/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include <SetCADModelParamters.h>
#include <iostream>
#include <string>
#include <StringToEnumConversions.h>
#include <ParametricParameters.h>
#include <map>


namespace isis
{

void ApplyParametricParameters( std::list<std::string>						&in_ComponentIDs, 
							   std::map<std::string, isis::CADComponentData>	&in_CADComponentData_map)
																		throw (isis::application_exception)
{
	for ( std::list<std::string>::const_iterator t = in_ComponentIDs.begin(); t != in_ComponentIDs.end(); ++t )
	{
		if ( in_CADComponentData_map[*t].parametricParametersPresent )
		{
			std::string ModelNameWithSuffix = AmalgamateModelNameWithSuffix ( 
													in_CADComponentData_map[*t].name, 
													in_CADComponentData_map[*t].modelType );

			for( std::list<CADParameter>::const_iterator  p( in_CADComponentData_map[*t].parametricParameters.begin());
			p != in_CADComponentData_map[*t].parametricParameters.end();
			++ p )
			{
				SetParametricParameter( ModelNameWithSuffix, 
										in_CADComponentData_map[*t].p_model,
					                    p->name, p->type, p->value);
			}
		}
	}

}
/***************
void ApplyParametricParameters(  
				const std::string	&in_model_name, 
				ProMdl				*in_p_model, 
				const AssemblyType::CADComponent_type::ParametricParameters_type &in_ParametricParameters )
									throw (isis::application_exception)
{

  	for ( AssemblyType::CADComponent_type::ParametricParameters_type::CADParameter_const_iterator k( in_ParametricParameters.CADParameter().begin());
				  k != in_ParametricParameters.CADParameter().end();
				  ++k )
	{		
		//****
		//std::cout << std::endl <<  "   CADParameter";
		//char temp_string[100];
		//std::cout << std::endl <<  "      Model Name     "  << in_model_name;	
		//std::cout << std::endl <<  "      Type           "  <<  k->Type();
		//std::cout << std::endl <<  "      Name           "	<<  k->Name();
		//std::cout << std::endl <<  "      Value          "	<<  k->Value();

		//if ( k->Units().present() )
		//{
		//	std::cout << std::endl <<  "	  Units.Value             " << k->Units().get().Value();     
		//}
		

		SetParametricParameter( in_model_name, in_p_model, k->Name(), k->Type(), k->Value());


	}  //for ...

}

**********************************************************/

} // end namespace isis