/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include <ToolKitPassThroughFunctions.h>
#include <CADCommonConstants.h>
#include <StringToEnumConversions.h>
#include <sstream>


namespace isis
{

	void isis_ProMdlRetrieve_WithDescriptiveErrorMsg( 
										   // Added Arguments
										  const std::string &in_ComponentID,
										  const std::string &in_Model_Name,
										  // Original arguments
										  ProFamilyName name, 
										  ProMdlType    type,
										  ProMdl       *p_handle)
										  throw (isis::application_exception)
	{

		try
		{
			isis::isis_ProMdlRetrieve(name,type, p_handle);	

		}
		catch ( isis::application_exception& ex )
		{
			//char modelName[ISIS_CHAR_BUFFER_LENGTH];
			//ProWstringToString(modelName, (char *)in_Model_Name.c_str());	

			std::stringstream errorString;
				errorString <<
						"Failed to open a Creo Model:"  << std::endl <<
						"   Model Name:        " << in_Model_Name << std::endl <<
						"   Model Type:        " << isis::ProMdlType_string(type) <<  std::endl <<
						"   Component ID:      " << in_ComponentID << std::endl <<
						"   Exception Message: " << ex.what();
			throw isis::application_exception(errorString.str().c_str());
		}

	}

	void isis_ProModelitemByNameInit_WithDescriptiveErrorMsg( 
										 // Added Arguments
										 const std::string &in_ComponentID,
										 const std::string &in_Model_Name,
										 ProMdlType     mdltype,
										 // Original arguments
										 ProMdl         mdl, 
                                         ProType        type, 
                                         ProName        name, 
                                         ProModelitem*  p_item ) throw(isis::application_exception)
	{

		try
		{
			isis::isis_ProModelitemByNameInit (mdl, type, name, p_item);

		}
		catch ( isis::application_exception& ex )
		{
			char featureName[ISIS_CHAR_BUFFER_LENGTH];
			ProWstringToString(featureName, name );	

			std::stringstream errorString;
				errorString <<
						"Could not find feature in Creo model:"  << std::endl <<
						"	Feature Name:      " << featureName <<  std::endl <<
						"   Model Name:        " << in_Model_Name << std::endl <<
						"   Model Type:        " << isis::ProMdlType_string(mdltype)<<  std::endl <<
						"   Component ID:      " << in_ComponentID << std::endl <<
						"   Exception Message: " << ex.what();
			throw isis::application_exception(errorString.str().c_str());
		}

	}


} // END namespace isis