/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef COORDINATE_SYSTEM_ROUTINES_H
#define COORDINATE_SYSTEM_ROUTINES_H

#include <isis_application_exception.h>
#include <isis_include_ptc_headers.h>
#include <string>
#include <vector>

namespace isis
{
	void CreateCoordinateSystem( ProMdl	in_p_model, 
								//ProMdlType in_pro_model_type,
								const ProCsys	   &referenceCoordinateSystem,
								const std::string &in_CoordinateSystemName,
								const std::vector<double> &in_Orgin,
								const std::vector<double> &in_XVector,
								const std::vector<double> &in_YVector ) throw(isis::application_exception);


	void FindDefaultCoordinateSystem( ProMdl in_p_model,
										  const std::string   &in_ModelName,
										  ProCsys &out_p_csys )
													throw(isis::application_exception);

	bool FoundProAxisBasedOnAxisName(	ProMdl				in_p_model,
										const std::string	&in_AxisName,	
										ProAxis				&out_p_axis)	throw(isis::application_exception);


} // END namespace isis

#endif