/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include <isis_ptc_toolkit_functions.h>
#include <CADCommonConstants.h>

extern "C" FILE* PTApplsUnicodeFopen(const char *filename, const char *mode);

namespace isis
{

	const int ERROR_STRING_BUFFER_LENGTH = 1024;

	void GetModelNameForErrorMessages( ProMdl     handle,
									   char       name_narrow[])
	{
		name_narrow[0] = '\0';
		// don't let this function throw an exception.
		try
		{
			ProName    name_wide;
			isis_ProMdlNameGet(handle, name_wide);
			ProWstringToString(name_narrow,name_wide);
		}
		catch (...)
		{
		}
	}


    ProError isis_ProEngineerStart(	char* proe_path,
									char* prodev_text_path )
									throw (isis::application_exception)
	{
		ProError err = ProEngineerStart( proe_path, prodev_text_path );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProEngineerStart returned ProError: %d, proe_path: %s,  prodev_text_path: %s", err, proe_path, prodev_text_path );
			throw isis::application_exception(err_str); 
		}

		return err;
	}


	ProError isis_ProMdlRetrieve( ProFamilyName name, 
								  ProMdlType    type,
								  ProMdl       *p_handle)
								  throw (isis::application_exception)
	{
		ProError err = ProMdlRetrieve( name, type, p_handle);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char name_narrow[ISIS_CHAR_BUFFER_LENGTH];
			ProWstringToString(name_narrow,name); 
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMdlRetrieve returned ProError: %d, Model Name: %s", err, ProWstringToString(name_narrow,name) );
			throw isis::application_exception(err_str); 
		}

		return err;

	}


	ProError isis_ProMdlDisplay( ProMdl    handle )
								  throw (isis::application_exception)
	{
		ProError err = ProMdlDisplay( handle);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMdlDisplay returned ProError: %d", err );
			throw isis::application_exception(err_str); 
		}

		return err;
	}

	ProError isis_ProMdlDelete( ProMdl    handle )
								  throw (isis::application_exception)
	{
		ProError err = ProMdlDelete( handle);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMdlDelete returned ProError: %d", err );
			throw isis::application_exception(err_str); 
		}

		return err;
	}


	ProError isis_ProMdlEraseNotDisplayed(  )
								  throw (isis::application_exception)
	{
		ProError err = ProMdlEraseNotDisplayed();

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMdlEraseNotDisplayed returned ProError: %d", err );
			throw isis::application_exception(err_str); 
		}

		return err;
	}


	extern ProError isis_ProSolidCreate  (	ProName     name, 
											ProType     type,
											ProSolid   *p_handle)
											throw (isis::application_exception)
	{
		ProError err = ProSolidCreate( name, type, p_handle);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProSolidCreate returned ProError: %d", err );
			throw isis::application_exception(err_str); 
		}

		return err;
	}




	ProError isis_ProEngineerEnd( void ) throw (isis::application_exception)
	{
		ProError err = ProEngineerEnd();

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProEngineerEnd returned ProError: %d", err );
			throw isis::application_exception(err_str); 
		}
		return err;
	}

	FILE *isis_PTApplsUnicodeFopen(const char *filename, const char *mode) throw(isis::application_exception)
	{
		FILE* fp = PTApplsUnicodeFopen( filename, mode);

		if ( fp == NULL ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "PTApplsUnicodeFopen returned Null" );
			throw isis::application_exception(err_str); 
		}
		
		return fp;
	}


	ProError isis_ProMdlDataGet( ProMdl handle, ProMdldata *p_data) throw(isis::application_exception)
	{
		ProError err = ProMdlDataGet( handle, p_data);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMdlDataGet returned ProError: %d", err );
			throw isis::application_exception(err_str); 
		}
		return err;
	}


	ProError isis_ProSolidFeatVisit ( ProSolid     p_handle, 
                                 ProFeatureVisitAction  visit_action,
                                 ProFeatureFilterAction  filter_action,
                                 ProAppData   app_data) throw(isis::application_exception)
	{

		ProError err = ProSolidFeatVisit ( p_handle, visit_action,filter_action,app_data  );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProSolidFeatVisit returned ProError: %d", err );
			throw isis::application_exception(err_str); 
		}
		return err;
	}

	ProError isis_ProAsmcompMdlGet ( ProAsmcomp *p_feat_handle,
									 ProMdl     *p_mdl_handle) throw(isis::application_exception)
	{

		ProError err = ProAsmcompMdlGet ( p_feat_handle, p_mdl_handle);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcompMdlGet returned ProError: %d", err );
			throw isis::application_exception(err_str); 
		}
		return err;
	}



	ProError isis_ProAsmcomppathMdlGet( ProAsmcomppath *p_path,
										ProMdl         *p_model) throw(isis::application_exception)
	{

		ProError err = ProAsmcomppathMdlGet ( p_path, p_model);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcomppathMdlGet returned ProError: %d", err );
			throw isis::application_exception(err_str); 
		}
		return err;
	}




	ProError isis_ProFeatureTypeGet  (ProFeature  *p_feat_handle, ProFeattype *p_type) throw(isis::application_exception)
	{
		ProError err = ProFeatureTypeGet ( p_feat_handle, p_type);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProFeatureTypeGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProAsmcompAssemble ( ProAssembly   owner_assembly,
				     ProSolid           component_model,
				     ProMatrix           init_pos,
				     ProAsmcomp *feature ) throw(isis::application_exception)
	{
		ProError err = ProAsmcompAssemble ( owner_assembly, component_model,init_pos, feature );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcompAssemble returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;

	}

	ProError isis_ProMdlSave  (ProMdl    handle) throw(isis::application_exception)
	{
		ProError err = ProMdlSave ( handle );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMdlSave returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;

	}


	ProError isis_ProMdlErase  (ProMdl    handle) throw(isis::application_exception)
	{
		ProError err = ProMdlErase ( handle );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMdlErase returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;

	}



	ProError isis_ProMdlfileCopy (	ProMdlType   mdl_type,
									ProName      from_name,
									ProName      to_name )
	{

		ProError err = ProMdlfileCopy (  mdl_type, from_name,  to_name);

		if ( err != PRO_TK_NO_ERROR ) 
		{

			char from_name_narrow[ISIS_CHAR_BUFFER_LENGTH];
			char to_name_narrow[ISIS_CHAR_BUFFER_LENGTH];
			ProWstringToString(from_name_narrow,from_name);
			ProWstringToString(to_name_narrow,to_name);
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMdlfileCopy returned ProError: %d, From Name: %s, To Name: %s", err, from_name_narrow, to_name_narrow );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProModelitemByNameInit ( ProMdl         mdl, 
                                         ProType        type, 
                                         ProName        name, 
                                         ProModelitem*  p_item ) throw(isis::application_exception)
	{
		ProError err = ProModelitemByNameInit ( mdl, type, name, p_item );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  model_name_narrow[PRO_NAME_SIZE];
			GetModelNameForErrorMessages( mdl, model_name_narrow );
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			char name_narrow[PRO_NAME_SIZE];
			ProWstringToString(name_narrow,name); 
			sprintf( err_str, "ProModelitemByNameInit returned ProError: %d, Model Name: %s, Feature Name: %s", err, model_name_narrow, ProWstringToString(name_narrow,name));
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProModelitemNameGet ( ProModelitem *p_item,
										ProName       name ) throw(isis::application_exception)
	{
		ProError err = ProModelitemNameGet ( p_item, name );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "isis_ProModelitemNameGet returned ProError: %d",err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProFeatureInit ( ProSolid     p_owner_handle, 
                                  int          feat_id, 
                                  ProFeature  *p_feat_handle ) throw(isis::application_exception)
	{
		ProError err = ProFeatureInit ( p_owner_handle, feat_id, p_feat_handle );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProFeatureInit returned ProError: %d, Feature ID: %d", err, feat_id);
			throw isis::application_exception(err_str);  
		}
		return err;

	}


	ProError isis_ProFeatureElemValueGet (	ProFeature    *feature,
											ProElempath    elempath,
											ProValue      *p_elemvalue ) throw(isis::application_exception)
	{
		ProError err = ProFeatureElemValueGet ( feature, elempath, p_elemvalue );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProFeatureElemValueGet returned ProError: %d, Feature ID: %d", err, feature->id );
			throw isis::application_exception(err_str);
		}
		return err;
	}

	ProError isis_ProElempathAlloc ( ProElempath *p_elem_path  ) throw(isis::application_exception)
	{
		ProError err = ProElempathAlloc ( p_elem_path );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProElempathAlloc returned ProError: %d", err);
			throw isis::application_exception(err_str);  
		}
		return err;

	}

	ProError isis_ProElempathDataSet ( ProElempath       elem_path,
                                     ProElempathItem  *elempath_data,
                                     int               path_size  ) throw(isis::application_exception)
	{
		ProError err = ProElempathDataSet ( elem_path, elempath_data, path_size );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProElempathDataSet returned ProError: %d", err);
			throw isis::application_exception(err_str);  
		}
		return err;

	}
	

	ProError isis_ProValueDataGet ( ProValue       value,
									ProValueData  *value_data ) throw(isis::application_exception)
	{
		ProError err = ProValueDataGet ( value, value_data );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProValueDataGet returned ProError: %d", err);
			throw isis::application_exception(err_str);  
		}
		return err;

	}


	ProError isis_ProElementArrayCount (ProElement    elemtree,
                                      ProElempath   elempath,
                                      int          *p_array_count) throw(isis::application_exception)
	{
		ProError err = ProElementArrayCount ( elemtree, elempath, p_array_count );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProElementArrayCount returned ProError: %d", err);
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProFeatureElemtreeExtract (	ProFeature *feature,
												ProAsmcomppath *path,
												ProFeatureElemtreeExtractOptions opts,
												ProElement *p_elem) throw(isis::application_exception)
	{
		ProError err = ProFeatureElemtreeExtract ( feature, path, opts, p_elem  );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProFeatureElemtreeExtract returned ProError: %d", err);
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProGeomitemFeatureGet (	ProGeomitem  *p_geom_item, 
											ProFeature   *p_feat_handle  ) throw(isis::application_exception)
	{
		ProError err = ProGeomitemFeatureGet ( p_geom_item, p_feat_handle );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProGeomitemFeatureGet returned ProError: %d, Feature ID: %d", err, p_geom_item->id);
			throw isis::application_exception(err_str);  
		}
		return err;

	}

	ProError isis_ProMdlCurrentGet ( ProMdl     *p_handle) throw(isis::application_exception)
	{
		ProError err = ProMdlCurrentGet ( p_handle );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "isis_ProMdlCurrentGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;

	}

	ProError isis_ProModelitemInit ( ProMdl         p_owner_handle, 
									 int            item_id, 
									 ProType        item_type, 
									 ProModelitem  *p_handle) throw(isis::application_exception)
	{
		ProError err = ProModelitemInit ( p_owner_handle, item_id, item_type, p_handle );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProModelitemInit returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;

	}


	ProError isis_ProMdlToModelitem (	ProMdl mdl, 
										ProModelitem* p_model_item ) throw(isis::application_exception)
	{
		ProError err = ProMdlToModelitem ( mdl, p_model_item );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMdlToModelitem returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProArrayAlloc ( int n_objs,
                                  int obj_size,
                                  int reallocation_size,
                                  ProArray* p_array) throw(isis::application_exception)
	{
		ProError err = ProArrayAlloc ( n_objs, obj_size, reallocation_size, p_array );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProArrayAlloc returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProArrayFree( ProArray* p_array) throw(isis::application_exception)
	{
		ProError err = ProArrayFree( p_array );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProArrayFreereturned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProArraySizeGet( ProArray in_array,
									int*     p_size) throw(isis::application_exception)
	{
		ProError err = ProArraySizeGet( in_array, p_size );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProArraySizeGetreturned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProAsmcomppathInit (	ProSolid       p_solid_handle,
										ProIdTable     memb_id_tab,
										int            table_size,
										ProAsmcomppath *p_handle) throw(isis::application_exception)
	{
		ProError err = ProAsmcomppathInit ( p_solid_handle, memb_id_tab, table_size, p_handle );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcomppathInit returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProSelectionAlloc (	ProAsmcomppath *p_cmp_path,
										ProModelitem *p_mdl_itm,
										ProSelection *p_selection) throw(isis::application_exception)
	{
		ProError err = ProSelectionAlloc ( p_cmp_path, p_mdl_itm, p_selection );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProSelectionAlloc returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProFeatureCreate (	ProSelection     model,
										ProElement       elemtree,
										ProFeatureCreateOptions options[],
										int              num_opts,
										ProFeature      *p_feature,
										ProErrorlist    *p_errors ) throw(isis::application_exception)
	{
		ProError err = ProFeatureCreate ( model, elemtree, options, num_opts, p_feature,  p_errors );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProFeatureCreate returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProSelectionFree ( ProSelection *p_selection) 
											throw(isis::application_exception)
	{
		ProError err = ProSelectionFree (p_selection );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProSelectionFree returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProAsmcompconstraintAlloc (	ProAsmcompconstraint *p_constraint) throw(isis::application_exception)
	{
		ProError err = ProAsmcompconstraintAlloc ( p_constraint);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcompconstraintAlloc returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProAsmcompconstraintFree (	ProAsmcompconstraint constraint ) throw(isis::application_exception)
	{
		ProError err = ProAsmcompconstraintFree ( constraint);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcompconstraintFree returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProAsmcompconstraintTypeSet (	ProAsmcompconstraint constraint,
												ProAsmcompConstrType type) throw(isis::application_exception)
	{
		ProError err = ProAsmcompconstraintTypeSet ( constraint, type);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcompconstraintTypeSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProAsmcompconstraintAsmreferenceSet (	ProAsmcompconstraint constraint,
													ProSelection asm_ref,
													ProDatumside asm_orient) throw(isis::application_exception)
	{
		ProError err = ProAsmcompconstraintAsmreferenceSet ( constraint, asm_ref, asm_orient );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcompconstraintAsmreferenceSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	

	ProError isis_ProAsmcompconstraintCompreferenceSet (	ProAsmcompconstraint constraint,
													ProSelection comp_ref,
													ProDatumside comp_orient) throw(isis::application_exception)
	{
		ProError err = ProAsmcompconstraintCompreferenceSet ( constraint, comp_ref, comp_orient );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcompconstraintCompreferenceSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProAsmcompRegenerate (	ProAsmcomp *p_comp_handle,
											ProBoolean  update_soft) 
														throw(isis::application_exception)
	{
		ProError err = ProAsmcompRegenerate ( p_comp_handle, update_soft );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcompRegenerate returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProArrayObjectAdd (	ProArray* p_array,
										int       index,
										int       n_objects,
										void*     p_object) throw(isis::application_exception)
	{
		ProError err = ProArrayObjectAdd ( p_array, index, n_objects, p_object );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProArrayObjectAdd returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}



	ProError isis_ProAsmcompConstraintsSet(	ProAsmcomppath* component_path, 
											ProAsmcomp *component,
											ProAsmcompconstraint *p_constraints ) throw(isis::application_exception)
	{
		ProError err = ProAsmcompConstraintsSet ( component_path, component, p_constraints );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcompConstraintsSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProSolidRegenerate(	ProSolid    p_handle,
                                                  int  flags ) throw(isis::application_exception)
	{
		ProError err = ProSolidRegenerate ( p_handle, flags );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProSolidRegenerate returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProSolidRegenerationstatusGet( ProSolid                    solid,
												 ProSolidRegenerationStatus* regen_status ) 
																throw(isis::application_exception)
	{
		ProError err = ProSolidRegenerationstatusGet ( solid, regen_status );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProSolidRegenerationstatusGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProAsmcompconstraintOffsetSet(	ProAsmcompconstraint constraint,
													double offset) throw(isis::application_exception)
	{
		ProError err = ProAsmcompconstraintOffsetSet ( constraint, offset );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcompconstraintOffsetSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProUnitsystemTypeGet( ProUnitsystem*     system,
                                        ProUnitsystemType* type)
												throw(isis::application_exception)
	{

		ProError err = ProUnitsystemTypeGet ( system,
											  type );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProUnitsystemTypeGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProMdlPrincipalunitsystemSet( ProMdl             mdl,
												ProUnitsystem*     new_system,
												ProUnitConvertType type,
												ProBoolean         ignore_param_units,
												int                regeneration_flags)
												throw(isis::application_exception)
	{

		ProError err = ProMdlPrincipalunitsystemSet (	mdl,
														new_system,
														type,
														ignore_param_units,
														regeneration_flags);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMdlPrincipalunitsystemSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProElementAlloc ( ProElemId name_id,
									ProElement *p_elem)
												throw(isis::application_exception)
	{

		ProError err = ProElementAlloc  ( name_id,
										  p_elem );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProElementAlloc  returned ProError: %d, ProElemId name_id: %d", err, name_id );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProElementValueSet (	ProElement  elem,
										ProValue    value)
												throw(isis::application_exception)
	{

		ProError err = ProElementValueSet  ( elem,
											value );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProElementValueSet  returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProElementIntegerSet(	ProElement element, int value)
												throw(isis::application_exception)
	{

		ProError err = ProElementIntegerSet ( element, value );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProElementIntegerSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}



	ProError isis_ProElementReferencesSet(	ProElement    element,
											ProReference* references)
												throw(isis::application_exception)
	{

		ProError err = ProElementReferencesSet ( element, references );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProElementReferencesSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProElemtreeElementAdd( ProElement     elemtree,
                                         ProElempath    elempath,
                                         ProElement     elem )
												throw(isis::application_exception)
	{

		ProError err = ProElemtreeElementAdd ( elemtree, elempath, elem );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProElemtreeElementAdd returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProValueAlloc( ProValue *p_value )
										throw(isis::application_exception)
	{

		ProError err = ProValueAlloc ( p_value );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProValueAlloc returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProValueFree( ProValue value )
										throw(isis::application_exception)
	{

		ProError err = ProValueFree ( value );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProValueFree returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProValueDataSet(	ProValue       value,
									ProValueData  *value_data )
										throw(isis::application_exception)
	{

		ProError err = ProValueDataSet ( value, value_data );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProValueDataSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}



	ProError isis_ProParameterInit(	ProModelitem *owner,
									ProName       name, 
									ProParameter *param )
											throw(isis::application_exception)
	{

		ProError err = ProParameterInit ( owner, name, param );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char name_narrow[ISIS_CHAR_BUFFER_LENGTH];
			ProWstringToString(name_narrow,name); 
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProParameterInit returned ProError: %d, Parameter Name: %s", err, ProWstringToString(name_narrow,name) );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProParameterValueSet(	ProParameter   *param, 
										ProParamvalue  *proval )
											throw(isis::application_exception)
	{

		ProError err = ProParameterValueSet ( param, proval );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProParameterValueSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProParameterCreate(	ProModelitem  *owner, 
										ProName        name, 
										ProParamvalue *proval, 
										ProParameter  *param )
											throw(isis::application_exception)
	{
		ProError err = ProParameterCreate ( owner, name, proval, param );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProParameterCreate returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProParameterValueGet(	ProParameter   *param, 
                                      ProParamvalue  *proval )
											throw(isis::application_exception)
	{

		ProError err = ProParameterValueGet ( param, proval );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProParameterValueGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


  	ProError isis_ProParameterScaledvalueSet(ProParameter   *param, 
                                            ProParamvalue  *proval,
                                            ProUnititem    *units)
										throw(isis::application_exception)
	{

		ProError err = ProParameterScaledvalueSet ( param, proval, units );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProParameterScaledvalueSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

//ProSolidMassPropertyGet
//	ProUnitConversionGet
  	ProError isis_ProUnitInit(	ProMdl        mdl,
								ProName       unit_name,
								ProUnititem*  unit)
										throw(isis::application_exception)
	{

		ProError err = ProUnitInit ( mdl, unit_name, unit );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProUnitInit returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProMacroLoad(	wchar_t* macro )
										throw(isis::application_exception)
	{

		ProError err = ProMacroLoad ( macro );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMacroLoad returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}



	ProError isis_ProSolidMassPropertyGet(ProSolid solid,
                                          ProName  csys_name,
                                          ProMassProperty* mass_prop )
										throw(isis::application_exception)
	{

		ProError err = ProSolidMassPropertyGet ( solid, csys_name, mass_prop );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProSolidMassPropertyGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}



	ProError isis_ProDirectoryChange( ProPath path )
										throw(isis::application_exception)
	{

		ProError err = ProDirectoryChange ( path );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProDirectoryChange returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProAsmcomppathTrfGet( ProAsmcomppath *p_path,
										ProBoolean   bottom_up,
										ProMatrix    transformation )
											throw(isis::application_exception)
	{

		ProError err = ProAsmcomppathTrfGet ( p_path, bottom_up, transformation );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcomppathTrfGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  

		}
		return err;
	}

	//// New 8/25/2010
	ProError isis_ProMdlPrincipalunitsystemGet( ProMdl          mdl,
												ProUnitsystem* principal_system)
											throw(isis::application_exception)
	{

		ProError err = ProMdlPrincipalunitsystemGet ( mdl, principal_system);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMdlPrincipalunitsystemGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  

		}
		return err;
	}
	
	ProError isis_ProUnitsystemUnitGet( ProUnitsystem* system,
                                      ProUnitType     type,
                                      ProUnititem*   unit )
											throw(isis::application_exception)
	{

		ProError err = ProUnitsystemUnitGet ( system, type, unit );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProUnitsystemUnitGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
			
		}
		return err;
	}

	ProError isis_ProWstringCopy( wchar_t* source, wchar_t* target, int num_chars )
											throw(isis::application_exception)
	{

		ProError err = ProWstringCopy ( source, target, num_chars );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProWstringCopy returned ProError: %d", err );
			throw isis::application_exception(err_str);  
			
			
		}
		return err;
	}

	ProError isis_ProElementWstringSet( ProElement element, wchar_t* value)
													throw(isis::application_exception)
	{
		ProError err = ProElementWstringSet ( element, value );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProElementWstringSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
			
			
		}
		return err;
	}



	ProError isis_ProMaterialCreate(	ProSolid			part,
										ProName				matl_name,
										ProMaterialdata		*p_matl_data,
										ProMaterial			*p_material )
											throw(isis::application_exception)
	{
		ProError err = ProMaterialCreate ( part, matl_name, p_matl_data, p_material  );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMaterialCreate returned ProError: %d", err );
			throw isis::application_exception(err_str);  					
		}
		return err;
	}


	ProError isis_ProMaterialDelete( ProMaterial      *p_material )
											throw(isis::application_exception)
	{
		ProError err = ProMaterialDelete ( p_material  );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMaterialDelete returned ProError: %d", err );
			throw isis::application_exception(err_str);  					
		}
		return err;
	}


	ProError isis_ProMaterialCurrentGet( ProSolid part,  ProMaterial  *p_material )
											throw(isis::application_exception)
	{
		ProError err = ProMaterialCurrentGet ( part, p_material );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMaterialCurrentGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProMaterialCurrentSet( ProMaterial  *p_material )
											throw(isis::application_exception)
	{
		ProError err = ProMaterialCurrentSet ( p_material );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMaterialCurrentSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  	
		}
		return err;
	}


	ProError isis_ProPartMaterialsGet(	ProSolid         part,
										ProName      **p_matl_names_arr )
											throw(isis::application_exception)
	{
		ProError err = ProPartMaterialsGet ( part, p_matl_names_arr );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProPartMaterialsGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProMaterialPropertyGet(	ProMaterialItem *p_material,
											ProMaterialPropertyType prop_type,
											ProParamvalue    *p_value,
											ProUnititem      *p_units)
											throw(isis::application_exception)
	{
		ProError err = ProMaterialPropertyGet ( p_material, prop_type, p_value, p_units );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMaterialPropertyGet returned ProError: %d, ProMaterialPropertyType %d: ", err, prop_type );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProMaterialPropertySet(	ProMaterialItem *p_material,
											ProMaterialPropertyType prop_type,
											ProParamvalue    *p_value,
											ProUnititem      *p_units)
											throw(isis::application_exception)
	{
		ProError err = ProMaterialPropertySet ( p_material, prop_type, p_value, p_units );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMaterialPropertySet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProFemmeshExport( ProSolid			pro_solid,
                                    ProFemmeshData*		p_mesh_data,
                                    ProPath				file_name   )
											throw(isis::application_exception)
	{

		ProError err = ProFemmeshExport ( pro_solid, p_mesh_data, file_name );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProFemmeshExport returned ProError: %d", err );
			throw isis::application_exception(err_str);  
			
		}
		return err;
	}


	ProError isis_ProPointInit( ProSolid   owner_handle,
								int        point_id,
								ProPoint  *p_handle )
											throw(isis::application_exception)
	{

		ProError err = ProPointInit ( owner_handle, point_id,  p_handle);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProPointInit returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProPointCoordGet( ProPoint    point,
									ProVector   xyz_point   )
											throw(isis::application_exception)
	{

		ProError err = ProPointCoordGet ( point, xyz_point );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProPointCoordGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProPntTrfEval(	ProVector   in_point,
									ProMatrix   trf,
									ProVector   out_point  )
											throw(isis::application_exception)
	{

		ProError err = ProPntTrfEval ( in_point, trf, out_point );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProPntTrfEval returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProOutputFileWrite(	 ProMdl      model,
                                     ProFileName name,
                                     ProImportExportFile   file_type,
                                     ProAppData  arg1,
                                     ProAppData  arg2,
                                     ProAppData  arg3,
                                     ProAppData  arg4 )
											throw(isis::application_exception)
	{

		ProError err = ProOutputFileWrite (  model,
											 name,
											 file_type,
											 arg1,
											 arg2,
											 arg3,
											 arg4 );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProOutputFileWrite returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProConfigoptSet(	ProName option,
                                    ProPath option_value  )
											throw(isis::application_exception)
	{

		ProError err = ProConfigoptSet ( option, option_value );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProConfigoptSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}



	ProError isis_ProRasterFileWrite( int            window_id,
                                      ProRasterDepth depth,
                                      double         width,
                                      double         height,
                                      ProDotsPerInch dots_per_inch,
                                      ProRasterType  type,
                                      ProPath        output_file )
											throw(isis::application_exception)
	{

		ProError err = ProRasterFileWrite ( window_id,
                                            depth,
                                            width,
                                            height,
                                            dots_per_inch,
                                            type,
                                            output_file );


		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProRasterFileWrite returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProWindowCurrentGet( int* p_window_id )
											throw(isis::application_exception)
	{

		ProError err = ProWindowCurrentGet ( p_window_id );


		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProWindowCurrentGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProSolidOutlineGet( ProSolid  p_solid,
										Pro3dPnt  r_outline_points[2])
											throw(isis::application_exception)
	{
		ProError err = ProSolidOutlineGet ( p_solid,
											r_outline_points );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProSolidOutlineGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProAsmcompPositionSet(	ProAsmcomppath* component_path,
											ProAsmcomp*     component,
											ProMatrix      position )
											throw(isis::application_exception)
	{
		ProError err = ProAsmcompPositionSet (	component_path,
												component,
												position);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAsmcompPositionSet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProFeatureDelete(	ProSolid    solid,
									int        *feat_ids,
									int         feat_count,
									ProFeatureDeleteOptions *delete_opts,
									int         num_opts)
											throw(isis::application_exception)
	{
		ProError err = ProFeatureDelete (	solid,
											feat_ids,
											feat_count,
											delete_opts,
											num_opts);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProFeatureDelete returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProFeatureWithoptionsDelete(	
									ProSolid                 solid,
                                    int                     *feat_list,
                                    ProFeatureDeleteOptions *opts,
                                    int                      flags)
											throw(isis::application_exception)
	{
		ProError err = ProFeatureWithoptionsDelete (	solid,
														feat_list,
														opts,
														flags );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProFeatureWithoptionsDelete returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProMdlNameGet(ProMdl     handle, 
                                ProName    name)
											throw(isis::application_exception)
	{
		ProError err = ProMdlNameGet (	handle, name );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMdlNameGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProElementFree(ProElement     *p_elem )
											throw(isis::application_exception)
	{
		ProError err = ProElementFree (	p_elem );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProElementFree returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProDtmcsysTransformfileRead( wchar_t* file_name, ProElement elem_tree )
											               throw(isis::application_exception)
	{
		ProError err = ProDtmcsysTransformfileRead ( file_name, elem_tree );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProDtmcsysTransformfileRead returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProSelect( char              option[],
			   int               max_count,
			   ProSelection     *p_in_sel,
			   ProSelFunctions  *sel_func,
			   ProSelectionEnv   sel_env,
			   ProSelAppAction   appl_act_data,
			   ProSelection    **p_sel_array,
			   int              *p_n_sels  )
											   throw(isis::application_exception)
	{
		ProError err = ProSelect (  option,
									max_count,
									p_in_sel,
									sel_func,
									sel_env,
									appl_act_data,
									p_sel_array,
									p_n_sels  );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProSelect returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProCsysIdGet( ProCsys csys, int *p_id )
											               throw(isis::application_exception)
	{
		ProError err = ProCsysIdGet ( csys, p_id );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProCsysIdGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	ProError isis_ProAxisIdGet( ProAxis  axis, int *p_id ) throw(isis::application_exception)
	{
		ProError err = ProAxisIdGet ( axis, p_id );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProAxisIdGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}



	ProError isis_ProIntfimportModelWithOptionsCreate( ProPath  import_file, 
                                                      ProPath  profile, 
                                                      ProIntfImportType type, 
                                                      ProMdlType create_type, 
                                                      ProImportRepType rep_type, 
                                                      ProName  new_model_name, 
                                                      ProIntfimportLayerFilter filter_func, 
                                                      ProAppData application_data, 
                                                      ProMdl* created_model ) throw(isis::application_exception)
	{
		ProError err = ProIntfimportModelWithOptionsCreate ( import_file,
															 profile,
															 type,
															 create_type,
															 rep_type,
															 new_model_name,
															 filter_func,
															 application_data,
															 created_model);

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProIntfimportModelWithOptionsCreate returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}

	/*
	ProMech* functions require a special Mechanica license
	ProError isis_ProMechanicaEnter(	ProSolid         solid,
										ProMechanicaMode mode,
										ProBool          fem )
										throw(isis::application_exception)
	{

		ProError err = ProMechanicaEnter ( solid, mode, fem );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMechanicaEnter returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}


	ProError isis_ProMechgeomrefPathGet(	ProMechGeomref entity,
											ProAsmcomppath* path)
										throw(isis::application_exception)
	{

		ProError err = ProMechgeomrefPathGet ( entity, path );

		if ( err != PRO_TK_NO_ERROR ) 
		{
			char  err_str[ERROR_STRING_BUFFER_LENGTH];
			sprintf( err_str, "ProMechgeomrefPathGet returned ProError: %d", err );
			throw isis::application_exception(err_str);  
		}
		return err;
	}
	
*/
}
