/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// Test.cpp : Defines the entry point for the console application.
//

#include <stdio.h>
#include <iostream>
#include <string>
#include <vector>
#include <io.h>     // For access().
#include <sys/types.h>  // For stat().
#include <sys/stat.h>   // For stat().

#include "../CADCommonFunctions/Nastran.h"
#include "DeckConverter.h"

bool DirectoryExists( const char* absolutePath ){

    if( _access( absolutePath, 0 ) == 0 ){

        struct stat status;
        stat( absolutePath, &status );

        return (status.st_mode & S_IFDIR) != 0;
    }
    return false;
}

int main(int argc, char* argv[])
{
	if (argc < 4)
	{
		std::cout << "-i <Nastran Input Deck File>   -o <Output Directory>" << std::endl;
		return 0;
	}

	try
	{
		std::string nasFile;
		std::string abaqusFile;
		for (int i = 1; i < argc; i++)
		{
			std::string anArg = argv[i];

			if (anArg == "-i")
			{
				nasFile = argv[i+1];
			}
			if (anArg == "-o")
			{
				abaqusFile = argv[i+1];
			}

		}
		
		std::string::size_type pos = nasFile.find(".nas");
		if (pos == std::string::npos)
			std::cout << "Incorrect File Name: " << nasFile << std::endl;
		else
		{
			if (!DirectoryExists(abaqusFile.c_str()))
				std::cout << "Error: Must specify an output directory!" << std::endl;

			isis_CADCommon::NastranDeck nasDeck;
			nasDeck.ReadNastranDeck(nasFile.c_str());
			isis_CADCommon::CommonNastranDS commonDS(nasFile.substr(0, pos));
			nasDeck.CreateCommonNastranDS(commonDS );
			//isis::CalculixConverter converter;
			//converter.ConvertNastranDeck(commonDS, abaqusFile);

			isis::ElmerConverter converter;
			converter.ConvertNastranDeck(commonDS, abaqusFile);
		}
	}
	catch(isis::application_exception& e)
	{
		std::cout << "ISIS Application Exception: " << e.what() << std::endl;
	}

	return 0;
}

