from odbAccess import *
from sys import argv,exit
from abaqus import *
from abaqusConstants import *
import visualization


def rightTrim(input,suffix):
    fileName = None
    pos = input.find(suffix)
    if (pos == -1):
        fileName = input
        input = input + suffix
    else:
        fileName = input[0:pos]
    return input,fileName

# this function saves PNG file of viewport
def CreateViewportPNG(odbName, pngfileName):
    try:
        myViewport=session.Viewport(name='Contour Plot', origin=(0, 0), width=200, height=100)
        myOdb = visualization.openOdb(path=odbName)
        myViewport.setValues(displayedObject=myOdb)

        mySteps = myOdb.steps
        numSteps = len(mySteps)
        

        session.printOptions.setValues(rendition=COLOR,
                                       vpDecorations=OFF, vpBackground=OFF)
        
        for i in range(numSteps):
            stepKey = mySteps.keys()[i]
            step = mySteps[stepKey]
            numFrames = len(step.frames)

            fileName=pngfileName.replace(' ','') + "_"

            myViewport.odbDisplay.display.setValues(plotState=(CONTOURS_ON_DEF))
            session.viewports['Contour Plot'].makeCurrent()
            session.viewports['Contour Plot'].maximize()            
            session.writeVrmlFile(fileName+"DEF", False, (myViewport,))
            session.write3DXMLFile(fileName+"DEF", False, (myViewport,))

            myViewport.odbDisplay.display.setValues(plotState=(CONTOURS_ON_UNDEF))
            session.viewports['Contour Plot'].makeCurrent()
            session.viewports['Contour Plot'].maximize()            
            session.writeVrmlFile(fileName+"UNDEF", False, (myViewport,))
            session.write3DXMLFile(fileName+"UNDEF", False, (myViewport,))
            
           
            #get displacement data
            displacement = step.frames[-1].fieldOutputs['U']
            myViewport.odbDisplay.setPrimaryVariable(field=displacement,
                                                     outputPosition=NODAL,
                                                     refinement=(INVARIANT, 'Magnitude'))                   
            myViewport.odbDisplay.contourOptions.setValues(numIntervals=10)
            myViewport.odbDisplay.display.setValues(plotState=(CONTOURS_ON_DEF))
            myViewport.view.setValues(session.views['Iso'])
            myViewport.view.zoom(0.8)
            session.printToFile(fileName+"Displacement_DEF", PNG, (myViewport,))

            #get stress data
            stress = step.frames[-1].fieldOutputs['S']
            myViewport.odbDisplay.setPrimaryVariable(field=stress,
                                                     outputPosition=INTEGRATION_POINT,
                                                     refinement=(INVARIANT, 'Mises'))
            myViewport.odbDisplay.contourOptions.setValues(numIntervals=10)
            myViewport.odbDisplay.display.setValues(plotState=(CONTOURS_ON_UNDEF))


            myViewport.view.setValues(session.views['Iso'])
            myViewport.view.zoom(0.8)
            session.printToFile(fileName+"Iso_UNDEF", PNG, (myViewport,))

            myViewport.view.setValues(session.views['Left'])
            myViewport.view.zoom(0.8)
            session.printToFile(fileName+"Left_UNDEF", PNG, (myViewport,))

            myViewport.view.setValues(session.views['Right'])
            myViewport.view.zoom(0.8)
            session.printToFile(fileName+"Right_UNDEF", PNG, (myViewport,))

            myViewport.view.setValues(session.views['Back'])
            myViewport.view.zoom(0.8)
            session.printToFile(fileName+"Back_UNDEF", PNG, (myViewport,))

            myViewport.view.setValues(session.views['Front'])
            myViewport.view.zoom(0.8)
            session.printToFile(fileName+"Front_UNDEF", PNG, (myViewport,))

            myViewport.view.setValues(session.views['Top'])
            myViewport.view.zoom(0.7)
            session.printToFile(fileName+"Top_UNDEF", PNG, (myViewport,))         

            myViewport.view.setValues(session.views['Bottom'])
            myViewport.view.zoom(0.7)
            session.printToFile(fileName+"Bottom_UNDEF", PNG, (myViewport,))
            
            
    except KeyError:
        print 'An assembly level file named %s does' \
              'not exist in the output database %s' \
              % (fileName, odbName)
        odb.close()
        exit(0)
    except (AbaqusException), value:
        print 'Error:', value
        odb.close()
        exit(0)



if __name__ == '__main__': 
    odbName = None
    pngfileName = None
    argList = argv
    argc = len(argList)
    i=0
    while (i < argc):
        if (argList[i][:2] == "-o"):
            i += 1
            name = argList[i]
            odbName,pngfileName = rightTrim(name,".odb")
            print(odbName)
        elif (argList[i][:2] == "-h"):            
            print __doc__
            exit(0)
        i += 1
    if not (odbName):
        print ' **ERROR** output database name is not provided'
        print __doc__
        exit(1)
    CreateViewportPNG(odbName,pngfileName)