#AnalysisFunctions.py

import math

def FindDisplacementMagnitude (x, y, z):
    return math.sqrt(math.fsum([pow(x, 2), pow(y, 2), pow(z, 2)]))

def FindStressMetrics (matrix):
    #print 'FindStressMetrics()'
    #print matrix
    #in_StressTensor
    #	Sxx	Sxy	Sxz
    #	S	Syy	Syz
    #	S	S	Szz
    xx = float(matrix[0])
    xy = float(matrix[3])
    xz = float(matrix[4])
    yy = float(matrix[1])
    yz = float(matrix[5])
    zz = float(matrix[2])

    out_VonMises = math.sqrt( .5 *
          (
              math.pow( xx - yy, 2) +
              math.pow( yy - zz, 2) +
              math.pow( zz - xx,2) +
              6.0 * (	math.pow( xy, 2) +
                        math.pow( yz, 2) +
                        math.pow( xz, 2)
                    )
            )
          )

        #stress invariants
    I1 = xx + yy + zz
    I2 = xx * yy + yy * zz + zz * xx - math.pow( xy, 2) - math.pow( yz, 2) - math.pow( xz, 2)
    I3 = xx * yy * zz - xx * math.pow( yz, 2) - yy * math.pow( xz, 2) - zz * math.pow( xy, 2) + 2 * xy * yz * xz

    phi = math.acos ( ( 2 * math.pow(I1,3) - 9 * I1 * I2 + 27 * I3 ) / ( 2 * math.pow((math.pow(I1,2) - 3 * I2 ), 3.0/2.0) ) ) /3.0

    hypotenuse = 2.0/3.0 * math.sqrt( math.pow(I1,2) - 3 * I2)
    PStress_1 = hypotenuse * math.cos(phi) + I1/3
    PStress_2 = hypotenuse * math.cos(phi + 2 * math.pi / 3 ) + I1/3
    PStress_3 = hypotenuse * math.cos(phi + 4 * math.pi / 3 ) + I1/3

    #print 'Phi:%f Hypothenuse:%f PS1:%f PS2:%f PS3:%f' % (phi, hypotenuse, PStress_1, PStress_2, PStress_3)

    sortedStress_vector = [PStress_1, PStress_2, PStress_3]
    sortedStress_vector.sort()
    #print sortedStress_vector
    
    out_Shear = .5 * abs( sortedStress_vector[2] - sortedStress_vector[0])
    out_Bearing = 0
    
    if ( sortedStress_vector[0] < 0 ):
        out_Bearing = abs( sortedStress_vector[0] )

    return out_VonMises, out_Bearing, out_Shear


def Test():
    # sxx,syy,szz,sxy,sxz,syz
    stress_matrix = [-2, 10, -5, 7, -3, 5]

    mise, bearing, shear = FindStressMetrics(stress_matrix)
    print 'Mises:%f  Bearing:%f  Shear:%f' %(mise, bearing, shear)


if __name__ == '__main__':
    Test()