/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
//################################################################################################
//
// Port bitmap part decorator class (decorator part)
//	PortBitmapPart.h
//
//################################################################################################

#ifndef __NPORTBITMAPPART_H_
#define __NPORTBITMAPPART_H_


#include "StdAfx.h"
#include "TypeableBitmapPart.h"
using namespace DecoratorSDK;

namespace Decor {

//################################################################################################
//
// CLASS : PortBitmapPart
//
//################################################################################################

class PortBitmapPart: public TypeableBitmapPart
{
protected:
	CPoint					m_ptInner;
	_bstr_t m_icon;

public:
	PortBitmapPart(PartBase* pPart, CComPtr<IMgaCommonDecoratorEvents>& eventSink, const CPoint& ptInner, _bstr_t icon);
	virtual ~PortBitmapPart();

// =============== resembles IMgaElementDecorator
public:
	virtual CSize	GetPreferredSize			(void) const;
	virtual void	InitializeEx				(CComPtr<IMgaProject>& pProject, CComPtr<IMgaMetaPart>& pPart,
												 CComPtr<IMgaFCO>& pFCO, HWND parentWnd, PreferenceMap& preferences);

	virtual void	DrawBackground				(CDC* pDC, Gdiplus::Graphics* gdip);

	virtual CPoint	GetInnerPosition			(void) const { return m_ptInner; };
};

}; // namespace Decor

#endif //__PORTBITMAPPART_H_
