/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AVM.DDP
{
    public class MetaTestBench
    {
        public abstract class ValueWithUnit
        {
            public string Name { get; set; }
            public string Unit { get; set; }
            public string Value { get; set; }
        }

        public class Parameter : ValueWithUnit
        {
        }

        public class Metric : ValueWithUnit
        {
            public Requirement Requirement { get; set; }
        }

        public class Requirement
        {
            public string Name { get; set; }
            public string SourceRepository { get; set; }
            public string ID { get; set; }
            public string Text { get; set; }
        }

        public string Name { get; set; }

        public List<Metric> Metrics { get; set; }
        public List<Parameter> Parameters { get; set; }
        public List<Requirement> Requirements { get; set; }

        public MetaTestBench()
        {
            Metrics = new List<Metric>();
            Parameters = new List<Parameter>();
            Requirements = new List<Requirement>();
        }
    }
}
