/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Concurrent;
using System.IO;
using System.Diagnostics;
using System.Linq;

namespace ComponentAuthoringAssistant.Framework
{
    public static class Temp
    {
        private static ConcurrentBag<FileSystemInfo> _tempDirs = new ConcurrentBag<FileSystemInfo>();

        public static void DeleteTempDirectories()
        {
            foreach (var tempDir in _tempDirs.OfType<DirectoryInfo>())
            {
                try
                {
                    tempDir.Delete(true);
                }
                catch (Exception)
                {
                    Debug.WriteLine("Delete failed: {0}", tempDir);
                }
            }

            foreach (var tempFile in _tempDirs.OfType<FileInfo>())
            {
                try
                {
                    tempFile.Delete();
                }
                catch (Exception)
                {
                    Debug.WriteLine("Delete failed: {0}", tempFile);
                }
            }
        }

        public static void AddTempDir(DirectoryInfo di)
        {
            if (di.Exists)
                _tempDirs.Add(di);
        }

        public static void AddTempFile(FileInfo fi)
        {
            if (fi.Exists)
                _tempDirs.Add(fi);
        }

        public static void ResetTempDirs()
        {
            _tempDirs = new ConcurrentBag<FileSystemInfo>();
        }
    }
}