/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using Common.Command;
using Common.Notification;
using AVM.META;
using AVM.iFAB;

namespace ComponentAuthoringAssistant.Models
{
    public class ArtifactDescriptor : NotifyBase
    {

        public object OriginalModel { get; private set; }


        public string FileFormat
        {
            get
            {
                if (OriginalModel is CADModel)
                {
                    var m = (CADModel) OriginalModel;
                    return m.FileFormat;
                }
                return string.Empty;
            }
        }


        public bool IsFileFormatVisible
        {
            get
            {
                return !string.IsNullOrEmpty(FileFormat);
            }
            
        }

        public bool HasArtifactChanged
        {
            get { return HasArtifactLocationChanged || HasArtifactTypeChanged; }
        }

        private bool _hasArtifactLocationChanged;
        public bool HasArtifactLocationChanged
        {
            get { return _hasArtifactLocationChanged; }
            set
            {
                _hasArtifactLocationChanged = value;
                OnPropertyChanged(() => HasArtifactLocationChanged);
                OnPropertyChanged(() => HasArtifactChanged);
            }
        }

        private bool _hasArtifactTypeChanged;
        public bool HasArtifactTypeChanged
        {
            get { return _hasArtifactTypeChanged; }
            set
            {
                _hasArtifactTypeChanged = value;
                OnPropertyChanged(() => HasArtifactTypeChanged);
                OnPropertyChanged(() => HasArtifactChanged);
            }
        }

        private bool _editLocation;
        public bool EditLocation
        {
            get { return _editLocation; }
            set
            {
                _editLocation = value;
                OnPropertyChanged(() => EditLocation);
            }
        }

        
        //public Visibility ChangetypeVisibility
        //{
        //    get { return ArtifactType==ArtifactTypes.GenericFile?Visibility.Visible:Visibility.Hidden; }
        //}


        private string _type;
        public string Type
        {
            get { return _type; }
            set
            {
                _type = value;
                OnPropertyChanged(() => Type);
            }
        }

        private string _name;
        public string Name
        {
            get { return _name; }
            set
            {
                _name = value;
                OnPropertyChanged(() => Name);
            }
        }

        private string _editedName;
        public string EditedName
        {
            get { return _editedName; }
            set
            {
                _editedName = value;
                OnPropertyChanged(() => EditedName);
            }
        }

        private ArtifactStatus _artifactStatus;
        public ArtifactStatus ArtifactStatus
        {
            get { return _artifactStatus; }
            set
            {
                _artifactStatus = value;
                OnPropertyChanged(() => ArtifactStatus);
            }
        }

        private string _artifactstatusError;
        public string ArtifactstatusError
        {
            get { return _artifactstatusError; }
            set
            {
                _artifactstatusError = value;
                OnPropertyChanged(() => ArtifactstatusError);
            }
        }

        private ArtifactTypes _artifactType;
        public ArtifactTypes ArtifactType
        {
            get { return _artifactType; }
            set
            {
                _artifactType = value;
                OnPropertyChanged(() => ArtifactType);
                OnPropertyChanged(() => FileFormat);
                OnPropertyChanged(()=>IsFileFormatVisible);

                HasArtifactTypeChanged = true;
            }
        }

        public ArtifactDescriptor(ArtifactTypes artifactType, object originalModel)
        {
            OriginalModel = originalModel;
            _artifactType = artifactType;
        }
    }

    public enum ArtifactTypes
    {
        GenericFile,
        CADModel,
        BehaviorModel,
        ManufacturingModel,
        SharedLibrary
    }

    public enum ArtifactStatus
    {
        Ok,
        FileNotFound,
    }
}
