/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using Common.Command;
using Common.Notification;
using ComponentAuthoringAssistant.Models;

namespace ComponentAuthoringAssistant.ViewModels
{
    public class ChangeVisibilityViewModel : NotifyBase
    {
        public DelegateCommand SaveCommand { get; set; }
        public DelegateCommand CancelCommand { get; set; }

        private ArtifactDescriptor _artifactDescriptor;
        public ArtifactDescriptor ArtifactDescriptor
        {
            get { return _artifactDescriptor; }
            set
            {
                _artifactDescriptor = value;
                OnPropertyChanged(() => ArtifactDescriptor);
                OnPropertyChanged(() => PossibleArtifactTypes);

            }
        }

        private readonly Dictionary<ArtifactTypes, List<ArtifactTypes>> _possibleArtifactTypes = new Dictionary<ArtifactTypes, List<ArtifactTypes>>();
        public List<ArtifactTypes> PossibleArtifactTypes
        {
            get
            {
                if (!_possibleArtifactTypes.ContainsKey(ArtifactDescriptor.ArtifactType))
                {
                    switch (ArtifactDescriptor.ArtifactType)
                    {
                        case ArtifactTypes.GenericFile:
                            _possibleArtifactTypes[ArtifactDescriptor.ArtifactType] = new List<ArtifactTypes> {ArtifactTypes.CADModel, ArtifactTypes.ManufacturingModel};
                            break;
                        case ArtifactTypes.CADModel:
                        case ArtifactTypes.BehaviorModel:
                        case ArtifactTypes.ManufacturingModel:
                        case ArtifactTypes.SharedLibrary:
                            _possibleArtifactTypes[ArtifactDescriptor.ArtifactType] = new List<ArtifactTypes>();
                            break;
                        default:
                            throw new ArgumentOutOfRangeException();
                    }
                }
                return _possibleArtifactTypes[ArtifactDescriptor.ArtifactType];
            }
        }

        private ArtifactTypes _selectedArtifactType;
        public ArtifactTypes SelectedArtifactType
        {
            get { return _selectedArtifactType; }
            set
            {
                _selectedArtifactType = value;
                OnPropertyChanged(() => SelectedArtifactType);
            }
        }


        private readonly Window _window;

        public ChangeVisibilityViewModel(ArtifactDescriptor ad, Window window)
        {
            _window = window;
            ArtifactDescriptor = ad;

            SelectedArtifactType = PossibleArtifactTypes.FirstOrDefault();

            SaveCommand = new DelegateCommand(a =>
                                                  {
                                                      ArtifactDescriptor.ArtifactType = SelectedArtifactType;
                                                      _window.DialogResult = true;
                                                      _window.Close();
                                                  },o=>true);

            CancelCommand = new DelegateCommand(a =>
                                                    {
                                                        _window.DialogResult = false;
                                                        _window.Close();
                                                    }, o => true);
        }
    }
}
