/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using Common.Command;
using Common.Notification;
using System.Windows;

namespace ComponentAuthoringAssistant.ViewModels
{
    public class ConfirmEditViewModel : NotifyBase
    {

        private DelegateCommand _discardChangesCommand;
        public DelegateCommand DiscardChangesCommand
        {
            get { return _discardChangesCommand; }
            set
            {
                _discardChangesCommand = value;
                OnPropertyChanged(() => DiscardChangesCommand);
            }
        }

        private DelegateCommand _acceptChangesCommand;
        public DelegateCommand AcceptChangesCommand
        {
            get { return _acceptChangesCommand; }
            set
            {
                _acceptChangesCommand = value;
                OnPropertyChanged(() => AcceptChangesCommand);
            }
        }

        private void ExecuteAcceptChanges(object state)
        {
            _window.DialogResult = true;
            _window.Close();
        }

        private void ExecuteDiscardChanges(object state)
        {
            _window.DialogResult = false;
            _window.Close();
        }

        private readonly Window _window;
        public ComponentAuthoringViewModel ParentViewModel { get; private set; }

        public ConfirmEditViewModel(Window window, object state=null)
        {
            _window = window;
            
            if (state !=null)
                ParentViewModel = (ComponentAuthoringViewModel) state; 

            DiscardChangesCommand = new DelegateCommand(ExecuteDiscardChanges,o=>true);
            AcceptChangesCommand  = new DelegateCommand(ExecuteAcceptChanges, o => true);
        }
    }
}