/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef ASSEMBLYOUTPUTWRITER_H
#define ASSEMBLYOUTPUTWRITER_H

#include "CyPhyML.h"
#include "CADData.h"
#include "Logger.h"
#include "Json_Helper.h"

class AssemblyOutputWriter
{
public:
	AssemblyOutputWriter():
	  outputDirectoryName(""),
	  cadFileDirectoryName(""),
	  assemblyName("TopAssembly"),
	  configurationID("")
	  {
		  useProjectManifest = Globals::Instance()->UseManifest;  
	  }

	AssemblyOutputWriter(string out, string cad, string name, string configID):
	  outputDirectoryName(out),
	  cadFileDirectoryName(cad),
	  assemblyName(name),
	  configurationID(configID)
	  {
		  useProjectManifest = Globals::Instance()->UseManifest;
	  }

	// main calling functions
	void WriteAssemblyInterfaceFile(list<CAssembly*> &, vector<CComponent*> &);
	void WriteAssemblyInterfaceFile(list<CAssembly*> &, vector<CComponent*> &, CyPhyML::TestBench &);
	void WriteAssemblyInterfaceFile(CAssembly *, CyPhyML::CADTestBenchType &);
	void WriteAssemblyBatFile(std::string);
	void WriteGraph(CAssembly* const, bool directed = false);
	void WriteGraph(list<CAssembly*> &, vector<CComponent*> &, bool directed = false);
	void WriteCADData(CAssembly* const topAssembly);
	void WriteCADData(list<CAssembly*> &topAssembly);
	/////////////////////////

private:
	void WriteAssemblyInterfaceFile(CAssembly*, Udm::Object &);
	void FillInAttributes(CADData* cadData, AssemblyInterface::CADComponent& cadComp);
	void FillInAttributes(const CyPhyML::CADTestBench& tb, AssemblyInterface::CADComponent& cadComp);
	void CreateFEAAnalysisInput(CyPhyML::CADTestBench&, AssemblyInterface::Assembly&);
	bool AddSurface(const CyPhyML::GeometryTypes& surface, Udm::Object& parent);

	void AddCircle(CyPhyML::Circle&, Udm::Object& parent);
	void AddConcentricCircles(CyPhyML::ConcentricCircles&, Udm::Object& parent);
	void AddCylinder(CyPhyML::Cylinder&, Udm::Object& parent);
	void AddSphere(CyPhyML::Sphere&, Udm::Object& parent);
	void AddPolygon(CyPhyML::Polygon&, Udm::Object& parent);
	void AddExtrusion(CyPhyML::Extrusion&, Udm::Object& parent);
	void AddCustom(CyPhyML::CustomGeometry&, Udm::Object& parent);

	bool AddSurfaceTreatment(const CyPhyML::AdjoiningSurfacesTreatment& treatment, Udm::Object& parent);
	bool AddAnalysisConstraint(const CyPhyML::AnalysisConstraint& constraint, Udm::Object& parent);
	bool AddAnalysisLoad(const CyPhyML::AnalysisLoad& load, Udm::Object& parent);
	void CreateMaterials(set<CyPhyML::MaterialsBase>& materialsSet, Udm::Object& parent);
	void CreateTestBenchMetrics(Udm::Object &, CyPhyML::TestBench &, string);				//void CreateCADComputationInformation(Udm::Object &, CyPhyML::TestBench &, string);

	void CreateOrphanComponents(vector<CComponent*> &, Udm::Object &);
	void CreateFeature(CyPhyML::AnalysisPoint& , Udm::Object& parent);
	string GetFeaturePointComponentParentID(const CyPhyML::PointGeometry &pt_in);


	void CreateTestBenchPostProcessScripts(const CyPhyML::TestBench &);
	void AddCADComponentConstraints(const vector<CEdge*> &);

protected:
	static const map<string, string> m_materialUnitLookup;

	string outputDirectoryName;
	string cadFileDirectoryName;
	string assemblyName;
	string configurationID;
	set<CyPhyML::MaterialsBase> materialsUsed;
	map<long, AssemblyInterface::CADComponent> m_AllAICADComponents;				///< A map of all the created AssemblyInterface::CADComponent

	// constants
	static const string kreg_config_id;

	static const string kmat_al;
	static const string kmat_steel;
	static const string kmat_ceramic;
	static const string kmat_poly;
	static const string kprop_thermal_exp;		
	static const string kprop_density;	
	static const string kprop_mod_elasticity;
	static const string kprop_tensile_ultm;
	static const string kprop_tensile_yield;
	static const string kprop_shear_mod;
	static const string kprop_poisson;
	static const string kprop_shear_strength;
	static const string kprop_bearing_ultm;
	static const string kprop_bearing_yield;
	static const string kprop_fatigue_strength;
	static const string kprop_fatigue_cycles;
	static const string kprop_min_melt_pt;
	static const string kprop_heat_capacity;
	static const string kprop_thermal_conductivity;
	static const string kprop_fracture_toughness;
	static const string kprop_max_safe_op_temp;
	static const string kprop_flexural_strength;
	static const string kprop_vicatb_soft_pt;
	static const string kprop_flame_rating;
	static const string kprop_heat_deflect_temp;
	static const string kprop_heat_deflect_load;

protected:	// helper functions
	//CyPhyML::AnalysisPoint FindEndPointAP(CyPhyML::AnalysisPoint&);
	static map<string, string> CreateMaterialUnitLookupTable();

	string GetTimeStamp();

	//set<string> m_cad_part_files;
	vector<Json_Helper::ComponentManifest> m_componentManifestData;
	set<string> m_componentManifestAdded;
	bool useProjectManifest;

	void GenerateExecutionScripts();
};

#endif