/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "CADDataCreator.h"

#include "UdmConsole.h"
#include "UdmGme.h"
#include <fstream>

#include "string_utils.h"
#include "CommonHelper.h"
#include "CommonTraverse.h"
#include "UdmFormatter.h"
#include "VersionNo.h"

#include "Logger.h"
#include "CommonData.h"
#include "AssemblyOutputWriter.h"
#include "CommonData.h"



CAssembly* CADDataCreator_Flatten::CreateINTCADStructure(CyPhyML::CADTestBench &testBench, 
														set<CyPhyML::Component> &AllCyPhyComponents_in, 
														set<CyPhyML::Component> &AllCyPhySize2Fit_in)
{

	CAssembly* topAssemblyCADData = CommonData::CreateCAssembly(testBench);	
	//this->m_topAssembly = tbID;

	ProcessSize2Fit(topAssemblyCADData, AllCyPhyComponents_in, AllCyPhySize2Fit_in);
	ProcessRegularComponents(topAssemblyCADData, AllCyPhyComponents_in);


	return topAssemblyCADData;

}

CAssembly* CADDataCreator_Flatten::CreateINTCADStructure(CyPhyML::ComponentAssembly &assembly, 
														set<CyPhyML::Component> &AllCyPhyComponents_in, 
														set<CyPhyML::Component> &AllCyPhySize2Fit_in)
{
	CAssembly* topAssemblyCADData = CommonData::CreateCAssembly(assembly);
	ProcessSize2Fit(topAssemblyCADData, AllCyPhyComponents_in, AllCyPhySize2Fit_in);
	ProcessRegularComponents(topAssemblyCADData, AllCyPhyComponents_in);

	return topAssemblyCADData;
}


void CADDataCreator_Flatten::ProcessSize2Fit(CAssembly *topAssemblyCADData,
											set<CyPhyML::Component> &AllCyPhyComponents_in,
											set<CyPhyML::Component> &AllCyPhySize2Fit_in)											
{
	for (set<CyPhyML::Component>::const_iterator ci = AllCyPhySize2Fit_in.begin(); ci != AllCyPhySize2Fit_in.end(); ci++)
	{
		CyPhyML::Component size2fitCyPhy(*ci);
		//CComponentSize2Fit* size2fit = new CComponentSize2Fit(size2fitCyPhy.uniqueId(), size2fitCyPhy);
		//AllSize2Fit[size2fitCyPhy.uniqueId()] = size2fit;
		CComponentSize2Fit* size2fit = CommonData::CreateCSize2Fit(size2fitCyPhy);

		topAssemblyCADData->child_Size2Fits.push_back(size2fit);

		set<CyPhyML::StructuralInterface> sir_Set = size2fitCyPhy.StructuralInterface_kind_children();
		for (set<CyPhyML::StructuralInterface>::const_iterator di = sir_Set.begin(); di != sir_Set.end(); di++)
		{
			CyPhyML::StructuralInterface beginPort(*di), endPort;
			long id = beginPort.uniqueId();
			StructuralInterfacePortVisitor sirVisitor;
			endPort = sirVisitor.FindConnectedSIRPort(beginPort);
			if (endPort != Udm::null)
			{
				CyPhyML::MgaObject endPortParent = endPort.parent();
				if (endPortParent.type() == CyPhyML::Component::meta)
				{				
					if (AllCyPhyComponents_in.find(CyPhyML::Component::Cast(endPortParent)) != AllCyPhyComponents_in.end())
					{
						size2fit->child_StructuralInterfaceRoles[id] = beginPort;
						size2fit->child_StructuralInterfaceRolesENDs[id] = endPort;

						CComponent* cadEndPortParent = CommonData::CreateCComponent(CyPhyML::Component::Cast(endPortParent));
						CyPhyML::JoinStructures js = *(sirVisitor.m_JoinStructuresVisited.begin());
						CEdge* edge = new CEdge(js.uniqueId(), js);
						edge->source = cadEndPortParent;
						edge->destination = size2fit;
						edge->sourcePort = endPort.uniqueId();
						edge->destinationPort = beginPort.uniqueId();

						CommonData::AddCEdge(edge);
						topAssemblyCADData->child_Size2FitEdges.push_back(edge);
					}
					else if (AllCyPhySize2Fit_in.find(CyPhyML::Component::Cast(endPortParent)) != AllCyPhySize2Fit_in.end())
						LOGMSG("Size2Fit [" + (string)size2fitCyPhy.name() + "] connected to another Size2Fit [" + (string)endPortParent.name() + "]", MSG_ERROR);
				}
			}

			for (vector<CyPhyML::StructuralInterface>::iterator k = sirVisitor.m_StructuralInterfaceRolePairs.begin(); k != sirVisitor.m_StructuralInterfaceRolePairs.end(); k++)
				AllSIRPorts2Skip.insert(*k);
		}
	}
}

void CADDataCreator_Flatten::ProcessRegularComponents(CAssembly *topAssemblyCADData,
													  set<CyPhyML::Component> &AllCyPhyComponents_in)

{	
	for (set<CyPhyML::Component>::const_iterator ci = AllCyPhyComponents_in.begin(); ci != AllCyPhyComponents_in.end(); ci++)
	{
		CyPhyML::Component component(*ci);
		CComponent *cadComponent = CommonData::CreateCComponent(component);
		topAssemblyCADData->AddComponent(cadComponent);						// adding new cadComponent data to topCadComponent (created from TB)

		set<CyPhyML::StructuralInterface> SIRs = component.StructuralInterface_kind_children();
		for (set<CyPhyML::StructuralInterface>::const_iterator ci2 = SIRs.begin(); ci2 != SIRs.end(); ci2++)
		{
			CyPhyML::StructuralInterface beginPort(*ci2), endPort;

			if (AllSIRPorts2Skip.find(beginPort) == AllSIRPorts2Skip.end())							// check if SIR port is new
			{
				StructuralInterfacePortVisitor sirVisitor;
				endPort = sirVisitor.FindConnectedSIRPort(beginPort);

				if (endPort != Udm::null)
				{
					CyPhyML::MgaObject endPortParentMGA = endPort.parent();
					if (endPortParentMGA.type() == CyPhyML::Component::meta)
					{
						CyPhyML::Component endPortParent = CyPhyML::Component::Cast(endPortParentMGA);
						if (component != endPortParent && 
							AllCyPhyComponents_in.find(endPortParent) != AllCyPhyComponents_in.end())							
						{
							CComponent* cadEndPortParent = CommonData::CreateCComponent(endPortParent);

							// DY: 10-26-2012
							// create an edge for this
							CyPhyML::JoinStructures js = *(sirVisitor.m_JoinStructuresVisited.begin());
							Join_StructuralInterfacePair::const_iterator zi = CommonData::JS_SI_Lookup_Table.find(js);
							if (zi != CommonData::JS_SI_Lookup_Table.end())
							{
								CEdge* edge = new CEdge(js.uniqueId(), js);
								edge->source = cadComponent;
								edge->destination = cadEndPortParent;
								edge->sourcePort = beginPort.uniqueId();
								edge->destinationPort = endPort.uniqueId();

								CommonData::AddCEdge(edge);
								topAssemblyCADData->child_Edges.push_back(edge);

								edge->SetDegreeOfFreedom(GetDegreesOfFreedom(zi->second.first));

								cadComponent->child_StructuralInterfaceRoles[beginPort.uniqueId()] = beginPort;
								cadEndPortParent->child_StructuralInterfaceRoles[endPort.uniqueId()] = endPort;
							}

							AllSIRPorts2Skip.insert(beginPort);
							AllSIRPorts2Skip.insert(endPort);

							
#if 0
							// create an edge for this
							CyPhyML::JoinStructures js = *(sirVisitor.m_JoinStructuresVisited.begin());
							CEdge* edge = new CEdge(js.uniqueId(), js);
							edge->source = cadComponent;
							edge->destination = cadEndPortParent;
							edge->sourcePort = beginPort.uniqueId();
							edge->destinationPort = endPort.uniqueId();

							CommonData::AddCEdge(edge);
							topAssemblyCADData->child_Edges.push_back(edge);
							Join_StructuralInterfacePair::const_iterator zi = CommonData::JS_SI_Lookup_Table.find(js);
							if (zi != CommonData::JS_SI_Lookup_Table.end())
							{
								edge->SetDegreeOfFreedom(GetDegreesOfFreedom(zi->second.first));
							}


							cadComponent->child_StructuralInterfaceRoles[beginPort.uniqueId()] = beginPort;
							cadEndPortParent->child_StructuralInterfaceRoles[endPort.uniqueId()] = endPort;

							AllSIRPorts2Skip.insert(beginPort);
							AllSIRPorts2Skip.insert(endPort);
#endif
						}
					}
					// add JoinStructures to traversed JS
				}
			}
		} // for		
	}
}
