/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef CADDATACREATOR
#define CADDATACREATOR

#include "CyPhyML.h"
#include "CADData.h"
#include "AssemblyInterface.h"
//#include "CEdgeAnalyzer.h"
#include <deque>


/** \file
    \brief Definition of the CADDataCreator class that traverses the model, creates intermediate hierarchy, flattens hierarchy where needed and generates the CAD assembly output file.		    
*/

class CADDataCreator_Flatten
{
public:
	CADDataCreator_Flatten() {}
	~CADDataCreator_Flatten() {}

	CAssembly* CreateINTCADStructure(CyPhyML::CADTestBench &, set<CyPhyML::Component> &, set<CyPhyML::Component> &);
	CAssembly* CreateINTCADStructure(CyPhyML::ComponentAssembly &, set<CyPhyML::Component> &, set<CyPhyML::Component> &);

protected:
	void ProcessSize2Fit(CAssembly *, set<CyPhyML::Component> &, set<CyPhyML::Component> &);
	void ProcessRegularComponents(CAssembly *, set<CyPhyML::Component> &);

protected:
	set<CyPhyML::StructuralInterface> AllSIRPorts2Skip;

};

// TODO: Fill in this class, flattens hierarchy
//class CADDataCreator_Hierarchical
//{
//};

#endif