/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// CaFoldersDialog.cpp : implementation file
//

#include "stdafx.h"
#include "CaFoldersDialog.h"
#include "afxdialogex.h"


// CaFoldersDialog dialog

IMPLEMENT_DYNAMIC(CaFoldersDialog, CDialogEx)

CaFoldersDialog::CaFoldersDialog(CWnd* pParent /*=NULL*/)
	: CDialogEx(CaFoldersDialog::IDD, pParent)
{

}

CaFoldersDialog::CaFoldersDialog(CyPhyML::RootFolder &rf, CWnd* pParent /*=NULL*/)
	: CDialogEx(CaFoldersDialog::IDD, pParent),
	m_rootFolder(rf)
{

}

CaFoldersDialog::~CaFoldersDialog()
{
}

void CaFoldersDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CA_FOLDER_TREE, m_caFolderTree);
}


BEGIN_MESSAGE_MAP(CaFoldersDialog, CDialogEx)
	ON_NOTIFY(TVN_SELCHANGED, IDC_CA_FOLDER_TREE, &CaFoldersDialog::OnTvnSelchangedTree1)
END_MESSAGE_MAP()


// CaFoldersDialog message handlers


void CaFoldersDialog::OnTvnSelchangedTree1(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here

	HTREEITEM hItem = this->m_caFolderTree.GetSelectedItem(); 
	this->m_selectedCAFolder = this->m_CAFolderMap[hItem];

	*pResult = 0;
}


BOOL CaFoldersDialog::OnInitDialog()
{
	CDialogEx::OnInitDialog();
	this->m_CAFolderMap.clear();

	std::set<CyPhyML::Components> Components_Set = this->m_rootFolder.Components_kind_children();
	for (std::set<CyPhyML::Components>::iterator i = Components_Set.begin(); i != Components_Set.end(); i++)
	{
		CyPhyML::Components componentsFolder(*i);
		this->GenerateTree(componentsFolder, NULL);
	}

	return 1;
}


bool CaFoldersDialog::GenerateTree(CyPhyML::Components &componentsFolder, HTREEITEM parent)
{
	bool containsComponentAssemblies = 0, childHasComponentAssemblies = 0;
	std::string nodeName = std::string(componentsFolder.name());
	HTREEITEM folderNode = m_caFolderTree.InsertItem((LPSTR)nodeName.c_str(), parent);
	
	std::set<CyPhyML::Components> Components_Set = componentsFolder.Components_kind_children();
	for (std::set<CyPhyML::Components>::iterator i = Components_Set.begin(); i != Components_Set.end(); i++)
	{
		if (this->GenerateTree(CyPhyML::Components(*i), folderNode) == 1)
			childHasComponentAssemblies = 1;
	}

	std::set<CyPhyML::ComponentAssemblies> ComponentAssemblies_Set = componentsFolder.ComponentAssemblies_kind_children();
	for (std::set<CyPhyML::ComponentAssemblies>::iterator i = ComponentAssemblies_Set.begin(); i != ComponentAssemblies_Set.end(); i++)
		this->GenerateTree(CyPhyML::ComponentAssemblies(*i), folderNode);
	
	if (ComponentAssemblies_Set.size() < 1 && !childHasComponentAssemblies)
	{
		// remove myself
		m_caFolderTree.DeleteItem(folderNode);
	}
	else
	{	
		this->m_CAFolderMap[folderNode] = componentsFolder;
		this->m_caFolderTree.Expand(folderNode,TVE_EXPAND);
		containsComponentAssemblies = 1;
	}

	return containsComponentAssemblies;
}


void CaFoldersDialog::GenerateTree(CyPhyML::ComponentAssemblies &caFolder, HTREEITEM parent)
{
	std::string nodeName = "* " + std::string(caFolder.name()) + "  [COMPONENT ASSEMBLIES]";
	HTREEITEM folderNode = m_caFolderTree.InsertItem((LPSTR)nodeName.c_str(), parent);
	m_caFolderTree.SetItemState(folderNode, TVIS_BOLD, TVIS_BOLD);

	this->m_CAFolderMap[folderNode] = caFolder;
	std::set<CyPhyML::ComponentAssemblies> ComponentAssemblies_Set = caFolder.ComponentAssemblies_kind_children();
	for (std::set<CyPhyML::ComponentAssemblies>::iterator i = ComponentAssemblies_Set.begin(); i != ComponentAssemblies_Set.end(); i++)
		this->GenerateTree(CyPhyML::ComponentAssemblies(*i), folderNode);

	this->m_caFolderTree.Expand(folderNode,TVE_EXPAND);
}