/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef CHECKCONSTRAINT_H
#define CHECKCONSTRAINT_H

#include "CyPhyML.h"

//#include <map>



class Checker
{
public:
	Checker();

	// used to index array
	enum ConstraintType
	{
		WARNING = 0,
		GENERAL_ERROR,
		COMPONENT_REF,
		DESIGN_CONTAINER,
		COMPONENT_FWDER,
		ASSEMBLY_SI,
		MISMATCH_SI_TYPE,
		MULTIPLE_CONNECTED_SI,
		SI_CONNECTION_ERROR,
		DATUM_PORT_ERROR,
		TIP_REFERENCE_ERROR,
		CAD_TB_COMPUTATION_BLOCK_ERROR,
		CAD_TB_GEOMETRY_ERROR,
		CAD_TB_CA_ERROR,
		CONSTRAINT_TYPE_COUNT
	};

	bool CheckConstraintStart(const CyPhyML::ComponentAssembly &assembly, set<CyPhyML::Component>& AllCyPhyComponents, set<CyPhyML::Component>& AllCyPhySize2Fit, set<long> &, int &, int &);
	void CheckAssembly(const CyPhyML::ComponentAssembly &assembly, set<CyPhyML::Component>& AllCyPhyComponents, set<CyPhyML::Component>& AllCyPhySize2Fit);

	bool CheckConstraintStart(const CyPhyML::CADTestBench &testBench, set<CyPhyML::Component>& AllCyPhyComponents, set<CyPhyML::Component>& AllCyPhySize2Fit, int &, int &);
	void CheckGeometry(const CyPhyML::CADTestBench &);
	void CheckGeometry(const CyPhyML::GeometryTypes &);
	void CheckGeometry(const CyPhyML::Circle &);
	void CheckGeometry(const CyPhyML::Polygon &);
	void CheckGeometry(const CyPhyML::ConcentricCircles &);
	void CheckGeometry(const CyPhyML::Sphere &);
	void CheckGeometry(const CyPhyML::Cylinder &);
	void CheckGeometry(const CyPhyML::Extrusion &);
	void CheckGeometry(const CyPhyML::CustomGeometry &);


	void GetFeaturePoint(CyPhyML::AnalysisPoint &);
	bool IsTIPInSUT(string &, CyPhyML::Component &);

	bool CheckComponent(CyPhyML::Component &, set<CyPhyML::Component> &);
	void CheckDatumPortNames(const CyPhyML::StructuralInterface &a, const CyPhyML::StructuralInterface &b);

	bool CheckConstraintStart(const CyPhyML::TestBench &testBench);

	void CreateLogMessage(std::string&, ConstraintType);	

	//void GetAnalysisPoint_FeaturePoint(CyPhyML::Geometry2ComponentConnection &, CyPhyML::AnalysisPoint &, CyPhyML::Point &);

protected:
	//int m_errorCount[CONSTRAINT_TYPE_COUNT];
	int m_errorCount;
	int m_warningCount;
	std::string m_format;

	std::set<CyPhyML::Component> RefCoordSystemComponents;
	//std::multimap<ConstraintType, std::string> errors;
	std::map<CyPhyML::StructuralInterface, CyPhyML::StructuralInterface> m_connectedStructuralInterface;
	void FindReferenceCoordSystemComponents(const CyPhyML::ComponentAssembly &, set<long> &);


	std::set<CyPhyML::StructuralInterface> m_validStructuralInterface;
	std::set<CyPhyML::JoinStructures> m_visitedJoin;
	bool HasConnectedGeometryFeature(const CyPhyML::StructuralInterfaceFeature &, const CyPhyML::CADModel &);
	void FindConnectedStructuralInterfacePort(const CyPhyML::StructuralInterface &);
	void CheckJoinStructureConnections();

	bool MatchSIType(string&, string&);
};

#endif