/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef COMMONDATA_H
#define COMMONDATA_H

#include "CyPhyML.h"
#include "CADData.h"

#include <map>

typedef std::map<CyPhyML::JoinStructures, pair<CyPhyML::StructuralInterface, CyPhyML::StructuralInterface>> Join_StructuralInterfacePair;
typedef map<CyPhyML::AnalysisPoint, CyPhyML::PointGeometry> AnalysisPoint_FeaturePoint_Map;

class CommonData
{
private:
	static map<long, CAssembly*> AllAssemblies;							///< A map of all CAssembly created
	static map<long, CComponent*> AllComponents;						///< A map of all CComponents created
	static vector<CEdge*> AllEdges;										///< A collection of all CEdges created
	static map<long, CForwarder*> AllForwarders;						///< A map of all CForwarders created
	static map<long, CComponentSize2Fit*> AllSize2Fit;					///< A map of all size2fit CComponents created

public:
	static Join_StructuralInterfacePair JS_SI_Lookup_Table;
	static AnalysisPoint_FeaturePoint_Map geometryConn_AnalysisPoint_table;
	static map<CyPhyML::CustomGeometryOperator, set<CyPhyML::GeometryTypes>> GeometryOperator_table;
	static map<CyPhyML::TestInjectionPoint, CyPhyML::Component> TIP_Component_table;
	static map<CyPhyML::Component, CyPhyML::CADModel> CADModel_Lookup_table;
	static map<CyPhyML::StructuralInterfaceFeature, CyPhyML::GeometryFeature> SIFeature_To_GeometryFeature_Lookup_table;

	static CComponent* CreateCComponent(CyPhyML::Component& cyphyComponent);

	static CAssembly* CreateCAssembly(CyPhyML::ComponentAssembly& cyphyAssembly);
	static CAssembly* CreateCAssembly(CyPhyML::ComponentAssembly& cyphyAssembly, long ID);											// for islands
	static CAssembly* CreateCAssembly(CyPhyML::ComponentAssembly& cyphyAssembly_in, long ID_in, string assemblyInterfaceID_in);		// for islands
	static CAssembly* CreateCAssembly(CyPhyML::MgaObject& cyphyref_in, long ID_in, string assemblyInterfaceID_in);		// for islands
	static CAssembly* CreateCAssembly(CyPhyML::CADTestBench& testBench);

	static CForwarder* CreateCForwarder(CyPhyML::StructuralInterfaceForwarder& port);
	static CComponentSize2Fit* CreateCSize2Fit(CyPhyML::Component &);
	static void AddCEdge(CEdge*);
	static CComponent *FindCComponent(long);
	static void CleanData();

};

#endif