/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef COMMONTRAVERSE_H
#define COMMONTRAVERSE_H

#include "CyPhyML.h"


/** \file
    \brief Common traversal code used to StructuralInterfaceRole Ports that are connected together via JoinStructrures and StructuralInterfaceForwarder port.		    
		   The user can start the process from a JoinStructure, a StructuralInterfaceRole Port or a StructuralInterfaceForwarder port.
*/

typedef std::pair<long, CyPhyML::StructuralInterface> JoinStructureEndsItem;	
typedef std::pair<CyPhyML::DesignElement, CyPhyML::JoinStructures> JoinStructureAndEndPair;

class StructuralInterfacePortVisitor : public CyPhyML::Visitor
{
public:
	StructuralInterfacePortVisitor() {};
	~StructuralInterfacePortVisitor() {};

	virtual void Visit_JoinStructures(const CyPhyML::JoinStructures &);
	virtual void Visit_StructuralInterface(const CyPhyML::StructuralInterface &);
	virtual void Visit_StructuralInterfaceForwarder(const CyPhyML::StructuralInterfaceForwarder &);

	vector<CyPhyML::StructuralInterface> m_StructuralInterfaceRolePairs;		///< A set of structural interface role ports found from visiting a series of connected join structures
	set<long> m_StructuralInterfaceRoleIDs;										///< A set of structural interface role ports visited by id
	set<long> m_StructuralInterfaceForwarders;									///< A set of structural interface forwarder ports visited by id
	set<CyPhyML::JoinStructures> m_JoinStructuresVisited;						///< A set of join structures visited

	void PrintStructuralInterfaceRolePairs();

	CyPhyML::StructuralInterface FindConnectedSIRPort(const CyPhyML::StructuralInterface&);
	void FindConnectedSIRPorts_Set(const CyPhyML::StructuralInterface& beginPort, set<CyPhyML::StructuralInterface>&);
};


  
class AnalysisPointVisitor : public CyPhyML::Visitor
{
public:
	AnalysisPointVisitor() {};
	~AnalysisPointVisitor() {};

	void FindAnalysisPointEnds(CyPhyML::AnalysisPoint &pt);	
	virtual void Visit_AnalysisPointMap(const CyPhyML::AnalysisPointMap &);
	virtual void Visit_AnalysisPoint(const CyPhyML::AnalysisPoint &);
	int GetPointsFoundSize() { return pointsFound.size(); }
	CyPhyML::PointGeometry GetFoundPoint();
protected:
	set<CyPhyML::PointGeometry> pointsFound;
	set<CyPhyML::AnalysisPointMap> visitedAPMap;	
};


class RefCoordinateSystemVisitor : public CyPhyML::Visitor
{
public:
	RefCoordinateSystemVisitor() {};
	~RefCoordinateSystemVisitor() {};

	virtual void Visit_ReferenceCoordinateSystem(const CyPhyML::ReferenceCoordinateSystem &);
	virtual void Visit_RefCoordSystem2RefCoordSystem(const CyPhyML::RefCoordSystem2RefCoordSystem &);
	set<CyPhyML::RefCoordSystem2RefCoordSystem> visited_Connection;
	set<CyPhyML::ReferenceCoordinateSystem> visited_CoordSystems;	
	set<CyPhyML::Component> FoundRefCoordComponents;
	set<long> FoundRefCoordIDs;
};

#endif