/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef CONVERT2_DAG_H
#define CONVERT2_DAG_H

#include "CADData.h"
#include <deque>
#include <fstream>



class Convert2DAG
{
public:
	void ToDAG(CAssembly *, set<long> &);
	void ToDAG(list<CAssembly*> &, set<long> &);

protected:
	void DisableEdges(CAssembly *, vector<CEdge*> &);
	void AssignEdgeConstraints(deque<long> &components2Process, vector<CEdge*> &edges2Process);
	void AddComponent2Process(deque<long> &components2Process, long newID);
};

class Convert2DAG_DOF
{
public:
	Convert2DAG_DOF();
	~Convert2DAG_DOF();
	void ToDAG(CAssembly *, set<long> &);
	void ToDAG(list<CAssembly*> &, set<long> &);

protected:		// functions
	void ConstrainComponents(set<long> &, vector<CEdge*> &, int degree, set<long> &);
	bool FindEdges(long myID, int degree, set<long> &, vector<CEdge*> &);
	long FindStartingComponent(vector<CComponent*> &, set<long> &, vector<CEdge*> &, set<long> &);

protected:		// members
	ofstream log_file_;
	map<long, string> display_id_lookup_;

};



#endif
