/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef CYPHY2CADVISITOR_H
#define CYPHY2CADVISITOR_H

#include "CyPhyML.h"
#include "AssemblyInterface.h"
#include "string_utils.h"
#include "CommonTraverse.h"
#include "CommonHelper.h"
#include "UdmGme.h"
#include "UmlExt.h"


//using namespace CyPhyML;

#define ASSEMBLY_DEF "ASSEMBLY"
#define PART_DEF "PART"



/** \file
    \brief Deprecated class, not used anymore.		    
*/

class CyPhy2CADVisitor : public CyPhyML::Visitor
{
public:
//	CyPhy2CADVisitor(AssemblyInterface::CADComponent &Parent, bool forThermal = 0):
	CyPhy2CADVisitor(Udm::Object &CADParent, bool forThermal = 0):
	m_CadComponentParent(CADParent),
	m_CurrentRootComponent(0),
	m_IsThermal(forThermal){
	};

	~CyPhy2CADVisitor() {};

//	virtual void Visit_StructuralInterfaceDefinitions(const CyPhyML::StructuralInterfaceDefinitions &);
//	virtual void Visit_StructuralInterfaceDefinition(const CyPhyML::StructuralInterfaceDefinition &);



private:
//	std::map<std::string, std::string> m_CADTermLookup;

//	AssemblyInterface::CADComponent &m_CadComponentParent;						// current CADComponent parent, used for creating child CADComponents
	Udm::Object &m_CadComponentParent;						// current CADComponent parent, used for creating child CADComponents
	  
//	std::map<long, long> m_StructuralIfaceMap;									// 4 looking up archetype ids
	std::map<long, AssemblyInterface::CADComponent> m_CadComponentMap;			// 4 adding constraints - all CADComponents created during traversal
	bool IsNewCADComponent(long id);											// checks if a CADComponent with id already exists in m_CadComponentMap


	std::set<long> m_JoinStructuresVisited;									// 4 keeping track of which join structures have been visited
	bool IsNewJoinStructure(long id);											// checks if a join structure have been visited or not based on passed in id

	

	void FindStructuralInterfaceRoleEnds(CyPhyML::StructuralInterface&, std::vector<JoinStructureEndsItem>&);	// 4 finding structural interface roles ends to a starting sir

	long m_CurrentRootComponent;												// keeps track of the current root component that traversal started with
	//void AddConstraint2CADComponent(AssemblyInterface::CADComponent&, CyPhyML::StructuralInterfaceRole&, CyPhyML::StructuralInterfaceRole&);     // add constraints to a CADComponent given its source structural interface role and its corresponding sir end

	void InitializeCadComponent(CyPhyML::MgaObject&, AssemblyInterface::CADComponent&);								// initializes a CADComponent with information from a Component/ComponentAssembly

	//void CreateRootComponentConstraints(AssemblyInterface::CADComponent&, long);
	void CreateRootComponentConstraints(AssemblyInterface::CADComponent&, std::string);
	//void CreateConstraintFeature(AssemblyInterface::Pair&, long, std::string, std::string);
	void CreateConstraintFeature(AssemblyInterface::Pair&, std::string, std::string, std::string);


	void FindConnectedJoinStructuresAndEnd(CyPhyML::StructuralPortType &, std::vector<JoinStructureAndEndPair> &);

	std::string GetCadName(const CyPhyML::DesignElement &, std::string &);

	bool IsCADAssembly(CyPhyML::DesignElement &);

	bool m_IsThermal;

	// new
	std::map<long, std::set<CyPhyML::ComponentAssembly> > m_assemblyToBeVisited;

	void AreFeaturesConnected(set<CyPhyML::SolidModelingFeature> &);

public:
	void TraverseAssembly(CyPhyML::ComponentAssembly &, long startingElement = -1);
	void TraverseDesignElement(CyPhyML::DesignElement &);

public:  // Helper Functions
//	void PrintStructuralIfaceMap();												// debug print for printing out structuralIfaceMap
//	long FindFeatureArchetypeID(CyPhyML::Feature &);							// given a feature (is either an instance or a subtype), find its base feature's uniqueId
	void PrintFindConnectedJoinStructuresAndEnd(std::vector<JoinStructureAndEndPair> &);
	void PrintJoinStructuresVisited();
	

	// new stuff for size2fit
	CyPhyML::DesignElement FindRootDesignElement(const CyPhyML::ComponentAssembly&);
	void FillInAttributes(const CyPhyML::DesignElement&, AssemblyInterface::CADComponent&);
//	void Check4ZeroConstraints(const AssemblyInterface::CADComponent&);
//	void Check4ZeroConstraints(const AssemblyInterface::Assembly&);
	bool IsSize2Fit(const CyPhyML::DesignElement&);
	bool IsCADByPass(const CyPhyML::DesignElement&);

	std::set<std::string> m_DE2DEConstraintPairs;
	bool PriorConstraintFromDE2DE(CyPhyML::DesignElement &, CyPhyML::DesignElement &);
	void AddDE2DEConstraintPairs(CyPhyML::DesignElement &, CyPhyML::DesignElement &);

};


#endif