/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "Logger.h"
#include <time.h>
#include <windows.h>
#include <direct.h>
#include <boost\filesystem.hpp>

Globals* Globals::instance_ = 0;

Globals::Globals()
	:CadXmlOutputDirectory(""),
	CadArtifactDirectory(""),
	ConsoleMessagesOn(1),
	Automation(0),
	DoConfig(false),
	Expanded(0),
	logFilterLevel(MSG_ERROR),
	CadPartDirectoryUpdated(0),
	PrepIFAB(false),
	DebugLogDirectory(""),
	ProjectRootDir(""),
	UseManifest(1),
	RunCommand("")
{
}

Globals::~Globals()
{
	logMessageQ.clear();
}

void Globals::TerminateInstance()
{
	if (instance_ != 0)
		delete instance_;
	instance_ = 0;
	
}

Globals* Globals::Instance()
{
	if (instance_ == 0)
		instance_ = new Globals();
	
	return instance_;
}


void Globals::WriteLogMsg()
{
	FileChannel file(this->DebugLogDirectory, "\\CyPhy2CAD.log");	//FileChannel file(CadXmlOutputDirectory, "\\log\\CyPhy2CAD.log");
	file.WriteLog(logMessageQ);

	if (this->ConsoleMessagesOn)
	{
		GMEConsoleChannel consoleChannel(logFilterLevel);
		consoleChannel.WriteLog(logMessageQ);
	}
	else
	{
		GMEConsoleChannel consoleChannel(MSG_WARNING);
		consoleChannel.WriteLog(logMessageQ);
	}
}

void Globals::CreateFolder(string &foldername_in)
{
	if (foldername_in != "")
	{
		boost::filesystem::path p(foldername_in);
		if (!boost::filesystem::exists(p))
			boost::filesystem::create_directory(p);
		//_mkdir(foldername_in.c_str());
	}
}

FileChannel::FileChannel(string path, string filename)
	: Channel()
{
	time_t seconds;
	seconds = time (NULL);

	string outfile;
	outfile = (path == "") ? filename : path + "\\" + filename;
	remove(outfile.c_str());

	m_file.open(outfile.c_str());
}

FileChannel::FileChannel(string path, string filename, string fileExt)
	: Channel()
{
	time_t seconds;
	seconds = time (NULL);

	string outfile;
	outfile = (path == "") ? filename + fileExt : path + "\\" + filename + fileExt;
	remove(outfile.c_str());

	m_file.open(outfile.c_str());
}

FileChannel::~FileChannel()
{
	if (m_file.is_open())
		m_file.close();
}

void FileChannel::WriteLog(LogMessages& messages)
{
	for (unsigned int i = 0; i < messages.size(); i++)
	{
		if (messages[i].first <= m_logLevel) 
		{
			switch (messages[i].first)
			{
			case 0:
				m_file<<"NORMAL: ";
				break;
			case 1:
				m_file<<"INFO: ";
				break;
			case 2:
				m_file<<"WARNING: ";
				break;
			case 3:
				m_file<<"ERROR: ";
				break;
			}
			m_file<<messages[i].second << std::endl;
		}
	}
}


GMEConsoleChannel::GMEConsoleChannel(msgtype_enum type)
	: Channel(type)
{
}



void GMEConsoleChannel::WriteLog(LogMessages& messages)
{
	for (unsigned int i = 0; i < messages.size(); i++)
	{
		if (messages[i].first >= m_logLevel)
			GMEConsole::Console::writeLine(messages[i].second, messages[i].first);
	}
}


