/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef LOGGER_H
#define LOGGER_H

#include <fstream>
#include "UdmConsole.h"

typedef vector<pair<msgtype_enum, string> > LogMessages;
#define LOGMSG(msg, type)	Globals::Instance()->logMessageQ.push_back(make_pair(type, msg))

class Channel
{
public:
	Channel(): m_logLevel(MSG_ERROR){};
	Channel(msgtype_enum type): m_logLevel(type) {};
	~Channel() {};
	virtual void WriteLog(LogMessages&) = 0;
protected:
	msgtype_enum m_logLevel;
};

class FileChannel : public Channel
{
public:
	FileChannel(string path, string filename);
	FileChannel(string path, string filename, string fileExt);
	~FileChannel();
	void WriteLog(LogMessages&);
	ofstream& Stream() {return m_file;}
private:
	ofstream m_file;
};

class GMEConsoleChannel  : public Channel
{
public:
	GMEConsoleChannel(): Channel(){};
	GMEConsoleChannel(msgtype_enum);
	~GMEConsoleChannel() {};
	void WriteLog(LogMessages&);
};

class Globals
{
private:
	Globals();
	~Globals();
	static Globals* instance_;
	
public:		// functions
	static void TerminateInstance();
	static Globals* Instance();
	LogMessages logMessageQ;
	void WriteLogMsg();

public:		// variables
	msgtype_enum logFilterLevel;
	string CadXmlOutputDirectory;
	string CadArtifactDirectory;
	bool CadPartDirectoryUpdated;
	string DebugLogDirectory;
	bool UseManifest;
	string ProjectRootDir;
	string RunCommand;
	
	// Passed in from calling interpreter
	bool ConsoleMessagesOn;
	bool Automation;
	bool DoConfig;
	bool Expanded;
	bool PrepIFAB;

	std::set<std::string> m_selectedStepFormats;
	string SettingsConfigPath;

public:
	void CreateFolder(string &);

};


#endif