/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// OptionsDialog.cpp : implementation file
//

#include "stdafx.h"
#include "OptionsDialog.h"
#include "afxdialogex.h"


#include "afxdlgs.h"
#include "string_utils.h"
#include "Logger.h"
#include <io.h>
#include "boost\property_tree\ptree.hpp"
#include "boost\property_tree\xml_parser.hpp"
#include "boost\filesystem.hpp"
#include <boost/foreach.hpp>
#include <boost/algorithm/string.hpp>

// OptionsDialog dialog

IMPLEMENT_DYNAMIC(OptionsDialog, CDialogEx)

OptionsDialog::OptionsDialog(CWnd* pParent, const std::string& ProjectRootDir)
	: CDialogEx(OptionsDialog::IDD, pParent),
	m_projectRootDir(ProjectRootDir),
	m_outputDirectory(_T(".\\")),
	m_cadDirectory(_T("")),
	m_cAP203_Single("AP203_Single_File"),
	m_cAP203_E2_Single("AP203_E2_Single_File"),
	m_cAP203_E2_Seperate("AP203_E2_Seperate_Part_Files"),
	m_cAP214_Single("AP214_Single_File"),
	m_cAP214_Seperate("AP214_Seperate_Part_Files"),
	m_useProjManifest(1)
{
	boost::filesystem::path full_path(m_projectRootDir);
	m_configPath =  full_path.string() + "\\CyPhy2CAD_config.xml";

	this->LoadConfigFile();
}

OptionsDialog::~OptionsDialog()
{
}

void OptionsDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_OUTPATH, m_outputDirectory);
	DDX_Text(pDX, IDC_CAD_PATH, m_cadDirectory);
	DDX_Control(pDX, IDC_STEP_LIST, m_stepList);
	DDX_Check(pDX, IDC_PROJ_MANIFEST_CHECK, m_useProjManifest);

#if 0 // TODO: Remove, not needed 6-21-2012
	DDX_Check(pDX, IDC_CAD_CHECK, m_genCAD);
	DDX_Check(pDX, IDC_MANUFACTURING_CHECK, m_genMAN);
	DDX_Control(pDX, IDC_PROE_COMBO, m_proeCombo);
#endif
}


BEGIN_MESSAGE_MAP(OptionsDialog, CDialogEx)
	ON_BN_CLICKED(IDC_OK_BUTTON, &OptionsDialog::OnBnClickedOkButton)
	ON_BN_CLICKED(IDC_PATH_BUTTON, &OptionsDialog::OnBnClickedPathButton)
	ON_BN_CLICKED(IDC_CANCEL_BUTTON, &OptionsDialog::OnBnClickedCancelButton)
	ON_BN_CLICKED(IDC_CAD_PATH_BUTTON, &OptionsDialog::OnBnClickedCadPathButton)

#if 0		// TODO: Remove, not needed 6-21-2012
	ON_CBN_SELCHANGE(IDC_PROE_COMBO, &OptionsDialog::OnCbnSelchangeProeCombo)
#endif

END_MESSAGE_MAP()

BOOL OptionsDialog::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	if (Globals::Instance()->Automation || Globals::Instance()->PrepIFAB)		// called from Master Interpreter
	{
		CEdit *out_dir_edit = reinterpret_cast<CEdit *>(GetDlgItem(IDC_OUTPATH));
		out_dir_edit->SetReadOnly(TRUE);

		CButton *path_button = reinterpret_cast<CButton *>(GetDlgItem(IDC_PATH_BUTTON));
		path_button->EnableWindow(FALSE);
	}

	int i = 0;
	ListView_SetExtendedListViewStyle(m_stepList.m_hWnd, LVS_EX_CHECKBOXES);

	LVITEM lvItem;
	lvItem.mask = LVIF_TEXT;
	lvItem.iItem = i;
	lvItem.iSubItem = 0;
	lvItem.pszText = "AP203_Single_File";
	m_stepList.InsertItem(&lvItem);
	m_stepFormats.push_back(m_cAP203_Single);
	if (m_selected_step.find(m_cAP203_Single) != m_selected_step.end())
		m_stepList.SetCheck(i);
	i++;
	lvItem.mask = LVIF_TEXT;
	lvItem.iItem = i;
	lvItem.iSubItem = 0;
	lvItem.pszText = "AP203_E2_Single_File";
	m_stepList.InsertItem(&lvItem);
	m_stepFormats.push_back(m_cAP203_E2_Single);
	if (m_selected_step.find(m_cAP203_E2_Single) != m_selected_step.end())
		m_stepList.SetCheck(i);
	i++;
	lvItem.mask = LVIF_TEXT;
	lvItem.iItem = i;
	lvItem.iSubItem = 0;
	lvItem.pszText = "AP203_E2_Seperate_Part_Files";
	m_stepList.InsertItem(&lvItem);
	m_stepFormats.push_back(m_cAP203_E2_Seperate);
	if (m_selected_step.find(m_cAP203_E2_Seperate) != m_selected_step.end())
		m_stepList.SetCheck(i);
	i++;
	lvItem.mask = LVIF_TEXT;
	lvItem.iItem = i;
	lvItem.iSubItem = 0;
	lvItem.pszText = "AP214_Single_File";
	m_stepList.InsertItem(&lvItem);
	m_stepFormats.push_back(m_cAP214_Single);
	if (m_selected_step.find(m_cAP214_Single) != m_selected_step.end())
		m_stepList.SetCheck(i);
	i++;
	lvItem.mask = LVIF_TEXT;
	lvItem.iItem = i;
	lvItem.iSubItem = 0;
	lvItem.pszText = "AP214_Seperate_Part_Files";
	m_stepList.InsertItem(&lvItem);
	m_stepFormats.push_back(m_cAP214_Seperate);
	if (m_selected_step.find(m_cAP214_Seperate) != m_selected_step.end())
		m_stepList.SetCheck(i);


	if (Globals::Instance()->PrepIFAB)
	{
		CListCtrl *step_list = reinterpret_cast<CListCtrl *>(GetDlgItem(IDC_STEP_LIST));
		step_list->EnableWindow(false);
	}

	CButton *ChkProjManifest = reinterpret_cast<CButton *>(GetDlgItem(IDC_PROJ_MANIFEST_CHECK));

	if (m_useProjManifest)
		ChkProjManifest->SetCheck(BST_CHECKED);
	else
		ChkProjManifest->SetCheck(BST_UNCHECKED);


#if 0		// TODO: Remove, not needed 6-21-2012
	int i = m_proeCombo.SetCurSel(0);
#endif

	return TRUE;
}

// OptionsDialog message handlers


void OptionsDialog::OnBnClickedOkButton()
{
	// TODO: Add your control notification handler code here
	this->UpdateData(1);
	
	if(m_outputDirectory.IsEmpty())
	{
		AfxMessageBox("You must specify the output directory.", MB_ICONINFORMATION );
	}
	else
	{
		for(int i=0; i<5; ++i)
		{
			if(m_stepList.GetCheck(i))
				Globals::Instance()->m_selectedStepFormats.insert(m_stepFormats[i]);
		}
		
		string tmp = GetCADDirectory();
		boost::replace_all(tmp, "/", "\\");
		SetCADDirectory(tmp);

		this->SaveConfigFile();
		this->OnOK();
	}
}


void OptionsDialog::OnBnClickedPathButton()
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CFolderPickerDialog outputLoc;
	int dialogReturn(outputLoc.DoModal());
	if (dialogReturn == IDOK) {
		this->m_outputDirectory = outputLoc.GetFolderPath();
		UpdateData(false);
	}
}



void OptionsDialog::OnBnClickedCancelButton()
{
	// TODO: Add your control notification handler code here
	this->OnCancel();
}


void OptionsDialog::OnBnClickedCadPathButton()
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CFolderPickerDialog outputLoc;
	int dialogReturn(outputLoc.DoModal());
	if (dialogReturn == IDOK) {
		this->m_cadDirectory = outputLoc.GetFolderPath();
		UpdateData(false);
	}
}

void OptionsDialog::LoadConfigFile()
{
	using boost::property_tree::ptree;
    ptree pt;

	Globals::Instance()->SettingsConfigPath = m_configPath;
	
	bool tmp = Globals::Instance()->PrepIFAB;
	// CyPhy2CAD_config.xml
	if(_access(m_configPath.c_str(), 0 ) != -1 )
	{
		read_xml(m_configPath, pt);

		SetOutputDirectory(pt.get<std::string>("config.outputdir"));
		SetCADDirectory(pt.get<std::string>("config.caddir"));
		SetUseProjectManifest(pt.get<int>("config.usemanifest"));

		if (!Globals::Instance()->PrepIFAB)
		{
			if (pt.get<bool>("config." + m_cAP203_Single))
				m_selected_step.insert(m_cAP203_Single);

			if (pt.get<bool>("config." + m_cAP203_E2_Single))
				m_selected_step.insert(m_cAP203_E2_Single);

			if (pt.get<bool>("config." + m_cAP203_E2_Seperate))
				m_selected_step.insert(m_cAP203_E2_Seperate);

			if (pt.get<bool>("config." + m_cAP214_Single))
				m_selected_step.insert(m_cAP214_Single);

			if (pt.get<bool>("config." + m_cAP214_Seperate))
				m_selected_step.insert(m_cAP214_Seperate);
		}
		else
			m_selected_step.insert(m_cAP203_E2_Seperate);
	}
	else
	{
		if (!Globals::Instance()->PrepIFAB)
		{
			m_selected_step.insert(m_cAP203_E2_Single);
			m_selected_step.insert(m_cAP203_E2_Seperate);
		}
		else
			m_selected_step.insert(m_cAP203_E2_Seperate);
	}

	if (Globals::Instance()->PrepIFAB)
		SetOutputDirectory(Globals::Instance()->CadXmlOutputDirectory);

	if (Globals::Instance()->Automation)
	{
		SetOutputDirectory(Globals::Instance()->CadXmlOutputDirectory);
		Globals::Instance()->CadArtifactDirectory = GetCADDirectory();
	}

	Globals::Instance()->UseManifest = GetUseProjectManifest();
	Globals::Instance()->m_selectedStepFormats = m_selected_step;

}

void OptionsDialog::SaveConfigFile()
{
	using boost::property_tree::ptree;
    ptree pt;

	// CyPhy2CAD_config.xml
	pt.put("config.outputdir", std::string(m_outputDirectory));
	pt.put("config.caddir", std::string(m_cadDirectory));
	pt.put("config.usemanifest", m_useProjManifest);

	std::set<std::string> tmp_step;
	for(int i=0; i<5; ++i)
	{
		if(m_stepList.GetCheck(i))
		{
			tmp_step.insert(m_stepFormats[i]);
			pt.put("config." + m_stepFormats[i], true);
		}
		else
		{
			pt.put("config." + m_stepFormats[i], false);
		}
	}

	write_xml(m_configPath, pt);

	Globals::Instance()->CadArtifactDirectory = GetCADDirectory();
	Globals::Instance()->CadXmlOutputDirectory = GetOutputDirectory();
	Globals::Instance()->m_selectedStepFormats = tmp_step;
	Globals::Instance()->UseManifest = GetUseProjectManifest();
}


#if 0		// TODO: Remove, not needed 6-21-2012
void OptionsDialog::OnCbnSelchangeProeCombo()
{
	// TODO: Add your control notification handler code here
	CString strSelected;
	int index = m_proeCombo.GetCurSel();

	if( index != CB_ERR )
	{
		this->m_proeCombo.GetLBText(index, strSelected);
		//this->m_proSelection = strSelected;
	}
	UpdateData(FALSE);
}
#endif
