/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#pragma once

#include "resource.h"
#include <string>
#include "afxcmn.h"
#include "afxdialogex.h"


/** \file
    \brief Dialog box that lets user select which CAD program to use for assembling:
	[1] Pro/Engineer or Creo
	[2] Generate for CAD or Manufacturing
	[3] Output folder to put the generated files
	[4] CAD working directory where CAD parts are located.
*/


// OptionsDialog dialog

class OptionsDialog : public CDialogEx
{
	DECLARE_DYNAMIC(OptionsDialog)

public:
	OptionsDialog(CWnd* pParent, const std::string& ProjectRootDir);   // standard constructor
	virtual ~OptionsDialog();

// Dialog Data
	enum { IDD = IDD_OPTIONS_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()

private:
	std::string m_projectRootDir;
	CString m_outputDirectory;
	CString m_cadDirectory;
	CListCtrl m_stepList;

	std::vector<std::string> m_stepFormats;
	std::set<std::string> m_selected_step;

	std::string m_configPath;

	const string m_cAP203_Single;
	const string m_cAP203_E2_Single;
	const string m_cAP203_E2_Seperate;
	const string m_cAP214_Single;
	const string m_cAP214_Seperate;

	int m_useProjManifest;

public:
	afx_msg void OnBnClickedOkButton();
	afx_msg void OnBnClickedPathButton();
	afx_msg void OnBnClickedCancelButton();
	afx_msg void OnBnClickedCadPathButton();


public:
	virtual BOOL OnInitDialog();

public:
	std::string GetOutputDirectory() {return std::string(m_outputDirectory);}
	void SetOutputDirectory(std::string outDirectory) {m_outputDirectory = outDirectory.c_str();}	
	std::string GetCADDirectory() {return (std::string)m_cadDirectory;}
	void SetCADDirectory(std::string directory) {m_cadDirectory = directory.c_str();}
	int GetUseProjectManifest() { return m_useProjManifest; }
	void SetUseProjectManifest(int use) { m_useProjManifest = use; }


private:
	void LoadConfigFile();
	void SaveConfigFile();

#if 0	// TODO: Remove, not needed 6-21-2012

	private:
	BOOL m_genCAD;
	BOOL m_genMAN;
	CString m_proSelection;
	CComboBox m_proeCombo;

public:
	afx_msg void OnCbnSelchangeProeCombo();

	bool GetGenerateCAD() 
	{
		if (m_genCAD == TRUE) 
			return 1;
		else
			return 0;
	}
	bool GetGenerateMAN() {
		if (m_genMAN == TRUE)
			return 1;
		else
			return 0;
	}

	//std::string GetProESelection() {return (std::string)m_proSelection;}
#endif


};
