/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// PartsDialog.cpp : implementation file
//

#include "stdafx.h"
#include "PartsDialog.h"
#include "afxdialogex.h"


#include "afxdlgs.h"
#include "string_utils.h"
#include "Logger.h"

// PartsDialog dialog

IMPLEMENT_DYNAMIC(PartsDialog, CDialogEx)

PartsDialog::PartsDialog(CWnd* pParent /*=NULL*/)
	: CDialogEx(PartsDialog::IDD, pParent),
	m_cadDirectory(_T(""))//,
{

}

PartsDialog::~PartsDialog()
{
}

void PartsDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_PATH, m_cadDirectory);
}


BEGIN_MESSAGE_MAP(PartsDialog, CDialogEx)
	ON_BN_CLICKED(IDOK, &PartsDialog::OnBnClickedOkButton)
	ON_BN_CLICKED(IDCANCEL, &PartsDialog::OnBnClickedCancelButton)
	ON_BN_CLICKED(IDC_DIR_BUTTON, &PartsDialog::OnBnClickedCadPathButton)

END_MESSAGE_MAP()

BOOL PartsDialog::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	return TRUE;
}

// PartsDialog message handlers


void PartsDialog::OnBnClickedOkButton()
{
	// TODO: Add your control notification handler code here
	this->UpdateData(1);
	this->OnOK();

}

void PartsDialog::OnBnClickedCancelButton()
{
	// TODO: Add your control notification handler code here
	this->OnCancel();
}


void PartsDialog::OnBnClickedCadPathButton()
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CFolderPickerDialog outputLoc;
	int dialogReturn(outputLoc.DoModal());
	if (dialogReturn == IDOK) {
		this->m_cadDirectory = outputLoc.GetFolderPath();
		UpdateData(false);
	}
}

