/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef RAWCOMPONENT_H
#define RAWCOMPONENT_H

#include "Mga.h"

#include <map>
#include "atlsafe.h"
#include "resource.h"

// Declaration of the main RAW COM component interface class


#ifdef BUILDER_OBJECT_NETWORK
#error   This file should only be included in the RAW COM configurations
#endif



class RawComponent {
////////////////////
// Insert your application specific member and method definitions here
public:
	std::map<std::string, _variant_t> componentParameters;
	std::string delimiter;

	void UpdateParameters();

	RawComponent() 
	{ 
		delimiter = ";\n";
		std::string Value = "";
		// initialize component parameters
		componentParameters.clear();
		//componentParameters["key"]            = _variant_t("value");
		componentParameters["name"]             = _variant_t("CAD interpreter");

		Value.erase();
		Value += "CAD desc\n";
		componentParameters["description"]      = _variant_t(Value.c_str());
		componentParameters["help"]             = _variant_t("Help string message. Usage: TBA...");
		componentParameters["console_messages"] = _variant_t("on");
		componentParameters["output_dir"]       = _variant_t(".\\");
		componentParameters["automation"]       = _variant_t("false");
		componentParameters["do_config"] = _variant_t("true");
		componentParameters["expanded"]         = _variant_t("false");
		componentParameters["runCommand"]       = _variant_t("");
		componentParameters["cadFile_dir"]       = _variant_t(".\\");
		componentParameters["labels"]       = _variant_t("Creo&&CADCreoParametricCreateAssembly.exev1.3");
		componentParameters["build_query"] = _variant_t("componentPackageRequestList");
		componentParameters["prepIFab"] = _variant_t("false");
		componentParameters["original_project_file"] = _variant_t("");
		componentParameters["results_zip_py"] = _variant_t(Result_Zip_Str().c_str());
	

		CComSafeArray<BSTR> safe;
		// list of all supported kinds
		safe.Add(CComBSTR(L"ComponentAssembly"));
		safe.Add(CComBSTR(L"CADTestBench"));
		safe.Add(CComBSTR(L"TestBench"));

		_variant_t pVal("");
		CComVariant(safe).Detach(&pVal);
		componentParameters["supports"]         = _variant_t(pVal);
	}

	string Result_Zip_Str();

private:
	
	
// Try not to modify the code below this line
////////////////////
public:	
#ifdef GME_ADDON
	CComPtr<IMgaProject> project;  // this is set before Initialize() is called
	CComPtr<IMgaAddOn> addon;      // this is set before Initialize() is called
#endif
	bool interactive;
	
	STDMETHODIMP Initialize(struct IMgaProject *);
	STDMETHODIMP Invoke(IMgaProject* gme, IMgaFCOs *models, long param);
	STDMETHODIMP InvokeEx( IMgaProject *project,  IMgaFCO *currentobj,  IMgaFCOs *selectedobjs,  long param);
	STDMETHODIMP ObjectsInvokeEx( IMgaProject *project,  IMgaObject *currentobj,  IMgaObjects *selectedobjs,  long param);
	STDMETHODIMP get_ComponentParameter(BSTR name, VARIANT *pVal);
	STDMETHODIMP put_ComponentParameter(BSTR name, VARIANT newVal);

#ifdef GME_ADDON
	STDMETHODIMP GlobalEvent(globalevent_enum event);
	STDMETHODIMP ObjectEvent(IMgaObject * obj, unsigned long eventmask, VARIANT v);
#endif
};


#endif //RAWCOMPONENT_H