/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "stdafx.h"
#include "afxdlgs.h"

#include <afxstr.h>
#include "UdmApp.h"
#include "UdmConfig.h"
#include "Uml.h"
#include "UdmUtil.h"


#include "CyPhyML.h"
#include "CyPhy2CADHelper.h"
#include "UdmConsole.h"
#include "..\CyPhyToolbox\CyPhyToolbox.h"
#include "OptionsDialog.h"
#include "PartsDialog.h"
#include "CommonHelper.h"
#include "Logger.h"
#include "UdmFormatter.h"
#include <boost/property_tree/exceptions.hpp>


string CUdmApp::szConnString;

/*********************************************************************************/
/* Initialization function. The framework calls it before preparing the backend. */
/* Initialize here the settings in the config global object.					 */
/* Return 0 if successful.														 */
/*********************************************************************************/
int CUdmApp::Initialize()
{


	// TODO: Your initialization code comes here...
	return 0;
}



/* 
Remarks to CUdmApp::UdmMain(...):
0.	The p_backend points to an already open backend, and the framework 
	closes it automatically. DO NOT OPEN OR CLOSE IT!
	To commit changes use p_backend->CommitEditSequence().
	To abort changes use p_backend->AbortEditSequence().
	To save changes to a different file use p_backend->SaveAs() or p_backend->CloseAs().

1.	Focus is the currently open model.

2.	The possible values for param (from GME DecoratorLib.h component_startmode_enum):
	GME_MAIN_START			=   0,
	GME_BROWSER_START		=   1,
	GME_CONTEXT_START		=   2,
	GME_EMBEDDED_START		=   3,
	GME_MENU_START			=  16,
	GME_BGCONTEXT_START		=  18,
	GME_ICON_START			=  32,
	METAMODEL_CHECK_SYNTAX	= 101

 3. The framework catches all the exceptions and reports the error in a message box,
	clean up and close the transactions aborting the changes. You can override this 
	behavior by catching udm_exception. Use udm_exception::what() to form an error 
	message.
*/

/***********************************************/
/* Main entry point for Udm-based Interpreter  */
/***********************************************/

void CUdmApp::UdmMain(
					 Udm::DataNetwork* p_backend,		// Backend pointer(already open!)
					 Udm::Object focusObject,			// Focus object
					 set<Udm::Object> selectedObjects,	// Selected objects
					 long param)						// Parameters
{	

	// TODO: Your Code Comes Here...
	try 
	{
		bool Automation = Globals::Instance()->Automation;
		bool Expanded =  Globals::Instance()->PrepIFAB;

		if (Globals::Instance()->ProjectRootDir == "")
		{
			string ProjectRootDir = CUdmApp::szConnString.substr(string("MGA=").length()).substr(0,CUdmApp::szConnString.find_last_of('\\') - string("MGA=").length() + 1);
			Globals::Instance()->ProjectRootDir = ProjectRootDir;
		}

		if (focusObject != Udm::null)
			selectedObjects.insert(focusObject);

		if (selectedObjects.size() > 0)
		{
			OptionsDialog optionsDlg = OptionsDialog(NULL, Globals::Instance()->ProjectRootDir);
			if (!(Globals::Instance()->Automation && !Globals::Instance()->DoConfig))
			{
				if(optionsDlg.DoModal() != IDOK) 	//quit if user cancels
				{
					GMEConsole::Console::writeLine("User Cancelled operation!", MSG_INFO);
					return;
				}
			}

			Globals::Instance()->CreateFolder(Globals::Instance()->CadXmlOutputDirectory);
			Globals::Instance()->DebugLogDirectory = Globals::Instance()->CadXmlOutputDirectory + "\\log";
			Globals::Instance()->CreateFolder(Globals::Instance()->DebugLogDirectory);


			for(set<Udm::Object>::iterator i=selectedObjects.begin();i!=selectedObjects.end();++i)
			{			
				CyPhyElaborate elaborator;
				Uml::Class selectedType = i->type();
				if(selectedType == CyPhyML::ComponentAssembly::meta)
				{
					CyPhyML::ComponentAssembly assembly;

					if (Expanded == false)		
					{
						// manually elaborate
						assembly = elaborator.elaborate(CyPhyML::ComponentAssembly::Cast(*i));
						GMEConsole::Console::writeLine("Elaborating model ..", MSG_INFO);
					}
					else
					{
						// simply cast since it will already have been elaborated before calling InvokeEx
						assembly = CyPhyML::ComponentAssembly::Cast(*i);
					}

					// FIXME: reenable after language changes
					CyPhy2CADHelper helper;
					helper.GenerateCADFile(assembly); //helper.GenerateCADFile(assembly, rf, id); 


					// ARN 9/11 - If standalone, we will close with no changes instead of collapsing
					// DY: 9/28/2012
					//if (Automation && Expanded == false)		// manually collapse
					if (Expanded == false)		// manually collapse
					{
						elaborator.collapse(assembly);
					}
				}
				else if (selectedType == CyPhyML::CADTestBench::meta)
				{
					CyPhyML::CADTestBench testBench;

					if (Expanded == false)
					{
						testBench = CyPhyML::CADTestBench::Cast(elaborator.elaborate(CyPhyML::CADTestBench::Cast(*i)));
						GMEConsole::Console::writeLine("Elaborating model ..", MSG_INFO);
					}
					else
					{
						testBench = CyPhyML::CADTestBench::Cast(*i);
					}

					// FIXME: reenable after language changes
					CyPhy2CADHelper helper;
					helper.GenerateCADFile(testBench); 

					// DY: 9/28/2012
					if (Expanded == false)		//if (Automation && Expanded == false)
					{
						elaborator.collapse(testBench);
					}
				}
				else if (selectedType == CyPhyML::TestBench::meta)
				{
					CyPhyML::TestBench testBench;
					if (Expanded == false)
					{
						testBench = CyPhyML::TestBench::Cast(elaborator.elaborate(CyPhyML::TestBench::Cast(*i)));
					}
					else
					{
						testBench = CyPhyML::TestBench::Cast(*i);
					}
					string tmp2 = Globals::Instance()->CadArtifactDirectory;
					// FIXME: reenable after language changes
					CyPhy2CADHelper helper;
					helper.GenerateCADFile(testBench); 

					// DY: 9/28/2012
					if (Expanded == false)		//if (Automation && Expanded == false)		// manually collapse
					{
						elaborator.collapse(testBench);
					}
				}
				else
					GMEConsole::Console::writeLine("CyPhy2CAD only runs on test benches and component assemblies, try again.", MSG_WARNING);
			}

		}

	}
	catch (udm_exception &exc)
	{
		GMEConsole::Console::writeLine("Udm exception occured! Exception description: " + (std::string)exc.what(), MSG_ERROR);
	}
	catch(const boost::property_tree::ptree_error &exc)
	{
		string message = "Parsing exception for option settings config file: " + string(exc.what());
		GMEConsole::Console::writeLine(message, MSG_ERROR);
		GMEConsole::Console::writeLine("Please remove settings config file first then try again: " + Globals::Instance()->SettingsConfigPath, MSG_ERROR);
	}
	catch (std::exception const&  exc)
	{
		GMEConsole::Console::writeLine(exc.what(), MSG_ERROR);
	}


/************************** Demo Code - Delete It *********************/
	// Welcome
	//AfxMessageBox("Hello Udm-based Interpreter World!");

#if 0

#ifdef _DEBUG
	// Displaying the name of the root object meta
	Udm::Object rootObject=p_backend->GetRootObject();
	string rootObjectName("Root Object's Class Name: ");
	rootObjectName+=UdmUtil::ExtractName(rootObject.type());
//	AfxMessageBox(rootObjectName.c_str());

	// Displaying the focus object
	if(focusObject!=&Udm::_null)
	{
		string focusObjectName("Focus Object Name: ");
		focusObjectName+=UdmUtil::ExtractName(focusObject);
//		AfxMessageBox(focusObjectName.c_str());
	}

	// Displaying selected objects
	if(!selectedObjects.empty())
	{
		string selObjNames("Selected Objects:\r\n");
		// Iterate set
		for(set<Udm::Object>::iterator i=selectedObjects.begin();
														i!=selectedObjects.end();i++)
		{
			selObjNames+=UdmUtil::ExtractName(*i);
			selObjNames+="\r\n";
		}
//		AfxMessageBox(selObjNames.c_str());	
	}
#endif
#endif	
/****************************** Demo Code End *************************/
												
}

