/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using GME.MGA;
using GME.MGA.Core;
using GME.MGA.Parser;
using ISIS.GME.Common.Interfaces;

// using domain specific interfaces
using CyPhyML = ISIS.GME.Dsml.CyPhyML.Interfaces;
using CyPhyMLClasses = ISIS.GME.Dsml.CyPhyML.Classes;

namespace CyPhy2ComponentModel {

    public static class Convert {

        public static CyPhyML.Component AVMComponent2CyPhyML(CyPhyML.ComponentAssembly cyPhyMLComponentParent, AVM.Component avmComponent, Dictionary<string, CyPhyML.Component> avmidComponentMap, bool resetUnitLib = true, object messageConsole = null) {
            CyPhyML.Component c_rtn = AVM2CyPhyML.CyPhyMLComponentBuilder.AVM2CyPhymL(cyPhyMLComponentParent, avmComponent, avmidComponentMap, resetUnitLib, messageConsole);
            CyPhyComponentAutoLayout.LayoutComponent( c_rtn );
            return c_rtn;
        }

        public static CyPhyML.Component AVMComponent2CyPhyML(CyPhyML.Components cyPhyMLComponentParent, AVM.Component avmComponent, Dictionary<string, CyPhyML.Component> avmidComponentMap, bool resetUnitLib = true, object messageConsole = null)
        {
            CyPhyML.Component c_rtn = AVM2CyPhyML.CyPhyMLComponentBuilder.AVM2CyPhymL(cyPhyMLComponentParent, avmComponent, avmidComponentMap, resetUnitLib, messageConsole);
             CyPhyComponentAutoLayout.LayoutComponent(c_rtn);
             return c_rtn;
         }

        public static AVM.Component CyPhyML2AVMComponent( CyPhyML.Component cyPhyMLComponent ) {
            return CyPhyML2AVM.AVMComponentBuilder.CyPhyML2AVM(cyPhyMLComponent);
        }

    }
}
