/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
namespace GME.CSharp
{
    using System;
    using System.Runtime.InteropServices;
    using GME.MGA;
    using GME.Util;

    /// <summary>
    /// Contains the configuration information.
    /// </summary>
    public abstract class ComponentConfig
    {
        /// <summary>
        /// Set paradigm name. Provide * if you want to register it for all paradigms.
        /// </summary>
        public const string ParadigmName = "CyPhyML";

        /// <summary>
        /// Set the human readable name of the interpreter. You can use white space characters.
        /// </summary>
        public const string ComponentName = "CyPhy2Modelica";

        /// <summary>
        /// Specify an icon path
        /// </summary>
        public const string IconName = "CyPhy2Modelica.ico";

        /// <summary>
        /// Registration mode
        /// </summary>
        public const regaccessmode_enum RegistrationMode = regaccessmode_enum.REGACCESS_SYSTEM;

        /// <summary>
        /// Program identifier
        /// </summary>
        public const string ProgID = "MGA.Interpreter.CyPhy2Modelica";

        /// <summary>
        /// Unique identifier
        /// </summary>
        public const string Guid = "65A16478-60B5-4638-9A08-C3AEA2E67C2A";
        
        /// <summary>
        /// Uncomment the flag if your component is paradigm independent.
        /// </summary>
        private static componenttype_enum componentType = componenttype_enum.COMPONENTTYPE_INTERPRETER;

        /// <summary>
        /// Gets or sets the path to the icon.
        /// If null, updated with the assembly path + the iconName dynamically on registration
        /// </summary>
        public static string IconPath { get; set; }

        /// <summary>
        /// Gets or sets the registration type
        /// Uncomment the flag if your component is paradigm independent.
        /// </summary>
        public static componenttype_enum ComponentType
        {
            get { return componentType; }
            set { componentType = value; }
        }
    }
}
