/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// using generic common interface
using Common = ISIS.GME.Common;

// using domain specific interfaces
using CyPhy = ISIS.GME.Dsml.CyPhyML.Interfaces;
using CyPhyClasses = ISIS.GME.Dsml.CyPhyML.Classes;

using CyPhy2Modelica.Modelica;

namespace CyPhy2Modelica
{
    public static class Generator
    {
        public static string TruncateLongString(this string str, int maxLength)
        {
            return str.Substring(0, Math.Min(str.Length, maxLength));
        }

        public static void Build(
            IEnumerable<CyPhy.Port> ports,
            Modelica.Model parent)
        {
            foreach (var item in ports)
            {
                if (item is CyPhy.PowerPortType == false)
                {
                    if (Factory.Library.ContainsKey(item.GetType()))
                    {
                        Modelica.Component cp = new Modelica.Component(item)
                        {
                            LibraryName = Factory.Library[item.GetType()],
                            Name = item.Name,
                        };
                        parent.Components.Add(cp);
                    }
                    else
                    {
                        GenerateModelicaModel.Messages.Add(
                            new GmeMessage(
                                "Type is not supported yet: " + item.Kind,
                                GmeMessage.Severity_enum.Warning));
                    }
                }
            }
        }

        public static void Build(
            IEnumerable<CyPhy.LocalSignal> localSignals,
            Modelica.Model parent)
        {
            foreach (var item in localSignals)
            {
                if (Factory.Library.ContainsKey(item.GetType()))
                {
                    Modelica.Component cp = new Modelica.Component(item)
                    {
                        LibraryName = Factory.Library[item.GetType()],
                        Name = item.Name,
                    };
                    parent.Components.Add(cp);
                }
                else
                {
                    GenerateModelicaModel.Messages.Add(
                        new GmeMessage(
                            "Type is not supported yet: " + item.Kind,
                            GmeMessage.Severity_enum.Warning));
                }
            }
        }

        public static void Build(
            IEnumerable<CyPhy.ExtendedElements> extendedElements,
            Modelica.Model parent)
        {
            foreach (var item in extendedElements)
            {
                if (Factory.Library.ContainsKey(item.GetType()))
                {
                    Modelica.Component cp = new Modelica.Component(item)
                    {
                        LibraryName = Factory.Library[item.GetType()],
                        Name = item.Name,
                    };
                    parent.Components.Add(cp);
                }
                else if (item is CyPhy.Modulation)
                {
                    // handled as an inline function
                }
                else if (item is CyPhy.ControlFunction)
                {
                    Modelica.Component cp = new Modelica.Component(item)
                    {
                        LibraryName = item.Name + Factory.ModelTypeSuffix,
                        Name = item.Name,
                    };
                    parent.Components.Add(cp);
                }
                else
                {
                    GenerateModelicaModel.Messages.Add(
                        new GmeMessage(
                            "Type is not supported yet: " + item.Kind,
                            GmeMessage.Severity_enum.Warning));
                }
            }
        }

        public static void Build(
            IEnumerable<CyPhy.ValueFlowTarget> valueFlowTargets,
            Modelica.Model parent)
        {
            foreach (var item in valueFlowTargets)
            {
                if (Factory.Library.ContainsKey(item.GetType()))
                {
                    Modelica.Component cp = new Modelica.Component(item)
                    {
                        LibraryName = Factory.Library[item.GetType()],
                        Name = item.Name,
                    };
                    parent.Components.Add(cp);

                    if (item is CyPhy.Parameter)
                    {
                        if (string.IsNullOrEmpty((item as CyPhy.Parameter).Attributes.Value))
                        {
                            cp.Parameters.Add("ParameterValue", "0");
                            GenerateModelicaModel.Messages.Add(
                                new GmeMessage(
                                    "Parameter Value is not given using 0: " + item.ToHyperLink(),
                                    GmeMessage.Severity_enum.Warning));
                        }
                        else
                        {
                            cp.Parameters.Add("ParameterValue", (item as CyPhy.Parameter).Attributes.Value);
                        }
                    }
                    else if (item is CyPhy.Property)
                    {
                        if (string.IsNullOrEmpty((item as CyPhy.Property).Attributes.Value))
                        {
                            cp.Parameters.Add("ParameterValue", "0");
                            GenerateModelicaModel.Messages.Add(
                                new GmeMessage(
                                    "Parameter Value is not given using 0: " + item.ToHyperLink(),
                                    GmeMessage.Severity_enum.Warning));
                        }
                        else
                        {
                            cp.Parameters.Add("ParameterValue", (item as CyPhy.Property).Attributes.Value);
                        }
                    }
                }
                else
                {
                    GenerateModelicaModel.Messages.Add(
                        new GmeMessage(
                            "Type is not supported yet: " + item.Kind,
                            GmeMessage.Severity_enum.Warning));
                }
            }
        }

    }
}
