/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace CyPhy2Modelica.Modelica
{
    public class Connection
    {
        /// <summary>
        /// Source port of this connection
        /// </summary>
        public Port Src { get; set; }

        /// <summary>
        /// Destination port of this connection
        /// </summary>
        public Port Dst { get; set; }


        public void Write(System.CodeDom.Compiler.IndentedTextWriter writer)
        {
            try
            {
                // NOTE: we will not implement an autorouter for modelica
                string linePoints = "annotation(Line(points = {{0.0,0.0},{0.1,0.1}}))";
                
                string srcPortName = string.IsNullOrEmpty(Src.Name) ?
                    "" :
                    "." + Src.Name;

                string dstPortName = string.IsNullOrEmpty(Dst.Name) ?
                    "" :
                    "." + Dst.Name;

                if (Src.PortType == Factory.PortType.Power ||
                    Dst.PortType == Factory.PortType.Power)
                {
                    // This is needed in order to support OM18
                    // for Bond type of connections only
                    writer.WriteLine(
                        " " +
                        Src.Parent.Name + srcPortName + ".E = " +
                        Dst.Parent.Name + dstPortName + ".E;");
                    writer.WriteLine(
                        " " +
                        Src.Parent.Name + srcPortName + ".F = " +
                        Dst.Parent.Name + dstPortName + ".F;");
                }
                else if (Src.PortType == Factory.PortType.Signal ||
                    Dst.PortType == Factory.PortType.Signal)
                {
                    string srcParentName = Src.Parent.SpecialName;
                    string dstParentName = Dst.Parent.SpecialName;

                    if (Dst.Impl is ISIS.GME.Dsml.CyPhyML.Interfaces.Metric)
                    {
                        var m = Dst.Impl as ISIS.GME.Dsml.CyPhyML.Interfaces.Metric;
                        if (m.SrcConnections.ValueFlowCollection.Count() +
                            m.SrcConnections.Signal2MetricCollection.Count() +
                            m.SrcConnections.ModelicaSignal2MetricCollection.Count() != 1)
                        {
                            return;
                        }
                    }

                    writer.WriteLine(
                        " " +
                        srcParentName + srcPortName + " = " +
                        dstParentName + dstPortName + "; ");
                }
                else
                {
                    string srcParentName = Src.Parent.SpecialName;
                    string dstParentName = Dst.Parent.SpecialName;

                    writer.WriteLine(
                        " connect(" +
                        srcParentName + srcPortName + ", " +
                        dstParentName + dstPortName + ") " +
                        linePoints + ";");
                }
            }
            catch (Exception ex)
            {
                writer.WriteLine("/*connection " + Src.Name + " -> " + Dst.Name + " */");
                System.Diagnostics.Debug.WriteLine(ex.Message);
            }
        }
    }
}
