/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Web.UI;

using Common = ISIS.GME.Common;

using CyPhy = ISIS.GME.Dsml.CyPhyML;

namespace CyPhy2Modelica.Modelica
{
	public class Documentation
	{
		public const string cssPanel = "panel";
		public const string cssPanelPlots = cssPanel + " plots";
		public const string cssPanelTitle = cssPanel + " title";
		public const string cssPanelContent = cssPanel + " content";
		public const string cssPanelGraph = cssPanel + " graph";
		public const string cssPanelTab = cssPanel + " tabs";
		
		public const string JavaScriptDir = "js/";
		public const string GraphsDir = "graphs/";
		public const string PlotsDir = "plots/";
		public const string PanelsDir = "panels/";
		public const string CssDir = "css/";

		public const string GraphsExtension = ".js";

		public static string GetDocPanelBase(Modelica.Model model, int indent = 0)
		{
			StringWriter stringWriter = new StringWriter();

			using (HtmlTextWriter writer = new HtmlTextWriter(stringWriter))
			{
				writer.Indent = indent;

				writer.WriteLine("<div class=\"" + cssPanel + "\">");
				writer.WriteLine("<div class=\"" + cssPanelTitle + "\">" + model.Name);
				if (model.HasScope())
				{
					writer.Write(" [has scope]");
				}
				writer.WriteLine("</div>");
				writer.WriteLine("<div class=\"" + cssPanelGraph + "\"><a href=\""
					+ GraphsDir + model.Impl.ID + GraphsExtension + "\">Reload graph...</a></div>");
				writer.WriteLine("<div class=\"" + cssPanelContent + "\">");

				foreach (var item in model.Models)
				{
					writer.WriteLine("<a href=\"" + item.Impl.ID + ".html\"><p>" + item.Name);
					if (item.HasScope())
					{
						writer.Write(" [has scope]");
					}
					writer.WriteLine("</p></a>");
				}

				// print those components, which are not models
				foreach (var item in model.Components.Where(
					x => model.Models.Select(y => y.Impl.ID).Contains(x.Impl.ID) == false))
				{
					string description = "";
					if (item.Impl is Common.Interfaces.Model)
					{
						description = (item.Impl as Common.Interfaces.Model).Preferences.Description;
					}
					else if (item.Impl is Common.Interfaces.Atom)
					{
						description = (item.Impl as Common.Interfaces.Atom).Preferences.Description;
					}
					else if (item.Impl is Common.Interfaces.Reference)
					{
						description = (item.Impl as Common.Interfaces.Reference).Preferences.Description;
					}
					else if (item.Impl is Common.Interfaces.Set)
					{
						description = (item.Impl as Common.Interfaces.Set).Preferences.Description;
					}
					if (item.Impl is CyPhy.Interfaces.Monitor ||
						string.IsNullOrEmpty(description) == false)
					{
						writer.WriteLine("<p class=\"elementName\">" + item.Name + "</p>");
						if (string.IsNullOrEmpty(description) == false)
						{
							writer.WriteLine("<p class=\"elementDescription\">" + description + "</p>");
						}
						if (item.Impl is CyPhy.Interfaces.Monitor)
						{
							writer.WriteLine("<div id=\"plotGUI\" class=\"panel plots\" href=\"" + PlotsDir + item.Impl.ID + ".js\" title=\"" + item.Impl.Name + "\">P L O T, Click to refresh...</div>");
						}
					}
				}
				writer.WriteLine("</div>");
				writer.WriteLine("<div id=\"sub\" class=\"panel\" hidden=\"true\"></div>");
				writer.WriteLine("</div>");

			}
			return stringWriter.ToString();
		}

		public static string GetDocMainPanel(Modelica.Model model, int indent)
		{
			StringWriter stringWriter = new StringWriter();

			using (HtmlTextWriter writer = new HtmlTextWriter(stringWriter))
			{
				writer.Indent = indent;
				writer.WriteLine("<!-- Main panel -->");

				writer.WriteLine("<div class=\"" + cssPanel + "\">");

				writer.WriteLine("<div class=\"" + cssPanelTitle + "\">" + model.Name);
				if (model.HasScope())
				{
					writer.Write(" [has scope]");
				}
				writer.WriteLine("</div>");

				writer.WriteLine("<div class=\"" + cssPanelGraph + "\"><a href=\"" + GraphsDir + model.Impl.ID + GraphsExtension + "\">Reload graph...</a></div>");
				writer.WriteLine("<div class=\"" + cssPanelContent + "\">");

				foreach (var item in model.Models)
				{
					writer.WriteLine("<a href=\"" + item.Impl.ID + ".html\"><p>" + item.Name + "</p></a>");
				}

				// print those components, which are not models
				foreach (var item in model.Components.Where(
					x => model.Models.Select(y => y.Impl.ID).Contains(x.Impl.ID) == false))
				{
					string description = "";
					if (item.Impl is Common.Interfaces.Model)
					{
						description = (item.Impl as Common.Interfaces.Model).Preferences.Description;
					}
					else if (item.Impl is Common.Interfaces.Atom)
					{
						description = (item.Impl as Common.Interfaces.Atom).Preferences.Description;
					}
					else if (item.Impl is Common.Interfaces.Reference)
					{
						description = (item.Impl as Common.Interfaces.Reference).Preferences.Description;
					}
					else if (item.Impl is Common.Interfaces.Set)
					{
						description = (item.Impl as Common.Interfaces.Set).Preferences.Description;
					}
					if (item.Impl is CyPhy.Interfaces.Monitor ||
						string.IsNullOrEmpty(description) == false)
					{
						writer.WriteLine("<p class=\"elementName\">" + item.Name + "</p>");
						if (string.IsNullOrEmpty(description) == false)
						{
							writer.WriteLine("<p class=\"elementDescription\">" + description + "</p>");
						}
						if (item.Impl is CyPhy.Interfaces.Monitor)
						{
							writer.WriteLine("<div id=\"plotGUI\" class=\"panel plots\" href=\"" + PlotsDir + item.Impl.ID + ".js\" title=\"" + item.Impl.Name + "\">P L O T, Click to refresh...</div>");
						}
					}
				}
				writer.WriteLine("</div>");
				writer.WriteLine("</div>");

				writer.WriteLine("<!-- Tab panel -->");
				writer.WriteLine("<div class=\"" + cssPanel + "\">");
				writer.WriteLine("<div id=\"tabs\" class=\"" + cssPanelTab + "\">");
				writer.WriteLine("<ul>");

				foreach (var item in model.Models)
				{
					writer.WriteLine("<li><a href=\"" + PanelsDir + item.Impl.ID + ".html\">" + item.Name);
					if (item.HasScope())
					{
						writer.WriteLine(" [has scope]");
					}

					writer.WriteLine("</a></li>");
				}

				writer.WriteLine("</ul>");
				writer.WriteLine("</div>");
				writer.WriteLine("</div>");

				// TODO: remove this
				foreach (var item in model.Models)
				{
					//writer.WriteLine(GetDocMainPanel(item, writer.Indent));
				}
			}
			return stringWriter.ToString();
		}
	}
}
