/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿// -----------------------------------------------------------------------
// <copyright file="ParametersClass.cs" company="">
// TODO: Update copyright text.
// </copyright>
// -----------------------------------------------------------------------

namespace CyPhy2Modelica
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using GME.MGA;

    /// <summary>
    /// TODO: Update summary.
    /// </summary>
    public class ParametersClass
    {
        private IMgaComponentEx Interpreter { get; set; }

        public string SimulationTargetTool
        {
            get { return GetStringParameter("simulationTargetTool"); }
            set { SetStringParameter("simulationTargetTool", value); }
        }

        public string Labels
        {
            get { return GetStringParameter("labels"); }
            set { SetStringParameter("labels", value); }
        }

        public string RunCommand
        {
            get { return GetStringParameter("runCommand"); }
            set { SetStringParameter("runCommand", value); }
        }

        public string OutputDir
        {
            get { return GetStringParameter("output_dir"); }
            set { SetStringParameter("output_dir", value); }
        }

        public string PackageName
        {
            get { return GetStringParameter("package_name"); }
            set { SetStringParameter("package_name", value); }
        }

        public string Configuration
        {
            get { return GetStringParameter("configuration"); }
            set { SetStringParameter("configuration", value); }
        }

        public string Automation
        {
            get { return GetStringParameter("automation"); }
            set { SetStringParameter("automation", value); }
        }

        public string TestBench
        {
            get { return GetStringParameter("TestBench"); }
            set { SetStringParameter("TestBench", value); }
        }

        public string TestBenchUniqueName
        {
            get { return GetStringParameter("TestBenchUniqueName"); }
            set { SetStringParameter("TestBenchUniqueName", value); }
        }

        public string TestBenchName
        {
            get { return GetStringParameter("test_bench_name"); }
            set { SetStringParameter("test_bench_name", value); }
        }

        public string ShowSettingsOnly
        {
            get { return GetStringParameter("show_settings_only"); }
            set { SetStringParameter("show_settings_only", value); }
        }

        public string ConsoleMessages
        {
            get { return GetStringParameter("console_messages"); }
            set { SetStringParameter("console_messages", value); }
        }

        public string DesignName
        {
            get { return GetStringParameter("DesignName"); }
            set { SetStringParameter("DesignName", value); }
        }

        public string OriginalProjectFile
        {
            get { return GetStringParameter("original_project_file"); }
            set { SetStringParameter("original_project_file", value); }
        }
        

        public ParametersClass(IMgaComponentEx interpreter)
        {
            this.Interpreter = interpreter;

            this.SimulationTargetTool = "OpenModelica";
            this.Labels = "OpenModelica && py_modelica12.08";
            this.RunCommand = "om_simulate.py";
            this.OutputDir = string.Empty;
            this.PackageName = string.Empty;
            this.Automation = "false";
            this.Configuration = string.Empty;
            this.TestBench = string.Empty;
            this.TestBenchUniqueName = string.Empty;
            this.TestBenchName = string.Empty;
            this.ShowSettingsOnly = "false";
            this.ConsoleMessages = "on";
            this.OriginalProjectFile = string.Empty;
        }

        private string GetStringParameter(string name)
        {
            return this.Interpreter.ComponentParameter[name] as string;
        }

        private void SetStringParameter(string name, string value)
        {
            this.Interpreter.ComponentParameter[name] = value;
        }
    }
}
