from scipy.io import loadmat
import numpy as np
import json
import os
import sys


#
#  limits:
#    component:limitA_min

#############################################
# interpreter: 
#############################################
#  Visit all components
#     for all limits in component
#     ** Generate file with all limit names, max or min and values
#          [name; min; max]
#          write out signal name - FULL hierarchy path found in *.mat file 
#
#
# in Matlab: load *.mat;  name(1:262,1:23700)';  grep for names
# 

#############################################
#  PYTHON:
#############################################
#  load mat file
#  load limit file  2-d file of [name; min; max]
#    itr through all limits
#    if limits['Name'] in result_mat[0]:
#   
#  **** write out to what??????
#
#


def load_mat(datafile, expand_param_data=True):
    data = loadmat(datafile, matlab_compatible=True)
    
    names = data['name'].transpose()
    descrips = data['description'].transpose()
    
    data_loc = data['dataInfo'][0]
    data_sign = np.sign(data['dataInfo'][1])
    data_col = np.abs(data['dataInfo'][1]) - 1
    
    num_time_pts = data['data_2'][0].shape[0]
    
    data_dict = {}
    desc_dict = {}
    
    for i in xrange(names.shape[0]):
        
        name = ''.join([str(e) for e in names[i]]).rstrip()
        
        if name == 'Time':
            name = 'time'
        
        descrip = ''.join([str(e) for e in descrips[i]]).rstrip()
        
        desc_dict[name] = descrip
        
        if data_loc[i] == 1:
            if expand_param_data:
                data_dict[name] = (np.ones(num_time_pts) * 
                                   data['data_1'][data_col[i]][0] * data_sign[i])
            else:
                data_dict[name] = data['data_1'][data_col[i]] * data_sign[i]
        else:
            data_dict[name] = data['data_2'][data_col[i]] * data_sign[i]
    
    return data_dict, desc_dict

    
    
def main():
    if not os.path.exists('summary.testresults.json'):
        print 'File does not exist: summary.testresults.json'
        os.exit(0)
        
    if (len(sys.argv) > 1):
        if not os.path.exists(sys.argv[1]):
            print 'Given result file does not exist: {0}'.format(sys.argv[1])
            os.exit(0)
        
        # file exists
        result_mat = load_mat(sys.argv[1])
        result_json = {}

        # read current limit file, which contains the metrics
        with open('limits.json','r') as file_in:
            limits_json = json.load(file_in)
        
        if 'LimitChecks' in limits_json:
            for checkval in limits_json['LimitChecks']:
                if 'VariableFullPath' in checkval and 'Maximum' in checkval['Attributes'] and 'Minimum' in checkval['Attributes']:
					print checkval['VariableFullPath']
					print checkval['VariableName']
					print checkval['LimitName']
					print checkval['Attributes']
					min = checkval['Attributes']['Minimum']
					max = checkval['Attributes']['Maximum']
					print min
					print max
					if checkval['LimitName'] in result_mat[0]:
					#if 'MaxSpeed' in result_mat[0]:
						val = float(str(result_mat[0][checkval['LimitName']][-1]))
						if val < min or val > max:
							checkval['LimitExceeded'] = 'true'
							print 'Limit Exceeded'
						else:
							checkval['LimitExceeded'] = 'false'
							print 'Signal within limit'
					else:
						# metric was not found in results
						pass
                else:
                    # create warning message
                    pass
            # update json file with the new values
            with open('limits.json','wb') as file_out:
                json.dump(limits_json, file_out)

        else:
            # create warning message
            pass
    else:
        print 'First argument must be a .mat result file.'
    

if __name__ == '__main__':
    main()

