package ISIS
extends Modelica.Icons.Package;
  package Types
    extends Modelica.Icons.Package;
    type Effort = Real(final quantity = "Effort") "Generic Effort quantity.";
    type Flow = Real(final quantity = "Flow") "Generic Flow quantity.";
    type Voltage = Real(final quantity = "Voltage")
      "Electrical effort: Voltage";
    type Current = Real(final quantity = "Current") "Electrical flow: Current.";
    type Torque = Real(final quantity = "Torque")
      "Mechanical rotation effort: Torque";
    type RotationalVelocity = Real(final quantity = "Rotational velocity")
      "Mechanical rotation flow: Rotational velocity";
    type Force = Real(final quantity = "Force")
      "Mechanical translation effort: Force";
    type Velocity = Real(final quantity = "Velocity")
      "Mechanical translation flow: Velocity";
    type Pressure = Real(final quantity = "Presure")
      "Hydraulic effort: Pressure";
    type VolumeFlowRate = Real(final quantity = "VolumeFlowRate")
      "Hydraulic flow: Volume flow rate";
    type SimpleSignal = Real(final quantity = "Signal") "A signal.";
    type BooleanSignal = Boolean(final quantity = "Boolean Signal")
      "A signal that only has boolean values.";
  end Types;

  package Ports
    extends Modelica.Icons.Package;
    model LibPowerPort
      ISIS.Types.Effort E;
      ISIS.Types.Flow F;
      // flow Real dummy1;
      // flow Real dummy2;
      annotation(defaultComponentName = "powerPort", Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100,-100},{100,100}}), graphics={  Rectangle(extent=  {{-100,100},{100,-100}}, lineColor=  {0,0,0}, fillColor=  {0,0,0},
                fillPattern=                                                                                                    FillPattern.Solid)}), Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100,-100},{100,100}}), graphics={  Rectangle(extent=  {{-40,40},{40,-40}}, lineColor=  {0,0,0}, fillColor=  {0,0,0},
                fillPattern=                                                                                                    FillPattern.Solid),Text(extent={{
                  -154,102},{162,42}},                                                                                                   lineColor=  {0,0,0}, textString=  "%name")}));
    end LibPowerPort;

    model LibSignalConnector
    //connector LibSignalConnector
      ISIS.Types.SimpleSignal SignalValue;
      // flow Real dummy;
    end LibSignalConnector;

    //connector LibBoolSignalPort
    model LibBoolSignalPort
      ISIS.Types.BooleanSignal SignalValue;
    end LibBoolSignalPort;

    model LibElectricalPowerPort

      Modelica.Electrical.Analog.Interfaces.Pin Port annotation(Placement(visible = true, transformation(origin={-44.7769,
                9.9315},                                                                                                    extent = {{-12,-12},{12,12}}, rotation = 0), iconTransformation(origin={-44.7769,
                9.9315},                                                                                                    extent = {{-12,-12},{12,12}}, rotation = 0)));
      ISIS.Ports.LibPowerPort Port1 annotation(Placement(visible = true, transformation(origin={45.9976,
                10.0142},                                                                                                 extent = {{-12,-12},{12,12}}, rotation = 0), iconTransformation(origin={45.9976,
                10.0142},                                                                                                   extent = {{-12,-12},{12,12}}, rotation = 0)));
    equation
      Port1.E = Port.v;
      Port1.F = Port.i;
    end LibElectricalPowerPort;

    model LibMechanicalRotationPowerPort
      Modelica.Mechanics.Rotational.Interfaces.Flange_a Port;
      ISIS.Ports.LibPowerPort Port1;
    equation
      Port1.E = Port.tau;
      Port1.F = der(Port.phi);
    end LibMechanicalRotationPowerPort;

    model LibMechanicalTranslationPowerPort
      Modelica.Mechanics.Translational.Interfaces.Flange_a Port;
      ISIS.Ports.LibPowerPort Port1;
    equation
      Port1.E = Port.f;
      Port1.F = der(Port.s);
    end LibMechanicalTranslationPowerPort;

    model LibHydraulicPowerPort
      Modelica.Fluid.Interfaces.FluidPort Port;
      ISIS.Ports.LibPowerPort Port1;
    equation
      Port1.E = Port.p;
      Port1.F = Port.m_flow;  // Not correct, just a placeholder.
    end LibHydraulicPowerPort;

  /*
    connector LibPowerPort
      ISIS.Types.Effort E;
      ISIS.Types.Flow F;
    end LibPowerPort;

    connector LibSignalConnector
      ISIS.Types.SimpleSignal SignalValue;
    end LibSignalConnector;
    
    connector LibBoolSignalPort
      ISIS.Types.BooleanSignal BoolSignal;
    end LibBoolSignalPort;
    
    connector LibElectricalPowerPortConnector
      ISIS.Types.Voltage V;
      ISIS.Types.Current I;
    end LibElectricalPowerPortConnector;

    connector LibMechanicalRotationPowerPortConnector
      ISIS.Types.Torque T;
      ISIS.Types.RotationalVelocity W;
    end LibMechanicalRotationPowerPortConnector;

    connector LibMechanicalTranslationPowerPortConnector
      ISIS.Types.Force F;
      ISIS.Types.Velocity V;
    end LibMechanicalTranslationPowerPortConnector;

    connector LibHydraulicPowerPortConnector
      ISIS.Types.Pressure P;
      ISIS.Types.VolumeFlowRate Q;
    end LibHydraulicPowerPortConnector;

    partial model LibDomainSpecificPowerPort
      parameter Integer BondCount = 1;
      ISIS.Ports.LibPowerPort PowerPorts[BondCount*2] "An array of generic power ports";
    equation
      for i in 1:2:BondCount*2 loop
        PowerPorts[i].E = PowerPorts[i+1].E;
        PowerPorts[i].F = PowerPorts[i+1].F;
      end for;
    end LibDomainSpecificPowerPort;

    model LibElectricalPowerPort
      extends ISIS.Ports.LibDomainSpecificPowerPort;
      ISIS.Ports.LibElectricalPowerPortConnector Electrical[BondCount];
    equation
      for i in 1:1:BondCount loop
        PowerPorts[i*2].E = Electrical[i].V;
        PowerPorts[i*2].F = Electrical[i].I;
      end for;
    end LibElectricalPowerPort;

    model LibMechanicalRotationPowerPort
      extends ISIS.Ports.LibDomainSpecificPowerPort;
      ISIS.Ports.LibMechanicalRotationPowerPortConnector Rotation[BondCount];
    equation
      for i in 1:1:BondCount loop
        PowerPorts[i*2].E = Rotation[i].T;
        PowerPorts[i*2].F = Rotation[i].W;
      end for;
    end LibMechanicalRotationPowerPort;

    model LibMechanicalTranslationPowerPort
      extends ISIS.Ports.LibDomainSpecificPowerPort;
      ISIS.Ports.LibMechanicalTranslationPowerPortConnector Translation[BondCount];
    equation
      for i in 1:1:BondCount loop
        PowerPorts[i*2].E = Translation[i].F;
        PowerPorts[i*2].F = Translation[i].V;
      end for;
    end LibMechanicalTranslationPowerPort;

    model LibHydraulicPowerPort
      extends ISIS.Ports.LibDomainSpecificPowerPort;
      ISIS.Ports.LibHydraulicPowerPortConnector Hydraulic[BondCount];
    equation
      for i in 1:1:BondCount loop
        PowerPorts[i*2].E = Hydraulic[i].P;
        PowerPorts[i*2].F = Hydraulic[i].Q;
      end for;
    end LibHydraulicPowerPort;
    */

  end Ports;

  package HBG
  extends Modelica.Icons.Package;
    partial model LibOnePort

      ISIS.Ports.LibPowerPort Port1 "A one element array of energy ports." annotation(Placement(visible = true, transformation(origin = {87.3857,-87.0201}, extent = {{-12,-12},{12,12}}, rotation = 0), iconTransformation(origin = {87.3857,-87.0201}, extent = {{-12,-12},{12,12}}, rotation = 0)));
      parameter Real ParameterValue = 1 "The value of the Bond Graph element.";
      parameter Integer Sign = 1
        "A multiplier for the ParameterValue to help the equations work out.";
      annotation (Icon(graphics={Text(
              extent={{-100,-60},{100,-100}},
              lineColor={0,0,255},
              textString="%name")}));
    end LibOnePort;

    partial model LibModulatedOnePort
      extends ISIS.HBG.LibOnePort;
      ISIS.Ports.LibSignalConnector ParameterSignal;
    end LibModulatedOnePort;

    partial model LibTwoPort
      ISIS.Ports.LibPowerPort Port1;
      ISIS.Ports.LibPowerPort Port2;
      parameter Real ParameterValue = 1 "The value of the Bond Graph element.";
      annotation (Icon(graphics={Text(
              extent={{-100,-60},{100,-100}},
              lineColor={0,0,255},
              textString="%name")}));
    end LibTwoPort;

    partial model LibModulatedTwoPort
      extends ISIS.HBG.LibTwoPort;
      ISIS.Ports.LibSignalConnector ParameterSignal;
      // Have to directly use the SignalValue, cannot store it into a variable and then
      // use it.  OpenModelica loses an equation or variable (I forget wich) when you
      // store it to a variable first.
    //equation
      //ParameterValue = ParameterSignal.SignalValue;
    end LibModulatedTwoPort;

    partial model LibStorage
      extends ISIS.HBG.LibOnePort;
      parameter Real InitialValue = 0
        "The initial value of the storage element.";
      Real State "What is stored.";
    end LibStorage;

    partial model LibModulatedStorage
      extends ISIS.HBG.LibModulatedOnePort;
      parameter Real InitialValue = 0
        "The initial value of the storage element.";
      ISIS.Ports.LibSignalConnector InitialSignal
        "Used to set the initial value at compile time.";
    end LibModulatedStorage;

    model LibResistor
      extends ISIS.HBG.LibOnePort;
      Real R = ParameterValue "Resistance value.";
    equation
      Port1.E = Port1.F * R * Sign;
      annotation (Diagram(graphics={
                                 Text(
              extent={{-100,100},{100,-100}},
              lineColor={0,0,0},
              textString="R")}), Icon(graphics={
                                 Text(
              extent={{-100,100},{100,-100}},
              lineColor={0,0,0},
              textString="R")}));
    end LibResistor;

    model LibModulatedResistor
      extends ISIS.HBG.LibModulatedOnePort;
      //Real R = ParameterValue "Resistance value.";
    equation
      // Have to directly use the SignalValue, cannot store it into a variable and then
      // use it.  OpenModelica loses an equation or variable (I forget wich) when you
      // store it to a variable first.
      //R = ParameterSignal.SignalValue;
      //PowerPorts[1].E = PowerPorts[1].F * R * Sign;
      Port1.E = Port1.F * ParameterSignal.SignalValue * Sign;
      annotation (Icon(graphics={Text(
              extent={{-100,100},{100,-54}},
              lineColor={0,0,0},
              textString="MR")}), Diagram(graphics={
                                 Text(
              extent={{-100,100},{100,-54}},
              lineColor={0,0,0},
              textString="MR")}));
    end LibModulatedResistor;

    model LibInertia
      extends ISIS.HBG.LibStorage;
      Real L = ParameterValue "Inertia value.";
    initial equation
      State = InitialValue;
    equation
      der(State) = Port1.E;
      Port1.F = State / (L * Sign);
      annotation (Icon(graphics={Text(
              extent={{-100,100},{100,-100}},
              lineColor={0,0,0},
              textString="I")}), Diagram(graphics={
                                 Text(
              extent={{-100,100},{100,-100}},
              lineColor={0,0,0},
              textString="I")}));
    end LibInertia;

    model LibModulatedInertia
      extends ISIS.HBG.LibStorage;
      //Real L = ParameterValue "Inertia value.";
    initial equation
      // Need some way to make sure we only read the initial signal if it's connected.  This is probably not the best way to do that.
      if InitialSignal.SignalValue <> 0 then
        InitialValue = InitialSignal.SignalValue;
      else
      end if;
      State = InitialValue;
    equation
      // Have to directly use the SignalValue, cannot store it into a variable and then
      // use it.  OpenModelica loses an equation or variable (I forget wich) when you
      // store it to a variable first.
      //L = ParameterSignal.SignalValue;
      der(State) = Port1.E;
      //PowerPorts[1].F = State / (L * Sign);
      Port1.F = State / (ParameterSignal.SignalValue * Sign);
      annotation (Icon(graphics={Text(
              extent={{-100,100},{100,-80}},
              lineColor={0,0,0},
              textString="MI")}), Diagram(graphics={
                                 Text(
              extent={{-100,100},{100,-80}},
              lineColor={0,0,0},
              textString="MI")}));
    end LibModulatedInertia;

    model LibCapacitor
      extends ISIS.HBG.LibStorage;
      Real C = ParameterValue "Capacitance value.";
    initial equation
      State = InitialValue;
    equation
      der(State) = Port1.F;
      Port1.E = State / (C * Sign);
      annotation (Diagram(graphics={
                                 Text(
              extent={{-100,100},{100,-100}},
              lineColor={0,0,0},
              textString="C")}), Icon(graphics={
                                 Text(
              extent={{-100,100},{100,-100}},
              lineColor={0,0,0},
              textString="C")}));
    end LibCapacitor;

    model LibModulatedCapacitor
      extends ISIS.HBG.LibModulatedStorage;
      //Real C = ParameterValue "Capacitance value.";
    initial equation
      // Need some way to make sure we only read the initial signal if it's connected.  This is probably not the best way to do that.
      if InitialSignal.SignalValue <> 0 then
        InitialValue = InitialSignal.SignalValue;
      else
        InitialValue = 0;
      end if;
      State = InitialValue;
    equation
      // Have to directly use the SignalValue, cannot store it into a variable and then
      // use it.  OpenModelica loses an equation or variable (I forget wich) when you
      // store it to a variable first.
      //C = ParameterSignal.SignalValue;
      der(State) = Port1.F;
      //PowerPorts[1].E = State / (C * Sign);
      Port1.E = State / (ParameterSignal.SignalValue * Sign);
      annotation (Icon(graphics={Text(
              extent={{-100,100},{100,-44}},
              lineColor={0,0,0},
              textString="MC")}), Diagram(graphics={
                                 Text(
              extent={{-100,100},{100,-50}},
              lineColor={0,0,0},
              textString="MC")}));
    end LibModulatedCapacitor;

    model LibSourceEffort
      extends ISIS.HBG.LibOnePort;
      Real SE = ParameterValue "Effort supplied.";
    equation
      Port1.E = SE * Sign;
      annotation (Icon(graphics={Text(
              extent={{-100,100},{100,-92}},
              lineColor={0,0,0},
              textString="Se")}), Diagram(graphics={
                                 Text(
              extent={{-100,100},{100,-92}},
              lineColor={0,0,0},
              textString="Se")}));
    end LibSourceEffort;

    model LibModulatedSourceEffort
      extends ISIS.HBG.LibModulatedOnePort;
      //Real SE = ParameterValue "Effort supplied.";
    equation
      // Have to directly use the SignalValue, cannot store it into a variable and then
      // use it.  OpenModelica loses an equation or variable (I forget wich) when you
      // store it to a variable first.
      //SE = ParameterSignal.SignalValue;
      //PowerPorts[1].E = SE * Sign;
      Port1.E = ParameterSignal.SignalValue * Sign;
      annotation (Icon(graphics={Text(
              extent={{-100,70},{100,-46}},
              lineColor={0,0,0},
              textString="MSe")}), Diagram(graphics={
                                 Text(
              extent={{-100,68},{100,-48}},
              lineColor={0,0,0},
              textString="MSe")}));
    end LibModulatedSourceEffort;

    model LibSourceFlow
      extends ISIS.HBG.LibOnePort;
      Real SF = ParameterValue "Flow supplied.";
    equation
      Port1.F = SF * Sign;
      annotation (Icon(graphics={Text(
              extent={{-100,100},{100,-100}},
              lineColor={0,0,0},
              textString="Sf")}), Diagram(graphics={
                                 Text(
              extent={{-100,100},{100,-100}},
              lineColor={0,0,0},
              textString="Sf")}));
    end LibSourceFlow;

    model LibModulatedSourceFlow
      extends ISIS.HBG.LibModulatedOnePort;
      //Real SF = ParameterValue "Flow supplied.";
    equation
      // Have to directly use the SignalValue, cannot store it into a variable and then
      // use it.  OpenModelica loses an equation or variable (I forget wich) when you
      // store it to a variable first.
      //SF = ParameterSignal.SignalValue;
      //PowerPorts[1].F = SF * Sign;
      Port1.F = ParameterSignal.SignalValue * Sign;
      annotation (Icon(graphics={Text(
              extent={{-98,64},{100,-54}},
              lineColor={0,0,0},
              textString="MSf")}), Diagram(graphics={
                                 Text(
              extent={{-98,66},{100,-52}},
              lineColor={0,0,0},
              textString="MSf")}));
    end LibModulatedSourceFlow;

    model LibTransformer
      extends ISIS.HBG.LibTwoPort;
    equation
      Port2.E * ParameterValue = Port1.E;
      Port1.F * ParameterValue = Port2.F;
      annotation (Icon(graphics={Text(
              extent={{-100,100},{100,-80}},
              lineColor={0,0,0},
              textString="TF")}), Diagram(graphics={
                                 Text(
              extent={{-100,100},{100,-80}},
              lineColor={0,0,0},
              textString="TF")}));
    end LibTransformer;

    model LibModulatedTransformer
      extends ISIS.HBG.LibModulatedTwoPort;
    equation
      // Assignment of the signal value to ParameterValue is done in ModulatedTwoPort.
      // Not anymore!
      // Have to directly use the SignalValue, cannot store it into a variable and then
      // use it.  OpenModelica loses an equation or variable (I forget wich) when you
      // store it to a variable first.
      //PowerPorts[2].E * ParameterValue = PowerPorts[1].E;
      //PowerPorts[1].F * ParameterValue = PowerPorts[2].F;
      Port2.E * ParameterSignal.SignalValue = Port1.E;
      Port1.F * ParameterSignal.SignalValue = Port2.F;
      annotation (Icon(graphics={Text(
              extent={{-100,74},{100,-42}},
              lineColor={0,0,0},
              textString="MTF")}), Diagram(graphics={
                                 Text(
              extent={{-100,60},{100,-56}},
              lineColor={0,0,0},
              textString="MTF")}));
    end LibModulatedTransformer;

    model LibGyrator
      extends ISIS.HBG.LibTwoPort;
    equation
      Port1.F * ParameterValue = Port2.E;
      Port2.F * ParameterValue = Port1.E;
      annotation (Icon(graphics={Text(
              extent={{-100,100},{100,-62}},
              lineColor={0,0,0},
              textString="GY")}),  Diagram(graphics={
                                 Text(
              extent={{-100,100},{100,-62}},
              lineColor={0,0,0},
              textString="GY")}));
    end LibGyrator;

    model LibModulatedGyrator
      extends ISIS.HBG.LibModulatedTwoPort;
    equation
      // Assignment of the signal value to ParameterValue is done in ModulatedTwoPort.
      // Not anymore!
      // Have to directly use the SignalValue, cannot store it into a variable and then
      // use it.  OpenModelica loses an equation or variable (I forget wich) when you
      // store it to a variable first.
      //PowerPorts[1].F * ParameterValue = PowerPorts[2].E;
      //PowerPorts[2].F * ParameterValue = PowerPorts[1].E;
      Port1.F * ParameterSignal.SignalValue = Port2.E;
      Port2.F * ParameterSignal.SignalValue = Port1.E;
      annotation (Icon(graphics={Text(
              extent={{-100,52},{100,-48}},
              lineColor={0,0,0},
              textString="MGY")}), Diagram(graphics={
                                 Text(
              extent={{-100,56},{100,-44}},
              lineColor={0,0,0},
              textString="MGY")}));
    end LibModulatedGyrator;

    model LibOneJunction2
      ISIS.Ports.LibPowerPort PowerPorts[2];
      parameter Boolean InitialState = true;
      parameter Integer Signs[:] = {-1, 1};

    equation
      if InitialState == true then
        PowerPorts[1].F = PowerPorts[2].F;
        (Signs[1]*PowerPorts[1].E) + (Signs[2]*PowerPorts[2].E) = 0;

      else
        PowerPorts[1].F = 0;
        PowerPorts[2].F = 0;

      end if;
    end LibOneJunction2;

    model LibOneJunction3
      ISIS.Ports.LibPowerPort PowerPorts[3];
      parameter Boolean InitialState = true;
      parameter Integer Signs[:] = {-1, 1, 1};

    equation
      if InitialState == true then
        PowerPorts[1].F = PowerPorts[2].F;
        PowerPorts[2].F = PowerPorts[3].F;
        (Signs[1]*PowerPorts[1].E) + (Signs[2]*PowerPorts[2].E) + (Signs[3]*PowerPorts[3].E) = 0;
      else
        PowerPorts[1].F = 0;
        PowerPorts[2].F = 0;
        PowerPorts[3].F = 0;

      end if;
    end LibOneJunction3;

    model LibOneJunction4
      ISIS.Ports.LibPowerPort PowerPorts[4];
      parameter Boolean InitialState = true;
      parameter Integer Signs[:] = {-1, 1, 1, 1};

    equation
      if InitialState == true then
        PowerPorts[1].F = PowerPorts[2].F;
        PowerPorts[2].F = PowerPorts[3].F;
        PowerPorts[3].F = PowerPorts[4].F;
        (Signs[1]*PowerPorts[1].E) + (Signs[2]*PowerPorts[2].E) + (Signs[3]*PowerPorts[3].E) + (Signs[4]*PowerPorts[4].E) = 0;
      else
        PowerPorts[1].F = 0;
        PowerPorts[2].F = 0;
        PowerPorts[3].F = 0;

      end if;
    end LibOneJunction4;

    model LibOneJunction
      parameter Integer BondCount;
      ISIS.Ports.LibPowerPort PowerPorts[BondCount];
      parameter Integer Signs[BondCount];
      parameter Boolean InitialState = true;
      ISIS.Ports.LibSignalConnector Flow;
      ISIS.Ports.LibSignalConnector Displacement;
    initial equation
      Displacement.SignalValue = 0;
    equation
      0 = Signs[:] * PowerPorts[:].E;
      for i in 1:BondCount-1 loop
        PowerPorts[i].F = PowerPorts[i+1].F;
      end for;
      Flow.SignalValue = PowerPorts[1].F;
      der(Displacement.SignalValue) = Flow.SignalValue;
      annotation (Icon(graphics={Text(
              extent={{-100,100},{100,-100}},
              lineColor={0,0,0},
              textString="1")}), Diagram(graphics={Text(
              extent={{-100,100},{100,-100}},
              lineColor={0,0,0},
              textString="1")}));
    end LibOneJunction;

    model LibHybridOneJunction
      parameter Integer BondCount;
      ISIS.Ports.LibPowerPort PowerPorts[BondCount];
      parameter Integer Signs[BondCount];
      parameter Boolean InitialState = true;
      ISIS.Ports.LibBoolSignalPort OnCondition;
      ISIS.Ports.LibBoolSignalPort OffCondition;
      Boolean State;
      ISIS.Ports.LibSignalConnector Flow;
      ISIS.Ports.LibSignalConnector Displacement;

    initial equation
      State = InitialState;
      Displacement.SignalValue = 0;

    equation
      State = ISIS.HBG.EvaluateJunction(State, OnCondition.BoolSignal, OffCondition.BoolSignal);
      if State == true then
        0 = Signs[:] * PowerPorts[:].E;
        for i in 1:BondCount-1 loop
          PowerPorts[i].F = PowerPorts[i+1].F;
        end for;
      else
        for i in 1:BondCount loop
          PowerPorts[i].F = 0;
        end for;
      end if;
      Flow.SignalValue = PowerPorts[1].F;
      der(Displacement.SignalValue) = Flow.SignalValue;

    end LibHybridOneJunction;

    function EvaluateJunction
      input Boolean StateIn;
      input Boolean OnCondition;
      input Boolean OffCondition;
      output Boolean StateOut;
    algorithm
      // Set junction state information.
      // This setup causes OM to crash - setting the State variable in the if/else statements does it.
      if StateIn == true then
        if OffCondition == true then
          StateOut := false;
        else
          StateOut := true;
        end if;
      else
        if OnCondition == true then
          StateOut := true;
        else
          StateOut := false;
        end if;
      end if;
    end EvaluateJunction;

    model LibZeroJunction
      parameter Integer BondCount;
      ISIS.Ports.LibPowerPort PowerPorts[BondCount];
      parameter Integer Signs[BondCount];
      parameter Boolean InitialState = true;
      ISIS.Ports.LibSignalConnector Effort;
      ISIS.Ports.LibSignalConnector Momentum;
    initial equation
      Momentum.SignalValue = 0;
    equation
      0 = Signs[:] * PowerPorts[:].F;
      for i in 1:BondCount-1 loop
        PowerPorts[i].E = PowerPorts[i+1].E;
      end for;
      Effort.SignalValue = PowerPorts[1].E;
      der(Momentum.SignalValue) = Effort.SignalValue;

      annotation (Icon(graphics={Text(
              extent={{-100,100},{100,-100}},
              lineColor={0,0,0},
              textString="0")}), Diagram(graphics={Text(
              extent={{-100,100},{100,-100}},
              lineColor={0,0,0},
              textString="0")}));
    end LibZeroJunction;

    model LibHybridZeroJunction
      parameter Integer BondCount;
      ISIS.Ports.LibPowerPort PowerPorts[BondCount];
      parameter Integer Signs[BondCount];
      parameter Boolean InitialState = true;
      ISIS.Ports.LibBoolSignalPort OnCondition;
      ISIS.Ports.LibBoolSignalPort OffCondition;
      Boolean State;
      ISIS.Ports.LibSignalConnector Effort;
      ISIS.Ports.LibSignalConnector Momentum;
    initial equation
      State = InitialState;
      Momentum.SignalValue = 0;
    equation
      State = ISIS.HBG.EvaluateJunction(State, OnCondition.BoolSignal, OffCondition.BoolSignal);
      if State == true then
        0 = Signs[:] * PowerPorts[:].F;
        for i in 1:BondCount-1 loop
          PowerPorts[i].E = PowerPorts[i+1].E;
        end for;
      else
        for i in 1:BondCount loop
          PowerPorts[i].F = 0;
        end for;
      end if;
      Effort.SignalValue = PowerPorts[1].E;
      der(Momentum.SignalValue) = Effort.SignalValue;
    end LibHybridZeroJunction;

    model LibZeroJunction2
      ISIS.Ports.LibPowerPort PowerPorts[2];
      parameter Boolean InitialState = true;
      parameter Integer Signs[:] = {-1, 1};
    equation
      if InitialState == true then
        (Signs[1]*PowerPorts[1].F) + (Signs[2]*PowerPorts[2].F) = 0;
        PowerPorts[1].E = PowerPorts[2].E;

      else
        PowerPorts[1].F = 0;
        PowerPorts[2].F = 0;

      end if;
    end LibZeroJunction2;

    model LibZeroJunction3
      ISIS.Ports.LibPowerPort PowerPorts[3];
      parameter Boolean InitialState = true;
      parameter Integer Signs[:] = {-1, 1, 1};
    equation
      if InitialState == true then
        (Signs[1]*PowerPorts[1].F) + (Signs[2]*PowerPorts[2].F) + (Signs[3]*PowerPorts[3].F) = 0;
        PowerPorts[1].E = PowerPorts[2].E;
        PowerPorts[2].E = PowerPorts[3].E;

      else
        PowerPorts[1].F = 0;
        PowerPorts[2].F = 0;
        PowerPorts[3].F = 0;

      end if;
    end LibZeroJunction3;

    model LibZeroJunction4
      ISIS.Ports.LibPowerPort PowerPorts[4];
      parameter Boolean InitialState = true;
      parameter Integer Signs[:] = {-1, 1, 1, 1};
    equation
      if InitialState == true then
        (Signs[1]*PowerPorts[1].F) + (Signs[2]*PowerPorts[2].F) + (Signs[3]*PowerPorts[3].F) + (Signs[4]*PowerPorts[4].F) = 0;
        PowerPorts[1].E = PowerPorts[2].E;
        PowerPorts[2].E = PowerPorts[3].E;
        PowerPorts[3].E = PowerPorts[4].E;

      else
        PowerPorts[1].F = 0;
        PowerPorts[2].F = 0;
        PowerPorts[3].F = 0;

      end if;
    end LibZeroJunction4;
  end HBG;

  package Extension
  extends Modelica.Icons.Package;
    model LibScope
      ISIS.Ports.LibSignalConnector Signal[1];
      Real Sensed;
    equation
      Sensed = Signal[1].SignalValue;
    end LibScope;

    model LibInputSignal
      ISIS.Ports.LibSignalConnector Signal[2];
    equation
      Signal[1].SignalValue = Signal[2].SignalValue;
    end LibInputSignal;

    model LibOutputSignal
      ISIS.Ports.LibSignalConnector Signal[2];
    equation
      Signal[1].SignalValue = Signal[2].SignalValue;
    end LibOutputSignal;

    model LibLocalSignal
      ISIS.Ports.LibSignalConnector Signal[2];
    equation
      Signal[1].SignalValue = Signal[2].SignalValue;
    end LibLocalSignal;

    model LibParameter
      ISIS.Ports.LibSignalConnector Signal[1];
      parameter Real ParameterValue;
    equation
      ParameterValue = Signal[1].SignalValue;
    end LibParameter;

    model LibMetric
      ISIS.Ports.LibSignalConnector Signal[1];
      Real MetricValue;
    equation
      MetricValue = Signal[1].SignalValue;
    end LibMetric;

    model LibDe
      ISIS.Ports.LibSignalConnector Signal[2];
    equation
      Signal[1].SignalValue = Signal[2].SignalValue;
    end LibDe;

    model LibDf
      ISIS.Ports.LibSignalConnector Signal[2];
    equation
      Signal[1].SignalValue = Signal[2].SignalValue;
    end LibDf;

    model LibDp
      ISIS.Ports.LibSignalConnector Signal[2];
    initial equation
      Signal[2].SignalValue = 0;
    equation
      der(Signal[2].SignalValue) = Signal[1].SignalValue;
    end LibDp;

    model LibDq
      ISIS.Ports.LibSignalConnector Signal[2];
    initial equation
      Signal[2].SignalValue = 0;
    equation
      der(Signal[2].SignalValue) = Signal[1].SignalValue;
    end LibDq;

  end Extension;

model TestElements

    Ports.LibPowerPort powerPort
      annotation (Placement(transformation(extent={{-40,60},{-20,80}})));
    Ports.LibSignalConnector libSignalConnector
      annotation (Placement(transformation(extent={{-100,60},{-80,80}})));
    Ports.LibBoolSignalPort libBoolSignalPort
      annotation (Placement(transformation(extent={{-80,60},{-60,80}})));
    Ports.LibElectricalPowerPort libElectricalPowerPort
      annotation (Placement(transformation(extent={{-20,60},{0,80}})));
    Ports.LibMechanicalRotationPowerPort libMechanicalRotationPowerPort
      annotation (Placement(transformation(extent={{0,60},{20,80}})));
    Ports.LibMechanicalTranslationPowerPort libMechanicalTranslationPowerPort
      annotation (Placement(transformation(extent={{20,60},{40,80}})));
    Ports.LibHydraulicPowerPort libHydraulicPowerPort
      annotation (Placement(transformation(extent={{40,60},{60,80}})));
    HBG.LibResistor libResistor
      annotation (Placement(transformation(extent={{-100,40},{-80,60}})));
    HBG.LibModulatedResistor libModulatedResistor
      annotation (Placement(transformation(extent={{-80,40},{-60,60}})));
    HBG.LibInertia libInertia
      annotation (Placement(transformation(extent={{-60,40},{-40,60}})));
    HBG.LibModulatedInertia libModulatedInertia
      annotation (Placement(transformation(extent={{-40,40},{-20,60}})));
    HBG.LibCapacitor libCapacitor
      annotation (Placement(transformation(extent={{-20,40},{0,60}})));
    HBG.LibModulatedCapacitor libModulatedCapacitor
      annotation (Placement(transformation(extent={{0,40},{20,60}})));
    HBG.LibSourceEffort libSourceEffort
      annotation (Placement(transformation(extent={{-100,20},{-80,40}})));
    HBG.LibModulatedSourceEffort libModulatedSourceEffort
      annotation (Placement(transformation(extent={{-80,20},{-60,40}})));
    HBG.LibSourceFlow libSourceFlow
      annotation (Placement(transformation(extent={{-60,20},{-40,40}})));
    HBG.LibModulatedSourceFlow libModulatedSourceFlow
      annotation (Placement(transformation(extent={{-40,20},{-20,40}})));
    HBG.LibTransformer libTransformer
      annotation (Placement(transformation(extent={{-20,20},{0,40}})));
    HBG.LibModulatedTransformer libModulatedTransformer
      annotation (Placement(transformation(extent={{0,20},{20,40}})));
    HBG.LibGyrator libGyrator
      annotation (Placement(transformation(extent={{20,20},{40,40}})));
    HBG.LibModulatedGyrator libModulatedGyrator
      annotation (Placement(transformation(extent={{40,20},{60,40}})));
    HBG.LibOneJunction libOneJunction
      annotation (Placement(transformation(extent={{20,40},{40,60}})));
    HBG.LibZeroJunction libZeroJunction
      annotation (Placement(transformation(extent={{40,40},{60,60}})));
    Extension.LibScope libScope
      annotation (Placement(transformation(extent={{-100,-20},{-80,0}})));
    Extension.LibInputSignal libInputSignal
      annotation (Placement(transformation(extent={{-80,-20},{-60,0}})));
    Extension.LibOutputSignal libOutputSignal
      annotation (Placement(transformation(extent={{-60,-20},{-40,0}})));
    Extension.LibLocalSignal libLocalSignal
      annotation (Placement(transformation(extent={{-40,-20},{-20,0}})));
    Extension.LibParameter libParameter
      annotation (Placement(transformation(extent={{-20,-20},{0,0}})));
    Extension.LibMetric libMetric
      annotation (Placement(transformation(extent={{0,-20},{20,0}})));
    Extension.LibDe libDe
      annotation (Placement(transformation(extent={{-100,-40},{-80,-20}})));
    Extension.LibDf libDf
      annotation (Placement(transformation(extent={{-80,-40},{-60,-20}})));
    Extension.LibDp libDp
      annotation (Placement(transformation(extent={{-60,-40},{-40,-20}})));
    Extension.LibDq libDq
      annotation (Placement(transformation(extent={{-40,-40},{-20,-20}})));
model Component
extends ISIS.Icons.Component;
end Component;

model ComponentAssembly
extends ISIS.Icons.ComponentAssembly;
end ComponentAssembly;

model TestComponent
extends ISIS.Icons.TestComponent;
end TestComponent;

    TestComponent testComponent
      annotation (Placement(transformation(extent={{0,-80},{20,-60}})));
    ComponentAssembly componentAssembly
      annotation (Placement(transformation(extent={{-40,-80},{-20,-60}})));
    Component component
      annotation (Placement(transformation(extent={{-80,-80},{-60,-60}})));
end TestElements;

  package Icons
    extends Modelica.Icons.Package;
    partial model TestBench "Icon for a test bench"

      annotation (Icon(graphics={
            Line(
              points={{-100,-20},{-60,-60},{-20,40}},
              color={0,255,0},
              smooth=Smooth.None,
              thickness=0.5),
            Line(
              points={{0,40},{100,-60}},
              color={255,0,0},
              smooth=Smooth.None,
              thickness=0.5),
            Line(
              points={{0,-60},{100,40}},
              color={255,0,0},
              smooth=Smooth.None,
              thickness=0.5)}));
    end TestBench;

    partial model Component

      annotation (Icon(graphics={
            Rectangle(
              extent={{-120,120},{120,-120}},
              lineColor={58,101,255},
              pattern=LinePattern.Dash,
              fillPattern=FillPattern.Backward,
              fillColor={193,217,255}),
                                 Polygon(
              points={{-120,100},{-120,120},{-100,120},{-120,100}},
              smooth=Smooth.None,
              fillColor={58,101,255},
              fillPattern=FillPattern.Solid,
              pattern=LinePattern.None,
              lineColor={90,101,255}),   Polygon(
              points={{-10,-10},{-10,10},{10,10},{-10,-10}},
              smooth=Smooth.None,
              fillColor={58,101,255},
              fillPattern=FillPattern.Solid,
              pattern=LinePattern.None,
              origin={110,-110},
              rotation=180,
              lineColor={0,0,0}),
            Text(
              extent={{-120,12},{120,-8}},
              lineColor={90,101,255},
              fillColor={116,214,35},
              fillPattern=FillPattern.Solid,
              textString="%name")}));
    end Component;

    partial model TestComponent

      annotation (Icon(graphics={
            Rectangle(
              extent={{-120,120},{120,-120}},
              lineColor={179,78,182},
              pattern=LinePattern.Dash,
              fillPattern=FillPattern.Backward,
              fillColor={249,212,255}),
                                 Polygon(
              points={{-120,100},{-120,120},{-100,120},{-120,100}},
              smooth=Smooth.None,
              fillColor={179,78,182},
              fillPattern=FillPattern.Solid,
              pattern=LinePattern.None), Polygon(
              points={{-10,-10},{-10,10},{10,10},{-10,-10}},
              smooth=Smooth.None,
              fillColor={179,78,182},
              fillPattern=FillPattern.Solid,
              pattern=LinePattern.None,
              origin={110,-110},
              rotation=180),
            Text(
              extent={{-120,12},{120,-8}},
              lineColor={179,78,182},
              fillColor={179,78,182},
              fillPattern=FillPattern.Solid,
              textString="%name")}));
    end TestComponent;

    partial model ComponentAssembly

      annotation (Icon(graphics={
            Rectangle(
              extent={{-120,120},{120,-120}},
              lineColor={116,214,35},
              pattern=LinePattern.Dash,
              fillPattern=FillPattern.Backward,
              fillColor={219,255,210}),
                                 Polygon(
              points={{-120,100},{-120,120},{-100,120},{-120,100}},
              smooth=Smooth.None,
              fillColor={116,214,35},
              fillPattern=FillPattern.Solid,
              pattern=LinePattern.None,
              lineColor={90,101,255}),   Polygon(
              points={{-10,-10},{-10,10},{10,10},{-10,-10}},
              smooth=Smooth.None,
              fillColor={116,214,35},
              fillPattern=FillPattern.Solid,
              pattern=LinePattern.None,
              origin={110,-110},
              rotation=180,
              lineColor={0,0,0}),Polygon(
              points={{-10,-10},{-10,10},{10,10},{-10,-10}},
              smooth=Smooth.None,
              fillColor={116,214,35},
              fillPattern=FillPattern.Solid,
              pattern=LinePattern.None,
              lineColor={90,101,255},
              origin={110,110},
              rotation=270),     Polygon(
              points={{-10,-10},{-10,10},{10,10},{-10,-10}},
              smooth=Smooth.None,
              fillColor={116,214,35},
              fillPattern=FillPattern.Solid,
              pattern=LinePattern.None,
              lineColor={90,101,255},
              origin={-110,-110},
              rotation=90),
            Text(
              extent={{-120,10},{120,-10}},
              lineColor={116,214,35},
              fillColor={116,214,35},
              fillPattern=FillPattern.Solid,
              textString="%name")}));
    end ComponentAssembly;

    partial model ModelicaModel

      annotation (Icon(graphics={            Rectangle(
              extent={{-68,68},{72,-52}},
              lineColor={0,0,0},
              fillColor={215,230,240},
              fillPattern=FillPattern.Solid), Text(
              extent={{-68,18},{72,0}},
              lineColor={0,0,255},
              textString="Modelica Model")}));
    end ModelicaModel;

    partial model BondGraph

      annotation (Icon(graphics={            Rectangle(
              extent={{-68,68},{72,-52}},
              lineColor={0,0,0},
              fillColor={215,230,240},
              fillPattern=FillPattern.Solid), Text(
              extent={{-68,26},{72,8}},
              lineColor={0,0,255},
              textString="Bond Graph")}));
    end BondGraph;

    partial model PhysicalComponent

      annotation (Icon(graphics={            Rectangle(
              extent={{-68,68},{72,-52}},
              lineColor={0,0,0},
              fillColor={215,230,240},
              fillPattern=FillPattern.Solid), Text(
              extent={{-68,26},{72,8}},
              lineColor={0,0,255},
              textString="Bond Graph")}));
    end PhysicalComponent;

    partial model PatternBased_Requirement

      annotation (Icon(graphics={
            Rectangle(
              extent={{-120,120},{120,-120}},
              lineColor={255,134,134},
              pattern=LinePattern.Dash,
              fillPattern=FillPattern.Backward,
              fillColor={235,178,178}),
                                 Polygon(
              points={{-120,100},{-120,120},{-100,120},{-120,100}},
              smooth=Smooth.None,
              fillColor={255,134,134},
              fillPattern=FillPattern.Solid,
              pattern=LinePattern.None,
              lineColor={255,134,134}),   Polygon(
              points={{-10,-10},{-10,10},{10,10},{-10,-10}},
              smooth=Smooth.None,
              fillColor={255,134,134},
              fillPattern=FillPattern.Solid,
              pattern=LinePattern.None,
              origin={110,-110},
              rotation=180,
              lineColor={0,0,0}),
            Text(
              extent={{-120,12},{120,-8}},
              lineColor={255,134,134},
              fillColor={255,134,134},
              fillPattern=FillPattern.Solid,
              textString="%name")}));

    end PatternBased_Requirement;

    partial model SignalFlow

      annotation (Icon(graphics={
            Rectangle(
              extent={{-120,120},{120,-120}},
              lineColor={255,170,85},
              fillPattern=FillPattern.Backward,
              fillColor={255,225,189}),
                                 Polygon(
              points={{-120,100},{-120,120},{-100,120},{-120,100}},
              smooth=Smooth.None,
              fillColor={255,170,85},
              fillPattern=FillPattern.Solid,
              lineColor={255,170,85}),   Polygon(
              points={{-10,-10},{-10,10},{10,10},{-10,-10}},
              smooth=Smooth.None,
              fillColor={255,170,85},
              fillPattern=FillPattern.Solid,
              origin={110,-110},
              rotation=180,
              lineColor={255,170,85}),
            Text(
              extent={{-120,12},{120,-8}},
              lineColor={255,170,85},
              fillColor={116,214,35},
              fillPattern=FillPattern.Solid,
              textString="%name")}));
    end SignalFlow;
  end Icons;
  annotation (uses(Modelica(version="3.2")));
end ISIS;

