/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version: 10.0.0.0
//  
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
// ------------------------------------------------------------------------------
namespace CyPhy2Modelica.Templates
{
    using System;
    using System.IO;
    using System.Diagnostics;
    using System.Linq;
    using System.Collections;
    using System.Collections.Generic;
    
    
    #line 1 "C:\META\meta_trunk\src\CyPhy2Modelica\Templates\simscript.tt"
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Microsoft.VisualStudio.TextTemplating", "10.0.0.0")]
    public partial class simscript : simscriptBase
    {
        #region ToString Helpers
        /// <summary>
        /// Utility class to produce culture-oriented representation of an object as a string.
        /// </summary>
        public class ToStringInstanceHelper
        {
            private System.IFormatProvider formatProviderField  = global::System.Globalization.CultureInfo.InvariantCulture;
            /// <summary>
            /// Gets or sets format provider to be used by ToStringWithCulture method.
            /// </summary>
            public System.IFormatProvider FormatProvider
            {
                get
                {
                    return this.formatProviderField ;
                }
                set
                {
                    if ((value != null))
                    {
                        this.formatProviderField  = value;
                    }
                }
            }
            /// <summary>
            /// This is called from the compile/run appdomain to convert objects within an expression block to a string
            /// </summary>
            public string ToStringWithCulture(object objectToConvert)
            {
                if ((objectToConvert == null))
                {
                    throw new global::System.ArgumentNullException("objectToConvert");
                }
                System.Type t = objectToConvert.GetType();
                System.Reflection.MethodInfo method = t.GetMethod("ToString", new System.Type[] {
                            typeof(System.IFormatProvider)});
                if ((method == null))
                {
                    return objectToConvert.ToString();
                }
                else
                {
                    return ((string)(method.Invoke(objectToConvert, new object[] {
                                this.formatProviderField })));
                }
            }
        }
        private ToStringInstanceHelper toStringHelperField = new ToStringInstanceHelper();
        public ToStringInstanceHelper ToStringHelper
        {
            get
            {
                return this.toStringHelperField;
            }
        }
        #endregion
        public virtual string TransformText()
        {
            this.GenerationEnvironment = null;
            this.Write(" \r\n");
            this.Write("#!/usr/bin/python\r\n# ---------------------------------------------------\r\n# Auto " +
                    "generated from simscript.tt\r\n# -------------------------------------------------" +
                    "--\r\nimport os\r\nimport sys\r\nimport json\r\nimport time\r\nimport logging\r\nimport subp" +
                    "rocess\r\nfrom py_modelica import OpenModelica, Dymola\r\nfrom py_modelica.report_fu" +
                    "nctions import *\r\nfrom py_modelica.utility_functions import \\\r\n    instantiate_l" +
                    "ogger, run_post_scripts, get_simscript_opts_and_args, write_out_tool_statistics\r" +
                    "\n\r\n# sys.exit is broken under the Windows virtualenv\r\n#  uncaught exceptions are" +
                    " broken too (i.e. %ERRORLEVEL% == 0)\r\nif os.name == \'nt\':\r\n    import win32api\r\n" +
                    "    def _exit(code):\r\n        win32api.TerminateProcess(win32api.GetCurrentProce" +
                    "ss(), code)\r\n    sys.exit = _exit\r\n\r\ndef init_and_compile_test_bench(tool_name=\'" +
                    "Dymola\',\r\n                                result_mat_file=\'\',\r\n                 " +
                    "               model_config_file=\'model_config.json\',\r\n                         " +
                    "       report_file=\'summary.testresults.json\'):\r\n    \"\"\"\r\n    Instanciates a new" +
                    " tool for simulation, \r\n    compiles and then returns with the tool. \r\n    \r\n   " +
                    " \"\"\"\r\n    try:\r\n        # Load in model_config.json\r\n        with open(model_con" +
                    "fig_file) as file_model:\r\n            model_config = json.load(file_model)\r\n    " +
                    "    # Read which tool to use from argument\r\n        if tool_name == \'OpenModelic" +
                    "a\':\r\n            tool = OpenModelica(model_config)\r\n            tool.short_name " +
                    "= result_mat_file\r\n        elif tool_name == \'Dymola\':\r\n            tool = Dymol" +
                    "a(model_config, dymola_home=r\"");
            
            #line 52 "C:\META\meta_trunk\src\CyPhy2Modelica\Templates\simscript.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(DymolaHome));
            
            #line default
            #line hidden
            this.Write("\")\r\n            if result_mat_file:\r\n                tool.result_mat = \'{0}.mat\'." +
                    "format(result_mat_file)\r\n        else:\r\n            msg = \'Only Dymola and OpenM" +
                    "odelica are supported!\'\r\n            raise Exception(msg)\r\n        # compile the" +
                    " model and return with the tool    \r\n        if tool.compile_model():\r\n         " +
                    "   return tool\r\n        else:\r\n            msg = \'Failed to compile model!\'\r\n   " +
                    "         raise Exception(msg)\r\n    except Exception as msg:\r\n        log = loggi" +
                    "ng.getLogger()\r\n        import traceback\r\n        log.error(\"Exception was raise" +
                    "d : {0}\".format(traceback.format_exc()))\r\n        update_analysis_status(\'FAILED" +
                    "\', str(msg), report_file) \r\n\r\ndef execute_test_bench(tool, \r\n                   " +
                    "    report_file=\"summary.testresults.json\",\r\n                       filter_file=" +
                    "\"filter.json\", \r\n                       limits_file=\"limits.json\"):\r\n    \"\"\"\r\n  " +
                    "  Reads in parameters from report_file and simulates the test bench. \r\n    When " +
                    "done, writes metrics to report_file\r\n    \r\n    \"\"\"\r\n    try:    \r\n        log = " +
                    "logging.getLogger()\r\n        # Read in parameters        \r\n        parameters = " +
                    "get_parameters_from_report_json(report_file)\r\n        log.info(\'Parameters : {0}" +
                    "\'.format(parameters))\r\n        # Try to compile and simulate model\r\n        if p" +
                    "arameters:\r\n            tool.change_parameter(parameters)\r\n        if tool.simul" +
                    "ate_model():\r\n            t_stamp = time.time()\r\n            update_metrics_in_r" +
                    "eport_json(tool.result_mat, filter_file, report_file)\r\n            check_limits(" +
                    "tool.result_mat, limits_file)\r\n            t_mat = time.time() - t_stamp\r\n      " +
                    "      # Run postprocessing scripts (if PostProcessing dir exists)\r\n            t" +
                    "_post = run_post_scripts(tool.result_mat, log)\r\n            update_analysis_stat" +
                    "us(new_status=\"OK\", report_file=report_file)\r\n            return t_mat, t_post\r\n" +
                    "        else:\r\n            msg = \'Compiled, but failed to Simulate model!\'\r\n    " +
                    "        raise Exception(msg)\r\n    except Exception as msg:\r\n        import trace" +
                    "back\r\n        log = logging.getLogger()\r\n        log.error(\"Exception was raised" +
                    " : {0}\".format(traceback.format_exc()))\r\n        update_analysis_status(\"FAILED\"" +
                    ", str(msg), report_file)\r\n\r\nif __name__==\'__main__\':\r\n    opts, args = get_simsc" +
                    "ript_opts_and_args()\r\n    log = instantiate_logger(opts.debug_file)\r\n    try:\r\n " +
                    "       # Read which tool to use from argument\t\r\n        tool = init_and_compile_" +
                    "test_bench(args[0], opts.result_mat_file,\r\n                                     " +
                    "      opts.model_config_file, opts.report_file)\r\n        t_mat, t_post = execute" +
                    "_test_bench(tool, opts.report_file, \r\n                                          " +
                    " opts.filter_file, opts.limits_file)\r\n        # write statistics (temp)\r\n       " +
                    " write_out_tool_statistics(tool, t_mat, t_post, \"tool_stat.json\")\r\n    except:\r\n" +
                    "        import traceback\r\n        traceback.print_exc(file=sys.stderr)\r\n        " +
                    "sys.exit(6)\r\n");
            return this.GenerationEnvironment.ToString();
        }
        
        #line 120 "C:\META\meta_trunk\src\CyPhy2Modelica\Templates\simscript.tt"

    public string DymolaHome {get;set;}

        
        #line default
        #line hidden
    }
    
    #line default
    #line hidden
    #region Base class
    /// <summary>
    /// Base class for this transformation
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Microsoft.VisualStudio.TextTemplating", "10.0.0.0")]
    public class simscriptBase
    {
        #region Fields
        private global::System.Text.StringBuilder generationEnvironmentField;
        private global::System.CodeDom.Compiler.CompilerErrorCollection errorsField;
        private global::System.Collections.Generic.List<int> indentLengthsField;
        private string currentIndentField = "";
        private bool endsWithNewline;
        private global::System.Collections.Generic.IDictionary<string, object> sessionField;
        #endregion
        #region Properties
        /// <summary>
        /// The string builder that generation-time code is using to assemble generated output
        /// </summary>
        protected System.Text.StringBuilder GenerationEnvironment
        {
            get
            {
                if ((this.generationEnvironmentField == null))
                {
                    this.generationEnvironmentField = new global::System.Text.StringBuilder();
                }
                return this.generationEnvironmentField;
            }
            set
            {
                this.generationEnvironmentField = value;
            }
        }
        /// <summary>
        /// The error collection for the generation process
        /// </summary>
        public System.CodeDom.Compiler.CompilerErrorCollection Errors
        {
            get
            {
                if ((this.errorsField == null))
                {
                    this.errorsField = new global::System.CodeDom.Compiler.CompilerErrorCollection();
                }
                return this.errorsField;
            }
        }
        /// <summary>
        /// A list of the lengths of each indent that was added with PushIndent
        /// </summary>
        private System.Collections.Generic.List<int> indentLengths
        {
            get
            {
                if ((this.indentLengthsField == null))
                {
                    this.indentLengthsField = new global::System.Collections.Generic.List<int>();
                }
                return this.indentLengthsField;
            }
        }
        /// <summary>
        /// Gets the current indent we use when adding lines to the output
        /// </summary>
        public string CurrentIndent
        {
            get
            {
                return this.currentIndentField;
            }
        }
        /// <summary>
        /// Current transformation session
        /// </summary>
        public virtual global::System.Collections.Generic.IDictionary<string, object> Session
        {
            get
            {
                return this.sessionField;
            }
            set
            {
                this.sessionField = value;
            }
        }
        #endregion
        #region Transform-time helpers
        /// <summary>
        /// Write text directly into the generated output
        /// </summary>
        public void Write(string textToAppend)
        {
            if (string.IsNullOrEmpty(textToAppend))
            {
                return;
            }
            // If we're starting off, or if the previous text ended with a newline,
            // we have to append the current indent first.
            if (((this.GenerationEnvironment.Length == 0) 
                        || this.endsWithNewline))
            {
                this.GenerationEnvironment.Append(this.currentIndentField);
                this.endsWithNewline = false;
            }
            // Check if the current text ends with a newline
            if (textToAppend.EndsWith(global::System.Environment.NewLine, global::System.StringComparison.CurrentCulture))
            {
                this.endsWithNewline = true;
            }
            // This is an optimization. If the current indent is "", then we don't have to do any
            // of the more complex stuff further down.
            if ((this.currentIndentField.Length == 0))
            {
                this.GenerationEnvironment.Append(textToAppend);
                return;
            }
            // Everywhere there is a newline in the text, add an indent after it
            textToAppend = textToAppend.Replace(global::System.Environment.NewLine, (global::System.Environment.NewLine + this.currentIndentField));
            // If the text ends with a newline, then we should strip off the indent added at the very end
            // because the appropriate indent will be added when the next time Write() is called
            if (this.endsWithNewline)
            {
                this.GenerationEnvironment.Append(textToAppend, 0, (textToAppend.Length - this.currentIndentField.Length));
            }
            else
            {
                this.GenerationEnvironment.Append(textToAppend);
            }
        }
        /// <summary>
        /// Write text directly into the generated output
        /// </summary>
        public void WriteLine(string textToAppend)
        {
            this.Write(textToAppend);
            this.GenerationEnvironment.AppendLine();
            this.endsWithNewline = true;
        }
        /// <summary>
        /// Write formatted text directly into the generated output
        /// </summary>
        public void Write(string format, params object[] args)
        {
            this.Write(string.Format(global::System.Globalization.CultureInfo.CurrentCulture, format, args));
        }
        /// <summary>
        /// Write formatted text directly into the generated output
        /// </summary>
        public void WriteLine(string format, params object[] args)
        {
            this.WriteLine(string.Format(global::System.Globalization.CultureInfo.CurrentCulture, format, args));
        }
        /// <summary>
        /// Raise an error
        /// </summary>
        public void Error(string message)
        {
            System.CodeDom.Compiler.CompilerError error = new global::System.CodeDom.Compiler.CompilerError();
            error.ErrorText = message;
            this.Errors.Add(error);
        }
        /// <summary>
        /// Raise a warning
        /// </summary>
        public void Warning(string message)
        {
            System.CodeDom.Compiler.CompilerError error = new global::System.CodeDom.Compiler.CompilerError();
            error.ErrorText = message;
            error.IsWarning = true;
            this.Errors.Add(error);
        }
        /// <summary>
        /// Increase the indent
        /// </summary>
        public void PushIndent(string indent)
        {
            if ((indent == null))
            {
                throw new global::System.ArgumentNullException("indent");
            }
            this.currentIndentField = (this.currentIndentField + indent);
            this.indentLengths.Add(indent.Length);
        }
        /// <summary>
        /// Remove the last indent that was added with PushIndent
        /// </summary>
        public string PopIndent()
        {
            string returnValue = "";
            if ((this.indentLengths.Count > 0))
            {
                int indentLength = this.indentLengths[(this.indentLengths.Count - 1)];
                this.indentLengths.RemoveAt((this.indentLengths.Count - 1));
                if ((indentLength > 0))
                {
                    returnValue = this.currentIndentField.Substring((this.currentIndentField.Length - indentLength));
                    this.currentIndentField = this.currentIndentField.Remove((this.currentIndentField.Length - indentLength));
                }
            }
            return returnValue;
        }
        /// <summary>
        /// Remove any indentation
        /// </summary>
        public void ClearIndent()
        {
            this.indentLengths.Clear();
            this.currentIndentField = "";
        }
        #endregion
    }
    #endregion
}
