/// <reference path="../js/jquery-1.7.1.js" />

AvmProject = {};


AvmProject.AvmProjectViewer = function (config) {
    $.extend(this, config);

    this.create();
};

AvmProject.AvmProjectViewer.prototype = {

    contentHolderE:null,

    projectData:null,
    projectDataLocation:null,
    projectLocation:null,

    isLocal:false,
    hash:null,

    create:function () {
        this.projectLocation = getParameterByName('resource_url');
        this.isLocal = getParameterByName('local');

        if (this.projectLocation) {
            trace('Loading simulation report descriptor from location: [' + this.projectLocation + ']');

            var that = this;
            $.ajax({
                       url:this.projectLocation,
                       dataType:'json',
                       success:function (data) {
                           trace("Load Success");
                           that.projectData = data;

                           var loc = that.projectLocation;
                           that.projectDataLocation = loc.substring(0, loc.lastIndexOf('/') + 1);
                           if (!that.isLocal) {
                               that.hash = '?format=raw';
                           }
                           else {
                               that.hash = '';
                           }

                           Tempo.prepare('components').render(data['Project']['Components']['CheckedOut']);
                           
                           $.each(data['Project'], function(key, value){
                               //var containerE = $('#Project-artifact').clone();
                               that.loadArtifact(value, key);
                               //containerE.appendTo($('#Project'));
                           });

                           //that.render();

                       },
                       error:function () {
                           trace("Load Error");
                       },

                       complete:function () {
                           trace("Load Complete");
                       }

                   });

        } else {
            trace('No parameters.');
        }
    },
    loadArtifact: function(dataArtifact, name) {
        var that = this;

        var nameE = $('<h3>', {
            'text': name
        });

        if (name === 'Results') {
            var url = that.getUrl(dataArtifact['UrlHints'][0]);
            $.ajax({
                url:url,
                dataType:'json',
                success:function (data) {
                    trace("Load Success " + dataArtifact['UrlHints'][0]);
                    that.resultsData = data;

                    //var idx = dataArtifact['UrlHints'][0].last('/');
                    //var urlPrefix = dataArtifact['UrlHints'][0].substring(0, idx);
                    // TODO: figure out results/ directory name dynamically

                    var urlPrefix = 'results/';
                    var results = Tempo.prepare('results').render(data['Results']);
                    $.each(data['Results'], function(id, obj){
                        
                        $.ajax({
                            url:that.getUrl(obj['TestBench']),
                            dataType:'json',
                            success:function (tbData) {
                                trace("Load Success Results");
                                obj['TestBench'] = tbData;
                                results.clear();
                                results.render(data['Results']);
                                }
                        });
                        
                        $.ajax({
                            url:that.getUrl('results/' + obj['Summary']),
                            dataType:'json',
                            success:function (summaryData) {
                                trace("Load Success Results");
                                obj['Summary'] = summaryData;
                                //results.clear();
                                results.render(data['Results']);
                                }
                        });
                        //that.loadResult(obj, id, containerE, urlPrefix);
                    });
                },
                error:function () {
                    trace("Load Error " + dataArtifact['UrlHints'][0]);
                },

                complete:function () {
                    trace("Load Complete " + dataArtifact['UrlHints'][0]);
                }

            });

        } else if (name === "TestBenches") {

            var testBenches = [];

            $.each(dataArtifact, function(k,url){
                url = that.getUrl(url);
                $.ajax({
                    url:url,
                    dataType:'json',
                    success:function (data) {
                        trace("Load Success " + url);
                        testBenches.push(data);

                        Tempo.prepare('testBenches').render(testBenches);

                    },
                    error:function () {
                        trace("Load Error " + url);
                    },

                    complete:function () {
                        trace("Load Complete " + url);
                    }

                });
            });
        }
    },

    loadResult: function(data, name, containerE, urlPrefix) {
        var that = this;

        var nameE = $('<a>', {
            'text': name,
            'href': urlPrefix + data['Summary']
        });

        $(containerE).append(nameE);
    },
    
    getUrl:function (url) {
        return this.projectDataLocation + url + this.hash;
    },
};
