within Ext_Lib.Electrical.Analog.Sources;
model StepVoltage
  parameter Modelica.SIunits.Voltage V(start=1) "Height of step";
  parameter Modelica.SIunits.Voltage offset = 0;
  parameter Modelica.SIunits.Time startTime = 0;

  Modelica.Electrical.Analog.Sources.StepVoltage stepVoltage(V=V,offset=offset,startTime=startTime)
    annotation (Placement(transformation(extent={{-28,42},{-8,62}})));
  Modelica.Electrical.Analog.Interfaces.NegativePin
              n "Negative pin" annotation (Placement(transformation(extent={{42,42},
            {22,62}},          rotation=0)));
  Modelica.Electrical.Analog.Interfaces.PositivePin
                         p annotation (Placement(transformation(extent={{-86,42},
            {-66,62}},      rotation=0)));
  Modelica.Blocks.Interfaces.RealOutput avg_power
    annotation (Placement(transformation(extent={{34,2},{54,22}})));
  Modelica.Blocks.Interfaces.RealOutput sum_power
    annotation (Placement(transformation(extent={{34,16},{54,36}})));
  Modelica.Blocks.Interfaces.RealOutput power
    annotation (Placement(transformation(extent={{34,-12},{54,8}})));
  Modelica.Blocks.Interfaces.RealOutput max_current
    annotation (Placement(transformation(extent={{66,-90},{86,-70}})));
  Modelica.Electrical.Analog.Sensors.PowerSensor powerSensor
    annotation (Placement(transformation(extent={{-56,42},{-36,62}})));
  Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
    annotation (Placement(transformation(extent={{0,42},{20,62}})));
  Modelica.Blocks.Math.Max max
    annotation (Placement(transformation(extent={{46,-60},{66,-40}})));
  Modelica.Blocks.Math.Abs abs1
    annotation (Placement(transformation(extent={{18,-54},{38,-34}})));
equation

  connect(p, powerSensor.pc) annotation (Line(
      points={{-76,52},{-56,52}},
      color={0,0,255},
      smooth=Smooth.None));
  connect(powerSensor.nc, stepVoltage.p) annotation (Line(
      points={{-36,52},{-28,52}},
      color={0,0,255},
      smooth=Smooth.None));
  connect(powerSensor.pv, p) annotation (Line(
      points={{-46,62},{-61,62},{-61,52},{-76,52}},
      color={0,0,255},
      smooth=Smooth.None));
  connect(powerSensor.power, power) annotation (Line(
      points={{-54,41},{-54,-2},{44,-2}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(stepVoltage.n, currentSensor.p) annotation (Line(
      points={{-8,52},{0,52}},
      color={0,0,255},
      smooth=Smooth.None));
  connect(currentSensor.n, n) annotation (Line(
      points={{20,52},{32,52}},
      color={0,0,255},
      smooth=Smooth.None));
  connect(powerSensor.nv, n) annotation (Line(
      points={{-46,42},{-46,38},{32,38},{32,52}},
      color={0,0,255},
      smooth=Smooth.None));
  connect(max.y, max_current) annotation (Line(
      points={{67,-50},{70,-50},{70,-80},{76,-80}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(max_current, max.u2) annotation (Line(
      points={{76,-80},{36,-80},{36,-56},{44,-56}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(abs1.y, max.u1) annotation (Line(
      points={{39,-44},{44,-44}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(currentSensor.i, abs1.u) annotation (Line(
      points={{10,42},{10,-44},{16,-44}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(powerSensor.power, avg_power) annotation (Line(
      points={{-54,41},{-8,41},{-8,12},{44,12}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(powerSensor.power, sum_power) annotation (Line(
      points={{-54,41},{-8,41},{-8,26},{44,26}},
      color={0,0,127},
      smooth=Smooth.None));
  annotation (Diagram(graphics));
end StepVoltage;
