/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
/* GenCyPhy2SFC.cpp generated on Mon Feb 11 16:44:06 2013
 */

#include "GenCyPhy2SFC.h"
#include <UmlExt.h>
#include "GReATSort.h"
#include "RTTGenerator.h"
#include "CyPhy2SFC-gr_cmptempl.h"
#include "CGLog.h"

void TL_0::operator()( const Packets_t& rootFolders_1, const Packets_t& rootStates_3, const Packets_t& projects_5)
{
#ifdef PRINT_INFO
	printLog( "TL_0" );
#endif
	if( ( !rootFolders_1.empty())&& ( !rootStates_3.empty())&& ( !projects_5.empty()))
		callGetProject_2e14( rootFolders_1, rootStates_3, projects_5);
}

void TL_0::callGetProject_2e14( const Packets_t& rootFolders_2dc0, const Packets_t& states_2dc3, const Packets_t& projects_2dc6)
{
	Packets_t rootFolders_2dc2;
	Packets_t states_2dc5;
	Packets_t projects_2dc8;
	GetProject_2dbf getProject_2dbf;
	getProject_2dbf( rootFolders_2dc0, states_2dc3, projects_2dc6, rootFolders_2dc2, states_2dc5, projects_2dc8);
	if( ( !rootFolders_2dc2.empty())&& ( !states_2dc5.empty())&& ( !projects_2dc8.empty()))
		callCreateTypes_2e18( rootFolders_2dc2, states_2dc5, projects_2dc8);
}

void TL_0::callCreateTypes_2e18( const Packets_t& rootFolders_2808, const Packets_t& states_280a, const Packets_t& projects_280c)
{
	Packets_t states_280e;
	Packets_t projects_280f;
	CreateTypes_2807 createTypes_2807;
	createTypes_2807( rootFolders_2808, states_280a, projects_280c, states_280e, projects_280f);
	if( ( !states_280e.empty())&& ( !projects_280f.empty()))
		callSetFileName_2e1c( states_280e, projects_280f);
}

void TL_0::callSetFileName_2e1c( const Packets_t& states_2def, const Packets_t& projects_2df3)
{
	Packets_t states_2df1;
	Packets_t programs_2df2;
	SetFileName_2dee setFileName_2dee;
	setFileName_2dee( states_2def, projects_2df3, states_2df1, programs_2df2);
	if( ( !states_2df1.empty())&& ( !programs_2df2.empty()))
		callProcessProgram_2e1f( states_2df1, programs_2df2);
}

void TL_0::callProcessProgram_2e1f( const Packets_t& states_8, const Packets_t& programs_a)
{
	ProcessProgram_7 processProgram_7;
	processProgram_7( states_8, programs_a);
}

void ProcessProgram_7::operator()( const Packets_t& states_8, const Packets_t& programs_a)
{
#ifdef PRINT_INFO
	printLog( "ProcessProgram_7" );
#endif
	for( Packets_t::const_iterator itstate_d= states_8.begin(), itprogram_14= programs_a.begin(); itstate_d!= states_8.end(), itprogram_14!= programs_a.end(); ++itstate_d, ++itprogram_14)
	{
		bool isUnique= isInputUnique( *itstate_d, *itprogram_14);
		if( !isUnique)
			continue;
		Packets_t onestate_11( 1, *itstate_d);
		Packets_t oneprogram_18( 1, *itprogram_14);
		executeOne( onestate_11, oneprogram_18);
	}
}

void ProcessProgram_7::executeOne( const Packets_t& states_8, const Packets_t& programs_a)
{
	if( ( !states_8.empty())&& ( !programs_a.empty()))
		callClearTables_27e6( states_8, programs_a);
}

bool ProcessProgram_7::isInputUnique( const Udm::Object& state_e, const Udm::Object& program_15)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_10= _state_c.begin(), itprogram_17= _program_13.begin(); itstate_10!= _state_c.end(), itprogram_17!= _program_13.end(); ++itstate_10, ++itprogram_17)
	{
		if( ( *itstate_10== state_e)&& ( *itprogram_17== program_15))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_c.push_back( state_e);
		_program_13.push_back( program_15);
	}
	return isUnique;
}

void ProcessProgram_7::callClearTables_27e6( const Packets_t& states_cbe, const Packets_t& programs_cc1)
{
	Packets_t states_cc0;
	Packets_t programs_cc3;
	ClearTables_cbd clearTables_cbd;
	clearTables_cbd( states_cbe, programs_cc1, states_cc0, programs_cc3);
	if( ( !states_cc0.empty())&& ( !programs_cc3.empty()))
		callCreateStateLabels_27e9( states_cc0, programs_cc3);
}

void ProcessProgram_7::callCreateStateLabels_27e9( const Packets_t& states_cdf, const Packets_t& programs_ce1)
{
	Packets_t states_ce3;
	Packets_t programs_ce4;
	CreateStateLabels_cde createStateLabels_cde;
	createStateLabels_cde( states_cdf, programs_ce1, states_ce3, programs_ce4);
	if( ( !states_ce3.empty())&& ( !programs_ce4.empty()))
		callCreateDEVars_27ec( states_ce3, programs_ce4);
}

void ProcessProgram_7::callCreateDEVars_27ec( const Packets_t& states_249c, const Packets_t& programs_249e)
{
	Packets_t states_24a0;
	Packets_t programs_24a1;
	CreateDEVars_249b createDEVars_249b;
	createDEVars_249b( states_249c, programs_249e, states_24a0, programs_24a1);
	if( ( !states_24a0.empty())&& ( !programs_24a1.empty()))
		callCreateFuncStateFunctions_27ef( states_24a0, programs_24a1);
}

void ProcessProgram_7::callCreateFuncStateFunctions_27ef( const Packets_t& states_efa, const Packets_t& programs_efc)
{
	Packets_t states_efe;
	Packets_t programs_eff;
	CreateFuncStateFunctions_ef9 createFuncStateFunctions_ef9;
	createFuncStateFunctions_ef9( states_efa, programs_efc, states_efe, programs_eff);
	if( ( !states_efe.empty())&& ( !programs_eff.empty()))
		callCreateFSFunctionBodies_27f2( states_efe, programs_eff);
}

void ProcessProgram_7::callCreateFSFunctionBodies_27f2( const Packets_t& states_51, const Packets_t& programs_53)
{
	Packets_t states_55;
	Packets_t programs_56;
	CreateFSFunctionBodies_50 createFSFunctionBodies_50;
	createFSFunctionBodies_50( states_51, programs_53, states_55, programs_56);
	if( ( !states_55.empty())&& ( !programs_56.empty()))
		callCreateFunctions_27f5( states_55, programs_56);
}

void ProcessProgram_7::callCreateFunctions_27f5( const Packets_t& states_245a, const Packets_t& programs_245c)
{
	Packets_t states_245e;
	Packets_t programs_245f;
	CreateFunctions_2459 createFunctions_2459;
	createFunctions_2459( states_245a, programs_245c, states_245e, programs_245f);
	if( ( !states_245e.empty())&& ( !programs_245f.empty()))
		callPopulateFunctions_27f8( states_245e, programs_245f);
}

void ProcessProgram_7::callPopulateFunctions_27f8( const Packets_t& states_1058, const Packets_t& programs_105a)
{
	Packets_t states_105c;
	Packets_t programs_105d;
	PopulateFunctions_1057 populateFunctions_1057;
	populateFunctions_1057( states_1058, programs_105a, states_105c, programs_105d);
	if( ( !states_105c.empty())&& ( !programs_105d.empty()))
		callCreateRootFunction_27fb( states_105c, programs_105d);
}

void ProcessProgram_7::callCreateRootFunction_27fb( const Packets_t& states_1f54, const Packets_t& programs_1f56)
{
	Packets_t states_1f58;
	Packets_t programs_1f59;
	CreateRootFunction_1f53 createRootFunction_1f53;
	createRootFunction_1f53( states_1f54, programs_1f56, states_1f58, programs_1f59);
	if( ( !states_1f58.empty())&& ( !programs_1f59.empty()))
		callCreateInitFunction_27fe( states_1f58, programs_1f59);
}

void ProcessProgram_7::callCreateInitFunction_27fe( const Packets_t& states_21fa, const Packets_t& programs_21fc)
{
	Packets_t states_21fe;
	Packets_t programs_21ff;
	CreateInitFunction_21f9 createInitFunction_21f9;
	createInitFunction_21f9( states_21fa, programs_21fc, states_21fe, programs_21ff);
	if( ( !states_21fe.empty())&& ( !programs_21ff.empty()))
		callCreateStatusFunction_2801( states_21fe, programs_21ff);
}

void ProcessProgram_7::callCreateStatusFunction_2801( const Packets_t& states_1b, const Packets_t& programs_1d)
{
	Packets_t states_1f;
	Packets_t programs_20;
	CreateStatusFunction_1a createStatusFunction_1a;
	createStatusFunction_1a( states_1b, programs_1d, states_1f, programs_20);
	if( ( !states_1f.empty())&& ( !programs_20.empty()))
		callMarkLegacy_2804( states_1f, programs_20);
}

void ProcessProgram_7::callMarkLegacy_2804( const Packets_t& states_243d, const Packets_t& programs_243f)
{
	MarkLegacy_243c markLegacy_243c;
	markLegacy_243c( states_243d, programs_243f);
}

void CreateStatusFunction_1a::operator()( const Packets_t& states_1b, const Packets_t& programs_1d, Packets_t& states_1f, Packets_t& programs_20)
{
#ifdef PRINT_INFO
	printLog( "CreateStatusFunction_1a" );
#endif
	_state_21= &states_1f;
	_program_22= &programs_20;
	if( ( !states_1b.empty())&& ( !programs_1d.empty()))
		callCreateStatusFunction_4d( states_1b, programs_1d);
	_state_21->insert( _state_21->end(), states_1b.begin(), states_1b.end());
	_program_22->insert( _program_22->end(), programs_1d.begin(), programs_1d.end());
}

void CreateStatusFunction_1a::callCreateStatusFunction_4d( const Packets_t& states_24, const Packets_t& programs_26)
{
	CreateStatusFunction_23 createStatusFunction_23;
	createStatusFunction_23( states_24, programs_26);
}

void CreateStatusFunction_23::operator()( const Packets_t& states_24, const Packets_t& programs_26)
{
#ifdef PRINT_INFO
	printLog( "CreateStatusFunction_23" );
#endif
	RTTGenerator::Instance()->generateRule(15, "CreateStatusFunction");
	processInputPackets( states_24, programs_26);
}

bool CreateStatusFunction_23::isInputUnique( const Udm::Object& state_2c, const Udm::Object& program_35)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_2e= _state_28.begin(), itProgram_37= _program_31.begin(); itState_2e!= _state_28.end(), itProgram_37!= _program_31.end(); ++itState_2e, ++itProgram_37)
	{
		if( ( *itState_2e== state_2c)&& ( *itProgram_37== program_35))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_28.push_back( state_2c);
		_program_31.push_back( program_35);
	}
	return isUnique;
}

bool CreateStatusFunction_23::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateStatusFunction_23::processInputPackets( const Packets_t& states_24, const Packets_t& programs_26)
{
	for( Packets_t::const_iterator itState_29= states_24.begin(), itProgram_32= programs_26.begin(); itState_29!= states_24.end(), itProgram_32!= programs_26.end(); ++itState_29, ++itProgram_32)
	{
		bool isUnique= isInputUnique( *itState_29, *itProgram_32);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_29, *itProgram_32);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateStatusFunction_23::patternMatcher( const Udm::Object& state_2a, const Udm::Object& program_33)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_2a.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_2f= CyPhyML::SignalFlow::State::Cast( state_2a);
		if( false== Uml::IsDerivedFrom( program_33.type(), SFC::Program::meta))
			continue;
		SFC::Program program_38= SFC::Program::Cast( program_33);
		set< SFC::Function> statuss_3a= state_2f.status();
		for( set< SFC::Function>::const_iterator itStatuss_3b= statuss_3a.begin(); itStatuss_3b!= statuss_3a.end(); ++itStatuss_3b)
		{
			SFC::Function currStatus_3c= *itStatuss_3b;
			set< SFC::Arg> args_3d= currStatus_3c.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itArg_3e= args_3d.begin(); itArg_3e!= args_3d.end(); ++itArg_3e)
			{
				SFC::Arg currArg_3f= *itArg_3e;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_43;
				if( !isValidBound(boundObjs_43, state_2f, true))
					continue;
				currMatch.state_44= state_2f;
				if( !isValidBound(boundObjs_43, program_38, true))
					continue;
				currMatch.program_45= program_38;
				if( !isValidBound(boundObjs_43, currArg_3f, false))
					continue;
				currMatch.arg_46= currArg_3f;
				if( !isValidBound(boundObjs_43, currStatus_3c, false))
					continue;
				currMatch.status_47= currStatus_3c;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void CreateStatusFunction_23::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function newgetStatus_48= SFC::Function::Create( currMatch.program_45, SFC::Program::meta_stmnt);
		SFC::Return newReturn_49= SFC::Return::Create( newgetStatus_48, SFC::Function::meta_stmnt);
		SFC::FunctionCall newFunctionCall_4a= SFC::FunctionCall::Create( newReturn_49, SFC::Return::meta_retexpr);
		SFC::ArgVal newArgVal_4b= SFC::ArgVal::Create( newFunctionCall_4a);
		SFC::Str newStr_4c= SFC::Str::Create( newArgVal_4b, SFC::ArgVal::meta_argexpr);
		SFC::Arg& Arg= currMatch.arg_46;
		SFC::ArgVal& ArgVal= newArgVal_4b;
		SFC::FunctionCall& FunctionCall= newFunctionCall_4a;
		SFC::Program& Program= currMatch.program_45;
		SFC::Return& Return= newReturn_49;
		CyPhyML::SignalFlow::State& State= currMatch.state_44;
		SFC::Function& Status= currMatch.status_47;
		SFC::Str& Str= newStr_4c;
		SFC::Function& getStatus= newgetStatus_48;
		{
getStatus.RefId() = Return.RefId() = Status.RefId();
};
		{
getStatus.name() = "getStatus";
getStatus.dt() = SFCTypesManager::getSingleton().getBasicType( "string" );
};
		{
__int64 statementCount = getStatus.statementCount();
Return.statementIndex() = statementCount++;
getStatus.statementCount() = statementCount;
};
		{
ArgVal.argIndex() = 0;
};
		{
Str.val() = "";
};
		{
__int64 statementCount = Program.statementCount();
getStatus.statementIndex() = statementCount++;
Program.statementCount() = statementCount;
};
		newFunctionCall_4a.callee()= currMatch.status_47;
		newArgVal_4b.arg()+= currMatch.arg_46;
	}
}

void CreateFSFunctionBodies_50::operator()( const Packets_t& states_51, const Packets_t& programs_53, Packets_t& states_55, Packets_t& programs_56)
{
#ifdef PRINT_INFO
	printLog( "CreateFSFunctionBodies_50" );
#endif
	_state_57= &states_55;
	_program_58= &programs_56;
	if( ( !states_51.empty())&& ( !programs_53.empty()))
		callPopulateGRFSFunction_cb4( states_51, programs_53);
	_state_57->insert( _state_57->end(), states_51.begin(), states_51.end());
	_program_58->insert( _program_58->end(), programs_53.begin(), programs_53.end());
}

void CreateFSFunctionBodies_50::callPopulateGRFSFunction_cb4( const Packets_t& states_5a, const Packets_t& programs_5c)
{
	Packets_t states_5e;
	Packets_t programs_5f;
	PopulateGRFSFunction_59 populateGRFSFunction_59;
	populateGRFSFunction_59( states_5a, programs_5c, states_5e, programs_5f);
	if( ( !states_5e.empty())&& ( !programs_5f.empty()))
		callPopulateEMFSFunction_cb7( states_5e, programs_5f);
}

void CreateFSFunctionBodies_50::callPopulateEMFSFunction_cb7( const Packets_t& states_c2f, const Packets_t& programs_c31)
{
	Packets_t states_c33;
	Packets_t programs_c34;
	PopulateEMFSFunction_c2e populateEMFSFunction_c2e;
	populateEMFSFunction_c2e( states_c2f, programs_c31, states_c33, programs_c34);
	if( ( !states_c33.empty())&& ( !programs_c34.empty()))
		callGetSubStates_cba( states_c33, programs_c34);
}

void CreateFSFunctionBodies_50::callGetSubStates_cba( const Packets_t& states_c8c, const Packets_t& parStmnts_c8f)
{
	Packets_t subStates_c8e;
	Packets_t parStmnts_c91;
	GetSubStates_c8b getSubStates_c8b;
	getSubStates_c8b( states_c8c, parStmnts_c8f, subStates_c8e, parStmnts_c91);
	if( ( !subStates_c8e.empty())&& ( !parStmnts_c91.empty()))
		callPopulateGRFSFunction_cb4( subStates_c8e, parStmnts_c91);
}

void PopulateGRFSFunction_59::operator()( const Packets_t& states_5a, const Packets_t& programs_5c, Packets_t& states_5e, Packets_t& programs_5f)
{
#ifdef PRINT_INFO
	printLog( "PopulateGRFSFunction_59" );
#endif
	_state_60= &states_5e;
	_program_61= &programs_5f;
	if( ( !states_5a.empty())&& ( !programs_5c.empty()))
		callGetGRFuncStateFunction_c21( states_5a, programs_5c);
	_state_60->insert( _state_60->end(), states_5a.begin(), states_5a.end());
	_program_61->insert( _program_61->end(), programs_5c.begin(), programs_5c.end());
}

void PopulateGRFSFunction_59::callGetGRFuncStateFunction_c21( const Packets_t& states_63, const Packets_t& programs_66)
{
	Packets_t states_65;
	Packets_t execs_68;
	GetGRFuncStateFunction_62 getGRFuncStateFunction_62;
	getGRFuncStateFunction_62( states_63, programs_66, states_65, execs_68);
	if( ( !states_65.empty())&& ( !execs_68.empty()))
		callTransStartMap_c24( states_65, execs_68);
}

void PopulateGRFSFunction_59::callTransStartMap_c24( const Packets_t& states_a08, const Packets_t& css_a0a)
{
	Packets_t states_a0c;
	Packets_t css_a0d;
	TransStartMap_a07 transStartMap_a07;
	transStartMap_a07( states_a08, css_a0a, states_a0c, css_a0d);
	if( ( !states_a0c.empty())&& ( !css_a0d.empty()))
		callDirectInFunction_c27( states_a0c, css_a0d);
}

void PopulateGRFSFunction_59::callDirectInFunction_c27( const Packets_t& states_94, const Packets_t& functions_97)
{
	Packets_t states_96;
	Packets_t functions_99;
	DirectInFunction_93 directInFunction_93;
	directInFunction_93( states_94, functions_97, states_96, functions_99);
	if( ( !states_96.empty())&& ( !functions_99.empty())&& ( !functions_99.empty()))
		callTransStartTransitions_c2a( states_96, functions_99, functions_99);
}

void PopulateGRFSFunction_59::callTransStartTransitions_c2a( const Packets_t& states_b2, const Packets_t& fcns_b4, const Packets_t& css_b6)
{
	TransStartTransitions_b1 transStartTransitions_b1;
	transStartTransitions_b1( states_b2, fcns_b4, css_b6);
}

void GetGRFuncStateFunction_62::operator()( const Packets_t& states_63, const Packets_t& programs_66, Packets_t& states_65, Packets_t& execs_68)
{
#ifdef PRINT_INFO
	printLog( "GetGRFuncStateFunction_62" );
#endif
	RTTGenerator::Instance()->generateRule(50, "GetGRFuncStateFunction");
	_state_69= &states_65;
	_exec_6a= &execs_68;
	processInputPackets( states_63, programs_66);
}

bool GetGRFuncStateFunction_62::isInputUnique( const Udm::Object& state_6f, const Udm::Object& program_78)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_71= _state_6b.begin(), itProgram_7a= _program_74.begin(); itState_71!= _state_6b.end(), itProgram_7a!= _program_74.end(); ++itState_71, ++itProgram_7a)
	{
		if( ( *itState_71== state_6f)&& ( *itProgram_7a== program_78))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_6b.push_back( state_6f);
		_program_74.push_back( program_78);
	}
	return isUnique;
}

bool GetGRFuncStateFunction_62::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool GetGRFuncStateFunction_62::isGuardTrue( SFC::Function& Exec, SFC::Program& Program, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel)
{
	bool Gz_guard= false;
	Gz_guard =
 static_cast< std::string >( State.Decomposition() ) == "FUNC_STATE" &&
 static_cast< std::string >( State.Order() ) == "-1";;
	return Gz_guard;
}

void GetGRFuncStateFunction_62::processInputPackets( const Packets_t& states_63, const Packets_t& programs_66)
{
	for( Packets_t::const_iterator itState_6c= states_63.begin(), itProgram_75= programs_66.begin(); itState_6c!= states_63.end(), itProgram_75!= programs_66.end(); ++itState_6c, ++itProgram_75)
	{
		bool isUnique= isInputUnique( *itState_6c, *itProgram_75);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_6c, *itProgram_75);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetGRFuncStateFunction_62::patternMatcher( const Udm::Object& state_6d, const Udm::Object& program_76)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_6d.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_72= CyPhyML::SignalFlow::State::Cast( state_6d);
		if( false== Uml::IsDerivedFrom( program_76.type(), SFC::Program::meta))
			continue;
		SFC::Program program_7b= SFC::Program::Cast( program_76);
		set< SFC::Function> execs_7d= state_72.exec();
		for( set< SFC::Function>::const_iterator itExecs_7e= execs_7d.begin(); itExecs_7e!= execs_7d.end(); ++itExecs_7e)
		{
			SFC::Function currExec_7f= *itExecs_7e;
			set< SFC::StateLabel> stateLabels_80= state_72.src();
			for( set< SFC::StateLabel>::const_iterator itStateLabels_81= stateLabels_80.begin(); itStateLabels_81!= stateLabels_80.end(); ++itStateLabels_81)
			{
				SFC::StateLabel currStateLabel_82= *itStateLabels_81;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_86;
				if( !isValidBound(boundObjs_86, state_72, true))
					continue;
				currMatch.state_87= state_72;
				if( !isValidBound(boundObjs_86, program_7b, true))
					continue;
				currMatch.program_88= program_7b;
				if( !isValidBound(boundObjs_86, currStateLabel_82, false))
					continue;
				currMatch.stateLabel_89= currStateLabel_82;
				if( !isValidBound(boundObjs_86, currExec_7f, false))
					continue;
				currMatch.exec_8a= currExec_7f;
				bool Gz_guard= isGuardTrue( currMatch.exec_8a, currMatch.program_88, currMatch.state_87, currMatch.stateLabel_89);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetGRFuncStateFunction_62::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_87, currMatch.exec_8a);
	}
}

void GetGRFuncStateFunction_62::outputAppender( const CyPhyML::SignalFlow::State& state_8f, const SFC::Function& exec_91)
{
	_state_69->push_back( state_8f);
	_exec_6a->push_back( exec_91);
}

void DirectInFunction_93::operator()( const Packets_t& states_94, const Packets_t& functions_97, Packets_t& states_96, Packets_t& functions_99)
{
#ifdef PRINT_INFO
	printLog( "DirectInFunction_93" );
#endif
	RTTGenerator::Instance()->generateRule(57, "DirectInFunction");
	_state_9a= &states_96;
	_function_9b= &functions_99;
	processInputPackets( states_94, functions_97);
	forwardInputs( );
}

bool DirectInFunction_93::isInputUnique( const Udm::Object& state_a0, const Udm::Object& function_a9)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_a2= _state_9c.begin(), itFunction_ab= _function_a5.begin(); itState_a2!= _state_9c.end(), itFunction_ab!= _function_a5.end(); ++itState_a2, ++itFunction_ab)
	{
		if( ( *itState_a2== state_a0)&& ( *itFunction_ab== function_a9))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_9c.push_back( state_a0);
		_function_a5.push_back( function_a9);
	}
	return isUnique;
}

void DirectInFunction_93::processInputPackets( const Packets_t& states_94, const Packets_t& functions_97)
{
	for( Packets_t::const_iterator itState_9d= states_94.begin(), itFunction_a6= functions_97.begin(); itState_9d!= states_94.end(), itFunction_a6!= functions_97.end(); ++itState_9d, ++itFunction_a6)
	{
		bool isUnique= isInputUnique( *itState_9d, *itFunction_a6);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_9d, *itFunction_a6);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool DirectInFunction_93::patternMatcher( const Udm::Object& state_9e, const Udm::Object& function_a7)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_9e.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_a3= CyPhyML::SignalFlow::State::Cast( state_9e);
		if( false== Uml::IsDerivedFrom( function_a7.type(), SFC::Function::meta))
			continue;
		SFC::Function function_ac= SFC::Function::Cast( function_a7);
		Match currMatch;
		currMatch.state_af= state_a3;
		currMatch.function_b0= function_ac;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void DirectInFunction_93::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
	}
}

void DirectInFunction_93::forwardInputs()
{
	*_state_9a= _state_9c;
	*_function_9b= _function_a5;
}

void TransStartTransitions_b1::operator()( const Packets_t& states_b2, const Packets_t& fcns_b4, const Packets_t& css_b6)
{
#ifdef PRINT_INFO
	printLog( "TransStartTransitions_b1" );
#endif
	if( ( !states_b2.empty())&& ( !fcns_b4.empty())&& ( !css_b6.empty()))
		callInitTCVarLoop_9fa( states_b2, fcns_b4, css_b6);
}

void TransStartTransitions_b1::callInitTCVarLoop_9fa( const Packets_t& states_f3, const Packets_t& functions_f6, const Packets_t& compoundStatements_f9)
{
	Packets_t states_f5;
	Packets_t functions_f8;
	Packets_t conditionalGroups_fb;
	InitTCVarLoop_f2 initTCVarLoop_f2;
	initTCVarLoop_f2( states_f3, functions_f6, compoundStatements_f9, states_f5, functions_f8, conditionalGroups_fb);
	if( ( !states_f5.empty())&& ( !functions_f8.empty())&& ( !conditionalGroups_fb.empty()))
		callGetStartTC_9fe( states_f5, functions_f8, conditionalGroups_fb);
}

void TransStartTransitions_b1::callGetStartTC_9fe( const Packets_t& states_b9, const Packets_t& functions_bd, const Packets_t& conditionalGroups_c0)
{
	Packets_t states_bb;
	Packets_t transStarts_bc;
	Packets_t functions_bf;
	Packets_t conditionalGroups_c2;
	GetStartTC_b8 getStartTC_b8;
	getStartTC_b8( states_b9, functions_bd, conditionalGroups_c0, states_bb, transStarts_bc, functions_bf, conditionalGroups_c2);
	if( ( !states_bb.empty())&& ( !transStarts_bc.empty())&& ( !functions_bf.empty())&& ( !conditionalGroups_c2.empty()))
		callEnterTransConnectorRecurse_a02( states_bb, transStarts_bc, functions_bf, conditionalGroups_c2);
}

void TransStartTransitions_b1::callEnterTransConnectorRecurse_a02( const Packets_t& states_137, const Packets_t& tcs_139, const Packets_t& fcns_13b, const Packets_t& cgs_13d)
{
	EnterTransConnectorRecurse_136 enterTransConnectorRecurse_136;
	enterTransConnectorRecurse_136( states_137, tcs_139, fcns_13b, cgs_13d);
}

void GetStartTC_b8::operator()( const Packets_t& states_b9, const Packets_t& functions_bd, const Packets_t& conditionalGroups_c0, Packets_t& states_bb, Packets_t& transStarts_bc, Packets_t& functions_bf, Packets_t& conditionalGroups_c2)
{
#ifdef PRINT_INFO
	printLog( "GetStartTC_b8" );
#endif
	RTTGenerator::Instance()->generateRule(690, "GetStartTC");
	_state_c3= &states_bb;
	_transStart_c4= &transStarts_bc;
	_function_c5= &functions_bf;
	_conditionalGroup_c6= &conditionalGroups_c2;
	processInputPackets( states_b9, functions_bd, conditionalGroups_c0);
}

bool GetStartTC_b8::isInputUnique( const Udm::Object& state_cb, const Udm::Object& function_d4, const Udm::Object& conditionalGroup_dd)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_cd= _state_c7.begin(), itFunction_d6= _function_d0.begin(), itConditionalGroup_df= _conditionalGroup_d9.begin(); itState_cd!= _state_c7.end(), itFunction_d6!= _function_d0.end(), itConditionalGroup_df!= _conditionalGroup_d9.end(); ++itState_cd, ++itFunction_d6, ++itConditionalGroup_df)
	{
		if( ( *itState_cd== state_cb)&& ( *itFunction_d6== function_d4)&& ( *itConditionalGroup_df== conditionalGroup_dd))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_c7.push_back( state_cb);
		_function_d0.push_back( function_d4);
		_conditionalGroup_d9.push_back( conditionalGroup_dd);
	}
	return isUnique;
}

void GetStartTC_b8::processInputPackets( const Packets_t& states_b9, const Packets_t& functions_bd, const Packets_t& conditionalGroups_c0)
{
	for( Packets_t::const_iterator itState_c8= states_b9.begin(), itFunction_d1= functions_bd.begin(), itConditionalGroup_da= conditionalGroups_c0.begin(); itState_c8!= states_b9.end(), itFunction_d1!= functions_bd.end(), itConditionalGroup_da!= conditionalGroups_c0.end(); ++itState_c8, ++itFunction_d1, ++itConditionalGroup_da)
	{
		bool isUnique= isInputUnique( *itState_c8, *itFunction_d1, *itConditionalGroup_da);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_c8, *itFunction_d1, *itConditionalGroup_da);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetStartTC_b8::patternMatcher( const Udm::Object& state_c9, const Udm::Object& function_d2, const Udm::Object& conditionalGroup_db)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_c9.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_ce= CyPhyML::SignalFlow::State::Cast( state_c9);
		if( false== Uml::IsDerivedFrom( function_d2.type(), SFC::Function::meta))
			continue;
		SFC::Function function_d7= SFC::Function::Cast( function_d2);
		if( false== Uml::IsDerivedFrom( conditionalGroup_db.type(), SFC::ConditionalGroup::meta))
			continue;
		SFC::ConditionalGroup conditionalGroup_e0= SFC::ConditionalGroup::Cast( conditionalGroup_db);
		set< CyPhyML::SignalFlow::TransStart> transStarts_e2= state_ce.TransStart_kind_children();
		for( set< CyPhyML::SignalFlow::TransStart>::const_iterator itTransStart_e3= transStarts_e2.begin(); itTransStart_e3!= transStarts_e2.end(); ++itTransStart_e3)
		{
			CyPhyML::SignalFlow::TransStart currTransStart_e4= *itTransStart_e3;
			Match currMatch;
			currMatch.state_e6= state_ce;
			currMatch.function_e7= function_d7;
			currMatch.conditionalGroup_e8= conditionalGroup_e0;
			currMatch.transStart_e9= currTransStart_e4;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetStartTC_b8::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_e6, currMatch.transStart_e9, currMatch.function_e7, currMatch.conditionalGroup_e8);
	}
}

void GetStartTC_b8::outputAppender( const CyPhyML::SignalFlow::State& state_ea, const CyPhyML::SignalFlow::TransStart& transStart_ec, const SFC::Function& function_ee, const SFC::ConditionalGroup& conditionalGroup_f0)
{
	_state_c3->push_back( state_ea);
	_transStart_c4->push_back( transStart_ec);
	_function_c5->push_back( function_ee);
	_conditionalGroup_c6->push_back( conditionalGroup_f0);
}

void InitTCVarLoop_f2::operator()( const Packets_t& states_f3, const Packets_t& functions_f6, const Packets_t& compoundStatements_f9, Packets_t& states_f5, Packets_t& functions_f8, Packets_t& conditionalGroups_fb)
{
#ifdef PRINT_INFO
	printLog( "InitTCVarLoop_f2" );
#endif
	RTTGenerator::Instance()->generateRule(826, "InitTCVarLoop");
	_state_fc= &states_f5;
	_function_fd= &functions_f8;
	_conditionalGroup_fe= &conditionalGroups_fb;
	processInputPackets( states_f3, functions_f6, compoundStatements_f9);
}

bool InitTCVarLoop_f2::isInputUnique( const Udm::Object& state_103, const Udm::Object& function_10c, const Udm::Object& compoundStatement_115)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_105= _state_ff.begin(), itFunction_10e= _function_108.begin(), itCompoundStatement_117= _compoundStatement_111.begin(); itState_105!= _state_ff.end(), itFunction_10e!= _function_108.end(), itCompoundStatement_117!= _compoundStatement_111.end(); ++itState_105, ++itFunction_10e, ++itCompoundStatement_117)
	{
		if( ( *itState_105== state_103)&& ( *itFunction_10e== function_10c)&& ( *itCompoundStatement_117== compoundStatement_115))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_ff.push_back( state_103);
		_function_108.push_back( function_10c);
		_compoundStatement_111.push_back( compoundStatement_115);
	}
	return isUnique;
}

bool InitTCVarLoop_f2::isGuardTrue( SFC::CompoundStatement& CompoundStatement, SFC::Function& Function, CyPhyML::SignalFlow::State& State, SFC::LocalVar& TCVar)
{
	bool Gz_guard= false;
	return static_cast< std::string >( TCVar.name() ) == "_TCVar_";;
	return Gz_guard;
}

void InitTCVarLoop_f2::processInputPackets( const Packets_t& states_f3, const Packets_t& functions_f6, const Packets_t& compoundStatements_f9)
{
	for( Packets_t::const_iterator itState_100= states_f3.begin(), itFunction_109= functions_f6.begin(), itCompoundStatement_112= compoundStatements_f9.begin(); itState_100!= states_f3.end(), itFunction_109!= functions_f6.end(), itCompoundStatement_112!= compoundStatements_f9.end(); ++itState_100, ++itFunction_109, ++itCompoundStatement_112)
	{
		bool isUnique= isInputUnique( *itState_100, *itFunction_109, *itCompoundStatement_112);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_100, *itFunction_109, *itCompoundStatement_112);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitTCVarLoop_f2::patternMatcher( const Udm::Object& state_101, const Udm::Object& function_10a, const Udm::Object& compoundStatement_113)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_101.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_106= CyPhyML::SignalFlow::State::Cast( state_101);
		if( false== Uml::IsDerivedFrom( function_10a.type(), SFC::Function::meta))
			continue;
		SFC::Function function_10f= SFC::Function::Cast( function_10a);
		if( false== Uml::IsDerivedFrom( compoundStatement_113.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_118= SFC::CompoundStatement::Cast( compoundStatement_113);
		set< SFC::LocalVar> tCVars_11a= function_10f.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itTCVar_11b= tCVars_11a.begin(); itTCVar_11b!= tCVars_11a.end(); ++itTCVar_11b)
		{
			SFC::LocalVar currTCVar_11c= *itTCVar_11b;
			Match currMatch;
			currMatch.state_11e= state_106;
			currMatch.function_11f= function_10f;
			currMatch.compoundStatement_120= compoundStatement_118;
			currMatch.tCVar_121= currTCVar_11c;
			bool Gz_guard= isGuardTrue( currMatch.compoundStatement_120, currMatch.function_11f, currMatch.state_11e, currMatch.tCVar_121);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void InitTCVarLoop_f2::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::IterativeBlock newIterativeBlock_126= SFC::IterativeBlock::Create( currMatch.compoundStatement_120, SFC::CompoundStatement::meta_stmnt);
		SFC::ConditionalGroup newConditionalGroup_127= SFC::ConditionalGroup::Create( newIterativeBlock_126, SFC::IterativeBlock::meta_stmnt);
		SFC::UserCode newInitTCVar_128= SFC::UserCode::Create( currMatch.compoundStatement_120, SFC::CompoundStatement::meta_stmnt);
		SFC::BinaryExprs newAssignTCVar_129= SFC::BinaryExprs::Create( newInitTCVar_128, SFC::UserCode::meta_codeexpr);
		SFC::Int newZero_12a= SFC::Int::Create( newAssignTCVar_129, SFC::BinaryExprs::meta_rightexpr);
		SFC::UserCode newUserCode_12b= SFC::UserCode::Create( newIterativeBlock_126, SFC::IterativeBlock::meta_cond);
		SFC::ArgDeclRef newAssignTCArgDeclRef_12c= SFC::ArgDeclRef::Create( newAssignTCVar_129, SFC::BinaryExprs::meta_leftexpr);
		SFC::BinaryExprs newNotEqualTo_12d= SFC::BinaryExprs::Create( newUserCode_12b, SFC::UserCode::meta_codeexpr);
		SFC::ArgDeclRef newEqualsTCArgDeclRef_12e= SFC::ArgDeclRef::Create( newNotEqualTo_12d, SFC::BinaryExprs::meta_leftexpr);
		SFC::Int newNegOne_12f= SFC::Int::Create( newNotEqualTo_12d, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef& AssignTCArgDeclRef= newAssignTCArgDeclRef_12c;
		SFC::BinaryExprs& AssignTCVar= newAssignTCVar_129;
		SFC::CompoundStatement& CompoundStatement= currMatch.compoundStatement_120;
		SFC::ConditionalGroup& ConditionalGroup= newConditionalGroup_127;
		SFC::ArgDeclRef& EqualsTCArgDeclRef= newEqualsTCArgDeclRef_12e;
		SFC::Function& Function= currMatch.function_11f;
		SFC::UserCode& InitTCVar= newInitTCVar_128;
		SFC::IterativeBlock& IterativeBlock= newIterativeBlock_126;
		SFC::Int& NegOne= newNegOne_12f;
		SFC::BinaryExprs& NotEqualTo= newNotEqualTo_12d;
		CyPhyML::SignalFlow::State& State= currMatch.state_11e;
		SFC::LocalVar& TCVar= currMatch.tCVar_121;
		SFC::UserCode& UserCode= newUserCode_12b;
		SFC::Int& Zero= newZero_12a;
		{
__int64 statementCount = IterativeBlock.statementCount();
ConditionalGroup.statementIndex() = statementCount++;
IterativeBlock.statementCount() = statementCount;
};
		{
AssignTCVar.op() = "=";
};
		{
NotEqualTo.op() = "!=";
};
		{
NegOne.val() = -1;
};
		{
__int64 statementCount = CompoundStatement.statementCount();
InitTCVar.statementIndex() = statementCount++;
IterativeBlock.statementIndex() = statementCount++;
CompoundStatement.statementCount() = statementCount;
};
		{
Zero.val() = 0;
};
		{
InitTCVar.RefId() = IterativeBlock.RefId() = ConditionalGroup.RefId() = UserCode.RefId() = CompoundStatement.RefId();
};
		newAssignTCArgDeclRef_12c.argdecl()= currMatch.tCVar_121;
		newEqualsTCArgDeclRef_12e.argdecl()= currMatch.tCVar_121;
		outputAppender( currMatch.state_11e, currMatch.function_11f, newConditionalGroup_127);
	}
}

void InitTCVarLoop_f2::outputAppender( const CyPhyML::SignalFlow::State& state_130, const SFC::Function& function_132, const SFC::ConditionalGroup& conditionalGroup_134)
{
	_state_fc->push_back( state_130);
	_function_fd->push_back( function_132);
	_conditionalGroup_fe->push_back( conditionalGroup_134);
}

void EnterTransConnectorRecurse_136::operator()( const Packets_t& states_137, const Packets_t& tcs_139, const Packets_t& fcns_13b, const Packets_t& cgs_13d)
{
#ifdef PRINT_INFO
	printLog( "EnterTransConnectorRecurse_136" );
#endif
	for( Packets_t::const_iterator itstate_140= states_137.begin(), ittc_147= tcs_139.begin(), itfcn_14e= fcns_13b.begin(), itcg_155= cgs_13d.begin(); itstate_140!= states_137.end(), ittc_147!= tcs_139.end(), itfcn_14e!= fcns_13b.end(), itcg_155!= cgs_13d.end(); ++itstate_140, ++ittc_147, ++itfcn_14e, ++itcg_155)
	{
		bool isUnique= isInputUnique( *itstate_140, *ittc_147, *itfcn_14e, *itcg_155);
		if( !isUnique)
			continue;
		Packets_t onestate_144( 1, *itstate_140);
		Packets_t onetc_14b( 1, *ittc_147);
		Packets_t onefcn_152( 1, *itfcn_14e);
		Packets_t onecg_159( 1, *itcg_155);
		executeOne( onestate_144, onetc_14b, onefcn_152, onecg_159);
	}
}

void EnterTransConnectorRecurse_136::executeOne( const Packets_t& states_137, const Packets_t& tcs_139, const Packets_t& fcns_13b, const Packets_t& cgs_13d)
{
	if( ( !states_137.empty())&& ( !tcs_139.empty())&& ( !fcns_13b.empty())&& ( !cgs_13d.empty()))
		callProcessedFilter_9e6( states_137, tcs_139, fcns_13b, cgs_13d);
}

bool EnterTransConnectorRecurse_136::isInputUnique( const Udm::Object& state_141, const Udm::Object& tc_148, const Udm::Object& fcn_14f, const Udm::Object& cg_156)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_143= _state_13f.begin(), ittc_14a= _tc_146.begin(), itfcn_151= _fcn_14d.begin(), itcg_158= _cg_154.begin(); itstate_143!= _state_13f.end(), ittc_14a!= _tc_146.end(), itfcn_151!= _fcn_14d.end(), itcg_158!= _cg_154.end(); ++itstate_143, ++ittc_14a, ++itfcn_151, ++itcg_158)
	{
		if( ( *itstate_143== state_141)&& ( *ittc_14a== tc_148)&& ( *itfcn_151== fcn_14f)&& ( *itcg_158== cg_156))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_13f.push_back( state_141);
		_tc_146.push_back( tc_148);
		_fcn_14d.push_back( fcn_14f);
		_cg_154.push_back( cg_156);
	}
	return isUnique;
}

void EnterTransConnectorRecurse_136::callProcessedFilter_9e6( const Packets_t& states_81a, const Packets_t& tcs_81c, const Packets_t& fcns_81e, const Packets_t& cgs_820)
{
	Packets_t states_822;
	Packets_t tcs_823;
	Packets_t fcns_824;
	Packets_t cgs_825;
	ProcessedFilter_819 processedFilter_819;
	processedFilter_819( states_81a, tcs_81c, fcns_81e, cgs_820, states_822, tcs_823, fcns_824, cgs_825);
	if( ( !states_822.empty())&& ( !tcs_823.empty())&& ( !fcns_824.empty())&& ( !cgs_825.empty()))
		callCreateTransitionCG_9eb( states_822, tcs_823, fcns_824, cgs_825);
}

void EnterTransConnectorRecurse_136::callCreateTransitionCG_9eb( const Packets_t& states_7c9, const Packets_t& transConnectors_7cc, const Packets_t& functions_7cf, const Packets_t& tCVarCGs_7d3)
{
	Packets_t states_7cb;
	Packets_t transConnectors_7ce;
	Packets_t functions_7d1;
	Packets_t transitionCGs_7d2;
	CreateTransitionCG_7c8 createTransitionCG_7c8;
	createTransitionCG_7c8( states_7c9, transConnectors_7cc, functions_7cf, tCVarCGs_7d3, states_7cb, transConnectors_7ce, functions_7d1, transitionCGs_7d2);
	if( ( !states_7cb.empty())&& ( !transConnectors_7ce.empty())&& ( !functions_7d1.empty())&& ( !transitionCGs_7d2.empty()))
		callEnterTransitions_9f0( states_7cb, transConnectors_7ce, functions_7d1, transitionCGs_7d2);
}

void EnterTransConnectorRecurse_136::callEnterTransitions_9f0( const Packets_t& states_15c, const Packets_t& tcs_15e, const Packets_t& fcns_160, const Packets_t& css_162)
{
	Packets_t states_164;
	Packets_t tcs_165;
	Packets_t fcns_166;
	Packets_t css_167;
	EnterTransitions_15b enterTransitions_15b;
	enterTransitions_15b( states_15c, tcs_15e, fcns_160, css_162, states_164, tcs_165, fcns_166, css_167);
	if( ( !states_164.empty())&& ( !tcs_165.empty())&& ( !fcns_166.empty())&& ( !css_167.empty()))
		callNoDefaultTransition_9f5( states_164, tcs_165, fcns_166, css_167);
}

void EnterTransConnectorRecurse_136::callNoDefaultTransition_9f5( const Packets_t& states_88d, const Packets_t& tcs_88f, const Packets_t& fcns_891, const Packets_t& css_893)
{
	NoDefaultTransition_88c noDefaultTransition_88c;
	noDefaultTransition_88c( states_88d, tcs_88f, fcns_891, css_893);
}

void EnterTransitions_15b::operator()( const Packets_t& states_15c, const Packets_t& tcs_15e, const Packets_t& fcns_160, const Packets_t& css_162, Packets_t& states_164, Packets_t& tcs_165, Packets_t& fcns_166, Packets_t& css_167)
{
#ifdef PRINT_INFO
	printLog( "EnterTransitions_15b" );
#endif
	_state_168= &states_164;
	_tc_169= &tcs_165;
	_fcn_16a= &fcns_166;
	_cs_16b= &css_167;
	if( ( !states_15c.empty())&& ( !tcs_15e.empty())&& ( !fcns_160.empty())&& ( !css_162.empty()))
		callGetAllTransitions_7be( states_15c, tcs_15e, fcns_160, css_162);
	_state_168->insert( _state_168->end(), states_15c.begin(), states_15c.end());
	_tc_169->insert( _tc_169->end(), tcs_15e.begin(), tcs_15e.end());
	_fcn_16a->insert( _fcn_16a->end(), fcns_160.begin(), fcns_160.end());
	_cs_16b->insert( _cs_16b->end(), css_162.begin(), css_162.end());
}

void EnterTransitions_15b::callGetAllTransitions_7be( const Packets_t& states_6b4, const Packets_t& tcs_6b6, const Packets_t& fcns_6b8, const Packets_t& css_6ba)
{
	Packets_t states_6bc;
	Packets_t transs_6bd;
	Packets_t fcns_6be;
	Packets_t css_6bf;
	GetAllTransitions_6b3 getAllTransitions_6b3;
	getAllTransitions_6b3( states_6b4, tcs_6b6, fcns_6b8, css_6ba, states_6bc, transs_6bd, fcns_6be, css_6bf);
	if( ( !states_6bc.empty())&& ( !transs_6bd.empty())&& ( !fcns_6be.empty())&& ( !css_6bf.empty()))
		callEnterProcessTransitions_7c3( states_6bc, transs_6bd, fcns_6be, css_6bf);
}

void EnterTransitions_15b::callEnterProcessTransitions_7c3( const Packets_t& states_16d, const Packets_t& transs_16f, const Packets_t& fcns_171, const Packets_t& css_173)
{
	EnterProcessTransitions_16c enterProcessTransitions_16c;
	enterProcessTransitions_16c( states_16d, transs_16f, fcns_171, css_173);
}

void EnterProcessTransitions_16c::operator()( const Packets_t& states_16d, const Packets_t& transs_16f, const Packets_t& fcns_171, const Packets_t& css_173)
{
#ifdef PRINT_INFO
	printLog( "EnterProcessTransitions_16c" );
#endif
	if( ( !states_16d.empty())&& ( !transs_16f.empty())&& ( !fcns_171.empty())&& ( !css_173.empty()))
		callOrderTransitions_680( states_16d, transs_16f, fcns_171, css_173);
}

void EnterProcessTransitions_16c::callOrderTransitions_680( const Packets_t& states_63f, const Packets_t& transitions_642, const Packets_t& functions_645, const Packets_t& compoundStatements_648)
{
	Packets_t states_641;
	Packets_t transitions_644;
	Packets_t functions_647;
	Packets_t compoundStatements_64a;
	OrderTransitions_63e orderTransitions_63e;
	orderTransitions_63e( states_63f, transitions_642, functions_645, compoundStatements_648, states_641, transitions_644, functions_647, compoundStatements_64a);
	if( ( !states_641.empty())&& ( !transitions_644.empty())&& ( !functions_647.empty())&& ( !compoundStatements_64a.empty()))
		callTransCond_685( states_641, transitions_644, functions_647, compoundStatements_64a);
}

void EnterProcessTransitions_16c::callTransCond_685( const Packets_t& states_331, const Packets_t& transitions_335, const Packets_t& functions_338, const Packets_t& transitionCGs_33b)
{
	Packets_t states_333;
	Packets_t dstTransConnectors_334;
	Packets_t transitions_337;
	Packets_t functions_33a;
	Packets_t conditionalBlocks_33d;
	TransCond_330 transCond_330;
	transCond_330( states_331, transitions_335, functions_338, transitionCGs_33b, states_333, dstTransConnectors_334, transitions_337, functions_33a, conditionalBlocks_33d);
	if( ( !states_333.empty())&& ( !dstTransConnectors_334.empty())&& ( !transitions_337.empty())&& ( !functions_33a.empty())&& ( !conditionalBlocks_33d.empty()))
		callTest_68a( states_333, dstTransConnectors_334, transitions_337, functions_33a, conditionalBlocks_33d);
}

void EnterProcessTransitions_16c::callTest_68a( const Packets_t& states_37c, const Packets_t& dsts_37e, const Packets_t& transs_380, const Packets_t& fcns_382, const Packets_t& cbs_384)
{
	Packets_t states_386;
	Packets_t dsts_387;
	Packets_t transs_388;
	Packets_t fcns_389;
	Packets_t cbs_38a;
	Packets_t states_38b;
	Packets_t dsts_38c;
	Packets_t transs_38d;
	Packets_t fcns_38e;
	Packets_t cbs_38f;
	Packets_t states_390;
	Packets_t dsts_391;
	Packets_t transs_392;
	Packets_t fcns_393;
	Packets_t cbs_394;
	Packets_t states_395;
	Packets_t dsts_396;
	Packets_t transs_397;
	Packets_t fcns_398;
	Packets_t cbs_399;
	Packets_t states_39a;
	Packets_t dsts_39b;
	Packets_t transs_39c;
	Packets_t fcns_39d;
	Packets_t cbs_39e;
	Test_37b test_37b;
	test_37b( states_37c, dsts_37e, transs_380, fcns_382, cbs_384, states_386, dsts_387, transs_388, fcns_389, cbs_38a, states_38b, dsts_38c, transs_38d, fcns_38e, cbs_38f, states_390, dsts_391, transs_392, fcns_393, cbs_394, states_395, dsts_396, transs_397, fcns_398, cbs_399, states_39a, dsts_39b, transs_39c, fcns_39d, cbs_39e);
	if( ( !states_386.empty())&& ( !dsts_387.empty())&& ( !transs_388.empty())&& ( !fcns_389.empty())&& ( !cbs_38a.empty()))
		callEnterNextState_690( states_386, dsts_387, transs_388, fcns_389, cbs_38a);
	if( ( !states_390.empty())&& ( !dsts_391.empty())&& ( !transs_392.empty())&& ( !fcns_393.empty())&& ( !cbs_394.empty()))
		callNextJunction_696( states_390, dsts_391, transs_392, fcns_393, cbs_394);
	if( ( !states_39a.empty())&& ( !dsts_39b.empty())&& ( !transs_39c.empty())&& ( !fcns_39d.empty())&& ( !cbs_39e.empty()))
		callDeadEndJunction_69c( states_39a, dsts_39b, transs_39c, fcns_39d, cbs_39e);
	if( ( !states_395.empty())&& ( !dsts_396.empty())&& ( !transs_397.empty())&& ( !fcns_398.empty())&& ( !cbs_399.empty()))
		callGetDstJuncFromRef_6a2( states_395, dsts_396, transs_397, fcns_398, cbs_399);
	if( ( !states_38b.empty())&& ( !dsts_38c.empty())&& ( !transs_38d.empty())&& ( !fcns_38e.empty())&& ( !cbs_38f.empty()))
		callGetDstStateFromRef_6a8( states_38b, dsts_38c, transs_38d, fcns_38e, cbs_38f);
}

void EnterProcessTransitions_16c::callEnterNextState_690( const Packets_t& states_176, const Packets_t& dstStates_178, const Packets_t& transitions_17a, const Packets_t& functions_17c, const Packets_t& transitionCBs_17e)
{
	EnterNextState_175 enterNextState_175;
	enterNextState_175( states_176, dstStates_178, transitions_17a, functions_17c, transitionCBs_17e);
}

void EnterProcessTransitions_16c::callNextJunction_696( const Packets_t& states_1d3, const Packets_t& junctions_1d6, const Packets_t& transitions_1d9, const Packets_t& functions_1db, const Packets_t& transitionCBs_1de)
{
	Packets_t states_1d5;
	Packets_t junctions_1d8;
	Packets_t functions_1dd;
	Packets_t conditionalGroups_1e0;
	NextJunction_1d2 nextJunction_1d2;
	nextJunction_1d2( states_1d3, junctions_1d6, transitions_1d9, functions_1db, transitionCBs_1de, states_1d5, junctions_1d8, functions_1dd, conditionalGroups_1e0);
	if( ( !states_1d5.empty())&& ( !junctions_1d8.empty())&& ( !functions_1dd.empty())&& ( !conditionalGroups_1e0.empty()))
		callEnterTransConnectorRecurse_6ae( states_1d5, junctions_1d8, functions_1dd, conditionalGroups_1e0);
}

void EnterProcessTransitions_16c::callDeadEndJunction_69c( const Packets_t& states_2e5, const Packets_t& transConnectors_2e7, const Packets_t& transitions_2e9, const Packets_t& functions_2eb, const Packets_t& transitionCBs_2ed)
{
	DeadEndJunction_2e4 deadEndJunction_2e4;
	deadEndJunction_2e4( states_2e5, transConnectors_2e7, transitions_2e9, functions_2eb, transitionCBs_2ed);
}

void EnterProcessTransitions_16c::callGetDstJuncFromRef_6a2( const Packets_t& states_23b, const Packets_t& connectorRefs_23e, const Packets_t& transitions_241, const Packets_t& functions_244, const Packets_t& conditionalBlocks_247)
{
	Packets_t states_23d;
	Packets_t junctions_240;
	Packets_t transitions_243;
	Packets_t functions_246;
	Packets_t conditionalBlocks_249;
	GetDstJuncFromRef_23a getDstJuncFromRef_23a;
	getDstJuncFromRef_23a( states_23b, connectorRefs_23e, transitions_241, functions_244, conditionalBlocks_247, states_23d, junctions_240, transitions_243, functions_246, conditionalBlocks_249);
	if( ( !states_23d.empty())&& ( !junctions_240.empty())&& ( !transitions_243.empty())&& ( !functions_246.empty())&& ( !conditionalBlocks_249.empty()))
		callNextJunction_696( states_23d, junctions_240, transitions_243, functions_246, conditionalBlocks_249);
}

void EnterProcessTransitions_16c::callGetDstStateFromRef_6a8( const Packets_t& states_290, const Packets_t& connectorRefs_294, const Packets_t& transitions_296, const Packets_t& functions_299, const Packets_t& conditionalBlocks_29c)
{
	Packets_t states_292;
	Packets_t dstStates_293;
	Packets_t transitions_298;
	Packets_t functions_29b;
	Packets_t conditionalBlocks_29e;
	GetDstStateFromRef_28f getDstStateFromRef_28f;
	getDstStateFromRef_28f( states_290, connectorRefs_294, transitions_296, functions_299, conditionalBlocks_29c, states_292, dstStates_293, transitions_298, functions_29b, conditionalBlocks_29e);
	if( ( !states_292.empty())&& ( !dstStates_293.empty())&& ( !transitions_298.empty())&& ( !functions_29b.empty())&& ( !conditionalBlocks_29e.empty()))
		callEnterNextState_690( states_292, dstStates_293, transitions_298, functions_29b, conditionalBlocks_29e);
}

void EnterProcessTransitions_16c::callEnterTransConnectorRecurse_6ae( const Packets_t& states_137, const Packets_t& tcs_139, const Packets_t& fcns_13b, const Packets_t& cgs_13d)
{
	EnterTransConnectorRecurse_136 enterTransConnectorRecurse_136;
	enterTransConnectorRecurse_136( states_137, tcs_139, fcns_13b, cgs_13d);
}

void EnterNextState_175::operator()( const Packets_t& states_176, const Packets_t& dstStates_178, const Packets_t& transitions_17a, const Packets_t& functions_17c, const Packets_t& transitionCBs_17e)
{
#ifdef PRINT_INFO
	printLog( "EnterNextState_175" );
#endif
	RTTGenerator::Instance()->generateRule(2247, "EnterNextState");
	processInputPackets( states_176, dstStates_178, transitions_17a, functions_17c, transitionCBs_17e);
}

bool EnterNextState_175::isInputUnique( const Udm::Object& state_184, const Udm::Object& dstState_18d, const Udm::Object& transition_196, const Udm::Object& function_19f, const Udm::Object& transitionCB_1a8)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_186= _state_180.begin(), itDstState_18f= _dstState_189.begin(), itTransition_198= _transition_192.begin(), itFunction_1a1= _function_19b.begin(), itTransitionCB_1aa= _transitionCB_1a4.begin(); itState_186!= _state_180.end(), itDstState_18f!= _dstState_189.end(), itTransition_198!= _transition_192.end(), itFunction_1a1!= _function_19b.end(), itTransitionCB_1aa!= _transitionCB_1a4.end(); ++itState_186, ++itDstState_18f, ++itTransition_198, ++itFunction_1a1, ++itTransitionCB_1aa)
	{
		if( ( *itState_186== state_184)&& ( *itDstState_18f== dstState_18d)&& ( *itTransition_198== transition_196)&& ( *itFunction_1a1== function_19f)&& ( *itTransitionCB_1aa== transitionCB_1a8))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_180.push_back( state_184);
		_dstState_189.push_back( dstState_18d);
		_transition_192.push_back( transition_196);
		_function_19b.push_back( function_19f);
		_transitionCB_1a4.push_back( transitionCB_1a8);
	}
	return isUnique;
}

bool EnterNextState_175::isGuardTrue( CyPhyML::SignalFlow::State& DstState, SFC::Function& Enter, SFC::Arg& EnterArg0, SFC::Arg& EnterArg1, SFC::Function& Function, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel, CyPhyML::SignalFlow::Transition& Transition, SFC::ConditionalBlock& TransitionCB)
{
	bool Gz_guard= false;
	return EnterArg0.argIndex() == 0 && EnterArg1.argIndex() == 1;;
	return Gz_guard;
}

void EnterNextState_175::processInputPackets( const Packets_t& states_176, const Packets_t& dstStates_178, const Packets_t& transitions_17a, const Packets_t& functions_17c, const Packets_t& transitionCBs_17e)
{
	for( Packets_t::const_iterator itState_181= states_176.begin(), itDstState_18a= dstStates_178.begin(), itTransition_193= transitions_17a.begin(), itFunction_19c= functions_17c.begin(), itTransitionCB_1a5= transitionCBs_17e.begin(); itState_181!= states_176.end(), itDstState_18a!= dstStates_178.end(), itTransition_193!= transitions_17a.end(), itFunction_19c!= functions_17c.end(), itTransitionCB_1a5!= transitionCBs_17e.end(); ++itState_181, ++itDstState_18a, ++itTransition_193, ++itFunction_19c, ++itTransitionCB_1a5)
	{
		bool isUnique= isInputUnique( *itState_181, *itDstState_18a, *itTransition_193, *itFunction_19c, *itTransitionCB_1a5);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_181, *itDstState_18a, *itTransition_193, *itFunction_19c, *itTransitionCB_1a5);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool EnterNextState_175::patternMatcher( const Udm::Object& state_182, const Udm::Object& dstState_18b, const Udm::Object& transition_194, const Udm::Object& function_19d, const Udm::Object& transitionCB_1a6)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_182.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_187= CyPhyML::SignalFlow::State::Cast( state_182);
		if( false== Uml::IsDerivedFrom( dstState_18b.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State dstState_190= CyPhyML::SignalFlow::State::Cast( dstState_18b);
		if( false== Uml::IsDerivedFrom( transition_194.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_199= CyPhyML::SignalFlow::Transition::Cast( transition_194);
		if( false== Uml::IsDerivedFrom( function_19d.type(), SFC::Function::meta))
			continue;
		SFC::Function function_1a2= SFC::Function::Cast( function_19d);
		if( false== Uml::IsDerivedFrom( transitionCB_1a6.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock transitionCB_1ab= SFC::ConditionalBlock::Cast( transitionCB_1a6);
		set< SFC::Function> enters_1ad= dstState_190.enter();
		for( set< SFC::Function>::const_iterator itEnters_1ae= enters_1ad.begin(); itEnters_1ae!= enters_1ad.end(); ++itEnters_1ae)
		{
			SFC::Function currEnter_1af= *itEnters_1ae;
			set< SFC::Arg> enterArg1s_1b0= currEnter_1af.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itEnterArg1_1b1= enterArg1s_1b0.begin(); itEnterArg1_1b1!= enterArg1s_1b0.end(); ++itEnterArg1_1b1)
			{
				SFC::Arg currEnterArg1_1b2= *itEnterArg1_1b1;
				set< SFC::Arg> enterArg0s_1b3= currEnter_1af.Arg_kind_children();
				for( set< SFC::Arg>::const_iterator itEnterArg0_1b4= enterArg0s_1b3.begin(); itEnterArg0_1b4!= enterArg0s_1b3.end(); ++itEnterArg0_1b4)
				{
					SFC::Arg currEnterArg0_1b5= *itEnterArg0_1b4;
					set< SFC::StateLabel> stateLabels_1b6= state_187.src();
					for( set< SFC::StateLabel>::const_iterator itStateLabels_1b7= stateLabels_1b6.begin(); itStateLabels_1b7!= stateLabels_1b6.end(); ++itStateLabels_1b7)
					{
						SFC::StateLabel currStateLabel_1b8= *itStateLabels_1b7;
						Match currMatch;
						currMatch.state_1ba= state_187;
						currMatch.dstState_1bb= dstState_190;
						currMatch.transition_1bc= transition_199;
						currMatch.function_1bd= function_1a2;
						currMatch.transitionCB_1be= transitionCB_1ab;
						currMatch.stateLabel_1bf= currStateLabel_1b8;
						currMatch.enterArg0_1c0= currEnterArg0_1b5;
						currMatch.enter_1c1= currEnter_1af;
						currMatch.enterArg1_1c2= currEnterArg1_1b2;
						bool Gz_guard= isGuardTrue( currMatch.dstState_1bb, currMatch.enter_1c1, currMatch.enterArg0_1c0, currMatch.enterArg1_1c2, currMatch.function_1bd, currMatch.state_1ba, currMatch.stateLabel_1bf, currMatch.transition_1bc, currMatch.transitionCB_1be);
						if( true== Gz_guard)
							_matches.push_back( currMatch);
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void EnterNextState_175::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Return newReturn_1cc= SFC::Return::Create( currMatch.transitionCB_1be, SFC::ConditionalBlock::meta_stmnt);
		SFC::FunctionCall newEnterFunctionCall_1cd= SFC::FunctionCall::Create( currMatch.transitionCB_1be, SFC::ConditionalBlock::meta_stmnt);
		SFC::ArgVal newEnterArgVal0_1ce= SFC::ArgVal::Create( newEnterFunctionCall_1cd);
		SFC::Int newTwo_1cf= SFC::Int::Create( newEnterArgVal0_1ce, SFC::ArgVal::meta_argexpr);
		SFC::ArgVal newEnterArgVal1_1d0= SFC::ArgVal::Create( newEnterFunctionCall_1cd);
		SFC::ArgDeclRef newEnterArgDeclRef_1d1= SFC::ArgDeclRef::Create( newEnterArgVal1_1d0, SFC::ArgVal::meta_argexpr);
		CyPhyML::SignalFlow::State& DstState= currMatch.dstState_1bb;
		SFC::Function& Enter= currMatch.enter_1c1;
		SFC::Arg& EnterArg0= currMatch.enterArg0_1c0;
		SFC::Arg& EnterArg1= currMatch.enterArg1_1c2;
		SFC::ArgDeclRef& EnterArgDeclRef= newEnterArgDeclRef_1d1;
		SFC::ArgVal& EnterArgVal0= newEnterArgVal0_1ce;
		SFC::ArgVal& EnterArgVal1= newEnterArgVal1_1d0;
		SFC::FunctionCall& EnterFunctionCall= newEnterFunctionCall_1cd;
		SFC::Function& Function= currMatch.function_1bd;
		SFC::Return& Return= newReturn_1cc;
		CyPhyML::SignalFlow::State& State= currMatch.state_1ba;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_1bf;
		CyPhyML::SignalFlow::Transition& Transition= currMatch.transition_1bc;
		SFC::ConditionalBlock& TransitionCB= currMatch.transitionCB_1be;
		SFC::Int& Two= newTwo_1cf;
		{
EnterFunctionCall.RefId() = Return.RefId() = TransitionCB.RefId();
};
		{
EnterArgVal1.argIndex() = 1;
};
		{
SFManager::mstat2SFC( TransitionCB, Transition.Action() );

__int64 statementCount = TransitionCB.statementCount();
EnterFunctionCall.statementIndex() = statementCount++;
Return.statementIndex() = statementCount++;
TransitionCB.statementCount() = statementCount;
};
		{
EnterArgVal0.argIndex() = 0;
};
		{
Two.val() = 2;
};
		newEnterFunctionCall_1cd.callee()= currMatch.enter_1c1;
		newEnterArgDeclRef_1d1.argdecl()= currMatch.stateLabel_1bf;
		newEnterArgVal1_1d0.arg()+= currMatch.enterArg1_1c2;
		newEnterArgVal0_1ce.arg()+= currMatch.enterArg0_1c0;
	}
}

void NextJunction_1d2::operator()( const Packets_t& states_1d3, const Packets_t& junctions_1d6, const Packets_t& transitions_1d9, const Packets_t& functions_1db, const Packets_t& transitionCBs_1de, Packets_t& states_1d5, Packets_t& junctions_1d8, Packets_t& functions_1dd, Packets_t& conditionalGroups_1e0)
{
#ifdef PRINT_INFO
	printLog( "NextJunction_1d2" );
#endif
	RTTGenerator::Instance()->generateRule(2672, "NextJunction");
	_state_1e1= &states_1d5;
	_junction_1e2= &junctions_1d8;
	_function_1e3= &functions_1dd;
	_conditionalGroup_1e4= &conditionalGroups_1e0;
	processInputPackets( states_1d3, junctions_1d6, transitions_1d9, functions_1db, transitionCBs_1de);
}

bool NextJunction_1d2::isInputUnique( const Udm::Object& state_1e9, const Udm::Object& junction_1f2, const Udm::Object& transition_1fb, const Udm::Object& function_204, const Udm::Object& transitionCB_20d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1eb= _state_1e5.begin(), itJunction_1f4= _junction_1ee.begin(), itTransition_1fd= _transition_1f7.begin(), itFunction_206= _function_200.begin(), itTransitionCB_20f= _transitionCB_209.begin(); itState_1eb!= _state_1e5.end(), itJunction_1f4!= _junction_1ee.end(), itTransition_1fd!= _transition_1f7.end(), itFunction_206!= _function_200.end(), itTransitionCB_20f!= _transitionCB_209.end(); ++itState_1eb, ++itJunction_1f4, ++itTransition_1fd, ++itFunction_206, ++itTransitionCB_20f)
	{
		if( ( *itState_1eb== state_1e9)&& ( *itJunction_1f4== junction_1f2)&& ( *itTransition_1fd== transition_1fb)&& ( *itFunction_206== function_204)&& ( *itTransitionCB_20f== transitionCB_20d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1e5.push_back( state_1e9);
		_junction_1ee.push_back( junction_1f2);
		_transition_1f7.push_back( transition_1fb);
		_function_200.push_back( function_204);
		_transitionCB_209.push_back( transitionCB_20d);
	}
	return isUnique;
}

bool NextJunction_1d2::isGuardTrue( SFC::ConditionalBlock& ConditionalBlock, SFC::ConditionalGroup& ConditionalGroup, SFC::Function& Function, CyPhyML::SignalFlow::SF_Junction& Junction, CyPhyML::SignalFlow::State& State, SFC::LocalVar& TCVar, CyPhyML::SignalFlow::Transition& Transition, SFC::ConditionalBlock& TransitionCB, SFC::ConditionalGroup& TransitionCG)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( TCVar.name() ) == "_TCVar_";;
	return Gz_guard;
}

void NextJunction_1d2::processInputPackets( const Packets_t& states_1d3, const Packets_t& junctions_1d6, const Packets_t& transitions_1d9, const Packets_t& functions_1db, const Packets_t& transitionCBs_1de)
{
	for( Packets_t::const_iterator itState_1e6= states_1d3.begin(), itJunction_1ef= junctions_1d6.begin(), itTransition_1f8= transitions_1d9.begin(), itFunction_201= functions_1db.begin(), itTransitionCB_20a= transitionCBs_1de.begin(); itState_1e6!= states_1d3.end(), itJunction_1ef!= junctions_1d6.end(), itTransition_1f8!= transitions_1d9.end(), itFunction_201!= functions_1db.end(), itTransitionCB_20a!= transitionCBs_1de.end(); ++itState_1e6, ++itJunction_1ef, ++itTransition_1f8, ++itFunction_201, ++itTransitionCB_20a)
	{
		bool isUnique= isInputUnique( *itState_1e6, *itJunction_1ef, *itTransition_1f8, *itFunction_201, *itTransitionCB_20a);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1e6, *itJunction_1ef, *itTransition_1f8, *itFunction_201, *itTransitionCB_20a);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool NextJunction_1d2::patternMatcher( const Udm::Object& state_1e7, const Udm::Object& junction_1f0, const Udm::Object& transition_1f9, const Udm::Object& function_202, const Udm::Object& transitionCB_20b)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1e7.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1ec= CyPhyML::SignalFlow::State::Cast( state_1e7);
		if( false== Uml::IsDerivedFrom( junction_1f0.type(), CyPhyML::SignalFlow::SF_Junction::meta))
			continue;
		CyPhyML::SignalFlow::SF_Junction junction_1f5= CyPhyML::SignalFlow::SF_Junction::Cast( junction_1f0);
		if( false== Uml::IsDerivedFrom( transition_1f9.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_1fe= CyPhyML::SignalFlow::Transition::Cast( transition_1f9);
		if( false== Uml::IsDerivedFrom( function_202.type(), SFC::Function::meta))
			continue;
		SFC::Function function_207= SFC::Function::Cast( function_202);
		if( false== Uml::IsDerivedFrom( transitionCB_20b.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock transitionCB_210= SFC::ConditionalBlock::Cast( transitionCB_20b);
		Udm::Object transitionCBParent_212= transitionCB_210.container();
		if( false== Uml::IsDerivedFrom( transitionCBParent_212.type(), SFC::ConditionalGroup::meta))
			continue;
		SFC::ConditionalGroup transitionCGTransitionCB_213= SFC::ConditionalGroup::Cast( transitionCBParent_212);
		Udm::Object transitionCGParent_214= transitionCGTransitionCB_213.container();
		if( false== Uml::IsDerivedFrom( transitionCGParent_214.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock conditionalBlockTransitionCG_215= SFC::ConditionalBlock::Cast( transitionCGParent_214);
		Udm::Object conditionalBlockParent_216= conditionalBlockTransitionCG_215.container();
		if( false== Uml::IsDerivedFrom( conditionalBlockParent_216.type(), SFC::ConditionalGroup::meta))
			continue;
		SFC::ConditionalGroup conditionalGroupConditionalBlock_217= SFC::ConditionalGroup::Cast( conditionalBlockParent_216);
		set< SFC::LocalVar> tCVars_218= function_207.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itTCVar_219= tCVars_218.begin(); itTCVar_219!= tCVars_218.end(); ++itTCVar_219)
		{
			SFC::LocalVar currTCVar_21a= *itTCVar_219;
			Match currMatch;
			currMatch.state_21c= state_1ec;
			currMatch.junction_21d= junction_1f5;
			currMatch.transition_21e= transition_1fe;
			currMatch.function_21f= function_207;
			currMatch.transitionCB_220= transitionCB_210;
			currMatch.tCVar_221= currTCVar_21a;
			currMatch.conditionalGroup_222= conditionalGroupConditionalBlock_217;
			currMatch.transitionCG_223= transitionCGTransitionCB_213;
			currMatch.conditionalBlock_224= conditionalBlockTransitionCG_215;
			bool Gz_guard= isGuardTrue( currMatch.conditionalBlock_224, currMatch.conditionalGroup_222, currMatch.function_21f, currMatch.junction_21d, currMatch.state_21c, currMatch.tCVar_221, currMatch.transition_21e, currMatch.transitionCB_220, currMatch.transitionCG_223);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void NextJunction_1d2::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::UserCode newNextJunction_22e= SFC::UserCode::Create( currMatch.transitionCB_220, SFC::ConditionalBlock::meta_stmnt);
		SFC::BinaryExprs newAssign_22f= SFC::BinaryExprs::Create( newNextJunction_22e, SFC::UserCode::meta_codeexpr);
		SFC::ArgDeclRef newArgDeclRef_230= SFC::ArgDeclRef::Create( newAssign_22f, SFC::BinaryExprs::meta_leftexpr);
		SFC::Int newInt_231= SFC::Int::Create( newAssign_22f, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_230;
		SFC::BinaryExprs& Assign= newAssign_22f;
		SFC::ConditionalBlock& ConditionalBlock= currMatch.conditionalBlock_224;
		SFC::ConditionalGroup& ConditionalGroup= currMatch.conditionalGroup_222;
		SFC::Function& Function= currMatch.function_21f;
		SFC::Int& Int= newInt_231;
		CyPhyML::SignalFlow::SF_Junction& Junction= currMatch.junction_21d;
		SFC::UserCode& NextJunction= newNextJunction_22e;
		CyPhyML::SignalFlow::State& State= currMatch.state_21c;
		SFC::LocalVar& TCVar= currMatch.tCVar_221;
		CyPhyML::SignalFlow::Transition& Transition= currMatch.transition_21e;
		SFC::ConditionalBlock& TransitionCB= currMatch.transitionCB_220;
		SFC::ConditionalGroup& TransitionCG= currMatch.transitionCG_223;
		{
NextJunction.RefId() = Junction.RefId();
};
		{
Assign.op() = "=";

};
		{
__int64 statementCount = TransitionCB.statementCount();
NextJunction.statementIndex() = statementCount++;
TransitionCB.statementCount() = statementCount;
};
		{
Int.val() = SFManager::StateTransConnectorMap::get_singleton().getTransConnectorMap( State ).getTransConnectorNumber( Junction );
};
		newArgDeclRef_230.argdecl()= currMatch.tCVar_221;
		outputAppender( currMatch.state_21c, currMatch.junction_21d, currMatch.function_21f, currMatch.conditionalGroup_222);
	}
}

void NextJunction_1d2::outputAppender( const CyPhyML::SignalFlow::State& state_232, const CyPhyML::SignalFlow::SF_Junction& junction_234, const SFC::Function& function_236, const SFC::ConditionalGroup& conditionalGroup_238)
{
	_state_1e1->push_back( state_232);
	_junction_1e2->push_back( junction_234);
	_function_1e3->push_back( function_236);
	_conditionalGroup_1e4->push_back( conditionalGroup_238);
}

void GetDstJuncFromRef_23a::operator()( const Packets_t& states_23b, const Packets_t& connectorRefs_23e, const Packets_t& transitions_241, const Packets_t& functions_244, const Packets_t& conditionalBlocks_247, Packets_t& states_23d, Packets_t& junctions_240, Packets_t& transitions_243, Packets_t& functions_246, Packets_t& conditionalBlocks_249)
{
#ifdef PRINT_INFO
	printLog( "GetDstJuncFromRef_23a" );
#endif
	RTTGenerator::Instance()->generateRule(2460, "GetDstJuncFromRef");
	_state_24a= &states_23d;
	_junction_24b= &junctions_240;
	_transition_24c= &transitions_243;
	_function_24d= &functions_246;
	_conditionalBlock_24e= &conditionalBlocks_249;
	processInputPackets( states_23b, connectorRefs_23e, transitions_241, functions_244, conditionalBlocks_247);
}

bool GetDstJuncFromRef_23a::isInputUnique( const Udm::Object& state_253, const Udm::Object& connectorRef_25c, const Udm::Object& transition_265, const Udm::Object& function_26e, const Udm::Object& conditionalBlock_277)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_255= _state_24f.begin(), itConnectorRef_25e= _connectorRef_258.begin(), itTransition_267= _transition_261.begin(), itFunction_270= _function_26a.begin(), itConditionalBlock_279= _conditionalBlock_273.begin(); itState_255!= _state_24f.end(), itConnectorRef_25e!= _connectorRef_258.end(), itTransition_267!= _transition_261.end(), itFunction_270!= _function_26a.end(), itConditionalBlock_279!= _conditionalBlock_273.end(); ++itState_255, ++itConnectorRef_25e, ++itTransition_267, ++itFunction_270, ++itConditionalBlock_279)
	{
		if( ( *itState_255== state_253)&& ( *itConnectorRef_25e== connectorRef_25c)&& ( *itTransition_267== transition_265)&& ( *itFunction_270== function_26e)&& ( *itConditionalBlock_279== conditionalBlock_277))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_24f.push_back( state_253);
		_connectorRef_258.push_back( connectorRef_25c);
		_transition_261.push_back( transition_265);
		_function_26a.push_back( function_26e);
		_conditionalBlock_273.push_back( conditionalBlock_277);
	}
	return isUnique;
}

void GetDstJuncFromRef_23a::processInputPackets( const Packets_t& states_23b, const Packets_t& connectorRefs_23e, const Packets_t& transitions_241, const Packets_t& functions_244, const Packets_t& conditionalBlocks_247)
{
	for( Packets_t::const_iterator itState_250= states_23b.begin(), itConnectorRef_259= connectorRefs_23e.begin(), itTransition_262= transitions_241.begin(), itFunction_26b= functions_244.begin(), itConditionalBlock_274= conditionalBlocks_247.begin(); itState_250!= states_23b.end(), itConnectorRef_259!= connectorRefs_23e.end(), itTransition_262!= transitions_241.end(), itFunction_26b!= functions_244.end(), itConditionalBlock_274!= conditionalBlocks_247.end(); ++itState_250, ++itConnectorRef_259, ++itTransition_262, ++itFunction_26b, ++itConditionalBlock_274)
	{
		bool isUnique= isInputUnique( *itState_250, *itConnectorRef_259, *itTransition_262, *itFunction_26b, *itConditionalBlock_274);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_250, *itConnectorRef_259, *itTransition_262, *itFunction_26b, *itConditionalBlock_274);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetDstJuncFromRef_23a::patternMatcher( const Udm::Object& state_251, const Udm::Object& connectorRef_25a, const Udm::Object& transition_263, const Udm::Object& function_26c, const Udm::Object& conditionalBlock_275)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_251.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_256= CyPhyML::SignalFlow::State::Cast( state_251);
		if( false== Uml::IsDerivedFrom( connectorRef_25a.type(), CyPhyML::SignalFlow::ConnectorRef::meta))
			continue;
		CyPhyML::SignalFlow::ConnectorRef connectorRef_25f= CyPhyML::SignalFlow::ConnectorRef::Cast( connectorRef_25a);
		if( false== Uml::IsDerivedFrom( transition_263.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_268= CyPhyML::SignalFlow::Transition::Cast( transition_263);
		if( false== Uml::IsDerivedFrom( function_26c.type(), SFC::Function::meta))
			continue;
		SFC::Function function_271= SFC::Function::Cast( function_26c);
		if( false== Uml::IsDerivedFrom( conditionalBlock_275.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock conditionalBlock_27a= SFC::ConditionalBlock::Cast( conditionalBlock_275);
		CyPhyML::SignalFlow::TransConnector junction_27c= connectorRef_25f.ref();
		if( false== Uml::IsDerivedFrom( junction_27c.type(), CyPhyML::SignalFlow::SF_Junction::meta))
			continue;
		CyPhyML::SignalFlow::SF_Junction junction_27d= CyPhyML::SignalFlow::SF_Junction::Cast( junction_27c);
		if( !junction_27d)
			continue;
		Match currMatch;
		currMatch.state_27f= state_256;
		currMatch.connectorRef_280= connectorRef_25f;
		currMatch.transition_281= transition_268;
		currMatch.function_282= function_271;
		currMatch.conditionalBlock_283= conditionalBlock_27a;
		currMatch.junction_284= junction_27d;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void GetDstJuncFromRef_23a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_27f, currMatch.junction_284, currMatch.transition_281, currMatch.function_282, currMatch.conditionalBlock_283);
	}
}

void GetDstJuncFromRef_23a::outputAppender( const CyPhyML::SignalFlow::State& state_285, const CyPhyML::SignalFlow::SF_Junction& junction_287, const CyPhyML::SignalFlow::Transition& transition_289, const SFC::Function& function_28b, const SFC::ConditionalBlock& conditionalBlock_28d)
{
	_state_24a->push_back( state_285);
	_junction_24b->push_back( junction_287);
	_transition_24c->push_back( transition_289);
	_function_24d->push_back( function_28b);
	_conditionalBlock_24e->push_back( conditionalBlock_28d);
}

void GetDstStateFromRef_28f::operator()( const Packets_t& states_290, const Packets_t& connectorRefs_294, const Packets_t& transitions_296, const Packets_t& functions_299, const Packets_t& conditionalBlocks_29c, Packets_t& states_292, Packets_t& dstStates_293, Packets_t& transitions_298, Packets_t& functions_29b, Packets_t& conditionalBlocks_29e)
{
#ifdef PRINT_INFO
	printLog( "GetDstStateFromRef_28f" );
#endif
	RTTGenerator::Instance()->generateRule(2664, "GetDstStateFromRef");
	_state_29f= &states_292;
	_dstState_2a0= &dstStates_293;
	_transition_2a1= &transitions_298;
	_function_2a2= &functions_29b;
	_conditionalBlock_2a3= &conditionalBlocks_29e;
	processInputPackets( states_290, connectorRefs_294, transitions_296, functions_299, conditionalBlocks_29c);
}

bool GetDstStateFromRef_28f::isInputUnique( const Udm::Object& state_2a8, const Udm::Object& connectorRef_2b1, const Udm::Object& transition_2ba, const Udm::Object& function_2c3, const Udm::Object& conditionalBlock_2cc)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_2aa= _state_2a4.begin(), itConnectorRef_2b3= _connectorRef_2ad.begin(), itTransition_2bc= _transition_2b6.begin(), itFunction_2c5= _function_2bf.begin(), itConditionalBlock_2ce= _conditionalBlock_2c8.begin(); itState_2aa!= _state_2a4.end(), itConnectorRef_2b3!= _connectorRef_2ad.end(), itTransition_2bc!= _transition_2b6.end(), itFunction_2c5!= _function_2bf.end(), itConditionalBlock_2ce!= _conditionalBlock_2c8.end(); ++itState_2aa, ++itConnectorRef_2b3, ++itTransition_2bc, ++itFunction_2c5, ++itConditionalBlock_2ce)
	{
		if( ( *itState_2aa== state_2a8)&& ( *itConnectorRef_2b3== connectorRef_2b1)&& ( *itTransition_2bc== transition_2ba)&& ( *itFunction_2c5== function_2c3)&& ( *itConditionalBlock_2ce== conditionalBlock_2cc))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_2a4.push_back( state_2a8);
		_connectorRef_2ad.push_back( connectorRef_2b1);
		_transition_2b6.push_back( transition_2ba);
		_function_2bf.push_back( function_2c3);
		_conditionalBlock_2c8.push_back( conditionalBlock_2cc);
	}
	return isUnique;
}

void GetDstStateFromRef_28f::processInputPackets( const Packets_t& states_290, const Packets_t& connectorRefs_294, const Packets_t& transitions_296, const Packets_t& functions_299, const Packets_t& conditionalBlocks_29c)
{
	for( Packets_t::const_iterator itState_2a5= states_290.begin(), itConnectorRef_2ae= connectorRefs_294.begin(), itTransition_2b7= transitions_296.begin(), itFunction_2c0= functions_299.begin(), itConditionalBlock_2c9= conditionalBlocks_29c.begin(); itState_2a5!= states_290.end(), itConnectorRef_2ae!= connectorRefs_294.end(), itTransition_2b7!= transitions_296.end(), itFunction_2c0!= functions_299.end(), itConditionalBlock_2c9!= conditionalBlocks_29c.end(); ++itState_2a5, ++itConnectorRef_2ae, ++itTransition_2b7, ++itFunction_2c0, ++itConditionalBlock_2c9)
	{
		bool isUnique= isInputUnique( *itState_2a5, *itConnectorRef_2ae, *itTransition_2b7, *itFunction_2c0, *itConditionalBlock_2c9);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_2a5, *itConnectorRef_2ae, *itTransition_2b7, *itFunction_2c0, *itConditionalBlock_2c9);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetDstStateFromRef_28f::patternMatcher( const Udm::Object& state_2a6, const Udm::Object& connectorRef_2af, const Udm::Object& transition_2b8, const Udm::Object& function_2c1, const Udm::Object& conditionalBlock_2ca)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_2a6.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_2ab= CyPhyML::SignalFlow::State::Cast( state_2a6);
		if( false== Uml::IsDerivedFrom( connectorRef_2af.type(), CyPhyML::SignalFlow::ConnectorRef::meta))
			continue;
		CyPhyML::SignalFlow::ConnectorRef connectorRef_2b4= CyPhyML::SignalFlow::ConnectorRef::Cast( connectorRef_2af);
		if( false== Uml::IsDerivedFrom( transition_2b8.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_2bd= CyPhyML::SignalFlow::Transition::Cast( transition_2b8);
		if( false== Uml::IsDerivedFrom( function_2c1.type(), SFC::Function::meta))
			continue;
		SFC::Function function_2c6= SFC::Function::Cast( function_2c1);
		if( false== Uml::IsDerivedFrom( conditionalBlock_2ca.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock conditionalBlock_2cf= SFC::ConditionalBlock::Cast( conditionalBlock_2ca);
		CyPhyML::SignalFlow::TransConnector dstState_2d1= connectorRef_2b4.ref();
		if( false== Uml::IsDerivedFrom( dstState_2d1.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State dstState_2d2= CyPhyML::SignalFlow::State::Cast( dstState_2d1);
		if( !dstState_2d2)
			continue;
		Match currMatch;
		currMatch.state_2d4= state_2ab;
		currMatch.connectorRef_2d5= connectorRef_2b4;
		currMatch.transition_2d6= transition_2bd;
		currMatch.function_2d7= function_2c6;
		currMatch.conditionalBlock_2d8= conditionalBlock_2cf;
		currMatch.dstState_2d9= dstState_2d2;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void GetDstStateFromRef_28f::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_2d4, currMatch.dstState_2d9, currMatch.transition_2d6, currMatch.function_2d7, currMatch.conditionalBlock_2d8);
	}
}

void GetDstStateFromRef_28f::outputAppender( const CyPhyML::SignalFlow::State& state_2da, const CyPhyML::SignalFlow::State& dstState_2dc, const CyPhyML::SignalFlow::Transition& transition_2de, const SFC::Function& function_2e0, const SFC::ConditionalBlock& conditionalBlock_2e2)
{
	_state_29f->push_back( state_2da);
	_dstState_2a0->push_back( dstState_2dc);
	_transition_2a1->push_back( transition_2de);
	_function_2a2->push_back( function_2e0);
	_conditionalBlock_2a3->push_back( conditionalBlock_2e2);
}

void DeadEndJunction_2e4::operator()( const Packets_t& states_2e5, const Packets_t& transConnectors_2e7, const Packets_t& transitions_2e9, const Packets_t& functions_2eb, const Packets_t& transitionCBs_2ed)
{
#ifdef PRINT_INFO
	printLog( "DeadEndJunction_2e4" );
#endif
	RTTGenerator::Instance()->generateRule(2435, "DeadEndJunction");
	processInputPackets( states_2e5, transConnectors_2e7, transitions_2e9, functions_2eb, transitionCBs_2ed);
}

bool DeadEndJunction_2e4::isInputUnique( const Udm::Object& state_2f3, const Udm::Object& transConnector_2fc, const Udm::Object& transition_305, const Udm::Object& function_30e, const Udm::Object& transitionCB_317)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_2f5= _state_2ef.begin(), itTransConnector_2fe= _transConnector_2f8.begin(), itTransition_307= _transition_301.begin(), itFunction_310= _function_30a.begin(), itTransitionCB_319= _transitionCB_313.begin(); itState_2f5!= _state_2ef.end(), itTransConnector_2fe!= _transConnector_2f8.end(), itTransition_307!= _transition_301.end(), itFunction_310!= _function_30a.end(), itTransitionCB_319!= _transitionCB_313.end(); ++itState_2f5, ++itTransConnector_2fe, ++itTransition_307, ++itFunction_310, ++itTransitionCB_319)
	{
		if( ( *itState_2f5== state_2f3)&& ( *itTransConnector_2fe== transConnector_2fc)&& ( *itTransition_307== transition_305)&& ( *itFunction_310== function_30e)&& ( *itTransitionCB_319== transitionCB_317))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_2ef.push_back( state_2f3);
		_transConnector_2f8.push_back( transConnector_2fc);
		_transition_301.push_back( transition_305);
		_function_30a.push_back( function_30e);
		_transitionCB_313.push_back( transitionCB_317);
	}
	return isUnique;
}

bool DeadEndJunction_2e4::isGuardTrue( SFC::Function& Function, CyPhyML::SignalFlow::State& State, SFC::LocalVar& TCVar, CyPhyML::SignalFlow::TransConnector& TransConnector, CyPhyML::SignalFlow::Transition& Transition, SFC::ConditionalBlock& TransitionCB)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( TCVar.name() ) == "_TCVar_";;
	return Gz_guard;
}

void DeadEndJunction_2e4::processInputPackets( const Packets_t& states_2e5, const Packets_t& transConnectors_2e7, const Packets_t& transitions_2e9, const Packets_t& functions_2eb, const Packets_t& transitionCBs_2ed)
{
	for( Packets_t::const_iterator itState_2f0= states_2e5.begin(), itTransConnector_2f9= transConnectors_2e7.begin(), itTransition_302= transitions_2e9.begin(), itFunction_30b= functions_2eb.begin(), itTransitionCB_314= transitionCBs_2ed.begin(); itState_2f0!= states_2e5.end(), itTransConnector_2f9!= transConnectors_2e7.end(), itTransition_302!= transitions_2e9.end(), itFunction_30b!= functions_2eb.end(), itTransitionCB_314!= transitionCBs_2ed.end(); ++itState_2f0, ++itTransConnector_2f9, ++itTransition_302, ++itFunction_30b, ++itTransitionCB_314)
	{
		bool isUnique= isInputUnique( *itState_2f0, *itTransConnector_2f9, *itTransition_302, *itFunction_30b, *itTransitionCB_314);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_2f0, *itTransConnector_2f9, *itTransition_302, *itFunction_30b, *itTransitionCB_314);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool DeadEndJunction_2e4::patternMatcher( const Udm::Object& state_2f1, const Udm::Object& transConnector_2fa, const Udm::Object& transition_303, const Udm::Object& function_30c, const Udm::Object& transitionCB_315)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_2f1.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_2f6= CyPhyML::SignalFlow::State::Cast( state_2f1);
		if( false== Uml::IsDerivedFrom( transConnector_2fa.type(), CyPhyML::SignalFlow::TransConnector::meta))
			continue;
		CyPhyML::SignalFlow::TransConnector transConnector_2ff= CyPhyML::SignalFlow::TransConnector::Cast( transConnector_2fa);
		if( false== Uml::IsDerivedFrom( transition_303.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_308= CyPhyML::SignalFlow::Transition::Cast( transition_303);
		if( false== Uml::IsDerivedFrom( function_30c.type(), SFC::Function::meta))
			continue;
		SFC::Function function_311= SFC::Function::Cast( function_30c);
		if( false== Uml::IsDerivedFrom( transitionCB_315.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock transitionCB_31a= SFC::ConditionalBlock::Cast( transitionCB_315);
		set< SFC::LocalVar> tCVars_31c= function_311.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itTCVar_31d= tCVars_31c.begin(); itTCVar_31d!= tCVars_31c.end(); ++itTCVar_31d)
		{
			SFC::LocalVar currTCVar_31e= *itTCVar_31d;
			Match currMatch;
			currMatch.state_320= state_2f6;
			currMatch.transConnector_321= transConnector_2ff;
			currMatch.transition_322= transition_308;
			currMatch.function_323= function_311;
			currMatch.transitionCB_324= transitionCB_31a;
			currMatch.tCVar_325= currTCVar_31e;
			bool Gz_guard= isGuardTrue( currMatch.function_323, currMatch.state_320, currMatch.tCVar_325, currMatch.transConnector_321, currMatch.transition_322, currMatch.transitionCB_324);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void DeadEndJunction_2e4::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::UserCode newNextJunction_32c= SFC::UserCode::Create( currMatch.transitionCB_324, SFC::ConditionalBlock::meta_stmnt);
		SFC::BinaryExprs newAssign_32d= SFC::BinaryExprs::Create( newNextJunction_32c, SFC::UserCode::meta_codeexpr);
		SFC::Int newNegOne_32e= SFC::Int::Create( newAssign_32d, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef_32f= SFC::ArgDeclRef::Create( newAssign_32d, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_32f;
		SFC::BinaryExprs& Assign= newAssign_32d;
		SFC::Function& Function= currMatch.function_323;
		SFC::Int& NegOne= newNegOne_32e;
		SFC::UserCode& NextJunction= newNextJunction_32c;
		CyPhyML::SignalFlow::State& State= currMatch.state_320;
		SFC::LocalVar& TCVar= currMatch.tCVar_325;
		CyPhyML::SignalFlow::TransConnector& TransConnector= currMatch.transConnector_321;
		CyPhyML::SignalFlow::Transition& Transition= currMatch.transition_322;
		SFC::ConditionalBlock& TransitionCB= currMatch.transitionCB_324;
		{
NextJunction.RefId() = TransConnector.RefId();
};
		{
__int64 statementCount = TransitionCB.statementCount();
NextJunction.statementIndex() = statementCount++;
TransitionCB.statementCount() = statementCount;
};
		{
Assign.op() = "=";
NegOne.val() = -1;
};
		newArgDeclRef_32f.argdecl()= currMatch.tCVar_325;
	}
}

void TransCond_330::operator()( const Packets_t& states_331, const Packets_t& transitions_335, const Packets_t& functions_338, const Packets_t& transitionCGs_33b, Packets_t& states_333, Packets_t& dstTransConnectors_334, Packets_t& transitions_337, Packets_t& functions_33a, Packets_t& conditionalBlocks_33d)
{
#ifdef PRINT_INFO
	printLog( "TransCond_330" );
#endif
	RTTGenerator::Instance()->generateRule(2421, "TransCond");
	_state_33e= &states_333;
	_dstTransConnector_33f= &dstTransConnectors_334;
	_transition_340= &transitions_337;
	_function_341= &functions_33a;
	_conditionalBlock_342= &conditionalBlocks_33d;
	processInputPackets( states_331, transitions_335, functions_338, transitionCGs_33b);
}

bool TransCond_330::isInputUnique( const Udm::Object& state_347, const Udm::Object& transition_350, const Udm::Object& function_359, const Udm::Object& transitionCG_362)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_349= _state_343.begin(), itTransition_352= _transition_34c.begin(), itFunction_35b= _function_355.begin(), itTransitionCG_364= _transitionCG_35e.begin(); itState_349!= _state_343.end(), itTransition_352!= _transition_34c.end(), itFunction_35b!= _function_355.end(), itTransitionCG_364!= _transitionCG_35e.end(); ++itState_349, ++itTransition_352, ++itFunction_35b, ++itTransitionCG_364)
	{
		if( ( *itState_349== state_347)&& ( *itTransition_352== transition_350)&& ( *itFunction_35b== function_359)&& ( *itTransitionCG_364== transitionCG_362))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_343.push_back( state_347);
		_transition_34c.push_back( transition_350);
		_function_355.push_back( function_359);
		_transitionCG_35e.push_back( transitionCG_362);
	}
	return isUnique;
}

void TransCond_330::processInputPackets( const Packets_t& states_331, const Packets_t& transitions_335, const Packets_t& functions_338, const Packets_t& transitionCGs_33b)
{
	for( Packets_t::const_iterator itState_344= states_331.begin(), itTransition_34d= transitions_335.begin(), itFunction_356= functions_338.begin(), itTransitionCG_35f= transitionCGs_33b.begin(); itState_344!= states_331.end(), itTransition_34d!= transitions_335.end(), itFunction_356!= functions_338.end(), itTransitionCG_35f!= transitionCGs_33b.end(); ++itState_344, ++itTransition_34d, ++itFunction_356, ++itTransitionCG_35f)
	{
		bool isUnique= isInputUnique( *itState_344, *itTransition_34d, *itFunction_356, *itTransitionCG_35f);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_344, *itTransition_34d, *itFunction_356, *itTransitionCG_35f);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TransCond_330::patternMatcher( const Udm::Object& state_345, const Udm::Object& transition_34e, const Udm::Object& function_357, const Udm::Object& transitionCG_360)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_345.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_34a= CyPhyML::SignalFlow::State::Cast( state_345);
		if( false== Uml::IsDerivedFrom( transition_34e.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_353= CyPhyML::SignalFlow::Transition::Cast( transition_34e);
		if( false== Uml::IsDerivedFrom( function_357.type(), SFC::Function::meta))
			continue;
		SFC::Function function_35c= SFC::Function::Cast( function_357);
		if( false== Uml::IsDerivedFrom( transitionCG_360.type(), SFC::ConditionalGroup::meta))
			continue;
		SFC::ConditionalGroup transitionCG_365= SFC::ConditionalGroup::Cast( transitionCG_360);
		CyPhyML::SignalFlow::TransConnector srcTransConnector_367= transition_353.srcTransition_end();
		CyPhyML::SignalFlow::TransConnector dstTransConnector_368= transition_353.dstTransition_end();
		Match currMatch;
		currMatch.state_36a= state_34a;
		currMatch.transition_36b= transition_353;
		currMatch.function_36c= function_35c;
		currMatch.transitionCG_36d= transitionCG_365;
		currMatch.dstTransConnector_36e= dstTransConnector_368;
		currMatch.srcTransConnector_36f= srcTransConnector_367;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void TransCond_330::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_370= SFC::ConditionalBlock::Create( currMatch.transitionCG_36d, SFC::ConditionalGroup::meta_stmnt);
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_370;
		CyPhyML::SignalFlow::TransConnector& DstTransConnector= currMatch.dstTransConnector_36e;
		SFC::Function& Function= currMatch.function_36c;
		CyPhyML::SignalFlow::TransConnector& SrcTransConnector= currMatch.srcTransConnector_36f;
		CyPhyML::SignalFlow::State& State= currMatch.state_36a;
		CyPhyML::SignalFlow::Transition& Transition= currMatch.transition_36b;
		SFC::ConditionalGroup& TransitionCG= currMatch.transitionCG_36d;
		{
ConditionalBlock.RefId() = Transition.RefId();
};
		{
__int64 statementCount = TransitionCG.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
TransitionCG.statementCount() = statementCount;
};
		{
std::string condition = Transition.Trigger();
SFManager::filterComments( condition );
condition = SFManager::trim( condition );

std::string guard = Transition.Guard();
SFManager::filterComments( guard );
guard = SFManager::trim( guard );

if ( condition.empty() ) {
  condition = guard;
} else if ( !guard.empty() ) {
  condition = "( " + condition + " ) && ( " + guard + " )";
}
if ( condition.empty() ) condition = "1";

SFManager::mexpr2SFCCondition( ConditionalBlock, condition );

SFManager::mstat2SFC( ConditionalBlock, Transition.ConditionAction() );
};
		outputAppender( currMatch.state_36a, currMatch.dstTransConnector_36e, currMatch.transition_36b, currMatch.function_36c, newConditionalBlock_370);
	}
}

void TransCond_330::outputAppender( const CyPhyML::SignalFlow::State& state_371, const CyPhyML::SignalFlow::TransConnector& dstTransConnector_373, const CyPhyML::SignalFlow::Transition& transition_375, const SFC::Function& function_377, const SFC::ConditionalBlock& conditionalBlock_379)
{
	_state_33e->push_back( state_371);
	_dstTransConnector_33f->push_back( dstTransConnector_373);
	_transition_340->push_back( transition_375);
	_function_341->push_back( function_377);
	_conditionalBlock_342->push_back( conditionalBlock_379);
}

void Test_37b::operator()( const Packets_t& states_37c, const Packets_t& dsts_37e, const Packets_t& transs_380, const Packets_t& fcns_382, const Packets_t& cbs_384, Packets_t& states_386, Packets_t& dsts_387, Packets_t& transs_388, Packets_t& fcns_389, Packets_t& cbs_38a, Packets_t& states_38b, Packets_t& dsts_38c, Packets_t& transs_38d, Packets_t& fcns_38e, Packets_t& cbs_38f, Packets_t& states_390, Packets_t& dsts_391, Packets_t& transs_392, Packets_t& fcns_393, Packets_t& cbs_394, Packets_t& states_395, Packets_t& dsts_396, Packets_t& transs_397, Packets_t& fcns_398, Packets_t& cbs_399, Packets_t& states_39a, Packets_t& dsts_39b, Packets_t& transs_39c, Packets_t& fcns_39d, Packets_t& cbs_39e)
{
#ifdef PRINT_INFO
	printLog( "Test_37b" );
#endif
	_state_39f= &states_386;
	_dst_3a0= &dsts_387;
	_trans_3a1= &transs_388;
	_fcn_3a2= &fcns_389;
	_cb_3a3= &cbs_38a;
	_state_3a4= &states_38b;
	_dst_3a5= &dsts_38c;
	_trans_3a6= &transs_38d;
	_fcn_3a7= &fcns_38e;
	_cb_3a8= &cbs_38f;
	_state_3a9= &states_390;
	_dst_3aa= &dsts_391;
	_trans_3ab= &transs_392;
	_fcn_3ac= &fcns_393;
	_cb_3ad= &cbs_394;
	_state_3ae= &states_395;
	_dst_3af= &dsts_396;
	_trans_3b0= &transs_397;
	_fcn_3b1= &fcns_398;
	_cb_3b2= &cbs_399;
	_state_3b3= &states_39a;
	_dst_3b4= &dsts_39b;
	_trans_3b5= &transs_39c;
	_fcn_3b6= &fcns_39d;
	_cb_3b7= &cbs_39e;
	for( Packets_t::const_iterator itstate_3b9= states_37c.begin(), itdst_3c0= dsts_37e.begin(), ittrans_3c7= transs_380.begin(), itfcn_3ce= fcns_382.begin(), itcb_3d5= cbs_384.begin(); itstate_3b9!= states_37c.end(), itdst_3c0!= dsts_37e.end(), ittrans_3c7!= transs_380.end(), itfcn_3ce!= fcns_382.end(), itcb_3d5!= cbs_384.end(); ++itstate_3b9, ++itdst_3c0, ++ittrans_3c7, ++itfcn_3ce, ++itcb_3d5)
	{
		bool isUnique= isInputUnique( *itstate_3b9, *itdst_3c0, *ittrans_3c7, *itfcn_3ce, *itcb_3d5);
		if( !isUnique)
			continue;
		Packets_t onestate_3bd( 1, *itstate_3b9);
		Packets_t onedst_3c4( 1, *itdst_3c0);
		Packets_t onetrans_3cb( 1, *ittrans_3c7);
		Packets_t onefcn_3d2( 1, *itfcn_3ce);
		Packets_t onecb_3d9( 1, *itcb_3d5);
		executeOne( onestate_3bd, onedst_3c4, onetrans_3cb, onefcn_3d2, onecb_3d9);
	}
}

void Test_37b::executeOne( const Packets_t& states_37c, const Packets_t& dsts_37e, const Packets_t& transs_380, const Packets_t& fcns_382, const Packets_t& cbs_384)
{
	Packets_t states_3de;
	Packets_t dstStates_3e1;
	Packets_t transitions_3e4;
	Packets_t functions_3e7;
	Packets_t conditionalBlocks_3ea;
	DstIsState_3db dstIsState_3db;
	bool isMatchDstIsState_3db= dstIsState_3db( states_37c, dsts_37e, transs_380, fcns_382, cbs_384, states_3de, dstStates_3e1, transitions_3e4, functions_3e7, conditionalBlocks_3ea);
	_state_39f->insert( _state_39f->end(), states_3de.begin(), states_3de.end());
	_dst_3a0->insert( _dst_3a0->end(), dstStates_3e1.begin(), dstStates_3e1.end());
	_trans_3a1->insert( _trans_3a1->end(), transitions_3e4.begin(), transitions_3e4.end());
	_fcn_3a2->insert( _fcn_3a2->end(), functions_3e7.begin(), functions_3e7.end());
	_cb_3a3->insert( _cb_3a3->end(), conditionalBlocks_3ea.begin(), conditionalBlocks_3ea.end());
	if( isMatchDstIsState_3db)
		return;
	Packets_t states_430;
	Packets_t connectorRefs_433;
	Packets_t transitions_436;
	Packets_t functions_439;
	Packets_t conditionalBlocks_43c;
	DstIsRefState_42d dstIsRefState_42d;
	bool isMatchDstIsRefState_42d= dstIsRefState_42d( states_37c, dsts_37e, transs_380, fcns_382, cbs_384, states_430, connectorRefs_433, transitions_436, functions_439, conditionalBlocks_43c);
	_state_3a4->insert( _state_3a4->end(), states_430.begin(), states_430.end());
	_dst_3a5->insert( _dst_3a5->end(), connectorRefs_433.begin(), connectorRefs_433.end());
	_trans_3a6->insert( _trans_3a6->end(), transitions_436.begin(), transitions_436.end());
	_fcn_3a7->insert( _fcn_3a7->end(), functions_439.begin(), functions_439.end());
	_cb_3a8->insert( _cb_3a8->end(), conditionalBlocks_43c.begin(), conditionalBlocks_43c.end());
	if( isMatchDstIsRefState_42d)
		return;
	Packets_t states_485;
	Packets_t junctions_488;
	Packets_t transitions_48b;
	Packets_t functions_48e;
	Packets_t conditionalBlocks_491;
	DstIsJuncWithTrans_482 dstIsJuncWithTrans_482;
	bool isMatchDstIsJuncWithTrans_482= dstIsJuncWithTrans_482( states_37c, dsts_37e, transs_380, fcns_382, cbs_384, states_485, junctions_488, transitions_48b, functions_48e, conditionalBlocks_491);
	_state_3a9->insert( _state_3a9->end(), states_485.begin(), states_485.end());
	_dst_3aa->insert( _dst_3aa->end(), junctions_488.begin(), junctions_488.end());
	_trans_3ab->insert( _trans_3ab->end(), transitions_48b.begin(), transitions_48b.end());
	_fcn_3ac->insert( _fcn_3ac->end(), functions_48e.begin(), functions_48e.end());
	_cb_3ad->insert( _cb_3ad->end(), conditionalBlocks_491.begin(), conditionalBlocks_491.end());
	if( isMatchDstIsJuncWithTrans_482)
		return;
	Packets_t states_4dd;
	Packets_t junctions_4e0;
	Packets_t transitions_4e3;
	Packets_t functions_4e6;
	Packets_t conditionalBlocks_4e9;
	DstIsJuncWithRefTrans_4da dstIsJuncWithRefTrans_4da;
	bool isMatchDstIsJuncWithRefTrans_4da= dstIsJuncWithRefTrans_4da( states_37c, dsts_37e, transs_380, fcns_382, cbs_384, states_4dd, junctions_4e0, transitions_4e3, functions_4e6, conditionalBlocks_4e9);
	_state_3a9->insert( _state_3a9->end(), states_4dd.begin(), states_4dd.end());
	_dst_3aa->insert( _dst_3aa->end(), junctions_4e0.begin(), junctions_4e0.end());
	_trans_3ab->insert( _trans_3ab->end(), transitions_4e3.begin(), transitions_4e3.end());
	_fcn_3ac->insert( _fcn_3ac->end(), functions_4e6.begin(), functions_4e6.end());
	_cb_3ad->insert( _cb_3ad->end(), conditionalBlocks_4e9.begin(), conditionalBlocks_4e9.end());
	if( isMatchDstIsJuncWithRefTrans_4da)
		return;
	Packets_t states_539;
	Packets_t connectorRefs_53c;
	Packets_t transitions_53f;
	Packets_t functions_542;
	Packets_t conditionalBlocks_545;
	DstIsJuncRefWithTrans_536 dstIsJuncRefWithTrans_536;
	bool isMatchDstIsJuncRefWithTrans_536= dstIsJuncRefWithTrans_536( states_37c, dsts_37e, transs_380, fcns_382, cbs_384, states_539, connectorRefs_53c, transitions_53f, functions_542, conditionalBlocks_545);
	_state_3ae->insert( _state_3ae->end(), states_539.begin(), states_539.end());
	_dst_3af->insert( _dst_3af->end(), connectorRefs_53c.begin(), connectorRefs_53c.end());
	_trans_3b0->insert( _trans_3b0->end(), transitions_53f.begin(), transitions_53f.end());
	_fcn_3b1->insert( _fcn_3b1->end(), functions_542.begin(), functions_542.end());
	_cb_3b2->insert( _cb_3b2->end(), conditionalBlocks_545.begin(), conditionalBlocks_545.end());
	if( isMatchDstIsJuncRefWithTrans_536)
		return;
	Packets_t states_594;
	Packets_t connectorRefs_597;
	Packets_t transitions_59a;
	Packets_t functions_59d;
	Packets_t conditionalBlocks_5a0;
	DstIsJuncRefWithJuncTrans_591 dstIsJuncRefWithJuncTrans_591;
	bool isMatchDstIsJuncRefWithJuncTrans_591= dstIsJuncRefWithJuncTrans_591( states_37c, dsts_37e, transs_380, fcns_382, cbs_384, states_594, connectorRefs_597, transitions_59a, functions_59d, conditionalBlocks_5a0);
	_state_3ae->insert( _state_3ae->end(), states_594.begin(), states_594.end());
	_dst_3af->insert( _dst_3af->end(), connectorRefs_597.begin(), connectorRefs_597.end());
	_trans_3b0->insert( _trans_3b0->end(), transitions_59a.begin(), transitions_59a.end());
	_fcn_3b1->insert( _fcn_3b1->end(), functions_59d.begin(), functions_59d.end());
	_cb_3b2->insert( _cb_3b2->end(), conditionalBlocks_5a0.begin(), conditionalBlocks_5a0.end());
	if( isMatchDstIsJuncRefWithJuncTrans_591)
		return;
	Packets_t states_5ef;
	Packets_t transConnectors_5f2;
	Packets_t transitions_5f5;
	Packets_t functions_5f8;
	Packets_t conditionalBlocks_5fb;
	DeadEnd_5ec deadEnd_5ec;
	bool isMatchDeadEnd_5ec= deadEnd_5ec( states_37c, dsts_37e, transs_380, fcns_382, cbs_384, states_5ef, transConnectors_5f2, transitions_5f5, functions_5f8, conditionalBlocks_5fb);
	_state_3b3->insert( _state_3b3->end(), states_5ef.begin(), states_5ef.end());
	_dst_3b4->insert( _dst_3b4->end(), transConnectors_5f2.begin(), transConnectors_5f2.end());
	_trans_3b5->insert( _trans_3b5->end(), transitions_5f5.begin(), transitions_5f5.end());
	_fcn_3b6->insert( _fcn_3b6->end(), functions_5f8.begin(), functions_5f8.end());
	_cb_3b7->insert( _cb_3b7->end(), conditionalBlocks_5fb.begin(), conditionalBlocks_5fb.end());
	if( isMatchDeadEnd_5ec)
		return;
}

bool Test_37b::isInputUnique( const Udm::Object& state_3ba, const Udm::Object& dst_3c1, const Udm::Object& trans_3c8, const Udm::Object& fcn_3cf, const Udm::Object& cb_3d6)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_3bc= _state_3b8.begin(), itdst_3c3= _dst_3bf.begin(), ittrans_3ca= _trans_3c6.begin(), itfcn_3d1= _fcn_3cd.begin(), itcb_3d8= _cb_3d4.begin(); itstate_3bc!= _state_3b8.end(), itdst_3c3!= _dst_3bf.end(), ittrans_3ca!= _trans_3c6.end(), itfcn_3d1!= _fcn_3cd.end(), itcb_3d8!= _cb_3d4.end(); ++itstate_3bc, ++itdst_3c3, ++ittrans_3ca, ++itfcn_3d1, ++itcb_3d8)
	{
		if( ( *itstate_3bc== state_3ba)&& ( *itdst_3c3== dst_3c1)&& ( *ittrans_3ca== trans_3c8)&& ( *itfcn_3d1== fcn_3cf)&& ( *itcb_3d8== cb_3d6))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_3b8.push_back( state_3ba);
		_dst_3bf.push_back( dst_3c1);
		_trans_3c6.push_back( trans_3c8);
		_fcn_3cd.push_back( fcn_3cf);
		_cb_3d4.push_back( cb_3d6);
	}
	return isUnique;
}

bool DstIsState_3db::operator()( const Packets_t& states_3dc, const Packets_t& dstStates_3df, const Packets_t& transitions_3e2, const Packets_t& functions_3e5, const Packets_t& conditionalBlocks_3e8, Packets_t& states_3de, Packets_t& dstStates_3e1, Packets_t& transitions_3e4, Packets_t& functions_3e7, Packets_t& conditionalBlocks_3ea)
{
#ifdef PRINT_INFO
	printLog( "DstIsState_3db" );
#endif
	_state_3eb= &states_3de;
	_dstState_3ec= &dstStates_3e1;
	_transition_3ed= &transitions_3e4;
	_function_3ee= &functions_3e7;
	_conditionalBlock_3ef= &conditionalBlocks_3ea;
	processInputPackets( states_3dc, dstStates_3df, transitions_3e2, functions_3e5, conditionalBlocks_3e8);
	if( false== _matches.empty())
		return true;
	return false;
}

bool DstIsState_3db::isInputUnique( const Udm::Object& state_3f4, const Udm::Object& dstState_3fd, const Udm::Object& transition_406, const Udm::Object& function_40f, const Udm::Object& conditionalBlock_418)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_3f6= _state_3f0.begin(), itDstState_3ff= _dstState_3f9.begin(), itTransition_408= _transition_402.begin(), itFunction_411= _function_40b.begin(), itConditionalBlock_41a= _conditionalBlock_414.begin(); itState_3f6!= _state_3f0.end(), itDstState_3ff!= _dstState_3f9.end(), itTransition_408!= _transition_402.end(), itFunction_411!= _function_40b.end(), itConditionalBlock_41a!= _conditionalBlock_414.end(); ++itState_3f6, ++itDstState_3ff, ++itTransition_408, ++itFunction_411, ++itConditionalBlock_41a)
	{
		if( ( *itState_3f6== state_3f4)&& ( *itDstState_3ff== dstState_3fd)&& ( *itTransition_408== transition_406)&& ( *itFunction_411== function_40f)&& ( *itConditionalBlock_41a== conditionalBlock_418))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_3f0.push_back( state_3f4);
		_dstState_3f9.push_back( dstState_3fd);
		_transition_402.push_back( transition_406);
		_function_40b.push_back( function_40f);
		_conditionalBlock_414.push_back( conditionalBlock_418);
	}
	return isUnique;
}

void DstIsState_3db::processInputPackets( const Packets_t& states_3dc, const Packets_t& dstStates_3df, const Packets_t& transitions_3e2, const Packets_t& functions_3e5, const Packets_t& conditionalBlocks_3e8)
{
	for( Packets_t::const_iterator itState_3f1= states_3dc.begin(), itDstState_3fa= dstStates_3df.begin(), itTransition_403= transitions_3e2.begin(), itFunction_40c= functions_3e5.begin(), itConditionalBlock_415= conditionalBlocks_3e8.begin(); itState_3f1!= states_3dc.end(), itDstState_3fa!= dstStates_3df.end(), itTransition_403!= transitions_3e2.end(), itFunction_40c!= functions_3e5.end(), itConditionalBlock_415!= conditionalBlocks_3e8.end(); ++itState_3f1, ++itDstState_3fa, ++itTransition_403, ++itFunction_40c, ++itConditionalBlock_415)
	{
		bool isUnique= isInputUnique( *itState_3f1, *itDstState_3fa, *itTransition_403, *itFunction_40c, *itConditionalBlock_415);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_3f1, *itDstState_3fa, *itTransition_403, *itFunction_40c, *itConditionalBlock_415);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_41e, currMatch.dstState_41f, currMatch.transition_420, currMatch.function_421, currMatch.conditionalBlock_422);
	}
}

bool DstIsState_3db::patternMatcher( const Udm::Object& state_3f2, const Udm::Object& dstState_3fb, const Udm::Object& transition_404, const Udm::Object& function_40d, const Udm::Object& conditionalBlock_416)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_3f2.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_3f7= CyPhyML::SignalFlow::State::Cast( state_3f2);
		if( false== Uml::IsDerivedFrom( dstState_3fb.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State dstState_400= CyPhyML::SignalFlow::State::Cast( dstState_3fb);
		if( false== Uml::IsDerivedFrom( transition_404.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_409= CyPhyML::SignalFlow::Transition::Cast( transition_404);
		if( false== Uml::IsDerivedFrom( function_40d.type(), SFC::Function::meta))
			continue;
		SFC::Function function_412= SFC::Function::Cast( function_40d);
		if( false== Uml::IsDerivedFrom( conditionalBlock_416.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock conditionalBlock_41b= SFC::ConditionalBlock::Cast( conditionalBlock_416);
		Match currMatch;
		currMatch.state_41e= state_3f7;
		currMatch.dstState_41f= dstState_400;
		currMatch.transition_420= transition_409;
		currMatch.function_421= function_412;
		currMatch.conditionalBlock_422= conditionalBlock_41b;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void DstIsState_3db::outputAppender( const CyPhyML::SignalFlow::State& state_423, const CyPhyML::SignalFlow::State& dstState_425, const CyPhyML::SignalFlow::Transition& transition_427, const SFC::Function& function_429, const SFC::ConditionalBlock& conditionalBlock_42b)
{
	_state_3eb->push_back( state_423);
	_dstState_3ec->push_back( dstState_425);
	_transition_3ed->push_back( transition_427);
	_function_3ee->push_back( function_429);
	_conditionalBlock_3ef->push_back( conditionalBlock_42b);
}

bool DstIsRefState_42d::operator()( const Packets_t& states_42e, const Packets_t& connectorRefs_431, const Packets_t& transitions_434, const Packets_t& functions_437, const Packets_t& conditionalBlocks_43a, Packets_t& states_430, Packets_t& connectorRefs_433, Packets_t& transitions_436, Packets_t& functions_439, Packets_t& conditionalBlocks_43c)
{
#ifdef PRINT_INFO
	printLog( "DstIsRefState_42d" );
#endif
	_state_43d= &states_430;
	_connectorRef_43e= &connectorRefs_433;
	_transition_43f= &transitions_436;
	_function_440= &functions_439;
	_conditionalBlock_441= &conditionalBlocks_43c;
	processInputPackets( states_42e, connectorRefs_431, transitions_434, functions_437, conditionalBlocks_43a);
	if( false== _matches.empty())
		return true;
	return false;
}

bool DstIsRefState_42d::isInputUnique( const Udm::Object& state_446, const Udm::Object& connectorRef_44f, const Udm::Object& transition_458, const Udm::Object& function_461, const Udm::Object& conditionalBlock_46a)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_448= _state_442.begin(), itConnectorRef_451= _connectorRef_44b.begin(), itTransition_45a= _transition_454.begin(), itFunction_463= _function_45d.begin(), itConditionalBlock_46c= _conditionalBlock_466.begin(); itState_448!= _state_442.end(), itConnectorRef_451!= _connectorRef_44b.end(), itTransition_45a!= _transition_454.end(), itFunction_463!= _function_45d.end(), itConditionalBlock_46c!= _conditionalBlock_466.end(); ++itState_448, ++itConnectorRef_451, ++itTransition_45a, ++itFunction_463, ++itConditionalBlock_46c)
	{
		if( ( *itState_448== state_446)&& ( *itConnectorRef_451== connectorRef_44f)&& ( *itTransition_45a== transition_458)&& ( *itFunction_463== function_461)&& ( *itConditionalBlock_46c== conditionalBlock_46a))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_442.push_back( state_446);
		_connectorRef_44b.push_back( connectorRef_44f);
		_transition_454.push_back( transition_458);
		_function_45d.push_back( function_461);
		_conditionalBlock_466.push_back( conditionalBlock_46a);
	}
	return isUnique;
}

void DstIsRefState_42d::processInputPackets( const Packets_t& states_42e, const Packets_t& connectorRefs_431, const Packets_t& transitions_434, const Packets_t& functions_437, const Packets_t& conditionalBlocks_43a)
{
	for( Packets_t::const_iterator itState_443= states_42e.begin(), itConnectorRef_44c= connectorRefs_431.begin(), itTransition_455= transitions_434.begin(), itFunction_45e= functions_437.begin(), itConditionalBlock_467= conditionalBlocks_43a.begin(); itState_443!= states_42e.end(), itConnectorRef_44c!= connectorRefs_431.end(), itTransition_455!= transitions_434.end(), itFunction_45e!= functions_437.end(), itConditionalBlock_467!= conditionalBlocks_43a.end(); ++itState_443, ++itConnectorRef_44c, ++itTransition_455, ++itFunction_45e, ++itConditionalBlock_467)
	{
		bool isUnique= isInputUnique( *itState_443, *itConnectorRef_44c, *itTransition_455, *itFunction_45e, *itConditionalBlock_467);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_443, *itConnectorRef_44c, *itTransition_455, *itFunction_45e, *itConditionalBlock_467);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_472, currMatch.connectorRef_473, currMatch.transition_474, currMatch.function_475, currMatch.conditionalBlock_476);
	}
}

bool DstIsRefState_42d::patternMatcher( const Udm::Object& state_444, const Udm::Object& connectorRef_44d, const Udm::Object& transition_456, const Udm::Object& function_45f, const Udm::Object& conditionalBlock_468)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_444.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_449= CyPhyML::SignalFlow::State::Cast( state_444);
		if( false== Uml::IsDerivedFrom( connectorRef_44d.type(), CyPhyML::SignalFlow::ConnectorRef::meta))
			continue;
		CyPhyML::SignalFlow::ConnectorRef connectorRef_452= CyPhyML::SignalFlow::ConnectorRef::Cast( connectorRef_44d);
		if( false== Uml::IsDerivedFrom( transition_456.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_45b= CyPhyML::SignalFlow::Transition::Cast( transition_456);
		if( false== Uml::IsDerivedFrom( function_45f.type(), SFC::Function::meta))
			continue;
		SFC::Function function_464= SFC::Function::Cast( function_45f);
		if( false== Uml::IsDerivedFrom( conditionalBlock_468.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock conditionalBlock_46d= SFC::ConditionalBlock::Cast( conditionalBlock_468);
		CyPhyML::SignalFlow::TransConnector dstState_46f= connectorRef_452.ref();
		if( false== Uml::IsDerivedFrom( dstState_46f.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State dstState_470= CyPhyML::SignalFlow::State::Cast( dstState_46f);
		if( !dstState_470)
			continue;
		Match currMatch;
		currMatch.state_472= state_449;
		currMatch.connectorRef_473= connectorRef_452;
		currMatch.transition_474= transition_45b;
		currMatch.function_475= function_464;
		currMatch.conditionalBlock_476= conditionalBlock_46d;
		currMatch.dstState_477= dstState_470;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void DstIsRefState_42d::outputAppender( const CyPhyML::SignalFlow::State& state_478, const CyPhyML::SignalFlow::ConnectorRef& connectorRef_47a, const CyPhyML::SignalFlow::Transition& transition_47c, const SFC::Function& function_47e, const SFC::ConditionalBlock& conditionalBlock_480)
{
	_state_43d->push_back( state_478);
	_connectorRef_43e->push_back( connectorRef_47a);
	_transition_43f->push_back( transition_47c);
	_function_440->push_back( function_47e);
	_conditionalBlock_441->push_back( conditionalBlock_480);
}

bool DstIsJuncWithTrans_482::operator()( const Packets_t& states_483, const Packets_t& junctions_486, const Packets_t& transitions_489, const Packets_t& functions_48c, const Packets_t& conditionalBlocks_48f, Packets_t& states_485, Packets_t& junctions_488, Packets_t& transitions_48b, Packets_t& functions_48e, Packets_t& conditionalBlocks_491)
{
#ifdef PRINT_INFO
	printLog( "DstIsJuncWithTrans_482" );
#endif
	_state_492= &states_485;
	_junction_493= &junctions_488;
	_transition_494= &transitions_48b;
	_function_495= &functions_48e;
	_conditionalBlock_496= &conditionalBlocks_491;
	processInputPackets( states_483, junctions_486, transitions_489, functions_48c, conditionalBlocks_48f);
	if( false== _matches.empty())
		return true;
	return false;
}

bool DstIsJuncWithTrans_482::isInputUnique( const Udm::Object& state_49b, const Udm::Object& junction_4a4, const Udm::Object& transition_4ad, const Udm::Object& function_4b6, const Udm::Object& conditionalBlock_4bf)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_49d= _state_497.begin(), itJunction_4a6= _junction_4a0.begin(), itTransition_4af= _transition_4a9.begin(), itFunction_4b8= _function_4b2.begin(), itConditionalBlock_4c1= _conditionalBlock_4bb.begin(); itState_49d!= _state_497.end(), itJunction_4a6!= _junction_4a0.end(), itTransition_4af!= _transition_4a9.end(), itFunction_4b8!= _function_4b2.end(), itConditionalBlock_4c1!= _conditionalBlock_4bb.end(); ++itState_49d, ++itJunction_4a6, ++itTransition_4af, ++itFunction_4b8, ++itConditionalBlock_4c1)
	{
		if( ( *itState_49d== state_49b)&& ( *itJunction_4a6== junction_4a4)&& ( *itTransition_4af== transition_4ad)&& ( *itFunction_4b8== function_4b6)&& ( *itConditionalBlock_4c1== conditionalBlock_4bf))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_497.push_back( state_49b);
		_junction_4a0.push_back( junction_4a4);
		_transition_4a9.push_back( transition_4ad);
		_function_4b2.push_back( function_4b6);
		_conditionalBlock_4bb.push_back( conditionalBlock_4bf);
	}
	return isUnique;
}

void DstIsJuncWithTrans_482::processInputPackets( const Packets_t& states_483, const Packets_t& junctions_486, const Packets_t& transitions_489, const Packets_t& functions_48c, const Packets_t& conditionalBlocks_48f)
{
	for( Packets_t::const_iterator itState_498= states_483.begin(), itJunction_4a1= junctions_486.begin(), itTransition_4aa= transitions_489.begin(), itFunction_4b3= functions_48c.begin(), itConditionalBlock_4bc= conditionalBlocks_48f.begin(); itState_498!= states_483.end(), itJunction_4a1!= junctions_486.end(), itTransition_4aa!= transitions_489.end(), itFunction_4b3!= functions_48c.end(), itConditionalBlock_4bc!= conditionalBlocks_48f.end(); ++itState_498, ++itJunction_4a1, ++itTransition_4aa, ++itFunction_4b3, ++itConditionalBlock_4bc)
	{
		bool isUnique= isInputUnique( *itState_498, *itJunction_4a1, *itTransition_4aa, *itFunction_4b3, *itConditionalBlock_4bc);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_498, *itJunction_4a1, *itTransition_4aa, *itFunction_4b3, *itConditionalBlock_4bc);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_4c9, currMatch.junction_4ca, currMatch.transition_4cb, currMatch.function_4cc, currMatch.conditionalBlock_4cd);
	}
}

bool DstIsJuncWithTrans_482::patternMatcher( const Udm::Object& state_499, const Udm::Object& junction_4a2, const Udm::Object& transition_4ab, const Udm::Object& function_4b4, const Udm::Object& conditionalBlock_4bd)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_499.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_49e= CyPhyML::SignalFlow::State::Cast( state_499);
		if( false== Uml::IsDerivedFrom( junction_4a2.type(), CyPhyML::SignalFlow::SF_Junction::meta))
			continue;
		CyPhyML::SignalFlow::SF_Junction junction_4a7= CyPhyML::SignalFlow::SF_Junction::Cast( junction_4a2);
		if( false== Uml::IsDerivedFrom( transition_4ab.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_4b0= CyPhyML::SignalFlow::Transition::Cast( transition_4ab);
		if( false== Uml::IsDerivedFrom( function_4b4.type(), SFC::Function::meta))
			continue;
		SFC::Function function_4b9= SFC::Function::Cast( function_4b4);
		if( false== Uml::IsDerivedFrom( conditionalBlock_4bd.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock conditionalBlock_4c2= SFC::ConditionalBlock::Cast( conditionalBlock_4bd);
		set< CyPhyML::SignalFlow::Transition> transition2s_4c4= junction_4a7.dstTransition();
		for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransition2s_4c5= transition2s_4c4.begin(); itTransition2s_4c5!= transition2s_4c4.end(); ++itTransition2s_4c5)
		{
			CyPhyML::SignalFlow::Transition currTransition2_4c6= *itTransition2s_4c5;
			CyPhyML::SignalFlow::TransConnector transConnector_4c7= currTransition2_4c6.dstTransition_end();
			Match currMatch;
			currMatch.state_4c9= state_49e;
			currMatch.junction_4ca= junction_4a7;
			currMatch.transition_4cb= transition_4b0;
			currMatch.function_4cc= function_4b9;
			currMatch.conditionalBlock_4cd= conditionalBlock_4c2;
			currMatch.transition2_4ce= currTransition2_4c6;
			currMatch.transConnector_4cf= transConnector_4c7;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void DstIsJuncWithTrans_482::outputAppender( const CyPhyML::SignalFlow::State& state_4d0, const CyPhyML::SignalFlow::SF_Junction& junction_4d2, const CyPhyML::SignalFlow::Transition& transition_4d4, const SFC::Function& function_4d6, const SFC::ConditionalBlock& conditionalBlock_4d8)
{
	_state_492->push_back( state_4d0);
	_junction_493->push_back( junction_4d2);
	_transition_494->push_back( transition_4d4);
	_function_495->push_back( function_4d6);
	_conditionalBlock_496->push_back( conditionalBlock_4d8);
}

bool DstIsJuncWithRefTrans_4da::operator()( const Packets_t& states_4db, const Packets_t& junctions_4de, const Packets_t& transitions_4e1, const Packets_t& functions_4e4, const Packets_t& conditionalBlocks_4e7, Packets_t& states_4dd, Packets_t& junctions_4e0, Packets_t& transitions_4e3, Packets_t& functions_4e6, Packets_t& conditionalBlocks_4e9)
{
#ifdef PRINT_INFO
	printLog( "DstIsJuncWithRefTrans_4da" );
#endif
	_state_4ea= &states_4dd;
	_junction_4eb= &junctions_4e0;
	_transition_4ec= &transitions_4e3;
	_function_4ed= &functions_4e6;
	_conditionalBlock_4ee= &conditionalBlocks_4e9;
	processInputPackets( states_4db, junctions_4de, transitions_4e1, functions_4e4, conditionalBlocks_4e7);
	if( false== _matches.empty())
		return true;
	return false;
}

bool DstIsJuncWithRefTrans_4da::isInputUnique( const Udm::Object& state_4f3, const Udm::Object& junction_4fc, const Udm::Object& transition_505, const Udm::Object& function_50e, const Udm::Object& conditionalBlock_517)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_4f5= _state_4ef.begin(), itJunction_4fe= _junction_4f8.begin(), itTransition_507= _transition_501.begin(), itFunction_510= _function_50a.begin(), itConditionalBlock_519= _conditionalBlock_513.begin(); itState_4f5!= _state_4ef.end(), itJunction_4fe!= _junction_4f8.end(), itTransition_507!= _transition_501.end(), itFunction_510!= _function_50a.end(), itConditionalBlock_519!= _conditionalBlock_513.end(); ++itState_4f5, ++itJunction_4fe, ++itTransition_507, ++itFunction_510, ++itConditionalBlock_519)
	{
		if( ( *itState_4f5== state_4f3)&& ( *itJunction_4fe== junction_4fc)&& ( *itTransition_507== transition_505)&& ( *itFunction_510== function_50e)&& ( *itConditionalBlock_519== conditionalBlock_517))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_4ef.push_back( state_4f3);
		_junction_4f8.push_back( junction_4fc);
		_transition_501.push_back( transition_505);
		_function_50a.push_back( function_50e);
		_conditionalBlock_513.push_back( conditionalBlock_517);
	}
	return isUnique;
}

void DstIsJuncWithRefTrans_4da::processInputPackets( const Packets_t& states_4db, const Packets_t& junctions_4de, const Packets_t& transitions_4e1, const Packets_t& functions_4e4, const Packets_t& conditionalBlocks_4e7)
{
	for( Packets_t::const_iterator itState_4f0= states_4db.begin(), itJunction_4f9= junctions_4de.begin(), itTransition_502= transitions_4e1.begin(), itFunction_50b= functions_4e4.begin(), itConditionalBlock_514= conditionalBlocks_4e7.begin(); itState_4f0!= states_4db.end(), itJunction_4f9!= junctions_4de.end(), itTransition_502!= transitions_4e1.end(), itFunction_50b!= functions_4e4.end(), itConditionalBlock_514!= conditionalBlocks_4e7.end(); ++itState_4f0, ++itJunction_4f9, ++itTransition_502, ++itFunction_50b, ++itConditionalBlock_514)
	{
		bool isUnique= isInputUnique( *itState_4f0, *itJunction_4f9, *itTransition_502, *itFunction_50b, *itConditionalBlock_514);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_4f0, *itJunction_4f9, *itTransition_502, *itFunction_50b, *itConditionalBlock_514);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_524, currMatch.junction_525, currMatch.transition_526, currMatch.function_527, currMatch.conditionalBlock_528);
	}
}

bool DstIsJuncWithRefTrans_4da::patternMatcher( const Udm::Object& state_4f1, const Udm::Object& junction_4fa, const Udm::Object& transition_503, const Udm::Object& function_50c, const Udm::Object& conditionalBlock_515)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_4f1.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_4f6= CyPhyML::SignalFlow::State::Cast( state_4f1);
		if( false== Uml::IsDerivedFrom( junction_4fa.type(), CyPhyML::SignalFlow::SF_Junction::meta))
			continue;
		CyPhyML::SignalFlow::SF_Junction junction_4ff= CyPhyML::SignalFlow::SF_Junction::Cast( junction_4fa);
		if( false== Uml::IsDerivedFrom( transition_503.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_508= CyPhyML::SignalFlow::Transition::Cast( transition_503);
		if( false== Uml::IsDerivedFrom( function_50c.type(), SFC::Function::meta))
			continue;
		SFC::Function function_511= SFC::Function::Cast( function_50c);
		if( false== Uml::IsDerivedFrom( conditionalBlock_515.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock conditionalBlock_51a= SFC::ConditionalBlock::Cast( conditionalBlock_515);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_51c= junction_4ff.referedbyConnectorRef();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRefs_51d= connectorRefs_51c.begin(); itConnectorRefs_51d!= connectorRefs_51c.end(); ++itConnectorRefs_51d)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_51e= *itConnectorRefs_51d;
			set< CyPhyML::SignalFlow::Transition> transition2s_51f= currConnectorRef_51e.dstTransition();
			for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransition2s_520= transition2s_51f.begin(); itTransition2s_520!= transition2s_51f.end(); ++itTransition2s_520)
			{
				CyPhyML::SignalFlow::Transition currTransition2_521= *itTransition2s_520;
				CyPhyML::SignalFlow::TransConnector transConnector_522= currTransition2_521.dstTransition_end();
				Match currMatch;
				currMatch.state_524= state_4f6;
				currMatch.junction_525= junction_4ff;
				currMatch.transition_526= transition_508;
				currMatch.function_527= function_511;
				currMatch.conditionalBlock_528= conditionalBlock_51a;
				currMatch.connectorRef_529= currConnectorRef_51e;
				currMatch.transition2_52a= currTransition2_521;
				currMatch.transConnector_52b= transConnector_522;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void DstIsJuncWithRefTrans_4da::outputAppender( const CyPhyML::SignalFlow::State& state_52c, const CyPhyML::SignalFlow::SF_Junction& junction_52e, const CyPhyML::SignalFlow::Transition& transition_530, const SFC::Function& function_532, const SFC::ConditionalBlock& conditionalBlock_534)
{
	_state_4ea->push_back( state_52c);
	_junction_4eb->push_back( junction_52e);
	_transition_4ec->push_back( transition_530);
	_function_4ed->push_back( function_532);
	_conditionalBlock_4ee->push_back( conditionalBlock_534);
}

bool DstIsJuncRefWithTrans_536::operator()( const Packets_t& states_537, const Packets_t& connectorRefs_53a, const Packets_t& transitions_53d, const Packets_t& functions_540, const Packets_t& conditionalBlocks_543, Packets_t& states_539, Packets_t& connectorRefs_53c, Packets_t& transitions_53f, Packets_t& functions_542, Packets_t& conditionalBlocks_545)
{
#ifdef PRINT_INFO
	printLog( "DstIsJuncRefWithTrans_536" );
#endif
	_state_546= &states_539;
	_connectorRef_547= &connectorRefs_53c;
	_transition_548= &transitions_53f;
	_function_549= &functions_542;
	_conditionalBlock_54a= &conditionalBlocks_545;
	processInputPackets( states_537, connectorRefs_53a, transitions_53d, functions_540, conditionalBlocks_543);
	if( false== _matches.empty())
		return true;
	return false;
}

bool DstIsJuncRefWithTrans_536::isInputUnique( const Udm::Object& state_54f, const Udm::Object& connectorRef_558, const Udm::Object& transition_561, const Udm::Object& function_56a, const Udm::Object& conditionalBlock_573)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_551= _state_54b.begin(), itConnectorRef_55a= _connectorRef_554.begin(), itTransition_563= _transition_55d.begin(), itFunction_56c= _function_566.begin(), itConditionalBlock_575= _conditionalBlock_56f.begin(); itState_551!= _state_54b.end(), itConnectorRef_55a!= _connectorRef_554.end(), itTransition_563!= _transition_55d.end(), itFunction_56c!= _function_566.end(), itConditionalBlock_575!= _conditionalBlock_56f.end(); ++itState_551, ++itConnectorRef_55a, ++itTransition_563, ++itFunction_56c, ++itConditionalBlock_575)
	{
		if( ( *itState_551== state_54f)&& ( *itConnectorRef_55a== connectorRef_558)&& ( *itTransition_563== transition_561)&& ( *itFunction_56c== function_56a)&& ( *itConditionalBlock_575== conditionalBlock_573))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_54b.push_back( state_54f);
		_connectorRef_554.push_back( connectorRef_558);
		_transition_55d.push_back( transition_561);
		_function_566.push_back( function_56a);
		_conditionalBlock_56f.push_back( conditionalBlock_573);
	}
	return isUnique;
}

void DstIsJuncRefWithTrans_536::processInputPackets( const Packets_t& states_537, const Packets_t& connectorRefs_53a, const Packets_t& transitions_53d, const Packets_t& functions_540, const Packets_t& conditionalBlocks_543)
{
	for( Packets_t::const_iterator itState_54c= states_537.begin(), itConnectorRef_555= connectorRefs_53a.begin(), itTransition_55e= transitions_53d.begin(), itFunction_567= functions_540.begin(), itConditionalBlock_570= conditionalBlocks_543.begin(); itState_54c!= states_537.end(), itConnectorRef_555!= connectorRefs_53a.end(), itTransition_55e!= transitions_53d.end(), itFunction_567!= functions_540.end(), itConditionalBlock_570!= conditionalBlocks_543.end(); ++itState_54c, ++itConnectorRef_555, ++itTransition_55e, ++itFunction_567, ++itConditionalBlock_570)
	{
		bool isUnique= isInputUnique( *itState_54c, *itConnectorRef_555, *itTransition_55e, *itFunction_567, *itConditionalBlock_570);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_54c, *itConnectorRef_555, *itTransition_55e, *itFunction_567, *itConditionalBlock_570);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_57f, currMatch.connectorRef_580, currMatch.transition_581, currMatch.function_582, currMatch.conditionalBlock_583);
	}
}

bool DstIsJuncRefWithTrans_536::patternMatcher( const Udm::Object& state_54d, const Udm::Object& connectorRef_556, const Udm::Object& transition_55f, const Udm::Object& function_568, const Udm::Object& conditionalBlock_571)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_54d.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_552= CyPhyML::SignalFlow::State::Cast( state_54d);
		if( false== Uml::IsDerivedFrom( connectorRef_556.type(), CyPhyML::SignalFlow::ConnectorRef::meta))
			continue;
		CyPhyML::SignalFlow::ConnectorRef connectorRef_55b= CyPhyML::SignalFlow::ConnectorRef::Cast( connectorRef_556);
		if( false== Uml::IsDerivedFrom( transition_55f.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_564= CyPhyML::SignalFlow::Transition::Cast( transition_55f);
		if( false== Uml::IsDerivedFrom( function_568.type(), SFC::Function::meta))
			continue;
		SFC::Function function_56d= SFC::Function::Cast( function_568);
		if( false== Uml::IsDerivedFrom( conditionalBlock_571.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock conditionalBlock_576= SFC::ConditionalBlock::Cast( conditionalBlock_571);
		CyPhyML::SignalFlow::TransConnector junction_578= connectorRef_55b.ref();
		if( false== Uml::IsDerivedFrom( junction_578.type(), CyPhyML::SignalFlow::SF_Junction::meta))
			continue;
		CyPhyML::SignalFlow::SF_Junction junction_579= CyPhyML::SignalFlow::SF_Junction::Cast( junction_578);
		if( !junction_579)
			continue;
		set< CyPhyML::SignalFlow::Transition> transition2s_57a= connectorRef_55b.dstTransition();
		for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransition2s_57b= transition2s_57a.begin(); itTransition2s_57b!= transition2s_57a.end(); ++itTransition2s_57b)
		{
			CyPhyML::SignalFlow::Transition currTransition2_57c= *itTransition2s_57b;
			CyPhyML::SignalFlow::TransConnector transConnector_57d= currTransition2_57c.dstTransition_end();
			Match currMatch;
			currMatch.state_57f= state_552;
			currMatch.connectorRef_580= connectorRef_55b;
			currMatch.transition_581= transition_564;
			currMatch.function_582= function_56d;
			currMatch.conditionalBlock_583= conditionalBlock_576;
			currMatch.junction_584= junction_579;
			currMatch.transition2_585= currTransition2_57c;
			currMatch.transConnector_586= transConnector_57d;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void DstIsJuncRefWithTrans_536::outputAppender( const CyPhyML::SignalFlow::State& state_587, const CyPhyML::SignalFlow::ConnectorRef& connectorRef_589, const CyPhyML::SignalFlow::Transition& transition_58b, const SFC::Function& function_58d, const SFC::ConditionalBlock& conditionalBlock_58f)
{
	_state_546->push_back( state_587);
	_connectorRef_547->push_back( connectorRef_589);
	_transition_548->push_back( transition_58b);
	_function_549->push_back( function_58d);
	_conditionalBlock_54a->push_back( conditionalBlock_58f);
}

bool DstIsJuncRefWithJuncTrans_591::operator()( const Packets_t& states_592, const Packets_t& connectorRefs_595, const Packets_t& transitions_598, const Packets_t& functions_59b, const Packets_t& conditionalBlocks_59e, Packets_t& states_594, Packets_t& connectorRefs_597, Packets_t& transitions_59a, Packets_t& functions_59d, Packets_t& conditionalBlocks_5a0)
{
#ifdef PRINT_INFO
	printLog( "DstIsJuncRefWithJuncTrans_591" );
#endif
	_state_5a1= &states_594;
	_connectorRef_5a2= &connectorRefs_597;
	_transition_5a3= &transitions_59a;
	_function_5a4= &functions_59d;
	_conditionalBlock_5a5= &conditionalBlocks_5a0;
	processInputPackets( states_592, connectorRefs_595, transitions_598, functions_59b, conditionalBlocks_59e);
	if( false== _matches.empty())
		return true;
	return false;
}

bool DstIsJuncRefWithJuncTrans_591::isInputUnique( const Udm::Object& state_5aa, const Udm::Object& connectorRef_5b3, const Udm::Object& transition_5bc, const Udm::Object& function_5c5, const Udm::Object& conditionalBlock_5ce)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_5ac= _state_5a6.begin(), itConnectorRef_5b5= _connectorRef_5af.begin(), itTransition_5be= _transition_5b8.begin(), itFunction_5c7= _function_5c1.begin(), itConditionalBlock_5d0= _conditionalBlock_5ca.begin(); itState_5ac!= _state_5a6.end(), itConnectorRef_5b5!= _connectorRef_5af.end(), itTransition_5be!= _transition_5b8.end(), itFunction_5c7!= _function_5c1.end(), itConditionalBlock_5d0!= _conditionalBlock_5ca.end(); ++itState_5ac, ++itConnectorRef_5b5, ++itTransition_5be, ++itFunction_5c7, ++itConditionalBlock_5d0)
	{
		if( ( *itState_5ac== state_5aa)&& ( *itConnectorRef_5b5== connectorRef_5b3)&& ( *itTransition_5be== transition_5bc)&& ( *itFunction_5c7== function_5c5)&& ( *itConditionalBlock_5d0== conditionalBlock_5ce))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_5a6.push_back( state_5aa);
		_connectorRef_5af.push_back( connectorRef_5b3);
		_transition_5b8.push_back( transition_5bc);
		_function_5c1.push_back( function_5c5);
		_conditionalBlock_5ca.push_back( conditionalBlock_5ce);
	}
	return isUnique;
}

void DstIsJuncRefWithJuncTrans_591::processInputPackets( const Packets_t& states_592, const Packets_t& connectorRefs_595, const Packets_t& transitions_598, const Packets_t& functions_59b, const Packets_t& conditionalBlocks_59e)
{
	for( Packets_t::const_iterator itState_5a7= states_592.begin(), itConnectorRef_5b0= connectorRefs_595.begin(), itTransition_5b9= transitions_598.begin(), itFunction_5c2= functions_59b.begin(), itConditionalBlock_5cb= conditionalBlocks_59e.begin(); itState_5a7!= states_592.end(), itConnectorRef_5b0!= connectorRefs_595.end(), itTransition_5b9!= transitions_598.end(), itFunction_5c2!= functions_59b.end(), itConditionalBlock_5cb!= conditionalBlocks_59e.end(); ++itState_5a7, ++itConnectorRef_5b0, ++itTransition_5b9, ++itFunction_5c2, ++itConditionalBlock_5cb)
	{
		bool isUnique= isInputUnique( *itState_5a7, *itConnectorRef_5b0, *itTransition_5b9, *itFunction_5c2, *itConditionalBlock_5cb);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_5a7, *itConnectorRef_5b0, *itTransition_5b9, *itFunction_5c2, *itConditionalBlock_5cb);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_5da, currMatch.connectorRef_5db, currMatch.transition_5dc, currMatch.function_5dd, currMatch.conditionalBlock_5de);
	}
}

bool DstIsJuncRefWithJuncTrans_591::patternMatcher( const Udm::Object& state_5a8, const Udm::Object& connectorRef_5b1, const Udm::Object& transition_5ba, const Udm::Object& function_5c3, const Udm::Object& conditionalBlock_5cc)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_5a8.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_5ad= CyPhyML::SignalFlow::State::Cast( state_5a8);
		if( false== Uml::IsDerivedFrom( connectorRef_5b1.type(), CyPhyML::SignalFlow::ConnectorRef::meta))
			continue;
		CyPhyML::SignalFlow::ConnectorRef connectorRef_5b6= CyPhyML::SignalFlow::ConnectorRef::Cast( connectorRef_5b1);
		if( false== Uml::IsDerivedFrom( transition_5ba.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_5bf= CyPhyML::SignalFlow::Transition::Cast( transition_5ba);
		if( false== Uml::IsDerivedFrom( function_5c3.type(), SFC::Function::meta))
			continue;
		SFC::Function function_5c8= SFC::Function::Cast( function_5c3);
		if( false== Uml::IsDerivedFrom( conditionalBlock_5cc.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock conditionalBlock_5d1= SFC::ConditionalBlock::Cast( conditionalBlock_5cc);
		CyPhyML::SignalFlow::TransConnector junction_5d3= connectorRef_5b6.ref();
		if( false== Uml::IsDerivedFrom( junction_5d3.type(), CyPhyML::SignalFlow::SF_Junction::meta))
			continue;
		CyPhyML::SignalFlow::SF_Junction junction_5d4= CyPhyML::SignalFlow::SF_Junction::Cast( junction_5d3);
		if( !junction_5d4)
			continue;
		set< CyPhyML::SignalFlow::Transition> transition2s_5d5= junction_5d4.dstTransition();
		for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransition2s_5d6= transition2s_5d5.begin(); itTransition2s_5d6!= transition2s_5d5.end(); ++itTransition2s_5d6)
		{
			CyPhyML::SignalFlow::Transition currTransition2_5d7= *itTransition2s_5d6;
			CyPhyML::SignalFlow::TransConnector transConnector_5d8= currTransition2_5d7.dstTransition_end();
			Match currMatch;
			currMatch.state_5da= state_5ad;
			currMatch.connectorRef_5db= connectorRef_5b6;
			currMatch.transition_5dc= transition_5bf;
			currMatch.function_5dd= function_5c8;
			currMatch.conditionalBlock_5de= conditionalBlock_5d1;
			currMatch.junction_5df= junction_5d4;
			currMatch.transition2_5e0= currTransition2_5d7;
			currMatch.transConnector_5e1= transConnector_5d8;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void DstIsJuncRefWithJuncTrans_591::outputAppender( const CyPhyML::SignalFlow::State& state_5e2, const CyPhyML::SignalFlow::ConnectorRef& connectorRef_5e4, const CyPhyML::SignalFlow::Transition& transition_5e6, const SFC::Function& function_5e8, const SFC::ConditionalBlock& conditionalBlock_5ea)
{
	_state_5a1->push_back( state_5e2);
	_connectorRef_5a2->push_back( connectorRef_5e4);
	_transition_5a3->push_back( transition_5e6);
	_function_5a4->push_back( function_5e8);
	_conditionalBlock_5a5->push_back( conditionalBlock_5ea);
}

bool DeadEnd_5ec::operator()( const Packets_t& states_5ed, const Packets_t& transConnectors_5f0, const Packets_t& transitions_5f3, const Packets_t& functions_5f6, const Packets_t& conditionalBlocks_5f9, Packets_t& states_5ef, Packets_t& transConnectors_5f2, Packets_t& transitions_5f5, Packets_t& functions_5f8, Packets_t& conditionalBlocks_5fb)
{
#ifdef PRINT_INFO
	printLog( "DeadEnd_5ec" );
#endif
	_state_5fc= &states_5ef;
	_transConnector_5fd= &transConnectors_5f2;
	_transition_5fe= &transitions_5f5;
	_function_5ff= &functions_5f8;
	_conditionalBlock_600= &conditionalBlocks_5fb;
	processInputPackets( states_5ed, transConnectors_5f0, transitions_5f3, functions_5f6, conditionalBlocks_5f9);
	if( false== _matches.empty())
		return true;
	return false;
}

bool DeadEnd_5ec::isInputUnique( const Udm::Object& state_605, const Udm::Object& transConnector_60e, const Udm::Object& transition_617, const Udm::Object& function_620, const Udm::Object& conditionalBlock_629)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_607= _state_601.begin(), itTransConnector_610= _transConnector_60a.begin(), itTransition_619= _transition_613.begin(), itFunction_622= _function_61c.begin(), itConditionalBlock_62b= _conditionalBlock_625.begin(); itState_607!= _state_601.end(), itTransConnector_610!= _transConnector_60a.end(), itTransition_619!= _transition_613.end(), itFunction_622!= _function_61c.end(), itConditionalBlock_62b!= _conditionalBlock_625.end(); ++itState_607, ++itTransConnector_610, ++itTransition_619, ++itFunction_622, ++itConditionalBlock_62b)
	{
		if( ( *itState_607== state_605)&& ( *itTransConnector_610== transConnector_60e)&& ( *itTransition_619== transition_617)&& ( *itFunction_622== function_620)&& ( *itConditionalBlock_62b== conditionalBlock_629))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_601.push_back( state_605);
		_transConnector_60a.push_back( transConnector_60e);
		_transition_613.push_back( transition_617);
		_function_61c.push_back( function_620);
		_conditionalBlock_625.push_back( conditionalBlock_629);
	}
	return isUnique;
}

void DeadEnd_5ec::processInputPackets( const Packets_t& states_5ed, const Packets_t& transConnectors_5f0, const Packets_t& transitions_5f3, const Packets_t& functions_5f6, const Packets_t& conditionalBlocks_5f9)
{
	for( Packets_t::const_iterator itState_602= states_5ed.begin(), itTransConnector_60b= transConnectors_5f0.begin(), itTransition_614= transitions_5f3.begin(), itFunction_61d= functions_5f6.begin(), itConditionalBlock_626= conditionalBlocks_5f9.begin(); itState_602!= states_5ed.end(), itTransConnector_60b!= transConnectors_5f0.end(), itTransition_614!= transitions_5f3.end(), itFunction_61d!= functions_5f6.end(), itConditionalBlock_626!= conditionalBlocks_5f9.end(); ++itState_602, ++itTransConnector_60b, ++itTransition_614, ++itFunction_61d, ++itConditionalBlock_626)
	{
		bool isUnique= isInputUnique( *itState_602, *itTransConnector_60b, *itTransition_614, *itFunction_61d, *itConditionalBlock_626);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_602, *itTransConnector_60b, *itTransition_614, *itFunction_61d, *itConditionalBlock_626);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_62f, currMatch.transConnector_630, currMatch.transition_631, currMatch.function_632, currMatch.conditionalBlock_633);
	}
}

bool DeadEnd_5ec::patternMatcher( const Udm::Object& state_603, const Udm::Object& transConnector_60c, const Udm::Object& transition_615, const Udm::Object& function_61e, const Udm::Object& conditionalBlock_627)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_603.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_608= CyPhyML::SignalFlow::State::Cast( state_603);
		if( false== Uml::IsDerivedFrom( transConnector_60c.type(), CyPhyML::SignalFlow::TransConnector::meta))
			continue;
		CyPhyML::SignalFlow::TransConnector transConnector_611= CyPhyML::SignalFlow::TransConnector::Cast( transConnector_60c);
		if( false== Uml::IsDerivedFrom( transition_615.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_61a= CyPhyML::SignalFlow::Transition::Cast( transition_615);
		if( false== Uml::IsDerivedFrom( function_61e.type(), SFC::Function::meta))
			continue;
		SFC::Function function_623= SFC::Function::Cast( function_61e);
		if( false== Uml::IsDerivedFrom( conditionalBlock_627.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock conditionalBlock_62c= SFC::ConditionalBlock::Cast( conditionalBlock_627);
		Match currMatch;
		currMatch.state_62f= state_608;
		currMatch.transConnector_630= transConnector_611;
		currMatch.transition_631= transition_61a;
		currMatch.function_632= function_623;
		currMatch.conditionalBlock_633= conditionalBlock_62c;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void DeadEnd_5ec::outputAppender( const CyPhyML::SignalFlow::State& state_634, const CyPhyML::SignalFlow::TransConnector& transConnector_636, const CyPhyML::SignalFlow::Transition& transition_638, const SFC::Function& function_63a, const SFC::ConditionalBlock& conditionalBlock_63c)
{
	_state_5fc->push_back( state_634);
	_transConnector_5fd->push_back( transConnector_636);
	_transition_5fe->push_back( transition_638);
	_function_5ff->push_back( function_63a);
	_conditionalBlock_600->push_back( conditionalBlock_63c);
}

void OrderTransitions_63e::operator()( const Packets_t& states_63f, const Packets_t& transitions_642, const Packets_t& functions_645, const Packets_t& compoundStatements_648, Packets_t& states_641, Packets_t& transitions_644, Packets_t& functions_647, Packets_t& compoundStatements_64a)
{
#ifdef PRINT_INFO
	printLog( "OrderTransitions_63e" );
#endif
	RTTGenerator::Instance()->generateRule(2455, "OrderTransitions");
	_state_64b= &states_641;
	_transition_64c= &transitions_644;
	_function_64d= &functions_647;
	_compoundStatement_64e= &compoundStatements_64a;
	processInputPackets( states_63f, transitions_642, functions_645, compoundStatements_648);
	sortOutputs( );
}

bool OrderTransitions_63e::isInputUnique( const Udm::Object& state_653, const Udm::Object& transition_65c, const Udm::Object& function_665, const Udm::Object& compoundStatement_66e)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_655= _state_64f.begin(), itTransition_65e= _transition_658.begin(), itFunction_667= _function_661.begin(), itCompoundStatement_670= _compoundStatement_66a.begin(); itState_655!= _state_64f.end(), itTransition_65e!= _transition_658.end(), itFunction_667!= _function_661.end(), itCompoundStatement_670!= _compoundStatement_66a.end(); ++itState_655, ++itTransition_65e, ++itFunction_667, ++itCompoundStatement_670)
	{
		if( ( *itState_655== state_653)&& ( *itTransition_65e== transition_65c)&& ( *itFunction_667== function_665)&& ( *itCompoundStatement_670== compoundStatement_66e))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_64f.push_back( state_653);
		_transition_658.push_back( transition_65c);
		_function_661.push_back( function_665);
		_compoundStatement_66a.push_back( compoundStatement_66e);
	}
	return isUnique;
}

void OrderTransitions_63e::processInputPackets( const Packets_t& states_63f, const Packets_t& transitions_642, const Packets_t& functions_645, const Packets_t& compoundStatements_648)
{
	for( Packets_t::const_iterator itState_650= states_63f.begin(), itTransition_659= transitions_642.begin(), itFunction_662= functions_645.begin(), itCompoundStatement_66b= compoundStatements_648.begin(); itState_650!= states_63f.end(), itTransition_659!= transitions_642.end(), itFunction_662!= functions_645.end(), itCompoundStatement_66b!= compoundStatements_648.end(); ++itState_650, ++itTransition_659, ++itFunction_662, ++itCompoundStatement_66b)
	{
		bool isUnique= isInputUnique( *itState_650, *itTransition_659, *itFunction_662, *itCompoundStatement_66b);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_650, *itTransition_659, *itFunction_662, *itCompoundStatement_66b);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool OrderTransitions_63e::patternMatcher( const Udm::Object& state_651, const Udm::Object& transition_65a, const Udm::Object& function_663, const Udm::Object& compoundStatement_66c)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_651.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_656= CyPhyML::SignalFlow::State::Cast( state_651);
		if( false== Uml::IsDerivedFrom( transition_65a.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_65f= CyPhyML::SignalFlow::Transition::Cast( transition_65a);
		if( false== Uml::IsDerivedFrom( function_663.type(), SFC::Function::meta))
			continue;
		SFC::Function function_668= SFC::Function::Cast( function_663);
		if( false== Uml::IsDerivedFrom( compoundStatement_66c.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_671= SFC::CompoundStatement::Cast( compoundStatement_66c);
		Match currMatch;
		currMatch.state_674= state_656;
		currMatch.transition_675= transition_65f;
		currMatch.function_676= function_668;
		currMatch.compoundStatement_677= compoundStatement_671;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void OrderTransitions_63e::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_674, currMatch.transition_675, currMatch.function_676, currMatch.compoundStatement_677);
	}
}

void OrderTransitions_63e::outputAppender( const CyPhyML::SignalFlow::State& state_678, const CyPhyML::SignalFlow::Transition& transition_67a, const SFC::Function& function_67c, const SFC::CompoundStatement& compoundStatement_67e)
{
	_state_64b->push_back( state_678);
	_transition_64c->push_back( transition_67a);
	_function_64d->push_back( function_67c);
	_compoundStatement_64e->push_back( compoundStatement_67e);
}

void OrderTransitions_63e::sortOutputs()
{
	typedef std::multiset< CyPhyML::SignalFlow::Transition, std::pointer_to_binary_function< const CyPhyML::SignalFlow::Transition&, const CyPhyML::SignalFlow::Transition&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const CyPhyML::SignalFlow::Transition&, const CyPhyML::SignalFlow::Transition&, bool> ptr_TransitionOrder( TransitionOrder< CyPhyML::SignalFlow::Transition>);
	SortedSet_t sortedSet( ptr_TransitionOrder);
	std::vector< int> permutationVector( _transition_64c->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _transition_64c->begin(); it!= _transition_64c->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( CyPhyML::SignalFlow::Transition::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _transition_64c->begin());
	// order rest of the containers
	permutate( permutationVector, *_state_64b);
	permutate( permutationVector, *_function_64d);
	permutate( permutationVector, *_compoundStatement_64e);
}

void GetAllTransitions_6b3::operator()( const Packets_t& states_6b4, const Packets_t& tcs_6b6, const Packets_t& fcns_6b8, const Packets_t& css_6ba, Packets_t& states_6bc, Packets_t& transs_6bd, Packets_t& fcns_6be, Packets_t& css_6bf)
{
#ifdef PRINT_INFO
	printLog( "GetAllTransitions_6b3" );
#endif
	_state_6c0= &states_6bc;
	_trans_6c1= &transs_6bd;
	_fcn_6c2= &fcns_6be;
	_cs_6c3= &css_6bf;
	if( ( !states_6b4.empty())&& ( !tcs_6b6.empty())&& ( !fcns_6b8.empty())&& ( !css_6ba.empty()))
		callGetTransitionsFromJunctionRefs_7af( states_6b4, tcs_6b6, fcns_6b8, css_6ba);
	if( ( !states_6b4.empty())&& ( !tcs_6b6.empty())&& ( !fcns_6b8.empty())&& ( !css_6ba.empty()))
		callGetDirectTransitions_7b4( states_6b4, tcs_6b6, fcns_6b8, css_6ba);
	if( ( !states_6b4.empty())&& ( !tcs_6b6.empty())&& ( !fcns_6b8.empty())&& ( !css_6ba.empty()))
		callGetTransitionsFromStateRefs_7b9( states_6b4, tcs_6b6, fcns_6b8, css_6ba);
}

void GetAllTransitions_6b3::callGetTransitionsFromJunctionRefs_7af( const Packets_t& states_6c5, const Packets_t& junctions_6c9, const Packets_t& functions_6cb, const Packets_t& compoundStatements_6ce)
{
	Packets_t states_6c7;
	Packets_t transitions_6c8;
	Packets_t functions_6cd;
	Packets_t compoundStatements_6d0;
	GetTransitionsFromJunctionRefs_6c4 getTransitionsFromJunctionRefs_6c4;
	getTransitionsFromJunctionRefs_6c4( states_6c5, junctions_6c9, functions_6cb, compoundStatements_6ce, states_6c7, transitions_6c8, functions_6cd, compoundStatements_6d0);
	_state_6c0->insert( _state_6c0->end(), states_6c7.begin(), states_6c7.end());
	_trans_6c1->insert( _trans_6c1->end(), transitions_6c8.begin(), transitions_6c8.end());
	_fcn_6c2->insert( _fcn_6c2->end(), functions_6cd.begin(), functions_6cd.end());
	_cs_6c3->insert( _cs_6c3->end(), compoundStatements_6d0.begin(), compoundStatements_6d0.end());
}

void GetAllTransitions_6b3::callGetDirectTransitions_7b4( const Packets_t& states_711, const Packets_t& srcTransConnectors_714, const Packets_t& functions_717, const Packets_t& compoundStatements_71a)
{
	Packets_t states_713;
	Packets_t transitions_716;
	Packets_t functions_719;
	Packets_t compoundStatements_71c;
	GetDirectTransitions_710 getDirectTransitions_710;
	getDirectTransitions_710( states_711, srcTransConnectors_714, functions_717, compoundStatements_71a, states_713, transitions_716, functions_719, compoundStatements_71c);
	_state_6c0->insert( _state_6c0->end(), states_713.begin(), states_713.end());
	_trans_6c1->insert( _trans_6c1->end(), transitions_716.begin(), transitions_716.end());
	_fcn_6c2->insert( _fcn_6c2->end(), functions_719.begin(), functions_719.end());
	_cs_6c3->insert( _cs_6c3->end(), compoundStatements_71c.begin(), compoundStatements_71c.end());
}

void GetAllTransitions_6b3::callGetTransitionsFromStateRefs_7b9( const Packets_t& states_759, const Packets_t& tCStates_75d, const Packets_t& functions_75f, const Packets_t& compoundStatements_762)
{
	Packets_t states_75b;
	Packets_t transitions_75c;
	Packets_t functions_761;
	Packets_t compoundStatements_764;
	GetTransitionsFromStateRefs_758 getTransitionsFromStateRefs_758;
	getTransitionsFromStateRefs_758( states_759, tCStates_75d, functions_75f, compoundStatements_762, states_75b, transitions_75c, functions_761, compoundStatements_764);
	_state_6c0->insert( _state_6c0->end(), states_75b.begin(), states_75b.end());
	_trans_6c1->insert( _trans_6c1->end(), transitions_75c.begin(), transitions_75c.end());
	_fcn_6c2->insert( _fcn_6c2->end(), functions_761.begin(), functions_761.end());
	_cs_6c3->insert( _cs_6c3->end(), compoundStatements_764.begin(), compoundStatements_764.end());
}

void GetTransitionsFromJunctionRefs_6c4::operator()( const Packets_t& states_6c5, const Packets_t& junctions_6c9, const Packets_t& functions_6cb, const Packets_t& compoundStatements_6ce, Packets_t& states_6c7, Packets_t& transitions_6c8, Packets_t& functions_6cd, Packets_t& compoundStatements_6d0)
{
#ifdef PRINT_INFO
	printLog( "GetTransitionsFromJunctionRefs_6c4" );
#endif
	RTTGenerator::Instance()->generateRule(2383, "GetTransitionsFromJunctionRefs");
	_state_6d1= &states_6c7;
	_transition_6d2= &transitions_6c8;
	_function_6d3= &functions_6cd;
	_compoundStatement_6d4= &compoundStatements_6d0;
	processInputPackets( states_6c5, junctions_6c9, functions_6cb, compoundStatements_6ce);
}

bool GetTransitionsFromJunctionRefs_6c4::isInputUnique( const Udm::Object& state_6d9, const Udm::Object& junction_6e2, const Udm::Object& function_6eb, const Udm::Object& compoundStatement_6f4)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_6db= _state_6d5.begin(), itJunction_6e4= _junction_6de.begin(), itFunction_6ed= _function_6e7.begin(), itCompoundStatement_6f6= _compoundStatement_6f0.begin(); itState_6db!= _state_6d5.end(), itJunction_6e4!= _junction_6de.end(), itFunction_6ed!= _function_6e7.end(), itCompoundStatement_6f6!= _compoundStatement_6f0.end(); ++itState_6db, ++itJunction_6e4, ++itFunction_6ed, ++itCompoundStatement_6f6)
	{
		if( ( *itState_6db== state_6d9)&& ( *itJunction_6e4== junction_6e2)&& ( *itFunction_6ed== function_6eb)&& ( *itCompoundStatement_6f6== compoundStatement_6f4))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_6d5.push_back( state_6d9);
		_junction_6de.push_back( junction_6e2);
		_function_6e7.push_back( function_6eb);
		_compoundStatement_6f0.push_back( compoundStatement_6f4);
	}
	return isUnique;
}

void GetTransitionsFromJunctionRefs_6c4::processInputPackets( const Packets_t& states_6c5, const Packets_t& junctions_6c9, const Packets_t& functions_6cb, const Packets_t& compoundStatements_6ce)
{
	for( Packets_t::const_iterator itState_6d6= states_6c5.begin(), itJunction_6df= junctions_6c9.begin(), itFunction_6e8= functions_6cb.begin(), itCompoundStatement_6f1= compoundStatements_6ce.begin(); itState_6d6!= states_6c5.end(), itJunction_6df!= junctions_6c9.end(), itFunction_6e8!= functions_6cb.end(), itCompoundStatement_6f1!= compoundStatements_6ce.end(); ++itState_6d6, ++itJunction_6df, ++itFunction_6e8, ++itCompoundStatement_6f1)
	{
		bool isUnique= isInputUnique( *itState_6d6, *itJunction_6df, *itFunction_6e8, *itCompoundStatement_6f1);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_6d6, *itJunction_6df, *itFunction_6e8, *itCompoundStatement_6f1);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetTransitionsFromJunctionRefs_6c4::patternMatcher( const Udm::Object& state_6d7, const Udm::Object& junction_6e0, const Udm::Object& function_6e9, const Udm::Object& compoundStatement_6f2)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_6d7.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_6dc= CyPhyML::SignalFlow::State::Cast( state_6d7);
		if( false== Uml::IsDerivedFrom( junction_6e0.type(), CyPhyML::SignalFlow::SF_Junction::meta))
			continue;
		CyPhyML::SignalFlow::SF_Junction junction_6e5= CyPhyML::SignalFlow::SF_Junction::Cast( junction_6e0);
		if( false== Uml::IsDerivedFrom( function_6e9.type(), SFC::Function::meta))
			continue;
		SFC::Function function_6ee= SFC::Function::Cast( function_6e9);
		if( false== Uml::IsDerivedFrom( compoundStatement_6f2.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_6f7= SFC::CompoundStatement::Cast( compoundStatement_6f2);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_6f9= junction_6e5.referedbyConnectorRef();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRefs_6fa= connectorRefs_6f9.begin(); itConnectorRefs_6fa!= connectorRefs_6f9.end(); ++itConnectorRefs_6fa)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_6fb= *itConnectorRefs_6fa;
			set< CyPhyML::SignalFlow::Transition> transitions_6fc= currConnectorRef_6fb.dstTransition();
			for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransitions_6fd= transitions_6fc.begin(); itTransitions_6fd!= transitions_6fc.end(); ++itTransitions_6fd)
			{
				CyPhyML::SignalFlow::Transition currTransition_6fe= *itTransitions_6fd;
				CyPhyML::SignalFlow::TransConnector dstTransConnector_6ff= currTransition_6fe.dstTransition_end();
				Match currMatch;
				currMatch.state_701= state_6dc;
				currMatch.junction_702= junction_6e5;
				currMatch.function_703= function_6ee;
				currMatch.compoundStatement_704= compoundStatement_6f7;
				currMatch.transition_705= currTransition_6fe;
				currMatch.connectorRef_706= currConnectorRef_6fb;
				currMatch.dstTransConnector_707= dstTransConnector_6ff;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetTransitionsFromJunctionRefs_6c4::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_701, currMatch.transition_705, currMatch.function_703, currMatch.compoundStatement_704);
	}
}

void GetTransitionsFromJunctionRefs_6c4::outputAppender( const CyPhyML::SignalFlow::State& state_708, const CyPhyML::SignalFlow::Transition& transition_70a, const SFC::Function& function_70c, const SFC::CompoundStatement& compoundStatement_70e)
{
	_state_6d1->push_back( state_708);
	_transition_6d2->push_back( transition_70a);
	_function_6d3->push_back( function_70c);
	_compoundStatement_6d4->push_back( compoundStatement_70e);
}

void GetDirectTransitions_710::operator()( const Packets_t& states_711, const Packets_t& srcTransConnectors_714, const Packets_t& functions_717, const Packets_t& compoundStatements_71a, Packets_t& states_713, Packets_t& transitions_716, Packets_t& functions_719, Packets_t& compoundStatements_71c)
{
#ifdef PRINT_INFO
	printLog( "GetDirectTransitions_710" );
#endif
	RTTGenerator::Instance()->generateRule(2394, "GetDirectTransitions");
	_state_71d= &states_713;
	_transition_71e= &transitions_716;
	_function_71f= &functions_719;
	_compoundStatement_720= &compoundStatements_71c;
	processInputPackets( states_711, srcTransConnectors_714, functions_717, compoundStatements_71a);
}

bool GetDirectTransitions_710::isInputUnique( const Udm::Object& state_725, const Udm::Object& srcTransConnector_72e, const Udm::Object& function_737, const Udm::Object& compoundStatement_740)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_727= _state_721.begin(), itSrcTransConnector_730= _srcTransConnector_72a.begin(), itFunction_739= _function_733.begin(), itCompoundStatement_742= _compoundStatement_73c.begin(); itState_727!= _state_721.end(), itSrcTransConnector_730!= _srcTransConnector_72a.end(), itFunction_739!= _function_733.end(), itCompoundStatement_742!= _compoundStatement_73c.end(); ++itState_727, ++itSrcTransConnector_730, ++itFunction_739, ++itCompoundStatement_742)
	{
		if( ( *itState_727== state_725)&& ( *itSrcTransConnector_730== srcTransConnector_72e)&& ( *itFunction_739== function_737)&& ( *itCompoundStatement_742== compoundStatement_740))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_721.push_back( state_725);
		_srcTransConnector_72a.push_back( srcTransConnector_72e);
		_function_733.push_back( function_737);
		_compoundStatement_73c.push_back( compoundStatement_740);
	}
	return isUnique;
}

void GetDirectTransitions_710::processInputPackets( const Packets_t& states_711, const Packets_t& srcTransConnectors_714, const Packets_t& functions_717, const Packets_t& compoundStatements_71a)
{
	for( Packets_t::const_iterator itState_722= states_711.begin(), itSrcTransConnector_72b= srcTransConnectors_714.begin(), itFunction_734= functions_717.begin(), itCompoundStatement_73d= compoundStatements_71a.begin(); itState_722!= states_711.end(), itSrcTransConnector_72b!= srcTransConnectors_714.end(), itFunction_734!= functions_717.end(), itCompoundStatement_73d!= compoundStatements_71a.end(); ++itState_722, ++itSrcTransConnector_72b, ++itFunction_734, ++itCompoundStatement_73d)
	{
		bool isUnique= isInputUnique( *itState_722, *itSrcTransConnector_72b, *itFunction_734, *itCompoundStatement_73d);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_722, *itSrcTransConnector_72b, *itFunction_734, *itCompoundStatement_73d);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetDirectTransitions_710::patternMatcher( const Udm::Object& state_723, const Udm::Object& srcTransConnector_72c, const Udm::Object& function_735, const Udm::Object& compoundStatement_73e)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_723.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_728= CyPhyML::SignalFlow::State::Cast( state_723);
		if( false== Uml::IsDerivedFrom( srcTransConnector_72c.type(), CyPhyML::SignalFlow::TransConnector::meta))
			continue;
		CyPhyML::SignalFlow::TransConnector srcTransConnector_731= CyPhyML::SignalFlow::TransConnector::Cast( srcTransConnector_72c);
		if( false== Uml::IsDerivedFrom( function_735.type(), SFC::Function::meta))
			continue;
		SFC::Function function_73a= SFC::Function::Cast( function_735);
		if( false== Uml::IsDerivedFrom( compoundStatement_73e.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_743= SFC::CompoundStatement::Cast( compoundStatement_73e);
		set< CyPhyML::SignalFlow::Transition> transitions_745= srcTransConnector_731.dstTransition();
		for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransitions_746= transitions_745.begin(); itTransitions_746!= transitions_745.end(); ++itTransitions_746)
		{
			CyPhyML::SignalFlow::Transition currTransition_747= *itTransitions_746;
			CyPhyML::SignalFlow::TransConnector dstTransConnector_748= currTransition_747.dstTransition_end();
			Match currMatch;
			currMatch.state_74a= state_728;
			currMatch.srcTransConnector_74b= srcTransConnector_731;
			currMatch.function_74c= function_73a;
			currMatch.compoundStatement_74d= compoundStatement_743;
			currMatch.transition_74e= currTransition_747;
			currMatch.dstTransConnector_74f= dstTransConnector_748;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetDirectTransitions_710::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_74a, currMatch.transition_74e, currMatch.function_74c, currMatch.compoundStatement_74d);
	}
}

void GetDirectTransitions_710::outputAppender( const CyPhyML::SignalFlow::State& state_750, const CyPhyML::SignalFlow::Transition& transition_752, const SFC::Function& function_754, const SFC::CompoundStatement& compoundStatement_756)
{
	_state_71d->push_back( state_750);
	_transition_71e->push_back( transition_752);
	_function_71f->push_back( function_754);
	_compoundStatement_720->push_back( compoundStatement_756);
}

void GetTransitionsFromStateRefs_758::operator()( const Packets_t& states_759, const Packets_t& tCStates_75d, const Packets_t& functions_75f, const Packets_t& compoundStatements_762, Packets_t& states_75b, Packets_t& transitions_75c, Packets_t& functions_761, Packets_t& compoundStatements_764)
{
#ifdef PRINT_INFO
	printLog( "GetTransitionsFromStateRefs_758" );
#endif
	RTTGenerator::Instance()->generateRule(2403, "GetTransitionsFromStateRefs");
	_state_765= &states_75b;
	_transition_766= &transitions_75c;
	_function_767= &functions_761;
	_compoundStatement_768= &compoundStatements_764;
	processInputPackets( states_759, tCStates_75d, functions_75f, compoundStatements_762);
}

bool GetTransitionsFromStateRefs_758::isInputUnique( const Udm::Object& state_76d, const Udm::Object& tCState_776, const Udm::Object& function_77f, const Udm::Object& compoundStatement_788)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_76f= _state_769.begin(), itTCState_778= _tCState_772.begin(), itFunction_781= _function_77b.begin(), itCompoundStatement_78a= _compoundStatement_784.begin(); itState_76f!= _state_769.end(), itTCState_778!= _tCState_772.end(), itFunction_781!= _function_77b.end(), itCompoundStatement_78a!= _compoundStatement_784.end(); ++itState_76f, ++itTCState_778, ++itFunction_781, ++itCompoundStatement_78a)
	{
		if( ( *itState_76f== state_76d)&& ( *itTCState_778== tCState_776)&& ( *itFunction_781== function_77f)&& ( *itCompoundStatement_78a== compoundStatement_788))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_769.push_back( state_76d);
		_tCState_772.push_back( tCState_776);
		_function_77b.push_back( function_77f);
		_compoundStatement_784.push_back( compoundStatement_788);
	}
	return isUnique;
}

bool GetTransitionsFromStateRefs_758::isGuardTrue( SFC::CompoundStatement& CompoundStatement, CyPhyML::SignalFlow::ConnectorRef& ConnectorRef, CyPhyML::SignalFlow::TransConnector& DstTransConnector, SFC::Function& Function, CyPhyML::SignalFlow::State& RefParentState, CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::State& TCState, CyPhyML::SignalFlow::Transition& Transition)
{
	bool Gz_guard= false;
	return State != RefParentState;;
	return Gz_guard;
}

void GetTransitionsFromStateRefs_758::processInputPackets( const Packets_t& states_759, const Packets_t& tCStates_75d, const Packets_t& functions_75f, const Packets_t& compoundStatements_762)
{
	for( Packets_t::const_iterator itState_76a= states_759.begin(), itTCState_773= tCStates_75d.begin(), itFunction_77c= functions_75f.begin(), itCompoundStatement_785= compoundStatements_762.begin(); itState_76a!= states_759.end(), itTCState_773!= tCStates_75d.end(), itFunction_77c!= functions_75f.end(), itCompoundStatement_785!= compoundStatements_762.end(); ++itState_76a, ++itTCState_773, ++itFunction_77c, ++itCompoundStatement_785)
	{
		bool isUnique= isInputUnique( *itState_76a, *itTCState_773, *itFunction_77c, *itCompoundStatement_785);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_76a, *itTCState_773, *itFunction_77c, *itCompoundStatement_785);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetTransitionsFromStateRefs_758::patternMatcher( const Udm::Object& state_76b, const Udm::Object& tCState_774, const Udm::Object& function_77d, const Udm::Object& compoundStatement_786)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_76b.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_770= CyPhyML::SignalFlow::State::Cast( state_76b);
		if( false== Uml::IsDerivedFrom( tCState_774.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State tCState_779= CyPhyML::SignalFlow::State::Cast( tCState_774);
		if( false== Uml::IsDerivedFrom( function_77d.type(), SFC::Function::meta))
			continue;
		SFC::Function function_782= SFC::Function::Cast( function_77d);
		if( false== Uml::IsDerivedFrom( compoundStatement_786.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_78b= SFC::CompoundStatement::Cast( compoundStatement_786);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_78d= state_770.referedbyConnectorRef();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRefs_78e= connectorRefs_78d.begin(); itConnectorRefs_78e!= connectorRefs_78d.end(); ++itConnectorRefs_78e)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_78f= *itConnectorRefs_78e;
			Udm::Object connectorRefParent_790= currConnectorRef_78f.container();
			if( false== Uml::IsDerivedFrom( connectorRefParent_790.type(), CyPhyML::SignalFlow::State::meta))
				continue;
			CyPhyML::SignalFlow::State refParentStateConnectorRef_791= CyPhyML::SignalFlow::State::Cast( connectorRefParent_790);
			set< CyPhyML::SignalFlow::Transition> transitions_792= currConnectorRef_78f.dstTransition();
			for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransitions_793= transitions_792.begin(); itTransitions_793!= transitions_792.end(); ++itTransitions_793)
			{
				CyPhyML::SignalFlow::Transition currTransition_794= *itTransitions_793;
				CyPhyML::SignalFlow::TransConnector dstTransConnector_795= currTransition_794.dstTransition_end();
				Match currMatch;
				currMatch.state_797= state_770;
				currMatch.tCState_798= tCState_779;
				currMatch.function_799= function_782;
				currMatch.compoundStatement_79a= compoundStatement_78b;
				currMatch.refParentState_79b= refParentStateConnectorRef_791;
				currMatch.transition_79c= currTransition_794;
				currMatch.connectorRef_79d= currConnectorRef_78f;
				currMatch.dstTransConnector_79e= dstTransConnector_795;
				bool Gz_guard= isGuardTrue( currMatch.compoundStatement_79a, currMatch.connectorRef_79d, currMatch.dstTransConnector_79e, currMatch.function_799, currMatch.refParentState_79b, currMatch.state_797, currMatch.tCState_798, currMatch.transition_79c);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetTransitionsFromStateRefs_758::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_797, currMatch.transition_79c, currMatch.function_799, currMatch.compoundStatement_79a);
	}
}

void GetTransitionsFromStateRefs_758::outputAppender( const CyPhyML::SignalFlow::State& state_7a7, const CyPhyML::SignalFlow::Transition& transition_7a9, const SFC::Function& function_7ab, const SFC::CompoundStatement& compoundStatement_7ad)
{
	_state_765->push_back( state_7a7);
	_transition_766->push_back( transition_7a9);
	_function_767->push_back( function_7ab);
	_compoundStatement_768->push_back( compoundStatement_7ad);
}

void CreateTransitionCG_7c8::operator()( const Packets_t& states_7c9, const Packets_t& transConnectors_7cc, const Packets_t& functions_7cf, const Packets_t& tCVarCGs_7d3, Packets_t& states_7cb, Packets_t& transConnectors_7ce, Packets_t& functions_7d1, Packets_t& transitionCGs_7d2)
{
#ifdef PRINT_INFO
	printLog( "CreateTransitionCG_7c8" );
#endif
	RTTGenerator::Instance()->generateRule(2713, "CreateTransitionCG");
	_state_7d5= &states_7cb;
	_transConnector_7d6= &transConnectors_7ce;
	_function_7d7= &functions_7d1;
	_transitionCG_7d8= &transitionCGs_7d2;
	processInputPackets( states_7c9, transConnectors_7cc, functions_7cf, tCVarCGs_7d3);
}

bool CreateTransitionCG_7c8::isInputUnique( const Udm::Object& state_7dd, const Udm::Object& transConnector_7e6, const Udm::Object& function_7ef, const Udm::Object& tCVarCG_7f8)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_7df= _state_7d9.begin(), itTransConnector_7e8= _transConnector_7e2.begin(), itFunction_7f1= _function_7eb.begin(), itTCVarCG_7fa= _tCVarCG_7f4.begin(); itState_7df!= _state_7d9.end(), itTransConnector_7e8!= _transConnector_7e2.end(), itFunction_7f1!= _function_7eb.end(), itTCVarCG_7fa!= _tCVarCG_7f4.end(); ++itState_7df, ++itTransConnector_7e8, ++itFunction_7f1, ++itTCVarCG_7fa)
	{
		if( ( *itState_7df== state_7dd)&& ( *itTransConnector_7e8== transConnector_7e6)&& ( *itFunction_7f1== function_7ef)&& ( *itTCVarCG_7fa== tCVarCG_7f8))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_7d9.push_back( state_7dd);
		_transConnector_7e2.push_back( transConnector_7e6);
		_function_7eb.push_back( function_7ef);
		_tCVarCG_7f4.push_back( tCVarCG_7f8);
	}
	return isUnique;
}

bool CreateTransitionCG_7c8::isGuardTrue( SFC::Function& Function, CyPhyML::SignalFlow::State& State, SFC::LocalVar& TCVar, SFC::ConditionalGroup& TCVarCG, CyPhyML::SignalFlow::TransConnector& TransConnector)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( TCVar.name() ) == "_TCVar_";
	return Gz_guard;
}

void CreateTransitionCG_7c8::processInputPackets( const Packets_t& states_7c9, const Packets_t& transConnectors_7cc, const Packets_t& functions_7cf, const Packets_t& tCVarCGs_7d3)
{
	for( Packets_t::const_iterator itState_7da= states_7c9.begin(), itTransConnector_7e3= transConnectors_7cc.begin(), itFunction_7ec= functions_7cf.begin(), itTCVarCG_7f5= tCVarCGs_7d3.begin(); itState_7da!= states_7c9.end(), itTransConnector_7e3!= transConnectors_7cc.end(), itFunction_7ec!= functions_7cf.end(), itTCVarCG_7f5!= tCVarCGs_7d3.end(); ++itState_7da, ++itTransConnector_7e3, ++itFunction_7ec, ++itTCVarCG_7f5)
	{
		bool isUnique= isInputUnique( *itState_7da, *itTransConnector_7e3, *itFunction_7ec, *itTCVarCG_7f5);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_7da, *itTransConnector_7e3, *itFunction_7ec, *itTCVarCG_7f5);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateTransitionCG_7c8::patternMatcher( const Udm::Object& state_7db, const Udm::Object& transConnector_7e4, const Udm::Object& function_7ed, const Udm::Object& tCVarCG_7f6)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_7db.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_7e0= CyPhyML::SignalFlow::State::Cast( state_7db);
		if( false== Uml::IsDerivedFrom( transConnector_7e4.type(), CyPhyML::SignalFlow::TransConnector::meta))
			continue;
		CyPhyML::SignalFlow::TransConnector transConnector_7e9= CyPhyML::SignalFlow::TransConnector::Cast( transConnector_7e4);
		if( false== Uml::IsDerivedFrom( function_7ed.type(), SFC::Function::meta))
			continue;
		SFC::Function function_7f2= SFC::Function::Cast( function_7ed);
		if( false== Uml::IsDerivedFrom( tCVarCG_7f6.type(), SFC::ConditionalGroup::meta))
			continue;
		SFC::ConditionalGroup tCVarCG_7fb= SFC::ConditionalGroup::Cast( tCVarCG_7f6);
		set< SFC::LocalVar> tCVars_7fd= function_7f2.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itTCVar_7fe= tCVars_7fd.begin(); itTCVar_7fe!= tCVars_7fd.end(); ++itTCVar_7fe)
		{
			SFC::LocalVar currTCVar_7ff= *itTCVar_7fe;
			Match currMatch;
			currMatch.state_801= state_7e0;
			currMatch.transConnector_802= transConnector_7e9;
			currMatch.function_803= function_7f2;
			currMatch.tCVarCG_804= tCVarCG_7fb;
			currMatch.tCVar_805= currTCVar_7ff;
			bool Gz_guard= isGuardTrue( currMatch.function_803, currMatch.state_801, currMatch.tCVar_805, currMatch.tCVarCG_804, currMatch.transConnector_802);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateTransitionCG_7c8::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newTCVarCB_80b= SFC::ConditionalBlock::Create( currMatch.tCVarCG_804, SFC::ConditionalGroup::meta_stmnt);
		SFC::UserCode newTCVarTest_80c= SFC::UserCode::Create( newTCVarCB_80b, SFC::ConditionalBlock::meta_cond);
		SFC::BinaryExprs newEquals_80d= SFC::BinaryExprs::Create( newTCVarTest_80c, SFC::UserCode::meta_codeexpr);
		SFC::Int newInt_80e= SFC::Int::Create( newEquals_80d, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef_80f= SFC::ArgDeclRef::Create( newEquals_80d, SFC::BinaryExprs::meta_leftexpr);
		SFC::ConditionalGroup newTransitionCG_810= SFC::ConditionalGroup::Create( newTCVarCB_80b, SFC::ConditionalBlock::meta_stmnt);
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_80f;
		SFC::BinaryExprs& Equals= newEquals_80d;
		SFC::Function& Function= currMatch.function_803;
		SFC::Int& Int= newInt_80e;
		CyPhyML::SignalFlow::State& State= currMatch.state_801;
		SFC::LocalVar& TCVar= currMatch.tCVar_805;
		SFC::ConditionalBlock& TCVarCB= newTCVarCB_80b;
		SFC::ConditionalGroup& TCVarCG= currMatch.tCVarCG_804;
		SFC::UserCode& TCVarTest= newTCVarTest_80c;
		CyPhyML::SignalFlow::TransConnector& TransConnector= currMatch.transConnector_802;
		SFC::ConditionalGroup& TransitionCG= newTransitionCG_810;
		{
TCVarCB.RefId() = TCVarTest.RefId() = TransitionCG.RefId() = TransConnector.RefId();
};
		{
__int64 statementCount = TCVarCG.statementCount();
TCVarCB.statementIndex() = statementCount++;
TCVarCG.statementCount() = statementCount;
};
		{
Equals.op() = "==";
};
		{
__int64 statementCount = TCVarCB.statementCount();
TransitionCG.statementIndex() = statementCount++;
TCVarCB.statementCount() = statementCount;
};
		{
Int.val() = SFManager::StateTransConnectorMap::get_singleton().getTransConnectorMap( State ).getTransConnectorNumber( TransConnector );
};
		{
SFManager::StateTransConnectorMap::get_singleton().getTransConnectorMap( State ).setIsTransConnectorProcessed( TransConnector, true );
};
		newArgDeclRef_80f.argdecl()= currMatch.tCVar_805;
		outputAppender( currMatch.state_801, currMatch.transConnector_802, currMatch.function_803, newTransitionCG_810);
	}
}

void CreateTransitionCG_7c8::outputAppender( const CyPhyML::SignalFlow::State& state_811, const CyPhyML::SignalFlow::TransConnector& transConnector_813, const SFC::Function& function_815, const SFC::ConditionalGroup& transitionCG_817)
{
	_state_7d5->push_back( state_811);
	_transConnector_7d6->push_back( transConnector_813);
	_function_7d7->push_back( function_815);
	_transitionCG_7d8->push_back( transitionCG_817);
}

void ProcessedFilter_819::operator()( const Packets_t& states_81a, const Packets_t& tcs_81c, const Packets_t& fcns_81e, const Packets_t& cgs_820, Packets_t& states_822, Packets_t& tcs_823, Packets_t& fcns_824, Packets_t& cgs_825)
{
#ifdef PRINT_INFO
	printLog( "ProcessedFilter_819" );
#endif
	_state_826= &states_822;
	_tc_827= &tcs_823;
	_fcn_828= &fcns_824;
	_cg_829= &cgs_825;
	for( Packets_t::const_iterator itstate_82b= states_81a.begin(), ittc_832= tcs_81c.begin(), itfcn_839= fcns_81e.begin(), itcg_840= cgs_820.begin(); itstate_82b!= states_81a.end(), ittc_832!= tcs_81c.end(), itfcn_839!= fcns_81e.end(), itcg_840!= cgs_820.end(); ++itstate_82b, ++ittc_832, ++itfcn_839, ++itcg_840)
	{
		bool isUnique= isInputUnique( *itstate_82b, *ittc_832, *itfcn_839, *itcg_840);
		if( !isUnique)
			continue;
		Packets_t onestate_82f( 1, *itstate_82b);
		Packets_t onetc_836( 1, *ittc_832);
		Packets_t onefcn_83d( 1, *itfcn_839);
		Packets_t onecg_844( 1, *itcg_840);
		executeOne( onestate_82f, onetc_836, onefcn_83d, onecg_844);
	}
}

void ProcessedFilter_819::executeOne( const Packets_t& states_81a, const Packets_t& tcs_81c, const Packets_t& fcns_81e, const Packets_t& cgs_820)
{
	Packets_t states_849;
	Packets_t transConnectors_84c;
	Packets_t functions_84f;
	Packets_t conditionalGroups_852;
	TCNotProcessed_846 tCNotProcessed_846;
	bool isMatchTCNotProcessed_846= tCNotProcessed_846( states_81a, tcs_81c, fcns_81e, cgs_820, states_849, transConnectors_84c, functions_84f, conditionalGroups_852);
	_state_826->insert( _state_826->end(), states_849.begin(), states_849.end());
	_tc_827->insert( _tc_827->end(), transConnectors_84c.begin(), transConnectors_84c.end());
	_fcn_828->insert( _fcn_828->end(), functions_84f.begin(), functions_84f.end());
	_cg_829->insert( _cg_829->end(), conditionalGroups_852.begin(), conditionalGroups_852.end());
	if( isMatchTCNotProcessed_846)
		return;
}

bool ProcessedFilter_819::isInputUnique( const Udm::Object& state_82c, const Udm::Object& tc_833, const Udm::Object& fcn_83a, const Udm::Object& cg_841)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_82e= _state_82a.begin(), ittc_835= _tc_831.begin(), itfcn_83c= _fcn_838.begin(), itcg_843= _cg_83f.begin(); itstate_82e!= _state_82a.end(), ittc_835!= _tc_831.end(), itfcn_83c!= _fcn_838.end(), itcg_843!= _cg_83f.end(); ++itstate_82e, ++ittc_835, ++itfcn_83c, ++itcg_843)
	{
		if( ( *itstate_82e== state_82c)&& ( *ittc_835== tc_833)&& ( *itfcn_83c== fcn_83a)&& ( *itcg_843== cg_841))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_82a.push_back( state_82c);
		_tc_831.push_back( tc_833);
		_fcn_838.push_back( fcn_83a);
		_cg_83f.push_back( cg_841);
	}
	return isUnique;
}

bool TCNotProcessed_846::operator()( const Packets_t& states_847, const Packets_t& transConnectors_84a, const Packets_t& functions_84d, const Packets_t& conditionalGroups_850, Packets_t& states_849, Packets_t& transConnectors_84c, Packets_t& functions_84f, Packets_t& conditionalGroups_852)
{
#ifdef PRINT_INFO
	printLog( "TCNotProcessed_846" );
#endif
	_state_853= &states_849;
	_transConnector_854= &transConnectors_84c;
	_function_855= &functions_84f;
	_conditionalGroup_856= &conditionalGroups_852;
	processInputPackets( states_847, transConnectors_84a, functions_84d, conditionalGroups_850);
	if( false== _matches.empty())
		return true;
	return false;
}

bool TCNotProcessed_846::isInputUnique( const Udm::Object& state_85b, const Udm::Object& transConnector_864, const Udm::Object& function_86d, const Udm::Object& conditionalGroup_876)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_85d= _state_857.begin(), itTransConnector_866= _transConnector_860.begin(), itFunction_86f= _function_869.begin(), itConditionalGroup_878= _conditionalGroup_872.begin(); itState_85d!= _state_857.end(), itTransConnector_866!= _transConnector_860.end(), itFunction_86f!= _function_869.end(), itConditionalGroup_878!= _conditionalGroup_872.end(); ++itState_85d, ++itTransConnector_866, ++itFunction_86f, ++itConditionalGroup_878)
	{
		if( ( *itState_85d== state_85b)&& ( *itTransConnector_866== transConnector_864)&& ( *itFunction_86f== function_86d)&& ( *itConditionalGroup_878== conditionalGroup_876))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_857.push_back( state_85b);
		_transConnector_860.push_back( transConnector_864);
		_function_869.push_back( function_86d);
		_conditionalGroup_872.push_back( conditionalGroup_876);
	}
	return isUnique;
}

bool TCNotProcessed_846::isGuardTrue( SFC::ConditionalGroup& ConditionalGroup, SFC::Function& Function, CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::TransConnector& TransConnector)
{
	bool Gz_guard= false;
	return !SFManager::StateTransConnectorMap::get_singleton().getTransConnectorMap( State ).getIsTransConnectorProcessed( TransConnector );;
	return Gz_guard;
}

void TCNotProcessed_846::processInputPackets( const Packets_t& states_847, const Packets_t& transConnectors_84a, const Packets_t& functions_84d, const Packets_t& conditionalGroups_850)
{
	for( Packets_t::const_iterator itState_858= states_847.begin(), itTransConnector_861= transConnectors_84a.begin(), itFunction_86a= functions_84d.begin(), itConditionalGroup_873= conditionalGroups_850.begin(); itState_858!= states_847.end(), itTransConnector_861!= transConnectors_84a.end(), itFunction_86a!= functions_84d.end(), itConditionalGroup_873!= conditionalGroups_850.end(); ++itState_858, ++itTransConnector_861, ++itFunction_86a, ++itConditionalGroup_873)
	{
		bool isUnique= isInputUnique( *itState_858, *itTransConnector_861, *itFunction_86a, *itConditionalGroup_873);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_858, *itTransConnector_861, *itFunction_86a, *itConditionalGroup_873);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_87c, currMatch.transConnector_87d, currMatch.function_87e, currMatch.conditionalGroup_87f);
	}
}

bool TCNotProcessed_846::patternMatcher( const Udm::Object& state_859, const Udm::Object& transConnector_862, const Udm::Object& function_86b, const Udm::Object& conditionalGroup_874)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_859.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_85e= CyPhyML::SignalFlow::State::Cast( state_859);
		if( false== Uml::IsDerivedFrom( transConnector_862.type(), CyPhyML::SignalFlow::TransConnector::meta))
			continue;
		CyPhyML::SignalFlow::TransConnector transConnector_867= CyPhyML::SignalFlow::TransConnector::Cast( transConnector_862);
		if( false== Uml::IsDerivedFrom( function_86b.type(), SFC::Function::meta))
			continue;
		SFC::Function function_870= SFC::Function::Cast( function_86b);
		if( false== Uml::IsDerivedFrom( conditionalGroup_874.type(), SFC::ConditionalGroup::meta))
			continue;
		SFC::ConditionalGroup conditionalGroup_879= SFC::ConditionalGroup::Cast( conditionalGroup_874);
		Match currMatch;
		currMatch.state_87c= state_85e;
		currMatch.transConnector_87d= transConnector_867;
		currMatch.function_87e= function_870;
		currMatch.conditionalGroup_87f= conditionalGroup_879;
		bool Gz_guard= isGuardTrue( currMatch.conditionalGroup_87f, currMatch.function_87e, currMatch.state_87c, currMatch.transConnector_87d);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void TCNotProcessed_846::outputAppender( const CyPhyML::SignalFlow::State& state_884, const CyPhyML::SignalFlow::TransConnector& transConnector_886, const SFC::Function& function_888, const SFC::ConditionalGroup& conditionalGroup_88a)
{
	_state_853->push_back( state_884);
	_transConnector_854->push_back( transConnector_886);
	_function_855->push_back( function_888);
	_conditionalGroup_856->push_back( conditionalGroup_88a);
}

void NoDefaultTransition_88c::operator()( const Packets_t& states_88d, const Packets_t& tcs_88f, const Packets_t& fcns_891, const Packets_t& css_893)
{
#ifdef PRINT_INFO
	printLog( "NoDefaultTransition_88c" );
#endif
	if( ( !states_88d.empty())&& ( !tcs_88f.empty())&& ( !fcns_891.empty())&& ( !css_893.empty()))
		callNDTTest_9dc( states_88d, tcs_88f, fcns_891, css_893);
}

void NoDefaultTransition_88c::callNDTTest_9dc( const Packets_t& states_8db, const Packets_t& tcs_8dd, const Packets_t& fcns_8df, const Packets_t& css_8e1)
{
	Packets_t states_8e3;
	Packets_t tcs_8e4;
	Packets_t fcns_8e5;
	Packets_t css_8e6;
	NDTTest_8da nDTTest_8da;
	nDTTest_8da( states_8db, tcs_8dd, fcns_8df, css_8e1, states_8e3, tcs_8e4, fcns_8e5, css_8e6);
	if( ( !states_8e3.empty())&& ( !tcs_8e4.empty())&& ( !fcns_8e5.empty())&& ( !css_8e6.empty()))
		callExitLoop_9e1( states_8e3, tcs_8e4, fcns_8e5, css_8e6);
}

void NoDefaultTransition_88c::callExitLoop_9e1( const Packets_t& states_896, const Packets_t& srcTransConnectors_898, const Packets_t& functions_89a, const Packets_t& compoundStatements_89c)
{
	ExitLoop_895 exitLoop_895;
	exitLoop_895( states_896, srcTransConnectors_898, functions_89a, compoundStatements_89c);
}

void ExitLoop_895::operator()( const Packets_t& states_896, const Packets_t& srcTransConnectors_898, const Packets_t& functions_89a, const Packets_t& compoundStatements_89c)
{
#ifdef PRINT_INFO
	printLog( "ExitLoop_895" );
#endif
	RTTGenerator::Instance()->generateRule(2744, "ExitLoop");
	processInputPackets( states_896, srcTransConnectors_898, functions_89a, compoundStatements_89c);
}

bool ExitLoop_895::isInputUnique( const Udm::Object& state_8a2, const Udm::Object& srcTransConnector_8ab, const Udm::Object& function_8b4, const Udm::Object& compoundStatement_8bd)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_8a4= _state_89e.begin(), itSrcTransConnector_8ad= _srcTransConnector_8a7.begin(), itFunction_8b6= _function_8b0.begin(), itCompoundStatement_8bf= _compoundStatement_8b9.begin(); itState_8a4!= _state_89e.end(), itSrcTransConnector_8ad!= _srcTransConnector_8a7.end(), itFunction_8b6!= _function_8b0.end(), itCompoundStatement_8bf!= _compoundStatement_8b9.end(); ++itState_8a4, ++itSrcTransConnector_8ad, ++itFunction_8b6, ++itCompoundStatement_8bf)
	{
		if( ( *itState_8a4== state_8a2)&& ( *itSrcTransConnector_8ad== srcTransConnector_8ab)&& ( *itFunction_8b6== function_8b4)&& ( *itCompoundStatement_8bf== compoundStatement_8bd))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_89e.push_back( state_8a2);
		_srcTransConnector_8a7.push_back( srcTransConnector_8ab);
		_function_8b0.push_back( function_8b4);
		_compoundStatement_8b9.push_back( compoundStatement_8bd);
	}
	return isUnique;
}

bool ExitLoop_895::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool ExitLoop_895::isGuardTrue( SFC::CompoundStatement& CompoundStatement, SFC::Function& Function, CyPhyML::SignalFlow::TransConnector& SrcTransConnector, CyPhyML::SignalFlow::State& State, SFC::LocalVar& TCVar)
{
	bool Gz_guard= false;
	return static_cast< std::string >( TCVar.name() ) == "_TCVar_";;
	return Gz_guard;
}

void ExitLoop_895::processInputPackets( const Packets_t& states_896, const Packets_t& srcTransConnectors_898, const Packets_t& functions_89a, const Packets_t& compoundStatements_89c)
{
	for( Packets_t::const_iterator itState_89f= states_896.begin(), itSrcTransConnector_8a8= srcTransConnectors_898.begin(), itFunction_8b1= functions_89a.begin(), itCompoundStatement_8ba= compoundStatements_89c.begin(); itState_89f!= states_896.end(), itSrcTransConnector_8a8!= srcTransConnectors_898.end(), itFunction_8b1!= functions_89a.end(), itCompoundStatement_8ba!= compoundStatements_89c.end(); ++itState_89f, ++itSrcTransConnector_8a8, ++itFunction_8b1, ++itCompoundStatement_8ba)
	{
		bool isUnique= isInputUnique( *itState_89f, *itSrcTransConnector_8a8, *itFunction_8b1, *itCompoundStatement_8ba);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_89f, *itSrcTransConnector_8a8, *itFunction_8b1, *itCompoundStatement_8ba);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ExitLoop_895::patternMatcher( const Udm::Object& state_8a0, const Udm::Object& srcTransConnector_8a9, const Udm::Object& function_8b2, const Udm::Object& compoundStatement_8bb)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_8a0.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_8a5= CyPhyML::SignalFlow::State::Cast( state_8a0);
		if( false== Uml::IsDerivedFrom( srcTransConnector_8a9.type(), CyPhyML::SignalFlow::TransConnector::meta))
			continue;
		CyPhyML::SignalFlow::TransConnector srcTransConnector_8ae= CyPhyML::SignalFlow::TransConnector::Cast( srcTransConnector_8a9);
		if( false== Uml::IsDerivedFrom( function_8b2.type(), SFC::Function::meta))
			continue;
		SFC::Function function_8b7= SFC::Function::Cast( function_8b2);
		if( false== Uml::IsDerivedFrom( compoundStatement_8bb.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_8c0= SFC::CompoundStatement::Cast( compoundStatement_8bb);
		set< SFC::LocalVar> tCVars_8c2= function_8b7.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itTCVar_8c3= tCVars_8c2.begin(); itTCVar_8c3!= tCVars_8c2.end(); ++itTCVar_8c3)
		{
			SFC::LocalVar currTCVar_8c4= *itTCVar_8c3;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_8c8;
			if( !isValidBound(boundObjs_8c8, state_8a5, true))
				continue;
			currMatch.state_8c9= state_8a5;
			if( !isValidBound(boundObjs_8c8, srcTransConnector_8ae, true))
				continue;
			currMatch.srcTransConnector_8ca= srcTransConnector_8ae;
			if( !isValidBound(boundObjs_8c8, function_8b7, true))
				continue;
			currMatch.function_8cb= function_8b7;
			if( !isValidBound(boundObjs_8c8, compoundStatement_8c0, true))
				continue;
			currMatch.compoundStatement_8cc= compoundStatement_8c0;
			if( !isValidBound(boundObjs_8c8, currTCVar_8c4, false))
				continue;
			currMatch.tCVar_8cd= currTCVar_8c4;
			bool Gz_guard= isGuardTrue( currMatch.compoundStatement_8cc, currMatch.function_8cb, currMatch.srcTransConnector_8ca, currMatch.state_8c9, currMatch.tCVar_8cd);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void ExitLoop_895::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_8d3= SFC::ConditionalBlock::Create( currMatch.compoundStatement_8cc, SFC::CompoundStatement::meta_stmnt);
		SFC::UserCode newUserCode_8d4= SFC::UserCode::Create( newConditionalBlock_8d3, SFC::ConditionalBlock::meta_stmnt);
		SFC::BinaryExprs newAssign_8d5= SFC::BinaryExprs::Create( newUserCode_8d4, SFC::UserCode::meta_codeexpr);
		SFC::ArgDeclRef newArgDeclRef_8d6= SFC::ArgDeclRef::Create( newAssign_8d5, SFC::BinaryExprs::meta_leftexpr);
		SFC::Int newNegOne_8d7= SFC::Int::Create( newAssign_8d5, SFC::BinaryExprs::meta_rightexpr);
		SFC::UserCode newTrueCond_8d8= SFC::UserCode::Create( newConditionalBlock_8d3, SFC::ConditionalBlock::meta_cond);
		SFC::Int newOne_8d9= SFC::Int::Create( newTrueCond_8d8, SFC::UserCode::meta_codeexpr);
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_8d6;
		SFC::BinaryExprs& Assign= newAssign_8d5;
		SFC::CompoundStatement& CompoundStatement= currMatch.compoundStatement_8cc;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_8d3;
		SFC::Function& Function= currMatch.function_8cb;
		SFC::Int& NegOne= newNegOne_8d7;
		SFC::Int& One= newOne_8d9;
		CyPhyML::SignalFlow::TransConnector& SrcTransConnector= currMatch.srcTransConnector_8ca;
		CyPhyML::SignalFlow::State& State= currMatch.state_8c9;
		SFC::LocalVar& TCVar= currMatch.tCVar_8cd;
		SFC::UserCode& TrueCond= newTrueCond_8d8;
		SFC::UserCode& UserCode= newUserCode_8d4;
		{
ConditionalBlock.RefId() = UserCode.RefId() = SrcTransConnector.RefId();
};
		{
Assign.op() = "=";
};
		{
__int64 statementCount = ConditionalBlock.statementCount();
UserCode.statementIndex() = statementCount++;
ConditionalBlock.statementCount() = statementCount;
};
		{
__int64 statementCount = CompoundStatement.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
CompoundStatement.statementCount() = statementCount;
};
		{
One.val() = 1;
};
		{
NegOne.val() = -1;
};
		newArgDeclRef_8d6.argdecl()= currMatch.tCVar_8cd;
	}
}

void NDTTest_8da::operator()( const Packets_t& states_8db, const Packets_t& tcs_8dd, const Packets_t& fcns_8df, const Packets_t& css_8e1, Packets_t& states_8e3, Packets_t& tcs_8e4, Packets_t& fcns_8e5, Packets_t& css_8e6)
{
#ifdef PRINT_INFO
	printLog( "NDTTest_8da" );
#endif
	_state_8e7= &states_8e3;
	_tc_8e8= &tcs_8e4;
	_fcn_8e9= &fcns_8e5;
	_cs_8ea= &css_8e6;
	for( Packets_t::const_iterator itstate_8ec= states_8db.begin(), ittc_8f3= tcs_8dd.begin(), itfcn_8fa= fcns_8df.begin(), itcs_901= css_8e1.begin(); itstate_8ec!= states_8db.end(), ittc_8f3!= tcs_8dd.end(), itfcn_8fa!= fcns_8df.end(), itcs_901!= css_8e1.end(); ++itstate_8ec, ++ittc_8f3, ++itfcn_8fa, ++itcs_901)
	{
		bool isUnique= isInputUnique( *itstate_8ec, *ittc_8f3, *itfcn_8fa, *itcs_901);
		if( !isUnique)
			continue;
		Packets_t onestate_8f0( 1, *itstate_8ec);
		Packets_t onetc_8f7( 1, *ittc_8f3);
		Packets_t onefcn_8fe( 1, *itfcn_8fa);
		Packets_t onecs_905( 1, *itcs_901);
		executeOne( onestate_8f0, onetc_8f7, onefcn_8fe, onecs_905);
	}
}

void NDTTest_8da::executeOne( const Packets_t& states_8db, const Packets_t& tcs_8dd, const Packets_t& fcns_8df, const Packets_t& css_8e1)
{
	HasDefaultTransitionDouble_907 hasDefaultTransitionDouble_907;
	bool isMatchHasDefaultTransitionDouble_907= hasDefaultTransitionDouble_907( states_8db, tcs_8dd, fcns_8df, css_8e1);
	if( isMatchHasDefaultTransitionDouble_907)
		return;
	HasDefaultTransitionInt_94f hasDefaultTransitionInt_94f;
	bool isMatchHasDefaultTransitionInt_94f= hasDefaultTransitionInt_94f( states_8db, tcs_8dd, fcns_8df, css_8e1);
	if( isMatchHasDefaultTransitionInt_94f)
		return;
	Packets_t states_99a;
	Packets_t transConnectors_99d;
	Packets_t functions_9a0;
	Packets_t compoundStatements_9a3;
	NoDefault_997 noDefault_997;
	bool isMatchNoDefault_997= noDefault_997( states_8db, tcs_8dd, fcns_8df, css_8e1, states_99a, transConnectors_99d, functions_9a0, compoundStatements_9a3);
	_state_8e7->insert( _state_8e7->end(), states_99a.begin(), states_99a.end());
	_tc_8e8->insert( _tc_8e8->end(), transConnectors_99d.begin(), transConnectors_99d.end());
	_fcn_8e9->insert( _fcn_8e9->end(), functions_9a0.begin(), functions_9a0.end());
	_cs_8ea->insert( _cs_8ea->end(), compoundStatements_9a3.begin(), compoundStatements_9a3.end());
	if( isMatchNoDefault_997)
		return;
}

bool NDTTest_8da::isInputUnique( const Udm::Object& state_8ed, const Udm::Object& tc_8f4, const Udm::Object& fcn_8fb, const Udm::Object& cs_902)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_8ef= _state_8eb.begin(), ittc_8f6= _tc_8f2.begin(), itfcn_8fd= _fcn_8f9.begin(), itcs_904= _cs_900.begin(); itstate_8ef!= _state_8eb.end(), ittc_8f6!= _tc_8f2.end(), itfcn_8fd!= _fcn_8f9.end(), itcs_904!= _cs_900.end(); ++itstate_8ef, ++ittc_8f6, ++itfcn_8fd, ++itcs_904)
	{
		if( ( *itstate_8ef== state_8ed)&& ( *ittc_8f6== tc_8f4)&& ( *itfcn_8fd== fcn_8fb)&& ( *itcs_904== cs_902))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_8eb.push_back( state_8ed);
		_tc_8f2.push_back( tc_8f4);
		_fcn_8f9.push_back( fcn_8fb);
		_cs_900.push_back( cs_902);
	}
	return isUnique;
}

bool HasDefaultTransitionDouble_907::operator()( const Packets_t& states_908, const Packets_t& srcTransConnectors_90a, const Packets_t& functions_90c, const Packets_t& compoundStatements_90e)
{
#ifdef PRINT_INFO
	printLog( "HasDefaultTransitionDouble_907" );
#endif
	processInputPackets( states_908, srcTransConnectors_90a, functions_90c, compoundStatements_90e);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasDefaultTransitionDouble_907::isInputUnique( const Udm::Object& state_914, const Udm::Object& srcTransConnector_91d, const Udm::Object& function_926, const Udm::Object& compoundStatement_92f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_916= _state_910.begin(), itSrcTransConnector_91f= _srcTransConnector_919.begin(), itFunction_928= _function_922.begin(), itCompoundStatement_931= _compoundStatement_92b.begin(); itState_916!= _state_910.end(), itSrcTransConnector_91f!= _srcTransConnector_919.end(), itFunction_928!= _function_922.end(), itCompoundStatement_931!= _compoundStatement_92b.end(); ++itState_916, ++itSrcTransConnector_91f, ++itFunction_928, ++itCompoundStatement_931)
	{
		if( ( *itState_916== state_914)&& ( *itSrcTransConnector_91f== srcTransConnector_91d)&& ( *itFunction_928== function_926)&& ( *itCompoundStatement_931== compoundStatement_92f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_910.push_back( state_914);
		_srcTransConnector_919.push_back( srcTransConnector_91d);
		_function_922.push_back( function_926);
		_compoundStatement_92b.push_back( compoundStatement_92f);
	}
	return isUnique;
}

bool HasDefaultTransitionDouble_907::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool HasDefaultTransitionDouble_907::isGuardTrue( SFC::CompoundStatement& CompoundStatement, SFC::ConditionalBlock& ConditionalBlock, SFC::Double& Double, SFC::Function& Function, CyPhyML::SignalFlow::TransConnector& SrcTransConnector, CyPhyML::SignalFlow::State& State, SFC::UserCode& UserCode)
{
	bool Gz_guard= false;
	return Double.val() == 1;;
	return Gz_guard;
}

void HasDefaultTransitionDouble_907::processInputPackets( const Packets_t& states_908, const Packets_t& srcTransConnectors_90a, const Packets_t& functions_90c, const Packets_t& compoundStatements_90e)
{
	for( Packets_t::const_iterator itState_911= states_908.begin(), itSrcTransConnector_91a= srcTransConnectors_90a.begin(), itFunction_923= functions_90c.begin(), itCompoundStatement_92c= compoundStatements_90e.begin(); itState_911!= states_908.end(), itSrcTransConnector_91a!= srcTransConnectors_90a.end(), itFunction_923!= functions_90c.end(), itCompoundStatement_92c!= compoundStatements_90e.end(); ++itState_911, ++itSrcTransConnector_91a, ++itFunction_923, ++itCompoundStatement_92c)
	{
		bool isUnique= isInputUnique( *itState_911, *itSrcTransConnector_91a, *itFunction_923, *itCompoundStatement_92c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_911, *itSrcTransConnector_91a, *itFunction_923, *itCompoundStatement_92c);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( );
	}
}

bool HasDefaultTransitionDouble_907::patternMatcher( const Udm::Object& state_912, const Udm::Object& srcTransConnector_91b, const Udm::Object& function_924, const Udm::Object& compoundStatement_92d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_912.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_917= CyPhyML::SignalFlow::State::Cast( state_912);
		if( false== Uml::IsDerivedFrom( srcTransConnector_91b.type(), CyPhyML::SignalFlow::TransConnector::meta))
			continue;
		CyPhyML::SignalFlow::TransConnector srcTransConnector_920= CyPhyML::SignalFlow::TransConnector::Cast( srcTransConnector_91b);
		if( false== Uml::IsDerivedFrom( function_924.type(), SFC::Function::meta))
			continue;
		SFC::Function function_929= SFC::Function::Cast( function_924);
		if( false== Uml::IsDerivedFrom( compoundStatement_92d.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_932= SFC::CompoundStatement::Cast( compoundStatement_92d);
		set< SFC::ConditionalBlock> conditionalBlocks_934= compoundStatement_932.ConditionalBlock_kind_children();
		for( set< SFC::ConditionalBlock>::const_iterator itConditionalBlock_935= conditionalBlocks_934.begin(); itConditionalBlock_935!= conditionalBlocks_934.end(); ++itConditionalBlock_935)
		{
			SFC::ConditionalBlock currConditionalBlock_936= *itConditionalBlock_935;
			set< SFC::UserCode> userCodes_937= currConditionalBlock_936.UserCode_kind_children();
			for( set< SFC::UserCode>::const_iterator itUserCode_938= userCodes_937.begin(); itUserCode_938!= userCodes_937.end(); ++itUserCode_938)
			{
				SFC::UserCode currUserCode_939= *itUserCode_938;
				set< SFC::Double> doubles_93a= currUserCode_939.Double_kind_children();
				for( set< SFC::Double>::const_iterator itDouble_93b= doubles_93a.begin(); itDouble_93b!= doubles_93a.end(); ++itDouble_93b)
				{
					SFC::Double currDouble_93c= *itDouble_93b;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_940;
					if( !isValidBound(boundObjs_940, state_917, true))
						continue;
					currMatch.state_941= state_917;
					if( !isValidBound(boundObjs_940, srcTransConnector_920, true))
						continue;
					currMatch.srcTransConnector_942= srcTransConnector_920;
					if( !isValidBound(boundObjs_940, function_929, true))
						continue;
					currMatch.function_943= function_929;
					if( !isValidBound(boundObjs_940, compoundStatement_932, true))
						continue;
					currMatch.compoundStatement_944= compoundStatement_932;
					if( !isValidBound(boundObjs_940, currUserCode_939, false))
						continue;
					currMatch.userCode_945= currUserCode_939;
					if( !isValidBound(boundObjs_940, currDouble_93c, false))
						continue;
					currMatch.double_946= currDouble_93c;
					if( !isValidBound(boundObjs_940, currConditionalBlock_936, false))
						continue;
					currMatch.conditionalBlock_947= currConditionalBlock_936;
					bool Gz_guard= isGuardTrue( currMatch.compoundStatement_944, currMatch.conditionalBlock_947, currMatch.double_946, currMatch.function_943, currMatch.srcTransConnector_942, currMatch.state_941, currMatch.userCode_945);
					if( true== Gz_guard)
						_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void HasDefaultTransitionDouble_907::outputAppender()
{
}

bool HasDefaultTransitionInt_94f::operator()( const Packets_t& states_950, const Packets_t& srcTransConnectors_952, const Packets_t& functions_954, const Packets_t& compoundStatements_956)
{
#ifdef PRINT_INFO
	printLog( "HasDefaultTransitionInt_94f" );
#endif
	processInputPackets( states_950, srcTransConnectors_952, functions_954, compoundStatements_956);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasDefaultTransitionInt_94f::isInputUnique( const Udm::Object& state_95c, const Udm::Object& srcTransConnector_965, const Udm::Object& function_96e, const Udm::Object& compoundStatement_977)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_95e= _state_958.begin(), itSrcTransConnector_967= _srcTransConnector_961.begin(), itFunction_970= _function_96a.begin(), itCompoundStatement_979= _compoundStatement_973.begin(); itState_95e!= _state_958.end(), itSrcTransConnector_967!= _srcTransConnector_961.end(), itFunction_970!= _function_96a.end(), itCompoundStatement_979!= _compoundStatement_973.end(); ++itState_95e, ++itSrcTransConnector_967, ++itFunction_970, ++itCompoundStatement_979)
	{
		if( ( *itState_95e== state_95c)&& ( *itSrcTransConnector_967== srcTransConnector_965)&& ( *itFunction_970== function_96e)&& ( *itCompoundStatement_979== compoundStatement_977))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_958.push_back( state_95c);
		_srcTransConnector_961.push_back( srcTransConnector_965);
		_function_96a.push_back( function_96e);
		_compoundStatement_973.push_back( compoundStatement_977);
	}
	return isUnique;
}

bool HasDefaultTransitionInt_94f::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool HasDefaultTransitionInt_94f::isGuardTrue( SFC::CompoundStatement& CompoundStatement, SFC::ConditionalBlock& ConditionalBlock, SFC::Function& Function, SFC::Int& Int, CyPhyML::SignalFlow::TransConnector& SrcTransConnector, CyPhyML::SignalFlow::State& State, SFC::UserCode& UserCode)
{
	bool Gz_guard= false;
	return Int.val() == 1;;
	return Gz_guard;
}

void HasDefaultTransitionInt_94f::processInputPackets( const Packets_t& states_950, const Packets_t& srcTransConnectors_952, const Packets_t& functions_954, const Packets_t& compoundStatements_956)
{
	for( Packets_t::const_iterator itState_959= states_950.begin(), itSrcTransConnector_962= srcTransConnectors_952.begin(), itFunction_96b= functions_954.begin(), itCompoundStatement_974= compoundStatements_956.begin(); itState_959!= states_950.end(), itSrcTransConnector_962!= srcTransConnectors_952.end(), itFunction_96b!= functions_954.end(), itCompoundStatement_974!= compoundStatements_956.end(); ++itState_959, ++itSrcTransConnector_962, ++itFunction_96b, ++itCompoundStatement_974)
	{
		bool isUnique= isInputUnique( *itState_959, *itSrcTransConnector_962, *itFunction_96b, *itCompoundStatement_974);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_959, *itSrcTransConnector_962, *itFunction_96b, *itCompoundStatement_974);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( );
	}
}

bool HasDefaultTransitionInt_94f::patternMatcher( const Udm::Object& state_95a, const Udm::Object& srcTransConnector_963, const Udm::Object& function_96c, const Udm::Object& compoundStatement_975)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_95a.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_95f= CyPhyML::SignalFlow::State::Cast( state_95a);
		if( false== Uml::IsDerivedFrom( srcTransConnector_963.type(), CyPhyML::SignalFlow::TransConnector::meta))
			continue;
		CyPhyML::SignalFlow::TransConnector srcTransConnector_968= CyPhyML::SignalFlow::TransConnector::Cast( srcTransConnector_963);
		if( false== Uml::IsDerivedFrom( function_96c.type(), SFC::Function::meta))
			continue;
		SFC::Function function_971= SFC::Function::Cast( function_96c);
		if( false== Uml::IsDerivedFrom( compoundStatement_975.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_97a= SFC::CompoundStatement::Cast( compoundStatement_975);
		set< SFC::ConditionalBlock> conditionalBlocks_97c= compoundStatement_97a.ConditionalBlock_kind_children();
		for( set< SFC::ConditionalBlock>::const_iterator itConditionalBlock_97d= conditionalBlocks_97c.begin(); itConditionalBlock_97d!= conditionalBlocks_97c.end(); ++itConditionalBlock_97d)
		{
			SFC::ConditionalBlock currConditionalBlock_97e= *itConditionalBlock_97d;
			set< SFC::UserCode> userCodes_97f= currConditionalBlock_97e.UserCode_kind_children();
			for( set< SFC::UserCode>::const_iterator itUserCode_980= userCodes_97f.begin(); itUserCode_980!= userCodes_97f.end(); ++itUserCode_980)
			{
				SFC::UserCode currUserCode_981= *itUserCode_980;
				set< SFC::Int> ints_982= currUserCode_981.Int_kind_children();
				for( set< SFC::Int>::const_iterator itInt_983= ints_982.begin(); itInt_983!= ints_982.end(); ++itInt_983)
				{
					SFC::Int currInt_984= *itInt_983;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_988;
					if( !isValidBound(boundObjs_988, state_95f, true))
						continue;
					currMatch.state_989= state_95f;
					if( !isValidBound(boundObjs_988, srcTransConnector_968, true))
						continue;
					currMatch.srcTransConnector_98a= srcTransConnector_968;
					if( !isValidBound(boundObjs_988, function_971, true))
						continue;
					currMatch.function_98b= function_971;
					if( !isValidBound(boundObjs_988, compoundStatement_97a, true))
						continue;
					currMatch.compoundStatement_98c= compoundStatement_97a;
					if( !isValidBound(boundObjs_988, currUserCode_981, false))
						continue;
					currMatch.userCode_98d= currUserCode_981;
					if( !isValidBound(boundObjs_988, currInt_984, false))
						continue;
					currMatch.int_98e= currInt_984;
					if( !isValidBound(boundObjs_988, currConditionalBlock_97e, false))
						continue;
					currMatch.conditionalBlock_98f= currConditionalBlock_97e;
					bool Gz_guard= isGuardTrue( currMatch.compoundStatement_98c, currMatch.conditionalBlock_98f, currMatch.function_98b, currMatch.int_98e, currMatch.srcTransConnector_98a, currMatch.state_989, currMatch.userCode_98d);
					if( true== Gz_guard)
						_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void HasDefaultTransitionInt_94f::outputAppender()
{
}

bool NoDefault_997::operator()( const Packets_t& states_998, const Packets_t& transConnectors_99b, const Packets_t& functions_99e, const Packets_t& compoundStatements_9a1, Packets_t& states_99a, Packets_t& transConnectors_99d, Packets_t& functions_9a0, Packets_t& compoundStatements_9a3)
{
#ifdef PRINT_INFO
	printLog( "NoDefault_997" );
#endif
	_state_9a4= &states_99a;
	_transConnector_9a5= &transConnectors_99d;
	_function_9a6= &functions_9a0;
	_compoundStatement_9a7= &compoundStatements_9a3;
	processInputPackets( states_998, transConnectors_99b, functions_99e, compoundStatements_9a1);
	if( false== _matches.empty())
		return true;
	return false;
}

bool NoDefault_997::isInputUnique( const Udm::Object& state_9ac, const Udm::Object& transConnector_9b5, const Udm::Object& function_9be, const Udm::Object& compoundStatement_9c7)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_9ae= _state_9a8.begin(), itTransConnector_9b7= _transConnector_9b1.begin(), itFunction_9c0= _function_9ba.begin(), itCompoundStatement_9c9= _compoundStatement_9c3.begin(); itState_9ae!= _state_9a8.end(), itTransConnector_9b7!= _transConnector_9b1.end(), itFunction_9c0!= _function_9ba.end(), itCompoundStatement_9c9!= _compoundStatement_9c3.end(); ++itState_9ae, ++itTransConnector_9b7, ++itFunction_9c0, ++itCompoundStatement_9c9)
	{
		if( ( *itState_9ae== state_9ac)&& ( *itTransConnector_9b7== transConnector_9b5)&& ( *itFunction_9c0== function_9be)&& ( *itCompoundStatement_9c9== compoundStatement_9c7))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_9a8.push_back( state_9ac);
		_transConnector_9b1.push_back( transConnector_9b5);
		_function_9ba.push_back( function_9be);
		_compoundStatement_9c3.push_back( compoundStatement_9c7);
	}
	return isUnique;
}

bool NoDefault_997::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void NoDefault_997::processInputPackets( const Packets_t& states_998, const Packets_t& transConnectors_99b, const Packets_t& functions_99e, const Packets_t& compoundStatements_9a1)
{
	for( Packets_t::const_iterator itState_9a9= states_998.begin(), itTransConnector_9b2= transConnectors_99b.begin(), itFunction_9bb= functions_99e.begin(), itCompoundStatement_9c4= compoundStatements_9a1.begin(); itState_9a9!= states_998.end(), itTransConnector_9b2!= transConnectors_99b.end(), itFunction_9bb!= functions_99e.end(), itCompoundStatement_9c4!= compoundStatements_9a1.end(); ++itState_9a9, ++itTransConnector_9b2, ++itFunction_9bb, ++itCompoundStatement_9c4)
	{
		bool isUnique= isInputUnique( *itState_9a9, *itTransConnector_9b2, *itFunction_9bb, *itCompoundStatement_9c4);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_9a9, *itTransConnector_9b2, *itFunction_9bb, *itCompoundStatement_9c4);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_9d0, currMatch.transConnector_9d1, currMatch.function_9d2, currMatch.compoundStatement_9d3);
	}
}

bool NoDefault_997::patternMatcher( const Udm::Object& state_9aa, const Udm::Object& transConnector_9b3, const Udm::Object& function_9bc, const Udm::Object& compoundStatement_9c5)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_9aa.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_9af= CyPhyML::SignalFlow::State::Cast( state_9aa);
		if( false== Uml::IsDerivedFrom( transConnector_9b3.type(), CyPhyML::SignalFlow::TransConnector::meta))
			continue;
		CyPhyML::SignalFlow::TransConnector transConnector_9b8= CyPhyML::SignalFlow::TransConnector::Cast( transConnector_9b3);
		if( false== Uml::IsDerivedFrom( function_9bc.type(), SFC::Function::meta))
			continue;
		SFC::Function function_9c1= SFC::Function::Cast( function_9bc);
		if( false== Uml::IsDerivedFrom( compoundStatement_9c5.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_9ca= SFC::CompoundStatement::Cast( compoundStatement_9c5);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_9cf;
		if( !isValidBound(boundObjs_9cf, state_9af, true))
			continue;
		currMatch.state_9d0= state_9af;
		if( !isValidBound(boundObjs_9cf, transConnector_9b8, true))
			continue;
		currMatch.transConnector_9d1= transConnector_9b8;
		if( !isValidBound(boundObjs_9cf, function_9c1, true))
			continue;
		currMatch.function_9d2= function_9c1;
		if( !isValidBound(boundObjs_9cf, compoundStatement_9ca, true))
			continue;
		currMatch.compoundStatement_9d3= compoundStatement_9ca;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void NoDefault_997::outputAppender( const CyPhyML::SignalFlow::State& state_9d4, const CyPhyML::SignalFlow::TransConnector& transConnector_9d6, const SFC::Function& function_9d8, const SFC::CompoundStatement& compoundStatement_9da)
{
	_state_9a4->push_back( state_9d4);
	_transConnector_9a5->push_back( transConnector_9d6);
	_function_9a6->push_back( function_9d8);
	_compoundStatement_9a7->push_back( compoundStatement_9da);
}

void TransStartMap_a07::operator()( const Packets_t& states_a08, const Packets_t& css_a0a, Packets_t& states_a0c, Packets_t& css_a0d)
{
#ifdef PRINT_INFO
	printLog( "TransStartMap_a07" );
#endif
	_state_a0e= &states_a0c;
	_cs_a0f= &css_a0d;
	_state_a0e->insert( _state_a0e->end(), states_a08.begin(), states_a08.end());
	_cs_a0f->insert( _cs_a0f->end(), css_a0a.begin(), css_a0a.end());
	if( ( !states_a08.empty()))
		callInitTransConnectorMap_c1c( states_a08);
}

void TransStartMap_a07::callInitTransConnectorMap_c1c( const Packets_t& states_a11)
{
	Packets_t states_a13;
	Packets_t transStarts_a14;
	InitTransConnectorMap_a10 initTransConnectorMap_a10;
	initTransConnectorMap_a10( states_a11, states_a13, transStarts_a14);
	if( ( !states_a13.empty())&& ( !transStarts_a14.empty()))
		callTransConnectorMapRecurse_c1e( states_a13, transStarts_a14);
}

void TransStartMap_a07::callTransConnectorMapRecurse_c1e( const Packets_t& states_a2b, const Packets_t& tcs_a2d)
{
	TransConnectorMapRecurse_a2a transConnectorMapRecurse_a2a;
	transConnectorMapRecurse_a2a( states_a2b, tcs_a2d);
}

void InitTransConnectorMap_a10::operator()( const Packets_t& states_a11, Packets_t& states_a13, Packets_t& transStarts_a14)
{
#ifdef PRINT_INFO
	printLog( "InitTransConnectorMap_a10" );
#endif
	RTTGenerator::Instance()->generateRule(701, "InitTransConnectorMap");
	_state_a15= &states_a13;
	_transStart_a16= &transStarts_a14;
	processInputPackets( states_a11);
}

bool InitTransConnectorMap_a10::isInputUnique( const Udm::Object& state_a1b)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_a1d= _state_a17.begin(); itState_a1d!= _state_a17.end(); ++itState_a1d)
	{
		if( ( *itState_a1d== state_a1b))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_a17.push_back( state_a1b);
	return isUnique;
}

void InitTransConnectorMap_a10::processInputPackets( const Packets_t& states_a11)
{
	for( Packets_t::const_iterator itState_a18= states_a11.begin(); itState_a18!= states_a11.end(); ++itState_a18)
	{
		bool isUnique= isInputUnique( *itState_a18);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_a18);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitTransConnectorMap_a10::patternMatcher( const Udm::Object& state_a19)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_a19.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_a1e= CyPhyML::SignalFlow::State::Cast( state_a19);
		set< CyPhyML::SignalFlow::TransStart> transStarts_a20= state_a1e.TransStart_kind_children();
		for( set< CyPhyML::SignalFlow::TransStart>::const_iterator itTransStart_a21= transStarts_a20.begin(); itTransStart_a21!= transStarts_a20.end(); ++itTransStart_a21)
		{
			CyPhyML::SignalFlow::TransStart currTransStart_a22= *itTransStart_a21;
			Match currMatch;
			currMatch.state_a24= state_a1e;
			currMatch.transStart_a25= currTransStart_a22;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void InitTransConnectorMap_a10::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		CyPhyML::SignalFlow::State& State= currMatch.state_a24;
		CyPhyML::SignalFlow::TransStart& TransStart= currMatch.transStart_a25;
		{
SFManager::StateTransConnectorMap::get_singleton().clearState( State );
};
		outputAppender( currMatch.state_a24, currMatch.transStart_a25);
	}
}

void InitTransConnectorMap_a10::outputAppender( const CyPhyML::SignalFlow::State& state_a26, const CyPhyML::SignalFlow::TransStart& transStart_a28)
{
	_state_a15->push_back( state_a26);
	_transStart_a16->push_back( transStart_a28);
}

void TransConnectorMapRecurse_a2a::operator()( const Packets_t& states_a2b, const Packets_t& tcs_a2d)
{
#ifdef PRINT_INFO
	printLog( "TransConnectorMapRecurse_a2a" );
#endif
	for( Packets_t::const_iterator itstate_a30= states_a2b.begin(), ittc_a37= tcs_a2d.begin(); itstate_a30!= states_a2b.end(), ittc_a37!= tcs_a2d.end(); ++itstate_a30, ++ittc_a37)
	{
		bool isUnique= isInputUnique( *itstate_a30, *ittc_a37);
		if( !isUnique)
			continue;
		Packets_t onestate_a34( 1, *itstate_a30);
		Packets_t onetc_a3b( 1, *ittc_a37);
		executeOne( onestate_a34, onetc_a3b);
	}
}

void TransConnectorMapRecurse_a2a::executeOne( const Packets_t& states_a2b, const Packets_t& tcs_a2d)
{
	if( ( !states_a2b.empty())&& ( !tcs_a2d.empty()))
		callProcessedFilter_c10( states_a2b, tcs_a2d);
}

bool TransConnectorMapRecurse_a2a::isInputUnique( const Udm::Object& state_a31, const Udm::Object& tc_a38)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_a33= _state_a2f.begin(), ittc_a3a= _tc_a36.begin(); itstate_a33!= _state_a2f.end(), ittc_a3a!= _tc_a36.end(); ++itstate_a33, ++ittc_a3a)
	{
		if( ( *itstate_a33== state_a31)&& ( *ittc_a3a== tc_a38))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_a2f.push_back( state_a31);
		_tc_a36.push_back( tc_a38);
	}
	return isUnique;
}

void TransConnectorMapRecurse_a2a::callProcessedFilter_c10( const Packets_t& states_bd6, const Packets_t& tcs_bd8)
{
	Packets_t states_bda;
	Packets_t tcs_bdb;
	ProcessedFilter_bd5 processedFilter_bd5;
	processedFilter_bd5( states_bd6, tcs_bd8, states_bda, tcs_bdb);
	if( ( !states_bda.empty())&& ( !tcs_bdb.empty()))
		callAddTransConnector_c13( states_bda, tcs_bdb);
}

void TransConnectorMapRecurse_a2a::callAddTransConnector_c13( const Packets_t& states_ad9, const Packets_t& transConnectors_adc)
{
	Packets_t states_adb;
	Packets_t transConnectors_ade;
	AddTransConnector_ad8 addTransConnector_ad8;
	addTransConnector_ad8( states_ad9, transConnectors_adc, states_adb, transConnectors_ade);
	if( ( !states_adb.empty())&& ( !transConnectors_ade.empty()))
		callGetAllTransitions_c16( states_adb, transConnectors_ade);
}

void TransConnectorMapRecurse_a2a::callGetAllTransitions_c16( const Packets_t& states_a3e, const Packets_t& tcs_a40)
{
	Packets_t states_a42;
	Packets_t transs_a43;
	GetAllTransitions_a3d getAllTransitions_a3d;
	getAllTransitions_a3d( states_a3e, tcs_a40, states_a42, transs_a43);
	if( ( !states_a42.empty())&& ( !transs_a43.empty()))
		callProcessTransitionsMap_c19( states_a42, transs_a43);
}

void TransConnectorMapRecurse_a2a::callProcessTransitionsMap_c19( const Packets_t& states_af7, const Packets_t& transs_af9)
{
	ProcessTransitionsMap_af6 processTransitionsMap_af6;
	processTransitionsMap_af6( states_af7, transs_af9);
}

void GetAllTransitions_a3d::operator()( const Packets_t& states_a3e, const Packets_t& tcs_a40, Packets_t& states_a42, Packets_t& transs_a43)
{
#ifdef PRINT_INFO
	printLog( "GetAllTransitions_a3d" );
#endif
	_state_a44= &states_a42;
	_trans_a45= &transs_a43;
	if( ( !states_a3e.empty())&& ( !tcs_a40.empty()))
		callGetTransitionsFromJunctionRefs_acf( states_a3e, tcs_a40);
	if( ( !states_a3e.empty())&& ( !tcs_a40.empty()))
		callGetDirectTransitions_ad2( states_a3e, tcs_a40);
	if( ( !states_a3e.empty())&& ( !tcs_a40.empty()))
		callGetTransitionsFromStateRefs_ad5( states_a3e, tcs_a40);
}

void GetAllTransitions_a3d::callGetTransitionsFromJunctionRefs_acf( const Packets_t& states_aa4, const Packets_t& junctions_aa8)
{
	Packets_t states_aa6;
	Packets_t transitions_aa7;
	GetTransitionsFromJunctionRefs_aa3 getTransitionsFromJunctionRefs_aa3;
	getTransitionsFromJunctionRefs_aa3( states_aa4, junctions_aa8, states_aa6, transitions_aa7);
	_state_a44->insert( _state_a44->end(), states_aa6.begin(), states_aa6.end());
	_trans_a45->insert( _trans_a45->end(), transitions_aa7.begin(), transitions_aa7.end());
}

void GetAllTransitions_a3d::callGetDirectTransitions_ad2( const Packets_t& states_a7c, const Packets_t& srcTransConnectors_a7f)
{
	Packets_t states_a7e;
	Packets_t transitions_a81;
	GetDirectTransitions_a7b getDirectTransitions_a7b;
	getDirectTransitions_a7b( states_a7c, srcTransConnectors_a7f, states_a7e, transitions_a81);
	_state_a44->insert( _state_a44->end(), states_a7e.begin(), states_a7e.end());
	_trans_a45->insert( _trans_a45->end(), transitions_a81.begin(), transitions_a81.end());
}

void GetAllTransitions_a3d::callGetTransitionsFromStateRefs_ad5( const Packets_t& states_a47, const Packets_t& tCStates_a4b)
{
	Packets_t states_a49;
	Packets_t transitions_a4a;
	GetTransitionsFromStateRefs_a46 getTransitionsFromStateRefs_a46;
	getTransitionsFromStateRefs_a46( states_a47, tCStates_a4b, states_a49, transitions_a4a);
	_state_a44->insert( _state_a44->end(), states_a49.begin(), states_a49.end());
	_trans_a45->insert( _trans_a45->end(), transitions_a4a.begin(), transitions_a4a.end());
}

void GetTransitionsFromStateRefs_a46::operator()( const Packets_t& states_a47, const Packets_t& tCStates_a4b, Packets_t& states_a49, Packets_t& transitions_a4a)
{
#ifdef PRINT_INFO
	printLog( "GetTransitionsFromStateRefs_a46" );
#endif
	RTTGenerator::Instance()->generateRule(2290, "GetTransitionsFromStateRefs");
	_state_a4d= &states_a49;
	_transition_a4e= &transitions_a4a;
	processInputPackets( states_a47, tCStates_a4b);
}

bool GetTransitionsFromStateRefs_a46::isInputUnique( const Udm::Object& state_a53, const Udm::Object& tCState_a5c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_a55= _state_a4f.begin(), itTCState_a5e= _tCState_a58.begin(); itState_a55!= _state_a4f.end(), itTCState_a5e!= _tCState_a58.end(); ++itState_a55, ++itTCState_a5e)
	{
		if( ( *itState_a55== state_a53)&& ( *itTCState_a5e== tCState_a5c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_a4f.push_back( state_a53);
		_tCState_a58.push_back( tCState_a5c);
	}
	return isUnique;
}

bool GetTransitionsFromStateRefs_a46::isGuardTrue( CyPhyML::SignalFlow::ConnectorRef& ConnectorRef, CyPhyML::SignalFlow::TransConnector& DstTransConnector, CyPhyML::SignalFlow::State& RefParentState, CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::State& TCState, CyPhyML::SignalFlow::Transition& Transition)
{
	bool Gz_guard= false;
	return State != RefParentState;;
	return Gz_guard;
}

void GetTransitionsFromStateRefs_a46::processInputPackets( const Packets_t& states_a47, const Packets_t& tCStates_a4b)
{
	for( Packets_t::const_iterator itState_a50= states_a47.begin(), itTCState_a59= tCStates_a4b.begin(); itState_a50!= states_a47.end(), itTCState_a59!= tCStates_a4b.end(); ++itState_a50, ++itTCState_a59)
	{
		bool isUnique= isInputUnique( *itState_a50, *itTCState_a59);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_a50, *itTCState_a59);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetTransitionsFromStateRefs_a46::patternMatcher( const Udm::Object& state_a51, const Udm::Object& tCState_a5a)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_a51.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_a56= CyPhyML::SignalFlow::State::Cast( state_a51);
		if( false== Uml::IsDerivedFrom( tCState_a5a.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State tCState_a5f= CyPhyML::SignalFlow::State::Cast( tCState_a5a);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_a61= state_a56.referedbyConnectorRef();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRefs_a62= connectorRefs_a61.begin(); itConnectorRefs_a62!= connectorRefs_a61.end(); ++itConnectorRefs_a62)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_a63= *itConnectorRefs_a62;
			Udm::Object connectorRefParent_a64= currConnectorRef_a63.container();
			if( false== Uml::IsDerivedFrom( connectorRefParent_a64.type(), CyPhyML::SignalFlow::State::meta))
				continue;
			CyPhyML::SignalFlow::State refParentStateConnectorRef_a65= CyPhyML::SignalFlow::State::Cast( connectorRefParent_a64);
			set< CyPhyML::SignalFlow::Transition> transitions_a66= currConnectorRef_a63.dstTransition();
			for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransitions_a67= transitions_a66.begin(); itTransitions_a67!= transitions_a66.end(); ++itTransitions_a67)
			{
				CyPhyML::SignalFlow::Transition currTransition_a68= *itTransitions_a67;
				CyPhyML::SignalFlow::TransConnector dstTransConnector_a69= currTransition_a68.dstTransition_end();
				Match currMatch;
				currMatch.state_a6b= state_a56;
				currMatch.tCState_a6c= tCState_a5f;
				currMatch.refParentState_a6d= refParentStateConnectorRef_a65;
				currMatch.transition_a6e= currTransition_a68;
				currMatch.connectorRef_a6f= currConnectorRef_a63;
				currMatch.dstTransConnector_a70= dstTransConnector_a69;
				bool Gz_guard= isGuardTrue( currMatch.connectorRef_a6f, currMatch.dstTransConnector_a70, currMatch.refParentState_a6d, currMatch.state_a6b, currMatch.tCState_a6c, currMatch.transition_a6e);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetTransitionsFromStateRefs_a46::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_a6b, currMatch.transition_a6e);
	}
}

void GetTransitionsFromStateRefs_a46::outputAppender( const CyPhyML::SignalFlow::State& state_a77, const CyPhyML::SignalFlow::Transition& transition_a79)
{
	_state_a4d->push_back( state_a77);
	_transition_a4e->push_back( transition_a79);
}

void GetDirectTransitions_a7b::operator()( const Packets_t& states_a7c, const Packets_t& srcTransConnectors_a7f, Packets_t& states_a7e, Packets_t& transitions_a81)
{
#ifdef PRINT_INFO
	printLog( "GetDirectTransitions_a7b" );
#endif
	RTTGenerator::Instance()->generateRule(2301, "GetDirectTransitions");
	_state_a82= &states_a7e;
	_transition_a83= &transitions_a81;
	processInputPackets( states_a7c, srcTransConnectors_a7f);
}

bool GetDirectTransitions_a7b::isInputUnique( const Udm::Object& state_a88, const Udm::Object& srcTransConnector_a91)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_a8a= _state_a84.begin(), itSrcTransConnector_a93= _srcTransConnector_a8d.begin(); itState_a8a!= _state_a84.end(), itSrcTransConnector_a93!= _srcTransConnector_a8d.end(); ++itState_a8a, ++itSrcTransConnector_a93)
	{
		if( ( *itState_a8a== state_a88)&& ( *itSrcTransConnector_a93== srcTransConnector_a91))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_a84.push_back( state_a88);
		_srcTransConnector_a8d.push_back( srcTransConnector_a91);
	}
	return isUnique;
}

void GetDirectTransitions_a7b::processInputPackets( const Packets_t& states_a7c, const Packets_t& srcTransConnectors_a7f)
{
	for( Packets_t::const_iterator itState_a85= states_a7c.begin(), itSrcTransConnector_a8e= srcTransConnectors_a7f.begin(); itState_a85!= states_a7c.end(), itSrcTransConnector_a8e!= srcTransConnectors_a7f.end(); ++itState_a85, ++itSrcTransConnector_a8e)
	{
		bool isUnique= isInputUnique( *itState_a85, *itSrcTransConnector_a8e);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_a85, *itSrcTransConnector_a8e);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetDirectTransitions_a7b::patternMatcher( const Udm::Object& state_a86, const Udm::Object& srcTransConnector_a8f)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_a86.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_a8b= CyPhyML::SignalFlow::State::Cast( state_a86);
		if( false== Uml::IsDerivedFrom( srcTransConnector_a8f.type(), CyPhyML::SignalFlow::TransConnector::meta))
			continue;
		CyPhyML::SignalFlow::TransConnector srcTransConnector_a94= CyPhyML::SignalFlow::TransConnector::Cast( srcTransConnector_a8f);
		set< CyPhyML::SignalFlow::Transition> transitions_a96= srcTransConnector_a94.dstTransition();
		for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransitions_a97= transitions_a96.begin(); itTransitions_a97!= transitions_a96.end(); ++itTransitions_a97)
		{
			CyPhyML::SignalFlow::Transition currTransition_a98= *itTransitions_a97;
			CyPhyML::SignalFlow::TransConnector dstTransConnector_a99= currTransition_a98.dstTransition_end();
			Match currMatch;
			currMatch.state_a9b= state_a8b;
			currMatch.srcTransConnector_a9c= srcTransConnector_a94;
			currMatch.transition_a9d= currTransition_a98;
			currMatch.dstTransConnector_a9e= dstTransConnector_a99;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetDirectTransitions_a7b::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_a9b, currMatch.transition_a9d);
	}
}

void GetDirectTransitions_a7b::outputAppender( const CyPhyML::SignalFlow::State& state_a9f, const CyPhyML::SignalFlow::Transition& transition_aa1)
{
	_state_a82->push_back( state_a9f);
	_transition_a83->push_back( transition_aa1);
}

void GetTransitionsFromJunctionRefs_aa3::operator()( const Packets_t& states_aa4, const Packets_t& junctions_aa8, Packets_t& states_aa6, Packets_t& transitions_aa7)
{
#ifdef PRINT_INFO
	printLog( "GetTransitionsFromJunctionRefs_aa3" );
#endif
	RTTGenerator::Instance()->generateRule(2308, "GetTransitionsFromJunctionRefs");
	_state_aaa= &states_aa6;
	_transition_aab= &transitions_aa7;
	processInputPackets( states_aa4, junctions_aa8);
}

bool GetTransitionsFromJunctionRefs_aa3::isInputUnique( const Udm::Object& state_ab0, const Udm::Object& junction_ab9)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_ab2= _state_aac.begin(), itJunction_abb= _junction_ab5.begin(); itState_ab2!= _state_aac.end(), itJunction_abb!= _junction_ab5.end(); ++itState_ab2, ++itJunction_abb)
	{
		if( ( *itState_ab2== state_ab0)&& ( *itJunction_abb== junction_ab9))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_aac.push_back( state_ab0);
		_junction_ab5.push_back( junction_ab9);
	}
	return isUnique;
}

void GetTransitionsFromJunctionRefs_aa3::processInputPackets( const Packets_t& states_aa4, const Packets_t& junctions_aa8)
{
	for( Packets_t::const_iterator itState_aad= states_aa4.begin(), itJunction_ab6= junctions_aa8.begin(); itState_aad!= states_aa4.end(), itJunction_ab6!= junctions_aa8.end(); ++itState_aad, ++itJunction_ab6)
	{
		bool isUnique= isInputUnique( *itState_aad, *itJunction_ab6);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_aad, *itJunction_ab6);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetTransitionsFromJunctionRefs_aa3::patternMatcher( const Udm::Object& state_aae, const Udm::Object& junction_ab7)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_aae.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_ab3= CyPhyML::SignalFlow::State::Cast( state_aae);
		if( false== Uml::IsDerivedFrom( junction_ab7.type(), CyPhyML::SignalFlow::SF_Junction::meta))
			continue;
		CyPhyML::SignalFlow::SF_Junction junction_abc= CyPhyML::SignalFlow::SF_Junction::Cast( junction_ab7);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_abe= junction_abc.referedbyConnectorRef();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRefs_abf= connectorRefs_abe.begin(); itConnectorRefs_abf!= connectorRefs_abe.end(); ++itConnectorRefs_abf)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_ac0= *itConnectorRefs_abf;
			set< CyPhyML::SignalFlow::Transition> transitions_ac1= currConnectorRef_ac0.dstTransition();
			for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransitions_ac2= transitions_ac1.begin(); itTransitions_ac2!= transitions_ac1.end(); ++itTransitions_ac2)
			{
				CyPhyML::SignalFlow::Transition currTransition_ac3= *itTransitions_ac2;
				CyPhyML::SignalFlow::TransConnector dstTransConnector_ac4= currTransition_ac3.dstTransition_end();
				Match currMatch;
				currMatch.state_ac6= state_ab3;
				currMatch.junction_ac7= junction_abc;
				currMatch.transition_ac8= currTransition_ac3;
				currMatch.connectorRef_ac9= currConnectorRef_ac0;
				currMatch.dstTransConnector_aca= dstTransConnector_ac4;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetTransitionsFromJunctionRefs_aa3::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_ac6, currMatch.transition_ac8);
	}
}

void GetTransitionsFromJunctionRefs_aa3::outputAppender( const CyPhyML::SignalFlow::State& state_acb, const CyPhyML::SignalFlow::Transition& transition_acd)
{
	_state_aaa->push_back( state_acb);
	_transition_aab->push_back( transition_acd);
}

void AddTransConnector_ad8::operator()( const Packets_t& states_ad9, const Packets_t& transConnectors_adc, Packets_t& states_adb, Packets_t& transConnectors_ade)
{
#ifdef PRINT_INFO
	printLog( "AddTransConnector_ad8" );
#endif
	RTTGenerator::Instance()->generateRule(2317, "AddTransConnector");
	_state_adf= &states_adb;
	_transConnector_ae0= &transConnectors_ade;
	processInputPackets( states_ad9, transConnectors_adc);
	forwardInputs( );
}

bool AddTransConnector_ad8::isInputUnique( const Udm::Object& state_ae5, const Udm::Object& transConnector_aee)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_ae7= _state_ae1.begin(), itTransConnector_af0= _transConnector_aea.begin(); itState_ae7!= _state_ae1.end(), itTransConnector_af0!= _transConnector_aea.end(); ++itState_ae7, ++itTransConnector_af0)
	{
		if( ( *itState_ae7== state_ae5)&& ( *itTransConnector_af0== transConnector_aee))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_ae1.push_back( state_ae5);
		_transConnector_aea.push_back( transConnector_aee);
	}
	return isUnique;
}

void AddTransConnector_ad8::processInputPackets( const Packets_t& states_ad9, const Packets_t& transConnectors_adc)
{
	for( Packets_t::const_iterator itState_ae2= states_ad9.begin(), itTransConnector_aeb= transConnectors_adc.begin(); itState_ae2!= states_ad9.end(), itTransConnector_aeb!= transConnectors_adc.end(); ++itState_ae2, ++itTransConnector_aeb)
	{
		bool isUnique= isInputUnique( *itState_ae2, *itTransConnector_aeb);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_ae2, *itTransConnector_aeb);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool AddTransConnector_ad8::patternMatcher( const Udm::Object& state_ae3, const Udm::Object& transConnector_aec)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_ae3.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_ae8= CyPhyML::SignalFlow::State::Cast( state_ae3);
		if( false== Uml::IsDerivedFrom( transConnector_aec.type(), CyPhyML::SignalFlow::TransConnector::meta))
			continue;
		CyPhyML::SignalFlow::TransConnector transConnector_af1= CyPhyML::SignalFlow::TransConnector::Cast( transConnector_aec);
		Match currMatch;
		currMatch.state_af4= state_ae8;
		currMatch.transConnector_af5= transConnector_af1;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void AddTransConnector_ad8::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		CyPhyML::SignalFlow::State& State= currMatch.state_af4;
		CyPhyML::SignalFlow::TransConnector& TransConnector= currMatch.transConnector_af5;
		{
SFManager::StateTransConnectorMap::get_singleton().getTransConnectorMap( State ).addTransConnector( TransConnector );
};
	}
}

void AddTransConnector_ad8::forwardInputs()
{
	*_state_adf= _state_ae1;
	*_transConnector_ae0= _transConnector_aea;
}

void ProcessTransitionsMap_af6::operator()( const Packets_t& states_af7, const Packets_t& transs_af9)
{
#ifdef PRINT_INFO
	printLog( "ProcessTransitionsMap_af6" );
#endif
	if( ( !states_af7.empty())&& ( !transs_af9.empty()))
		callOrderTransitions_bc6( states_af7, transs_af9);
}

void ProcessTransitionsMap_af6::callOrderTransitions_bc6( const Packets_t& states_b7f, const Packets_t& transitions_b82)
{
	Packets_t states_b81;
	Packets_t transitions_b84;
	OrderTransitions_b7e orderTransitions_b7e;
	orderTransitions_b7e( states_b7f, transitions_b82, states_b81, transitions_b84);
	if( ( !states_b81.empty())&& ( !transitions_b84.empty()))
		callgetDstTransConnectors_bc9( states_b81, transitions_b84);
}

void ProcessTransitionsMap_af6::callgetDstTransConnectors_bc9( const Packets_t& states_ba1, const Packets_t& transitions_ba5)
{
	Packets_t states_ba3;
	Packets_t dstTransConnectors_ba4;
	GetDstTransConnectors_ba0 getDstTransConnectors_ba0;
	getDstTransConnectors_ba0( states_ba1, transitions_ba5, states_ba3, dstTransConnectors_ba4);
	if( ( !states_ba3.empty())&& ( !dstTransConnectors_ba4.empty()))
		callTransConnTest_bcc( states_ba3, dstTransConnectors_ba4);
}

void ProcessTransitionsMap_af6::callTransConnTest_bcc( const Packets_t& states_b20, const Packets_t& tcs_b22)
{
	Packets_t states_b24;
	Packets_t tcs_b25;
	Packets_t states_b26;
	Packets_t tcs_b27;
	TransConnTest_b1f transConnTest_b1f;
	transConnTest_b1f( states_b20, tcs_b22, states_b24, tcs_b25, states_b26, tcs_b27);
	if( ( !states_b26.empty())&& ( !tcs_b27.empty()))
		callTransConnectorMapRecurse_bcf( states_b26, tcs_b27);
	if( ( !states_b24.empty())&& ( !tcs_b25.empty()))
		callDerefConnRef_bd2( states_b24, tcs_b25);
}

void ProcessTransitionsMap_af6::callTransConnectorMapRecurse_bcf( const Packets_t& states_a2b, const Packets_t& tcs_a2d)
{
	TransConnectorMapRecurse_a2a transConnectorMapRecurse_a2a;
	transConnectorMapRecurse_a2a( states_a2b, tcs_a2d);
}

void ProcessTransitionsMap_af6::callDerefConnRef_bd2( const Packets_t& states_afc, const Packets_t& connectorRefs_aff)
{
	Packets_t states_afe;
	Packets_t transConnectors_b01;
	DerefConnRef_afb derefConnRef_afb;
	derefConnRef_afb( states_afc, connectorRefs_aff, states_afe, transConnectors_b01);
	if( ( !states_afe.empty())&& ( !transConnectors_b01.empty()))
		callTransConnTest_bcc( states_afe, transConnectors_b01);
}

void DerefConnRef_afb::operator()( const Packets_t& states_afc, const Packets_t& connectorRefs_aff, Packets_t& states_afe, Packets_t& transConnectors_b01)
{
#ifdef PRINT_INFO
	printLog( "DerefConnRef_afb" );
#endif
	RTTGenerator::Instance()->generateRule(2324, "DerefConnRef");
	_state_b02= &states_afe;
	_transConnector_b03= &transConnectors_b01;
	processInputPackets( states_afc, connectorRefs_aff);
}

bool DerefConnRef_afb::isInputUnique( const Udm::Object& state_b08, const Udm::Object& connectorRef_b11)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_b0a= _state_b04.begin(), itConnectorRef_b13= _connectorRef_b0d.begin(); itState_b0a!= _state_b04.end(), itConnectorRef_b13!= _connectorRef_b0d.end(); ++itState_b0a, ++itConnectorRef_b13)
	{
		if( ( *itState_b0a== state_b08)&& ( *itConnectorRef_b13== connectorRef_b11))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_b04.push_back( state_b08);
		_connectorRef_b0d.push_back( connectorRef_b11);
	}
	return isUnique;
}

void DerefConnRef_afb::processInputPackets( const Packets_t& states_afc, const Packets_t& connectorRefs_aff)
{
	for( Packets_t::const_iterator itState_b05= states_afc.begin(), itConnectorRef_b0e= connectorRefs_aff.begin(); itState_b05!= states_afc.end(), itConnectorRef_b0e!= connectorRefs_aff.end(); ++itState_b05, ++itConnectorRef_b0e)
	{
		bool isUnique= isInputUnique( *itState_b05, *itConnectorRef_b0e);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_b05, *itConnectorRef_b0e);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool DerefConnRef_afb::patternMatcher( const Udm::Object& state_b06, const Udm::Object& connectorRef_b0f)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_b06.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_b0b= CyPhyML::SignalFlow::State::Cast( state_b06);
		if( false== Uml::IsDerivedFrom( connectorRef_b0f.type(), CyPhyML::SignalFlow::ConnectorRef::meta))
			continue;
		CyPhyML::SignalFlow::ConnectorRef connectorRef_b14= CyPhyML::SignalFlow::ConnectorRef::Cast( connectorRef_b0f);
		CyPhyML::SignalFlow::TransConnector transConnector_b16= connectorRef_b14.ref();
		if( !transConnector_b16)
			continue;
		Match currMatch;
		currMatch.state_b18= state_b0b;
		currMatch.connectorRef_b19= connectorRef_b14;
		currMatch.transConnector_b1a= transConnector_b16;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void DerefConnRef_afb::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_b18, currMatch.transConnector_b1a);
	}
}

void DerefConnRef_afb::outputAppender( const CyPhyML::SignalFlow::State& state_b1b, const CyPhyML::SignalFlow::TransConnector& transConnector_b1d)
{
	_state_b02->push_back( state_b1b);
	_transConnector_b03->push_back( transConnector_b1d);
}

void TransConnTest_b1f::operator()( const Packets_t& states_b20, const Packets_t& tcs_b22, Packets_t& states_b24, Packets_t& tcs_b25, Packets_t& states_b26, Packets_t& tcs_b27)
{
#ifdef PRINT_INFO
	printLog( "TransConnTest_b1f" );
#endif
	_state_b28= &states_b24;
	_tc_b29= &tcs_b25;
	_state_b2a= &states_b26;
	_tc_b2b= &tcs_b27;
	for( Packets_t::const_iterator itstate_b2d= states_b20.begin(), ittc_b34= tcs_b22.begin(); itstate_b2d!= states_b20.end(), ittc_b34!= tcs_b22.end(); ++itstate_b2d, ++ittc_b34)
	{
		bool isUnique= isInputUnique( *itstate_b2d, *ittc_b34);
		if( !isUnique)
			continue;
		Packets_t onestate_b31( 1, *itstate_b2d);
		Packets_t onetc_b38( 1, *ittc_b34);
		executeOne( onestate_b31, onetc_b38);
	}
}

void TransConnTest_b1f::executeOne( const Packets_t& states_b20, const Packets_t& tcs_b22)
{
	Packets_t states_b3d;
	Packets_t connectorRefs_b40;
	IsConnectorRef_b3a isConnectorRef_b3a;
	bool isMatchIsConnectorRef_b3a= isConnectorRef_b3a( states_b20, tcs_b22, states_b3d, connectorRefs_b40);
	_state_b28->insert( _state_b28->end(), states_b3d.begin(), states_b3d.end());
	_tc_b29->insert( _tc_b29->end(), connectorRefs_b40.begin(), connectorRefs_b40.end());
	if( isMatchIsConnectorRef_b3a)
		return;
	Packets_t states_b5f;
	Packets_t junctions_b62;
	Otherwise_b5c otherwise_b5c;
	bool isMatchOtherwise_b5c= otherwise_b5c( states_b20, tcs_b22, states_b5f, junctions_b62);
	_state_b2a->insert( _state_b2a->end(), states_b5f.begin(), states_b5f.end());
	_tc_b2b->insert( _tc_b2b->end(), junctions_b62.begin(), junctions_b62.end());
	if( isMatchOtherwise_b5c)
		return;
}

bool TransConnTest_b1f::isInputUnique( const Udm::Object& state_b2e, const Udm::Object& tc_b35)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_b30= _state_b2c.begin(), ittc_b37= _tc_b33.begin(); itstate_b30!= _state_b2c.end(), ittc_b37!= _tc_b33.end(); ++itstate_b30, ++ittc_b37)
	{
		if( ( *itstate_b30== state_b2e)&& ( *ittc_b37== tc_b35))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_b2c.push_back( state_b2e);
		_tc_b33.push_back( tc_b35);
	}
	return isUnique;
}

bool IsConnectorRef_b3a::operator()( const Packets_t& states_b3b, const Packets_t& connectorRefs_b3e, Packets_t& states_b3d, Packets_t& connectorRefs_b40)
{
#ifdef PRINT_INFO
	printLog( "IsConnectorRef_b3a" );
#endif
	_state_b41= &states_b3d;
	_connectorRef_b42= &connectorRefs_b40;
	processInputPackets( states_b3b, connectorRefs_b3e);
	if( false== _matches.empty())
		return true;
	return false;
}

bool IsConnectorRef_b3a::isInputUnique( const Udm::Object& state_b47, const Udm::Object& connectorRef_b50)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_b49= _state_b43.begin(), itConnectorRef_b52= _connectorRef_b4c.begin(); itState_b49!= _state_b43.end(), itConnectorRef_b52!= _connectorRef_b4c.end(); ++itState_b49, ++itConnectorRef_b52)
	{
		if( ( *itState_b49== state_b47)&& ( *itConnectorRef_b52== connectorRef_b50))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_b43.push_back( state_b47);
		_connectorRef_b4c.push_back( connectorRef_b50);
	}
	return isUnique;
}

void IsConnectorRef_b3a::processInputPackets( const Packets_t& states_b3b, const Packets_t& connectorRefs_b3e)
{
	for( Packets_t::const_iterator itState_b44= states_b3b.begin(), itConnectorRef_b4d= connectorRefs_b3e.begin(); itState_b44!= states_b3b.end(), itConnectorRef_b4d!= connectorRefs_b3e.end(); ++itState_b44, ++itConnectorRef_b4d)
	{
		bool isUnique= isInputUnique( *itState_b44, *itConnectorRef_b4d);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_b44, *itConnectorRef_b4d);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_b56, currMatch.connectorRef_b57);
	}
}

bool IsConnectorRef_b3a::patternMatcher( const Udm::Object& state_b45, const Udm::Object& connectorRef_b4e)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_b45.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_b4a= CyPhyML::SignalFlow::State::Cast( state_b45);
		if( false== Uml::IsDerivedFrom( connectorRef_b4e.type(), CyPhyML::SignalFlow::ConnectorRef::meta))
			continue;
		CyPhyML::SignalFlow::ConnectorRef connectorRef_b53= CyPhyML::SignalFlow::ConnectorRef::Cast( connectorRef_b4e);
		Match currMatch;
		currMatch.state_b56= state_b4a;
		currMatch.connectorRef_b57= connectorRef_b53;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void IsConnectorRef_b3a::outputAppender( const CyPhyML::SignalFlow::State& state_b58, const CyPhyML::SignalFlow::ConnectorRef& connectorRef_b5a)
{
	_state_b41->push_back( state_b58);
	_connectorRef_b42->push_back( connectorRef_b5a);
}

bool Otherwise_b5c::operator()( const Packets_t& states_b5d, const Packets_t& junctions_b60, Packets_t& states_b5f, Packets_t& junctions_b62)
{
#ifdef PRINT_INFO
	printLog( "Otherwise_b5c" );
#endif
	_state_b63= &states_b5f;
	_junction_b64= &junctions_b62;
	processInputPackets( states_b5d, junctions_b60);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_b5c::isInputUnique( const Udm::Object& state_b69, const Udm::Object& junction_b72)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_b6b= _state_b65.begin(), itJunction_b74= _junction_b6e.begin(); itState_b6b!= _state_b65.end(), itJunction_b74!= _junction_b6e.end(); ++itState_b6b, ++itJunction_b74)
	{
		if( ( *itState_b6b== state_b69)&& ( *itJunction_b74== junction_b72))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_b65.push_back( state_b69);
		_junction_b6e.push_back( junction_b72);
	}
	return isUnique;
}

void Otherwise_b5c::processInputPackets( const Packets_t& states_b5d, const Packets_t& junctions_b60)
{
	for( Packets_t::const_iterator itState_b66= states_b5d.begin(), itJunction_b6f= junctions_b60.begin(); itState_b66!= states_b5d.end(), itJunction_b6f!= junctions_b60.end(); ++itState_b66, ++itJunction_b6f)
	{
		bool isUnique= isInputUnique( *itState_b66, *itJunction_b6f);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_b66, *itJunction_b6f);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_b78, currMatch.junction_b79);
	}
}

bool Otherwise_b5c::patternMatcher( const Udm::Object& state_b67, const Udm::Object& junction_b70)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_b67.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_b6c= CyPhyML::SignalFlow::State::Cast( state_b67);
		if( false== Uml::IsDerivedFrom( junction_b70.type(), CyPhyML::SignalFlow::SF_Junction::meta))
			continue;
		CyPhyML::SignalFlow::SF_Junction junction_b75= CyPhyML::SignalFlow::SF_Junction::Cast( junction_b70);
		Match currMatch;
		currMatch.state_b78= state_b6c;
		currMatch.junction_b79= junction_b75;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_b5c::outputAppender( const CyPhyML::SignalFlow::State& state_b7a, const CyPhyML::SignalFlow::SF_Junction& junction_b7c)
{
	_state_b63->push_back( state_b7a);
	_junction_b64->push_back( junction_b7c);
}

void OrderTransitions_b7e::operator()( const Packets_t& states_b7f, const Packets_t& transitions_b82, Packets_t& states_b81, Packets_t& transitions_b84)
{
#ifdef PRINT_INFO
	printLog( "OrderTransitions_b7e" );
#endif
	RTTGenerator::Instance()->generateRule(2342, "OrderTransitions");
	_state_b85= &states_b81;
	_transition_b86= &transitions_b84;
	processInputPackets( states_b7f, transitions_b82);
	sortOutputs( );
}

bool OrderTransitions_b7e::isInputUnique( const Udm::Object& state_b8b, const Udm::Object& transition_b94)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_b8d= _state_b87.begin(), itTransition_b96= _transition_b90.begin(); itState_b8d!= _state_b87.end(), itTransition_b96!= _transition_b90.end(); ++itState_b8d, ++itTransition_b96)
	{
		if( ( *itState_b8d== state_b8b)&& ( *itTransition_b96== transition_b94))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_b87.push_back( state_b8b);
		_transition_b90.push_back( transition_b94);
	}
	return isUnique;
}

void OrderTransitions_b7e::processInputPackets( const Packets_t& states_b7f, const Packets_t& transitions_b82)
{
	for( Packets_t::const_iterator itState_b88= states_b7f.begin(), itTransition_b91= transitions_b82.begin(); itState_b88!= states_b7f.end(), itTransition_b91!= transitions_b82.end(); ++itState_b88, ++itTransition_b91)
	{
		bool isUnique= isInputUnique( *itState_b88, *itTransition_b91);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_b88, *itTransition_b91);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool OrderTransitions_b7e::patternMatcher( const Udm::Object& state_b89, const Udm::Object& transition_b92)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_b89.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_b8e= CyPhyML::SignalFlow::State::Cast( state_b89);
		if( false== Uml::IsDerivedFrom( transition_b92.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_b97= CyPhyML::SignalFlow::Transition::Cast( transition_b92);
		Match currMatch;
		currMatch.state_b9a= state_b8e;
		currMatch.transition_b9b= transition_b97;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void OrderTransitions_b7e::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_b9a, currMatch.transition_b9b);
	}
}

void OrderTransitions_b7e::outputAppender( const CyPhyML::SignalFlow::State& state_b9c, const CyPhyML::SignalFlow::Transition& transition_b9e)
{
	_state_b85->push_back( state_b9c);
	_transition_b86->push_back( transition_b9e);
}

void OrderTransitions_b7e::sortOutputs()
{
	typedef std::multiset< CyPhyML::SignalFlow::Transition, std::pointer_to_binary_function< const CyPhyML::SignalFlow::Transition&, const CyPhyML::SignalFlow::Transition&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const CyPhyML::SignalFlow::Transition&, const CyPhyML::SignalFlow::Transition&, bool> ptr_TransitionOrder( TransitionOrder< CyPhyML::SignalFlow::Transition>);
	SortedSet_t sortedSet( ptr_TransitionOrder);
	std::vector< int> permutationVector( _transition_b86->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _transition_b86->begin(); it!= _transition_b86->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( CyPhyML::SignalFlow::Transition::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _transition_b86->begin());
	// order rest of the containers
	permutate( permutationVector, *_state_b85);
}

void GetDstTransConnectors_ba0::operator()( const Packets_t& states_ba1, const Packets_t& transitions_ba5, Packets_t& states_ba3, Packets_t& dstTransConnectors_ba4)
{
#ifdef PRINT_INFO
	printLog( "GetDstTransConnectors_ba0" );
#endif
	RTTGenerator::Instance()->generateRule(2345, "getDstTransConnectors");
	_state_ba7= &states_ba3;
	_dstTransConnector_ba8= &dstTransConnectors_ba4;
	processInputPackets( states_ba1, transitions_ba5);
}

bool GetDstTransConnectors_ba0::isInputUnique( const Udm::Object& state_bad, const Udm::Object& transition_bb6)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_baf= _state_ba9.begin(), itTransition_bb8= _transition_bb2.begin(); itState_baf!= _state_ba9.end(), itTransition_bb8!= _transition_bb2.end(); ++itState_baf, ++itTransition_bb8)
	{
		if( ( *itState_baf== state_bad)&& ( *itTransition_bb8== transition_bb6))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_ba9.push_back( state_bad);
		_transition_bb2.push_back( transition_bb6);
	}
	return isUnique;
}

void GetDstTransConnectors_ba0::processInputPackets( const Packets_t& states_ba1, const Packets_t& transitions_ba5)
{
	for( Packets_t::const_iterator itState_baa= states_ba1.begin(), itTransition_bb3= transitions_ba5.begin(); itState_baa!= states_ba1.end(), itTransition_bb3!= transitions_ba5.end(); ++itState_baa, ++itTransition_bb3)
	{
		bool isUnique= isInputUnique( *itState_baa, *itTransition_bb3);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_baa, *itTransition_bb3);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetDstTransConnectors_ba0::patternMatcher( const Udm::Object& state_bab, const Udm::Object& transition_bb4)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_bab.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_bb0= CyPhyML::SignalFlow::State::Cast( state_bab);
		if( false== Uml::IsDerivedFrom( transition_bb4.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_bb9= CyPhyML::SignalFlow::Transition::Cast( transition_bb4);
		CyPhyML::SignalFlow::TransConnector transConnector_bbb= transition_bb9.srcTransition_end();
		CyPhyML::SignalFlow::TransConnector dstTransConnector_bbc= transition_bb9.dstTransition_end();
		Match currMatch;
		currMatch.state_bbe= state_bb0;
		currMatch.transition_bbf= transition_bb9;
		currMatch.transConnector_bc0= transConnector_bbb;
		currMatch.dstTransConnector_bc1= dstTransConnector_bbc;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void GetDstTransConnectors_ba0::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_bbe, currMatch.dstTransConnector_bc1);
	}
}

void GetDstTransConnectors_ba0::outputAppender( const CyPhyML::SignalFlow::State& state_bc2, const CyPhyML::SignalFlow::TransConnector& dstTransConnector_bc4)
{
	_state_ba7->push_back( state_bc2);
	_dstTransConnector_ba8->push_back( dstTransConnector_bc4);
}

void ProcessedFilter_bd5::operator()( const Packets_t& states_bd6, const Packets_t& tcs_bd8, Packets_t& states_bda, Packets_t& tcs_bdb)
{
#ifdef PRINT_INFO
	printLog( "ProcessedFilter_bd5" );
#endif
	_state_bdc= &states_bda;
	_tc_bdd= &tcs_bdb;
	for( Packets_t::const_iterator itstate_bdf= states_bd6.begin(), ittc_be6= tcs_bd8.begin(); itstate_bdf!= states_bd6.end(), ittc_be6!= tcs_bd8.end(); ++itstate_bdf, ++ittc_be6)
	{
		bool isUnique= isInputUnique( *itstate_bdf, *ittc_be6);
		if( !isUnique)
			continue;
		Packets_t onestate_be3( 1, *itstate_bdf);
		Packets_t onetc_bea( 1, *ittc_be6);
		executeOne( onestate_be3, onetc_bea);
	}
}

void ProcessedFilter_bd5::executeOne( const Packets_t& states_bd6, const Packets_t& tcs_bd8)
{
	Packets_t states_bef;
	Packets_t transConnectors_bf2;
	TCNotProcessed_bec tCNotProcessed_bec;
	bool isMatchTCNotProcessed_bec= tCNotProcessed_bec( states_bd6, tcs_bd8, states_bef, transConnectors_bf2);
	_state_bdc->insert( _state_bdc->end(), states_bef.begin(), states_bef.end());
	_tc_bdd->insert( _tc_bdd->end(), transConnectors_bf2.begin(), transConnectors_bf2.end());
	if( isMatchTCNotProcessed_bec)
		return;
}

bool ProcessedFilter_bd5::isInputUnique( const Udm::Object& state_be0, const Udm::Object& tc_be7)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_be2= _state_bde.begin(), ittc_be9= _tc_be5.begin(); itstate_be2!= _state_bde.end(), ittc_be9!= _tc_be5.end(); ++itstate_be2, ++ittc_be9)
	{
		if( ( *itstate_be2== state_be0)&& ( *ittc_be9== tc_be7))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_bde.push_back( state_be0);
		_tc_be5.push_back( tc_be7);
	}
	return isUnique;
}

bool TCNotProcessed_bec::operator()( const Packets_t& states_bed, const Packets_t& transConnectors_bf0, Packets_t& states_bef, Packets_t& transConnectors_bf2)
{
#ifdef PRINT_INFO
	printLog( "TCNotProcessed_bec" );
#endif
	_state_bf3= &states_bef;
	_transConnector_bf4= &transConnectors_bf2;
	processInputPackets( states_bed, transConnectors_bf0);
	if( false== _matches.empty())
		return true;
	return false;
}

bool TCNotProcessed_bec::isInputUnique( const Udm::Object& state_bf9, const Udm::Object& transConnector_c02)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_bfb= _state_bf5.begin(), itTransConnector_c04= _transConnector_bfe.begin(); itState_bfb!= _state_bf5.end(), itTransConnector_c04!= _transConnector_bfe.end(); ++itState_bfb, ++itTransConnector_c04)
	{
		if( ( *itState_bfb== state_bf9)&& ( *itTransConnector_c04== transConnector_c02))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_bf5.push_back( state_bf9);
		_transConnector_bfe.push_back( transConnector_c02);
	}
	return isUnique;
}

bool TCNotProcessed_bec::isGuardTrue( CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::TransConnector& TransConnector)
{
	bool Gz_guard= false;
	return !SFManager::StateTransConnectorMap::get_singleton().getTransConnectorMap( State ).hasTransConnector( TransConnector );;
	return Gz_guard;
}

void TCNotProcessed_bec::processInputPackets( const Packets_t& states_bed, const Packets_t& transConnectors_bf0)
{
	for( Packets_t::const_iterator itState_bf6= states_bed.begin(), itTransConnector_bff= transConnectors_bf0.begin(); itState_bf6!= states_bed.end(), itTransConnector_bff!= transConnectors_bf0.end(); ++itState_bf6, ++itTransConnector_bff)
	{
		bool isUnique= isInputUnique( *itState_bf6, *itTransConnector_bff);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_bf6, *itTransConnector_bff);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_c08, currMatch.transConnector_c09);
	}
}

bool TCNotProcessed_bec::patternMatcher( const Udm::Object& state_bf7, const Udm::Object& transConnector_c00)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_bf7.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_bfc= CyPhyML::SignalFlow::State::Cast( state_bf7);
		if( false== Uml::IsDerivedFrom( transConnector_c00.type(), CyPhyML::SignalFlow::TransConnector::meta))
			continue;
		CyPhyML::SignalFlow::TransConnector transConnector_c05= CyPhyML::SignalFlow::TransConnector::Cast( transConnector_c00);
		Match currMatch;
		currMatch.state_c08= state_bfc;
		currMatch.transConnector_c09= transConnector_c05;
		bool Gz_guard= isGuardTrue( currMatch.state_c08, currMatch.transConnector_c09);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void TCNotProcessed_bec::outputAppender( const CyPhyML::SignalFlow::State& state_c0c, const CyPhyML::SignalFlow::TransConnector& transConnector_c0e)
{
	_state_bf3->push_back( state_c0c);
	_transConnector_bf4->push_back( transConnector_c0e);
}

void PopulateEMFSFunction_c2e::operator()( const Packets_t& states_c2f, const Packets_t& programs_c31, Packets_t& states_c33, Packets_t& programs_c34)
{
#ifdef PRINT_INFO
	printLog( "PopulateEMFSFunction_c2e" );
#endif
	_state_c35= &states_c33;
	_program_c36= &programs_c34;
	if( ( !states_c2f.empty())&& ( !programs_c31.empty()))
		callGetEMFuncStateFunction_c85( states_c2f, programs_c31);
	_state_c35->insert( _state_c35->end(), states_c2f.begin(), states_c2f.end());
	_program_c36->insert( _program_c36->end(), programs_c31.begin(), programs_c31.end());
}

void PopulateEMFSFunction_c2e::callGetEMFuncStateFunction_c85( const Packets_t& states_c55, const Packets_t& programs_c58)
{
	Packets_t states_c57;
	Packets_t execs_c5a;
	GetEMFuncStateFunction_c54 getEMFuncStateFunction_c54;
	getEMFuncStateFunction_c54( states_c55, programs_c58, states_c57, execs_c5a);
	if( ( !states_c57.empty())&& ( !execs_c5a.empty()))
		callFunctionBody_c88( states_c57, execs_c5a);
}

void PopulateEMFSFunction_c2e::callFunctionBody_c88( const Packets_t& states_c38, const Packets_t& execs_c3a)
{
	FunctionBody_c37 functionBody_c37;
	functionBody_c37( states_c38, execs_c3a);
}

void FunctionBody_c37::operator()( const Packets_t& states_c38, const Packets_t& execs_c3a)
{
#ifdef PRINT_INFO
	printLog( "FunctionBody_c37" );
#endif
	RTTGenerator::Instance()->generateRule(65, "FunctionBody");
	processInputPackets( states_c38, execs_c3a);
}

bool FunctionBody_c37::isInputUnique( const Udm::Object& state_c40, const Udm::Object& exec_c49)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_c42= _state_c3c.begin(), itExec_c4b= _exec_c45.begin(); itState_c42!= _state_c3c.end(), itExec_c4b!= _exec_c45.end(); ++itState_c42, ++itExec_c4b)
	{
		if( ( *itState_c42== state_c40)&& ( *itExec_c4b== exec_c49))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_c3c.push_back( state_c40);
		_exec_c45.push_back( exec_c49);
	}
	return isUnique;
}

bool FunctionBody_c37::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void FunctionBody_c37::processInputPackets( const Packets_t& states_c38, const Packets_t& execs_c3a)
{
	for( Packets_t::const_iterator itState_c3d= states_c38.begin(), itExec_c46= execs_c3a.begin(); itState_c3d!= states_c38.end(), itExec_c46!= execs_c3a.end(); ++itState_c3d, ++itExec_c46)
	{
		bool isUnique= isInputUnique( *itState_c3d, *itExec_c46);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_c3d, *itExec_c46);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool FunctionBody_c37::patternMatcher( const Udm::Object& state_c3e, const Udm::Object& exec_c47)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_c3e.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_c43= CyPhyML::SignalFlow::State::Cast( state_c3e);
		if( false== Uml::IsDerivedFrom( exec_c47.type(), SFC::Function::meta))
			continue;
		SFC::Function exec_c4c= SFC::Function::Cast( exec_c47);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_c51;
		if( !isValidBound(boundObjs_c51, state_c43, true))
			continue;
		currMatch.state_c52= state_c43;
		if( !isValidBound(boundObjs_c51, exec_c4c, true))
			continue;
		currMatch.exec_c53= exec_c4c;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void FunctionBody_c37::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function& Exec= currMatch.exec_c53;
		CyPhyML::SignalFlow::State& State= currMatch.state_c52;
		{
SFManager::mstat2SFC( Exec, State.DuringAction() );
};
	}
}

void GetEMFuncStateFunction_c54::operator()( const Packets_t& states_c55, const Packets_t& programs_c58, Packets_t& states_c57, Packets_t& execs_c5a)
{
#ifdef PRINT_INFO
	printLog( "GetEMFuncStateFunction_c54" );
#endif
	RTTGenerator::Instance()->generateRule(69, "GetEMFuncStateFunction");
	_state_c5b= &states_c57;
	_exec_c5c= &execs_c5a;
	processInputPackets( states_c55, programs_c58);
}

bool GetEMFuncStateFunction_c54::isInputUnique( const Udm::Object& state_c61, const Udm::Object& program_c6a)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_c63= _state_c5d.begin(), itProgram_c6c= _program_c66.begin(); itState_c63!= _state_c5d.end(), itProgram_c6c!= _program_c66.end(); ++itState_c63, ++itProgram_c6c)
	{
		if( ( *itState_c63== state_c61)&& ( *itProgram_c6c== program_c6a))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_c5d.push_back( state_c61);
		_program_c66.push_back( program_c6a);
	}
	return isUnique;
}

bool GetEMFuncStateFunction_c54::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool GetEMFuncStateFunction_c54::isGuardTrue( SFC::Function& Exec, SFC::Program& Program, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel)
{
	bool Gz_guard= false;
	Gz_guard =
 static_cast< std::string >( State.Decomposition() ) == "FUNC_STATE" &&
 static_cast< std::string >( State.Order() ) == "-2";;
	return Gz_guard;
}

void GetEMFuncStateFunction_c54::processInputPackets( const Packets_t& states_c55, const Packets_t& programs_c58)
{
	for( Packets_t::const_iterator itState_c5e= states_c55.begin(), itProgram_c67= programs_c58.begin(); itState_c5e!= states_c55.end(), itProgram_c67!= programs_c58.end(); ++itState_c5e, ++itProgram_c67)
	{
		bool isUnique= isInputUnique( *itState_c5e, *itProgram_c67);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_c5e, *itProgram_c67);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetEMFuncStateFunction_c54::patternMatcher( const Udm::Object& state_c5f, const Udm::Object& program_c68)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_c5f.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_c64= CyPhyML::SignalFlow::State::Cast( state_c5f);
		if( false== Uml::IsDerivedFrom( program_c68.type(), SFC::Program::meta))
			continue;
		SFC::Program program_c6d= SFC::Program::Cast( program_c68);
		set< SFC::Function> execs_c6f= state_c64.exec();
		for( set< SFC::Function>::const_iterator itExecs_c70= execs_c6f.begin(); itExecs_c70!= execs_c6f.end(); ++itExecs_c70)
		{
			SFC::Function currExec_c71= *itExecs_c70;
			set< SFC::StateLabel> stateLabels_c72= state_c64.src();
			for( set< SFC::StateLabel>::const_iterator itStateLabels_c73= stateLabels_c72.begin(); itStateLabels_c73!= stateLabels_c72.end(); ++itStateLabels_c73)
			{
				SFC::StateLabel currStateLabel_c74= *itStateLabels_c73;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_c78;
				if( !isValidBound(boundObjs_c78, state_c64, true))
					continue;
				currMatch.state_c79= state_c64;
				if( !isValidBound(boundObjs_c78, program_c6d, true))
					continue;
				currMatch.program_c7a= program_c6d;
				if( !isValidBound(boundObjs_c78, currStateLabel_c74, false))
					continue;
				currMatch.stateLabel_c7b= currStateLabel_c74;
				if( !isValidBound(boundObjs_c78, currExec_c71, false))
					continue;
				currMatch.exec_c7c= currExec_c71;
				bool Gz_guard= isGuardTrue( currMatch.exec_c7c, currMatch.program_c7a, currMatch.state_c79, currMatch.stateLabel_c7b);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetEMFuncStateFunction_c54::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_c79, currMatch.exec_c7c);
	}
}

void GetEMFuncStateFunction_c54::outputAppender( const CyPhyML::SignalFlow::State& state_c81, const SFC::Function& exec_c83)
{
	_state_c5b->push_back( state_c81);
	_exec_c5c->push_back( exec_c83);
}

void GetSubStates_c8b::operator()( const Packets_t& states_c8c, const Packets_t& parStmnts_c8f, Packets_t& subStates_c8e, Packets_t& parStmnts_c91)
{
#ifdef PRINT_INFO
	printLog( "GetSubStates_c8b" );
#endif
	RTTGenerator::Instance()->generateRule(1832, "GetSubStates");
	_subState_c92= &subStates_c8e;
	_parStmnt_c93= &parStmnts_c91;
	processInputPackets( states_c8c, parStmnts_c8f);
}

bool GetSubStates_c8b::isInputUnique( const Udm::Object& state_c98, const Udm::Object& parStmnt_ca1)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_c9a= _state_c94.begin(), itParStmnt_ca3= _parStmnt_c9d.begin(); itState_c9a!= _state_c94.end(), itParStmnt_ca3!= _parStmnt_c9d.end(); ++itState_c9a, ++itParStmnt_ca3)
	{
		if( ( *itState_c9a== state_c98)&& ( *itParStmnt_ca3== parStmnt_ca1))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_c94.push_back( state_c98);
		_parStmnt_c9d.push_back( parStmnt_ca1);
	}
	return isUnique;
}

bool GetSubStates_c8b::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetSubStates_c8b::processInputPackets( const Packets_t& states_c8c, const Packets_t& parStmnts_c8f)
{
	for( Packets_t::const_iterator itState_c95= states_c8c.begin(), itParStmnt_c9e= parStmnts_c8f.begin(); itState_c95!= states_c8c.end(), itParStmnt_c9e!= parStmnts_c8f.end(); ++itState_c95, ++itParStmnt_c9e)
	{
		bool isUnique= isInputUnique( *itState_c95, *itParStmnt_c9e);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_c95, *itParStmnt_c9e);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetSubStates_c8b::patternMatcher( const Udm::Object& state_c96, const Udm::Object& parStmnt_c9f)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_c96.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_c9b= CyPhyML::SignalFlow::State::Cast( state_c96);
		if( false== Uml::IsDerivedFrom( parStmnt_c9f.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement parStmnt_ca4= SFC::CompoundStatement::Cast( parStmnt_c9f);
		set< CyPhyML::SignalFlow::State> subStates_ca6= state_c9b.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itSubState_ca7= subStates_ca6.begin(); itSubState_ca7!= subStates_ca6.end(); ++itSubState_ca7)
		{
			CyPhyML::SignalFlow::State currSubState_ca8= *itSubState_ca7;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_cac;
			if( !isValidBound(boundObjs_cac, state_c9b, true))
				continue;
			currMatch.state_cad= state_c9b;
			if( !isValidBound(boundObjs_cac, parStmnt_ca4, true))
				continue;
			currMatch.parStmnt_cae= parStmnt_ca4;
			if( !isValidBound(boundObjs_cac, currSubState_ca8, false))
				continue;
			currMatch.subState_caf= currSubState_ca8;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetSubStates_c8b::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subState_caf, currMatch.parStmnt_cae);
	}
}

void GetSubStates_c8b::outputAppender( const CyPhyML::SignalFlow::State& subState_cb0, const SFC::CompoundStatement& parStmnt_cb2)
{
	_subState_c92->push_back( subState_cb0);
	_parStmnt_c93->push_back( parStmnt_cb2);
}

void ClearTables_cbd::operator()( const Packets_t& states_cbe, const Packets_t& programs_cc1, Packets_t& states_cc0, Packets_t& programs_cc3)
{
#ifdef PRINT_INFO
	printLog( "ClearTables_cbd" );
#endif
	RTTGenerator::Instance()->generateRule(76, "ClearTables");
	_state_cc4= &states_cc0;
	_program_cc5= &programs_cc3;
	processInputPackets( states_cbe, programs_cc1);
	forwardInputs( );
}

bool ClearTables_cbd::isInputUnique( const Udm::Object& state_cca, const Udm::Object& program_cd3)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_ccc= _state_cc6.begin(), itProgram_cd5= _program_ccf.begin(); itState_ccc!= _state_cc6.end(), itProgram_cd5!= _program_ccf.end(); ++itState_ccc, ++itProgram_cd5)
	{
		if( ( *itState_ccc== state_cca)&& ( *itProgram_cd5== program_cd3))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_cc6.push_back( state_cca);
		_program_ccf.push_back( program_cd3);
	}
	return isUnique;
}

bool ClearTables_cbd::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void ClearTables_cbd::processInputPackets( const Packets_t& states_cbe, const Packets_t& programs_cc1)
{
	for( Packets_t::const_iterator itState_cc7= states_cbe.begin(), itProgram_cd0= programs_cc1.begin(); itState_cc7!= states_cbe.end(), itProgram_cd0!= programs_cc1.end(); ++itState_cc7, ++itProgram_cd0)
	{
		bool isUnique= isInputUnique( *itState_cc7, *itProgram_cd0);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_cc7, *itProgram_cd0);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ClearTables_cbd::patternMatcher( const Udm::Object& state_cc8, const Udm::Object& program_cd1)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_cc8.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_ccd= CyPhyML::SignalFlow::State::Cast( state_cc8);
		if( false== Uml::IsDerivedFrom( program_cd1.type(), SFC::Program::meta))
			continue;
		SFC::Program program_cd6= SFC::Program::Cast( program_cd1);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_cdb;
		if( !isValidBound(boundObjs_cdb, state_ccd, true))
			continue;
		currMatch.state_cdc= state_ccd;
		if( !isValidBound(boundObjs_cdb, program_cd6, true))
			continue;
		currMatch.program_cdd= program_cd6;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void ClearTables_cbd::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Program& Program= currMatch.program_cdd;
		CyPhyML::SignalFlow::State& State= currMatch.state_cdc;
		{
SFManager::getVarResolve().clear();
SFManager::getFunctionHash().clear();
getSFCSymbolTable().clear();
};
	}
}

void ClearTables_cbd::forwardInputs()
{
	*_state_cc4= _state_cc6;
	*_program_cc5= _program_ccf;
}

void CreateStateLabels_cde::operator()( const Packets_t& states_cdf, const Packets_t& programs_ce1, Packets_t& states_ce3, Packets_t& programs_ce4)
{
#ifdef PRINT_INFO
	printLog( "CreateStateLabels_cde" );
#endif
	_state_ce5= &states_ce3;
	_program_ce6= &programs_ce4;
	if( ( !states_cdf.empty())&& ( !programs_ce1.empty()))
		callCreateCompoundStates_eed( states_cdf, programs_ce1);
	_state_ce5->insert( _state_ce5->end(), states_cdf.begin(), states_cdf.end());
	_program_ce6->insert( _program_ce6->end(), programs_ce1.begin(), programs_ce1.end());
}

void CreateStateLabels_cde::callCreateCompoundStates_eed( const Packets_t& states_ce8, const Packets_t& programs_cea)
{
	Packets_t states_cec;
	Packets_t programs_ced;
	CreateCompoundStates_ce7 createCompoundStates_ce7;
	createCompoundStates_ce7( states_ce8, programs_cea, states_cec, programs_ced);
	if( ( !states_cec.empty())&& ( !programs_ced.empty()))
		callCreateStateVar_ef0( states_cec, programs_ced);
}

void CreateStateLabels_cde::callCreateStateVar_ef0( const Packets_t& states_dcc, const Packets_t& programs_dcf)
{
	Packets_t states_dce;
	Packets_t programs_dd1;
	CreateStateVar_dcb createStateVar_dcb;
	createStateVar_dcb( states_dcc, programs_dcf, states_dce, programs_dd1);
	if( ( !states_dce.empty())&& ( !programs_dd1.empty()))
		callCreateLeafStates_ef3( states_dce, programs_dd1);
}

void CreateStateLabels_cde::callCreateLeafStates_ef3( const Packets_t& states_dee, const Packets_t& programs_df0)
{
	Packets_t states_df2;
	Packets_t programs_df3;
	CreateLeafStates_ded createLeafStates_ded;
	createLeafStates_ded( states_dee, programs_df0, states_df2, programs_df3);
	if( ( !states_df2.empty())&& ( !programs_df3.empty()))
		callCreateFuncStates_psuedo_ef6( states_df2, programs_df3);
}

void CreateStateLabels_cde::callCreateFuncStates_psuedo_ef6( const Packets_t& states_e6e, const Packets_t& programs_e70)
{
	Packets_t states_e72;
	Packets_t programs_e73;
	CreateFuncStates_psuedo_e6d createFuncStates_psuedo_e6d;
	createFuncStates_psuedo_e6d( states_e6e, programs_e70, states_e72, programs_e73);
}

void CreateCompoundStates_ce7::operator()( const Packets_t& states_ce8, const Packets_t& programs_cea, Packets_t& states_cec, Packets_t& programs_ced)
{
#ifdef PRINT_INFO
	printLog( "CreateCompoundStates_ce7" );
#endif
	_state_cee= &states_cec;
	_program_cef= &programs_ced;
	_state_cee->insert( _state_cee->end(), states_ce8.begin(), states_ce8.end());
	_program_cef->insert( _program_cef->end(), programs_cea.begin(), programs_cea.end());
	if( ( !states_ce8.empty())&& ( !programs_cea.empty()))
		callIsANDORGROUPCompound_dc2( states_ce8, programs_cea);
}

void CreateCompoundStates_ce7::callIsANDORGROUPCompound_dc2( const Packets_t& states_d80, const Packets_t& programs_d82)
{
	Packets_t states_d84;
	Packets_t programs_d85;
	IsANDORGROUPCompound_d7f isANDORGROUPCompound_d7f;
	isANDORGROUPCompound_d7f( states_d80, programs_d82, states_d84, programs_d85);
	if( ( !states_d84.empty())&& ( !programs_d85.empty()))
		callCreateStateLabel_dc5( states_d84, programs_d85);
}

void CreateCompoundStates_ce7::callCreateStateLabel_dc5( const Packets_t& states_cf1, const Packets_t& programs_cf3)
{
	Packets_t states_cf5;
	Packets_t programs_cf6;
	CreateStateLabel_cf0 createStateLabel_cf0;
	createStateLabel_cf0( states_cf1, programs_cf3, states_cf5, programs_cf6);
	if( ( !states_cf5.empty())&& ( !programs_cf6.empty()))
		callGetSubStates_dc8( states_cf5, programs_cf6);
}

void CreateCompoundStates_ce7::callGetSubStates_dc8( const Packets_t& states_c8c, const Packets_t& parStmnts_c8f)
{
	Packets_t subStates_c8e;
	Packets_t parStmnts_c91;
	GetSubStates_c8b getSubStates_c8b;
	getSubStates_c8b( states_c8c, parStmnts_c8f, subStates_c8e, parStmnts_c91);
	if( ( !subStates_c8e.empty())&& ( !parStmnts_c91.empty()))
		callIsANDORGROUPCompound_dc2( subStates_c8e, parStmnts_c91);
}

void CreateStateLabel_cf0::operator()( const Packets_t& states_cf1, const Packets_t& programs_cf3, Packets_t& states_cf5, Packets_t& programs_cf6)
{
#ifdef PRINT_INFO
	printLog( "CreateStateLabel_cf0" );
#endif
	_state_cf7= &states_cf5;
	_program_cf8= &programs_cf6;
	if( ( !states_cf1.empty())&& ( !programs_cf3.empty()))
		callCreate_d76( states_cf1, programs_cf3);
	_state_cf7->insert( _state_cf7->end(), states_cf1.begin(), states_cf1.end());
	_program_cf8->insert( _program_cf8->end(), programs_cf3.begin(), programs_cf3.end());
}

void CreateStateLabel_cf0::callCreate_d76( const Packets_t& states_d22, const Packets_t& programs_d25)
{
	Packets_t states_d24;
	Packets_t stateLabels_d27;
	Create_d21 create_d21;
	create_d21( states_d22, programs_d25, states_d24, stateLabels_d27);
	if( ( !states_d24.empty())&& ( !stateLabels_d27.empty()))
		callInitMask_d79( states_d24, stateLabels_d27);
}

void CreateStateLabel_cf0::callInitMask_d79( const Packets_t& states_d48, const Packets_t& stateLabels_d4b)
{
	Packets_t states_d4a;
	Packets_t stateLabels_d4d;
	InitMask_d47 initMask_d47;
	initMask_d47( states_d48, stateLabels_d4b, states_d4a, stateLabels_d4d);
	if( ( !states_d4a.empty())&& ( !stateLabels_d4d.empty()))
		callSetPath_d7c( states_d4a, stateLabels_d4d);
}

void CreateStateLabel_cf0::callSetPath_d7c( const Packets_t& states_cfa, const Packets_t& stateLabels_cfd)
{
	Packets_t superStates_cfc;
	Packets_t stateLabels_cff;
	SetPath_cf9 setPath_cf9;
	setPath_cf9( states_cfa, stateLabels_cfd, superStates_cfc, stateLabels_cff);
	if( ( !superStates_cfc.empty())&& ( !stateLabels_cff.empty()))
		callSetPath_d7c( superStates_cfc, stateLabels_cff);
}

void SetPath_cf9::operator()( const Packets_t& states_cfa, const Packets_t& stateLabels_cfd, Packets_t& superStates_cfc, Packets_t& stateLabels_cff)
{
#ifdef PRINT_INFO
	printLog( "SetPath_cf9" );
#endif
	RTTGenerator::Instance()->generateRule(95, "SetPath");
	_superState_d00= &superStates_cfc;
	_stateLabel_d01= &stateLabels_cff;
	processInputPackets( states_cfa, stateLabels_cfd);
}

bool SetPath_cf9::isInputUnique( const Udm::Object& state_d06, const Udm::Object& stateLabel_d0f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_d08= _state_d02.begin(), itStateLabel_d11= _stateLabel_d0b.begin(); itState_d08!= _state_d02.end(), itStateLabel_d11!= _stateLabel_d0b.end(); ++itState_d08, ++itStateLabel_d11)
	{
		if( ( *itState_d08== state_d06)&& ( *itStateLabel_d11== stateLabel_d0f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_d02.push_back( state_d06);
		_stateLabel_d0b.push_back( stateLabel_d0f);
	}
	return isUnique;
}

bool SetPath_cf9::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void SetPath_cf9::processInputPackets( const Packets_t& states_cfa, const Packets_t& stateLabels_cfd)
{
	for( Packets_t::const_iterator itState_d03= states_cfa.begin(), itStateLabel_d0c= stateLabels_cfd.begin(); itState_d03!= states_cfa.end(), itStateLabel_d0c!= stateLabels_cfd.end(); ++itState_d03, ++itStateLabel_d0c)
	{
		bool isUnique= isInputUnique( *itState_d03, *itStateLabel_d0c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_d03, *itStateLabel_d0c);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool SetPath_cf9::patternMatcher( const Udm::Object& state_d04, const Udm::Object& stateLabel_d0d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_d04.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_d09= CyPhyML::SignalFlow::State::Cast( state_d04);
		if( false== Uml::IsDerivedFrom( stateLabel_d0d.type(), SFC::StateLabel::meta))
			continue;
		SFC::StateLabel stateLabel_d12= SFC::StateLabel::Cast( stateLabel_d0d);
		Udm::Object stateParent_d14= state_d09.container();
		if( false== Uml::IsDerivedFrom( stateParent_d14.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State superStateState_d15= CyPhyML::SignalFlow::State::Cast( stateParent_d14);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_d19;
		if( !isValidBound(boundObjs_d19, state_d09, true))
			continue;
		currMatch.state_d1a= state_d09;
		if( !isValidBound(boundObjs_d19, stateLabel_d12, true))
			continue;
		currMatch.stateLabel_d1b= stateLabel_d12;
		if( !isValidBound(boundObjs_d19, superStateState_d15, false))
			continue;
		currMatch.superState_d1c= superStateState_d15;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void SetPath_cf9::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		CyPhyML::SignalFlow::State& State= currMatch.state_d1a;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_d1b;
		CyPhyML::SignalFlow::State& SuperState= currMatch.superState_d1c;
		{
StateLabel.comment() =
 static_cast< std::string >( SuperState.name() ) + "/" +
 static_cast< std::string >( StateLabel.comment() );
};
		outputAppender( currMatch.superState_d1c, currMatch.stateLabel_d1b);
	}
}

void SetPath_cf9::outputAppender( const CyPhyML::SignalFlow::State& superState_d1d, const SFC::StateLabel& stateLabel_d1f)
{
	_superState_d00->push_back( superState_d1d);
	_stateLabel_d01->push_back( stateLabel_d1f);
}

void Create_d21::operator()( const Packets_t& states_d22, const Packets_t& programs_d25, Packets_t& states_d24, Packets_t& stateLabels_d27)
{
#ifdef PRINT_INFO
	printLog( "Create_d21" );
#endif
	RTTGenerator::Instance()->generateRule(101, "Create");
	_state_d28= &states_d24;
	_stateLabel_d29= &stateLabels_d27;
	processInputPackets( states_d22, programs_d25);
}

bool Create_d21::isInputUnique( const Udm::Object& state_d2e, const Udm::Object& program_d37)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_d30= _state_d2a.begin(), itProgram_d39= _program_d33.begin(); itState_d30!= _state_d2a.end(), itProgram_d39!= _program_d33.end(); ++itState_d30, ++itProgram_d39)
	{
		if( ( *itState_d30== state_d2e)&& ( *itProgram_d39== program_d37))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_d2a.push_back( state_d2e);
		_program_d33.push_back( program_d37);
	}
	return isUnique;
}

bool Create_d21::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Create_d21::processInputPackets( const Packets_t& states_d22, const Packets_t& programs_d25)
{
	for( Packets_t::const_iterator itState_d2b= states_d22.begin(), itProgram_d34= programs_d25.begin(); itState_d2b!= states_d22.end(), itProgram_d34!= programs_d25.end(); ++itState_d2b, ++itProgram_d34)
	{
		bool isUnique= isInputUnique( *itState_d2b, *itProgram_d34);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_d2b, *itProgram_d34);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool Create_d21::patternMatcher( const Udm::Object& state_d2c, const Udm::Object& program_d35)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_d2c.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_d31= CyPhyML::SignalFlow::State::Cast( state_d2c);
		if( false== Uml::IsDerivedFrom( program_d35.type(), SFC::Program::meta))
			continue;
		SFC::Program program_d3a= SFC::Program::Cast( program_d35);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_d3f;
		if( !isValidBound(boundObjs_d3f, state_d31, true))
			continue;
		currMatch.state_d40= state_d31;
		if( !isValidBound(boundObjs_d3f, program_d3a, true))
			continue;
		currMatch.program_d41= program_d3a;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Create_d21::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::StateLabel newStateLabel_d42= SFC::StateLabel::Create( currMatch.program_d41);
		SFC::Program& Program= currMatch.program_d41;
		CyPhyML::SignalFlow::State& State= currMatch.state_d40;
		SFC::StateLabel& StateLabel= newStateLabel_d42;
		{
std::string name = State.name();

StateLabel.comment() = name;

__int64 stateCount = Program.stateCount();
std::string nameUC = SFUtils::convertToCPlusPlusName(   std::string(  _strupr( (char *)name.c_str() )  )   ) + boost::lexical_cast< std::string >( stateCount );

StateLabel.name() = nameUC;
StateLabel.value() = stateCount++;
Program.stateCount() = stateCount;

StateLabel.dt() = SFCTypesManager::getSingleton().getBasicType( "int" );
};
		{
__int64 statementCount = Program.statementCount();
StateLabel.statementIndex() = statementCount++;
Program.statementCount() = statementCount;
};
		{
StateLabel.RefId() = State.RefId();
};
		newStateLabel_d42.dst()+= currMatch.state_d40;
		outputAppender( currMatch.state_d40, newStateLabel_d42);
	}
}

void Create_d21::outputAppender( const CyPhyML::SignalFlow::State& state_d43, const SFC::StateLabel& stateLabel_d45)
{
	_state_d28->push_back( state_d43);
	_stateLabel_d29->push_back( stateLabel_d45);
}

void InitMask_d47::operator()( const Packets_t& states_d48, const Packets_t& stateLabels_d4b, Packets_t& states_d4a, Packets_t& stateLabels_d4d)
{
#ifdef PRINT_INFO
	printLog( "InitMask_d47" );
#endif
	RTTGenerator::Instance()->generateRule(110, "InitMask");
	_state_d4e= &states_d4a;
	_stateLabel_d4f= &stateLabels_d4d;
	processInputPackets( states_d48, stateLabels_d4b);
	forwardInputs( );
}

bool InitMask_d47::isInputUnique( const Udm::Object& state_d54, const Udm::Object& stateLabel_d5d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_d56= _state_d50.begin(), itStateLabel_d5f= _stateLabel_d59.begin(); itState_d56!= _state_d50.end(), itStateLabel_d5f!= _stateLabel_d59.end(); ++itState_d56, ++itStateLabel_d5f)
	{
		if( ( *itState_d56== state_d54)&& ( *itStateLabel_d5f== stateLabel_d5d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_d50.push_back( state_d54);
		_stateLabel_d59.push_back( stateLabel_d5d);
	}
	return isUnique;
}

bool InitMask_d47::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool InitMask_d47::isGuardTrue( CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel, CyPhyML::SignalFlow::State& SuperState, SFC::StateLabel& SuperStateLabel)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( State.Decomposition() ) == "AND_STATE";;
	return Gz_guard;
}

void InitMask_d47::processInputPackets( const Packets_t& states_d48, const Packets_t& stateLabels_d4b)
{
	for( Packets_t::const_iterator itState_d51= states_d48.begin(), itStateLabel_d5a= stateLabels_d4b.begin(); itState_d51!= states_d48.end(), itStateLabel_d5a!= stateLabels_d4b.end(); ++itState_d51, ++itStateLabel_d5a)
	{
		bool isUnique= isInputUnique( *itState_d51, *itStateLabel_d5a);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_d51, *itStateLabel_d5a);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitMask_d47::patternMatcher( const Udm::Object& state_d52, const Udm::Object& stateLabel_d5b)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_d52.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_d57= CyPhyML::SignalFlow::State::Cast( state_d52);
		if( false== Uml::IsDerivedFrom( stateLabel_d5b.type(), SFC::StateLabel::meta))
			continue;
		SFC::StateLabel stateLabel_d60= SFC::StateLabel::Cast( stateLabel_d5b);
		set< CyPhyML::SignalFlow::State> states_d62= stateLabel_d60.dst();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itStates_d63= states_d62.begin(); itStates_d63!= states_d62.end(); ++itStates_d63)
		{
			CyPhyML::SignalFlow::State currState_d64= *itStates_d63;
			if( state_d57!= currState_d64)
				continue;
			Udm::Object stateParent_d65= state_d57.container();
			if( false== Uml::IsDerivedFrom( stateParent_d65.type(), CyPhyML::SignalFlow::State::meta))
				continue;
			CyPhyML::SignalFlow::State superStateState_d66= CyPhyML::SignalFlow::State::Cast( stateParent_d65);
			set< SFC::StateLabel> superStateLabels_d67= superStateState_d66.src();
			for( set< SFC::StateLabel>::const_iterator itSuperStateLabels_d68= superStateLabels_d67.begin(); itSuperStateLabels_d68!= superStateLabels_d67.end(); ++itSuperStateLabels_d68)
			{
				SFC::StateLabel currSuperStateLabel_d69= *itSuperStateLabels_d68;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_d6d;
				if( !isValidBound(boundObjs_d6d, state_d57, true))
					continue;
				currMatch.state_d6e= state_d57;
				if( !isValidBound(boundObjs_d6d, stateLabel_d60, true))
					continue;
				currMatch.stateLabel_d6f= stateLabel_d60;
				if( !isValidBound(boundObjs_d6d, superStateState_d66, false))
					continue;
				currMatch.superState_d70= superStateState_d66;
				if( !isValidBound(boundObjs_d6d, currSuperStateLabel_d69, false))
					continue;
				currMatch.superStateLabel_d71= currSuperStateLabel_d69;
				bool Gz_guard= isGuardTrue( currMatch.state_d6e, currMatch.stateLabel_d6f, currMatch.superState_d70, currMatch.superStateLabel_d71);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void InitMask_d47::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		CyPhyML::SignalFlow::State& State= currMatch.state_d6e;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_d6f;
		CyPhyML::SignalFlow::State& SuperState= currMatch.superState_d70;
		SFC::StateLabel& SuperStateLabel= currMatch.superStateLabel_d71;
		{
__int64 ss = SuperStateLabel.andSS();
__int64 sl = StateLabel.value();

sl = (1 << (ss + 16)) | (sl & 0xffff);

StateLabel.value() = sl;
SuperStateLabel.andSS() = ++ss;
};
	}
}

void InitMask_d47::forwardInputs()
{
	*_state_d4e= _state_d50;
	*_stateLabel_d4f= _stateLabel_d59;
}

void IsANDORGROUPCompound_d7f::operator()( const Packets_t& states_d80, const Packets_t& programs_d82, Packets_t& states_d84, Packets_t& programs_d85)
{
#ifdef PRINT_INFO
	printLog( "IsANDORGROUPCompound_d7f" );
#endif
	_state_d86= &states_d84;
	_program_d87= &programs_d85;
	for( Packets_t::const_iterator itstate_d89= states_d80.begin(), itprogram_d90= programs_d82.begin(); itstate_d89!= states_d80.end(), itprogram_d90!= programs_d82.end(); ++itstate_d89, ++itprogram_d90)
	{
		bool isUnique= isInputUnique( *itstate_d89, *itprogram_d90);
		if( !isUnique)
			continue;
		Packets_t onestate_d8d( 1, *itstate_d89);
		Packets_t oneprogram_d94( 1, *itprogram_d90);
		executeOne( onestate_d8d, oneprogram_d94);
	}
}

void IsANDORGROUPCompound_d7f::executeOne( const Packets_t& states_d80, const Packets_t& programs_d82)
{
	Packets_t states_d99;
	Packets_t programs_d9c;
	HasSubstates_d96 hasSubstates_d96;
	bool isMatchHasSubstates_d96= hasSubstates_d96( states_d80, programs_d82, states_d99, programs_d9c);
	_state_d86->insert( _state_d86->end(), states_d99.begin(), states_d99.end());
	_program_d87->insert( _program_d87->end(), programs_d9c.begin(), programs_d9c.end());
	if( isMatchHasSubstates_d96)
		return;
}

bool IsANDORGROUPCompound_d7f::isInputUnique( const Udm::Object& state_d8a, const Udm::Object& program_d91)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_d8c= _state_d88.begin(), itprogram_d93= _program_d8f.begin(); itstate_d8c!= _state_d88.end(), itprogram_d93!= _program_d8f.end(); ++itstate_d8c, ++itprogram_d93)
	{
		if( ( *itstate_d8c== state_d8a)&& ( *itprogram_d93== program_d91))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_d88.push_back( state_d8a);
		_program_d8f.push_back( program_d91);
	}
	return isUnique;
}

bool HasSubstates_d96::operator()( const Packets_t& states_d97, const Packets_t& programs_d9a, Packets_t& states_d99, Packets_t& programs_d9c)
{
#ifdef PRINT_INFO
	printLog( "HasSubstates_d96" );
#endif
	_state_d9d= &states_d99;
	_program_d9e= &programs_d9c;
	processInputPackets( states_d97, programs_d9a);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasSubstates_d96::isInputUnique( const Udm::Object& state_da3, const Udm::Object& program_dac)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_da5= _state_d9f.begin(), itProgram_dae= _program_da8.begin(); itState_da5!= _state_d9f.end(), itProgram_dae!= _program_da8.end(); ++itState_da5, ++itProgram_dae)
	{
		if( ( *itState_da5== state_da3)&& ( *itProgram_dae== program_dac))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_d9f.push_back( state_da3);
		_program_da8.push_back( program_dac);
	}
	return isUnique;
}

bool HasSubstates_d96::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool HasSubstates_d96::isGuardTrue( SFC::Program& Program, CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::State& SubState)
{
	bool Gz_guard= false;
	string s = State.Decomposition();
Gz_guard = !( s.compare("FUNC_STATE") == 0 );;
	return Gz_guard;
}

void HasSubstates_d96::processInputPackets( const Packets_t& states_d97, const Packets_t& programs_d9a)
{
	for( Packets_t::const_iterator itState_da0= states_d97.begin(), itProgram_da9= programs_d9a.begin(); itState_da0!= states_d97.end(), itProgram_da9!= programs_d9a.end(); ++itState_da0, ++itProgram_da9)
	{
		bool isUnique= isInputUnique( *itState_da0, *itProgram_da9);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_da0, *itProgram_da9);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_db8, currMatch.program_db9);
	}
}

bool HasSubstates_d96::patternMatcher( const Udm::Object& state_da1, const Udm::Object& program_daa)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_da1.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_da6= CyPhyML::SignalFlow::State::Cast( state_da1);
		if( false== Uml::IsDerivedFrom( program_daa.type(), SFC::Program::meta))
			continue;
		SFC::Program program_daf= SFC::Program::Cast( program_daa);
		set< CyPhyML::SignalFlow::State> subStates_db1= state_da6.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itSubState_db2= subStates_db1.begin(); itSubState_db2!= subStates_db1.end(); ++itSubState_db2)
		{
			CyPhyML::SignalFlow::State currSubState_db3= *itSubState_db2;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_db7;
			if( !isValidBound(boundObjs_db7, state_da6, true))
				continue;
			currMatch.state_db8= state_da6;
			if( !isValidBound(boundObjs_db7, program_daf, true))
				continue;
			currMatch.program_db9= program_daf;
			if( !isValidBound(boundObjs_db7, currSubState_db3, false))
				continue;
			currMatch.subState_dba= currSubState_db3;
			bool Gz_guard= isGuardTrue( currMatch.program_db9, currMatch.state_db8, currMatch.subState_dba);
			if( true== Gz_guard)
			{
				_matches.push_back( currMatch);
				return true;
			}
		}
	}
	return !_matches.empty();
}

void HasSubstates_d96::outputAppender( const CyPhyML::SignalFlow::State& state_dbe, const SFC::Program& program_dc0)
{
	_state_d9d->push_back( state_dbe);
	_program_d9e->push_back( program_dc0);
}

void CreateStateVar_dcb::operator()( const Packets_t& states_dcc, const Packets_t& programs_dcf, Packets_t& states_dce, Packets_t& programs_dd1)
{
#ifdef PRINT_INFO
	printLog( "CreateStateVar_dcb" );
#endif
	RTTGenerator::Instance()->generateRule(129, "CreateStateVar");
	_state_dd2= &states_dce;
	_program_dd3= &programs_dd1;
	processInputPackets( states_dcc, programs_dcf);
	forwardInputs( );
}

bool CreateStateVar_dcb::isInputUnique( const Udm::Object& state_dd8, const Udm::Object& program_de1)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_dda= _state_dd4.begin(), itProgram_de3= _program_ddd.begin(); itState_dda!= _state_dd4.end(), itProgram_de3!= _program_ddd.end(); ++itState_dda, ++itProgram_de3)
	{
		if( ( *itState_dda== state_dd8)&& ( *itProgram_de3== program_de1))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_dd4.push_back( state_dd8);
		_program_ddd.push_back( program_de1);
	}
	return isUnique;
}

bool CreateStateVar_dcb::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateStateVar_dcb::processInputPackets( const Packets_t& states_dcc, const Packets_t& programs_dcf)
{
	for( Packets_t::const_iterator itState_dd5= states_dcc.begin(), itProgram_dde= programs_dcf.begin(); itState_dd5!= states_dcc.end(), itProgram_dde!= programs_dcf.end(); ++itState_dd5, ++itProgram_dde)
	{
		bool isUnique= isInputUnique( *itState_dd5, *itProgram_dde);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_dd5, *itProgram_dde);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateStateVar_dcb::patternMatcher( const Udm::Object& state_dd6, const Udm::Object& program_ddf)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_dd6.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_ddb= CyPhyML::SignalFlow::State::Cast( state_dd6);
		if( false== Uml::IsDerivedFrom( program_ddf.type(), SFC::Program::meta))
			continue;
		SFC::Program program_de4= SFC::Program::Cast( program_ddf);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_de9;
		if( !isValidBound(boundObjs_de9, state_ddb, true))
			continue;
		currMatch.state_dea= state_ddb;
		if( !isValidBound(boundObjs_de9, program_de4, true))
			continue;
		currMatch.program_deb= program_de4;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateStateVar_dcb::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::StateVar newStateVar_dec= SFC::StateVar::Create( currMatch.program_deb, SFC::Program::meta_stmnt);
		SFC::Program& Program= currMatch.program_deb;
		CyPhyML::SignalFlow::State& State= currMatch.state_dea;
		SFC::StateVar& StateVar= newStateVar_dec;
		{
StateVar.RefId() = Program.RefId();
};
		{
__int64 stateCount = Program.stateCount();
StateVar.size() = stateCount;
StateVar.name() = "activeSubStates";
StateVar.dt() = SFCTypesManager::getSingleton().getBasicType( "int" );
};
		{
__int64 statementCount = Program.statementCount();
StateVar.statementIndex() = statementCount++;
Program.statementCount() = statementCount;
};
	}
}

void CreateStateVar_dcb::forwardInputs()
{
	*_state_dd2= _state_dd4;
	*_program_dd3= _program_ddd;
}

void CreateLeafStates_ded::operator()( const Packets_t& states_dee, const Packets_t& programs_df0, Packets_t& states_df2, Packets_t& programs_df3)
{
#ifdef PRINT_INFO
	printLog( "CreateLeafStates_ded" );
#endif
	_state_df4= &states_df2;
	_program_df5= &programs_df3;
	_state_df4->insert( _state_df4->end(), states_dee.begin(), states_dee.end());
	_program_df5->insert( _program_df5->end(), programs_df0.begin(), programs_df0.end());
	if( ( !states_dee.empty())&& ( !programs_df0.empty()))
		callIsLeaf_e64( states_dee, programs_df0);
}

void CreateLeafStates_ded::callIsLeaf_e64( const Packets_t& states_df7, const Packets_t& programs_df9)
{
	Packets_t states_dfb;
	Packets_t programs_dfc;
	Packets_t states_dfd;
	Packets_t programs_dfe;
	IsLeaf_df6 isLeaf_df6;
	isLeaf_df6( states_df7, programs_df9, states_dfb, programs_dfc, states_dfd, programs_dfe);
	if( ( !states_dfd.empty())&& ( !programs_dfe.empty()))
		callCreateStateLabel_e67( states_dfd, programs_dfe);
	if( ( !states_dfb.empty())&& ( !programs_dfc.empty()))
		callGetSubStates_e6a( states_dfb, programs_dfc);
}

void CreateLeafStates_ded::callCreateStateLabel_e67( const Packets_t& states_cf1, const Packets_t& programs_cf3)
{
	Packets_t states_cf5;
	Packets_t programs_cf6;
	CreateStateLabel_cf0 createStateLabel_cf0;
	createStateLabel_cf0( states_cf1, programs_cf3, states_cf5, programs_cf6);
}

void CreateLeafStates_ded::callGetSubStates_e6a( const Packets_t& states_c8c, const Packets_t& parStmnts_c8f)
{
	Packets_t subStates_c8e;
	Packets_t parStmnts_c91;
	GetSubStates_c8b getSubStates_c8b;
	getSubStates_c8b( states_c8c, parStmnts_c8f, subStates_c8e, parStmnts_c91);
	if( ( !subStates_c8e.empty())&& ( !parStmnts_c91.empty()))
		callIsLeaf_e64( subStates_c8e, parStmnts_c91);
}

void IsLeaf_df6::operator()( const Packets_t& states_df7, const Packets_t& programs_df9, Packets_t& states_dfb, Packets_t& programs_dfc, Packets_t& states_dfd, Packets_t& programs_dfe)
{
#ifdef PRINT_INFO
	printLog( "IsLeaf_df6" );
#endif
	_state_dff= &states_dfb;
	_program_e00= &programs_dfc;
	_state_e01= &states_dfd;
	_program_e02= &programs_dfe;
	for( Packets_t::const_iterator itstate_e04= states_df7.begin(), itprogram_e0b= programs_df9.begin(); itstate_e04!= states_df7.end(), itprogram_e0b!= programs_df9.end(); ++itstate_e04, ++itprogram_e0b)
	{
		bool isUnique= isInputUnique( *itstate_e04, *itprogram_e0b);
		if( !isUnique)
			continue;
		Packets_t onestate_e08( 1, *itstate_e04);
		Packets_t oneprogram_e0f( 1, *itprogram_e0b);
		executeOne( onestate_e08, oneprogram_e0f);
	}
}

void IsLeaf_df6::executeOne( const Packets_t& states_df7, const Packets_t& programs_df9)
{
	Packets_t states_e14;
	Packets_t programs_e17;
	HasSubstates_e11 hasSubstates_e11;
	bool isMatchHasSubstates_e11= hasSubstates_e11( states_df7, programs_df9, states_e14, programs_e17);
	_state_dff->insert( _state_dff->end(), states_e14.begin(), states_e14.end());
	_program_e00->insert( _program_e00->end(), programs_e17.begin(), programs_e17.end());
	if( isMatchHasSubstates_e11)
		return;
	Packets_t states_e40;
	Packets_t programs_e43;
	Otherwise_e3d otherwise_e3d;
	bool isMatchOtherwise_e3d= otherwise_e3d( states_df7, programs_df9, states_e40, programs_e43);
	_state_e01->insert( _state_e01->end(), states_e40.begin(), states_e40.end());
	_program_e02->insert( _program_e02->end(), programs_e43.begin(), programs_e43.end());
}

bool IsLeaf_df6::isInputUnique( const Udm::Object& state_e05, const Udm::Object& program_e0c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_e07= _state_e03.begin(), itprogram_e0e= _program_e0a.begin(); itstate_e07!= _state_e03.end(), itprogram_e0e!= _program_e0a.end(); ++itstate_e07, ++itprogram_e0e)
	{
		if( ( *itstate_e07== state_e05)&& ( *itprogram_e0e== program_e0c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_e03.push_back( state_e05);
		_program_e0a.push_back( program_e0c);
	}
	return isUnique;
}

bool HasSubstates_e11::operator()( const Packets_t& states_e12, const Packets_t& programs_e15, Packets_t& states_e14, Packets_t& programs_e17)
{
#ifdef PRINT_INFO
	printLog( "HasSubstates_e11" );
#endif
	_state_e18= &states_e14;
	_program_e19= &programs_e17;
	processInputPackets( states_e12, programs_e15);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasSubstates_e11::isInputUnique( const Udm::Object& state_e1e, const Udm::Object& program_e27)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_e20= _state_e1a.begin(), itProgram_e29= _program_e23.begin(); itState_e20!= _state_e1a.end(), itProgram_e29!= _program_e23.end(); ++itState_e20, ++itProgram_e29)
	{
		if( ( *itState_e20== state_e1e)&& ( *itProgram_e29== program_e27))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_e1a.push_back( state_e1e);
		_program_e23.push_back( program_e27);
	}
	return isUnique;
}

bool HasSubstates_e11::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool HasSubstates_e11::isGuardTrue( SFC::Program& Program, CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::State& SubState)
{
	bool Gz_guard= false;
	string s;
State.GetStrValue("Decomposition", s);
Gz_guard = !( s.compare("FUNC_STATE") == 0 );;
	return Gz_guard;
}

void HasSubstates_e11::processInputPackets( const Packets_t& states_e12, const Packets_t& programs_e15)
{
	for( Packets_t::const_iterator itState_e1b= states_e12.begin(), itProgram_e24= programs_e15.begin(); itState_e1b!= states_e12.end(), itProgram_e24!= programs_e15.end(); ++itState_e1b, ++itProgram_e24)
	{
		bool isUnique= isInputUnique( *itState_e1b, *itProgram_e24);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_e1b, *itProgram_e24);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_e33, currMatch.program_e34);
	}
}

bool HasSubstates_e11::patternMatcher( const Udm::Object& state_e1c, const Udm::Object& program_e25)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_e1c.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_e21= CyPhyML::SignalFlow::State::Cast( state_e1c);
		if( false== Uml::IsDerivedFrom( program_e25.type(), SFC::Program::meta))
			continue;
		SFC::Program program_e2a= SFC::Program::Cast( program_e25);
		set< CyPhyML::SignalFlow::State> subStates_e2c= state_e21.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itSubState_e2d= subStates_e2c.begin(); itSubState_e2d!= subStates_e2c.end(); ++itSubState_e2d)
		{
			CyPhyML::SignalFlow::State currSubState_e2e= *itSubState_e2d;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_e32;
			if( !isValidBound(boundObjs_e32, state_e21, true))
				continue;
			currMatch.state_e33= state_e21;
			if( !isValidBound(boundObjs_e32, program_e2a, true))
				continue;
			currMatch.program_e34= program_e2a;
			if( !isValidBound(boundObjs_e32, currSubState_e2e, false))
				continue;
			currMatch.subState_e35= currSubState_e2e;
			bool Gz_guard= isGuardTrue( currMatch.program_e34, currMatch.state_e33, currMatch.subState_e35);
			if( true== Gz_guard)
			{
				_matches.push_back( currMatch);
				return true;
			}
		}
	}
	return !_matches.empty();
}

void HasSubstates_e11::outputAppender( const CyPhyML::SignalFlow::State& state_e39, const SFC::Program& program_e3b)
{
	_state_e18->push_back( state_e39);
	_program_e19->push_back( program_e3b);
}

bool Otherwise_e3d::operator()( const Packets_t& states_e3e, const Packets_t& programs_e41, Packets_t& states_e40, Packets_t& programs_e43)
{
#ifdef PRINT_INFO
	printLog( "Otherwise_e3d" );
#endif
	_state_e44= &states_e40;
	_program_e45= &programs_e43;
	processInputPackets( states_e3e, programs_e41);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_e3d::isInputUnique( const Udm::Object& state_e4a, const Udm::Object& program_e53)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_e4c= _state_e46.begin(), itProgram_e55= _program_e4f.begin(); itState_e4c!= _state_e46.end(), itProgram_e55!= _program_e4f.end(); ++itState_e4c, ++itProgram_e55)
	{
		if( ( *itState_e4c== state_e4a)&& ( *itProgram_e55== program_e53))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_e46.push_back( state_e4a);
		_program_e4f.push_back( program_e53);
	}
	return isUnique;
}

bool Otherwise_e3d::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool Otherwise_e3d::isGuardTrue( SFC::Program& Program, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	string s = State.Decomposition();
Gz_guard = !( s.compare("FUNC_STATE") == 0 );;
	return Gz_guard;
}

void Otherwise_e3d::processInputPackets( const Packets_t& states_e3e, const Packets_t& programs_e41)
{
	for( Packets_t::const_iterator itState_e47= states_e3e.begin(), itProgram_e50= programs_e41.begin(); itState_e47!= states_e3e.end(), itProgram_e50!= programs_e41.end(); ++itState_e47, ++itProgram_e50)
	{
		bool isUnique= isInputUnique( *itState_e47, *itProgram_e50);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_e47, *itProgram_e50);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_e5c, currMatch.program_e5d);
	}
}

bool Otherwise_e3d::patternMatcher( const Udm::Object& state_e48, const Udm::Object& program_e51)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_e48.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_e4d= CyPhyML::SignalFlow::State::Cast( state_e48);
		if( false== Uml::IsDerivedFrom( program_e51.type(), SFC::Program::meta))
			continue;
		SFC::Program program_e56= SFC::Program::Cast( program_e51);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_e5b;
		if( !isValidBound(boundObjs_e5b, state_e4d, true))
			continue;
		currMatch.state_e5c= state_e4d;
		if( !isValidBound(boundObjs_e5b, program_e56, true))
			continue;
		currMatch.program_e5d= program_e56;
		bool Gz_guard= isGuardTrue( currMatch.program_e5d, currMatch.state_e5c);
		if( true== Gz_guard)
		{
			_matches.push_back( currMatch);
			return true;
		}
	}
	return !_matches.empty();
}

void Otherwise_e3d::outputAppender( const CyPhyML::SignalFlow::State& state_e60, const SFC::Program& program_e62)
{
	_state_e44->push_back( state_e60);
	_program_e45->push_back( program_e62);
}

void CreateFuncStates_psuedo_e6d::operator()( const Packets_t& states_e6e, const Packets_t& programs_e70, Packets_t& states_e72, Packets_t& programs_e73)
{
#ifdef PRINT_INFO
	printLog( "CreateFuncStates_psuedo_e6d" );
#endif
	_state_e74= &states_e72;
	_program_e75= &programs_e73;
	if( ( !states_e6e.empty())&& ( !programs_e70.empty()))
		callIsFuncState_ee4( states_e6e, programs_e70);
	_state_e74->insert( _state_e74->end(), states_e6e.begin(), states_e6e.end());
	_program_e75->insert( _program_e75->end(), programs_e70.begin(), programs_e70.end());
}

void CreateFuncStates_psuedo_e6d::callIsFuncState_ee4( const Packets_t& states_e77, const Packets_t& programs_e79)
{
	Packets_t states_e7b;
	Packets_t programs_e7c;
	Packets_t states_e7d;
	Packets_t programs_e7e;
	IsFuncState_e76 isFuncState_e76;
	isFuncState_e76( states_e77, programs_e79, states_e7b, programs_e7c, states_e7d, programs_e7e);
	if( ( !states_e7b.empty())&& ( !programs_e7c.empty()))
		callGetSubStates_ee7( states_e7b, programs_e7c);
	if( ( !states_e7d.empty())&& ( !programs_e7e.empty()))
		callCreateStateLabel_eea( states_e7d, programs_e7e);
}

void CreateFuncStates_psuedo_e6d::callGetSubStates_ee7( const Packets_t& states_c8c, const Packets_t& parStmnts_c8f)
{
	Packets_t subStates_c8e;
	Packets_t parStmnts_c91;
	GetSubStates_c8b getSubStates_c8b;
	getSubStates_c8b( states_c8c, parStmnts_c8f, subStates_c8e, parStmnts_c91);
	if( ( !subStates_c8e.empty())&& ( !parStmnts_c91.empty()))
		callIsFuncState_ee4( subStates_c8e, parStmnts_c91);
}

void CreateFuncStates_psuedo_e6d::callCreateStateLabel_eea( const Packets_t& states_cf1, const Packets_t& programs_cf3)
{
	Packets_t states_cf5;
	Packets_t programs_cf6;
	CreateStateLabel_cf0 createStateLabel_cf0;
	createStateLabel_cf0( states_cf1, programs_cf3, states_cf5, programs_cf6);
	if( ( !states_cf5.empty())&& ( !programs_cf6.empty()))
		callGetSubStates_ee7( states_cf5, programs_cf6);
}

void IsFuncState_e76::operator()( const Packets_t& states_e77, const Packets_t& programs_e79, Packets_t& states_e7b, Packets_t& programs_e7c, Packets_t& states_e7d, Packets_t& programs_e7e)
{
#ifdef PRINT_INFO
	printLog( "IsFuncState_e76" );
#endif
	_state_e7f= &states_e7b;
	_program_e80= &programs_e7c;
	_state_e81= &states_e7d;
	_program_e82= &programs_e7e;
	for( Packets_t::const_iterator itstate_e84= states_e77.begin(), itprogram_e8b= programs_e79.begin(); itstate_e84!= states_e77.end(), itprogram_e8b!= programs_e79.end(); ++itstate_e84, ++itprogram_e8b)
	{
		bool isUnique= isInputUnique( *itstate_e84, *itprogram_e8b);
		if( !isUnique)
			continue;
		Packets_t onestate_e88( 1, *itstate_e84);
		Packets_t oneprogram_e8f( 1, *itprogram_e8b);
		executeOne( onestate_e88, oneprogram_e8f);
	}
}

void IsFuncState_e76::executeOne( const Packets_t& states_e77, const Packets_t& programs_e79)
{
	Packets_t states_e94;
	Packets_t programs_e97;
	HasSubstates_e91 hasSubstates_e91;
	bool isMatchHasSubstates_e91= hasSubstates_e91( states_e77, programs_e79, states_e94, programs_e97);
	_state_e7f->insert( _state_e7f->end(), states_e94.begin(), states_e94.end());
	_program_e80->insert( _program_e80->end(), programs_e97.begin(), programs_e97.end());
	if( isMatchHasSubstates_e91)
		return;
	Packets_t states_ec0;
	Packets_t programs_ec3;
	Otherwise_ebd otherwise_ebd;
	bool isMatchOtherwise_ebd= otherwise_ebd( states_e77, programs_e79, states_ec0, programs_ec3);
	_state_e81->insert( _state_e81->end(), states_ec0.begin(), states_ec0.end());
	_program_e82->insert( _program_e82->end(), programs_ec3.begin(), programs_ec3.end());
}

bool IsFuncState_e76::isInputUnique( const Udm::Object& state_e85, const Udm::Object& program_e8c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_e87= _state_e83.begin(), itprogram_e8e= _program_e8a.begin(); itstate_e87!= _state_e83.end(), itprogram_e8e!= _program_e8a.end(); ++itstate_e87, ++itprogram_e8e)
	{
		if( ( *itstate_e87== state_e85)&& ( *itprogram_e8e== program_e8c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_e83.push_back( state_e85);
		_program_e8a.push_back( program_e8c);
	}
	return isUnique;
}

bool HasSubstates_e91::operator()( const Packets_t& states_e92, const Packets_t& programs_e95, Packets_t& states_e94, Packets_t& programs_e97)
{
#ifdef PRINT_INFO
	printLog( "HasSubstates_e91" );
#endif
	_state_e98= &states_e94;
	_program_e99= &programs_e97;
	processInputPackets( states_e92, programs_e95);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasSubstates_e91::isInputUnique( const Udm::Object& state_e9e, const Udm::Object& program_ea7)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_ea0= _state_e9a.begin(), itProgram_ea9= _program_ea3.begin(); itState_ea0!= _state_e9a.end(), itProgram_ea9!= _program_ea3.end(); ++itState_ea0, ++itProgram_ea9)
	{
		if( ( *itState_ea0== state_e9e)&& ( *itProgram_ea9== program_ea7))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_e9a.push_back( state_e9e);
		_program_ea3.push_back( program_ea7);
	}
	return isUnique;
}

bool HasSubstates_e91::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool HasSubstates_e91::isGuardTrue( SFC::Program& Program, CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::State& SubState)
{
	bool Gz_guard= false;
	Gz_guard  = static_cast< std::string >( State.Decomposition() ) != "FUNC_STATE";;
	return Gz_guard;
}

void HasSubstates_e91::processInputPackets( const Packets_t& states_e92, const Packets_t& programs_e95)
{
	for( Packets_t::const_iterator itState_e9b= states_e92.begin(), itProgram_ea4= programs_e95.begin(); itState_e9b!= states_e92.end(), itProgram_ea4!= programs_e95.end(); ++itState_e9b, ++itProgram_ea4)
	{
		bool isUnique= isInputUnique( *itState_e9b, *itProgram_ea4);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_e9b, *itProgram_ea4);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_eb3, currMatch.program_eb4);
	}
}

bool HasSubstates_e91::patternMatcher( const Udm::Object& state_e9c, const Udm::Object& program_ea5)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_e9c.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_ea1= CyPhyML::SignalFlow::State::Cast( state_e9c);
		if( false== Uml::IsDerivedFrom( program_ea5.type(), SFC::Program::meta))
			continue;
		SFC::Program program_eaa= SFC::Program::Cast( program_ea5);
		set< CyPhyML::SignalFlow::State> subStates_eac= state_ea1.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itSubState_ead= subStates_eac.begin(); itSubState_ead!= subStates_eac.end(); ++itSubState_ead)
		{
			CyPhyML::SignalFlow::State currSubState_eae= *itSubState_ead;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_eb2;
			if( !isValidBound(boundObjs_eb2, state_ea1, true))
				continue;
			currMatch.state_eb3= state_ea1;
			if( !isValidBound(boundObjs_eb2, program_eaa, true))
				continue;
			currMatch.program_eb4= program_eaa;
			if( !isValidBound(boundObjs_eb2, currSubState_eae, false))
				continue;
			currMatch.subState_eb5= currSubState_eae;
			bool Gz_guard= isGuardTrue( currMatch.program_eb4, currMatch.state_eb3, currMatch.subState_eb5);
			if( true== Gz_guard)
			{
				_matches.push_back( currMatch);
				return true;
			}
		}
	}
	return !_matches.empty();
}

void HasSubstates_e91::outputAppender( const CyPhyML::SignalFlow::State& state_eb9, const SFC::Program& program_ebb)
{
	_state_e98->push_back( state_eb9);
	_program_e99->push_back( program_ebb);
}

bool Otherwise_ebd::operator()( const Packets_t& states_ebe, const Packets_t& programs_ec1, Packets_t& states_ec0, Packets_t& programs_ec3)
{
#ifdef PRINT_INFO
	printLog( "Otherwise_ebd" );
#endif
	_state_ec4= &states_ec0;
	_program_ec5= &programs_ec3;
	processInputPackets( states_ebe, programs_ec1);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_ebd::isInputUnique( const Udm::Object& state_eca, const Udm::Object& program_ed3)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_ecc= _state_ec6.begin(), itProgram_ed5= _program_ecf.begin(); itState_ecc!= _state_ec6.end(), itProgram_ed5!= _program_ecf.end(); ++itState_ecc, ++itProgram_ed5)
	{
		if( ( *itState_ecc== state_eca)&& ( *itProgram_ed5== program_ed3))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_ec6.push_back( state_eca);
		_program_ecf.push_back( program_ed3);
	}
	return isUnique;
}

bool Otherwise_ebd::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool Otherwise_ebd::isGuardTrue( SFC::Program& Program, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	string s = State.Decomposition();
Gz_guard = ( s.compare("FUNC_STATE") == 0 );;
	return Gz_guard;
}

void Otherwise_ebd::processInputPackets( const Packets_t& states_ebe, const Packets_t& programs_ec1)
{
	for( Packets_t::const_iterator itState_ec7= states_ebe.begin(), itProgram_ed0= programs_ec1.begin(); itState_ec7!= states_ebe.end(), itProgram_ed0!= programs_ec1.end(); ++itState_ec7, ++itProgram_ed0)
	{
		bool isUnique= isInputUnique( *itState_ec7, *itProgram_ed0);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_ec7, *itProgram_ed0);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_edc, currMatch.program_edd);
	}
}

bool Otherwise_ebd::patternMatcher( const Udm::Object& state_ec8, const Udm::Object& program_ed1)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_ec8.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_ecd= CyPhyML::SignalFlow::State::Cast( state_ec8);
		if( false== Uml::IsDerivedFrom( program_ed1.type(), SFC::Program::meta))
			continue;
		SFC::Program program_ed6= SFC::Program::Cast( program_ed1);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_edb;
		if( !isValidBound(boundObjs_edb, state_ecd, true))
			continue;
		currMatch.state_edc= state_ecd;
		if( !isValidBound(boundObjs_edb, program_ed6, true))
			continue;
		currMatch.program_edd= program_ed6;
		bool Gz_guard= isGuardTrue( currMatch.program_edd, currMatch.state_edc);
		if( true== Gz_guard)
		{
			_matches.push_back( currMatch);
			return true;
		}
	}
	return !_matches.empty();
}

void Otherwise_ebd::outputAppender( const CyPhyML::SignalFlow::State& state_ee0, const SFC::Program& program_ee2)
{
	_state_ec4->push_back( state_ee0);
	_program_ec5->push_back( program_ee2);
}

void CreateFuncStateFunctions_ef9::operator()( const Packets_t& states_efa, const Packets_t& programs_efc, Packets_t& states_efe, Packets_t& programs_eff)
{
#ifdef PRINT_INFO
	printLog( "CreateFuncStateFunctions_ef9" );
#endif
	_state_f00= &states_efe;
	_program_f01= &programs_eff;
	if( ( !states_efa.empty())&& ( !programs_efc.empty()))
		callPopulateGRFSFunction_104e( states_efa, programs_efc);
	_state_f00->insert( _state_f00->end(), states_efa.begin(), states_efa.end());
	_program_f01->insert( _program_f01->end(), programs_efc.begin(), programs_efc.end());
}

void CreateFuncStateFunctions_ef9::callPopulateGRFSFunction_104e( const Packets_t& states_1011, const Packets_t& programs_1013)
{
	Packets_t states_1015;
	Packets_t programs_1016;
	PopulateGRFSFunction_1010 populateGRFSFunction_1010;
	populateGRFSFunction_1010( states_1011, programs_1013, states_1015, programs_1016);
	if( ( !states_1015.empty())&& ( !programs_1016.empty()))
		callPopulateEMFSFunction_1051( states_1015, programs_1016);
}

void CreateFuncStateFunctions_ef9::callPopulateEMFSFunction_1051( const Packets_t& states_f03, const Packets_t& programs_f05)
{
	Packets_t states_f07;
	Packets_t programs_f08;
	PopulateEMFSFunction_f02 populateEMFSFunction_f02;
	populateEMFSFunction_f02( states_f03, programs_f05, states_f07, programs_f08);
	if( ( !states_f07.empty())&& ( !programs_f08.empty()))
		callGetSubStates_1054( states_f07, programs_f08);
}

void CreateFuncStateFunctions_ef9::callGetSubStates_1054( const Packets_t& states_c8c, const Packets_t& parStmnts_c8f)
{
	Packets_t subStates_c8e;
	Packets_t parStmnts_c91;
	GetSubStates_c8b getSubStates_c8b;
	getSubStates_c8b( states_c8c, parStmnts_c8f, subStates_c8e, parStmnts_c91);
	if( ( !subStates_c8e.empty())&& ( !parStmnts_c91.empty()))
		callPopulateGRFSFunction_104e( subStates_c8e, parStmnts_c91);
}

void PopulateEMFSFunction_f02::operator()( const Packets_t& states_f03, const Packets_t& programs_f05, Packets_t& states_f07, Packets_t& programs_f08)
{
#ifdef PRINT_INFO
	printLog( "PopulateEMFSFunction_f02" );
#endif
	_state_f09= &states_f07;
	_program_f0a= &programs_f08;
	_state_f09->insert( _state_f09->end(), states_f03.begin(), states_f03.end());
	_program_f0a->insert( _program_f0a->end(), programs_f05.begin(), programs_f05.end());
	if( ( !states_f03.empty())&& ( !programs_f05.empty()))
		callCreateEMFuncStateFunction_100a( states_f03, programs_f05);
}

void PopulateEMFSFunction_f02::callCreateEMFuncStateFunction_100a( const Packets_t& states_f0c, const Packets_t& programs_f0f)
{
	Packets_t states_f0e;
	Packets_t execs_f11;
	CreateEMFuncStateFunction_f0b createEMFuncStateFunction_f0b;
	createEMFuncStateFunction_f0b( states_f0c, programs_f0f, states_f0e, execs_f11);
	if( ( !states_f0e.empty())&& ( !execs_f11.empty()))
		callFuncArgsAndVars_100d( states_f0e, execs_f11);
}

void PopulateEMFSFunction_f02::callFuncArgsAndVars_100d( const Packets_t& states_f39, const Packets_t& fcns_f3b)
{
	Packets_t states_f3d;
	Packets_t fcns_f3e;
	FuncArgsAndVars_f38 funcArgsAndVars_f38;
	funcArgsAndVars_f38( states_f39, fcns_f3b, states_f3d, fcns_f3e);
}

void CreateEMFuncStateFunction_f0b::operator()( const Packets_t& states_f0c, const Packets_t& programs_f0f, Packets_t& states_f0e, Packets_t& execs_f11)
{
#ifdef PRINT_INFO
	printLog( "CreateEMFuncStateFunction_f0b" );
#endif
	RTTGenerator::Instance()->generateRule(187, "CreateEMFuncStateFunction");
	_state_f12= &states_f0e;
	_exec_f13= &execs_f11;
	processInputPackets( states_f0c, programs_f0f);
}

bool CreateEMFuncStateFunction_f0b::isInputUnique( const Udm::Object& state_f18, const Udm::Object& program_f21)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_f1a= _state_f14.begin(), itProgram_f23= _program_f1d.begin(); itState_f1a!= _state_f14.end(), itProgram_f23!= _program_f1d.end(); ++itState_f1a, ++itProgram_f23)
	{
		if( ( *itState_f1a== state_f18)&& ( *itProgram_f23== program_f21))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_f14.push_back( state_f18);
		_program_f1d.push_back( program_f21);
	}
	return isUnique;
}

bool CreateEMFuncStateFunction_f0b::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool CreateEMFuncStateFunction_f0b::isGuardTrue( SFC::Program& Program, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel)
{
	bool Gz_guard= false;
	Gz_guard =
 static_cast< std::string >( State.Decomposition() ) == "FUNC_STATE" &&
 static_cast< std::string >( State.Order() ) == "-2";;
	return Gz_guard;
}

void CreateEMFuncStateFunction_f0b::processInputPackets( const Packets_t& states_f0c, const Packets_t& programs_f0f)
{
	for( Packets_t::const_iterator itState_f15= states_f0c.begin(), itProgram_f1e= programs_f0f.begin(); itState_f15!= states_f0c.end(), itProgram_f1e!= programs_f0f.end(); ++itState_f15, ++itProgram_f1e)
	{
		bool isUnique= isInputUnique( *itState_f15, *itProgram_f1e);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_f15, *itProgram_f1e);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateEMFuncStateFunction_f0b::patternMatcher( const Udm::Object& state_f16, const Udm::Object& program_f1f)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_f16.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_f1b= CyPhyML::SignalFlow::State::Cast( state_f16);
		if( false== Uml::IsDerivedFrom( program_f1f.type(), SFC::Program::meta))
			continue;
		SFC::Program program_f24= SFC::Program::Cast( program_f1f);
		set< SFC::StateLabel> stateLabels_f26= state_f1b.src();
		for( set< SFC::StateLabel>::const_iterator itStateLabels_f27= stateLabels_f26.begin(); itStateLabels_f27!= stateLabels_f26.end(); ++itStateLabels_f27)
		{
			SFC::StateLabel currStateLabel_f28= *itStateLabels_f27;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_f2c;
			if( !isValidBound(boundObjs_f2c, state_f1b, true))
				continue;
			currMatch.state_f2d= state_f1b;
			if( !isValidBound(boundObjs_f2c, program_f24, true))
				continue;
			currMatch.program_f2e= program_f24;
			if( !isValidBound(boundObjs_f2c, currStateLabel_f28, false))
				continue;
			currMatch.stateLabel_f2f= currStateLabel_f28;
			bool Gz_guard= isGuardTrue( currMatch.program_f2e, currMatch.state_f2d, currMatch.stateLabel_f2f);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateEMFuncStateFunction_f0b::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function newExec_f33= SFC::Function::Create( currMatch.program_f2e, SFC::Program::meta_stmnt);
		SFC::Function& Exec= newExec_f33;
		SFC::Program& Program= currMatch.program_f2e;
		CyPhyML::SignalFlow::State& State= currMatch.state_f2d;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_f2f;
		{
Exec.RefId() = State.RefId();
};
		{
__int64 statementCount = Program.statementCount();
Exec.statementIndex() = statementCount++;
Program.statementCount() = statementCount;
};
		{
Exec.name() = State.name();
Exec.scope() = StateLabel.comment();

SFManager::FunctionArgMapManager::get_singleton().parseFunctionSpec( Exec, State.EnterAction() );

SFManager::AddTypedEntityScope( Exec );
};
		newExec_f33.execSt()+= currMatch.state_f2d;
		outputAppender( currMatch.state_f2d, newExec_f33);
	}
}

void CreateEMFuncStateFunction_f0b::outputAppender( const CyPhyML::SignalFlow::State& state_f34, const SFC::Function& exec_f36)
{
	_state_f12->push_back( state_f34);
	_exec_f13->push_back( exec_f36);
}

void FuncArgsAndVars_f38::operator()( const Packets_t& states_f39, const Packets_t& fcns_f3b, Packets_t& states_f3d, Packets_t& fcns_f3e)
{
#ifdef PRINT_INFO
	printLog( "FuncArgsAndVars_f38" );
#endif
	_state_f3f= &states_f3d;
	_fcn_f40= &fcns_f3e;
	if( ( !states_f39.empty())&& ( !fcns_f3b.empty()))
		callFuncInputArgs_1001( states_f39, fcns_f3b);
}

void FuncArgsAndVars_f38::callFuncInputArgs_1001( const Packets_t& states_f42, const Packets_t& fcns_f44)
{
	Packets_t states_f46;
	Packets_t fcns_f47;
	FuncInputArgs_f41 funcInputArgs_f41;
	funcInputArgs_f41( states_f42, fcns_f44, states_f46, fcns_f47);
	if( ( !states_f46.empty())&& ( !fcns_f47.empty()))
		callFuncOutputArgs_1004( states_f46, fcns_f47);
}

void FuncArgsAndVars_f38::callFuncOutputArgs_1004( const Packets_t& states_f80, const Packets_t& fcns_f82)
{
	Packets_t states_f84;
	Packets_t fcns_f85;
	FuncOutputArgs_f7f funcOutputArgs_f7f;
	funcOutputArgs_f7f( states_f80, fcns_f82, states_f84, fcns_f85);
	if( ( !states_f84.empty())&& ( !fcns_f85.empty()))
		callFuncLocalVars_1007( states_f84, fcns_f85);
}

void FuncArgsAndVars_f38::callFuncLocalVars_1007( const Packets_t& states_fc1, const Packets_t& fcns_fc3)
{
	Packets_t states_fc5;
	Packets_t fcns_fc6;
	FuncLocalVars_fc0 funcLocalVars_fc0;
	funcLocalVars_fc0( states_fc1, fcns_fc3, states_fc5, fcns_fc6);
	_state_f3f->insert( _state_f3f->end(), states_fc5.begin(), states_fc5.end());
	_fcn_f40->insert( _fcn_f40->end(), fcns_fc6.begin(), fcns_fc6.end());
}

void FuncInputArgs_f41::operator()( const Packets_t& states_f42, const Packets_t& fcns_f44, Packets_t& states_f46, Packets_t& fcns_f47)
{
#ifdef PRINT_INFO
	printLog( "FuncInputArgs_f41" );
#endif
	_state_f48= &states_f46;
	_fcn_f49= &fcns_f47;
	_state_f48->insert( _state_f48->end(), states_f42.begin(), states_f42.end());
	_fcn_f49->insert( _fcn_f49->end(), fcns_f44.begin(), fcns_f44.end());
	if( ( !states_f42.empty())&& ( !fcns_f44.empty()))
		callInputArgs_f7c( states_f42, fcns_f44);
}

void FuncInputArgs_f41::callInputArgs_f7c( const Packets_t& states_f4b, const Packets_t& execs_f4d)
{
	InputArgs_f4a inputArgs_f4a;
	inputArgs_f4a( states_f4b, execs_f4d);
}

void InputArgs_f4a::operator()( const Packets_t& states_f4b, const Packets_t& execs_f4d)
{
#ifdef PRINT_INFO
	printLog( "InputArgs_f4a" );
#endif
	RTTGenerator::Instance()->generateRule(230, "InputArgs");
	processInputPackets( states_f4b, execs_f4d);
}

bool InputArgs_f4a::isInputUnique( const Udm::Object& state_f53, const Udm::Object& exec_f5c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_f55= _state_f4f.begin(), itExec_f5e= _exec_f58.begin(); itState_f55!= _state_f4f.end(), itExec_f5e!= _exec_f58.end(); ++itState_f55, ++itExec_f5e)
	{
		if( ( *itState_f55== state_f53)&& ( *itExec_f5e== exec_f5c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_f4f.push_back( state_f53);
		_exec_f58.push_back( exec_f5c);
	}
	return isUnique;
}

bool InputArgs_f4a::isGuardTrue( SFC::DT& DT, CyPhyML::SignalFlow::Data& Data, SFC::Function& Exec, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel, CyPhyML::SignalFlow::SF_TypeBase& TypeBase, CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Data.Scope() ) == "INPUT_DATA";;
	return Gz_guard;
}

void InputArgs_f4a::processInputPackets( const Packets_t& states_f4b, const Packets_t& execs_f4d)
{
	for( Packets_t::const_iterator itState_f50= states_f4b.begin(), itExec_f59= execs_f4d.begin(); itState_f50!= states_f4b.end(), itExec_f59!= execs_f4d.end(); ++itState_f50, ++itExec_f59)
	{
		bool isUnique= isInputUnique( *itState_f50, *itExec_f59);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_f50, *itExec_f59);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InputArgs_f4a::patternMatcher( const Udm::Object& state_f51, const Udm::Object& exec_f5a)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_f51.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_f56= CyPhyML::SignalFlow::State::Cast( state_f51);
		if( false== Uml::IsDerivedFrom( exec_f5a.type(), SFC::Function::meta))
			continue;
		SFC::Function exec_f5f= SFC::Function::Cast( exec_f5a);
		set< CyPhyML::SignalFlow::Data> datas_f61= state_f56.Data_kind_children();
		for( set< CyPhyML::SignalFlow::Data>::const_iterator itData_f62= datas_f61.begin(); itData_f62!= datas_f61.end(); ++itData_f62)
		{
			CyPhyML::SignalFlow::Data currData_f63= *itData_f62;
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_f64= currData_f63.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_f65= typeBaseRefs_f64.begin(); itTypeBaseRef_f65!= typeBaseRefs_f64.end(); ++itTypeBaseRef_f65)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_f66= *itTypeBaseRef_f65;
				set< SFC::StateLabel> stateLabels_f67= state_f56.src();
				for( set< SFC::StateLabel>::const_iterator itStateLabels_f68= stateLabels_f67.begin(); itStateLabels_f68!= stateLabels_f67.end(); ++itStateLabels_f68)
				{
					SFC::StateLabel currStateLabel_f69= *itStateLabels_f68;
					CyPhyML::SignalFlow::SF_TypeBase typeBase_f6a= currTypeBaseRef_f66.ref();
					if( !typeBase_f6a)
						continue;
					SFC::DT dT_f6b= typeBase_f6a.dt();
					if( !dT_f6b)
						continue;
					Match currMatch;
					currMatch.state_f6d= state_f56;
					currMatch.exec_f6e= exec_f5f;
					currMatch.stateLabel_f6f= currStateLabel_f69;
					currMatch.data_f70= currData_f63;
					currMatch.typeBaseRef_f71= currTypeBaseRef_f66;
					currMatch.typeBase_f72= typeBase_f6a;
					currMatch.dT_f73= dT_f6b;
					bool Gz_guard= isGuardTrue( currMatch.dT_f73, currMatch.data_f70, currMatch.exec_f6e, currMatch.state_f6d, currMatch.stateLabel_f6f, currMatch.typeBase_f72, currMatch.typeBaseRef_f71);
					if( true== Gz_guard)
						_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void InputArgs_f4a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_f7b= SFC::Arg::Create( currMatch.exec_f6e);
		SFC::Arg& Arg= newArg_f7b;
		SFC::DT& DT= currMatch.dT_f73;
		CyPhyML::SignalFlow::Data& Data= currMatch.data_f70;
		SFC::Function& Exec= currMatch.exec_f6e;
		CyPhyML::SignalFlow::State& State= currMatch.state_f6d;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_f6f;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_f72;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_f71;
		{
Arg.RefId() = Data.RefId();
};
		{
std::string name = Data.name();
Arg.name() = name;
Arg.scope() = StateLabel.comment(); /* comment contains the extend state name */
Arg.argIndex() = SFManager::FunctionArgMapManager::get_singleton().getArgNo( Exec, name );
Arg.indexBase() = Data.ArrayFirstIndex();

Exec.argCount() = Exec.argCount() + 1;

SFManager::AddTypedEntityScope( Arg );
};
		newArg_f7b.dt()= currMatch.dT_f73;
	}
}

void FuncOutputArgs_f7f::operator()( const Packets_t& states_f80, const Packets_t& fcns_f82, Packets_t& states_f84, Packets_t& fcns_f85)
{
#ifdef PRINT_INFO
	printLog( "FuncOutputArgs_f7f" );
#endif
	_state_f86= &states_f84;
	_fcn_f87= &fcns_f85;
	_state_f86->insert( _state_f86->end(), states_f80.begin(), states_f80.end());
	_fcn_f87->insert( _fcn_f87->end(), fcns_f82.begin(), fcns_f82.end());
	if( ( !states_f80.empty())&& ( !fcns_f82.empty()))
		callOutputArgs_fbd( states_f80, fcns_f82);
}

void FuncOutputArgs_f7f::callOutputArgs_fbd( const Packets_t& states_f89, const Packets_t& execs_f8b)
{
	OutputArgs_f88 outputArgs_f88;
	outputArgs_f88( states_f89, execs_f8b);
}

void OutputArgs_f88::operator()( const Packets_t& states_f89, const Packets_t& execs_f8b)
{
#ifdef PRINT_INFO
	printLog( "OutputArgs_f88" );
#endif
	RTTGenerator::Instance()->generateRule(253, "OutputArgs");
	processInputPackets( states_f89, execs_f8b);
}

bool OutputArgs_f88::isInputUnique( const Udm::Object& state_f91, const Udm::Object& exec_f9a)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_f93= _state_f8d.begin(), itExec_f9c= _exec_f96.begin(); itState_f93!= _state_f8d.end(), itExec_f9c!= _exec_f96.end(); ++itState_f93, ++itExec_f9c)
	{
		if( ( *itState_f93== state_f91)&& ( *itExec_f9c== exec_f9a))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_f8d.push_back( state_f91);
		_exec_f96.push_back( exec_f9a);
	}
	return isUnique;
}

bool OutputArgs_f88::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool OutputArgs_f88::isGuardTrue( SFC::DT& DT, CyPhyML::SignalFlow::Data& Data, SFC::Function& Exec, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel, CyPhyML::SignalFlow::SF_TypeBase& TypeBase, CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Data.Scope() ) == "OUTPUT_DATA";;
	return Gz_guard;
}

void OutputArgs_f88::processInputPackets( const Packets_t& states_f89, const Packets_t& execs_f8b)
{
	for( Packets_t::const_iterator itState_f8e= states_f89.begin(), itExec_f97= execs_f8b.begin(); itState_f8e!= states_f89.end(), itExec_f97!= execs_f8b.end(); ++itState_f8e, ++itExec_f97)
	{
		bool isUnique= isInputUnique( *itState_f8e, *itExec_f97);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_f8e, *itExec_f97);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool OutputArgs_f88::patternMatcher( const Udm::Object& state_f8f, const Udm::Object& exec_f98)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_f8f.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_f94= CyPhyML::SignalFlow::State::Cast( state_f8f);
		if( false== Uml::IsDerivedFrom( exec_f98.type(), SFC::Function::meta))
			continue;
		SFC::Function exec_f9d= SFC::Function::Cast( exec_f98);
		set< CyPhyML::SignalFlow::Data> datas_f9f= state_f94.Data_kind_children();
		for( set< CyPhyML::SignalFlow::Data>::const_iterator itData_fa0= datas_f9f.begin(); itData_fa0!= datas_f9f.end(); ++itData_fa0)
		{
			CyPhyML::SignalFlow::Data currData_fa1= *itData_fa0;
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_fa2= currData_fa1.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_fa3= typeBaseRefs_fa2.begin(); itTypeBaseRef_fa3!= typeBaseRefs_fa2.end(); ++itTypeBaseRef_fa3)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_fa4= *itTypeBaseRef_fa3;
				set< SFC::StateLabel> stateLabels_fa5= state_f94.src();
				for( set< SFC::StateLabel>::const_iterator itStateLabels_fa6= stateLabels_fa5.begin(); itStateLabels_fa6!= stateLabels_fa5.end(); ++itStateLabels_fa6)
				{
					SFC::StateLabel currStateLabel_fa7= *itStateLabels_fa6;
					CyPhyML::SignalFlow::SF_TypeBase typeBase_fa8= currTypeBaseRef_fa4.ref();
					if( !typeBase_fa8)
						continue;
					SFC::DT dT_fa9= typeBase_fa8.dt();
					if( !dT_fa9)
						continue;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_fad;
					if( !isValidBound(boundObjs_fad, state_f94, true))
						continue;
					currMatch.state_fae= state_f94;
					if( !isValidBound(boundObjs_fad, exec_f9d, true))
						continue;
					currMatch.exec_faf= exec_f9d;
					if( !isValidBound(boundObjs_fad, currStateLabel_fa7, false))
						continue;
					currMatch.stateLabel_fb0= currStateLabel_fa7;
					if( !isValidBound(boundObjs_fad, currData_fa1, false))
						continue;
					currMatch.data_fb1= currData_fa1;
					if( !isValidBound(boundObjs_fad, currTypeBaseRef_fa4, false))
						continue;
					currMatch.typeBaseRef_fb2= currTypeBaseRef_fa4;
					if( !isValidBound(boundObjs_fad, typeBase_fa8, false))
						continue;
					currMatch.typeBase_fb3= typeBase_fa8;
					if( !isValidBound(boundObjs_fad, dT_fa9, false))
						continue;
					currMatch.dT_fb4= dT_fa9;
					bool Gz_guard= isGuardTrue( currMatch.dT_fb4, currMatch.data_fb1, currMatch.exec_faf, currMatch.state_fae, currMatch.stateLabel_fb0, currMatch.typeBase_fb3, currMatch.typeBaseRef_fb2);
					if( true== Gz_guard)
						_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void OutputArgs_f88::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_fbc= SFC::Arg::Create( currMatch.exec_faf);
		SFC::Arg& Arg= newArg_fbc;
		SFC::DT& DT= currMatch.dT_fb4;
		CyPhyML::SignalFlow::Data& Data= currMatch.data_fb1;
		SFC::Function& Exec= currMatch.exec_faf;
		CyPhyML::SignalFlow::State& State= currMatch.state_fae;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_fb0;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_fb3;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_fb2;
		{
Arg.RefId() = Data.RefId();
};
		{
std::string name = Data.name();
Arg.name() = name;
Arg.scope() = StateLabel.comment(); /* comment contains the extend state name */
Arg.argIndex() = SFManager::FunctionArgMapManager::get_singleton().getArgNo( Exec, name );
Arg.indexBase() = Data.ArrayFirstIndex();
Arg.ptr() = true;

Exec.argCount() = Exec.argCount() + 1;

SFManager::AddTypedEntityScope( Arg );
};
		newArg_fbc.dt()= currMatch.dT_fb4;
	}
}

void FuncLocalVars_fc0::operator()( const Packets_t& states_fc1, const Packets_t& fcns_fc3, Packets_t& states_fc5, Packets_t& fcns_fc6)
{
#ifdef PRINT_INFO
	printLog( "FuncLocalVars_fc0" );
#endif
	_state_fc7= &states_fc5;
	_fcn_fc8= &fcns_fc6;
	if( ( !states_fc1.empty())&& ( !fcns_fc3.empty()))
		callFuncLocalVars_ffe( states_fc1, fcns_fc3);
	_state_fc7->insert( _state_fc7->end(), states_fc1.begin(), states_fc1.end());
	_fcn_fc8->insert( _fcn_fc8->end(), fcns_fc3.begin(), fcns_fc3.end());
}

void FuncLocalVars_fc0::callFuncLocalVars_ffe( const Packets_t& states_fca, const Packets_t& execs_fcc)
{
	FuncLocalVars_fc9 funcLocalVars_fc9;
	funcLocalVars_fc9( states_fca, execs_fcc);
}

void FuncLocalVars_fc9::operator()( const Packets_t& states_fca, const Packets_t& execs_fcc)
{
#ifdef PRINT_INFO
	printLog( "FuncLocalVars_fc9" );
#endif
	RTTGenerator::Instance()->generateRule(276, "FuncLocalVars");
	processInputPackets( states_fca, execs_fcc);
}

bool FuncLocalVars_fc9::isInputUnique( const Udm::Object& state_fd2, const Udm::Object& exec_fdb)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_fd4= _state_fce.begin(), itExec_fdd= _exec_fd7.begin(); itState_fd4!= _state_fce.end(), itExec_fdd!= _exec_fd7.end(); ++itState_fd4, ++itExec_fdd)
	{
		if( ( *itState_fd4== state_fd2)&& ( *itExec_fdd== exec_fdb))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_fce.push_back( state_fd2);
		_exec_fd7.push_back( exec_fdb);
	}
	return isUnique;
}

bool FuncLocalVars_fc9::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool FuncLocalVars_fc9::isGuardTrue( SFC::DT& DT, CyPhyML::SignalFlow::Data& Data, SFC::Function& Exec, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel, CyPhyML::SignalFlow::SF_TypeBase& TypeBase, CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef)
{
	bool Gz_guard= false;
	std::string scope = Data.Scope();
Gz_guard = scope != "INPUT_DATA" && scope != "OUTPUT_DATA";;
	return Gz_guard;
}

void FuncLocalVars_fc9::processInputPackets( const Packets_t& states_fca, const Packets_t& execs_fcc)
{
	for( Packets_t::const_iterator itState_fcf= states_fca.begin(), itExec_fd8= execs_fcc.begin(); itState_fcf!= states_fca.end(), itExec_fd8!= execs_fcc.end(); ++itState_fcf, ++itExec_fd8)
	{
		bool isUnique= isInputUnique( *itState_fcf, *itExec_fd8);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_fcf, *itExec_fd8);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool FuncLocalVars_fc9::patternMatcher( const Udm::Object& state_fd0, const Udm::Object& exec_fd9)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_fd0.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_fd5= CyPhyML::SignalFlow::State::Cast( state_fd0);
		if( false== Uml::IsDerivedFrom( exec_fd9.type(), SFC::Function::meta))
			continue;
		SFC::Function exec_fde= SFC::Function::Cast( exec_fd9);
		set< CyPhyML::SignalFlow::Data> datas_fe0= state_fd5.Data_kind_children();
		for( set< CyPhyML::SignalFlow::Data>::const_iterator itData_fe1= datas_fe0.begin(); itData_fe1!= datas_fe0.end(); ++itData_fe1)
		{
			CyPhyML::SignalFlow::Data currData_fe2= *itData_fe1;
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_fe3= currData_fe2.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_fe4= typeBaseRefs_fe3.begin(); itTypeBaseRef_fe4!= typeBaseRefs_fe3.end(); ++itTypeBaseRef_fe4)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_fe5= *itTypeBaseRef_fe4;
				CyPhyML::SignalFlow::SF_TypeBase typeBase_fe6= currTypeBaseRef_fe5.ref();
				if( !typeBase_fe6)
					continue;
				SFC::DT dT_fe7= typeBase_fe6.dt();
				if( !dT_fe7)
					continue;
				set< SFC::StateLabel> stateLabels_fe8= state_fd5.src();
				for( set< SFC::StateLabel>::const_iterator itStateLabels_fe9= stateLabels_fe8.begin(); itStateLabels_fe9!= stateLabels_fe8.end(); ++itStateLabels_fe9)
				{
					SFC::StateLabel currStateLabel_fea= *itStateLabels_fe9;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_fee;
					if( !isValidBound(boundObjs_fee, state_fd5, true))
						continue;
					currMatch.state_fef= state_fd5;
					if( !isValidBound(boundObjs_fee, exec_fde, true))
						continue;
					currMatch.exec_ff0= exec_fde;
					if( !isValidBound(boundObjs_fee, currStateLabel_fea, false))
						continue;
					currMatch.stateLabel_ff1= currStateLabel_fea;
					if( !isValidBound(boundObjs_fee, currData_fe2, false))
						continue;
					currMatch.data_ff2= currData_fe2;
					if( !isValidBound(boundObjs_fee, currTypeBaseRef_fe5, false))
						continue;
					currMatch.typeBaseRef_ff3= currTypeBaseRef_fe5;
					if( !isValidBound(boundObjs_fee, typeBase_fe6, false))
						continue;
					currMatch.typeBase_ff4= typeBase_fe6;
					if( !isValidBound(boundObjs_fee, dT_fe7, false))
						continue;
					currMatch.dT_ff5= dT_fe7;
					bool Gz_guard= isGuardTrue( currMatch.dT_ff5, currMatch.data_ff2, currMatch.exec_ff0, currMatch.state_fef, currMatch.stateLabel_ff1, currMatch.typeBase_ff4, currMatch.typeBaseRef_ff3);
					if( true== Gz_guard)
						_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void FuncLocalVars_fc9::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar newLocalVar_ffd= SFC::LocalVar::Create( currMatch.exec_ff0, SFC::Function::meta_stmnt);
		SFC::DT& DT= currMatch.dT_ff5;
		CyPhyML::SignalFlow::Data& Data= currMatch.data_ff2;
		SFC::Function& Exec= currMatch.exec_ff0;
		SFC::LocalVar& LocalVar= newLocalVar_ffd;
		CyPhyML::SignalFlow::State& State= currMatch.state_fef;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_ff1;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_ff4;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_ff3;
		{
LocalVar.RefId() = Data.RefId();
};
		{
std::string dataName = Data.Name();
if(dataName.empty())
	dataName = Data.name();
LocalVar.name() = dataName;
LocalVar.scope() = StateLabel.comment(); /* comment contains the extend state name */
LocalVar.initial() = Data.InitialValue();
LocalVar.indexBase() = Data.ArrayFirstIndex();

SFManager::AddTypedEntityScope( LocalVar );
};
		{
__int64 statementCount = Exec.statementCount();
LocalVar.statementIndex() = statementCount++;
Exec.statementCount() = statementCount;
};
		newLocalVar_ffd.dt()= currMatch.dT_ff5;
	}
}

void PopulateGRFSFunction_1010::operator()( const Packets_t& states_1011, const Packets_t& programs_1013, Packets_t& states_1015, Packets_t& programs_1016)
{
#ifdef PRINT_INFO
	printLog( "PopulateGRFSFunction_1010" );
#endif
	_state_1017= &states_1015;
	_program_1018= &programs_1016;
	if( ( !states_1011.empty())&& ( !programs_1013.empty()))
		callCreateGRFuncStateFunction_1048( states_1011, programs_1013);
	_state_1017->insert( _state_1017->end(), states_1011.begin(), states_1011.end());
	_program_1018->insert( _program_1018->end(), programs_1013.begin(), programs_1013.end());
}

void PopulateGRFSFunction_1010::callCreateGRFuncStateFunction_1048( const Packets_t& states_101a, const Packets_t& programs_101d)
{
	Packets_t states_101c;
	Packets_t execs_101f;
	CreateGRFuncStateFunction_1019 createGRFuncStateFunction_1019;
	createGRFuncStateFunction_1019( states_101a, programs_101d, states_101c, execs_101f);
	if( ( !states_101c.empty())&& ( !execs_101f.empty()))
		callFuncArgsAndVars_104b( states_101c, execs_101f);
}

void PopulateGRFSFunction_1010::callFuncArgsAndVars_104b( const Packets_t& states_f39, const Packets_t& fcns_f3b)
{
	Packets_t states_f3d;
	Packets_t fcns_f3e;
	FuncArgsAndVars_f38 funcArgsAndVars_f38;
	funcArgsAndVars_f38( states_f39, fcns_f3b, states_f3d, fcns_f3e);
}

void CreateGRFuncStateFunction_1019::operator()( const Packets_t& states_101a, const Packets_t& programs_101d, Packets_t& states_101c, Packets_t& execs_101f)
{
#ifdef PRINT_INFO
	printLog( "CreateGRFuncStateFunction_1019" );
#endif
	RTTGenerator::Instance()->generateRule(203, "CreateGRFuncStateFunction");
	_state_1020= &states_101c;
	_exec_1021= &execs_101f;
	processInputPackets( states_101a, programs_101d);
}

bool CreateGRFuncStateFunction_1019::isInputUnique( const Udm::Object& state_1026, const Udm::Object& program_102f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1028= _state_1022.begin(), itProgram_1031= _program_102b.begin(); itState_1028!= _state_1022.end(), itProgram_1031!= _program_102b.end(); ++itState_1028, ++itProgram_1031)
	{
		if( ( *itState_1028== state_1026)&& ( *itProgram_1031== program_102f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1022.push_back( state_1026);
		_program_102b.push_back( program_102f);
	}
	return isUnique;
}

bool CreateGRFuncStateFunction_1019::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool CreateGRFuncStateFunction_1019::isGuardTrue( SFC::Program& Program, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel)
{
	bool Gz_guard= false;
	Gz_guard =
 static_cast< std::string >( State.Decomposition() ) == "FUNC_STATE" &&
 static_cast< std::string >( State.Order() ) == "-1";;
	return Gz_guard;
}

void CreateGRFuncStateFunction_1019::processInputPackets( const Packets_t& states_101a, const Packets_t& programs_101d)
{
	for( Packets_t::const_iterator itState_1023= states_101a.begin(), itProgram_102c= programs_101d.begin(); itState_1023!= states_101a.end(), itProgram_102c!= programs_101d.end(); ++itState_1023, ++itProgram_102c)
	{
		bool isUnique= isInputUnique( *itState_1023, *itProgram_102c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1023, *itProgram_102c);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateGRFuncStateFunction_1019::patternMatcher( const Udm::Object& state_1024, const Udm::Object& program_102d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1024.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1029= CyPhyML::SignalFlow::State::Cast( state_1024);
		if( false== Uml::IsDerivedFrom( program_102d.type(), SFC::Program::meta))
			continue;
		SFC::Program program_1032= SFC::Program::Cast( program_102d);
		set< SFC::StateLabel> stateLabels_1034= state_1029.src();
		for( set< SFC::StateLabel>::const_iterator itStateLabels_1035= stateLabels_1034.begin(); itStateLabels_1035!= stateLabels_1034.end(); ++itStateLabels_1035)
		{
			SFC::StateLabel currStateLabel_1036= *itStateLabels_1035;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_103a;
			if( !isValidBound(boundObjs_103a, state_1029, true))
				continue;
			currMatch.state_103b= state_1029;
			if( !isValidBound(boundObjs_103a, program_1032, true))
				continue;
			currMatch.program_103c= program_1032;
			if( !isValidBound(boundObjs_103a, currStateLabel_1036, false))
				continue;
			currMatch.stateLabel_103d= currStateLabel_1036;
			bool Gz_guard= isGuardTrue( currMatch.program_103c, currMatch.state_103b, currMatch.stateLabel_103d);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateGRFuncStateFunction_1019::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function newExec_1041= SFC::Function::Create( currMatch.program_103c, SFC::Program::meta_stmnt);
		SFC::LocalVar newExecTCVar_1042= SFC::LocalVar::Create( newExec_1041, SFC::Function::meta_stmnt);
		SFC::LocalVar newExecHTPVar_1043= SFC::LocalVar::Create( newExec_1041, SFC::Function::meta_stmnt);
		SFC::Function& Exec= newExec_1041;
		SFC::LocalVar& ExecHTPVar= newExecHTPVar_1043;
		SFC::LocalVar& ExecTCVar= newExecTCVar_1042;
		SFC::Program& Program= currMatch.program_103c;
		CyPhyML::SignalFlow::State& State= currMatch.state_103b;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_103d;
		{
Exec.RefId() = ExecHTPVar.RefId() = ExecTCVar.RefId() = State.RefId();
};
		{
ExecHTPVar.name() = "_HTPVar_";
ExecHTPVar.dt() = SFCTypesManager::getSingleton().getBasicType( "int32" );
ExecTCVar.name() = "_TCVar_";
ExecTCVar.dt() = SFCTypesManager::getSingleton().getBasicType( "int32" );
};
		{
__int64 statementCount = Exec.statementCount();
ExecTCVar.statementIndex() = statementCount++;
ExecHTPVar.statementIndex() = statementCount++;
Exec.statementCount() = statementCount;
};
		{
Exec.name() = State.name();
Exec.scope() = StateLabel.comment();

SFManager::FunctionArgMapManager::get_singleton().parseFunctionSpec( Exec, State.EnterAction() );

SFManager::AddTypedEntityScope( Exec );
};
		{
__int64 statementCount = Program.statementCount();
Exec.statementIndex() = statementCount++;
Program.statementCount() = statementCount;
};
		newExec_1041.execSt()+= currMatch.state_103b;
		outputAppender( currMatch.state_103b, newExec_1041);
	}
}

void CreateGRFuncStateFunction_1019::outputAppender( const CyPhyML::SignalFlow::State& state_1044, const SFC::Function& exec_1046)
{
	_state_1020->push_back( state_1044);
	_exec_1021->push_back( exec_1046);
}

void PopulateFunctions_1057::operator()( const Packets_t& states_1058, const Packets_t& programs_105a, Packets_t& states_105c, Packets_t& programs_105d)
{
#ifdef PRINT_INFO
	printLog( "PopulateFunctions_1057" );
#endif
	_state_105e= &states_105c;
	_program_105f= &programs_105d;
	if( ( !states_1058.empty())&& ( !programs_105a.empty()))
		callNoFunctionStates_1f41( states_1058, programs_105a);
	_state_105e->insert( _state_105e->end(), states_1058.begin(), states_1058.end());
	_program_105f->insert( _program_105f->end(), programs_105a.begin(), programs_105a.end());
}

void PopulateFunctions_1057::callNoFunctionStates_1f41( const Packets_t& states_1309, const Packets_t& programs_130b)
{
	Packets_t states_130d;
	Packets_t programs_130e;
	NoFunctionStates_1308 noFunctionStates_1308;
	noFunctionStates_1308( states_1309, programs_130b, states_130d, programs_130e);
	if( ( !states_130d.empty())&& ( !programs_130e.empty()))
		callPopulateEnterFunction_1f44( states_130d, programs_130e);
}

void PopulateFunctions_1057::callPopulateEnterFunction_1f44( const Packets_t& states_1c16, const Packets_t& programs_1c18)
{
	Packets_t states_1c1a;
	Packets_t programs_1c1b;
	PopulateEnterFunction_1c15 populateEnterFunction_1c15;
	populateEnterFunction_1c15( states_1c16, programs_1c18, states_1c1a, programs_1c1b);
	if( ( !states_1c1a.empty())&& ( !programs_1c1b.empty()))
		callPopulateExecFunction_1f47( states_1c1a, programs_1c1b);
}

void PopulateFunctions_1057::callPopulateExecFunction_1f47( const Packets_t& states_1347, const Packets_t& programs_1349)
{
	Packets_t states_134b;
	Packets_t programs_134c;
	PopulateExecFunction_1346 populateExecFunction_1346;
	populateExecFunction_1346( states_1347, programs_1349, states_134b, programs_134c);
	if( ( !states_134b.empty())&& ( !programs_134c.empty()))
		callPopulateExitFunction_1f4a( states_134b, programs_134c);
}

void PopulateFunctions_1057::callPopulateExitFunction_1f4a( const Packets_t& states_19ef, const Packets_t& programs_19f1)
{
	Packets_t states_19f3;
	Packets_t programs_19f4;
	PopulateExitFunction_19ee populateExitFunction_19ee;
	populateExitFunction_19ee( states_19ef, programs_19f1, states_19f3, programs_19f4);
	if( ( !states_19f3.empty())&& ( !programs_19f4.empty()))
		callPopulateStatusFunction_1f4d( states_19f3, programs_19f4);
}

void PopulateFunctions_1057::callPopulateStatusFunction_1f4d( const Packets_t& states_1061, const Packets_t& programs_1063)
{
	Packets_t states_1065;
	Packets_t programs_1066;
	PopulateStatusFunction_1060 populateStatusFunction_1060;
	populateStatusFunction_1060( states_1061, programs_1063, states_1065, programs_1066);
	if( ( !states_1065.empty())&& ( !programs_1066.empty()))
		callGetSubStates_1f50( states_1065, programs_1066);
}

void PopulateFunctions_1057::callGetSubStates_1f50( const Packets_t& states_c8c, const Packets_t& parStmnts_c8f)
{
	Packets_t subStates_c8e;
	Packets_t parStmnts_c91;
	GetSubStates_c8b getSubStates_c8b;
	getSubStates_c8b( states_c8c, parStmnts_c8f, subStates_c8e, parStmnts_c91);
	if( ( !subStates_c8e.empty())&& ( !parStmnts_c91.empty()))
		callNoFunctionStates_1f41( subStates_c8e, parStmnts_c91);
}

void PopulateStatusFunction_1060::operator()( const Packets_t& states_1061, const Packets_t& programs_1063, Packets_t& states_1065, Packets_t& programs_1066)
{
#ifdef PRINT_INFO
	printLog( "PopulateStatusFunction_1060" );
#endif
	_state_1067= &states_1065;
	_program_1068= &programs_1066;
	_state_1067->insert( _state_1067->end(), states_1061.begin(), states_1061.end());
	_program_1068->insert( _program_1068->end(), programs_1063.begin(), programs_1063.end());
	if( ( !states_1061.empty()))
		callGetStatusFunction_12ea( states_1061);
}

void PopulateStatusFunction_1060::callGetStatusFunction_12ea( const Packets_t& states_12c3)
{
	Packets_t states_12c5;
	Packets_t statuss_12c6;
	GetStatusFunction_12c2 getStatusFunction_12c2;
	getStatusFunction_12c2( states_12c3, states_12c5, statuss_12c6);
	if( ( !states_12c5.empty())&& ( !statuss_12c6.empty()))
		callHasChildren_12ec( states_12c5, statuss_12c6);
}

void PopulateStatusFunction_1060::callHasChildren_12ec( const Packets_t& states_1089, const Packets_t& statuss_108b)
{
	Packets_t states_108d;
	Packets_t statuss_108e;
	Packets_t states_108f;
	Packets_t statuss_1090;
	HasChildren_1088 hasChildren_1088;
	hasChildren_1088( states_1089, statuss_108b, states_108d, statuss_108e, states_108f, statuss_1090);
	if( ( !states_108f.empty())&& ( !statuss_1090.empty()))
		callElimState_12ef( states_108f, statuss_1090);
	if( ( !states_108d.empty())&& ( !statuss_108e.empty()))
		callnewIndent_12f2( states_108d, statuss_108e);
}

void PopulateStatusFunction_1060::callElimState_12ef( const Packets_t& states_106a, const Packets_t& statuss_106c)
{
	Packets_t statuss_106e;
	ElimState_1069 elimState_1069;
	elimState_1069( states_106a, statuss_106c, statuss_106e);
	if( ( !statuss_106e.empty()))
		callReturnValue_12f5( statuss_106e);
}

void PopulateStatusFunction_1060::callnewIndent_12f2( const Packets_t& states_10f5, const Packets_t& statuss_10f8)
{
	Packets_t states_10f7;
	Packets_t statuss_10fa;
	Packets_t stateVars_10fb;
	NewIndent_10f4 newIndent_10f4;
	newIndent_10f4( states_10f5, statuss_10f8, states_10f7, statuss_10fa, stateVars_10fb);
	if( ( !states_10f7.empty())&& ( !statuss_10fa.empty())&& ( !stateVars_10fb.empty()))
		callDecompTest_12f7( states_10f7, statuss_10fa, stateVars_10fb);
}

void PopulateStatusFunction_1060::callReturnValue_12f5( const Packets_t& statuss_1130)
{
	ReturnValue_112f returnValue_112f;
	returnValue_112f( statuss_1130);
}

void PopulateStatusFunction_1060::callDecompTest_12f7( const Packets_t& states_11ae, const Packets_t& statuss_11b0, const Packets_t& svs_11b2)
{
	Packets_t states_11b4;
	Packets_t statuss_11b5;
	Packets_t svs_11b6;
	Packets_t states_11b7;
	Packets_t statuss_11b8;
	Packets_t svs_11b9;
	DecompTest_11ad decompTest_11ad;
	decompTest_11ad( states_11ae, statuss_11b0, svs_11b2, states_11b4, statuss_11b5, svs_11b6, states_11b7, statuss_11b8, svs_11b9);
	if( ( !states_11b4.empty())&& ( !statuss_11b5.empty())&& ( !svs_11b6.empty()))
		callGetChildStates_12fb( states_11b4, statuss_11b5, svs_11b6);
	if( ( !states_11b7.empty())&& ( !statuss_11b8.empty())&& ( !svs_11b9.empty()))
		callCreateConditionalGroup_12ff( states_11b7, statuss_11b8, svs_11b9);
}

void PopulateStatusFunction_1060::callGetChildStates_12fb( const Packets_t& states_1250, const Packets_t& compoundStatements_1254, const Packets_t& stateVars_1257)
{
	Packets_t states_1252;
	Packets_t childStates_1253;
	Packets_t compoundStatements_1256;
	Packets_t stateVars_1259;
	GetChildStates_124f getChildStates_124f;
	getChildStates_124f( states_1250, compoundStatements_1254, stateVars_1257, states_1252, childStates_1253, compoundStatements_1256, stateVars_1259);
	if( ( !states_1252.empty())&& ( !childStates_1253.empty())&& ( !compoundStatements_1256.empty())&& ( !stateVars_1259.empty()))
		callCreateConditionals_1303( states_1252, childStates_1253, compoundStatements_1256, stateVars_1259);
}

void PopulateStatusFunction_1060::callCreateConditionalGroup_12ff( const Packets_t& states_128d, const Packets_t& statuss_1290, const Packets_t& stateVars_1293)
{
	Packets_t states_128f;
	Packets_t conditionalGroups_1292;
	Packets_t stateVars_1295;
	CreateConditionalGroup_128c createConditionalGroup_128c;
	createConditionalGroup_128c( states_128d, statuss_1290, stateVars_1293, states_128f, conditionalGroups_1292, stateVars_1295);
	if( ( !states_128f.empty())&& ( !conditionalGroups_1292.empty())&& ( !stateVars_1295.empty()))
		callGetChildStates_12fb( states_128f, conditionalGroups_1292, stateVars_1295);
}

void PopulateStatusFunction_1060::callCreateConditionals_1303( const Packets_t& states_1149, const Packets_t& childStates_114c, const Packets_t& compoundStatements_114e, const Packets_t& stateVars_1150)
{
	Packets_t statuss_114b;
	CreateConditionals_1148 createConditionals_1148;
	createConditionals_1148( states_1149, childStates_114c, compoundStatements_114e, stateVars_1150, statuss_114b);
	if( ( !statuss_114b.empty()))
		callReturnValue_12f5( statuss_114b);
}

void ElimState_1069::operator()( const Packets_t& states_106a, const Packets_t& statuss_106c, Packets_t& statuss_106e)
{
#ifdef PRINT_INFO
	printLog( "ElimState_1069" );
#endif
	RTTGenerator::Instance()->generateRule(305, "ElimState");
	_status_106f= &statuss_106e;
	processInputPackets( states_106a, statuss_106c);
	forwardInputs( );
}

bool ElimState_1069::isInputUnique( const Udm::Object& state_1074, const Udm::Object& status_107d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1076= _state_1070.begin(), itStatus_107f= _status_1079.begin(); itState_1076!= _state_1070.end(), itStatus_107f!= _status_1079.end(); ++itState_1076, ++itStatus_107f)
	{
		if( ( *itState_1076== state_1074)&& ( *itStatus_107f== status_107d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1070.push_back( state_1074);
		_status_1079.push_back( status_107d);
	}
	return isUnique;
}

bool ElimState_1069::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void ElimState_1069::processInputPackets( const Packets_t& states_106a, const Packets_t& statuss_106c)
{
	for( Packets_t::const_iterator itState_1071= states_106a.begin(), itStatus_107a= statuss_106c.begin(); itState_1071!= states_106a.end(), itStatus_107a!= statuss_106c.end(); ++itState_1071, ++itStatus_107a)
	{
		bool isUnique= isInputUnique( *itState_1071, *itStatus_107a);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1071, *itStatus_107a);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ElimState_1069::patternMatcher( const Udm::Object& state_1072, const Udm::Object& status_107b)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1072.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1077= CyPhyML::SignalFlow::State::Cast( state_1072);
		if( false== Uml::IsDerivedFrom( status_107b.type(), SFC::Function::meta))
			continue;
		SFC::Function status_1080= SFC::Function::Cast( status_107b);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1085;
		if( !isValidBound(boundObjs_1085, state_1077, true))
			continue;
		currMatch.state_1086= state_1077;
		if( !isValidBound(boundObjs_1085, status_1080, true))
			continue;
		currMatch.status_1087= status_1080;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void ElimState_1069::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
	}
}

void ElimState_1069::forwardInputs()
{
	*_status_106f= _status_1079;
}

void HasChildren_1088::operator()( const Packets_t& states_1089, const Packets_t& statuss_108b, Packets_t& states_108d, Packets_t& statuss_108e, Packets_t& states_108f, Packets_t& statuss_1090)
{
#ifdef PRINT_INFO
	printLog( "HasChildren_1088" );
#endif
	_state_1091= &states_108d;
	_status_1092= &statuss_108e;
	_state_1093= &states_108f;
	_status_1094= &statuss_1090;
	for( Packets_t::const_iterator itstate_1096= states_1089.begin(), itstatus_109d= statuss_108b.begin(); itstate_1096!= states_1089.end(), itstatus_109d!= statuss_108b.end(); ++itstate_1096, ++itstatus_109d)
	{
		bool isUnique= isInputUnique( *itstate_1096, *itstatus_109d);
		if( !isUnique)
			continue;
		Packets_t onestate_109a( 1, *itstate_1096);
		Packets_t onestatus_10a1( 1, *itstatus_109d);
		executeOne( onestate_109a, onestatus_10a1);
	}
}

void HasChildren_1088::executeOne( const Packets_t& states_1089, const Packets_t& statuss_108b)
{
	Packets_t states_10a6;
	Packets_t statuss_10a9;
	HasChildren_10a3 hasChildren_10a3;
	bool isMatchHasChildren_10a3= hasChildren_10a3( states_1089, statuss_108b, states_10a6, statuss_10a9);
	_state_1091->insert( _state_1091->end(), states_10a6.begin(), states_10a6.end());
	_status_1092->insert( _status_1092->end(), statuss_10a9.begin(), statuss_10a9.end());
	if( isMatchHasChildren_10a3)
		return;
	Packets_t states_10d2;
	Packets_t statuss_10d5;
	NoChildren_10cf noChildren_10cf;
	bool isMatchNoChildren_10cf= noChildren_10cf( states_1089, statuss_108b, states_10d2, statuss_10d5);
	_state_1093->insert( _state_1093->end(), states_10d2.begin(), states_10d2.end());
	_status_1094->insert( _status_1094->end(), statuss_10d5.begin(), statuss_10d5.end());
	if( isMatchNoChildren_10cf)
		return;
}

bool HasChildren_1088::isInputUnique( const Udm::Object& state_1097, const Udm::Object& status_109e)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_1099= _state_1095.begin(), itstatus_10a0= _status_109c.begin(); itstate_1099!= _state_1095.end(), itstatus_10a0!= _status_109c.end(); ++itstate_1099, ++itstatus_10a0)
	{
		if( ( *itstate_1099== state_1097)&& ( *itstatus_10a0== status_109e))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1095.push_back( state_1097);
		_status_109c.push_back( status_109e);
	}
	return isUnique;
}

bool HasChildren_10a3::operator()( const Packets_t& states_10a4, const Packets_t& statuss_10a7, Packets_t& states_10a6, Packets_t& statuss_10a9)
{
#ifdef PRINT_INFO
	printLog( "HasChildren_10a3" );
#endif
	_state_10aa= &states_10a6;
	_status_10ab= &statuss_10a9;
	processInputPackets( states_10a4, statuss_10a7);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasChildren_10a3::isInputUnique( const Udm::Object& state_10b0, const Udm::Object& status_10b9)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_10b2= _state_10ac.begin(), itStatus_10bb= _status_10b5.begin(); itState_10b2!= _state_10ac.end(), itStatus_10bb!= _status_10b5.end(); ++itState_10b2, ++itStatus_10bb)
	{
		if( ( *itState_10b2== state_10b0)&& ( *itStatus_10bb== status_10b9))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_10ac.push_back( state_10b0);
		_status_10b5.push_back( status_10b9);
	}
	return isUnique;
}

bool HasChildren_10a3::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool HasChildren_10a3::isGuardTrue( CyPhyML::SignalFlow::State& ChildState, CyPhyML::SignalFlow::State& State, SFC::Function& Status)
{
	bool Gz_guard= false;
	return static_cast< std::string >( ChildState.Decomposition() ) != "FUNC_STATE";;
	return Gz_guard;
}

void HasChildren_10a3::processInputPackets( const Packets_t& states_10a4, const Packets_t& statuss_10a7)
{
	for( Packets_t::const_iterator itState_10ad= states_10a4.begin(), itStatus_10b6= statuss_10a7.begin(); itState_10ad!= states_10a4.end(), itStatus_10b6!= statuss_10a7.end(); ++itState_10ad, ++itStatus_10b6)
	{
		bool isUnique= isInputUnique( *itState_10ad, *itStatus_10b6);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_10ad, *itStatus_10b6);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_10c5, currMatch.status_10c6);
	}
}

bool HasChildren_10a3::patternMatcher( const Udm::Object& state_10ae, const Udm::Object& status_10b7)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_10ae.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_10b3= CyPhyML::SignalFlow::State::Cast( state_10ae);
		if( false== Uml::IsDerivedFrom( status_10b7.type(), SFC::Function::meta))
			continue;
		SFC::Function status_10bc= SFC::Function::Cast( status_10b7);
		set< CyPhyML::SignalFlow::State> childStates_10be= state_10b3.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itChildState_10bf= childStates_10be.begin(); itChildState_10bf!= childStates_10be.end(); ++itChildState_10bf)
		{
			CyPhyML::SignalFlow::State currChildState_10c0= *itChildState_10bf;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_10c4;
			if( !isValidBound(boundObjs_10c4, state_10b3, true))
				continue;
			currMatch.state_10c5= state_10b3;
			if( !isValidBound(boundObjs_10c4, status_10bc, true))
				continue;
			currMatch.status_10c6= status_10bc;
			if( !isValidBound(boundObjs_10c4, currChildState_10c0, false))
				continue;
			currMatch.childState_10c7= currChildState_10c0;
			bool Gz_guard= isGuardTrue( currMatch.childState_10c7, currMatch.state_10c5, currMatch.status_10c6);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void HasChildren_10a3::outputAppender( const CyPhyML::SignalFlow::State& state_10cb, const SFC::Function& status_10cd)
{
	_state_10aa->push_back( state_10cb);
	_status_10ab->push_back( status_10cd);
}

bool NoChildren_10cf::operator()( const Packets_t& states_10d0, const Packets_t& statuss_10d3, Packets_t& states_10d2, Packets_t& statuss_10d5)
{
#ifdef PRINT_INFO
	printLog( "NoChildren_10cf" );
#endif
	_state_10d6= &states_10d2;
	_status_10d7= &statuss_10d5;
	processInputPackets( states_10d0, statuss_10d3);
	if( false== _matches.empty())
		return true;
	return false;
}

bool NoChildren_10cf::isInputUnique( const Udm::Object& state_10dc, const Udm::Object& status_10e5)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_10de= _state_10d8.begin(), itStatus_10e7= _status_10e1.begin(); itState_10de!= _state_10d8.end(), itStatus_10e7!= _status_10e1.end(); ++itState_10de, ++itStatus_10e7)
	{
		if( ( *itState_10de== state_10dc)&& ( *itStatus_10e7== status_10e5))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_10d8.push_back( state_10dc);
		_status_10e1.push_back( status_10e5);
	}
	return isUnique;
}

bool NoChildren_10cf::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void NoChildren_10cf::processInputPackets( const Packets_t& states_10d0, const Packets_t& statuss_10d3)
{
	for( Packets_t::const_iterator itState_10d9= states_10d0.begin(), itStatus_10e2= statuss_10d3.begin(); itState_10d9!= states_10d0.end(), itStatus_10e2!= statuss_10d3.end(); ++itState_10d9, ++itStatus_10e2)
	{
		bool isUnique= isInputUnique( *itState_10d9, *itStatus_10e2);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_10d9, *itStatus_10e2);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_10ee, currMatch.status_10ef);
	}
}

bool NoChildren_10cf::patternMatcher( const Udm::Object& state_10da, const Udm::Object& status_10e3)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_10da.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_10df= CyPhyML::SignalFlow::State::Cast( state_10da);
		if( false== Uml::IsDerivedFrom( status_10e3.type(), SFC::Function::meta))
			continue;
		SFC::Function status_10e8= SFC::Function::Cast( status_10e3);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_10ed;
		if( !isValidBound(boundObjs_10ed, state_10df, true))
			continue;
		currMatch.state_10ee= state_10df;
		if( !isValidBound(boundObjs_10ed, status_10e8, true))
			continue;
		currMatch.status_10ef= status_10e8;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void NoChildren_10cf::outputAppender( const CyPhyML::SignalFlow::State& state_10f0, const SFC::Function& status_10f2)
{
	_state_10d6->push_back( state_10f0);
	_status_10d7->push_back( status_10f2);
}

void NewIndent_10f4::operator()( const Packets_t& states_10f5, const Packets_t& statuss_10f8, Packets_t& states_10f7, Packets_t& statuss_10fa, Packets_t& stateVars_10fb)
{
#ifdef PRINT_INFO
	printLog( "NewIndent_10f4" );
#endif
	RTTGenerator::Instance()->generateRule(323, "newIndent");
	_state_10fc= &states_10f7;
	_status_10fd= &statuss_10fa;
	_stateVar_10fe= &stateVars_10fb;
	processInputPackets( states_10f5, statuss_10f8);
}

bool NewIndent_10f4::isInputUnique( const Udm::Object& state_1103, const Udm::Object& status_110c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1105= _state_10ff.begin(), itStatus_110e= _status_1108.begin(); itState_1105!= _state_10ff.end(), itStatus_110e!= _status_1108.end(); ++itState_1105, ++itStatus_110e)
	{
		if( ( *itState_1105== state_1103)&& ( *itStatus_110e== status_110c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_10ff.push_back( state_1103);
		_status_1108.push_back( status_110c);
	}
	return isUnique;
}

bool NewIndent_10f4::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void NewIndent_10f4::processInputPackets( const Packets_t& states_10f5, const Packets_t& statuss_10f8)
{
	for( Packets_t::const_iterator itState_1100= states_10f5.begin(), itStatus_1109= statuss_10f8.begin(); itState_1100!= states_10f5.end(), itStatus_1109!= statuss_10f8.end(); ++itState_1100, ++itStatus_1109)
	{
		bool isUnique= isInputUnique( *itState_1100, *itStatus_1109);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1100, *itStatus_1109);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool NewIndent_10f4::patternMatcher( const Udm::Object& state_1101, const Udm::Object& status_110a)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1101.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1106= CyPhyML::SignalFlow::State::Cast( state_1101);
		if( false== Uml::IsDerivedFrom( status_110a.type(), SFC::Function::meta))
			continue;
		SFC::Function status_110f= SFC::Function::Cast( status_110a);
		Udm::Object statusParent_1111= status_110f.container();
		if( false== Uml::IsDerivedFrom( statusParent_1111.type(), SFC::Program::meta))
			continue;
		SFC::Program programStatus_1112= SFC::Program::Cast( statusParent_1111);
		set< SFC::Arg> args_1113= status_110f.Arg_kind_children();
		for( set< SFC::Arg>::const_iterator itArg_1114= args_1113.begin(); itArg_1114!= args_1113.end(); ++itArg_1114)
		{
			SFC::Arg currArg_1115= *itArg_1114;
			set< SFC::StateVar> stateVars_1116= programStatus_1112.StateVar_kind_children();
			for( set< SFC::StateVar>::const_iterator itStateVar_1117= stateVars_1116.begin(); itStateVar_1117!= stateVars_1116.end(); ++itStateVar_1117)
			{
				SFC::StateVar currStateVar_1118= *itStateVar_1117;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_111c;
				if( !isValidBound(boundObjs_111c, state_1106, true))
					continue;
				currMatch.state_111d= state_1106;
				if( !isValidBound(boundObjs_111c, status_110f, true))
					continue;
				currMatch.status_111e= status_110f;
				if( !isValidBound(boundObjs_111c, currArg_1115, false))
					continue;
				currMatch.arg_111f= currArg_1115;
				if( !isValidBound(boundObjs_111c, programStatus_1112, false))
					continue;
				currMatch.program_1120= programStatus_1112;
				if( !isValidBound(boundObjs_111c, currStateVar_1118, false))
					continue;
				currMatch.stateVar_1121= currStateVar_1118;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void NewIndent_10f4::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar newnewIndent_1122= SFC::LocalVar::Create( currMatch.status_111e, SFC::Function::meta_stmnt);
		SFC::UserCode newnewIndentAssign_1123= SFC::UserCode::Create( currMatch.status_111e, SFC::Function::meta_stmnt);
		SFC::BinaryExprs newAssign_1124= SFC::BinaryExprs::Create( newnewIndentAssign_1123, SFC::UserCode::meta_codeexpr);
		SFC::ArgDeclRef newArgDeclRef4_1125= SFC::ArgDeclRef::Create( newAssign_1124, SFC::BinaryExprs::meta_leftexpr);
		SFC::BinaryExprs newPlus_1126= SFC::BinaryExprs::Create( newAssign_1124, SFC::BinaryExprs::meta_rightexpr);
		SFC::Str newStr_1127= SFC::Str::Create( newPlus_1126, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef3_1128= SFC::ArgDeclRef::Create( newPlus_1126, SFC::BinaryExprs::meta_leftexpr);
		SFC::Arg& Arg= currMatch.arg_111f;
		SFC::ArgDeclRef& ArgDeclRef3= newArgDeclRef3_1128;
		SFC::ArgDeclRef& ArgDeclRef4= newArgDeclRef4_1125;
		SFC::BinaryExprs& Assign= newAssign_1124;
		SFC::BinaryExprs& Plus= newPlus_1126;
		SFC::Program& Program= currMatch.program_1120;
		CyPhyML::SignalFlow::State& State= currMatch.state_111d;
		SFC::StateVar& StateVar= currMatch.stateVar_1121;
		SFC::Function& Status= currMatch.status_111e;
		SFC::Str& Str= newStr_1127;
		SFC::LocalVar& newIndent= newnewIndent_1122;
		SFC::UserCode& newIndentAssign= newnewIndentAssign_1123;
		{
newIndentAssign.RefId() = newIndent.RefId() = Status.RefId();
};
		{
Str.val() = "\\t";
};
		{
Plus.op() = "+";
};
		{
newIndent.name() = "newIndent";
newIndent.dt() = SFCTypesManager::getSingleton().getBasicType( "string" );
};
		{
Assign.op() = "=";
};
		{
__int64 statementCount = Status.statementCount();
newIndent.statementIndex() = statementCount++;
newIndentAssign.statementIndex() = statementCount++;
Status.statementCount() = statementCount;
};
		newArgDeclRef3_1128.argdecl()= currMatch.arg_111f;
		newArgDeclRef4_1125.argdecl()= newnewIndent_1122;
		outputAppender( currMatch.state_111d, currMatch.status_111e, currMatch.stateVar_1121);
	}
}

void NewIndent_10f4::outputAppender( const CyPhyML::SignalFlow::State& state_1129, const SFC::Function& status_112b, const SFC::StateVar& stateVar_112d)
{
	_state_10fc->push_back( state_1129);
	_status_10fd->push_back( status_112b);
	_stateVar_10fe->push_back( stateVar_112d);
}

void ReturnValue_112f::operator()( const Packets_t& statuss_1130)
{
#ifdef PRINT_INFO
	printLog( "ReturnValue_112f" );
#endif
	RTTGenerator::Instance()->generateRule(354, "ReturnValue");
	processInputPackets( statuss_1130);
}

bool ReturnValue_112f::isInputUnique( const Udm::Object& status_1136)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itStatus_1138= _status_1132.begin(); itStatus_1138!= _status_1132.end(); ++itStatus_1138)
	{
		if( ( *itStatus_1138== status_1136))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_status_1132.push_back( status_1136);
	return isUnique;
}

bool ReturnValue_112f::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool ReturnValue_112f::isGuardTrue( SFC::Function& Status, SFC::LocalVar& retval)
{
	bool Gz_guard= false;
	return static_cast< std::string >( retval.name() ) == "retval";;
	return Gz_guard;
}

void ReturnValue_112f::processInputPackets( const Packets_t& statuss_1130)
{
	for( Packets_t::const_iterator itStatus_1133= statuss_1130.begin(); itStatus_1133!= statuss_1130.end(); ++itStatus_1133)
	{
		bool isUnique= isInputUnique( *itStatus_1133);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itStatus_1133);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ReturnValue_112f::patternMatcher( const Udm::Object& status_1134)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( status_1134.type(), SFC::Function::meta))
			continue;
		SFC::Function status_1139= SFC::Function::Cast( status_1134);
		set< SFC::LocalVar> retvals_113b= status_1139.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itretval_113c= retvals_113b.begin(); itretval_113c!= retvals_113b.end(); ++itretval_113c)
		{
			SFC::LocalVar currretval_113d= *itretval_113c;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1141;
			if( !isValidBound(boundObjs_1141, status_1139, true))
				continue;
			currMatch.status_1142= status_1139;
			if( !isValidBound(boundObjs_1141, currretval_113d, false))
				continue;
			currMatch.retval_1143= currretval_113d;
			bool Gz_guard= isGuardTrue( currMatch.status_1142, currMatch.retval_1143);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void ReturnValue_112f::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Return newReturn_1146= SFC::Return::Create( currMatch.status_1142, SFC::Function::meta_stmnt);
		SFC::ArgDeclRef newArgDeclRef_1147= SFC::ArgDeclRef::Create( newReturn_1146, SFC::Return::meta_retexpr);
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_1147;
		SFC::Return& Return= newReturn_1146;
		SFC::Function& Status= currMatch.status_1142;
		SFC::LocalVar& retval= currMatch.retval_1143;
		{
Return.RefId() = Status.RefId();
};
		{
__int64 statementCount = Status.statementCount();
Return.statementIndex() = statementCount++;
Status.statementCount() = statementCount;
};
		newArgDeclRef_1147.argdecl()= currMatch.retval_1143;
	}
}

void CreateConditionals_1148::operator()( const Packets_t& states_1149, const Packets_t& childStates_114c, const Packets_t& compoundStatements_114e, const Packets_t& stateVars_1150, Packets_t& statuss_114b)
{
#ifdef PRINT_INFO
	printLog( "CreateConditionals_1148" );
#endif
	RTTGenerator::Instance()->generateRule(365, "CreateConditionals");
	_status_1152= &statuss_114b;
	processInputPackets( states_1149, childStates_114c, compoundStatements_114e, stateVars_1150);
}

bool CreateConditionals_1148::isInputUnique( const Udm::Object& state_1157, const Udm::Object& childState_1160, const Udm::Object& compoundStatement_1169, const Udm::Object& stateVar_1172)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1159= _state_1153.begin(), itChildState_1162= _childState_115c.begin(), itCompoundStatement_116b= _compoundStatement_1165.begin(), itStateVar_1174= _stateVar_116e.begin(); itState_1159!= _state_1153.end(), itChildState_1162!= _childState_115c.end(), itCompoundStatement_116b!= _compoundStatement_1165.end(), itStateVar_1174!= _stateVar_116e.end(); ++itState_1159, ++itChildState_1162, ++itCompoundStatement_116b, ++itStateVar_1174)
	{
		if( ( *itState_1159== state_1157)&& ( *itChildState_1162== childState_1160)&& ( *itCompoundStatement_116b== compoundStatement_1169)&& ( *itStateVar_1174== stateVar_1172))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1153.push_back( state_1157);
		_childState_115c.push_back( childState_1160);
		_compoundStatement_1165.push_back( compoundStatement_1169);
		_stateVar_116e.push_back( stateVar_1172);
	}
	return isUnique;
}

bool CreateConditionals_1148::isGuardTrue( CyPhyML::SignalFlow::State& ChildState, SFC::StateLabel& ChildStateLabel, SFC::Function& ChildStatus, SFC::CompoundStatement& CompoundStatement, SFC::Arg& IndentArg, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel, SFC::StateVar& StateVar, SFC::Function& Status, SFC::LocalVar& newIndent, SFC::LocalVar& retval)
{
	bool Gz_guard= false;
	return static_cast< std::string >( retval.name() ) == "retval" && static_cast< std::string >( newIndent.name() ) == "newIndent";;
	return Gz_guard;
}

void CreateConditionals_1148::processInputPackets( const Packets_t& states_1149, const Packets_t& childStates_114c, const Packets_t& compoundStatements_114e, const Packets_t& stateVars_1150)
{
	for( Packets_t::const_iterator itState_1154= states_1149.begin(), itChildState_115d= childStates_114c.begin(), itCompoundStatement_1166= compoundStatements_114e.begin(), itStateVar_116f= stateVars_1150.begin(); itState_1154!= states_1149.end(), itChildState_115d!= childStates_114c.end(), itCompoundStatement_1166!= compoundStatements_114e.end(), itStateVar_116f!= stateVars_1150.end(); ++itState_1154, ++itChildState_115d, ++itCompoundStatement_1166, ++itStateVar_116f)
	{
		bool isUnique= isInputUnique( *itState_1154, *itChildState_115d, *itCompoundStatement_1166, *itStateVar_116f);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1154, *itChildState_115d, *itCompoundStatement_1166, *itStateVar_116f);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateConditionals_1148::patternMatcher( const Udm::Object& state_1155, const Udm::Object& childState_115e, const Udm::Object& compoundStatement_1167, const Udm::Object& stateVar_1170)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1155.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_115a= CyPhyML::SignalFlow::State::Cast( state_1155);
		if( false== Uml::IsDerivedFrom( childState_115e.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State childState_1163= CyPhyML::SignalFlow::State::Cast( childState_115e);
		if( false== Uml::IsDerivedFrom( compoundStatement_1167.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_116c= SFC::CompoundStatement::Cast( compoundStatement_1167);
		if( false== Uml::IsDerivedFrom( stateVar_1170.type(), SFC::StateVar::meta))
			continue;
		SFC::StateVar stateVar_1175= SFC::StateVar::Cast( stateVar_1170);
		set< SFC::Function> statuss_1177= state_115a.status();
		for( set< SFC::Function>::const_iterator itStatuss_1178= statuss_1177.begin(); itStatuss_1178!= statuss_1177.end(); ++itStatuss_1178)
		{
			SFC::Function currStatus_1179= *itStatuss_1178;
			set< SFC::LocalVar> newIndents_117a= currStatus_1179.LocalVar_kind_children();
			for( set< SFC::LocalVar>::const_iterator itnewIndent_117b= newIndents_117a.begin(); itnewIndent_117b!= newIndents_117a.end(); ++itnewIndent_117b)
			{
				SFC::LocalVar currnewIndent_117c= *itnewIndent_117b;
				set< SFC::LocalVar> retvals_117d= currStatus_1179.LocalVar_kind_children();
				for( set< SFC::LocalVar>::const_iterator itretval_117e= retvals_117d.begin(); itretval_117e!= retvals_117d.end(); ++itretval_117e)
				{
					SFC::LocalVar currretval_117f= *itretval_117e;
					set< SFC::Function> childStatuss_1180= childState_1163.status();
					for( set< SFC::Function>::const_iterator itChildStatuss_1181= childStatuss_1180.begin(); itChildStatuss_1181!= childStatuss_1180.end(); ++itChildStatuss_1181)
					{
						SFC::Function currChildStatus_1182= *itChildStatuss_1181;
						set< SFC::Arg> indentArgs_1183= currChildStatus_1182.Arg_kind_children();
						for( set< SFC::Arg>::const_iterator itIndentArg_1184= indentArgs_1183.begin(); itIndentArg_1184!= indentArgs_1183.end(); ++itIndentArg_1184)
						{
							SFC::Arg currIndentArg_1185= *itIndentArg_1184;
							set< SFC::StateLabel> childStateLabels_1186= childState_1163.src();
							for( set< SFC::StateLabel>::const_iterator itChildStateLabels_1187= childStateLabels_1186.begin(); itChildStateLabels_1187!= childStateLabels_1186.end(); ++itChildStateLabels_1187)
							{
								SFC::StateLabel currChildStateLabel_1188= *itChildStateLabels_1187;
								set< SFC::StateLabel> stateLabels_1189= state_115a.src();
								for( set< SFC::StateLabel>::const_iterator itStateLabels_118a= stateLabels_1189.begin(); itStateLabels_118a!= stateLabels_1189.end(); ++itStateLabels_118a)
								{
									SFC::StateLabel currStateLabel_118b= *itStateLabels_118a;
									Match currMatch;
									currMatch.state_118d= state_115a;
									currMatch.childState_118e= childState_1163;
									currMatch.compoundStatement_118f= compoundStatement_116c;
									currMatch.stateVar_1190= stateVar_1175;
									currMatch.status_1191= currStatus_1179;
									currMatch.retval_1192= currretval_117f;
									currMatch.indentArg_1193= currIndentArg_1185;
									currMatch.childStatus_1194= currChildStatus_1182;
									currMatch.newIndent_1195= currnewIndent_117c;
									currMatch.stateLabel_1196= currStateLabel_118b;
									currMatch.childStateLabel_1197= currChildStateLabel_1188;
									bool Gz_guard= isGuardTrue( currMatch.childState_118e, currMatch.childStateLabel_1197, currMatch.childStatus_1194, currMatch.compoundStatement_118f, currMatch.indentArg_1193, currMatch.state_118d, currMatch.stateLabel_1196, currMatch.stateVar_1190, currMatch.status_1191, currMatch.newIndent_1195, currMatch.retval_1192);
									if( true== Gz_guard)
										_matches.push_back( currMatch);
								}
							}
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void CreateConditionals_1148::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_11a3= SFC::ConditionalBlock::Create( currMatch.compoundStatement_118f, SFC::CompoundStatement::meta_stmnt);
		SFC::UserCode newUserCode_11a4= SFC::UserCode::Create( newConditionalBlock_11a3, SFC::ConditionalBlock::meta_stmnt);
		SFC::BinaryExprs newAddEquals_11a5= SFC::BinaryExprs::Create( newUserCode_11a4, SFC::UserCode::meta_codeexpr);
		SFC::ArgDeclRef newArgDeclRef2_11a6= SFC::ArgDeclRef::Create( newAddEquals_11a5, SFC::BinaryExprs::meta_leftexpr);
		SFC::FunctionCall newFunctionCall_11a7= SFC::FunctionCall::Create( newAddEquals_11a5, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgVal newArgVal_11a8= SFC::ArgVal::Create( newFunctionCall_11a7);
		SFC::ArgDeclRef newArgDeclRef1_11a9= SFC::ArgDeclRef::Create( newArgVal_11a8, SFC::ArgVal::meta_argexpr);
		SFC::CheckState newCheckState_11aa= SFC::CheckState::Create( newConditionalBlock_11a3, SFC::ConditionalBlock::meta_cond);
		SFC::BinaryExprs& AddEquals= newAddEquals_11a5;
		SFC::ArgDeclRef& ArgDeclRef1= newArgDeclRef1_11a9;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_11a6;
		SFC::ArgVal& ArgVal= newArgVal_11a8;
		SFC::CheckState& CheckState= newCheckState_11aa;
		CyPhyML::SignalFlow::State& ChildState= currMatch.childState_118e;
		SFC::StateLabel& ChildStateLabel= currMatch.childStateLabel_1197;
		SFC::Function& ChildStatus= currMatch.childStatus_1194;
		SFC::CompoundStatement& CompoundStatement= currMatch.compoundStatement_118f;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_11a3;
		SFC::FunctionCall& FunctionCall= newFunctionCall_11a7;
		SFC::Arg& IndentArg= currMatch.indentArg_1193;
		CyPhyML::SignalFlow::State& State= currMatch.state_118d;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_1196;
		SFC::StateVar& StateVar= currMatch.stateVar_1190;
		SFC::Function& Status= currMatch.status_1191;
		SFC::UserCode& UserCode= newUserCode_11a4;
		SFC::LocalVar& newIndent= currMatch.newIndent_1195;
		SFC::LocalVar& retval= currMatch.retval_1192;
		{
ConditionalBlock.RefId() = UserCode.RefId() = CompoundStatement.RefId();
};
		{
CheckState.andState() = static_cast< std::string >( ChildState.Decomposition() ) == "AND_STATE";
};
		{
__int64 statementCount = ConditionalBlock.statementCount();
UserCode.statementIndex() = statementCount++;
ConditionalBlock.statementCount() = statementCount;
};
		{
__int64 statementCount = CompoundStatement.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
CompoundStatement.statementCount() = statementCount;
};
		{
AddEquals.op() = "+=";
};
		newArgDeclRef1_11a9.argdecl()= currMatch.newIndent_1195;
		newArgVal_11a8.arg()+= currMatch.indentArg_1193;
		newArgDeclRef2_11a6.argdecl()= currMatch.retval_1192;
		newFunctionCall_11a7.callee()= currMatch.childStatus_1194;
		newCheckState_11aa.svar()= currMatch.stateVar_1190;
		newCheckState_11aa.value()= currMatch.childStateLabel_1197;
		newCheckState_11aa.index()= currMatch.stateLabel_1196;
		outputAppender( currMatch.status_1191);
	}
}

void CreateConditionals_1148::outputAppender( const SFC::Function& status_11ab)
{
	_status_1152->push_back( status_11ab);
}

void DecompTest_11ad::operator()( const Packets_t& states_11ae, const Packets_t& statuss_11b0, const Packets_t& svs_11b2, Packets_t& states_11b4, Packets_t& statuss_11b5, Packets_t& svs_11b6, Packets_t& states_11b7, Packets_t& statuss_11b8, Packets_t& svs_11b9)
{
#ifdef PRINT_INFO
	printLog( "DecompTest_11ad" );
#endif
	_state_11ba= &states_11b4;
	_status_11bb= &statuss_11b5;
	_sv_11bc= &svs_11b6;
	_state_11bd= &states_11b7;
	_status_11be= &statuss_11b8;
	_sv_11bf= &svs_11b9;
	for( Packets_t::const_iterator itstate_11c1= states_11ae.begin(), itstatus_11c8= statuss_11b0.begin(), itsv_11cf= svs_11b2.begin(); itstate_11c1!= states_11ae.end(), itstatus_11c8!= statuss_11b0.end(), itsv_11cf!= svs_11b2.end(); ++itstate_11c1, ++itstatus_11c8, ++itsv_11cf)
	{
		bool isUnique= isInputUnique( *itstate_11c1, *itstatus_11c8, *itsv_11cf);
		if( !isUnique)
			continue;
		Packets_t onestate_11c5( 1, *itstate_11c1);
		Packets_t onestatus_11cc( 1, *itstatus_11c8);
		Packets_t onesv_11d3( 1, *itsv_11cf);
		executeOne( onestate_11c5, onestatus_11cc, onesv_11d3);
	}
}

void DecompTest_11ad::executeOne( const Packets_t& states_11ae, const Packets_t& statuss_11b0, const Packets_t& svs_11b2)
{
	Packets_t states_11d8;
	Packets_t statuss_11db;
	Packets_t stateVars_11de;
	AndState_11d5 andState_11d5;
	bool isMatchAndState_11d5= andState_11d5( states_11ae, statuss_11b0, svs_11b2, states_11d8, statuss_11db, stateVars_11de);
	_state_11ba->insert( _state_11ba->end(), states_11d8.begin(), states_11d8.end());
	_status_11bb->insert( _status_11bb->end(), statuss_11db.begin(), statuss_11db.end());
	_sv_11bc->insert( _sv_11bc->end(), stateVars_11de.begin(), stateVars_11de.end());
	if( isMatchAndState_11d5)
		return;
	Packets_t states_1215;
	Packets_t statuss_1218;
	Packets_t stateVars_121b;
	OrState_1212 orState_1212;
	bool isMatchOrState_1212= orState_1212( states_11ae, statuss_11b0, svs_11b2, states_1215, statuss_1218, stateVars_121b);
	_state_11bd->insert( _state_11bd->end(), states_1215.begin(), states_1215.end());
	_status_11be->insert( _status_11be->end(), statuss_1218.begin(), statuss_1218.end());
	_sv_11bf->insert( _sv_11bf->end(), stateVars_121b.begin(), stateVars_121b.end());
	if( isMatchOrState_1212)
		return;
}

bool DecompTest_11ad::isInputUnique( const Udm::Object& state_11c2, const Udm::Object& status_11c9, const Udm::Object& sv_11d0)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_11c4= _state_11c0.begin(), itstatus_11cb= _status_11c7.begin(), itsv_11d2= _sv_11ce.begin(); itstate_11c4!= _state_11c0.end(), itstatus_11cb!= _status_11c7.end(), itsv_11d2!= _sv_11ce.end(); ++itstate_11c4, ++itstatus_11cb, ++itsv_11d2)
	{
		if( ( *itstate_11c4== state_11c2)&& ( *itstatus_11cb== status_11c9)&& ( *itsv_11d2== sv_11d0))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_11c0.push_back( state_11c2);
		_status_11c7.push_back( status_11c9);
		_sv_11ce.push_back( sv_11d0);
	}
	return isUnique;
}

bool AndState_11d5::operator()( const Packets_t& states_11d6, const Packets_t& statuss_11d9, const Packets_t& stateVars_11dc, Packets_t& states_11d8, Packets_t& statuss_11db, Packets_t& stateVars_11de)
{
#ifdef PRINT_INFO
	printLog( "AndState_11d5" );
#endif
	_state_11df= &states_11d8;
	_status_11e0= &statuss_11db;
	_stateVar_11e1= &stateVars_11de;
	processInputPackets( states_11d6, statuss_11d9, stateVars_11dc);
	if( false== _matches.empty())
		return true;
	return false;
}

bool AndState_11d5::isInputUnique( const Udm::Object& state_11e6, const Udm::Object& status_11ef, const Udm::Object& stateVar_11f8)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_11e8= _state_11e2.begin(), itStatus_11f1= _status_11eb.begin(), itStateVar_11fa= _stateVar_11f4.begin(); itState_11e8!= _state_11e2.end(), itStatus_11f1!= _status_11eb.end(), itStateVar_11fa!= _stateVar_11f4.end(); ++itState_11e8, ++itStatus_11f1, ++itStateVar_11fa)
	{
		if( ( *itState_11e8== state_11e6)&& ( *itStatus_11f1== status_11ef)&& ( *itStateVar_11fa== stateVar_11f8))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_11e2.push_back( state_11e6);
		_status_11eb.push_back( status_11ef);
		_stateVar_11f4.push_back( stateVar_11f8);
	}
	return isUnique;
}

bool AndState_11d5::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool AndState_11d5::isGuardTrue( CyPhyML::SignalFlow::State& ChildState, CyPhyML::SignalFlow::State& State, SFC::StateVar& StateVar, SFC::Function& Status)
{
	bool Gz_guard= false;
	return static_cast< std::string >( ChildState.Decomposition() ) == "AND_STATE";;
	return Gz_guard;
}

void AndState_11d5::processInputPackets( const Packets_t& states_11d6, const Packets_t& statuss_11d9, const Packets_t& stateVars_11dc)
{
	for( Packets_t::const_iterator itState_11e3= states_11d6.begin(), itStatus_11ec= statuss_11d9.begin(), itStateVar_11f5= stateVars_11dc.begin(); itState_11e3!= states_11d6.end(), itStatus_11ec!= statuss_11d9.end(), itStateVar_11f5!= stateVars_11dc.end(); ++itState_11e3, ++itStatus_11ec, ++itStateVar_11f5)
	{
		bool isUnique= isInputUnique( *itState_11e3, *itStatus_11ec, *itStateVar_11f5);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_11e3, *itStatus_11ec, *itStateVar_11f5);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1204, currMatch.status_1205, currMatch.stateVar_1206);
	}
}

bool AndState_11d5::patternMatcher( const Udm::Object& state_11e4, const Udm::Object& status_11ed, const Udm::Object& stateVar_11f6)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_11e4.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_11e9= CyPhyML::SignalFlow::State::Cast( state_11e4);
		if( false== Uml::IsDerivedFrom( status_11ed.type(), SFC::Function::meta))
			continue;
		SFC::Function status_11f2= SFC::Function::Cast( status_11ed);
		if( false== Uml::IsDerivedFrom( stateVar_11f6.type(), SFC::StateVar::meta))
			continue;
		SFC::StateVar stateVar_11fb= SFC::StateVar::Cast( stateVar_11f6);
		set< CyPhyML::SignalFlow::State> childStates_11fd= state_11e9.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itChildState_11fe= childStates_11fd.begin(); itChildState_11fe!= childStates_11fd.end(); ++itChildState_11fe)
		{
			CyPhyML::SignalFlow::State currChildState_11ff= *itChildState_11fe;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1203;
			if( !isValidBound(boundObjs_1203, state_11e9, true))
				continue;
			currMatch.state_1204= state_11e9;
			if( !isValidBound(boundObjs_1203, status_11f2, true))
				continue;
			currMatch.status_1205= status_11f2;
			if( !isValidBound(boundObjs_1203, stateVar_11fb, true))
				continue;
			currMatch.stateVar_1206= stateVar_11fb;
			if( !isValidBound(boundObjs_1203, currChildState_11ff, false))
				continue;
			currMatch.childState_1207= currChildState_11ff;
			bool Gz_guard= isGuardTrue( currMatch.childState_1207, currMatch.state_1204, currMatch.stateVar_1206, currMatch.status_1205);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void AndState_11d5::outputAppender( const CyPhyML::SignalFlow::State& state_120c, const SFC::Function& status_120e, const SFC::StateVar& stateVar_1210)
{
	_state_11df->push_back( state_120c);
	_status_11e0->push_back( status_120e);
	_stateVar_11e1->push_back( stateVar_1210);
}

bool OrState_1212::operator()( const Packets_t& states_1213, const Packets_t& statuss_1216, const Packets_t& stateVars_1219, Packets_t& states_1215, Packets_t& statuss_1218, Packets_t& stateVars_121b)
{
#ifdef PRINT_INFO
	printLog( "OrState_1212" );
#endif
	_state_121c= &states_1215;
	_status_121d= &statuss_1218;
	_stateVar_121e= &stateVars_121b;
	processInputPackets( states_1213, statuss_1216, stateVars_1219);
	if( false== _matches.empty())
		return true;
	return false;
}

bool OrState_1212::isInputUnique( const Udm::Object& state_1223, const Udm::Object& status_122c, const Udm::Object& stateVar_1235)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1225= _state_121f.begin(), itStatus_122e= _status_1228.begin(), itStateVar_1237= _stateVar_1231.begin(); itState_1225!= _state_121f.end(), itStatus_122e!= _status_1228.end(), itStateVar_1237!= _stateVar_1231.end(); ++itState_1225, ++itStatus_122e, ++itStateVar_1237)
	{
		if( ( *itState_1225== state_1223)&& ( *itStatus_122e== status_122c)&& ( *itStateVar_1237== stateVar_1235))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_121f.push_back( state_1223);
		_status_1228.push_back( status_122c);
		_stateVar_1231.push_back( stateVar_1235);
	}
	return isUnique;
}

bool OrState_1212::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool OrState_1212::isGuardTrue( CyPhyML::SignalFlow::State& ChildState, CyPhyML::SignalFlow::State& State, SFC::StateVar& StateVar, SFC::Function& Status)
{
	bool Gz_guard= false;
	return static_cast< std::string >( ChildState.Decomposition() ) == "OR_STATE";;
	return Gz_guard;
}

void OrState_1212::processInputPackets( const Packets_t& states_1213, const Packets_t& statuss_1216, const Packets_t& stateVars_1219)
{
	for( Packets_t::const_iterator itState_1220= states_1213.begin(), itStatus_1229= statuss_1216.begin(), itStateVar_1232= stateVars_1219.begin(); itState_1220!= states_1213.end(), itStatus_1229!= statuss_1216.end(), itStateVar_1232!= stateVars_1219.end(); ++itState_1220, ++itStatus_1229, ++itStateVar_1232)
	{
		bool isUnique= isInputUnique( *itState_1220, *itStatus_1229, *itStateVar_1232);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1220, *itStatus_1229, *itStateVar_1232);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1241, currMatch.status_1242, currMatch.stateVar_1243);
	}
}

bool OrState_1212::patternMatcher( const Udm::Object& state_1221, const Udm::Object& status_122a, const Udm::Object& stateVar_1233)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1221.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1226= CyPhyML::SignalFlow::State::Cast( state_1221);
		if( false== Uml::IsDerivedFrom( status_122a.type(), SFC::Function::meta))
			continue;
		SFC::Function status_122f= SFC::Function::Cast( status_122a);
		if( false== Uml::IsDerivedFrom( stateVar_1233.type(), SFC::StateVar::meta))
			continue;
		SFC::StateVar stateVar_1238= SFC::StateVar::Cast( stateVar_1233);
		set< CyPhyML::SignalFlow::State> childStates_123a= state_1226.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itChildState_123b= childStates_123a.begin(); itChildState_123b!= childStates_123a.end(); ++itChildState_123b)
		{
			CyPhyML::SignalFlow::State currChildState_123c= *itChildState_123b;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1240;
			if( !isValidBound(boundObjs_1240, state_1226, true))
				continue;
			currMatch.state_1241= state_1226;
			if( !isValidBound(boundObjs_1240, status_122f, true))
				continue;
			currMatch.status_1242= status_122f;
			if( !isValidBound(boundObjs_1240, stateVar_1238, true))
				continue;
			currMatch.stateVar_1243= stateVar_1238;
			if( !isValidBound(boundObjs_1240, currChildState_123c, false))
				continue;
			currMatch.childState_1244= currChildState_123c;
			bool Gz_guard= isGuardTrue( currMatch.childState_1244, currMatch.state_1241, currMatch.stateVar_1243, currMatch.status_1242);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void OrState_1212::outputAppender( const CyPhyML::SignalFlow::State& state_1249, const SFC::Function& status_124b, const SFC::StateVar& stateVar_124d)
{
	_state_121c->push_back( state_1249);
	_status_121d->push_back( status_124b);
	_stateVar_121e->push_back( stateVar_124d);
}

void GetChildStates_124f::operator()( const Packets_t& states_1250, const Packets_t& compoundStatements_1254, const Packets_t& stateVars_1257, Packets_t& states_1252, Packets_t& childStates_1253, Packets_t& compoundStatements_1256, Packets_t& stateVars_1259)
{
#ifdef PRINT_INFO
	printLog( "GetChildStates_124f" );
#endif
	RTTGenerator::Instance()->generateRule(434, "GetChildStates");
	_state_125a= &states_1252;
	_childState_125b= &childStates_1253;
	_compoundStatement_125c= &compoundStatements_1256;
	_stateVar_125d= &stateVars_1259;
	processInputPackets( states_1250, compoundStatements_1254, stateVars_1257);
	sortOutputs( );
}

bool GetChildStates_124f::isInputUnique( const Udm::Object& state_1262, const Udm::Object& compoundStatement_126b, const Udm::Object& stateVar_1274)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1264= _state_125e.begin(), itCompoundStatement_126d= _compoundStatement_1267.begin(), itStateVar_1276= _stateVar_1270.begin(); itState_1264!= _state_125e.end(), itCompoundStatement_126d!= _compoundStatement_1267.end(), itStateVar_1276!= _stateVar_1270.end(); ++itState_1264, ++itCompoundStatement_126d, ++itStateVar_1276)
	{
		if( ( *itState_1264== state_1262)&& ( *itCompoundStatement_126d== compoundStatement_126b)&& ( *itStateVar_1276== stateVar_1274))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_125e.push_back( state_1262);
		_compoundStatement_1267.push_back( compoundStatement_126b);
		_stateVar_1270.push_back( stateVar_1274);
	}
	return isUnique;
}

bool GetChildStates_124f::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetChildStates_124f::processInputPackets( const Packets_t& states_1250, const Packets_t& compoundStatements_1254, const Packets_t& stateVars_1257)
{
	for( Packets_t::const_iterator itState_125f= states_1250.begin(), itCompoundStatement_1268= compoundStatements_1254.begin(), itStateVar_1271= stateVars_1257.begin(); itState_125f!= states_1250.end(), itCompoundStatement_1268!= compoundStatements_1254.end(), itStateVar_1271!= stateVars_1257.end(); ++itState_125f, ++itCompoundStatement_1268, ++itStateVar_1271)
	{
		bool isUnique= isInputUnique( *itState_125f, *itCompoundStatement_1268, *itStateVar_1271);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_125f, *itCompoundStatement_1268, *itStateVar_1271);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetChildStates_124f::patternMatcher( const Udm::Object& state_1260, const Udm::Object& compoundStatement_1269, const Udm::Object& stateVar_1272)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1260.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1265= CyPhyML::SignalFlow::State::Cast( state_1260);
		if( false== Uml::IsDerivedFrom( compoundStatement_1269.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_126e= SFC::CompoundStatement::Cast( compoundStatement_1269);
		if( false== Uml::IsDerivedFrom( stateVar_1272.type(), SFC::StateVar::meta))
			continue;
		SFC::StateVar stateVar_1277= SFC::StateVar::Cast( stateVar_1272);
		set< CyPhyML::SignalFlow::State> childStates_1279= state_1265.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itChildState_127a= childStates_1279.begin(); itChildState_127a!= childStates_1279.end(); ++itChildState_127a)
		{
			CyPhyML::SignalFlow::State currChildState_127b= *itChildState_127a;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_127f;
			if( !isValidBound(boundObjs_127f, state_1265, true))
				continue;
			currMatch.state_1280= state_1265;
			if( !isValidBound(boundObjs_127f, compoundStatement_126e, true))
				continue;
			currMatch.compoundStatement_1281= compoundStatement_126e;
			if( !isValidBound(boundObjs_127f, stateVar_1277, true))
				continue;
			currMatch.stateVar_1282= stateVar_1277;
			if( !isValidBound(boundObjs_127f, currChildState_127b, false))
				continue;
			currMatch.childState_1283= currChildState_127b;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetChildStates_124f::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1280, currMatch.childState_1283, currMatch.compoundStatement_1281, currMatch.stateVar_1282);
	}
}

void GetChildStates_124f::outputAppender( const CyPhyML::SignalFlow::State& state_1284, const CyPhyML::SignalFlow::State& childState_1286, const SFC::CompoundStatement& compoundStatement_1288, const SFC::StateVar& stateVar_128a)
{
	_state_125a->push_back( state_1284);
	_childState_125b->push_back( childState_1286);
	_compoundStatement_125c->push_back( compoundStatement_1288);
	_stateVar_125d->push_back( stateVar_128a);
}

void GetChildStates_124f::sortOutputs()
{
	typedef std::multiset< CyPhyML::SignalFlow::State, std::pointer_to_binary_function< const CyPhyML::SignalFlow::State&, const CyPhyML::SignalFlow::State&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const CyPhyML::SignalFlow::State&, const CyPhyML::SignalFlow::State&, bool> ptr_StateOrder( StateOrder< CyPhyML::SignalFlow::State>);
	SortedSet_t sortedSet( ptr_StateOrder);
	std::vector< int> permutationVector( _childState_125b->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _childState_125b->begin(); it!= _childState_125b->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( CyPhyML::SignalFlow::State::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _childState_125b->begin());
	// order rest of the containers
	permutate( permutationVector, *_state_125a);
	permutate( permutationVector, *_compoundStatement_125c);
	permutate( permutationVector, *_stateVar_125d);
}

void CreateConditionalGroup_128c::operator()( const Packets_t& states_128d, const Packets_t& statuss_1290, const Packets_t& stateVars_1293, Packets_t& states_128f, Packets_t& conditionalGroups_1292, Packets_t& stateVars_1295)
{
#ifdef PRINT_INFO
	printLog( "CreateConditionalGroup_128c" );
#endif
	RTTGenerator::Instance()->generateRule(440, "CreateConditionalGroup");
	_state_1296= &states_128f;
	_conditionalGroup_1297= &conditionalGroups_1292;
	_stateVar_1298= &stateVars_1295;
	processInputPackets( states_128d, statuss_1290, stateVars_1293);
}

bool CreateConditionalGroup_128c::isInputUnique( const Udm::Object& state_129d, const Udm::Object& status_12a6, const Udm::Object& stateVar_12af)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_129f= _state_1299.begin(), itStatus_12a8= _status_12a2.begin(), itStateVar_12b1= _stateVar_12ab.begin(); itState_129f!= _state_1299.end(), itStatus_12a8!= _status_12a2.end(), itStateVar_12b1!= _stateVar_12ab.end(); ++itState_129f, ++itStatus_12a8, ++itStateVar_12b1)
	{
		if( ( *itState_129f== state_129d)&& ( *itStatus_12a8== status_12a6)&& ( *itStateVar_12b1== stateVar_12af))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1299.push_back( state_129d);
		_status_12a2.push_back( status_12a6);
		_stateVar_12ab.push_back( stateVar_12af);
	}
	return isUnique;
}

bool CreateConditionalGroup_128c::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateConditionalGroup_128c::processInputPackets( const Packets_t& states_128d, const Packets_t& statuss_1290, const Packets_t& stateVars_1293)
{
	for( Packets_t::const_iterator itState_129a= states_128d.begin(), itStatus_12a3= statuss_1290.begin(), itStateVar_12ac= stateVars_1293.begin(); itState_129a!= states_128d.end(), itStatus_12a3!= statuss_1290.end(), itStateVar_12ac!= stateVars_1293.end(); ++itState_129a, ++itStatus_12a3, ++itStateVar_12ac)
	{
		bool isUnique= isInputUnique( *itState_129a, *itStatus_12a3, *itStateVar_12ac);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_129a, *itStatus_12a3, *itStateVar_12ac);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateConditionalGroup_128c::patternMatcher( const Udm::Object& state_129b, const Udm::Object& status_12a4, const Udm::Object& stateVar_12ad)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_129b.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_12a0= CyPhyML::SignalFlow::State::Cast( state_129b);
		if( false== Uml::IsDerivedFrom( status_12a4.type(), SFC::Function::meta))
			continue;
		SFC::Function status_12a9= SFC::Function::Cast( status_12a4);
		if( false== Uml::IsDerivedFrom( stateVar_12ad.type(), SFC::StateVar::meta))
			continue;
		SFC::StateVar stateVar_12b2= SFC::StateVar::Cast( stateVar_12ad);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_12b7;
		if( !isValidBound(boundObjs_12b7, state_12a0, true))
			continue;
		currMatch.state_12b8= state_12a0;
		if( !isValidBound(boundObjs_12b7, status_12a9, true))
			continue;
		currMatch.status_12b9= status_12a9;
		if( !isValidBound(boundObjs_12b7, stateVar_12b2, true))
			continue;
		currMatch.stateVar_12ba= stateVar_12b2;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateConditionalGroup_128c::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalGroup newConditionalGroup_12bb= SFC::ConditionalGroup::Create( currMatch.status_12b9, SFC::Function::meta_stmnt);
		SFC::ConditionalGroup& ConditionalGroup= newConditionalGroup_12bb;
		CyPhyML::SignalFlow::State& State= currMatch.state_12b8;
		SFC::StateVar& StateVar= currMatch.stateVar_12ba;
		SFC::Function& Status= currMatch.status_12b9;
		{
ConditionalGroup.RefId() = Status.RefId();
};
		{
__int64 statementCount = Status.statementCount();
ConditionalGroup.statementIndex() = statementCount++;
Status.statementCount() = statementCount;
};
		outputAppender( currMatch.state_12b8, newConditionalGroup_12bb, currMatch.stateVar_12ba);
	}
}

void CreateConditionalGroup_128c::outputAppender( const CyPhyML::SignalFlow::State& state_12bc, const SFC::ConditionalGroup& conditionalGroup_12be, const SFC::StateVar& stateVar_12c0)
{
	_state_1296->push_back( state_12bc);
	_conditionalGroup_1297->push_back( conditionalGroup_12be);
	_stateVar_1298->push_back( stateVar_12c0);
}

void GetStatusFunction_12c2::operator()( const Packets_t& states_12c3, Packets_t& states_12c5, Packets_t& statuss_12c6)
{
#ifdef PRINT_INFO
	printLog( "GetStatusFunction_12c2" );
#endif
	RTTGenerator::Instance()->generateRule(448, "GetStatusFunction");
	_state_12c7= &states_12c5;
	_status_12c8= &statuss_12c6;
	processInputPackets( states_12c3);
}

bool GetStatusFunction_12c2::isInputUnique( const Udm::Object& state_12cd)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_12cf= _state_12c9.begin(); itState_12cf!= _state_12c9.end(); ++itState_12cf)
	{
		if( ( *itState_12cf== state_12cd))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_12c9.push_back( state_12cd);
	return isUnique;
}

bool GetStatusFunction_12c2::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetStatusFunction_12c2::processInputPackets( const Packets_t& states_12c3)
{
	for( Packets_t::const_iterator itState_12ca= states_12c3.begin(); itState_12ca!= states_12c3.end(); ++itState_12ca)
	{
		bool isUnique= isInputUnique( *itState_12ca);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_12ca);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetStatusFunction_12c2::patternMatcher( const Udm::Object& state_12cb)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_12cb.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_12d0= CyPhyML::SignalFlow::State::Cast( state_12cb);
		set< SFC::Function> statuss_12d2= state_12d0.status();
		for( set< SFC::Function>::const_iterator itStatuss_12d3= statuss_12d2.begin(); itStatuss_12d3!= statuss_12d2.end(); ++itStatuss_12d3)
		{
			SFC::Function currStatus_12d4= *itStatuss_12d3;
			set< SFC::Arg> args_12d5= currStatus_12d4.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itArg_12d6= args_12d5.begin(); itArg_12d6!= args_12d5.end(); ++itArg_12d6)
			{
				SFC::Arg currArg_12d7= *itArg_12d6;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_12db;
				if( !isValidBound(boundObjs_12db, state_12d0, true))
					continue;
				currMatch.state_12dc= state_12d0;
				if( !isValidBound(boundObjs_12db, currStatus_12d4, false))
					continue;
				currMatch.status_12dd= currStatus_12d4;
				if( !isValidBound(boundObjs_12db, currArg_12d7, false))
					continue;
				currMatch.arg_12de= currArg_12d7;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetStatusFunction_12c2::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar newretval_12df= SFC::LocalVar::Create( currMatch.status_12dd, SFC::Function::meta_stmnt);
		SFC::UserCode newretvalAssign_12e0= SFC::UserCode::Create( currMatch.status_12dd, SFC::Function::meta_stmnt);
		SFC::BinaryExprs newAssign_12e1= SFC::BinaryExprs::Create( newretvalAssign_12e0, SFC::UserCode::meta_codeexpr);
		SFC::BinaryExprs newPlus_12e2= SFC::BinaryExprs::Create( newAssign_12e1, SFC::BinaryExprs::meta_rightexpr);
		SFC::Str newStr_12e3= SFC::Str::Create( newPlus_12e2, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef1_12e4= SFC::ArgDeclRef::Create( newPlus_12e2, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef2_12e5= SFC::ArgDeclRef::Create( newAssign_12e1, SFC::BinaryExprs::meta_leftexpr);
		SFC::Arg& Arg= currMatch.arg_12de;
		SFC::ArgDeclRef& ArgDeclRef1= newArgDeclRef1_12e4;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_12e5;
		SFC::BinaryExprs& Assign= newAssign_12e1;
		SFC::BinaryExprs& Plus= newPlus_12e2;
		CyPhyML::SignalFlow::State& State= currMatch.state_12dc;
		SFC::Function& Status= currMatch.status_12dd;
		SFC::Str& Str= newStr_12e3;
		SFC::LocalVar& retval= newretval_12df;
		SFC::UserCode& retvalAssign= newretvalAssign_12e0;
		{
retval.RefId() = retvalAssign.RefId() = Status.RefId();
};
		{
Plus.op() = "+";
};
		{
Assign.op() = "=";
};
		{
Str.val() = static_cast< std::string >( State.name() ) + "\\n";
};
		{
retval.name() = "retval";
retval.dt() = SFCTypesManager::getSingleton().getBasicType( "string" );
};
		{
__int64 statementCount = Status.statementCount();
retval.statementIndex() = statementCount++;
retvalAssign.statementIndex() = statementCount++;
Status.statementCount() = statementCount;
};
		newArgDeclRef1_12e4.argdecl()= currMatch.arg_12de;
		newArgDeclRef2_12e5.argdecl()= newretval_12df;
		outputAppender( currMatch.state_12dc, currMatch.status_12dd);
	}
}

void GetStatusFunction_12c2::outputAppender( const CyPhyML::SignalFlow::State& state_12e6, const SFC::Function& status_12e8)
{
	_state_12c7->push_back( state_12e6);
	_status_12c8->push_back( status_12e8);
}

void NoFunctionStates_1308::operator()( const Packets_t& states_1309, const Packets_t& programs_130b, Packets_t& states_130d, Packets_t& programs_130e)
{
#ifdef PRINT_INFO
	printLog( "NoFunctionStates_1308" );
#endif
	_state_130f= &states_130d;
	_program_1310= &programs_130e;
	for( Packets_t::const_iterator itstate_1312= states_1309.begin(), itprogram_1319= programs_130b.begin(); itstate_1312!= states_1309.end(), itprogram_1319!= programs_130b.end(); ++itstate_1312, ++itprogram_1319)
	{
		bool isUnique= isInputUnique( *itstate_1312, *itprogram_1319);
		if( !isUnique)
			continue;
		Packets_t onestate_1316( 1, *itstate_1312);
		Packets_t oneprogram_131d( 1, *itprogram_1319);
		executeOne( onestate_1316, oneprogram_131d);
	}
}

void NoFunctionStates_1308::executeOne( const Packets_t& states_1309, const Packets_t& programs_130b)
{
	Packets_t states_1322;
	Packets_t programs_1325;
	NotFunctionState_131f notFunctionState_131f;
	bool isMatchNotFunctionState_131f= notFunctionState_131f( states_1309, programs_130b, states_1322, programs_1325);
	_state_130f->insert( _state_130f->end(), states_1322.begin(), states_1322.end());
	_program_1310->insert( _program_1310->end(), programs_1325.begin(), programs_1325.end());
	if( isMatchNotFunctionState_131f)
		return;
}

bool NoFunctionStates_1308::isInputUnique( const Udm::Object& state_1313, const Udm::Object& program_131a)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_1315= _state_1311.begin(), itprogram_131c= _program_1318.begin(); itstate_1315!= _state_1311.end(), itprogram_131c!= _program_1318.end(); ++itstate_1315, ++itprogram_131c)
	{
		if( ( *itstate_1315== state_1313)&& ( *itprogram_131c== program_131a))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1311.push_back( state_1313);
		_program_1318.push_back( program_131a);
	}
	return isUnique;
}

bool NotFunctionState_131f::operator()( const Packets_t& states_1320, const Packets_t& programs_1323, Packets_t& states_1322, Packets_t& programs_1325)
{
#ifdef PRINT_INFO
	printLog( "NotFunctionState_131f" );
#endif
	_state_1326= &states_1322;
	_program_1327= &programs_1325;
	processInputPackets( states_1320, programs_1323);
	if( false== _matches.empty())
		return true;
	return false;
}

bool NotFunctionState_131f::isInputUnique( const Udm::Object& state_132c, const Udm::Object& program_1335)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_132e= _state_1328.begin(), itProgram_1337= _program_1331.begin(); itState_132e!= _state_1328.end(), itProgram_1337!= _program_1331.end(); ++itState_132e, ++itProgram_1337)
	{
		if( ( *itState_132e== state_132c)&& ( *itProgram_1337== program_1335))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1328.push_back( state_132c);
		_program_1331.push_back( program_1335);
	}
	return isUnique;
}

bool NotFunctionState_131f::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool NotFunctionState_131f::isGuardTrue( SFC::Program& Program, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	return static_cast< std::string >( State.Decomposition() ) != "FUNC_STATE";;
	return Gz_guard;
}

void NotFunctionState_131f::processInputPackets( const Packets_t& states_1320, const Packets_t& programs_1323)
{
	for( Packets_t::const_iterator itState_1329= states_1320.begin(), itProgram_1332= programs_1323.begin(); itState_1329!= states_1320.end(), itProgram_1332!= programs_1323.end(); ++itState_1329, ++itProgram_1332)
	{
		bool isUnique= isInputUnique( *itState_1329, *itProgram_1332);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1329, *itProgram_1332);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_133e, currMatch.program_133f);
	}
}

bool NotFunctionState_131f::patternMatcher( const Udm::Object& state_132a, const Udm::Object& program_1333)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_132a.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_132f= CyPhyML::SignalFlow::State::Cast( state_132a);
		if( false== Uml::IsDerivedFrom( program_1333.type(), SFC::Program::meta))
			continue;
		SFC::Program program_1338= SFC::Program::Cast( program_1333);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_133d;
		if( !isValidBound(boundObjs_133d, state_132f, true))
			continue;
		currMatch.state_133e= state_132f;
		if( !isValidBound(boundObjs_133d, program_1338, true))
			continue;
		currMatch.program_133f= program_1338;
		bool Gz_guard= isGuardTrue( currMatch.program_133f, currMatch.state_133e);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void NotFunctionState_131f::outputAppender( const CyPhyML::SignalFlow::State& state_1342, const SFC::Program& program_1344)
{
	_state_1326->push_back( state_1342);
	_program_1327->push_back( program_1344);
}

void PopulateExecFunction_1346::operator()( const Packets_t& states_1347, const Packets_t& programs_1349, Packets_t& states_134b, Packets_t& programs_134c)
{
#ifdef PRINT_INFO
	printLog( "PopulateExecFunction_1346" );
#endif
	_state_134d= &states_134b;
	_program_134e= &programs_134c;
	if( ( !states_1347.empty()))
		callInitTransConnMap_19e2( states_1347);
	_state_134d->insert( _state_134d->end(), states_1347.begin(), states_1347.end());
	_program_134e->insert( _program_134e->end(), programs_1349.begin(), programs_1349.end());
}

void PopulateExecFunction_1346::callInitTransConnMap_19e2( const Packets_t& states_19d9)
{
	Packets_t states_19db;
	InitTransConnMap_19d8 initTransConnMap_19d8;
	initTransConnMap_19d8( states_19d9, states_19db);
	if( ( !states_19db.empty()))
		callOuterTransitions_19e4( states_19db);
}

void PopulateExecFunction_1346::callOuterTransitions_19e4( const Packets_t& states_1963)
{
	Packets_t states_1965;
	OuterTransitions_1962 outerTransitions_1962;
	outerTransitions_1962( states_1963, states_1965);
	if( ( !states_1965.empty()))
		callDuringAction_19e6( states_1965);
}

void PopulateExecFunction_1346::callDuringAction_19e6( const Packets_t& states_194c)
{
	Packets_t states_194e;
	DuringAction_194b duringAction_194b;
	duringAction_194b( states_194c, states_194e);
	if( ( !states_194e.empty()))
		callInitTransConnMapInner_19e8( states_194e);
}

void PopulateExecFunction_1346::callInitTransConnMapInner_19e8( const Packets_t& states_18fe)
{
	Packets_t states_1900;
	InitTransConnMapInner_18fd initTransConnMapInner_18fd;
	initTransConnMapInner_18fd( states_18fe, states_1900);
	if( ( !states_1900.empty()))
		callInnerTransitions_19ea( states_1900);
}

void PopulateExecFunction_1346::callInnerTransitions_19ea( const Packets_t& states_164c)
{
	Packets_t states_164e;
	InnerTransitions_164b innerTransitions_164b;
	innerTransitions_164b( states_164c, states_164e);
	if( ( !states_164e.empty()))
		callExecChildren_19ec( states_164e);
}

void PopulateExecFunction_1346::callExecChildren_19ec( const Packets_t& states_1350)
{
	ExecChildren_134f execChildren_134f;
	execChildren_134f( states_1350);
}

void ExecChildren_134f::operator()( const Packets_t& states_1350)
{
#ifdef PRINT_INFO
	printLog( "ExecChildren_134f" );
#endif
	if( ( !states_1350.empty()))
		callGetExecFcn_1627( states_1350);
}

void ExecChildren_134f::callGetExecFcn_1627( const Packets_t& states_160e)
{
	Packets_t states_1610;
	Packets_t functions_1611;
	GetExecFcn_160d getExecFcn_160d;
	getExecFcn_160d( states_160e, states_1610, functions_1611);
	if( ( !states_1610.empty())&& ( !functions_1611.empty()))
		callChildStateType_1629( states_1610, functions_1611);
}

void ExecChildren_134f::callChildStateType_1629( const Packets_t& states_152f, const Packets_t& css_1531)
{
	Packets_t states_1533;
	Packets_t css_1534;
	Packets_t states_1535;
	Packets_t css_1536;
	ChildStateType_152e childStateType_152e;
	childStateType_152e( states_152f, css_1531, states_1533, css_1534, states_1535, css_1536);
	if( ( !states_1533.empty())&& ( !css_1534.empty()))
		callTopLevelState_162c( states_1533, css_1534);
	if( ( !states_1535.empty())&& ( !css_1536.empty()))
		callCG_162f( states_1535, css_1536);
}

void ExecChildren_134f::callTopLevelState_162c( const Packets_t& states_1499, const Packets_t& css_149b)
{
	Packets_t states_149d;
	Packets_t css_149e;
	Packets_t states_149f;
	Packets_t css_14a0;
	TopLevelState_1498 topLevelState_1498;
	topLevelState_1498( states_1499, css_149b, states_149d, css_149e, states_149f, css_14a0);
	if( ( !states_149f.empty())&& ( !css_14a0.empty()))
		callChildStatesExec_1632( states_149f, css_14a0);
	if( ( !states_149d.empty())&& ( !css_149e.empty()))
		callCreateCG_1635( states_149d, css_149e);
}

void ExecChildren_134f::callCG_162f( const Packets_t& states_15e8, const Packets_t& compoundStatements_15eb)
{
	Packets_t states_15ea;
	Packets_t conditionalGroups_15ed;
	CG_15e7 cG_15e7;
	cG_15e7( states_15e8, compoundStatements_15eb, states_15ea, conditionalGroups_15ed);
	if( ( !states_15ea.empty())&& ( !conditionalGroups_15ed.empty()))
		callCallActiveChildExec_1638( states_15ea, conditionalGroups_15ed);
}

void ExecChildren_134f::callChildStatesExec_1632( const Packets_t& states_1380, const Packets_t& css_1382)
{
	ChildStatesExec_137f childStatesExec_137f;
	childStatesExec_137f( states_1380, css_1382);
}

void ExecChildren_134f::callCreateCG_1635( const Packets_t& states_1473, const Packets_t& execs_1476)
{
	Packets_t states_1475;
	Packets_t conditionalGroups_1478;
	CreateCG_1472 createCG_1472;
	createCG_1472( states_1473, execs_1476, states_1475, conditionalGroups_1478);
	if( ( !states_1475.empty())&& ( !conditionalGroups_1478.empty()))
		callEnterFunctionCondition_163b( states_1475, conditionalGroups_1478);
}

void ExecChildren_134f::callCallActiveChildExec_1638( const Packets_t& states_159b, const Packets_t& css_159d)
{
	Packets_t states_159f;
	Packets_t css_15a0;
	CallActiveChildExec_159a callActiveChildExec_159a;
	callActiveChildExec_159a( states_159b, css_159d, states_159f, css_15a0);
	if( ( !states_159f.empty())&& ( !css_15a0.empty()))
		callTransStartMap_163e( states_159f, css_15a0);
}

void ExecChildren_134f::callEnterFunctionCondition_163b( const Packets_t& states_13ea, const Packets_t& cgs_13ec)
{
	Packets_t states_13ee;
	Packets_t cgs_13ef;
	EnterFunctionCondition_13e9 enterFunctionCondition_13e9;
	enterFunctionCondition_13e9( states_13ea, cgs_13ec, states_13ee, cgs_13ef);
	if( ( !states_13ee.empty())&& ( !cgs_13ef.empty()))
		callExecFunctionCondition_1641( states_13ee, cgs_13ef);
}

void ExecChildren_134f::callTransStartMap_163e( const Packets_t& states_a08, const Packets_t& css_a0a)
{
	Packets_t states_a0c;
	Packets_t css_a0d;
	TransStartMap_a07 transStartMap_a07;
	transStartMap_a07( states_a08, css_a0a, states_a0c, css_a0d);
	if( ( !states_a0c.empty())&& ( !css_a0d.empty()))
		callDefaultCondition_1644( states_a0c, css_a0d);
}

void ExecChildren_134f::callExecFunctionCondition_1641( const Packets_t& states_1353, const Packets_t& cgs_1355)
{
	ExecFunctionCondition_1352 execFunctionCondition_1352;
	execFunctionCondition_1352( states_1353, cgs_1355);
}

void ExecChildren_134f::callDefaultCondition_1644( const Packets_t& states_1502, const Packets_t& compoundStatements_1506)
{
	Packets_t states_1504;
	Packets_t functions_1505;
	Packets_t conditionalBlocks_1508;
	DefaultCondition_1501 defaultCondition_1501;
	defaultCondition_1501( states_1502, compoundStatements_1506, states_1504, functions_1505, conditionalBlocks_1508);
	if( ( !states_1504.empty())&& ( !functions_1505.empty())&& ( !conditionalBlocks_1508.empty()))
		callTransStartTransitions_1647( states_1504, functions_1505, conditionalBlocks_1508);
}

void ExecChildren_134f::callTransStartTransitions_1647( const Packets_t& states_b2, const Packets_t& fcns_b4, const Packets_t& css_b6)
{
	TransStartTransitions_b1 transStartTransitions_b1;
	transStartTransitions_b1( states_b2, fcns_b4, css_b6);
}

void ExecFunctionCondition_1352::operator()( const Packets_t& states_1353, const Packets_t& cgs_1355)
{
#ifdef PRINT_INFO
	printLog( "ExecFunctionCondition_1352" );
#endif
	if( ( !states_1353.empty())&& ( !cgs_1355.empty()))
		callCreateDefaultCB_13e3( states_1353, cgs_1355);
}

void ExecFunctionCondition_1352::callCreateDefaultCB_13e3( const Packets_t& states_1358, const Packets_t& conditionalGroups_135b)
{
	Packets_t states_135a;
	Packets_t conditionalBlocks_135d;
	CreateDefaultCB_1357 createDefaultCB_1357;
	createDefaultCB_1357( states_1358, conditionalGroups_135b, states_135a, conditionalBlocks_135d);
	if( ( !states_135a.empty())&& ( !conditionalBlocks_135d.empty()))
		callChildStatesExec_13e6( states_135a, conditionalBlocks_135d);
}

void ExecFunctionCondition_1352::callChildStatesExec_13e6( const Packets_t& states_1380, const Packets_t& css_1382)
{
	ChildStatesExec_137f childStatesExec_137f;
	childStatesExec_137f( states_1380, css_1382);
}

void CreateDefaultCB_1357::operator()( const Packets_t& states_1358, const Packets_t& conditionalGroups_135b, Packets_t& states_135a, Packets_t& conditionalBlocks_135d)
{
#ifdef PRINT_INFO
	printLog( "CreateDefaultCB_1357" );
#endif
	RTTGenerator::Instance()->generateRule(494, "CreateDefaultCB");
	_state_135e= &states_135a;
	_conditionalBlock_135f= &conditionalBlocks_135d;
	processInputPackets( states_1358, conditionalGroups_135b);
}

bool CreateDefaultCB_1357::isInputUnique( const Udm::Object& state_1364, const Udm::Object& conditionalGroup_136d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1366= _state_1360.begin(), itConditionalGroup_136f= _conditionalGroup_1369.begin(); itState_1366!= _state_1360.end(), itConditionalGroup_136f!= _conditionalGroup_1369.end(); ++itState_1366, ++itConditionalGroup_136f)
	{
		if( ( *itState_1366== state_1364)&& ( *itConditionalGroup_136f== conditionalGroup_136d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1360.push_back( state_1364);
		_conditionalGroup_1369.push_back( conditionalGroup_136d);
	}
	return isUnique;
}

bool CreateDefaultCB_1357::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateDefaultCB_1357::processInputPackets( const Packets_t& states_1358, const Packets_t& conditionalGroups_135b)
{
	for( Packets_t::const_iterator itState_1361= states_1358.begin(), itConditionalGroup_136a= conditionalGroups_135b.begin(); itState_1361!= states_1358.end(), itConditionalGroup_136a!= conditionalGroups_135b.end(); ++itState_1361, ++itConditionalGroup_136a)
	{
		bool isUnique= isInputUnique( *itState_1361, *itConditionalGroup_136a);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1361, *itConditionalGroup_136a);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateDefaultCB_1357::patternMatcher( const Udm::Object& state_1362, const Udm::Object& conditionalGroup_136b)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1362.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1367= CyPhyML::SignalFlow::State::Cast( state_1362);
		if( false== Uml::IsDerivedFrom( conditionalGroup_136b.type(), SFC::ConditionalGroup::meta))
			continue;
		SFC::ConditionalGroup conditionalGroup_1370= SFC::ConditionalGroup::Cast( conditionalGroup_136b);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1375;
		if( !isValidBound(boundObjs_1375, state_1367, true))
			continue;
		currMatch.state_1376= state_1367;
		if( !isValidBound(boundObjs_1375, conditionalGroup_1370, true))
			continue;
		currMatch.conditionalGroup_1377= conditionalGroup_1370;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateDefaultCB_1357::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_1378= SFC::ConditionalBlock::Create( currMatch.conditionalGroup_1377, SFC::ConditionalGroup::meta_stmnt);
		SFC::UserCode newUserCode_1379= SFC::UserCode::Create( newConditionalBlock_1378, SFC::ConditionalBlock::meta_cond);
		SFC::Int newOne_137a= SFC::Int::Create( newUserCode_1379, SFC::UserCode::meta_codeexpr);
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_1378;
		SFC::ConditionalGroup& ConditionalGroup= currMatch.conditionalGroup_1377;
		SFC::Int& One= newOne_137a;
		CyPhyML::SignalFlow::State& State= currMatch.state_1376;
		SFC::UserCode& UserCode= newUserCode_1379;
		{
ConditionalBlock.RefId() = UserCode.RefId() = ConditionalGroup.RefId();
};
		{
__int64 statementCount = ConditionalGroup.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
ConditionalGroup.statementCount() = statementCount;
};
		{
One.val() = 1;
};
		outputAppender( currMatch.state_1376, newConditionalBlock_1378);
	}
}

void CreateDefaultCB_1357::outputAppender( const CyPhyML::SignalFlow::State& state_137b, const SFC::ConditionalBlock& conditionalBlock_137d)
{
	_state_135e->push_back( state_137b);
	_conditionalBlock_135f->push_back( conditionalBlock_137d);
}

void ChildStatesExec_137f::operator()( const Packets_t& states_1380, const Packets_t& css_1382)
{
#ifdef PRINT_INFO
	printLog( "ChildStatesExec_137f" );
#endif
	if( ( !states_1380.empty())&& ( !css_1382.empty()))
		callGetChildStates_13dc( states_1380, css_1382);
}

void ChildStatesExec_137f::callGetChildStates_13dc( const Packets_t& states_13b0, const Packets_t& compoundStatements_13b4)
{
	Packets_t states_13b2;
	Packets_t childStates_13b3;
	Packets_t compoundStatements_13b6;
	GetChildStates_13af getChildStates_13af;
	getChildStates_13af( states_13b0, compoundStatements_13b4, states_13b2, childStates_13b3, compoundStatements_13b6);
	if( ( !states_13b2.empty())&& ( !childStates_13b3.empty())&& ( !compoundStatements_13b6.empty()))
		callExecChildAndStates_13df( states_13b2, childStates_13b3, compoundStatements_13b6);
}

void ChildStatesExec_137f::callExecChildAndStates_13df( const Packets_t& states_1385, const Packets_t& childStates_1387, const Packets_t& compoundStatements_1389)
{
	ExecChildAndStates_1384 execChildAndStates_1384;
	execChildAndStates_1384( states_1385, childStates_1387, compoundStatements_1389);
}

void ExecChildAndStates_1384::operator()( const Packets_t& states_1385, const Packets_t& childStates_1387, const Packets_t& compoundStatements_1389)
{
#ifdef PRINT_INFO
	printLog( "ExecChildAndStates_1384" );
#endif
	RTTGenerator::Instance()->generateRule(509, "ExecChildAndStates");
	processInputPackets( states_1385, childStates_1387, compoundStatements_1389);
}

bool ExecChildAndStates_1384::isInputUnique( const Udm::Object& state_138f, const Udm::Object& childState_1398, const Udm::Object& compoundStatement_13a1)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1391= _state_138b.begin(), itChildState_139a= _childState_1394.begin(), itCompoundStatement_13a3= _compoundStatement_139d.begin(); itState_1391!= _state_138b.end(), itChildState_139a!= _childState_1394.end(), itCompoundStatement_13a3!= _compoundStatement_139d.end(); ++itState_1391, ++itChildState_139a, ++itCompoundStatement_13a3)
	{
		if( ( *itState_1391== state_138f)&& ( *itChildState_139a== childState_1398)&& ( *itCompoundStatement_13a3== compoundStatement_13a1))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_138b.push_back( state_138f);
		_childState_1394.push_back( childState_1398);
		_compoundStatement_139d.push_back( compoundStatement_13a1);
	}
	return isUnique;
}

void ExecChildAndStates_1384::processInputPackets( const Packets_t& states_1385, const Packets_t& childStates_1387, const Packets_t& compoundStatements_1389)
{
	for( Packets_t::const_iterator itState_138c= states_1385.begin(), itChildState_1395= childStates_1387.begin(), itCompoundStatement_139e= compoundStatements_1389.begin(); itState_138c!= states_1385.end(), itChildState_1395!= childStates_1387.end(), itCompoundStatement_139e!= compoundStatements_1389.end(); ++itState_138c, ++itChildState_1395, ++itCompoundStatement_139e)
	{
		bool isUnique= isInputUnique( *itState_138c, *itChildState_1395, *itCompoundStatement_139e);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_138c, *itChildState_1395, *itCompoundStatement_139e);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ExecChildAndStates_1384::patternMatcher( const Udm::Object& state_138d, const Udm::Object& childState_1396, const Udm::Object& compoundStatement_139f)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_138d.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1392= CyPhyML::SignalFlow::State::Cast( state_138d);
		if( false== Uml::IsDerivedFrom( childState_1396.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State childState_139b= CyPhyML::SignalFlow::State::Cast( childState_1396);
		if( false== Uml::IsDerivedFrom( compoundStatement_139f.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_13a4= SFC::CompoundStatement::Cast( compoundStatement_139f);
		set< SFC::Function> functions_13a6= childState_139b.exec();
		for( set< SFC::Function>::const_iterator itFunctions_13a7= functions_13a6.begin(); itFunctions_13a7!= functions_13a6.end(); ++itFunctions_13a7)
		{
			SFC::Function currFunction_13a8= *itFunctions_13a7;
			Match currMatch;
			currMatch.state_13aa= state_1392;
			currMatch.childState_13ab= childState_139b;
			currMatch.compoundStatement_13ac= compoundStatement_13a4;
			currMatch.function_13ad= currFunction_13a8;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void ExecChildAndStates_1384::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::FunctionCall newFunctionCall_13ae= SFC::FunctionCall::Create( currMatch.compoundStatement_13ac, SFC::CompoundStatement::meta_stmnt);
		CyPhyML::SignalFlow::State& ChildState= currMatch.childState_13ab;
		SFC::CompoundStatement& CompoundStatement= currMatch.compoundStatement_13ac;
		SFC::Function& Function= currMatch.function_13ad;
		SFC::FunctionCall& FunctionCall= newFunctionCall_13ae;
		CyPhyML::SignalFlow::State& State= currMatch.state_13aa;
		{
FunctionCall.RefId() = CompoundStatement.RefId();
};
		{
__int64 statementCount = CompoundStatement.statementCount();
FunctionCall.statementIndex() = statementCount++;
CompoundStatement.statementCount() = statementCount;
};
		newFunctionCall_13ae.callee()= currMatch.function_13ad;
	}
}

void GetChildStates_13af::operator()( const Packets_t& states_13b0, const Packets_t& compoundStatements_13b4, Packets_t& states_13b2, Packets_t& childStates_13b3, Packets_t& compoundStatements_13b6)
{
#ifdef PRINT_INFO
	printLog( "GetChildStates_13af" );
#endif
	RTTGenerator::Instance()->generateRule(670, "GetChildStates");
	_state_13b7= &states_13b2;
	_childState_13b8= &childStates_13b3;
	_compoundStatement_13b9= &compoundStatements_13b6;
	processInputPackets( states_13b0, compoundStatements_13b4);
	sortOutputs( );
}

bool GetChildStates_13af::isInputUnique( const Udm::Object& state_13be, const Udm::Object& compoundStatement_13c7)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_13c0= _state_13ba.begin(), itCompoundStatement_13c9= _compoundStatement_13c3.begin(); itState_13c0!= _state_13ba.end(), itCompoundStatement_13c9!= _compoundStatement_13c3.end(); ++itState_13c0, ++itCompoundStatement_13c9)
	{
		if( ( *itState_13c0== state_13be)&& ( *itCompoundStatement_13c9== compoundStatement_13c7))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_13ba.push_back( state_13be);
		_compoundStatement_13c3.push_back( compoundStatement_13c7);
	}
	return isUnique;
}

bool GetChildStates_13af::isGuardTrue( CyPhyML::SignalFlow::State& ChildState, SFC::CompoundStatement& CompoundStatement, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	return static_cast< std::string >( ChildState.Decomposition() ) != "FUNC_STATE";;
	return Gz_guard;
}

void GetChildStates_13af::processInputPackets( const Packets_t& states_13b0, const Packets_t& compoundStatements_13b4)
{
	for( Packets_t::const_iterator itState_13bb= states_13b0.begin(), itCompoundStatement_13c4= compoundStatements_13b4.begin(); itState_13bb!= states_13b0.end(), itCompoundStatement_13c4!= compoundStatements_13b4.end(); ++itState_13bb, ++itCompoundStatement_13c4)
	{
		bool isUnique= isInputUnique( *itState_13bb, *itCompoundStatement_13c4);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_13bb, *itCompoundStatement_13c4);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetChildStates_13af::patternMatcher( const Udm::Object& state_13bc, const Udm::Object& compoundStatement_13c5)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_13bc.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_13c1= CyPhyML::SignalFlow::State::Cast( state_13bc);
		if( false== Uml::IsDerivedFrom( compoundStatement_13c5.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_13ca= SFC::CompoundStatement::Cast( compoundStatement_13c5);
		set< CyPhyML::SignalFlow::State> childStates_13cc= state_13c1.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itChildState_13cd= childStates_13cc.begin(); itChildState_13cd!= childStates_13cc.end(); ++itChildState_13cd)
		{
			CyPhyML::SignalFlow::State currChildState_13ce= *itChildState_13cd;
			Match currMatch;
			currMatch.state_13d0= state_13c1;
			currMatch.compoundStatement_13d1= compoundStatement_13ca;
			currMatch.childState_13d2= currChildState_13ce;
			bool Gz_guard= isGuardTrue( currMatch.childState_13d2, currMatch.compoundStatement_13d1, currMatch.state_13d0);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetChildStates_13af::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_13d0, currMatch.childState_13d2, currMatch.compoundStatement_13d1);
	}
}

void GetChildStates_13af::outputAppender( const CyPhyML::SignalFlow::State& state_13d6, const CyPhyML::SignalFlow::State& childState_13d8, const SFC::CompoundStatement& compoundStatement_13da)
{
	_state_13b7->push_back( state_13d6);
	_childState_13b8->push_back( childState_13d8);
	_compoundStatement_13b9->push_back( compoundStatement_13da);
}

void GetChildStates_13af::sortOutputs()
{
	typedef std::multiset< CyPhyML::SignalFlow::State, std::pointer_to_binary_function< const CyPhyML::SignalFlow::State&, const CyPhyML::SignalFlow::State&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const CyPhyML::SignalFlow::State&, const CyPhyML::SignalFlow::State&, bool> ptr_StateOrder( StateOrder< CyPhyML::SignalFlow::State>);
	SortedSet_t sortedSet( ptr_StateOrder);
	std::vector< int> permutationVector( _childState_13b8->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _childState_13b8->begin(); it!= _childState_13b8->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( CyPhyML::SignalFlow::State::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _childState_13b8->begin());
	// order rest of the containers
	permutate( permutationVector, *_state_13b7);
	permutate( permutationVector, *_compoundStatement_13b9);
}

void EnterFunctionCondition_13e9::operator()( const Packets_t& states_13ea, const Packets_t& cgs_13ec, Packets_t& states_13ee, Packets_t& cgs_13ef)
{
#ifdef PRINT_INFO
	printLog( "EnterFunctionCondition_13e9" );
#endif
	_state_13f0= &states_13ee;
	_cg_13f1= &cgs_13ef;
	if( ( !states_13ea.empty())&& ( !cgs_13ec.empty()))
		callCreateCB_1468( states_13ea, cgs_13ec);
	_state_13f0->insert( _state_13f0->end(), states_13ea.begin(), states_13ea.end());
	_cg_13f1->insert( _cg_13f1->end(), cgs_13ec.begin(), cgs_13ec.end());
}

void EnterFunctionCondition_13e9::callCreateCB_1468( const Packets_t& states_1433, const Packets_t& conditionalGroups_1436)
{
	Packets_t states_1435;
	Packets_t conditionalBlocks_1438;
	CreateCB_1432 createCB_1432;
	createCB_1432( states_1433, conditionalGroups_1436, states_1435, conditionalBlocks_1438);
	if( ( !states_1435.empty())&& ( !conditionalBlocks_1438.empty()))
		callGetChildStates_146b( states_1435, conditionalBlocks_1438);
}

void EnterFunctionCondition_13e9::callGetChildStates_146b( const Packets_t& states_13b0, const Packets_t& compoundStatements_13b4)
{
	Packets_t states_13b2;
	Packets_t childStates_13b3;
	Packets_t compoundStatements_13b6;
	GetChildStates_13af getChildStates_13af;
	getChildStates_13af( states_13b0, compoundStatements_13b4, states_13b2, childStates_13b3, compoundStatements_13b6);
	if( ( !states_13b2.empty())&& ( !childStates_13b3.empty())&& ( !compoundStatements_13b6.empty()))
		callCallChildren_146e( states_13b2, childStates_13b3, compoundStatements_13b6);
}

void EnterFunctionCondition_13e9::callCallChildren_146e( const Packets_t& states_13f3, const Packets_t& childStates_13f5, const Packets_t& compoundStatements_13f7)
{
	CallChildren_13f2 callChildren_13f2;
	callChildren_13f2( states_13f3, childStates_13f5, compoundStatements_13f7);
}

void CallChildren_13f2::operator()( const Packets_t& states_13f3, const Packets_t& childStates_13f5, const Packets_t& compoundStatements_13f7)
{
#ifdef PRINT_INFO
	printLog( "CallChildren_13f2" );
#endif
	RTTGenerator::Instance()->generateRule(525, "CallChildren");
	processInputPackets( states_13f3, childStates_13f5, compoundStatements_13f7);
}

bool CallChildren_13f2::isInputUnique( const Udm::Object& state_13fd, const Udm::Object& childState_1406, const Udm::Object& compoundStatement_140f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_13ff= _state_13f9.begin(), itChildState_1408= _childState_1402.begin(), itCompoundStatement_1411= _compoundStatement_140b.begin(); itState_13ff!= _state_13f9.end(), itChildState_1408!= _childState_1402.end(), itCompoundStatement_1411!= _compoundStatement_140b.end(); ++itState_13ff, ++itChildState_1408, ++itCompoundStatement_1411)
	{
		if( ( *itState_13ff== state_13fd)&& ( *itChildState_1408== childState_1406)&& ( *itCompoundStatement_1411== compoundStatement_140f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_13f9.push_back( state_13fd);
		_childState_1402.push_back( childState_1406);
		_compoundStatement_140b.push_back( compoundStatement_140f);
	}
	return isUnique;
}

bool CallChildren_13f2::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool CallChildren_13f2::isGuardTrue( SFC::Arg& ChildArg0, SFC::Arg& ChildArg1, SFC::Function& ChildEnter, CyPhyML::SignalFlow::State& ChildState, SFC::CompoundStatement& CompoundStatement, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	return ChildArg0.argIndex() == 0 && ChildArg1.argIndex() == 1;;
	return Gz_guard;
}

void CallChildren_13f2::processInputPackets( const Packets_t& states_13f3, const Packets_t& childStates_13f5, const Packets_t& compoundStatements_13f7)
{
	for( Packets_t::const_iterator itState_13fa= states_13f3.begin(), itChildState_1403= childStates_13f5.begin(), itCompoundStatement_140c= compoundStatements_13f7.begin(); itState_13fa!= states_13f3.end(), itChildState_1403!= childStates_13f5.end(), itCompoundStatement_140c!= compoundStatements_13f7.end(); ++itState_13fa, ++itChildState_1403, ++itCompoundStatement_140c)
	{
		bool isUnique= isInputUnique( *itState_13fa, *itChildState_1403, *itCompoundStatement_140c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_13fa, *itChildState_1403, *itCompoundStatement_140c);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CallChildren_13f2::patternMatcher( const Udm::Object& state_13fb, const Udm::Object& childState_1404, const Udm::Object& compoundStatement_140d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_13fb.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1400= CyPhyML::SignalFlow::State::Cast( state_13fb);
		if( false== Uml::IsDerivedFrom( childState_1404.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State childState_1409= CyPhyML::SignalFlow::State::Cast( childState_1404);
		if( false== Uml::IsDerivedFrom( compoundStatement_140d.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1412= SFC::CompoundStatement::Cast( compoundStatement_140d);
		set< SFC::Function> childEnters_1414= childState_1409.enter();
		for( set< SFC::Function>::const_iterator itChildEnters_1415= childEnters_1414.begin(); itChildEnters_1415!= childEnters_1414.end(); ++itChildEnters_1415)
		{
			SFC::Function currChildEnter_1416= *itChildEnters_1415;
			set< SFC::Arg> childArg0s_1417= currChildEnter_1416.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itChildArg0_1418= childArg0s_1417.begin(); itChildArg0_1418!= childArg0s_1417.end(); ++itChildArg0_1418)
			{
				SFC::Arg currChildArg0_1419= *itChildArg0_1418;
				set< SFC::Arg> childArg1s_141a= currChildEnter_1416.Arg_kind_children();
				for( set< SFC::Arg>::const_iterator itChildArg1_141b= childArg1s_141a.begin(); itChildArg1_141b!= childArg1s_141a.end(); ++itChildArg1_141b)
				{
					SFC::Arg currChildArg1_141c= *itChildArg1_141b;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_1420;
					if( !isValidBound(boundObjs_1420, state_1400, true))
						continue;
					currMatch.state_1421= state_1400;
					if( !isValidBound(boundObjs_1420, childState_1409, true))
						continue;
					currMatch.childState_1422= childState_1409;
					if( !isValidBound(boundObjs_1420, compoundStatement_1412, true))
						continue;
					currMatch.compoundStatement_1423= compoundStatement_1412;
					if( !isValidBound(boundObjs_1420, currChildArg0_1419, false))
						continue;
					currMatch.childArg0_1424= currChildArg0_1419;
					if( !isValidBound(boundObjs_1420, currChildArg1_141c, false))
						continue;
					currMatch.childArg1_1425= currChildArg1_141c;
					if( !isValidBound(boundObjs_1420, currChildEnter_1416, false))
						continue;
					currMatch.childEnter_1426= currChildEnter_1416;
					bool Gz_guard= isGuardTrue( currMatch.childArg0_1424, currMatch.childArg1_1425, currMatch.childEnter_1426, currMatch.childState_1422, currMatch.compoundStatement_1423, currMatch.state_1421);
					if( true== Gz_guard)
						_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void CallChildren_13f2::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::FunctionCall newFunctionCall_142d= SFC::FunctionCall::Create( currMatch.compoundStatement_1423, SFC::CompoundStatement::meta_stmnt);
		SFC::ArgVal newArgVal0_142e= SFC::ArgVal::Create( newFunctionCall_142d);
		SFC::Int newTwo_142f= SFC::Int::Create( newArgVal0_142e, SFC::ArgVal::meta_argexpr);
		SFC::ArgVal newArgVal1_1430= SFC::ArgVal::Create( newFunctionCall_142d);
		SFC::Int newZero_1431= SFC::Int::Create( newArgVal1_1430, SFC::ArgVal::meta_argexpr);
		SFC::ArgVal& ArgVal0= newArgVal0_142e;
		SFC::ArgVal& ArgVal1= newArgVal1_1430;
		SFC::Arg& ChildArg0= currMatch.childArg0_1424;
		SFC::Arg& ChildArg1= currMatch.childArg1_1425;
		SFC::Function& ChildEnter= currMatch.childEnter_1426;
		CyPhyML::SignalFlow::State& ChildState= currMatch.childState_1422;
		SFC::CompoundStatement& CompoundStatement= currMatch.compoundStatement_1423;
		SFC::FunctionCall& FunctionCall= newFunctionCall_142d;
		CyPhyML::SignalFlow::State& State= currMatch.state_1421;
		SFC::Int& Two= newTwo_142f;
		SFC::Int& Zero= newZero_1431;
		{
FunctionCall.RefId() = CompoundStatement.RefId();
};
		{
Zero.val() = 0;
};
		{
ArgVal0.argIndex() = 0;
};
		{
ArgVal1.argIndex() = 1;
};
		{
Two.val() = 2;
};
		{
__int64 statementCount = CompoundStatement.statementCount();
FunctionCall.statementIndex() = statementCount++;
CompoundStatement.statementCount() = statementCount;
};
		{
FunctionCall.argCount() = 2;
};
		newArgVal0_142e.arg()+= currMatch.childArg0_1424;
		newArgVal1_1430.arg()+= currMatch.childArg1_1425;
		newFunctionCall_142d.callee()= currMatch.childEnter_1426;
	}
}

void CreateCB_1432::operator()( const Packets_t& states_1433, const Packets_t& conditionalGroups_1436, Packets_t& states_1435, Packets_t& conditionalBlocks_1438)
{
#ifdef PRINT_INFO
	printLog( "CreateCB_1432" );
#endif
	RTTGenerator::Instance()->generateRule(555, "CreateCB");
	_state_1439= &states_1435;
	_conditionalBlock_143a= &conditionalBlocks_1438;
	processInputPackets( states_1433, conditionalGroups_1436);
}

bool CreateCB_1432::isInputUnique( const Udm::Object& state_143f, const Udm::Object& conditionalGroup_1448)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1441= _state_143b.begin(), itConditionalGroup_144a= _conditionalGroup_1444.begin(); itState_1441!= _state_143b.end(), itConditionalGroup_144a!= _conditionalGroup_1444.end(); ++itState_1441, ++itConditionalGroup_144a)
	{
		if( ( *itState_1441== state_143f)&& ( *itConditionalGroup_144a== conditionalGroup_1448))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_143b.push_back( state_143f);
		_conditionalGroup_1444.push_back( conditionalGroup_1448);
	}
	return isUnique;
}

bool CreateCB_1432::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateCB_1432::processInputPackets( const Packets_t& states_1433, const Packets_t& conditionalGroups_1436)
{
	for( Packets_t::const_iterator itState_143c= states_1433.begin(), itConditionalGroup_1445= conditionalGroups_1436.begin(); itState_143c!= states_1433.end(), itConditionalGroup_1445!= conditionalGroups_1436.end(); ++itState_143c, ++itConditionalGroup_1445)
	{
		bool isUnique= isInputUnique( *itState_143c, *itConditionalGroup_1445);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_143c, *itConditionalGroup_1445);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateCB_1432::patternMatcher( const Udm::Object& state_143d, const Udm::Object& conditionalGroup_1446)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_143d.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1442= CyPhyML::SignalFlow::State::Cast( state_143d);
		if( false== Uml::IsDerivedFrom( conditionalGroup_1446.type(), SFC::ConditionalGroup::meta))
			continue;
		SFC::ConditionalGroup conditionalGroup_144b= SFC::ConditionalGroup::Cast( conditionalGroup_1446);
		Udm::Object conditionalGroupParent_144d= conditionalGroup_144b.container();
		if( false== Uml::IsDerivedFrom( conditionalGroupParent_144d.type(), SFC::Function::meta))
			continue;
		SFC::Function functionConditionalGroup_144e= SFC::Function::Cast( conditionalGroupParent_144d);
		Udm::Object functionParent_144f= functionConditionalGroup_144e.container();
		if( false== Uml::IsDerivedFrom( functionParent_144f.type(), SFC::Program::meta))
			continue;
		SFC::Program programFunction_1450= SFC::Program::Cast( functionParent_144f);
		set< SFC::StateVar> stateVars_1451= programFunction_1450.StateVar_kind_children();
		for( set< SFC::StateVar>::const_iterator itStateVar_1452= stateVars_1451.begin(); itStateVar_1452!= stateVars_1451.end(); ++itStateVar_1452)
		{
			SFC::StateVar currStateVar_1453= *itStateVar_1452;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1457;
			if( !isValidBound(boundObjs_1457, state_1442, true))
				continue;
			currMatch.state_1458= state_1442;
			if( !isValidBound(boundObjs_1457, conditionalGroup_144b, true))
				continue;
			currMatch.conditionalGroup_1459= conditionalGroup_144b;
			if( !isValidBound(boundObjs_1457, functionConditionalGroup_144e, false))
				continue;
			currMatch.function_145a= functionConditionalGroup_144e;
			if( !isValidBound(boundObjs_1457, programFunction_1450, false))
				continue;
			currMatch.program_145b= programFunction_1450;
			if( !isValidBound(boundObjs_1457, currStateVar_1453, false))
				continue;
			currMatch.stateVar_145c= currStateVar_1453;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateCB_1432::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_145d= SFC::ConditionalBlock::Create( currMatch.conditionalGroup_1459, SFC::ConditionalGroup::meta_stmnt);
		SFC::UserCode newUserCode_145e= SFC::UserCode::Create( newConditionalBlock_145d, SFC::ConditionalBlock::meta_cond);
		SFC::BinaryExprs newLE_145f= SFC::BinaryExprs::Create( newUserCode_145e, SFC::UserCode::meta_codeexpr);
		SFC::BinaryExprs newIndexOp_1460= SFC::BinaryExprs::Create( newLE_145f, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef_1461= SFC::ArgDeclRef::Create( newIndexOp_1460, SFC::BinaryExprs::meta_leftexpr);
		SFC::Int newZero2_1462= SFC::Int::Create( newIndexOp_1460, SFC::BinaryExprs::meta_rightexpr);
		SFC::Int newZero1_1463= SFC::Int::Create( newLE_145f, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_1461;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_145d;
		SFC::ConditionalGroup& ConditionalGroup= currMatch.conditionalGroup_1459;
		SFC::Function& Function= currMatch.function_145a;
		SFC::BinaryExprs& IndexOp= newIndexOp_1460;
		SFC::BinaryExprs& LE= newLE_145f;
		SFC::Program& Program= currMatch.program_145b;
		CyPhyML::SignalFlow::State& State= currMatch.state_1458;
		SFC::StateVar& StateVar= currMatch.stateVar_145c;
		SFC::UserCode& UserCode= newUserCode_145e;
		SFC::Int& Zero1= newZero1_1463;
		SFC::Int& Zero2= newZero2_1462;
		{
ConditionalBlock.RefId() = UserCode.RefId() = ConditionalGroup.RefId();
};
		{
Zero2.val() = 0;
};
		{
IndexOp.op() = "[";
};
		{
Zero1.val() = 0;
};
		{
LE.op() = "<=";
};
		{
__int64 statementCount = ConditionalGroup.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
ConditionalGroup.statementCount() = statementCount;
};
		newArgDeclRef_1461.argdecl()= currMatch.stateVar_145c;
		outputAppender( currMatch.state_1458, newConditionalBlock_145d);
	}
}

void CreateCB_1432::outputAppender( const CyPhyML::SignalFlow::State& state_1464, const SFC::ConditionalBlock& conditionalBlock_1466)
{
	_state_1439->push_back( state_1464);
	_conditionalBlock_143a->push_back( conditionalBlock_1466);
}

void CreateCG_1472::operator()( const Packets_t& states_1473, const Packets_t& execs_1476, Packets_t& states_1475, Packets_t& conditionalGroups_1478)
{
#ifdef PRINT_INFO
	printLog( "CreateCG_1472" );
#endif
	RTTGenerator::Instance()->generateRule(585, "CreateCG");
	_state_1479= &states_1475;
	_conditionalGroup_147a= &conditionalGroups_1478;
	processInputPackets( states_1473, execs_1476);
}

bool CreateCG_1472::isInputUnique( const Udm::Object& state_147f, const Udm::Object& exec_1488)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1481= _state_147b.begin(), itExec_148a= _exec_1484.begin(); itState_1481!= _state_147b.end(), itExec_148a!= _exec_1484.end(); ++itState_1481, ++itExec_148a)
	{
		if( ( *itState_1481== state_147f)&& ( *itExec_148a== exec_1488))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_147b.push_back( state_147f);
		_exec_1484.push_back( exec_1488);
	}
	return isUnique;
}

bool CreateCG_1472::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateCG_1472::processInputPackets( const Packets_t& states_1473, const Packets_t& execs_1476)
{
	for( Packets_t::const_iterator itState_147c= states_1473.begin(), itExec_1485= execs_1476.begin(); itState_147c!= states_1473.end(), itExec_1485!= execs_1476.end(); ++itState_147c, ++itExec_1485)
	{
		bool isUnique= isInputUnique( *itState_147c, *itExec_1485);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_147c, *itExec_1485);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateCG_1472::patternMatcher( const Udm::Object& state_147d, const Udm::Object& exec_1486)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_147d.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1482= CyPhyML::SignalFlow::State::Cast( state_147d);
		if( false== Uml::IsDerivedFrom( exec_1486.type(), SFC::Function::meta))
			continue;
		SFC::Function exec_148b= SFC::Function::Cast( exec_1486);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1490;
		if( !isValidBound(boundObjs_1490, state_1482, true))
			continue;
		currMatch.state_1491= state_1482;
		if( !isValidBound(boundObjs_1490, exec_148b, true))
			continue;
		currMatch.exec_1492= exec_148b;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateCG_1472::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalGroup newConditionalGroup_1493= SFC::ConditionalGroup::Create( currMatch.exec_1492, SFC::Function::meta_stmnt);
		SFC::ConditionalGroup& ConditionalGroup= newConditionalGroup_1493;
		SFC::Function& Exec= currMatch.exec_1492;
		CyPhyML::SignalFlow::State& State= currMatch.state_1491;
		{
ConditionalGroup.RefId() = Exec.RefId();
};
		{
__int64 statementCount = Exec.statementCount();
ConditionalGroup.statementIndex() = statementCount++;
Exec.statementCount() = statementCount;
};
		outputAppender( currMatch.state_1491, newConditionalGroup_1493);
	}
}

void CreateCG_1472::outputAppender( const CyPhyML::SignalFlow::State& state_1494, const SFC::ConditionalGroup& conditionalGroup_1496)
{
	_state_1479->push_back( state_1494);
	_conditionalGroup_147a->push_back( conditionalGroup_1496);
}

void TopLevelState_1498::operator()( const Packets_t& states_1499, const Packets_t& css_149b, Packets_t& states_149d, Packets_t& css_149e, Packets_t& states_149f, Packets_t& css_14a0)
{
#ifdef PRINT_INFO
	printLog( "TopLevelState_1498" );
#endif
	_state_14a1= &states_149d;
	_cs_14a2= &css_149e;
	_state_14a3= &states_149f;
	_cs_14a4= &css_14a0;
	for( Packets_t::const_iterator itstate_14a6= states_1499.begin(), itcs_14ad= css_149b.begin(); itstate_14a6!= states_1499.end(), itcs_14ad!= css_149b.end(); ++itstate_14a6, ++itcs_14ad)
	{
		bool isUnique= isInputUnique( *itstate_14a6, *itcs_14ad);
		if( !isUnique)
			continue;
		Packets_t onestate_14aa( 1, *itstate_14a6);
		Packets_t onecs_14b1( 1, *itcs_14ad);
		executeOne( onestate_14aa, onecs_14b1);
	}
}

void TopLevelState_1498::executeOne( const Packets_t& states_1499, const Packets_t& css_149b)
{
	Packets_t states_14b6;
	Packets_t compoundStatements_14b9;
	IsTopLevelState_14b3 isTopLevelState_14b3;
	bool isMatchIsTopLevelState_14b3= isTopLevelState_14b3( states_1499, css_149b, states_14b6, compoundStatements_14b9);
	_state_14a1->insert( _state_14a1->end(), states_14b6.begin(), states_14b6.end());
	_cs_14a2->insert( _cs_14a2->end(), compoundStatements_14b9.begin(), compoundStatements_14b9.end());
	if( isMatchIsTopLevelState_14b3)
		return;
	Packets_t states_14df;
	Packets_t compoundStatements_14e2;
	Otherwise_14dc otherwise_14dc;
	bool isMatchOtherwise_14dc= otherwise_14dc( states_1499, css_149b, states_14df, compoundStatements_14e2);
	_state_14a3->insert( _state_14a3->end(), states_14df.begin(), states_14df.end());
	_cs_14a4->insert( _cs_14a4->end(), compoundStatements_14e2.begin(), compoundStatements_14e2.end());
	if( isMatchOtherwise_14dc)
		return;
}

bool TopLevelState_1498::isInputUnique( const Udm::Object& state_14a7, const Udm::Object& cs_14ae)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_14a9= _state_14a5.begin(), itcs_14b0= _cs_14ac.begin(); itstate_14a9!= _state_14a5.end(), itcs_14b0!= _cs_14ac.end(); ++itstate_14a9, ++itcs_14b0)
	{
		if( ( *itstate_14a9== state_14a7)&& ( *itcs_14b0== cs_14ae))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_14a5.push_back( state_14a7);
		_cs_14ac.push_back( cs_14ae);
	}
	return isUnique;
}

bool IsTopLevelState_14b3::operator()( const Packets_t& states_14b4, const Packets_t& compoundStatements_14b7, Packets_t& states_14b6, Packets_t& compoundStatements_14b9)
{
#ifdef PRINT_INFO
	printLog( "IsTopLevelState_14b3" );
#endif
	_state_14ba= &states_14b6;
	_compoundStatement_14bb= &compoundStatements_14b9;
	processInputPackets( states_14b4, compoundStatements_14b7);
	if( false== _matches.empty())
		return true;
	return false;
}

bool IsTopLevelState_14b3::isInputUnique( const Udm::Object& state_14c0, const Udm::Object& compoundStatement_14c9)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_14c2= _state_14bc.begin(), itCompoundStatement_14cb= _compoundStatement_14c5.begin(); itState_14c2!= _state_14bc.end(), itCompoundStatement_14cb!= _compoundStatement_14c5.end(); ++itState_14c2, ++itCompoundStatement_14cb)
	{
		if( ( *itState_14c2== state_14c0)&& ( *itCompoundStatement_14cb== compoundStatement_14c9))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_14bc.push_back( state_14c0);
		_compoundStatement_14c5.push_back( compoundStatement_14c9);
	}
	return isUnique;
}

bool IsTopLevelState_14b3::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void IsTopLevelState_14b3::processInputPackets( const Packets_t& states_14b4, const Packets_t& compoundStatements_14b7)
{
	for( Packets_t::const_iterator itState_14bd= states_14b4.begin(), itCompoundStatement_14c6= compoundStatements_14b7.begin(); itState_14bd!= states_14b4.end(), itCompoundStatement_14c6!= compoundStatements_14b7.end(); ++itState_14bd, ++itCompoundStatement_14c6)
	{
		bool isUnique= isInputUnique( *itState_14bd, *itCompoundStatement_14c6);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_14bd, *itCompoundStatement_14c6);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_14d5, currMatch.compoundStatement_14d6);
	}
}

bool IsTopLevelState_14b3::patternMatcher( const Udm::Object& state_14be, const Udm::Object& compoundStatement_14c7)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_14be.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_14c3= CyPhyML::SignalFlow::State::Cast( state_14be);
		if( false== Uml::IsDerivedFrom( compoundStatement_14c7.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_14cc= SFC::CompoundStatement::Cast( compoundStatement_14c7);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_14ce= state_14c3.referedbyConnectorRef();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRefs_14cf= connectorRefs_14ce.begin(); itConnectorRefs_14cf!= connectorRefs_14ce.end(); ++itConnectorRefs_14cf)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_14d0= *itConnectorRefs_14cf;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_14d4;
			if( !isValidBound(boundObjs_14d4, state_14c3, true))
				continue;
			currMatch.state_14d5= state_14c3;
			if( !isValidBound(boundObjs_14d4, compoundStatement_14cc, true))
				continue;
			currMatch.compoundStatement_14d6= compoundStatement_14cc;
			if( !isValidBound(boundObjs_14d4, currConnectorRef_14d0, false))
				continue;
			currMatch.connectorRef_14d7= currConnectorRef_14d0;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void IsTopLevelState_14b3::outputAppender( const CyPhyML::SignalFlow::State& state_14d8, const SFC::CompoundStatement& compoundStatement_14da)
{
	_state_14ba->push_back( state_14d8);
	_compoundStatement_14bb->push_back( compoundStatement_14da);
}

bool Otherwise_14dc::operator()( const Packets_t& states_14dd, const Packets_t& compoundStatements_14e0, Packets_t& states_14df, Packets_t& compoundStatements_14e2)
{
#ifdef PRINT_INFO
	printLog( "Otherwise_14dc" );
#endif
	_state_14e3= &states_14df;
	_compoundStatement_14e4= &compoundStatements_14e2;
	processInputPackets( states_14dd, compoundStatements_14e0);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_14dc::isInputUnique( const Udm::Object& state_14e9, const Udm::Object& compoundStatement_14f2)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_14eb= _state_14e5.begin(), itCompoundStatement_14f4= _compoundStatement_14ee.begin(); itState_14eb!= _state_14e5.end(), itCompoundStatement_14f4!= _compoundStatement_14ee.end(); ++itState_14eb, ++itCompoundStatement_14f4)
	{
		if( ( *itState_14eb== state_14e9)&& ( *itCompoundStatement_14f4== compoundStatement_14f2))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_14e5.push_back( state_14e9);
		_compoundStatement_14ee.push_back( compoundStatement_14f2);
	}
	return isUnique;
}

bool Otherwise_14dc::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_14dc::processInputPackets( const Packets_t& states_14dd, const Packets_t& compoundStatements_14e0)
{
	for( Packets_t::const_iterator itState_14e6= states_14dd.begin(), itCompoundStatement_14ef= compoundStatements_14e0.begin(); itState_14e6!= states_14dd.end(), itCompoundStatement_14ef!= compoundStatements_14e0.end(); ++itState_14e6, ++itCompoundStatement_14ef)
	{
		bool isUnique= isInputUnique( *itState_14e6, *itCompoundStatement_14ef);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_14e6, *itCompoundStatement_14ef);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_14fb, currMatch.compoundStatement_14fc);
	}
}

bool Otherwise_14dc::patternMatcher( const Udm::Object& state_14e7, const Udm::Object& compoundStatement_14f0)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_14e7.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_14ec= CyPhyML::SignalFlow::State::Cast( state_14e7);
		if( false== Uml::IsDerivedFrom( compoundStatement_14f0.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_14f5= SFC::CompoundStatement::Cast( compoundStatement_14f0);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_14fa;
		if( !isValidBound(boundObjs_14fa, state_14ec, true))
			continue;
		currMatch.state_14fb= state_14ec;
		if( !isValidBound(boundObjs_14fa, compoundStatement_14f5, true))
			continue;
		currMatch.compoundStatement_14fc= compoundStatement_14f5;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_14dc::outputAppender( const CyPhyML::SignalFlow::State& state_14fd, const SFC::CompoundStatement& compoundStatement_14ff)
{
	_state_14e3->push_back( state_14fd);
	_compoundStatement_14e4->push_back( compoundStatement_14ff);
}

void DefaultCondition_1501::operator()( const Packets_t& states_1502, const Packets_t& compoundStatements_1506, Packets_t& states_1504, Packets_t& functions_1505, Packets_t& conditionalBlocks_1508)
{
#ifdef PRINT_INFO
	printLog( "DefaultCondition_1501" );
#endif
	RTTGenerator::Instance()->generateRule(607, "DefaultCondition");
	_state_1509= &states_1504;
	_function_150a= &functions_1505;
	_conditionalBlock_150b= &conditionalBlocks_1508;
	processInputPackets( states_1502, compoundStatements_1506);
}

bool DefaultCondition_1501::isInputUnique( const Udm::Object& state_1510, const Udm::Object& compoundStatement_1519)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1512= _state_150c.begin(), itCompoundStatement_151b= _compoundStatement_1515.begin(); itState_1512!= _state_150c.end(), itCompoundStatement_151b!= _compoundStatement_1515.end(); ++itState_1512, ++itCompoundStatement_151b)
	{
		if( ( *itState_1512== state_1510)&& ( *itCompoundStatement_151b== compoundStatement_1519))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_150c.push_back( state_1510);
		_compoundStatement_1515.push_back( compoundStatement_1519);
	}
	return isUnique;
}

void DefaultCondition_1501::processInputPackets( const Packets_t& states_1502, const Packets_t& compoundStatements_1506)
{
	for( Packets_t::const_iterator itState_150d= states_1502.begin(), itCompoundStatement_1516= compoundStatements_1506.begin(); itState_150d!= states_1502.end(), itCompoundStatement_1516!= compoundStatements_1506.end(); ++itState_150d, ++itCompoundStatement_1516)
	{
		bool isUnique= isInputUnique( *itState_150d, *itCompoundStatement_1516);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_150d, *itCompoundStatement_1516);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool DefaultCondition_1501::patternMatcher( const Udm::Object& state_150e, const Udm::Object& compoundStatement_1517)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_150e.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1513= CyPhyML::SignalFlow::State::Cast( state_150e);
		if( false== Uml::IsDerivedFrom( compoundStatement_1517.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_151c= SFC::CompoundStatement::Cast( compoundStatement_1517);
		set< SFC::Function> functions_151e= state_1513.exec();
		for( set< SFC::Function>::const_iterator itFunctions_151f= functions_151e.begin(); itFunctions_151f!= functions_151e.end(); ++itFunctions_151f)
		{
			SFC::Function currFunction_1520= *itFunctions_151f;
			Match currMatch;
			currMatch.state_1522= state_1513;
			currMatch.compoundStatement_1523= compoundStatement_151c;
			currMatch.function_1524= currFunction_1520;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void DefaultCondition_1501::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_1525= SFC::ConditionalBlock::Create( currMatch.compoundStatement_1523, SFC::CompoundStatement::meta_stmnt);
		SFC::UserCode newUserCode_1526= SFC::UserCode::Create( newConditionalBlock_1525, SFC::ConditionalBlock::meta_cond);
		SFC::Int newOne_1527= SFC::Int::Create( newUserCode_1526, SFC::UserCode::meta_codeexpr);
		SFC::CompoundStatement& CompoundStatement= currMatch.compoundStatement_1523;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_1525;
		SFC::Function& Function= currMatch.function_1524;
		SFC::Int& One= newOne_1527;
		CyPhyML::SignalFlow::State& State= currMatch.state_1522;
		SFC::UserCode& UserCode= newUserCode_1526;
		{
ConditionalBlock.RefId() = UserCode.RefId() = CompoundStatement.RefId();
};
		{
One.val() = 1;
};
		{
__int64 statementCount = CompoundStatement.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
CompoundStatement.statementCount() = statementCount;
};
		outputAppender( currMatch.state_1522, currMatch.function_1524, newConditionalBlock_1525);
	}
}

void DefaultCondition_1501::outputAppender( const CyPhyML::SignalFlow::State& state_1528, const SFC::Function& function_152a, const SFC::ConditionalBlock& conditionalBlock_152c)
{
	_state_1509->push_back( state_1528);
	_function_150a->push_back( function_152a);
	_conditionalBlock_150b->push_back( conditionalBlock_152c);
}

void ChildStateType_152e::operator()( const Packets_t& states_152f, const Packets_t& css_1531, Packets_t& states_1533, Packets_t& css_1534, Packets_t& states_1535, Packets_t& css_1536)
{
#ifdef PRINT_INFO
	printLog( "ChildStateType_152e" );
#endif
	_state_1537= &states_1533;
	_cs_1538= &css_1534;
	_state_1539= &states_1535;
	_cs_153a= &css_1536;
	for( Packets_t::const_iterator itstate_153c= states_152f.begin(), itcs_1543= css_1531.begin(); itstate_153c!= states_152f.end(), itcs_1543!= css_1531.end(); ++itstate_153c, ++itcs_1543)
	{
		bool isUnique= isInputUnique( *itstate_153c, *itcs_1543);
		if( !isUnique)
			continue;
		Packets_t onestate_1540( 1, *itstate_153c);
		Packets_t onecs_1547( 1, *itcs_1543);
		executeOne( onestate_1540, onecs_1547);
	}
}

void ChildStateType_152e::executeOne( const Packets_t& states_152f, const Packets_t& css_1531)
{
	Packets_t states_154c;
	Packets_t compoundStatements_154f;
	ChildANDStates_1549 childANDStates_1549;
	bool isMatchChildANDStates_1549= childANDStates_1549( states_152f, css_1531, states_154c, compoundStatements_154f);
	_state_1537->insert( _state_1537->end(), states_154c.begin(), states_154c.end());
	_cs_1538->insert( _cs_1538->end(), compoundStatements_154f.begin(), compoundStatements_154f.end());
	if( isMatchChildANDStates_1549)
		return;
	Packets_t states_1578;
	Packets_t compoundStatements_157b;
	Otherwise_1575 otherwise_1575;
	bool isMatchOtherwise_1575= otherwise_1575( states_152f, css_1531, states_1578, compoundStatements_157b);
	_state_1539->insert( _state_1539->end(), states_1578.begin(), states_1578.end());
	_cs_153a->insert( _cs_153a->end(), compoundStatements_157b.begin(), compoundStatements_157b.end());
	if( isMatchOtherwise_1575)
		return;
}

bool ChildStateType_152e::isInputUnique( const Udm::Object& state_153d, const Udm::Object& cs_1544)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_153f= _state_153b.begin(), itcs_1546= _cs_1542.begin(); itstate_153f!= _state_153b.end(), itcs_1546!= _cs_1542.end(); ++itstate_153f, ++itcs_1546)
	{
		if( ( *itstate_153f== state_153d)&& ( *itcs_1546== cs_1544))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_153b.push_back( state_153d);
		_cs_1542.push_back( cs_1544);
	}
	return isUnique;
}

bool ChildANDStates_1549::operator()( const Packets_t& states_154a, const Packets_t& compoundStatements_154d, Packets_t& states_154c, Packets_t& compoundStatements_154f)
{
#ifdef PRINT_INFO
	printLog( "ChildANDStates_1549" );
#endif
	_state_1550= &states_154c;
	_compoundStatement_1551= &compoundStatements_154f;
	processInputPackets( states_154a, compoundStatements_154d);
	if( false== _matches.empty())
		return true;
	return false;
}

bool ChildANDStates_1549::isInputUnique( const Udm::Object& state_1556, const Udm::Object& compoundStatement_155f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1558= _state_1552.begin(), itCompoundStatement_1561= _compoundStatement_155b.begin(); itState_1558!= _state_1552.end(), itCompoundStatement_1561!= _compoundStatement_155b.end(); ++itState_1558, ++itCompoundStatement_1561)
	{
		if( ( *itState_1558== state_1556)&& ( *itCompoundStatement_1561== compoundStatement_155f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1552.push_back( state_1556);
		_compoundStatement_155b.push_back( compoundStatement_155f);
	}
	return isUnique;
}

bool ChildANDStates_1549::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool ChildANDStates_1549::isGuardTrue( CyPhyML::SignalFlow::State& ChildState, SFC::CompoundStatement& CompoundStatement, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	return static_cast< std::string >( ChildState.Decomposition() ) == "AND_STATE";;
	return Gz_guard;
}

void ChildANDStates_1549::processInputPackets( const Packets_t& states_154a, const Packets_t& compoundStatements_154d)
{
	for( Packets_t::const_iterator itState_1553= states_154a.begin(), itCompoundStatement_155c= compoundStatements_154d.begin(); itState_1553!= states_154a.end(), itCompoundStatement_155c!= compoundStatements_154d.end(); ++itState_1553, ++itCompoundStatement_155c)
	{
		bool isUnique= isInputUnique( *itState_1553, *itCompoundStatement_155c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1553, *itCompoundStatement_155c);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_156b, currMatch.compoundStatement_156c);
	}
}

bool ChildANDStates_1549::patternMatcher( const Udm::Object& state_1554, const Udm::Object& compoundStatement_155d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1554.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1559= CyPhyML::SignalFlow::State::Cast( state_1554);
		if( false== Uml::IsDerivedFrom( compoundStatement_155d.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1562= SFC::CompoundStatement::Cast( compoundStatement_155d);
		set< CyPhyML::SignalFlow::State> childStates_1564= state_1559.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itChildState_1565= childStates_1564.begin(); itChildState_1565!= childStates_1564.end(); ++itChildState_1565)
		{
			CyPhyML::SignalFlow::State currChildState_1566= *itChildState_1565;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_156a;
			if( !isValidBound(boundObjs_156a, state_1559, true))
				continue;
			currMatch.state_156b= state_1559;
			if( !isValidBound(boundObjs_156a, compoundStatement_1562, true))
				continue;
			currMatch.compoundStatement_156c= compoundStatement_1562;
			if( !isValidBound(boundObjs_156a, currChildState_1566, false))
				continue;
			currMatch.childState_156d= currChildState_1566;
			bool Gz_guard= isGuardTrue( currMatch.childState_156d, currMatch.compoundStatement_156c, currMatch.state_156b);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void ChildANDStates_1549::outputAppender( const CyPhyML::SignalFlow::State& state_1571, const SFC::CompoundStatement& compoundStatement_1573)
{
	_state_1550->push_back( state_1571);
	_compoundStatement_1551->push_back( compoundStatement_1573);
}

bool Otherwise_1575::operator()( const Packets_t& states_1576, const Packets_t& compoundStatements_1579, Packets_t& states_1578, Packets_t& compoundStatements_157b)
{
#ifdef PRINT_INFO
	printLog( "Otherwise_1575" );
#endif
	_state_157c= &states_1578;
	_compoundStatement_157d= &compoundStatements_157b;
	processInputPackets( states_1576, compoundStatements_1579);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_1575::isInputUnique( const Udm::Object& state_1582, const Udm::Object& compoundStatement_158b)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1584= _state_157e.begin(), itCompoundStatement_158d= _compoundStatement_1587.begin(); itState_1584!= _state_157e.end(), itCompoundStatement_158d!= _compoundStatement_1587.end(); ++itState_1584, ++itCompoundStatement_158d)
	{
		if( ( *itState_1584== state_1582)&& ( *itCompoundStatement_158d== compoundStatement_158b))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_157e.push_back( state_1582);
		_compoundStatement_1587.push_back( compoundStatement_158b);
	}
	return isUnique;
}

bool Otherwise_1575::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_1575::processInputPackets( const Packets_t& states_1576, const Packets_t& compoundStatements_1579)
{
	for( Packets_t::const_iterator itState_157f= states_1576.begin(), itCompoundStatement_1588= compoundStatements_1579.begin(); itState_157f!= states_1576.end(), itCompoundStatement_1588!= compoundStatements_1579.end(); ++itState_157f, ++itCompoundStatement_1588)
	{
		bool isUnique= isInputUnique( *itState_157f, *itCompoundStatement_1588);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_157f, *itCompoundStatement_1588);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1594, currMatch.compoundStatement_1595);
	}
}

bool Otherwise_1575::patternMatcher( const Udm::Object& state_1580, const Udm::Object& compoundStatement_1589)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1580.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1585= CyPhyML::SignalFlow::State::Cast( state_1580);
		if( false== Uml::IsDerivedFrom( compoundStatement_1589.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_158e= SFC::CompoundStatement::Cast( compoundStatement_1589);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1593;
		if( !isValidBound(boundObjs_1593, state_1585, true))
			continue;
		currMatch.state_1594= state_1585;
		if( !isValidBound(boundObjs_1593, compoundStatement_158e, true))
			continue;
		currMatch.compoundStatement_1595= compoundStatement_158e;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_1575::outputAppender( const CyPhyML::SignalFlow::State& state_1596, const SFC::CompoundStatement& compoundStatement_1598)
{
	_state_157c->push_back( state_1596);
	_compoundStatement_157d->push_back( compoundStatement_1598);
}

void CallActiveChildExec_159a::operator()( const Packets_t& states_159b, const Packets_t& css_159d, Packets_t& states_159f, Packets_t& css_15a0)
{
#ifdef PRINT_INFO
	printLog( "CallActiveChildExec_159a" );
#endif
	_state_15a1= &states_159f;
	_cs_15a2= &css_15a0;
	if( ( !states_159b.empty())&& ( !css_159d.empty()))
		callGetChildStates_15e0( states_159b, css_159d);
	_state_15a1->insert( _state_15a1->end(), states_159b.begin(), states_159b.end());
	_cs_15a2->insert( _cs_15a2->end(), css_159d.begin(), css_159d.end());
}

void CallActiveChildExec_159a::callGetChildStates_15e0( const Packets_t& states_13b0, const Packets_t& compoundStatements_13b4)
{
	Packets_t states_13b2;
	Packets_t childStates_13b3;
	Packets_t compoundStatements_13b6;
	GetChildStates_13af getChildStates_13af;
	getChildStates_13af( states_13b0, compoundStatements_13b4, states_13b2, childStates_13b3, compoundStatements_13b6);
	if( ( !states_13b2.empty())&& ( !childStates_13b3.empty())&& ( !compoundStatements_13b6.empty()))
		callExecActiveChildState_15e3( states_13b2, childStates_13b3, compoundStatements_13b6);
}

void CallActiveChildExec_159a::callExecActiveChildState_15e3( const Packets_t& states_15a4, const Packets_t& childStates_15a6, const Packets_t& compoundStatements_15a8)
{
	ExecActiveChildState_15a3 execActiveChildState_15a3;
	execActiveChildState_15a3( states_15a4, childStates_15a6, compoundStatements_15a8);
}

void ExecActiveChildState_15a3::operator()( const Packets_t& states_15a4, const Packets_t& childStates_15a6, const Packets_t& compoundStatements_15a8)
{
#ifdef PRINT_INFO
	printLog( "ExecActiveChildState_15a3" );
#endif
	RTTGenerator::Instance()->generateRule(641, "ExecActiveChildState");
	processInputPackets( states_15a4, childStates_15a6, compoundStatements_15a8);
}

bool ExecActiveChildState_15a3::isInputUnique( const Udm::Object& state_15ae, const Udm::Object& childState_15b7, const Udm::Object& compoundStatement_15c0)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_15b0= _state_15aa.begin(), itChildState_15b9= _childState_15b3.begin(), itCompoundStatement_15c2= _compoundStatement_15bc.begin(); itState_15b0!= _state_15aa.end(), itChildState_15b9!= _childState_15b3.end(), itCompoundStatement_15c2!= _compoundStatement_15bc.end(); ++itState_15b0, ++itChildState_15b9, ++itCompoundStatement_15c2)
	{
		if( ( *itState_15b0== state_15ae)&& ( *itChildState_15b9== childState_15b7)&& ( *itCompoundStatement_15c2== compoundStatement_15c0))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_15aa.push_back( state_15ae);
		_childState_15b3.push_back( childState_15b7);
		_compoundStatement_15bc.push_back( compoundStatement_15c0);
	}
	return isUnique;
}

void ExecActiveChildState_15a3::processInputPackets( const Packets_t& states_15a4, const Packets_t& childStates_15a6, const Packets_t& compoundStatements_15a8)
{
	for( Packets_t::const_iterator itState_15ab= states_15a4.begin(), itChildState_15b4= childStates_15a6.begin(), itCompoundStatement_15bd= compoundStatements_15a8.begin(); itState_15ab!= states_15a4.end(), itChildState_15b4!= childStates_15a6.end(), itCompoundStatement_15bd!= compoundStatements_15a8.end(); ++itState_15ab, ++itChildState_15b4, ++itCompoundStatement_15bd)
	{
		bool isUnique= isInputUnique( *itState_15ab, *itChildState_15b4, *itCompoundStatement_15bd);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_15ab, *itChildState_15b4, *itCompoundStatement_15bd);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ExecActiveChildState_15a3::patternMatcher( const Udm::Object& state_15ac, const Udm::Object& childState_15b5, const Udm::Object& compoundStatement_15be)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_15ac.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_15b1= CyPhyML::SignalFlow::State::Cast( state_15ac);
		if( false== Uml::IsDerivedFrom( childState_15b5.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State childState_15ba= CyPhyML::SignalFlow::State::Cast( childState_15b5);
		if( false== Uml::IsDerivedFrom( compoundStatement_15be.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_15c3= SFC::CompoundStatement::Cast( compoundStatement_15be);
		set< SFC::StateLabel> childStateLabels_15c5= childState_15ba.src();
		for( set< SFC::StateLabel>::const_iterator itChildStateLabels_15c6= childStateLabels_15c5.begin(); itChildStateLabels_15c6!= childStateLabels_15c5.end(); ++itChildStateLabels_15c6)
		{
			SFC::StateLabel currChildStateLabel_15c7= *itChildStateLabels_15c6;
			set< SFC::Function> functions_15c8= childState_15ba.exec();
			for( set< SFC::Function>::const_iterator itFunctions_15c9= functions_15c8.begin(); itFunctions_15c9!= functions_15c8.end(); ++itFunctions_15c9)
			{
				SFC::Function currFunction_15ca= *itFunctions_15c9;
				Udm::Object functionParent_15cb= currFunction_15ca.container();
				if( false== Uml::IsDerivedFrom( functionParent_15cb.type(), SFC::Program::meta))
					continue;
				SFC::Program programFunction_15cc= SFC::Program::Cast( functionParent_15cb);
				set< SFC::StateVar> stateVars_15cd= programFunction_15cc.StateVar_kind_children();
				for( set< SFC::StateVar>::const_iterator itStateVar_15ce= stateVars_15cd.begin(); itStateVar_15ce!= stateVars_15cd.end(); ++itStateVar_15ce)
				{
					SFC::StateVar currStateVar_15cf= *itStateVar_15ce;
					set< SFC::StateLabel> stateLabels_15d0= state_15b1.src();
					for( set< SFC::StateLabel>::const_iterator itStateLabels_15d1= stateLabels_15d0.begin(); itStateLabels_15d1!= stateLabels_15d0.end(); ++itStateLabels_15d1)
					{
						SFC::StateLabel currStateLabel_15d2= *itStateLabels_15d1;
						Match currMatch;
						currMatch.state_15d4= state_15b1;
						currMatch.childState_15d5= childState_15ba;
						currMatch.compoundStatement_15d6= compoundStatement_15c3;
						currMatch.stateLabel_15d7= currStateLabel_15d2;
						currMatch.childStateLabel_15d8= currChildStateLabel_15c7;
						currMatch.function_15d9= currFunction_15ca;
						currMatch.program_15da= programFunction_15cc;
						currMatch.stateVar_15db= currStateVar_15cf;
						_matches.push_back( currMatch);
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void ExecActiveChildState_15a3::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_15dc= SFC::ConditionalBlock::Create( currMatch.compoundStatement_15d6, SFC::CompoundStatement::meta_stmnt);
		SFC::Return newReturn_15dd= SFC::Return::Create( newConditionalBlock_15dc, SFC::ConditionalBlock::meta_stmnt);
		SFC::FunctionCall newFunctionCall_15de= SFC::FunctionCall::Create( newConditionalBlock_15dc, SFC::ConditionalBlock::meta_stmnt);
		SFC::CheckState newCheckState_15df= SFC::CheckState::Create( newConditionalBlock_15dc, SFC::ConditionalBlock::meta_cond);
		SFC::CheckState& CheckState= newCheckState_15df;
		CyPhyML::SignalFlow::State& ChildState= currMatch.childState_15d5;
		SFC::StateLabel& ChildStateLabel= currMatch.childStateLabel_15d8;
		SFC::CompoundStatement& CompoundStatement= currMatch.compoundStatement_15d6;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_15dc;
		SFC::Function& Function= currMatch.function_15d9;
		SFC::FunctionCall& FunctionCall= newFunctionCall_15de;
		SFC::Program& Program= currMatch.program_15da;
		SFC::Return& Return= newReturn_15dd;
		CyPhyML::SignalFlow::State& State= currMatch.state_15d4;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_15d7;
		SFC::StateVar& StateVar= currMatch.stateVar_15db;
		{
ConditionalBlock.RefId() = FunctionCall.RefId() = Return.RefId() = CompoundStatement.RefId();
};
		{
__int64 statementCount = CompoundStatement.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
CompoundStatement.statementCount() = statementCount;
};
		{
__int64 statementCount = ConditionalBlock.statementCount();
FunctionCall.statementIndex() = statementCount++;
Return.statementIndex() = statementCount++;
ConditionalBlock.statementCount() = statementCount;
};
		newFunctionCall_15de.callee()= currMatch.function_15d9;
		newCheckState_15df.index()= currMatch.stateLabel_15d7;
		newCheckState_15df.svar()= currMatch.stateVar_15db;
		newCheckState_15df.value()= currMatch.childStateLabel_15d8;
	}
}

void CG_15e7::operator()( const Packets_t& states_15e8, const Packets_t& compoundStatements_15eb, Packets_t& states_15ea, Packets_t& conditionalGroups_15ed)
{
#ifdef PRINT_INFO
	printLog( "CG_15e7" );
#endif
	RTTGenerator::Instance()->generateRule(675, "CG");
	_state_15ee= &states_15ea;
	_conditionalGroup_15ef= &conditionalGroups_15ed;
	processInputPackets( states_15e8, compoundStatements_15eb);
}

bool CG_15e7::isInputUnique( const Udm::Object& state_15f4, const Udm::Object& compoundStatement_15fd)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_15f6= _state_15f0.begin(), itCompoundStatement_15ff= _compoundStatement_15f9.begin(); itState_15f6!= _state_15f0.end(), itCompoundStatement_15ff!= _compoundStatement_15f9.end(); ++itState_15f6, ++itCompoundStatement_15ff)
	{
		if( ( *itState_15f6== state_15f4)&& ( *itCompoundStatement_15ff== compoundStatement_15fd))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_15f0.push_back( state_15f4);
		_compoundStatement_15f9.push_back( compoundStatement_15fd);
	}
	return isUnique;
}

bool CG_15e7::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CG_15e7::processInputPackets( const Packets_t& states_15e8, const Packets_t& compoundStatements_15eb)
{
	for( Packets_t::const_iterator itState_15f1= states_15e8.begin(), itCompoundStatement_15fa= compoundStatements_15eb.begin(); itState_15f1!= states_15e8.end(), itCompoundStatement_15fa!= compoundStatements_15eb.end(); ++itState_15f1, ++itCompoundStatement_15fa)
	{
		bool isUnique= isInputUnique( *itState_15f1, *itCompoundStatement_15fa);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_15f1, *itCompoundStatement_15fa);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CG_15e7::patternMatcher( const Udm::Object& state_15f2, const Udm::Object& compoundStatement_15fb)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_15f2.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_15f7= CyPhyML::SignalFlow::State::Cast( state_15f2);
		if( false== Uml::IsDerivedFrom( compoundStatement_15fb.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1600= SFC::CompoundStatement::Cast( compoundStatement_15fb);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1605;
		if( !isValidBound(boundObjs_1605, state_15f7, true))
			continue;
		currMatch.state_1606= state_15f7;
		if( !isValidBound(boundObjs_1605, compoundStatement_1600, true))
			continue;
		currMatch.compoundStatement_1607= compoundStatement_1600;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CG_15e7::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalGroup newConditionalGroup_1608= SFC::ConditionalGroup::Create( currMatch.compoundStatement_1607, SFC::CompoundStatement::meta_stmnt);
		SFC::CompoundStatement& CompoundStatement= currMatch.compoundStatement_1607;
		SFC::ConditionalGroup& ConditionalGroup= newConditionalGroup_1608;
		CyPhyML::SignalFlow::State& State= currMatch.state_1606;
		{
ConditionalGroup.RefId() = CompoundStatement.RefId();
};
		{
__int64 statementCount = CompoundStatement.statementCount();
ConditionalGroup.statementIndex() = statementCount++;
CompoundStatement.statementCount() = statementCount;
};
		outputAppender( currMatch.state_1606, newConditionalGroup_1608);
	}
}

void CG_15e7::outputAppender( const CyPhyML::SignalFlow::State& state_1609, const SFC::ConditionalGroup& conditionalGroup_160b)
{
	_state_15ee->push_back( state_1609);
	_conditionalGroup_15ef->push_back( conditionalGroup_160b);
}

void GetExecFcn_160d::operator()( const Packets_t& states_160e, Packets_t& states_1610, Packets_t& functions_1611)
{
#ifdef PRINT_INFO
	printLog( "GetExecFcn_160d" );
#endif
	RTTGenerator::Instance()->generateRule(682, "GetExecFcn");
	_state_1612= &states_1610;
	_function_1613= &functions_1611;
	processInputPackets( states_160e);
}

bool GetExecFcn_160d::isInputUnique( const Udm::Object& state_1618)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_161a= _state_1614.begin(); itState_161a!= _state_1614.end(); ++itState_161a)
	{
		if( ( *itState_161a== state_1618))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1614.push_back( state_1618);
	return isUnique;
}

void GetExecFcn_160d::processInputPackets( const Packets_t& states_160e)
{
	for( Packets_t::const_iterator itState_1615= states_160e.begin(); itState_1615!= states_160e.end(); ++itState_1615)
	{
		bool isUnique= isInputUnique( *itState_1615);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1615);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetExecFcn_160d::patternMatcher( const Udm::Object& state_1616)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1616.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_161b= CyPhyML::SignalFlow::State::Cast( state_1616);
		set< SFC::Function> functions_161d= state_161b.exec();
		for( set< SFC::Function>::const_iterator itFunctions_161e= functions_161d.begin(); itFunctions_161e!= functions_161d.end(); ++itFunctions_161e)
		{
			SFC::Function currFunction_161f= *itFunctions_161e;
			Match currMatch;
			currMatch.state_1621= state_161b;
			currMatch.function_1622= currFunction_161f;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetExecFcn_160d::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1621, currMatch.function_1622);
	}
}

void GetExecFcn_160d::outputAppender( const CyPhyML::SignalFlow::State& state_1623, const SFC::Function& function_1625)
{
	_state_1612->push_back( state_1623);
	_function_1613->push_back( function_1625);
}

void InnerTransitions_164b::operator()( const Packets_t& states_164c, Packets_t& states_164e)
{
#ifdef PRINT_INFO
	printLog( "InnerTransitions_164b" );
#endif
	_state_164f= &states_164e;
	if( ( !states_164c.empty()))
		callCheckForInnerTransitions_18ea( states_164c);
	_state_164f->insert( _state_164f->end(), states_164c.begin(), states_164c.end());
}

void InnerTransitions_164b::callCheckForInnerTransitions_18ea( const Packets_t& states_1822)
{
	Packets_t states_1824;
	CheckForInnerTransitions_1821 checkForInnerTransitions_1821;
	checkForInnerTransitions_1821( states_1822, states_1824);
	if( ( !states_1824.empty()))
		callInit_18ec( states_1824);
}

void InnerTransitions_164b::callInit_18ec( const Packets_t& states_184f)
{
	Packets_t states_1851;
	Packets_t tcs_1852;
	Packets_t fcns_1853;
	Packets_t cgs_1854;
	Init_184e init_184e;
	init_184e( states_184f, states_1851, tcs_1852, fcns_1853, cgs_1854);
	if( ( !states_1851.empty())&& ( !tcs_1852.empty())&& ( !fcns_1853.empty())&& ( !cgs_1854.empty()))
		callCreateTransitionCG_18ee( states_1851, tcs_1852, fcns_1853, cgs_1854);
}

void InnerTransitions_164b::callCreateTransitionCG_18ee( const Packets_t& states_7c9, const Packets_t& transConnectors_7cc, const Packets_t& functions_7cf, const Packets_t& tCVarCGs_7d3)
{
	Packets_t states_7cb;
	Packets_t transConnectors_7ce;
	Packets_t functions_7d1;
	Packets_t transitionCGs_7d2;
	CreateTransitionCG_7c8 createTransitionCG_7c8;
	createTransitionCG_7c8( states_7c9, transConnectors_7cc, functions_7cf, tCVarCGs_7d3, states_7cb, transConnectors_7ce, functions_7d1, transitionCGs_7d2);
	if( ( !states_7cb.empty())&& ( !transConnectors_7ce.empty())&& ( !functions_7d1.empty())&& ( !transitionCGs_7d2.empty()))
		callExecInnerTransitions_18f3( states_7cb, transConnectors_7ce, functions_7d1, transitionCGs_7d2);
}

void InnerTransitions_164b::callExecInnerTransitions_18f3( const Packets_t& states_1651, const Packets_t& tcs_1653, const Packets_t& fcns_1655, const Packets_t& css_1657)
{
	Packets_t states_1659;
	Packets_t tcs_165a;
	Packets_t fcns_165b;
	Packets_t css_165c;
	ExecInnerTransitions_1650 execInnerTransitions_1650;
	execInnerTransitions_1650( states_1651, tcs_1653, fcns_1655, css_1657, states_1659, tcs_165a, fcns_165b, css_165c);
	if( ( !states_1659.empty())&& ( !tcs_165a.empty())&& ( !fcns_165b.empty())&& ( !css_165c.empty()))
		callNoDefaultTransition_18f8( states_1659, tcs_165a, fcns_165b, css_165c);
}

void InnerTransitions_164b::callNoDefaultTransition_18f8( const Packets_t& states_88d, const Packets_t& tcs_88f, const Packets_t& fcns_891, const Packets_t& css_893)
{
	NoDefaultTransition_88c noDefaultTransition_88c;
	noDefaultTransition_88c( states_88d, tcs_88f, fcns_891, css_893);
}

void ExecInnerTransitions_1650::operator()( const Packets_t& states_1651, const Packets_t& tcs_1653, const Packets_t& fcns_1655, const Packets_t& css_1657, Packets_t& states_1659, Packets_t& tcs_165a, Packets_t& fcns_165b, Packets_t& css_165c)
{
#ifdef PRINT_INFO
	printLog( "ExecInnerTransitions_1650" );
#endif
	_state_165d= &states_1659;
	_tc_165e= &tcs_165a;
	_fcn_165f= &fcns_165b;
	_cs_1660= &css_165c;
	if( ( !states_1651.empty())&& ( !tcs_1653.empty())&& ( !fcns_1655.empty())&& ( !css_1657.empty()))
		callGetInnerTransitions_1817( states_1651, tcs_1653, fcns_1655, css_1657);
	_state_165d->insert( _state_165d->end(), states_1651.begin(), states_1651.end());
	_tc_165e->insert( _tc_165e->end(), tcs_1653.begin(), tcs_1653.end());
	_fcn_165f->insert( _fcn_165f->end(), fcns_1655.begin(), fcns_1655.end());
	_cs_1660->insert( _cs_1660->end(), css_1657.begin(), css_1657.end());
}

void ExecInnerTransitions_1650::callGetInnerTransitions_1817( const Packets_t& states_1662, const Packets_t& parentStates_1665, const Packets_t& functions_1668, const Packets_t& compoundStatements_166b)
{
	Packets_t states_1664;
	Packets_t transitions_1667;
	Packets_t functions_166a;
	Packets_t compoundStatements_166d;
	GetInnerTransitions_1661 getInnerTransitions_1661;
	getInnerTransitions_1661( states_1662, parentStates_1665, functions_1668, compoundStatements_166b, states_1664, transitions_1667, functions_166a, compoundStatements_166d);
	if( ( !states_1664.empty())&& ( !transitions_1667.empty())&& ( !functions_166a.empty())&& ( !compoundStatements_166d.empty()))
		callExecProcessTransitions_181c( states_1664, transitions_1667, functions_166a, compoundStatements_166d);
}

void ExecInnerTransitions_1650::callExecProcessTransitions_181c( const Packets_t& states_16b0, const Packets_t& transs_16b2, const Packets_t& fcns_16b4, const Packets_t& css_16b6)
{
	ExecProcessTransitions_16af execProcessTransitions_16af;
	execProcessTransitions_16af( states_16b0, transs_16b2, fcns_16b4, css_16b6);
}

void GetInnerTransitions_1661::operator()( const Packets_t& states_1662, const Packets_t& parentStates_1665, const Packets_t& functions_1668, const Packets_t& compoundStatements_166b, Packets_t& states_1664, Packets_t& transitions_1667, Packets_t& functions_166a, Packets_t& compoundStatements_166d)
{
#ifdef PRINT_INFO
	printLog( "GetInnerTransitions_1661" );
#endif
	RTTGenerator::Instance()->generateRule(718, "GetInnerTransitions");
	_state_166e= &states_1664;
	_transition_166f= &transitions_1667;
	_function_1670= &functions_166a;
	_compoundStatement_1671= &compoundStatements_166d;
	processInputPackets( states_1662, parentStates_1665, functions_1668, compoundStatements_166b);
}

bool GetInnerTransitions_1661::isInputUnique( const Udm::Object& state_1676, const Udm::Object& parentState_167f, const Udm::Object& function_1688, const Udm::Object& compoundStatement_1691)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1678= _state_1672.begin(), itParentState_1681= _parentState_167b.begin(), itFunction_168a= _function_1684.begin(), itCompoundStatement_1693= _compoundStatement_168d.begin(); itState_1678!= _state_1672.end(), itParentState_1681!= _parentState_167b.end(), itFunction_168a!= _function_1684.end(), itCompoundStatement_1693!= _compoundStatement_168d.end(); ++itState_1678, ++itParentState_1681, ++itFunction_168a, ++itCompoundStatement_1693)
	{
		if( ( *itState_1678== state_1676)&& ( *itParentState_1681== parentState_167f)&& ( *itFunction_168a== function_1688)&& ( *itCompoundStatement_1693== compoundStatement_1691))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1672.push_back( state_1676);
		_parentState_167b.push_back( parentState_167f);
		_function_1684.push_back( function_1688);
		_compoundStatement_168d.push_back( compoundStatement_1691);
	}
	return isUnique;
}

void GetInnerTransitions_1661::processInputPackets( const Packets_t& states_1662, const Packets_t& parentStates_1665, const Packets_t& functions_1668, const Packets_t& compoundStatements_166b)
{
	for( Packets_t::const_iterator itState_1673= states_1662.begin(), itParentState_167c= parentStates_1665.begin(), itFunction_1685= functions_1668.begin(), itCompoundStatement_168e= compoundStatements_166b.begin(); itState_1673!= states_1662.end(), itParentState_167c!= parentStates_1665.end(), itFunction_1685!= functions_1668.end(), itCompoundStatement_168e!= compoundStatements_166b.end(); ++itState_1673, ++itParentState_167c, ++itFunction_1685, ++itCompoundStatement_168e)
	{
		bool isUnique= isInputUnique( *itState_1673, *itParentState_167c, *itFunction_1685, *itCompoundStatement_168e);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1673, *itParentState_167c, *itFunction_1685, *itCompoundStatement_168e);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetInnerTransitions_1661::patternMatcher( const Udm::Object& state_1674, const Udm::Object& parentState_167d, const Udm::Object& function_1686, const Udm::Object& compoundStatement_168f)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1674.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1679= CyPhyML::SignalFlow::State::Cast( state_1674);
		if( false== Uml::IsDerivedFrom( parentState_167d.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State parentState_1682= CyPhyML::SignalFlow::State::Cast( parentState_167d);
		if( false== Uml::IsDerivedFrom( function_1686.type(), SFC::Function::meta))
			continue;
		SFC::Function function_168b= SFC::Function::Cast( function_1686);
		if( false== Uml::IsDerivedFrom( compoundStatement_168f.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1694= SFC::CompoundStatement::Cast( compoundStatement_168f);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_1696= parentState_1682.ConnectorRef_kind_children();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRef_1697= connectorRefs_1696.begin(); itConnectorRef_1697!= connectorRefs_1696.end(); ++itConnectorRef_1697)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_1698= *itConnectorRef_1697;
			CyPhyML::SignalFlow::TransConnector parentState_1699= currConnectorRef_1698.ref();
			if( false== Uml::IsDerivedFrom( parentState_1699.type(), CyPhyML::SignalFlow::State::meta))
				continue;
			CyPhyML::SignalFlow::State parentState_169a= CyPhyML::SignalFlow::State::Cast( parentState_1699);
			if( !parentState_169a)
				continue;
			if( parentState_1682!= parentState_169a)
				continue;
			set< CyPhyML::SignalFlow::Transition> transitions_169b= currConnectorRef_1698.dstTransition();
			for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransitions_169c= transitions_169b.begin(); itTransitions_169c!= transitions_169b.end(); ++itTransitions_169c)
			{
				CyPhyML::SignalFlow::Transition currTransition_169d= *itTransitions_169c;
				CyPhyML::SignalFlow::TransConnector transConnector_169e= currTransition_169d.dstTransition_end();
				Match currMatch;
				currMatch.state_16a0= state_1679;
				currMatch.parentState_16a1= parentState_1682;
				currMatch.function_16a2= function_168b;
				currMatch.compoundStatement_16a3= compoundStatement_1694;
				currMatch.connectorRef_16a4= currConnectorRef_1698;
				currMatch.transConnector_16a5= transConnector_169e;
				currMatch.transition_16a6= currTransition_169d;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetInnerTransitions_1661::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_16a0, currMatch.transition_16a6, currMatch.function_16a2, currMatch.compoundStatement_16a3);
	}
}

void GetInnerTransitions_1661::outputAppender( const CyPhyML::SignalFlow::State& state_16a7, const CyPhyML::SignalFlow::Transition& transition_16a9, const SFC::Function& function_16ab, const SFC::CompoundStatement& compoundStatement_16ad)
{
	_state_166e->push_back( state_16a7);
	_transition_166f->push_back( transition_16a9);
	_function_1670->push_back( function_16ab);
	_compoundStatement_1671->push_back( compoundStatement_16ad);
}

void ExecProcessTransitions_16af::operator()( const Packets_t& states_16b0, const Packets_t& transs_16b2, const Packets_t& fcns_16b4, const Packets_t& css_16b6)
{
#ifdef PRINT_INFO
	printLog( "ExecProcessTransitions_16af" );
#endif
	if( ( !states_16b0.empty())&& ( !transs_16b2.empty())&& ( !fcns_16b4.empty())&& ( !css_16b6.empty()))
		callOrderTransitions_17de( states_16b0, transs_16b2, fcns_16b4, css_16b6);
}

void ExecProcessTransitions_16af::callOrderTransitions_17de( const Packets_t& states_63f, const Packets_t& transitions_642, const Packets_t& functions_645, const Packets_t& compoundStatements_648)
{
	Packets_t states_641;
	Packets_t transitions_644;
	Packets_t functions_647;
	Packets_t compoundStatements_64a;
	OrderTransitions_63e orderTransitions_63e;
	orderTransitions_63e( states_63f, transitions_642, functions_645, compoundStatements_648, states_641, transitions_644, functions_647, compoundStatements_64a);
	if( ( !states_641.empty())&& ( !transitions_644.empty())&& ( !functions_647.empty())&& ( !compoundStatements_64a.empty()))
		callTransCond_17e3( states_641, transitions_644, functions_647, compoundStatements_64a);
}

void ExecProcessTransitions_16af::callTransCond_17e3( const Packets_t& states_331, const Packets_t& transitions_335, const Packets_t& functions_338, const Packets_t& transitionCGs_33b)
{
	Packets_t states_333;
	Packets_t dstTransConnectors_334;
	Packets_t transitions_337;
	Packets_t functions_33a;
	Packets_t conditionalBlocks_33d;
	TransCond_330 transCond_330;
	transCond_330( states_331, transitions_335, functions_338, transitionCGs_33b, states_333, dstTransConnectors_334, transitions_337, functions_33a, conditionalBlocks_33d);
	if( ( !states_333.empty())&& ( !dstTransConnectors_334.empty())&& ( !transitions_337.empty())&& ( !functions_33a.empty())&& ( !conditionalBlocks_33d.empty()))
		callHighestTransParent_17e8( states_333, dstTransConnectors_334, transitions_337, functions_33a, conditionalBlocks_33d);
}

void ExecProcessTransitions_16af::callHighestTransParent_17e8( const Packets_t& states_16b9, const Packets_t& dstTransConnectors_16bc, const Packets_t& transitions_16bf, const Packets_t& functions_16c2, const Packets_t& conditionalBlocks_16c5)
{
	Packets_t states_16bb;
	Packets_t dstTransConnectors_16be;
	Packets_t transitions_16c1;
	Packets_t functions_16c4;
	Packets_t conditionalBlocks_16c7;
	HighestTransParent_16b8 highestTransParent_16b8;
	highestTransParent_16b8( states_16b9, dstTransConnectors_16bc, transitions_16bf, functions_16c2, conditionalBlocks_16c5, states_16bb, dstTransConnectors_16be, transitions_16c1, functions_16c4, conditionalBlocks_16c7);
	if( ( !states_16bb.empty())&& ( !dstTransConnectors_16be.empty())&& ( !transitions_16c1.empty())&& ( !functions_16c4.empty())&& ( !conditionalBlocks_16c7.empty()))
		callTest_17ee( states_16bb, dstTransConnectors_16be, transitions_16c1, functions_16c4, conditionalBlocks_16c7);
}

void ExecProcessTransitions_16af::callTest_17ee( const Packets_t& states_37c, const Packets_t& dsts_37e, const Packets_t& transs_380, const Packets_t& fcns_382, const Packets_t& cbs_384)
{
	Packets_t states_386;
	Packets_t dsts_387;
	Packets_t transs_388;
	Packets_t fcns_389;
	Packets_t cbs_38a;
	Packets_t states_38b;
	Packets_t dsts_38c;
	Packets_t transs_38d;
	Packets_t fcns_38e;
	Packets_t cbs_38f;
	Packets_t states_390;
	Packets_t dsts_391;
	Packets_t transs_392;
	Packets_t fcns_393;
	Packets_t cbs_394;
	Packets_t states_395;
	Packets_t dsts_396;
	Packets_t transs_397;
	Packets_t fcns_398;
	Packets_t cbs_399;
	Packets_t states_39a;
	Packets_t dsts_39b;
	Packets_t transs_39c;
	Packets_t fcns_39d;
	Packets_t cbs_39e;
	Test_37b test_37b;
	test_37b( states_37c, dsts_37e, transs_380, fcns_382, cbs_384, states_386, dsts_387, transs_388, fcns_389, cbs_38a, states_38b, dsts_38c, transs_38d, fcns_38e, cbs_38f, states_390, dsts_391, transs_392, fcns_393, cbs_394, states_395, dsts_396, transs_397, fcns_398, cbs_399, states_39a, dsts_39b, transs_39c, fcns_39d, cbs_39e);
	if( ( !states_395.empty())&& ( !dsts_396.empty())&& ( !transs_397.empty())&& ( !fcns_398.empty())&& ( !cbs_399.empty()))
		callGetDstJuncFromRef_17f4( states_395, dsts_396, transs_397, fcns_398, cbs_399);
	if( ( !states_38b.empty())&& ( !dsts_38c.empty())&& ( !transs_38d.empty())&& ( !fcns_38e.empty())&& ( !cbs_38f.empty()))
		callGetDstStateFromRef_17fa( states_38b, dsts_38c, transs_38d, fcns_38e, cbs_38f);
	if( ( !states_39a.empty())&& ( !dsts_39b.empty())&& ( !transs_39c.empty())&& ( !fcns_39d.empty())&& ( !cbs_39e.empty()))
		callDeadEndJunction_1800( states_39a, dsts_39b, transs_39c, fcns_39d, cbs_39e);
	if( ( !states_390.empty())&& ( !dsts_391.empty())&& ( !transs_392.empty())&& ( !fcns_393.empty())&& ( !cbs_394.empty()))
		callNextJunction_1806( states_390, dsts_391, transs_392, fcns_393, cbs_394);
	if( ( !states_386.empty())&& ( !dsts_387.empty())&& ( !transs_388.empty())&& ( !fcns_389.empty())&& ( !cbs_38a.empty()))
		callExecNextState_180c( states_386, dsts_387, transs_388, fcns_389, cbs_38a);
}

void ExecProcessTransitions_16af::callGetDstJuncFromRef_17f4( const Packets_t& states_23b, const Packets_t& connectorRefs_23e, const Packets_t& transitions_241, const Packets_t& functions_244, const Packets_t& conditionalBlocks_247)
{
	Packets_t states_23d;
	Packets_t junctions_240;
	Packets_t transitions_243;
	Packets_t functions_246;
	Packets_t conditionalBlocks_249;
	GetDstJuncFromRef_23a getDstJuncFromRef_23a;
	getDstJuncFromRef_23a( states_23b, connectorRefs_23e, transitions_241, functions_244, conditionalBlocks_247, states_23d, junctions_240, transitions_243, functions_246, conditionalBlocks_249);
	if( ( !states_23d.empty())&& ( !junctions_240.empty())&& ( !transitions_243.empty())&& ( !functions_246.empty())&& ( !conditionalBlocks_249.empty()))
		callNextJunction_1806( states_23d, junctions_240, transitions_243, functions_246, conditionalBlocks_249);
}

void ExecProcessTransitions_16af::callGetDstStateFromRef_17fa( const Packets_t& states_290, const Packets_t& connectorRefs_294, const Packets_t& transitions_296, const Packets_t& functions_299, const Packets_t& conditionalBlocks_29c)
{
	Packets_t states_292;
	Packets_t dstStates_293;
	Packets_t transitions_298;
	Packets_t functions_29b;
	Packets_t conditionalBlocks_29e;
	GetDstStateFromRef_28f getDstStateFromRef_28f;
	getDstStateFromRef_28f( states_290, connectorRefs_294, transitions_296, functions_299, conditionalBlocks_29c, states_292, dstStates_293, transitions_298, functions_29b, conditionalBlocks_29e);
	if( ( !states_292.empty())&& ( !dstStates_293.empty())&& ( !transitions_298.empty())&& ( !functions_29b.empty())&& ( !conditionalBlocks_29e.empty()))
		callExecNextState_180c( states_292, dstStates_293, transitions_298, functions_29b, conditionalBlocks_29e);
}

void ExecProcessTransitions_16af::callDeadEndJunction_1800( const Packets_t& states_2e5, const Packets_t& transConnectors_2e7, const Packets_t& transitions_2e9, const Packets_t& functions_2eb, const Packets_t& transitionCBs_2ed)
{
	DeadEndJunction_2e4 deadEndJunction_2e4;
	deadEndJunction_2e4( states_2e5, transConnectors_2e7, transitions_2e9, functions_2eb, transitionCBs_2ed);
}

void ExecProcessTransitions_16af::callNextJunction_1806( const Packets_t& states_1d3, const Packets_t& junctions_1d6, const Packets_t& transitions_1d9, const Packets_t& functions_1db, const Packets_t& transitionCBs_1de)
{
	Packets_t states_1d5;
	Packets_t junctions_1d8;
	Packets_t functions_1dd;
	Packets_t conditionalGroups_1e0;
	NextJunction_1d2 nextJunction_1d2;
	nextJunction_1d2( states_1d3, junctions_1d6, transitions_1d9, functions_1db, transitionCBs_1de, states_1d5, junctions_1d8, functions_1dd, conditionalGroups_1e0);
	if( ( !states_1d5.empty())&& ( !junctions_1d8.empty())&& ( !functions_1dd.empty())&& ( !conditionalGroups_1e0.empty()))
		callExecTransConnectorRecurse_1812( states_1d5, junctions_1d8, functions_1dd, conditionalGroups_1e0);
}

void ExecProcessTransitions_16af::callExecNextState_180c( const Packets_t& states_1721, const Packets_t& dstStates_1723, const Packets_t& transitions_1725, const Packets_t& functions_1727, const Packets_t& transitionCBs_1729)
{
	ExecNextState_1720 execNextState_1720;
	execNextState_1720( states_1721, dstStates_1723, transitions_1725, functions_1727, transitionCBs_1729);
}

void ExecProcessTransitions_16af::callExecTransConnectorRecurse_1812( const Packets_t& states_178b, const Packets_t& tcs_178d, const Packets_t& fcns_178f, const Packets_t& cgs_1791)
{
	ExecTransConnectorRecurse_178a execTransConnectorRecurse_178a;
	execTransConnectorRecurse_178a( states_178b, tcs_178d, fcns_178f, cgs_1791);
}

void HighestTransParent_16b8::operator()( const Packets_t& states_16b9, const Packets_t& dstTransConnectors_16bc, const Packets_t& transitions_16bf, const Packets_t& functions_16c2, const Packets_t& conditionalBlocks_16c5, Packets_t& states_16bb, Packets_t& dstTransConnectors_16be, Packets_t& transitions_16c1, Packets_t& functions_16c4, Packets_t& conditionalBlocks_16c7)
{
#ifdef PRINT_INFO
	printLog( "HighestTransParent_16b8" );
#endif
	RTTGenerator::Instance()->generateRule(2468, "HighestTransParent");
	_state_16c8= &states_16bb;
	_dstTransConnector_16c9= &dstTransConnectors_16be;
	_transition_16ca= &transitions_16c1;
	_function_16cb= &functions_16c4;
	_conditionalBlock_16cc= &conditionalBlocks_16c7;
	processInputPackets( states_16b9, dstTransConnectors_16bc, transitions_16bf, functions_16c2, conditionalBlocks_16c5);
	forwardInputs( );
}

bool HighestTransParent_16b8::isInputUnique( const Udm::Object& state_16d1, const Udm::Object& dstTransConnector_16da, const Udm::Object& transition_16e3, const Udm::Object& function_16ec, const Udm::Object& conditionalBlock_16f5)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_16d3= _state_16cd.begin(), itDstTransConnector_16dc= _dstTransConnector_16d6.begin(), itTransition_16e5= _transition_16df.begin(), itFunction_16ee= _function_16e8.begin(), itConditionalBlock_16f7= _conditionalBlock_16f1.begin(); itState_16d3!= _state_16cd.end(), itDstTransConnector_16dc!= _dstTransConnector_16d6.end(), itTransition_16e5!= _transition_16df.end(), itFunction_16ee!= _function_16e8.end(), itConditionalBlock_16f7!= _conditionalBlock_16f1.end(); ++itState_16d3, ++itDstTransConnector_16dc, ++itTransition_16e5, ++itFunction_16ee, ++itConditionalBlock_16f7)
	{
		if( ( *itState_16d3== state_16d1)&& ( *itDstTransConnector_16dc== dstTransConnector_16da)&& ( *itTransition_16e5== transition_16e3)&& ( *itFunction_16ee== function_16ec)&& ( *itConditionalBlock_16f7== conditionalBlock_16f5))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_16cd.push_back( state_16d1);
		_dstTransConnector_16d6.push_back( dstTransConnector_16da);
		_transition_16df.push_back( transition_16e3);
		_function_16e8.push_back( function_16ec);
		_conditionalBlock_16f1.push_back( conditionalBlock_16f5);
	}
	return isUnique;
}

bool HighestTransParent_16b8::isGuardTrue( SFC::ConditionalBlock& ConditionalBlock, CyPhyML::SignalFlow::TransConnector& DstTransConnector, SFC::Function& Function, SFC::LocalVar& HTPVar, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel, CyPhyML::SignalFlow::Transition& Transition, CyPhyML::SignalFlow::State& TransitionParentState)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( HTPVar.name() ) == "_HTPVar_";;
	return Gz_guard;
}

void HighestTransParent_16b8::processInputPackets( const Packets_t& states_16b9, const Packets_t& dstTransConnectors_16bc, const Packets_t& transitions_16bf, const Packets_t& functions_16c2, const Packets_t& conditionalBlocks_16c5)
{
	for( Packets_t::const_iterator itState_16ce= states_16b9.begin(), itDstTransConnector_16d7= dstTransConnectors_16bc.begin(), itTransition_16e0= transitions_16bf.begin(), itFunction_16e9= functions_16c2.begin(), itConditionalBlock_16f2= conditionalBlocks_16c5.begin(); itState_16ce!= states_16b9.end(), itDstTransConnector_16d7!= dstTransConnectors_16bc.end(), itTransition_16e0!= transitions_16bf.end(), itFunction_16e9!= functions_16c2.end(), itConditionalBlock_16f2!= conditionalBlocks_16c5.end(); ++itState_16ce, ++itDstTransConnector_16d7, ++itTransition_16e0, ++itFunction_16e9, ++itConditionalBlock_16f2)
	{
		bool isUnique= isInputUnique( *itState_16ce, *itDstTransConnector_16d7, *itTransition_16e0, *itFunction_16e9, *itConditionalBlock_16f2);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_16ce, *itDstTransConnector_16d7, *itTransition_16e0, *itFunction_16e9, *itConditionalBlock_16f2);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool HighestTransParent_16b8::patternMatcher( const Udm::Object& state_16cf, const Udm::Object& dstTransConnector_16d8, const Udm::Object& transition_16e1, const Udm::Object& function_16ea, const Udm::Object& conditionalBlock_16f3)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_16cf.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_16d4= CyPhyML::SignalFlow::State::Cast( state_16cf);
		if( false== Uml::IsDerivedFrom( dstTransConnector_16d8.type(), CyPhyML::SignalFlow::TransConnector::meta))
			continue;
		CyPhyML::SignalFlow::TransConnector dstTransConnector_16dd= CyPhyML::SignalFlow::TransConnector::Cast( dstTransConnector_16d8);
		if( false== Uml::IsDerivedFrom( transition_16e1.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_16e6= CyPhyML::SignalFlow::Transition::Cast( transition_16e1);
		if( false== Uml::IsDerivedFrom( function_16ea.type(), SFC::Function::meta))
			continue;
		SFC::Function function_16ef= SFC::Function::Cast( function_16ea);
		if( false== Uml::IsDerivedFrom( conditionalBlock_16f3.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock conditionalBlock_16f8= SFC::ConditionalBlock::Cast( conditionalBlock_16f3);
		set< SFC::LocalVar> hTPVars_16fa= function_16ef.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itHTPVar_16fb= hTPVars_16fa.begin(); itHTPVar_16fb!= hTPVars_16fa.end(); ++itHTPVar_16fb)
		{
			SFC::LocalVar currHTPVar_16fc= *itHTPVar_16fb;
			Udm::Object transitionParent_16fd= transition_16e6.container();
			if( false== Uml::IsDerivedFrom( transitionParent_16fd.type(), CyPhyML::SignalFlow::State::meta))
				continue;
			CyPhyML::SignalFlow::State transitionParentStateTransition_16fe= CyPhyML::SignalFlow::State::Cast( transitionParent_16fd);
			set< SFC::StateLabel> stateLabels_16ff= transitionParentStateTransition_16fe.src();
			for( set< SFC::StateLabel>::const_iterator itStateLabels_1700= stateLabels_16ff.begin(); itStateLabels_1700!= stateLabels_16ff.end(); ++itStateLabels_1700)
			{
				SFC::StateLabel currStateLabel_1701= *itStateLabels_1700;
				Match currMatch;
				currMatch.state_1703= state_16d4;
				currMatch.dstTransConnector_1704= dstTransConnector_16dd;
				currMatch.transition_1705= transition_16e6;
				currMatch.function_1706= function_16ef;
				currMatch.conditionalBlock_1707= conditionalBlock_16f8;
				currMatch.transitionParentState_1708= transitionParentStateTransition_16fe;
				currMatch.stateLabel_1709= currStateLabel_1701;
				currMatch.hTPVar_170a= currHTPVar_16fc;
				bool Gz_guard= isGuardTrue( currMatch.conditionalBlock_1707, currMatch.dstTransConnector_1704, currMatch.function_1706, currMatch.hTPVar_170a, currMatch.state_1703, currMatch.stateLabel_1709, currMatch.transition_1705, currMatch.transitionParentState_1708);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void HighestTransParent_16b8::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newHighestTransitionCB_1713= SFC::ConditionalBlock::Create( currMatch.conditionalBlock_1707, SFC::ConditionalBlock::meta_stmnt);
		SFC::UserCode newTakeMin_1714= SFC::UserCode::Create( newHighestTransitionCB_1713, SFC::ConditionalBlock::meta_stmnt);
		SFC::BinaryExprs newAssign_1715= SFC::BinaryExprs::Create( newTakeMin_1714, SFC::UserCode::meta_codeexpr);
		SFC::ArgDeclRef newSLArgDeclRef2_1716= SFC::ArgDeclRef::Create( newAssign_1715, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newHTPArgDeclRef2_1717= SFC::ArgDeclRef::Create( newAssign_1715, SFC::BinaryExprs::meta_leftexpr);
		SFC::UserCode newTestMin_1718= SFC::UserCode::Create( newHighestTransitionCB_1713, SFC::ConditionalBlock::meta_cond);
		SFC::BinaryExprs newLessThan_1719= SFC::BinaryExprs::Create( newTestMin_1718, SFC::UserCode::meta_codeexpr);
		SFC::BinaryExprs newLBitAnd_171a= SFC::BinaryExprs::Create( newLessThan_1719, SFC::BinaryExprs::meta_leftexpr);
		SFC::BinaryExprs newRBitAnd_171b= SFC::BinaryExprs::Create( newLessThan_1719, SFC::BinaryExprs::meta_rightexpr);
		SFC::Int newRInt_171c= SFC::Int::Create( newRBitAnd_171b, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newHTPArgDeclRef1_171d= SFC::ArgDeclRef::Create( newRBitAnd_171b, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newSLArgDeclRef1_171e= SFC::ArgDeclRef::Create( newLBitAnd_171a, SFC::BinaryExprs::meta_leftexpr);
		SFC::Int newLInt_171f= SFC::Int::Create( newLBitAnd_171a, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs& Assign= newAssign_1715;
		SFC::ConditionalBlock& ConditionalBlock= currMatch.conditionalBlock_1707;
		CyPhyML::SignalFlow::TransConnector& DstTransConnector= currMatch.dstTransConnector_1704;
		SFC::Function& Function= currMatch.function_1706;
		SFC::ArgDeclRef& HTPArgDeclRef1= newHTPArgDeclRef1_171d;
		SFC::ArgDeclRef& HTPArgDeclRef2= newHTPArgDeclRef2_1717;
		SFC::LocalVar& HTPVar= currMatch.hTPVar_170a;
		SFC::ConditionalBlock& HighestTransitionCB= newHighestTransitionCB_1713;
		SFC::BinaryExprs& LBitAnd= newLBitAnd_171a;
		SFC::Int& LInt= newLInt_171f;
		SFC::BinaryExprs& LessThan= newLessThan_1719;
		SFC::BinaryExprs& RBitAnd= newRBitAnd_171b;
		SFC::Int& RInt= newRInt_171c;
		SFC::ArgDeclRef& SLArgDeclRef1= newSLArgDeclRef1_171e;
		SFC::ArgDeclRef& SLArgDeclRef2= newSLArgDeclRef2_1716;
		CyPhyML::SignalFlow::State& State= currMatch.state_1703;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_1709;
		SFC::UserCode& TakeMin= newTakeMin_1714;
		SFC::UserCode& TestMin= newTestMin_1718;
		CyPhyML::SignalFlow::Transition& Transition= currMatch.transition_1705;
		CyPhyML::SignalFlow::State& TransitionParentState= currMatch.transitionParentState_1708;
		{
HighestTransitionCB.RefId() = TestMin.RefId() = TakeMin.RefId() = ConditionalBlock.RefId();
};
		{
__int64 statementCount = ConditionalBlock.statementCount();
HighestTransitionCB.statementIndex() = statementCount++;
ConditionalBlock.statementCount() = statementCount;

};
		{
RBitAnd.op() = "&";
};
		{
LInt.val() = 0xFFFF;
};
		{
LessThan.op() = "<";
};
		{
RInt.val() = 0xFFFF;
};
		{
Assign.op() = "=";
};
		{
LBitAnd.op() = "&";
};
		{
__int64 statementCount = HighestTransitionCB.statementCount();
TakeMin.statementIndex() = statementCount++;
HighestTransitionCB.statementCount() = statementCount;
};
		newSLArgDeclRef2_1716.argdecl()= currMatch.stateLabel_1709;
		newHTPArgDeclRef2_1717.argdecl()= currMatch.hTPVar_170a;
		newSLArgDeclRef1_171e.argdecl()= currMatch.stateLabel_1709;
		newHTPArgDeclRef1_171d.argdecl()= currMatch.hTPVar_170a;
	}
}

void HighestTransParent_16b8::forwardInputs()
{
	*_state_16c8= _state_16cd;
	*_dstTransConnector_16c9= _dstTransConnector_16d6;
	*_transition_16ca= _transition_16df;
	*_function_16cb= _function_16e8;
	*_conditionalBlock_16cc= _conditionalBlock_16f1;
}

void ExecNextState_1720::operator()( const Packets_t& states_1721, const Packets_t& dstStates_1723, const Packets_t& transitions_1725, const Packets_t& functions_1727, const Packets_t& transitionCBs_1729)
{
#ifdef PRINT_INFO
	printLog( "ExecNextState_1720" );
#endif
	RTTGenerator::Instance()->generateRule(2519, "ExecNextState");
	processInputPackets( states_1721, dstStates_1723, transitions_1725, functions_1727, transitionCBs_1729);
}

bool ExecNextState_1720::isInputUnique( const Udm::Object& state_172f, const Udm::Object& dstState_1738, const Udm::Object& transition_1741, const Udm::Object& function_174a, const Udm::Object& transitionCB_1753)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1731= _state_172b.begin(), itDstState_173a= _dstState_1734.begin(), itTransition_1743= _transition_173d.begin(), itFunction_174c= _function_1746.begin(), itTransitionCB_1755= _transitionCB_174f.begin(); itState_1731!= _state_172b.end(), itDstState_173a!= _dstState_1734.end(), itTransition_1743!= _transition_173d.end(), itFunction_174c!= _function_1746.end(), itTransitionCB_1755!= _transitionCB_174f.end(); ++itState_1731, ++itDstState_173a, ++itTransition_1743, ++itFunction_174c, ++itTransitionCB_1755)
	{
		if( ( *itState_1731== state_172f)&& ( *itDstState_173a== dstState_1738)&& ( *itTransition_1743== transition_1741)&& ( *itFunction_174c== function_174a)&& ( *itTransitionCB_1755== transitionCB_1753))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_172b.push_back( state_172f);
		_dstState_1734.push_back( dstState_1738);
		_transition_173d.push_back( transition_1741);
		_function_1746.push_back( function_174a);
		_transitionCB_174f.push_back( transitionCB_1753);
	}
	return isUnique;
}

bool ExecNextState_1720::isGuardTrue( CyPhyML::SignalFlow::State& DstState, SFC::Function& Enter, SFC::Arg& EnterArg0, SFC::Arg& EnterArg1, SFC::Function& Exit, SFC::Arg& ExitArg, SFC::Function& Function, SFC::LocalVar& HTPVar, CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::Transition& Transition, SFC::ConditionalBlock& TransitionCB)
{
	bool Gz_guard= false;
	return static_cast< std::string >( HTPVar.name() ) == "_HTPVar_" && EnterArg0.argIndex() == 0 && EnterArg1.argIndex() == 1;;
	return Gz_guard;
}

void ExecNextState_1720::processInputPackets( const Packets_t& states_1721, const Packets_t& dstStates_1723, const Packets_t& transitions_1725, const Packets_t& functions_1727, const Packets_t& transitionCBs_1729)
{
	for( Packets_t::const_iterator itState_172c= states_1721.begin(), itDstState_1735= dstStates_1723.begin(), itTransition_173e= transitions_1725.begin(), itFunction_1747= functions_1727.begin(), itTransitionCB_1750= transitionCBs_1729.begin(); itState_172c!= states_1721.end(), itDstState_1735!= dstStates_1723.end(), itTransition_173e!= transitions_1725.end(), itFunction_1747!= functions_1727.end(), itTransitionCB_1750!= transitionCBs_1729.end(); ++itState_172c, ++itDstState_1735, ++itTransition_173e, ++itFunction_1747, ++itTransitionCB_1750)
	{
		bool isUnique= isInputUnique( *itState_172c, *itDstState_1735, *itTransition_173e, *itFunction_1747, *itTransitionCB_1750);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_172c, *itDstState_1735, *itTransition_173e, *itFunction_1747, *itTransitionCB_1750);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ExecNextState_1720::patternMatcher( const Udm::Object& state_172d, const Udm::Object& dstState_1736, const Udm::Object& transition_173f, const Udm::Object& function_1748, const Udm::Object& transitionCB_1751)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_172d.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1732= CyPhyML::SignalFlow::State::Cast( state_172d);
		if( false== Uml::IsDerivedFrom( dstState_1736.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State dstState_173b= CyPhyML::SignalFlow::State::Cast( dstState_1736);
		if( false== Uml::IsDerivedFrom( transition_173f.type(), CyPhyML::SignalFlow::Transition::meta))
			continue;
		CyPhyML::SignalFlow::Transition transition_1744= CyPhyML::SignalFlow::Transition::Cast( transition_173f);
		if( false== Uml::IsDerivedFrom( function_1748.type(), SFC::Function::meta))
			continue;
		SFC::Function function_174d= SFC::Function::Cast( function_1748);
		if( false== Uml::IsDerivedFrom( transitionCB_1751.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock transitionCB_1756= SFC::ConditionalBlock::Cast( transitionCB_1751);
		set< SFC::LocalVar> hTPVars_1758= function_174d.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itHTPVar_1759= hTPVars_1758.begin(); itHTPVar_1759!= hTPVars_1758.end(); ++itHTPVar_1759)
		{
			SFC::LocalVar currHTPVar_175a= *itHTPVar_1759;
			set< SFC::Function> exits_175b= state_1732.exit();
			for( set< SFC::Function>::const_iterator itExits_175c= exits_175b.begin(); itExits_175c!= exits_175b.end(); ++itExits_175c)
			{
				SFC::Function currExit_175d= *itExits_175c;
				set< SFC::Arg> exitArgs_175e= currExit_175d.Arg_kind_children();
				for( set< SFC::Arg>::const_iterator itExitArg_175f= exitArgs_175e.begin(); itExitArg_175f!= exitArgs_175e.end(); ++itExitArg_175f)
				{
					SFC::Arg currExitArg_1760= *itExitArg_175f;
					set< SFC::Function> enters_1761= dstState_173b.enter();
					for( set< SFC::Function>::const_iterator itEnters_1762= enters_1761.begin(); itEnters_1762!= enters_1761.end(); ++itEnters_1762)
					{
						SFC::Function currEnter_1763= *itEnters_1762;
						set< SFC::Arg> enterArg0s_1764= currEnter_1763.Arg_kind_children();
						for( set< SFC::Arg>::const_iterator itEnterArg0_1765= enterArg0s_1764.begin(); itEnterArg0_1765!= enterArg0s_1764.end(); ++itEnterArg0_1765)
						{
							SFC::Arg currEnterArg0_1766= *itEnterArg0_1765;
							set< SFC::Arg> enterArg1s_1767= currEnter_1763.Arg_kind_children();
							for( set< SFC::Arg>::const_iterator itEnterArg1_1768= enterArg1s_1767.begin(); itEnterArg1_1768!= enterArg1s_1767.end(); ++itEnterArg1_1768)
							{
								SFC::Arg currEnterArg1_1769= *itEnterArg1_1768;
								Match currMatch;
								currMatch.state_176b= state_1732;
								currMatch.dstState_176c= dstState_173b;
								currMatch.transition_176d= transition_1744;
								currMatch.function_176e= function_174d;
								currMatch.transitionCB_176f= transitionCB_1756;
								currMatch.exitArg_1770= currExitArg_1760;
								currMatch.exit_1771= currExit_175d;
								currMatch.enterArg0_1772= currEnterArg0_1766;
								currMatch.enter_1773= currEnter_1763;
								currMatch.enterArg1_1774= currEnterArg1_1769;
								currMatch.hTPVar_1775= currHTPVar_175a;
								bool Gz_guard= isGuardTrue( currMatch.dstState_176c, currMatch.enter_1773, currMatch.enterArg0_1772, currMatch.enterArg1_1774, currMatch.exit_1771, currMatch.exitArg_1770, currMatch.function_176e, currMatch.hTPVar_1775, currMatch.state_176b, currMatch.transition_176d, currMatch.transitionCB_176f);
								if( true== Gz_guard)
									_matches.push_back( currMatch);
							}
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void ExecNextState_1720::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::FunctionCall newExitFunctionCall_1781= SFC::FunctionCall::Create( currMatch.transitionCB_176f, SFC::ConditionalBlock::meta_stmnt);
		SFC::ArgVal newExitArgVal_1782= SFC::ArgVal::Create( newExitFunctionCall_1781);
		SFC::ArgDeclRef newExitArgDeclRef_1783= SFC::ArgDeclRef::Create( newExitArgVal_1782, SFC::ArgVal::meta_argexpr);
		SFC::Return newReturn_1784= SFC::Return::Create( currMatch.transitionCB_176f, SFC::ConditionalBlock::meta_stmnt);
		SFC::FunctionCall newEnterFunctionCall_1785= SFC::FunctionCall::Create( currMatch.transitionCB_176f, SFC::ConditionalBlock::meta_stmnt);
		SFC::ArgVal newEnterArgVal0_1786= SFC::ArgVal::Create( newEnterFunctionCall_1785);
		SFC::Int newZero_1787= SFC::Int::Create( newEnterArgVal0_1786, SFC::ArgVal::meta_argexpr);
		SFC::ArgVal newEnterArgVal1_1788= SFC::ArgVal::Create( newEnterFunctionCall_1785);
		SFC::ArgDeclRef newEnterArgDeclRef_1789= SFC::ArgDeclRef::Create( newEnterArgVal1_1788, SFC::ArgVal::meta_argexpr);
		CyPhyML::SignalFlow::State& DstState= currMatch.dstState_176c;
		SFC::Function& Enter= currMatch.enter_1773;
		SFC::Arg& EnterArg0= currMatch.enterArg0_1772;
		SFC::Arg& EnterArg1= currMatch.enterArg1_1774;
		SFC::ArgDeclRef& EnterArgDeclRef= newEnterArgDeclRef_1789;
		SFC::ArgVal& EnterArgVal0= newEnterArgVal0_1786;
		SFC::ArgVal& EnterArgVal1= newEnterArgVal1_1788;
		SFC::FunctionCall& EnterFunctionCall= newEnterFunctionCall_1785;
		SFC::Function& Exit= currMatch.exit_1771;
		SFC::Arg& ExitArg= currMatch.exitArg_1770;
		SFC::ArgDeclRef& ExitArgDeclRef= newExitArgDeclRef_1783;
		SFC::ArgVal& ExitArgVal= newExitArgVal_1782;
		SFC::FunctionCall& ExitFunctionCall= newExitFunctionCall_1781;
		SFC::Function& Function= currMatch.function_176e;
		SFC::LocalVar& HTPVar= currMatch.hTPVar_1775;
		SFC::Return& Return= newReturn_1784;
		CyPhyML::SignalFlow::State& State= currMatch.state_176b;
		CyPhyML::SignalFlow::Transition& Transition= currMatch.transition_176d;
		SFC::ConditionalBlock& TransitionCB= currMatch.transitionCB_176f;
		SFC::Int& Zero= newZero_1787;
		{
EnterFunctionCall.RefId() = ExitFunctionCall.RefId() = Return.RefId() = TransitionCB.RefId();
};
		{
EnterArgVal0.argIndex() = 0;
};
		{
Zero.val() = 0;
};
		{
__int64 statementCount = TransitionCB.statementCount();
ExitFunctionCall.statementIndex() = statementCount++;
TransitionCB.statementCount() = statementCount;

SFManager::mstat2SFC( TransitionCB, Transition.Action() );

statementCount = TransitionCB.statementCount();
EnterFunctionCall.statementIndex() = statementCount++;
Return.statementIndex() = statementCount++;
TransitionCB.statementCount() = statementCount;
};
		{
EnterArgVal1.argIndex() = 1;
};
		newEnterArgVal0_1786.arg()+= currMatch.enterArg0_1772;
		newExitFunctionCall_1781.callee()= currMatch.exit_1771;
		newExitArgDeclRef_1783.argdecl()= currMatch.hTPVar_1775;
		newEnterFunctionCall_1785.callee()= currMatch.enter_1773;
		newEnterArgVal1_1788.arg()+= currMatch.enterArg1_1774;
		newEnterArgDeclRef_1789.argdecl()= currMatch.hTPVar_1775;
		newExitArgVal_1782.arg()+= currMatch.exitArg_1770;
	}
}

void ExecTransConnectorRecurse_178a::operator()( const Packets_t& states_178b, const Packets_t& tcs_178d, const Packets_t& fcns_178f, const Packets_t& cgs_1791)
{
#ifdef PRINT_INFO
	printLog( "ExecTransConnectorRecurse_178a" );
#endif
	for( Packets_t::const_iterator itstate_1794= states_178b.begin(), ittc_179b= tcs_178d.begin(), itfcn_17a2= fcns_178f.begin(), itcg_17a9= cgs_1791.begin(); itstate_1794!= states_178b.end(), ittc_179b!= tcs_178d.end(), itfcn_17a2!= fcns_178f.end(), itcg_17a9!= cgs_1791.end(); ++itstate_1794, ++ittc_179b, ++itfcn_17a2, ++itcg_17a9)
	{
		bool isUnique= isInputUnique( *itstate_1794, *ittc_179b, *itfcn_17a2, *itcg_17a9);
		if( !isUnique)
			continue;
		Packets_t onestate_1798( 1, *itstate_1794);
		Packets_t onetc_179f( 1, *ittc_179b);
		Packets_t onefcn_17a6( 1, *itfcn_17a2);
		Packets_t onecg_17ad( 1, *itcg_17a9);
		executeOne( onestate_1798, onetc_179f, onefcn_17a6, onecg_17ad);
	}
}

void ExecTransConnectorRecurse_178a::executeOne( const Packets_t& states_178b, const Packets_t& tcs_178d, const Packets_t& fcns_178f, const Packets_t& cgs_1791)
{
	if( ( !states_178b.empty())&& ( !tcs_178d.empty())&& ( !fcns_178f.empty())&& ( !cgs_1791.empty()))
		callProcessedFilter_17ca( states_178b, tcs_178d, fcns_178f, cgs_1791);
}

bool ExecTransConnectorRecurse_178a::isInputUnique( const Udm::Object& state_1795, const Udm::Object& tc_179c, const Udm::Object& fcn_17a3, const Udm::Object& cg_17aa)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_1797= _state_1793.begin(), ittc_179e= _tc_179a.begin(), itfcn_17a5= _fcn_17a1.begin(), itcg_17ac= _cg_17a8.begin(); itstate_1797!= _state_1793.end(), ittc_179e!= _tc_179a.end(), itfcn_17a5!= _fcn_17a1.end(), itcg_17ac!= _cg_17a8.end(); ++itstate_1797, ++ittc_179e, ++itfcn_17a5, ++itcg_17ac)
	{
		if( ( *itstate_1797== state_1795)&& ( *ittc_179e== tc_179c)&& ( *itfcn_17a5== fcn_17a3)&& ( *itcg_17ac== cg_17aa))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1793.push_back( state_1795);
		_tc_179a.push_back( tc_179c);
		_fcn_17a1.push_back( fcn_17a3);
		_cg_17a8.push_back( cg_17aa);
	}
	return isUnique;
}

void ExecTransConnectorRecurse_178a::callProcessedFilter_17ca( const Packets_t& states_81a, const Packets_t& tcs_81c, const Packets_t& fcns_81e, const Packets_t& cgs_820)
{
	Packets_t states_822;
	Packets_t tcs_823;
	Packets_t fcns_824;
	Packets_t cgs_825;
	ProcessedFilter_819 processedFilter_819;
	processedFilter_819( states_81a, tcs_81c, fcns_81e, cgs_820, states_822, tcs_823, fcns_824, cgs_825);
	if( ( !states_822.empty())&& ( !tcs_823.empty())&& ( !fcns_824.empty())&& ( !cgs_825.empty()))
		callCreateTransitionCG_17cf( states_822, tcs_823, fcns_824, cgs_825);
}

void ExecTransConnectorRecurse_178a::callCreateTransitionCG_17cf( const Packets_t& states_7c9, const Packets_t& transConnectors_7cc, const Packets_t& functions_7cf, const Packets_t& tCVarCGs_7d3)
{
	Packets_t states_7cb;
	Packets_t transConnectors_7ce;
	Packets_t functions_7d1;
	Packets_t transitionCGs_7d2;
	CreateTransitionCG_7c8 createTransitionCG_7c8;
	createTransitionCG_7c8( states_7c9, transConnectors_7cc, functions_7cf, tCVarCGs_7d3, states_7cb, transConnectors_7ce, functions_7d1, transitionCGs_7d2);
	if( ( !states_7cb.empty())&& ( !transConnectors_7ce.empty())&& ( !functions_7d1.empty())&& ( !transitionCGs_7d2.empty()))
		callExecTransitions_17d4( states_7cb, transConnectors_7ce, functions_7d1, transitionCGs_7d2);
}

void ExecTransConnectorRecurse_178a::callExecTransitions_17d4( const Packets_t& states_17b0, const Packets_t& tcs_17b2, const Packets_t& fcns_17b4, const Packets_t& css_17b6)
{
	Packets_t states_17b8;
	Packets_t tcs_17b9;
	Packets_t fcns_17ba;
	Packets_t css_17bb;
	ExecTransitions_17af execTransitions_17af;
	execTransitions_17af( states_17b0, tcs_17b2, fcns_17b4, css_17b6, states_17b8, tcs_17b9, fcns_17ba, css_17bb);
	if( ( !states_17b8.empty())&& ( !tcs_17b9.empty())&& ( !fcns_17ba.empty())&& ( !css_17bb.empty()))
		callNoDefaultTransition_17d9( states_17b8, tcs_17b9, fcns_17ba, css_17bb);
}

void ExecTransConnectorRecurse_178a::callNoDefaultTransition_17d9( const Packets_t& states_88d, const Packets_t& tcs_88f, const Packets_t& fcns_891, const Packets_t& css_893)
{
	NoDefaultTransition_88c noDefaultTransition_88c;
	noDefaultTransition_88c( states_88d, tcs_88f, fcns_891, css_893);
}

void ExecTransitions_17af::operator()( const Packets_t& states_17b0, const Packets_t& tcs_17b2, const Packets_t& fcns_17b4, const Packets_t& css_17b6, Packets_t& states_17b8, Packets_t& tcs_17b9, Packets_t& fcns_17ba, Packets_t& css_17bb)
{
#ifdef PRINT_INFO
	printLog( "ExecTransitions_17af" );
#endif
	_state_17bc= &states_17b8;
	_tc_17bd= &tcs_17b9;
	_fcn_17be= &fcns_17ba;
	_cs_17bf= &css_17bb;
	_state_17bc->insert( _state_17bc->end(), states_17b0.begin(), states_17b0.end());
	_tc_17bd->insert( _tc_17bd->end(), tcs_17b2.begin(), tcs_17b2.end());
	_fcn_17be->insert( _fcn_17be->end(), fcns_17b4.begin(), fcns_17b4.end());
	_cs_17bf->insert( _cs_17bf->end(), css_17b6.begin(), css_17b6.end());
	if( ( !states_17b0.empty())&& ( !tcs_17b2.empty())&& ( !fcns_17b4.empty())&& ( !css_17b6.empty()))
		callGetAllTransitions_17c0( states_17b0, tcs_17b2, fcns_17b4, css_17b6);
}

void ExecTransitions_17af::callGetAllTransitions_17c0( const Packets_t& states_6b4, const Packets_t& tcs_6b6, const Packets_t& fcns_6b8, const Packets_t& css_6ba)
{
	Packets_t states_6bc;
	Packets_t transs_6bd;
	Packets_t fcns_6be;
	Packets_t css_6bf;
	GetAllTransitions_6b3 getAllTransitions_6b3;
	getAllTransitions_6b3( states_6b4, tcs_6b6, fcns_6b8, css_6ba, states_6bc, transs_6bd, fcns_6be, css_6bf);
	if( ( !states_6bc.empty())&& ( !transs_6bd.empty())&& ( !fcns_6be.empty())&& ( !css_6bf.empty()))
		callExecProcessTransitions_17c5( states_6bc, transs_6bd, fcns_6be, css_6bf);
}

void ExecTransitions_17af::callExecProcessTransitions_17c5( const Packets_t& states_16b0, const Packets_t& transs_16b2, const Packets_t& fcns_16b4, const Packets_t& css_16b6)
{
	ExecProcessTransitions_16af execProcessTransitions_16af;
	execProcessTransitions_16af( states_16b0, transs_16b2, fcns_16b4, css_16b6);
}

void CheckForInnerTransitions_1821::operator()( const Packets_t& states_1822, Packets_t& states_1824)
{
#ifdef PRINT_INFO
	printLog( "CheckForInnerTransitions_1821" );
#endif
	_state_1825= &states_1824;
	for( Packets_t::const_iterator itstate_1827= states_1822.begin(); itstate_1827!= states_1822.end(); ++itstate_1827)
	{
		bool isUnique= isInputUnique( *itstate_1827);
		if( !isUnique)
			continue;
		Packets_t onestate_182b( 1, *itstate_1827);
		executeOne( onestate_182b);
	}
}

void CheckForInnerTransitions_1821::executeOne( const Packets_t& states_1822)
{
	Packets_t states_1830;
	HasInnerTransition_182d hasInnerTransition_182d;
	bool isMatchHasInnerTransition_182d= hasInnerTransition_182d( states_1822, states_1830);
	_state_1825->insert( _state_1825->end(), states_1830.begin(), states_1830.end());
	if( isMatchHasInnerTransition_182d)
		return;
}

bool CheckForInnerTransitions_1821::isInputUnique( const Udm::Object& state_1828)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_182a= _state_1826.begin(); itstate_182a!= _state_1826.end(); ++itstate_182a)
	{
		if( ( *itstate_182a== state_1828))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1826.push_back( state_1828);
	return isUnique;
}

bool HasInnerTransition_182d::operator()( const Packets_t& states_182e, Packets_t& states_1830)
{
#ifdef PRINT_INFO
	printLog( "HasInnerTransition_182d" );
#endif
	_state_1831= &states_1830;
	processInputPackets( states_182e);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasInnerTransition_182d::isInputUnique( const Udm::Object& state_1836)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1838= _state_1832.begin(); itState_1838!= _state_1832.end(); ++itState_1838)
	{
		if( ( *itState_1838== state_1836))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1832.push_back( state_1836);
	return isUnique;
}

bool HasInnerTransition_182d::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void HasInnerTransition_182d::processInputPackets( const Packets_t& states_182e)
{
	for( Packets_t::const_iterator itState_1833= states_182e.begin(); itState_1833!= states_182e.end(); ++itState_1833)
	{
		bool isUnique= isInputUnique( *itState_1833);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1833);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1848);
	}
}

bool HasInnerTransition_182d::patternMatcher( const Udm::Object& state_1834)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1834.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1839= CyPhyML::SignalFlow::State::Cast( state_1834);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_183b= state_1839.ConnectorRef_kind_children();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRef_183c= connectorRefs_183b.begin(); itConnectorRef_183c!= connectorRefs_183b.end(); ++itConnectorRef_183c)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_183d= *itConnectorRef_183c;
			CyPhyML::SignalFlow::TransConnector state_183e= currConnectorRef_183d.ref();
			if( false== Uml::IsDerivedFrom( state_183e.type(), CyPhyML::SignalFlow::State::meta))
				continue;
			CyPhyML::SignalFlow::State state_183f= CyPhyML::SignalFlow::State::Cast( state_183e);
			if( !state_183f)
				continue;
			if( state_1839!= state_183f)
				continue;
			set< CyPhyML::SignalFlow::Transition> transitions_1840= currConnectorRef_183d.dstTransition();
			for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransitions_1841= transitions_1840.begin(); itTransitions_1841!= transitions_1840.end(); ++itTransitions_1841)
			{
				CyPhyML::SignalFlow::Transition currTransition_1842= *itTransitions_1841;
				CyPhyML::SignalFlow::TransConnector transConnector_1843= currTransition_1842.dstTransition_end();
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_1847;
				if( !isValidBound(boundObjs_1847, state_1839, true))
					continue;
				currMatch.state_1848= state_1839;
				if( !isValidBound(boundObjs_1847, currTransition_1842, false))
					continue;
				currMatch.transition_1849= currTransition_1842;
				if( !isValidBound(boundObjs_1847, currConnectorRef_183d, false))
					continue;
				currMatch.connectorRef_184a= currConnectorRef_183d;
				if( !isValidBound(boundObjs_1847, transConnector_1843, false))
					continue;
				currMatch.transConnector_184b= transConnector_1843;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void HasInnerTransition_182d::outputAppender( const CyPhyML::SignalFlow::State& state_184c)
{
	_state_1831->push_back( state_184c);
}

void Init_184e::operator()( const Packets_t& states_184f, Packets_t& states_1851, Packets_t& tcs_1852, Packets_t& fcns_1853, Packets_t& cgs_1854)
{
#ifdef PRINT_INFO
	printLog( "Init_184e" );
#endif
	_state_1855= &states_1851;
	_tc_1856= &tcs_1852;
	_fcn_1857= &fcns_1853;
	_cg_1858= &cgs_1854;
	if( ( !states_184f.empty()))
		callGetExecFunction_18dc( states_184f);
}

void Init_184e::callGetExecFunction_18dc( const Packets_t& states_18c3)
{
	Packets_t states_18c5;
	Packets_t execs_18c6;
	GetExecFunction_18c2 getExecFunction_18c2;
	getExecFunction_18c2( states_18c3, states_18c5, execs_18c6);
	if( ( !states_18c5.empty())&& ( !execs_18c6.empty())&& ( !execs_18c6.empty()))
		callInitHTPVar_18de( states_18c5, execs_18c6, execs_18c6);
}

void Init_184e::callInitHTPVar_18de( const Packets_t& states_1886, const Packets_t& functions_1889, const Packets_t& compoundStatements_188c)
{
	Packets_t states_1888;
	Packets_t functions_188b;
	Packets_t compoundStatements_188e;
	InitHTPVar_1885 initHTPVar_1885;
	initHTPVar_1885( states_1886, functions_1889, compoundStatements_188c, states_1888, functions_188b, compoundStatements_188e);
	if( ( !states_1888.empty())&& ( !functions_188b.empty())&& ( !compoundStatements_188e.empty()))
		callInitTCVarLoop_18e2( states_1888, functions_188b, compoundStatements_188e);
}

void Init_184e::callInitTCVarLoop_18e2( const Packets_t& states_f3, const Packets_t& functions_f6, const Packets_t& compoundStatements_f9)
{
	Packets_t states_f5;
	Packets_t functions_f8;
	Packets_t conditionalGroups_fb;
	InitTCVarLoop_f2 initTCVarLoop_f2;
	initTCVarLoop_f2( states_f3, functions_f6, compoundStatements_f9, states_f5, functions_f8, conditionalGroups_fb);
	if( ( !states_f5.empty())&& ( !functions_f8.empty())&& ( !conditionalGroups_fb.empty()))
		callGetStartTC_18e6( states_f5, functions_f8, conditionalGroups_fb);
}

void Init_184e::callGetStartTC_18e6( const Packets_t& states_185a, const Packets_t& functions_185d, const Packets_t& conditionalGroups_1860)
{
	Packets_t states_185c;
	Packets_t functions_185f;
	Packets_t conditionalGroups_1862;
	GetStartTC_1859 getStartTC_1859;
	getStartTC_1859( states_185a, functions_185d, conditionalGroups_1860, states_185c, functions_185f, conditionalGroups_1862);
	_tc_1856->insert( _tc_1856->end(), states_185c.begin(), states_185c.end());
	_state_1855->insert( _state_1855->end(), states_185c.begin(), states_185c.end());
	_fcn_1857->insert( _fcn_1857->end(), functions_185f.begin(), functions_185f.end());
	_cg_1858->insert( _cg_1858->end(), conditionalGroups_1862.begin(), conditionalGroups_1862.end());
}

void GetStartTC_1859::operator()( const Packets_t& states_185a, const Packets_t& functions_185d, const Packets_t& conditionalGroups_1860, Packets_t& states_185c, Packets_t& functions_185f, Packets_t& conditionalGroups_1862)
{
#ifdef PRINT_INFO
	printLog( "GetStartTC_1859" );
#endif
	RTTGenerator::Instance()->generateRule(797, "GetStartTC");
	_state_1863= &states_185c;
	_function_1864= &functions_185f;
	_conditionalGroup_1865= &conditionalGroups_1862;
	processInputPackets( states_185a, functions_185d, conditionalGroups_1860);
	forwardInputs( );
}

bool GetStartTC_1859::isInputUnique( const Udm::Object& state_186a, const Udm::Object& function_1873, const Udm::Object& conditionalGroup_187c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_186c= _state_1866.begin(), itFunction_1875= _function_186f.begin(), itConditionalGroup_187e= _conditionalGroup_1878.begin(); itState_186c!= _state_1866.end(), itFunction_1875!= _function_186f.end(), itConditionalGroup_187e!= _conditionalGroup_1878.end(); ++itState_186c, ++itFunction_1875, ++itConditionalGroup_187e)
	{
		if( ( *itState_186c== state_186a)&& ( *itFunction_1875== function_1873)&& ( *itConditionalGroup_187e== conditionalGroup_187c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1866.push_back( state_186a);
		_function_186f.push_back( function_1873);
		_conditionalGroup_1878.push_back( conditionalGroup_187c);
	}
	return isUnique;
}

void GetStartTC_1859::processInputPackets( const Packets_t& states_185a, const Packets_t& functions_185d, const Packets_t& conditionalGroups_1860)
{
	for( Packets_t::const_iterator itState_1867= states_185a.begin(), itFunction_1870= functions_185d.begin(), itConditionalGroup_1879= conditionalGroups_1860.begin(); itState_1867!= states_185a.end(), itFunction_1870!= functions_185d.end(), itConditionalGroup_1879!= conditionalGroups_1860.end(); ++itState_1867, ++itFunction_1870, ++itConditionalGroup_1879)
	{
		bool isUnique= isInputUnique( *itState_1867, *itFunction_1870, *itConditionalGroup_1879);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1867, *itFunction_1870, *itConditionalGroup_1879);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetStartTC_1859::patternMatcher( const Udm::Object& state_1868, const Udm::Object& function_1871, const Udm::Object& conditionalGroup_187a)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1868.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_186d= CyPhyML::SignalFlow::State::Cast( state_1868);
		if( false== Uml::IsDerivedFrom( function_1871.type(), SFC::Function::meta))
			continue;
		SFC::Function function_1876= SFC::Function::Cast( function_1871);
		if( false== Uml::IsDerivedFrom( conditionalGroup_187a.type(), SFC::ConditionalGroup::meta))
			continue;
		SFC::ConditionalGroup conditionalGroup_187f= SFC::ConditionalGroup::Cast( conditionalGroup_187a);
		Match currMatch;
		currMatch.state_1882= state_186d;
		currMatch.function_1883= function_1876;
		currMatch.conditionalGroup_1884= conditionalGroup_187f;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void GetStartTC_1859::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
	}
}

void GetStartTC_1859::forwardInputs()
{
	*_state_1863= _state_1866;
	*_function_1864= _function_186f;
	*_conditionalGroup_1865= _conditionalGroup_1878;
}

void InitHTPVar_1885::operator()( const Packets_t& states_1886, const Packets_t& functions_1889, const Packets_t& compoundStatements_188c, Packets_t& states_1888, Packets_t& functions_188b, Packets_t& compoundStatements_188e)
{
#ifdef PRINT_INFO
	printLog( "InitHTPVar_1885" );
#endif
	RTTGenerator::Instance()->generateRule(801, "InitHTPVar");
	_state_188f= &states_1888;
	_function_1890= &functions_188b;
	_compoundStatement_1891= &compoundStatements_188e;
	processInputPackets( states_1886, functions_1889, compoundStatements_188c);
	forwardInputs( );
}

bool InitHTPVar_1885::isInputUnique( const Udm::Object& state_1896, const Udm::Object& function_189f, const Udm::Object& compoundStatement_18a8)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1898= _state_1892.begin(), itFunction_18a1= _function_189b.begin(), itCompoundStatement_18aa= _compoundStatement_18a4.begin(); itState_1898!= _state_1892.end(), itFunction_18a1!= _function_189b.end(), itCompoundStatement_18aa!= _compoundStatement_18a4.end(); ++itState_1898, ++itFunction_18a1, ++itCompoundStatement_18aa)
	{
		if( ( *itState_1898== state_1896)&& ( *itFunction_18a1== function_189f)&& ( *itCompoundStatement_18aa== compoundStatement_18a8))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1892.push_back( state_1896);
		_function_189b.push_back( function_189f);
		_compoundStatement_18a4.push_back( compoundStatement_18a8);
	}
	return isUnique;
}

bool InitHTPVar_1885::isGuardTrue( SFC::CompoundStatement& CompoundStatement, SFC::Function& Function, SFC::LocalVar& HTPVar, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel)
{
	bool Gz_guard= false;
	return static_cast< std::string >( HTPVar.name() ) == "_HTPVar_";;
	return Gz_guard;
}

void InitHTPVar_1885::processInputPackets( const Packets_t& states_1886, const Packets_t& functions_1889, const Packets_t& compoundStatements_188c)
{
	for( Packets_t::const_iterator itState_1893= states_1886.begin(), itFunction_189c= functions_1889.begin(), itCompoundStatement_18a5= compoundStatements_188c.begin(); itState_1893!= states_1886.end(), itFunction_189c!= functions_1889.end(), itCompoundStatement_18a5!= compoundStatements_188c.end(); ++itState_1893, ++itFunction_189c, ++itCompoundStatement_18a5)
	{
		bool isUnique= isInputUnique( *itState_1893, *itFunction_189c, *itCompoundStatement_18a5);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1893, *itFunction_189c, *itCompoundStatement_18a5);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitHTPVar_1885::patternMatcher( const Udm::Object& state_1894, const Udm::Object& function_189d, const Udm::Object& compoundStatement_18a6)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1894.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1899= CyPhyML::SignalFlow::State::Cast( state_1894);
		if( false== Uml::IsDerivedFrom( function_189d.type(), SFC::Function::meta))
			continue;
		SFC::Function function_18a2= SFC::Function::Cast( function_189d);
		if( false== Uml::IsDerivedFrom( compoundStatement_18a6.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_18ab= SFC::CompoundStatement::Cast( compoundStatement_18a6);
		set< SFC::LocalVar> hTPVars_18ad= function_18a2.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itHTPVar_18ae= hTPVars_18ad.begin(); itHTPVar_18ae!= hTPVars_18ad.end(); ++itHTPVar_18ae)
		{
			SFC::LocalVar currHTPVar_18af= *itHTPVar_18ae;
			set< SFC::StateLabel> stateLabels_18b0= state_1899.src();
			for( set< SFC::StateLabel>::const_iterator itStateLabels_18b1= stateLabels_18b0.begin(); itStateLabels_18b1!= stateLabels_18b0.end(); ++itStateLabels_18b1)
			{
				SFC::StateLabel currStateLabel_18b2= *itStateLabels_18b1;
				Match currMatch;
				currMatch.state_18b4= state_1899;
				currMatch.function_18b5= function_18a2;
				currMatch.compoundStatement_18b6= compoundStatement_18ab;
				currMatch.stateLabel_18b7= currStateLabel_18b2;
				currMatch.hTPVar_18b8= currHTPVar_18af;
				bool Gz_guard= isGuardTrue( currMatch.compoundStatement_18b6, currMatch.function_18b5, currMatch.hTPVar_18b8, currMatch.state_18b4, currMatch.stateLabel_18b7);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void InitHTPVar_1885::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::UserCode newInitHTPVar_18be= SFC::UserCode::Create( currMatch.compoundStatement_18b6, SFC::CompoundStatement::meta_stmnt);
		SFC::BinaryExprs newAssignHTPVar_18bf= SFC::BinaryExprs::Create( newInitHTPVar_18be, SFC::UserCode::meta_codeexpr);
		SFC::ArgDeclRef newHTPArgDeclRef_18c0= SFC::ArgDeclRef::Create( newAssignHTPVar_18bf, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef_18c1= SFC::ArgDeclRef::Create( newAssignHTPVar_18bf, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_18c1;
		SFC::BinaryExprs& AssignHTPVar= newAssignHTPVar_18bf;
		SFC::CompoundStatement& CompoundStatement= currMatch.compoundStatement_18b6;
		SFC::Function& Function= currMatch.function_18b5;
		SFC::ArgDeclRef& HTPArgDeclRef= newHTPArgDeclRef_18c0;
		SFC::LocalVar& HTPVar= currMatch.hTPVar_18b8;
		SFC::UserCode& InitHTPVar= newInitHTPVar_18be;
		CyPhyML::SignalFlow::State& State= currMatch.state_18b4;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_18b7;
		{
InitHTPVar.RefId() = CompoundStatement.RefId();
};
		{
__int64 statementCount = CompoundStatement.statementCount();
InitHTPVar.statementIndex() = statementCount++;
CompoundStatement.statementCount() = statementCount;
};
		{
AssignHTPVar.op() = "=";
};
		newArgDeclRef_18c1.argdecl()= currMatch.stateLabel_18b7;
		newHTPArgDeclRef_18c0.argdecl()= currMatch.hTPVar_18b8;
	}
}

void InitHTPVar_1885::forwardInputs()
{
	*_state_188f= _state_1892;
	*_function_1890= _function_189b;
	*_compoundStatement_1891= _compoundStatement_18a4;
}

void GetExecFunction_18c2::operator()( const Packets_t& states_18c3, Packets_t& states_18c5, Packets_t& execs_18c6)
{
#ifdef PRINT_INFO
	printLog( "GetExecFunction_18c2" );
#endif
	RTTGenerator::Instance()->generateRule(822, "GetExecFunction");
	_state_18c7= &states_18c5;
	_exec_18c8= &execs_18c6;
	processInputPackets( states_18c3);
}

bool GetExecFunction_18c2::isInputUnique( const Udm::Object& state_18cd)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_18cf= _state_18c9.begin(); itState_18cf!= _state_18c9.end(); ++itState_18cf)
	{
		if( ( *itState_18cf== state_18cd))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_18c9.push_back( state_18cd);
	return isUnique;
}

void GetExecFunction_18c2::processInputPackets( const Packets_t& states_18c3)
{
	for( Packets_t::const_iterator itState_18ca= states_18c3.begin(); itState_18ca!= states_18c3.end(); ++itState_18ca)
	{
		bool isUnique= isInputUnique( *itState_18ca);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_18ca);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetExecFunction_18c2::patternMatcher( const Udm::Object& state_18cb)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_18cb.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_18d0= CyPhyML::SignalFlow::State::Cast( state_18cb);
		set< SFC::Function> execs_18d2= state_18d0.exec();
		for( set< SFC::Function>::const_iterator itExecs_18d3= execs_18d2.begin(); itExecs_18d3!= execs_18d2.end(); ++itExecs_18d3)
		{
			SFC::Function currExec_18d4= *itExecs_18d3;
			Match currMatch;
			currMatch.state_18d6= state_18d0;
			currMatch.exec_18d7= currExec_18d4;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetExecFunction_18c2::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_18d6, currMatch.exec_18d7);
	}
}

void GetExecFunction_18c2::outputAppender( const CyPhyML::SignalFlow::State& state_18d8, const SFC::Function& exec_18da)
{
	_state_18c7->push_back( state_18d8);
	_exec_18c8->push_back( exec_18da);
}

void InitTransConnMapInner_18fd::operator()( const Packets_t& states_18fe, Packets_t& states_1900)
{
#ifdef PRINT_INFO
	printLog( "InitTransConnMapInner_18fd" );
#endif
	_state_1901= &states_1900;
	if( ( !states_18fe.empty()))
		callInitTransConnectorMap_1940( states_18fe);
	_state_1901->insert( _state_1901->end(), states_18fe.begin(), states_18fe.end());
}

void InitTransConnMapInner_18fd::callInitTransConnectorMap_1940( const Packets_t& states_1931)
{
	Packets_t states_1933;
	InitTransConnectorMap_1930 initTransConnectorMap_1930;
	initTransConnectorMap_1930( states_1931, states_1933);
	if( ( !states_1933.empty())&& ( !states_1933.empty()))
		callAddTransConnector_1942( states_1933, states_1933);
}

void InitTransConnMapInner_18fd::callAddTransConnector_1942( const Packets_t& states_ad9, const Packets_t& transConnectors_adc)
{
	Packets_t states_adb;
	Packets_t transConnectors_ade;
	AddTransConnector_ad8 addTransConnector_ad8;
	addTransConnector_ad8( states_ad9, transConnectors_adc, states_adb, transConnectors_ade);
	if( ( !states_adb.empty())&& ( !transConnectors_ade.empty()))
		callGetInnerTransitions_1945( states_adb, transConnectors_ade);
}

void InitTransConnMapInner_18fd::callGetInnerTransitions_1945( const Packets_t& states_1903, const Packets_t& states_1907)
{
	Packets_t states_1905;
	Packets_t transitions_1906;
	GetInnerTransitions_1902 getInnerTransitions_1902;
	getInnerTransitions_1902( states_1903, states_1907, states_1905, transitions_1906);
	if( ( !states_1905.empty())&& ( !transitions_1906.empty()))
		callProcessTransitionsMap_1948( states_1905, transitions_1906);
}

void InitTransConnMapInner_18fd::callProcessTransitionsMap_1948( const Packets_t& states_af7, const Packets_t& transs_af9)
{
	ProcessTransitionsMap_af6 processTransitionsMap_af6;
	processTransitionsMap_af6( states_af7, transs_af9);
}

void GetInnerTransitions_1902::operator()( const Packets_t& states_1903, const Packets_t& states_1907, Packets_t& states_1905, Packets_t& transitions_1906)
{
#ifdef PRINT_INFO
	printLog( "GetInnerTransitions_1902" );
#endif
	RTTGenerator::Instance()->generateRule(745, "GetInnerTransitions");
	_state_1909= &states_1905;
	_transition_190a= &transitions_1906;
	processInputPackets( states_1903, states_1907);
}

bool GetInnerTransitions_1902::isInputUnique( const Udm::Object& state_190f, const Udm::Object& state_1918)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1911= _state_190b.begin(), itState_191a= _state_1914.begin(); itState_1911!= _state_190b.end(), itState_191a!= _state_1914.end(); ++itState_1911, ++itState_191a)
	{
		if( ( *itState_1911== state_190f)&& ( *itState_191a== state_1918))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_190b.push_back( state_190f);
		_state_1914.push_back( state_1918);
	}
	return isUnique;
}

void GetInnerTransitions_1902::processInputPackets( const Packets_t& states_1903, const Packets_t& states_1907)
{
	for( Packets_t::const_iterator itState_190c= states_1903.begin(), itState_1915= states_1907.begin(); itState_190c!= states_1903.end(), itState_1915!= states_1907.end(); ++itState_190c, ++itState_1915)
	{
		bool isUnique= isInputUnique( *itState_190c, *itState_1915);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_190c, *itState_1915);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetInnerTransitions_1902::patternMatcher( const Udm::Object& state_190d, const Udm::Object& state_1916)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_190d.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1912= CyPhyML::SignalFlow::State::Cast( state_190d);
		if( false== Uml::IsDerivedFrom( state_1916.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_191b= CyPhyML::SignalFlow::State::Cast( state_1916);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_191d= state_191b.ConnectorRef_kind_children();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRef_191e= connectorRefs_191d.begin(); itConnectorRef_191e!= connectorRefs_191d.end(); ++itConnectorRef_191e)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_191f= *itConnectorRef_191e;
			CyPhyML::SignalFlow::TransConnector state_1920= currConnectorRef_191f.ref();
			if( false== Uml::IsDerivedFrom( state_1920.type(), CyPhyML::SignalFlow::State::meta))
				continue;
			CyPhyML::SignalFlow::State state_1921= CyPhyML::SignalFlow::State::Cast( state_1920);
			if( !state_1921)
				continue;
			if( state_191b!= state_1921)
				continue;
			set< CyPhyML::SignalFlow::Transition> transitions_1922= currConnectorRef_191f.dstTransition();
			for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransitions_1923= transitions_1922.begin(); itTransitions_1923!= transitions_1922.end(); ++itTransitions_1923)
			{
				CyPhyML::SignalFlow::Transition currTransition_1924= *itTransitions_1923;
				CyPhyML::SignalFlow::TransConnector dstTransConnector_1925= currTransition_1924.dstTransition_end();
				Match currMatch;
				currMatch.state_1927= state_1912;
				currMatch.state_1928= state_191b;
				currMatch.dstTransConnector_1929= dstTransConnector_1925;
				currMatch.transition_192a= currTransition_1924;
				currMatch.connectorRef_192b= currConnectorRef_191f;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetInnerTransitions_1902::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1927, currMatch.transition_192a);
	}
}

void GetInnerTransitions_1902::outputAppender( const CyPhyML::SignalFlow::State& state_192c, const CyPhyML::SignalFlow::Transition& transition_192e)
{
	_state_1909->push_back( state_192c);
	_transition_190a->push_back( transition_192e);
}

void InitTransConnectorMap_1930::operator()( const Packets_t& states_1931, Packets_t& states_1933)
{
#ifdef PRINT_INFO
	printLog( "InitTransConnectorMap_1930" );
#endif
	RTTGenerator::Instance()->generateRule(864, "InitTransConnectorMap");
	_state_1934= &states_1933;
	processInputPackets( states_1931);
	forwardInputs( );
}

bool InitTransConnectorMap_1930::isInputUnique( const Udm::Object& state_1939)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_193b= _state_1935.begin(); itState_193b!= _state_1935.end(); ++itState_193b)
	{
		if( ( *itState_193b== state_1939))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1935.push_back( state_1939);
	return isUnique;
}

void InitTransConnectorMap_1930::processInputPackets( const Packets_t& states_1931)
{
	for( Packets_t::const_iterator itState_1936= states_1931.begin(); itState_1936!= states_1931.end(); ++itState_1936)
	{
		bool isUnique= isInputUnique( *itState_1936);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1936);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitTransConnectorMap_1930::patternMatcher( const Udm::Object& state_1937)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1937.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_193c= CyPhyML::SignalFlow::State::Cast( state_1937);
		Match currMatch;
		currMatch.state_193f= state_193c;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void InitTransConnectorMap_1930::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		CyPhyML::SignalFlow::State& State= currMatch.state_193f;
		{
SFManager::StateTransConnectorMap::get_singleton().clearState( State );
};
	}
}

void InitTransConnectorMap_1930::forwardInputs()
{
	*_state_1934= _state_1935;
}

void DuringAction_194b::operator()( const Packets_t& states_194c, Packets_t& states_194e)
{
#ifdef PRINT_INFO
	printLog( "DuringAction_194b" );
#endif
	RTTGenerator::Instance()->generateRule(755, "DuringAction");
	_state_194f= &states_194e;
	processInputPackets( states_194c);
	forwardInputs( );
}

bool DuringAction_194b::isInputUnique( const Udm::Object& state_1954)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1956= _state_1950.begin(); itState_1956!= _state_1950.end(); ++itState_1956)
	{
		if( ( *itState_1956== state_1954))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1950.push_back( state_1954);
	return isUnique;
}

bool DuringAction_194b::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void DuringAction_194b::processInputPackets( const Packets_t& states_194c)
{
	for( Packets_t::const_iterator itState_1951= states_194c.begin(); itState_1951!= states_194c.end(); ++itState_1951)
	{
		bool isUnique= isInputUnique( *itState_1951);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1951);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool DuringAction_194b::patternMatcher( const Udm::Object& state_1952)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1952.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1957= CyPhyML::SignalFlow::State::Cast( state_1952);
		set< SFC::Function> execs_1959= state_1957.exec();
		for( set< SFC::Function>::const_iterator itExecs_195a= execs_1959.begin(); itExecs_195a!= execs_1959.end(); ++itExecs_195a)
		{
			SFC::Function currExec_195b= *itExecs_195a;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_195f;
			if( !isValidBound(boundObjs_195f, state_1957, true))
				continue;
			currMatch.state_1960= state_1957;
			if( !isValidBound(boundObjs_195f, currExec_195b, false))
				continue;
			currMatch.exec_1961= currExec_195b;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void DuringAction_194b::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function& Exec= currMatch.exec_1961;
		CyPhyML::SignalFlow::State& State= currMatch.state_1960;
		{
std::string duringAction = State.DuringAction();
SFManager::mstat2SFC( Exec, duringAction );
};
	}
}

void DuringAction_194b::forwardInputs()
{
	*_state_194f= _state_1950;
}

void OuterTransitions_1962::operator()( const Packets_t& states_1963, Packets_t& states_1965)
{
#ifdef PRINT_INFO
	printLog( "OuterTransitions_1962" );
#endif
	_state_1966= &states_1965;
	if( ( !states_1963.empty()))
		callCheckForOuterTransitions_19cf( states_1963);
	_state_1966->insert( _state_1966->end(), states_1963.begin(), states_1963.end());
}

void OuterTransitions_1962::callCheckForOuterTransitions_19cf( const Packets_t& states_1968)
{
	Packets_t states_196a;
	CheckForOuterTransitions_1967 checkForOuterTransitions_1967;
	checkForOuterTransitions_1967( states_1968, states_196a);
	if( ( !states_196a.empty()))
		callInit_19d1( states_196a);
}

void OuterTransitions_1962::callInit_19d1( const Packets_t& states_184f)
{
	Packets_t states_1851;
	Packets_t tcs_1852;
	Packets_t fcns_1853;
	Packets_t cgs_1854;
	Init_184e init_184e;
	init_184e( states_184f, states_1851, tcs_1852, fcns_1853, cgs_1854);
	if( ( !states_1851.empty())&& ( !tcs_1852.empty())&& ( !fcns_1853.empty())&& ( !cgs_1854.empty()))
		callExecTransConnectorRecurse_19d3( states_1851, tcs_1852, fcns_1853, cgs_1854);
}

void OuterTransitions_1962::callExecTransConnectorRecurse_19d3( const Packets_t& states_178b, const Packets_t& tcs_178d, const Packets_t& fcns_178f, const Packets_t& cgs_1791)
{
	ExecTransConnectorRecurse_178a execTransConnectorRecurse_178a;
	execTransConnectorRecurse_178a( states_178b, tcs_178d, fcns_178f, cgs_1791);
}

void CheckForOuterTransitions_1967::operator()( const Packets_t& states_1968, Packets_t& states_196a)
{
#ifdef PRINT_INFO
	printLog( "CheckForOuterTransitions_1967" );
#endif
	_state_196b= &states_196a;
	for( Packets_t::const_iterator itstate_196d= states_1968.begin(); itstate_196d!= states_1968.end(); ++itstate_196d)
	{
		bool isUnique= isInputUnique( *itstate_196d);
		if( !isUnique)
			continue;
		Packets_t onestate_1971( 1, *itstate_196d);
		executeOne( onestate_1971);
	}
}

void CheckForOuterTransitions_1967::executeOne( const Packets_t& states_1968)
{
	Packets_t states_1976;
	HasOuterTransition_1973 hasOuterTransition_1973;
	bool isMatchHasOuterTransition_1973= hasOuterTransition_1973( states_1968, states_1976);
	_state_196b->insert( _state_196b->end(), states_1976.begin(), states_1976.end());
	if( isMatchHasOuterTransition_1973)
		return;
	HasInnerTransition_198b hasInnerTransition_198b;
	bool isMatchHasInnerTransition_198b= hasInnerTransition_198b( states_1968);
	if( isMatchHasInnerTransition_198b)
		return;
	Packets_t states_19a8;
	HasRefOuterTransition_19a5 hasRefOuterTransition_19a5;
	bool isMatchHasRefOuterTransition_19a5= hasRefOuterTransition_19a5( states_1968, states_19a8);
	_state_196b->insert( _state_196b->end(), states_19a8.begin(), states_19a8.end());
	if( isMatchHasRefOuterTransition_19a5)
		return;
	Otherwise_19c1 otherwise_19c1;
	bool isMatchOtherwise_19c1= otherwise_19c1( states_1968);
	if( isMatchOtherwise_19c1)
		return;
}

bool CheckForOuterTransitions_1967::isInputUnique( const Udm::Object& state_196e)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_1970= _state_196c.begin(); itstate_1970!= _state_196c.end(); ++itstate_1970)
	{
		if( ( *itstate_1970== state_196e))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_196c.push_back( state_196e);
	return isUnique;
}

bool HasOuterTransition_1973::operator()( const Packets_t& states_1974, Packets_t& states_1976)
{
#ifdef PRINT_INFO
	printLog( "HasOuterTransition_1973" );
#endif
	_state_1977= &states_1976;
	processInputPackets( states_1974);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasOuterTransition_1973::isInputUnique( const Udm::Object& state_197c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_197e= _state_1978.begin(); itState_197e!= _state_1978.end(); ++itState_197e)
	{
		if( ( *itState_197e== state_197c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1978.push_back( state_197c);
	return isUnique;
}

void HasOuterTransition_1973::processInputPackets( const Packets_t& states_1974)
{
	for( Packets_t::const_iterator itState_1979= states_1974.begin(); itState_1979!= states_1974.end(); ++itState_1979)
	{
		bool isUnique= isInputUnique( *itState_1979);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1979);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1986);
	}
}

bool HasOuterTransition_1973::patternMatcher( const Udm::Object& state_197a)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_197a.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_197f= CyPhyML::SignalFlow::State::Cast( state_197a);
		set< CyPhyML::SignalFlow::Transition> transitions_1981= state_197f.dstTransition();
		for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransitions_1982= transitions_1981.begin(); itTransitions_1982!= transitions_1981.end(); ++itTransitions_1982)
		{
			CyPhyML::SignalFlow::Transition currTransition_1983= *itTransitions_1982;
			CyPhyML::SignalFlow::TransConnector transConnector_1984= currTransition_1983.dstTransition_end();
			Match currMatch;
			currMatch.state_1986= state_197f;
			currMatch.transition_1987= currTransition_1983;
			currMatch.transConnector_1988= transConnector_1984;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void HasOuterTransition_1973::outputAppender( const CyPhyML::SignalFlow::State& state_1989)
{
	_state_1977->push_back( state_1989);
}

bool HasInnerTransition_198b::operator()( const Packets_t& states_198c)
{
#ifdef PRINT_INFO
	printLog( "HasInnerTransition_198b" );
#endif
	processInputPackets( states_198c);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasInnerTransition_198b::isInputUnique( const Udm::Object& state_1992)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1994= _state_198e.begin(); itState_1994!= _state_198e.end(); ++itState_1994)
	{
		if( ( *itState_1994== state_1992))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_198e.push_back( state_1992);
	return isUnique;
}

void HasInnerTransition_198b::processInputPackets( const Packets_t& states_198c)
{
	for( Packets_t::const_iterator itState_198f= states_198c.begin(); itState_198f!= states_198c.end(); ++itState_198f)
	{
		bool isUnique= isInputUnique( *itState_198f);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_198f);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( );
	}
}

bool HasInnerTransition_198b::patternMatcher( const Udm::Object& state_1990)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1990.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1995= CyPhyML::SignalFlow::State::Cast( state_1990);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_1997= state_1995.ConnectorRef_kind_children();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRef_1998= connectorRefs_1997.begin(); itConnectorRef_1998!= connectorRefs_1997.end(); ++itConnectorRef_1998)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_1999= *itConnectorRef_1998;
			CyPhyML::SignalFlow::TransConnector state_199a= currConnectorRef_1999.ref();
			if( false== Uml::IsDerivedFrom( state_199a.type(), CyPhyML::SignalFlow::State::meta))
				continue;
			CyPhyML::SignalFlow::State state_199b= CyPhyML::SignalFlow::State::Cast( state_199a);
			if( !state_199b)
				continue;
			if( state_1995!= state_199b)
				continue;
			set< CyPhyML::SignalFlow::Transition> transitions_199c= currConnectorRef_1999.dstTransition();
			for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransitions_199d= transitions_199c.begin(); itTransitions_199d!= transitions_199c.end(); ++itTransitions_199d)
			{
				CyPhyML::SignalFlow::Transition currTransition_199e= *itTransitions_199d;
				CyPhyML::SignalFlow::TransConnector transConnector_199f= currTransition_199e.dstTransition_end();
				Match currMatch;
				currMatch.state_19a1= state_1995;
				currMatch.transition_19a2= currTransition_199e;
				currMatch.connectorRef_19a3= currConnectorRef_1999;
				currMatch.transConnector_19a4= transConnector_199f;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void HasInnerTransition_198b::outputAppender()
{
}

bool HasRefOuterTransition_19a5::operator()( const Packets_t& states_19a6, Packets_t& states_19a8)
{
#ifdef PRINT_INFO
	printLog( "HasRefOuterTransition_19a5" );
#endif
	_state_19a9= &states_19a8;
	processInputPackets( states_19a6);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasRefOuterTransition_19a5::isInputUnique( const Udm::Object& state_19ae)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_19b0= _state_19aa.begin(); itState_19b0!= _state_19aa.end(); ++itState_19b0)
	{
		if( ( *itState_19b0== state_19ae))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_19aa.push_back( state_19ae);
	return isUnique;
}

void HasRefOuterTransition_19a5::processInputPackets( const Packets_t& states_19a6)
{
	for( Packets_t::const_iterator itState_19ab= states_19a6.begin(); itState_19ab!= states_19a6.end(); ++itState_19ab)
	{
		bool isUnique= isInputUnique( *itState_19ab);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_19ab);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_19bb);
	}
}

bool HasRefOuterTransition_19a5::patternMatcher( const Udm::Object& state_19ac)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_19ac.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_19b1= CyPhyML::SignalFlow::State::Cast( state_19ac);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_19b3= state_19b1.referedbyConnectorRef();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRefs_19b4= connectorRefs_19b3.begin(); itConnectorRefs_19b4!= connectorRefs_19b3.end(); ++itConnectorRefs_19b4)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_19b5= *itConnectorRefs_19b4;
			set< CyPhyML::SignalFlow::Transition> transitions_19b6= currConnectorRef_19b5.dstTransition();
			for( set< CyPhyML::SignalFlow::Transition>::const_iterator itTransitions_19b7= transitions_19b6.begin(); itTransitions_19b7!= transitions_19b6.end(); ++itTransitions_19b7)
			{
				CyPhyML::SignalFlow::Transition currTransition_19b8= *itTransitions_19b7;
				CyPhyML::SignalFlow::TransConnector transConnector_19b9= currTransition_19b8.dstTransition_end();
				Match currMatch;
				currMatch.state_19bb= state_19b1;
				currMatch.transition_19bc= currTransition_19b8;
				currMatch.connectorRef_19bd= currConnectorRef_19b5;
				currMatch.transConnector_19be= transConnector_19b9;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void HasRefOuterTransition_19a5::outputAppender( const CyPhyML::SignalFlow::State& state_19bf)
{
	_state_19a9->push_back( state_19bf);
}

bool Otherwise_19c1::operator()( const Packets_t& states_19c2)
{
#ifdef PRINT_INFO
	printLog( "Otherwise_19c1" );
#endif
	processInputPackets( states_19c2);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_19c1::isInputUnique( const Udm::Object& state_19c8)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_19ca= _state_19c4.begin(); itState_19ca!= _state_19c4.end(); ++itState_19ca)
	{
		if( ( *itState_19ca== state_19c8))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_19c4.push_back( state_19c8);
	return isUnique;
}

void Otherwise_19c1::processInputPackets( const Packets_t& states_19c2)
{
	for( Packets_t::const_iterator itState_19c5= states_19c2.begin(); itState_19c5!= states_19c2.end(); ++itState_19c5)
	{
		bool isUnique= isInputUnique( *itState_19c5);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_19c5);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( );
	}
}

bool Otherwise_19c1::patternMatcher( const Udm::Object& state_19c6)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_19c6.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_19cb= CyPhyML::SignalFlow::State::Cast( state_19c6);
		Match currMatch;
		currMatch.state_19ce= state_19cb;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_19c1::outputAppender()
{
}

void InitTransConnMap_19d8::operator()( const Packets_t& states_19d9, Packets_t& states_19db)
{
#ifdef PRINT_INFO
	printLog( "InitTransConnMap_19d8" );
#endif
	_state_19dc= &states_19db;
	if( ( !states_19d9.empty()))
		callInitTransConnectorMap_19dd( states_19d9);
	_state_19dc->insert( _state_19dc->end(), states_19d9.begin(), states_19d9.end());
}

void InitTransConnMap_19d8::callInitTransConnectorMap_19dd( const Packets_t& states_1931)
{
	Packets_t states_1933;
	InitTransConnectorMap_1930 initTransConnectorMap_1930;
	initTransConnectorMap_1930( states_1931, states_1933);
	if( ( !states_1933.empty())&& ( !states_1933.empty()))
		callTransConnectorMapRecurse_19df( states_1933, states_1933);
}

void InitTransConnMap_19d8::callTransConnectorMapRecurse_19df( const Packets_t& states_a2b, const Packets_t& tcs_a2d)
{
	TransConnectorMapRecurse_a2a transConnectorMapRecurse_a2a;
	transConnectorMapRecurse_a2a( states_a2b, tcs_a2d);
}

void PopulateExitFunction_19ee::operator()( const Packets_t& states_19ef, const Packets_t& programs_19f1, Packets_t& states_19f3, Packets_t& programs_19f4)
{
#ifdef PRINT_INFO
	printLog( "PopulateExitFunction_19ee" );
#endif
	_state_19f5= &states_19f3;
	_program_19f6= &programs_19f4;
	if( ( !states_19ef.empty()))
		callGetExitFunction_1c0d( states_19ef);
	_state_19f5->insert( _state_19f5->end(), states_19ef.begin(), states_19ef.end());
	_program_19f6->insert( _program_19f6->end(), programs_19f1.begin(), programs_19f1.end());
}

void PopulateExitFunction_19ee::callGetExitFunction_1c0d( const Packets_t& states_1bf1)
{
	Packets_t states_1bf3;
	Packets_t exits_1bf4;
	GetExitFunction_1bf0 getExitFunction_1bf0;
	getExitFunction_1bf0( states_1bf1, states_1bf3, exits_1bf4);
	if( ( !states_1bf3.empty())&& ( !exits_1bf4.empty()))
		callExitChildStates_1c0f( states_1bf3, exits_1bf4);
}

void PopulateExitFunction_19ee::callExitChildStates_1c0f( const Packets_t& states_1a33, const Packets_t& fcns_1a35)
{
	Packets_t states_1a37;
	Packets_t fcns_1a38;
	ExitChildStates_1a32 exitChildStates_1a32;
	exitChildStates_1a32( states_1a33, fcns_1a35, states_1a37, fcns_1a38);
	if( ( !states_1a37.empty())&& ( !fcns_1a38.empty()))
		callGoToParent_1c12( states_1a37, fcns_1a38);
}

void PopulateExitFunction_19ee::callGoToParent_1c12( const Packets_t& states_19f8, const Packets_t& fcns_19fa)
{
	Packets_t states_19fc;
	Packets_t fcns_19fd;
	GoToParent_19f7 goToParent_19f7;
	goToParent_19f7( states_19f8, fcns_19fa, states_19fc, fcns_19fd);
}

void GoToParent_19f7::operator()( const Packets_t& states_19f8, const Packets_t& fcns_19fa, Packets_t& states_19fc, Packets_t& fcns_19fd)
{
#ifdef PRINT_INFO
	printLog( "GoToParent_19f7" );
#endif
	_state_19fe= &states_19fc;
	_fcn_19ff= &fcns_19fd;
	if( ( !states_19f8.empty())&& ( !fcns_19fa.empty()))
		callArgToParent_1a2f( states_19f8, fcns_19fa);
	_state_19fe->insert( _state_19fe->end(), states_19f8.begin(), states_19f8.end());
	_fcn_19ff->insert( _fcn_19ff->end(), fcns_19fa.begin(), fcns_19fa.end());
}

void GoToParent_19f7::callArgToParent_1a2f( const Packets_t& states_1a01, const Packets_t& functions_1a03)
{
	ArgToParent_1a00 argToParent_1a00;
	argToParent_1a00( states_1a01, functions_1a03);
}

void ArgToParent_1a00::operator()( const Packets_t& states_1a01, const Packets_t& functions_1a03)
{
#ifdef PRINT_INFO
	printLog( "ArgToParent_1a00" );
#endif
	RTTGenerator::Instance()->generateRule(877, "ArgToParent");
	processInputPackets( states_1a01, functions_1a03);
}

bool ArgToParent_1a00::isInputUnique( const Udm::Object& state_1a09, const Udm::Object& function_1a12)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1a0b= _state_1a05.begin(), itFunction_1a14= _function_1a0e.begin(); itState_1a0b!= _state_1a05.end(), itFunction_1a14!= _function_1a0e.end(); ++itState_1a0b, ++itFunction_1a14)
	{
		if( ( *itState_1a0b== state_1a09)&& ( *itFunction_1a14== function_1a12))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1a05.push_back( state_1a09);
		_function_1a0e.push_back( function_1a12);
	}
	return isUnique;
}

bool ArgToParent_1a00::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void ArgToParent_1a00::processInputPackets( const Packets_t& states_1a01, const Packets_t& functions_1a03)
{
	for( Packets_t::const_iterator itState_1a06= states_1a01.begin(), itFunction_1a0f= functions_1a03.begin(); itState_1a06!= states_1a01.end(), itFunction_1a0f!= functions_1a03.end(); ++itState_1a06, ++itFunction_1a0f)
	{
		bool isUnique= isInputUnique( *itState_1a06, *itFunction_1a0f);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1a06, *itFunction_1a0f);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ArgToParent_1a00::patternMatcher( const Udm::Object& state_1a07, const Udm::Object& function_1a10)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1a07.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1a0c= CyPhyML::SignalFlow::State::Cast( state_1a07);
		if( false== Uml::IsDerivedFrom( function_1a10.type(), SFC::Function::meta))
			continue;
		SFC::Function function_1a15= SFC::Function::Cast( function_1a10);
		set< SFC::Arg> args_1a17= function_1a15.Arg_kind_children();
		for( set< SFC::Arg>::const_iterator itArg_1a18= args_1a17.begin(); itArg_1a18!= args_1a17.end(); ++itArg_1a18)
		{
			SFC::Arg currArg_1a19= *itArg_1a18;
			Udm::Object stateParent_1a1a= state_1a0c.container();
			if( false== Uml::IsDerivedFrom( stateParent_1a1a.type(), CyPhyML::SignalFlow::State::meta))
				continue;
			CyPhyML::SignalFlow::State parentStateState_1a1b= CyPhyML::SignalFlow::State::Cast( stateParent_1a1a);
			set< SFC::Function> parentExits_1a1c= parentStateState_1a1b.exit();
			for( set< SFC::Function>::const_iterator itParentExits_1a1d= parentExits_1a1c.begin(); itParentExits_1a1d!= parentExits_1a1c.end(); ++itParentExits_1a1d)
			{
				SFC::Function currParentExit_1a1e= *itParentExits_1a1d;
				set< SFC::Arg> parentArgs_1a1f= currParentExit_1a1e.Arg_kind_children();
				for( set< SFC::Arg>::const_iterator itParentArg_1a20= parentArgs_1a1f.begin(); itParentArg_1a20!= parentArgs_1a1f.end(); ++itParentArg_1a20)
				{
					SFC::Arg currParentArg_1a21= *itParentArg_1a20;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_1a25;
					if( !isValidBound(boundObjs_1a25, state_1a0c, true))
						continue;
					currMatch.state_1a26= state_1a0c;
					if( !isValidBound(boundObjs_1a25, function_1a15, true))
						continue;
					currMatch.function_1a27= function_1a15;
					if( !isValidBound(boundObjs_1a25, parentStateState_1a1b, false))
						continue;
					currMatch.parentState_1a28= parentStateState_1a1b;
					if( !isValidBound(boundObjs_1a25, currParentArg_1a21, false))
						continue;
					currMatch.parentArg_1a29= currParentArg_1a21;
					if( !isValidBound(boundObjs_1a25, currParentExit_1a1e, false))
						continue;
					currMatch.parentExit_1a2a= currParentExit_1a1e;
					if( !isValidBound(boundObjs_1a25, currArg_1a19, false))
						continue;
					currMatch.arg_1a2b= currArg_1a19;
					_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void ArgToParent_1a00::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::FunctionCall newFunctionCall_1a2c= SFC::FunctionCall::Create( currMatch.function_1a27, SFC::Function::meta_stmnt);
		SFC::ArgVal newArgVal_1a2d= SFC::ArgVal::Create( newFunctionCall_1a2c);
		SFC::ArgDeclRef newArgDeclRef_1a2e= SFC::ArgDeclRef::Create( newArgVal_1a2d, SFC::ArgVal::meta_argexpr);
		SFC::Arg& Arg= currMatch.arg_1a2b;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_1a2e;
		SFC::ArgVal& ArgVal= newArgVal_1a2d;
		SFC::Function& Function= currMatch.function_1a27;
		SFC::FunctionCall& FunctionCall= newFunctionCall_1a2c;
		SFC::Arg& ParentArg= currMatch.parentArg_1a29;
		SFC::Function& ParentExit= currMatch.parentExit_1a2a;
		CyPhyML::SignalFlow::State& ParentState= currMatch.parentState_1a28;
		CyPhyML::SignalFlow::State& State= currMatch.state_1a26;
		{
FunctionCall.RefId() = Function.RefId();
};
		{
__int64 statementCount = Function.statementCount();
FunctionCall.statementIndex() = statementCount++;
Function.statementCount() = statementCount;
};
		newFunctionCall_1a2c.callee()= currMatch.parentExit_1a2a;
		newArgVal_1a2d.arg()+= currMatch.parentArg_1a29;
		newArgDeclRef_1a2e.argdecl()= currMatch.arg_1a2b;
	}
}

void ExitChildStates_1a32::operator()( const Packets_t& states_1a33, const Packets_t& fcns_1a35, Packets_t& states_1a37, Packets_t& fcns_1a38)
{
#ifdef PRINT_INFO
	printLog( "ExitChildStates_1a32" );
#endif
	_state_1a39= &states_1a37;
	_fcn_1a3a= &fcns_1a38;
	if( ( !states_1a33.empty())&& ( !fcns_1a35.empty()))
		callArgNegOneOrState_1be5( states_1a33, fcns_1a35);
	_state_1a39->insert( _state_1a39->end(), states_1a33.begin(), states_1a33.end());
	_fcn_1a3a->insert( _fcn_1a3a->end(), fcns_1a35.begin(), fcns_1a35.end());
}

void ExitChildStates_1a32::callArgNegOneOrState_1be5( const Packets_t& states_1bac, const Packets_t& functions_1bb0)
{
	Packets_t states_1bae;
	Packets_t args_1baf;
	Packets_t conditionalBlocks_1bb2;
	ArgNegOneOrState_1bab argNegOneOrState_1bab;
	argNegOneOrState_1bab( states_1bac, functions_1bb0, states_1bae, args_1baf, conditionalBlocks_1bb2);
	if( ( !states_1bae.empty())&& ( !args_1baf.empty())&& ( !conditionalBlocks_1bb2.empty()))
		callCallChildExits_1be8( states_1bae, args_1baf, conditionalBlocks_1bb2);
}

void ExitChildStates_1a32::callCallChildExits_1be8( const Packets_t& states_1a82, const Packets_t& args_1a84, const Packets_t& cbs_1a86)
{
	Packets_t states_1a88;
	Packets_t args_1a89;
	Packets_t cbs_1a8a;
	CallChildExits_1a81 callChildExits_1a81;
	callChildExits_1a81( states_1a82, args_1a84, cbs_1a86, states_1a88, args_1a89, cbs_1a8a);
	if( ( !states_1a88.empty())&& ( !args_1a89.empty())&& ( !cbs_1a8a.empty()))
		callDeactivateState_1bec( states_1a88, args_1a89, cbs_1a8a);
}

void ExitChildStates_1a32::callDeactivateState_1bec( const Packets_t& states_1a3c, const Packets_t& args_1a3e, const Packets_t& childrenCalledCBs_1a40)
{
	DeactivateState_1a3b deactivateState_1a3b;
	deactivateState_1a3b( states_1a3c, args_1a3e, childrenCalledCBs_1a40);
}

void DeactivateState_1a3b::operator()( const Packets_t& states_1a3c, const Packets_t& args_1a3e, const Packets_t& childrenCalledCBs_1a40)
{
#ifdef PRINT_INFO
	printLog( "DeactivateState_1a3b" );
#endif
	RTTGenerator::Instance()->generateRule(904, "DeactivateState");
	processInputPackets( states_1a3c, args_1a3e, childrenCalledCBs_1a40);
}

bool DeactivateState_1a3b::isInputUnique( const Udm::Object& state_1a46, const Udm::Object& arg_1a4f, const Udm::Object& childrenCalledCB_1a58)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1a48= _state_1a42.begin(), itArg_1a51= _arg_1a4b.begin(), itChildrenCalledCB_1a5a= _childrenCalledCB_1a54.begin(); itState_1a48!= _state_1a42.end(), itArg_1a51!= _arg_1a4b.end(), itChildrenCalledCB_1a5a!= _childrenCalledCB_1a54.end(); ++itState_1a48, ++itArg_1a51, ++itChildrenCalledCB_1a5a)
	{
		if( ( *itState_1a48== state_1a46)&& ( *itArg_1a51== arg_1a4f)&& ( *itChildrenCalledCB_1a5a== childrenCalledCB_1a58))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1a42.push_back( state_1a46);
		_arg_1a4b.push_back( arg_1a4f);
		_childrenCalledCB_1a54.push_back( childrenCalledCB_1a58);
	}
	return isUnique;
}

bool DeactivateState_1a3b::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void DeactivateState_1a3b::processInputPackets( const Packets_t& states_1a3c, const Packets_t& args_1a3e, const Packets_t& childrenCalledCBs_1a40)
{
	for( Packets_t::const_iterator itState_1a43= states_1a3c.begin(), itArg_1a4c= args_1a3e.begin(), itChildrenCalledCB_1a55= childrenCalledCBs_1a40.begin(); itState_1a43!= states_1a3c.end(), itArg_1a4c!= args_1a3e.end(), itChildrenCalledCB_1a55!= childrenCalledCBs_1a40.end(); ++itState_1a43, ++itArg_1a4c, ++itChildrenCalledCB_1a55)
	{
		bool isUnique= isInputUnique( *itState_1a43, *itArg_1a4c, *itChildrenCalledCB_1a55);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1a43, *itArg_1a4c, *itChildrenCalledCB_1a55);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool DeactivateState_1a3b::patternMatcher( const Udm::Object& state_1a44, const Udm::Object& arg_1a4d, const Udm::Object& childrenCalledCB_1a56)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1a44.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1a49= CyPhyML::SignalFlow::State::Cast( state_1a44);
		if( false== Uml::IsDerivedFrom( arg_1a4d.type(), SFC::Arg::meta))
			continue;
		SFC::Arg arg_1a52= SFC::Arg::Cast( arg_1a4d);
		if( false== Uml::IsDerivedFrom( childrenCalledCB_1a56.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock childrenCalledCB_1a5b= SFC::ConditionalBlock::Cast( childrenCalledCB_1a56);
		Udm::Object stateParent_1a5d= state_1a49.container();
		if( false== Uml::IsDerivedFrom( stateParent_1a5d.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State parentStateState_1a5e= CyPhyML::SignalFlow::State::Cast( stateParent_1a5d);
		set< SFC::Function> functions_1a5f= parentStateState_1a5e.exit();
		for( set< SFC::Function>::const_iterator itFunctions_1a60= functions_1a5f.begin(); itFunctions_1a60!= functions_1a5f.end(); ++itFunctions_1a60)
		{
			SFC::Function currFunction_1a61= *itFunctions_1a60;
			Udm::Object functionParent_1a62= currFunction_1a61.container();
			if( false== Uml::IsDerivedFrom( functionParent_1a62.type(), SFC::Program::meta))
				continue;
			SFC::Program programFunction_1a63= SFC::Program::Cast( functionParent_1a62);
			set< SFC::StateVar> stateVars_1a64= programFunction_1a63.StateVar_kind_children();
			for( set< SFC::StateVar>::const_iterator itStateVar_1a65= stateVars_1a64.begin(); itStateVar_1a65!= stateVars_1a64.end(); ++itStateVar_1a65)
			{
				SFC::StateVar currStateVar_1a66= *itStateVar_1a65;
				set< SFC::StateLabel> parentStateLabels_1a67= parentStateState_1a5e.src();
				for( set< SFC::StateLabel>::const_iterator itParentStateLabels_1a68= parentStateLabels_1a67.begin(); itParentStateLabels_1a68!= parentStateLabels_1a67.end(); ++itParentStateLabels_1a68)
				{
					SFC::StateLabel currParentStateLabel_1a69= *itParentStateLabels_1a68;
					set< SFC::StateLabel> stateLabels_1a6a= state_1a49.src();
					for( set< SFC::StateLabel>::const_iterator itStateLabels_1a6b= stateLabels_1a6a.begin(); itStateLabels_1a6b!= stateLabels_1a6a.end(); ++itStateLabels_1a6b)
					{
						SFC::StateLabel currStateLabel_1a6c= *itStateLabels_1a6b;
						Match currMatch;
						set< pair<int, Udm::Object> > boundObjs_1a70;
						if( !isValidBound(boundObjs_1a70, state_1a49, true))
							continue;
						currMatch.state_1a71= state_1a49;
						if( !isValidBound(boundObjs_1a70, arg_1a52, true))
							continue;
						currMatch.arg_1a72= arg_1a52;
						if( !isValidBound(boundObjs_1a70, childrenCalledCB_1a5b, true))
							continue;
						currMatch.childrenCalledCB_1a73= childrenCalledCB_1a5b;
						if( !isValidBound(boundObjs_1a70, parentStateState_1a5e, false))
							continue;
						currMatch.parentState_1a74= parentStateState_1a5e;
						if( !isValidBound(boundObjs_1a70, currFunction_1a61, false))
							continue;
						currMatch.function_1a75= currFunction_1a61;
						if( !isValidBound(boundObjs_1a70, currStateLabel_1a6c, false))
							continue;
						currMatch.stateLabel_1a76= currStateLabel_1a6c;
						if( !isValidBound(boundObjs_1a70, currParentStateLabel_1a69, false))
							continue;
						currMatch.parentStateLabel_1a77= currParentStateLabel_1a69;
						if( !isValidBound(boundObjs_1a70, programFunction_1a63, false))
							continue;
						currMatch.program_1a78= programFunction_1a63;
						if( !isValidBound(boundObjs_1a70, currStateVar_1a66, false))
							continue;
						currMatch.stateVar_1a79= currStateVar_1a66;
						_matches.push_back( currMatch);
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void DeactivateState_1a3b::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Return newReturn_1a7a= SFC::Return::Create( currMatch.childrenCalledCB_1a73, SFC::ConditionalBlock::meta_stmnt);
		SFC::ConditionalBlock newConditionalBlock_1a7b= SFC::ConditionalBlock::Create( currMatch.childrenCalledCB_1a73, SFC::ConditionalBlock::meta_stmnt);
		SFC::SetState newSetState_1a7c= SFC::SetState::Create( newConditionalBlock_1a7b, SFC::ConditionalBlock::meta_stmnt);
		SFC::UserCode newUserCode_1a7d= SFC::UserCode::Create( newConditionalBlock_1a7b, SFC::ConditionalBlock::meta_cond);
		SFC::BinaryExprs newEqual_1a7e= SFC::BinaryExprs::Create( newUserCode_1a7d, SFC::UserCode::meta_codeexpr);
		SFC::ArgDeclRef newArgDeclRef_1a7f= SFC::ArgDeclRef::Create( newEqual_1a7e, SFC::BinaryExprs::meta_leftexpr);
		SFC::Int newInt_1a80= SFC::Int::Create( newEqual_1a7e, SFC::BinaryExprs::meta_rightexpr);
		SFC::Arg& Arg= currMatch.arg_1a72;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_1a7f;
		SFC::ConditionalBlock& ChildrenCalledCB= currMatch.childrenCalledCB_1a73;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_1a7b;
		SFC::BinaryExprs& Equal= newEqual_1a7e;
		SFC::Function& Function= currMatch.function_1a75;
		SFC::Int& Int= newInt_1a80;
		CyPhyML::SignalFlow::State& ParentState= currMatch.parentState_1a74;
		SFC::StateLabel& ParentStateLabel= currMatch.parentStateLabel_1a77;
		SFC::Program& Program= currMatch.program_1a78;
		SFC::Return& Return= newReturn_1a7a;
		SFC::SetState& SetState= newSetState_1a7c;
		CyPhyML::SignalFlow::State& State= currMatch.state_1a71;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_1a76;
		SFC::StateVar& StateVar= currMatch.stateVar_1a79;
		SFC::UserCode& UserCode= newUserCode_1a7d;
		{
ConditionalBlock.RefId() = UserCode.RefId() = SetState.RefId() = Return.RefId() = ChildrenCalledCB.RefId();
};
		{
std::string exitAction = State.ExitAction();
exitAction = SFManager::trim( exitAction );

SFManager::mstat2SFC( ConditionalBlock, exitAction );

__int64 statementCount = ConditionalBlock.statementCount();
SetState.statementIndex() = statementCount++;
ConditionalBlock.statementCount() = statementCount;

};
		{
SetState.invert() = true;
SetState.andState() = static_cast< std::string >( State.Decomposition() ) == "AND_STATE";
};
		{
__int64 statementCount = ChildrenCalledCB.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
Return.statementIndex() = statementCount++;
ChildrenCalledCB.statementCount() = statementCount;
};
		{
Equal.op() = "==";
Int.val() = -1;
};
		newSetState_1a7c.index()= currMatch.parentStateLabel_1a77;
		newSetState_1a7c.value()= currMatch.stateLabel_1a76;
		newSetState_1a7c.svar()= currMatch.stateVar_1a79;
		newArgDeclRef_1a7f.argdecl()= currMatch.arg_1a72;
	}
}

void CallChildExits_1a81::operator()( const Packets_t& states_1a82, const Packets_t& args_1a84, const Packets_t& cbs_1a86, Packets_t& states_1a88, Packets_t& args_1a89, Packets_t& cbs_1a8a)
{
#ifdef PRINT_INFO
	printLog( "CallChildExits_1a81" );
#endif
	_state_1a8b= &states_1a88;
	_arg_1a8c= &args_1a89;
	_cb_1a8d= &cbs_1a8a;
	if( ( !states_1a82.empty())&& ( !cbs_1a86.empty()))
		callOrStateCG_1ba1( states_1a82, cbs_1a86);
	_state_1a8b->insert( _state_1a8b->end(), states_1a82.begin(), states_1a82.end());
	_arg_1a8c->insert( _arg_1a8c->end(), args_1a84.begin(), args_1a84.end());
	_cb_1a8d->insert( _cb_1a8d->end(), cbs_1a86.begin(), cbs_1a86.end());
}

void CallChildExits_1a81::callOrStateCG_1ba1( const Packets_t& states_1a8f, const Packets_t& css_1a91)
{
	Packets_t states_1a93;
	Packets_t css_1a94;
	OrStateCG_1a8e orStateCG_1a8e;
	orStateCG_1a8e( states_1a8f, css_1a91, states_1a93, css_1a94);
	if( ( !states_1a93.empty())&& ( !css_1a94.empty()))
		callROrderChildStates_1ba4( states_1a93, css_1a94);
}

void CallChildExits_1a81::callROrderChildStates_1ba4( const Packets_t& states_1b30, const Packets_t& compoundStatements_1b34)
{
	Packets_t states_1b32;
	Packets_t states_1b33;
	Packets_t compoundStatements_1b36;
	ROrderChildStates_1b2f rOrderChildStates_1b2f;
	rOrderChildStates_1b2f( states_1b30, compoundStatements_1b34, states_1b32, states_1b33, compoundStatements_1b36);
	if( ( !states_1b32.empty())&& ( !states_1b33.empty())&& ( !compoundStatements_1b36.empty()))
		callExitChildStates_1ba7( states_1b32, states_1b33, compoundStatements_1b36);
}

void CallChildExits_1a81::callExitChildStates_1ba7( const Packets_t& states_1b5d, const Packets_t& childStates_1b5f, const Packets_t& compoundStatements_1b61)
{
	ExitChildStates_1b5c exitChildStates_1b5c;
	exitChildStates_1b5c( states_1b5d, childStates_1b5f, compoundStatements_1b61);
}

void OrStateCG_1a8e::operator()( const Packets_t& states_1a8f, const Packets_t& css_1a91, Packets_t& states_1a93, Packets_t& css_1a94)
{
#ifdef PRINT_INFO
	printLog( "OrStateCG_1a8e" );
#endif
	_state_1a95= &states_1a93;
	_cs_1a96= &css_1a94;
	if( ( !states_1a8f.empty())&& ( !css_1a91.empty()))
		callChildStateType_1b29( states_1a8f, css_1a91);
}

void OrStateCG_1a8e::callChildStateType_1b29( const Packets_t& states_1abe, const Packets_t& css_1ac0)
{
	Packets_t states_1ac2;
	Packets_t css_1ac3;
	Packets_t states_1ac4;
	Packets_t css_1ac5;
	ChildStateType_1abd childStateType_1abd;
	childStateType_1abd( states_1abe, css_1ac0, states_1ac2, css_1ac3, states_1ac4, css_1ac5);
	_state_1a95->insert( _state_1a95->end(), states_1ac2.begin(), states_1ac2.end());
	_cs_1a96->insert( _cs_1a96->end(), css_1ac3.begin(), css_1ac3.end());
	if( ( !states_1ac4.empty())&& ( !css_1ac5.empty()))
		callCG_1b2c( states_1ac4, css_1ac5);
}

void OrStateCG_1a8e::callCG_1b2c( const Packets_t& states_1a98, const Packets_t& compoundStatements_1a9b)
{
	Packets_t states_1a9a;
	Packets_t conditionalGroups_1a9d;
	CG_1a97 cG_1a97;
	cG_1a97( states_1a98, compoundStatements_1a9b, states_1a9a, conditionalGroups_1a9d);
	_state_1a95->insert( _state_1a95->end(), states_1a9a.begin(), states_1a9a.end());
	_cs_1a96->insert( _cs_1a96->end(), conditionalGroups_1a9d.begin(), conditionalGroups_1a9d.end());
}

void CG_1a97::operator()( const Packets_t& states_1a98, const Packets_t& compoundStatements_1a9b, Packets_t& states_1a9a, Packets_t& conditionalGroups_1a9d)
{
#ifdef PRINT_INFO
	printLog( "CG_1a97" );
#endif
	RTTGenerator::Instance()->generateRule(955, "CG");
	_state_1a9e= &states_1a9a;
	_conditionalGroup_1a9f= &conditionalGroups_1a9d;
	processInputPackets( states_1a98, compoundStatements_1a9b);
}

bool CG_1a97::isInputUnique( const Udm::Object& state_1aa4, const Udm::Object& compoundStatement_1aad)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1aa6= _state_1aa0.begin(), itCompoundStatement_1aaf= _compoundStatement_1aa9.begin(); itState_1aa6!= _state_1aa0.end(), itCompoundStatement_1aaf!= _compoundStatement_1aa9.end(); ++itState_1aa6, ++itCompoundStatement_1aaf)
	{
		if( ( *itState_1aa6== state_1aa4)&& ( *itCompoundStatement_1aaf== compoundStatement_1aad))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1aa0.push_back( state_1aa4);
		_compoundStatement_1aa9.push_back( compoundStatement_1aad);
	}
	return isUnique;
}

bool CG_1a97::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CG_1a97::processInputPackets( const Packets_t& states_1a98, const Packets_t& compoundStatements_1a9b)
{
	for( Packets_t::const_iterator itState_1aa1= states_1a98.begin(), itCompoundStatement_1aaa= compoundStatements_1a9b.begin(); itState_1aa1!= states_1a98.end(), itCompoundStatement_1aaa!= compoundStatements_1a9b.end(); ++itState_1aa1, ++itCompoundStatement_1aaa)
	{
		bool isUnique= isInputUnique( *itState_1aa1, *itCompoundStatement_1aaa);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1aa1, *itCompoundStatement_1aaa);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CG_1a97::patternMatcher( const Udm::Object& state_1aa2, const Udm::Object& compoundStatement_1aab)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1aa2.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1aa7= CyPhyML::SignalFlow::State::Cast( state_1aa2);
		if( false== Uml::IsDerivedFrom( compoundStatement_1aab.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1ab0= SFC::CompoundStatement::Cast( compoundStatement_1aab);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1ab5;
		if( !isValidBound(boundObjs_1ab5, state_1aa7, true))
			continue;
		currMatch.state_1ab6= state_1aa7;
		if( !isValidBound(boundObjs_1ab5, compoundStatement_1ab0, true))
			continue;
		currMatch.compoundStatement_1ab7= compoundStatement_1ab0;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CG_1a97::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalGroup newConditionalGroup_1ab8= SFC::ConditionalGroup::Create( currMatch.compoundStatement_1ab7, SFC::CompoundStatement::meta_stmnt);
		SFC::CompoundStatement& CompoundStatement= currMatch.compoundStatement_1ab7;
		SFC::ConditionalGroup& ConditionalGroup= newConditionalGroup_1ab8;
		CyPhyML::SignalFlow::State& State= currMatch.state_1ab6;
		{
ConditionalGroup.RefId() = CompoundStatement.RefId();
};
		{
__int64 statementCount = CompoundStatement.statementCount();
ConditionalGroup.statementIndex() = statementCount++;
CompoundStatement.statementCount() = statementCount;
};
		outputAppender( currMatch.state_1ab6, newConditionalGroup_1ab8);
	}
}

void CG_1a97::outputAppender( const CyPhyML::SignalFlow::State& state_1ab9, const SFC::ConditionalGroup& conditionalGroup_1abb)
{
	_state_1a9e->push_back( state_1ab9);
	_conditionalGroup_1a9f->push_back( conditionalGroup_1abb);
}

void ChildStateType_1abd::operator()( const Packets_t& states_1abe, const Packets_t& css_1ac0, Packets_t& states_1ac2, Packets_t& css_1ac3, Packets_t& states_1ac4, Packets_t& css_1ac5)
{
#ifdef PRINT_INFO
	printLog( "ChildStateType_1abd" );
#endif
	_state_1ac6= &states_1ac2;
	_cs_1ac7= &css_1ac3;
	_state_1ac8= &states_1ac4;
	_cs_1ac9= &css_1ac5;
	for( Packets_t::const_iterator itstate_1acb= states_1abe.begin(), itcs_1ad2= css_1ac0.begin(); itstate_1acb!= states_1abe.end(), itcs_1ad2!= css_1ac0.end(); ++itstate_1acb, ++itcs_1ad2)
	{
		bool isUnique= isInputUnique( *itstate_1acb, *itcs_1ad2);
		if( !isUnique)
			continue;
		Packets_t onestate_1acf( 1, *itstate_1acb);
		Packets_t onecs_1ad6( 1, *itcs_1ad2);
		executeOne( onestate_1acf, onecs_1ad6);
	}
}

void ChildStateType_1abd::executeOne( const Packets_t& states_1abe, const Packets_t& css_1ac0)
{
	Packets_t states_1adb;
	Packets_t compoundStatements_1ade;
	ChildAndStates_1ad8 childAndStates_1ad8;
	bool isMatchChildAndStates_1ad8= childAndStates_1ad8( states_1abe, css_1ac0, states_1adb, compoundStatements_1ade);
	_state_1ac6->insert( _state_1ac6->end(), states_1adb.begin(), states_1adb.end());
	_cs_1ac7->insert( _cs_1ac7->end(), compoundStatements_1ade.begin(), compoundStatements_1ade.end());
	if( isMatchChildAndStates_1ad8)
		return;
	Packets_t states_1b07;
	Packets_t compoundStatements_1b0a;
	ChildOrStates_1b04 childOrStates_1b04;
	bool isMatchChildOrStates_1b04= childOrStates_1b04( states_1abe, css_1ac0, states_1b07, compoundStatements_1b0a);
	_state_1ac8->insert( _state_1ac8->end(), states_1b07.begin(), states_1b07.end());
	_cs_1ac9->insert( _cs_1ac9->end(), compoundStatements_1b0a.begin(), compoundStatements_1b0a.end());
	if( isMatchChildOrStates_1b04)
		return;
}

bool ChildStateType_1abd::isInputUnique( const Udm::Object& state_1acc, const Udm::Object& cs_1ad3)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_1ace= _state_1aca.begin(), itcs_1ad5= _cs_1ad1.begin(); itstate_1ace!= _state_1aca.end(), itcs_1ad5!= _cs_1ad1.end(); ++itstate_1ace, ++itcs_1ad5)
	{
		if( ( *itstate_1ace== state_1acc)&& ( *itcs_1ad5== cs_1ad3))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1aca.push_back( state_1acc);
		_cs_1ad1.push_back( cs_1ad3);
	}
	return isUnique;
}

bool ChildAndStates_1ad8::operator()( const Packets_t& states_1ad9, const Packets_t& compoundStatements_1adc, Packets_t& states_1adb, Packets_t& compoundStatements_1ade)
{
#ifdef PRINT_INFO
	printLog( "ChildAndStates_1ad8" );
#endif
	_state_1adf= &states_1adb;
	_compoundStatement_1ae0= &compoundStatements_1ade;
	processInputPackets( states_1ad9, compoundStatements_1adc);
	if( false== _matches.empty())
		return true;
	return false;
}

bool ChildAndStates_1ad8::isInputUnique( const Udm::Object& state_1ae5, const Udm::Object& compoundStatement_1aee)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1ae7= _state_1ae1.begin(), itCompoundStatement_1af0= _compoundStatement_1aea.begin(); itState_1ae7!= _state_1ae1.end(), itCompoundStatement_1af0!= _compoundStatement_1aea.end(); ++itState_1ae7, ++itCompoundStatement_1af0)
	{
		if( ( *itState_1ae7== state_1ae5)&& ( *itCompoundStatement_1af0== compoundStatement_1aee))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1ae1.push_back( state_1ae5);
		_compoundStatement_1aea.push_back( compoundStatement_1aee);
	}
	return isUnique;
}

bool ChildAndStates_1ad8::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool ChildAndStates_1ad8::isGuardTrue( CyPhyML::SignalFlow::State& ChildState, SFC::CompoundStatement& CompoundStatement, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( ChildState.Decomposition() ) == "AND_STATE";;
	return Gz_guard;
}

void ChildAndStates_1ad8::processInputPackets( const Packets_t& states_1ad9, const Packets_t& compoundStatements_1adc)
{
	for( Packets_t::const_iterator itState_1ae2= states_1ad9.begin(), itCompoundStatement_1aeb= compoundStatements_1adc.begin(); itState_1ae2!= states_1ad9.end(), itCompoundStatement_1aeb!= compoundStatements_1adc.end(); ++itState_1ae2, ++itCompoundStatement_1aeb)
	{
		bool isUnique= isInputUnique( *itState_1ae2, *itCompoundStatement_1aeb);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1ae2, *itCompoundStatement_1aeb);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1afa, currMatch.compoundStatement_1afb);
	}
}

bool ChildAndStates_1ad8::patternMatcher( const Udm::Object& state_1ae3, const Udm::Object& compoundStatement_1aec)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1ae3.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1ae8= CyPhyML::SignalFlow::State::Cast( state_1ae3);
		if( false== Uml::IsDerivedFrom( compoundStatement_1aec.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1af1= SFC::CompoundStatement::Cast( compoundStatement_1aec);
		set< CyPhyML::SignalFlow::State> childStates_1af3= state_1ae8.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itChildState_1af4= childStates_1af3.begin(); itChildState_1af4!= childStates_1af3.end(); ++itChildState_1af4)
		{
			CyPhyML::SignalFlow::State currChildState_1af5= *itChildState_1af4;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1af9;
			if( !isValidBound(boundObjs_1af9, state_1ae8, true))
				continue;
			currMatch.state_1afa= state_1ae8;
			if( !isValidBound(boundObjs_1af9, compoundStatement_1af1, true))
				continue;
			currMatch.compoundStatement_1afb= compoundStatement_1af1;
			if( !isValidBound(boundObjs_1af9, currChildState_1af5, false))
				continue;
			currMatch.childState_1afc= currChildState_1af5;
			bool Gz_guard= isGuardTrue( currMatch.childState_1afc, currMatch.compoundStatement_1afb, currMatch.state_1afa);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void ChildAndStates_1ad8::outputAppender( const CyPhyML::SignalFlow::State& state_1b00, const SFC::CompoundStatement& compoundStatement_1b02)
{
	_state_1adf->push_back( state_1b00);
	_compoundStatement_1ae0->push_back( compoundStatement_1b02);
}

bool ChildOrStates_1b04::operator()( const Packets_t& states_1b05, const Packets_t& compoundStatements_1b08, Packets_t& states_1b07, Packets_t& compoundStatements_1b0a)
{
#ifdef PRINT_INFO
	printLog( "ChildOrStates_1b04" );
#endif
	_state_1b0b= &states_1b07;
	_compoundStatement_1b0c= &compoundStatements_1b0a;
	processInputPackets( states_1b05, compoundStatements_1b08);
	if( false== _matches.empty())
		return true;
	return false;
}

bool ChildOrStates_1b04::isInputUnique( const Udm::Object& state_1b11, const Udm::Object& compoundStatement_1b1a)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1b13= _state_1b0d.begin(), itCompoundStatement_1b1c= _compoundStatement_1b16.begin(); itState_1b13!= _state_1b0d.end(), itCompoundStatement_1b1c!= _compoundStatement_1b16.end(); ++itState_1b13, ++itCompoundStatement_1b1c)
	{
		if( ( *itState_1b13== state_1b11)&& ( *itCompoundStatement_1b1c== compoundStatement_1b1a))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1b0d.push_back( state_1b11);
		_compoundStatement_1b16.push_back( compoundStatement_1b1a);
	}
	return isUnique;
}

bool ChildOrStates_1b04::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void ChildOrStates_1b04::processInputPackets( const Packets_t& states_1b05, const Packets_t& compoundStatements_1b08)
{
	for( Packets_t::const_iterator itState_1b0e= states_1b05.begin(), itCompoundStatement_1b17= compoundStatements_1b08.begin(); itState_1b0e!= states_1b05.end(), itCompoundStatement_1b17!= compoundStatements_1b08.end(); ++itState_1b0e, ++itCompoundStatement_1b17)
	{
		bool isUnique= isInputUnique( *itState_1b0e, *itCompoundStatement_1b17);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1b0e, *itCompoundStatement_1b17);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1b23, currMatch.compoundStatement_1b24);
	}
}

bool ChildOrStates_1b04::patternMatcher( const Udm::Object& state_1b0f, const Udm::Object& compoundStatement_1b18)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1b0f.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1b14= CyPhyML::SignalFlow::State::Cast( state_1b0f);
		if( false== Uml::IsDerivedFrom( compoundStatement_1b18.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1b1d= SFC::CompoundStatement::Cast( compoundStatement_1b18);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1b22;
		if( !isValidBound(boundObjs_1b22, state_1b14, true))
			continue;
		currMatch.state_1b23= state_1b14;
		if( !isValidBound(boundObjs_1b22, compoundStatement_1b1d, true))
			continue;
		currMatch.compoundStatement_1b24= compoundStatement_1b1d;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void ChildOrStates_1b04::outputAppender( const CyPhyML::SignalFlow::State& state_1b25, const SFC::CompoundStatement& compoundStatement_1b27)
{
	_state_1b0b->push_back( state_1b25);
	_compoundStatement_1b0c->push_back( compoundStatement_1b27);
}

void ROrderChildStates_1b2f::operator()( const Packets_t& states_1b30, const Packets_t& compoundStatements_1b34, Packets_t& states_1b32, Packets_t& states_1b33, Packets_t& compoundStatements_1b36)
{
#ifdef PRINT_INFO
	printLog( "ROrderChildStates_1b2f" );
#endif
	RTTGenerator::Instance()->generateRule(977, "ROrderChildStates");
	_state_1b37= &states_1b32;
	_state_1b38= &states_1b33;
	_compoundStatement_1b39= &compoundStatements_1b36;
	processInputPackets( states_1b30, compoundStatements_1b34);
	sortOutputs( );
}

bool ROrderChildStates_1b2f::isInputUnique( const Udm::Object& state_1b3e, const Udm::Object& compoundStatement_1b47)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1b40= _state_1b3a.begin(), itCompoundStatement_1b49= _compoundStatement_1b43.begin(); itState_1b40!= _state_1b3a.end(), itCompoundStatement_1b49!= _compoundStatement_1b43.end(); ++itState_1b40, ++itCompoundStatement_1b49)
	{
		if( ( *itState_1b40== state_1b3e)&& ( *itCompoundStatement_1b49== compoundStatement_1b47))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1b3a.push_back( state_1b3e);
		_compoundStatement_1b43.push_back( compoundStatement_1b47);
	}
	return isUnique;
}

bool ROrderChildStates_1b2f::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void ROrderChildStates_1b2f::processInputPackets( const Packets_t& states_1b30, const Packets_t& compoundStatements_1b34)
{
	for( Packets_t::const_iterator itState_1b3b= states_1b30.begin(), itCompoundStatement_1b44= compoundStatements_1b34.begin(); itState_1b3b!= states_1b30.end(), itCompoundStatement_1b44!= compoundStatements_1b34.end(); ++itState_1b3b, ++itCompoundStatement_1b44)
	{
		bool isUnique= isInputUnique( *itState_1b3b, *itCompoundStatement_1b44);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1b3b, *itCompoundStatement_1b44);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ROrderChildStates_1b2f::patternMatcher( const Udm::Object& state_1b3c, const Udm::Object& compoundStatement_1b45)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1b3c.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1b41= CyPhyML::SignalFlow::State::Cast( state_1b3c);
		if( false== Uml::IsDerivedFrom( compoundStatement_1b45.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1b4a= SFC::CompoundStatement::Cast( compoundStatement_1b45);
		set< CyPhyML::SignalFlow::State> states_1b4c= state_1b41.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itState_1b4d= states_1b4c.begin(); itState_1b4d!= states_1b4c.end(); ++itState_1b4d)
		{
			CyPhyML::SignalFlow::State currState_1b4e= *itState_1b4d;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1b52;
			if( !isValidBound(boundObjs_1b52, state_1b41, true))
				continue;
			currMatch.state_1b53= state_1b41;
			if( !isValidBound(boundObjs_1b52, compoundStatement_1b4a, true))
				continue;
			currMatch.compoundStatement_1b54= compoundStatement_1b4a;
			if( !isValidBound(boundObjs_1b52, currState_1b4e, false))
				continue;
			currMatch.state_1b55= currState_1b4e;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void ROrderChildStates_1b2f::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1b53, currMatch.state_1b55, currMatch.compoundStatement_1b54);
	}
}

void ROrderChildStates_1b2f::outputAppender( const CyPhyML::SignalFlow::State& state_1b56, const CyPhyML::SignalFlow::State& state_1b58, const SFC::CompoundStatement& compoundStatement_1b5a)
{
	_state_1b37->push_back( state_1b56);
	_state_1b38->push_back( state_1b58);
	_compoundStatement_1b39->push_back( compoundStatement_1b5a);
}

void ROrderChildStates_1b2f::sortOutputs()
{
	typedef std::multiset< CyPhyML::SignalFlow::State, std::pointer_to_binary_function< const CyPhyML::SignalFlow::State&, const CyPhyML::SignalFlow::State&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const CyPhyML::SignalFlow::State&, const CyPhyML::SignalFlow::State&, bool> ptr_StateRevOrder( StateRevOrder< CyPhyML::SignalFlow::State>);
	SortedSet_t sortedSet( ptr_StateRevOrder);
	std::vector< int> permutationVector( _state_1b38->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _state_1b38->begin(); it!= _state_1b38->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( CyPhyML::SignalFlow::State::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _state_1b38->begin());
	// order rest of the containers
	permutate( permutationVector, *_state_1b37);
	permutate( permutationVector, *_compoundStatement_1b39);
}

void ExitChildStates_1b5c::operator()( const Packets_t& states_1b5d, const Packets_t& childStates_1b5f, const Packets_t& compoundStatements_1b61)
{
#ifdef PRINT_INFO
	printLog( "ExitChildStates_1b5c" );
#endif
	RTTGenerator::Instance()->generateRule(982, "ExitChildStates");
	processInputPackets( states_1b5d, childStates_1b5f, compoundStatements_1b61);
}

bool ExitChildStates_1b5c::isInputUnique( const Udm::Object& state_1b67, const Udm::Object& childState_1b70, const Udm::Object& compoundStatement_1b79)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1b69= _state_1b63.begin(), itChildState_1b72= _childState_1b6c.begin(), itCompoundStatement_1b7b= _compoundStatement_1b75.begin(); itState_1b69!= _state_1b63.end(), itChildState_1b72!= _childState_1b6c.end(), itCompoundStatement_1b7b!= _compoundStatement_1b75.end(); ++itState_1b69, ++itChildState_1b72, ++itCompoundStatement_1b7b)
	{
		if( ( *itState_1b69== state_1b67)&& ( *itChildState_1b72== childState_1b70)&& ( *itCompoundStatement_1b7b== compoundStatement_1b79))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1b63.push_back( state_1b67);
		_childState_1b6c.push_back( childState_1b70);
		_compoundStatement_1b75.push_back( compoundStatement_1b79);
	}
	return isUnique;
}

bool ExitChildStates_1b5c::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void ExitChildStates_1b5c::processInputPackets( const Packets_t& states_1b5d, const Packets_t& childStates_1b5f, const Packets_t& compoundStatements_1b61)
{
	for( Packets_t::const_iterator itState_1b64= states_1b5d.begin(), itChildState_1b6d= childStates_1b5f.begin(), itCompoundStatement_1b76= compoundStatements_1b61.begin(); itState_1b64!= states_1b5d.end(), itChildState_1b6d!= childStates_1b5f.end(), itCompoundStatement_1b76!= compoundStatements_1b61.end(); ++itState_1b64, ++itChildState_1b6d, ++itCompoundStatement_1b76)
	{
		bool isUnique= isInputUnique( *itState_1b64, *itChildState_1b6d, *itCompoundStatement_1b76);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1b64, *itChildState_1b6d, *itCompoundStatement_1b76);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ExitChildStates_1b5c::patternMatcher( const Udm::Object& state_1b65, const Udm::Object& childState_1b6e, const Udm::Object& compoundStatement_1b77)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1b65.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1b6a= CyPhyML::SignalFlow::State::Cast( state_1b65);
		if( false== Uml::IsDerivedFrom( childState_1b6e.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State childState_1b73= CyPhyML::SignalFlow::State::Cast( childState_1b6e);
		if( false== Uml::IsDerivedFrom( compoundStatement_1b77.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1b7c= SFC::CompoundStatement::Cast( compoundStatement_1b77);
		set< SFC::StateLabel> stateLabels_1b7e= state_1b6a.src();
		for( set< SFC::StateLabel>::const_iterator itStateLabels_1b7f= stateLabels_1b7e.begin(); itStateLabels_1b7f!= stateLabels_1b7e.end(); ++itStateLabels_1b7f)
		{
			SFC::StateLabel currStateLabel_1b80= *itStateLabels_1b7f;
			set< SFC::Function> exits_1b81= childState_1b73.exit();
			for( set< SFC::Function>::const_iterator itExits_1b82= exits_1b81.begin(); itExits_1b82!= exits_1b81.end(); ++itExits_1b82)
			{
				SFC::Function currExit_1b83= *itExits_1b82;
				Udm::Object exitParent_1b84= currExit_1b83.container();
				if( false== Uml::IsDerivedFrom( exitParent_1b84.type(), SFC::Program::meta))
					continue;
				SFC::Program programExit_1b85= SFC::Program::Cast( exitParent_1b84);
				set< SFC::StateVar> stateVars_1b86= programExit_1b85.StateVar_kind_children();
				for( set< SFC::StateVar>::const_iterator itStateVar_1b87= stateVars_1b86.begin(); itStateVar_1b87!= stateVars_1b86.end(); ++itStateVar_1b87)
				{
					SFC::StateVar currStateVar_1b88= *itStateVar_1b87;
					set< SFC::Arg> args_1b89= currExit_1b83.Arg_kind_children();
					for( set< SFC::Arg>::const_iterator itArg_1b8a= args_1b89.begin(); itArg_1b8a!= args_1b89.end(); ++itArg_1b8a)
					{
						SFC::Arg currArg_1b8b= *itArg_1b8a;
						set< SFC::StateLabel> childStateLabels_1b8c= childState_1b73.src();
						for( set< SFC::StateLabel>::const_iterator itChildStateLabels_1b8d= childStateLabels_1b8c.begin(); itChildStateLabels_1b8d!= childStateLabels_1b8c.end(); ++itChildStateLabels_1b8d)
						{
							SFC::StateLabel currChildStateLabel_1b8e= *itChildStateLabels_1b8d;
							Match currMatch;
							set< pair<int, Udm::Object> > boundObjs_1b92;
							if( !isValidBound(boundObjs_1b92, state_1b6a, true))
								continue;
							currMatch.state_1b93= state_1b6a;
							if( !isValidBound(boundObjs_1b92, childState_1b73, true))
								continue;
							currMatch.childState_1b94= childState_1b73;
							if( !isValidBound(boundObjs_1b92, compoundStatement_1b7c, true))
								continue;
							currMatch.compoundStatement_1b95= compoundStatement_1b7c;
							if( !isValidBound(boundObjs_1b92, currChildStateLabel_1b8e, false))
								continue;
							currMatch.childStateLabel_1b96= currChildStateLabel_1b8e;
							if( !isValidBound(boundObjs_1b92, currStateLabel_1b80, false))
								continue;
							currMatch.stateLabel_1b97= currStateLabel_1b80;
							if( !isValidBound(boundObjs_1b92, currStateVar_1b88, false))
								continue;
							currMatch.stateVar_1b98= currStateVar_1b88;
							if( !isValidBound(boundObjs_1b92, currArg_1b8b, false))
								continue;
							currMatch.arg_1b99= currArg_1b8b;
							if( !isValidBound(boundObjs_1b92, currExit_1b83, false))
								continue;
							currMatch.exit_1b9a= currExit_1b83;
							if( !isValidBound(boundObjs_1b92, programExit_1b85, false))
								continue;
							currMatch.program_1b9b= programExit_1b85;
							_matches.push_back( currMatch);
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void ExitChildStates_1b5c::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_1b9c= SFC::ConditionalBlock::Create( currMatch.compoundStatement_1b95, SFC::CompoundStatement::meta_stmnt);
		SFC::CheckState newCheckState_1b9d= SFC::CheckState::Create( newConditionalBlock_1b9c, SFC::ConditionalBlock::meta_cond);
		SFC::FunctionCall newFunctionCall_1b9e= SFC::FunctionCall::Create( newConditionalBlock_1b9c, SFC::ConditionalBlock::meta_stmnt);
		SFC::ArgVal newArgVal_1b9f= SFC::ArgVal::Create( newFunctionCall_1b9e);
		SFC::Int newInt_1ba0= SFC::Int::Create( newArgVal_1b9f, SFC::ArgVal::meta_argexpr);
		SFC::Arg& Arg= currMatch.arg_1b99;
		SFC::ArgVal& ArgVal= newArgVal_1b9f;
		SFC::CheckState& CheckState= newCheckState_1b9d;
		CyPhyML::SignalFlow::State& ChildState= currMatch.childState_1b94;
		SFC::StateLabel& ChildStateLabel= currMatch.childStateLabel_1b96;
		SFC::CompoundStatement& CompoundStatement= currMatch.compoundStatement_1b95;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_1b9c;
		SFC::Function& Exit= currMatch.exit_1b9a;
		SFC::FunctionCall& FunctionCall= newFunctionCall_1b9e;
		SFC::Int& Int= newInt_1ba0;
		SFC::Program& Program= currMatch.program_1b9b;
		CyPhyML::SignalFlow::State& State= currMatch.state_1b93;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_1b97;
		SFC::StateVar& StateVar= currMatch.stateVar_1b98;
		{
ConditionalBlock.RefId() = FunctionCall.RefId() = CompoundStatement.RefId();
};
		{
Int.val() = -1;
};
		{
__int64 statementCount = CompoundStatement.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
CompoundStatement.statementCount() = statementCount;
};
		{
__int64 statementCount = ConditionalBlock.statementCount();
FunctionCall.statementIndex() = statementCount++;
ConditionalBlock.statementCount() = statementCount;
};
		newFunctionCall_1b9e.callee()= currMatch.exit_1b9a;
		newCheckState_1b9d.svar()= currMatch.stateVar_1b98;
		newArgVal_1b9f.arg()+= currMatch.arg_1b99;
		newCheckState_1b9d.value()= currMatch.childStateLabel_1b96;
		newCheckState_1b9d.index()= currMatch.stateLabel_1b97;
	}
}

void ArgNegOneOrState_1bab::operator()( const Packets_t& states_1bac, const Packets_t& functions_1bb0, Packets_t& states_1bae, Packets_t& args_1baf, Packets_t& conditionalBlocks_1bb2)
{
#ifdef PRINT_INFO
	printLog( "ArgNegOneOrState_1bab" );
#endif
	RTTGenerator::Instance()->generateRule(1017, "ArgNegOneOrState");
	_state_1bb3= &states_1bae;
	_arg_1bb4= &args_1baf;
	_conditionalBlock_1bb5= &conditionalBlocks_1bb2;
	processInputPackets( states_1bac, functions_1bb0);
}

bool ArgNegOneOrState_1bab::isInputUnique( const Udm::Object& state_1bba, const Udm::Object& function_1bc3)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1bbc= _state_1bb6.begin(), itFunction_1bc5= _function_1bbf.begin(); itState_1bbc!= _state_1bb6.end(), itFunction_1bc5!= _function_1bbf.end(); ++itState_1bbc, ++itFunction_1bc5)
	{
		if( ( *itState_1bbc== state_1bba)&& ( *itFunction_1bc5== function_1bc3))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1bb6.push_back( state_1bba);
		_function_1bbf.push_back( function_1bc3);
	}
	return isUnique;
}

bool ArgNegOneOrState_1bab::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void ArgNegOneOrState_1bab::processInputPackets( const Packets_t& states_1bac, const Packets_t& functions_1bb0)
{
	for( Packets_t::const_iterator itState_1bb7= states_1bac.begin(), itFunction_1bc0= functions_1bb0.begin(); itState_1bb7!= states_1bac.end(), itFunction_1bc0!= functions_1bb0.end(); ++itState_1bb7, ++itFunction_1bc0)
	{
		bool isUnique= isInputUnique( *itState_1bb7, *itFunction_1bc0);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1bb7, *itFunction_1bc0);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ArgNegOneOrState_1bab::patternMatcher( const Udm::Object& state_1bb8, const Udm::Object& function_1bc1)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1bb8.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1bbd= CyPhyML::SignalFlow::State::Cast( state_1bb8);
		if( false== Uml::IsDerivedFrom( function_1bc1.type(), SFC::Function::meta))
			continue;
		SFC::Function function_1bc6= SFC::Function::Cast( function_1bc1);
		set< SFC::Arg> args_1bc8= function_1bc6.Arg_kind_children();
		for( set< SFC::Arg>::const_iterator itArg_1bc9= args_1bc8.begin(); itArg_1bc9!= args_1bc8.end(); ++itArg_1bc9)
		{
			SFC::Arg currArg_1bca= *itArg_1bc9;
			set< SFC::StateLabel> stateLabels_1bcb= state_1bbd.src();
			for( set< SFC::StateLabel>::const_iterator itStateLabels_1bcc= stateLabels_1bcb.begin(); itStateLabels_1bcc!= stateLabels_1bcb.end(); ++itStateLabels_1bcc)
			{
				SFC::StateLabel currStateLabel_1bcd= *itStateLabels_1bcc;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_1bd1;
				if( !isValidBound(boundObjs_1bd1, state_1bbd, true))
					continue;
				currMatch.state_1bd2= state_1bbd;
				if( !isValidBound(boundObjs_1bd1, function_1bc6, true))
					continue;
				currMatch.function_1bd3= function_1bc6;
				if( !isValidBound(boundObjs_1bd1, currStateLabel_1bcd, false))
					continue;
				currMatch.stateLabel_1bd4= currStateLabel_1bcd;
				if( !isValidBound(boundObjs_1bd1, currArg_1bca, false))
					continue;
				currMatch.arg_1bd5= currArg_1bca;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void ArgNegOneOrState_1bab::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_1bd6= SFC::ConditionalBlock::Create( currMatch.function_1bd3, SFC::Function::meta_stmnt);
		SFC::UserCode newUserCode_1bd7= SFC::UserCode::Create( newConditionalBlock_1bd6, SFC::ConditionalBlock::meta_cond);
		SFC::BinaryExprs newLogOR_1bd8= SFC::BinaryExprs::Create( newUserCode_1bd7, SFC::UserCode::meta_codeexpr);
		SFC::BinaryExprs newEqual2_1bd9= SFC::BinaryExprs::Create( newLogOR_1bd8, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef_1bda= SFC::ArgDeclRef::Create( newEqual2_1bd9, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef2_1bdb= SFC::ArgDeclRef::Create( newEqual2_1bd9, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs newEqual1_1bdc= SFC::BinaryExprs::Create( newLogOR_1bd8, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRe1f_1bdd= SFC::ArgDeclRef::Create( newEqual1_1bdc, SFC::BinaryExprs::meta_leftexpr);
		SFC::Int newInt_1bde= SFC::Int::Create( newEqual1_1bdc, SFC::BinaryExprs::meta_rightexpr);
		SFC::Arg& Arg= currMatch.arg_1bd5;
		SFC::ArgDeclRef& ArgDeclRe1f= newArgDeclRe1f_1bdd;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_1bda;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_1bdb;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_1bd6;
		SFC::BinaryExprs& Equal1= newEqual1_1bdc;
		SFC::BinaryExprs& Equal2= newEqual2_1bd9;
		SFC::Function& Function= currMatch.function_1bd3;
		SFC::Int& Int= newInt_1bde;
		SFC::BinaryExprs& LogOR= newLogOR_1bd8;
		CyPhyML::SignalFlow::State& State= currMatch.state_1bd2;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_1bd4;
		SFC::UserCode& UserCode= newUserCode_1bd7;
		{
ConditionalBlock.RefId() = UserCode.RefId() = Function.RefId();
};
		{
Equal2.op() = "==";
};
		{
LogOR.op() = "||";
};
		{
Equal1.op() = "==";
Int.val() = -1;
};
		{
__int64 statementCount = Function.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
Function.statementCount() = statementCount;
};
		newArgDeclRef2_1bdb.argdecl()= currMatch.stateLabel_1bd4;
		newArgDeclRef_1bda.argdecl()= currMatch.arg_1bd5;
		newArgDeclRe1f_1bdd.argdecl()= currMatch.arg_1bd5;
		outputAppender( currMatch.state_1bd2, currMatch.arg_1bd5, newConditionalBlock_1bd6);
	}
}

void ArgNegOneOrState_1bab::outputAppender( const CyPhyML::SignalFlow::State& state_1bdf, const SFC::Arg& arg_1be1, const SFC::ConditionalBlock& conditionalBlock_1be3)
{
	_state_1bb3->push_back( state_1bdf);
	_arg_1bb4->push_back( arg_1be1);
	_conditionalBlock_1bb5->push_back( conditionalBlock_1be3);
}

void GetExitFunction_1bf0::operator()( const Packets_t& states_1bf1, Packets_t& states_1bf3, Packets_t& exits_1bf4)
{
#ifdef PRINT_INFO
	printLog( "GetExitFunction_1bf0" );
#endif
	RTTGenerator::Instance()->generateRule(1050, "GetExitFunction");
	_state_1bf5= &states_1bf3;
	_exit_1bf6= &exits_1bf4;
	processInputPackets( states_1bf1);
}

bool GetExitFunction_1bf0::isInputUnique( const Udm::Object& state_1bfb)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1bfd= _state_1bf7.begin(); itState_1bfd!= _state_1bf7.end(); ++itState_1bfd)
	{
		if( ( *itState_1bfd== state_1bfb))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1bf7.push_back( state_1bfb);
	return isUnique;
}

bool GetExitFunction_1bf0::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetExitFunction_1bf0::processInputPackets( const Packets_t& states_1bf1)
{
	for( Packets_t::const_iterator itState_1bf8= states_1bf1.begin(); itState_1bf8!= states_1bf1.end(); ++itState_1bf8)
	{
		bool isUnique= isInputUnique( *itState_1bf8);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1bf8);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetExitFunction_1bf0::patternMatcher( const Udm::Object& state_1bf9)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1bf9.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1bfe= CyPhyML::SignalFlow::State::Cast( state_1bf9);
		set< SFC::Function> exits_1c00= state_1bfe.exit();
		for( set< SFC::Function>::const_iterator itExits_1c01= exits_1c00.begin(); itExits_1c01!= exits_1c00.end(); ++itExits_1c01)
		{
			SFC::Function currExit_1c02= *itExits_1c01;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1c06;
			if( !isValidBound(boundObjs_1c06, state_1bfe, true))
				continue;
			currMatch.state_1c07= state_1bfe;
			if( !isValidBound(boundObjs_1c06, currExit_1c02, false))
				continue;
			currMatch.exit_1c08= currExit_1c02;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetExitFunction_1bf0::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1c07, currMatch.exit_1c08);
	}
}

void GetExitFunction_1bf0::outputAppender( const CyPhyML::SignalFlow::State& state_1c09, const SFC::Function& exit_1c0b)
{
	_state_1bf5->push_back( state_1c09);
	_exit_1bf6->push_back( exit_1c0b);
}

void PopulateEnterFunction_1c15::operator()( const Packets_t& states_1c16, const Packets_t& programs_1c18, Packets_t& states_1c1a, Packets_t& programs_1c1b)
{
#ifdef PRINT_INFO
	printLog( "PopulateEnterFunction_1c15" );
#endif
	_state_1c1c= &states_1c1a;
	_program_1c1d= &programs_1c1b;
	if( ( !states_1c16.empty()))
		callTestEAIOff_1f35( states_1c16);
	_state_1c1c->insert( _state_1c1c->end(), states_1c16.begin(), states_1c16.end());
	_program_1c1d->insert( _program_1c1d->end(), programs_1c18.begin(), programs_1c18.end());
}

void PopulateEnterFunction_1c15::callTestEAIOff_1f35( const Packets_t& states_1eeb)
{
	Packets_t states_1eed;
	Packets_t states_1eee;
	TestEAIOff_1eea testEAIOff_1eea;
	testEAIOff_1eea( states_1eeb, states_1eed, states_1eee);
	if( ( !states_1eee.empty()))
		callReturnAtTopState_1f37( states_1eee);
}

void PopulateEnterFunction_1c15::callReturnAtTopState_1f37( const Packets_t& states_1ebd)
{
	Packets_t states_1ebf;
	ReturnAtTopState_1ebc returnAtTopState_1ebc;
	returnAtTopState_1ebc( states_1ebd, states_1ebf);
	if( ( !states_1ebf.empty()))
		callMode0or1_1f39( states_1ebf);
}

void PopulateEnterFunction_1c15::callMode0or1_1f39( const Packets_t& states_1e34)
{
	Packets_t states_1e36;
	Mode0or1_1e33 mode0or1_1e33;
	mode0or1_1e33( states_1e34, states_1e36);
	if( ( !states_1e36.empty()))
		callMode0or1or2_1f3b( states_1e36);
}

void PopulateEnterFunction_1c15::callMode0or1or2_1f3b( const Packets_t& states_1df3)
{
	Packets_t states_1df5;
	Mode0or1or2_1df2 mode0or1or2_1df2;
	mode0or1or2_1df2( states_1df3, states_1df5);
	if( ( !states_1df5.empty()))
		callMode0or2_1f3d( states_1df5);
}

void PopulateEnterFunction_1c15::callMode0or2_1f3d( const Packets_t& states_1d5d)
{
	Packets_t states_1d5f;
	Mode0or2_1d5c mode0or2_1d5c;
	mode0or2_1d5c( states_1d5d, states_1d5f);
	if( ( !states_1d5f.empty()))
		callMode0or3_1f3f( states_1d5f);
}

void PopulateEnterFunction_1c15::callMode0or3_1f3f( const Packets_t& states_1c1f)
{
	Packets_t states_1c21;
	Mode0or3_1c1e mode0or3_1c1e;
	mode0or3_1c1e( states_1c1f, states_1c21);
}

void Mode0or3_1c1e::operator()( const Packets_t& states_1c1f, Packets_t& states_1c21)
{
#ifdef PRINT_INFO
	printLog( "Mode0or3_1c1e" );
#endif
	_state_1c22= &states_1c21;
	_state_1c22->insert( _state_1c22->end(), states_1c1f.begin(), states_1c1f.end());
	if( ( !states_1c1f.empty()))
		callTestMode03_1d54( states_1c1f);
}

void Mode0or3_1c1e::callTestMode03_1d54( const Packets_t& states_1d2b)
{
	Packets_t states_1d2d;
	Packets_t conditionalBlocks_1d2e;
	TestMode03_1d2a testMode03_1d2a;
	testMode03_1d2a( states_1d2b, states_1d2d, conditionalBlocks_1d2e);
	if( ( !states_1d2d.empty())&& ( !conditionalBlocks_1d2e.empty()))
		callCallLOSibs_1d56( states_1d2d, conditionalBlocks_1d2e);
}

void Mode0or3_1c1e::callCallLOSibs_1d56( const Packets_t& states_1c24, const Packets_t& css_1c26)
{
	Packets_t states_1c28;
	Packets_t css_1c29;
	CallLOSibs_1c23 callLOSibs_1c23;
	callLOSibs_1c23( states_1c24, css_1c26, states_1c28, css_1c29);
	if( ( !states_1c28.empty())&& ( !css_1c29.empty()))
		callCallParent_1d59( states_1c28, css_1c29);
}

void Mode0or3_1c1e::callCallParent_1d59( const Packets_t& states_1ced, const Packets_t& conditionalBlocks_1cef)
{
	CallParent_1cec callParent_1cec;
	callParent_1cec( states_1ced, conditionalBlocks_1cef);
}

void CallLOSibs_1c23::operator()( const Packets_t& states_1c24, const Packets_t& css_1c26, Packets_t& states_1c28, Packets_t& css_1c29)
{
#ifdef PRINT_INFO
	printLog( "CallLOSibs_1c23" );
#endif
	_state_1c2a= &states_1c28;
	_cs_1c2b= &css_1c29;
	if( ( !states_1c24.empty())&& ( !css_1c26.empty()))
		callIsAndState_1ce2( states_1c24, css_1c26);
	_state_1c2a->insert( _state_1c2a->end(), states_1c24.begin(), states_1c24.end());
	_cs_1c2b->insert( _cs_1c2b->end(), css_1c26.begin(), css_1c26.end());
}

void CallLOSibs_1c23::callIsAndState_1ce2( const Packets_t& states_1c5e, const Packets_t& css_1c60)
{
	Packets_t states_1c62;
	Packets_t css_1c63;
	IsAndState_1c5d isAndState_1c5d;
	isAndState_1c5d( states_1c5e, css_1c60, states_1c62, css_1c63);
	if( ( !states_1c62.empty())&& ( !css_1c63.empty()))
		callGetLOSibs_1ce5( states_1c62, css_1c63);
}

void CallLOSibs_1c23::callGetLOSibs_1ce5( const Packets_t& states_1c2d, const Packets_t& compoundStatements_1c31)
{
	Packets_t states_1c2f;
	Packets_t sibStates_1c30;
	Packets_t compoundStatements_1c33;
	GetLOSibs_1c2c getLOSibs_1c2c;
	getLOSibs_1c2c( states_1c2d, compoundStatements_1c31, states_1c2f, sibStates_1c30, compoundStatements_1c33);
	if( ( !states_1c2f.empty())&& ( !sibStates_1c30.empty())&& ( !compoundStatements_1c33.empty()))
		callCallSibsOrChildren_1ce8( states_1c2f, sibStates_1c30, compoundStatements_1c33);
}

void CallLOSibs_1c23::callCallSibsOrChildren_1ce8( const Packets_t& states_1c99, const Packets_t& sOCStates_1c9b, const Packets_t& compoundStatements_1c9d)
{
	CallSibsOrChildren_1c98 callSibsOrChildren_1c98;
	callSibsOrChildren_1c98( states_1c99, sOCStates_1c9b, compoundStatements_1c9d);
}

void GetLOSibs_1c2c::operator()( const Packets_t& states_1c2d, const Packets_t& compoundStatements_1c31, Packets_t& states_1c2f, Packets_t& sibStates_1c30, Packets_t& compoundStatements_1c33)
{
#ifdef PRINT_INFO
	printLog( "GetLOSibs_1c2c" );
#endif
	RTTGenerator::Instance()->generateRule(1067, "GetLOSibs");
	_state_1c34= &states_1c2f;
	_sibState_1c35= &sibStates_1c30;
	_compoundStatement_1c36= &compoundStatements_1c33;
	processInputPackets( states_1c2d, compoundStatements_1c31);
	sortOutputs( );
}

bool GetLOSibs_1c2c::isInputUnique( const Udm::Object& state_1c3b, const Udm::Object& compoundStatement_1c44)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1c3d= _state_1c37.begin(), itCompoundStatement_1c46= _compoundStatement_1c40.begin(); itState_1c3d!= _state_1c37.end(), itCompoundStatement_1c46!= _compoundStatement_1c40.end(); ++itState_1c3d, ++itCompoundStatement_1c46)
	{
		if( ( *itState_1c3d== state_1c3b)&& ( *itCompoundStatement_1c46== compoundStatement_1c44))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1c37.push_back( state_1c3b);
		_compoundStatement_1c40.push_back( compoundStatement_1c44);
	}
	return isUnique;
}

bool GetLOSibs_1c2c::isGuardTrue( SFC::CompoundStatement& CompoundStatement, CyPhyML::SignalFlow::State& ParentState, CyPhyML::SignalFlow::State& SibState, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	std::string stateOrder = SFManager::trim(  static_cast< std::string >( State.Order() )  );
if ( stateOrder.empty() ) stateOrder = "0";

std::string sibStateOrder = SFManager::trim(  static_cast< std::string >( SibState.Order() )  );
if ( sibStateOrder.empty() ) sibStateOrder = "0";

return boost::lexical_cast< int >( stateOrder ) > boost::lexical_cast< int >( sibStateOrder );;
	return Gz_guard;
}

void GetLOSibs_1c2c::processInputPackets( const Packets_t& states_1c2d, const Packets_t& compoundStatements_1c31)
{
	for( Packets_t::const_iterator itState_1c38= states_1c2d.begin(), itCompoundStatement_1c41= compoundStatements_1c31.begin(); itState_1c38!= states_1c2d.end(), itCompoundStatement_1c41!= compoundStatements_1c31.end(); ++itState_1c38, ++itCompoundStatement_1c41)
	{
		bool isUnique= isInputUnique( *itState_1c38, *itCompoundStatement_1c41);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1c38, *itCompoundStatement_1c41);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetLOSibs_1c2c::patternMatcher( const Udm::Object& state_1c39, const Udm::Object& compoundStatement_1c42)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1c39.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1c3e= CyPhyML::SignalFlow::State::Cast( state_1c39);
		if( false== Uml::IsDerivedFrom( compoundStatement_1c42.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1c47= SFC::CompoundStatement::Cast( compoundStatement_1c42);
		Udm::Object stateParent_1c49= state_1c3e.container();
		if( false== Uml::IsDerivedFrom( stateParent_1c49.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State parentStateState_1c4a= CyPhyML::SignalFlow::State::Cast( stateParent_1c49);
		set< CyPhyML::SignalFlow::State> sibStates_1c4b= parentStateState_1c4a.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itSibState_1c4c= sibStates_1c4b.begin(); itSibState_1c4c!= sibStates_1c4b.end(); ++itSibState_1c4c)
		{
			CyPhyML::SignalFlow::State currSibState_1c4d= *itSibState_1c4c;
			Match currMatch;
			currMatch.state_1c4f= state_1c3e;
			currMatch.compoundStatement_1c50= compoundStatement_1c47;
			currMatch.parentState_1c51= parentStateState_1c4a;
			currMatch.sibState_1c52= currSibState_1c4d;
			bool Gz_guard= isGuardTrue( currMatch.compoundStatement_1c50, currMatch.parentState_1c51, currMatch.sibState_1c52, currMatch.state_1c4f);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetLOSibs_1c2c::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1c4f, currMatch.sibState_1c52, currMatch.compoundStatement_1c50);
	}
}

void GetLOSibs_1c2c::outputAppender( const CyPhyML::SignalFlow::State& state_1c57, const CyPhyML::SignalFlow::State& sibState_1c59, const SFC::CompoundStatement& compoundStatement_1c5b)
{
	_state_1c34->push_back( state_1c57);
	_sibState_1c35->push_back( sibState_1c59);
	_compoundStatement_1c36->push_back( compoundStatement_1c5b);
}

void GetLOSibs_1c2c::sortOutputs()
{
	typedef std::multiset< CyPhyML::SignalFlow::State, std::pointer_to_binary_function< const CyPhyML::SignalFlow::State&, const CyPhyML::SignalFlow::State&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const CyPhyML::SignalFlow::State&, const CyPhyML::SignalFlow::State&, bool> ptr_StateOrder( StateOrder< CyPhyML::SignalFlow::State>);
	SortedSet_t sortedSet( ptr_StateOrder);
	std::vector< int> permutationVector( _sibState_1c35->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _sibState_1c35->begin(); it!= _sibState_1c35->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( CyPhyML::SignalFlow::State::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _sibState_1c35->begin());
	// order rest of the containers
	permutate( permutationVector, *_state_1c34);
	permutate( permutationVector, *_compoundStatement_1c36);
}

void IsAndState_1c5d::operator()( const Packets_t& states_1c5e, const Packets_t& css_1c60, Packets_t& states_1c62, Packets_t& css_1c63)
{
#ifdef PRINT_INFO
	printLog( "IsAndState_1c5d" );
#endif
	_state_1c64= &states_1c62;
	_cs_1c65= &css_1c63;
	for( Packets_t::const_iterator itstate_1c67= states_1c5e.begin(), itcs_1c6e= css_1c60.begin(); itstate_1c67!= states_1c5e.end(), itcs_1c6e!= css_1c60.end(); ++itstate_1c67, ++itcs_1c6e)
	{
		bool isUnique= isInputUnique( *itstate_1c67, *itcs_1c6e);
		if( !isUnique)
			continue;
		Packets_t onestate_1c6b( 1, *itstate_1c67);
		Packets_t onecs_1c72( 1, *itcs_1c6e);
		executeOne( onestate_1c6b, onecs_1c72);
	}
}

void IsAndState_1c5d::executeOne( const Packets_t& states_1c5e, const Packets_t& css_1c60)
{
	Packets_t states_1c77;
	Packets_t compoundStatements_1c7a;
	AndState_1c74 andState_1c74;
	bool isMatchAndState_1c74= andState_1c74( states_1c5e, css_1c60, states_1c77, compoundStatements_1c7a);
	_state_1c64->insert( _state_1c64->end(), states_1c77.begin(), states_1c77.end());
	_cs_1c65->insert( _cs_1c65->end(), compoundStatements_1c7a.begin(), compoundStatements_1c7a.end());
	if( isMatchAndState_1c74)
		return;
}

bool IsAndState_1c5d::isInputUnique( const Udm::Object& state_1c68, const Udm::Object& cs_1c6f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_1c6a= _state_1c66.begin(), itcs_1c71= _cs_1c6d.begin(); itstate_1c6a!= _state_1c66.end(), itcs_1c71!= _cs_1c6d.end(); ++itstate_1c6a, ++itcs_1c71)
	{
		if( ( *itstate_1c6a== state_1c68)&& ( *itcs_1c71== cs_1c6f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1c66.push_back( state_1c68);
		_cs_1c6d.push_back( cs_1c6f);
	}
	return isUnique;
}

bool AndState_1c74::operator()( const Packets_t& states_1c75, const Packets_t& compoundStatements_1c78, Packets_t& states_1c77, Packets_t& compoundStatements_1c7a)
{
#ifdef PRINT_INFO
	printLog( "AndState_1c74" );
#endif
	_state_1c7b= &states_1c77;
	_compoundStatement_1c7c= &compoundStatements_1c7a;
	processInputPackets( states_1c75, compoundStatements_1c78);
	if( false== _matches.empty())
		return true;
	return false;
}

bool AndState_1c74::isInputUnique( const Udm::Object& state_1c81, const Udm::Object& compoundStatement_1c8a)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1c83= _state_1c7d.begin(), itCompoundStatement_1c8c= _compoundStatement_1c86.begin(); itState_1c83!= _state_1c7d.end(), itCompoundStatement_1c8c!= _compoundStatement_1c86.end(); ++itState_1c83, ++itCompoundStatement_1c8c)
	{
		if( ( *itState_1c83== state_1c81)&& ( *itCompoundStatement_1c8c== compoundStatement_1c8a))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1c7d.push_back( state_1c81);
		_compoundStatement_1c86.push_back( compoundStatement_1c8a);
	}
	return isUnique;
}

bool AndState_1c74::isGuardTrue( SFC::CompoundStatement& CompoundStatement, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( State.Decomposition() ) == "AND_STATE";;
	return Gz_guard;
}

void AndState_1c74::processInputPackets( const Packets_t& states_1c75, const Packets_t& compoundStatements_1c78)
{
	for( Packets_t::const_iterator itState_1c7e= states_1c75.begin(), itCompoundStatement_1c87= compoundStatements_1c78.begin(); itState_1c7e!= states_1c75.end(), itCompoundStatement_1c87!= compoundStatements_1c78.end(); ++itState_1c7e, ++itCompoundStatement_1c87)
	{
		bool isUnique= isInputUnique( *itState_1c7e, *itCompoundStatement_1c87);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1c7e, *itCompoundStatement_1c87);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1c90, currMatch.compoundStatement_1c91);
	}
}

bool AndState_1c74::patternMatcher( const Udm::Object& state_1c7f, const Udm::Object& compoundStatement_1c88)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1c7f.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1c84= CyPhyML::SignalFlow::State::Cast( state_1c7f);
		if( false== Uml::IsDerivedFrom( compoundStatement_1c88.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1c8d= SFC::CompoundStatement::Cast( compoundStatement_1c88);
		Match currMatch;
		currMatch.state_1c90= state_1c84;
		currMatch.compoundStatement_1c91= compoundStatement_1c8d;
		bool Gz_guard= isGuardTrue( currMatch.compoundStatement_1c91, currMatch.state_1c90);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void AndState_1c74::outputAppender( const CyPhyML::SignalFlow::State& state_1c94, const SFC::CompoundStatement& compoundStatement_1c96)
{
	_state_1c7b->push_back( state_1c94);
	_compoundStatement_1c7c->push_back( compoundStatement_1c96);
}

void CallSibsOrChildren_1c98::operator()( const Packets_t& states_1c99, const Packets_t& sOCStates_1c9b, const Packets_t& compoundStatements_1c9d)
{
#ifdef PRINT_INFO
	printLog( "CallSibsOrChildren_1c98" );
#endif
	RTTGenerator::Instance()->generateRule(1323, "CallSibsOrChildren");
	processInputPackets( states_1c99, sOCStates_1c9b, compoundStatements_1c9d);
}

bool CallSibsOrChildren_1c98::isInputUnique( const Udm::Object& state_1ca3, const Udm::Object& sOCState_1cac, const Udm::Object& compoundStatement_1cb5)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1ca5= _state_1c9f.begin(), itSOCState_1cae= _sOCState_1ca8.begin(), itCompoundStatement_1cb7= _compoundStatement_1cb1.begin(); itState_1ca5!= _state_1c9f.end(), itSOCState_1cae!= _sOCState_1ca8.end(), itCompoundStatement_1cb7!= _compoundStatement_1cb1.end(); ++itState_1ca5, ++itSOCState_1cae, ++itCompoundStatement_1cb7)
	{
		if( ( *itState_1ca5== state_1ca3)&& ( *itSOCState_1cae== sOCState_1cac)&& ( *itCompoundStatement_1cb7== compoundStatement_1cb5))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1c9f.push_back( state_1ca3);
		_sOCState_1ca8.push_back( sOCState_1cac);
		_compoundStatement_1cb1.push_back( compoundStatement_1cb5);
	}
	return isUnique;
}

bool CallSibsOrChildren_1c98::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool CallSibsOrChildren_1c98::isGuardTrue( SFC::Arg& Arg1, SFC::CompoundStatement& CompoundStatement, SFC::Function& Enter, SFC::Arg& SOCArg0, SFC::Arg& SOCArg1, SFC::Function& SOCEnter, CyPhyML::SignalFlow::State& SOCState, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	return SOCArg0.argIndex() == 0 && SOCArg1.argIndex() == 1 && Arg1.argIndex() == 1;;
	return Gz_guard;
}

void CallSibsOrChildren_1c98::processInputPackets( const Packets_t& states_1c99, const Packets_t& sOCStates_1c9b, const Packets_t& compoundStatements_1c9d)
{
	for( Packets_t::const_iterator itState_1ca0= states_1c99.begin(), itSOCState_1ca9= sOCStates_1c9b.begin(), itCompoundStatement_1cb2= compoundStatements_1c9d.begin(); itState_1ca0!= states_1c99.end(), itSOCState_1ca9!= sOCStates_1c9b.end(), itCompoundStatement_1cb2!= compoundStatements_1c9d.end(); ++itState_1ca0, ++itSOCState_1ca9, ++itCompoundStatement_1cb2)
	{
		bool isUnique= isInputUnique( *itState_1ca0, *itSOCState_1ca9, *itCompoundStatement_1cb2);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1ca0, *itSOCState_1ca9, *itCompoundStatement_1cb2);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CallSibsOrChildren_1c98::patternMatcher( const Udm::Object& state_1ca1, const Udm::Object& sOCState_1caa, const Udm::Object& compoundStatement_1cb3)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1ca1.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1ca6= CyPhyML::SignalFlow::State::Cast( state_1ca1);
		if( false== Uml::IsDerivedFrom( sOCState_1caa.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State sOCState_1caf= CyPhyML::SignalFlow::State::Cast( sOCState_1caa);
		if( false== Uml::IsDerivedFrom( compoundStatement_1cb3.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1cb8= SFC::CompoundStatement::Cast( compoundStatement_1cb3);
		set< SFC::Function> sOCEnters_1cba= sOCState_1caf.enter();
		for( set< SFC::Function>::const_iterator itSOCEnters_1cbb= sOCEnters_1cba.begin(); itSOCEnters_1cbb!= sOCEnters_1cba.end(); ++itSOCEnters_1cbb)
		{
			SFC::Function currSOCEnter_1cbc= *itSOCEnters_1cbb;
			set< SFC::Arg> sOCArg1s_1cbd= currSOCEnter_1cbc.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itSOCArg1_1cbe= sOCArg1s_1cbd.begin(); itSOCArg1_1cbe!= sOCArg1s_1cbd.end(); ++itSOCArg1_1cbe)
			{
				SFC::Arg currSOCArg1_1cbf= *itSOCArg1_1cbe;
				set< SFC::Arg> sOCArg0s_1cc0= currSOCEnter_1cbc.Arg_kind_children();
				for( set< SFC::Arg>::const_iterator itSOCArg0_1cc1= sOCArg0s_1cc0.begin(); itSOCArg0_1cc1!= sOCArg0s_1cc0.end(); ++itSOCArg0_1cc1)
				{
					SFC::Arg currSOCArg0_1cc2= *itSOCArg0_1cc1;
					set< SFC::Function> enters_1cc3= state_1ca6.enter();
					for( set< SFC::Function>::const_iterator itEnters_1cc4= enters_1cc3.begin(); itEnters_1cc4!= enters_1cc3.end(); ++itEnters_1cc4)
					{
						SFC::Function currEnter_1cc5= *itEnters_1cc4;
						set< SFC::Arg> arg1s_1cc6= currEnter_1cc5.Arg_kind_children();
						for( set< SFC::Arg>::const_iterator itArg1_1cc7= arg1s_1cc6.begin(); itArg1_1cc7!= arg1s_1cc6.end(); ++itArg1_1cc7)
						{
							SFC::Arg currArg1_1cc8= *itArg1_1cc7;
							Match currMatch;
							set< pair<int, Udm::Object> > boundObjs_1ccc;
							if( !isValidBound(boundObjs_1ccc, state_1ca6, true))
								continue;
							currMatch.state_1ccd= state_1ca6;
							if( !isValidBound(boundObjs_1ccc, sOCState_1caf, true))
								continue;
							currMatch.sOCState_1cce= sOCState_1caf;
							if( !isValidBound(boundObjs_1ccc, compoundStatement_1cb8, true))
								continue;
							currMatch.compoundStatement_1ccf= compoundStatement_1cb8;
							if( !isValidBound(boundObjs_1ccc, currEnter_1cc5, false))
								continue;
							currMatch.enter_1cd0= currEnter_1cc5;
							if( !isValidBound(boundObjs_1ccc, currSOCArg0_1cc2, false))
								continue;
							currMatch.sOCArg0_1cd1= currSOCArg0_1cc2;
							if( !isValidBound(boundObjs_1ccc, currSOCArg1_1cbf, false))
								continue;
							currMatch.sOCArg1_1cd2= currSOCArg1_1cbf;
							if( !isValidBound(boundObjs_1ccc, currArg1_1cc8, false))
								continue;
							currMatch.arg1_1cd3= currArg1_1cc8;
							if( !isValidBound(boundObjs_1ccc, currSOCEnter_1cbc, false))
								continue;
							currMatch.sOCEnter_1cd4= currSOCEnter_1cbc;
							bool Gz_guard= isGuardTrue( currMatch.arg1_1cd3, currMatch.compoundStatement_1ccf, currMatch.enter_1cd0, currMatch.sOCArg0_1cd1, currMatch.sOCArg1_1cd2, currMatch.sOCEnter_1cd4, currMatch.sOCState_1cce, currMatch.state_1ccd);
							if( true== Gz_guard)
								_matches.push_back( currMatch);
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void CallSibsOrChildren_1c98::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::FunctionCall newFunctionCall_1cdd= SFC::FunctionCall::Create( currMatch.compoundStatement_1ccf, SFC::CompoundStatement::meta_stmnt);
		SFC::ArgVal newArgVal1_1cde= SFC::ArgVal::Create( newFunctionCall_1cdd);
		SFC::ArgDeclRef newArgDeclRef_1cdf= SFC::ArgDeclRef::Create( newArgVal1_1cde, SFC::ArgVal::meta_argexpr);
		SFC::ArgVal newArgVal0_1ce0= SFC::ArgVal::Create( newFunctionCall_1cdd);
		SFC::Int newTwo_1ce1= SFC::Int::Create( newArgVal0_1ce0, SFC::ArgVal::meta_argexpr);
		SFC::Arg& Arg1= currMatch.arg1_1cd3;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_1cdf;
		SFC::ArgVal& ArgVal0= newArgVal0_1ce0;
		SFC::ArgVal& ArgVal1= newArgVal1_1cde;
		SFC::CompoundStatement& CompoundStatement= currMatch.compoundStatement_1ccf;
		SFC::Function& Enter= currMatch.enter_1cd0;
		SFC::FunctionCall& FunctionCall= newFunctionCall_1cdd;
		SFC::Arg& SOCArg0= currMatch.sOCArg0_1cd1;
		SFC::Arg& SOCArg1= currMatch.sOCArg1_1cd2;
		SFC::Function& SOCEnter= currMatch.sOCEnter_1cd4;
		CyPhyML::SignalFlow::State& SOCState= currMatch.sOCState_1cce;
		CyPhyML::SignalFlow::State& State= currMatch.state_1ccd;
		SFC::Int& Two= newTwo_1ce1;
		{
FunctionCall.RefId() = CompoundStatement.RefId();
};
		{
FunctionCall.argCount() = 2;
};
		{
__int64 statementCount = CompoundStatement.statementCount();
FunctionCall.statementIndex() = statementCount++;
CompoundStatement.statementCount() = statementCount;
};
		{
Two.val() = 2;
};
		{
ArgVal1.argIndex() = 1;
};
		{
ArgVal0.argIndex() = 0;
};
		newFunctionCall_1cdd.callee()= currMatch.sOCEnter_1cd4;
		newArgDeclRef_1cdf.argdecl()= currMatch.arg1_1cd3;
		newArgVal1_1cde.arg()+= currMatch.sOCArg1_1cd2;
		newArgVal0_1ce0.arg()+= currMatch.sOCArg0_1cd1;
	}
}

void CallParent_1cec::operator()( const Packets_t& states_1ced, const Packets_t& conditionalBlocks_1cef)
{
#ifdef PRINT_INFO
	printLog( "CallParent_1cec" );
#endif
	RTTGenerator::Instance()->generateRule(1074, "CallParent");
	processInputPackets( states_1ced, conditionalBlocks_1cef);
}

bool CallParent_1cec::isInputUnique( const Udm::Object& state_1cf5, const Udm::Object& conditionalBlock_1cfe)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1cf7= _state_1cf1.begin(), itConditionalBlock_1d00= _conditionalBlock_1cfa.begin(); itState_1cf7!= _state_1cf1.end(), itConditionalBlock_1d00!= _conditionalBlock_1cfa.end(); ++itState_1cf7, ++itConditionalBlock_1d00)
	{
		if( ( *itState_1cf7== state_1cf5)&& ( *itConditionalBlock_1d00== conditionalBlock_1cfe))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1cf1.push_back( state_1cf5);
		_conditionalBlock_1cfa.push_back( conditionalBlock_1cfe);
	}
	return isUnique;
}

bool CallParent_1cec::isGuardTrue( SFC::Arg& Arg1, SFC::ConditionalBlock& ConditionalBlock, SFC::Function& Enter, SFC::Arg& ParentArg0, SFC::Arg& ParentArg1, SFC::Function& ParentEnter, CyPhyML::SignalFlow::State& ParentState, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	return Arg1.argIndex() == 1 && ParentArg0.argIndex() == 0 && ParentArg1.argIndex() == 1;;
	return Gz_guard;
}

void CallParent_1cec::processInputPackets( const Packets_t& states_1ced, const Packets_t& conditionalBlocks_1cef)
{
	for( Packets_t::const_iterator itState_1cf2= states_1ced.begin(), itConditionalBlock_1cfb= conditionalBlocks_1cef.begin(); itState_1cf2!= states_1ced.end(), itConditionalBlock_1cfb!= conditionalBlocks_1cef.end(); ++itState_1cf2, ++itConditionalBlock_1cfb)
	{
		bool isUnique= isInputUnique( *itState_1cf2, *itConditionalBlock_1cfb);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1cf2, *itConditionalBlock_1cfb);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CallParent_1cec::patternMatcher( const Udm::Object& state_1cf3, const Udm::Object& conditionalBlock_1cfc)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1cf3.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1cf8= CyPhyML::SignalFlow::State::Cast( state_1cf3);
		if( false== Uml::IsDerivedFrom( conditionalBlock_1cfc.type(), SFC::ConditionalBlock::meta))
			continue;
		SFC::ConditionalBlock conditionalBlock_1d01= SFC::ConditionalBlock::Cast( conditionalBlock_1cfc);
		Udm::Object stateParent_1d03= state_1cf8.container();
		if( false== Uml::IsDerivedFrom( stateParent_1d03.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State parentStateState_1d04= CyPhyML::SignalFlow::State::Cast( stateParent_1d03);
		set< SFC::Function> enters_1d05= state_1cf8.enter();
		for( set< SFC::Function>::const_iterator itEnters_1d06= enters_1d05.begin(); itEnters_1d06!= enters_1d05.end(); ++itEnters_1d06)
		{
			SFC::Function currEnter_1d07= *itEnters_1d06;
			set< SFC::Arg> arg1s_1d08= currEnter_1d07.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itArg1_1d09= arg1s_1d08.begin(); itArg1_1d09!= arg1s_1d08.end(); ++itArg1_1d09)
			{
				SFC::Arg currArg1_1d0a= *itArg1_1d09;
				set< SFC::Function> parentEnters_1d0b= parentStateState_1d04.enter();
				for( set< SFC::Function>::const_iterator itParentEnters_1d0c= parentEnters_1d0b.begin(); itParentEnters_1d0c!= parentEnters_1d0b.end(); ++itParentEnters_1d0c)
				{
					SFC::Function currParentEnter_1d0d= *itParentEnters_1d0c;
					set< SFC::Arg> parentArg0s_1d0e= currParentEnter_1d0d.Arg_kind_children();
					for( set< SFC::Arg>::const_iterator itParentArg0_1d0f= parentArg0s_1d0e.begin(); itParentArg0_1d0f!= parentArg0s_1d0e.end(); ++itParentArg0_1d0f)
					{
						SFC::Arg currParentArg0_1d10= *itParentArg0_1d0f;
						set< SFC::Arg> parentArg1s_1d11= currParentEnter_1d0d.Arg_kind_children();
						for( set< SFC::Arg>::const_iterator itParentArg1_1d12= parentArg1s_1d11.begin(); itParentArg1_1d12!= parentArg1s_1d11.end(); ++itParentArg1_1d12)
						{
							SFC::Arg currParentArg1_1d13= *itParentArg1_1d12;
							Match currMatch;
							currMatch.state_1d15= state_1cf8;
							currMatch.conditionalBlock_1d16= conditionalBlock_1d01;
							currMatch.parentState_1d17= parentStateState_1d04;
							currMatch.parentArg1_1d18= currParentArg1_1d13;
							currMatch.parentArg0_1d19= currParentArg0_1d10;
							currMatch.parentEnter_1d1a= currParentEnter_1d0d;
							currMatch.enter_1d1b= currEnter_1d07;
							currMatch.arg1_1d1c= currArg1_1d0a;
							bool Gz_guard= isGuardTrue( currMatch.arg1_1d1c, currMatch.conditionalBlock_1d16, currMatch.enter_1d1b, currMatch.parentArg0_1d19, currMatch.parentArg1_1d18, currMatch.parentEnter_1d1a, currMatch.parentState_1d17, currMatch.state_1d15);
							if( true== Gz_guard)
								_matches.push_back( currMatch);
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void CallParent_1cec::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::FunctionCall newFunctionCall_1d25= SFC::FunctionCall::Create( currMatch.conditionalBlock_1d16, SFC::ConditionalBlock::meta_stmnt);
		SFC::ArgVal newArgVal1_1d26= SFC::ArgVal::Create( newFunctionCall_1d25);
		SFC::ArgDeclRef newArgDeclRef_1d27= SFC::ArgDeclRef::Create( newArgVal1_1d26, SFC::ArgVal::meta_argexpr);
		SFC::ArgVal newArgVal0_1d28= SFC::ArgVal::Create( newFunctionCall_1d25);
		SFC::Int newThree_1d29= SFC::Int::Create( newArgVal0_1d28, SFC::ArgVal::meta_argexpr);
		SFC::Arg& Arg1= currMatch.arg1_1d1c;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_1d27;
		SFC::ArgVal& ArgVal0= newArgVal0_1d28;
		SFC::ArgVal& ArgVal1= newArgVal1_1d26;
		SFC::ConditionalBlock& ConditionalBlock= currMatch.conditionalBlock_1d16;
		SFC::Function& Enter= currMatch.enter_1d1b;
		SFC::FunctionCall& FunctionCall= newFunctionCall_1d25;
		SFC::Arg& ParentArg0= currMatch.parentArg0_1d19;
		SFC::Arg& ParentArg1= currMatch.parentArg1_1d18;
		SFC::Function& ParentEnter= currMatch.parentEnter_1d1a;
		CyPhyML::SignalFlow::State& ParentState= currMatch.parentState_1d17;
		CyPhyML::SignalFlow::State& State= currMatch.state_1d15;
		SFC::Int& Three= newThree_1d29;
		{
FunctionCall.RefId() = ConditionalBlock.RefId();
};
		{
FunctionCall.argCount() = 2;
};
		{
ArgVal0.argIndex() = 0;
};
		{
Three.val() = 3;
};
		{
__int64 statementCount = ConditionalBlock.statementCount();
FunctionCall.statementIndex() = statementCount++;
ConditionalBlock.statementCount() = statementCount;
};
		{
ArgVal1.argIndex() = 1;
};
		newFunctionCall_1d25.callee()= currMatch.parentEnter_1d1a;
		newArgDeclRef_1d27.argdecl()= currMatch.arg1_1d1c;
		newArgVal0_1d28.arg()+= currMatch.parentArg0_1d19;
		newArgVal1_1d26.arg()+= currMatch.parentArg1_1d18;
	}
}

void TestMode03_1d2a::operator()( const Packets_t& states_1d2b, Packets_t& states_1d2d, Packets_t& conditionalBlocks_1d2e)
{
#ifdef PRINT_INFO
	printLog( "TestMode03_1d2a" );
#endif
	RTTGenerator::Instance()->generateRule(1109, "TestMode03");
	_state_1d2f= &states_1d2d;
	_conditionalBlock_1d30= &conditionalBlocks_1d2e;
	processInputPackets( states_1d2b);
}

bool TestMode03_1d2a::isInputUnique( const Udm::Object& state_1d35)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1d37= _state_1d31.begin(); itState_1d37!= _state_1d31.end(); ++itState_1d37)
	{
		if( ( *itState_1d37== state_1d35))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1d31.push_back( state_1d35);
	return isUnique;
}

bool TestMode03_1d2a::isGuardTrue( SFC::Arg& Arg0, SFC::Function& Enter, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	Gz_guard = Arg0.argIndex() == 0;;
	return Gz_guard;
}

void TestMode03_1d2a::processInputPackets( const Packets_t& states_1d2b)
{
	for( Packets_t::const_iterator itState_1d32= states_1d2b.begin(); itState_1d32!= states_1d2b.end(); ++itState_1d32)
	{
		bool isUnique= isInputUnique( *itState_1d32);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1d32);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TestMode03_1d2a::patternMatcher( const Udm::Object& state_1d33)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1d33.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1d38= CyPhyML::SignalFlow::State::Cast( state_1d33);
		set< SFC::Function> enters_1d3a= state_1d38.enter();
		for( set< SFC::Function>::const_iterator itEnters_1d3b= enters_1d3a.begin(); itEnters_1d3b!= enters_1d3a.end(); ++itEnters_1d3b)
		{
			SFC::Function currEnter_1d3c= *itEnters_1d3b;
			set< SFC::Arg> arg0s_1d3d= currEnter_1d3c.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itArg0_1d3e= arg0s_1d3d.begin(); itArg0_1d3e!= arg0s_1d3d.end(); ++itArg0_1d3e)
			{
				SFC::Arg currArg0_1d3f= *itArg0_1d3e;
				Match currMatch;
				currMatch.state_1d41= state_1d38;
				currMatch.arg0_1d42= currArg0_1d3f;
				currMatch.enter_1d43= currEnter_1d3c;
				bool Gz_guard= isGuardTrue( currMatch.arg0_1d42, currMatch.enter_1d43, currMatch.state_1d41);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void TestMode03_1d2a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_1d47= SFC::ConditionalBlock::Create( currMatch.enter_1d43, SFC::Function::meta_stmnt);
		SFC::UserCode newUserCode_1d48= SFC::UserCode::Create( newConditionalBlock_1d47, SFC::ConditionalBlock::meta_cond);
		SFC::BinaryExprs newLOR_1d49= SFC::BinaryExprs::Create( newUserCode_1d48, SFC::UserCode::meta_codeexpr);
		SFC::BinaryExprs newEquals1_1d4a= SFC::BinaryExprs::Create( newLOR_1d49, SFC::BinaryExprs::meta_leftexpr);
		SFC::Int newZero_1d4b= SFC::Int::Create( newEquals1_1d4a, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef1_1d4c= SFC::ArgDeclRef::Create( newEquals1_1d4a, SFC::BinaryExprs::meta_leftexpr);
		SFC::BinaryExprs newEquals2_1d4d= SFC::BinaryExprs::Create( newLOR_1d49, SFC::BinaryExprs::meta_rightexpr);
		SFC::Int newThree_1d4e= SFC::Int::Create( newEquals2_1d4d, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef2_1d4f= SFC::ArgDeclRef::Create( newEquals2_1d4d, SFC::BinaryExprs::meta_leftexpr);
		SFC::Arg& Arg0= currMatch.arg0_1d42;
		SFC::ArgDeclRef& ArgDeclRef1= newArgDeclRef1_1d4c;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_1d4f;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_1d47;
		SFC::Function& Enter= currMatch.enter_1d43;
		SFC::BinaryExprs& Equals1= newEquals1_1d4a;
		SFC::BinaryExprs& Equals2= newEquals2_1d4d;
		SFC::BinaryExprs& LOR= newLOR_1d49;
		CyPhyML::SignalFlow::State& State= currMatch.state_1d41;
		SFC::Int& Three= newThree_1d4e;
		SFC::UserCode& UserCode= newUserCode_1d48;
		SFC::Int& Zero= newZero_1d4b;
		{
ConditionalBlock.RefId() = UserCode.RefId() = Enter.RefId();
};
		{
Equals2.op() = "==";
};
		{
Three.val() = 3;
};
		{
LOR.op() = "||";
};
		{
Zero.val() = 0;
};
		{
Equals1.op() = "==";
};
		{
__int64 statementCount = Enter.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
Enter.statementCount() = statementCount;
};
		newArgDeclRef2_1d4f.argdecl()= currMatch.arg0_1d42;
		newArgDeclRef1_1d4c.argdecl()= currMatch.arg0_1d42;
		outputAppender( currMatch.state_1d41, newConditionalBlock_1d47);
	}
}

void TestMode03_1d2a::outputAppender( const CyPhyML::SignalFlow::State& state_1d50, const SFC::ConditionalBlock& conditionalBlock_1d52)
{
	_state_1d2f->push_back( state_1d50);
	_conditionalBlock_1d30->push_back( conditionalBlock_1d52);
}

void Mode0or2_1d5c::operator()( const Packets_t& states_1d5d, Packets_t& states_1d5f)
{
#ifdef PRINT_INFO
	printLog( "Mode0or2_1d5c" );
#endif
	_state_1d60= &states_1d5f;
	if( ( !states_1d5d.empty()))
		callChildTest_1dda( states_1d5d);
	_state_1d60->insert( _state_1d60->end(), states_1d5d.begin(), states_1d5d.end());
}

void Mode0or2_1d5c::callChildTest_1dda( const Packets_t& states_1d62)
{
	Packets_t states_1d64;
	ChildTest_1d61 childTest_1d61;
	childTest_1d61( states_1d62, states_1d64);
	if( ( !states_1d64.empty()))
		callTestMode02_1ddc( states_1d64);
}

void Mode0or2_1d5c::callTestMode02_1ddc( const Packets_t& states_1db1)
{
	Packets_t states_1db3;
	Packets_t conditionalBlocks_1db4;
	TestMode02_1db0 testMode02_1db0;
	testMode02_1db0( states_1db1, states_1db3, conditionalBlocks_1db4);
	if( ( !states_1db3.empty())&& ( !conditionalBlocks_1db4.empty()))
		callChildStateType_1dde( states_1db3, conditionalBlocks_1db4);
}

void Mode0or2_1d5c::callChildStateType_1dde( const Packets_t& states_152f, const Packets_t& css_1531)
{
	Packets_t states_1533;
	Packets_t css_1534;
	Packets_t states_1535;
	Packets_t css_1536;
	ChildStateType_152e childStateType_152e;
	childStateType_152e( states_152f, css_1531, states_1533, css_1534, states_1535, css_1536);
	if( ( !states_1535.empty())&& ( !css_1536.empty()))
		callTransStartMap_1de1( states_1535, css_1536);
	if( ( !states_1533.empty())&& ( !css_1534.empty()))
		callGetChildStates_1de4( states_1533, css_1534);
}

void Mode0or2_1d5c::callTransStartMap_1de1( const Packets_t& states_a08, const Packets_t& css_a0a)
{
	Packets_t states_a0c;
	Packets_t css_a0d;
	TransStartMap_a07 transStartMap_a07;
	transStartMap_a07( states_a08, css_a0a, states_a0c, css_a0d);
	if( ( !states_a0c.empty())&& ( !css_a0d.empty()))
		callRefetchEnterFcn_1de7( states_a0c, css_a0d);
}

void Mode0or2_1d5c::callGetChildStates_1de4( const Packets_t& states_13b0, const Packets_t& compoundStatements_13b4)
{
	Packets_t states_13b2;
	Packets_t childStates_13b3;
	Packets_t compoundStatements_13b6;
	GetChildStates_13af getChildStates_13af;
	getChildStates_13af( states_13b0, compoundStatements_13b4, states_13b2, childStates_13b3, compoundStatements_13b6);
	if( ( !states_13b2.empty())&& ( !childStates_13b3.empty())&& ( !compoundStatements_13b6.empty()))
		callCallSibsOrChildren_1dea( states_13b2, childStates_13b3, compoundStatements_13b6);
}

void Mode0or2_1d5c::callRefetchEnterFcn_1de7( const Packets_t& states_1d87, const Packets_t& compoundStatements_1d8b)
{
	Packets_t states_1d89;
	Packets_t functions_1d8a;
	Packets_t compoundStatements_1d8d;
	RefetchEnterFcn_1d86 refetchEnterFcn_1d86;
	refetchEnterFcn_1d86( states_1d87, compoundStatements_1d8b, states_1d89, functions_1d8a, compoundStatements_1d8d);
	if( ( !states_1d89.empty())&& ( !functions_1d8a.empty())&& ( !compoundStatements_1d8d.empty()))
		callTransStartTransitions_1dee( states_1d89, functions_1d8a, compoundStatements_1d8d);
}

void Mode0or2_1d5c::callCallSibsOrChildren_1dea( const Packets_t& states_1c99, const Packets_t& sOCStates_1c9b, const Packets_t& compoundStatements_1c9d)
{
	CallSibsOrChildren_1c98 callSibsOrChildren_1c98;
	callSibsOrChildren_1c98( states_1c99, sOCStates_1c9b, compoundStatements_1c9d);
}

void Mode0or2_1d5c::callTransStartTransitions_1dee( const Packets_t& states_b2, const Packets_t& fcns_b4, const Packets_t& css_b6)
{
	TransStartTransitions_b1 transStartTransitions_b1;
	transStartTransitions_b1( states_b2, fcns_b4, css_b6);
}

void ChildTest_1d61::operator()( const Packets_t& states_1d62, Packets_t& states_1d64)
{
#ifdef PRINT_INFO
	printLog( "ChildTest_1d61" );
#endif
	_state_1d65= &states_1d64;
	for( Packets_t::const_iterator itstate_1d67= states_1d62.begin(); itstate_1d67!= states_1d62.end(); ++itstate_1d67)
	{
		bool isUnique= isInputUnique( *itstate_1d67);
		if( !isUnique)
			continue;
		Packets_t onestate_1d6b( 1, *itstate_1d67);
		executeOne( onestate_1d6b);
	}
}

void ChildTest_1d61::executeOne( const Packets_t& states_1d62)
{
	Packets_t states_1d70;
	HasChildTransConnector_1d6d hasChildTransConnector_1d6d;
	bool isMatchHasChildTransConnector_1d6d= hasChildTransConnector_1d6d( states_1d62, states_1d70);
	_state_1d65->insert( _state_1d65->end(), states_1d70.begin(), states_1d70.end());
	if( isMatchHasChildTransConnector_1d6d)
		return;
}

bool ChildTest_1d61::isInputUnique( const Udm::Object& state_1d68)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_1d6a= _state_1d66.begin(); itstate_1d6a!= _state_1d66.end(); ++itstate_1d6a)
	{
		if( ( *itstate_1d6a== state_1d68))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1d66.push_back( state_1d68);
	return isUnique;
}

bool HasChildTransConnector_1d6d::operator()( const Packets_t& states_1d6e, Packets_t& states_1d70)
{
#ifdef PRINT_INFO
	printLog( "HasChildTransConnector_1d6d" );
#endif
	_state_1d71= &states_1d70;
	processInputPackets( states_1d6e);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasChildTransConnector_1d6d::isInputUnique( const Udm::Object& state_1d76)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1d78= _state_1d72.begin(); itState_1d78!= _state_1d72.end(); ++itState_1d78)
	{
		if( ( *itState_1d78== state_1d76))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1d72.push_back( state_1d76);
	return isUnique;
}

bool HasChildTransConnector_1d6d::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void HasChildTransConnector_1d6d::processInputPackets( const Packets_t& states_1d6e)
{
	for( Packets_t::const_iterator itState_1d73= states_1d6e.begin(); itState_1d73!= states_1d6e.end(); ++itState_1d73)
	{
		bool isUnique= isInputUnique( *itState_1d73);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1d73);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1d82);
	}
}

bool HasChildTransConnector_1d6d::patternMatcher( const Udm::Object& state_1d74)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1d74.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1d79= CyPhyML::SignalFlow::State::Cast( state_1d74);
		set< CyPhyML::SignalFlow::TransConnector> transConnectors_1d7b= state_1d79.TransConnector_kind_children();
		for( set< CyPhyML::SignalFlow::TransConnector>::const_iterator itTransConnector_1d7c= transConnectors_1d7b.begin(); itTransConnector_1d7c!= transConnectors_1d7b.end(); ++itTransConnector_1d7c)
		{
			CyPhyML::SignalFlow::TransConnector currTransConnector_1d7d= *itTransConnector_1d7c;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1d81;
			if( !isValidBound(boundObjs_1d81, state_1d79, true))
				continue;
			currMatch.state_1d82= state_1d79;
			if( !isValidBound(boundObjs_1d81, currTransConnector_1d7d, false))
				continue;
			currMatch.transConnector_1d83= currTransConnector_1d7d;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void HasChildTransConnector_1d6d::outputAppender( const CyPhyML::SignalFlow::State& state_1d84)
{
	_state_1d71->push_back( state_1d84);
}

void RefetchEnterFcn_1d86::operator()( const Packets_t& states_1d87, const Packets_t& compoundStatements_1d8b, Packets_t& states_1d89, Packets_t& functions_1d8a, Packets_t& compoundStatements_1d8d)
{
#ifdef PRINT_INFO
	printLog( "RefetchEnterFcn_1d86" );
#endif
	RTTGenerator::Instance()->generateRule(1152, "RefetchEnterFcn");
	_state_1d8e= &states_1d89;
	_function_1d8f= &functions_1d8a;
	_compoundStatement_1d90= &compoundStatements_1d8d;
	processInputPackets( states_1d87, compoundStatements_1d8b);
}

bool RefetchEnterFcn_1d86::isInputUnique( const Udm::Object& state_1d95, const Udm::Object& compoundStatement_1d9e)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1d97= _state_1d91.begin(), itCompoundStatement_1da0= _compoundStatement_1d9a.begin(); itState_1d97!= _state_1d91.end(), itCompoundStatement_1da0!= _compoundStatement_1d9a.end(); ++itState_1d97, ++itCompoundStatement_1da0)
	{
		if( ( *itState_1d97== state_1d95)&& ( *itCompoundStatement_1da0== compoundStatement_1d9e))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1d91.push_back( state_1d95);
		_compoundStatement_1d9a.push_back( compoundStatement_1d9e);
	}
	return isUnique;
}

void RefetchEnterFcn_1d86::processInputPackets( const Packets_t& states_1d87, const Packets_t& compoundStatements_1d8b)
{
	for( Packets_t::const_iterator itState_1d92= states_1d87.begin(), itCompoundStatement_1d9b= compoundStatements_1d8b.begin(); itState_1d92!= states_1d87.end(), itCompoundStatement_1d9b!= compoundStatements_1d8b.end(); ++itState_1d92, ++itCompoundStatement_1d9b)
	{
		bool isUnique= isInputUnique( *itState_1d92, *itCompoundStatement_1d9b);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1d92, *itCompoundStatement_1d9b);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool RefetchEnterFcn_1d86::patternMatcher( const Udm::Object& state_1d93, const Udm::Object& compoundStatement_1d9c)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1d93.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1d98= CyPhyML::SignalFlow::State::Cast( state_1d93);
		if( false== Uml::IsDerivedFrom( compoundStatement_1d9c.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1da1= SFC::CompoundStatement::Cast( compoundStatement_1d9c);
		set< SFC::Function> functions_1da3= state_1d98.enter();
		for( set< SFC::Function>::const_iterator itFunctions_1da4= functions_1da3.begin(); itFunctions_1da4!= functions_1da3.end(); ++itFunctions_1da4)
		{
			SFC::Function currFunction_1da5= *itFunctions_1da4;
			Match currMatch;
			currMatch.state_1da7= state_1d98;
			currMatch.compoundStatement_1da8= compoundStatement_1da1;
			currMatch.function_1da9= currFunction_1da5;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void RefetchEnterFcn_1d86::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1da7, currMatch.function_1da9, currMatch.compoundStatement_1da8);
	}
}

void RefetchEnterFcn_1d86::outputAppender( const CyPhyML::SignalFlow::State& state_1daa, const SFC::Function& function_1dac, const SFC::CompoundStatement& compoundStatement_1dae)
{
	_state_1d8e->push_back( state_1daa);
	_function_1d8f->push_back( function_1dac);
	_compoundStatement_1d90->push_back( compoundStatement_1dae);
}

void TestMode02_1db0::operator()( const Packets_t& states_1db1, Packets_t& states_1db3, Packets_t& conditionalBlocks_1db4)
{
#ifdef PRINT_INFO
	printLog( "TestMode02_1db0" );
#endif
	RTTGenerator::Instance()->generateRule(1157, "TestMode02");
	_state_1db5= &states_1db3;
	_conditionalBlock_1db6= &conditionalBlocks_1db4;
	processInputPackets( states_1db1);
}

bool TestMode02_1db0::isInputUnique( const Udm::Object& state_1dbb)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1dbd= _state_1db7.begin(); itState_1dbd!= _state_1db7.end(); ++itState_1dbd)
	{
		if( ( *itState_1dbd== state_1dbb))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1db7.push_back( state_1dbb);
	return isUnique;
}

bool TestMode02_1db0::isGuardTrue( SFC::Arg& Arg0, SFC::Function& Enter, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	Gz_guard = Arg0.argIndex() == 0;;
	return Gz_guard;
}

void TestMode02_1db0::processInputPackets( const Packets_t& states_1db1)
{
	for( Packets_t::const_iterator itState_1db8= states_1db1.begin(); itState_1db8!= states_1db1.end(); ++itState_1db8)
	{
		bool isUnique= isInputUnique( *itState_1db8);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1db8);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TestMode02_1db0::patternMatcher( const Udm::Object& state_1db9)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1db9.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1dbe= CyPhyML::SignalFlow::State::Cast( state_1db9);
		set< SFC::Function> enters_1dc0= state_1dbe.enter();
		for( set< SFC::Function>::const_iterator itEnters_1dc1= enters_1dc0.begin(); itEnters_1dc1!= enters_1dc0.end(); ++itEnters_1dc1)
		{
			SFC::Function currEnter_1dc2= *itEnters_1dc1;
			set< SFC::Arg> arg0s_1dc3= currEnter_1dc2.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itArg0_1dc4= arg0s_1dc3.begin(); itArg0_1dc4!= arg0s_1dc3.end(); ++itArg0_1dc4)
			{
				SFC::Arg currArg0_1dc5= *itArg0_1dc4;
				Match currMatch;
				currMatch.state_1dc7= state_1dbe;
				currMatch.arg0_1dc8= currArg0_1dc5;
				currMatch.enter_1dc9= currEnter_1dc2;
				bool Gz_guard= isGuardTrue( currMatch.arg0_1dc8, currMatch.enter_1dc9, currMatch.state_1dc7);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void TestMode02_1db0::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_1dcd= SFC::ConditionalBlock::Create( currMatch.enter_1dc9, SFC::Function::meta_stmnt);
		SFC::UserCode newUserCode_1dce= SFC::UserCode::Create( newConditionalBlock_1dcd, SFC::ConditionalBlock::meta_cond);
		SFC::BinaryExprs newLOR_1dcf= SFC::BinaryExprs::Create( newUserCode_1dce, SFC::UserCode::meta_codeexpr);
		SFC::BinaryExprs newEquals1_1dd0= SFC::BinaryExprs::Create( newLOR_1dcf, SFC::BinaryExprs::meta_leftexpr);
		SFC::Int newZero_1dd1= SFC::Int::Create( newEquals1_1dd0, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef1_1dd2= SFC::ArgDeclRef::Create( newEquals1_1dd0, SFC::BinaryExprs::meta_leftexpr);
		SFC::BinaryExprs newEquals2_1dd3= SFC::BinaryExprs::Create( newLOR_1dcf, SFC::BinaryExprs::meta_rightexpr);
		SFC::Int newTwo_1dd4= SFC::Int::Create( newEquals2_1dd3, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef2_1dd5= SFC::ArgDeclRef::Create( newEquals2_1dd3, SFC::BinaryExprs::meta_leftexpr);
		SFC::Arg& Arg0= currMatch.arg0_1dc8;
		SFC::ArgDeclRef& ArgDeclRef1= newArgDeclRef1_1dd2;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_1dd5;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_1dcd;
		SFC::Function& Enter= currMatch.enter_1dc9;
		SFC::BinaryExprs& Equals1= newEquals1_1dd0;
		SFC::BinaryExprs& Equals2= newEquals2_1dd3;
		SFC::BinaryExprs& LOR= newLOR_1dcf;
		CyPhyML::SignalFlow::State& State= currMatch.state_1dc7;
		SFC::Int& Two= newTwo_1dd4;
		SFC::UserCode& UserCode= newUserCode_1dce;
		SFC::Int& Zero= newZero_1dd1;
		{
ConditionalBlock.RefId() = UserCode.RefId() = Enter.RefId();
};
		{
Equals2.op() = "==";
};
		{
Two.val() = 2;
};
		{
LOR.op() = "||";
};
		{
Zero.val() = 0;
};
		{
Equals1.op() = "==";
};
		{
__int64 statementCount = Enter.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
Enter.statementCount() = statementCount;
};
		newArgDeclRef2_1dd5.argdecl()= currMatch.arg0_1dc8;
		newArgDeclRef1_1dd2.argdecl()= currMatch.arg0_1dc8;
		outputAppender( currMatch.state_1dc7, newConditionalBlock_1dcd);
	}
}

void TestMode02_1db0::outputAppender( const CyPhyML::SignalFlow::State& state_1dd6, const SFC::ConditionalBlock& conditionalBlock_1dd8)
{
	_state_1db5->push_back( state_1dd6);
	_conditionalBlock_1db6->push_back( conditionalBlock_1dd8);
}

void Mode0or1or2_1df2::operator()( const Packets_t& states_1df3, Packets_t& states_1df5)
{
#ifdef PRINT_INFO
	printLog( "Mode0or1or2_1df2" );
#endif
	_state_1df6= &states_1df5;
	_state_1df6->insert( _state_1df6->end(), states_1df3.begin(), states_1df3.end());
	if( ( !states_1df3.empty()))
		callTestMode012EnterAction_1e31( states_1df3);
}

void Mode0or1or2_1df2::callTestMode012EnterAction_1e31( const Packets_t& states_1df8)
{
	TestMode012EnterAction_1df7 testMode012EnterAction_1df7;
	testMode012EnterAction_1df7( states_1df8);
}

void TestMode012EnterAction_1df7::operator()( const Packets_t& states_1df8)
{
#ifdef PRINT_INFO
	printLog( "TestMode012EnterAction_1df7" );
#endif
	RTTGenerator::Instance()->generateRule(1193, "TestMode012EnterAction");
	processInputPackets( states_1df8);
}

bool TestMode012EnterAction_1df7::isInputUnique( const Udm::Object& state_1dfe)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1e00= _state_1dfa.begin(); itState_1e00!= _state_1dfa.end(); ++itState_1e00)
	{
		if( ( *itState_1e00== state_1dfe))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1dfa.push_back( state_1dfe);
	return isUnique;
}

bool TestMode012EnterAction_1df7::isGuardTrue( SFC::Arg& Arg0, SFC::Function& Enter, CyPhyML::SignalFlow::State& ParentState, SFC::StateLabel& ParentStateLabel, SFC::Program& Program, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel, SFC::StateVar& StateVar)
{
	bool Gz_guard= false;
	Gz_guard = Arg0.argIndex() == 0;;
	return Gz_guard;
}

void TestMode012EnterAction_1df7::processInputPackets( const Packets_t& states_1df8)
{
	for( Packets_t::const_iterator itState_1dfb= states_1df8.begin(); itState_1dfb!= states_1df8.end(); ++itState_1dfb)
	{
		bool isUnique= isInputUnique( *itState_1dfb);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1dfb);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TestMode012EnterAction_1df7::patternMatcher( const Udm::Object& state_1dfc)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1dfc.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1e01= CyPhyML::SignalFlow::State::Cast( state_1dfc);
		Udm::Object stateParent_1e03= state_1e01.container();
		if( false== Uml::IsDerivedFrom( stateParent_1e03.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State parentStateState_1e04= CyPhyML::SignalFlow::State::Cast( stateParent_1e03);
		set< SFC::StateLabel> stateLabels_1e05= state_1e01.src();
		for( set< SFC::StateLabel>::const_iterator itStateLabels_1e06= stateLabels_1e05.begin(); itStateLabels_1e06!= stateLabels_1e05.end(); ++itStateLabels_1e06)
		{
			SFC::StateLabel currStateLabel_1e07= *itStateLabels_1e06;
			set< SFC::StateLabel> parentStateLabels_1e08= parentStateState_1e04.src();
			for( set< SFC::StateLabel>::const_iterator itParentStateLabels_1e09= parentStateLabels_1e08.begin(); itParentStateLabels_1e09!= parentStateLabels_1e08.end(); ++itParentStateLabels_1e09)
			{
				SFC::StateLabel currParentStateLabel_1e0a= *itParentStateLabels_1e09;
				set< SFC::Function> enters_1e0b= state_1e01.enter();
				for( set< SFC::Function>::const_iterator itEnters_1e0c= enters_1e0b.begin(); itEnters_1e0c!= enters_1e0b.end(); ++itEnters_1e0c)
				{
					SFC::Function currEnter_1e0d= *itEnters_1e0c;
					Udm::Object enterParent_1e0e= currEnter_1e0d.container();
					if( false== Uml::IsDerivedFrom( enterParent_1e0e.type(), SFC::Program::meta))
						continue;
					SFC::Program programEnter_1e0f= SFC::Program::Cast( enterParent_1e0e);
					set< SFC::StateVar> stateVars_1e10= programEnter_1e0f.StateVar_kind_children();
					for( set< SFC::StateVar>::const_iterator itStateVar_1e11= stateVars_1e10.begin(); itStateVar_1e11!= stateVars_1e10.end(); ++itStateVar_1e11)
					{
						SFC::StateVar currStateVar_1e12= *itStateVar_1e11;
						set< SFC::Arg> arg0s_1e13= currEnter_1e0d.Arg_kind_children();
						for( set< SFC::Arg>::const_iterator itArg0_1e14= arg0s_1e13.begin(); itArg0_1e14!= arg0s_1e13.end(); ++itArg0_1e14)
						{
							SFC::Arg currArg0_1e15= *itArg0_1e14;
							Match currMatch;
							currMatch.state_1e17= state_1e01;
							currMatch.parentState_1e18= parentStateState_1e04;
							currMatch.parentStateLabel_1e19= currParentStateLabel_1e0a;
							currMatch.stateLabel_1e1a= currStateLabel_1e07;
							currMatch.arg0_1e1b= currArg0_1e15;
							currMatch.enter_1e1c= currEnter_1e0d;
							currMatch.program_1e1d= programEnter_1e0f;
							currMatch.stateVar_1e1e= currStateVar_1e12;
							bool Gz_guard= isGuardTrue( currMatch.arg0_1e1b, currMatch.enter_1e1c, currMatch.parentState_1e18, currMatch.parentStateLabel_1e19, currMatch.program_1e1d, currMatch.state_1e17, currMatch.stateLabel_1e1a, currMatch.stateVar_1e1e);
							if( true== Gz_guard)
								_matches.push_back( currMatch);
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void TestMode012EnterAction_1df7::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_1e27= SFC::ConditionalBlock::Create( currMatch.enter_1e1c, SFC::Function::meta_stmnt);
		SFC::SetState newSetState_1e28= SFC::SetState::Create( newConditionalBlock_1e27, SFC::ConditionalBlock::meta_stmnt);
		SFC::UserCode newUserCode_1e29= SFC::UserCode::Create( newConditionalBlock_1e27, SFC::ConditionalBlock::meta_cond);
		SFC::BinaryExprs newLAND_1e2a= SFC::BinaryExprs::Create( newUserCode_1e29, SFC::UserCode::meta_codeexpr);
		SFC::BinaryExprs newGE_1e2b= SFC::BinaryExprs::Create( newLAND_1e2a, SFC::BinaryExprs::meta_leftexpr);
		SFC::Int newZero_1e2c= SFC::Int::Create( newGE_1e2b, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef1_1e2d= SFC::ArgDeclRef::Create( newGE_1e2b, SFC::BinaryExprs::meta_leftexpr);
		SFC::BinaryExprs newLE_1e2e= SFC::BinaryExprs::Create( newLAND_1e2a, SFC::BinaryExprs::meta_rightexpr);
		SFC::Int newTwo_1e2f= SFC::Int::Create( newLE_1e2e, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef2_1e30= SFC::ArgDeclRef::Create( newLE_1e2e, SFC::BinaryExprs::meta_leftexpr);
		SFC::Arg& Arg0= currMatch.arg0_1e1b;
		SFC::ArgDeclRef& ArgDeclRef1= newArgDeclRef1_1e2d;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_1e30;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_1e27;
		SFC::Function& Enter= currMatch.enter_1e1c;
		SFC::BinaryExprs& GE= newGE_1e2b;
		SFC::BinaryExprs& LAND= newLAND_1e2a;
		SFC::BinaryExprs& LE= newLE_1e2e;
		CyPhyML::SignalFlow::State& ParentState= currMatch.parentState_1e18;
		SFC::StateLabel& ParentStateLabel= currMatch.parentStateLabel_1e19;
		SFC::Program& Program= currMatch.program_1e1d;
		SFC::SetState& SetState= newSetState_1e28;
		CyPhyML::SignalFlow::State& State= currMatch.state_1e17;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_1e1a;
		SFC::StateVar& StateVar= currMatch.stateVar_1e1e;
		SFC::Int& Two= newTwo_1e2f;
		SFC::UserCode& UserCode= newUserCode_1e29;
		SFC::Int& Zero= newZero_1e2c;
		{
ConditionalBlock.RefId() = UserCode.RefId() = SetState.RefId() = Enter.RefId();
};
		{
SetState.invert() = false;
SetState.andState() = static_cast< std::string >( State.Decomposition() ) == "AND_STATE";
};
		{
__int64 statementCount = ConditionalBlock.statementCount();
SetState.statementIndex() = statementCount++;
ConditionalBlock.statementCount() = statementCount;

SFManager::mstat2SFC( ConditionalBlock, State.EnterAction() );
};
		{
LE.op() = "<=";
};
		{
Two.val() = 2;
};
		{
LAND.op() = "&&";
};
		{
Zero.val() = 0;
};
		{
GE.op() = ">=";
};
		{
__int64 statementCount = Enter.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
Enter.statementCount() = statementCount;
};
		newSetState_1e28.index()= currMatch.parentStateLabel_1e19;
		newSetState_1e28.value()= currMatch.stateLabel_1e1a;
		newSetState_1e28.svar()= currMatch.stateVar_1e1e;
		newArgDeclRef2_1e30.argdecl()= currMatch.arg0_1e1b;
		newArgDeclRef1_1e2d.argdecl()= currMatch.arg0_1e1b;
	}
}

void Mode0or1_1e33::operator()( const Packets_t& states_1e34, Packets_t& states_1e36)
{
#ifdef PRINT_INFO
	printLog( "Mode0or1_1e33" );
#endif
	_state_1e37= &states_1e36;
	_state_1e37->insert( _state_1e37->end(), states_1e34.begin(), states_1e34.end());
	if( ( !states_1e34.empty()))
		callTestMode01CallParent_1eb0( states_1e34);
}

void Mode0or1_1e33::callTestMode01CallParent_1eb0( const Packets_t& states_1e6a)
{
	Packets_t states_1e6c;
	Packets_t conditionalBlocks_1e6d;
	TestMode01CallParent_1e69 testMode01CallParent_1e69;
	testMode01CallParent_1e69( states_1e6a, states_1e6c, conditionalBlocks_1e6d);
	if( ( !states_1e6c.empty())&& ( !conditionalBlocks_1e6d.empty()))
		callIsAndState_1eb2( states_1e6c, conditionalBlocks_1e6d);
}

void Mode0or1_1e33::callIsAndState_1eb2( const Packets_t& states_1c5e, const Packets_t& css_1c60)
{
	Packets_t states_1c62;
	Packets_t css_1c63;
	IsAndState_1c5d isAndState_1c5d;
	isAndState_1c5d( states_1c5e, css_1c60, states_1c62, css_1c63);
	if( ( !states_1c62.empty())&& ( !css_1c63.empty()))
		callGetHOSibs_1eb5( states_1c62, css_1c63);
}

void Mode0or1_1e33::callGetHOSibs_1eb5( const Packets_t& states_1e39, const Packets_t& compoundStatements_1e3d)
{
	Packets_t states_1e3b;
	Packets_t sibStates_1e3c;
	Packets_t compoundStatements_1e3f;
	GetHOSibs_1e38 getHOSibs_1e38;
	getHOSibs_1e38( states_1e39, compoundStatements_1e3d, states_1e3b, sibStates_1e3c, compoundStatements_1e3f);
	if( ( !states_1e3b.empty())&& ( !sibStates_1e3c.empty())&& ( !compoundStatements_1e3f.empty()))
		callCallSibsOrChildren_1eb8( states_1e3b, sibStates_1e3c, compoundStatements_1e3f);
}

void Mode0or1_1e33::callCallSibsOrChildren_1eb8( const Packets_t& states_1c99, const Packets_t& sOCStates_1c9b, const Packets_t& compoundStatements_1c9d)
{
	CallSibsOrChildren_1c98 callSibsOrChildren_1c98;
	callSibsOrChildren_1c98( states_1c99, sOCStates_1c9b, compoundStatements_1c9d);
}

void GetHOSibs_1e38::operator()( const Packets_t& states_1e39, const Packets_t& compoundStatements_1e3d, Packets_t& states_1e3b, Packets_t& sibStates_1e3c, Packets_t& compoundStatements_1e3f)
{
#ifdef PRINT_INFO
	printLog( "GetHOSibs_1e38" );
#endif
	RTTGenerator::Instance()->generateRule(1246, "GetHOSibs");
	_state_1e40= &states_1e3b;
	_sibState_1e41= &sibStates_1e3c;
	_compoundStatement_1e42= &compoundStatements_1e3f;
	processInputPackets( states_1e39, compoundStatements_1e3d);
	sortOutputs( );
}

bool GetHOSibs_1e38::isInputUnique( const Udm::Object& state_1e47, const Udm::Object& compoundStatement_1e50)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1e49= _state_1e43.begin(), itCompoundStatement_1e52= _compoundStatement_1e4c.begin(); itState_1e49!= _state_1e43.end(), itCompoundStatement_1e52!= _compoundStatement_1e4c.end(); ++itState_1e49, ++itCompoundStatement_1e52)
	{
		if( ( *itState_1e49== state_1e47)&& ( *itCompoundStatement_1e52== compoundStatement_1e50))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1e43.push_back( state_1e47);
		_compoundStatement_1e4c.push_back( compoundStatement_1e50);
	}
	return isUnique;
}

bool GetHOSibs_1e38::isGuardTrue( SFC::CompoundStatement& CompoundStatement, CyPhyML::SignalFlow::State& ParentState, CyPhyML::SignalFlow::State& SibState, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	std::string stateOrder = SFManager::trim(  static_cast< std::string >( State.Order() )  );
if ( stateOrder.empty() ) stateOrder = "0";

std::string sibStateOrder = SFManager::trim(  static_cast< std::string >( SibState.Order() )  );
if ( sibStateOrder.empty() ) sibStateOrder = "0";

return boost::lexical_cast< int >( stateOrder ) < boost::lexical_cast< int >( sibStateOrder );;
	return Gz_guard;
}

void GetHOSibs_1e38::processInputPackets( const Packets_t& states_1e39, const Packets_t& compoundStatements_1e3d)
{
	for( Packets_t::const_iterator itState_1e44= states_1e39.begin(), itCompoundStatement_1e4d= compoundStatements_1e3d.begin(); itState_1e44!= states_1e39.end(), itCompoundStatement_1e4d!= compoundStatements_1e3d.end(); ++itState_1e44, ++itCompoundStatement_1e4d)
	{
		bool isUnique= isInputUnique( *itState_1e44, *itCompoundStatement_1e4d);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1e44, *itCompoundStatement_1e4d);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetHOSibs_1e38::patternMatcher( const Udm::Object& state_1e45, const Udm::Object& compoundStatement_1e4e)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1e45.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1e4a= CyPhyML::SignalFlow::State::Cast( state_1e45);
		if( false== Uml::IsDerivedFrom( compoundStatement_1e4e.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement compoundStatement_1e53= SFC::CompoundStatement::Cast( compoundStatement_1e4e);
		Udm::Object stateParent_1e55= state_1e4a.container();
		if( false== Uml::IsDerivedFrom( stateParent_1e55.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State parentStateState_1e56= CyPhyML::SignalFlow::State::Cast( stateParent_1e55);
		set< CyPhyML::SignalFlow::State> sibStates_1e57= parentStateState_1e56.State_kind_children();
		for( set< CyPhyML::SignalFlow::State>::const_iterator itSibState_1e58= sibStates_1e57.begin(); itSibState_1e58!= sibStates_1e57.end(); ++itSibState_1e58)
		{
			CyPhyML::SignalFlow::State currSibState_1e59= *itSibState_1e58;
			Match currMatch;
			currMatch.state_1e5b= state_1e4a;
			currMatch.compoundStatement_1e5c= compoundStatement_1e53;
			currMatch.parentState_1e5d= parentStateState_1e56;
			currMatch.sibState_1e5e= currSibState_1e59;
			bool Gz_guard= isGuardTrue( currMatch.compoundStatement_1e5c, currMatch.parentState_1e5d, currMatch.sibState_1e5e, currMatch.state_1e5b);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetHOSibs_1e38::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1e5b, currMatch.sibState_1e5e, currMatch.compoundStatement_1e5c);
	}
}

void GetHOSibs_1e38::outputAppender( const CyPhyML::SignalFlow::State& state_1e63, const CyPhyML::SignalFlow::State& sibState_1e65, const SFC::CompoundStatement& compoundStatement_1e67)
{
	_state_1e40->push_back( state_1e63);
	_sibState_1e41->push_back( sibState_1e65);
	_compoundStatement_1e42->push_back( compoundStatement_1e67);
}

void GetHOSibs_1e38::sortOutputs()
{
	typedef std::multiset< CyPhyML::SignalFlow::State, std::pointer_to_binary_function< const CyPhyML::SignalFlow::State&, const CyPhyML::SignalFlow::State&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const CyPhyML::SignalFlow::State&, const CyPhyML::SignalFlow::State&, bool> ptr_StateOrder( StateOrder< CyPhyML::SignalFlow::State>);
	SortedSet_t sortedSet( ptr_StateOrder);
	std::vector< int> permutationVector( _sibState_1e41->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _sibState_1e41->begin(); it!= _sibState_1e41->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( CyPhyML::SignalFlow::State::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _sibState_1e41->begin());
	// order rest of the containers
	permutate( permutationVector, *_state_1e40);
	permutate( permutationVector, *_compoundStatement_1e42);
}

void TestMode01CallParent_1e69::operator()( const Packets_t& states_1e6a, Packets_t& states_1e6c, Packets_t& conditionalBlocks_1e6d)
{
#ifdef PRINT_INFO
	printLog( "TestMode01CallParent_1e69" );
#endif
	RTTGenerator::Instance()->generateRule(1253, "TestMode01CallParent");
	_state_1e6e= &states_1e6c;
	_conditionalBlock_1e6f= &conditionalBlocks_1e6d;
	processInputPackets( states_1e6a);
}

bool TestMode01CallParent_1e69::isInputUnique( const Udm::Object& state_1e74)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1e76= _state_1e70.begin(); itState_1e76!= _state_1e70.end(); ++itState_1e76)
	{
		if( ( *itState_1e76== state_1e74))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1e70.push_back( state_1e74);
	return isUnique;
}

bool TestMode01CallParent_1e69::isGuardTrue( SFC::Arg& Arg0, SFC::Arg& Arg1, SFC::Function& Enter, SFC::Arg& ParentArg0, SFC::Arg& ParentArg1, SFC::Function& ParentEnter, CyPhyML::SignalFlow::State& ParentState, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	return ParentArg0.argIndex() == 0 && ParentArg1.argIndex() == 1 && Arg0.argIndex() == 0 && Arg1.argIndex() == 1;;
	return Gz_guard;
}

void TestMode01CallParent_1e69::processInputPackets( const Packets_t& states_1e6a)
{
	for( Packets_t::const_iterator itState_1e71= states_1e6a.begin(); itState_1e71!= states_1e6a.end(); ++itState_1e71)
	{
		bool isUnique= isInputUnique( *itState_1e71);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1e71);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TestMode01CallParent_1e69::patternMatcher( const Udm::Object& state_1e72)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1e72.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1e77= CyPhyML::SignalFlow::State::Cast( state_1e72);
		Udm::Object stateParent_1e79= state_1e77.container();
		if( false== Uml::IsDerivedFrom( stateParent_1e79.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State parentStateState_1e7a= CyPhyML::SignalFlow::State::Cast( stateParent_1e79);
		set< SFC::Function> parentEnters_1e7b= parentStateState_1e7a.enter();
		for( set< SFC::Function>::const_iterator itParentEnters_1e7c= parentEnters_1e7b.begin(); itParentEnters_1e7c!= parentEnters_1e7b.end(); ++itParentEnters_1e7c)
		{
			SFC::Function currParentEnter_1e7d= *itParentEnters_1e7c;
			set< SFC::Arg> parentArg1s_1e7e= currParentEnter_1e7d.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itParentArg1_1e7f= parentArg1s_1e7e.begin(); itParentArg1_1e7f!= parentArg1s_1e7e.end(); ++itParentArg1_1e7f)
			{
				SFC::Arg currParentArg1_1e80= *itParentArg1_1e7f;
				set< SFC::Arg> parentArg0s_1e81= currParentEnter_1e7d.Arg_kind_children();
				for( set< SFC::Arg>::const_iterator itParentArg0_1e82= parentArg0s_1e81.begin(); itParentArg0_1e82!= parentArg0s_1e81.end(); ++itParentArg0_1e82)
				{
					SFC::Arg currParentArg0_1e83= *itParentArg0_1e82;
					set< SFC::Function> enters_1e84= state_1e77.enter();
					for( set< SFC::Function>::const_iterator itEnters_1e85= enters_1e84.begin(); itEnters_1e85!= enters_1e84.end(); ++itEnters_1e85)
					{
						SFC::Function currEnter_1e86= *itEnters_1e85;
						set< SFC::Arg> arg0s_1e87= currEnter_1e86.Arg_kind_children();
						for( set< SFC::Arg>::const_iterator itArg0_1e88= arg0s_1e87.begin(); itArg0_1e88!= arg0s_1e87.end(); ++itArg0_1e88)
						{
							SFC::Arg currArg0_1e89= *itArg0_1e88;
							set< SFC::Arg> arg1s_1e8a= currEnter_1e86.Arg_kind_children();
							for( set< SFC::Arg>::const_iterator itArg1_1e8b= arg1s_1e8a.begin(); itArg1_1e8b!= arg1s_1e8a.end(); ++itArg1_1e8b)
							{
								SFC::Arg currArg1_1e8c= *itArg1_1e8b;
								Match currMatch;
								currMatch.state_1e8e= state_1e77;
								currMatch.parentState_1e8f= parentStateState_1e7a;
								currMatch.parentArg0_1e90= currParentArg0_1e83;
								currMatch.parentEnter_1e91= currParentEnter_1e7d;
								currMatch.arg0_1e92= currArg0_1e89;
								currMatch.arg1_1e93= currArg1_1e8c;
								currMatch.parentArg1_1e94= currParentArg1_1e80;
								currMatch.enter_1e95= currEnter_1e86;
								bool Gz_guard= isGuardTrue( currMatch.arg0_1e92, currMatch.arg1_1e93, currMatch.enter_1e95, currMatch.parentArg0_1e90, currMatch.parentArg1_1e94, currMatch.parentEnter_1e91, currMatch.parentState_1e8f, currMatch.state_1e8e);
								if( true== Gz_guard)
									_matches.push_back( currMatch);
							}
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void TestMode01CallParent_1e69::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_1e9e= SFC::ConditionalBlock::Create( currMatch.enter_1e95, SFC::Function::meta_stmnt);
		SFC::FunctionCall newFunctionCall_1e9f= SFC::FunctionCall::Create( newConditionalBlock_1e9e, SFC::ConditionalBlock::meta_stmnt);
		SFC::ArgVal newArgVal1_1ea0= SFC::ArgVal::Create( newFunctionCall_1e9f);
		SFC::ArgDeclRef newFCArgDeclRef_1ea1= SFC::ArgDeclRef::Create( newArgVal1_1ea0, SFC::ArgVal::meta_argexpr);
		SFC::ArgVal newArgVal0_1ea2= SFC::ArgVal::Create( newFunctionCall_1e9f);
		SFC::Int newArgOne_1ea3= SFC::Int::Create( newArgVal0_1ea2, SFC::ArgVal::meta_argexpr);
		SFC::UserCode newUserCode_1ea4= SFC::UserCode::Create( newConditionalBlock_1e9e, SFC::ConditionalBlock::meta_cond);
		SFC::BinaryExprs newLOR_1ea5= SFC::BinaryExprs::Create( newUserCode_1ea4, SFC::UserCode::meta_codeexpr);
		SFC::BinaryExprs newEquals2_1ea6= SFC::BinaryExprs::Create( newLOR_1ea5, SFC::BinaryExprs::meta_rightexpr);
		SFC::Int newOne_1ea7= SFC::Int::Create( newEquals2_1ea6, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef2_1ea8= SFC::ArgDeclRef::Create( newEquals2_1ea6, SFC::BinaryExprs::meta_leftexpr);
		SFC::BinaryExprs newEquals1_1ea9= SFC::BinaryExprs::Create( newLOR_1ea5, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef1_1eaa= SFC::ArgDeclRef::Create( newEquals1_1ea9, SFC::BinaryExprs::meta_leftexpr);
		SFC::Int newZero_1eab= SFC::Int::Create( newEquals1_1ea9, SFC::BinaryExprs::meta_rightexpr);
		SFC::Arg& Arg0= currMatch.arg0_1e92;
		SFC::Arg& Arg1= currMatch.arg1_1e93;
		SFC::ArgDeclRef& ArgDeclRef1= newArgDeclRef1_1eaa;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_1ea8;
		SFC::Int& ArgOne= newArgOne_1ea3;
		SFC::ArgVal& ArgVal0= newArgVal0_1ea2;
		SFC::ArgVal& ArgVal1= newArgVal1_1ea0;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_1e9e;
		SFC::Function& Enter= currMatch.enter_1e95;
		SFC::BinaryExprs& Equals1= newEquals1_1ea9;
		SFC::BinaryExprs& Equals2= newEquals2_1ea6;
		SFC::ArgDeclRef& FCArgDeclRef= newFCArgDeclRef_1ea1;
		SFC::FunctionCall& FunctionCall= newFunctionCall_1e9f;
		SFC::BinaryExprs& LOR= newLOR_1ea5;
		SFC::Int& One= newOne_1ea7;
		SFC::Arg& ParentArg0= currMatch.parentArg0_1e90;
		SFC::Arg& ParentArg1= currMatch.parentArg1_1e94;
		SFC::Function& ParentEnter= currMatch.parentEnter_1e91;
		CyPhyML::SignalFlow::State& ParentState= currMatch.parentState_1e8f;
		CyPhyML::SignalFlow::State& State= currMatch.state_1e8e;
		SFC::UserCode& UserCode= newUserCode_1ea4;
		SFC::Int& Zero= newZero_1eab;
		{
ConditionalBlock.RefId() = UserCode.RefId() = FunctionCall.RefId() = Enter.RefId();
};
		{
ArgOne.val() = 1;
};
		{
FunctionCall.argCount() = 2;
};
		{
ArgVal0.argIndex() = 0;
};
		{
ArgVal1.argIndex() = 1;
};
		{
__int64 statementCount = Enter.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
Enter.statementCount() = statementCount;
};
		{
__int64 statementCount = ConditionalBlock.statementCount();
FunctionCall.statementIndex() = statementCount++;
ConditionalBlock.statementCount() = statementCount;
};
		{
Zero.val() = 0;
};
		{
One.val() = 1;
};
		{
Equals2.op() = "==";
};
		{
Equals1.op() = "==";
};
		{
LOR.op() = "||";
};
		newFunctionCall_1e9f.callee()= currMatch.parentEnter_1e91;
		newArgVal0_1ea2.arg()+= currMatch.parentArg0_1e90;
		newArgVal1_1ea0.arg()+= currMatch.parentArg1_1e94;
		newFCArgDeclRef_1ea1.argdecl()= currMatch.arg1_1e93;
		newArgDeclRef1_1eaa.argdecl()= currMatch.arg0_1e92;
		newArgDeclRef2_1ea8.argdecl()= currMatch.arg0_1e92;
		outputAppender( currMatch.state_1e8e, newConditionalBlock_1e9e);
	}
}

void TestMode01CallParent_1e69::outputAppender( const CyPhyML::SignalFlow::State& state_1eac, const SFC::ConditionalBlock& conditionalBlock_1eae)
{
	_state_1e6e->push_back( state_1eac);
	_conditionalBlock_1e6f->push_back( conditionalBlock_1eae);
}

void ReturnAtTopState_1ebc::operator()( const Packets_t& states_1ebd, Packets_t& states_1ebf)
{
#ifdef PRINT_INFO
	printLog( "ReturnAtTopState_1ebc" );
#endif
	_state_1ec0= &states_1ebf;
	if( ( !states_1ebd.empty()))
		callTopState_1ee8( states_1ebd);
	_state_1ec0->insert( _state_1ec0->end(), states_1ebd.begin(), states_1ebd.end());
}

void ReturnAtTopState_1ebc::callTopState_1ee8( const Packets_t& states_1ec2)
{
	TopState_1ec1 topState_1ec1;
	topState_1ec1( states_1ec2);
}

void TopState_1ec1::operator()( const Packets_t& states_1ec2)
{
#ifdef PRINT_INFO
	printLog( "TopState_1ec1" );
#endif
	RTTGenerator::Instance()->generateRule(1360, "TopState");
	processInputPackets( states_1ec2);
}

bool TopState_1ec1::isInputUnique( const Udm::Object& state_1ec8)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1eca= _state_1ec4.begin(); itState_1eca!= _state_1ec4.end(); ++itState_1eca)
	{
		if( ( *itState_1eca== state_1ec8))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1ec4.push_back( state_1ec8);
	return isUnique;
}

bool TopState_1ec1::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool TopState_1ec1::isGuardTrue( SFC::Arg& Arg, SFC::Function& Enter, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel)
{
	bool Gz_guard= false;
	Gz_guard = Arg.argIndex() == 1;;
	return Gz_guard;
}

void TopState_1ec1::processInputPackets( const Packets_t& states_1ec2)
{
	for( Packets_t::const_iterator itState_1ec5= states_1ec2.begin(); itState_1ec5!= states_1ec2.end(); ++itState_1ec5)
	{
		bool isUnique= isInputUnique( *itState_1ec5);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1ec5);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TopState_1ec1::patternMatcher( const Udm::Object& state_1ec6)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1ec6.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1ecb= CyPhyML::SignalFlow::State::Cast( state_1ec6);
		set< SFC::Function> enters_1ecd= state_1ecb.enter();
		for( set< SFC::Function>::const_iterator itEnters_1ece= enters_1ecd.begin(); itEnters_1ece!= enters_1ecd.end(); ++itEnters_1ece)
		{
			SFC::Function currEnter_1ecf= *itEnters_1ece;
			set< SFC::Arg> args_1ed0= currEnter_1ecf.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itArg_1ed1= args_1ed0.begin(); itArg_1ed1!= args_1ed0.end(); ++itArg_1ed1)
			{
				SFC::Arg currArg_1ed2= *itArg_1ed1;
				set< SFC::StateLabel> stateLabels_1ed3= state_1ecb.src();
				for( set< SFC::StateLabel>::const_iterator itStateLabels_1ed4= stateLabels_1ed3.begin(); itStateLabels_1ed4!= stateLabels_1ed3.end(); ++itStateLabels_1ed4)
				{
					SFC::StateLabel currStateLabel_1ed5= *itStateLabels_1ed4;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_1ed9;
					if( !isValidBound(boundObjs_1ed9, state_1ecb, true))
						continue;
					currMatch.state_1eda= state_1ecb;
					if( !isValidBound(boundObjs_1ed9, currStateLabel_1ed5, false))
						continue;
					currMatch.stateLabel_1edb= currStateLabel_1ed5;
					if( !isValidBound(boundObjs_1ed9, currEnter_1ecf, false))
						continue;
					currMatch.enter_1edc= currEnter_1ecf;
					if( !isValidBound(boundObjs_1ed9, currArg_1ed2, false))
						continue;
					currMatch.arg_1edd= currArg_1ed2;
					bool Gz_guard= isGuardTrue( currMatch.arg_1edd, currMatch.enter_1edc, currMatch.state_1eda, currMatch.stateLabel_1edb);
					if( true== Gz_guard)
						_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void TopState_1ec1::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_1ee2= SFC::ConditionalBlock::Create( currMatch.enter_1edc, SFC::Function::meta_stmnt);
		SFC::UserCode newUserCode_1ee3= SFC::UserCode::Create( newConditionalBlock_1ee2, SFC::ConditionalBlock::meta_cond);
		SFC::Return newReturn_1ee4= SFC::Return::Create( newConditionalBlock_1ee2, SFC::ConditionalBlock::meta_stmnt);
		SFC::BinaryExprs newEquals_1ee5= SFC::BinaryExprs::Create( newUserCode_1ee3, SFC::UserCode::meta_codeexpr);
		SFC::ArgDeclRef newArgDeclRef_1ee6= SFC::ArgDeclRef::Create( newEquals_1ee5, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newSLArgDeclRef_1ee7= SFC::ArgDeclRef::Create( newEquals_1ee5, SFC::BinaryExprs::meta_rightexpr);
		SFC::Arg& Arg= currMatch.arg_1edd;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_1ee6;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_1ee2;
		SFC::Function& Enter= currMatch.enter_1edc;
		SFC::BinaryExprs& Equals= newEquals_1ee5;
		SFC::Return& Return= newReturn_1ee4;
		SFC::ArgDeclRef& SLArgDeclRef= newSLArgDeclRef_1ee7;
		CyPhyML::SignalFlow::State& State= currMatch.state_1eda;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_1edb;
		SFC::UserCode& UserCode= newUserCode_1ee3;
		{
ConditionalBlock.RefId() = Return.RefId() = UserCode.RefId() = Enter.RefId();
};
		{
Equals.op() = "==";
};
		{
__int64 statementCount = Enter.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
Enter.statementCount() = statementCount;
};
		{
__int64 statementCount = ConditionalBlock.statementCount();
Return.statementIndex() = statementCount++;
ConditionalBlock.statementCount() = statementCount;
};
		newArgDeclRef_1ee6.argdecl()= currMatch.arg_1edd;
		newSLArgDeclRef_1ee7.argdecl()= currMatch.stateLabel_1edb;
	}
}

void TestEAIOff_1eea::operator()( const Packets_t& states_1eeb, Packets_t& states_1eed, Packets_t& states_1eee)
{
#ifdef PRINT_INFO
	printLog( "TestEAIOff_1eea" );
#endif
	_state_1eef= &states_1eed;
	_state_1ef0= &states_1eee;
	for( Packets_t::const_iterator itstate_1ef2= states_1eeb.begin(); itstate_1ef2!= states_1eeb.end(); ++itstate_1ef2)
	{
		bool isUnique= isInputUnique( *itstate_1ef2);
		if( !isUnique)
			continue;
		Packets_t onestate_1ef6( 1, *itstate_1ef2);
		executeOne( onestate_1ef6);
	}
}

void TestEAIOff_1eea::executeOne( const Packets_t& states_1eeb)
{
	Packets_t states_1efb;
	EAIOff_1ef8 eAIOff_1ef8;
	bool isMatchEAIOff_1ef8= eAIOff_1ef8( states_1eeb, states_1efb);
	_state_1eef->insert( _state_1eef->end(), states_1efb.begin(), states_1efb.end());
	if( isMatchEAIOff_1ef8)
		return;
	Packets_t states_1f23;
	Otherwise_1f20 otherwise_1f20;
	bool isMatchOtherwise_1f20= otherwise_1f20( states_1eeb, states_1f23);
	_state_1ef0->insert( _state_1ef0->end(), states_1f23.begin(), states_1f23.end());
	if( isMatchOtherwise_1f20)
		return;
}

bool TestEAIOff_1eea::isInputUnique( const Udm::Object& state_1ef3)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_1ef5= _state_1ef1.begin(); itstate_1ef5!= _state_1ef1.end(); ++itstate_1ef5)
	{
		if( ( *itstate_1ef5== state_1ef3))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1ef1.push_back( state_1ef3);
	return isUnique;
}

bool EAIOff_1ef8::operator()( const Packets_t& states_1ef9, Packets_t& states_1efb)
{
#ifdef PRINT_INFO
	printLog( "EAIOff_1ef8" );
#endif
	_state_1efc= &states_1efb;
	processInputPackets( states_1ef9);
	if( false== _matches.empty())
		return true;
	return false;
}

bool EAIOff_1ef8::isInputUnique( const Udm::Object& state_1f01)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1f03= _state_1efd.begin(); itState_1f03!= _state_1efd.end(); ++itState_1f03)
	{
		if( ( *itState_1f03== state_1f01))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1efd.push_back( state_1f01);
	return isUnique;
}

bool EAIOff_1ef8::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool EAIOff_1ef8::isGuardTrue( CyPhyML::SignalFlow::ConnectorRef& ConnectorRef, CyPhyML::SignalFlow::SF_Parameter& Parameter, CyPhyML::SignalFlow::Primitive& Primitive, CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::Subsystem& Subsystem)
{
	bool Gz_guard= false;
	return static_cast< std::string >( Parameter.name() ) == "ExecuteAtInitialization" &&
 static_cast< std::string >(  Parameter.Value() ) == "off";;
	return Gz_guard;
}

void EAIOff_1ef8::processInputPackets( const Packets_t& states_1ef9)
{
	for( Packets_t::const_iterator itState_1efe= states_1ef9.begin(); itState_1efe!= states_1ef9.end(); ++itState_1efe)
	{
		bool isUnique= isInputUnique( *itState_1efe);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1efe);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1f14);
	}
}

bool EAIOff_1ef8::patternMatcher( const Udm::Object& state_1eff)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1eff.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1f04= CyPhyML::SignalFlow::State::Cast( state_1eff);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_1f06= state_1f04.referedbyConnectorRef();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRefs_1f07= connectorRefs_1f06.begin(); itConnectorRefs_1f07!= connectorRefs_1f06.end(); ++itConnectorRefs_1f07)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_1f08= *itConnectorRefs_1f07;
			Udm::Object connectorRefParent_1f09= currConnectorRef_1f08.container();
			if( false== Uml::IsDerivedFrom( connectorRefParent_1f09.type(), CyPhyML::SignalFlow::Primitive::meta))
				continue;
			CyPhyML::SignalFlow::Primitive primitiveConnectorRef_1f0a= CyPhyML::SignalFlow::Primitive::Cast( connectorRefParent_1f09);
			Udm::Object primitiveParent_1f0b= primitiveConnectorRef_1f0a.container();
			if( false== Uml::IsDerivedFrom( primitiveParent_1f0b.type(), CyPhyML::SignalFlow::Subsystem::meta))
				continue;
			CyPhyML::SignalFlow::Subsystem subsystemPrimitive_1f0c= CyPhyML::SignalFlow::Subsystem::Cast( primitiveParent_1f0b);
			set< CyPhyML::SignalFlow::SF_Parameter> parameters_1f0d= subsystemPrimitive_1f0c.SF_Parameter_kind_children();
			for( set< CyPhyML::SignalFlow::SF_Parameter>::const_iterator itParameter_1f0e= parameters_1f0d.begin(); itParameter_1f0e!= parameters_1f0d.end(); ++itParameter_1f0e)
			{
				CyPhyML::SignalFlow::SF_Parameter currParameter_1f0f= *itParameter_1f0e;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_1f13;
				if( !isValidBound(boundObjs_1f13, state_1f04, true))
					continue;
				currMatch.state_1f14= state_1f04;
				if( !isValidBound(boundObjs_1f13, currConnectorRef_1f08, false))
					continue;
				currMatch.connectorRef_1f15= currConnectorRef_1f08;
				if( !isValidBound(boundObjs_1f13, primitiveConnectorRef_1f0a, false))
					continue;
				currMatch.primitive_1f16= primitiveConnectorRef_1f0a;
				if( !isValidBound(boundObjs_1f13, currParameter_1f0f, false))
					continue;
				currMatch.parameter_1f17= currParameter_1f0f;
				if( !isValidBound(boundObjs_1f13, subsystemPrimitive_1f0c, false))
					continue;
				currMatch.subsystem_1f18= subsystemPrimitive_1f0c;
				bool Gz_guard= isGuardTrue( currMatch.connectorRef_1f15, currMatch.parameter_1f17, currMatch.primitive_1f16, currMatch.state_1f14, currMatch.subsystem_1f18);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void EAIOff_1ef8::outputAppender( const CyPhyML::SignalFlow::State& state_1f1e)
{
	_state_1efc->push_back( state_1f1e);
}

bool Otherwise_1f20::operator()( const Packets_t& states_1f21, Packets_t& states_1f23)
{
#ifdef PRINT_INFO
	printLog( "Otherwise_1f20" );
#endif
	_state_1f24= &states_1f23;
	processInputPackets( states_1f21);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_1f20::isInputUnique( const Udm::Object& state_1f29)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1f2b= _state_1f25.begin(); itState_1f2b!= _state_1f25.end(); ++itState_1f2b)
	{
		if( ( *itState_1f2b== state_1f29))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_state_1f25.push_back( state_1f29);
	return isUnique;
}

bool Otherwise_1f20::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_1f20::processInputPackets( const Packets_t& states_1f21)
{
	for( Packets_t::const_iterator itState_1f26= states_1f21.begin(); itState_1f26!= states_1f21.end(); ++itState_1f26)
	{
		bool isUnique= isInputUnique( *itState_1f26);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1f26);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_1f32);
	}
}

bool Otherwise_1f20::patternMatcher( const Udm::Object& state_1f27)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1f27.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1f2c= CyPhyML::SignalFlow::State::Cast( state_1f27);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1f31;
		if( !isValidBound(boundObjs_1f31, state_1f2c, true))
			continue;
		currMatch.state_1f32= state_1f2c;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_1f20::outputAppender( const CyPhyML::SignalFlow::State& state_1f33)
{
	_state_1f24->push_back( state_1f33);
}

void CreateRootFunction_1f53::operator()( const Packets_t& states_1f54, const Packets_t& programs_1f56, Packets_t& states_1f58, Packets_t& programs_1f59)
{
#ifdef PRINT_INFO
	printLog( "CreateRootFunction_1f53" );
#endif
	_state_1f5a= &states_1f58;
	_program_1f5b= &programs_1f59;
	if( ( !states_1f54.empty())&& ( !programs_1f56.empty()))
		callCreateRootFunction_21ed( states_1f54, programs_1f56);
	_state_1f5a->insert( _state_1f5a->end(), states_1f54.begin(), states_1f54.end());
	_program_1f5b->insert( _program_1f5b->end(), programs_1f56.begin(), programs_1f56.end());
}

void CreateRootFunction_1f53::callCreateRootFunction_21ed( const Packets_t& states_1f83, const Packets_t& programs_1f86)
{
	Packets_t states_1f85;
	Packets_t rootFunctions_1f88;
	CreateRootFunction_1f82 createRootFunction_1f82;
	createRootFunction_1f82( states_1f83, programs_1f86, states_1f85, rootFunctions_1f88);
	if( ( !states_1f85.empty())&& ( !rootFunctions_1f88.empty()))
		callCreateInputArgs_21f0( states_1f85, rootFunctions_1f88);
}

void CreateRootFunction_1f53::callCreateInputArgs_21f0( const Packets_t& states_1fa9, const Packets_t& rootFxns_1fab)
{
	Packets_t states_1fad;
	Packets_t rootFxns_1fae;
	CreateInputArgs_1fa8 createInputArgs_1fa8;
	createInputArgs_1fa8( states_1fa9, rootFxns_1fab, states_1fad, rootFxns_1fae);
	if( ( !states_1fad.empty())&& ( !rootFxns_1fae.empty()))
		callCreateRootExecCall_21f3( states_1fad, rootFxns_1fae);
}

void CreateRootFunction_1f53::callCreateRootExecCall_21f3( const Packets_t& states_1f5d, const Packets_t& rootFunctions_1f60)
{
	Packets_t states_1f5f;
	Packets_t rootFunctions_1f62;
	CreateRootExecCall_1f5c createRootExecCall_1f5c;
	createRootExecCall_1f5c( states_1f5d, rootFunctions_1f60, states_1f5f, rootFunctions_1f62);
	if( ( !states_1f5f.empty())&& ( !rootFunctions_1f62.empty()))
		callCreateOutputArgs_21f6( states_1f5f, rootFunctions_1f62);
}

void CreateRootFunction_1f53::callCreateOutputArgs_21f6( const Packets_t& states_2119, const Packets_t& rootFxns_211b)
{
	Packets_t states_211d;
	Packets_t rootFxns_211e;
	CreateOutputArgs_2118 createOutputArgs_2118;
	createOutputArgs_2118( states_2119, rootFxns_211b, states_211d, rootFxns_211e);
}

void CreateRootExecCall_1f5c::operator()( const Packets_t& states_1f5d, const Packets_t& rootFunctions_1f60, Packets_t& states_1f5f, Packets_t& rootFunctions_1f62)
{
#ifdef PRINT_INFO
	printLog( "CreateRootExecCall_1f5c" );
#endif
	RTTGenerator::Instance()->generateRule(1407, "CreateRootExecCall");
	_state_1f63= &states_1f5f;
	_rootFunction_1f64= &rootFunctions_1f62;
	processInputPackets( states_1f5d, rootFunctions_1f60);
	forwardInputs( );
}

bool CreateRootExecCall_1f5c::isInputUnique( const Udm::Object& state_1f69, const Udm::Object& rootFunction_1f72)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1f6b= _state_1f65.begin(), itRootFunction_1f74= _rootFunction_1f6e.begin(); itState_1f6b!= _state_1f65.end(), itRootFunction_1f74!= _rootFunction_1f6e.end(); ++itState_1f6b, ++itRootFunction_1f74)
	{
		if( ( *itState_1f6b== state_1f69)&& ( *itRootFunction_1f74== rootFunction_1f72))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1f65.push_back( state_1f69);
		_rootFunction_1f6e.push_back( rootFunction_1f72);
	}
	return isUnique;
}

bool CreateRootExecCall_1f5c::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateRootExecCall_1f5c::processInputPackets( const Packets_t& states_1f5d, const Packets_t& rootFunctions_1f60)
{
	for( Packets_t::const_iterator itState_1f66= states_1f5d.begin(), itRootFunction_1f6f= rootFunctions_1f60.begin(); itState_1f66!= states_1f5d.end(), itRootFunction_1f6f!= rootFunctions_1f60.end(); ++itState_1f66, ++itRootFunction_1f6f)
	{
		bool isUnique= isInputUnique( *itState_1f66, *itRootFunction_1f6f);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1f66, *itRootFunction_1f6f);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateRootExecCall_1f5c::patternMatcher( const Udm::Object& state_1f67, const Udm::Object& rootFunction_1f70)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1f67.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1f6c= CyPhyML::SignalFlow::State::Cast( state_1f67);
		if( false== Uml::IsDerivedFrom( rootFunction_1f70.type(), SFC::Function::meta))
			continue;
		SFC::Function rootFunction_1f75= SFC::Function::Cast( rootFunction_1f70);
		set< SFC::Function> execs_1f77= state_1f6c.exec();
		for( set< SFC::Function>::const_iterator itExecs_1f78= execs_1f77.begin(); itExecs_1f78!= execs_1f77.end(); ++itExecs_1f78)
		{
			SFC::Function currExec_1f79= *itExecs_1f78;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1f7d;
			if( !isValidBound(boundObjs_1f7d, state_1f6c, true))
				continue;
			currMatch.state_1f7e= state_1f6c;
			if( !isValidBound(boundObjs_1f7d, rootFunction_1f75, true))
				continue;
			currMatch.rootFunction_1f7f= rootFunction_1f75;
			if( !isValidBound(boundObjs_1f7d, currExec_1f79, false))
				continue;
			currMatch.exec_1f80= currExec_1f79;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateRootExecCall_1f5c::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::FunctionCall newFunctionCall_1f81= SFC::FunctionCall::Create( currMatch.rootFunction_1f7f, SFC::Function::meta_stmnt);
		SFC::Function& Exec= currMatch.exec_1f80;
		SFC::FunctionCall& FunctionCall= newFunctionCall_1f81;
		SFC::Function& RootFunction= currMatch.rootFunction_1f7f;
		CyPhyML::SignalFlow::State& State= currMatch.state_1f7e;
		{
FunctionCall.RefId() = RootFunction.RefId();
};
		{
__int64 statementCount = RootFunction.statementCount();
FunctionCall.statementIndex() = statementCount++;
RootFunction.statementCount() = statementCount;
};
		newFunctionCall_1f81.callee()= currMatch.exec_1f80;
	}
}

void CreateRootExecCall_1f5c::forwardInputs()
{
	*_state_1f63= _state_1f65;
	*_rootFunction_1f64= _rootFunction_1f6e;
}

void CreateRootFunction_1f82::operator()( const Packets_t& states_1f83, const Packets_t& programs_1f86, Packets_t& states_1f85, Packets_t& rootFunctions_1f88)
{
#ifdef PRINT_INFO
	printLog( "CreateRootFunction_1f82" );
#endif
	RTTGenerator::Instance()->generateRule(1417, "CreateRootFunction");
	_state_1f89= &states_1f85;
	_rootFunction_1f8a= &rootFunctions_1f88;
	processInputPackets( states_1f83, programs_1f86);
}

bool CreateRootFunction_1f82::isInputUnique( const Udm::Object& state_1f8f, const Udm::Object& program_1f98)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1f91= _state_1f8b.begin(), itProgram_1f9a= _program_1f94.begin(); itState_1f91!= _state_1f8b.end(), itProgram_1f9a!= _program_1f94.end(); ++itState_1f91, ++itProgram_1f9a)
	{
		if( ( *itState_1f91== state_1f8f)&& ( *itProgram_1f9a== program_1f98))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1f8b.push_back( state_1f8f);
		_program_1f94.push_back( program_1f98);
	}
	return isUnique;
}

bool CreateRootFunction_1f82::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateRootFunction_1f82::processInputPackets( const Packets_t& states_1f83, const Packets_t& programs_1f86)
{
	for( Packets_t::const_iterator itState_1f8c= states_1f83.begin(), itProgram_1f95= programs_1f86.begin(); itState_1f8c!= states_1f83.end(), itProgram_1f95!= programs_1f86.end(); ++itState_1f8c, ++itProgram_1f95)
	{
		bool isUnique= isInputUnique( *itState_1f8c, *itProgram_1f95);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1f8c, *itProgram_1f95);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateRootFunction_1f82::patternMatcher( const Udm::Object& state_1f8d, const Udm::Object& program_1f96)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1f8d.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1f92= CyPhyML::SignalFlow::State::Cast( state_1f8d);
		if( false== Uml::IsDerivedFrom( program_1f96.type(), SFC::Program::meta))
			continue;
		SFC::Program program_1f9b= SFC::Program::Cast( program_1f96);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1fa0;
		if( !isValidBound(boundObjs_1fa0, state_1f92, true))
			continue;
		currMatch.state_1fa1= state_1f92;
		if( !isValidBound(boundObjs_1fa0, program_1f9b, true))
			continue;
		currMatch.program_1fa2= program_1f9b;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateRootFunction_1f82::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function newRootFunction_1fa3= SFC::Function::Create( currMatch.program_1fa2);
		SFC::Program& Program= currMatch.program_1fa2;
		SFC::Function& RootFunction= newRootFunction_1fa3;
		CyPhyML::SignalFlow::State& State= currMatch.state_1fa1;
		{
RootFunction.RefId() = State.RefId();
};
		{
RootFunction.name() = static_cast< std::string >( State.name() ) + "_main";
};
		{
__int64 statementCount = Program.statementCount();
RootFunction.statementIndex() = statementCount++;
Program.statementCount() = statementCount;
};
		outputAppender( currMatch.state_1fa1, newRootFunction_1fa3);
	}
}

void CreateRootFunction_1f82::outputAppender( const CyPhyML::SignalFlow::State& state_1fa4, const SFC::Function& rootFunction_1fa6)
{
	_state_1f89->push_back( state_1fa4);
	_rootFunction_1f8a->push_back( rootFunction_1fa6);
}

void CreateInputArgs_1fa8::operator()( const Packets_t& states_1fa9, const Packets_t& rootFxns_1fab, Packets_t& states_1fad, Packets_t& rootFxns_1fae)
{
#ifdef PRINT_INFO
	printLog( "CreateInputArgs_1fa8" );
#endif
	_state_1faf= &states_1fad;
	_rootFxn_1fb0= &rootFxns_1fae;
	_state_1faf->insert( _state_1faf->end(), states_1fa9.begin(), states_1fa9.end());
	_rootFxn_1fb0->insert( _rootFxn_1fb0->end(), rootFxns_1fab.begin(), rootFxns_1fab.end());
	if( ( !states_1fa9.empty())&& ( !rootFxns_1fab.empty()))
		callCheckStateDecomp_2109( states_1fa9, rootFxns_1fab);
}

void CreateInputArgs_1fa8::callCheckStateDecomp_2109( const Packets_t& states_20a3, const Packets_t& programs_20a5)
{
	Packets_t states_20a7;
	Packets_t programs_20a8;
	Packets_t states_20a9;
	Packets_t programs_20aa;
	CheckStateDecomp_20a2 checkStateDecomp_20a2;
	checkStateDecomp_20a2( states_20a3, programs_20a5, states_20a7, programs_20a8, states_20a9, programs_20aa);
	if( ( !states_20a7.empty())&& ( !programs_20a8.empty()))
		callGetSubStates_210c( states_20a7, programs_20a8);
	if( ( !states_20a9.empty())&& ( !programs_20aa.empty()))
		callCreateIDArgs_210f( states_20a9, programs_20aa);
}

void CreateInputArgs_1fa8::callGetSubStates_210c( const Packets_t& states_c8c, const Packets_t& parStmnts_c8f)
{
	Packets_t subStates_c8e;
	Packets_t parStmnts_c91;
	GetSubStates_c8b getSubStates_c8b;
	getSubStates_c8b( states_c8c, parStmnts_c8f, subStates_c8e, parStmnts_c91);
	if( ( !subStates_c8e.empty())&& ( !parStmnts_c91.empty()))
		callCheckStateDecomp_2109( subStates_c8e, parStmnts_c91);
}

void CreateInputArgs_1fa8::callCreateIDArgs_210f( const Packets_t& states_1fe3, const Packets_t& rootFxns_1fe5)
{
	Packets_t states_1fe7;
	Packets_t rootFxns_1fe8;
	CreateIDArgs_1fe2 createIDArgs_1fe2;
	createIDArgs_1fe2( states_1fe3, rootFxns_1fe5, states_1fe7, rootFxns_1fe8);
	if( ( !states_1fe7.empty())&& ( !rootFxns_1fe8.empty()))
		callCreateIEArgs_2112( states_1fe7, rootFxns_1fe8);
}

void CreateInputArgs_1fa8::callCreateIEArgs_2112( const Packets_t& states_2043, const Packets_t& rootFxns_2045)
{
	Packets_t states_2047;
	Packets_t rootFxns_2048;
	CreateIEArgs_2042 createIEArgs_2042;
	createIEArgs_2042( states_2043, rootFxns_2045, states_2047, rootFxns_2048);
	if( ( !states_2047.empty())&& ( !rootFxns_2048.empty()))
		callCreateLEInit_2115( states_2047, rootFxns_2048);
}

void CreateInputArgs_1fa8::callCreateLEInit_2115( const Packets_t& states_1fb2, const Packets_t& rootFunctions_1fb5)
{
	Packets_t states_1fb4;
	Packets_t rootFunctions_1fb7;
	CreateLEInit_1fb1 createLEInit_1fb1;
	createLEInit_1fb1( states_1fb2, rootFunctions_1fb5, states_1fb4, rootFunctions_1fb7);
	if( ( !states_1fb4.empty())&& ( !rootFunctions_1fb7.empty()))
		callGetSubStates_210c( states_1fb4, rootFunctions_1fb7);
}

void CreateLEInit_1fb1::operator()( const Packets_t& states_1fb2, const Packets_t& rootFunctions_1fb5, Packets_t& states_1fb4, Packets_t& rootFunctions_1fb7)
{
#ifdef PRINT_INFO
	printLog( "CreateLEInit_1fb1" );
#endif
	RTTGenerator::Instance()->generateRule(1430, "CreateLEInit");
	_state_1fb8= &states_1fb4;
	_rootFunction_1fb9= &rootFunctions_1fb7;
	processInputPackets( states_1fb2, rootFunctions_1fb5);
	forwardInputs( );
}

bool CreateLEInit_1fb1::isInputUnique( const Udm::Object& state_1fbe, const Udm::Object& rootFunction_1fc7)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1fc0= _state_1fba.begin(), itRootFunction_1fc9= _rootFunction_1fc3.begin(); itState_1fc0!= _state_1fba.end(), itRootFunction_1fc9!= _rootFunction_1fc3.end(); ++itState_1fc0, ++itRootFunction_1fc9)
	{
		if( ( *itState_1fc0== state_1fbe)&& ( *itRootFunction_1fc9== rootFunction_1fc7))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1fba.push_back( state_1fbe);
		_rootFunction_1fc3.push_back( rootFunction_1fc7);
	}
	return isUnique;
}

bool CreateLEInit_1fb1::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool CreateLEInit_1fb1::isGuardTrue( CyPhyML::SignalFlow::Event& Event, SFC::LocalVar& LocalVar, SFC::Function& RootFunction, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Event.Scope() ) == "LOCAL_EVENT";;
	return Gz_guard;
}

void CreateLEInit_1fb1::processInputPackets( const Packets_t& states_1fb2, const Packets_t& rootFunctions_1fb5)
{
	for( Packets_t::const_iterator itState_1fbb= states_1fb2.begin(), itRootFunction_1fc4= rootFunctions_1fb5.begin(); itState_1fbb!= states_1fb2.end(), itRootFunction_1fc4!= rootFunctions_1fb5.end(); ++itState_1fbb, ++itRootFunction_1fc4)
	{
		bool isUnique= isInputUnique( *itState_1fbb, *itRootFunction_1fc4);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1fbb, *itRootFunction_1fc4);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateLEInit_1fb1::patternMatcher( const Udm::Object& state_1fbc, const Udm::Object& rootFunction_1fc5)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1fbc.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1fc1= CyPhyML::SignalFlow::State::Cast( state_1fbc);
		if( false== Uml::IsDerivedFrom( rootFunction_1fc5.type(), SFC::Function::meta))
			continue;
		SFC::Function rootFunction_1fca= SFC::Function::Cast( rootFunction_1fc5);
		set< CyPhyML::SignalFlow::Event> events_1fcc= state_1fc1.Event_kind_children();
		for( set< CyPhyML::SignalFlow::Event>::const_iterator itEvent_1fcd= events_1fcc.begin(); itEvent_1fcd!= events_1fcc.end(); ++itEvent_1fcd)
		{
			CyPhyML::SignalFlow::Event currEvent_1fce= *itEvent_1fcd;
			set< SFC::LocalVar> localVars_1fcf= currEvent_1fce.src();
			for( set< SFC::LocalVar>::const_iterator itLocalVars_1fd0= localVars_1fcf.begin(); itLocalVars_1fd0!= localVars_1fcf.end(); ++itLocalVars_1fd0)
			{
				SFC::LocalVar currLocalVar_1fd1= *itLocalVars_1fd0;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_1fd5;
				if( !isValidBound(boundObjs_1fd5, state_1fc1, true))
					continue;
				currMatch.state_1fd6= state_1fc1;
				if( !isValidBound(boundObjs_1fd5, rootFunction_1fca, true))
					continue;
				currMatch.rootFunction_1fd7= rootFunction_1fca;
				if( !isValidBound(boundObjs_1fd5, currEvent_1fce, false))
					continue;
				currMatch.event_1fd8= currEvent_1fce;
				if( !isValidBound(boundObjs_1fd5, currLocalVar_1fd1, false))
					continue;
				currMatch.localVar_1fd9= currLocalVar_1fd1;
				bool Gz_guard= isGuardTrue( currMatch.event_1fd8, currMatch.localVar_1fd9, currMatch.rootFunction_1fd7, currMatch.state_1fd6);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void CreateLEInit_1fb1::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::UserCode newInitEventCode_1fde= SFC::UserCode::Create( currMatch.rootFunction_1fd7, SFC::Function::meta_stmnt);
		SFC::BinaryExprs newBinaryExprs_1fdf= SFC::BinaryExprs::Create( newInitEventCode_1fde, SFC::UserCode::meta_codeexpr);
		SFC::Int newInt_1fe0= SFC::Int::Create( newBinaryExprs_1fdf, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef_1fe1= SFC::ArgDeclRef::Create( newBinaryExprs_1fdf, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_1fe1;
		SFC::BinaryExprs& BinaryExprs= newBinaryExprs_1fdf;
		CyPhyML::SignalFlow::Event& Event= currMatch.event_1fd8;
		SFC::UserCode& InitEventCode= newInitEventCode_1fde;
		SFC::Int& Int= newInt_1fe0;
		SFC::LocalVar& LocalVar= currMatch.localVar_1fd9;
		SFC::Function& RootFunction= currMatch.rootFunction_1fd7;
		CyPhyML::SignalFlow::State& State= currMatch.state_1fd6;
		{
InitEventCode.RefId() = RootFunction.RefId();
};
		{
__int64 statementCount = RootFunction.statementCount();
InitEventCode.statementIndex() = statementCount++;
RootFunction.statementCount() = statementCount;
};
		{
Int.val() = 0;
};
		{
BinaryExprs.op() = "=";
};
		newArgDeclRef_1fe1.argdecl()= currMatch.localVar_1fd9;
	}
}

void CreateLEInit_1fb1::forwardInputs()
{
	*_state_1fb8= _state_1fba;
	*_rootFunction_1fb9= _rootFunction_1fc3;
}

void CreateIDArgs_1fe2::operator()( const Packets_t& states_1fe3, const Packets_t& rootFxns_1fe5, Packets_t& states_1fe7, Packets_t& rootFxns_1fe8)
{
#ifdef PRINT_INFO
	printLog( "CreateIDArgs_1fe2" );
#endif
	_state_1fe9= &states_1fe7;
	_rootFxn_1fea= &rootFxns_1fe8;
	_state_1fe9->insert( _state_1fe9->end(), states_1fe3.begin(), states_1fe3.end());
	_rootFxn_1fea->insert( _rootFxn_1fea->end(), rootFxns_1fe5.begin(), rootFxns_1fe5.end());
	if( ( !states_1fe3.empty())&& ( !rootFxns_1fe5.empty()))
		callGetInData_203c( states_1fe3, rootFxns_1fe5);
}

void CreateIDArgs_1fe2::callGetInData_203c( const Packets_t& states_2012, const Packets_t& rootFunctions_2014)
{
	Packets_t datas_2011;
	Packets_t rootFunctions_2016;
	GetInData_2010 getInData_2010;
	getInData_2010( states_2012, rootFunctions_2014, datas_2011, rootFunctions_2016);
	if( ( !datas_2011.empty())&& ( !rootFunctions_2016.empty()))
		callCreateIDArg_203f( datas_2011, rootFunctions_2016);
}

void CreateIDArgs_1fe2::callCreateIDArg_203f( const Packets_t& datas_1fec, const Packets_t& rootFunctions_1fee)
{
	CreateIDArg_1feb createIDArg_1feb;
	createIDArg_1feb( datas_1fec, rootFunctions_1fee);
}

void CreateIDArg_1feb::operator()( const Packets_t& datas_1fec, const Packets_t& rootFunctions_1fee)
{
#ifdef PRINT_INFO
	printLog( "CreateIDArg_1feb" );
#endif
	RTTGenerator::Instance()->generateRule(1455, "CreateIDArg");
	processInputPackets( datas_1fec, rootFunctions_1fee);
}

bool CreateIDArg_1feb::isInputUnique( const Udm::Object& data_1ff4, const Udm::Object& rootFunction_1ffd)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itData_1ff6= _data_1ff0.begin(), itRootFunction_1fff= _rootFunction_1ff9.begin(); itData_1ff6!= _data_1ff0.end(), itRootFunction_1fff!= _rootFunction_1ff9.end(); ++itData_1ff6, ++itRootFunction_1fff)
	{
		if( ( *itData_1ff6== data_1ff4)&& ( *itRootFunction_1fff== rootFunction_1ffd))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_data_1ff0.push_back( data_1ff4);
		_rootFunction_1ff9.push_back( rootFunction_1ffd);
	}
	return isUnique;
}

bool CreateIDArg_1feb::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateIDArg_1feb::processInputPackets( const Packets_t& datas_1fec, const Packets_t& rootFunctions_1fee)
{
	for( Packets_t::const_iterator itData_1ff1= datas_1fec.begin(), itRootFunction_1ffa= rootFunctions_1fee.begin(); itData_1ff1!= datas_1fec.end(), itRootFunction_1ffa!= rootFunctions_1fee.end(); ++itData_1ff1, ++itRootFunction_1ffa)
	{
		bool isUnique= isInputUnique( *itData_1ff1, *itRootFunction_1ffa);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itData_1ff1, *itRootFunction_1ffa);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateIDArg_1feb::patternMatcher( const Udm::Object& data_1ff2, const Udm::Object& rootFunction_1ffb)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( data_1ff2.type(), CyPhyML::SignalFlow::Data::meta))
			continue;
		CyPhyML::SignalFlow::Data data_1ff7= CyPhyML::SignalFlow::Data::Cast( data_1ff2);
		if( false== Uml::IsDerivedFrom( rootFunction_1ffb.type(), SFC::Function::meta))
			continue;
		SFC::Function rootFunction_2000= SFC::Function::Cast( rootFunction_1ffb);
		set< SFC::LocalVar> localVars_2002= data_1ff7.src();
		for( set< SFC::LocalVar>::const_iterator itLocalVars_2003= localVars_2002.begin(); itLocalVars_2003!= localVars_2002.end(); ++itLocalVars_2003)
		{
			SFC::LocalVar currLocalVar_2004= *itLocalVars_2003;
			SFC::DT dT_2005= currLocalVar_2004.dt();
			if( !dT_2005)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_2009;
			if( !isValidBound(boundObjs_2009, data_1ff7, true))
				continue;
			currMatch.data_200a= data_1ff7;
			if( !isValidBound(boundObjs_2009, rootFunction_2000, true))
				continue;
			currMatch.rootFunction_200b= rootFunction_2000;
			if( !isValidBound(boundObjs_2009, currLocalVar_2004, false))
				continue;
			currMatch.localVar_200c= currLocalVar_2004;
			if( !isValidBound(boundObjs_2009, dT_2005, false))
				continue;
			currMatch.dT_200d= dT_2005;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateIDArg_1feb::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_200e= SFC::Arg::Create( currMatch.rootFunction_200b);
		SFC::SetVar newSetVar_200f= SFC::SetVar::Create( currMatch.rootFunction_200b);
		SFC::Arg& Arg= newArg_200e;
		SFC::DT& DT= currMatch.dT_200d;
		CyPhyML::SignalFlow::Data& Data= currMatch.data_200a;
		SFC::LocalVar& LocalVar= currMatch.localVar_200c;
		SFC::Function& RootFunction= currMatch.rootFunction_200b;
		SFC::SetVar& SetVar= newSetVar_200f;
		{
Arg.RefId() = SetVar.RefId() = LocalVar.RefId();
};
		{
Arg.name() = static_cast< std::string >( Data.Name() ) + "_";
Arg.indexBase() = Data.ArrayFirstIndex();
};
		{
__int64 argCount = RootFunction.argCount();
Arg.argIndex() = argCount++;
RootFunction.argCount() = argCount;
};
		{
__int64 statementCount = RootFunction.statementCount();
SetVar.statementIndex() = statementCount++;
RootFunction.statementCount() = statementCount;
};
		newArg_200e.dt()= currMatch.dT_200d;
		newSetVar_200f.arg_end()= newArg_200e;
		newSetVar_200f.lvar_end()= currMatch.localVar_200c;
	}
}

void GetInData_2010::operator()( const Packets_t& states_2012, const Packets_t& rootFunctions_2014, Packets_t& datas_2011, Packets_t& rootFunctions_2016)
{
#ifdef PRINT_INFO
	printLog( "GetInData_2010" );
#endif
	RTTGenerator::Instance()->generateRule(1473, "GetInData");
	_data_2017= &datas_2011;
	_rootFunction_2018= &rootFunctions_2016;
	processInputPackets( states_2012, rootFunctions_2014);
	sortOutputs( );
}

bool GetInData_2010::isInputUnique( const Udm::Object& state_201d, const Udm::Object& rootFunction_2026)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_201f= _state_2019.begin(), itRootFunction_2028= _rootFunction_2022.begin(); itState_201f!= _state_2019.end(), itRootFunction_2028!= _rootFunction_2022.end(); ++itState_201f, ++itRootFunction_2028)
	{
		if( ( *itState_201f== state_201d)&& ( *itRootFunction_2028== rootFunction_2026))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_2019.push_back( state_201d);
		_rootFunction_2022.push_back( rootFunction_2026);
	}
	return isUnique;
}

bool GetInData_2010::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool GetInData_2010::isGuardTrue( CyPhyML::SignalFlow::Data& Data, SFC::Function& RootFunction, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Data.Scope() ) == "INPUT_DATA";;
	return Gz_guard;
}

void GetInData_2010::processInputPackets( const Packets_t& states_2012, const Packets_t& rootFunctions_2014)
{
	for( Packets_t::const_iterator itState_201a= states_2012.begin(), itRootFunction_2023= rootFunctions_2014.begin(); itState_201a!= states_2012.end(), itRootFunction_2023!= rootFunctions_2014.end(); ++itState_201a, ++itRootFunction_2023)
	{
		bool isUnique= isInputUnique( *itState_201a, *itRootFunction_2023);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_201a, *itRootFunction_2023);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetInData_2010::patternMatcher( const Udm::Object& state_201b, const Udm::Object& rootFunction_2024)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_201b.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_2020= CyPhyML::SignalFlow::State::Cast( state_201b);
		if( false== Uml::IsDerivedFrom( rootFunction_2024.type(), SFC::Function::meta))
			continue;
		SFC::Function rootFunction_2029= SFC::Function::Cast( rootFunction_2024);
		set< CyPhyML::SignalFlow::Data> datas_202b= state_2020.Data_kind_children();
		for( set< CyPhyML::SignalFlow::Data>::const_iterator itData_202c= datas_202b.begin(); itData_202c!= datas_202b.end(); ++itData_202c)
		{
			CyPhyML::SignalFlow::Data currData_202d= *itData_202c;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_2031;
			if( !isValidBound(boundObjs_2031, state_2020, true))
				continue;
			currMatch.state_2032= state_2020;
			if( !isValidBound(boundObjs_2031, rootFunction_2029, true))
				continue;
			currMatch.rootFunction_2033= rootFunction_2029;
			if( !isValidBound(boundObjs_2031, currData_202d, false))
				continue;
			currMatch.data_2034= currData_202d;
			bool Gz_guard= isGuardTrue( currMatch.data_2034, currMatch.rootFunction_2033, currMatch.state_2032);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetInData_2010::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.data_2034, currMatch.rootFunction_2033);
	}
}

void GetInData_2010::outputAppender( const CyPhyML::SignalFlow::Data& data_2038, const SFC::Function& rootFunction_203a)
{
	_data_2017->push_back( data_2038);
	_rootFunction_2018->push_back( rootFunction_203a);
}

void GetInData_2010::sortOutputs()
{
	typedef std::multiset< CyPhyML::SignalFlow::Data, std::pointer_to_binary_function< const CyPhyML::SignalFlow::Data&, const CyPhyML::SignalFlow::Data&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const CyPhyML::SignalFlow::Data&, const CyPhyML::SignalFlow::Data&, bool> ptr_DEOrder( DEOrder< CyPhyML::SignalFlow::Data>);
	SortedSet_t sortedSet( ptr_DEOrder);
	std::vector< int> permutationVector( _data_2017->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _data_2017->begin(); it!= _data_2017->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( CyPhyML::SignalFlow::Data::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _data_2017->begin());
	// order rest of the containers
	permutate( permutationVector, *_rootFunction_2018);
}

void CreateIEArgs_2042::operator()( const Packets_t& states_2043, const Packets_t& rootFxns_2045, Packets_t& states_2047, Packets_t& rootFxns_2048)
{
#ifdef PRINT_INFO
	printLog( "CreateIEArgs_2042" );
#endif
	_state_2049= &states_2047;
	_rootFxn_204a= &rootFxns_2048;
	_state_2049->insert( _state_2049->end(), states_2043.begin(), states_2043.end());
	_rootFxn_204a->insert( _rootFxn_204a->end(), rootFxns_2045.begin(), rootFxns_2045.end());
	if( ( !states_2043.empty())&& ( !rootFxns_2045.empty()))
		callGetInEvent_209c( states_2043, rootFxns_2045);
}

void CreateIEArgs_2042::callGetInEvent_209c( const Packets_t& states_2071, const Packets_t& rootFunctions_2074)
{
	Packets_t events_2073;
	Packets_t rootFunctions_2076;
	GetInEvent_2070 getInEvent_2070;
	getInEvent_2070( states_2071, rootFunctions_2074, events_2073, rootFunctions_2076);
	if( ( !events_2073.empty())&& ( !rootFunctions_2076.empty()))
		callCreateIEArg_209f( events_2073, rootFunctions_2076);
}

void CreateIEArgs_2042::callCreateIEArg_209f( const Packets_t& events_204c, const Packets_t& rootFunctions_204e)
{
	CreateIEArg_204b createIEArg_204b;
	createIEArg_204b( events_204c, rootFunctions_204e);
}

void CreateIEArg_204b::operator()( const Packets_t& events_204c, const Packets_t& rootFunctions_204e)
{
#ifdef PRINT_INFO
	printLog( "CreateIEArg_204b" );
#endif
	RTTGenerator::Instance()->generateRule(1483, "CreateIEArg");
	processInputPackets( events_204c, rootFunctions_204e);
}

bool CreateIEArg_204b::isInputUnique( const Udm::Object& event_2054, const Udm::Object& rootFunction_205d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itEvent_2056= _event_2050.begin(), itRootFunction_205f= _rootFunction_2059.begin(); itEvent_2056!= _event_2050.end(), itRootFunction_205f!= _rootFunction_2059.end(); ++itEvent_2056, ++itRootFunction_205f)
	{
		if( ( *itEvent_2056== event_2054)&& ( *itRootFunction_205f== rootFunction_205d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_event_2050.push_back( event_2054);
		_rootFunction_2059.push_back( rootFunction_205d);
	}
	return isUnique;
}

bool CreateIEArg_204b::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateIEArg_204b::processInputPackets( const Packets_t& events_204c, const Packets_t& rootFunctions_204e)
{
	for( Packets_t::const_iterator itEvent_2051= events_204c.begin(), itRootFunction_205a= rootFunctions_204e.begin(); itEvent_2051!= events_204c.end(), itRootFunction_205a!= rootFunctions_204e.end(); ++itEvent_2051, ++itRootFunction_205a)
	{
		bool isUnique= isInputUnique( *itEvent_2051, *itRootFunction_205a);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itEvent_2051, *itRootFunction_205a);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateIEArg_204b::patternMatcher( const Udm::Object& event_2052, const Udm::Object& rootFunction_205b)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( event_2052.type(), CyPhyML::SignalFlow::Event::meta))
			continue;
		CyPhyML::SignalFlow::Event event_2057= CyPhyML::SignalFlow::Event::Cast( event_2052);
		if( false== Uml::IsDerivedFrom( rootFunction_205b.type(), SFC::Function::meta))
			continue;
		SFC::Function rootFunction_2060= SFC::Function::Cast( rootFunction_205b);
		set< SFC::LocalVar> localVars_2062= event_2057.src();
		for( set< SFC::LocalVar>::const_iterator itLocalVars_2063= localVars_2062.begin(); itLocalVars_2063!= localVars_2062.end(); ++itLocalVars_2063)
		{
			SFC::LocalVar currLocalVar_2064= *itLocalVars_2063;
			SFC::DT dT_2065= currLocalVar_2064.dt();
			if( !dT_2065)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_2069;
			if( !isValidBound(boundObjs_2069, event_2057, true))
				continue;
			currMatch.event_206a= event_2057;
			if( !isValidBound(boundObjs_2069, rootFunction_2060, true))
				continue;
			currMatch.rootFunction_206b= rootFunction_2060;
			if( !isValidBound(boundObjs_2069, currLocalVar_2064, false))
				continue;
			currMatch.localVar_206c= currLocalVar_2064;
			if( !isValidBound(boundObjs_2069, dT_2065, false))
				continue;
			currMatch.dT_206d= dT_2065;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateIEArg_204b::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_206e= SFC::Arg::Create( currMatch.rootFunction_206b);
		SFC::SetVar newSetVar_206f= SFC::SetVar::Create( currMatch.rootFunction_206b);
		SFC::Arg& Arg= newArg_206e;
		SFC::DT& DT= currMatch.dT_206d;
		CyPhyML::SignalFlow::Event& Event= currMatch.event_206a;
		SFC::LocalVar& LocalVar= currMatch.localVar_206c;
		SFC::Function& RootFunction= currMatch.rootFunction_206b;
		SFC::SetVar& SetVar= newSetVar_206f;
		{
Arg.RefId() = SetVar.RefId() = LocalVar.RefId();
};
		{
Arg.name() = static_cast< std::string >( Event.Name() ) + "_";

};
		{
__int64 statementCount = RootFunction.statementCount();
SetVar.statementIndex() = statementCount++;
RootFunction.statementCount() = statementCount;
};
		{
__int64 argCount = RootFunction.argCount();
Arg.argIndex() = argCount++;
RootFunction.argCount() = argCount;
};
		newArg_206e.dt()= currMatch.dT_206d;
		newSetVar_206f.arg_end()= newArg_206e;
		newSetVar_206f.lvar_end()= currMatch.localVar_206c;
	}
}

void GetInEvent_2070::operator()( const Packets_t& states_2071, const Packets_t& rootFunctions_2074, Packets_t& events_2073, Packets_t& rootFunctions_2076)
{
#ifdef PRINT_INFO
	printLog( "GetInEvent_2070" );
#endif
	RTTGenerator::Instance()->generateRule(1501, "GetInEvent");
	_event_2077= &events_2073;
	_rootFunction_2078= &rootFunctions_2076;
	processInputPackets( states_2071, rootFunctions_2074);
	sortOutputs( );
}

bool GetInEvent_2070::isInputUnique( const Udm::Object& state_207d, const Udm::Object& rootFunction_2086)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_207f= _state_2079.begin(), itRootFunction_2088= _rootFunction_2082.begin(); itState_207f!= _state_2079.end(), itRootFunction_2088!= _rootFunction_2082.end(); ++itState_207f, ++itRootFunction_2088)
	{
		if( ( *itState_207f== state_207d)&& ( *itRootFunction_2088== rootFunction_2086))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_2079.push_back( state_207d);
		_rootFunction_2082.push_back( rootFunction_2086);
	}
	return isUnique;
}

bool GetInEvent_2070::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool GetInEvent_2070::isGuardTrue( CyPhyML::SignalFlow::Event& Event, SFC::Function& RootFunction, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Event.Scope() ) == "INPUT_EVENT";;
	return Gz_guard;
}

void GetInEvent_2070::processInputPackets( const Packets_t& states_2071, const Packets_t& rootFunctions_2074)
{
	for( Packets_t::const_iterator itState_207a= states_2071.begin(), itRootFunction_2083= rootFunctions_2074.begin(); itState_207a!= states_2071.end(), itRootFunction_2083!= rootFunctions_2074.end(); ++itState_207a, ++itRootFunction_2083)
	{
		bool isUnique= isInputUnique( *itState_207a, *itRootFunction_2083);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_207a, *itRootFunction_2083);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetInEvent_2070::patternMatcher( const Udm::Object& state_207b, const Udm::Object& rootFunction_2084)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_207b.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_2080= CyPhyML::SignalFlow::State::Cast( state_207b);
		if( false== Uml::IsDerivedFrom( rootFunction_2084.type(), SFC::Function::meta))
			continue;
		SFC::Function rootFunction_2089= SFC::Function::Cast( rootFunction_2084);
		set< CyPhyML::SignalFlow::Event> events_208b= state_2080.Event_kind_children();
		for( set< CyPhyML::SignalFlow::Event>::const_iterator itEvent_208c= events_208b.begin(); itEvent_208c!= events_208b.end(); ++itEvent_208c)
		{
			CyPhyML::SignalFlow::Event currEvent_208d= *itEvent_208c;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_2091;
			if( !isValidBound(boundObjs_2091, state_2080, true))
				continue;
			currMatch.state_2092= state_2080;
			if( !isValidBound(boundObjs_2091, rootFunction_2089, true))
				continue;
			currMatch.rootFunction_2093= rootFunction_2089;
			if( !isValidBound(boundObjs_2091, currEvent_208d, false))
				continue;
			currMatch.event_2094= currEvent_208d;
			bool Gz_guard= isGuardTrue( currMatch.event_2094, currMatch.rootFunction_2093, currMatch.state_2092);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetInEvent_2070::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.event_2094, currMatch.rootFunction_2093);
	}
}

void GetInEvent_2070::outputAppender( const CyPhyML::SignalFlow::Event& event_2098, const SFC::Function& rootFunction_209a)
{
	_event_2077->push_back( event_2098);
	_rootFunction_2078->push_back( rootFunction_209a);
}

void GetInEvent_2070::sortOutputs()
{
	typedef std::multiset< CyPhyML::SignalFlow::Event, std::pointer_to_binary_function< const CyPhyML::SignalFlow::Event&, const CyPhyML::SignalFlow::Event&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const CyPhyML::SignalFlow::Event&, const CyPhyML::SignalFlow::Event&, bool> ptr_DEOrder( DEOrder< CyPhyML::SignalFlow::Event>);
	SortedSet_t sortedSet( ptr_DEOrder);
	std::vector< int> permutationVector( _event_2077->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _event_2077->begin(); it!= _event_2077->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( CyPhyML::SignalFlow::Event::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _event_2077->begin());
	// order rest of the containers
	permutate( permutationVector, *_rootFunction_2078);
}

void CheckStateDecomp_20a2::operator()( const Packets_t& states_20a3, const Packets_t& programs_20a5, Packets_t& states_20a7, Packets_t& programs_20a8, Packets_t& states_20a9, Packets_t& programs_20aa)
{
#ifdef PRINT_INFO
	printLog( "CheckStateDecomp_20a2" );
#endif
	_state_20ab= &states_20a7;
	_program_20ac= &programs_20a8;
	_state_20ad= &states_20a9;
	_program_20ae= &programs_20aa;
	for( Packets_t::const_iterator itstate_20b0= states_20a3.begin(), itprogram_20b7= programs_20a5.begin(); itstate_20b0!= states_20a3.end(), itprogram_20b7!= programs_20a5.end(); ++itstate_20b0, ++itprogram_20b7)
	{
		bool isUnique= isInputUnique( *itstate_20b0, *itprogram_20b7);
		if( !isUnique)
			continue;
		Packets_t onestate_20b4( 1, *itstate_20b0);
		Packets_t oneprogram_20bb( 1, *itprogram_20b7);
		executeOne( onestate_20b4, oneprogram_20bb);
	}
}

void CheckStateDecomp_20a2::executeOne( const Packets_t& states_20a3, const Packets_t& programs_20a5)
{
	Packets_t states_20c0;
	Packets_t programs_20c3;
	IsFuncState_20bd isFuncState_20bd;
	bool isMatchIsFuncState_20bd= isFuncState_20bd( states_20a3, programs_20a5, states_20c0, programs_20c3);
	_state_20ab->insert( _state_20ab->end(), states_20c0.begin(), states_20c0.end());
	_program_20ac->insert( _program_20ac->end(), programs_20c3.begin(), programs_20c3.end());
	if( isMatchIsFuncState_20bd)
		return;
	Packets_t states_20e7;
	Packets_t programs_20ea;
	Otherwise_20e4 otherwise_20e4;
	bool isMatchOtherwise_20e4= otherwise_20e4( states_20a3, programs_20a5, states_20e7, programs_20ea);
	_state_20ad->insert( _state_20ad->end(), states_20e7.begin(), states_20e7.end());
	_program_20ae->insert( _program_20ae->end(), programs_20ea.begin(), programs_20ea.end());
}

bool CheckStateDecomp_20a2::isInputUnique( const Udm::Object& state_20b1, const Udm::Object& program_20b8)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_20b3= _state_20af.begin(), itprogram_20ba= _program_20b6.begin(); itstate_20b3!= _state_20af.end(), itprogram_20ba!= _program_20b6.end(); ++itstate_20b3, ++itprogram_20ba)
	{
		if( ( *itstate_20b3== state_20b1)&& ( *itprogram_20ba== program_20b8))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_20af.push_back( state_20b1);
		_program_20b6.push_back( program_20b8);
	}
	return isUnique;
}

bool IsFuncState_20bd::operator()( const Packets_t& states_20be, const Packets_t& programs_20c1, Packets_t& states_20c0, Packets_t& programs_20c3)
{
#ifdef PRINT_INFO
	printLog( "IsFuncState_20bd" );
#endif
	_state_20c4= &states_20c0;
	_program_20c5= &programs_20c3;
	processInputPackets( states_20be, programs_20c1);
	if( false== _matches.empty())
		return true;
	return false;
}

bool IsFuncState_20bd::isInputUnique( const Udm::Object& state_20ca, const Udm::Object& program_20d3)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_20cc= _state_20c6.begin(), itProgram_20d5= _program_20cf.begin(); itState_20cc!= _state_20c6.end(), itProgram_20d5!= _program_20cf.end(); ++itState_20cc, ++itProgram_20d5)
	{
		if( ( *itState_20cc== state_20ca)&& ( *itProgram_20d5== program_20d3))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_20c6.push_back( state_20ca);
		_program_20cf.push_back( program_20d3);
	}
	return isUnique;
}

bool IsFuncState_20bd::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool IsFuncState_20bd::isGuardTrue( SFC::CompoundStatement& Program, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	return static_cast< std::string >( State.Decomposition() ) == "FUNC_STATE";;
	return Gz_guard;
}

void IsFuncState_20bd::processInputPackets( const Packets_t& states_20be, const Packets_t& programs_20c1)
{
	for( Packets_t::const_iterator itState_20c7= states_20be.begin(), itProgram_20d0= programs_20c1.begin(); itState_20c7!= states_20be.end(), itProgram_20d0!= programs_20c1.end(); ++itState_20c7, ++itProgram_20d0)
	{
		bool isUnique= isInputUnique( *itState_20c7, *itProgram_20d0);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_20c7, *itProgram_20d0);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_20dc, currMatch.program_20dd);
	}
}

bool IsFuncState_20bd::patternMatcher( const Udm::Object& state_20c8, const Udm::Object& program_20d1)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_20c8.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_20cd= CyPhyML::SignalFlow::State::Cast( state_20c8);
		if( false== Uml::IsDerivedFrom( program_20d1.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement program_20d6= SFC::CompoundStatement::Cast( program_20d1);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_20db;
		if( !isValidBound(boundObjs_20db, state_20cd, true))
			continue;
		currMatch.state_20dc= state_20cd;
		if( !isValidBound(boundObjs_20db, program_20d6, true))
			continue;
		currMatch.program_20dd= program_20d6;
		bool Gz_guard= isGuardTrue( currMatch.program_20dd, currMatch.state_20dc);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void IsFuncState_20bd::outputAppender( const CyPhyML::SignalFlow::State& state_20e0, const SFC::CompoundStatement& program_20e2)
{
	_state_20c4->push_back( state_20e0);
	_program_20c5->push_back( program_20e2);
}

bool Otherwise_20e4::operator()( const Packets_t& states_20e5, const Packets_t& programs_20e8, Packets_t& states_20e7, Packets_t& programs_20ea)
{
#ifdef PRINT_INFO
	printLog( "Otherwise_20e4" );
#endif
	_state_20eb= &states_20e7;
	_program_20ec= &programs_20ea;
	processInputPackets( states_20e5, programs_20e8);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_20e4::isInputUnique( const Udm::Object& state_20f1, const Udm::Object& program_20fa)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_20f3= _state_20ed.begin(), itProgram_20fc= _program_20f6.begin(); itState_20f3!= _state_20ed.end(), itProgram_20fc!= _program_20f6.end(); ++itState_20f3, ++itProgram_20fc)
	{
		if( ( *itState_20f3== state_20f1)&& ( *itProgram_20fc== program_20fa))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_20ed.push_back( state_20f1);
		_program_20f6.push_back( program_20fa);
	}
	return isUnique;
}

bool Otherwise_20e4::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_20e4::processInputPackets( const Packets_t& states_20e5, const Packets_t& programs_20e8)
{
	for( Packets_t::const_iterator itState_20ee= states_20e5.begin(), itProgram_20f7= programs_20e8.begin(); itState_20ee!= states_20e5.end(), itProgram_20f7!= programs_20e8.end(); ++itState_20ee, ++itProgram_20f7)
	{
		bool isUnique= isInputUnique( *itState_20ee, *itProgram_20f7);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_20ee, *itProgram_20f7);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_2103, currMatch.program_2104);
	}
}

bool Otherwise_20e4::patternMatcher( const Udm::Object& state_20ef, const Udm::Object& program_20f8)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_20ef.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_20f4= CyPhyML::SignalFlow::State::Cast( state_20ef);
		if( false== Uml::IsDerivedFrom( program_20f8.type(), SFC::CompoundStatement::meta))
			continue;
		SFC::CompoundStatement program_20fd= SFC::CompoundStatement::Cast( program_20f8);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2102;
		if( !isValidBound(boundObjs_2102, state_20f4, true))
			continue;
		currMatch.state_2103= state_20f4;
		if( !isValidBound(boundObjs_2102, program_20fd, true))
			continue;
		currMatch.program_2104= program_20fd;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_20e4::outputAppender( const CyPhyML::SignalFlow::State& state_2105, const SFC::CompoundStatement& program_2107)
{
	_state_20eb->push_back( state_2105);
	_program_20ec->push_back( program_2107);
}

void CreateOutputArgs_2118::operator()( const Packets_t& states_2119, const Packets_t& rootFxns_211b, Packets_t& states_211d, Packets_t& rootFxns_211e)
{
#ifdef PRINT_INFO
	printLog( "CreateOutputArgs_2118" );
#endif
	_state_211f= &states_211d;
	_rootFxn_2120= &rootFxns_211e;
	_state_211f->insert( _state_211f->end(), states_2119.begin(), states_2119.end());
	_rootFxn_2120->insert( _rootFxn_2120->end(), rootFxns_211b.begin(), rootFxns_211b.end());
	if( ( !states_2119.empty())&& ( !rootFxns_211b.empty()))
		callCheckStateDecomp_21e1( states_2119, rootFxns_211b);
}

void CreateOutputArgs_2118::callCheckStateDecomp_21e1( const Packets_t& states_20a3, const Packets_t& programs_20a5)
{
	Packets_t states_20a7;
	Packets_t programs_20a8;
	Packets_t states_20a9;
	Packets_t programs_20aa;
	CheckStateDecomp_20a2 checkStateDecomp_20a2;
	checkStateDecomp_20a2( states_20a3, programs_20a5, states_20a7, programs_20a8, states_20a9, programs_20aa);
	if( ( !states_20a7.empty())&& ( !programs_20a8.empty()))
		callGetSubStates_21e4( states_20a7, programs_20a8);
	if( ( !states_20a9.empty())&& ( !programs_20aa.empty()))
		callCreateODArgs_21e7( states_20a9, programs_20aa);
}

void CreateOutputArgs_2118::callGetSubStates_21e4( const Packets_t& states_c8c, const Packets_t& parStmnts_c8f)
{
	Packets_t subStates_c8e;
	Packets_t parStmnts_c91;
	GetSubStates_c8b getSubStates_c8b;
	getSubStates_c8b( states_c8c, parStmnts_c8f, subStates_c8e, parStmnts_c91);
	if( ( !subStates_c8e.empty())&& ( !parStmnts_c91.empty()))
		callCheckStateDecomp_21e1( subStates_c8e, parStmnts_c91);
}

void CreateOutputArgs_2118::callCreateODArgs_21e7( const Packets_t& states_2122, const Packets_t& rootFxns_2124)
{
	Packets_t states_2126;
	Packets_t rootFxns_2127;
	CreateODArgs_2121 createODArgs_2121;
	createODArgs_2121( states_2122, rootFxns_2124, states_2126, rootFxns_2127);
	if( ( !states_2126.empty())&& ( !rootFxns_2127.empty()))
		callCreateOEArgs_21ea( states_2126, rootFxns_2127);
}

void CreateOutputArgs_2118::callCreateOEArgs_21ea( const Packets_t& states_2182, const Packets_t& rootFxns_2184)
{
	Packets_t states_2186;
	Packets_t rootFxns_2187;
	CreateOEArgs_2181 createOEArgs_2181;
	createOEArgs_2181( states_2182, rootFxns_2184, states_2186, rootFxns_2187);
	if( ( !states_2186.empty())&& ( !rootFxns_2187.empty()))
		callGetSubStates_21e4( states_2186, rootFxns_2187);
}

void CreateODArgs_2121::operator()( const Packets_t& states_2122, const Packets_t& rootFxns_2124, Packets_t& states_2126, Packets_t& rootFxns_2127)
{
#ifdef PRINT_INFO
	printLog( "CreateODArgs_2121" );
#endif
	_state_2128= &states_2126;
	_rootFxn_2129= &rootFxns_2127;
	_state_2128->insert( _state_2128->end(), states_2122.begin(), states_2122.end());
	_rootFxn_2129->insert( _rootFxn_2129->end(), rootFxns_2124.begin(), rootFxns_2124.end());
	if( ( !states_2122.empty())&& ( !rootFxns_2124.empty()))
		callGetOutData_217b( states_2122, rootFxns_2124);
}

void CreateODArgs_2121::callGetOutData_217b( const Packets_t& states_212c, const Packets_t& rootFunctions_212e)
{
	Packets_t datas_212b;
	Packets_t rootFunctions_2130;
	GetOutData_212a getOutData_212a;
	getOutData_212a( states_212c, rootFunctions_212e, datas_212b, rootFunctions_2130);
	if( ( !datas_212b.empty())&& ( !rootFunctions_2130.empty()))
		callCreateODArg_217e( datas_212b, rootFunctions_2130);
}

void CreateODArgs_2121::callCreateODArg_217e( const Packets_t& datas_2157, const Packets_t& rootFunctions_2159)
{
	CreateODArg_2156 createODArg_2156;
	createODArg_2156( datas_2157, rootFunctions_2159);
}

void GetOutData_212a::operator()( const Packets_t& states_212c, const Packets_t& rootFunctions_212e, Packets_t& datas_212b, Packets_t& rootFunctions_2130)
{
#ifdef PRINT_INFO
	printLog( "GetOutData_212a" );
#endif
	RTTGenerator::Instance()->generateRule(1516, "GetOutData");
	_data_2131= &datas_212b;
	_rootFunction_2132= &rootFunctions_2130;
	processInputPackets( states_212c, rootFunctions_212e);
	sortOutputs( );
}

bool GetOutData_212a::isInputUnique( const Udm::Object& state_2137, const Udm::Object& rootFunction_2140)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_2139= _state_2133.begin(), itRootFunction_2142= _rootFunction_213c.begin(); itState_2139!= _state_2133.end(), itRootFunction_2142!= _rootFunction_213c.end(); ++itState_2139, ++itRootFunction_2142)
	{
		if( ( *itState_2139== state_2137)&& ( *itRootFunction_2142== rootFunction_2140))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_2133.push_back( state_2137);
		_rootFunction_213c.push_back( rootFunction_2140);
	}
	return isUnique;
}

bool GetOutData_212a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool GetOutData_212a::isGuardTrue( CyPhyML::SignalFlow::Data& Data, SFC::Function& RootFunction, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Data.Scope() ) == "OUTPUT_DATA";;
	return Gz_guard;
}

void GetOutData_212a::processInputPackets( const Packets_t& states_212c, const Packets_t& rootFunctions_212e)
{
	for( Packets_t::const_iterator itState_2134= states_212c.begin(), itRootFunction_213d= rootFunctions_212e.begin(); itState_2134!= states_212c.end(), itRootFunction_213d!= rootFunctions_212e.end(); ++itState_2134, ++itRootFunction_213d)
	{
		bool isUnique= isInputUnique( *itState_2134, *itRootFunction_213d);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_2134, *itRootFunction_213d);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetOutData_212a::patternMatcher( const Udm::Object& state_2135, const Udm::Object& rootFunction_213e)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_2135.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_213a= CyPhyML::SignalFlow::State::Cast( state_2135);
		if( false== Uml::IsDerivedFrom( rootFunction_213e.type(), SFC::Function::meta))
			continue;
		SFC::Function rootFunction_2143= SFC::Function::Cast( rootFunction_213e);
		set< CyPhyML::SignalFlow::Data> datas_2145= state_213a.Data_kind_children();
		for( set< CyPhyML::SignalFlow::Data>::const_iterator itData_2146= datas_2145.begin(); itData_2146!= datas_2145.end(); ++itData_2146)
		{
			CyPhyML::SignalFlow::Data currData_2147= *itData_2146;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_214b;
			if( !isValidBound(boundObjs_214b, state_213a, true))
				continue;
			currMatch.state_214c= state_213a;
			if( !isValidBound(boundObjs_214b, rootFunction_2143, true))
				continue;
			currMatch.rootFunction_214d= rootFunction_2143;
			if( !isValidBound(boundObjs_214b, currData_2147, false))
				continue;
			currMatch.data_214e= currData_2147;
			bool Gz_guard= isGuardTrue( currMatch.data_214e, currMatch.rootFunction_214d, currMatch.state_214c);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetOutData_212a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.data_214e, currMatch.rootFunction_214d);
	}
}

void GetOutData_212a::outputAppender( const CyPhyML::SignalFlow::Data& data_2152, const SFC::Function& rootFunction_2154)
{
	_data_2131->push_back( data_2152);
	_rootFunction_2132->push_back( rootFunction_2154);
}

void GetOutData_212a::sortOutputs()
{
	typedef std::multiset< CyPhyML::SignalFlow::Data, std::pointer_to_binary_function< const CyPhyML::SignalFlow::Data&, const CyPhyML::SignalFlow::Data&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const CyPhyML::SignalFlow::Data&, const CyPhyML::SignalFlow::Data&, bool> ptr_DEOrder( DEOrder< CyPhyML::SignalFlow::Data>);
	SortedSet_t sortedSet( ptr_DEOrder);
	std::vector< int> permutationVector( _data_2131->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _data_2131->begin(); it!= _data_2131->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( CyPhyML::SignalFlow::Data::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _data_2131->begin());
	// order rest of the containers
	permutate( permutationVector, *_rootFunction_2132);
}

void CreateODArg_2156::operator()( const Packets_t& datas_2157, const Packets_t& rootFunctions_2159)
{
#ifdef PRINT_INFO
	printLog( "CreateODArg_2156" );
#endif
	RTTGenerator::Instance()->generateRule(1521, "CreateODArg");
	processInputPackets( datas_2157, rootFunctions_2159);
}

bool CreateODArg_2156::isInputUnique( const Udm::Object& data_215f, const Udm::Object& rootFunction_2168)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itData_2161= _data_215b.begin(), itRootFunction_216a= _rootFunction_2164.begin(); itData_2161!= _data_215b.end(), itRootFunction_216a!= _rootFunction_2164.end(); ++itData_2161, ++itRootFunction_216a)
	{
		if( ( *itData_2161== data_215f)&& ( *itRootFunction_216a== rootFunction_2168))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_data_215b.push_back( data_215f);
		_rootFunction_2164.push_back( rootFunction_2168);
	}
	return isUnique;
}

bool CreateODArg_2156::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateODArg_2156::processInputPackets( const Packets_t& datas_2157, const Packets_t& rootFunctions_2159)
{
	for( Packets_t::const_iterator itData_215c= datas_2157.begin(), itRootFunction_2165= rootFunctions_2159.begin(); itData_215c!= datas_2157.end(), itRootFunction_2165!= rootFunctions_2159.end(); ++itData_215c, ++itRootFunction_2165)
	{
		bool isUnique= isInputUnique( *itData_215c, *itRootFunction_2165);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itData_215c, *itRootFunction_2165);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateODArg_2156::patternMatcher( const Udm::Object& data_215d, const Udm::Object& rootFunction_2166)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( data_215d.type(), CyPhyML::SignalFlow::Data::meta))
			continue;
		CyPhyML::SignalFlow::Data data_2162= CyPhyML::SignalFlow::Data::Cast( data_215d);
		if( false== Uml::IsDerivedFrom( rootFunction_2166.type(), SFC::Function::meta))
			continue;
		SFC::Function rootFunction_216b= SFC::Function::Cast( rootFunction_2166);
		set< SFC::LocalVar> localVars_216d= data_2162.src();
		for( set< SFC::LocalVar>::const_iterator itLocalVars_216e= localVars_216d.begin(); itLocalVars_216e!= localVars_216d.end(); ++itLocalVars_216e)
		{
			SFC::LocalVar currLocalVar_216f= *itLocalVars_216e;
			SFC::DT dT_2170= currLocalVar_216f.dt();
			if( !dT_2170)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_2174;
			if( !isValidBound(boundObjs_2174, data_2162, true))
				continue;
			currMatch.data_2175= data_2162;
			if( !isValidBound(boundObjs_2174, rootFunction_216b, true))
				continue;
			currMatch.rootFunction_2176= rootFunction_216b;
			if( !isValidBound(boundObjs_2174, currLocalVar_216f, false))
				continue;
			currMatch.localVar_2177= currLocalVar_216f;
			if( !isValidBound(boundObjs_2174, dT_2170, false))
				continue;
			currMatch.dT_2178= dT_2170;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateODArg_2156::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::SetVar newSetVar_2179= SFC::SetVar::Create( currMatch.rootFunction_2176);
		SFC::Arg newArg_217a= SFC::Arg::Create( currMatch.rootFunction_2176);
		SFC::Arg& Arg= newArg_217a;
		SFC::DT& DT= currMatch.dT_2178;
		CyPhyML::SignalFlow::Data& Data= currMatch.data_2175;
		SFC::LocalVar& LocalVar= currMatch.localVar_2177;
		SFC::Function& RootFunction= currMatch.rootFunction_2176;
		SFC::SetVar& SetVar= newSetVar_2179;
		{
Arg.RefId() = SetVar.RefId() = LocalVar.RefId();
};
		{
__int64 statementCount = RootFunction.statementCount();
SetVar.statementIndex() = statementCount++;
RootFunction.statementCount() = statementCount;
};
		{
__int64 argCount = RootFunction.argCount();
Arg.argIndex() = argCount++;
RootFunction.argCount() = argCount;
};
		{
Arg.name() = static_cast< std::string >( Data.Name() ) + "_";
Arg.indexBase() = Data.ArrayFirstIndex();
Arg.ptr() = true;
};
		{
SetVar.invert() = true;
};
		newArg_217a.dt()= currMatch.dT_2178;
		newSetVar_2179.arg_end()= newArg_217a;
		newSetVar_2179.lvar_end()= currMatch.localVar_2177;
	}
}

void CreateOEArgs_2181::operator()( const Packets_t& states_2182, const Packets_t& rootFxns_2184, Packets_t& states_2186, Packets_t& rootFxns_2187)
{
#ifdef PRINT_INFO
	printLog( "CreateOEArgs_2181" );
#endif
	_state_2188= &states_2186;
	_rootFxn_2189= &rootFxns_2187;
	_state_2188->insert( _state_2188->end(), states_2182.begin(), states_2182.end());
	_rootFxn_2189->insert( _rootFxn_2189->end(), rootFxns_2184.begin(), rootFxns_2184.end());
	if( ( !states_2182.empty())&& ( !rootFxns_2184.empty()))
		callGetOutEvent_21db( states_2182, rootFxns_2184);
}

void CreateOEArgs_2181::callGetOutEvent_21db( const Packets_t& states_218b, const Packets_t& rootFunctions_218e)
{
	Packets_t events_218d;
	Packets_t rootFunctions_2190;
	GetOutEvent_218a getOutEvent_218a;
	getOutEvent_218a( states_218b, rootFunctions_218e, events_218d, rootFunctions_2190);
	if( ( !events_218d.empty())&& ( !rootFunctions_2190.empty()))
		callCreateOEArg_21de( events_218d, rootFunctions_2190);
}

void CreateOEArgs_2181::callCreateOEArg_21de( const Packets_t& events_21b7, const Packets_t& rootFunctions_21b9)
{
	CreateOEArg_21b6 createOEArg_21b6;
	createOEArg_21b6( events_21b7, rootFunctions_21b9);
}

void GetOutEvent_218a::operator()( const Packets_t& states_218b, const Packets_t& rootFunctions_218e, Packets_t& events_218d, Packets_t& rootFunctions_2190)
{
#ifdef PRINT_INFO
	printLog( "GetOutEvent_218a" );
#endif
	RTTGenerator::Instance()->generateRule(1545, "GetOutEvent");
	_event_2191= &events_218d;
	_rootFunction_2192= &rootFunctions_2190;
	processInputPackets( states_218b, rootFunctions_218e);
	sortOutputs( );
}

bool GetOutEvent_218a::isInputUnique( const Udm::Object& state_2197, const Udm::Object& rootFunction_21a0)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_2199= _state_2193.begin(), itRootFunction_21a2= _rootFunction_219c.begin(); itState_2199!= _state_2193.end(), itRootFunction_21a2!= _rootFunction_219c.end(); ++itState_2199, ++itRootFunction_21a2)
	{
		if( ( *itState_2199== state_2197)&& ( *itRootFunction_21a2== rootFunction_21a0))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_2193.push_back( state_2197);
		_rootFunction_219c.push_back( rootFunction_21a0);
	}
	return isUnique;
}

bool GetOutEvent_218a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool GetOutEvent_218a::isGuardTrue( CyPhyML::SignalFlow::Event& Event, SFC::Function& RootFunction, CyPhyML::SignalFlow::State& State)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Event.Scope() ) == "OUTPUT_EVENT";;
	return Gz_guard;
}

void GetOutEvent_218a::processInputPackets( const Packets_t& states_218b, const Packets_t& rootFunctions_218e)
{
	for( Packets_t::const_iterator itState_2194= states_218b.begin(), itRootFunction_219d= rootFunctions_218e.begin(); itState_2194!= states_218b.end(), itRootFunction_219d!= rootFunctions_218e.end(); ++itState_2194, ++itRootFunction_219d)
	{
		bool isUnique= isInputUnique( *itState_2194, *itRootFunction_219d);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_2194, *itRootFunction_219d);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetOutEvent_218a::patternMatcher( const Udm::Object& state_2195, const Udm::Object& rootFunction_219e)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_2195.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_219a= CyPhyML::SignalFlow::State::Cast( state_2195);
		if( false== Uml::IsDerivedFrom( rootFunction_219e.type(), SFC::Function::meta))
			continue;
		SFC::Function rootFunction_21a3= SFC::Function::Cast( rootFunction_219e);
		set< CyPhyML::SignalFlow::Event> events_21a5= state_219a.Event_kind_children();
		for( set< CyPhyML::SignalFlow::Event>::const_iterator itEvent_21a6= events_21a5.begin(); itEvent_21a6!= events_21a5.end(); ++itEvent_21a6)
		{
			CyPhyML::SignalFlow::Event currEvent_21a7= *itEvent_21a6;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_21ab;
			if( !isValidBound(boundObjs_21ab, state_219a, true))
				continue;
			currMatch.state_21ac= state_219a;
			if( !isValidBound(boundObjs_21ab, rootFunction_21a3, true))
				continue;
			currMatch.rootFunction_21ad= rootFunction_21a3;
			if( !isValidBound(boundObjs_21ab, currEvent_21a7, false))
				continue;
			currMatch.event_21ae= currEvent_21a7;
			bool Gz_guard= isGuardTrue( currMatch.event_21ae, currMatch.rootFunction_21ad, currMatch.state_21ac);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetOutEvent_218a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.event_21ae, currMatch.rootFunction_21ad);
	}
}

void GetOutEvent_218a::outputAppender( const CyPhyML::SignalFlow::Event& event_21b2, const SFC::Function& rootFunction_21b4)
{
	_event_2191->push_back( event_21b2);
	_rootFunction_2192->push_back( rootFunction_21b4);
}

void GetOutEvent_218a::sortOutputs()
{
	typedef std::multiset< CyPhyML::SignalFlow::Event, std::pointer_to_binary_function< const CyPhyML::SignalFlow::Event&, const CyPhyML::SignalFlow::Event&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const CyPhyML::SignalFlow::Event&, const CyPhyML::SignalFlow::Event&, bool> ptr_DEOrder( DEOrder< CyPhyML::SignalFlow::Event>);
	SortedSet_t sortedSet( ptr_DEOrder);
	std::vector< int> permutationVector( _event_2191->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _event_2191->begin(); it!= _event_2191->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( CyPhyML::SignalFlow::Event::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _event_2191->begin());
	// order rest of the containers
	permutate( permutationVector, *_rootFunction_2192);
}

void CreateOEArg_21b6::operator()( const Packets_t& events_21b7, const Packets_t& rootFunctions_21b9)
{
#ifdef PRINT_INFO
	printLog( "CreateOEArg_21b6" );
#endif
	RTTGenerator::Instance()->generateRule(1550, "CreateOEArg");
	processInputPackets( events_21b7, rootFunctions_21b9);
}

bool CreateOEArg_21b6::isInputUnique( const Udm::Object& event_21bf, const Udm::Object& rootFunction_21c8)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itEvent_21c1= _event_21bb.begin(), itRootFunction_21ca= _rootFunction_21c4.begin(); itEvent_21c1!= _event_21bb.end(), itRootFunction_21ca!= _rootFunction_21c4.end(); ++itEvent_21c1, ++itRootFunction_21ca)
	{
		if( ( *itEvent_21c1== event_21bf)&& ( *itRootFunction_21ca== rootFunction_21c8))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_event_21bb.push_back( event_21bf);
		_rootFunction_21c4.push_back( rootFunction_21c8);
	}
	return isUnique;
}

bool CreateOEArg_21b6::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateOEArg_21b6::processInputPackets( const Packets_t& events_21b7, const Packets_t& rootFunctions_21b9)
{
	for( Packets_t::const_iterator itEvent_21bc= events_21b7.begin(), itRootFunction_21c5= rootFunctions_21b9.begin(); itEvent_21bc!= events_21b7.end(), itRootFunction_21c5!= rootFunctions_21b9.end(); ++itEvent_21bc, ++itRootFunction_21c5)
	{
		bool isUnique= isInputUnique( *itEvent_21bc, *itRootFunction_21c5);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itEvent_21bc, *itRootFunction_21c5);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateOEArg_21b6::patternMatcher( const Udm::Object& event_21bd, const Udm::Object& rootFunction_21c6)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( event_21bd.type(), CyPhyML::SignalFlow::Event::meta))
			continue;
		CyPhyML::SignalFlow::Event event_21c2= CyPhyML::SignalFlow::Event::Cast( event_21bd);
		if( false== Uml::IsDerivedFrom( rootFunction_21c6.type(), SFC::Function::meta))
			continue;
		SFC::Function rootFunction_21cb= SFC::Function::Cast( rootFunction_21c6);
		set< SFC::LocalVar> localVars_21cd= event_21c2.src();
		for( set< SFC::LocalVar>::const_iterator itLocalVars_21ce= localVars_21cd.begin(); itLocalVars_21ce!= localVars_21cd.end(); ++itLocalVars_21ce)
		{
			SFC::LocalVar currLocalVar_21cf= *itLocalVars_21ce;
			SFC::DT dT_21d0= currLocalVar_21cf.dt();
			if( !dT_21d0)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_21d4;
			if( !isValidBound(boundObjs_21d4, event_21c2, true))
				continue;
			currMatch.event_21d5= event_21c2;
			if( !isValidBound(boundObjs_21d4, rootFunction_21cb, true))
				continue;
			currMatch.rootFunction_21d6= rootFunction_21cb;
			if( !isValidBound(boundObjs_21d4, currLocalVar_21cf, false))
				continue;
			currMatch.localVar_21d7= currLocalVar_21cf;
			if( !isValidBound(boundObjs_21d4, dT_21d0, false))
				continue;
			currMatch.dT_21d8= dT_21d0;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateOEArg_21b6::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::SetVar newSetVar_21d9= SFC::SetVar::Create( currMatch.rootFunction_21d6);
		SFC::Arg newArg_21da= SFC::Arg::Create( currMatch.rootFunction_21d6);
		SFC::Arg& Arg= newArg_21da;
		SFC::DT& DT= currMatch.dT_21d8;
		CyPhyML::SignalFlow::Event& Event= currMatch.event_21d5;
		SFC::LocalVar& LocalVar= currMatch.localVar_21d7;
		SFC::Function& RootFunction= currMatch.rootFunction_21d6;
		SFC::SetVar& SetVar= newSetVar_21d9;
		{
Arg.RefId() = SetVar.RefId() = LocalVar.RefId();
};
		{
__int64 argCount = RootFunction.argCount();
Arg.argIndex() = argCount++;
RootFunction.argCount() = argCount;
};
		{
__int64 statementCount = RootFunction.statementCount();
SetVar.statementIndex() = statementCount++;
RootFunction.statementCount() = statementCount;
};
		{
Arg.name() = static_cast< std::string >( Event.Name() ) + "_";
Arg.ptr() = true;
};
		{
SetVar.invert() = true;
};
		newArg_21da.dt()= currMatch.dT_21d8;
		newSetVar_21d9.arg_end()= newArg_21da;
		newSetVar_21d9.lvar_end()= currMatch.localVar_21d7;
	}
}

void CreateInitFunction_21f9::operator()( const Packets_t& states_21fa, const Packets_t& programs_21fc, Packets_t& states_21fe, Packets_t& programs_21ff)
{
#ifdef PRINT_INFO
	printLog( "CreateInitFunction_21f9" );
#endif
	_state_2200= &states_21fe;
	_program_2201= &programs_21ff;
	_state_2200->insert( _state_2200->end(), states_21fa.begin(), states_21fa.end());
	_program_2201->insert( _program_2201->end(), programs_21fc.begin(), programs_21fc.end());
	if( ( !states_21fa.empty())&& ( !programs_21fc.empty()))
		callCreateInitFunction_242b( states_21fa, programs_21fc);
}

void CreateInitFunction_21f9::callCreateInitFunction_242b( const Packets_t& states_225a, const Packets_t& programs_225d)
{
	Packets_t states_225c;
	Packets_t programs_225f;
	Packets_t initFunctions_2260;
	Packets_t initIdxs_2261;
	CreateInitFunction_2259 createInitFunction_2259;
	createInitFunction_2259( states_225a, programs_225d, states_225c, programs_225f, initFunctions_2260, initIdxs_2261);
	if( ( !states_225c.empty())&& ( !programs_225f.empty())&& ( !initFunctions_2260.empty())&& ( !initIdxs_2261.empty()))
		callInitLocalVars_242e( states_225c, programs_225f, initFunctions_2260, initIdxs_2261);
}

void CreateInitFunction_21f9::callInitLocalVars_242e( const Packets_t& states_228d, const Packets_t& programs_228f, const Packets_t& initFns_2291, const Packets_t& initIdxs_2293)
{
	Packets_t states_2295;
	Packets_t initfns_2296;
	InitLocalVars_228c initLocalVars_228c;
	initLocalVars_228c( states_228d, programs_228f, initFns_2291, initIdxs_2293, states_2295, initfns_2296);
	if( ( !states_2295.empty())&& ( !initfns_2296.empty()))
		callTestEAIOn_2433( states_2295, initfns_2296);
}

void CreateInitFunction_21f9::callTestEAIOn_2433( const Packets_t& states_23dc, const Packets_t& initfns_23de)
{
	Packets_t states_23e0;
	Packets_t initfns_23e1;
	TestEAIOn_23db testEAIOn_23db;
	testEAIOn_23db( states_23dc, initfns_23de, states_23e0, initfns_23e1);
	if( ( !states_23e0.empty())&& ( !initfns_23e1.empty()))
		callCreateFunction_FunctionCall_2436( states_23e0, initfns_23e1);
}

void CreateInitFunction_21f9::callCreateFunction_FunctionCall_2436( const Packets_t& states_2203, const Packets_t& initFns_2206)
{
	Packets_t enters_2205;
	Packets_t functionCalls_2208;
	CreateFunction_FunctionCall_2202 createFunction_FunctionCall_2202;
	createFunction_FunctionCall_2202( states_2203, initFns_2206, enters_2205, functionCalls_2208);
	if( ( !enters_2205.empty())&& ( !functionCalls_2208.empty()))
		callFunctionCall_Vals_2439( enters_2205, functionCalls_2208);
}

void CreateInitFunction_21f9::callFunctionCall_Vals_2439( const Packets_t& enters_222d, const Packets_t& functionCalls_222f)
{
	FunctionCall_Vals_222c functionCall_Vals_222c;
	functionCall_Vals_222c( enters_222d, functionCalls_222f);
}

void CreateFunction_FunctionCall_2202::operator()( const Packets_t& states_2203, const Packets_t& initFns_2206, Packets_t& enters_2205, Packets_t& functionCalls_2208)
{
#ifdef PRINT_INFO
	printLog( "CreateFunction_FunctionCall_2202" );
#endif
	RTTGenerator::Instance()->generateRule(1574, "CreateFunction_FunctionCall");
	_enter_2209= &enters_2205;
	_functionCall_220a= &functionCalls_2208;
	processInputPackets( states_2203, initFns_2206);
}

bool CreateFunction_FunctionCall_2202::isInputUnique( const Udm::Object& state_220f, const Udm::Object& initFn_2218)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_2211= _state_220b.begin(), itInitFn_221a= _initFn_2214.begin(); itState_2211!= _state_220b.end(), itInitFn_221a!= _initFn_2214.end(); ++itState_2211, ++itInitFn_221a)
	{
		if( ( *itState_2211== state_220f)&& ( *itInitFn_221a== initFn_2218))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_220b.push_back( state_220f);
		_initFn_2214.push_back( initFn_2218);
	}
	return isUnique;
}

bool CreateFunction_FunctionCall_2202::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateFunction_FunctionCall_2202::processInputPackets( const Packets_t& states_2203, const Packets_t& initFns_2206)
{
	for( Packets_t::const_iterator itState_220c= states_2203.begin(), itInitFn_2215= initFns_2206.begin(); itState_220c!= states_2203.end(), itInitFn_2215!= initFns_2206.end(); ++itState_220c, ++itInitFn_2215)
	{
		bool isUnique= isInputUnique( *itState_220c, *itInitFn_2215);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_220c, *itInitFn_2215);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateFunction_FunctionCall_2202::patternMatcher( const Udm::Object& state_220d, const Udm::Object& initFn_2216)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_220d.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_2212= CyPhyML::SignalFlow::State::Cast( state_220d);
		if( false== Uml::IsDerivedFrom( initFn_2216.type(), SFC::Function::meta))
			continue;
		SFC::Function initFn_221b= SFC::Function::Cast( initFn_2216);
		set< SFC::Function> enters_221d= state_2212.enter();
		for( set< SFC::Function>::const_iterator itEnters_221e= enters_221d.begin(); itEnters_221e!= enters_221d.end(); ++itEnters_221e)
		{
			SFC::Function currEnter_221f= *itEnters_221e;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_2223;
			if( !isValidBound(boundObjs_2223, state_2212, true))
				continue;
			currMatch.state_2224= state_2212;
			if( !isValidBound(boundObjs_2223, initFn_221b, true))
				continue;
			currMatch.initFn_2225= initFn_221b;
			if( !isValidBound(boundObjs_2223, currEnter_221f, false))
				continue;
			currMatch.enter_2226= currEnter_221f;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateFunction_FunctionCall_2202::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::FunctionCall newFunctionCall_2227= SFC::FunctionCall::Create( currMatch.initFn_2225);
		SFC::Function& Enter= currMatch.enter_2226;
		SFC::FunctionCall& FunctionCall= newFunctionCall_2227;
		SFC::Function& InitFn= currMatch.initFn_2225;
		CyPhyML::SignalFlow::State& State= currMatch.state_2224;
		{
FunctionCall.RefId() = InitFn.RefId();
};
		{
__int64 statementCount = InitFn.statementCount();
FunctionCall.statementIndex() = statementCount++;
InitFn.statementCount() = statementCount;
};
		newFunctionCall_2227.callee()= currMatch.enter_2226;
		outputAppender( currMatch.enter_2226, newFunctionCall_2227);
	}
}

void CreateFunction_FunctionCall_2202::outputAppender( const SFC::Function& enter_2228, const SFC::FunctionCall& functionCall_222a)
{
	_enter_2209->push_back( enter_2228);
	_functionCall_220a->push_back( functionCall_222a);
}

void FunctionCall_Vals_222c::operator()( const Packets_t& enters_222d, const Packets_t& functionCalls_222f)
{
#ifdef PRINT_INFO
	printLog( "FunctionCall_Vals_222c" );
#endif
	RTTGenerator::Instance()->generateRule(1584, "FunctionCall_Vals");
	processInputPackets( enters_222d, functionCalls_222f);
}

bool FunctionCall_Vals_222c::isInputUnique( const Udm::Object& enter_2235, const Udm::Object& functionCall_223e)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itEnter_2237= _enter_2231.begin(), itFunctionCall_2240= _functionCall_223a.begin(); itEnter_2237!= _enter_2231.end(), itFunctionCall_2240!= _functionCall_223a.end(); ++itEnter_2237, ++itFunctionCall_2240)
	{
		if( ( *itEnter_2237== enter_2235)&& ( *itFunctionCall_2240== functionCall_223e))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_enter_2231.push_back( enter_2235);
		_functionCall_223a.push_back( functionCall_223e);
	}
	return isUnique;
}

bool FunctionCall_Vals_222c::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool FunctionCall_Vals_222c::isGuardTrue( SFC::Arg& Arg0, SFC::Arg& Arg1, SFC::Function& Enter, SFC::FunctionCall& FunctionCall)
{
	bool Gz_guard= false;
	return Arg0.argIndex() == 0 && Arg1.argIndex() == 1;;
	return Gz_guard;
}

void FunctionCall_Vals_222c::processInputPackets( const Packets_t& enters_222d, const Packets_t& functionCalls_222f)
{
	for( Packets_t::const_iterator itEnter_2232= enters_222d.begin(), itFunctionCall_223b= functionCalls_222f.begin(); itEnter_2232!= enters_222d.end(), itFunctionCall_223b!= functionCalls_222f.end(); ++itEnter_2232, ++itFunctionCall_223b)
	{
		bool isUnique= isInputUnique( *itEnter_2232, *itFunctionCall_223b);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itEnter_2232, *itFunctionCall_223b);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool FunctionCall_Vals_222c::patternMatcher( const Udm::Object& enter_2233, const Udm::Object& functionCall_223c)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( enter_2233.type(), SFC::Function::meta))
			continue;
		SFC::Function enter_2238= SFC::Function::Cast( enter_2233);
		if( false== Uml::IsDerivedFrom( functionCall_223c.type(), SFC::FunctionCall::meta))
			continue;
		SFC::FunctionCall functionCall_2241= SFC::FunctionCall::Cast( functionCall_223c);
		set< SFC::Arg> arg1s_2243= enter_2238.Arg_kind_children();
		for( set< SFC::Arg>::const_iterator itArg1_2244= arg1s_2243.begin(); itArg1_2244!= arg1s_2243.end(); ++itArg1_2244)
		{
			SFC::Arg currArg1_2245= *itArg1_2244;
			set< SFC::Arg> arg0s_2246= enter_2238.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itArg0_2247= arg0s_2246.begin(); itArg0_2247!= arg0s_2246.end(); ++itArg0_2247)
			{
				SFC::Arg currArg0_2248= *itArg0_2247;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_224c;
				if( !isValidBound(boundObjs_224c, enter_2238, true))
					continue;
				currMatch.enter_224d= enter_2238;
				if( !isValidBound(boundObjs_224c, functionCall_2241, true))
					continue;
				currMatch.functionCall_224e= functionCall_2241;
				if( !isValidBound(boundObjs_224c, currArg0_2248, false))
					continue;
				currMatch.arg0_224f= currArg0_2248;
				if( !isValidBound(boundObjs_224c, currArg1_2245, false))
					continue;
				currMatch.arg1_2250= currArg1_2245;
				bool Gz_guard= isGuardTrue( currMatch.arg0_224f, currMatch.arg1_2250, currMatch.enter_224d, currMatch.functionCall_224e);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void FunctionCall_Vals_222c::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ArgVal newArgVal1_2255= SFC::ArgVal::Create( currMatch.functionCall_224e);
		SFC::Int newNegOne_2256= SFC::Int::Create( newArgVal1_2255);
		SFC::ArgVal newArgVal0_2257= SFC::ArgVal::Create( currMatch.functionCall_224e);
		SFC::Int newZero_2258= SFC::Int::Create( newArgVal0_2257);
		SFC::Arg& Arg0= currMatch.arg0_224f;
		SFC::Arg& Arg1= currMatch.arg1_2250;
		SFC::ArgVal& ArgVal0= newArgVal0_2257;
		SFC::ArgVal& ArgVal1= newArgVal1_2255;
		SFC::Function& Enter= currMatch.enter_224d;
		SFC::FunctionCall& FunctionCall= currMatch.functionCall_224e;
		SFC::Int& NegOne= newNegOne_2256;
		SFC::Int& Zero= newZero_2258;
		{
ArgVal1.argIndex() = Arg1.argIndex();
};
		{
ArgVal0.argIndex() = Arg0.argIndex();
};
		{
FunctionCall.argCount() = FunctionCall.argCount() + 2;
};
		{
NegOne.val() = -1;
};
		{
Zero.val() = 0;
};
		newArgVal1_2255.arg()+= currMatch.arg1_2250;
		newArgVal0_2257.arg()+= currMatch.arg0_224f;
	}
}

void CreateInitFunction_2259::operator()( const Packets_t& states_225a, const Packets_t& programs_225d, Packets_t& states_225c, Packets_t& programs_225f, Packets_t& initFunctions_2260, Packets_t& initIdxs_2261)
{
#ifdef PRINT_INFO
	printLog( "CreateInitFunction_2259" );
#endif
	RTTGenerator::Instance()->generateRule(1606, "CreateInitFunction");
	_state_2262= &states_225c;
	_program_2263= &programs_225f;
	_initFunction_2264= &initFunctions_2260;
	_initIdx_2265= &initIdxs_2261;
	processInputPackets( states_225a, programs_225d);
}

bool CreateInitFunction_2259::isInputUnique( const Udm::Object& state_226a, const Udm::Object& program_2273)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_226c= _state_2266.begin(), itProgram_2275= _program_226f.begin(); itState_226c!= _state_2266.end(), itProgram_2275!= _program_226f.end(); ++itState_226c, ++itProgram_2275)
	{
		if( ( *itState_226c== state_226a)&& ( *itProgram_2275== program_2273))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_2266.push_back( state_226a);
		_program_226f.push_back( program_2273);
	}
	return isUnique;
}

bool CreateInitFunction_2259::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateInitFunction_2259::processInputPackets( const Packets_t& states_225a, const Packets_t& programs_225d)
{
	for( Packets_t::const_iterator itState_2267= states_225a.begin(), itProgram_2270= programs_225d.begin(); itState_2267!= states_225a.end(), itProgram_2270!= programs_225d.end(); ++itState_2267, ++itProgram_2270)
	{
		bool isUnique= isInputUnique( *itState_2267, *itProgram_2270);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_2267, *itProgram_2270);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateInitFunction_2259::patternMatcher( const Udm::Object& state_2268, const Udm::Object& program_2271)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_2268.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_226d= CyPhyML::SignalFlow::State::Cast( state_2268);
		if( false== Uml::IsDerivedFrom( program_2271.type(), SFC::Program::meta))
			continue;
		SFC::Program program_2276= SFC::Program::Cast( program_2271);
		set< SFC::StateVar> stateVars_2278= program_2276.StateVar_kind_children();
		for( set< SFC::StateVar>::const_iterator itStateVar_2279= stateVars_2278.begin(); itStateVar_2279!= stateVars_2278.end(); ++itStateVar_2279)
		{
			SFC::StateVar currStateVar_227a= *itStateVar_2279;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_227e;
			if( !isValidBound(boundObjs_227e, state_226d, true))
				continue;
			currMatch.state_227f= state_226d;
			if( !isValidBound(boundObjs_227e, program_2276, true))
				continue;
			currMatch.program_2280= program_2276;
			if( !isValidBound(boundObjs_227e, currStateVar_227a, false))
				continue;
			currMatch.stateVar_2281= currStateVar_227a;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateInitFunction_2259::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function newInitFunction_2282= SFC::Function::Create( currMatch.program_2280);
		SFC::LocalVar newInitIdx_2283= SFC::LocalVar::Create( newInitFunction_2282);
		SFC::Function& InitFunction= newInitFunction_2282;
		SFC::LocalVar& InitIdx= newInitIdx_2283;
		SFC::Program& Program= currMatch.program_2280;
		CyPhyML::SignalFlow::State& State= currMatch.state_227f;
		SFC::StateVar& StateVar= currMatch.stateVar_2281;
		{
InitFunction.RefId() = InitIdx.RefId() = State.RefId();
};
		{
__int64 sc;
sc = Program.statementCount();
InitFunction.statementIndex() = sc++;
Program.statementCount() = sc;
};
		{
InitFunction.name() = static_cast< std::string >( State.name() ) + "_init";
};
		{
__int64 sc;
sc = InitFunction.statementCount();
InitIdx.statementIndex() = sc++;
InitFunction.statementCount() = sc;
};
		{
InitIdx.name() = "i";
InitIdx.dt() = SFCTypesManager::getSingleton().getBasicType( "int" );
InitIdx.initial() = "0";
};
		outputAppender( currMatch.state_227f, currMatch.program_2280, newInitFunction_2282, newInitIdx_2283);
	}
}

void CreateInitFunction_2259::outputAppender( const CyPhyML::SignalFlow::State& state_2284, const SFC::Program& program_2286, const SFC::Function& initFunction_2288, const SFC::LocalVar& initIdx_228a)
{
	_state_2262->push_back( state_2284);
	_program_2263->push_back( program_2286);
	_initFunction_2264->push_back( initFunction_2288);
	_initIdx_2265->push_back( initIdx_228a);
}

void InitLocalVars_228c::operator()( const Packets_t& states_228d, const Packets_t& programs_228f, const Packets_t& initFns_2291, const Packets_t& initIdxs_2293, Packets_t& states_2295, Packets_t& initfns_2296)
{
#ifdef PRINT_INFO
	printLog( "InitLocalVars_228c" );
#endif
	_state_2297= &states_2295;
	_initfn_2298= &initfns_2296;
	_state_2297->insert( _state_2297->end(), states_228d.begin(), states_228d.end());
	_initfn_2298->insert( _initfn_2298->end(), initFns_2291.begin(), initFns_2291.end());
	if( ( !programs_228f.empty())&& ( !initFns_2291.empty())&& ( !initIdxs_2293.empty()))
		callGetSortedVars_23cb( programs_228f, initFns_2291, initIdxs_2293);
}

void InitLocalVars_228c::callGetSortedVars_23cb( const Packets_t& programs_229a, const Packets_t& initFns_229d, const Packets_t& initIdxs_22a0)
{
	Packets_t vars_229c;
	Packets_t initFns_229f;
	Packets_t initIdxs_22a2;
	GetSortedVars_2299 getSortedVars_2299;
	getSortedVars_2299( programs_229a, initFns_229d, initIdxs_22a0, vars_229c, initFns_229f, initIdxs_22a2);
	if( ( !vars_229c.empty())&& ( !initFns_229f.empty())&& ( !initIdxs_22a2.empty()))
		callArrayVars_23cf( vars_229c, initFns_229f, initIdxs_22a2);
}

void InitLocalVars_228c::callArrayVars_23cf( const Packets_t& programs_230e, const Packets_t& initFns_2310, const Packets_t& initIdxs_2312)
{
	Packets_t vars_2314;
	Packets_t initfns_2315;
	Packets_t initidxs_2316;
	Packets_t vars_2317;
	Packets_t initfns_2318;
	Packets_t initidxs_2319;
	ArrayVars_230d arrayVars_230d;
	arrayVars_230d( programs_230e, initFns_2310, initIdxs_2312, vars_2314, initfns_2315, initidxs_2316, vars_2317, initfns_2318, initidxs_2319);
	if( ( !vars_2314.empty())&& ( !initfns_2315.empty())&& ( !initidxs_2316.empty()))
		callInitArrayVar_23d3( vars_2314, initfns_2315, initidxs_2316);
	if( ( !vars_2317.empty())&& ( !initfns_2318.empty())&& ( !initidxs_2319.empty()))
		callInitScalarVar_23d7( vars_2317, initfns_2318, initidxs_2319);
}

void InitLocalVars_228c::callInitArrayVar_23d3( const Packets_t& vars_22d3, const Packets_t& initFns_22d5, const Packets_t& idxVars_22d7)
{
	InitArrayVar_22d2 initArrayVar_22d2;
	initArrayVar_22d2( vars_22d3, initFns_22d5, idxVars_22d7);
}

void InitLocalVars_228c::callInitScalarVar_23d7( const Packets_t& vars_23a3, const Packets_t& initFns_23a5, const Packets_t& idxVars_23a7)
{
	InitScalarVar_23a2 initScalarVar_23a2;
	initScalarVar_23a2( vars_23a3, initFns_23a5, idxVars_23a7);
}

void GetSortedVars_2299::operator()( const Packets_t& programs_229a, const Packets_t& initFns_229d, const Packets_t& initIdxs_22a0, Packets_t& vars_229c, Packets_t& initFns_229f, Packets_t& initIdxs_22a2)
{
#ifdef PRINT_INFO
	printLog( "GetSortedVars_2299" );
#endif
	RTTGenerator::Instance()->generateRule(1627, "GetSortedVars");
	_var_22a3= &vars_229c;
	_initFn_22a4= &initFns_229f;
	_initIdx_22a5= &initIdxs_22a2;
	processInputPackets( programs_229a, initFns_229d, initIdxs_22a0);
	sortOutputs( );
}

bool GetSortedVars_2299::isInputUnique( const Udm::Object& program_22aa, const Udm::Object& initFn_22b3, const Udm::Object& initIdx_22bc)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itProgram_22ac= _program_22a6.begin(), itInitFn_22b5= _initFn_22af.begin(), itInitIdx_22be= _initIdx_22b8.begin(); itProgram_22ac!= _program_22a6.end(), itInitFn_22b5!= _initFn_22af.end(), itInitIdx_22be!= _initIdx_22b8.end(); ++itProgram_22ac, ++itInitFn_22b5, ++itInitIdx_22be)
	{
		if( ( *itProgram_22ac== program_22aa)&& ( *itInitFn_22b5== initFn_22b3)&& ( *itInitIdx_22be== initIdx_22bc))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_program_22a6.push_back( program_22aa);
		_initFn_22af.push_back( initFn_22b3);
		_initIdx_22b8.push_back( initIdx_22bc);
	}
	return isUnique;
}

bool GetSortedVars_2299::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetSortedVars_2299::processInputPackets( const Packets_t& programs_229a, const Packets_t& initFns_229d, const Packets_t& initIdxs_22a0)
{
	for( Packets_t::const_iterator itProgram_22a7= programs_229a.begin(), itInitFn_22b0= initFns_229d.begin(), itInitIdx_22b9= initIdxs_22a0.begin(); itProgram_22a7!= programs_229a.end(), itInitFn_22b0!= initFns_229d.end(), itInitIdx_22b9!= initIdxs_22a0.end(); ++itProgram_22a7, ++itInitFn_22b0, ++itInitIdx_22b9)
	{
		bool isUnique= isInputUnique( *itProgram_22a7, *itInitFn_22b0, *itInitIdx_22b9);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itProgram_22a7, *itInitFn_22b0, *itInitIdx_22b9);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetSortedVars_2299::patternMatcher( const Udm::Object& program_22a8, const Udm::Object& initFn_22b1, const Udm::Object& initIdx_22ba)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( program_22a8.type(), SFC::Program::meta))
			continue;
		SFC::Program program_22ad= SFC::Program::Cast( program_22a8);
		if( false== Uml::IsDerivedFrom( initFn_22b1.type(), SFC::Function::meta))
			continue;
		SFC::Function initFn_22b6= SFC::Function::Cast( initFn_22b1);
		if( false== Uml::IsDerivedFrom( initIdx_22ba.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar initIdx_22bf= SFC::LocalVar::Cast( initIdx_22ba);
		set< SFC::Var> vars_22c1= program_22ad.Var_kind_children();
		for( set< SFC::Var>::const_iterator itVar_22c2= vars_22c1.begin(); itVar_22c2!= vars_22c1.end(); ++itVar_22c2)
		{
			SFC::Var currVar_22c3= *itVar_22c2;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_22c7;
			if( !isValidBound(boundObjs_22c7, program_22ad, true))
				continue;
			currMatch.program_22c8= program_22ad;
			if( !isValidBound(boundObjs_22c7, initFn_22b6, true))
				continue;
			currMatch.initFn_22c9= initFn_22b6;
			if( !isValidBound(boundObjs_22c7, initIdx_22bf, true))
				continue;
			currMatch.initIdx_22ca= initIdx_22bf;
			if( !isValidBound(boundObjs_22c7, currVar_22c3, false))
				continue;
			currMatch.var_22cb= currVar_22c3;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetSortedVars_2299::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.var_22cb, currMatch.initFn_22c9, currMatch.initIdx_22ca);
	}
}

void GetSortedVars_2299::outputAppender( const SFC::Var& var_22cc, const SFC::Function& initFn_22ce, const SFC::LocalVar& initIdx_22d0)
{
	_var_22a3->push_back( var_22cc);
	_initFn_22a4->push_back( initFn_22ce);
	_initIdx_22a5->push_back( initIdx_22d0);
}

void GetSortedVars_2299::sortOutputs()
{
	typedef std::multiset< SFC::Var, std::pointer_to_binary_function< const SFC::Var&, const SFC::Var&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const SFC::Var&, const SFC::Var&, bool> ptr_StatementOrder( StatementOrder< SFC::Var>);
	SortedSet_t sortedSet( ptr_StatementOrder);
	std::vector< int> permutationVector( _var_22a3->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _var_22a3->begin(); it!= _var_22a3->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( SFC::Var::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _var_22a3->begin());
	// order rest of the containers
	permutate( permutationVector, *_initFn_22a4);
	permutate( permutationVector, *_initIdx_22a5);
}

void InitArrayVar_22d2::operator()( const Packets_t& vars_22d3, const Packets_t& initFns_22d5, const Packets_t& idxVars_22d7)
{
#ifdef PRINT_INFO
	printLog( "InitArrayVar_22d2" );
#endif
	RTTGenerator::Instance()->generateRule(1633, "InitArrayVar");
	processInputPackets( vars_22d3, initFns_22d5, idxVars_22d7);
}

bool InitArrayVar_22d2::isInputUnique( const Udm::Object& var_22dd, const Udm::Object& initFn_22e6, const Udm::Object& idxVar_22ef)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itVar_22df= _var_22d9.begin(), itInitFn_22e8= _initFn_22e2.begin(), itIdxVar_22f1= _idxVar_22eb.begin(); itVar_22df!= _var_22d9.end(), itInitFn_22e8!= _initFn_22e2.end(), itIdxVar_22f1!= _idxVar_22eb.end(); ++itVar_22df, ++itInitFn_22e8, ++itIdxVar_22f1)
	{
		if( ( *itVar_22df== var_22dd)&& ( *itInitFn_22e8== initFn_22e6)&& ( *itIdxVar_22f1== idxVar_22ef))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_var_22d9.push_back( var_22dd);
		_initFn_22e2.push_back( initFn_22e6);
		_idxVar_22eb.push_back( idxVar_22ef);
	}
	return isUnique;
}

bool InitArrayVar_22d2::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void InitArrayVar_22d2::processInputPackets( const Packets_t& vars_22d3, const Packets_t& initFns_22d5, const Packets_t& idxVars_22d7)
{
	for( Packets_t::const_iterator itVar_22da= vars_22d3.begin(), itInitFn_22e3= initFns_22d5.begin(), itIdxVar_22ec= idxVars_22d7.begin(); itVar_22da!= vars_22d3.end(), itInitFn_22e3!= initFns_22d5.end(), itIdxVar_22ec!= idxVars_22d7.end(); ++itVar_22da, ++itInitFn_22e3, ++itIdxVar_22ec)
	{
		bool isUnique= isInputUnique( *itVar_22da, *itInitFn_22e3, *itIdxVar_22ec);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itVar_22da, *itInitFn_22e3, *itIdxVar_22ec);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitArrayVar_22d2::patternMatcher( const Udm::Object& var_22db, const Udm::Object& initFn_22e4, const Udm::Object& idxVar_22ed)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( var_22db.type(), SFC::Var::meta))
			continue;
		SFC::Var var_22e0= SFC::Var::Cast( var_22db);
		if( false== Uml::IsDerivedFrom( initFn_22e4.type(), SFC::Function::meta))
			continue;
		SFC::Function initFn_22e9= SFC::Function::Cast( initFn_22e4);
		if( false== Uml::IsDerivedFrom( idxVar_22ed.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar idxVar_22f2= SFC::LocalVar::Cast( idxVar_22ed);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_22f7;
		if( !isValidBound(boundObjs_22f7, var_22e0, true))
			continue;
		currMatch.var_22f8= var_22e0;
		if( !isValidBound(boundObjs_22f7, initFn_22e9, true))
			continue;
		currMatch.initFn_22f9= initFn_22e9;
		if( !isValidBound(boundObjs_22f7, idxVar_22f2, true))
			continue;
		currMatch.idxVar_22fa= idxVar_22f2;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void InitArrayVar_22d2::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::UserCode newInitIdxVar_22fb= SFC::UserCode::Create( currMatch.initFn_22f9);
		SFC::BinaryExprs newopAssign_22fc= SFC::BinaryExprs::Create( newInitIdxVar_22fb, SFC::UserCode::meta_codeexpr);
		SFC::Int newzeroVal_22fd= SFC::Int::Create( newopAssign_22fc, SFC::BinaryExprs::meta_rightexpr);
		SFC::IterativeBlock newloopBlock_22fe= SFC::IterativeBlock::Create( currMatch.initFn_22f9);
		SFC::UserCode newincIdxVar_22ff= SFC::UserCode::Create( newloopBlock_22fe, SFC::IterativeBlock::meta_stmnt);
		SFC::UnaryExprs newopInc_2300= SFC::UnaryExprs::Create( newincIdxVar_22ff, SFC::UserCode::meta_codeexpr);
		SFC::UserCode newloopCond_2301= SFC::UserCode::Create( newloopBlock_22fe, SFC::IterativeBlock::meta_cond);
		SFC::BinaryExprs newopLe_2302= SFC::BinaryExprs::Create( newloopCond_2301, SFC::UserCode::meta_codeexpr);
		SFC::Int newloopBound_2303= SFC::Int::Create( newopLe_2302, SFC::BinaryExprs::meta_rightexpr);
		SFC::UserCode newloopAction_2304= SFC::UserCode::Create( newloopBlock_22fe, SFC::IterativeBlock::meta_stmnt);
		SFC::ArgDeclRef newidxVarRef_2305= SFC::ArgDeclRef::Create( newopAssign_22fc, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newidxVarRef2_2306= SFC::ArgDeclRef::Create( newopInc_2300, SFC::UnaryExprs::meta_subexpr);
		SFC::ArgDeclRef newidxVarRef3_2307= SFC::ArgDeclRef::Create( newopLe_2302, SFC::BinaryExprs::meta_leftexpr);
		SFC::BinaryExprs newVarAssign_2308= SFC::BinaryExprs::Create( newloopAction_2304, SFC::UserCode::meta_codeexpr);
		SFC::Int newZero_2309= SFC::Int::Create( newVarAssign_2308, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs newVarIndexOp_230a= SFC::BinaryExprs::Create( newVarAssign_2308, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newidxVarRef4_230b= SFC::ArgDeclRef::Create( newVarIndexOp_230a, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newVarRef_230c= SFC::ArgDeclRef::Create( newVarIndexOp_230a, SFC::BinaryExprs::meta_leftexpr);
		SFC::LocalVar& IdxVar= currMatch.idxVar_22fa;
		SFC::Function& InitFn= currMatch.initFn_22f9;
		SFC::UserCode& InitIdxVar= newInitIdxVar_22fb;
		SFC::Var& Var= currMatch.var_22f8;
		SFC::BinaryExprs& VarAssign= newVarAssign_2308;
		SFC::BinaryExprs& VarIndexOp= newVarIndexOp_230a;
		SFC::ArgDeclRef& VarRef= newVarRef_230c;
		SFC::Int& Zero= newZero_2309;
		SFC::ArgDeclRef& idxVarRef= newidxVarRef_2305;
		SFC::ArgDeclRef& idxVarRef2= newidxVarRef2_2306;
		SFC::ArgDeclRef& idxVarRef3= newidxVarRef3_2307;
		SFC::ArgDeclRef& idxVarRef4= newidxVarRef4_230b;
		SFC::UserCode& incIdxVar= newincIdxVar_22ff;
		SFC::UserCode& loopAction= newloopAction_2304;
		SFC::IterativeBlock& loopBlock= newloopBlock_22fe;
		SFC::Int& loopBound= newloopBound_2303;
		SFC::UserCode& loopCond= newloopCond_2301;
		SFC::BinaryExprs& opAssign= newopAssign_22fc;
		SFC::UnaryExprs& opInc= newopInc_2300;
		SFC::BinaryExprs& opLe= newopLe_2302;
		SFC::Int& zeroVal= newzeroVal_22fd;
		{
InitIdxVar.RefId() = loopBlock.RefId() = loopCond.RefId() = incIdxVar.RefId() = InitFn.RefId();
loopAction.RefId() = Var.RefId();
};
		{
Zero.val() = 0;
};
		{
__int64 sc;
sc = loopBlock.statementCount();
loopAction.statementIndex() = sc++;
incIdxVar.statementIndex() = sc++;
loopBlock.statementCount() = sc;
};
		{
__int64 sc;
sc = InitFn.statementCount();
InitIdxVar.statementIndex() = sc++;
loopBlock.statementIndex() = sc++;
InitFn.statementCount() = sc;
};
		{
opAssign.op() = string("=");
opInc.op() = string("++");
opLe.op() = string("<");
};
		{
zeroVal.val() = 0;
loopBound.val() = Var.size();
};
		{
loopAction.expr() = "";

VarAssign.op() = "=";
VarIndexOp.op() = "[";
VarRef.unres() = "";
idxVarRef4.unres() = "";

};
		{
idxVarRef.unres() = "";
idxVarRef2.unres() = "";
idxVarRef3.unres() = "";

};
		newidxVarRef_2305.argdecl()= currMatch.idxVar_22fa;
		newidxVarRef2_2306.argdecl()= currMatch.idxVar_22fa;
		newidxVarRef3_2307.argdecl()= currMatch.idxVar_22fa;
		newidxVarRef4_230b.argdecl()= currMatch.idxVar_22fa;
		newVarRef_230c.argdecl()= currMatch.var_22f8;
	}
}

void ArrayVars_230d::operator()( const Packets_t& programs_230e, const Packets_t& initFns_2310, const Packets_t& initIdxs_2312, Packets_t& vars_2314, Packets_t& initfns_2315, Packets_t& initidxs_2316, Packets_t& vars_2317, Packets_t& initfns_2318, Packets_t& initidxs_2319)
{
#ifdef PRINT_INFO
	printLog( "ArrayVars_230d" );
#endif
	_var_231a= &vars_2314;
	_initfn_231b= &initfns_2315;
	_initidx_231c= &initidxs_2316;
	_var_231d= &vars_2317;
	_initfn_231e= &initfns_2318;
	_initidx_231f= &initidxs_2319;
	for( Packets_t::const_iterator itprogram_2321= programs_230e.begin(), itinitFn_2328= initFns_2310.begin(), itinitIdx_232f= initIdxs_2312.begin(); itprogram_2321!= programs_230e.end(), itinitFn_2328!= initFns_2310.end(), itinitIdx_232f!= initIdxs_2312.end(); ++itprogram_2321, ++itinitFn_2328, ++itinitIdx_232f)
	{
		bool isUnique= isInputUnique( *itprogram_2321, *itinitFn_2328, *itinitIdx_232f);
		if( !isUnique)
			continue;
		Packets_t oneprogram_2325( 1, *itprogram_2321);
		Packets_t oneinitFn_232c( 1, *itinitFn_2328);
		Packets_t oneinitIdx_2333( 1, *itinitIdx_232f);
		executeOne( oneprogram_2325, oneinitFn_232c, oneinitIdx_2333);
	}
}

void ArrayVars_230d::executeOne( const Packets_t& programs_230e, const Packets_t& initFns_2310, const Packets_t& initIdxs_2312)
{
	Packets_t vars_2338;
	Packets_t initFns_233b;
	Packets_t initIdxs_233e;
	ArrayVar_2335 arrayVar_2335;
	bool isMatchArrayVar_2335= arrayVar_2335( programs_230e, initFns_2310, initIdxs_2312, vars_2338, initFns_233b, initIdxs_233e);
	_var_231a->insert( _var_231a->end(), vars_2338.begin(), vars_2338.end());
	_initfn_231b->insert( _initfn_231b->end(), initFns_233b.begin(), initFns_233b.end());
	_initidx_231c->insert( _initidx_231c->end(), initIdxs_233e.begin(), initIdxs_233e.end());
	if( isMatchArrayVar_2335)
		return;
	Packets_t vars_2370;
	Packets_t initFns_2373;
	Packets_t initIdxs_2376;
	Otherwise_236d otherwise_236d;
	bool isMatchOtherwise_236d= otherwise_236d( programs_230e, initFns_2310, initIdxs_2312, vars_2370, initFns_2373, initIdxs_2376);
	_var_231d->insert( _var_231d->end(), vars_2370.begin(), vars_2370.end());
	_initfn_231e->insert( _initfn_231e->end(), initFns_2373.begin(), initFns_2373.end());
	_initidx_231f->insert( _initidx_231f->end(), initIdxs_2376.begin(), initIdxs_2376.end());
	if( isMatchOtherwise_236d)
		return;
}

bool ArrayVars_230d::isInputUnique( const Udm::Object& program_2322, const Udm::Object& initFn_2329, const Udm::Object& initIdx_2330)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itprogram_2324= _program_2320.begin(), itinitFn_232b= _initFn_2327.begin(), itinitIdx_2332= _initIdx_232e.begin(); itprogram_2324!= _program_2320.end(), itinitFn_232b!= _initFn_2327.end(), itinitIdx_2332!= _initIdx_232e.end(); ++itprogram_2324, ++itinitFn_232b, ++itinitIdx_2332)
	{
		if( ( *itprogram_2324== program_2322)&& ( *itinitFn_232b== initFn_2329)&& ( *itinitIdx_2332== initIdx_2330))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_program_2320.push_back( program_2322);
		_initFn_2327.push_back( initFn_2329);
		_initIdx_232e.push_back( initIdx_2330);
	}
	return isUnique;
}

bool ArrayVar_2335::operator()( const Packets_t& vars_2336, const Packets_t& initFns_2339, const Packets_t& initIdxs_233c, Packets_t& vars_2338, Packets_t& initFns_233b, Packets_t& initIdxs_233e)
{
#ifdef PRINT_INFO
	printLog( "ArrayVar_2335" );
#endif
	_var_233f= &vars_2338;
	_initFn_2340= &initFns_233b;
	_initIdx_2341= &initIdxs_233e;
	processInputPackets( vars_2336, initFns_2339, initIdxs_233c);
	sortOutputs( );
	if( false== _matches.empty())
		return true;
	return false;
}

bool ArrayVar_2335::isInputUnique( const Udm::Object& var_2346, const Udm::Object& initFn_234f, const Udm::Object& initIdx_2358)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itVar_2348= _var_2342.begin(), itInitFn_2351= _initFn_234b.begin(), itInitIdx_235a= _initIdx_2354.begin(); itVar_2348!= _var_2342.end(), itInitFn_2351!= _initFn_234b.end(), itInitIdx_235a!= _initIdx_2354.end(); ++itVar_2348, ++itInitFn_2351, ++itInitIdx_235a)
	{
		if( ( *itVar_2348== var_2346)&& ( *itInitFn_2351== initFn_234f)&& ( *itInitIdx_235a== initIdx_2358))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_var_2342.push_back( var_2346);
		_initFn_234b.push_back( initFn_234f);
		_initIdx_2354.push_back( initIdx_2358);
	}
	return isUnique;
}

bool ArrayVar_2335::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool ArrayVar_2335::isGuardTrue( SFC::Function& InitFn, SFC::LocalVar& InitIdx, SFC::Var& Var)
{
	bool Gz_guard= false;
	__int64 sz = Var.size();
const Udm::Object& o = Var;
Gz_guard = (sz > 1) || Udm::IsDerivedFrom(o.type(), SFC::StateVar::meta);;
	return Gz_guard;
}

void ArrayVar_2335::processInputPackets( const Packets_t& vars_2336, const Packets_t& initFns_2339, const Packets_t& initIdxs_233c)
{
	for( Packets_t::const_iterator itVar_2343= vars_2336.begin(), itInitFn_234c= initFns_2339.begin(), itInitIdx_2355= initIdxs_233c.begin(); itVar_2343!= vars_2336.end(), itInitFn_234c!= initFns_2339.end(), itInitIdx_2355!= initIdxs_233c.end(); ++itVar_2343, ++itInitFn_234c, ++itInitIdx_2355)
	{
		bool isUnique= isInputUnique( *itVar_2343, *itInitFn_234c, *itInitIdx_2355);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itVar_2343, *itInitFn_234c, *itInitIdx_2355);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.var_2361, currMatch.initFn_2362, currMatch.initIdx_2363);
	}
}

bool ArrayVar_2335::patternMatcher( const Udm::Object& var_2344, const Udm::Object& initFn_234d, const Udm::Object& initIdx_2356)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( var_2344.type(), SFC::Var::meta))
			continue;
		SFC::Var var_2349= SFC::Var::Cast( var_2344);
		if( false== Uml::IsDerivedFrom( initFn_234d.type(), SFC::Function::meta))
			continue;
		SFC::Function initFn_2352= SFC::Function::Cast( initFn_234d);
		if( false== Uml::IsDerivedFrom( initIdx_2356.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar initIdx_235b= SFC::LocalVar::Cast( initIdx_2356);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2360;
		if( !isValidBound(boundObjs_2360, var_2349, true))
			continue;
		currMatch.var_2361= var_2349;
		if( !isValidBound(boundObjs_2360, initFn_2352, true))
			continue;
		currMatch.initFn_2362= initFn_2352;
		if( !isValidBound(boundObjs_2360, initIdx_235b, true))
			continue;
		currMatch.initIdx_2363= initIdx_235b;
		bool Gz_guard= isGuardTrue( currMatch.initFn_2362, currMatch.initIdx_2363, currMatch.var_2361);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void ArrayVar_2335::outputAppender( const SFC::Var& var_2367, const SFC::Function& initFn_2369, const SFC::LocalVar& initIdx_236b)
{
	_var_233f->push_back( var_2367);
	_initFn_2340->push_back( initFn_2369);
	_initIdx_2341->push_back( initIdx_236b);
}

void ArrayVar_2335::sortOutputs()
{
	typedef std::multiset< SFC::Var, std::pointer_to_binary_function< const SFC::Var&, const SFC::Var&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const SFC::Var&, const SFC::Var&, bool> ptr_StatementOrder( StatementOrder< SFC::Var>);
	SortedSet_t sortedSet( ptr_StatementOrder);
	std::vector< int> permutationVector( _var_233f->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _var_233f->begin(); it!= _var_233f->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( SFC::Var::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _var_233f->begin());
	// order rest of the containers
	permutate( permutationVector, *_initFn_2340);
	permutate( permutationVector, *_initIdx_2341);
}

bool Otherwise_236d::operator()( const Packets_t& vars_236e, const Packets_t& initFns_2371, const Packets_t& initIdxs_2374, Packets_t& vars_2370, Packets_t& initFns_2373, Packets_t& initIdxs_2376)
{
#ifdef PRINT_INFO
	printLog( "Otherwise_236d" );
#endif
	_var_2377= &vars_2370;
	_initFn_2378= &initFns_2373;
	_initIdx_2379= &initIdxs_2376;
	processInputPackets( vars_236e, initFns_2371, initIdxs_2374);
	sortOutputs( );
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_236d::isInputUnique( const Udm::Object& var_237e, const Udm::Object& initFn_2387, const Udm::Object& initIdx_2390)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itVar_2380= _var_237a.begin(), itInitFn_2389= _initFn_2383.begin(), itInitIdx_2392= _initIdx_238c.begin(); itVar_2380!= _var_237a.end(), itInitFn_2389!= _initFn_2383.end(), itInitIdx_2392!= _initIdx_238c.end(); ++itVar_2380, ++itInitFn_2389, ++itInitIdx_2392)
	{
		if( ( *itVar_2380== var_237e)&& ( *itInitFn_2389== initFn_2387)&& ( *itInitIdx_2392== initIdx_2390))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_var_237a.push_back( var_237e);
		_initFn_2383.push_back( initFn_2387);
		_initIdx_238c.push_back( initIdx_2390);
	}
	return isUnique;
}

bool Otherwise_236d::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_236d::processInputPackets( const Packets_t& vars_236e, const Packets_t& initFns_2371, const Packets_t& initIdxs_2374)
{
	for( Packets_t::const_iterator itVar_237b= vars_236e.begin(), itInitFn_2384= initFns_2371.begin(), itInitIdx_238d= initIdxs_2374.begin(); itVar_237b!= vars_236e.end(), itInitFn_2384!= initFns_2371.end(), itInitIdx_238d!= initIdxs_2374.end(); ++itVar_237b, ++itInitFn_2384, ++itInitIdx_238d)
	{
		bool isUnique= isInputUnique( *itVar_237b, *itInitFn_2384, *itInitIdx_238d);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itVar_237b, *itInitFn_2384, *itInitIdx_238d);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.var_2399, currMatch.initFn_239a, currMatch.initIdx_239b);
	}
}

bool Otherwise_236d::patternMatcher( const Udm::Object& var_237c, const Udm::Object& initFn_2385, const Udm::Object& initIdx_238e)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( var_237c.type(), SFC::Var::meta))
			continue;
		SFC::Var var_2381= SFC::Var::Cast( var_237c);
		if( false== Uml::IsDerivedFrom( initFn_2385.type(), SFC::Function::meta))
			continue;
		SFC::Function initFn_238a= SFC::Function::Cast( initFn_2385);
		if( false== Uml::IsDerivedFrom( initIdx_238e.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar initIdx_2393= SFC::LocalVar::Cast( initIdx_238e);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2398;
		if( !isValidBound(boundObjs_2398, var_2381, true))
			continue;
		currMatch.var_2399= var_2381;
		if( !isValidBound(boundObjs_2398, initFn_238a, true))
			continue;
		currMatch.initFn_239a= initFn_238a;
		if( !isValidBound(boundObjs_2398, initIdx_2393, true))
			continue;
		currMatch.initIdx_239b= initIdx_2393;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_236d::outputAppender( const SFC::Var& var_239c, const SFC::Function& initFn_239e, const SFC::LocalVar& initIdx_23a0)
{
	_var_2377->push_back( var_239c);
	_initFn_2378->push_back( initFn_239e);
	_initIdx_2379->push_back( initIdx_23a0);
}

void Otherwise_236d::sortOutputs()
{
	typedef std::multiset< SFC::Var, std::pointer_to_binary_function< const SFC::Var&, const SFC::Var&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const SFC::Var&, const SFC::Var&, bool> ptr_StatementOrder( StatementOrder< SFC::Var>);
	SortedSet_t sortedSet( ptr_StatementOrder);
	std::vector< int> permutationVector( _var_2377->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _var_2377->begin(); it!= _var_2377->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( SFC::Var::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _var_2377->begin());
	// order rest of the containers
	permutate( permutationVector, *_initFn_2378);
	permutate( permutationVector, *_initIdx_2379);
}

void InitScalarVar_23a2::operator()( const Packets_t& vars_23a3, const Packets_t& initFns_23a5, const Packets_t& idxVars_23a7)
{
#ifdef PRINT_INFO
	printLog( "InitScalarVar_23a2" );
#endif
	RTTGenerator::Instance()->generateRule(1704, "InitScalarVar");
	processInputPackets( vars_23a3, initFns_23a5, idxVars_23a7);
}

bool InitScalarVar_23a2::isInputUnique( const Udm::Object& var_23ad, const Udm::Object& initFn_23b6, const Udm::Object& idxVar_23bf)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itVar_23af= _var_23a9.begin(), itInitFn_23b8= _initFn_23b2.begin(), itIdxVar_23c1= _idxVar_23bb.begin(); itVar_23af!= _var_23a9.end(), itInitFn_23b8!= _initFn_23b2.end(), itIdxVar_23c1!= _idxVar_23bb.end(); ++itVar_23af, ++itInitFn_23b8, ++itIdxVar_23c1)
	{
		if( ( *itVar_23af== var_23ad)&& ( *itInitFn_23b8== initFn_23b6)&& ( *itIdxVar_23c1== idxVar_23bf))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_var_23a9.push_back( var_23ad);
		_initFn_23b2.push_back( initFn_23b6);
		_idxVar_23bb.push_back( idxVar_23bf);
	}
	return isUnique;
}

bool InitScalarVar_23a2::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void InitScalarVar_23a2::processInputPackets( const Packets_t& vars_23a3, const Packets_t& initFns_23a5, const Packets_t& idxVars_23a7)
{
	for( Packets_t::const_iterator itVar_23aa= vars_23a3.begin(), itInitFn_23b3= initFns_23a5.begin(), itIdxVar_23bc= idxVars_23a7.begin(); itVar_23aa!= vars_23a3.end(), itInitFn_23b3!= initFns_23a5.end(), itIdxVar_23bc!= idxVars_23a7.end(); ++itVar_23aa, ++itInitFn_23b3, ++itIdxVar_23bc)
	{
		bool isUnique= isInputUnique( *itVar_23aa, *itInitFn_23b3, *itIdxVar_23bc);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itVar_23aa, *itInitFn_23b3, *itIdxVar_23bc);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitScalarVar_23a2::patternMatcher( const Udm::Object& var_23ab, const Udm::Object& initFn_23b4, const Udm::Object& idxVar_23bd)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( var_23ab.type(), SFC::Var::meta))
			continue;
		SFC::Var var_23b0= SFC::Var::Cast( var_23ab);
		if( false== Uml::IsDerivedFrom( initFn_23b4.type(), SFC::Function::meta))
			continue;
		SFC::Function initFn_23b9= SFC::Function::Cast( initFn_23b4);
		if( false== Uml::IsDerivedFrom( idxVar_23bd.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar idxVar_23c2= SFC::LocalVar::Cast( idxVar_23bd);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_23c7;
		if( !isValidBound(boundObjs_23c7, var_23b0, true))
			continue;
		currMatch.var_23c8= var_23b0;
		if( !isValidBound(boundObjs_23c7, initFn_23b9, true))
			continue;
		currMatch.initFn_23c9= initFn_23b9;
		if( !isValidBound(boundObjs_23c7, idxVar_23c2, true))
			continue;
		currMatch.idxVar_23ca= idxVar_23c2;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void InitScalarVar_23a2::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar& IdxVar= currMatch.idxVar_23ca;
		SFC::Function& InitFn= currMatch.initFn_23c9;
		SFC::Var& Var= currMatch.var_23c8;
		{
SFManager::initVar( InitFn, Var );
};
	}
}

void TestEAIOn_23db::operator()( const Packets_t& states_23dc, const Packets_t& initfns_23de, Packets_t& states_23e0, Packets_t& initfns_23e1)
{
#ifdef PRINT_INFO
	printLog( "TestEAIOn_23db" );
#endif
	_state_23e2= &states_23e0;
	_initfn_23e3= &initfns_23e1;
	for( Packets_t::const_iterator itstate_23e5= states_23dc.begin(), itinitfn_23ec= initfns_23de.begin(); itstate_23e5!= states_23dc.end(), itinitfn_23ec!= initfns_23de.end(); ++itstate_23e5, ++itinitfn_23ec)
	{
		bool isUnique= isInputUnique( *itstate_23e5, *itinitfn_23ec);
		if( !isUnique)
			continue;
		Packets_t onestate_23e9( 1, *itstate_23e5);
		Packets_t oneinitfn_23f0( 1, *itinitfn_23ec);
		executeOne( onestate_23e9, oneinitfn_23f0);
	}
}

void TestEAIOn_23db::executeOne( const Packets_t& states_23dc, const Packets_t& initfns_23de)
{
	Packets_t states_23f5;
	Packets_t initFns_23f8;
	EAIOn_23f2 eAIOn_23f2;
	bool isMatchEAIOn_23f2= eAIOn_23f2( states_23dc, initfns_23de, states_23f5, initFns_23f8);
	_state_23e2->insert( _state_23e2->end(), states_23f5.begin(), states_23f5.end());
	_initfn_23e3->insert( _initfn_23e3->end(), initFns_23f8.begin(), initFns_23f8.end());
}

bool TestEAIOn_23db::isInputUnique( const Udm::Object& state_23e6, const Udm::Object& initfn_23ed)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_23e8= _state_23e4.begin(), itinitfn_23ef= _initfn_23eb.begin(); itstate_23e8!= _state_23e4.end(), itinitfn_23ef!= _initfn_23eb.end(); ++itstate_23e8, ++itinitfn_23ef)
	{
		if( ( *itstate_23e8== state_23e6)&& ( *itinitfn_23ef== initfn_23ed))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_23e4.push_back( state_23e6);
		_initfn_23eb.push_back( initfn_23ed);
	}
	return isUnique;
}

bool EAIOn_23f2::operator()( const Packets_t& states_23f3, const Packets_t& initFns_23f6, Packets_t& states_23f5, Packets_t& initFns_23f8)
{
#ifdef PRINT_INFO
	printLog( "EAIOn_23f2" );
#endif
	_state_23f9= &states_23f5;
	_initFn_23fa= &initFns_23f8;
	processInputPackets( states_23f3, initFns_23f6);
	if( false== _matches.empty())
		return true;
	return false;
}

bool EAIOn_23f2::isInputUnique( const Udm::Object& state_23ff, const Udm::Object& initFn_2408)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_2401= _state_23fb.begin(), itInitFn_240a= _initFn_2404.begin(); itState_2401!= _state_23fb.end(), itInitFn_240a!= _initFn_2404.end(); ++itState_2401, ++itInitFn_240a)
	{
		if( ( *itState_2401== state_23ff)&& ( *itInitFn_240a== initFn_2408))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_23fb.push_back( state_23ff);
		_initFn_2404.push_back( initFn_2408);
	}
	return isUnique;
}

bool EAIOn_23f2::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool EAIOn_23f2::isGuardTrue( CyPhyML::SignalFlow::ConnectorRef& ConnectorRef, SFC::Function& InitFn, CyPhyML::SignalFlow::SF_Parameter& Parameter, CyPhyML::SignalFlow::Primitive& Primitive, CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::Subsystem& Subsystem)
{
	bool Gz_guard= false;
	return static_cast< std::string >( Parameter.name() ) == "ExecuteAtInitialization" &&
 static_cast< std::string >(  Parameter.Value() ) == "on";;
	return Gz_guard;
}

void EAIOn_23f2::processInputPackets( const Packets_t& states_23f3, const Packets_t& initFns_23f6)
{
	for( Packets_t::const_iterator itState_23fc= states_23f3.begin(), itInitFn_2405= initFns_23f6.begin(); itState_23fc!= states_23f3.end(), itInitFn_2405!= initFns_23f6.end(); ++itState_23fc, ++itInitFn_2405)
	{
		bool isUnique= isInputUnique( *itState_23fc, *itInitFn_2405);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_23fc, *itInitFn_2405);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_241b, currMatch.initFn_241c);
	}
}

bool EAIOn_23f2::patternMatcher( const Udm::Object& state_23fd, const Udm::Object& initFn_2406)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_23fd.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_2402= CyPhyML::SignalFlow::State::Cast( state_23fd);
		if( false== Uml::IsDerivedFrom( initFn_2406.type(), SFC::Function::meta))
			continue;
		SFC::Function initFn_240b= SFC::Function::Cast( initFn_2406);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_240d= state_2402.referedbyConnectorRef();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRefs_240e= connectorRefs_240d.begin(); itConnectorRefs_240e!= connectorRefs_240d.end(); ++itConnectorRefs_240e)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_240f= *itConnectorRefs_240e;
			Udm::Object connectorRefParent_2410= currConnectorRef_240f.container();
			if( false== Uml::IsDerivedFrom( connectorRefParent_2410.type(), CyPhyML::SignalFlow::Primitive::meta))
				continue;
			CyPhyML::SignalFlow::Primitive primitiveConnectorRef_2411= CyPhyML::SignalFlow::Primitive::Cast( connectorRefParent_2410);
			Udm::Object primitiveParent_2412= primitiveConnectorRef_2411.container();
			if( false== Uml::IsDerivedFrom( primitiveParent_2412.type(), CyPhyML::SignalFlow::Subsystem::meta))
				continue;
			CyPhyML::SignalFlow::Subsystem subsystemPrimitive_2413= CyPhyML::SignalFlow::Subsystem::Cast( primitiveParent_2412);
			set< CyPhyML::SignalFlow::SF_Parameter> parameters_2414= subsystemPrimitive_2413.SF_Parameter_kind_children();
			for( set< CyPhyML::SignalFlow::SF_Parameter>::const_iterator itParameter_2415= parameters_2414.begin(); itParameter_2415!= parameters_2414.end(); ++itParameter_2415)
			{
				CyPhyML::SignalFlow::SF_Parameter currParameter_2416= *itParameter_2415;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_241a;
				if( !isValidBound(boundObjs_241a, state_2402, true))
					continue;
				currMatch.state_241b= state_2402;
				if( !isValidBound(boundObjs_241a, initFn_240b, true))
					continue;
				currMatch.initFn_241c= initFn_240b;
				if( !isValidBound(boundObjs_241a, currConnectorRef_240f, false))
					continue;
				currMatch.connectorRef_241d= currConnectorRef_240f;
				if( !isValidBound(boundObjs_241a, primitiveConnectorRef_2411, false))
					continue;
				currMatch.primitive_241e= primitiveConnectorRef_2411;
				if( !isValidBound(boundObjs_241a, currParameter_2416, false))
					continue;
				currMatch.parameter_241f= currParameter_2416;
				if( !isValidBound(boundObjs_241a, subsystemPrimitive_2413, false))
					continue;
				currMatch.subsystem_2420= subsystemPrimitive_2413;
				bool Gz_guard= isGuardTrue( currMatch.connectorRef_241d, currMatch.initFn_241c, currMatch.parameter_241f, currMatch.primitive_241e, currMatch.state_241b, currMatch.subsystem_2420);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void EAIOn_23f2::outputAppender( const CyPhyML::SignalFlow::State& state_2427, const SFC::Function& initFn_2429)
{
	_state_23f9->push_back( state_2427);
	_initFn_23fa->push_back( initFn_2429);
}

void MarkLegacy_243c::operator()( const Packets_t& states_243d, const Packets_t& programs_243f)
{
#ifdef PRINT_INFO
	printLog( "MarkLegacy_243c" );
#endif
	RTTGenerator::Instance()->generateRule(1725, "MarkLegacy");
	processInputPackets( states_243d, programs_243f);
}

bool MarkLegacy_243c::isInputUnique( const Udm::Object& state_2445, const Udm::Object& program_244e)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_2447= _state_2441.begin(), itProgram_2450= _program_244a.begin(); itState_2447!= _state_2441.end(), itProgram_2450!= _program_244a.end(); ++itState_2447, ++itProgram_2450)
	{
		if( ( *itState_2447== state_2445)&& ( *itProgram_2450== program_244e))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_2441.push_back( state_2445);
		_program_244a.push_back( program_244e);
	}
	return isUnique;
}

bool MarkLegacy_243c::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void MarkLegacy_243c::processInputPackets( const Packets_t& states_243d, const Packets_t& programs_243f)
{
	for( Packets_t::const_iterator itState_2442= states_243d.begin(), itProgram_244b= programs_243f.begin(); itState_2442!= states_243d.end(), itProgram_244b!= programs_243f.end(); ++itState_2442, ++itProgram_244b)
	{
		bool isUnique= isInputUnique( *itState_2442, *itProgram_244b);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_2442, *itProgram_244b);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool MarkLegacy_243c::patternMatcher( const Udm::Object& state_2443, const Udm::Object& program_244c)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_2443.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_2448= CyPhyML::SignalFlow::State::Cast( state_2443);
		if( false== Uml::IsDerivedFrom( program_244c.type(), SFC::Program::meta))
			continue;
		SFC::Program program_2451= SFC::Program::Cast( program_244c);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2456;
		if( !isValidBound(boundObjs_2456, state_2448, true))
			continue;
		currMatch.state_2457= state_2448;
		if( !isValidBound(boundObjs_2456, program_2451, true))
			continue;
		currMatch.program_2458= program_2451;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void MarkLegacy_243c::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Program& Program= currMatch.program_2458;
		CyPhyML::SignalFlow::State& State= currMatch.state_2457;
		{
__int64 statementCount = Program.statementCount();
if ( statementCount > 0 ) statementCount = -statementCount;
Program.statementCount() = statementCount;
};
	}
}

void CreateFunctions_2459::operator()( const Packets_t& states_245a, const Packets_t& programs_245c, Packets_t& states_245e, Packets_t& programs_245f)
{
#ifdef PRINT_INFO
	printLog( "CreateFunctions_2459" );
#endif
	_state_2460= &states_245e;
	_program_2461= &programs_245f;
	_state_2460->insert( _state_2460->end(), states_245a.begin(), states_245a.end());
	_program_2461->insert( _program_2461->end(), programs_245c.begin(), programs_245c.end());
	if( ( !states_245a.empty())&& ( !programs_245c.empty()))
		callCreateFunctions_2495( states_245a, programs_245c);
}

void CreateFunctions_2459::callCreateFunctions_2495( const Packets_t& states_2463, const Packets_t& programs_2466)
{
	Packets_t states_2465;
	Packets_t programs_2468;
	CreateFunctions_2462 createFunctions_2462;
	createFunctions_2462( states_2463, programs_2466, states_2465, programs_2468);
	if( ( !states_2465.empty())&& ( !programs_2468.empty()))
		callGetSubStates_2498( states_2465, programs_2468);
}

void CreateFunctions_2459::callGetSubStates_2498( const Packets_t& states_c8c, const Packets_t& parStmnts_c8f)
{
	Packets_t subStates_c8e;
	Packets_t parStmnts_c91;
	GetSubStates_c8b getSubStates_c8b;
	getSubStates_c8b( states_c8c, parStmnts_c8f, subStates_c8e, parStmnts_c91);
	if( ( !subStates_c8e.empty())&& ( !parStmnts_c91.empty()))
		callCreateFunctions_2495( subStates_c8e, parStmnts_c91);
}

void CreateFunctions_2462::operator()( const Packets_t& states_2463, const Packets_t& programs_2466, Packets_t& states_2465, Packets_t& programs_2468)
{
#ifdef PRINT_INFO
	printLog( "CreateFunctions_2462" );
#endif
	RTTGenerator::Instance()->generateRule(1734, "CreateFunctions");
	_state_2469= &states_2465;
	_program_246a= &programs_2468;
	processInputPackets( states_2463, programs_2466);
	forwardInputs( );
}

bool CreateFunctions_2462::isInputUnique( const Udm::Object& state_246f, const Udm::Object& program_2478)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_2471= _state_246b.begin(), itProgram_247a= _program_2474.begin(); itState_2471!= _state_246b.end(), itProgram_247a!= _program_2474.end(); ++itState_2471, ++itProgram_247a)
	{
		if( ( *itState_2471== state_246f)&& ( *itProgram_247a== program_2478))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_246b.push_back( state_246f);
		_program_2474.push_back( program_2478);
	}
	return isUnique;
}

bool CreateFunctions_2462::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool CreateFunctions_2462::isGuardTrue( SFC::Program& Program, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( State.Decomposition() ) != "FUNC_STATE";;
	return Gz_guard;
}

void CreateFunctions_2462::processInputPackets( const Packets_t& states_2463, const Packets_t& programs_2466)
{
	for( Packets_t::const_iterator itState_246c= states_2463.begin(), itProgram_2475= programs_2466.begin(); itState_246c!= states_2463.end(), itProgram_2475!= programs_2466.end(); ++itState_246c, ++itProgram_2475)
	{
		bool isUnique= isInputUnique( *itState_246c, *itProgram_2475);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_246c, *itProgram_2475);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateFunctions_2462::patternMatcher( const Udm::Object& state_246d, const Udm::Object& program_2476)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_246d.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_2472= CyPhyML::SignalFlow::State::Cast( state_246d);
		if( false== Uml::IsDerivedFrom( program_2476.type(), SFC::Program::meta))
			continue;
		SFC::Program program_247b= SFC::Program::Cast( program_2476);
		set< SFC::StateLabel> stateLabels_247d= state_2472.src();
		for( set< SFC::StateLabel>::const_iterator itStateLabels_247e= stateLabels_247d.begin(); itStateLabels_247e!= stateLabels_247d.end(); ++itStateLabels_247e)
		{
			SFC::StateLabel currStateLabel_247f= *itStateLabels_247e;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_2483;
			if( !isValidBound(boundObjs_2483, state_2472, true))
				continue;
			currMatch.state_2484= state_2472;
			if( !isValidBound(boundObjs_2483, program_247b, true))
				continue;
			currMatch.program_2485= program_247b;
			if( !isValidBound(boundObjs_2483, currStateLabel_247f, false))
				continue;
			currMatch.stateLabel_2486= currStateLabel_247f;
			bool Gz_guard= isGuardTrue( currMatch.program_2485, currMatch.state_2484, currMatch.stateLabel_2486);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateFunctions_2462::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function newStatus_248a= SFC::Function::Create( currMatch.program_2485, SFC::Program::meta_stmnt);
		SFC::Arg newIndentArg_248b= SFC::Arg::Create( newStatus_248a);
		SFC::Function newEnter_248c= SFC::Function::Create( currMatch.program_2485, SFC::Program::meta_stmnt);
		SFC::Arg newModeArg_248d= SFC::Arg::Create( newEnter_248c);
		SFC::Function newExec_248e= SFC::Function::Create( currMatch.program_2485, SFC::Program::meta_stmnt);
		SFC::LocalVar newExecTCVar_248f= SFC::LocalVar::Create( newExec_248e, SFC::Function::meta_stmnt);
		SFC::LocalVar newEnterTCVar_2490= SFC::LocalVar::Create( newEnter_248c, SFC::Function::meta_stmnt);
		SFC::Function newExit_2491= SFC::Function::Create( currMatch.program_2485, SFC::Program::meta_stmnt);
		SFC::Arg newTrParArg_2492= SFC::Arg::Create( newExit_2491);
		SFC::LocalVar newExecHTPVar_2493= SFC::LocalVar::Create( newExec_248e, SFC::Function::meta_stmnt);
		SFC::Arg newTrPathParArg_2494= SFC::Arg::Create( newEnter_248c);
		SFC::Function& Enter= newEnter_248c;
		SFC::LocalVar& EnterTCVar= newEnterTCVar_2490;
		SFC::Function& Exec= newExec_248e;
		SFC::LocalVar& ExecHTPVar= newExecHTPVar_2493;
		SFC::LocalVar& ExecTCVar= newExecTCVar_248f;
		SFC::Function& Exit= newExit_2491;
		SFC::Arg& IndentArg= newIndentArg_248b;
		SFC::Arg& ModeArg= newModeArg_248d;
		SFC::Program& Program= currMatch.program_2485;
		CyPhyML::SignalFlow::State& State= currMatch.state_2484;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_2486;
		SFC::Function& Status= newStatus_248a;
		SFC::Arg& TrParArg= newTrParArg_2492;
		SFC::Arg& TrPathParArg= newTrPathParArg_2494;
		{
__int64 statementCount = Program.statementCount();
Enter.statementIndex() = statementCount++;
Exec.statementIndex()  = statementCount++;
Exit.statementIndex()  = statementCount++;
Status.statementIndex()  = statementCount++;
Program.statementCount() = statementCount;
};
		{
__int64 statementCount = Enter.statementCount();
EnterTCVar.statementIndex() = statementCount++;
Enter.statementCount() = statementCount;
};
		{
__int64 statementCount = Exec.statementCount();
ExecTCVar.statementIndex() = statementCount++;
ExecHTPVar.statementIndex() = statementCount++;
Exec.statementCount() = statementCount;
};
		{
ModeArg.name() = "entryMode";
ModeArg.dt() = SFCTypesManager::getSingleton().getBasicType( "int" );
ModeArg.argIndex() = 0;

TrPathParArg.name() = "tpp";
TrPathParArg.dt() = SFCTypesManager::getSingleton().getBasicType( "int" );
TrPathParArg.argIndex() = 1;

Enter.argCount() = 2;
};
		{
Status.dt() = SFCTypesManager::getSingleton().getBasicType( "string" );
};
		{
TrParArg.name() = "_transitionParent_";
TrParArg.dt() = SFCTypesManager::getSingleton().getBasicType( "int" );
TrParArg.argIndex() = 0;

Exit.argCount() = 1;
};
		{
Enter.annotation() = State.Description();
};
		{
Enter.RefId() = Exec.RefId() = Exit.RefId() = Status.RefId() = EnterTCVar.RefId() = ExecHTPVar.RefId() = ExecTCVar.RefId() = ModeArg.RefId() = TrPathParArg.RefId() = TrParArg.RefId() = IndentArg.RefId() = State.RefId();
};
		{
EnterTCVar.name() = "_TCVar_";
EnterTCVar.dt() = SFCTypesManager::getSingleton().getBasicType( "int32" );
};
		{
__int64 argCount = Status.argCount();
IndentArg.argIndex() = argCount++;
Status.argCount() = argCount;

IndentArg.dt() = SFCTypesManager::getSingleton().getBasicType( "string" );
IndentArg.name() = "indent";
};
		{
std::string name = static_cast< std::string >( State.name() ) + "_" + boost::lexical_cast< std::string >( State.uniqueId() );
Enter.name() = name + "_enter";
Enter.scope() = StateLabel.comment();
Exec.name() = name + "_exec";
Exec.scope() = StateLabel.comment();
Exit.name() = name + "_exit";
Exit.scope() = StateLabel.comment();
Status.name() = name + "_status";
Status.scope() = StateLabel.comment();
};
		{
ExecHTPVar.name() = "_HTPVar_";
ExecHTPVar.dt() = SFCTypesManager::getSingleton().getBasicType( "int32" );
ExecTCVar.name() = "_TCVar_";
ExecTCVar.dt() = SFCTypesManager::getSingleton().getBasicType( "int32" );
};
		newEnter_248c.enterSt()+= currMatch.state_2484;
		newExit_2491.exitSt()+= currMatch.state_2484;
		newExec_248e.execSt()+= currMatch.state_2484;
		newStatus_248a.statusSt()+= currMatch.state_2484;
	}
}

void CreateFunctions_2462::forwardInputs()
{
	*_state_2469= _state_246b;
	*_program_246a= _program_2474;
}

void CreateDEVars_249b::operator()( const Packets_t& states_249c, const Packets_t& programs_249e, Packets_t& states_24a0, Packets_t& programs_24a1)
{
#ifdef PRINT_INFO
	printLog( "CreateDEVars_249b" );
#endif
	_state_24a2= &states_24a0;
	_program_24a3= &programs_24a1;
	if( ( !states_249c.empty())&& ( !programs_249e.empty()))
		callCheckStateDecomp_27d7( states_249c, programs_249e);
	_state_24a2->insert( _state_24a2->end(), states_249c.begin(), states_249c.end());
	_program_24a3->insert( _program_24a3->end(), programs_249e.begin(), programs_249e.end());
}

void CreateDEVars_249b::callCheckStateDecomp_27d7( const Packets_t& states_20a3, const Packets_t& programs_20a5)
{
	Packets_t states_20a7;
	Packets_t programs_20a8;
	Packets_t states_20a9;
	Packets_t programs_20aa;
	CheckStateDecomp_20a2 checkStateDecomp_20a2;
	checkStateDecomp_20a2( states_20a3, programs_20a5, states_20a7, programs_20a8, states_20a9, programs_20aa);
	if( ( !states_20a9.empty())&& ( !programs_20aa.empty()))
		callCreateDataVar_27da( states_20a9, programs_20aa);
	if( ( !states_20a7.empty())&& ( !programs_20a8.empty()))
		callGetSubStates_27dd( states_20a7, programs_20a8);
}

void CreateDEVars_249b::callCreateDataVar_27da( const Packets_t& states_24a5, const Packets_t& programs_24a7)
{
	Packets_t states_24a9;
	Packets_t programs_24aa;
	CreateDataVar_24a4 createDataVar_24a4;
	createDataVar_24a4( states_24a5, programs_24a7, states_24a9, programs_24aa);
	if( ( !states_24a9.empty())&& ( !programs_24aa.empty()))
		callCreateStoreVar_27e0( states_24a9, programs_24aa);
}

void CreateDEVars_249b::callGetSubStates_27dd( const Packets_t& states_c8c, const Packets_t& parStmnts_c8f)
{
	Packets_t subStates_c8e;
	Packets_t parStmnts_c91;
	GetSubStates_c8b getSubStates_c8b;
	getSubStates_c8b( states_c8c, parStmnts_c8f, subStates_c8e, parStmnts_c91);
	if( ( !subStates_c8e.empty())&& ( !parStmnts_c91.empty()))
		callCheckStateDecomp_27d7( subStates_c8e, parStmnts_c91);
}

void CreateDEVars_249b::callCreateStoreVar_27e0( const Packets_t& states_2520, const Packets_t& programs_2522)
{
	Packets_t states_2524;
	Packets_t programs_2525;
	CreateStoreVar_251f createStoreVar_251f;
	createStoreVar_251f( states_2520, programs_2522, states_2524, programs_2525);
	if( ( !states_2524.empty())&& ( !programs_2525.empty()))
		callCreateEventVar_27e3( states_2524, programs_2525);
}

void CreateDEVars_249b::callCreateEventVar_27e3( const Packets_t& states_24e6, const Packets_t& programs_24e8)
{
	Packets_t states_24ea;
	Packets_t programs_24eb;
	CreateEventVar_24e5 createEventVar_24e5;
	createEventVar_24e5( states_24e6, programs_24e8, states_24ea, programs_24eb);
	if( ( !states_24ea.empty())&& ( !programs_24eb.empty()))
		callGetSubStates_27dd( states_24ea, programs_24eb);
}

void CreateDataVar_24a4::operator()( const Packets_t& states_24a5, const Packets_t& programs_24a7, Packets_t& states_24a9, Packets_t& programs_24aa)
{
#ifdef PRINT_INFO
	printLog( "CreateDataVar_24a4" );
#endif
	_state_24ab= &states_24a9;
	_program_24ac= &programs_24aa;
	if( ( !states_24a5.empty())&& ( !programs_24a7.empty()))
		callCreateDataVar_24e2( states_24a5, programs_24a7);
	_state_24ab->insert( _state_24ab->end(), states_24a5.begin(), states_24a5.end());
	_program_24ac->insert( _program_24ac->end(), programs_24a7.begin(), programs_24a7.end());
}

void CreateDataVar_24a4::callCreateDataVar_24e2( const Packets_t& states_24ae, const Packets_t& programs_24b0)
{
	CreateDataVar_24ad createDataVar_24ad;
	createDataVar_24ad( states_24ae, programs_24b0);
}

void CreateDataVar_24ad::operator()( const Packets_t& states_24ae, const Packets_t& programs_24b0)
{
#ifdef PRINT_INFO
	printLog( "CreateDataVar_24ad" );
#endif
	RTTGenerator::Instance()->generateRule(1787, "CreateDataVar");
	processInputPackets( states_24ae, programs_24b0);
}

bool CreateDataVar_24ad::isInputUnique( const Udm::Object& state_24b6, const Udm::Object& program_24bf)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_24b8= _state_24b2.begin(), itProgram_24c1= _program_24bb.begin(); itState_24b8!= _state_24b2.end(), itProgram_24c1!= _program_24bb.end(); ++itState_24b8, ++itProgram_24c1)
	{
		if( ( *itState_24b8== state_24b6)&& ( *itProgram_24c1== program_24bf))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_24b2.push_back( state_24b6);
		_program_24bb.push_back( program_24bf);
	}
	return isUnique;
}

bool CreateDataVar_24ad::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool CreateDataVar_24ad::isGuardTrue( SFC::DT& DT, CyPhyML::SignalFlow::Data& Data, SFC::Program& Program, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel, CyPhyML::SignalFlow::SF_TypeBase& TypeBase, CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Data.Scope() ) != "STORE_DATA";;
	return Gz_guard;
}

void CreateDataVar_24ad::processInputPackets( const Packets_t& states_24ae, const Packets_t& programs_24b0)
{
	for( Packets_t::const_iterator itState_24b3= states_24ae.begin(), itProgram_24bc= programs_24b0.begin(); itState_24b3!= states_24ae.end(), itProgram_24bc!= programs_24b0.end(); ++itState_24b3, ++itProgram_24bc)
	{
		bool isUnique= isInputUnique( *itState_24b3, *itProgram_24bc);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_24b3, *itProgram_24bc);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateDataVar_24ad::patternMatcher( const Udm::Object& state_24b4, const Udm::Object& program_24bd)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_24b4.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_24b9= CyPhyML::SignalFlow::State::Cast( state_24b4);
		if( false== Uml::IsDerivedFrom( program_24bd.type(), SFC::Program::meta))
			continue;
		SFC::Program program_24c2= SFC::Program::Cast( program_24bd);
		set< CyPhyML::SignalFlow::Data> datas_24c4= state_24b9.Data_kind_children();
		for( set< CyPhyML::SignalFlow::Data>::const_iterator itData_24c5= datas_24c4.begin(); itData_24c5!= datas_24c4.end(); ++itData_24c5)
		{
			CyPhyML::SignalFlow::Data currData_24c6= *itData_24c5;
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_24c7= currData_24c6.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_24c8= typeBaseRefs_24c7.begin(); itTypeBaseRef_24c8!= typeBaseRefs_24c7.end(); ++itTypeBaseRef_24c8)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_24c9= *itTypeBaseRef_24c8;
				CyPhyML::SignalFlow::SF_TypeBase typeBase_24ca= currTypeBaseRef_24c9.ref();
				if( !typeBase_24ca)
					continue;
				SFC::DT dT_24cb= typeBase_24ca.dt();
				if( !dT_24cb)
					continue;
				set< SFC::StateLabel> stateLabels_24cc= state_24b9.src();
				for( set< SFC::StateLabel>::const_iterator itStateLabels_24cd= stateLabels_24cc.begin(); itStateLabels_24cd!= stateLabels_24cc.end(); ++itStateLabels_24cd)
				{
					SFC::StateLabel currStateLabel_24ce= *itStateLabels_24cd;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_24d2;
					if( !isValidBound(boundObjs_24d2, state_24b9, true))
						continue;
					currMatch.state_24d3= state_24b9;
					if( !isValidBound(boundObjs_24d2, program_24c2, true))
						continue;
					currMatch.program_24d4= program_24c2;
					if( !isValidBound(boundObjs_24d2, currStateLabel_24ce, false))
						continue;
					currMatch.stateLabel_24d5= currStateLabel_24ce;
					if( !isValidBound(boundObjs_24d2, currData_24c6, false))
						continue;
					currMatch.data_24d6= currData_24c6;
					if( !isValidBound(boundObjs_24d2, currTypeBaseRef_24c9, false))
						continue;
					currMatch.typeBaseRef_24d7= currTypeBaseRef_24c9;
					if( !isValidBound(boundObjs_24d2, typeBase_24ca, false))
						continue;
					currMatch.typeBase_24d8= typeBase_24ca;
					if( !isValidBound(boundObjs_24d2, dT_24cb, false))
						continue;
					currMatch.dT_24d9= dT_24cb;
					bool Gz_guard= isGuardTrue( currMatch.dT_24d9, currMatch.data_24d6, currMatch.program_24d4, currMatch.state_24d3, currMatch.stateLabel_24d5, currMatch.typeBase_24d8, currMatch.typeBaseRef_24d7);
					if( true== Gz_guard)
						_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void CreateDataVar_24ad::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar newLocalVar_24e1= SFC::LocalVar::Create( currMatch.program_24d4);
		SFC::DT& DT= currMatch.dT_24d9;
		CyPhyML::SignalFlow::Data& Data= currMatch.data_24d6;
		SFC::LocalVar& LocalVar= newLocalVar_24e1;
		SFC::Program& Program= currMatch.program_24d4;
		CyPhyML::SignalFlow::State& State= currMatch.state_24d3;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_24d5;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_24d8;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_24d7;
		{
LocalVar.RefId() = Data.RefId();
};
		{
__int64 statementCount = Program.statementCount();
LocalVar.statementIndex() = statementCount++;
Program.statementCount() = statementCount;
};
		{
std::string dataName = Data.Name();
if(dataName.empty())
	dataName = Data.name();
LocalVar.name() = dataName;
LocalVar.scope() = StateLabel.comment(); /* comment contains the extend state name */
LocalVar.initial() = Data.InitialValue();
LocalVar.indexBase() = Data.ArrayFirstIndex();

SFManager::AddTypedEntityScope( LocalVar );
};
		newLocalVar_24e1.dt()= currMatch.dT_24d9;
		newLocalVar_24e1.data()+= currMatch.data_24d6;
	}
}

void CreateEventVar_24e5::operator()( const Packets_t& states_24e6, const Packets_t& programs_24e8, Packets_t& states_24ea, Packets_t& programs_24eb)
{
#ifdef PRINT_INFO
	printLog( "CreateEventVar_24e5" );
#endif
	_state_24ec= &states_24ea;
	_program_24ed= &programs_24eb;
	if( ( !states_24e6.empty())&& ( !programs_24e8.empty()))
		callCreateEventVar_251c( states_24e6, programs_24e8);
	_state_24ec->insert( _state_24ec->end(), states_24e6.begin(), states_24e6.end());
	_program_24ed->insert( _program_24ed->end(), programs_24e8.begin(), programs_24e8.end());
}

void CreateEventVar_24e5::callCreateEventVar_251c( const Packets_t& states_24ef, const Packets_t& programs_24f1)
{
	CreateEventVar_24ee createEventVar_24ee;
	createEventVar_24ee( states_24ef, programs_24f1);
}

void CreateEventVar_24ee::operator()( const Packets_t& states_24ef, const Packets_t& programs_24f1)
{
#ifdef PRINT_INFO
	printLog( "CreateEventVar_24ee" );
#endif
	RTTGenerator::Instance()->generateRule(1812, "CreateEventVar");
	processInputPackets( states_24ef, programs_24f1);
}

bool CreateEventVar_24ee::isInputUnique( const Udm::Object& state_24f7, const Udm::Object& program_2500)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_24f9= _state_24f3.begin(), itProgram_2502= _program_24fc.begin(); itState_24f9!= _state_24f3.end(), itProgram_2502!= _program_24fc.end(); ++itState_24f9, ++itProgram_2502)
	{
		if( ( *itState_24f9== state_24f7)&& ( *itProgram_2502== program_2500))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_24f3.push_back( state_24f7);
		_program_24fc.push_back( program_2500);
	}
	return isUnique;
}

bool CreateEventVar_24ee::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateEventVar_24ee::processInputPackets( const Packets_t& states_24ef, const Packets_t& programs_24f1)
{
	for( Packets_t::const_iterator itState_24f4= states_24ef.begin(), itProgram_24fd= programs_24f1.begin(); itState_24f4!= states_24ef.end(), itProgram_24fd!= programs_24f1.end(); ++itState_24f4, ++itProgram_24fd)
	{
		bool isUnique= isInputUnique( *itState_24f4, *itProgram_24fd);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_24f4, *itProgram_24fd);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateEventVar_24ee::patternMatcher( const Udm::Object& state_24f5, const Udm::Object& program_24fe)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_24f5.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_24fa= CyPhyML::SignalFlow::State::Cast( state_24f5);
		if( false== Uml::IsDerivedFrom( program_24fe.type(), SFC::Program::meta))
			continue;
		SFC::Program program_2503= SFC::Program::Cast( program_24fe);
		set< CyPhyML::SignalFlow::Event> events_2505= state_24fa.Event_kind_children();
		for( set< CyPhyML::SignalFlow::Event>::const_iterator itEvent_2506= events_2505.begin(); itEvent_2506!= events_2505.end(); ++itEvent_2506)
		{
			CyPhyML::SignalFlow::Event currEvent_2507= *itEvent_2506;
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_2508= currEvent_2507.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_2509= typeBaseRefs_2508.begin(); itTypeBaseRef_2509!= typeBaseRefs_2508.end(); ++itTypeBaseRef_2509)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_250a= *itTypeBaseRef_2509;
				CyPhyML::SignalFlow::SF_TypeBase typeBase_250b= currTypeBaseRef_250a.ref();
				if( !typeBase_250b)
					continue;
				SFC::DT dT_250c= typeBase_250b.dt();
				if( !dT_250c)
					continue;
				set< SFC::StateLabel> stateLabels_250d= state_24fa.src();
				for( set< SFC::StateLabel>::const_iterator itStateLabels_250e= stateLabels_250d.begin(); itStateLabels_250e!= stateLabels_250d.end(); ++itStateLabels_250e)
				{
					SFC::StateLabel currStateLabel_250f= *itStateLabels_250e;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_2513;
					if( !isValidBound(boundObjs_2513, state_24fa, true))
						continue;
					currMatch.state_2514= state_24fa;
					if( !isValidBound(boundObjs_2513, program_2503, true))
						continue;
					currMatch.program_2515= program_2503;
					if( !isValidBound(boundObjs_2513, currStateLabel_250f, false))
						continue;
					currMatch.stateLabel_2516= currStateLabel_250f;
					if( !isValidBound(boundObjs_2513, currEvent_2507, false))
						continue;
					currMatch.event_2517= currEvent_2507;
					if( !isValidBound(boundObjs_2513, currTypeBaseRef_250a, false))
						continue;
					currMatch.typeBaseRef_2518= currTypeBaseRef_250a;
					if( !isValidBound(boundObjs_2513, typeBase_250b, false))
						continue;
					currMatch.typeBase_2519= typeBase_250b;
					if( !isValidBound(boundObjs_2513, dT_250c, false))
						continue;
					currMatch.dT_251a= dT_250c;
					_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void CreateEventVar_24ee::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar newLocalVar_251b= SFC::LocalVar::Create( currMatch.program_2515);
		SFC::DT& DT= currMatch.dT_251a;
		CyPhyML::SignalFlow::Event& Event= currMatch.event_2517;
		SFC::LocalVar& LocalVar= newLocalVar_251b;
		SFC::Program& Program= currMatch.program_2515;
		CyPhyML::SignalFlow::State& State= currMatch.state_2514;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_2516;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_2519;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_2518;
		{
LocalVar.RefId() = Event.RefId();
};
		{
__int64 sc;
Program.GetIntValue("statementCount", sc);
LocalVar.SetIntValue("statementIndex", sc++);
Program.SetIntValue("statementCount", sc);
};
		{
LocalVar.name() = Event.name();
LocalVar.initial() = "0";
LocalVar.scope() = StateLabel.comment();

SFManager::AddTypedEntityScope( LocalVar );
};
		newLocalVar_251b.dt()= currMatch.dT_251a;
		newLocalVar_251b.event()+= currMatch.event_2517;
	}
}

void CreateStoreVar_251f::operator()( const Packets_t& states_2520, const Packets_t& programs_2522, Packets_t& states_2524, Packets_t& programs_2525)
{
#ifdef PRINT_INFO
	printLog( "CreateStoreVar_251f" );
#endif
	_state_2526= &states_2524;
	_program_2527= &programs_2525;
	_state_2526->insert( _state_2526->end(), states_2520.begin(), states_2520.end());
	_program_2527->insert( _program_2527->end(), programs_2522.begin(), programs_2522.end());
	if( ( !states_2520.empty())&& ( !programs_2522.empty()))
		callCreateDataVar_27c5( states_2520, programs_2522);
}

void CreateStoreVar_251f::callCreateDataVar_27c5( const Packets_t& states_2627, const Packets_t& programs_262b)
{
	Packets_t states_2629;
	Packets_t localVars_262a;
	CreateDataVar_2626 createDataVar_2626;
	createDataVar_2626( states_2627, programs_262b, states_2629, localVars_262a);
	if( ( !states_2629.empty())&& ( !localVars_262a.empty()))
		callGetHighestState_27c8( states_2629, localVars_262a);
}

void CreateStoreVar_251f::callGetHighestState_27c8( const Packets_t& states_2668, const Packets_t& localVars_266a)
{
	Packets_t states_266c;
	Packets_t localVars_266d;
	GetHighestState_2667 getHighestState_2667;
	getHighestState_2667( states_2668, localVars_266a, states_266c, localVars_266d);
	if( ( !states_266c.empty())&& ( !localVars_266d.empty()))
		callGetContainingSubsystem_27cb( states_266c, localVars_266d);
}

void CreateStoreVar_251f::callGetContainingSubsystem_27cb( const Packets_t& states_25f5, const Packets_t& localVars_25f8)
{
	Packets_t subsystems_25f7;
	Packets_t localVars_25fa;
	GetContainingSubsystem_25f4 getContainingSubsystem_25f4;
	getContainingSubsystem_25f4( states_25f5, localVars_25f8, subsystems_25f7, localVars_25fa);
	if( ( !subsystems_25f7.empty())&& ( !localVars_25fa.empty()))
		callGetStoreSubsystem_27ce( subsystems_25f7, localVars_25fa);
}

void CreateStoreVar_251f::callGetStoreSubsystem_27ce( const Packets_t& systems_2529, const Packets_t& localVars_252b)
{
	Packets_t systems_252d;
	Packets_t localVars_252e;
	GetStoreSubsystem_2528 getStoreSubsystem_2528;
	getStoreSubsystem_2528( systems_2529, localVars_252b, systems_252d, localVars_252e);
	if( ( !systems_252d.empty())&& ( !localVars_252e.empty()))
		callGetScope_27d1( systems_252d, localVars_252e);
}

void CreateStoreVar_251f::callGetScope_27d1( const Packets_t& systems_2727, const Packets_t& localVars_2729)
{
	Packets_t systems_272b;
	Packets_t localVars_272c;
	GetScope_2726 getScope_2726;
	getScope_2726( systems_2727, localVars_2729, systems_272b, localVars_272c);
	if( ( !systems_272b.empty())&& ( !localVars_272c.empty()))
		callRegister_27d4( systems_272b, localVars_272c);
}

void CreateStoreVar_251f::callRegister_27d4( const Packets_t& subsystems_270a, const Packets_t& localVars_270c)
{
	Register_2709 register_2709;
	register_2709( subsystems_270a, localVars_270c);
}

void GetStoreSubsystem_2528::operator()( const Packets_t& systems_2529, const Packets_t& localVars_252b, Packets_t& systems_252d, Packets_t& localVars_252e)
{
#ifdef PRINT_INFO
	printLog( "GetStoreSubsystem_2528" );
#endif
	_system_252f= &systems_252d;
	_localVar_2530= &localVars_252e;
	if( ( !systems_2529.empty())&& ( !localVars_252b.empty()))
		callStoreTest_25eb( systems_2529, localVars_252b);
}

void GetStoreSubsystem_2528::callStoreTest_25eb( const Packets_t& systems_257b, const Packets_t& localVars_257d)
{
	Packets_t systems_257f;
	Packets_t localVars_2580;
	Packets_t systems_2581;
	Packets_t localVars_2582;
	StoreTest_257a storeTest_257a;
	storeTest_257a( systems_257b, localVars_257d, systems_257f, localVars_2580, systems_2581, localVars_2582);
	if( ( !systems_257f.empty())&& ( !localVars_2580.empty()))
		callInitScope_25ee( systems_257f, localVars_2580);
	if( ( !systems_2581.empty())&& ( !localVars_2582.empty()))
		callNextHigherSubsystem_25f1( systems_2581, localVars_2582);
}

void GetStoreSubsystem_2528::callInitScope_25ee( const Packets_t& subsystems_2532, const Packets_t& localVars_2535)
{
	Packets_t subsystems_2534;
	Packets_t localVars_2537;
	InitScope_2531 initScope_2531;
	initScope_2531( subsystems_2532, localVars_2535, subsystems_2534, localVars_2537);
	_system_252f->insert( _system_252f->end(), subsystems_2534.begin(), subsystems_2534.end());
	_localVar_2530->insert( _localVar_2530->end(), localVars_2537.begin(), localVars_2537.end());
}

void GetStoreSubsystem_2528::callNextHigherSubsystem_25f1( const Packets_t& subSubsystems_2553, const Packets_t& localVars_2556)
{
	Packets_t subsystems_2555;
	Packets_t localVars_2558;
	NextHigherSubsystem_2552 nextHigherSubsystem_2552;
	nextHigherSubsystem_2552( subSubsystems_2553, localVars_2556, subsystems_2555, localVars_2558);
	if( ( !subsystems_2555.empty())&& ( !localVars_2558.empty()))
		callStoreTest_25eb( subsystems_2555, localVars_2558);
}

void InitScope_2531::operator()( const Packets_t& subsystems_2532, const Packets_t& localVars_2535, Packets_t& subsystems_2534, Packets_t& localVars_2537)
{
#ifdef PRINT_INFO
	printLog( "InitScope_2531" );
#endif
	RTTGenerator::Instance()->generateRule(1847, "InitScope");
	_subsystem_2538= &subsystems_2534;
	_localVar_2539= &localVars_2537;
	processInputPackets( subsystems_2532, localVars_2535);
	forwardInputs( );
}

bool InitScope_2531::isInputUnique( const Udm::Object& subsystem_253e, const Udm::Object& localVar_2547)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_2540= _subsystem_253a.begin(), itLocalVar_2549= _localVar_2543.begin(); itSubsystem_2540!= _subsystem_253a.end(), itLocalVar_2549!= _localVar_2543.end(); ++itSubsystem_2540, ++itLocalVar_2549)
	{
		if( ( *itSubsystem_2540== subsystem_253e)&& ( *itLocalVar_2549== localVar_2547))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_253a.push_back( subsystem_253e);
		_localVar_2543.push_back( localVar_2547);
	}
	return isUnique;
}

bool InitScope_2531::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void InitScope_2531::processInputPackets( const Packets_t& subsystems_2532, const Packets_t& localVars_2535)
{
	for( Packets_t::const_iterator itSubsystem_253b= subsystems_2532.begin(), itLocalVar_2544= localVars_2535.begin(); itSubsystem_253b!= subsystems_2532.end(), itLocalVar_2544!= localVars_2535.end(); ++itSubsystem_253b, ++itLocalVar_2544)
	{
		bool isUnique= isInputUnique( *itSubsystem_253b, *itLocalVar_2544);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_253b, *itLocalVar_2544);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitScope_2531::patternMatcher( const Udm::Object& subsystem_253c, const Udm::Object& localVar_2545)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_253c.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_2541= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_253c);
		if( false== Uml::IsDerivedFrom( localVar_2545.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_254a= SFC::LocalVar::Cast( localVar_2545);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_254f;
		if( !isValidBound(boundObjs_254f, subsystem_2541, true))
			continue;
		currMatch.subsystem_2550= subsystem_2541;
		if( !isValidBound(boundObjs_254f, localVar_254a, true))
			continue;
		currMatch.localVar_2551= localVar_254a;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void InitScope_2531::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar& LocalVar= currMatch.localVar_2551;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_2550;
		{
LocalVar.scope() = Subsystem.name();
};
	}
}

void InitScope_2531::forwardInputs()
{
	*_subsystem_2538= _subsystem_253a;
	*_localVar_2539= _localVar_2543;
}

void NextHigherSubsystem_2552::operator()( const Packets_t& subSubsystems_2553, const Packets_t& localVars_2556, Packets_t& subsystems_2555, Packets_t& localVars_2558)
{
#ifdef PRINT_INFO
	printLog( "NextHigherSubsystem_2552" );
#endif
	RTTGenerator::Instance()->generateRule(1851, "NextHigherSubsystem");
	_subsystem_2559= &subsystems_2555;
	_localVar_255a= &localVars_2558;
	processInputPackets( subSubsystems_2553, localVars_2556);
}

bool NextHigherSubsystem_2552::isInputUnique( const Udm::Object& subSubsystem_255f, const Udm::Object& localVar_2568)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubSubsystem_2561= _subSubsystem_255b.begin(), itLocalVar_256a= _localVar_2564.begin(); itSubSubsystem_2561!= _subSubsystem_255b.end(), itLocalVar_256a!= _localVar_2564.end(); ++itSubSubsystem_2561, ++itLocalVar_256a)
	{
		if( ( *itSubSubsystem_2561== subSubsystem_255f)&& ( *itLocalVar_256a== localVar_2568))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subSubsystem_255b.push_back( subSubsystem_255f);
		_localVar_2564.push_back( localVar_2568);
	}
	return isUnique;
}

bool NextHigherSubsystem_2552::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void NextHigherSubsystem_2552::processInputPackets( const Packets_t& subSubsystems_2553, const Packets_t& localVars_2556)
{
	for( Packets_t::const_iterator itSubSubsystem_255c= subSubsystems_2553.begin(), itLocalVar_2565= localVars_2556.begin(); itSubSubsystem_255c!= subSubsystems_2553.end(), itLocalVar_2565!= localVars_2556.end(); ++itSubSubsystem_255c, ++itLocalVar_2565)
	{
		bool isUnique= isInputUnique( *itSubSubsystem_255c, *itLocalVar_2565);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubSubsystem_255c, *itLocalVar_2565);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool NextHigherSubsystem_2552::patternMatcher( const Udm::Object& subSubsystem_255d, const Udm::Object& localVar_2566)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subSubsystem_255d.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subSubsystem_2562= CyPhyML::SignalFlow::Subsystem::Cast( subSubsystem_255d);
		if( false== Uml::IsDerivedFrom( localVar_2566.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_256b= SFC::LocalVar::Cast( localVar_2566);
		Udm::Object subSubsystemParent_256d= subSubsystem_2562.container();
		if( false== Uml::IsDerivedFrom( subSubsystemParent_256d.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystemSubSubsystem_256e= CyPhyML::SignalFlow::Subsystem::Cast( subSubsystemParent_256d);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2572;
		if( !isValidBound(boundObjs_2572, subSubsystem_2562, true))
			continue;
		currMatch.subSubsystem_2573= subSubsystem_2562;
		if( !isValidBound(boundObjs_2572, localVar_256b, true))
			continue;
		currMatch.localVar_2574= localVar_256b;
		if( !isValidBound(boundObjs_2572, subsystemSubSubsystem_256e, false))
			continue;
		currMatch.subsystem_2575= subsystemSubSubsystem_256e;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void NextHigherSubsystem_2552::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_2575, currMatch.localVar_2574);
	}
}

void NextHigherSubsystem_2552::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_2576, const SFC::LocalVar& localVar_2578)
{
	_subsystem_2559->push_back( subsystem_2576);
	_localVar_255a->push_back( localVar_2578);
}

void StoreTest_257a::operator()( const Packets_t& systems_257b, const Packets_t& localVars_257d, Packets_t& systems_257f, Packets_t& localVars_2580, Packets_t& systems_2581, Packets_t& localVars_2582)
{
#ifdef PRINT_INFO
	printLog( "StoreTest_257a" );
#endif
	_system_2583= &systems_257f;
	_localVar_2584= &localVars_2580;
	_system_2585= &systems_2581;
	_localVar_2586= &localVars_2582;
	for( Packets_t::const_iterator itsystem_2588= systems_257b.begin(), itlocalVar_258f= localVars_257d.begin(); itsystem_2588!= systems_257b.end(), itlocalVar_258f!= localVars_257d.end(); ++itsystem_2588, ++itlocalVar_258f)
	{
		bool isUnique= isInputUnique( *itsystem_2588, *itlocalVar_258f);
		if( !isUnique)
			continue;
		Packets_t onesystem_258c( 1, *itsystem_2588);
		Packets_t onelocalVar_2593( 1, *itlocalVar_258f);
		executeOne( onesystem_258c, onelocalVar_2593);
	}
}

void StoreTest_257a::executeOne( const Packets_t& systems_257b, const Packets_t& localVars_257d)
{
	Packets_t subsystems_2598;
	Packets_t localVars_259b;
	HasStore_2595 hasStore_2595;
	bool isMatchHasStore_2595= hasStore_2595( systems_257b, localVars_257d, subsystems_2598, localVars_259b);
	_system_2583->insert( _system_2583->end(), subsystems_2598.begin(), subsystems_2598.end());
	_localVar_2584->insert( _localVar_2584->end(), localVars_259b.begin(), localVars_259b.end());
	if( isMatchHasStore_2595)
		return;
	Packets_t subsystems_25c9;
	Packets_t localVars_25cc;
	Otherwise_25c6 otherwise_25c6;
	bool isMatchOtherwise_25c6= otherwise_25c6( systems_257b, localVars_257d, subsystems_25c9, localVars_25cc);
	_system_2585->insert( _system_2585->end(), subsystems_25c9.begin(), subsystems_25c9.end());
	_localVar_2586->insert( _localVar_2586->end(), localVars_25cc.begin(), localVars_25cc.end());
	if( isMatchOtherwise_25c6)
		return;
}

bool StoreTest_257a::isInputUnique( const Udm::Object& system_2589, const Udm::Object& localVar_2590)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itsystem_258b= _system_2587.begin(), itlocalVar_2592= _localVar_258e.begin(); itsystem_258b!= _system_2587.end(), itlocalVar_2592!= _localVar_258e.end(); ++itsystem_258b, ++itlocalVar_2592)
	{
		if( ( *itsystem_258b== system_2589)&& ( *itlocalVar_2592== localVar_2590))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_system_2587.push_back( system_2589);
		_localVar_258e.push_back( localVar_2590);
	}
	return isUnique;
}

bool HasStore_2595::operator()( const Packets_t& subsystems_2596, const Packets_t& localVars_2599, Packets_t& subsystems_2598, Packets_t& localVars_259b)
{
#ifdef PRINT_INFO
	printLog( "HasStore_2595" );
#endif
	_subsystem_259c= &subsystems_2598;
	_localVar_259d= &localVars_259b;
	processInputPackets( subsystems_2596, localVars_2599);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasStore_2595::isInputUnique( const Udm::Object& subsystem_25a2, const Udm::Object& localVar_25ab)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_25a4= _subsystem_259e.begin(), itLocalVar_25ad= _localVar_25a7.begin(); itSubsystem_25a4!= _subsystem_259e.end(), itLocalVar_25ad!= _localVar_25a7.end(); ++itSubsystem_25a4, ++itLocalVar_25ad)
	{
		if( ( *itSubsystem_25a4== subsystem_25a2)&& ( *itLocalVar_25ad== localVar_25ab))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_259e.push_back( subsystem_25a2);
		_localVar_25a7.push_back( localVar_25ab);
	}
	return isUnique;
}

bool HasStore_2595::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool HasStore_2595::isGuardTrue( SFC::LocalVar& LocalVar, CyPhyML::SignalFlow::SF_Parameter& Parameter, CyPhyML::SignalFlow::Primitive& Primitive, CyPhyML::SignalFlow::Subsystem& Subsystem)
{
	bool Gz_guard= false;
	Gz_guard =
 static_cast< std::string >( Parameter.Value() ) ==
 static_cast< std::string >( LocalVar.name() );;
	return Gz_guard;
}

void HasStore_2595::processInputPackets( const Packets_t& subsystems_2596, const Packets_t& localVars_2599)
{
	for( Packets_t::const_iterator itSubsystem_259f= subsystems_2596.begin(), itLocalVar_25a8= localVars_2599.begin(); itSubsystem_259f!= subsystems_2596.end(), itLocalVar_25a8!= localVars_2599.end(); ++itSubsystem_259f, ++itLocalVar_25a8)
	{
		bool isUnique= isInputUnique( *itSubsystem_259f, *itLocalVar_25a8);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_259f, *itLocalVar_25a8);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_25ba, currMatch.localVar_25bb);
	}
}

bool HasStore_2595::patternMatcher( const Udm::Object& subsystem_25a0, const Udm::Object& localVar_25a9)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_25a0.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_25a5= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_25a0);
		if( false== Uml::IsDerivedFrom( localVar_25a9.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_25ae= SFC::LocalVar::Cast( localVar_25a9);
		set< CyPhyML::SignalFlow::Primitive> primitives_25b0= subsystem_25a5.Primitive_kind_children();
		for( set< CyPhyML::SignalFlow::Primitive>::const_iterator itPrimitive_25b1= primitives_25b0.begin(); itPrimitive_25b1!= primitives_25b0.end(); ++itPrimitive_25b1)
		{
			CyPhyML::SignalFlow::Primitive currPrimitive_25b2= *itPrimitive_25b1;
			set< CyPhyML::SignalFlow::SF_Parameter> parameters_25b3= currPrimitive_25b2.SF_Parameter_kind_children();
			for( set< CyPhyML::SignalFlow::SF_Parameter>::const_iterator itParameter_25b4= parameters_25b3.begin(); itParameter_25b4!= parameters_25b3.end(); ++itParameter_25b4)
			{
				CyPhyML::SignalFlow::SF_Parameter currParameter_25b5= *itParameter_25b4;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_25b9;
				if( !isValidBound(boundObjs_25b9, subsystem_25a5, true))
					continue;
				currMatch.subsystem_25ba= subsystem_25a5;
				if( !isValidBound(boundObjs_25b9, localVar_25ae, true))
					continue;
				currMatch.localVar_25bb= localVar_25ae;
				if( !isValidBound(boundObjs_25b9, currParameter_25b5, false))
					continue;
				currMatch.parameter_25bc= currParameter_25b5;
				if( !isValidBound(boundObjs_25b9, currPrimitive_25b2, false))
					continue;
				currMatch.primitive_25bd= currPrimitive_25b2;
				bool Gz_guard= isGuardTrue( currMatch.localVar_25bb, currMatch.parameter_25bc, currMatch.primitive_25bd, currMatch.subsystem_25ba);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void HasStore_2595::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_25c2, const SFC::LocalVar& localVar_25c4)
{
	_subsystem_259c->push_back( subsystem_25c2);
	_localVar_259d->push_back( localVar_25c4);
}

bool Otherwise_25c6::operator()( const Packets_t& subsystems_25c7, const Packets_t& localVars_25ca, Packets_t& subsystems_25c9, Packets_t& localVars_25cc)
{
#ifdef PRINT_INFO
	printLog( "Otherwise_25c6" );
#endif
	_subsystem_25cd= &subsystems_25c9;
	_localVar_25ce= &localVars_25cc;
	processInputPackets( subsystems_25c7, localVars_25ca);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_25c6::isInputUnique( const Udm::Object& subsystem_25d3, const Udm::Object& localVar_25dc)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_25d5= _subsystem_25cf.begin(), itLocalVar_25de= _localVar_25d8.begin(); itSubsystem_25d5!= _subsystem_25cf.end(), itLocalVar_25de!= _localVar_25d8.end(); ++itSubsystem_25d5, ++itLocalVar_25de)
	{
		if( ( *itSubsystem_25d5== subsystem_25d3)&& ( *itLocalVar_25de== localVar_25dc))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_25cf.push_back( subsystem_25d3);
		_localVar_25d8.push_back( localVar_25dc);
	}
	return isUnique;
}

bool Otherwise_25c6::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_25c6::processInputPackets( const Packets_t& subsystems_25c7, const Packets_t& localVars_25ca)
{
	for( Packets_t::const_iterator itSubsystem_25d0= subsystems_25c7.begin(), itLocalVar_25d9= localVars_25ca.begin(); itSubsystem_25d0!= subsystems_25c7.end(), itLocalVar_25d9!= localVars_25ca.end(); ++itSubsystem_25d0, ++itLocalVar_25d9)
	{
		bool isUnique= isInputUnique( *itSubsystem_25d0, *itLocalVar_25d9);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_25d0, *itLocalVar_25d9);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_25e5, currMatch.localVar_25e6);
	}
}

bool Otherwise_25c6::patternMatcher( const Udm::Object& subsystem_25d1, const Udm::Object& localVar_25da)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_25d1.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_25d6= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_25d1);
		if( false== Uml::IsDerivedFrom( localVar_25da.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_25df= SFC::LocalVar::Cast( localVar_25da);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_25e4;
		if( !isValidBound(boundObjs_25e4, subsystem_25d6, true))
			continue;
		currMatch.subsystem_25e5= subsystem_25d6;
		if( !isValidBound(boundObjs_25e4, localVar_25df, true))
			continue;
		currMatch.localVar_25e6= localVar_25df;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_25c6::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_25e7, const SFC::LocalVar& localVar_25e9)
{
	_subsystem_25cd->push_back( subsystem_25e7);
	_localVar_25ce->push_back( localVar_25e9);
}

void GetContainingSubsystem_25f4::operator()( const Packets_t& states_25f5, const Packets_t& localVars_25f8, Packets_t& subsystems_25f7, Packets_t& localVars_25fa)
{
#ifdef PRINT_INFO
	printLog( "GetContainingSubsystem_25f4" );
#endif
	RTTGenerator::Instance()->generateRule(1873, "GetContainingSubsystem");
	_subsystem_25fb= &subsystems_25f7;
	_localVar_25fc= &localVars_25fa;
	processInputPackets( states_25f5, localVars_25f8);
}

bool GetContainingSubsystem_25f4::isInputUnique( const Udm::Object& state_2601, const Udm::Object& localVar_260a)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_2603= _state_25fd.begin(), itLocalVar_260c= _localVar_2606.begin(); itState_2603!= _state_25fd.end(), itLocalVar_260c!= _localVar_2606.end(); ++itState_2603, ++itLocalVar_260c)
	{
		if( ( *itState_2603== state_2601)&& ( *itLocalVar_260c== localVar_260a))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_25fd.push_back( state_2601);
		_localVar_2606.push_back( localVar_260a);
	}
	return isUnique;
}

bool GetContainingSubsystem_25f4::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetContainingSubsystem_25f4::processInputPackets( const Packets_t& states_25f5, const Packets_t& localVars_25f8)
{
	for( Packets_t::const_iterator itState_25fe= states_25f5.begin(), itLocalVar_2607= localVars_25f8.begin(); itState_25fe!= states_25f5.end(), itLocalVar_2607!= localVars_25f8.end(); ++itState_25fe, ++itLocalVar_2607)
	{
		bool isUnique= isInputUnique( *itState_25fe, *itLocalVar_2607);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_25fe, *itLocalVar_2607);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetContainingSubsystem_25f4::patternMatcher( const Udm::Object& state_25ff, const Udm::Object& localVar_2608)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_25ff.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_2604= CyPhyML::SignalFlow::State::Cast( state_25ff);
		if( false== Uml::IsDerivedFrom( localVar_2608.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_260d= SFC::LocalVar::Cast( localVar_2608);
		set< CyPhyML::SignalFlow::ConnectorRef> connectorRefs_260f= state_2604.referedbyConnectorRef();
		for( set< CyPhyML::SignalFlow::ConnectorRef>::const_iterator itConnectorRefs_2610= connectorRefs_260f.begin(); itConnectorRefs_2610!= connectorRefs_260f.end(); ++itConnectorRefs_2610)
		{
			CyPhyML::SignalFlow::ConnectorRef currConnectorRef_2611= *itConnectorRefs_2610;
			Udm::Object connectorRefParent_2612= currConnectorRef_2611.container();
			if( false== Uml::IsDerivedFrom( connectorRefParent_2612.type(), CyPhyML::SignalFlow::Primitive::meta))
				continue;
			CyPhyML::SignalFlow::Primitive primitiveConnectorRef_2613= CyPhyML::SignalFlow::Primitive::Cast( connectorRefParent_2612);
			Udm::Object primitiveParent_2614= primitiveConnectorRef_2613.container();
			if( false== Uml::IsDerivedFrom( primitiveParent_2614.type(), CyPhyML::SignalFlow::Subsystem::meta))
				continue;
			CyPhyML::SignalFlow::Subsystem subSubsystemPrimitive_2615= CyPhyML::SignalFlow::Subsystem::Cast( primitiveParent_2614);
			Udm::Object subSubsystemParent_2616= subSubsystemPrimitive_2615.container();
			if( false== Uml::IsDerivedFrom( subSubsystemParent_2616.type(), CyPhyML::SignalFlow::Subsystem::meta))
				continue;
			CyPhyML::SignalFlow::Subsystem subsystemSubSubsystem_2617= CyPhyML::SignalFlow::Subsystem::Cast( subSubsystemParent_2616);
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_261b;
			if( !isValidBound(boundObjs_261b, state_2604, true))
				continue;
			currMatch.state_261c= state_2604;
			if( !isValidBound(boundObjs_261b, localVar_260d, true))
				continue;
			currMatch.localVar_261d= localVar_260d;
			if( !isValidBound(boundObjs_261b, subSubsystemPrimitive_2615, false))
				continue;
			currMatch.subSubsystem_261e= subSubsystemPrimitive_2615;
			if( !isValidBound(boundObjs_261b, subsystemSubSubsystem_2617, false))
				continue;
			currMatch.subsystem_261f= subsystemSubSubsystem_2617;
			if( !isValidBound(boundObjs_261b, currConnectorRef_2611, false))
				continue;
			currMatch.connectorRef_2620= currConnectorRef_2611;
			if( !isValidBound(boundObjs_261b, primitiveConnectorRef_2613, false))
				continue;
			currMatch.primitive_2621= primitiveConnectorRef_2613;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetContainingSubsystem_25f4::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_261f, currMatch.localVar_261d);
	}
}

void GetContainingSubsystem_25f4::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_2622, const SFC::LocalVar& localVar_2624)
{
	_subsystem_25fb->push_back( subsystem_2622);
	_localVar_25fc->push_back( localVar_2624);
}

void CreateDataVar_2626::operator()( const Packets_t& states_2627, const Packets_t& programs_262b, Packets_t& states_2629, Packets_t& localVars_262a)
{
#ifdef PRINT_INFO
	printLog( "CreateDataVar_2626" );
#endif
	RTTGenerator::Instance()->generateRule(1884, "CreateDataVar");
	_state_262d= &states_2629;
	_localVar_262e= &localVars_262a;
	processInputPackets( states_2627, programs_262b);
}

bool CreateDataVar_2626::isInputUnique( const Udm::Object& state_2633, const Udm::Object& program_263c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_2635= _state_262f.begin(), itProgram_263e= _program_2638.begin(); itState_2635!= _state_262f.end(), itProgram_263e!= _program_2638.end(); ++itState_2635, ++itProgram_263e)
	{
		if( ( *itState_2635== state_2633)&& ( *itProgram_263e== program_263c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_262f.push_back( state_2633);
		_program_2638.push_back( program_263c);
	}
	return isUnique;
}

bool CreateDataVar_2626::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool CreateDataVar_2626::isGuardTrue( SFC::DT& DT, CyPhyML::SignalFlow::Data& Data, SFC::Program& Program, SFC::Project& Project, CyPhyML::SignalFlow::State& State, SFC::StateLabel& StateLabel, CyPhyML::SignalFlow::SF_TypeBase& TypeBase, CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Data.Scope() ) == "STORE_DATA";;
	return Gz_guard;
}

void CreateDataVar_2626::processInputPackets( const Packets_t& states_2627, const Packets_t& programs_262b)
{
	for( Packets_t::const_iterator itState_2630= states_2627.begin(), itProgram_2639= programs_262b.begin(); itState_2630!= states_2627.end(), itProgram_2639!= programs_262b.end(); ++itState_2630, ++itProgram_2639)
	{
		bool isUnique= isInputUnique( *itState_2630, *itProgram_2639);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_2630, *itProgram_2639);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateDataVar_2626::patternMatcher( const Udm::Object& state_2631, const Udm::Object& program_263a)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_2631.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_2636= CyPhyML::SignalFlow::State::Cast( state_2631);
		if( false== Uml::IsDerivedFrom( program_263a.type(), SFC::Program::meta))
			continue;
		SFC::Program program_263f= SFC::Program::Cast( program_263a);
		set< CyPhyML::SignalFlow::Data> datas_2641= state_2636.Data_kind_children();
		for( set< CyPhyML::SignalFlow::Data>::const_iterator itData_2642= datas_2641.begin(); itData_2642!= datas_2641.end(); ++itData_2642)
		{
			CyPhyML::SignalFlow::Data currData_2643= *itData_2642;
			Udm::Object programParent_2644= program_263f.container();
			if( false== Uml::IsDerivedFrom( programParent_2644.type(), SFC::Project::meta))
				continue;
			SFC::Project projectProgram_2645= SFC::Project::Cast( programParent_2644);
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_2646= currData_2643.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_2647= typeBaseRefs_2646.begin(); itTypeBaseRef_2647!= typeBaseRefs_2646.end(); ++itTypeBaseRef_2647)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_2648= *itTypeBaseRef_2647;
				set< SFC::StateLabel> stateLabels_2649= state_2636.src();
				for( set< SFC::StateLabel>::const_iterator itStateLabels_264a= stateLabels_2649.begin(); itStateLabels_264a!= stateLabels_2649.end(); ++itStateLabels_264a)
				{
					SFC::StateLabel currStateLabel_264b= *itStateLabels_264a;
					CyPhyML::SignalFlow::SF_TypeBase typeBase_264c= currTypeBaseRef_2648.ref();
					if( !typeBase_264c)
						continue;
					SFC::DT dT_264d= typeBase_264c.dt();
					if( !dT_264d)
						continue;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_2651;
					if( !isValidBound(boundObjs_2651, state_2636, true))
						continue;
					currMatch.state_2652= state_2636;
					if( !isValidBound(boundObjs_2651, program_263f, true))
						continue;
					currMatch.program_2653= program_263f;
					if( !isValidBound(boundObjs_2651, currStateLabel_264b, false))
						continue;
					currMatch.stateLabel_2654= currStateLabel_264b;
					if( !isValidBound(boundObjs_2651, currData_2643, false))
						continue;
					currMatch.data_2655= currData_2643;
					if( !isValidBound(boundObjs_2651, currTypeBaseRef_2648, false))
						continue;
					currMatch.typeBaseRef_2656= currTypeBaseRef_2648;
					if( !isValidBound(boundObjs_2651, typeBase_264c, false))
						continue;
					currMatch.typeBase_2657= typeBase_264c;
					if( !isValidBound(boundObjs_2651, dT_264d, false))
						continue;
					currMatch.dT_2658= dT_264d;
					if( !isValidBound(boundObjs_2651, projectProgram_2645, false))
						continue;
					currMatch.project_2659= projectProgram_2645;
					bool Gz_guard= isGuardTrue( currMatch.dT_2658, currMatch.data_2655, currMatch.program_2653, currMatch.project_2659, currMatch.state_2652, currMatch.stateLabel_2654, currMatch.typeBase_2657, currMatch.typeBaseRef_2656);
					if( true== Gz_guard)
						_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void CreateDataVar_2626::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar newLocalVar_2662= SFC::LocalVar::Create( currMatch.project_2659);
		SFC::DT& DT= currMatch.dT_2658;
		CyPhyML::SignalFlow::Data& Data= currMatch.data_2655;
		SFC::LocalVar& LocalVar= newLocalVar_2662;
		SFC::Program& Program= currMatch.program_2653;
		SFC::Project& Project= currMatch.project_2659;
		CyPhyML::SignalFlow::State& State= currMatch.state_2652;
		SFC::StateLabel& StateLabel= currMatch.stateLabel_2654;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_2657;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_2656;
		{
LocalVar.RefId() = Data.RefId();
};
		{
__int64 statementCount = Project.statementCount();
LocalVar.statementIndex() = statementCount++;
Project.statementCount() = statementCount;
};
		{
std::string dataName = Data.Name();
if(dataName.empty())
	dataName = Data.name();
LocalVar.initial() = Data.InitialValue();
LocalVar.indexBase() = Data.ArrayFirstIndex();
};
		newLocalVar_2662.data()+= currMatch.data_2655;
		newLocalVar_2662.dt()= currMatch.dT_2658;
		outputAppender( currMatch.state_2652, newLocalVar_2662);
	}
}

void CreateDataVar_2626::outputAppender( const CyPhyML::SignalFlow::State& state_2663, const SFC::LocalVar& localVar_2665)
{
	_state_262d->push_back( state_2663);
	_localVar_262e->push_back( localVar_2665);
}

void GetHighestState_2667::operator()( const Packets_t& states_2668, const Packets_t& localVars_266a, Packets_t& states_266c, Packets_t& localVars_266d)
{
#ifdef PRINT_INFO
	printLog( "GetHighestState_2667" );
#endif
	_state_266e= &states_266c;
	_localVar_266f= &localVars_266d;
	if( ( !states_2668.empty())&& ( !localVars_266a.empty()))
		callHighestStateTest_2703( states_2668, localVars_266a);
}

void GetHighestState_2667::callHighestStateTest_2703( const Packets_t& states_2671, const Packets_t& localVars_2673)
{
	Packets_t states_2675;
	Packets_t localVars_2676;
	Packets_t states_2677;
	Packets_t localVars_2678;
	HighestStateTest_2670 highestStateTest_2670;
	highestStateTest_2670( states_2671, localVars_2673, states_2675, localVars_2676, states_2677, localVars_2678);
	_state_266e->insert( _state_266e->end(), states_2675.begin(), states_2675.end());
	_localVar_266f->insert( _localVar_266f->end(), localVars_2676.begin(), localVars_2676.end());
	if( ( !states_2677.empty())&& ( !localVars_2678.empty()))
		callNextHigherState_2706( states_2677, localVars_2678);
}

void GetHighestState_2667::callNextHigherState_2706( const Packets_t& subStates_26dc, const Packets_t& localVars_26df)
{
	Packets_t states_26de;
	Packets_t localVars_26e1;
	NextHigherState_26db nextHigherState_26db;
	nextHigherState_26db( subStates_26dc, localVars_26df, states_26de, localVars_26e1);
	if( ( !states_26de.empty())&& ( !localVars_26e1.empty()))
		callHighestStateTest_2703( states_26de, localVars_26e1);
}

void HighestStateTest_2670::operator()( const Packets_t& states_2671, const Packets_t& localVars_2673, Packets_t& states_2675, Packets_t& localVars_2676, Packets_t& states_2677, Packets_t& localVars_2678)
{
#ifdef PRINT_INFO
	printLog( "HighestStateTest_2670" );
#endif
	_state_2679= &states_2675;
	_localVar_267a= &localVars_2676;
	_state_267b= &states_2677;
	_localVar_267c= &localVars_2678;
	for( Packets_t::const_iterator itstate_267e= states_2671.begin(), itlocalVar_2685= localVars_2673.begin(); itstate_267e!= states_2671.end(), itlocalVar_2685!= localVars_2673.end(); ++itstate_267e, ++itlocalVar_2685)
	{
		bool isUnique= isInputUnique( *itstate_267e, *itlocalVar_2685);
		if( !isUnique)
			continue;
		Packets_t onestate_2682( 1, *itstate_267e);
		Packets_t onelocalVar_2689( 1, *itlocalVar_2685);
		executeOne( onestate_2682, onelocalVar_2689);
	}
}

void HighestStateTest_2670::executeOne( const Packets_t& states_2671, const Packets_t& localVars_2673)
{
	Packets_t subStates_268e;
	Packets_t localVars_2691;
	HighestState_268b highestState_268b;
	bool isMatchHighestState_268b= highestState_268b( states_2671, localVars_2673, subStates_268e, localVars_2691);
	_state_2679->insert( _state_2679->end(), subStates_268e.begin(), subStates_268e.end());
	_localVar_267a->insert( _localVar_267a->end(), localVars_2691.begin(), localVars_2691.end());
	if( isMatchHighestState_268b)
		return;
	Packets_t states_26b9;
	Packets_t localVars_26bc;
	Otherwise_26b6 otherwise_26b6;
	bool isMatchOtherwise_26b6= otherwise_26b6( states_2671, localVars_2673, states_26b9, localVars_26bc);
	_state_267b->insert( _state_267b->end(), states_26b9.begin(), states_26b9.end());
	_localVar_267c->insert( _localVar_267c->end(), localVars_26bc.begin(), localVars_26bc.end());
	if( isMatchOtherwise_26b6)
		return;
}

bool HighestStateTest_2670::isInputUnique( const Udm::Object& state_267f, const Udm::Object& localVar_2686)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstate_2681= _state_267d.begin(), itlocalVar_2688= _localVar_2684.begin(); itstate_2681!= _state_267d.end(), itlocalVar_2688!= _localVar_2684.end(); ++itstate_2681, ++itlocalVar_2688)
	{
		if( ( *itstate_2681== state_267f)&& ( *itlocalVar_2688== localVar_2686))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_267d.push_back( state_267f);
		_localVar_2684.push_back( localVar_2686);
	}
	return isUnique;
}

bool HighestState_268b::operator()( const Packets_t& subStates_268c, const Packets_t& localVars_268f, Packets_t& subStates_268e, Packets_t& localVars_2691)
{
#ifdef PRINT_INFO
	printLog( "HighestState_268b" );
#endif
	_subState_2692= &subStates_268e;
	_localVar_2693= &localVars_2691;
	processInputPackets( subStates_268c, localVars_268f);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HighestState_268b::isInputUnique( const Udm::Object& subState_2698, const Udm::Object& localVar_26a1)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubState_269a= _subState_2694.begin(), itLocalVar_26a3= _localVar_269d.begin(); itSubState_269a!= _subState_2694.end(), itLocalVar_26a3!= _localVar_269d.end(); ++itSubState_269a, ++itLocalVar_26a3)
	{
		if( ( *itSubState_269a== subState_2698)&& ( *itLocalVar_26a3== localVar_26a1))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subState_2694.push_back( subState_2698);
		_localVar_269d.push_back( localVar_26a1);
	}
	return isUnique;
}

bool HighestState_268b::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void HighestState_268b::processInputPackets( const Packets_t& subStates_268c, const Packets_t& localVars_268f)
{
	for( Packets_t::const_iterator itSubState_2695= subStates_268c.begin(), itLocalVar_269e= localVars_268f.begin(); itSubState_2695!= subStates_268c.end(), itLocalVar_269e!= localVars_268f.end(); ++itSubState_2695, ++itLocalVar_269e)
	{
		bool isUnique= isInputUnique( *itSubState_2695, *itLocalVar_269e);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubState_2695, *itLocalVar_269e);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subState_26ae, currMatch.localVar_26af);
	}
}

bool HighestState_268b::patternMatcher( const Udm::Object& subState_2696, const Udm::Object& localVar_269f)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subState_2696.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State subState_269b= CyPhyML::SignalFlow::State::Cast( subState_2696);
		if( false== Uml::IsDerivedFrom( localVar_269f.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_26a4= SFC::LocalVar::Cast( localVar_269f);
		Udm::Object subStateParent_26a6= subState_269b.container();
		if( false== Uml::IsDerivedFrom( subStateParent_26a6.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State stateSubState_26a7= CyPhyML::SignalFlow::State::Cast( subStateParent_26a6);
		Udm::Object stateParent_26a8= stateSubState_26a7.container();
		if( false== Uml::IsDerivedFrom( stateParent_26a8.type(), CyPhyML::SignalFlow::Block::meta))
			continue;
		CyPhyML::SignalFlow::Block stateflowState_26a9= CyPhyML::SignalFlow::Block::Cast( stateParent_26a8);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_26ad;
		if( !isValidBound(boundObjs_26ad, subState_269b, true))
			continue;
		currMatch.subState_26ae= subState_269b;
		if( !isValidBound(boundObjs_26ad, localVar_26a4, true))
			continue;
		currMatch.localVar_26af= localVar_26a4;
		if( !isValidBound(boundObjs_26ad, stateSubState_26a7, false))
			continue;
		currMatch.state_26b0= stateSubState_26a7;
		if( !isValidBound(boundObjs_26ad, stateflowState_26a9, false))
			continue;
		currMatch.stateflow_26b1= stateflowState_26a9;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void HighestState_268b::outputAppender( const CyPhyML::SignalFlow::State& subState_26b2, const SFC::LocalVar& localVar_26b4)
{
	_subState_2692->push_back( subState_26b2);
	_localVar_2693->push_back( localVar_26b4);
}

bool Otherwise_26b6::operator()( const Packets_t& states_26b7, const Packets_t& localVars_26ba, Packets_t& states_26b9, Packets_t& localVars_26bc)
{
#ifdef PRINT_INFO
	printLog( "Otherwise_26b6" );
#endif
	_state_26bd= &states_26b9;
	_localVar_26be= &localVars_26bc;
	processInputPackets( states_26b7, localVars_26ba);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_26b6::isInputUnique( const Udm::Object& state_26c3, const Udm::Object& localVar_26cc)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_26c5= _state_26bf.begin(), itLocalVar_26ce= _localVar_26c8.begin(); itState_26c5!= _state_26bf.end(), itLocalVar_26ce!= _localVar_26c8.end(); ++itState_26c5, ++itLocalVar_26ce)
	{
		if( ( *itState_26c5== state_26c3)&& ( *itLocalVar_26ce== localVar_26cc))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_26bf.push_back( state_26c3);
		_localVar_26c8.push_back( localVar_26cc);
	}
	return isUnique;
}

bool Otherwise_26b6::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_26b6::processInputPackets( const Packets_t& states_26b7, const Packets_t& localVars_26ba)
{
	for( Packets_t::const_iterator itState_26c0= states_26b7.begin(), itLocalVar_26c9= localVars_26ba.begin(); itState_26c0!= states_26b7.end(), itLocalVar_26c9!= localVars_26ba.end(); ++itState_26c0, ++itLocalVar_26c9)
	{
		bool isUnique= isInputUnique( *itState_26c0, *itLocalVar_26c9);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_26c0, *itLocalVar_26c9);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_26d5, currMatch.localVar_26d6);
	}
}

bool Otherwise_26b6::patternMatcher( const Udm::Object& state_26c1, const Udm::Object& localVar_26ca)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_26c1.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_26c6= CyPhyML::SignalFlow::State::Cast( state_26c1);
		if( false== Uml::IsDerivedFrom( localVar_26ca.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_26cf= SFC::LocalVar::Cast( localVar_26ca);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_26d4;
		if( !isValidBound(boundObjs_26d4, state_26c6, true))
			continue;
		currMatch.state_26d5= state_26c6;
		if( !isValidBound(boundObjs_26d4, localVar_26cf, true))
			continue;
		currMatch.localVar_26d6= localVar_26cf;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_26b6::outputAppender( const CyPhyML::SignalFlow::State& state_26d7, const SFC::LocalVar& localVar_26d9)
{
	_state_26bd->push_back( state_26d7);
	_localVar_26be->push_back( localVar_26d9);
}

void NextHigherState_26db::operator()( const Packets_t& subStates_26dc, const Packets_t& localVars_26df, Packets_t& states_26de, Packets_t& localVars_26e1)
{
#ifdef PRINT_INFO
	printLog( "NextHigherState_26db" );
#endif
	RTTGenerator::Instance()->generateRule(1928, "NextHigherState");
	_state_26e2= &states_26de;
	_localVar_26e3= &localVars_26e1;
	processInputPackets( subStates_26dc, localVars_26df);
}

bool NextHigherState_26db::isInputUnique( const Udm::Object& subState_26e8, const Udm::Object& localVar_26f1)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubState_26ea= _subState_26e4.begin(), itLocalVar_26f3= _localVar_26ed.begin(); itSubState_26ea!= _subState_26e4.end(), itLocalVar_26f3!= _localVar_26ed.end(); ++itSubState_26ea, ++itLocalVar_26f3)
	{
		if( ( *itSubState_26ea== subState_26e8)&& ( *itLocalVar_26f3== localVar_26f1))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subState_26e4.push_back( subState_26e8);
		_localVar_26ed.push_back( localVar_26f1);
	}
	return isUnique;
}

bool NextHigherState_26db::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void NextHigherState_26db::processInputPackets( const Packets_t& subStates_26dc, const Packets_t& localVars_26df)
{
	for( Packets_t::const_iterator itSubState_26e5= subStates_26dc.begin(), itLocalVar_26ee= localVars_26df.begin(); itSubState_26e5!= subStates_26dc.end(), itLocalVar_26ee!= localVars_26df.end(); ++itSubState_26e5, ++itLocalVar_26ee)
	{
		bool isUnique= isInputUnique( *itSubState_26e5, *itLocalVar_26ee);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubState_26e5, *itLocalVar_26ee);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool NextHigherState_26db::patternMatcher( const Udm::Object& subState_26e6, const Udm::Object& localVar_26ef)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subState_26e6.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State subState_26eb= CyPhyML::SignalFlow::State::Cast( subState_26e6);
		if( false== Uml::IsDerivedFrom( localVar_26ef.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_26f4= SFC::LocalVar::Cast( localVar_26ef);
		Udm::Object subStateParent_26f6= subState_26eb.container();
		if( false== Uml::IsDerivedFrom( subStateParent_26f6.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State stateSubState_26f7= CyPhyML::SignalFlow::State::Cast( subStateParent_26f6);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_26fb;
		if( !isValidBound(boundObjs_26fb, subState_26eb, true))
			continue;
		currMatch.subState_26fc= subState_26eb;
		if( !isValidBound(boundObjs_26fb, localVar_26f4, true))
			continue;
		currMatch.localVar_26fd= localVar_26f4;
		if( !isValidBound(boundObjs_26fb, stateSubState_26f7, false))
			continue;
		currMatch.state_26fe= stateSubState_26f7;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void NextHigherState_26db::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.state_26fe, currMatch.localVar_26fd);
	}
}

void NextHigherState_26db::outputAppender( const CyPhyML::SignalFlow::State& state_26ff, const SFC::LocalVar& localVar_2701)
{
	_state_26e2->push_back( state_26ff);
	_localVar_26e3->push_back( localVar_2701);
}

void Register_2709::operator()( const Packets_t& subsystems_270a, const Packets_t& localVars_270c)
{
#ifdef PRINT_INFO
	printLog( "Register_2709" );
#endif
	RTTGenerator::Instance()->generateRule(1933, "Register");
	processInputPackets( subsystems_270a, localVars_270c);
}

bool Register_2709::isInputUnique( const Udm::Object& subsystem_2712, const Udm::Object& localVar_271b)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_2714= _subsystem_270e.begin(), itLocalVar_271d= _localVar_2717.begin(); itSubsystem_2714!= _subsystem_270e.end(), itLocalVar_271d!= _localVar_2717.end(); ++itSubsystem_2714, ++itLocalVar_271d)
	{
		if( ( *itSubsystem_2714== subsystem_2712)&& ( *itLocalVar_271d== localVar_271b))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_270e.push_back( subsystem_2712);
		_localVar_2717.push_back( localVar_271b);
	}
	return isUnique;
}

bool Register_2709::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Register_2709::processInputPackets( const Packets_t& subsystems_270a, const Packets_t& localVars_270c)
{
	for( Packets_t::const_iterator itSubsystem_270f= subsystems_270a.begin(), itLocalVar_2718= localVars_270c.begin(); itSubsystem_270f!= subsystems_270a.end(), itLocalVar_2718!= localVars_270c.end(); ++itSubsystem_270f, ++itLocalVar_2718)
	{
		bool isUnique= isInputUnique( *itSubsystem_270f, *itLocalVar_2718);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_270f, *itLocalVar_2718);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool Register_2709::patternMatcher( const Udm::Object& subsystem_2710, const Udm::Object& localVar_2719)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_2710.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_2715= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_2710);
		if( false== Uml::IsDerivedFrom( localVar_2719.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_271e= SFC::LocalVar::Cast( localVar_2719);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2723;
		if( !isValidBound(boundObjs_2723, subsystem_2715, true))
			continue;
		currMatch.subsystem_2724= subsystem_2715;
		if( !isValidBound(boundObjs_2723, localVar_271e, true))
			continue;
		currMatch.localVar_2725= localVar_271e;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Register_2709::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar& LocalVar= currMatch.localVar_2725;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_2724;
		{
SFManager::AddTypedEntityScope( LocalVar );
};
	}
}

void GetScope_2726::operator()( const Packets_t& systems_2727, const Packets_t& localVars_2729, Packets_t& systems_272b, Packets_t& localVars_272c)
{
#ifdef PRINT_INFO
	printLog( "GetScope_2726" );
#endif
	_system_272d= &systems_272b;
	_localVar_272e= &localVars_272c;
	if( ( !systems_2727.empty())&& ( !localVars_2729.empty()))
		callSubSubsystemTest_27bf( systems_2727, localVars_2729);
}

void GetScope_2726::callSubSubsystemTest_27bf( const Packets_t& systems_2758, const Packets_t& localVars_275a)
{
	Packets_t systems_275c;
	Packets_t localVars_275d;
	Packets_t systems_275e;
	Packets_t localVars_275f;
	SubSubsystemTest_2757 subSubsystemTest_2757;
	subSubsystemTest_2757( systems_2758, localVars_275a, systems_275c, localVars_275d, systems_275e, localVars_275f);
	_system_272d->insert( _system_272d->end(), systems_275e.begin(), systems_275e.end());
	_localVar_272e->insert( _localVar_272e->end(), localVars_275f.begin(), localVars_275f.end());
	if( ( !systems_275c.empty())&& ( !localVars_275d.empty()))
		callAddToScope_27c2( systems_275c, localVars_275d);
}

void GetScope_2726::callAddToScope_27c2( const Packets_t& subSubsystems_2730, const Packets_t& localVars_2733)
{
	Packets_t subsystems_2732;
	Packets_t localVars_2735;
	AddToScope_272f addToScope_272f;
	addToScope_272f( subSubsystems_2730, localVars_2733, subsystems_2732, localVars_2735);
	if( ( !subsystems_2732.empty())&& ( !localVars_2735.empty()))
		callSubSubsystemTest_27bf( subsystems_2732, localVars_2735);
}

void AddToScope_272f::operator()( const Packets_t& subSubsystems_2730, const Packets_t& localVars_2733, Packets_t& subsystems_2732, Packets_t& localVars_2735)
{
#ifdef PRINT_INFO
	printLog( "AddToScope_272f" );
#endif
	RTTGenerator::Instance()->generateRule(1942, "AddToScope");
	_subsystem_2736= &subsystems_2732;
	_localVar_2737= &localVars_2735;
	processInputPackets( subSubsystems_2730, localVars_2733);
}

bool AddToScope_272f::isInputUnique( const Udm::Object& subSubsystem_273c, const Udm::Object& localVar_2745)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubSubsystem_273e= _subSubsystem_2738.begin(), itLocalVar_2747= _localVar_2741.begin(); itSubSubsystem_273e!= _subSubsystem_2738.end(), itLocalVar_2747!= _localVar_2741.end(); ++itSubSubsystem_273e, ++itLocalVar_2747)
	{
		if( ( *itSubSubsystem_273e== subSubsystem_273c)&& ( *itLocalVar_2747== localVar_2745))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subSubsystem_2738.push_back( subSubsystem_273c);
		_localVar_2741.push_back( localVar_2745);
	}
	return isUnique;
}

bool AddToScope_272f::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void AddToScope_272f::processInputPackets( const Packets_t& subSubsystems_2730, const Packets_t& localVars_2733)
{
	for( Packets_t::const_iterator itSubSubsystem_2739= subSubsystems_2730.begin(), itLocalVar_2742= localVars_2733.begin(); itSubSubsystem_2739!= subSubsystems_2730.end(), itLocalVar_2742!= localVars_2733.end(); ++itSubSubsystem_2739, ++itLocalVar_2742)
	{
		bool isUnique= isInputUnique( *itSubSubsystem_2739, *itLocalVar_2742);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubSubsystem_2739, *itLocalVar_2742);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool AddToScope_272f::patternMatcher( const Udm::Object& subSubsystem_273a, const Udm::Object& localVar_2743)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subSubsystem_273a.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subSubsystem_273f= CyPhyML::SignalFlow::Subsystem::Cast( subSubsystem_273a);
		if( false== Uml::IsDerivedFrom( localVar_2743.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_2748= SFC::LocalVar::Cast( localVar_2743);
		Udm::Object subSubsystemParent_274a= subSubsystem_273f.container();
		if( false== Uml::IsDerivedFrom( subSubsystemParent_274a.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystemSubSubsystem_274b= CyPhyML::SignalFlow::Subsystem::Cast( subSubsystemParent_274a);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_274f;
		if( !isValidBound(boundObjs_274f, subSubsystem_273f, true))
			continue;
		currMatch.subSubsystem_2750= subSubsystem_273f;
		if( !isValidBound(boundObjs_274f, localVar_2748, true))
			continue;
		currMatch.localVar_2751= localVar_2748;
		if( !isValidBound(boundObjs_274f, subsystemSubSubsystem_274b, false))
			continue;
		currMatch.subsystem_2752= subsystemSubSubsystem_274b;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void AddToScope_272f::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar& LocalVar= currMatch.localVar_2751;
		CyPhyML::SignalFlow::Subsystem& SubSubsystem= currMatch.subSubsystem_2750;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_2752;
		{
LocalVar.scope() =
 static_cast< std::string >( Subsystem.name() ) + "/" +
 static_cast< std::string >( LocalVar.scope() );
};
		outputAppender( currMatch.subsystem_2752, currMatch.localVar_2751);
	}
}

void AddToScope_272f::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_2753, const SFC::LocalVar& localVar_2755)
{
	_subsystem_2736->push_back( subsystem_2753);
	_localVar_2737->push_back( localVar_2755);
}

void SubSubsystemTest_2757::operator()( const Packets_t& systems_2758, const Packets_t& localVars_275a, Packets_t& systems_275c, Packets_t& localVars_275d, Packets_t& systems_275e, Packets_t& localVars_275f)
{
#ifdef PRINT_INFO
	printLog( "SubSubsystemTest_2757" );
#endif
	_system_2760= &systems_275c;
	_localVar_2761= &localVars_275d;
	_system_2762= &systems_275e;
	_localVar_2763= &localVars_275f;
	for( Packets_t::const_iterator itsystem_2765= systems_2758.begin(), itlocalVar_276c= localVars_275a.begin(); itsystem_2765!= systems_2758.end(), itlocalVar_276c!= localVars_275a.end(); ++itsystem_2765, ++itlocalVar_276c)
	{
		bool isUnique= isInputUnique( *itsystem_2765, *itlocalVar_276c);
		if( !isUnique)
			continue;
		Packets_t onesystem_2769( 1, *itsystem_2765);
		Packets_t onelocalVar_2770( 1, *itlocalVar_276c);
		executeOne( onesystem_2769, onelocalVar_2770);
	}
}

void SubSubsystemTest_2757::executeOne( const Packets_t& systems_2758, const Packets_t& localVars_275a)
{
	Packets_t subSubsystems_2775;
	Packets_t localVars_2778;
	NotTopSubsystem_2772 notTopSubsystem_2772;
	bool isMatchNotTopSubsystem_2772= notTopSubsystem_2772( systems_2758, localVars_275a, subSubsystems_2775, localVars_2778);
	_system_2760->insert( _system_2760->end(), subSubsystems_2775.begin(), subSubsystems_2775.end());
	_localVar_2761->insert( _localVar_2761->end(), localVars_2778.begin(), localVars_2778.end());
	Packets_t subsystems_279d;
	Packets_t localVars_27a0;
	Otherwise_279a otherwise_279a;
	bool isMatchOtherwise_279a= otherwise_279a( systems_2758, localVars_275a, subsystems_279d, localVars_27a0);
	_system_2762->insert( _system_2762->end(), subsystems_279d.begin(), subsystems_279d.end());
	_localVar_2763->insert( _localVar_2763->end(), localVars_27a0.begin(), localVars_27a0.end());
}

bool SubSubsystemTest_2757::isInputUnique( const Udm::Object& system_2766, const Udm::Object& localVar_276d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itsystem_2768= _system_2764.begin(), itlocalVar_276f= _localVar_276b.begin(); itsystem_2768!= _system_2764.end(), itlocalVar_276f!= _localVar_276b.end(); ++itsystem_2768, ++itlocalVar_276f)
	{
		if( ( *itsystem_2768== system_2766)&& ( *itlocalVar_276f== localVar_276d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_system_2764.push_back( system_2766);
		_localVar_276b.push_back( localVar_276d);
	}
	return isUnique;
}

bool NotTopSubsystem_2772::operator()( const Packets_t& subSubsystems_2773, const Packets_t& localVars_2776, Packets_t& subSubsystems_2775, Packets_t& localVars_2778)
{
#ifdef PRINT_INFO
	printLog( "NotTopSubsystem_2772" );
#endif
	_subSubsystem_2779= &subSubsystems_2775;
	_localVar_277a= &localVars_2778;
	processInputPackets( subSubsystems_2773, localVars_2776);
	if( false== _matches.empty())
		return true;
	return false;
}

bool NotTopSubsystem_2772::isInputUnique( const Udm::Object& subSubsystem_277f, const Udm::Object& localVar_2788)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubSubsystem_2781= _subSubsystem_277b.begin(), itLocalVar_278a= _localVar_2784.begin(); itSubSubsystem_2781!= _subSubsystem_277b.end(), itLocalVar_278a!= _localVar_2784.end(); ++itSubSubsystem_2781, ++itLocalVar_278a)
	{
		if( ( *itSubSubsystem_2781== subSubsystem_277f)&& ( *itLocalVar_278a== localVar_2788))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subSubsystem_277b.push_back( subSubsystem_277f);
		_localVar_2784.push_back( localVar_2788);
	}
	return isUnique;
}

bool NotTopSubsystem_2772::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void NotTopSubsystem_2772::processInputPackets( const Packets_t& subSubsystems_2773, const Packets_t& localVars_2776)
{
	for( Packets_t::const_iterator itSubSubsystem_277c= subSubsystems_2773.begin(), itLocalVar_2785= localVars_2776.begin(); itSubSubsystem_277c!= subSubsystems_2773.end(), itLocalVar_2785!= localVars_2776.end(); ++itSubSubsystem_277c, ++itLocalVar_2785)
	{
		bool isUnique= isInputUnique( *itSubSubsystem_277c, *itLocalVar_2785);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubSubsystem_277c, *itLocalVar_2785);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subSubsystem_2793, currMatch.localVar_2794);
	}
}

bool NotTopSubsystem_2772::patternMatcher( const Udm::Object& subSubsystem_277d, const Udm::Object& localVar_2786)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subSubsystem_277d.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subSubsystem_2782= CyPhyML::SignalFlow::Subsystem::Cast( subSubsystem_277d);
		if( false== Uml::IsDerivedFrom( localVar_2786.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_278b= SFC::LocalVar::Cast( localVar_2786);
		Udm::Object subSubsystemParent_278d= subSubsystem_2782.container();
		if( false== Uml::IsDerivedFrom( subSubsystemParent_278d.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystemSubSubsystem_278e= CyPhyML::SignalFlow::Subsystem::Cast( subSubsystemParent_278d);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2792;
		if( !isValidBound(boundObjs_2792, subSubsystem_2782, true))
			continue;
		currMatch.subSubsystem_2793= subSubsystem_2782;
		if( !isValidBound(boundObjs_2792, localVar_278b, true))
			continue;
		currMatch.localVar_2794= localVar_278b;
		if( !isValidBound(boundObjs_2792, subsystemSubSubsystem_278e, false))
			continue;
		currMatch.subsystem_2795= subsystemSubSubsystem_278e;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void NotTopSubsystem_2772::outputAppender( const CyPhyML::SignalFlow::Subsystem& subSubsystem_2796, const SFC::LocalVar& localVar_2798)
{
	_subSubsystem_2779->push_back( subSubsystem_2796);
	_localVar_277a->push_back( localVar_2798);
}

bool Otherwise_279a::operator()( const Packets_t& subsystems_279b, const Packets_t& localVars_279e, Packets_t& subsystems_279d, Packets_t& localVars_27a0)
{
#ifdef PRINT_INFO
	printLog( "Otherwise_279a" );
#endif
	_subsystem_27a1= &subsystems_279d;
	_localVar_27a2= &localVars_27a0;
	processInputPackets( subsystems_279b, localVars_279e);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_279a::isInputUnique( const Udm::Object& subsystem_27a7, const Udm::Object& localVar_27b0)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_27a9= _subsystem_27a3.begin(), itLocalVar_27b2= _localVar_27ac.begin(); itSubsystem_27a9!= _subsystem_27a3.end(), itLocalVar_27b2!= _localVar_27ac.end(); ++itSubsystem_27a9, ++itLocalVar_27b2)
	{
		if( ( *itSubsystem_27a9== subsystem_27a7)&& ( *itLocalVar_27b2== localVar_27b0))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_27a3.push_back( subsystem_27a7);
		_localVar_27ac.push_back( localVar_27b0);
	}
	return isUnique;
}

bool Otherwise_279a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_279a::processInputPackets( const Packets_t& subsystems_279b, const Packets_t& localVars_279e)
{
	for( Packets_t::const_iterator itSubsystem_27a4= subsystems_279b.begin(), itLocalVar_27ad= localVars_279e.begin(); itSubsystem_27a4!= subsystems_279b.end(), itLocalVar_27ad!= localVars_279e.end(); ++itSubsystem_27a4, ++itLocalVar_27ad)
	{
		bool isUnique= isInputUnique( *itSubsystem_27a4, *itLocalVar_27ad);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_27a4, *itLocalVar_27ad);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_27b9, currMatch.localVar_27ba);
	}
}

bool Otherwise_279a::patternMatcher( const Udm::Object& subsystem_27a5, const Udm::Object& localVar_27ae)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_27a5.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_27aa= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_27a5);
		if( false== Uml::IsDerivedFrom( localVar_27ae.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_27b3= SFC::LocalVar::Cast( localVar_27ae);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_27b8;
		if( !isValidBound(boundObjs_27b8, subsystem_27aa, true))
			continue;
		currMatch.subsystem_27b9= subsystem_27aa;
		if( !isValidBound(boundObjs_27b8, localVar_27b3, true))
			continue;
		currMatch.localVar_27ba= localVar_27b3;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_279a::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_27bb, const SFC::LocalVar& localVar_27bd)
{
	_subsystem_27a1->push_back( subsystem_27bb);
	_localVar_27a2->push_back( localVar_27bd);
}

void CreateTypes_2807::operator()( const Packets_t& rootFolders_2808, const Packets_t& states_280a, const Packets_t& projects_280c, Packets_t& states_280e, Packets_t& projects_280f)
{
#ifdef PRINT_INFO
	printLog( "CreateTypes_2807" );
#endif
	_state_2810= &states_280e;
	_project_2811= &projects_280f;
	_state_2810->insert( _state_2810->end(), states_280a.begin(), states_280a.end());
	_project_2811->insert( _project_2811->end(), projects_280c.begin(), projects_280c.end());
	if( ( !rootFolders_2808.empty())&& ( !projects_280c.empty()))
		callGetTypeBlock_2db4( rootFolders_2808, projects_280c);
}

void CreateTypes_2807::callGetTypeBlock_2db4( const Packets_t& rootFolders_2d48, const Packets_t& projects_2d4a)
{
	Packets_t typess_2d4c;
	Packets_t projects_2d4d;
	GetTypeBlock_2d47 getTypeBlock_2d47;
	getTypeBlock_2d47( rootFolders_2d48, projects_2d4a, typess_2d4c, projects_2d4d);
	if( ( !typess_2d4c.empty())&& ( !projects_2d4d.empty()))
		callCreateTypesInner_2db7( typess_2d4c, projects_2d4d);
}

void CreateTypes_2807::callCreateTypesInner_2db7( const Packets_t& typess_2813, const Packets_t& projects_2815)
{
	Packets_t typess_2817;
	Packets_t newStructs_2818;
	CreateTypesInner_2812 createTypesInner_2812;
	createTypesInner_2812( typess_2813, projects_2815, typess_2817, newStructs_2818);
	if( ( !typess_2817.empty())&& ( !newStructs_2818.empty()))
		callStructMembers_2dba( typess_2817, newStructs_2818);
}

void CreateTypes_2807::callStructMembers_2dba( const Packets_t& typess_2d18, const Packets_t& newStructs_2d1a)
{
	Packets_t newStructs_2d1c;
	StructMembers_2d17 structMembers_2d17;
	structMembers_2d17( typess_2d18, newStructs_2d1a, newStructs_2d1c);
	if( ( !newStructs_2d1c.empty()))
		callRegisterStruct_2dbd( newStructs_2d1c);
}

void CreateTypes_2807::callRegisterStruct_2dbd( const Packets_t& sfcStructs_2d07)
{
	RegisterStruct_2d06 registerStruct_2d06;
	registerStruct_2d06( sfcStructs_2d07);
}

void CreateTypesInner_2812::operator()( const Packets_t& typess_2813, const Packets_t& projects_2815, Packets_t& typess_2817, Packets_t& newStructs_2818)
{
#ifdef PRINT_INFO
	printLog( "CreateTypesInner_2812" );
#endif
	_types_2819= &typess_2817;
	_newStruct_281a= &newStructs_2818;
	for( Packets_t::const_iterator ittypes_281c= typess_2813.begin(), itproject_2823= projects_2815.begin(); ittypes_281c!= typess_2813.end(), itproject_2823!= projects_2815.end(); ++ittypes_281c, ++itproject_2823)
	{
		bool isUnique= isInputUnique( *ittypes_281c, *itproject_2823);
		if( !isUnique)
			continue;
		Packets_t onetypes_2820( 1, *ittypes_281c);
		Packets_t oneproject_2827( 1, *itproject_2823);
		executeOne( onetypes_2820, oneproject_2827);
	}
}

void CreateTypesInner_2812::executeOne( const Packets_t& typess_2813, const Packets_t& projects_2815)
{
	if( ( !typess_2813.empty())&& ( !projects_2815.empty()))
		callStructOrMatrix_2cfd( typess_2813, projects_2815);
}

bool CreateTypesInner_2812::isInputUnique( const Udm::Object& types_281d, const Udm::Object& project_2824)
{
	bool isUnique= true;
	for( Packets_t::const_iterator ittypes_281f= _types_281b.begin(), itproject_2826= _project_2822.begin(); ittypes_281f!= _types_281b.end(), itproject_2826!= _project_2822.end(); ++ittypes_281f, ++itproject_2826)
	{
		if( ( *ittypes_281f== types_281d)&& ( *itproject_2826== project_2824))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_types_281b.push_back( types_281d);
		_project_2822.push_back( project_2824);
	}
	return isUnique;
}

void CreateTypesInner_2812::callStructOrMatrix_2cfd( const Packets_t& typess_2c73, const Packets_t& projects_2c75)
{
	Packets_t typess_2c77;
	Packets_t projects_2c78;
	Packets_t typess_2c79;
	Packets_t projects_2c7a;
	StructOrMatrix_2c72 structOrMatrix_2c72;
	structOrMatrix_2c72( typess_2c73, projects_2c75, typess_2c77, projects_2c78, typess_2c79, projects_2c7a);
	if( ( !typess_2c77.empty())&& ( !projects_2c78.empty()))
		callCreateStructType_2d00( typess_2c77, projects_2c78);
	if( ( !typess_2c79.empty())&& ( !projects_2c7a.empty()))
		callCreateArrayOrBasicType_2d03( typess_2c79, projects_2c7a);
}

void CreateTypesInner_2812::callCreateStructType_2d00( const Packets_t& ecsl_dp_Structs_2cd8, const Packets_t& projects_2cdb)
{
	Packets_t ecsl_dp_Structs_2cda;
	Packets_t sfc_Structs_2cdd;
	CreateStructType_2cd7 createStructType_2cd7;
	createStructType_2cd7( ecsl_dp_Structs_2cd8, projects_2cdb, ecsl_dp_Structs_2cda, sfc_Structs_2cdd);
	_types_2819->insert( _types_2819->end(), ecsl_dp_Structs_2cda.begin(), ecsl_dp_Structs_2cda.end());
	_newStruct_281a->insert( _newStruct_281a->end(), sfc_Structs_2cdd.begin(), sfc_Structs_2cdd.end());
}

void CreateTypesInner_2812::callCreateArrayOrBasicType_2d03( const Packets_t& typess_282a, const Packets_t& projects_282c)
{
	CreateArrayOrBasicType_2829 createArrayOrBasicType_2829;
	createArrayOrBasicType_2829( typess_282a, projects_282c);
}

void CreateArrayOrBasicType_2829::operator()( const Packets_t& typess_282a, const Packets_t& projects_282c)
{
#ifdef PRINT_INFO
	printLog( "CreateArrayOrBasicType_2829" );
#endif
	if( ( !typess_282a.empty())&& ( !projects_282c.empty()))
		callDimensionTest_2c60( typess_282a, projects_282c);
}

void CreateArrayOrBasicType_2829::callDimensionTest_2c60( const Packets_t& typess_2bcf, const Packets_t& projects_2bd1)
{
	Packets_t typess_2bd3;
	Packets_t projects_2bd4;
	Packets_t typess_2bd5;
	Packets_t projects_2bd6;
	Packets_t typess_2bd7;
	Packets_t projects_2bd8;
	DimensionTest_2bce dimensionTest_2bce;
	dimensionTest_2bce( typess_2bcf, projects_2bd1, typess_2bd3, projects_2bd4, typess_2bd5, projects_2bd6, typess_2bd7, projects_2bd8);
	if( ( !typess_2bd7.empty())&& ( !projects_2bd8.empty()))
		callProcessOther_2c63( typess_2bd7, projects_2bd8);
	if( ( !typess_2bd5.empty())&& ( !projects_2bd6.empty()))
		callProcessColumn_2c66( typess_2bd5, projects_2bd6);
	if( ( !typess_2bd3.empty())&& ( !projects_2bd4.empty()))
		callProcessScalar_2c69( typess_2bd3, projects_2bd4);
}

void CreateArrayOrBasicType_2829::callProcessOther_2c63( const Packets_t& typess_286d, const Packets_t& projects_286f)
{
	Packets_t typess_2871;
	Packets_t array1s_2872;
	Packets_t projects_2873;
	ProcessOther_286c processOther_286c;
	processOther_286c( typess_286d, projects_286f, typess_2871, array1s_2872, projects_2873);
	if( ( !typess_2871.empty())&& ( !array1s_2872.empty()))
		callRegisterType_2c6c( typess_2871, array1s_2872);
}

void CreateArrayOrBasicType_2829::callProcessColumn_2c66( const Packets_t& typess_2bbd, const Packets_t& projects_2bbf)
{
	Packets_t typess_2bc1;
	Packets_t array1s_2bc2;
	Packets_t projects_2bc3;
	ProcessColumn_2bbc processColumn_2bbc;
	processColumn_2bbc( typess_2bbd, projects_2bbf, typess_2bc1, array1s_2bc2, projects_2bc3);
	if( ( !typess_2bc1.empty())&& ( !array1s_2bc2.empty()))
		callRegisterType_2c6c( typess_2bc1, array1s_2bc2);
}

void CreateArrayOrBasicType_2829::callProcessScalar_2c69( const Packets_t& typess_29ad, const Packets_t& projects_29af)
{
	Packets_t typess_29b1;
	Packets_t basictypes_29b2;
	Packets_t projects_29b3;
	ProcessScalar_29ac processScalar_29ac;
	processScalar_29ac( typess_29ad, projects_29af, typess_29b1, basictypes_29b2, projects_29b3);
	if( ( !typess_29b1.empty())&& ( !basictypes_29b2.empty()))
		callRegisterType_2c6c( typess_29b1, basictypes_29b2);
}

void CreateArrayOrBasicType_2829::callRegisterType_2c6c( const Packets_t& matrixs_282f, const Packets_t& dTs_2832)
{
	Packets_t matrixs_2831;
	Packets_t dTs_2834;
	RegisterType_282e registerType_282e;
	registerType_282e( matrixs_282f, dTs_2832, matrixs_2831, dTs_2834);
	if( ( !matrixs_2831.empty())&& ( !dTs_2834.empty()))
		callMakeAssoc_2c6f( matrixs_2831, dTs_2834);
}

void CreateArrayOrBasicType_2829::callMakeAssoc_2c6f( const Packets_t& matrixs_2850, const Packets_t& dTs_2852)
{
	MakeAssoc_284f makeAssoc_284f;
	makeAssoc_284f( matrixs_2850, dTs_2852);
}

void RegisterType_282e::operator()( const Packets_t& matrixs_282f, const Packets_t& dTs_2832, Packets_t& matrixs_2831, Packets_t& dTs_2834)
{
#ifdef PRINT_INFO
	printLog( "RegisterType_282e" );
#endif
	RTTGenerator::Instance()->generateRule(1990, "RegisterType");
	_matrix_2835= &matrixs_2831;
	_dT_2836= &dTs_2834;
	processInputPackets( matrixs_282f, dTs_2832);
	forwardInputs( );
}

bool RegisterType_282e::isInputUnique( const Udm::Object& matrix_283b, const Udm::Object& dT_2844)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_283d= _matrix_2837.begin(), itDT_2846= _dT_2840.begin(); itMatrix_283d!= _matrix_2837.end(), itDT_2846!= _dT_2840.end(); ++itMatrix_283d, ++itDT_2846)
	{
		if( ( *itMatrix_283d== matrix_283b)&& ( *itDT_2846== dT_2844))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_2837.push_back( matrix_283b);
		_dT_2840.push_back( dT_2844);
	}
	return isUnique;
}

bool RegisterType_282e::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void RegisterType_282e::processInputPackets( const Packets_t& matrixs_282f, const Packets_t& dTs_2832)
{
	for( Packets_t::const_iterator itMatrix_2838= matrixs_282f.begin(), itDT_2841= dTs_2832.begin(); itMatrix_2838!= matrixs_282f.end(), itDT_2841!= dTs_2832.end(); ++itMatrix_2838, ++itDT_2841)
	{
		bool isUnique= isInputUnique( *itMatrix_2838, *itDT_2841);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_2838, *itDT_2841);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool RegisterType_282e::patternMatcher( const Udm::Object& matrix_2839, const Udm::Object& dT_2842)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_2839.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_283e= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_2839);
		if( false== Uml::IsDerivedFrom( dT_2842.type(), SFC::DT::meta))
			continue;
		SFC::DT dT_2847= SFC::DT::Cast( dT_2842);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_284c;
		if( !isValidBound(boundObjs_284c, matrix_283e, true))
			continue;
		currMatch.matrix_284d= matrix_283e;
		if( !isValidBound(boundObjs_284c, dT_2847, true))
			continue;
		currMatch.dT_284e= dT_2847;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void RegisterType_282e::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *it