/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef SFUTILS_H
#define SFUTILS_H

#include <string>
#include <cctype>	// for isalpha, isalnum

class SFUtils
{
public:
	static std::string convertToCPlusPlusName( const std::string& name)
	{
/*		unsigned char unaut= 0xfc;
		unsigned char unaut= '';
		std::cout << unaut;
		if ( isalpha( unaut))
			std::cout << " is alpha."; 
		else 
			std::cout << " is not alpha.";
		std::cout << std::endl;
*/		// empty name
		if ( name.empty())
			return "";
		// name must start with letter
		std::string converted;
		if ( false== isalpha( (unsigned char)name[ 0]))
			converted= "pre";
		// name can contain alphanum characthers and '_'
		for( std::string::const_iterator i= name.begin(); i!= name.end(); ++i)
		{
			if ( isalnum( (unsigned char)*i) || (*i== '_'))
				converted+= *i;
			else
				converted+= '_';
		}
		return converted;
	}
};

#endif //UTILS_H
