/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "runSF_CodeGen.h"

#include "SLSF.h"

#include "SFCUdmEngine.hpp"
#include "GenCyPhy2SFC.h"
//#include "InputFileRegistry.h"
#include "SFCprint.h"
#include "CPrinter.hpp"
#include "JPrinter.hpp"
#include "SFuncWrapperPrint.h"
#include "SfUtils.h"
//#include "transroot.hpp"
#include "ConfigKeeper.hpp"
#include "mfile2SFC.hpp"
#include <iostream>
#include <boost/filesystem.hpp>
#include <Uml.h>
#include <UmlExt.h>
#include "CGLog.h"

#include "UdmConsole.h"

#ifdef _WIN32
//UDM_USE_DOM
UDM_USE_MGA
#endif

typedef std::set< SFC::Program > ProgramSet;
typedef std::set< CyPhyML::SignalFlow::State> StateSet;
typedef std::set< CyPhyML::SignalFlow::SFState > SFStateSet;
typedef std::set< CyPhyML::SignalFlow::Transition > TransitionSet;
typedef std::set< CyPhyML::SignalFlow::SFTransition > SFTransitionSet;
typedef std::set< CyPhyML::SignalFlow::Data > DataSet;
typedef std::set< CyPhyML::SignalFlow::SFData > SFDataSet;
typedef std::set< CyPhyML::SignalFlow::Event > EventSet;
typedef std::set< CyPhyML::SignalFlow::SFEvent > SFEventSet;

// When this function is used as an exported .dll function by some other .dll 
// then we need to initialize the metas according to the following func.
void __declspec(dllexport) runCyPhySF_CodeGen_dllimported(const CyPhyML::SignalFlowModel &sfmodel, std::string cyphy_file, 
						Uml::Diagram &cyphy_meta_diagram, std::string logFile, std::string directory)
{
	UdmDom::str_xsd_storage::RemoveXsd("CyPhyML.xsd");

	LINKS::Initialize();
	CyPhyML::Initialize(cyphy_meta_diagram);
	
	// Collect Datanetwork to be passed to runCyPhy2SL_codeGen func
	Udm::DataNetwork * dn = sfmodel.__impl()->__getdn();
	// Generate Code
	openLogFile(logFile, true);
	printLog("******Start model transformation(SF_CodeGen) for SignalFlow model: "+(std::string)sfmodel.name()+"******");
	runCyPhySF_CodeGen(sfmodel, cyphy_file, dn, directory);
	printLog("******End model transformation(SF_CodeGen)******");
	closeLogFile();
}

void getStates(const CyPhyML::SignalFlow::Block &block, StateSet &states)
{
	set<CyPhyML::SignalFlow::State> bstates = block.State_kind_children();
	states.insert(bstates.begin(), bstates.end());
	if(Uml::IsDerivedFrom(block.type(), CyPhyML::SignalFlow::Subsystem::meta))
	{
		const CyPhyML::SignalFlow::Subsystem &subsys = CyPhyML::SignalFlow::Subsystem::Cast(block);
		set<CyPhyML::SignalFlow::Block> blocks = subsys.Block_kind_children();
		for(set<CyPhyML::SignalFlow::Block>::iterator bit=blocks.begin();bit!=blocks.end();++bit)
		{
			CyPhyML::SignalFlow::Block currBlock = *bit;
			getStates(currBlock, states);
		}
	}		
}

void getSFStates(const CyPhyML::SignalFlow::Block &block, SFStateSet &states)
{
	set<CyPhyML::SignalFlow::SFState> bstates = block.SFState_kind_children();
	states.insert(bstates.begin(), bstates.end());
	if(Uml::IsDerivedFrom(block.type(), CyPhyML::SignalFlow::Subsystem::meta))
	{
		const CyPhyML::SignalFlow::Subsystem &subsys = CyPhyML::SignalFlow::Subsystem::Cast(block);
		set<CyPhyML::SignalFlow::Block> blocks = subsys.Block_kind_children();
		for(set<CyPhyML::SignalFlow::Block>::iterator bit=blocks.begin();bit!=blocks.end();++bit)
		{
			CyPhyML::SignalFlow::Block currBlock = *bit;
			getSFStates(currBlock, states);
		}
	}		
}

void runCyPhySF_CodeGen(const CyPhyML::SignalFlowModel &sfmodel, std::string cyphy_file, Udm::DataNetwork* sdn_cyphy, std::string directory)
{
	if (CyPhyML::SignalFlowModel::meta == Udm::null)
		throw udm_exception("CyPhyML diagram is not initialized");
	set<CyPhyML::SignalFlow::Subsystem> syss = sfmodel.SignalFlow_Subsystem_kind_children();
	for(set<CyPhyML::SignalFlow::Subsystem>::iterator it=syss.begin();it!=syss.end();++it)
	{
		CyPhyML::SignalFlow::Subsystem sys = *it;
		runCyPhySF_CodeGen(sys, cyphy_file, sdn_cyphy, directory);
	}
}

void runCyPhySF_CodeGen(const CyPhyML::SignalFlow::Subsystem &sys, std::string cyphy_file, Udm::DataNetwork* sdn_cyphy, std::string directory)
{
	std::string outputDirectory = directory;
	std::string projectName;
	if(!cyphy_file.empty())
	{
		std::string inputFilename = cyphy_file;
		projectName = inputFilename.substr(  0, inputFilename.rfind( "." )  );
	}
	else
	{
		Udm::Object sfparent = sys.parent();
		projectName = UdmUtil::ExtractName(sfparent);
	}

	try 
	{
		std::vector< Udm::StaticDataNetworkSpecifier> dnsvec;
		//Udm::StaticDataNetworkSpecifier sdns_cyphy(cyphy_file, sdn_cyphy);
		Udm::StaticDataNetworkSpecifier sdns_cyphy("", sdn_cyphy);
		dnsvec.push_back( sdns_cyphy);

		// create SFC w
		UdmDom::DomDataNetwork &sdn_sfc = SFCUdmEngine::get_singleton().getDomDataNetwork();
		sdn_sfc.CreateNew("_sftemp.xml", "SFC.xsd", SFC::Project::meta, Udm::CHANGES_PERSIST_ALWAYS);

		Udm::StaticDataNetworkSpecifier sdns_SFC("_sftemp.xml", &sdn_sfc);
		dnsvec.push_back( sdns_SFC);

		Udm::StaticUdmProject prj( dnsvec, CyPhy2SFC::diagram);

		StateSet states;
		getStates(sys, states);

		SFStateSet sfstates;
		getSFStates( sys, sfstates );

		std::string sysName = UdmUtil::ExtractName(sys.GetParent());

		Packets_t projects;	
		SFC::Project rootSFC = SFC::Project::Cast(sdn_sfc.GetRootObject() );
		rootSFC.name() = projectName;
		projects.push_back(rootSFC);

		Packets_t rootFolder;
		CyPhyML::RootFolder cyphy_rf = CyPhyML::RootFolder::Cast(sdn_cyphy->GetRootObject());
		rootFolder.push_back(cyphy_rf);

		// transformation
		// for each rootSFC ...
		for( StateSet::const_iterator it = states.begin() ; it!= states.end() ; ++it ) 
		{
			Packets_t oneRootState;
			oneRootState.push_back( *it );
			TL_0 tL_0;
			tL_0(rootFolder, oneRootState, projects);

			const SLSF::State& state = SLSF::State::Cast( *it);
			const std::string& stateName= state.name();
			const set<SLSF::ConnectorRef>& crefs = state.referedbyConnectorRef();
			int ni=0;
			for( set< SLSF::ConnectorRef >::const_iterator cri=crefs.begin() ; cri!=crefs.end() ; cri++ ) 
			{
				SLSF::ConnectorRef cref = *cri;
				const set<SLSF::ConnectorRef>& crefins = cref.Instances();
				ni += crefins.size();
			}

			boost::filesystem::current_path( outputDirectory );

			ProgramSet programSet = rootSFC.Program_kind_children();
			for( ProgramSet::iterator pgsItr = programSet.begin() ; pgsItr != programSet.end() ; (void)++pgsItr )
			{
				pgsItr->filename() = SFUtils::convertToCPlusPlusName( stateName );
			}

			CPrinter::print( rootSFC);
				
			boost::filesystem::current_path(outputDirectory);

			sdn_sfc.SaveAs( outputDirectory + "/" + sysName + "_" + stateName + "_SFC.xml" );

			// Delete program
			std::set< SFC::Statement> statements = rootSFC.Statement_kind_children();
			for(
				std::set< SFC::Statement >::iterator itS = statements.begin() ;
				itS != statements.end() ;
				++itS
			) 
				{
				SFC::Statement ob = *itS;
				ob.DeleteObject();
			}

#ifdef _DEBUG
			std::set< SFC::Statement> statements2= rootSFC.Statement_kind_children();
			for( std::set< SFC::Statement>::const_iterator itS2= statements2.begin(); itS2!= statements2.end(); ++itS2) {
				std::cout << itS2->statementIndex() << endl;
			}
#endif
			// initialize program
			rootSFC.statementCount()= 0;
			rootSFC.statementIndex() = 0;
		}


		// Duplicate the above for SFStates
		// for each rootSFC ...
		for( SFStateSet::const_iterator it = sfstates.begin() ; it!= sfstates.end() ; ++it ) 
		{
			Packets_t oneRootState;
			oneRootState.push_back( *it );
			T2L_3761 tl2;
			tl2(rootFolder, oneRootState, projects);

			const SLSF::SFState& state = SLSF::SFState::Cast( *it);
			const std::string& stateName= state.name();
			const set<SLSF::SFConnectorRef>& crefs = state.referedbyConnectorRef();
			int ni=0;
			for( set< SLSF::SFConnectorRef >::const_iterator cri=crefs.begin() ; cri!=crefs.end() ; cri++ ) 
			{
				SLSF::SFConnectorRef cref = *cri;
				const set<SLSF::SFConnectorRef>& crefins = cref.Instances();
				ni += crefins.size();
			}

	//		boost::filesystem::path path = boost::filesystem::current_path();
			boost::filesystem::current_path( outputDirectory );
			//boost::filesystem::current_path(sysName);

			ProgramSet programSet = rootSFC.Program_kind_children();
			for( ProgramSet::iterator pgsItr = programSet.begin() ; pgsItr != programSet.end() ; (void)++pgsItr )
			{
				pgsItr->filename() = SFUtils::convertToCPlusPlusName( stateName );
			}

			CPrinter::print( rootSFC);
				
	//		boost::filesystem::current_path( path );
			boost::filesystem::current_path(outputDirectory);

			sdn_sfc.SaveAs( outputDirectory + "/" + sysName + "_" + stateName + "_SFC.xml" );

			// Delete program
			std::set< SFC::Statement> statements = rootSFC.Statement_kind_children();
			for(
				std::set< SFC::Statement >::iterator itS = statements.begin() ;
				itS != statements.end() ;
				++itS
			) 
				{
				SFC::Statement ob = *itS;
				ob.DeleteObject();
			}

#ifdef _DEBUG
			std::set< SFC::Statement> statements2= rootSFC.Statement_kind_children();
			for( std::set< SFC::Statement>::const_iterator itS2= statements2.begin(); itS2!= statements2.end(); ++itS2) {
				std::cout << itS2->statementIndex() << endl;
			}
#endif
			// initialize program
			rootSFC.statementCount()= 0;
			rootSFC.statementIndex() = 0;
		}

			// Close the project
	  		prj.Close();
			// Close SFC w
			sdn_sfc.CloseWithUpdate();

			boost::filesystem::remove( "_sftemp.xml" );
			boost::filesystem::remove( "_sftemp.mem" );
	}
	catch( udm_exception &e)
	{
		cout << e.what() << endl;
		return;
	}
	catch(exception &e)
	{
		printLog(e.what());
		return;
	}
	catch(...)
	{
		printLog("Exception throw.");
		return;
	}	
	std::cout << "Done." << std::endl;
}