/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
/* NAME:	Error Log (Dummy)
 * AUTHOR:	Feng Shi - fengshi@isis-server.isis.vanderbilt.edu
 */
#ifndef __CGLOG_H
#define __CGLOG_H

#ifdef _MSC_VER
#pragma warning (disable : 4786)
#pragma warning (disable : 4503) 
#endif


#include <string>
#include <fstream>
#include <iostream>


class CGLog
{
public:
	static std::string filePath;
	static CGLog* Instance();
	static CGLog* Instance(const std::string& file_path, bool append=false);
	void print(const std::string& msg);
	void close();
protected:
	CGLog();
	CGLog( const std::string& file_path, bool append);
	~CGLog();
private:
    static CGLog* instance;
	std::ofstream logFile;
};

//Open log file
extern void openLogFile(const std::string& file_path, bool append=false);
extern void closeLogFile();
extern void printLog( const std::string& msg);

#endif //__CGLOG_H
