/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
/* GenCyPhy2SLC.cpp generated on Tue Feb 12 13:05:09 2013
 */

#include "GenCyPhy2SLC.h"
#include <UmlExt.h>
#include "GReATSort.h"
#include "RTTGenerator.h"
#include "CyPhy2SLC-gr_cmptempl.h"
#include "CGLog.h"

void TL_0::operator()( const Packets_t& dataflows_1, const Packets_t& projects_3)
{
#ifdef PRINT_INFO
	printLog("TL_0" );
#endif
	if( ( !dataflows_1.empty())&& ( !projects_3.empty()))
		callGetProject_5ab4( dataflows_1, projects_3);
}

void TL_0::callGetProject_5ab4( const Packets_t& dataflows_6, const Packets_t& projects_9)
{
	Packets_t dataflows_8;
	Packets_t projects_b;
	GetProject_5 getProject_5;
	getProject_5( dataflows_6, projects_9, dataflows_8, projects_b);
	if( ( !dataflows_8.empty())&& ( !projects_b.empty()))
		callCheckPorts_5ab7( dataflows_8, projects_b);
}

void TL_0::callCheckPorts_5ab7( const Packets_t& comptypes_5628, const Packets_t& projects_562a)
{
	Packets_t dataflows_562c;
	Packets_t projects_562d;
	CheckPorts_5627 checkPorts_5627;
	checkPorts_5627( comptypes_5628, projects_562a, dataflows_562c, projects_562d);
	if( ( !dataflows_562c.empty())&& ( !projects_562d.empty()))
		callCreateTypes_5aba( dataflows_562c, projects_562d);
}

void TL_0::callCreateTypes_5aba( const Packets_t& dataflows_27, const Packets_t& projects_29)
{
	Packets_t dataflows_2b;
	Packets_t projects_2c;
	CreateTypes_26 createTypes_26;
	createTypes_26( dataflows_27, projects_29, dataflows_2b, projects_2c);
	if( ( !dataflows_2b.empty())&& ( !projects_2c.empty()))
		callMakeClasses_5abd( dataflows_2b, projects_2c);
}

void TL_0::callMakeClasses_5abd( const Packets_t& dataflows_121e, const Packets_t& projects_1220)
{
	Packets_t dataflows_1222;
	Packets_t projects_1223;
	MakeClasses_121d makeClasses_121d;
	makeClasses_121d( dataflows_121e, projects_1220, dataflows_1222, projects_1223);
	if( ( !dataflows_1222.empty())&& ( !projects_1223.empty()))
		callFinishClasses_5ac0( dataflows_1222, projects_1223);
}

void TL_0::callFinishClasses_5ac0( const Packets_t& dataflows_53cd, const Packets_t& projects_53cf)
{
	Packets_t dataflows_53d1;
	Packets_t projects_53d2;
	FinishClasses_53cc finishClasses_53cc;
	finishClasses_53cc( dataflows_53cd, projects_53cf, dataflows_53d1, projects_53d2);
	if( ( !dataflows_53d1.empty())&& ( !projects_53d2.empty()))
		callParamInitFcn_5ac3( dataflows_53d1, projects_53d2);
}

void TL_0::callParamInitFcn_5ac3( const Packets_t& dataflows_581b, const Packets_t& projects_581d)
{
	Packets_t dataflows_581f;
	Packets_t projects_5820;
	ParamInitFcn_581a paramInitFcn_581a;
	paramInitFcn_581a( dataflows_581b, projects_581d, dataflows_581f, projects_5820);
	if( ( !dataflows_581f.empty())&& ( !projects_5820.empty()))
		callMergeClasses_5ac6( dataflows_581f, projects_5820);
}

void TL_0::callMergeClasses_5ac6( const Packets_t& dataflows_6b3, const Packets_t& projects_6b5)
{
	Packets_t dataflows_6b7;
	Packets_t projects_6b8;
	MergeClasses_6b2 mergeClasses_6b2;
	mergeClasses_6b2( dataflows_6b3, projects_6b5, dataflows_6b7, projects_6b8);
	if( ( !dataflows_6b7.empty())&& ( !projects_6b8.empty()))
		callConstructors_5ac9( dataflows_6b7, projects_6b8);
}

void TL_0::callConstructors_5ac9( const Packets_t& dataflows_d95, const Packets_t& projects_d97)
{
	Packets_t dataflows_d99;
	Packets_t projects_d9a;
	Constructors_d94 constructors_d94;
	constructors_d94( dataflows_d95, projects_d97, dataflows_d99, projects_d9a);
}

void GetProject_5::operator()( const Packets_t& dataflows_6, const Packets_t& projects_9, Packets_t& dataflows_8, Packets_t& projects_b)
{
#ifdef PRINT_INFO
	printLog("GetProject_5" );
#endif
	RTTGenerator::Instance()->generateRule(6, "GetProject");
	_dataflow_c= &dataflows_8;
	_project_d= &projects_b;
	processInputPackets( dataflows_6, projects_9);
	forwardInputs( );
}

bool GetProject_5::isInputUnique( const Udm::Object& dataflow_12, const Udm::Object& project_1b)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itDataflow_14= _dataflow_e.begin(), itProject_1d= _project_17.begin(); itDataflow_14!= _dataflow_e.end(), itProject_1d!= _project_17.end(); ++itDataflow_14, ++itProject_1d)
	{
		if( ( *itDataflow_14== dataflow_12)&& ( *itProject_1d== project_1b))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_dataflow_e.push_back( dataflow_12);
		_project_17.push_back( project_1b);
	}
	return isUnique;
}

bool GetProject_5::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetProject_5::processInputPackets( const Packets_t& dataflows_6, const Packets_t& projects_9)
{
	for( Packets_t::const_iterator itDataflow_f= dataflows_6.begin(), itProject_18= projects_9.begin(); itDataflow_f!= dataflows_6.end(), itProject_18!= projects_9.end(); ++itDataflow_f, ++itProject_18)
	{
		bool isUnique= isInputUnique( *itDataflow_f, *itProject_18);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itDataflow_f, *itProject_18);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetProject_5::patternMatcher( const Udm::Object& dataflow_10, const Udm::Object& project_19)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( dataflow_10.type(), CyPhyML::SignalFlowModel::meta))
			continue;
		CyPhyML::SignalFlowModel dataflow_15= CyPhyML::SignalFlowModel::Cast( dataflow_10);
		if( false== Uml::IsDerivedFrom( project_19.type(), SFC::Project::meta))
			continue;
		SFC::Project project_1e= SFC::Project::Cast( project_19);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_23;
		if( !isValidBound(boundObjs_23, dataflow_15, true))
			continue;
		currMatch.dataflow_24= dataflow_15;
		if( !isValidBound(boundObjs_23, project_1e, true))
			continue;
		currMatch.project_25= project_1e;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void GetProject_5::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		CyPhyML::SignalFlowModel& Dataflow= currMatch.dataflow_24;
		SFC::Project& Project= currMatch.project_25;
		{
SFCTypesManager::initSingleton( Project );
};
	}
}

void GetProject_5::forwardInputs()
{
	*_dataflow_c= _dataflow_e;
	*_project_d= _project_17;
}

void CreateTypes_26::operator()( const Packets_t& dataflows_27, const Packets_t& projects_29, Packets_t& dataflows_2b, Packets_t& projects_2c)
{
#ifdef PRINT_INFO
	printLog("CreateTypes_26" );
#endif
	_dataflow_2d= &dataflows_2b;
	_project_2e= &projects_2c;
	if( ( !dataflows_27.empty())&& ( !projects_29.empty()))
		callGetTypes_6a7( dataflows_27, projects_29);
	_dataflow_2d->insert( _dataflow_2d->end(), dataflows_27.begin(), dataflows_27.end());
	_project_2e->insert( _project_2e->end(), projects_29.begin(), projects_29.end());
}

void CreateTypes_26::callGetTypes_6a7( const Packets_t& states_30, const Packets_t& projects_32)
{
	Packets_t typess_34;
	Packets_t projects_35;
	GetTypes_2f getTypes_2f;
	getTypes_2f( states_30, projects_32, typess_34, projects_35);
	if( ( !typess_34.empty())&& ( !projects_35.empty()))
		callCreateTypesInner_6aa( typess_34, projects_35);
}

void CreateTypes_26::callCreateTypesInner_6aa( const Packets_t& typess_1b4, const Packets_t& projects_1b6)
{
	Packets_t typess_1b8;
	Packets_t newStructs_1b9;
	CreateTypesInner_1b3 createTypesInner_1b3;
	createTypesInner_1b3( typess_1b4, projects_1b6, typess_1b8, newStructs_1b9);
	if( ( !typess_1b8.empty())&& ( !newStructs_1b9.empty()))
		callStructMembers_6ad( typess_1b8, newStructs_1b9);
}

void CreateTypes_26::callStructMembers_6ad( const Packets_t& typess_184, const Packets_t& newStructs_186)
{
	Packets_t newStructs_188;
	StructMembers_183 structMembers_183;
	structMembers_183( typess_184, newStructs_186, newStructs_188);
	if( ( !newStructs_188.empty()))
		callRegisterStruct_6b0( newStructs_188);
}

void CreateTypes_26::callRegisterStruct_6b0( const Packets_t& sfcStructs_173)
{
	RegisterStruct_172 registerStruct_172;
	registerStruct_172( sfcStructs_173);
}

void GetTypes_2f::operator()( const Packets_t& states_30, const Packets_t& projects_32, Packets_t& typess_34, Packets_t& projects_35)
{
#ifdef PRINT_INFO
	printLog("GetTypes_2f" );
#endif
	_types_36= &typess_34;
	_project_37= &projects_35;
	if( ( !states_30.empty())&& ( !projects_32.empty()))
		callGetContainer_166( states_30, projects_32);
}

void GetTypes_2f::callGetContainer_166( const Packets_t& dataflows_ac, const Packets_t& projects_af)
{
	Packets_t designFolders_ae;
	Packets_t projects_b1;
	GetContainer_ab getContainer_ab;
	getContainer_ab( dataflows_ac, projects_af, designFolders_ae, projects_b1);
	if( ( !designFolders_ae.empty())&& ( !projects_b1.empty()))
		callFindTopContainer_169( designFolders_ae, projects_b1);
}

void GetTypes_2f::callFindTopContainer_169( const Packets_t& containers_ff, const Packets_t& projects_101)
{
	Packets_t containers_103;
	Packets_t projects_104;
	Packets_t containers_105;
	Packets_t projects_106;
	FindTopContainer_fe findTopContainer_fe;
	findTopContainer_fe( containers_ff, projects_101, containers_103, projects_104, containers_105, projects_106);
	if( ( !containers_103.empty())&& ( !projects_104.empty()))
		callGetTypes_16c( containers_103, projects_104);
	if( ( !containers_105.empty())&& ( !projects_106.empty()))
		callNextContainer_16f( containers_105, projects_106);
}

void GetTypes_2f::callGetTypes_16c( const Packets_t& containers_39, const Packets_t& projects_3b)
{
	Packets_t typess_3d;
	Packets_t projects_3e;
	GetTypes_38 getTypes_38;
	getTypes_38( containers_39, projects_3b, typess_3d, projects_3e);
	_types_36->insert( _types_36->end(), typess_3d.begin(), typess_3d.end());
	_project_37->insert( _project_37->end(), projects_3e.begin(), projects_3e.end());
}

void GetTypes_2f::callNextContainer_16f( const Packets_t& designFolders_d8, const Packets_t& projects_da)
{
	Packets_t designFolders_d7;
	Packets_t projects_dc;
	NextContainer_d6 nextContainer_d6;
	nextContainer_d6( designFolders_d8, projects_da, designFolders_d7, projects_dc);
	if( ( !designFolders_d7.empty())&& ( !projects_dc.empty()))
		callFindTopContainer_169( designFolders_d7, projects_dc);
}

void GetTypes_38::operator()( const Packets_t& containers_39, const Packets_t& projects_3b, Packets_t& typess_3d, Packets_t& projects_3e)
{
#ifdef PRINT_INFO
	printLog("GetTypes_38" );
#endif
	_types_3f= &typess_3d;
	_project_40= &projects_3e;
	if( ( !containers_39.empty())&& ( !projects_3b.empty()))
		callGetTypes_Lib_a5( containers_39, projects_3b);
	if( ( !containers_39.empty())&& ( !projects_3b.empty()))
		callGetTypes_NonLib_a8( containers_39, projects_3b);
}

void GetTypes_38::callGetTypes_Lib_a5( const Packets_t& designFolders_42, const Packets_t& projects_45)
{
	Packets_t typeBases_44;
	Packets_t projects_47;
	GetTypes_Lib_41 getTypes_Lib_41;
	getTypes_Lib_41( designFolders_42, projects_45, typeBases_44, projects_47);
	_types_3f->insert( _types_3f->end(), typeBases_44.begin(), typeBases_44.end());
	_project_40->insert( _project_40->end(), projects_47.begin(), projects_47.end());
}

void GetTypes_38::callGetTypes_NonLib_a8( const Packets_t& designFolders_76, const Packets_t& projects_79)
{
	Packets_t typeBases_78;
	Packets_t projects_7b;
	GetTypes_NonLib_75 getTypes_NonLib_75;
	getTypes_NonLib_75( designFolders_76, projects_79, typeBases_78, projects_7b);
	_types_3f->insert( _types_3f->end(), typeBases_78.begin(), typeBases_78.end());
	_project_40->insert( _project_40->end(), projects_7b.begin(), projects_7b.end());
}

void GetTypes_Lib_41::operator()( const Packets_t& designFolders_42, const Packets_t& projects_45, Packets_t& typeBases_44, Packets_t& projects_47)
{
#ifdef PRINT_INFO
	printLog("GetTypes_Lib_41" );
#endif
	RTTGenerator::Instance()->generateRule(25, "GetTypes_Lib");
	_typeBase_48= &typeBases_44;
	_project_49= &projects_47;
	processInputPackets( designFolders_42, projects_45);
}

bool GetTypes_Lib_41::isInputUnique( const Udm::Object& designFolder_4e, const Udm::Object& project_57)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itDesignFolder_50= _designFolder_4a.begin(), itProject_59= _project_53.begin(); itDesignFolder_50!= _designFolder_4a.end(), itProject_59!= _project_53.end(); ++itDesignFolder_50, ++itProject_59)
	{
		if( ( *itDesignFolder_50== designFolder_4e)&& ( *itProject_59== project_57))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_designFolder_4a.push_back( designFolder_4e);
		_project_53.push_back( project_57);
	}
	return isUnique;
}

bool GetTypes_Lib_41::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetTypes_Lib_41::processInputPackets( const Packets_t& designFolders_42, const Packets_t& projects_45)
{
	for( Packets_t::const_iterator itDesignFolder_4b= designFolders_42.begin(), itProject_54= projects_45.begin(); itDesignFolder_4b!= designFolders_42.end(), itProject_54!= projects_45.end(); ++itDesignFolder_4b, ++itProject_54)
	{
		bool isUnique= isInputUnique( *itDesignFolder_4b, *itProject_54);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itDesignFolder_4b, *itProject_54);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetTypes_Lib_41::patternMatcher( const Udm::Object& designFolder_4c, const Udm::Object& project_55)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( designFolder_4c.type(), CyPhyML::Components::meta))
			continue;
		CyPhyML::Components designFolder_51= CyPhyML::Components::Cast( designFolder_4c);
		if( false== Uml::IsDerivedFrom( project_55.type(), SFC::Project::meta))
			continue;
		SFC::Project project_5a= SFC::Project::Cast( project_55);
		Udm::Object designFolderParent_5c= designFolder_51.container();
		if( false== Uml::IsDerivedFrom( designFolderParent_5c.type(), CyPhyML::RootFolder::meta))
			continue;
		CyPhyML::RootFolder rootFolderDesignFolder_5d= CyPhyML::RootFolder::Cast( designFolderParent_5c);
		set< CyPhyML::RootFolder> rootFolders_5e= rootFolderDesignFolder_5d.RootFolder_kind_children();
		for( set< CyPhyML::RootFolder>::const_iterator itRootFolder_5f= rootFolders_5e.begin(); itRootFolder_5f!= rootFolders_5e.end(); ++itRootFolder_5f)
		{
			CyPhyML::RootFolder currRootFolder_60= *itRootFolder_5f;
			set< CyPhyML::SignalFlow::Types> typess_61= currRootFolder_60.SignalFlow_Types_kind_children();
			for( set< CyPhyML::SignalFlow::Types>::const_iterator itTypes_62= typess_61.begin(); itTypes_62!= typess_61.end(); ++itTypes_62)
			{
				CyPhyML::SignalFlow::Types currTypes_63= *itTypes_62;
				set< CyPhyML::SignalFlow::SF_TypeBase> typeBases_64= currTypes_63.SF_TypeBase_kind_children();
				for( set< CyPhyML::SignalFlow::SF_TypeBase>::const_iterator itTypeBase_65= typeBases_64.begin(); itTypeBase_65!= typeBases_64.end(); ++itTypeBase_65)
				{
					CyPhyML::SignalFlow::SF_TypeBase currTypeBase_66= *itTypeBase_65;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_6a;
					if( !isValidBound(boundObjs_6a, designFolder_51, true))
						continue;
					currMatch.designFolder_6b= designFolder_51;
					if( !isValidBound(boundObjs_6a, project_5a, true))
						continue;
					currMatch.project_6c= project_5a;
					if( !isValidBound(boundObjs_6a, rootFolderDesignFolder_5d, false))
						continue;
					currMatch.rootFolder_6d= rootFolderDesignFolder_5d;
					if( !isValidBound(boundObjs_6a, currRootFolder_60, false))
						continue;
					currMatch.rootFolder_6e= currRootFolder_60;
					if( !isValidBound(boundObjs_6a, currTypes_63, false))
						continue;
					currMatch.types_6f= currTypes_63;
					if( !isValidBound(boundObjs_6a, currTypeBase_66, false))
						continue;
					currMatch.typeBase_70= currTypeBase_66;
					_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void GetTypes_Lib_41::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.typeBase_70, currMatch.project_6c);
	}
}

void GetTypes_Lib_41::outputAppender( const CyPhyML::SignalFlow::SF_TypeBase& typeBase_71, const SFC::Project& project_73)
{
	_typeBase_48->push_back( typeBase_71);
	_project_49->push_back( project_73);
}

void GetTypes_NonLib_75::operator()( const Packets_t& designFolders_76, const Packets_t& projects_79, Packets_t& typeBases_78, Packets_t& projects_7b)
{
#ifdef PRINT_INFO
	printLog("GetTypes_NonLib_75" );
#endif
	RTTGenerator::Instance()->generateRule(36, "GetTypes_NonLib");
	_typeBase_7c= &typeBases_78;
	_project_7d= &projects_7b;
	processInputPackets( designFolders_76, projects_79);
}

bool GetTypes_NonLib_75::isInputUnique( const Udm::Object& designFolder_82, const Udm::Object& project_8b)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itDesignFolder_84= _designFolder_7e.begin(), itProject_8d= _project_87.begin(); itDesignFolder_84!= _designFolder_7e.end(), itProject_8d!= _project_87.end(); ++itDesignFolder_84, ++itProject_8d)
	{
		if( ( *itDesignFolder_84== designFolder_82)&& ( *itProject_8d== project_8b))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_designFolder_7e.push_back( designFolder_82);
		_project_87.push_back( project_8b);
	}
	return isUnique;
}

bool GetTypes_NonLib_75::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetTypes_NonLib_75::processInputPackets( const Packets_t& designFolders_76, const Packets_t& projects_79)
{
	for( Packets_t::const_iterator itDesignFolder_7f= designFolders_76.begin(), itProject_88= projects_79.begin(); itDesignFolder_7f!= designFolders_76.end(), itProject_88!= projects_79.end(); ++itDesignFolder_7f, ++itProject_88)
	{
		bool isUnique= isInputUnique( *itDesignFolder_7f, *itProject_88);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itDesignFolder_7f, *itProject_88);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetTypes_NonLib_75::patternMatcher( const Udm::Object& designFolder_80, const Udm::Object& project_89)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( designFolder_80.type(), CyPhyML::Components::meta))
			continue;
		CyPhyML::Components designFolder_85= CyPhyML::Components::Cast( designFolder_80);
		if( false== Uml::IsDerivedFrom( project_89.type(), SFC::Project::meta))
			continue;
		SFC::Project project_8e= SFC::Project::Cast( project_89);
		Udm::Object designFolderParent_90= designFolder_85.container();
		if( false== Uml::IsDerivedFrom( designFolderParent_90.type(), CyPhyML::RootFolder::meta))
			continue;
		CyPhyML::RootFolder rootFolderDesignFolder_91= CyPhyML::RootFolder::Cast( designFolderParent_90);
		set< CyPhyML::SignalFlow::Types> typess_92= rootFolderDesignFolder_91.SignalFlow_Types_kind_children();
		for( set< CyPhyML::SignalFlow::Types>::const_iterator itTypes_93= typess_92.begin(); itTypes_93!= typess_92.end(); ++itTypes_93)
		{
			CyPhyML::SignalFlow::Types currTypes_94= *itTypes_93;
			set< CyPhyML::SignalFlow::SF_TypeBase> typeBases_95= currTypes_94.SF_TypeBase_kind_children();
			for( set< CyPhyML::SignalFlow::SF_TypeBase>::const_iterator itTypeBase_96= typeBases_95.begin(); itTypeBase_96!= typeBases_95.end(); ++itTypeBase_96)
			{
				CyPhyML::SignalFlow::SF_TypeBase currTypeBase_97= *itTypeBase_96;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_9b;
				if( !isValidBound(boundObjs_9b, designFolder_85, true))
					continue;
				currMatch.designFolder_9c= designFolder_85;
				if( !isValidBound(boundObjs_9b, project_8e, true))
					continue;
				currMatch.project_9d= project_8e;
				if( !isValidBound(boundObjs_9b, rootFolderDesignFolder_91, false))
					continue;
				currMatch.rootFolder_9e= rootFolderDesignFolder_91;
				if( !isValidBound(boundObjs_9b, currTypes_94, false))
					continue;
				currMatch.types_9f= currTypes_94;
				if( !isValidBound(boundObjs_9b, currTypeBase_97, false))
					continue;
				currMatch.typeBase_a0= currTypeBase_97;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetTypes_NonLib_75::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.typeBase_a0, currMatch.project_9d);
	}
}

void GetTypes_NonLib_75::outputAppender( const CyPhyML::SignalFlow::SF_TypeBase& typeBase_a1, const SFC::Project& project_a3)
{
	_typeBase_7c->push_back( typeBase_a1);
	_project_7d->push_back( project_a3);
}

void GetContainer_ab::operator()( const Packets_t& dataflows_ac, const Packets_t& projects_af, Packets_t& designFolders_ae, Packets_t& projects_b1)
{
#ifdef PRINT_INFO
	printLog("GetContainer_ab" );
#endif
	RTTGenerator::Instance()->generateRule(45, "GetContainer");
	_designFolder_b2= &designFolders_ae;
	_project_b3= &projects_b1;
	processInputPackets( dataflows_ac, projects_af);
}

bool GetContainer_ab::isInputUnique( const Udm::Object& dataflow_b8, const Udm::Object& project_c1)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itDataflow_ba= _dataflow_b4.begin(), itProject_c3= _project_bd.begin(); itDataflow_ba!= _dataflow_b4.end(), itProject_c3!= _project_bd.end(); ++itDataflow_ba, ++itProject_c3)
	{
		if( ( *itDataflow_ba== dataflow_b8)&& ( *itProject_c3== project_c1))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_dataflow_b4.push_back( dataflow_b8);
		_project_bd.push_back( project_c1);
	}
	return isUnique;
}

bool GetContainer_ab::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetContainer_ab::processInputPackets( const Packets_t& dataflows_ac, const Packets_t& projects_af)
{
	for( Packets_t::const_iterator itDataflow_b5= dataflows_ac.begin(), itProject_be= projects_af.begin(); itDataflow_b5!= dataflows_ac.end(), itProject_be!= projects_af.end(); ++itDataflow_b5, ++itProject_be)
	{
		bool isUnique= isInputUnique( *itDataflow_b5, *itProject_be);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itDataflow_b5, *itProject_be);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetContainer_ab::patternMatcher( const Udm::Object& dataflow_b6, const Udm::Object& project_bf)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( dataflow_b6.type(), CyPhyML::SignalFlowModel::meta))
			continue;
		CyPhyML::SignalFlowModel dataflow_bb= CyPhyML::SignalFlowModel::Cast( dataflow_b6);
		if( false== Uml::IsDerivedFrom( project_bf.type(), SFC::Project::meta))
			continue;
		SFC::Project project_c4= SFC::Project::Cast( project_bf);
		Udm::Object dataflowParent_c6= dataflow_bb.container();
		if( false== Uml::IsDerivedFrom( dataflowParent_c6.type(), CyPhyML::Component::meta))
			continue;
		CyPhyML::Component modelsFolderDataflow_c7= CyPhyML::Component::Cast( dataflowParent_c6);
		Udm::Object modelsFolderParent_c8= modelsFolderDataflow_c7.container();
		if( false== Uml::IsDerivedFrom( modelsFolderParent_c8.type(), CyPhyML::Components::meta))
			continue;
		CyPhyML::Components designFolderModelsFolder_c9= CyPhyML::Components::Cast( modelsFolderParent_c8);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_cd;
		if( !isValidBound(boundObjs_cd, dataflow_bb, true))
			continue;
		currMatch.dataflow_ce= dataflow_bb;
		if( !isValidBound(boundObjs_cd, project_c4, true))
			continue;
		currMatch.project_cf= project_c4;
		if( !isValidBound(boundObjs_cd, modelsFolderDataflow_c7, false))
			continue;
		currMatch.modelsFolder_d0= modelsFolderDataflow_c7;
		if( !isValidBound(boundObjs_cd, designFolderModelsFolder_c9, false))
			continue;
		currMatch.designFolder_d1= designFolderModelsFolder_c9;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void GetContainer_ab::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.designFolder_d1, currMatch.project_cf);
	}
}

void GetContainer_ab::outputAppender( const CyPhyML::Components& designFolder_d2, const SFC::Project& project_d4)
{
	_designFolder_b2->push_back( designFolder_d2);
	_project_b3->push_back( project_d4);
}

void NextContainer_d6::operator()( const Packets_t& designFolders_d8, const Packets_t& projects_da, Packets_t& designFolders_d7, Packets_t& projects_dc)
{
#ifdef PRINT_INFO
	printLog("NextContainer_d6" );
#endif
	RTTGenerator::Instance()->generateRule(52, "NextContainer");
	_designFolder_dd= &designFolders_d7;
	_project_de= &projects_dc;
	processInputPackets( designFolders_d8, projects_da);
}

bool NextContainer_d6::isInputUnique( const Udm::Object& designFolder_e3, const Udm::Object& project_ec)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itDesignFolder_e5= _designFolder_df.begin(), itProject_ee= _project_e8.begin(); itDesignFolder_e5!= _designFolder_df.end(), itProject_ee!= _project_e8.end(); ++itDesignFolder_e5, ++itProject_ee)
	{
		if( ( *itDesignFolder_e5== designFolder_e3)&& ( *itProject_ee== project_ec))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_designFolder_df.push_back( designFolder_e3);
		_project_e8.push_back( project_ec);
	}
	return isUnique;
}

bool NextContainer_d6::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void NextContainer_d6::processInputPackets( const Packets_t& designFolders_d8, const Packets_t& projects_da)
{
	for( Packets_t::const_iterator itDesignFolder_e0= designFolders_d8.begin(), itProject_e9= projects_da.begin(); itDesignFolder_e0!= designFolders_d8.end(), itProject_e9!= projects_da.end(); ++itDesignFolder_e0, ++itProject_e9)
	{
		bool isUnique= isInputUnique( *itDesignFolder_e0, *itProject_e9);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itDesignFolder_e0, *itProject_e9);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool NextContainer_d6::patternMatcher( const Udm::Object& designFolder_e1, const Udm::Object& project_ea)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( designFolder_e1.type(), CyPhyML::Components::meta))
			continue;
		CyPhyML::Components designFolder_e6= CyPhyML::Components::Cast( designFolder_e1);
		if( false== Uml::IsDerivedFrom( project_ea.type(), SFC::Project::meta))
			continue;
		SFC::Project project_ef= SFC::Project::Cast( project_ea);
		Udm::Object designFolderParent_f1= designFolder_e6.container();
		if( false== Uml::IsDerivedFrom( designFolderParent_f1.type(), CyPhyML::Components::meta))
			continue;
		CyPhyML::Components designFolderDesignFolder_f2= CyPhyML::Components::Cast( designFolderParent_f1);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_f6;
		if( !isValidBound(boundObjs_f6, designFolder_e6, true))
			continue;
		currMatch.designFolder_f7= designFolder_e6;
		if( !isValidBound(boundObjs_f6, project_ef, true))
			continue;
		currMatch.project_f8= project_ef;
		if( !isValidBound(boundObjs_f6, designFolderDesignFolder_f2, false))
			continue;
		currMatch.designFolder_f9= designFolderDesignFolder_f2;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void NextContainer_d6::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.designFolder_f9, currMatch.project_f8);
	}
}

void NextContainer_d6::outputAppender( const CyPhyML::Components& designFolder_fa, const SFC::Project& project_fc)
{
	_designFolder_dd->push_back( designFolder_fa);
	_project_de->push_back( project_fc);
}

void FindTopContainer_fe::operator()( const Packets_t& containers_ff, const Packets_t& projects_101, Packets_t& containers_103, Packets_t& projects_104, Packets_t& containers_105, Packets_t& projects_106)
{
#ifdef PRINT_INFO
	printLog("FindTopContainer_fe" );
#endif
	_container_107= &containers_103;
	_project_108= &projects_104;
	_container_109= &containers_105;
	_project_10a= &projects_106;
	for( Packets_t::const_iterator itcontainer_10c= containers_ff.begin(), itproject_113= projects_101.begin(); itcontainer_10c!= containers_ff.end(), itproject_113!= projects_101.end(); ++itcontainer_10c, ++itproject_113)
	{
		bool isUnique= isInputUnique( *itcontainer_10c, *itproject_113);
		if( !isUnique)
			continue;
		Packets_t onecontainer_110( 1, *itcontainer_10c);
		Packets_t oneproject_117( 1, *itproject_113);
		executeOne( onecontainer_110, oneproject_117);
	}
}

void FindTopContainer_fe::executeOne( const Packets_t& containers_ff, const Packets_t& projects_101)
{
	Packets_t designFolders_11c;
	Packets_t projects_11f;
	ChildOfComponent_119 childOfComponent_119;
	bool isMatchChildOfComponent_119= childOfComponent_119( containers_ff, projects_101, designFolders_11c, projects_11f);
	_container_107->insert( _container_107->end(), designFolders_11c.begin(), designFolders_11c.end());
	_project_108->insert( _project_108->end(), projects_11f.begin(), projects_11f.end());
	if( isMatchChildOfComponent_119)
		return;
	Packets_t designFolders_144;
	Packets_t projects_147;
	Otherwise_141 otherwise_141;
	bool isMatchOtherwise_141= otherwise_141( containers_ff, projects_101, designFolders_144, projects_147);
	_container_109->insert( _container_109->end(), designFolders_144.begin(), designFolders_144.end());
	_project_10a->insert( _project_10a->end(), projects_147.begin(), projects_147.end());
	if( isMatchOtherwise_141)
		return;
}

bool FindTopContainer_fe::isInputUnique( const Udm::Object& container_10d, const Udm::Object& project_114)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itcontainer_10f= _container_10b.begin(), itproject_116= _project_112.begin(); itcontainer_10f!= _container_10b.end(), itproject_116!= _project_112.end(); ++itcontainer_10f, ++itproject_116)
	{
		if( ( *itcontainer_10f== container_10d)&& ( *itproject_116== project_114))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_container_10b.push_back( container_10d);
		_project_112.push_back( project_114);
	}
	return isUnique;
}

bool ChildOfComponent_119::operator()( const Packets_t& designFolders_11a, const Packets_t& projects_11d, Packets_t& designFolders_11c, Packets_t& projects_11f)
{
#ifdef PRINT_INFO
	printLog("ChildOfComponent_119" );
#endif
	_designFolder_120= &designFolders_11c;
	_project_121= &projects_11f;
	processInputPackets( designFolders_11a, projects_11d);
	if( false== _matches.empty())
		return true;
	return false;
}

bool ChildOfComponent_119::isInputUnique( const Udm::Object& designFolder_126, const Udm::Object& project_12f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itDesignFolder_128= _designFolder_122.begin(), itProject_131= _project_12b.begin(); itDesignFolder_128!= _designFolder_122.end(), itProject_131!= _project_12b.end(); ++itDesignFolder_128, ++itProject_131)
	{
		if( ( *itDesignFolder_128== designFolder_126)&& ( *itProject_131== project_12f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_designFolder_122.push_back( designFolder_126);
		_project_12b.push_back( project_12f);
	}
	return isUnique;
}

bool ChildOfComponent_119::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void ChildOfComponent_119::processInputPackets( const Packets_t& designFolders_11a, const Packets_t& projects_11d)
{
	for( Packets_t::const_iterator itDesignFolder_123= designFolders_11a.begin(), itProject_12c= projects_11d.begin(); itDesignFolder_123!= designFolders_11a.end(), itProject_12c!= projects_11d.end(); ++itDesignFolder_123, ++itProject_12c)
	{
		bool isUnique= isInputUnique( *itDesignFolder_123, *itProject_12c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itDesignFolder_123, *itProject_12c);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.designFolder_13a, currMatch.project_13b);
	}
}

bool ChildOfComponent_119::patternMatcher( const Udm::Object& designFolder_124, const Udm::Object& project_12d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( designFolder_124.type(), CyPhyML::Components::meta))
			continue;
		CyPhyML::Components designFolder_129= CyPhyML::Components::Cast( designFolder_124);
		if( false== Uml::IsDerivedFrom( project_12d.type(), SFC::Project::meta))
			continue;
		SFC::Project project_132= SFC::Project::Cast( project_12d);
		Udm::Object designFolderParent_134= designFolder_129.container();
		if( false== Uml::IsDerivedFrom( designFolderParent_134.type(), CyPhyML::RootFolder::meta))
			continue;
		CyPhyML::RootFolder rootFolderDesignFolder_135= CyPhyML::RootFolder::Cast( designFolderParent_134);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_139;
		if( !isValidBound(boundObjs_139, designFolder_129, true))
			continue;
		currMatch.designFolder_13a= designFolder_129;
		if( !isValidBound(boundObjs_139, project_132, true))
			continue;
		currMatch.project_13b= project_132;
		if( !isValidBound(boundObjs_139, rootFolderDesignFolder_135, false))
			continue;
		currMatch.rootFolder_13c= rootFolderDesignFolder_135;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void ChildOfComponent_119::outputAppender( const CyPhyML::Components& designFolder_13d, const SFC::Project& project_13f)
{
	_designFolder_120->push_back( designFolder_13d);
	_project_121->push_back( project_13f);
}

bool Otherwise_141::operator()( const Packets_t& designFolders_142, const Packets_t& projects_145, Packets_t& designFolders_144, Packets_t& projects_147)
{
#ifdef PRINT_INFO
	printLog("Otherwise_141" );
#endif
	_designFolder_148= &designFolders_144;
	_project_149= &projects_147;
	processInputPackets( designFolders_142, projects_145);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_141::isInputUnique( const Udm::Object& designFolder_14e, const Udm::Object& project_157)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itDesignFolder_150= _designFolder_14a.begin(), itProject_159= _project_153.begin(); itDesignFolder_150!= _designFolder_14a.end(), itProject_159!= _project_153.end(); ++itDesignFolder_150, ++itProject_159)
	{
		if( ( *itDesignFolder_150== designFolder_14e)&& ( *itProject_159== project_157))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_designFolder_14a.push_back( designFolder_14e);
		_project_153.push_back( project_157);
	}
	return isUnique;
}

bool Otherwise_141::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_141::processInputPackets( const Packets_t& designFolders_142, const Packets_t& projects_145)
{
	for( Packets_t::const_iterator itDesignFolder_14b= designFolders_142.begin(), itProject_154= projects_145.begin(); itDesignFolder_14b!= designFolders_142.end(), itProject_154!= projects_145.end(); ++itDesignFolder_14b, ++itProject_154)
	{
		bool isUnique= isInputUnique( *itDesignFolder_14b, *itProject_154);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itDesignFolder_14b, *itProject_154);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.designFolder_160, currMatch.project_161);
	}
}

bool Otherwise_141::patternMatcher( const Udm::Object& designFolder_14c, const Udm::Object& project_155)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( designFolder_14c.type(), CyPhyML::Components::meta))
			continue;
		CyPhyML::Components designFolder_151= CyPhyML::Components::Cast( designFolder_14c);
		if( false== Uml::IsDerivedFrom( project_155.type(), SFC::Project::meta))
			continue;
		SFC::Project project_15a= SFC::Project::Cast( project_155);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_15f;
		if( !isValidBound(boundObjs_15f, designFolder_151, true))
			continue;
		currMatch.designFolder_160= designFolder_151;
		if( !isValidBound(boundObjs_15f, project_15a, true))
			continue;
		currMatch.project_161= project_15a;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_141::outputAppender( const CyPhyML::Components& designFolder_162, const SFC::Project& project_164)
{
	_designFolder_148->push_back( designFolder_162);
	_project_149->push_back( project_164);
}

void RegisterStruct_172::operator()( const Packets_t& sfcStructs_173)
{
#ifdef PRINT_INFO
	printLog("RegisterStruct_172" );
#endif
	RTTGenerator::Instance()->generateRule(72, "RegisterStruct");
	processInputPackets( sfcStructs_173);
}

bool RegisterStruct_172::isInputUnique( const Udm::Object& sfcStruct_179)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itsfcStruct_17b= _sfcStruct_175.begin(); itsfcStruct_17b!= _sfcStruct_175.end(); ++itsfcStruct_17b)
	{
		if( ( *itsfcStruct_17b== sfcStruct_179))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_sfcStruct_175.push_back( sfcStruct_179);
	return isUnique;
}

bool RegisterStruct_172::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void RegisterStruct_172::processInputPackets( const Packets_t& sfcStructs_173)
{
	for( Packets_t::const_iterator itsfcStruct_176= sfcStructs_173.begin(); itsfcStruct_176!= sfcStructs_173.end(); ++itsfcStruct_176)
	{
		bool isUnique= isInputUnique( *itsfcStruct_176);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itsfcStruct_176);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool RegisterStruct_172::patternMatcher( const Udm::Object& sfcStruct_177)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( sfcStruct_177.type(), SFC::Struct::meta))
			continue;
		SFC::Struct sfcStruct_17c= SFC::Struct::Cast( sfcStruct_177);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_181;
		if( !isValidBound(boundObjs_181, sfcStruct_17c, true))
			continue;
		currMatch.sfcStruct_182= sfcStruct_17c;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void RegisterStruct_172::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Struct& sfcStruct= currMatch.sfcStruct_182;
		{
SFCTypesManager::getSingleton().makeTypeUnique( sfcStruct );
};
	}
}

void StructMembers_183::operator()( const Packets_t& typess_184, const Packets_t& newStructs_186, Packets_t& newStructs_188)
{
#ifdef PRINT_INFO
	printLog("StructMembers_183" );
#endif
	_newStruct_189= &newStructs_188;
	_newStruct_189->insert( _newStruct_189->end(), newStructs_186.begin(), newStructs_186.end());
	if( ( !typess_184.empty())&& ( !newStructs_186.empty()))
		callCreateStructMembers_1b0( typess_184, newStructs_186);
}

void StructMembers_183::callCreateStructMembers_1b0( const Packets_t& eSMoL_Structs_18b, const Packets_t& sfc_Structs_18d)
{
	CreateStructMembers_18a createStructMembers_18a;
	createStructMembers_18a( eSMoL_Structs_18b, sfc_Structs_18d);
}

void CreateStructMembers_18a::operator()( const Packets_t& eSMoL_Structs_18b, const Packets_t& sfc_Structs_18d)
{
#ifdef PRINT_INFO
	printLog("CreateStructMembers_18a" );
#endif
	RTTGenerator::Instance()->generateRule(79, "CreateStructMembers");
	processInputPackets( eSMoL_Structs_18b, sfc_Structs_18d);
}

bool CreateStructMembers_18a::isInputUnique( const Udm::Object& eSMoL_Struct_193, const Udm::Object& sfc_Struct_19c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itESMoL_Struct_195= _eSMoL_Struct_18f.begin(), itsfc_Struct_19e= _sfc_Struct_198.begin(); itESMoL_Struct_195!= _eSMoL_Struct_18f.end(), itsfc_Struct_19e!= _sfc_Struct_198.end(); ++itESMoL_Struct_195, ++itsfc_Struct_19e)
	{
		if( ( *itESMoL_Struct_195== eSMoL_Struct_193)&& ( *itsfc_Struct_19e== sfc_Struct_19c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_eSMoL_Struct_18f.push_back( eSMoL_Struct_193);
		_sfc_Struct_198.push_back( sfc_Struct_19c);
	}
	return isUnique;
}

bool CreateStructMembers_18a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateStructMembers_18a::processInputPackets( const Packets_t& eSMoL_Structs_18b, const Packets_t& sfc_Structs_18d)
{
	for( Packets_t::const_iterator itESMoL_Struct_190= eSMoL_Structs_18b.begin(), itsfc_Struct_199= sfc_Structs_18d.begin(); itESMoL_Struct_190!= eSMoL_Structs_18b.end(), itsfc_Struct_199!= sfc_Structs_18d.end(); ++itESMoL_Struct_190, ++itsfc_Struct_199)
	{
		bool isUnique= isInputUnique( *itESMoL_Struct_190, *itsfc_Struct_199);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itESMoL_Struct_190, *itsfc_Struct_199);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateStructMembers_18a::patternMatcher( const Udm::Object& eSMoL_Struct_191, const Udm::Object& sfc_Struct_19a)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( eSMoL_Struct_191.type(), CyPhyML::SignalFlow::TypeStruct::meta))
			continue;
		CyPhyML::SignalFlow::TypeStruct eSMoL_Struct_196= CyPhyML::SignalFlow::TypeStruct::Cast( eSMoL_Struct_191);
		if( false== Uml::IsDerivedFrom( sfc_Struct_19a.type(), SFC::Struct::meta))
			continue;
		SFC::Struct sfc_Struct_19f= SFC::Struct::Cast( sfc_Struct_19a);
		set< CyPhyML::SignalFlow::TypeBaseRef> eSMoL_StructRefs_1a1= eSMoL_Struct_196.TypeBaseRef_kind_children();
		for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itESMoL_StructRef_1a2= eSMoL_StructRefs_1a1.begin(); itESMoL_StructRef_1a2!= eSMoL_StructRefs_1a1.end(); ++itESMoL_StructRef_1a2)
		{
			CyPhyML::SignalFlow::TypeBaseRef currESMoL_StructRef_1a3= *itESMoL_StructRef_1a2;
			CyPhyML::SignalFlow::SF_TypeBase eSMoL_TypeBase_1a4= currESMoL_StructRef_1a3.ref();
			if( !eSMoL_TypeBase_1a4)
				continue;
			SFC::DT sfc_DT_1a5= eSMoL_TypeBase_1a4.dt();
			if( !sfc_DT_1a5)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1a9;
			if( !isValidBound(boundObjs_1a9, eSMoL_Struct_196, true))
				continue;
			currMatch.eSMoL_Struct_1aa= eSMoL_Struct_196;
			if( !isValidBound(boundObjs_1a9, sfc_Struct_19f, true))
				continue;
			currMatch.sfc_Struct_1ab= sfc_Struct_19f;
			if( !isValidBound(boundObjs_1a9, currESMoL_StructRef_1a3, false))
				continue;
			currMatch.eSMoL_StructRef_1ac= currESMoL_StructRef_1a3;
			if( !isValidBound(boundObjs_1a9, eSMoL_TypeBase_1a4, false))
				continue;
			currMatch.eSMoL_TypeBase_1ad= eSMoL_TypeBase_1a4;
			if( !isValidBound(boundObjs_1a9, sfc_DT_1a5, false))
				continue;
			currMatch.sfc_DT_1ae= sfc_DT_1a5;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateStructMembers_18a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar newStructLocalVar_1af= SFC::LocalVar::Create( currMatch.sfc_Struct_1ab, SFC::Struct::meta_memb);
		CyPhyML::SignalFlow::TypeStruct& ESMoL_Struct= currMatch.eSMoL_Struct_1aa;
		CyPhyML::SignalFlow::TypeBaseRef& ESMoL_StructRef= currMatch.eSMoL_StructRef_1ac;
		CyPhyML::SignalFlow::SF_TypeBase& ESMoL_TypeBase= currMatch.eSMoL_TypeBase_1ad;
		SFC::LocalVar& StructLocalVar= newStructLocalVar_1af;
		SFC::DT& sfc_DT= currMatch.sfc_DT_1ae;
		SFC::Struct& sfc_Struct= currMatch.sfc_Struct_1ab;
		{
StructLocalVar.name() = ESMoL_StructRef.name();
StructLocalVar.statementIndex() = ESMoL_StructRef.MemberIndex();
};
		newStructLocalVar_1af.dt()= currMatch.sfc_DT_1ae;
		newStructLocalVar_1af.tbr()= currMatch.eSMoL_StructRef_1ac;
	}
}

void CreateTypesInner_1b3::operator()( const Packets_t& typess_1b4, const Packets_t& projects_1b6, Packets_t& typess_1b8, Packets_t& newStructs_1b9)
{
#ifdef PRINT_INFO
	printLog("CreateTypesInner_1b3" );
#endif
	_types_1ba= &typess_1b8;
	_newStruct_1bb= &newStructs_1b9;
	for( Packets_t::const_iterator ittypes_1bd= typess_1b4.begin(), itproject_1c4= projects_1b6.begin(); ittypes_1bd!= typess_1b4.end(), itproject_1c4!= projects_1b6.end(); ++ittypes_1bd, ++itproject_1c4)
	{
		bool isUnique= isInputUnique( *ittypes_1bd, *itproject_1c4);
		if( !isUnique)
			continue;
		Packets_t onetypes_1c1( 1, *ittypes_1bd);
		Packets_t oneproject_1c8( 1, *itproject_1c4);
		executeOne( onetypes_1c1, oneproject_1c8);
	}
}

void CreateTypesInner_1b3::executeOne( const Packets_t& typess_1b4, const Packets_t& projects_1b6)
{
	if( ( !typess_1b4.empty())&& ( !projects_1b6.empty()))
		callStructOrMatrix_69e( typess_1b4, projects_1b6);
}

bool CreateTypesInner_1b3::isInputUnique( const Udm::Object& types_1be, const Udm::Object& project_1c5)
{
	bool isUnique= true;
	for( Packets_t::const_iterator ittypes_1c0= _types_1bc.begin(), itproject_1c7= _project_1c3.begin(); ittypes_1c0!= _types_1bc.end(), itproject_1c7!= _project_1c3.end(); ++ittypes_1c0, ++itproject_1c7)
	{
		if( ( *ittypes_1c0== types_1be)&& ( *itproject_1c7== project_1c5))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_types_1bc.push_back( types_1be);
		_project_1c3.push_back( project_1c5);
	}
	return isUnique;
}

void CreateTypesInner_1b3::callStructOrMatrix_69e( const Packets_t& typess_614, const Packets_t& projects_616)
{
	Packets_t typess_618;
	Packets_t projects_619;
	Packets_t typess_61a;
	Packets_t projects_61b;
	StructOrMatrix_613 structOrMatrix_613;
	structOrMatrix_613( typess_614, projects_616, typess_618, projects_619, typess_61a, projects_61b);
	if( ( !typess_618.empty())&& ( !projects_619.empty()))
		callCreateStructType_6a1( typess_618, projects_619);
	if( ( !typess_61a.empty())&& ( !projects_61b.empty()))
		callCreateArrayOrBasicType_6a4( typess_61a, projects_61b);
}

void CreateTypesInner_1b3::callCreateStructType_6a1( const Packets_t& eSMoL_Structs_679, const Packets_t& projects_67d)
{
	Packets_t eSMoL_Structs_67b;
	Packets_t sfc_Structs_67c;
	CreateStructType_678 createStructType_678;
	createStructType_678( eSMoL_Structs_679, projects_67d, eSMoL_Structs_67b, sfc_Structs_67c);
	_types_1ba->insert( _types_1ba->end(), eSMoL_Structs_67b.begin(), eSMoL_Structs_67b.end());
	_newStruct_1bb->insert( _newStruct_1bb->end(), sfc_Structs_67c.begin(), sfc_Structs_67c.end());
}

void CreateTypesInner_1b3::callCreateArrayOrBasicType_6a4( const Packets_t& typess_1cb, const Packets_t& projects_1cd)
{
	CreateArrayOrBasicType_1ca createArrayOrBasicType_1ca;
	createArrayOrBasicType_1ca( typess_1cb, projects_1cd);
}

void CreateArrayOrBasicType_1ca::operator()( const Packets_t& typess_1cb, const Packets_t& projects_1cd)
{
#ifdef PRINT_INFO
	printLog("CreateArrayOrBasicType_1ca" );
#endif
	if( ( !typess_1cb.empty())&& ( !projects_1cd.empty()))
		callDimensionTest_601( typess_1cb, projects_1cd);
}

void CreateArrayOrBasicType_1ca::callDimensionTest_601( const Packets_t& typess_570, const Packets_t& projects_572)
{
	Packets_t typess_574;
	Packets_t projects_575;
	Packets_t typess_576;
	Packets_t projects_577;
	Packets_t typess_578;
	Packets_t projects_579;
	DimensionTest_56f dimensionTest_56f;
	dimensionTest_56f( typess_570, projects_572, typess_574, projects_575, typess_576, projects_577, typess_578, projects_579);
	if( ( !typess_578.empty())&& ( !projects_579.empty()))
		callProcessOther_604( typess_578, projects_579);
	if( ( !typess_576.empty())&& ( !projects_577.empty()))
		callProcessColumn_607( typess_576, projects_577);
	if( ( !typess_574.empty())&& ( !projects_575.empty()))
		callProcessScalar_60a( typess_574, projects_575);
}

void CreateArrayOrBasicType_1ca::callProcessOther_604( const Packets_t& typess_20e, const Packets_t& projects_210)
{
	Packets_t typess_212;
	Packets_t array1s_213;
	Packets_t projects_214;
	ProcessOther_20d processOther_20d;
	processOther_20d( typess_20e, projects_210, typess_212, array1s_213, projects_214);
	if( ( !typess_212.empty())&& ( !array1s_213.empty()))
		callRegisterType_60d( typess_212, array1s_213);
}

void CreateArrayOrBasicType_1ca::callProcessColumn_607( const Packets_t& typess_55e, const Packets_t& projects_560)
{
	Packets_t typess_562;
	Packets_t array1s_563;
	Packets_t projects_564;
	ProcessColumn_55d processColumn_55d;
	processColumn_55d( typess_55e, projects_560, typess_562, array1s_563, projects_564);
	if( ( !typess_562.empty())&& ( !array1s_563.empty()))
		callRegisterType_60d( typess_562, array1s_563);
}

void CreateArrayOrBasicType_1ca::callProcessScalar_60a( const Packets_t& typess_34e, const Packets_t& projects_350)
{
	Packets_t typess_352;
	Packets_t basictypes_353;
	Packets_t projects_354;
	ProcessScalar_34d processScalar_34d;
	processScalar_34d( typess_34e, projects_350, typess_352, basictypes_353, projects_354);
	if( ( !typess_352.empty())&& ( !basictypes_353.empty()))
		callRegisterType_60d( typess_352, basictypes_353);
}

void CreateArrayOrBasicType_1ca::callRegisterType_60d( const Packets_t& matrixs_1d0, const Packets_t& dTs_1d3)
{
	Packets_t matrixs_1d2;
	Packets_t dTs_1d5;
	RegisterType_1cf registerType_1cf;
	registerType_1cf( matrixs_1d0, dTs_1d3, matrixs_1d2, dTs_1d5);
	if( ( !matrixs_1d2.empty())&& ( !dTs_1d5.empty()))
		callMakeAssoc_610( matrixs_1d2, dTs_1d5);
}

void CreateArrayOrBasicType_1ca::callMakeAssoc_610( const Packets_t& matrixs_1f1, const Packets_t& dTs_1f3)
{
	MakeAssoc_1f0 makeAssoc_1f0;
	makeAssoc_1f0( matrixs_1f1, dTs_1f3);
}

void RegisterType_1cf::operator()( const Packets_t& matrixs_1d0, const Packets_t& dTs_1d3, Packets_t& matrixs_1d2, Packets_t& dTs_1d5)
{
#ifdef PRINT_INFO
	printLog("RegisterType_1cf" );
#endif
	RTTGenerator::Instance()->generateRule(101, "RegisterType");
	_matrix_1d6= &matrixs_1d2;
	_dT_1d7= &dTs_1d5;
	processInputPackets( matrixs_1d0, dTs_1d3);
	forwardInputs( );
}

bool RegisterType_1cf::isInputUnique( const Udm::Object& matrix_1dc, const Udm::Object& dT_1e5)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_1de= _matrix_1d8.begin(), itDT_1e7= _dT_1e1.begin(); itMatrix_1de!= _matrix_1d8.end(), itDT_1e7!= _dT_1e1.end(); ++itMatrix_1de, ++itDT_1e7)
	{
		if( ( *itMatrix_1de== matrix_1dc)&& ( *itDT_1e7== dT_1e5))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_1d8.push_back( matrix_1dc);
		_dT_1e1.push_back( dT_1e5);
	}
	return isUnique;
}

bool RegisterType_1cf::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void RegisterType_1cf::processInputPackets( const Packets_t& matrixs_1d0, const Packets_t& dTs_1d3)
{
	for( Packets_t::const_iterator itMatrix_1d9= matrixs_1d0.begin(), itDT_1e2= dTs_1d3.begin(); itMatrix_1d9!= matrixs_1d0.end(), itDT_1e2!= dTs_1d3.end(); ++itMatrix_1d9, ++itDT_1e2)
	{
		bool isUnique= isInputUnique( *itMatrix_1d9, *itDT_1e2);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_1d9, *itDT_1e2);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool RegisterType_1cf::patternMatcher( const Udm::Object& matrix_1da, const Udm::Object& dT_1e3)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_1da.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_1df= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_1da);
		if( false== Uml::IsDerivedFrom( dT_1e3.type(), SFC::DT::meta))
			continue;
		SFC::DT dT_1e8= SFC::DT::Cast( dT_1e3);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1ed;
		if( !isValidBound(boundObjs_1ed, matrix_1df, true))
			continue;
		currMatch.matrix_1ee= matrix_1df;
		if( !isValidBound(boundObjs_1ed, dT_1e8, true))
			continue;
		currMatch.dT_1ef= dT_1e8;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void RegisterType_1cf::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::DT& DT= currMatch.dT_1ef;
		CyPhyML::SignalFlow::SF_Matrix& Matrix= currMatch.matrix_1ee;
		{
SFCTypesManager::getSingleton().makeTypeUnique( DT );
};
	}
}

void RegisterType_1cf::forwardInputs()
{
	*_matrix_1d6= _matrix_1d8;
	*_dT_1d7= _dT_1e1;
}

void MakeAssoc_1f0::operator()( const Packets_t& matrixs_1f1, const Packets_t& dTs_1f3)
{
#ifdef PRINT_INFO
	printLog("MakeAssoc_1f0" );
#endif
	RTTGenerator::Instance()->generateRule(105, "MakeAssoc");
	processInputPackets( matrixs_1f1, dTs_1f3);
}

bool MakeAssoc_1f0::isInputUnique( const Udm::Object& matrix_1f9, const Udm::Object& dT_202)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_1fb= _matrix_1f5.begin(), itDT_204= _dT_1fe.begin(); itMatrix_1fb!= _matrix_1f5.end(), itDT_204!= _dT_1fe.end(); ++itMatrix_1fb, ++itDT_204)
	{
		if( ( *itMatrix_1fb== matrix_1f9)&& ( *itDT_204== dT_202))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_1f5.push_back( matrix_1f9);
		_dT_1fe.push_back( dT_202);
	}
	return isUnique;
}

bool MakeAssoc_1f0::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void MakeAssoc_1f0::processInputPackets( const Packets_t& matrixs_1f1, const Packets_t& dTs_1f3)
{
	for( Packets_t::const_iterator itMatrix_1f6= matrixs_1f1.begin(), itDT_1ff= dTs_1f3.begin(); itMatrix_1f6!= matrixs_1f1.end(), itDT_1ff!= dTs_1f3.end(); ++itMatrix_1f6, ++itDT_1ff)
	{
		bool isUnique= isInputUnique( *itMatrix_1f6, *itDT_1ff);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_1f6, *itDT_1ff);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool MakeAssoc_1f0::patternMatcher( const Udm::Object& matrix_1f7, const Udm::Object& dT_200)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_1f7.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_1fc= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_1f7);
		if( false== Uml::IsDerivedFrom( dT_200.type(), SFC::DT::meta))
			continue;
		SFC::DT dT_205= SFC::DT::Cast( dT_200);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_20a;
		if( !isValidBound(boundObjs_20a, matrix_1fc, true))
			continue;
		currMatch.matrix_20b= matrix_1fc;
		if( !isValidBound(boundObjs_20a, dT_205, true))
			continue;
		currMatch.dT_20c= dT_205;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void MakeAssoc_1f0::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.dT_20c.tb()+= currMatch.matrix_20b;
	}
}

void ProcessOther_20d::operator()( const Packets_t& typess_20e, const Packets_t& projects_210, Packets_t& typess_212, Packets_t& array1s_213, Packets_t& projects_214)
{
#ifdef PRINT_INFO
	printLog("ProcessOther_20d" );
#endif
	_types_215= &typess_212;
	_array1_216= &array1s_213;
	_project_217= &projects_214;
	if( ( !typess_20e.empty())&& ( !projects_210.empty()))
		callProcessRowVector_556( typess_20e, projects_210);
}

void ProcessOther_20d::callProcessRowVector_556( const Packets_t& typess_219, const Packets_t& projects_21b)
{
	Packets_t typess_21d;
	Packets_t array2s_21e;
	Packets_t projectss_21f;
	ProcessRowVector_218 processRowVector_218;
	processRowVector_218( typess_219, projects_21b, typess_21d, array2s_21e, projectss_21f);
	if( ( !typess_21d.empty())&& ( !array2s_21e.empty())&& ( !projectss_21f.empty()))
		callProcessArray1_559( typess_21d, array2s_21e, projectss_21f);
}

void ProcessOther_20d::callProcessArray1_559( const Packets_t& typess_42f, const Packets_t& basictypes_431, const Packets_t& projects_433)
{
	Packets_t typess_435;
	Packets_t array1s_436;
	Packets_t projects_437;
	ProcessArray1_42e processArray1_42e;
	processArray1_42e( typess_42f, basictypes_431, projects_433, typess_435, array1s_436, projects_437);
	_project_217->insert( _project_217->end(), projects_437.begin(), projects_437.end());
	_types_215->insert( _types_215->end(), typess_435.begin(), typess_435.end());
	_array1_216->insert( _array1_216->end(), array1s_436.begin(), array1s_436.end());
}

void ProcessRowVector_218::operator()( const Packets_t& typess_219, const Packets_t& projects_21b, Packets_t& typess_21d, Packets_t& array2s_21e, Packets_t& projectss_21f)
{
#ifdef PRINT_INFO
	printLog("ProcessRowVector_218" );
#endif
	_types_220= &typess_21d;
	_array2_221= &array2s_21e;
	_projects_222= &projectss_21f;
	if( ( !typess_219.empty())&& ( !projects_21b.empty()))
		callProcessScalar_427( typess_219, projects_21b);
}

void ProcessRowVector_218::callProcessScalar_427( const Packets_t& typess_34e, const Packets_t& projects_350)
{
	Packets_t typess_352;
	Packets_t basictypes_353;
	Packets_t projects_354;
	ProcessScalar_34d processScalar_34d;
	processScalar_34d( typess_34e, projects_350, typess_352, basictypes_353, projects_354);
	if( ( !typess_352.empty())&& ( !basictypes_353.empty())&& ( !projects_354.empty()))
		callProcessArray2_42a( typess_352, basictypes_353, projects_354);
}

void ProcessRowVector_218::callProcessArray2_42a( const Packets_t& typess_224, const Packets_t& basictypes_226, const Packets_t& projects_228)
{
	Packets_t typess_22a;
	Packets_t array2s_22b;
	Packets_t projectss_22c;
	ProcessArray2_223 processArray2_223;
	processArray2_223( typess_224, basictypes_226, projects_228, typess_22a, array2s_22b, projectss_22c);
	_types_220->insert( _types_220->end(), typess_22a.begin(), typess_22a.end());
	_array2_221->insert( _array2_221->end(), array2s_22b.begin(), array2s_22b.end());
	_projects_222->insert( _projects_222->end(), projectss_22c.begin(), projectss_22c.end());
}

void ProcessArray2_223::operator()( const Packets_t& typess_224, const Packets_t& basictypes_226, const Packets_t& projects_228, Packets_t& typess_22a, Packets_t& array2s_22b, Packets_t& projectss_22c)
{
#ifdef PRINT_INFO
	printLog("ProcessArray2_223" );
#endif
	_types_22d= &typess_22a;
	_array2_22e= &array2s_22b;
	_projects_22f= &projectss_22c;
	if( ( !typess_224.empty())&& ( !basictypes_226.empty())&& ( !projects_228.empty()))
		callGetArray2_341( typess_224, basictypes_226, projects_228);
}

void ProcessArray2_223::callGetArray2_341( const Packets_t& typess_231, const Packets_t& basictypes_233, const Packets_t& projects_235)
{
	Packets_t typess_237;
	Packets_t basictypes_238;
	Packets_t projectss_239;
	Packets_t typess_23a;
	Packets_t basictypes_23b;
	Packets_t projectss_23c;
	GetArray2_230 getArray2_230;
	getArray2_230( typess_231, basictypes_233, projects_235, typess_237, basictypes_238, projectss_239, typess_23a, basictypes_23b, projectss_23c);
	if( ( !typess_237.empty())&& ( !basictypes_238.empty())&& ( !projectss_239.empty()))
		callUseArray2_345( typess_237, basictypes_238, projectss_239);
	if( ( !typess_23a.empty())&& ( !basictypes_23b.empty())&& ( !projectss_23c.empty()))
		callCreateArray2_349( typess_23a, basictypes_23b, projectss_23c);
}

void ProcessArray2_223::callUseArray2_345( const Packets_t& matrixs_2cd, const Packets_t& basicTypes_2d1, const Packets_t& projects_2d3)
{
	Packets_t matrixs_2cf;
	Packets_t arrays_2d0;
	Packets_t projects_2d5;
	UseArray2_2cc useArray2_2cc;
	useArray2_2cc( matrixs_2cd, basicTypes_2d1, projects_2d3, matrixs_2cf, arrays_2d0, projects_2d5);
	_types_22d->insert( _types_22d->end(), matrixs_2cf.begin(), matrixs_2cf.end());
	_array2_22e->insert( _array2_22e->end(), arrays_2d0.begin(), arrays_2d0.end());
	_projects_22f->insert( _projects_22f->end(), projects_2d5.begin(), projects_2d5.end());
}

void ProcessArray2_223::callCreateArray2_349( const Packets_t& matrixs_30c, const Packets_t& basicTypes_310, const Packets_t& projects_312)
{
	Packets_t matrixs_30e;
	Packets_t arrays_30f;
	Packets_t projects_314;
	CreateArray2_30b createArray2_30b;
	createArray2_30b( matrixs_30c, basicTypes_310, projects_312, matrixs_30e, arrays_30f, projects_314);
	_types_22d->insert( _types_22d->end(), matrixs_30e.begin(), matrixs_30e.end());
	_array2_22e->insert( _array2_22e->end(), arrays_30f.begin(), arrays_30f.end());
	_projects_22f->insert( _projects_22f->end(), projects_314.begin(), projects_314.end());
}

void GetArray2_230::operator()( const Packets_t& typess_231, const Packets_t& basictypes_233, const Packets_t& projects_235, Packets_t& typess_237, Packets_t& basictypes_238, Packets_t& projectss_239, Packets_t& typess_23a, Packets_t& basictypes_23b, Packets_t& projectss_23c)
{
#ifdef PRINT_INFO
	printLog("GetArray2_230" );
#endif
	_types_23d= &typess_237;
	_basictype_23e= &basictypes_238;
	_projects_23f= &projectss_239;
	_types_240= &typess_23a;
	_basictype_241= &basictypes_23b;
	_projects_242= &projectss_23c;
	for( Packets_t::const_iterator ittypes_244= typess_231.begin(), itbasictype_24b= basictypes_233.begin(), itproject_252= projects_235.begin(); ittypes_244!= typess_231.end(), itbasictype_24b!= basictypes_233.end(), itproject_252!= projects_235.end(); ++ittypes_244, ++itbasictype_24b, ++itproject_252)
	{
		bool isUnique= isInputUnique( *ittypes_244, *itbasictype_24b, *itproject_252);
		if( !isUnique)
			continue;
		Packets_t onetypes_248( 1, *ittypes_244);
		Packets_t onebasictype_24f( 1, *itbasictype_24b);
		Packets_t oneproject_256( 1, *itproject_252);
		executeOne( onetypes_248, onebasictype_24f, oneproject_256);
	}
}

void GetArray2_230::executeOne( const Packets_t& typess_231, const Packets_t& basictypes_233, const Packets_t& projects_235)
{
	Packets_t matrixs_25b;
	Packets_t basicTypes_25e;
	Packets_t projects_261;
	Array2Exists_258 array2Exists_258;
	bool isMatchArray2Exists_258= array2Exists_258( typess_231, basictypes_233, projects_235, matrixs_25b, basicTypes_25e, projects_261);
	_types_23d->insert( _types_23d->end(), matrixs_25b.begin(), matrixs_25b.end());
	_basictype_23e->insert( _basictype_23e->end(), basicTypes_25e.begin(), basicTypes_25e.end());
	_projects_23f->insert( _projects_23f->end(), projects_261.begin(), projects_261.end());
	if( isMatchArray2Exists_258)
		return;
	Packets_t matrixs_29a;
	Packets_t basicTypes_29d;
	Packets_t projects_2a0;
	Otherwise_297 otherwise_297;
	bool isMatchOtherwise_297= otherwise_297( typess_231, basictypes_233, projects_235, matrixs_29a, basicTypes_29d, projects_2a0);
	_types_240->insert( _types_240->end(), matrixs_29a.begin(), matrixs_29a.end());
	_basictype_241->insert( _basictype_241->end(), basicTypes_29d.begin(), basicTypes_29d.end());
	_projects_242->insert( _projects_242->end(), projects_2a0.begin(), projects_2a0.end());
	if( isMatchOtherwise_297)
		return;
}

bool GetArray2_230::isInputUnique( const Udm::Object& types_245, const Udm::Object& basictype_24c, const Udm::Object& project_253)
{
	bool isUnique= true;
	for( Packets_t::const_iterator ittypes_247= _types_243.begin(), itbasictype_24e= _basictype_24a.begin(), itproject_255= _project_251.begin(); ittypes_247!= _types_243.end(), itbasictype_24e!= _basictype_24a.end(), itproject_255!= _project_251.end(); ++ittypes_247, ++itbasictype_24e, ++itproject_255)
	{
		if( ( *ittypes_247== types_245)&& ( *itbasictype_24e== basictype_24c)&& ( *itproject_255== project_253))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_types_243.push_back( types_245);
		_basictype_24a.push_back( basictype_24c);
		_project_251.push_back( project_253);
	}
	return isUnique;
}

bool Array2Exists_258::operator()( const Packets_t& matrixs_259, const Packets_t& basicTypes_25c, const Packets_t& projects_25f, Packets_t& matrixs_25b, Packets_t& basicTypes_25e, Packets_t& projects_261)
{
#ifdef PRINT_INFO
	printLog("Array2Exists_258" );
#endif
	_matrix_262= &matrixs_25b;
	_basicType_263= &basicTypes_25e;
	_project_264= &projects_261;
	processInputPackets( matrixs_259, basicTypes_25c, projects_25f);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Array2Exists_258::isInputUnique( const Udm::Object& matrix_269, const Udm::Object& basicType_272, const Udm::Object& project_27b)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_26b= _matrix_265.begin(), itBasicType_274= _basicType_26e.begin(), itProject_27d= _project_277.begin(); itMatrix_26b!= _matrix_265.end(), itBasicType_274!= _basicType_26e.end(), itProject_27d!= _project_277.end(); ++itMatrix_26b, ++itBasicType_274, ++itProject_27d)
	{
		if( ( *itMatrix_26b== matrix_269)&& ( *itBasicType_274== basicType_272)&& ( *itProject_27d== project_27b))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_265.push_back( matrix_269);
		_basicType_26e.push_back( basicType_272);
		_project_277.push_back( project_27b);
	}
	return isUnique;
}

bool Array2Exists_258::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool Array2Exists_258::isGuardTrue( SFC::Array& Array, SFC::BasicType& BasicType, CyPhyML::SignalFlow::SF_Matrix& Matrix, SFC::Project& Project)
{
	bool Gz_guard= false;
	Gz_guard = Matrix.columns() == Array.noelem();;
	return Gz_guard;
}

void Array2Exists_258::processInputPackets( const Packets_t& matrixs_259, const Packets_t& basicTypes_25c, const Packets_t& projects_25f)
{
	for( Packets_t::const_iterator itMatrix_266= matrixs_259.begin(), itBasicType_26f= basicTypes_25c.begin(), itProject_278= projects_25f.begin(); itMatrix_266!= matrixs_259.end(), itBasicType_26f!= basicTypes_25c.end(), itProject_278!= projects_25f.end(); ++itMatrix_266, ++itBasicType_26f, ++itProject_278)
	{
		bool isUnique= isInputUnique( *itMatrix_266, *itBasicType_26f, *itProject_278);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_266, *itBasicType_26f, *itProject_278);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.matrix_289, currMatch.basicType_28a, currMatch.project_28b);
	}
}

bool Array2Exists_258::patternMatcher( const Udm::Object& matrix_267, const Udm::Object& basicType_270, const Udm::Object& project_279)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_267.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_26c= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_267);
		if( false== Uml::IsDerivedFrom( basicType_270.type(), SFC::BasicType::meta))
			continue;
		SFC::BasicType basicType_275= SFC::BasicType::Cast( basicType_270);
		if( false== Uml::IsDerivedFrom( project_279.type(), SFC::Project::meta))
			continue;
		SFC::Project project_27e= SFC::Project::Cast( project_279);
		set< SFC::Array> arrays_280= project_27e.Array_kind_children();
		for( set< SFC::Array>::const_iterator itArray_281= arrays_280.begin(); itArray_281!= arrays_280.end(); ++itArray_281)
		{
			SFC::Array currArray_282= *itArray_281;
			SFC::DT basicType_283= currArray_282.dt();
			if(!basicType_283 || false== Uml::IsDerivedFrom( basicType_283.type(), SFC::BasicType::meta))
				continue;
			SFC::BasicType basicType_284= SFC::BasicType::Cast( basicType_283);
			if( !basicType_284)
				continue;
			if( basicType_275!= basicType_284)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_288;
			if( !isValidBound(boundObjs_288, matrix_26c, true))
				continue;
			currMatch.matrix_289= matrix_26c;
			if( !isValidBound(boundObjs_288, basicType_275, true))
				continue;
			currMatch.basicType_28a= basicType_275;
			if( !isValidBound(boundObjs_288, project_27e, true))
				continue;
			currMatch.project_28b= project_27e;
			if( !isValidBound(boundObjs_288, currArray_282, false))
				continue;
			currMatch.array_28c= currArray_282;
			bool Gz_guard= isGuardTrue( currMatch.array_28c, currMatch.basicType_28a, currMatch.matrix_289, currMatch.project_28b);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void Array2Exists_258::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_291, const SFC::BasicType& basicType_293, const SFC::Project& project_295)
{
	_matrix_262->push_back( matrix_291);
	_basicType_263->push_back( basicType_293);
	_project_264->push_back( project_295);
}

bool Otherwise_297::operator()( const Packets_t& matrixs_298, const Packets_t& basicTypes_29b, const Packets_t& projects_29e, Packets_t& matrixs_29a, Packets_t& basicTypes_29d, Packets_t& projects_2a0)
{
#ifdef PRINT_INFO
	printLog("Otherwise_297" );
#endif
	_matrix_2a1= &matrixs_29a;
	_basicType_2a2= &basicTypes_29d;
	_project_2a3= &projects_2a0;
	processInputPackets( matrixs_298, basicTypes_29b, projects_29e);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_297::isInputUnique( const Udm::Object& matrix_2a8, const Udm::Object& basicType_2b1, const Udm::Object& project_2ba)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_2aa= _matrix_2a4.begin(), itBasicType_2b3= _basicType_2ad.begin(), itProject_2bc= _project_2b6.begin(); itMatrix_2aa!= _matrix_2a4.end(), itBasicType_2b3!= _basicType_2ad.end(), itProject_2bc!= _project_2b6.end(); ++itMatrix_2aa, ++itBasicType_2b3, ++itProject_2bc)
	{
		if( ( *itMatrix_2aa== matrix_2a8)&& ( *itBasicType_2b3== basicType_2b1)&& ( *itProject_2bc== project_2ba))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_2a4.push_back( matrix_2a8);
		_basicType_2ad.push_back( basicType_2b1);
		_project_2b6.push_back( project_2ba);
	}
	return isUnique;
}

bool Otherwise_297::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_297::processInputPackets( const Packets_t& matrixs_298, const Packets_t& basicTypes_29b, const Packets_t& projects_29e)
{
	for( Packets_t::const_iterator itMatrix_2a5= matrixs_298.begin(), itBasicType_2ae= basicTypes_29b.begin(), itProject_2b7= projects_29e.begin(); itMatrix_2a5!= matrixs_298.end(), itBasicType_2ae!= basicTypes_29b.end(), itProject_2b7!= projects_29e.end(); ++itMatrix_2a5, ++itBasicType_2ae, ++itProject_2b7)
	{
		bool isUnique= isInputUnique( *itMatrix_2a5, *itBasicType_2ae, *itProject_2b7);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_2a5, *itBasicType_2ae, *itProject_2b7);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.matrix_2c3, currMatch.basicType_2c4, currMatch.project_2c5);
	}
}

bool Otherwise_297::patternMatcher( const Udm::Object& matrix_2a6, const Udm::Object& basicType_2af, const Udm::Object& project_2b8)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_2a6.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_2ab= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_2a6);
		if( false== Uml::IsDerivedFrom( basicType_2af.type(), SFC::BasicType::meta))
			continue;
		SFC::BasicType basicType_2b4= SFC::BasicType::Cast( basicType_2af);
		if( false== Uml::IsDerivedFrom( project_2b8.type(), SFC::Project::meta))
			continue;
		SFC::Project project_2bd= SFC::Project::Cast( project_2b8);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2c2;
		if( !isValidBound(boundObjs_2c2, matrix_2ab, true))
			continue;
		currMatch.matrix_2c3= matrix_2ab;
		if( !isValidBound(boundObjs_2c2, basicType_2b4, true))
			continue;
		currMatch.basicType_2c4= basicType_2b4;
		if( !isValidBound(boundObjs_2c2, project_2bd, true))
			continue;
		currMatch.project_2c5= project_2bd;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_297::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_2c6, const SFC::BasicType& basicType_2c8, const SFC::Project& project_2ca)
{
	_matrix_2a1->push_back( matrix_2c6);
	_basicType_2a2->push_back( basicType_2c8);
	_project_2a3->push_back( project_2ca);
}

void UseArray2_2cc::operator()( const Packets_t& matrixs_2cd, const Packets_t& basicTypes_2d1, const Packets_t& projects_2d3, Packets_t& matrixs_2cf, Packets_t& arrays_2d0, Packets_t& projects_2d5)
{
#ifdef PRINT_INFO
	printLog("UseArray2_2cc" );
#endif
	RTTGenerator::Instance()->generateRule(149, "UseArray2");
	_matrix_2d6= &matrixs_2cf;
	_array_2d7= &arrays_2d0;
	_project_2d8= &projects_2d5;
	processInputPackets( matrixs_2cd, basicTypes_2d1, projects_2d3);
}

bool UseArray2_2cc::isInputUnique( const Udm::Object& matrix_2dd, const Udm::Object& basicType_2e6, const Udm::Object& project_2ef)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_2df= _matrix_2d9.begin(), itBasicType_2e8= _basicType_2e2.begin(), itProject_2f1= _project_2eb.begin(); itMatrix_2df!= _matrix_2d9.end(), itBasicType_2e8!= _basicType_2e2.end(), itProject_2f1!= _project_2eb.end(); ++itMatrix_2df, ++itBasicType_2e8, ++itProject_2f1)
	{
		if( ( *itMatrix_2df== matrix_2dd)&& ( *itBasicType_2e8== basicType_2e6)&& ( *itProject_2f1== project_2ef))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_2d9.push_back( matrix_2dd);
		_basicType_2e2.push_back( basicType_2e6);
		_project_2eb.push_back( project_2ef);
	}
	return isUnique;
}

bool UseArray2_2cc::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool UseArray2_2cc::isGuardTrue( SFC::Array& Array, SFC::BasicType& BasicType, CyPhyML::SignalFlow::SF_Matrix& Matrix, SFC::Project& Project)
{
	bool Gz_guard= false;
	Gz_guard = Matrix.columns() == Array.noelem();;
	return Gz_guard;
}

void UseArray2_2cc::processInputPackets( const Packets_t& matrixs_2cd, const Packets_t& basicTypes_2d1, const Packets_t& projects_2d3)
{
	for( Packets_t::const_iterator itMatrix_2da= matrixs_2cd.begin(), itBasicType_2e3= basicTypes_2d1.begin(), itProject_2ec= projects_2d3.begin(); itMatrix_2da!= matrixs_2cd.end(), itBasicType_2e3!= basicTypes_2d1.end(), itProject_2ec!= projects_2d3.end(); ++itMatrix_2da, ++itBasicType_2e3, ++itProject_2ec)
	{
		bool isUnique= isInputUnique( *itMatrix_2da, *itBasicType_2e3, *itProject_2ec);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_2da, *itBasicType_2e3, *itProject_2ec);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool UseArray2_2cc::patternMatcher( const Udm::Object& matrix_2db, const Udm::Object& basicType_2e4, const Udm::Object& project_2ed)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_2db.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_2e0= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_2db);
		if( false== Uml::IsDerivedFrom( basicType_2e4.type(), SFC::BasicType::meta))
			continue;
		SFC::BasicType basicType_2e9= SFC::BasicType::Cast( basicType_2e4);
		if( false== Uml::IsDerivedFrom( project_2ed.type(), SFC::Project::meta))
			continue;
		SFC::Project project_2f2= SFC::Project::Cast( project_2ed);
		set< SFC::Array> arrays_2f4= project_2f2.Array_kind_children();
		for( set< SFC::Array>::const_iterator itArray_2f5= arrays_2f4.begin(); itArray_2f5!= arrays_2f4.end(); ++itArray_2f5)
		{
			SFC::Array currArray_2f6= *itArray_2f5;
			SFC::DT basicType_2f7= currArray_2f6.dt();
			if(!basicType_2f7 || false== Uml::IsDerivedFrom( basicType_2f7.type(), SFC::BasicType::meta))
				continue;
			SFC::BasicType basicType_2f8= SFC::BasicType::Cast( basicType_2f7);
			if( !basicType_2f8)
				continue;
			if( basicType_2e9!= basicType_2f8)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_2fc;
			if( !isValidBound(boundObjs_2fc, matrix_2e0, true))
				continue;
			currMatch.matrix_2fd= matrix_2e0;
			if( !isValidBound(boundObjs_2fc, basicType_2e9, true))
				continue;
			currMatch.basicType_2fe= basicType_2e9;
			if( !isValidBound(boundObjs_2fc, project_2f2, true))
				continue;
			currMatch.project_2ff= project_2f2;
			if( !isValidBound(boundObjs_2fc, currArray_2f6, false))
				continue;
			currMatch.array_300= currArray_2f6;
			bool Gz_guard= isGuardTrue( currMatch.array_300, currMatch.basicType_2fe, currMatch.matrix_2fd, currMatch.project_2ff);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void UseArray2_2cc::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.matrix_2fd, currMatch.array_300, currMatch.project_2ff);
	}
}

void UseArray2_2cc::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_305, const SFC::Array& array_307, const SFC::Project& project_309)
{
	_matrix_2d6->push_back( matrix_305);
	_array_2d7->push_back( array_307);
	_project_2d8->push_back( project_309);
}

void CreateArray2_30b::operator()( const Packets_t& matrixs_30c, const Packets_t& basicTypes_310, const Packets_t& projects_312, Packets_t& matrixs_30e, Packets_t& arrays_30f, Packets_t& projects_314)
{
#ifdef PRINT_INFO
	printLog("CreateArray2_30b" );
#endif
	RTTGenerator::Instance()->generateRule(156, "CreateArray2");
	_matrix_315= &matrixs_30e;
	_array_316= &arrays_30f;
	_project_317= &projects_314;
	processInputPackets( matrixs_30c, basicTypes_310, projects_312);
}

bool CreateArray2_30b::isInputUnique( const Udm::Object& matrix_31c, const Udm::Object& basicType_325, const Udm::Object& project_32e)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_31e= _matrix_318.begin(), itBasicType_327= _basicType_321.begin(), itProject_330= _project_32a.begin(); itMatrix_31e!= _matrix_318.end(), itBasicType_327!= _basicType_321.end(), itProject_330!= _project_32a.end(); ++itMatrix_31e, ++itBasicType_327, ++itProject_330)
	{
		if( ( *itMatrix_31e== matrix_31c)&& ( *itBasicType_327== basicType_325)&& ( *itProject_330== project_32e))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_318.push_back( matrix_31c);
		_basicType_321.push_back( basicType_325);
		_project_32a.push_back( project_32e);
	}
	return isUnique;
}

bool CreateArray2_30b::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateArray2_30b::processInputPackets( const Packets_t& matrixs_30c, const Packets_t& basicTypes_310, const Packets_t& projects_312)
{
	for( Packets_t::const_iterator itMatrix_319= matrixs_30c.begin(), itBasicType_322= basicTypes_310.begin(), itProject_32b= projects_312.begin(); itMatrix_319!= matrixs_30c.end(), itBasicType_322!= basicTypes_310.end(), itProject_32b!= projects_312.end(); ++itMatrix_319, ++itBasicType_322, ++itProject_32b)
	{
		bool isUnique= isInputUnique( *itMatrix_319, *itBasicType_322, *itProject_32b);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_319, *itBasicType_322, *itProject_32b);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateArray2_30b::patternMatcher( const Udm::Object& matrix_31a, const Udm::Object& basicType_323, const Udm::Object& project_32c)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_31a.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_31f= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_31a);
		if( false== Uml::IsDerivedFrom( basicType_323.type(), SFC::BasicType::meta))
			continue;
		SFC::BasicType basicType_328= SFC::BasicType::Cast( basicType_323);
		if( false== Uml::IsDerivedFrom( project_32c.type(), SFC::Project::meta))
			continue;
		SFC::Project project_331= SFC::Project::Cast( project_32c);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_336;
		if( !isValidBound(boundObjs_336, matrix_31f, true))
			continue;
		currMatch.matrix_337= matrix_31f;
		if( !isValidBound(boundObjs_336, basicType_328, true))
			continue;
		currMatch.basicType_338= basicType_328;
		if( !isValidBound(boundObjs_336, project_331, true))
			continue;
		currMatch.project_339= project_331;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateArray2_30b::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Array newArray_33a= SFC::Array::Create( currMatch.project_339);
		SFC::Array& Array= newArray_33a;
		SFC::BasicType& BasicType= currMatch.basicType_338;
		CyPhyML::SignalFlow::SF_Matrix& Matrix= currMatch.matrix_337;
		SFC::Project& Project= currMatch.project_339;
		{
__int64 statementCount = Project.statementCount();
Array.statementIndex() = statementCount++;
Project.statementCount() = statementCount;

Array.noelem() = Matrix.columns();
};
		newArray_33a.dt()= currMatch.basicType_338;
		outputAppender( currMatch.matrix_337, newArray_33a, currMatch.project_339);
	}
}

void CreateArray2_30b::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_33b, const SFC::Array& array_33d, const SFC::Project& project_33f)
{
	_matrix_315->push_back( matrix_33b);
	_array_316->push_back( array_33d);
	_project_317->push_back( project_33f);
}

void ProcessScalar_34d::operator()( const Packets_t& typess_34e, const Packets_t& projects_350, Packets_t& typess_352, Packets_t& basictypes_353, Packets_t& projects_354)
{
#ifdef PRINT_INFO
	printLog("ProcessScalar_34d" );
#endif
	_types_355= &typess_352;
	_basictype_356= &basictypes_353;
	_project_357= &projects_354;
	if( ( !typess_34e.empty())&& ( !projects_350.empty()))
		callGetBasicType_41e( typess_34e, projects_350);
}

void ProcessScalar_34d::callGetBasicType_41e( const Packets_t& typess_389, const Packets_t& projects_38b)
{
	Packets_t typess_38d;
	Packets_t projectss_38e;
	Packets_t typess_38f;
	Packets_t projectss_390;
	GetBasicType_388 getBasicType_388;
	getBasicType_388( typess_389, projects_38b, typess_38d, projectss_38e, typess_38f, projectss_390);
	if( ( !typess_38f.empty())&& ( !projectss_390.empty()))
		callCreateBasicType_421( typess_38f, projectss_390);
	if( ( !typess_38d.empty())&& ( !projectss_38e.empty()))
		callUseBasicType_424( typess_38d, projectss_38e);
}

void ProcessScalar_34d::callCreateBasicType_421( const Packets_t& matrixs_3f5, const Packets_t& projects_3f9)
{
	Packets_t matrixs_3f7;
	Packets_t basicTypes_3f8;
	Packets_t projects_3fb;
	CreateBasicType_3f4 createBasicType_3f4;
	createBasicType_3f4( matrixs_3f5, projects_3f9, matrixs_3f7, basicTypes_3f8, projects_3fb);
	_types_355->insert( _types_355->end(), matrixs_3f7.begin(), matrixs_3f7.end());
	_basictype_356->insert( _basictype_356->end(), basicTypes_3f8.begin(), basicTypes_3f8.end());
	_project_357->insert( _project_357->end(), projects_3fb.begin(), projects_3fb.end());
}

void ProcessScalar_34d::callUseBasicType_424( const Packets_t& matrixs_359, const Packets_t& projects_35d)
{
	Packets_t matrixs_35b;
	Packets_t basicTypes_35c;
	Packets_t projects_35f;
	UseBasicType_358 useBasicType_358;
	useBasicType_358( matrixs_359, projects_35d, matrixs_35b, basicTypes_35c, projects_35f);
	_types_355->insert( _types_355->end(), matrixs_35b.begin(), matrixs_35b.end());
	_basictype_356->insert( _basictype_356->end(), basicTypes_35c.begin(), basicTypes_35c.end());
	_project_357->insert( _project_357->end(), projects_35f.begin(), projects_35f.end());
}

void UseBasicType_358::operator()( const Packets_t& matrixs_359, const Packets_t& projects_35d, Packets_t& matrixs_35b, Packets_t& basicTypes_35c, Packets_t& projects_35f)
{
#ifdef PRINT_INFO
	printLog("UseBasicType_358" );
#endif
	RTTGenerator::Instance()->generateRule(219, "UseBasicType");
	_matrix_360= &matrixs_35b;
	_basicType_361= &basicTypes_35c;
	_project_362= &projects_35f;
	processInputPackets( matrixs_359, projects_35d);
}

bool UseBasicType_358::isInputUnique( const Udm::Object& matrix_367, const Udm::Object& project_370)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_369= _matrix_363.begin(), itProject_372= _project_36c.begin(); itMatrix_369!= _matrix_363.end(), itProject_372!= _project_36c.end(); ++itMatrix_369, ++itProject_372)
	{
		if( ( *itMatrix_369== matrix_367)&& ( *itProject_372== project_370))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_363.push_back( matrix_367);
		_project_36c.push_back( project_370);
	}
	return isUnique;
}

bool UseBasicType_358::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool UseBasicType_358::isGuardTrue( SFC::BasicType& BasicType, CyPhyML::SignalFlow::SF_Matrix& Matrix, SFC::Project& Project)
{
	bool Gz_guard= false;
	Gz_guard =
 static_cast< std::string >( Matrix.Type() ) ==
 static_cast< std::string >( BasicType.name() );;
	return Gz_guard;
}

void UseBasicType_358::processInputPackets( const Packets_t& matrixs_359, const Packets_t& projects_35d)
{
	for( Packets_t::const_iterator itMatrix_364= matrixs_359.begin(), itProject_36d= projects_35d.begin(); itMatrix_364!= matrixs_359.end(), itProject_36d!= projects_35d.end(); ++itMatrix_364, ++itProject_36d)
	{
		bool isUnique= isInputUnique( *itMatrix_364, *itProject_36d);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_364, *itProject_36d);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool UseBasicType_358::patternMatcher( const Udm::Object& matrix_365, const Udm::Object& project_36e)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_365.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_36a= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_365);
		if( false== Uml::IsDerivedFrom( project_36e.type(), SFC::Project::meta))
			continue;
		SFC::Project project_373= SFC::Project::Cast( project_36e);
		set< SFC::BasicType> basicTypes_375= project_373.BasicType_kind_children();
		for( set< SFC::BasicType>::const_iterator itBasicType_376= basicTypes_375.begin(); itBasicType_376!= basicTypes_375.end(); ++itBasicType_376)
		{
			SFC::BasicType currBasicType_377= *itBasicType_376;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_37b;
			if( !isValidBound(boundObjs_37b, matrix_36a, true))
				continue;
			currMatch.matrix_37c= matrix_36a;
			if( !isValidBound(boundObjs_37b, project_373, true))
				continue;
			currMatch.project_37d= project_373;
			if( !isValidBound(boundObjs_37b, currBasicType_377, false))
				continue;
			currMatch.basicType_37e= currBasicType_377;
			bool Gz_guard= isGuardTrue( currMatch.basicType_37e, currMatch.matrix_37c, currMatch.project_37d);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void UseBasicType_358::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.matrix_37c, currMatch.basicType_37e, currMatch.project_37d);
	}
}

void UseBasicType_358::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_382, const SFC::BasicType& basicType_384, const SFC::Project& project_386)
{
	_matrix_360->push_back( matrix_382);
	_basicType_361->push_back( basicType_384);
	_project_362->push_back( project_386);
}

void GetBasicType_388::operator()( const Packets_t& typess_389, const Packets_t& projects_38b, Packets_t& typess_38d, Packets_t& projectss_38e, Packets_t& typess_38f, Packets_t& projectss_390)
{
#ifdef PRINT_INFO
	printLog("GetBasicType_388" );
#endif
	_types_391= &typess_38d;
	_projects_392= &projectss_38e;
	_types_393= &typess_38f;
	_projects_394= &projectss_390;
	for( Packets_t::const_iterator ittypes_396= typess_389.begin(), itproject_39d= projects_38b.begin(); ittypes_396!= typess_389.end(), itproject_39d!= projects_38b.end(); ++ittypes_396, ++itproject_39d)
	{
		bool isUnique= isInputUnique( *ittypes_396, *itproject_39d);
		if( !isUnique)
			continue;
		Packets_t onetypes_39a( 1, *ittypes_396);
		Packets_t oneproject_3a1( 1, *itproject_39d);
		executeOne( onetypes_39a, oneproject_3a1);
	}
}

void GetBasicType_388::executeOne( const Packets_t& typess_389, const Packets_t& projects_38b)
{
	Packets_t matrixs_3a6;
	Packets_t projects_3a9;
	BasicTypeExists_3a3 basicTypeExists_3a3;
	bool isMatchBasicTypeExists_3a3= basicTypeExists_3a3( typess_389, projects_38b, matrixs_3a6, projects_3a9);
	_types_391->insert( _types_391->end(), matrixs_3a6.begin(), matrixs_3a6.end());
	_projects_392->insert( _projects_392->end(), projects_3a9.begin(), projects_3a9.end());
	if( isMatchBasicTypeExists_3a3)
		return;
	Packets_t matrixs_3d2;
	Packets_t projects_3d5;
	Otherwise_3cf otherwise_3cf;
	bool isMatchOtherwise_3cf= otherwise_3cf( typess_389, projects_38b, matrixs_3d2, projects_3d5);
	_types_393->insert( _types_393->end(), matrixs_3d2.begin(), matrixs_3d2.end());
	_projects_394->insert( _projects_394->end(), projects_3d5.begin(), projects_3d5.end());
}

bool GetBasicType_388::isInputUnique( const Udm::Object& types_397, const Udm::Object& project_39e)
{
	bool isUnique= true;
	for( Packets_t::const_iterator ittypes_399= _types_395.begin(), itproject_3a0= _project_39c.begin(); ittypes_399!= _types_395.end(), itproject_3a0!= _project_39c.end(); ++ittypes_399, ++itproject_3a0)
	{
		if( ( *ittypes_399== types_397)&& ( *itproject_3a0== project_39e))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_types_395.push_back( types_397);
		_project_39c.push_back( project_39e);
	}
	return isUnique;
}

bool BasicTypeExists_3a3::operator()( const Packets_t& matrixs_3a4, const Packets_t& projects_3a7, Packets_t& matrixs_3a6, Packets_t& projects_3a9)
{
#ifdef PRINT_INFO
	printLog("BasicTypeExists_3a3" );
#endif
	_matrix_3aa= &matrixs_3a6;
	_project_3ab= &projects_3a9;
	processInputPackets( matrixs_3a4, projects_3a7);
	if( false== _matches.empty())
		return true;
	return false;
}

bool BasicTypeExists_3a3::isInputUnique( const Udm::Object& matrix_3b0, const Udm::Object& project_3b9)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_3b2= _matrix_3ac.begin(), itProject_3bb= _project_3b5.begin(); itMatrix_3b2!= _matrix_3ac.end(), itProject_3bb!= _project_3b5.end(); ++itMatrix_3b2, ++itProject_3bb)
	{
		if( ( *itMatrix_3b2== matrix_3b0)&& ( *itProject_3bb== project_3b9))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_3ac.push_back( matrix_3b0);
		_project_3b5.push_back( project_3b9);
	}
	return isUnique;
}

bool BasicTypeExists_3a3::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool BasicTypeExists_3a3::isGuardTrue( SFC::BasicType& BasicType, CyPhyML::SignalFlow::SF_Matrix& Matrix, SFC::Project& Project)
{
	bool Gz_guard= false;
	Gz_guard =
 static_cast< std::string >( Matrix.Type() ) ==
 static_cast< std::string >( BasicType.name() );;
	return Gz_guard;
}

void BasicTypeExists_3a3::processInputPackets( const Packets_t& matrixs_3a4, const Packets_t& projects_3a7)
{
	for( Packets_t::const_iterator itMatrix_3ad= matrixs_3a4.begin(), itProject_3b6= projects_3a7.begin(); itMatrix_3ad!= matrixs_3a4.end(), itProject_3b6!= projects_3a7.end(); ++itMatrix_3ad, ++itProject_3b6)
	{
		bool isUnique= isInputUnique( *itMatrix_3ad, *itProject_3b6);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_3ad, *itProject_3b6);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.matrix_3c5, currMatch.project_3c6);
	}
}

bool BasicTypeExists_3a3::patternMatcher( const Udm::Object& matrix_3ae, const Udm::Object& project_3b7)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_3ae.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_3b3= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_3ae);
		if( false== Uml::IsDerivedFrom( project_3b7.type(), SFC::Project::meta))
			continue;
		SFC::Project project_3bc= SFC::Project::Cast( project_3b7);
		set< SFC::BasicType> basicTypes_3be= project_3bc.BasicType_kind_children();
		for( set< SFC::BasicType>::const_iterator itBasicType_3bf= basicTypes_3be.begin(); itBasicType_3bf!= basicTypes_3be.end(); ++itBasicType_3bf)
		{
			SFC::BasicType currBasicType_3c0= *itBasicType_3bf;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_3c4;
			if( !isValidBound(boundObjs_3c4, matrix_3b3, true))
				continue;
			currMatch.matrix_3c5= matrix_3b3;
			if( !isValidBound(boundObjs_3c4, project_3bc, true))
				continue;
			currMatch.project_3c6= project_3bc;
			if( !isValidBound(boundObjs_3c4, currBasicType_3c0, false))
				continue;
			currMatch.basicType_3c7= currBasicType_3c0;
			bool Gz_guard= isGuardTrue( currMatch.basicType_3c7, currMatch.matrix_3c5, currMatch.project_3c6);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void BasicTypeExists_3a3::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_3cb, const SFC::Project& project_3cd)
{
	_matrix_3aa->push_back( matrix_3cb);
	_project_3ab->push_back( project_3cd);
}

bool Otherwise_3cf::operator()( const Packets_t& matrixs_3d0, const Packets_t& projects_3d3, Packets_t& matrixs_3d2, Packets_t& projects_3d5)
{
#ifdef PRINT_INFO
	printLog("Otherwise_3cf" );
#endif
	_matrix_3d6= &matrixs_3d2;
	_project_3d7= &projects_3d5;
	processInputPackets( matrixs_3d0, projects_3d3);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_3cf::isInputUnique( const Udm::Object& matrix_3dc, const Udm::Object& project_3e5)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_3de= _matrix_3d8.begin(), itProject_3e7= _project_3e1.begin(); itMatrix_3de!= _matrix_3d8.end(), itProject_3e7!= _project_3e1.end(); ++itMatrix_3de, ++itProject_3e7)
	{
		if( ( *itMatrix_3de== matrix_3dc)&& ( *itProject_3e7== project_3e5))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_3d8.push_back( matrix_3dc);
		_project_3e1.push_back( project_3e5);
	}
	return isUnique;
}

bool Otherwise_3cf::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_3cf::processInputPackets( const Packets_t& matrixs_3d0, const Packets_t& projects_3d3)
{
	for( Packets_t::const_iterator itMatrix_3d9= matrixs_3d0.begin(), itProject_3e2= projects_3d3.begin(); itMatrix_3d9!= matrixs_3d0.end(), itProject_3e2!= projects_3d3.end(); ++itMatrix_3d9, ++itProject_3e2)
	{
		bool isUnique= isInputUnique( *itMatrix_3d9, *itProject_3e2);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_3d9, *itProject_3e2);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.matrix_3ee, currMatch.project_3ef);
	}
}

bool Otherwise_3cf::patternMatcher( const Udm::Object& matrix_3da, const Udm::Object& project_3e3)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_3da.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_3df= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_3da);
		if( false== Uml::IsDerivedFrom( project_3e3.type(), SFC::Project::meta))
			continue;
		SFC::Project project_3e8= SFC::Project::Cast( project_3e3);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_3ed;
		if( !isValidBound(boundObjs_3ed, matrix_3df, true))
			continue;
		currMatch.matrix_3ee= matrix_3df;
		if( !isValidBound(boundObjs_3ed, project_3e8, true))
			continue;
		currMatch.project_3ef= project_3e8;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_3cf::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_3f0, const SFC::Project& project_3f2)
{
	_matrix_3d6->push_back( matrix_3f0);
	_project_3d7->push_back( project_3f2);
}

void CreateBasicType_3f4::operator()( const Packets_t& matrixs_3f5, const Packets_t& projects_3f9, Packets_t& matrixs_3f7, Packets_t& basicTypes_3f8, Packets_t& projects_3fb)
{
#ifdef PRINT_INFO
	printLog("CreateBasicType_3f4" );
#endif
	RTTGenerator::Instance()->generateRule(239, "CreateBasicType");
	_matrix_3fc= &matrixs_3f7;
	_basicType_3fd= &basicTypes_3f8;
	_project_3fe= &projects_3fb;
	processInputPackets( matrixs_3f5, projects_3f9);
}

bool CreateBasicType_3f4::isInputUnique( const Udm::Object& matrix_403, const Udm::Object& project_40c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_405= _matrix_3ff.begin(), itProject_40e= _project_408.begin(); itMatrix_405!= _matrix_3ff.end(), itProject_40e!= _project_408.end(); ++itMatrix_405, ++itProject_40e)
	{
		if( ( *itMatrix_405== matrix_403)&& ( *itProject_40e== project_40c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_3ff.push_back( matrix_403);
		_project_408.push_back( project_40c);
	}
	return isUnique;
}

bool CreateBasicType_3f4::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateBasicType_3f4::processInputPackets( const Packets_t& matrixs_3f5, const Packets_t& projects_3f9)
{
	for( Packets_t::const_iterator itMatrix_400= matrixs_3f5.begin(), itProject_409= projects_3f9.begin(); itMatrix_400!= matrixs_3f5.end(), itProject_409!= projects_3f9.end(); ++itMatrix_400, ++itProject_409)
	{
		bool isUnique= isInputUnique( *itMatrix_400, *itProject_409);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_400, *itProject_409);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateBasicType_3f4::patternMatcher( const Udm::Object& matrix_401, const Udm::Object& project_40a)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_401.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_406= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_401);
		if( false== Uml::IsDerivedFrom( project_40a.type(), SFC::Project::meta))
			continue;
		SFC::Project project_40f= SFC::Project::Cast( project_40a);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_414;
		if( !isValidBound(boundObjs_414, matrix_406, true))
			continue;
		currMatch.matrix_415= matrix_406;
		if( !isValidBound(boundObjs_414, project_40f, true))
			continue;
		currMatch.project_416= project_40f;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateBasicType_3f4::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::BasicType newBasicType_417= SFC::BasicType::Create( currMatch.project_416);
		SFC::BasicType& BasicType= newBasicType_417;
		CyPhyML::SignalFlow::SF_Matrix& Matrix= currMatch.matrix_415;
		SFC::Project& Project= currMatch.project_416;
		{
__int64 statementCount = Project.statementCount();
BasicType.statementIndex() = statementCount++;
Project.statementCount() = statementCount;

BasicType.name() = Matrix.Type();

};
		outputAppender( currMatch.matrix_415, newBasicType_417, currMatch.project_416);
	}
}

void CreateBasicType_3f4::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_418, const SFC::BasicType& basicType_41a, const SFC::Project& project_41c)
{
	_matrix_3fc->push_back( matrix_418);
	_basicType_3fd->push_back( basicType_41a);
	_project_3fe->push_back( project_41c);
}

void ProcessArray1_42e::operator()( const Packets_t& typess_42f, const Packets_t& basictypes_431, const Packets_t& projects_433, Packets_t& typess_435, Packets_t& array1s_436, Packets_t& projects_437)
{
#ifdef PRINT_INFO
	printLog("ProcessArray1_42e" );
#endif
	_types_438= &typess_435;
	_array1_439= &array1s_436;
	_project_43a= &projects_437;
	if( ( !typess_42f.empty())&& ( !basictypes_431.empty())&& ( !projects_433.empty()))
		callGetArray1_54a( typess_42f, basictypes_431, projects_433);
}

void ProcessArray1_42e::callGetArray1_54a( const Packets_t& typess_43c, const Packets_t& dts_43e, const Packets_t& projects_440)
{
	Packets_t typess_442;
	Packets_t dts_443;
	Packets_t projectss_444;
	Packets_t typess_445;
	Packets_t dts_446;
	Packets_t projectss_447;
	GetArray1_43b getArray1_43b;
	getArray1_43b( typess_43c, dts_43e, projects_440, typess_442, dts_443, projectss_444, typess_445, dts_446, projectss_447);
	if( ( !typess_445.empty())&& ( !dts_446.empty())&& ( !projectss_447.empty()))
		callCreateArray1_54e( typess_445, dts_446, projectss_447);
	if( ( !typess_442.empty())&& ( !dts_443.empty())&& ( !projectss_444.empty()))
		callUseArray1_552( typess_442, dts_443, projectss_444);
}

void ProcessArray1_42e::callCreateArray1_54e( const Packets_t& matrixs_515, const Packets_t& dTs_518, const Packets_t& projects_51b)
{
	Packets_t matrixs_517;
	Packets_t arrays_51a;
	Packets_t projects_51d;
	CreateArray1_514 createArray1_514;
	createArray1_514( matrixs_515, dTs_518, projects_51b, matrixs_517, arrays_51a, projects_51d);
	_types_438->insert( _types_438->end(), matrixs_517.begin(), matrixs_517.end());
	_array1_439->insert( _array1_439->end(), arrays_51a.begin(), arrays_51a.end());
	_project_43a->insert( _project_43a->end(), projects_51d.begin(), projects_51d.end());
}

void ProcessArray1_42e::callUseArray1_552( const Packets_t& matrixs_4d7, const Packets_t& dTs_4da, const Packets_t& projects_4dd)
{
	Packets_t matrixs_4d9;
	Packets_t arrays_4dc;
	Packets_t projects_4df;
	UseArray1_4d6 useArray1_4d6;
	useArray1_4d6( matrixs_4d7, dTs_4da, projects_4dd, matrixs_4d9, arrays_4dc, projects_4df);
	_types_438->insert( _types_438->end(), matrixs_4d9.begin(), matrixs_4d9.end());
	_array1_439->insert( _array1_439->end(), arrays_4dc.begin(), arrays_4dc.end());
	_project_43a->insert( _project_43a->end(), projects_4df.begin(), projects_4df.end());
}

void GetArray1_43b::operator()( const Packets_t& typess_43c, const Packets_t& dts_43e, const Packets_t& projects_440, Packets_t& typess_442, Packets_t& dts_443, Packets_t& projectss_444, Packets_t& typess_445, Packets_t& dts_446, Packets_t& projectss_447)
{
#ifdef PRINT_INFO
	printLog("GetArray1_43b" );
#endif
	_types_448= &typess_442;
	_dt_449= &dts_443;
	_projects_44a= &projectss_444;
	_types_44b= &typess_445;
	_dt_44c= &dts_446;
	_projects_44d= &projectss_447;
	for( Packets_t::const_iterator ittypes_44f= typess_43c.begin(), itdt_456= dts_43e.begin(), itproject_45d= projects_440.begin(); ittypes_44f!= typess_43c.end(), itdt_456!= dts_43e.end(), itproject_45d!= projects_440.end(); ++ittypes_44f, ++itdt_456, ++itproject_45d)
	{
		bool isUnique= isInputUnique( *ittypes_44f, *itdt_456, *itproject_45d);
		if( !isUnique)
			continue;
		Packets_t onetypes_453( 1, *ittypes_44f);
		Packets_t onedt_45a( 1, *itdt_456);
		Packets_t oneproject_461( 1, *itproject_45d);
		executeOne( onetypes_453, onedt_45a, oneproject_461);
	}
}

void GetArray1_43b::executeOne( const Packets_t& typess_43c, const Packets_t& dts_43e, const Packets_t& projects_440)
{
	Packets_t matrixs_466;
	Packets_t dTs_469;
	Packets_t projects_46c;
	Array1Exists_463 array1Exists_463;
	bool isMatchArray1Exists_463= array1Exists_463( typess_43c, dts_43e, projects_440, matrixs_466, dTs_469, projects_46c);
	_types_448->insert( _types_448->end(), matrixs_466.begin(), matrixs_466.end());
	_dt_449->insert( _dt_449->end(), dTs_469.begin(), dTs_469.end());
	_projects_44a->insert( _projects_44a->end(), projects_46c.begin(), projects_46c.end());
	if( isMatchArray1Exists_463)
		return;
	Packets_t matrixs_4a4;
	Packets_t dTs_4a7;
	Packets_t projects_4aa;
	Otherwise_4a1 otherwise_4a1;
	bool isMatchOtherwise_4a1= otherwise_4a1( typess_43c, dts_43e, projects_440, matrixs_4a4, dTs_4a7, projects_4aa);
	_types_44b->insert( _types_44b->end(), matrixs_4a4.begin(), matrixs_4a4.end());
	_dt_44c->insert( _dt_44c->end(), dTs_4a7.begin(), dTs_4a7.end());
	_projects_44d->insert( _projects_44d->end(), projects_4aa.begin(), projects_4aa.end());
	if( isMatchOtherwise_4a1)
		return;
}

bool GetArray1_43b::isInputUnique( const Udm::Object& types_450, const Udm::Object& dt_457, const Udm::Object& project_45e)
{
	bool isUnique= true;
	for( Packets_t::const_iterator ittypes_452= _types_44e.begin(), itdt_459= _dt_455.begin(), itproject_460= _project_45c.begin(); ittypes_452!= _types_44e.end(), itdt_459!= _dt_455.end(), itproject_460!= _project_45c.end(); ++ittypes_452, ++itdt_459, ++itproject_460)
	{
		if( ( *ittypes_452== types_450)&& ( *itdt_459== dt_457)&& ( *itproject_460== project_45e))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_types_44e.push_back( types_450);
		_dt_455.push_back( dt_457);
		_project_45c.push_back( project_45e);
	}
	return isUnique;
}

bool Array1Exists_463::operator()( const Packets_t& matrixs_464, const Packets_t& dTs_467, const Packets_t& projects_46a, Packets_t& matrixs_466, Packets_t& dTs_469, Packets_t& projects_46c)
{
#ifdef PRINT_INFO
	printLog("Array1Exists_463" );
#endif
	_matrix_46d= &matrixs_466;
	_dT_46e= &dTs_469;
	_project_46f= &projects_46c;
	processInputPackets( matrixs_464, dTs_467, projects_46a);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Array1Exists_463::isInputUnique( const Udm::Object& matrix_474, const Udm::Object& dT_47d, const Udm::Object& project_486)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_476= _matrix_470.begin(), itDT_47f= _dT_479.begin(), itProject_488= _project_482.begin(); itMatrix_476!= _matrix_470.end(), itDT_47f!= _dT_479.end(), itProject_488!= _project_482.end(); ++itMatrix_476, ++itDT_47f, ++itProject_488)
	{
		if( ( *itMatrix_476== matrix_474)&& ( *itDT_47f== dT_47d)&& ( *itProject_488== project_486))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_470.push_back( matrix_474);
		_dT_479.push_back( dT_47d);
		_project_482.push_back( project_486);
	}
	return isUnique;
}

bool Array1Exists_463::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool Array1Exists_463::isGuardTrue( SFC::Array& Array, SFC::DT& DT, CyPhyML::SignalFlow::SF_Matrix& Matrix, SFC::Project& Project)
{
	bool Gz_guard= false;
	Gz_guard = Matrix.rows() == Array.noelem();;
	return Gz_guard;
}

void Array1Exists_463::processInputPackets( const Packets_t& matrixs_464, const Packets_t& dTs_467, const Packets_t& projects_46a)
{
	for( Packets_t::const_iterator itMatrix_471= matrixs_464.begin(), itDT_47a= dTs_467.begin(), itProject_483= projects_46a.begin(); itMatrix_471!= matrixs_464.end(), itDT_47a!= dTs_467.end(), itProject_483!= projects_46a.end(); ++itMatrix_471, ++itDT_47a, ++itProject_483)
	{
		bool isUnique= isInputUnique( *itMatrix_471, *itDT_47a, *itProject_483);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_471, *itDT_47a, *itProject_483);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.matrix_493, currMatch.dT_494, currMatch.project_495);
	}
}

bool Array1Exists_463::patternMatcher( const Udm::Object& matrix_472, const Udm::Object& dT_47b, const Udm::Object& project_484)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_472.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_477= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_472);
		if( false== Uml::IsDerivedFrom( dT_47b.type(), SFC::DT::meta))
			continue;
		SFC::DT dT_480= SFC::DT::Cast( dT_47b);
		if( false== Uml::IsDerivedFrom( project_484.type(), SFC::Project::meta))
			continue;
		SFC::Project project_489= SFC::Project::Cast( project_484);
		set< SFC::Array> arrays_48b= project_489.Array_kind_children();
		for( set< SFC::Array>::const_iterator itArray_48c= arrays_48b.begin(); itArray_48c!= arrays_48b.end(); ++itArray_48c)
		{
			SFC::Array currArray_48d= *itArray_48c;
			SFC::DT dT_48e= currArray_48d.dt();
			if( !dT_48e)
				continue;
			if( dT_480!= dT_48e)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_492;
			if( !isValidBound(boundObjs_492, matrix_477, true))
				continue;
			currMatch.matrix_493= matrix_477;
			if( !isValidBound(boundObjs_492, dT_480, true))
				continue;
			currMatch.dT_494= dT_480;
			if( !isValidBound(boundObjs_492, project_489, true))
				continue;
			currMatch.project_495= project_489;
			if( !isValidBound(boundObjs_492, currArray_48d, false))
				continue;
			currMatch.array_496= currArray_48d;
			bool Gz_guard= isGuardTrue( currMatch.array_496, currMatch.dT_494, currMatch.matrix_493, currMatch.project_495);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void Array1Exists_463::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_49b, const SFC::DT& dT_49d, const SFC::Project& project_49f)
{
	_matrix_46d->push_back( matrix_49b);
	_dT_46e->push_back( dT_49d);
	_project_46f->push_back( project_49f);
}

bool Otherwise_4a1::operator()( const Packets_t& matrixs_4a2, const Packets_t& dTs_4a5, const Packets_t& projects_4a8, Packets_t& matrixs_4a4, Packets_t& dTs_4a7, Packets_t& projects_4aa)
{
#ifdef PRINT_INFO
	printLog("Otherwise_4a1" );
#endif
	_matrix_4ab= &matrixs_4a4;
	_dT_4ac= &dTs_4a7;
	_project_4ad= &projects_4aa;
	processInputPackets( matrixs_4a2, dTs_4a5, projects_4a8);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_4a1::isInputUnique( const Udm::Object& matrix_4b2, const Udm::Object& dT_4bb, const Udm::Object& project_4c4)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_4b4= _matrix_4ae.begin(), itDT_4bd= _dT_4b7.begin(), itProject_4c6= _project_4c0.begin(); itMatrix_4b4!= _matrix_4ae.end(), itDT_4bd!= _dT_4b7.end(), itProject_4c6!= _project_4c0.end(); ++itMatrix_4b4, ++itDT_4bd, ++itProject_4c6)
	{
		if( ( *itMatrix_4b4== matrix_4b2)&& ( *itDT_4bd== dT_4bb)&& ( *itProject_4c6== project_4c4))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_4ae.push_back( matrix_4b2);
		_dT_4b7.push_back( dT_4bb);
		_project_4c0.push_back( project_4c4);
	}
	return isUnique;
}

bool Otherwise_4a1::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_4a1::processInputPackets( const Packets_t& matrixs_4a2, const Packets_t& dTs_4a5, const Packets_t& projects_4a8)
{
	for( Packets_t::const_iterator itMatrix_4af= matrixs_4a2.begin(), itDT_4b8= dTs_4a5.begin(), itProject_4c1= projects_4a8.begin(); itMatrix_4af!= matrixs_4a2.end(), itDT_4b8!= dTs_4a5.end(), itProject_4c1!= projects_4a8.end(); ++itMatrix_4af, ++itDT_4b8, ++itProject_4c1)
	{
		bool isUnique= isInputUnique( *itMatrix_4af, *itDT_4b8, *itProject_4c1);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_4af, *itDT_4b8, *itProject_4c1);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.matrix_4cd, currMatch.dT_4ce, currMatch.project_4cf);
	}
}

bool Otherwise_4a1::patternMatcher( const Udm::Object& matrix_4b0, const Udm::Object& dT_4b9, const Udm::Object& project_4c2)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_4b0.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_4b5= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_4b0);
		if( false== Uml::IsDerivedFrom( dT_4b9.type(), SFC::DT::meta))
			continue;
		SFC::DT dT_4be= SFC::DT::Cast( dT_4b9);
		if( false== Uml::IsDerivedFrom( project_4c2.type(), SFC::Project::meta))
			continue;
		SFC::Project project_4c7= SFC::Project::Cast( project_4c2);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_4cc;
		if( !isValidBound(boundObjs_4cc, matrix_4b5, true))
			continue;
		currMatch.matrix_4cd= matrix_4b5;
		if( !isValidBound(boundObjs_4cc, dT_4be, true))
			continue;
		currMatch.dT_4ce= dT_4be;
		if( !isValidBound(boundObjs_4cc, project_4c7, true))
			continue;
		currMatch.project_4cf= project_4c7;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_4a1::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_4d0, const SFC::DT& dT_4d2, const SFC::Project& project_4d4)
{
	_matrix_4ab->push_back( matrix_4d0);
	_dT_4ac->push_back( dT_4d2);
	_project_4ad->push_back( project_4d4);
}

void UseArray1_4d6::operator()( const Packets_t& matrixs_4d7, const Packets_t& dTs_4da, const Packets_t& projects_4dd, Packets_t& matrixs_4d9, Packets_t& arrays_4dc, Packets_t& projects_4df)
{
#ifdef PRINT_INFO
	printLog("UseArray1_4d6" );
#endif
	RTTGenerator::Instance()->generateRule(198, "UseArray1");
	_matrix_4e0= &matrixs_4d9;
	_array_4e1= &arrays_4dc;
	_project_4e2= &projects_4df;
	processInputPackets( matrixs_4d7, dTs_4da, projects_4dd);
}

bool UseArray1_4d6::isInputUnique( const Udm::Object& matrix_4e7, const Udm::Object& dT_4f0, const Udm::Object& project_4f9)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_4e9= _matrix_4e3.begin(), itDT_4f2= _dT_4ec.begin(), itProject_4fb= _project_4f5.begin(); itMatrix_4e9!= _matrix_4e3.end(), itDT_4f2!= _dT_4ec.end(), itProject_4fb!= _project_4f5.end(); ++itMatrix_4e9, ++itDT_4f2, ++itProject_4fb)
	{
		if( ( *itMatrix_4e9== matrix_4e7)&& ( *itDT_4f2== dT_4f0)&& ( *itProject_4fb== project_4f9))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_4e3.push_back( matrix_4e7);
		_dT_4ec.push_back( dT_4f0);
		_project_4f5.push_back( project_4f9);
	}
	return isUnique;
}

bool UseArray1_4d6::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool UseArray1_4d6::isGuardTrue( SFC::Array& Array, SFC::DT& DT, CyPhyML::SignalFlow::SF_Matrix& Matrix, SFC::Project& Project)
{
	bool Gz_guard= false;
	Gz_guard = Matrix.rows() == Array.noelem();;
	return Gz_guard;
}

void UseArray1_4d6::processInputPackets( const Packets_t& matrixs_4d7, const Packets_t& dTs_4da, const Packets_t& projects_4dd)
{
	for( Packets_t::const_iterator itMatrix_4e4= matrixs_4d7.begin(), itDT_4ed= dTs_4da.begin(), itProject_4f6= projects_4dd.begin(); itMatrix_4e4!= matrixs_4d7.end(), itDT_4ed!= dTs_4da.end(), itProject_4f6!= projects_4dd.end(); ++itMatrix_4e4, ++itDT_4ed, ++itProject_4f6)
	{
		bool isUnique= isInputUnique( *itMatrix_4e4, *itDT_4ed, *itProject_4f6);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_4e4, *itDT_4ed, *itProject_4f6);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool UseArray1_4d6::patternMatcher( const Udm::Object& matrix_4e5, const Udm::Object& dT_4ee, const Udm::Object& project_4f7)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_4e5.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_4ea= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_4e5);
		if( false== Uml::IsDerivedFrom( dT_4ee.type(), SFC::DT::meta))
			continue;
		SFC::DT dT_4f3= SFC::DT::Cast( dT_4ee);
		if( false== Uml::IsDerivedFrom( project_4f7.type(), SFC::Project::meta))
			continue;
		SFC::Project project_4fc= SFC::Project::Cast( project_4f7);
		set< SFC::Array> arrays_4fe= project_4fc.Array_kind_children();
		for( set< SFC::Array>::const_iterator itArray_4ff= arrays_4fe.begin(); itArray_4ff!= arrays_4fe.end(); ++itArray_4ff)
		{
			SFC::Array currArray_500= *itArray_4ff;
			SFC::DT dT_501= currArray_500.dt();
			if( !dT_501)
				continue;
			if( dT_4f3!= dT_501)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_505;
			if( !isValidBound(boundObjs_505, matrix_4ea, true))
				continue;
			currMatch.matrix_506= matrix_4ea;
			if( !isValidBound(boundObjs_505, dT_4f3, true))
				continue;
			currMatch.dT_507= dT_4f3;
			if( !isValidBound(boundObjs_505, project_4fc, true))
				continue;
			currMatch.project_508= project_4fc;
			if( !isValidBound(boundObjs_505, currArray_500, false))
				continue;
			currMatch.array_509= currArray_500;
			bool Gz_guard= isGuardTrue( currMatch.array_509, currMatch.dT_507, currMatch.matrix_506, currMatch.project_508);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void UseArray1_4d6::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.matrix_506, currMatch.array_509, currMatch.project_508);
	}
}

void UseArray1_4d6::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_50e, const SFC::Array& array_510, const SFC::Project& project_512)
{
	_matrix_4e0->push_back( matrix_50e);
	_array_4e1->push_back( array_510);
	_project_4e2->push_back( project_512);
}

void CreateArray1_514::operator()( const Packets_t& matrixs_515, const Packets_t& dTs_518, const Packets_t& projects_51b, Packets_t& matrixs_517, Packets_t& arrays_51a, Packets_t& projects_51d)
{
#ifdef PRINT_INFO
	printLog("CreateArray1_514" );
#endif
	RTTGenerator::Instance()->generateRule(205, "CreateArray1");
	_matrix_51e= &matrixs_517;
	_array_51f= &arrays_51a;
	_project_520= &projects_51d;
	processInputPackets( matrixs_515, dTs_518, projects_51b);
}

bool CreateArray1_514::isInputUnique( const Udm::Object& matrix_525, const Udm::Object& dT_52e, const Udm::Object& project_537)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_527= _matrix_521.begin(), itDT_530= _dT_52a.begin(), itProject_539= _project_533.begin(); itMatrix_527!= _matrix_521.end(), itDT_530!= _dT_52a.end(), itProject_539!= _project_533.end(); ++itMatrix_527, ++itDT_530, ++itProject_539)
	{
		if( ( *itMatrix_527== matrix_525)&& ( *itDT_530== dT_52e)&& ( *itProject_539== project_537))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_521.push_back( matrix_525);
		_dT_52a.push_back( dT_52e);
		_project_533.push_back( project_537);
	}
	return isUnique;
}

bool CreateArray1_514::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateArray1_514::processInputPackets( const Packets_t& matrixs_515, const Packets_t& dTs_518, const Packets_t& projects_51b)
{
	for( Packets_t::const_iterator itMatrix_522= matrixs_515.begin(), itDT_52b= dTs_518.begin(), itProject_534= projects_51b.begin(); itMatrix_522!= matrixs_515.end(), itDT_52b!= dTs_518.end(), itProject_534!= projects_51b.end(); ++itMatrix_522, ++itDT_52b, ++itProject_534)
	{
		bool isUnique= isInputUnique( *itMatrix_522, *itDT_52b, *itProject_534);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_522, *itDT_52b, *itProject_534);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateArray1_514::patternMatcher( const Udm::Object& matrix_523, const Udm::Object& dT_52c, const Udm::Object& project_535)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_523.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_528= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_523);
		if( false== Uml::IsDerivedFrom( dT_52c.type(), SFC::DT::meta))
			continue;
		SFC::DT dT_531= SFC::DT::Cast( dT_52c);
		if( false== Uml::IsDerivedFrom( project_535.type(), SFC::Project::meta))
			continue;
		SFC::Project project_53a= SFC::Project::Cast( project_535);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_53f;
		if( !isValidBound(boundObjs_53f, matrix_528, true))
			continue;
		currMatch.matrix_540= matrix_528;
		if( !isValidBound(boundObjs_53f, dT_531, true))
			continue;
		currMatch.dT_541= dT_531;
		if( !isValidBound(boundObjs_53f, project_53a, true))
			continue;
		currMatch.project_542= project_53a;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateArray1_514::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Array newArray_543= SFC::Array::Create( currMatch.project_542);
		SFC::Array& Array= newArray_543;
		SFC::DT& DT= currMatch.dT_541;
		CyPhyML::SignalFlow::SF_Matrix& Matrix= currMatch.matrix_540;
		SFC::Project& Project= currMatch.project_542;
		{
__int64 statementCount = Project.statementCount();
Array.statementIndex() = statementCount++;
Project.statementCount() = statementCount;

Array.noelem() = Matrix.rows();

};
		newArray_543.dt()= currMatch.dT_541;
		outputAppender( currMatch.matrix_540, newArray_543, currMatch.project_542);
	}
}

void CreateArray1_514::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_544, const SFC::Array& array_546, const SFC::Project& project_548)
{
	_matrix_51e->push_back( matrix_544);
	_array_51f->push_back( array_546);
	_project_520->push_back( project_548);
}

void ProcessColumn_55d::operator()( const Packets_t& typess_55e, const Packets_t& projects_560, Packets_t& typess_562, Packets_t& array1s_563, Packets_t& projects_564)
{
#ifdef PRINT_INFO
	printLog("ProcessColumn_55d" );
#endif
	_types_565= &typess_562;
	_array1_566= &array1s_563;
	_project_567= &projects_564;
	if( ( !typess_55e.empty())&& ( !projects_560.empty()))
		callProcessScalar_568( typess_55e, projects_560);
}

void ProcessColumn_55d::callProcessScalar_568( const Packets_t& typess_34e, const Packets_t& projects_350)
{
	Packets_t typess_352;
	Packets_t basictypes_353;
	Packets_t projects_354;
	ProcessScalar_34d processScalar_34d;
	processScalar_34d( typess_34e, projects_350, typess_352, basictypes_353, projects_354);
	if( ( !typess_352.empty())&& ( !basictypes_353.empty())&& ( !projects_354.empty()))
		callProcessArray1_56b( typess_352, basictypes_353, projects_354);
}

void ProcessColumn_55d::callProcessArray1_56b( const Packets_t& typess_42f, const Packets_t& basictypes_431, const Packets_t& projects_433)
{
	Packets_t typess_435;
	Packets_t array1s_436;
	Packets_t projects_437;
	ProcessArray1_42e processArray1_42e;
	processArray1_42e( typess_42f, basictypes_431, projects_433, typess_435, array1s_436, projects_437);
	_types_565->insert( _types_565->end(), typess_435.begin(), typess_435.end());
	_array1_566->insert( _array1_566->end(), array1s_436.begin(), array1s_436.end());
	_project_567->insert( _project_567->end(), projects_437.begin(), projects_437.end());
}

void DimensionTest_56f::operator()( const Packets_t& typess_570, const Packets_t& projects_572, Packets_t& typess_574, Packets_t& projects_575, Packets_t& typess_576, Packets_t& projects_577, Packets_t& typess_578, Packets_t& projects_579)
{
#ifdef PRINT_INFO
	printLog("DimensionTest_56f" );
#endif
	_types_57a= &typess_574;
	_project_57b= &projects_575;
	_types_57c= &typess_576;
	_project_57d= &projects_577;
	_types_57e= &typess_578;
	_project_57f= &projects_579;
	for( Packets_t::const_iterator ittypes_581= typess_570.begin(), itproject_588= projects_572.begin(); ittypes_581!= typess_570.end(), itproject_588!= projects_572.end(); ++ittypes_581, ++itproject_588)
	{
		bool isUnique= isInputUnique( *ittypes_581, *itproject_588);
		if( !isUnique)
			continue;
		Packets_t onetypes_585( 1, *ittypes_581);
		Packets_t oneproject_58c( 1, *itproject_588);
		executeOne( onetypes_585, oneproject_58c);
	}
}

void DimensionTest_56f::executeOne( const Packets_t& typess_570, const Packets_t& projects_572)
{
	Packets_t matrixs_591;
	Packets_t projects_594;
	Scalar_58e scalar_58e;
	bool isMatchScalar_58e= scalar_58e( typess_570, projects_572, matrixs_591, projects_594);
	_types_57a->insert( _types_57a->end(), matrixs_591.begin(), matrixs_591.end());
	_project_57b->insert( _project_57b->end(), projects_594.begin(), projects_594.end());
	if( isMatchScalar_58e)
		return;
	Packets_t matrixs_5b8;
	Packets_t projects_5bb;
	ColumnVector_5b5 columnVector_5b5;
	bool isMatchColumnVector_5b5= columnVector_5b5( typess_570, projects_572, matrixs_5b8, projects_5bb);
	_types_57c->insert( _types_57c->end(), matrixs_5b8.begin(), matrixs_5b8.end());
	_project_57d->insert( _project_57d->end(), projects_5bb.begin(), projects_5bb.end());
	if( isMatchColumnVector_5b5)
		return;
	Packets_t matrixs_5df;
	Packets_t projects_5e2;
	Other_5dc other_5dc;
	bool isMatchOther_5dc= other_5dc( typess_570, projects_572, matrixs_5df, projects_5e2);
	_types_57e->insert( _types_57e->end(), matrixs_5df.begin(), matrixs_5df.end());
	_project_57f->insert( _project_57f->end(), projects_5e2.begin(), projects_5e2.end());
	if( isMatchOther_5dc)
		return;
}

bool DimensionTest_56f::isInputUnique( const Udm::Object& types_582, const Udm::Object& project_589)
{
	bool isUnique= true;
	for( Packets_t::const_iterator ittypes_584= _types_580.begin(), itproject_58b= _project_587.begin(); ittypes_584!= _types_580.end(), itproject_58b!= _project_587.end(); ++ittypes_584, ++itproject_58b)
	{
		if( ( *ittypes_584== types_582)&& ( *itproject_58b== project_589))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_types_580.push_back( types_582);
		_project_587.push_back( project_589);
	}
	return isUnique;
}

bool Scalar_58e::operator()( const Packets_t& matrixs_58f, const Packets_t& projects_592, Packets_t& matrixs_591, Packets_t& projects_594)
{
#ifdef PRINT_INFO
	printLog("Scalar_58e" );
#endif
	_matrix_595= &matrixs_591;
	_project_596= &projects_594;
	processInputPackets( matrixs_58f, projects_592);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Scalar_58e::isInputUnique( const Udm::Object& matrix_59b, const Udm::Object& project_5a4)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_59d= _matrix_597.begin(), itProject_5a6= _project_5a0.begin(); itMatrix_59d!= _matrix_597.end(), itProject_5a6!= _project_5a0.end(); ++itMatrix_59d, ++itProject_5a6)
	{
		if( ( *itMatrix_59d== matrix_59b)&& ( *itProject_5a6== project_5a4))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_597.push_back( matrix_59b);
		_project_5a0.push_back( project_5a4);
	}
	return isUnique;
}

bool Scalar_58e::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool Scalar_58e::isGuardTrue( CyPhyML::SignalFlow::SF_Matrix& Matrix, SFC::Project& Project)
{
	bool Gz_guard= false;
	Gz_guard = Matrix.rows() == 1 && Matrix.columns() == 1;;
	return Gz_guard;
}

void Scalar_58e::processInputPackets( const Packets_t& matrixs_58f, const Packets_t& projects_592)
{
	for( Packets_t::const_iterator itMatrix_598= matrixs_58f.begin(), itProject_5a1= projects_592.begin(); itMatrix_598!= matrixs_58f.end(), itProject_5a1!= projects_592.end(); ++itMatrix_598, ++itProject_5a1)
	{
		bool isUnique= isInputUnique( *itMatrix_598, *itProject_5a1);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_598, *itProject_5a1);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.matrix_5ad, currMatch.project_5ae);
	}
}

bool Scalar_58e::patternMatcher( const Udm::Object& matrix_599, const Udm::Object& project_5a2)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_599.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_59e= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_599);
		if( false== Uml::IsDerivedFrom( project_5a2.type(), SFC::Project::meta))
			continue;
		SFC::Project project_5a7= SFC::Project::Cast( project_5a2);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_5ac;
		if( !isValidBound(boundObjs_5ac, matrix_59e, true))
			continue;
		currMatch.matrix_5ad= matrix_59e;
		if( !isValidBound(boundObjs_5ac, project_5a7, true))
			continue;
		currMatch.project_5ae= project_5a7;
		bool Gz_guard= isGuardTrue( currMatch.matrix_5ad, currMatch.project_5ae);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Scalar_58e::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_5b1, const SFC::Project& project_5b3)
{
	_matrix_595->push_back( matrix_5b1);
	_project_596->push_back( project_5b3);
}

bool ColumnVector_5b5::operator()( const Packets_t& matrixs_5b6, const Packets_t& projects_5b9, Packets_t& matrixs_5b8, Packets_t& projects_5bb)
{
#ifdef PRINT_INFO
	printLog("ColumnVector_5b5" );
#endif
	_matrix_5bc= &matrixs_5b8;
	_project_5bd= &projects_5bb;
	processInputPackets( matrixs_5b6, projects_5b9);
	if( false== _matches.empty())
		return true;
	return false;
}

bool ColumnVector_5b5::isInputUnique( const Udm::Object& matrix_5c2, const Udm::Object& project_5cb)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_5c4= _matrix_5be.begin(), itProject_5cd= _project_5c7.begin(); itMatrix_5c4!= _matrix_5be.end(), itProject_5cd!= _project_5c7.end(); ++itMatrix_5c4, ++itProject_5cd)
	{
		if( ( *itMatrix_5c4== matrix_5c2)&& ( *itProject_5cd== project_5cb))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_5be.push_back( matrix_5c2);
		_project_5c7.push_back( project_5cb);
	}
	return isUnique;
}

bool ColumnVector_5b5::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool ColumnVector_5b5::isGuardTrue( CyPhyML::SignalFlow::SF_Matrix& Matrix, SFC::Project& Project)
{
	bool Gz_guard= false;
	Gz_guard = Matrix.rows() != 1 && Matrix.columns() == 1;;
	return Gz_guard;
}

void ColumnVector_5b5::processInputPackets( const Packets_t& matrixs_5b6, const Packets_t& projects_5b9)
{
	for( Packets_t::const_iterator itMatrix_5bf= matrixs_5b6.begin(), itProject_5c8= projects_5b9.begin(); itMatrix_5bf!= matrixs_5b6.end(), itProject_5c8!= projects_5b9.end(); ++itMatrix_5bf, ++itProject_5c8)
	{
		bool isUnique= isInputUnique( *itMatrix_5bf, *itProject_5c8);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_5bf, *itProject_5c8);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.matrix_5d4, currMatch.project_5d5);
	}
}

bool ColumnVector_5b5::patternMatcher( const Udm::Object& matrix_5c0, const Udm::Object& project_5c9)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_5c0.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_5c5= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_5c0);
		if( false== Uml::IsDerivedFrom( project_5c9.type(), SFC::Project::meta))
			continue;
		SFC::Project project_5ce= SFC::Project::Cast( project_5c9);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_5d3;
		if( !isValidBound(boundObjs_5d3, matrix_5c5, true))
			continue;
		currMatch.matrix_5d4= matrix_5c5;
		if( !isValidBound(boundObjs_5d3, project_5ce, true))
			continue;
		currMatch.project_5d5= project_5ce;
		bool Gz_guard= isGuardTrue( currMatch.matrix_5d4, currMatch.project_5d5);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void ColumnVector_5b5::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_5d8, const SFC::Project& project_5da)
{
	_matrix_5bc->push_back( matrix_5d8);
	_project_5bd->push_back( project_5da);
}

bool Other_5dc::operator()( const Packets_t& matrixs_5dd, const Packets_t& projects_5e0, Packets_t& matrixs_5df, Packets_t& projects_5e2)
{
#ifdef PRINT_INFO
	printLog("Other_5dc" );
#endif
	_matrix_5e3= &matrixs_5df;
	_project_5e4= &projects_5e2;
	processInputPackets( matrixs_5dd, projects_5e0);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Other_5dc::isInputUnique( const Udm::Object& matrix_5e9, const Udm::Object& project_5f2)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_5eb= _matrix_5e5.begin(), itProject_5f4= _project_5ee.begin(); itMatrix_5eb!= _matrix_5e5.end(), itProject_5f4!= _project_5ee.end(); ++itMatrix_5eb, ++itProject_5f4)
	{
		if( ( *itMatrix_5eb== matrix_5e9)&& ( *itProject_5f4== project_5f2))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_5e5.push_back( matrix_5e9);
		_project_5ee.push_back( project_5f2);
	}
	return isUnique;
}

bool Other_5dc::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Other_5dc::processInputPackets( const Packets_t& matrixs_5dd, const Packets_t& projects_5e0)
{
	for( Packets_t::const_iterator itMatrix_5e6= matrixs_5dd.begin(), itProject_5ef= projects_5e0.begin(); itMatrix_5e6!= matrixs_5dd.end(), itProject_5ef!= projects_5e0.end(); ++itMatrix_5e6, ++itProject_5ef)
	{
		bool isUnique= isInputUnique( *itMatrix_5e6, *itProject_5ef);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_5e6, *itProject_5ef);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.matrix_5fb, currMatch.project_5fc);
	}
}

bool Other_5dc::patternMatcher( const Udm::Object& matrix_5e7, const Udm::Object& project_5f0)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_5e7.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_5ec= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_5e7);
		if( false== Uml::IsDerivedFrom( project_5f0.type(), SFC::Project::meta))
			continue;
		SFC::Project project_5f5= SFC::Project::Cast( project_5f0);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_5fa;
		if( !isValidBound(boundObjs_5fa, matrix_5ec, true))
			continue;
		currMatch.matrix_5fb= matrix_5ec;
		if( !isValidBound(boundObjs_5fa, project_5f5, true))
			continue;
		currMatch.project_5fc= project_5f5;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Other_5dc::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_5fd, const SFC::Project& project_5ff)
{
	_matrix_5e3->push_back( matrix_5fd);
	_project_5e4->push_back( project_5ff);
}

void StructOrMatrix_613::operator()( const Packets_t& typess_614, const Packets_t& projects_616, Packets_t& typess_618, Packets_t& projects_619, Packets_t& typess_61a, Packets_t& projects_61b)
{
#ifdef PRINT_INFO
	printLog("StructOrMatrix_613" );
#endif
	_types_61c= &typess_618;
	_project_61d= &projects_619;
	_types_61e= &typess_61a;
	_project_61f= &projects_61b;
	for( Packets_t::const_iterator ittypes_621= typess_614.begin(), itproject_628= projects_616.begin(); ittypes_621!= typess_614.end(), itproject_628!= projects_616.end(); ++ittypes_621, ++itproject_628)
	{
		bool isUnique= isInputUnique( *ittypes_621, *itproject_628);
		if( !isUnique)
			continue;
		Packets_t onetypes_625( 1, *ittypes_621);
		Packets_t oneproject_62c( 1, *itproject_628);
		executeOne( onetypes_625, oneproject_62c);
	}
}

void StructOrMatrix_613::executeOne( const Packets_t& typess_614, const Packets_t& projects_616)
{
	Packets_t typeStructs_631;
	Packets_t projects_634;
	IsStruct_62e isStruct_62e;
	bool isMatchIsStruct_62e= isStruct_62e( typess_614, projects_616, typeStructs_631, projects_634);
	_types_61c->insert( _types_61c->end(), typeStructs_631.begin(), typeStructs_631.end());
	_project_61d->insert( _project_61d->end(), projects_634.begin(), projects_634.end());
	Packets_t matrixs_656;
	Packets_t projects_659;
	IsMatrix_653 isMatrix_653;
	bool isMatchIsMatrix_653= isMatrix_653( typess_614, projects_616, matrixs_656, projects_659);
	_types_61e->insert( _types_61e->end(), matrixs_656.begin(), matrixs_656.end());
	_project_61f->insert( _project_61f->end(), projects_659.begin(), projects_659.end());
}

bool StructOrMatrix_613::isInputUnique( const Udm::Object& types_622, const Udm::Object& project_629)
{
	bool isUnique= true;
	for( Packets_t::const_iterator ittypes_624= _types_620.begin(), itproject_62b= _project_627.begin(); ittypes_624!= _types_620.end(), itproject_62b!= _project_627.end(); ++ittypes_624, ++itproject_62b)
	{
		if( ( *ittypes_624== types_622)&& ( *itproject_62b== project_629))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_types_620.push_back( types_622);
		_project_627.push_back( project_629);
	}
	return isUnique;
}

bool IsStruct_62e::operator()( const Packets_t& typeStructs_62f, const Packets_t& projects_632, Packets_t& typeStructs_631, Packets_t& projects_634)
{
#ifdef PRINT_INFO
	printLog("IsStruct_62e" );
#endif
	_typeStruct_635= &typeStructs_631;
	_project_636= &projects_634;
	processInputPackets( typeStructs_62f, projects_632);
	if( false== _matches.empty())
		return true;
	return false;
}

bool IsStruct_62e::isInputUnique( const Udm::Object& typeStruct_63b, const Udm::Object& project_644)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itTypeStruct_63d= _typeStruct_637.begin(), itProject_646= _project_640.begin(); itTypeStruct_63d!= _typeStruct_637.end(), itProject_646!= _project_640.end(); ++itTypeStruct_63d, ++itProject_646)
	{
		if( ( *itTypeStruct_63d== typeStruct_63b)&& ( *itProject_646== project_644))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_typeStruct_637.push_back( typeStruct_63b);
		_project_640.push_back( project_644);
	}
	return isUnique;
}

bool IsStruct_62e::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void IsStruct_62e::processInputPackets( const Packets_t& typeStructs_62f, const Packets_t& projects_632)
{
	for( Packets_t::const_iterator itTypeStruct_638= typeStructs_62f.begin(), itProject_641= projects_632.begin(); itTypeStruct_638!= typeStructs_62f.end(), itProject_641!= projects_632.end(); ++itTypeStruct_638, ++itProject_641)
	{
		bool isUnique= isInputUnique( *itTypeStruct_638, *itProject_641);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itTypeStruct_638, *itProject_641);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.typeStruct_64d, currMatch.project_64e);
	}
}

bool IsStruct_62e::patternMatcher( const Udm::Object& typeStruct_639, const Udm::Object& project_642)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( typeStruct_639.type(), CyPhyML::SignalFlow::TypeStruct::meta))
			continue;
		CyPhyML::SignalFlow::TypeStruct typeStruct_63e= CyPhyML::SignalFlow::TypeStruct::Cast( typeStruct_639);
		if( false== Uml::IsDerivedFrom( project_642.type(), SFC::Project::meta))
			continue;
		SFC::Project project_647= SFC::Project::Cast( project_642);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_64c;
		if( !isValidBound(boundObjs_64c, typeStruct_63e, true))
			continue;
		currMatch.typeStruct_64d= typeStruct_63e;
		if( !isValidBound(boundObjs_64c, project_647, true))
			continue;
		currMatch.project_64e= project_647;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void IsStruct_62e::outputAppender( const CyPhyML::SignalFlow::TypeStruct& typeStruct_64f, const SFC::Project& project_651)
{
	_typeStruct_635->push_back( typeStruct_64f);
	_project_636->push_back( project_651);
}

bool IsMatrix_653::operator()( const Packets_t& matrixs_654, const Packets_t& projects_657, Packets_t& matrixs_656, Packets_t& projects_659)
{
#ifdef PRINT_INFO
	printLog("IsMatrix_653" );
#endif
	_matrix_65a= &matrixs_656;
	_project_65b= &projects_659;
	processInputPackets( matrixs_654, projects_657);
	if( false== _matches.empty())
		return true;
	return false;
}

bool IsMatrix_653::isInputUnique( const Udm::Object& matrix_660, const Udm::Object& project_669)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMatrix_662= _matrix_65c.begin(), itProject_66b= _project_665.begin(); itMatrix_662!= _matrix_65c.end(), itProject_66b!= _project_665.end(); ++itMatrix_662, ++itProject_66b)
	{
		if( ( *itMatrix_662== matrix_660)&& ( *itProject_66b== project_669))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_matrix_65c.push_back( matrix_660);
		_project_665.push_back( project_669);
	}
	return isUnique;
}

bool IsMatrix_653::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void IsMatrix_653::processInputPackets( const Packets_t& matrixs_654, const Packets_t& projects_657)
{
	for( Packets_t::const_iterator itMatrix_65d= matrixs_654.begin(), itProject_666= projects_657.begin(); itMatrix_65d!= matrixs_654.end(), itProject_666!= projects_657.end(); ++itMatrix_65d, ++itProject_666)
	{
		bool isUnique= isInputUnique( *itMatrix_65d, *itProject_666);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMatrix_65d, *itProject_666);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.matrix_672, currMatch.project_673);
	}
}

bool IsMatrix_653::patternMatcher( const Udm::Object& matrix_65e, const Udm::Object& project_667)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( matrix_65e.type(), CyPhyML::SignalFlow::SF_Matrix::meta))
			continue;
		CyPhyML::SignalFlow::SF_Matrix matrix_663= CyPhyML::SignalFlow::SF_Matrix::Cast( matrix_65e);
		if( false== Uml::IsDerivedFrom( project_667.type(), SFC::Project::meta))
			continue;
		SFC::Project project_66c= SFC::Project::Cast( project_667);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_671;
		if( !isValidBound(boundObjs_671, matrix_663, true))
			continue;
		currMatch.matrix_672= matrix_663;
		if( !isValidBound(boundObjs_671, project_66c, true))
			continue;
		currMatch.project_673= project_66c;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void IsMatrix_653::outputAppender( const CyPhyML::SignalFlow::SF_Matrix& matrix_674, const SFC::Project& project_676)
{
	_matrix_65a->push_back( matrix_674);
	_project_65b->push_back( project_676);
}

void CreateStructType_678::operator()( const Packets_t& eSMoL_Structs_679, const Packets_t& projects_67d, Packets_t& eSMoL_Structs_67b, Packets_t& sfc_Structs_67c)
{
#ifdef PRINT_INFO
	printLog("CreateStructType_678" );
#endif
	RTTGenerator::Instance()->generateRule(276, "CreateStructType");
	_eSMoL_Struct_67f= &eSMoL_Structs_67b;
	_sfc_Struct_680= &sfc_Structs_67c;
	processInputPackets( eSMoL_Structs_679, projects_67d);
}

bool CreateStructType_678::isInputUnique( const Udm::Object& eSMoL_Struct_685, const Udm::Object& project_68e)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itESMoL_Struct_687= _eSMoL_Struct_681.begin(), itProject_690= _project_68a.begin(); itESMoL_Struct_687!= _eSMoL_Struct_681.end(), itProject_690!= _project_68a.end(); ++itESMoL_Struct_687, ++itProject_690)
	{
		if( ( *itESMoL_Struct_687== eSMoL_Struct_685)&& ( *itProject_690== project_68e))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_eSMoL_Struct_681.push_back( eSMoL_Struct_685);
		_project_68a.push_back( project_68e);
	}
	return isUnique;
}

bool CreateStructType_678::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateStructType_678::processInputPackets( const Packets_t& eSMoL_Structs_679, const Packets_t& projects_67d)
{
	for( Packets_t::const_iterator itESMoL_Struct_682= eSMoL_Structs_679.begin(), itProject_68b= projects_67d.begin(); itESMoL_Struct_682!= eSMoL_Structs_679.end(), itProject_68b!= projects_67d.end(); ++itESMoL_Struct_682, ++itProject_68b)
	{
		bool isUnique= isInputUnique( *itESMoL_Struct_682, *itProject_68b);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itESMoL_Struct_682, *itProject_68b);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateStructType_678::patternMatcher( const Udm::Object& eSMoL_Struct_683, const Udm::Object& project_68c)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( eSMoL_Struct_683.type(), CyPhyML::SignalFlow::TypeStruct::meta))
			continue;
		CyPhyML::SignalFlow::TypeStruct eSMoL_Struct_688= CyPhyML::SignalFlow::TypeStruct::Cast( eSMoL_Struct_683);
		if( false== Uml::IsDerivedFrom( project_68c.type(), SFC::Project::meta))
			continue;
		SFC::Project project_691= SFC::Project::Cast( project_68c);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_696;
		if( !isValidBound(boundObjs_696, eSMoL_Struct_688, true))
			continue;
		currMatch.eSMoL_Struct_697= eSMoL_Struct_688;
		if( !isValidBound(boundObjs_696, project_691, true))
			continue;
		currMatch.project_698= project_691;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateStructType_678::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Struct newsfc_Struct_699= SFC::Struct::Create( currMatch.project_698, SFC::Project::meta_stmnt);
		CyPhyML::SignalFlow::TypeStruct& ESMoL_Struct= currMatch.eSMoL_Struct_697;
		SFC::Project& Project= currMatch.project_698;
		SFC::Struct& sfc_Struct= newsfc_Struct_699;
		{
sfc_Struct.memberCount() = ESMoL_Struct.MemberCount();
sfc_Struct.name() = ESMoL_Struct.name();
};
		{
__int64 sc = Project.statementCount();
sfc_Struct.statementIndex() = sc++;
Project.statementCount() = sc;
};
		newsfc_Struct_699.tb()+= currMatch.eSMoL_Struct_697;
		outputAppender( currMatch.eSMoL_Struct_697, newsfc_Struct_699);
	}
}

void CreateStructType_678::outputAppender( const CyPhyML::SignalFlow::TypeStruct& eSMoL_Struct_69a, const SFC::Struct& sfc_Struct_69c)
{
	_eSMoL_Struct_67f->push_back( eSMoL_Struct_69a);
	_sfc_Struct_680->push_back( sfc_Struct_69c);
}

void MergeClasses_6b2::operator()( const Packets_t& dataflows_6b3, const Packets_t& projects_6b5, Packets_t& dataflows_6b7, Packets_t& projects_6b8)
{
#ifdef PRINT_INFO
	printLog("MergeClasses_6b2" );
#endif
	_dataflow_6b9= &dataflows_6b7;
	_project_6ba= &projects_6b8;
	if( ( !projects_6b5.empty()))
		callMergeClasses_d90( projects_6b5);
	_dataflow_6b9->insert( _dataflow_6b9->end(), dataflows_6b3.begin(), dataflows_6b3.end());
	_project_6ba->insert( _project_6ba->end(), projects_6b5.begin(), projects_6b5.end());
}

void MergeClasses_6b2::callMergeClasses_d90( const Packets_t& projects_717)
{
	Packets_t projects_719;
	MergeClasses_716 mergeClasses_716;
	mergeClasses_716( projects_717, projects_719);
	if( ( !projects_719.empty()))
		callElimRedundantClasses_d92( projects_719);
}

void MergeClasses_6b2::callElimRedundantClasses_d92( const Packets_t& projects_6bc)
{
	Packets_t projects_6be;
	ElimRedundantClasses_6bb elimRedundantClasses_6bb;
	elimRedundantClasses_6bb( projects_6bc, projects_6be);
}

void ElimRedundantClasses_6bb::operator()( const Packets_t& projects_6bc, Packets_t& projects_6be)
{
#ifdef PRINT_INFO
	printLog("ElimRedundantClasses_6bb" );
#endif
	_project_6bf= &projects_6be;
	if( ( !projects_6bc.empty()))
		callGetClasses_710( projects_6bc);
	_project_6bf->insert( _project_6bf->end(), projects_6bc.begin(), projects_6bc.end());
}

void ElimRedundantClasses_6bb::callGetClasses_710( const Packets_t& projects_6f5)
{
	Packets_t classs_6f4;
	GetClasses_6f3 getClasses_6f3;
	getClasses_6f3( projects_6f5, classs_6f4);
	if( ( !classs_6f4.empty()))
		callRedundancyTest_712( classs_6f4);
}

void ElimRedundantClasses_6bb::callRedundancyTest_712( const Packets_t& classs_6d2)
{
	Packets_t classs_6d4;
	RedundancyTest_6d1 redundancyTest_6d1;
	redundancyTest_6d1( classs_6d2, classs_6d4);
	if( ( !classs_6d4.empty()))
		callDeleteClass_714( classs_6d4);
}

void ElimRedundantClasses_6bb::callDeleteClass_714( const Packets_t& classs_6c1)
{
	DeleteClass_6c0 deleteClass_6c0;
	deleteClass_6c0( classs_6c1);
}

void DeleteClass_6c0::operator()( const Packets_t& classs_6c1)
{
#ifdef PRINT_INFO
	printLog("DeleteClass_6c0" );
#endif
	RTTGenerator::Instance()->generateRule(292, "DeleteClass");
	processInputPackets( classs_6c1);
}

bool DeleteClass_6c0::isInputUnique( const Udm::Object& class_6c7)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass_6c9= _class_6c3.begin(); itClass_6c9!= _class_6c3.end(); ++itClass_6c9)
	{
		if( ( *itClass_6c9== class_6c7))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class_6c3.push_back( class_6c7);
	return isUnique;
}

bool DeleteClass_6c0::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void DeleteClass_6c0::processInputPackets( const Packets_t& classs_6c1)
{
	for( Packets_t::const_iterator itClass_6c4= classs_6c1.begin(); itClass_6c4!= classs_6c1.end(); ++itClass_6c4)
	{
		bool isUnique= isInputUnique( *itClass_6c4);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass_6c4);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool DeleteClass_6c0::patternMatcher( const Udm::Object& class_6c5)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class_6c5.type(), SFC::Class::meta))
			continue;
		SFC::Class class_6ca= SFC::Class::Cast( class_6c5);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_6cf;
		if( !isValidBound(boundObjs_6cf, class_6ca, true))
			continue;
		currMatch.class_6d0= class_6ca;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void DeleteClass_6c0::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		if( currMatch.class_6d0)
			currMatch.class_6d0.DeleteObject();
	}
}

void RedundancyTest_6d1::operator()( const Packets_t& classs_6d2, Packets_t& classs_6d4)
{
#ifdef PRINT_INFO
	printLog("RedundancyTest_6d1" );
#endif
	_class_6d5= &classs_6d4;
	for( Packets_t::const_iterator itclass_6d7= classs_6d2.begin(); itclass_6d7!= classs_6d2.end(); ++itclass_6d7)
	{
		bool isUnique= isInputUnique( *itclass_6d7);
		if( !isUnique)
			continue;
		Packets_t oneclass_6db( 1, *itclass_6d7);
		executeOne( oneclass_6db);
	}
}

void RedundancyTest_6d1::executeOne( const Packets_t& classs_6d2)
{
	Packets_t classs_6e0;
	NegStatementCount_6dd negStatementCount_6dd;
	bool isMatchNegStatementCount_6dd= negStatementCount_6dd( classs_6d2, classs_6e0);
	_class_6d5->insert( _class_6d5->end(), classs_6e0.begin(), classs_6e0.end());
	if( isMatchNegStatementCount_6dd)
		return;
}

bool RedundancyTest_6d1::isInputUnique( const Udm::Object& class_6d8)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itclass_6da= _class_6d6.begin(); itclass_6da!= _class_6d6.end(); ++itclass_6da)
	{
		if( ( *itclass_6da== class_6d8))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class_6d6.push_back( class_6d8);
	return isUnique;
}

bool NegStatementCount_6dd::operator()( const Packets_t& classs_6de, Packets_t& classs_6e0)
{
#ifdef PRINT_INFO
	printLog("NegStatementCount_6dd" );
#endif
	_class_6e1= &classs_6e0;
	processInputPackets( classs_6de);
	if( false== _matches.empty())
		return true;
	return false;
}

bool NegStatementCount_6dd::isInputUnique( const Udm::Object& class_6e6)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass_6e8= _class_6e2.begin(); itClass_6e8!= _class_6e2.end(); ++itClass_6e8)
	{
		if( ( *itClass_6e8== class_6e6))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class_6e2.push_back( class_6e6);
	return isUnique;
}

bool NegStatementCount_6dd::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool NegStatementCount_6dd::isGuardTrue( SFC::Class& Class)
{
	bool Gz_guard= false;
	return Class.statementCount() < 0;;
	return Gz_guard;
}

void NegStatementCount_6dd::processInputPackets( const Packets_t& classs_6de)
{
	for( Packets_t::const_iterator itClass_6e3= classs_6de.begin(); itClass_6e3!= classs_6de.end(); ++itClass_6e3)
	{
		bool isUnique= isInputUnique( *itClass_6e3);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass_6e3);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class_6ef);
	}
}

bool NegStatementCount_6dd::patternMatcher( const Udm::Object& class_6e4)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class_6e4.type(), SFC::Class::meta))
			continue;
		SFC::Class class_6e9= SFC::Class::Cast( class_6e4);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_6ee;
		if( !isValidBound(boundObjs_6ee, class_6e9, true))
			continue;
		currMatch.class_6ef= class_6e9;
		bool Gz_guard= isGuardTrue( currMatch.class_6ef);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void NegStatementCount_6dd::outputAppender( const SFC::Class& class_6f1)
{
	_class_6e1->push_back( class_6f1);
}

void GetClasses_6f3::operator()( const Packets_t& projects_6f5, Packets_t& classs_6f4)
{
#ifdef PRINT_INFO
	printLog("GetClasses_6f3" );
#endif
	RTTGenerator::Instance()->generateRule(299, "GetClasses");
	_class_6f7= &classs_6f4;
	processInputPackets( projects_6f5);
}

bool GetClasses_6f3::isInputUnique( const Udm::Object& project_6fc)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itProject_6fe= _project_6f8.begin(); itProject_6fe!= _project_6f8.end(); ++itProject_6fe)
	{
		if( ( *itProject_6fe== project_6fc))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_project_6f8.push_back( project_6fc);
	return isUnique;
}

bool GetClasses_6f3::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetClasses_6f3::processInputPackets( const Packets_t& projects_6f5)
{
	for( Packets_t::const_iterator itProject_6f9= projects_6f5.begin(); itProject_6f9!= projects_6f5.end(); ++itProject_6f9)
	{
		bool isUnique= isInputUnique( *itProject_6f9);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itProject_6f9);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetClasses_6f3::patternMatcher( const Udm::Object& project_6fa)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( project_6fa.type(), SFC::Project::meta))
			continue;
		SFC::Project project_6ff= SFC::Project::Cast( project_6fa);
		set< SFC::Program> programs_701= project_6ff.Program_kind_children();
		for( set< SFC::Program>::const_iterator itProgram_702= programs_701.begin(); itProgram_702!= programs_701.end(); ++itProgram_702)
		{
			SFC::Program currProgram_703= *itProgram_702;
			set< SFC::Class> classs_704= currProgram_703.Class_kind_children();
			for( set< SFC::Class>::const_iterator itClass_705= classs_704.begin(); itClass_705!= classs_704.end(); ++itClass_705)
			{
				SFC::Class currClass_706= *itClass_705;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_70a;
				if( !isValidBound(boundObjs_70a, project_6ff, true))
					continue;
				currMatch.project_70b= project_6ff;
				if( !isValidBound(boundObjs_70a, currProgram_703, false))
					continue;
				currMatch.program_70c= currProgram_703;
				if( !isValidBound(boundObjs_70a, currClass_706, false))
					continue;
				currMatch.class_70d= currClass_706;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetClasses_6f3::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class_70d);
	}
}

void GetClasses_6f3::outputAppender( const SFC::Class& class_70e)
{
	_class_6f7->push_back( class_70e);
}

void MergeClasses_716::operator()( const Packets_t& projects_717, Packets_t& projects_719)
{
#ifdef PRINT_INFO
	printLog("MergeClasses_716" );
#endif
	_project_71a= &projects_719;
	if( ( !projects_717.empty()))
		callMakeEquivalence_d8a( projects_717);
	_project_71a->insert( _project_71a->end(), projects_717.begin(), projects_717.end());
}

void MergeClasses_716::callMakeEquivalence_d8a( const Packets_t& projects_d5e)
{
	Packets_t projects_d60;
	MakeEquivalence_d5d makeEquivalence_d5d;
	makeEquivalence_d5d( projects_d5e, projects_d60);
	if( ( !projects_d60.empty()))
		callGetClasses_d8c( projects_d60);
}

void MergeClasses_716::callGetClasses_d8c( const Packets_t& projects_d42)
{
	Packets_t classs_d41;
	GetClasses_d40 getClasses_d40;
	getClasses_d40( projects_d42, classs_d41);
	if( ( !classs_d41.empty()))
		callOneClassAtATime_d8e( classs_d41);
}

void MergeClasses_716::callOneClassAtATime_d8e( const Packets_t& classs_71c)
{
	OneClassAtATime_71b oneClassAtATime_71b;
	oneClassAtATime_71b( classs_71c);
}

void OneClassAtATime_71b::operator()( const Packets_t& classs_71c)
{
#ifdef PRINT_INFO
	printLog("OneClassAtATime_71b" );
#endif
	for( Packets_t::const_iterator itclass_71f= classs_71c.begin(); itclass_71f!= classs_71c.end(); ++itclass_71f)
	{
		bool isUnique= isInputUnique( *itclass_71f);
		if( !isUnique)
			continue;
		Packets_t oneclass_723( 1, *itclass_71f);
		executeOne( oneclass_723);
	}
}

void OneClassAtATime_71b::executeOne( const Packets_t& classs_71c)
{
	if( ( !classs_71c.empty()))
		callClassFilter_d38( classs_71c);
}

bool OneClassAtATime_71b::isInputUnique( const Udm::Object& class_720)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itclass_722= _class_71e.begin(); itclass_722!= _class_71e.end(); ++itclass_722)
	{
		if( ( *itclass_722== class_720))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class_71e.push_back( class_720);
	return isUnique;
}

void OneClassAtATime_71b::callClassFilter_d38( const Packets_t& classs_726)
{
	Packets_t classs_728;
	ClassFilter_725 classFilter_725;
	classFilter_725( classs_726, classs_728);
	if( ( !classs_728.empty()))
		callMergeClasses_d3a( classs_728);
}

void OneClassAtATime_71b::callMergeClasses_d3a( const Packets_t& classs_7db)
{
	Packets_t classs_7dd;
	MergeClasses_7da mergeClasses_7da;
	mergeClasses_7da( classs_7db, classs_7dd);
	if( ( !classs_7dd.empty()))
		callGetNextLevelClasses_d3c( classs_7dd);
}

void OneClassAtATime_71b::callGetNextLevelClasses_d3c( const Packets_t& childClasss_7b8)
{
	Packets_t parentClasss_7ba;
	GetNextLevelClasses_7b7 getNextLevelClasses_7b7;
	getNextLevelClasses_7b7( childClasss_7b8, parentClasss_7ba);
	if( ( !parentClasss_7ba.empty()))
		callOneClassAtATime_d3e( parentClasss_7ba);
}

void OneClassAtATime_71b::callOneClassAtATime_d3e( const Packets_t& classs_71c)
{
	OneClassAtATime_71b oneClassAtATime_71b;
	oneClassAtATime_71b( classs_71c);
}

void ClassFilter_725::operator()( const Packets_t& classs_726, Packets_t& classs_728)
{
#ifdef PRINT_INFO
	printLog("ClassFilter_725" );
#endif
	_class_729= &classs_728;
	if( ( !classs_726.empty()))
		callSimpleStructFilter_7b5( classs_726);
}

void ClassFilter_725::callSimpleStructFilter_7b5( const Packets_t& classs_72b)
{
	Packets_t classs_72d;
	Packets_t classs_72e;
	Packets_t classs_72f;
	Packets_t classs_730;
	SimpleStructFilter_72a simpleStructFilter_72a;
	simpleStructFilter_72a( classs_72b, classs_72d, classs_72e, classs_72f, classs_730);
	_class_729->insert( _class_729->end(), classs_730.begin(), classs_730.end());
}

void SimpleStructFilter_72a::operator()( const Packets_t& classs_72b, Packets_t& classs_72d, Packets_t& classs_72e, Packets_t& classs_72f, Packets_t& classs_730)
{
#ifdef PRINT_INFO
	printLog("SimpleStructFilter_72a" );
#endif
	_class_731= &classs_72d;
	_class_732= &classs_72e;
	_class_733= &classs_72f;
	_class_734= &classs_730;
	for( Packets_t::const_iterator itclass_736= classs_72b.begin(); itclass_736!= classs_72b.end(); ++itclass_736)
	{
		bool isUnique= isInputUnique( *itclass_736);
		if( !isUnique)
			continue;
		Packets_t oneclass_73a( 1, *itclass_736);
		executeOne( oneclass_73a);
	}
}

void SimpleStructFilter_72a::executeOne( const Packets_t& classs_72b)
{
	Packets_t classs_73f;
	Marked_73c marked_73c;
	bool isMatchMarked_73c= marked_73c( classs_72b, classs_73f);
	_class_731->insert( _class_731->end(), classs_73f.begin(), classs_73f.end());
	Packets_t classs_755;
	ComplexStruct1_752 complexStruct1_752;
	bool isMatchComplexStruct1_752= complexStruct1_752( classs_72b, classs_755);
	_class_732->insert( _class_732->end(), classs_755.begin(), classs_755.end());
	if( isMatchComplexStruct1_752)
		return;
	Packets_t classs_77c;
	ComplexStruct2_779 complexStruct2_779;
	bool isMatchComplexStruct2_779= complexStruct2_779( classs_72b, classs_77c);
	_class_733->insert( _class_733->end(), classs_77c.begin(), classs_77c.end());
	if( isMatchComplexStruct2_779)
		return;
	Packets_t classs_7a3;
	SimpleStruct_7a0 simpleStruct_7a0;
	bool isMatchSimpleStruct_7a0= simpleStruct_7a0( classs_72b, classs_7a3);
	_class_734->insert( _class_734->end(), classs_7a3.begin(), classs_7a3.end());
	if( isMatchSimpleStruct_7a0)
		return;
}

bool SimpleStructFilter_72a::isInputUnique( const Udm::Object& class_737)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itclass_739= _class_735.begin(); itclass_739!= _class_735.end(); ++itclass_739)
	{
		if( ( *itclass_739== class_737))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class_735.push_back( class_737);
	return isUnique;
}

bool Marked_73c::operator()( const Packets_t& classs_73d, Packets_t& classs_73f)
{
#ifdef PRINT_INFO
	printLog("Marked_73c" );
#endif
	_class_740= &classs_73f;
	processInputPackets( classs_73d);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Marked_73c::isInputUnique( const Udm::Object& class_745)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass_747= _class_741.begin(); itClass_747!= _class_741.end(); ++itClass_747)
	{
		if( ( *itClass_747== class_745))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class_741.push_back( class_745);
	return isUnique;
}

bool Marked_73c::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool Marked_73c::isGuardTrue( SFC::Class& Class)
{
	bool Gz_guard= false;
	return Class.statementCount() < 0;;
	return Gz_guard;
}

void Marked_73c::processInputPackets( const Packets_t& classs_73d)
{
	for( Packets_t::const_iterator itClass_742= classs_73d.begin(); itClass_742!= classs_73d.end(); ++itClass_742)
	{
		bool isUnique= isInputUnique( *itClass_742);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass_742);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class_74e);
	}
}

bool Marked_73c::patternMatcher( const Udm::Object& class_743)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class_743.type(), SFC::Class::meta))
			continue;
		SFC::Class class_748= SFC::Class::Cast( class_743);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_74d;
		if( !isValidBound(boundObjs_74d, class_748, true))
			continue;
		currMatch.class_74e= class_748;
		bool Gz_guard= isGuardTrue( currMatch.class_74e);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Marked_73c::outputAppender( const SFC::Class& class_750)
{
	_class_740->push_back( class_750);
}

bool ComplexStruct1_752::operator()( const Packets_t& classs_753, Packets_t& classs_755)
{
#ifdef PRINT_INFO
	printLog("ComplexStruct1_752" );
#endif
	_class_756= &classs_755;
	processInputPackets( classs_753);
	if( false== _matches.empty())
		return true;
	return false;
}

bool ComplexStruct1_752::isInputUnique( const Udm::Object& class_75b)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass_75d= _class_757.begin(); itClass_75d!= _class_757.end(); ++itClass_75d)
	{
		if( ( *itClass_75d== class_75b))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class_757.push_back( class_75b);
	return isUnique;
}

bool ComplexStruct1_752::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void ComplexStruct1_752::processInputPackets( const Packets_t& classs_753)
{
	for( Packets_t::const_iterator itClass_758= classs_753.begin(); itClass_758!= classs_753.end(); ++itClass_758)
	{
		bool isUnique= isInputUnique( *itClass_758);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass_758);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class_771);
	}
}

bool ComplexStruct1_752::patternMatcher( const Udm::Object& class_759)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class_759.type(), SFC::Class::meta))
			continue;
		SFC::Class class_75e= SFC::Class::Cast( class_759);
		set< SFC::Struct> parentStructs_760= class_75e.Struct_kind_children();
		for( set< SFC::Struct>::const_iterator itParentStruct_761= parentStructs_760.begin(); itParentStruct_761!= parentStructs_760.end(); ++itParentStruct_761)
		{
			SFC::Struct currParentStruct_762= *itParentStruct_761;
			set< SFC::LocalVar> localVars_763= currParentStruct_762.LocalVar_kind_children();
			for( set< SFC::LocalVar>::const_iterator itLocalVar_764= localVars_763.begin(); itLocalVar_764!= localVars_763.end(); ++itLocalVar_764)
			{
				SFC::LocalVar currLocalVar_765= *itLocalVar_764;
				SFC::DT childStruct_766= currLocalVar_765.dt();
				if(!childStruct_766 || false== Uml::IsDerivedFrom( childStruct_766.type(), SFC::Struct::meta))
					continue;
				SFC::Struct childStruct_767= SFC::Struct::Cast( childStruct_766);
				if( !childStruct_767)
					continue;
				Udm::Object childStructParent_768= childStruct_767.container();
				if( false== Uml::IsDerivedFrom( childStructParent_768.type(), SFC::Class::meta))
					continue;
				SFC::Class childClassChildStruct_769= SFC::Class::Cast( childStructParent_768);
				set< SFC::Class> equivClasss_76a= childClassChildStruct_769.equivdst();
				for( set< SFC::Class>::const_iterator itEquivClasss_76b= equivClasss_76a.begin(); itEquivClasss_76b!= equivClasss_76a.end(); ++itEquivClasss_76b)
				{
					SFC::Class currEquivClass_76c= *itEquivClasss_76b;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_770;
					if( !isValidBound(boundObjs_770, class_75e, true))
						continue;
					currMatch.class_771= class_75e;
					if( !isValidBound(boundObjs_770, childClassChildStruct_769, false))
						continue;
					currMatch.childClass_772= childClassChildStruct_769;
					if( !isValidBound(boundObjs_770, currEquivClass_76c, false))
						continue;
					currMatch.equivClass_773= currEquivClass_76c;
					if( !isValidBound(boundObjs_770, currParentStruct_762, false))
						continue;
					currMatch.parentStruct_774= currParentStruct_762;
					if( !isValidBound(boundObjs_770, currLocalVar_765, false))
						continue;
					currMatch.localVar_775= currLocalVar_765;
					if( !isValidBound(boundObjs_770, childStruct_767, false))
						continue;
					currMatch.childStruct_776= childStruct_767;
					_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void ComplexStruct1_752::outputAppender( const SFC::Class& class_777)
{
	_class_756->push_back( class_777);
}

bool ComplexStruct2_779::operator()( const Packets_t& classs_77a, Packets_t& classs_77c)
{
#ifdef PRINT_INFO
	printLog("ComplexStruct2_779" );
#endif
	_class_77d= &classs_77c;
	processInputPackets( classs_77a);
	if( false== _matches.empty())
		return true;
	return false;
}

bool ComplexStruct2_779::isInputUnique( const Udm::Object& class_782)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass_784= _class_77e.begin(); itClass_784!= _class_77e.end(); ++itClass_784)
	{
		if( ( *itClass_784== class_782))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class_77e.push_back( class_782);
	return isUnique;
}

bool ComplexStruct2_779::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void ComplexStruct2_779::processInputPackets( const Packets_t& classs_77a)
{
	for( Packets_t::const_iterator itClass_77f= classs_77a.begin(); itClass_77f!= classs_77a.end(); ++itClass_77f)
	{
		bool isUnique= isInputUnique( *itClass_77f);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass_77f);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class_798);
	}
}

bool ComplexStruct2_779::patternMatcher( const Udm::Object& class_780)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class_780.type(), SFC::Class::meta))
			continue;
		SFC::Class class_785= SFC::Class::Cast( class_780);
		set< SFC::Struct> parentStructs_787= class_785.Struct_kind_children();
		for( set< SFC::Struct>::const_iterator itParentStruct_788= parentStructs_787.begin(); itParentStruct_788!= parentStructs_787.end(); ++itParentStruct_788)
		{
			SFC::Struct currParentStruct_789= *itParentStruct_788;
			set< SFC::LocalVar> localVars_78a= currParentStruct_789.LocalVar_kind_children();
			for( set< SFC::LocalVar>::const_iterator itLocalVar_78b= localVars_78a.begin(); itLocalVar_78b!= localVars_78a.end(); ++itLocalVar_78b)
			{
				SFC::LocalVar currLocalVar_78c= *itLocalVar_78b;
				SFC::DT childStruct_78d= currLocalVar_78c.dt();
				if(!childStruct_78d || false== Uml::IsDerivedFrom( childStruct_78d.type(), SFC::Struct::meta))
					continue;
				SFC::Struct childStruct_78e= SFC::Struct::Cast( childStruct_78d);
				if( !childStruct_78e)
					continue;
				Udm::Object childStructParent_78f= childStruct_78e.container();
				if( false== Uml::IsDerivedFrom( childStructParent_78f.type(), SFC::Class::meta))
					continue;
				SFC::Class childClassChildStruct_790= SFC::Class::Cast( childStructParent_78f);
				set< SFC::Class> equivClasss_791= childClassChildStruct_790.equivsrc();
				for( set< SFC::Class>::const_iterator itEquivClasss_792= equivClasss_791.begin(); itEquivClasss_792!= equivClasss_791.end(); ++itEquivClasss_792)
				{
					SFC::Class currEquivClass_793= *itEquivClasss_792;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_797;
					if( !isValidBound(boundObjs_797, class_785, true))
						continue;
					currMatch.class_798= class_785;
					if( !isValidBound(boundObjs_797, currParentStruct_789, false))
						continue;
					currMatch.parentStruct_799= currParentStruct_789;
					if( !isValidBound(boundObjs_797, childClassChildStruct_790, false))
						continue;
					currMatch.childClass_79a= childClassChildStruct_790;
					if( !isValidBound(boundObjs_797, currEquivClass_793, false))
						continue;
					currMatch.equivClass_79b= currEquivClass_793;
					if( !isValidBound(boundObjs_797, currLocalVar_78c, false))
						continue;
					currMatch.localVar_79c= currLocalVar_78c;
					if( !isValidBound(boundObjs_797, childStruct_78e, false))
						continue;
					currMatch.childStruct_79d= childStruct_78e;
					_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void ComplexStruct2_779::outputAppender( const SFC::Class& class_79e)
{
	_class_77d->push_back( class_79e);
}

bool SimpleStruct_7a0::operator()( const Packets_t& classs_7a1, Packets_t& classs_7a3)
{
#ifdef PRINT_INFO
	printLog("SimpleStruct_7a0" );
#endif
	_class_7a4= &classs_7a3;
	processInputPackets( classs_7a1);
	if( false== _matches.empty())
		return true;
	return false;
}

bool SimpleStruct_7a0::isInputUnique( const Udm::Object& class_7a9)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass_7ab= _class_7a5.begin(); itClass_7ab!= _class_7a5.end(); ++itClass_7ab)
	{
		if( ( *itClass_7ab== class_7a9))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class_7a5.push_back( class_7a9);
	return isUnique;
}

bool SimpleStruct_7a0::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void SimpleStruct_7a0::processInputPackets( const Packets_t& classs_7a1)
{
	for( Packets_t::const_iterator itClass_7a6= classs_7a1.begin(); itClass_7a6!= classs_7a1.end(); ++itClass_7a6)
	{
		bool isUnique= isInputUnique( *itClass_7a6);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass_7a6);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class_7b2);
	}
}

bool SimpleStruct_7a0::patternMatcher( const Udm::Object& class_7a7)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class_7a7.type(), SFC::Class::meta))
			continue;
		SFC::Class class_7ac= SFC::Class::Cast( class_7a7);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_7b1;
		if( !isValidBound(boundObjs_7b1, class_7ac, true))
			continue;
		currMatch.class_7b2= class_7ac;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void SimpleStruct_7a0::outputAppender( const SFC::Class& class_7b3)
{
	_class_7a4->push_back( class_7b3);
}

void GetNextLevelClasses_7b7::operator()( const Packets_t& childClasss_7b8, Packets_t& parentClasss_7ba)
{
#ifdef PRINT_INFO
	printLog("GetNextLevelClasses_7b7" );
#endif
	RTTGenerator::Instance()->generateRule(347, "GetNextLevelClasses");
	_parentClass_7bb= &parentClasss_7ba;
	processInputPackets( childClasss_7b8);
}

bool GetNextLevelClasses_7b7::isInputUnique( const Udm::Object& childClass_7c0)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itChildClass_7c2= _childClass_7bc.begin(); itChildClass_7c2!= _childClass_7bc.end(); ++itChildClass_7c2)
	{
		if( ( *itChildClass_7c2== childClass_7c0))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_childClass_7bc.push_back( childClass_7c0);
	return isUnique;
}

bool GetNextLevelClasses_7b7::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetNextLevelClasses_7b7::processInputPackets( const Packets_t& childClasss_7b8)
{
	for( Packets_t::const_iterator itChildClass_7bd= childClasss_7b8.begin(); itChildClass_7bd!= childClasss_7b8.end(); ++itChildClass_7bd)
	{
		bool isUnique= isInputUnique( *itChildClass_7bd);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itChildClass_7bd);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetNextLevelClasses_7b7::patternMatcher( const Udm::Object& childClass_7be)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( childClass_7be.type(), SFC::Class::meta))
			continue;
		SFC::Class childClass_7c3= SFC::Class::Cast( childClass_7be);
		set< SFC::Struct> childStructs_7c5= childClass_7c3.Struct_kind_children();
		for( set< SFC::Struct>::const_iterator itChildStruct_7c6= childStructs_7c5.begin(); itChildStruct_7c6!= childStructs_7c5.end(); ++itChildStruct_7c6)
		{
			SFC::Struct currChildStruct_7c7= *itChildStruct_7c6;
			set< SFC::TypedEntity> members_7c8= currChildStruct_7c7.te();
			for( set< SFC::TypedEntity>::const_iterator itMembers_7c9= members_7c8.begin(); itMembers_7c9!= members_7c8.end(); ++itMembers_7c9)
			{
				if( false== Uml::IsDerivedFrom( (*itMembers_7c9).type(), SFC::LocalVar::meta))
					continue;
				SFC::LocalVar currMember_7ca= SFC::LocalVar::Cast( *itMembers_7c9);
				Udm::Object memberParent_7cb= currMember_7ca.container();
				if( false== Uml::IsDerivedFrom( memberParent_7cb.type(), SFC::Struct::meta))
					continue;
				SFC::Struct parentStructMember_7cc= SFC::Struct::Cast( memberParent_7cb);
				Udm::Object parentStructParent_7cd= parentStructMember_7cc.container();
				if( false== Uml::IsDerivedFrom( parentStructParent_7cd.type(), SFC::Class::meta))
					continue;
				SFC::Class parentClassParentStruct_7ce= SFC::Class::Cast( parentStructParent_7cd);
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_7d2;
				if( !isValidBound(boundObjs_7d2, childClass_7c3, true))
					continue;
				currMatch.childClass_7d3= childClass_7c3;
				if( !isValidBound(boundObjs_7d2, parentClassParentStruct_7ce, false))
					continue;
				currMatch.parentClass_7d4= parentClassParentStruct_7ce;
				if( !isValidBound(boundObjs_7d2, currMember_7ca, false))
					continue;
				currMatch.member_7d5= currMember_7ca;
				if( !isValidBound(boundObjs_7d2, currChildStruct_7c7, false))
					continue;
				currMatch.childStruct_7d6= currChildStruct_7c7;
				if( !isValidBound(boundObjs_7d2, parentStructMember_7cc, false))
					continue;
				currMatch.parentStruct_7d7= parentStructMember_7cc;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetNextLevelClasses_7b7::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.parentClass_7d4);
	}
}

void GetNextLevelClasses_7b7::outputAppender( const SFC::Class& parentClass_7d8)
{
	_parentClass_7bb->push_back( parentClass_7d8);
}

void MergeClasses_7da::operator()( const Packets_t& classs_7db, Packets_t& classs_7dd)
{
#ifdef PRINT_INFO
	printLog("MergeClasses_7da" );
#endif
	_class_7de= &classs_7dd;
	_class_7de->insert( _class_7de->end(), classs_7db.begin(), classs_7db.end());
	if( ( !classs_7db.empty()))
		callTestEquivalence_d34( classs_7db);
}

void MergeClasses_7da::callTestEquivalence_d34( const Packets_t& classs_7e0)
{
	Packets_t classs_7e2;
	TestEquivalence_7df testEquivalence_7df;
	testEquivalence_7df( classs_7e0, classs_7e2);
	if( ( !classs_7e2.empty()))
		callElimEquiv_d36( classs_7e2);
}

void MergeClasses_7da::callElimEquiv_d36( const Packets_t& classs_a73)
{
	ElimEquiv_a72 elimEquiv_a72;
	elimEquiv_a72( classs_a73);
}

void TestEquivalence_7df::operator()( const Packets_t& classs_7e0, Packets_t& classs_7e2)
{
#ifdef PRINT_INFO
	printLog("TestEquivalence_7df" );
#endif
	_class_7e3= &classs_7e2;
	for( Packets_t::const_iterator itclass_7e5= classs_7e0.begin(); itclass_7e5!= classs_7e0.end(); ++itclass_7e5)
	{
		bool isUnique= isInputUnique( *itclass_7e5);
		if( !isUnique)
			continue;
		Packets_t oneclass_7e9( 1, *itclass_7e5);
		executeOne( oneclass_7e9);
	}
}

void TestEquivalence_7df::executeOne( const Packets_t& classs_7e0)
{
	if( ( !classs_7e0.empty()))
		callTestDataMembers_a6e( classs_7e0);
}

bool TestEquivalence_7df::isInputUnique( const Udm::Object& class_7e6)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itclass_7e8= _class_7e4.begin(); itclass_7e8!= _class_7e4.end(); ++itclass_7e8)
	{
		if( ( *itclass_7e8== class_7e6))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class_7e4.push_back( class_7e6);
	return isUnique;
}

void TestEquivalence_7df::callTestDataMembers_a6e( const Packets_t& classs_8fd)
{
	Packets_t classs_8ff;
	TestDataMembers_8fc testDataMembers_8fc;
	testDataMembers_8fc( classs_8fd, classs_8ff);
	if( ( !classs_8ff.empty()))
		callCheckMethods_a70( classs_8ff);
}

void TestEquivalence_7df::callCheckMethods_a70( const Packets_t& classs_7ec)
{
	Packets_t classs_7ee;
	CheckMethods_7eb checkMethods_7eb;
	checkMethods_7eb( classs_7ec, classs_7ee);
	_class_7e3->insert( _class_7e3->end(), classs_7ee.begin(), classs_7ee.end());
}

void CheckMethods_7eb::operator()( const Packets_t& classs_7ec, Packets_t& classs_7ee)
{
#ifdef PRINT_INFO
	printLog("CheckMethods_7eb" );
#endif
	_class_7ef= &classs_7ee;
	if( ( !classs_7ec.empty()))
		callGetMainFunctionArgs_8f2( classs_7ec);
	_class_7ef->insert( _class_7ef->end(), classs_7ec.begin(), classs_7ec.end());
}

void CheckMethods_7eb::callGetMainFunctionArgs_8f2( const Packets_t& class1s_8c6)
{
	Packets_t class1s_8c8;
	Packets_t class2s_8c9;
	Packets_t args_8ca;
	GetMainFunctionArgs_8c5 getMainFunctionArgs_8c5;
	getMainFunctionArgs_8c5( class1s_8c6, class1s_8c8, class2s_8c9, args_8ca);
	if( ( !class1s_8c8.empty())&& ( !class2s_8c9.empty())&& ( !args_8ca.empty()))
		callTestArgs_8f4( class1s_8c8, class2s_8c9, args_8ca);
}

void CheckMethods_7eb::callTestArgs_8f4( const Packets_t& class1s_7f1, const Packets_t& class2s_7f3, const Packets_t& args_7f5)
{
	Packets_t class1s_7f7;
	Packets_t class2s_7f8;
	Packets_t args_7f9;
	Packets_t class1s_7fa;
	Packets_t class2s_7fb;
	Packets_t args_7fc;
	TestArgs_7f0 testArgs_7f0;
	testArgs_7f0( class1s_7f1, class2s_7f3, args_7f5, class1s_7f7, class2s_7f8, args_7f9, class1s_7fa, class2s_7fb, args_7fc);
	if( ( !class1s_7fa.empty())&& ( !class2s_7fb.empty())&& ( !args_7fc.empty()))
		callBreakEquivalence_8f8( class1s_7fa, class2s_7fb, args_7fc);
}

void CheckMethods_7eb::callBreakEquivalence_8f8( const Packets_t& class1s_89a, const Packets_t& class2s_89c, const Packets_t& args_89e)
{
	BreakEquivalence_899 breakEquivalence_899;
	breakEquivalence_899( class1s_89a, class2s_89c, args_89e);
}

void TestArgs_7f0::operator()( const Packets_t& class1s_7f1, const Packets_t& class2s_7f3, const Packets_t& args_7f5, Packets_t& class1s_7f7, Packets_t& class2s_7f8, Packets_t& args_7f9, Packets_t& class1s_7fa, Packets_t& class2s_7fb, Packets_t& args_7fc)
{
#ifdef PRINT_INFO
	printLog("TestArgs_7f0" );
#endif
	_class1_7fd= &class1s_7f7;
	_class2_7fe= &class2s_7f8;
	_arg_7ff= &args_7f9;
	_class1_800= &class1s_7fa;
	_class2_801= &class2s_7fb;
	_arg_802= &args_7fc;
	for( Packets_t::const_iterator itclass1_804= class1s_7f1.begin(), itclass2_80b= class2s_7f3.begin(), itarg_812= args_7f5.begin(); itclass1_804!= class1s_7f1.end(), itclass2_80b!= class2s_7f3.end(), itarg_812!= args_7f5.end(); ++itclass1_804, ++itclass2_80b, ++itarg_812)
	{
		bool isUnique= isInputUnique( *itclass1_804, *itclass2_80b, *itarg_812);
		if( !isUnique)
			continue;
		Packets_t oneclass1_808( 1, *itclass1_804);
		Packets_t oneclass2_80f( 1, *itclass2_80b);
		Packets_t onearg_816( 1, *itarg_812);
		executeOne( oneclass1_808, oneclass2_80f, onearg_816);
	}
}

void TestArgs_7f0::executeOne( const Packets_t& class1s_7f1, const Packets_t& class2s_7f3, const Packets_t& args_7f5)
{
	Packets_t class1s_81b;
	Packets_t class2s_81e;
	Packets_t arg1s_821;
	ArgsMatch_818 argsMatch_818;
	bool isMatchArgsMatch_818= argsMatch_818( class1s_7f1, class2s_7f3, args_7f5, class1s_81b, class2s_81e, arg1s_821);
	_class1_7fd->insert( _class1_7fd->end(), class1s_81b.begin(), class1s_81b.end());
	_class2_7fe->insert( _class2_7fe->end(), class2s_81e.begin(), class2s_81e.end());
	_arg_7ff->insert( _arg_7ff->end(), arg1s_821.begin(), arg1s_821.end());
	if( isMatchArgsMatch_818)
		return;
	Packets_t class1s_864;
	Packets_t class2s_867;
	Packets_t arg1s_86a;
	NoArgMatch_861 noArgMatch_861;
	bool isMatchNoArgMatch_861= noArgMatch_861( class1s_7f1, class2s_7f3, args_7f5, class1s_864, class2s_867, arg1s_86a);
	_class1_800->insert( _class1_800->end(), class1s_864.begin(), class1s_864.end());
	_class2_801->insert( _class2_801->end(), class2s_867.begin(), class2s_867.end());
	_arg_802->insert( _arg_802->end(), arg1s_86a.begin(), arg1s_86a.end());
	if( isMatchNoArgMatch_861)
		return;
}

bool TestArgs_7f0::isInputUnique( const Udm::Object& class1_805, const Udm::Object& class2_80c, const Udm::Object& arg_813)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itclass1_807= _class1_803.begin(), itclass2_80e= _class2_80a.begin(), itarg_815= _arg_811.begin(); itclass1_807!= _class1_803.end(), itclass2_80e!= _class2_80a.end(), itarg_815!= _arg_811.end(); ++itclass1_807, ++itclass2_80e, ++itarg_815)
	{
		if( ( *itclass1_807== class1_805)&& ( *itclass2_80e== class2_80c)&& ( *itarg_815== arg_813))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_803.push_back( class1_805);
		_class2_80a.push_back( class2_80c);
		_arg_811.push_back( arg_813);
	}
	return isUnique;
}

bool ArgsMatch_818::operator()( const Packets_t& class1s_819, const Packets_t& class2s_81c, const Packets_t& arg1s_81f, Packets_t& class1s_81b, Packets_t& class2s_81e, Packets_t& arg1s_821)
{
#ifdef PRINT_INFO
	printLog("ArgsMatch_818" );
#endif
	_class1_822= &class1s_81b;
	_class2_823= &class2s_81e;
	_arg1_824= &arg1s_821;
	processInputPackets( class1s_819, class2s_81c, arg1s_81f);
	if( false== _matches.empty())
		return true;
	return false;
}

bool ArgsMatch_818::isInputUnique( const Udm::Object& class1_829, const Udm::Object& class2_832, const Udm::Object& arg1_83b)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_82b= _class1_825.begin(), itClass2_834= _class2_82e.begin(), itArg1_83d= _arg1_837.begin(); itClass1_82b!= _class1_825.end(), itClass2_834!= _class2_82e.end(), itArg1_83d!= _arg1_837.end(); ++itClass1_82b, ++itClass2_834, ++itArg1_83d)
	{
		if( ( *itClass1_82b== class1_829)&& ( *itClass2_834== class2_832)&& ( *itArg1_83d== arg1_83b))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_825.push_back( class1_829);
		_class2_82e.push_back( class2_832);
		_arg1_837.push_back( arg1_83b);
	}
	return isUnique;
}

bool ArgsMatch_818::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool ArgsMatch_818::isGuardTrue( SFC::Arg& Arg1, SFC::Arg& Arg2, SFC::Class& Class1, SFC::Class& Class2, SFC::DT& DT, SFC::Function& MainFunction2)
{
	bool Gz_guard= false;
	std::string functionName = MainFunction2.name();

return
 functionName.substr( functionName.size() - 5 ) == "_main" &&
 Arg1.ptr() == Arg2.ptr() &&
 Arg1.argIndex() == Arg2.argIndex()
;;
	return Gz_guard;
}

void ArgsMatch_818::processInputPackets( const Packets_t& class1s_819, const Packets_t& class2s_81c, const Packets_t& arg1s_81f)
{
	for( Packets_t::const_iterator itClass1_826= class1s_819.begin(), itClass2_82f= class2s_81c.begin(), itArg1_838= arg1s_81f.begin(); itClass1_826!= class1s_819.end(), itClass2_82f!= class2s_81c.end(), itArg1_838!= arg1s_81f.end(); ++itClass1_826, ++itClass2_82f, ++itArg1_838)
	{
		bool isUnique= isInputUnique( *itClass1_826, *itClass2_82f, *itArg1_838);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_826, *itClass2_82f, *itArg1_838);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class1_84f, currMatch.class2_850, currMatch.arg1_851);
	}
}

bool ArgsMatch_818::patternMatcher( const Udm::Object& class1_827, const Udm::Object& class2_830, const Udm::Object& arg1_839)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_827.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_82c= SFC::Class::Cast( class1_827);
		if( false== Uml::IsDerivedFrom( class2_830.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_835= SFC::Class::Cast( class2_830);
		if( false== Uml::IsDerivedFrom( arg1_839.type(), SFC::Arg::meta))
			continue;
		SFC::Arg arg1_83e= SFC::Arg::Cast( arg1_839);
		set< SFC::Class> class2s_840= class1_82c.equivdst();
		for( set< SFC::Class>::const_iterator itClass2s_841= class2s_840.begin(); itClass2s_841!= class2s_840.end(); ++itClass2s_841)
		{
			SFC::Class currClass2_842= *itClass2s_841;
			if( class2_835!= currClass2_842)
				continue;
			set< SFC::Function> mainFunction2s_843= class2_835.Function_kind_children();
			for( set< SFC::Function>::const_iterator itMainFunction2_844= mainFunction2s_843.begin(); itMainFunction2_844!= mainFunction2s_843.end(); ++itMainFunction2_844)
			{
				SFC::Function currMainFunction2_845= *itMainFunction2_844;
				set< SFC::Arg> arg2s_846= currMainFunction2_845.Arg_kind_children();
				for( set< SFC::Arg>::const_iterator itArg2_847= arg2s_846.begin(); itArg2_847!= arg2s_846.end(); ++itArg2_847)
				{
					SFC::Arg currArg2_848= *itArg2_847;
					SFC::DT dT_849= currArg2_848.dt();
					if( !dT_849)
						continue;
					SFC::DT dT_84a= arg1_83e.dt();
					if( !dT_84a)
						continue;
					if( dT_849!= dT_84a)
						continue;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_84e;
					if( !isValidBound(boundObjs_84e, class1_82c, true))
						continue;
					currMatch.class1_84f= class1_82c;
					if( !isValidBound(boundObjs_84e, class2_835, true))
						continue;
					currMatch.class2_850= class2_835;
					if( !isValidBound(boundObjs_84e, arg1_83e, true))
						continue;
					currMatch.arg1_851= arg1_83e;
					if( !isValidBound(boundObjs_84e, currArg2_848, false))
						continue;
					currMatch.arg2_852= currArg2_848;
					if( !isValidBound(boundObjs_84e, currMainFunction2_845, false))
						continue;
					currMatch.mainFunction2_853= currMainFunction2_845;
					if( !isValidBound(boundObjs_84e, dT_849, false))
						continue;
					currMatch.dT_854= dT_849;
					bool Gz_guard= isGuardTrue( currMatch.arg1_851, currMatch.arg2_852, currMatch.class1_84f, currMatch.class2_850, currMatch.dT_854, currMatch.mainFunction2_853);
					if( true== Gz_guard)
						_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void ArgsMatch_818::outputAppender( const SFC::Class& class1_85b, const SFC::Class& class2_85d, const SFC::Arg& arg1_85f)
{
	_class1_822->push_back( class1_85b);
	_class2_823->push_back( class2_85d);
	_arg1_824->push_back( arg1_85f);
}

bool NoArgMatch_861::operator()( const Packets_t& class1s_862, const Packets_t& class2s_865, const Packets_t& arg1s_868, Packets_t& class1s_864, Packets_t& class2s_867, Packets_t& arg1s_86a)
{
#ifdef PRINT_INFO
	printLog("NoArgMatch_861" );
#endif
	_class1_86b= &class1s_864;
	_class2_86c= &class2s_867;
	_arg1_86d= &arg1s_86a;
	processInputPackets( class1s_862, class2s_865, arg1s_868);
	if( false== _matches.empty())
		return true;
	return false;
}

bool NoArgMatch_861::isInputUnique( const Udm::Object& class1_872, const Udm::Object& class2_87b, const Udm::Object& arg1_884)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_874= _class1_86e.begin(), itClass2_87d= _class2_877.begin(), itArg1_886= _arg1_880.begin(); itClass1_874!= _class1_86e.end(), itClass2_87d!= _class2_877.end(), itArg1_886!= _arg1_880.end(); ++itClass1_874, ++itClass2_87d, ++itArg1_886)
	{
		if( ( *itClass1_874== class1_872)&& ( *itClass2_87d== class2_87b)&& ( *itArg1_886== arg1_884))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_86e.push_back( class1_872);
		_class2_877.push_back( class2_87b);
		_arg1_880.push_back( arg1_884);
	}
	return isUnique;
}

bool NoArgMatch_861::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void NoArgMatch_861::processInputPackets( const Packets_t& class1s_862, const Packets_t& class2s_865, const Packets_t& arg1s_868)
{
	for( Packets_t::const_iterator itClass1_86f= class1s_862.begin(), itClass2_878= class2s_865.begin(), itArg1_881= arg1s_868.begin(); itClass1_86f!= class1s_862.end(), itClass2_878!= class2s_865.end(), itArg1_881!= arg1s_868.end(); ++itClass1_86f, ++itClass2_878, ++itArg1_881)
	{
		bool isUnique= isInputUnique( *itClass1_86f, *itClass2_878, *itArg1_881);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_86f, *itClass2_878, *itArg1_881);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class1_890, currMatch.class2_891, currMatch.arg1_892);
	}
}

bool NoArgMatch_861::patternMatcher( const Udm::Object& class1_870, const Udm::Object& class2_879, const Udm::Object& arg1_882)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_870.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_875= SFC::Class::Cast( class1_870);
		if( false== Uml::IsDerivedFrom( class2_879.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_87e= SFC::Class::Cast( class2_879);
		if( false== Uml::IsDerivedFrom( arg1_882.type(), SFC::Arg::meta))
			continue;
		SFC::Arg arg1_887= SFC::Arg::Cast( arg1_882);
		set< SFC::Class> class2s_889= class1_875.equivdst();
		for( set< SFC::Class>::const_iterator itClass2s_88a= class2s_889.begin(); itClass2s_88a!= class2s_889.end(); ++itClass2s_88a)
		{
			SFC::Class currClass2_88b= *itClass2s_88a;
			if( class2_87e!= currClass2_88b)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_88f;
			if( !isValidBound(boundObjs_88f, class1_875, true))
				continue;
			currMatch.class1_890= class1_875;
			if( !isValidBound(boundObjs_88f, class2_87e, true))
				continue;
			currMatch.class2_891= class2_87e;
			if( !isValidBound(boundObjs_88f, arg1_887, true))
				continue;
			currMatch.arg1_892= arg1_887;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void NoArgMatch_861::outputAppender( const SFC::Class& class1_893, const SFC::Class& class2_895, const SFC::Arg& arg1_897)
{
	_class1_86b->push_back( class1_893);
	_class2_86c->push_back( class2_895);
	_arg1_86d->push_back( arg1_897);
}

void BreakEquivalence_899::operator()( const Packets_t& class1s_89a, const Packets_t& class2s_89c, const Packets_t& args_89e)
{
#ifdef PRINT_INFO
	printLog("BreakEquivalence_899" );
#endif
	RTTGenerator::Instance()->generateRule(393, "BreakEquivalence");
	processInputPackets( class1s_89a, class2s_89c, args_89e);
}

bool BreakEquivalence_899::isInputUnique( const Udm::Object& class1_8a4, const Udm::Object& class2_8ad, const Udm::Object& arg_8b6)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_8a6= _class1_8a0.begin(), itClass2_8af= _class2_8a9.begin(), itArg_8b8= _arg_8b2.begin(); itClass1_8a6!= _class1_8a0.end(), itClass2_8af!= _class2_8a9.end(), itArg_8b8!= _arg_8b2.end(); ++itClass1_8a6, ++itClass2_8af, ++itArg_8b8)
	{
		if( ( *itClass1_8a6== class1_8a4)&& ( *itClass2_8af== class2_8ad)&& ( *itArg_8b8== arg_8b6))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_8a0.push_back( class1_8a4);
		_class2_8a9.push_back( class2_8ad);
		_arg_8b2.push_back( arg_8b6);
	}
	return isUnique;
}

bool BreakEquivalence_899::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void BreakEquivalence_899::processInputPackets( const Packets_t& class1s_89a, const Packets_t& class2s_89c, const Packets_t& args_89e)
{
	for( Packets_t::const_iterator itClass1_8a1= class1s_89a.begin(), itClass2_8aa= class2s_89c.begin(), itArg_8b3= args_89e.begin(); itClass1_8a1!= class1s_89a.end(), itClass2_8aa!= class2s_89c.end(), itArg_8b3!= args_89e.end(); ++itClass1_8a1, ++itClass2_8aa, ++itArg_8b3)
	{
		bool isUnique= isInputUnique( *itClass1_8a1, *itClass2_8aa, *itArg_8b3);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_8a1, *itClass2_8aa, *itArg_8b3);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool BreakEquivalence_899::patternMatcher( const Udm::Object& class1_8a2, const Udm::Object& class2_8ab, const Udm::Object& arg_8b4)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_8a2.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_8a7= SFC::Class::Cast( class1_8a2);
		if( false== Uml::IsDerivedFrom( class2_8ab.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_8b0= SFC::Class::Cast( class2_8ab);
		if( false== Uml::IsDerivedFrom( arg_8b4.type(), SFC::Arg::meta))
			continue;
		SFC::Arg arg_8b9= SFC::Arg::Cast( arg_8b4);
		set< SFC::Class> class2s_8bb= class1_8a7.equivdst();
		for( set< SFC::Class>::const_iterator itClass2s_8bc= class2s_8bb.begin(); itClass2s_8bc!= class2s_8bb.end(); ++itClass2s_8bc)
		{
			SFC::Class currClass2_8bd= *itClass2s_8bc;
			if( class2_8b0!= currClass2_8bd)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_8c1;
			if( !isValidBound(boundObjs_8c1, class1_8a7, true))
				continue;
			currMatch.class1_8c2= class1_8a7;
			if( !isValidBound(boundObjs_8c1, class2_8b0, true))
				continue;
			currMatch.class2_8c3= class2_8b0;
			if( !isValidBound(boundObjs_8c1, arg_8b9, true))
				continue;
			currMatch.arg_8c4= arg_8b9;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void BreakEquivalence_899::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.class1_8c2.equivdst()-= currMatch.class2_8c3;
	}
}

void GetMainFunctionArgs_8c5::operator()( const Packets_t& class1s_8c6, Packets_t& class1s_8c8, Packets_t& class2s_8c9, Packets_t& args_8ca)
{
#ifdef PRINT_INFO
	printLog("GetMainFunctionArgs_8c5" );
#endif
	RTTGenerator::Instance()->generateRule(398, "GetMainFunctionArgs");
	_class1_8cb= &class1s_8c8;
	_class2_8cc= &class2s_8c9;
	_arg_8cd= &args_8ca;
	processInputPackets( class1s_8c6);
}

bool GetMainFunctionArgs_8c5::isInputUnique( const Udm::Object& class1_8d2)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_8d4= _class1_8ce.begin(); itClass1_8d4!= _class1_8ce.end(); ++itClass1_8d4)
	{
		if( ( *itClass1_8d4== class1_8d2))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class1_8ce.push_back( class1_8d2);
	return isUnique;
}

bool GetMainFunctionArgs_8c5::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool GetMainFunctionArgs_8c5::isGuardTrue( SFC::Arg& Arg, SFC::Class& Class1, SFC::Class& Class2, SFC::Function& MainFunction1)
{
	bool Gz_guard= false;
	std::string functionName = MainFunction1.name();
return
 functionName.substr( functionName.size() - 5 ) == "_main" &&
 static_cast< __int64 >( Arg.argIndex() ) != 0
;;
	return Gz_guard;
}

void GetMainFunctionArgs_8c5::processInputPackets( const Packets_t& class1s_8c6)
{
	for( Packets_t::const_iterator itClass1_8cf= class1s_8c6.begin(); itClass1_8cf!= class1s_8c6.end(); ++itClass1_8cf)
	{
		bool isUnique= isInputUnique( *itClass1_8cf);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_8cf);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetMainFunctionArgs_8c5::patternMatcher( const Udm::Object& class1_8d0)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_8d0.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_8d5= SFC::Class::Cast( class1_8d0);
		set< SFC::Function> mainFunction1s_8d7= class1_8d5.Function_kind_children();
		for( set< SFC::Function>::const_iterator itMainFunction1_8d8= mainFunction1s_8d7.begin(); itMainFunction1_8d8!= mainFunction1s_8d7.end(); ++itMainFunction1_8d8)
		{
			SFC::Function currMainFunction1_8d9= *itMainFunction1_8d8;
			set< SFC::Arg> args_8da= currMainFunction1_8d9.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itArg_8db= args_8da.begin(); itArg_8db!= args_8da.end(); ++itArg_8db)
			{
				SFC::Arg currArg_8dc= *itArg_8db;
				set< SFC::Class> class2s_8dd= class1_8d5.equivdst();
				for( set< SFC::Class>::const_iterator itClass2s_8de= class2s_8dd.begin(); itClass2s_8de!= class2s_8dd.end(); ++itClass2s_8de)
				{
					SFC::Class currClass2_8df= *itClass2s_8de;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_8e3;
					if( !isValidBound(boundObjs_8e3, class1_8d5, true))
						continue;
					currMatch.class1_8e4= class1_8d5;
					if( !isValidBound(boundObjs_8e3, currClass2_8df, false))
						continue;
					currMatch.class2_8e5= currClass2_8df;
					if( !isValidBound(boundObjs_8e3, currArg_8dc, false))
						continue;
					currMatch.arg_8e6= currArg_8dc;
					if( !isValidBound(boundObjs_8e3, currMainFunction1_8d9, false))
						continue;
					currMatch.mainFunction1_8e7= currMainFunction1_8d9;
					bool Gz_guard= isGuardTrue( currMatch.arg_8e6, currMatch.class1_8e4, currMatch.class2_8e5, currMatch.mainFunction1_8e7);
					if( true== Gz_guard)
						_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void GetMainFunctionArgs_8c5::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class1_8e4, currMatch.class2_8e5, currMatch.arg_8e6);
	}
}

void GetMainFunctionArgs_8c5::outputAppender( const SFC::Class& class1_8ec, const SFC::Class& class2_8ee, const SFC::Arg& arg_8f0)
{
	_class1_8cb->push_back( class1_8ec);
	_class2_8cc->push_back( class2_8ee);
	_arg_8cd->push_back( arg_8f0);
}

void TestDataMembers_8fc::operator()( const Packets_t& classs_8fd, Packets_t& classs_8ff)
{
#ifdef PRINT_INFO
	printLog("TestDataMembers_8fc" );
#endif
	_class_900= &classs_8ff;
	if( ( !classs_8fd.empty()))
		callGetMembers_a64( classs_8fd);
	_class_900->insert( _class_900->end(), classs_8fd.begin(), classs_8fd.end());
}

void TestDataMembers_8fc::callGetMembers_a64( const Packets_t& class1s_902)
{
	Packets_t class1s_904;
	Packets_t class2s_905;
	Packets_t localVar1s_906;
	GetMembers_901 getMembers_901;
	getMembers_901( class1s_902, class1s_904, class2s_905, localVar1s_906);
	if( ( !class1s_904.empty())&& ( !class2s_905.empty())&& ( !localVar1s_906.empty()))
		callTestMembers_a66( class1s_904, class2s_905, localVar1s_906);
}

void TestDataMembers_8fc::callTestMembers_a66( const Packets_t& class1s_92b, const Packets_t& class2s_92d, const Packets_t& members_92f)
{
	Packets_t class1s_931;
	Packets_t class2s_932;
	Packets_t members_933;
	Packets_t class1s_934;
	Packets_t class2s_935;
	Packets_t members_936;
	Packets_t class1s_937;
	Packets_t class2s_938;
	Packets_t members_939;
	TestMembers_92a testMembers_92a;
	testMembers_92a( class1s_92b, class2s_92d, members_92f, class1s_931, class2s_932, members_933, class1s_934, class2s_935, members_936, class1s_937, class2s_938, members_939);
	if( ( !class1s_937.empty())&& ( !class2s_938.empty())&& ( !members_939.empty()))
		callBreakEquivalence_a6a( class1s_937, class2s_938, members_939);
}

void TestDataMembers_8fc::callBreakEquivalence_a6a( const Packets_t& class1s_a39, const Packets_t& class2s_a3b, const Packets_t& localVar1s_a3d)
{
	BreakEquivalence_a38 breakEquivalence_a38;
	breakEquivalence_a38( class1s_a39, class2s_a3b, localVar1s_a3d);
}

void GetMembers_901::operator()( const Packets_t& class1s_902, Packets_t& class1s_904, Packets_t& class2s_905, Packets_t& localVar1s_906)
{
#ifdef PRINT_INFO
	printLog("GetMembers_901" );
#endif
	RTTGenerator::Instance()->generateRule(409, "GetMembers");
	_class1_907= &class1s_904;
	_class2_908= &class2s_905;
	_localVar1_909= &localVar1s_906;
	processInputPackets( class1s_902);
}

bool GetMembers_901::isInputUnique( const Udm::Object& class1_90e)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_910= _class1_90a.begin(); itClass1_910!= _class1_90a.end(); ++itClass1_910)
	{
		if( ( *itClass1_910== class1_90e))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class1_90a.push_back( class1_90e);
	return isUnique;
}

bool GetMembers_901::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetMembers_901::processInputPackets( const Packets_t& class1s_902)
{
	for( Packets_t::const_iterator itClass1_90b= class1s_902.begin(); itClass1_90b!= class1s_902.end(); ++itClass1_90b)
	{
		bool isUnique= isInputUnique( *itClass1_90b);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_90b);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetMembers_901::patternMatcher( const Udm::Object& class1_90c)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_90c.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_911= SFC::Class::Cast( class1_90c);
		set< SFC::Struct> classStruct1s_913= class1_911.Struct_kind_children();
		for( set< SFC::Struct>::const_iterator itClassStruct1_914= classStruct1s_913.begin(); itClassStruct1_914!= classStruct1s_913.end(); ++itClassStruct1_914)
		{
			SFC::Struct currClassStruct1_915= *itClassStruct1_914;
			set< SFC::LocalVar> localVar1s_916= currClassStruct1_915.LocalVar_kind_children();
			for( set< SFC::LocalVar>::const_iterator itLocalVar1_917= localVar1s_916.begin(); itLocalVar1_917!= localVar1s_916.end(); ++itLocalVar1_917)
			{
				SFC::LocalVar currLocalVar1_918= *itLocalVar1_917;
				set< SFC::Class> class2s_919= class1_911.equivdst();
				for( set< SFC::Class>::const_iterator itClass2s_91a= class2s_919.begin(); itClass2s_91a!= class2s_919.end(); ++itClass2s_91a)
				{
					SFC::Class currClass2_91b= *itClass2s_91a;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_91f;
					if( !isValidBound(boundObjs_91f, class1_911, true))
						continue;
					currMatch.class1_920= class1_911;
					if( !isValidBound(boundObjs_91f, currClass2_91b, false))
						continue;
					currMatch.class2_921= currClass2_91b;
					if( !isValidBound(boundObjs_91f, currLocalVar1_918, false))
						continue;
					currMatch.localVar1_922= currLocalVar1_918;
					if( !isValidBound(boundObjs_91f, currClassStruct1_915, false))
						continue;
					currMatch.classStruct1_923= currClassStruct1_915;
					_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void GetMembers_901::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class1_920, currMatch.class2_921, currMatch.localVar1_922);
	}
}

void GetMembers_901::outputAppender( const SFC::Class& class1_924, const SFC::Class& class2_926, const SFC::LocalVar& localVar1_928)
{
	_class1_907->push_back( class1_924);
	_class2_908->push_back( class2_926);
	_localVar1_909->push_back( localVar1_928);
}

void TestMembers_92a::operator()( const Packets_t& class1s_92b, const Packets_t& class2s_92d, const Packets_t& members_92f, Packets_t& class1s_931, Packets_t& class2s_932, Packets_t& members_933, Packets_t& class1s_934, Packets_t& class2s_935, Packets_t& members_936, Packets_t& class1s_937, Packets_t& class2s_938, Packets_t& members_939)
{
#ifdef PRINT_INFO
	printLog("TestMembers_92a" );
#endif
	_class1_93a= &class1s_931;
	_class2_93b= &class2s_932;
	_member_93c= &members_933;
	_class1_93d= &class1s_934;
	_class2_93e= &class2s_935;
	_member_93f= &members_936;
	_class1_940= &class1s_937;
	_class2_941= &class2s_938;
	_member_942= &members_939;
	for( Packets_t::const_iterator itclass1_944= class1s_92b.begin(), itclass2_94b= class2s_92d.begin(), itmember_952= members_92f.begin(); itclass1_944!= class1s_92b.end(), itclass2_94b!= class2s_92d.end(), itmember_952!= members_92f.end(); ++itclass1_944, ++itclass2_94b, ++itmember_952)
	{
		bool isUnique= isInputUnique( *itclass1_944, *itclass2_94b, *itmember_952);
		if( !isUnique)
			continue;
		Packets_t oneclass1_948( 1, *itclass1_944);
		Packets_t oneclass2_94f( 1, *itclass2_94b);
		Packets_t onemember_956( 1, *itmember_952);
		executeOne( oneclass1_948, oneclass2_94f, onemember_956);
	}
}

void TestMembers_92a::executeOne( const Packets_t& class1s_92b, const Packets_t& class2s_92d, const Packets_t& members_92f)
{
	Packets_t class1s_95b;
	Packets_t class2s_95e;
	Packets_t localVar1s_961;
	ParameterMemberMatch_958 parameterMemberMatch_958;
	bool isMatchParameterMemberMatch_958= parameterMemberMatch_958( class1s_92b, class2s_92d, members_92f, class1s_95b, class2s_95e, localVar1s_961);
	_class1_93a->insert( _class1_93a->end(), class1s_95b.begin(), class1s_95b.end());
	_class2_93b->insert( _class2_93b->end(), class2s_95e.begin(), class2s_95e.end());
	_member_93c->insert( _member_93c->end(), localVar1s_961.begin(), localVar1s_961.end());
	if( isMatchParameterMemberMatch_958)
		return;
	Packets_t class1s_9ae;
	Packets_t class2s_9b1;
	Packets_t localVar1s_9b4;
	StructMemberMatch_9ab structMemberMatch_9ab;
	bool isMatchStructMemberMatch_9ab= structMemberMatch_9ab( class1s_92b, class2s_92d, members_92f, class1s_9ae, class2s_9b1, localVar1s_9b4);
	_class1_93d->insert( _class1_93d->end(), class1s_9ae.begin(), class1s_9ae.end());
	_class2_93e->insert( _class2_93e->end(), class2s_9b1.begin(), class2s_9b1.end());
	_member_93f->insert( _member_93f->end(), localVar1s_9b4.begin(), localVar1s_9b4.end());
	if( isMatchStructMemberMatch_9ab)
		return;
	Packets_t class1s_a03;
	Packets_t class2s_a06;
	Packets_t localVar1s_a09;
	NoMemberMatch_a00 noMemberMatch_a00;
	bool isMatchNoMemberMatch_a00= noMemberMatch_a00( class1s_92b, class2s_92d, members_92f, class1s_a03, class2s_a06, localVar1s_a09);
	_class1_940->insert( _class1_940->end(), class1s_a03.begin(), class1s_a03.end());
	_class2_941->insert( _class2_941->end(), class2s_a06.begin(), class2s_a06.end());
	_member_942->insert( _member_942->end(), localVar1s_a09.begin(), localVar1s_a09.end());
	if( isMatchNoMemberMatch_a00)
		return;
}

bool TestMembers_92a::isInputUnique( const Udm::Object& class1_945, const Udm::Object& class2_94c, const Udm::Object& member_953)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itclass1_947= _class1_943.begin(), itclass2_94e= _class2_94a.begin(), itmember_955= _member_951.begin(); itclass1_947!= _class1_943.end(), itclass2_94e!= _class2_94a.end(), itmember_955!= _member_951.end(); ++itclass1_947, ++itclass2_94e, ++itmember_955)
	{
		if( ( *itclass1_947== class1_945)&& ( *itclass2_94e== class2_94c)&& ( *itmember_955== member_953))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_943.push_back( class1_945);
		_class2_94a.push_back( class2_94c);
		_member_951.push_back( member_953);
	}
	return isUnique;
}

bool ParameterMemberMatch_958::operator()( const Packets_t& class1s_959, const Packets_t& class2s_95c, const Packets_t& localVar1s_95f, Packets_t& class1s_95b, Packets_t& class2s_95e, Packets_t& localVar1s_961)
{
#ifdef PRINT_INFO
	printLog("ParameterMemberMatch_958" );
#endif
	_class1_962= &class1s_95b;
	_class2_963= &class2s_95e;
	_localVar1_964= &localVar1s_961;
	processInputPackets( class1s_959, class2s_95c, localVar1s_95f);
	if( false== _matches.empty())
		return true;
	return false;
}

bool ParameterMemberMatch_958::isInputUnique( const Udm::Object& class1_969, const Udm::Object& class2_972, const Udm::Object& localVar1_97b)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_96b= _class1_965.begin(), itClass2_974= _class2_96e.begin(), itLocalVar1_97d= _localVar1_977.begin(); itClass1_96b!= _class1_965.end(), itClass2_974!= _class2_96e.end(), itLocalVar1_97d!= _localVar1_977.end(); ++itClass1_96b, ++itClass2_974, ++itLocalVar1_97d)
	{
		if( ( *itClass1_96b== class1_969)&& ( *itClass2_974== class2_972)&& ( *itLocalVar1_97d== localVar1_97b))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_965.push_back( class1_969);
		_class2_96e.push_back( class2_972);
		_localVar1_977.push_back( localVar1_97b);
	}
	return isUnique;
}

bool ParameterMemberMatch_958::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool ParameterMemberMatch_958::isGuardTrue( SFC::Class& Class1, SFC::Class& Class2, SFC::DT& DT, SFC::LocalVar& LocalVar1, SFC::LocalVar& LocalVar2, CyPhyML::SignalFlow::SF_Parameter& Parameter1, CyPhyML::SignalFlow::SF_Parameter& Parameter2, SFC::Struct& Struct2)
{
	bool Gz_guard= false;
	return SFUtils::InstanceEquivalent( Parameter1, Parameter2 );;
	return Gz_guard;
}

void ParameterMemberMatch_958::processInputPackets( const Packets_t& class1s_959, const Packets_t& class2s_95c, const Packets_t& localVar1s_95f)
{
	for( Packets_t::const_iterator itClass1_966= class1s_959.begin(), itClass2_96f= class2s_95c.begin(), itLocalVar1_978= localVar1s_95f.begin(); itClass1_966!= class1s_959.end(), itClass2_96f!= class2s_95c.end(), itLocalVar1_978!= localVar1s_95f.end(); ++itClass1_966, ++itClass2_96f, ++itLocalVar1_978)
	{
		bool isUnique= isInputUnique( *itClass1_966, *itClass2_96f, *itLocalVar1_978);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_966, *itClass2_96f, *itLocalVar1_978);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class1_995, currMatch.class2_996, currMatch.localVar1_997);
	}
}

bool ParameterMemberMatch_958::patternMatcher( const Udm::Object& class1_967, const Udm::Object& class2_970, const Udm::Object& localVar1_979)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_967.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_96c= SFC::Class::Cast( class1_967);
		if( false== Uml::IsDerivedFrom( class2_970.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_975= SFC::Class::Cast( class2_970);
		if( false== Uml::IsDerivedFrom( localVar1_979.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar1_97e= SFC::LocalVar::Cast( localVar1_979);
		set< SFC::Class> class2s_980= class1_96c.equivdst();
		for( set< SFC::Class>::const_iterator itClass2s_981= class2s_980.begin(); itClass2s_981!= class2s_980.end(); ++itClass2s_981)
		{
			SFC::Class currClass2_982= *itClass2s_981;
			if( class2_975!= currClass2_982)
				continue;
			set< SFC::Struct> struct2s_983= class2_975.Struct_kind_children();
			for( set< SFC::Struct>::const_iterator itStruct2_984= struct2s_983.begin(); itStruct2_984!= struct2s_983.end(); ++itStruct2_984)
			{
				SFC::Struct currStruct2_985= *itStruct2_984;
				set< SFC::LocalVar> localVar2s_986= currStruct2_985.LocalVar_kind_children();
				for( set< SFC::LocalVar>::const_iterator itLocalVar2_987= localVar2s_986.begin(); itLocalVar2_987!= localVar2s_986.end(); ++itLocalVar2_987)
				{
					SFC::LocalVar currLocalVar2_988= *itLocalVar2_987;
					SFC::DT dT_989= currLocalVar2_988.dt();
					if( !dT_989)
						continue;
					SFC::DT dT_98a= localVar1_97e.dt();
					if( !dT_98a)
						continue;
					if( dT_989!= dT_98a)
						continue;
					set< CyPhyML::SignalFlow::SF_Parameter> parameter1s_98b= localVar1_97e.param();
					for( set< CyPhyML::SignalFlow::SF_Parameter>::const_iterator itParameter1s_98c= parameter1s_98b.begin(); itParameter1s_98c!= parameter1s_98b.end(); ++itParameter1s_98c)
					{
						CyPhyML::SignalFlow::SF_Parameter currParameter1_98d= *itParameter1s_98c;
						set< CyPhyML::SignalFlow::SF_Parameter> parameter2s_98e= currLocalVar2_988.param();
						for( set< CyPhyML::SignalFlow::SF_Parameter>::const_iterator itParameter2s_98f= parameter2s_98e.begin(); itParameter2s_98f!= parameter2s_98e.end(); ++itParameter2s_98f)
						{
							CyPhyML::SignalFlow::SF_Parameter currParameter2_990= *itParameter2s_98f;
							Match currMatch;
							set< pair<int, Udm::Object> > boundObjs_994;
							if( !isValidBound(boundObjs_994, class1_96c, true))
								continue;
							currMatch.class1_995= class1_96c;
							if( !isValidBound(boundObjs_994, class2_975, true))
								continue;
							currMatch.class2_996= class2_975;
							if( !isValidBound(boundObjs_994, localVar1_97e, true))
								continue;
							currMatch.localVar1_997= localVar1_97e;
							if( !isValidBound(boundObjs_994, currParameter2_990, false))
								continue;
							currMatch.parameter2_998= currParameter2_990;
							if( !isValidBound(boundObjs_994, currStruct2_985, false))
								continue;
							currMatch.struct2_999= currStruct2_985;
							if( !isValidBound(boundObjs_994, currLocalVar2_988, false))
								continue;
							currMatch.localVar2_99a= currLocalVar2_988;
							if( !isValidBound(boundObjs_994, dT_989, false))
								continue;
							currMatch.dT_99b= dT_989;
							if( !isValidBound(boundObjs_994, currParameter1_98d, false))
								continue;
							currMatch.parameter1_99c= currParameter1_98d;
							bool Gz_guard= isGuardTrue( currMatch.class1_995, currMatch.class2_996, currMatch.dT_99b, currMatch.localVar1_997, currMatch.localVar2_99a, currMatch.parameter1_99c, currMatch.parameter2_998, currMatch.struct2_999);
							if( true== Gz_guard)
								_matches.push_back( currMatch);
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void ParameterMemberMatch_958::outputAppender( const SFC::Class& class1_9a5, const SFC::Class& class2_9a7, const SFC::LocalVar& localVar1_9a9)
{
	_class1_962->push_back( class1_9a5);
	_class2_963->push_back( class2_9a7);
	_localVar1_964->push_back( localVar1_9a9);
}

bool StructMemberMatch_9ab::operator()( const Packets_t& class1s_9ac, const Packets_t& class2s_9af, const Packets_t& localVar1s_9b2, Packets_t& class1s_9ae, Packets_t& class2s_9b1, Packets_t& localVar1s_9b4)
{
#ifdef PRINT_INFO
	printLog("StructMemberMatch_9ab" );
#endif
	_class1_9b5= &class1s_9ae;
	_class2_9b6= &class2s_9b1;
	_localVar1_9b7= &localVar1s_9b4;
	processInputPackets( class1s_9ac, class2s_9af, localVar1s_9b2);
	if( false== _matches.empty())
		return true;
	return false;
}

bool StructMemberMatch_9ab::isInputUnique( const Udm::Object& class1_9bc, const Udm::Object& class2_9c5, const Udm::Object& localVar1_9ce)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_9be= _class1_9b8.begin(), itClass2_9c7= _class2_9c1.begin(), itLocalVar1_9d0= _localVar1_9ca.begin(); itClass1_9be!= _class1_9b8.end(), itClass2_9c7!= _class2_9c1.end(), itLocalVar1_9d0!= _localVar1_9ca.end(); ++itClass1_9be, ++itClass2_9c7, ++itLocalVar1_9d0)
	{
		if( ( *itClass1_9be== class1_9bc)&& ( *itClass2_9c7== class2_9c5)&& ( *itLocalVar1_9d0== localVar1_9ce))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_9b8.push_back( class1_9bc);
		_class2_9c1.push_back( class2_9c5);
		_localVar1_9ca.push_back( localVar1_9ce);
	}
	return isUnique;
}

bool StructMemberMatch_9ab::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool StructMemberMatch_9ab::isGuardTrue( SFC::Class& Class, SFC::Class& Class1, SFC::Class& Class2, SFC::LocalVar& LocalVar1, SFC::LocalVar& LocalVar2, SFC::Struct& Struct2, CyPhyML::SignalFlow::Subsystem& Subsystem1, CyPhyML::SignalFlow::Subsystem& Subsystem2)
{
	bool Gz_guard= false;
	return SFUtils::InstanceCorrespond( Subsystem1, Subsystem2 );;
	return Gz_guard;
}

void StructMemberMatch_9ab::processInputPackets( const Packets_t& class1s_9ac, const Packets_t& class2s_9af, const Packets_t& localVar1s_9b2)
{
	for( Packets_t::const_iterator itClass1_9b9= class1s_9ac.begin(), itClass2_9c2= class2s_9af.begin(), itLocalVar1_9cb= localVar1s_9b2.begin(); itClass1_9b9!= class1s_9ac.end(), itClass2_9c2!= class2s_9af.end(), itLocalVar1_9cb!= localVar1s_9b2.end(); ++itClass1_9b9, ++itClass2_9c2, ++itLocalVar1_9cb)
	{
		bool isUnique= isInputUnique( *itClass1_9b9, *itClass2_9c2, *itLocalVar1_9cb);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_9b9, *itClass2_9c2, *itLocalVar1_9cb);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class1_9ea, currMatch.class2_9eb, currMatch.localVar1_9ec);
	}
}

bool StructMemberMatch_9ab::patternMatcher( const Udm::Object& class1_9ba, const Udm::Object& class2_9c3, const Udm::Object& localVar1_9cc)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_9ba.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_9bf= SFC::Class::Cast( class1_9ba);
		if( false== Uml::IsDerivedFrom( class2_9c3.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_9c8= SFC::Class::Cast( class2_9c3);
		if( false== Uml::IsDerivedFrom( localVar1_9cc.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar1_9d1= SFC::LocalVar::Cast( localVar1_9cc);
		set< SFC::Class> class2s_9d3= class1_9bf.equivdst();
		for( set< SFC::Class>::const_iterator itClass2s_9d4= class2s_9d3.begin(); itClass2s_9d4!= class2s_9d3.end(); ++itClass2s_9d4)
		{
			SFC::Class currClass2_9d5= *itClass2s_9d4;
			if( class2_9c8!= currClass2_9d5)
				continue;
			set< SFC::Struct> struct2s_9d6= class2_9c8.Struct_kind_children();
			for( set< SFC::Struct>::const_iterator itStruct2_9d7= struct2s_9d6.begin(); itStruct2_9d7!= struct2s_9d6.end(); ++itStruct2_9d7)
			{
				SFC::Struct currStruct2_9d8= *itStruct2_9d7;
				set< SFC::LocalVar> localVar2s_9d9= currStruct2_9d8.LocalVar_kind_children();
				for( set< SFC::LocalVar>::const_iterator itLocalVar2_9da= localVar2s_9d9.begin(); itLocalVar2_9da!= localVar2s_9d9.end(); ++itLocalVar2_9da)
				{
					SFC::LocalVar currLocalVar2_9db= *itLocalVar2_9da;
					set< CyPhyML::SignalFlow::Subsystem> subsystem1s_9dc= localVar1_9d1.sys();
					for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itSubsystem1s_9dd= subsystem1s_9dc.begin(); itSubsystem1s_9dd!= subsystem1s_9dc.end(); ++itSubsystem1s_9dd)
					{
						CyPhyML::SignalFlow::Subsystem currSubsystem1_9de= *itSubsystem1s_9dd;
						SFC::Class class_9df= currSubsystem1_9de.cls();
						if( !class_9df)
							continue;
						set< CyPhyML::SignalFlow::Subsystem> subsystem2s_9e0= class_9df.obj();
						for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itSubsystem2s_9e1= subsystem2s_9e0.begin(); itSubsystem2s_9e1!= subsystem2s_9e0.end(); ++itSubsystem2s_9e1)
						{
							CyPhyML::SignalFlow::Subsystem currSubsystem2_9e2= *itSubsystem2s_9e1;
							set< CyPhyML::SignalFlow::Subsystem> subsystem2s_9e3= currLocalVar2_9db.sys();
							for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itSubsystem2s_9e4= subsystem2s_9e3.begin(); itSubsystem2s_9e4!= subsystem2s_9e3.end(); ++itSubsystem2s_9e4)
							{
								CyPhyML::SignalFlow::Subsystem currSubsystem2_9e5= *itSubsystem2s_9e4;
								if( currSubsystem2_9e2!= currSubsystem2_9e5)
									continue;
								Match currMatch;
								set< pair<int, Udm::Object> > boundObjs_9e9;
								if( !isValidBound(boundObjs_9e9, class1_9bf, true))
									continue;
								currMatch.class1_9ea= class1_9bf;
								if( !isValidBound(boundObjs_9e9, class2_9c8, true))
									continue;
								currMatch.class2_9eb= class2_9c8;
								if( !isValidBound(boundObjs_9e9, localVar1_9d1, true))
									continue;
								currMatch.localVar1_9ec= localVar1_9d1;
								if( !isValidBound(boundObjs_9e9, currStruct2_9d8, false))
									continue;
								currMatch.struct2_9ed= currStruct2_9d8;
								if( !isValidBound(boundObjs_9e9, currLocalVar2_9db, false))
									continue;
								currMatch.localVar2_9ee= currLocalVar2_9db;
								if( !isValidBound(boundObjs_9e9, class_9df, false))
									continue;
								currMatch.class_9ef= class_9df;
								if( !isValidBound(boundObjs_9e9, currSubsystem1_9de, false))
									continue;
								currMatch.subsystem1_9f0= currSubsystem1_9de;
								if( !isValidBound(boundObjs_9e9, currSubsystem2_9e2, false))
									continue;
								currMatch.subsystem2_9f1= currSubsystem2_9e2;
								bool Gz_guard= isGuardTrue( currMatch.class_9ef, currMatch.class1_9ea, currMatch.class2_9eb, currMatch.localVar1_9ec, currMatch.localVar2_9ee, currMatch.struct2_9ed, currMatch.subsystem1_9f0, currMatch.subsystem2_9f1);
								if( true== Gz_guard)
									_matches.push_back( currMatch);
							}
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void StructMemberMatch_9ab::outputAppender( const SFC::Class& class1_9fa, const SFC::Class& class2_9fc, const SFC::LocalVar& localVar1_9fe)
{
	_class1_9b5->push_back( class1_9fa);
	_class2_9b6->push_back( class2_9fc);
	_localVar1_9b7->push_back( localVar1_9fe);
}

bool NoMemberMatch_a00::operator()( const Packets_t& class1s_a01, const Packets_t& class2s_a04, const Packets_t& localVar1s_a07, Packets_t& class1s_a03, Packets_t& class2s_a06, Packets_t& localVar1s_a09)
{
#ifdef PRINT_INFO
	printLog("NoMemberMatch_a00" );
#endif
	_class1_a0a= &class1s_a03;
	_class2_a0b= &class2s_a06;
	_localVar1_a0c= &localVar1s_a09;
	processInputPackets( class1s_a01, class2s_a04, localVar1s_a07);
	if( false== _matches.empty())
		return true;
	return false;
}

bool NoMemberMatch_a00::isInputUnique( const Udm::Object& class1_a11, const Udm::Object& class2_a1a, const Udm::Object& localVar1_a23)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_a13= _class1_a0d.begin(), itClass2_a1c= _class2_a16.begin(), itLocalVar1_a25= _localVar1_a1f.begin(); itClass1_a13!= _class1_a0d.end(), itClass2_a1c!= _class2_a16.end(), itLocalVar1_a25!= _localVar1_a1f.end(); ++itClass1_a13, ++itClass2_a1c, ++itLocalVar1_a25)
	{
		if( ( *itClass1_a13== class1_a11)&& ( *itClass2_a1c== class2_a1a)&& ( *itLocalVar1_a25== localVar1_a23))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_a0d.push_back( class1_a11);
		_class2_a16.push_back( class2_a1a);
		_localVar1_a1f.push_back( localVar1_a23);
	}
	return isUnique;
}

bool NoMemberMatch_a00::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void NoMemberMatch_a00::processInputPackets( const Packets_t& class1s_a01, const Packets_t& class2s_a04, const Packets_t& localVar1s_a07)
{
	for( Packets_t::const_iterator itClass1_a0e= class1s_a01.begin(), itClass2_a17= class2s_a04.begin(), itLocalVar1_a20= localVar1s_a07.begin(); itClass1_a0e!= class1s_a01.end(), itClass2_a17!= class2s_a04.end(), itLocalVar1_a20!= localVar1s_a07.end(); ++itClass1_a0e, ++itClass2_a17, ++itLocalVar1_a20)
	{
		bool isUnique= isInputUnique( *itClass1_a0e, *itClass2_a17, *itLocalVar1_a20);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_a0e, *itClass2_a17, *itLocalVar1_a20);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class1_a2f, currMatch.class2_a30, currMatch.localVar1_a31);
	}
}

bool NoMemberMatch_a00::patternMatcher( const Udm::Object& class1_a0f, const Udm::Object& class2_a18, const Udm::Object& localVar1_a21)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_a0f.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_a14= SFC::Class::Cast( class1_a0f);
		if( false== Uml::IsDerivedFrom( class2_a18.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_a1d= SFC::Class::Cast( class2_a18);
		if( false== Uml::IsDerivedFrom( localVar1_a21.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar1_a26= SFC::LocalVar::Cast( localVar1_a21);
		set< SFC::Class> class2s_a28= class1_a14.equivdst();
		for( set< SFC::Class>::const_iterator itClass2s_a29= class2s_a28.begin(); itClass2s_a29!= class2s_a28.end(); ++itClass2s_a29)
		{
			SFC::Class currClass2_a2a= *itClass2s_a29;
			if( class2_a1d!= currClass2_a2a)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_a2e;
			if( !isValidBound(boundObjs_a2e, class1_a14, true))
				continue;
			currMatch.class1_a2f= class1_a14;
			if( !isValidBound(boundObjs_a2e, class2_a1d, true))
				continue;
			currMatch.class2_a30= class2_a1d;
			if( !isValidBound(boundObjs_a2e, localVar1_a26, true))
				continue;
			currMatch.localVar1_a31= localVar1_a26;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void NoMemberMatch_a00::outputAppender( const SFC::Class& class1_a32, const SFC::Class& class2_a34, const SFC::LocalVar& localVar1_a36)
{
	_class1_a0a->push_back( class1_a32);
	_class2_a0b->push_back( class2_a34);
	_localVar1_a0c->push_back( localVar1_a36);
}

void BreakEquivalence_a38::operator()( const Packets_t& class1s_a39, const Packets_t& class2s_a3b, const Packets_t& localVar1s_a3d)
{
#ifdef PRINT_INFO
	printLog("BreakEquivalence_a38" );
#endif
	RTTGenerator::Instance()->generateRule(467, "BreakEquivalence");
	processInputPackets( class1s_a39, class2s_a3b, localVar1s_a3d);
}

bool BreakEquivalence_a38::isInputUnique( const Udm::Object& class1_a43, const Udm::Object& class2_a4c, const Udm::Object& localVar1_a55)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_a45= _class1_a3f.begin(), itClass2_a4e= _class2_a48.begin(), itLocalVar1_a57= _localVar1_a51.begin(); itClass1_a45!= _class1_a3f.end(), itClass2_a4e!= _class2_a48.end(), itLocalVar1_a57!= _localVar1_a51.end(); ++itClass1_a45, ++itClass2_a4e, ++itLocalVar1_a57)
	{
		if( ( *itClass1_a45== class1_a43)&& ( *itClass2_a4e== class2_a4c)&& ( *itLocalVar1_a57== localVar1_a55))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_a3f.push_back( class1_a43);
		_class2_a48.push_back( class2_a4c);
		_localVar1_a51.push_back( localVar1_a55);
	}
	return isUnique;
}

bool BreakEquivalence_a38::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void BreakEquivalence_a38::processInputPackets( const Packets_t& class1s_a39, const Packets_t& class2s_a3b, const Packets_t& localVar1s_a3d)
{
	for( Packets_t::const_iterator itClass1_a40= class1s_a39.begin(), itClass2_a49= class2s_a3b.begin(), itLocalVar1_a52= localVar1s_a3d.begin(); itClass1_a40!= class1s_a39.end(), itClass2_a49!= class2s_a3b.end(), itLocalVar1_a52!= localVar1s_a3d.end(); ++itClass1_a40, ++itClass2_a49, ++itLocalVar1_a52)
	{
		bool isUnique= isInputUnique( *itClass1_a40, *itClass2_a49, *itLocalVar1_a52);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_a40, *itClass2_a49, *itLocalVar1_a52);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool BreakEquivalence_a38::patternMatcher( const Udm::Object& class1_a41, const Udm::Object& class2_a4a, const Udm::Object& localVar1_a53)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_a41.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_a46= SFC::Class::Cast( class1_a41);
		if( false== Uml::IsDerivedFrom( class2_a4a.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_a4f= SFC::Class::Cast( class2_a4a);
		if( false== Uml::IsDerivedFrom( localVar1_a53.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar1_a58= SFC::LocalVar::Cast( localVar1_a53);
		set< SFC::Class> class2s_a5a= class1_a46.equivdst();
		for( set< SFC::Class>::const_iterator itClass2s_a5b= class2s_a5a.begin(); itClass2s_a5b!= class2s_a5a.end(); ++itClass2s_a5b)
		{
			SFC::Class currClass2_a5c= *itClass2s_a5b;
			if( class2_a4f!= currClass2_a5c)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_a60;
			if( !isValidBound(boundObjs_a60, class1_a46, true))
				continue;
			currMatch.class1_a61= class1_a46;
			if( !isValidBound(boundObjs_a60, class2_a4f, true))
				continue;
			currMatch.class2_a62= class2_a4f;
			if( !isValidBound(boundObjs_a60, localVar1_a58, true))
				continue;
			currMatch.localVar1_a63= localVar1_a58;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void BreakEquivalence_a38::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.class1_a61.equivdst()-= currMatch.class2_a62;
	}
}

void ElimEquiv_a72::operator()( const Packets_t& classs_a73)
{
#ifdef PRINT_INFO
	printLog("ElimEquiv_a72" );
#endif
	for( Packets_t::const_iterator itclass_a76= classs_a73.begin(); itclass_a76!= classs_a73.end(); ++itclass_a76)
	{
		bool isUnique= isInputUnique( *itclass_a76);
		if( !isUnique)
			continue;
		Packets_t oneclass_a7a( 1, *itclass_a76);
		executeOne( oneclass_a7a);
	}
}

void ElimEquiv_a72::executeOne( const Packets_t& classs_a73)
{
	if( ( !classs_a73.empty()))
		callGetEquivalence_d27( classs_a73);
}

bool ElimEquiv_a72::isInputUnique( const Udm::Object& class_a77)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itclass_a79= _class_a75.begin(); itclass_a79!= _class_a75.end(); ++itclass_a79)
	{
		if( ( *itclass_a79== class_a77))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class_a75.push_back( class_a77);
	return isUnique;
}

void ElimEquiv_a72::callGetEquivalence_d27( const Packets_t& class1s_d0b)
{
	Packets_t class1s_d0d;
	Packets_t class2s_d0e;
	GetEquivalence_d0a getEquivalence_d0a;
	getEquivalence_d0a( class1s_d0b, class1s_d0d, class2s_d0e);
	if( ( !class1s_d0d.empty())&& ( !class2s_d0e.empty()))
		callTransferSubsystems_d29( class1s_d0d, class2s_d0e);
}

void ElimEquiv_a72::callTransferSubsystems_d29( const Packets_t& class1s_cde, const Packets_t& class2s_ce0)
{
	Packets_t class1s_ce2;
	Packets_t class2s_ce3;
	TransferSubsystems_cdd transferSubsystems_cdd;
	transferSubsystems_cdd( class1s_cde, class2s_ce0, class1s_ce2, class2s_ce3);
	if( ( !class1s_ce2.empty())&& ( !class2s_ce3.empty()))
		callTransferMethodCalls_d2c( class1s_ce2, class2s_ce3);
}

void ElimEquiv_a72::callTransferMethodCalls_d2c( const Packets_t& class1s_ac5, const Packets_t& class2s_ac7)
{
	Packets_t class1s_ac9;
	Packets_t class2s_aca;
	TransferMethodCalls_ac4 transferMethodCalls_ac4;
	transferMethodCalls_ac4( class1s_ac5, class2s_ac7, class1s_ac9, class2s_aca);
	if( ( !class1s_ac9.empty())&& ( !class2s_aca.empty()))
		callTransferStruct_d2f( class1s_ac9, class2s_aca);
}

void ElimEquiv_a72::callTransferStruct_d2f( const Packets_t& class1s_b73, const Packets_t& class2s_b75)
{
	Packets_t deleteclasss_b77;
	TransferStruct_b72 transferStruct_b72;
	transferStruct_b72( class1s_b73, class2s_b75, deleteclasss_b77);
	if( ( !deleteclasss_b77.empty()))
		callDeleteClass_d32( deleteclasss_b77);
}

void ElimEquiv_a72::callDeleteClass_d32( const Packets_t& deleteClasss_a7d)
{
	DeleteClass_a7c deleteClass_a7c;
	deleteClass_a7c( deleteClasss_a7d);
}

void DeleteClass_a7c::operator()( const Packets_t& deleteClasss_a7d)
{
#ifdef PRINT_INFO
	printLog("DeleteClass_a7c" );
#endif
	if( ( !deleteClasss_a7d.empty()))
		callmarkClass_abe( deleteClasss_a7d);
}

void DeleteClass_a7c::callmarkClass_abe( const Packets_t& classs_aac)
{
	Packets_t classs_aae;
	MarkClass_aab markClass_aab;
	markClass_aab( classs_aac, classs_aae);
	if( ( !classs_aae.empty()))
		callnoEquivDst_ac0( classs_aae);
}

void DeleteClass_a7c::callnoEquivDst_ac0( const Packets_t& class2s_a95)
{
	Packets_t class2s_a97;
	NoEquivDst_a94 noEquivDst_a94;
	noEquivDst_a94( class2s_a95, class2s_a97);
	if( ( !class2s_a97.empty()))
		callnoEquivSrc_ac2( class2s_a97);
}

void DeleteClass_a7c::callnoEquivSrc_ac2( const Packets_t& class1s_a80)
{
	NoEquivSrc_a7f noEquivSrc_a7f;
	noEquivSrc_a7f( class1s_a80);
}

void NoEquivSrc_a7f::operator()( const Packets_t& class1s_a80)
{
#ifdef PRINT_INFO
	printLog("NoEquivSrc_a7f" );
#endif
	RTTGenerator::Instance()->generateRule(476, "noEquivSrc");
	processInputPackets( class1s_a80);
}

bool NoEquivSrc_a7f::isInputUnique( const Udm::Object& class1_a86)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_a88= _class1_a82.begin(); itClass1_a88!= _class1_a82.end(); ++itClass1_a88)
	{
		if( ( *itClass1_a88== class1_a86))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class1_a82.push_back( class1_a86);
	return isUnique;
}

bool NoEquivSrc_a7f::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void NoEquivSrc_a7f::processInputPackets( const Packets_t& class1s_a80)
{
	for( Packets_t::const_iterator itClass1_a83= class1s_a80.begin(); itClass1_a83!= class1s_a80.end(); ++itClass1_a83)
	{
		bool isUnique= isInputUnique( *itClass1_a83);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_a83);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool NoEquivSrc_a7f::patternMatcher( const Udm::Object& class1_a84)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_a84.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_a89= SFC::Class::Cast( class1_a84);
		set< SFC::Class> class2s_a8b= class1_a89.equivdst();
		for( set< SFC::Class>::const_iterator itClass2s_a8c= class2s_a8b.begin(); itClass2s_a8c!= class2s_a8b.end(); ++itClass2s_a8c)
		{
			SFC::Class currClass2_a8d= *itClass2s_a8c;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_a91;
			if( !isValidBound(boundObjs_a91, class1_a89, true))
				continue;
			currMatch.class1_a92= class1_a89;
			if( !isValidBound(boundObjs_a91, currClass2_a8d, false))
				continue;
			currMatch.class2_a93= currClass2_a8d;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void NoEquivSrc_a7f::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
	}
}

void NoEquivDst_a94::operator()( const Packets_t& class2s_a95, Packets_t& class2s_a97)
{
#ifdef PRINT_INFO
	printLog("NoEquivDst_a94" );
#endif
	RTTGenerator::Instance()->generateRule(480, "noEquivDst");
	_class2_a98= &class2s_a97;
	processInputPackets( class2s_a95);
	forwardInputs( );
}

bool NoEquivDst_a94::isInputUnique( const Udm::Object& class2_a9d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass2_a9f= _class2_a99.begin(); itClass2_a9f!= _class2_a99.end(); ++itClass2_a9f)
	{
		if( ( *itClass2_a9f== class2_a9d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class2_a99.push_back( class2_a9d);
	return isUnique;
}

bool NoEquivDst_a94::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void NoEquivDst_a94::processInputPackets( const Packets_t& class2s_a95)
{
	for( Packets_t::const_iterator itClass2_a9a= class2s_a95.begin(); itClass2_a9a!= class2s_a95.end(); ++itClass2_a9a)
	{
		bool isUnique= isInputUnique( *itClass2_a9a);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass2_a9a);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool NoEquivDst_a94::patternMatcher( const Udm::Object& class2_a9b)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class2_a9b.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_aa0= SFC::Class::Cast( class2_a9b);
		set< SFC::Class> class1s_aa2= class2_aa0.equivsrc();
		for( set< SFC::Class>::const_iterator itClass1s_aa3= class1s_aa2.begin(); itClass1s_aa3!= class1s_aa2.end(); ++itClass1s_aa3)
		{
			SFC::Class currClass1_aa4= *itClass1s_aa3;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_aa8;
			if( !isValidBound(boundObjs_aa8, class2_aa0, true))
				continue;
			currMatch.class2_aa9= class2_aa0;
			if( !isValidBound(boundObjs_aa8, currClass1_aa4, false))
				continue;
			currMatch.class1_aaa= currClass1_aa4;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void NoEquivDst_a94::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.class1_aaa.equivdst()-= currMatch.class2_aa9;
	}
}

void NoEquivDst_a94::forwardInputs()
{
	*_class2_a98= _class2_a99;
}

void MarkClass_aab::operator()( const Packets_t& classs_aac, Packets_t& classs_aae)
{
#ifdef PRINT_INFO
	printLog("MarkClass_aab" );
#endif
	RTTGenerator::Instance()->generateRule(484, "markClass");
	_class_aaf= &classs_aae;
	processInputPackets( classs_aac);
	forwardInputs( );
}

bool MarkClass_aab::isInputUnique( const Udm::Object& class_ab4)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass_ab6= _class_ab0.begin(); itClass_ab6!= _class_ab0.end(); ++itClass_ab6)
	{
		if( ( *itClass_ab6== class_ab4))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class_ab0.push_back( class_ab4);
	return isUnique;
}

bool MarkClass_aab::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void MarkClass_aab::processInputPackets( const Packets_t& classs_aac)
{
	for( Packets_t::const_iterator itClass_ab1= classs_aac.begin(); itClass_ab1!= classs_aac.end(); ++itClass_ab1)
	{
		bool isUnique= isInputUnique( *itClass_ab1);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass_ab1);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool MarkClass_aab::patternMatcher( const Udm::Object& class_ab2)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class_ab2.type(), SFC::Class::meta))
			continue;
		SFC::Class class_ab7= SFC::Class::Cast( class_ab2);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_abc;
		if( !isValidBound(boundObjs_abc, class_ab7, true))
			continue;
		currMatch.class_abd= class_ab7;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void MarkClass_aab::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Class& Class= currMatch.class_abd;
		{
Class.statementCount() = -Class.statementCount();
};
	}
}

void MarkClass_aab::forwardInputs()
{
	*_class_aaf= _class_ab0;
}

void TransferMethodCalls_ac4::operator()( const Packets_t& class1s_ac5, const Packets_t& class2s_ac7, Packets_t& class1s_ac9, Packets_t& class2s_aca)
{
#ifdef PRINT_INFO
	printLog("TransferMethodCalls_ac4" );
#endif
	_class1_acb= &class1s_ac9;
	_class2_acc= &class2s_aca;
	if( ( !class1s_ac5.empty())&& ( !class2s_ac7.empty()))
		callGetMethods_b6c( class1s_ac5, class2s_ac7);
	_class1_acb->insert( _class1_acb->end(), class1s_ac5.begin(), class1s_ac5.end());
	_class2_acc->insert( _class2_acc->end(), class2s_ac7.begin(), class2s_ac7.end());
}

void TransferMethodCalls_ac4::callGetMethods_b6c( const Packets_t& class1s_b3d, const Packets_t& class2s_b40)
{
	Packets_t method1s_b3c;
	Packets_t method2s_b3f;
	GetMethods_b3b getMethods_b3b;
	getMethods_b3b( class1s_b3d, class2s_b40, method1s_b3c, method2s_b3f);
	if( ( !method1s_b3c.empty())&& ( !method2s_b3f.empty()))
		callTransferMethodCalls_b6f( method1s_b3c, method2s_b3f);
}

void TransferMethodCalls_ac4::callTransferMethodCalls_b6f( const Packets_t& method1s_ace, const Packets_t& method2s_ad0)
{
	TransferMethodCalls_acd transferMethodCalls_acd;
	transferMethodCalls_acd( method1s_ace, method2s_ad0);
}

void TransferMethodCalls_acd::operator()( const Packets_t& method1s_ace, const Packets_t& method2s_ad0)
{
#ifdef PRINT_INFO
	printLog("TransferMethodCalls_acd" );
#endif
	if( ( !method1s_ace.empty())&& ( !method2s_ad0.empty()))
		callTransferMethodCallArgs_b35( method1s_ace, method2s_ad0);
}

void TransferMethodCalls_acd::callTransferMethodCallArgs_b35( const Packets_t& method1s_ad3, const Packets_t& method2s_ad5)
{
	Packets_t method1s_ad7;
	Packets_t method2s_ad8;
	TransferMethodCallArgs_ad2 transferMethodCallArgs_ad2;
	transferMethodCallArgs_ad2( method1s_ad3, method2s_ad5, method1s_ad7, method2s_ad8);
	if( ( !method1s_ad7.empty())&& ( !method2s_ad8.empty()))
		callTransferMethodCallTarget_b38( method1s_ad7, method2s_ad8);
}

void TransferMethodCalls_acd::callTransferMethodCallTarget_b38( const Packets_t& method1s_b15, const Packets_t& method2s_b17)
{
	TransferMethodCallTarget_b14 transferMethodCallTarget_b14;
	transferMethodCallTarget_b14( method1s_b15, method2s_b17);
}

void TransferMethodCallArgs_ad2::operator()( const Packets_t& method1s_ad3, const Packets_t& method2s_ad5, Packets_t& method1s_ad7, Packets_t& method2s_ad8)
{
#ifdef PRINT_INFO
	printLog("TransferMethodCallArgs_ad2" );
#endif
	_method1_ad9= &method1s_ad7;
	_method2_ada= &method2s_ad8;
	_method1_ad9->insert( _method1_ad9->end(), method1s_ad3.begin(), method1s_ad3.end());
	_method2_ada->insert( _method2_ada->end(), method2s_ad5.begin(), method2s_ad5.end());
	if( ( !method1s_ad3.empty())&& ( !method2s_ad5.empty()))
		callTransferMethodCallArgs_b11( method1s_ad3, method2s_ad5);
}

void TransferMethodCallArgs_ad2::callTransferMethodCallArgs_b11( const Packets_t& method1s_adc, const Packets_t& method2s_ade)
{
	TransferMethodCallArgs_adb transferMethodCallArgs_adb;
	transferMethodCallArgs_adb( method1s_adc, method2s_ade);
}

void TransferMethodCallArgs_adb::operator()( const Packets_t& method1s_adc, const Packets_t& method2s_ade)
{
#ifdef PRINT_INFO
	printLog("TransferMethodCallArgs_adb" );
#endif
	RTTGenerator::Instance()->generateRule(500, "TransferMethodCallArgs");
	processInputPackets( method1s_adc, method2s_ade);
}

bool TransferMethodCallArgs_adb::isInputUnique( const Udm::Object& method1_ae4, const Udm::Object& method2_aed)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMethod1_ae6= _method1_ae0.begin(), itMethod2_aef= _method2_ae9.begin(); itMethod1_ae6!= _method1_ae0.end(), itMethod2_aef!= _method2_ae9.end(); ++itMethod1_ae6, ++itMethod2_aef)
	{
		if( ( *itMethod1_ae6== method1_ae4)&& ( *itMethod2_aef== method2_aed))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_method1_ae0.push_back( method1_ae4);
		_method2_ae9.push_back( method2_aed);
	}
	return isUnique;
}

bool TransferMethodCallArgs_adb::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool TransferMethodCallArgs_adb::isGuardTrue( SFC::Arg& Arg1, SFC::Arg& Arg2, SFC::ArgVal& ArgVal, SFC::Function& Method1, SFC::Function& Method2, SFC::FunctionCall& MethodCall2)
{
	bool Gz_guard= false;
	Gz_guard = Arg1.argIndex() == Arg2.argIndex();;
	return Gz_guard;
}

void TransferMethodCallArgs_adb::processInputPackets( const Packets_t& method1s_adc, const Packets_t& method2s_ade)
{
	for( Packets_t::const_iterator itMethod1_ae1= method1s_adc.begin(), itMethod2_aea= method2s_ade.begin(); itMethod1_ae1!= method1s_adc.end(), itMethod2_aea!= method2s_ade.end(); ++itMethod1_ae1, ++itMethod2_aea)
	{
		bool isUnique= isInputUnique( *itMethod1_ae1, *itMethod2_aea);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMethod1_ae1, *itMethod2_aea);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TransferMethodCallArgs_adb::patternMatcher( const Udm::Object& method1_ae2, const Udm::Object& method2_aeb)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( method1_ae2.type(), SFC::Function::meta))
			continue;
		SFC::Function method1_ae7= SFC::Function::Cast( method1_ae2);
		if( false== Uml::IsDerivedFrom( method2_aeb.type(), SFC::Function::meta))
			continue;
		SFC::Function method2_af0= SFC::Function::Cast( method2_aeb);
		set< SFC::Arg> arg2s_af2= method2_af0.Arg_kind_children();
		for( set< SFC::Arg>::const_iterator itArg2_af3= arg2s_af2.begin(); itArg2_af3!= arg2s_af2.end(); ++itArg2_af3)
		{
			SFC::Arg currArg2_af4= *itArg2_af3;
			set< SFC::Arg> arg1s_af5= method1_ae7.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itArg1_af6= arg1s_af5.begin(); itArg1_af6!= arg1s_af5.end(); ++itArg1_af6)
			{
				SFC::Arg currArg1_af7= *itArg1_af6;
				set< SFC::FunctionCall> methodCall2s_af8= method2_af0.caller();
				for( set< SFC::FunctionCall>::const_iterator itMethodCall2s_af9= methodCall2s_af8.begin(); itMethodCall2s_af9!= methodCall2s_af8.end(); ++itMethodCall2s_af9)
				{
					SFC::FunctionCall currMethodCall2_afa= *itMethodCall2s_af9;
					set< SFC::ArgVal> argVals_afb= currMethodCall2_afa.ArgVal_kind_children();
					for( set< SFC::ArgVal>::const_iterator itArgVal_afc= argVals_afb.begin(); itArgVal_afc!= argVals_afb.end(); ++itArgVal_afc)
					{
						SFC::ArgVal currArgVal_afd= *itArgVal_afc;
						set< SFC::Arg> arg2s_afe= currArgVal_afd.arg();
						for( set< SFC::Arg>::const_iterator itArg2s_aff= arg2s_afe.begin(); itArg2s_aff!= arg2s_afe.end(); ++itArg2s_aff)
						{
							SFC::Arg currArg2_b00= *itArg2s_aff;
							if( currArg2_af4!= currArg2_b00)
								continue;
							Match currMatch;
							set< pair<int, Udm::Object> > boundObjs_b04;
							if( !isValidBound(boundObjs_b04, method1_ae7, true))
								continue;
							currMatch.method1_b05= method1_ae7;
							if( !isValidBound(boundObjs_b04, method2_af0, true))
								continue;
							currMatch.method2_b06= method2_af0;
							if( !isValidBound(boundObjs_b04, currArg1_af7, false))
								continue;
							currMatch.arg1_b07= currArg1_af7;
							if( !isValidBound(boundObjs_b04, currMethodCall2_afa, false))
								continue;
							currMatch.methodCall2_b08= currMethodCall2_afa;
							if( !isValidBound(boundObjs_b04, currArgVal_afd, false))
								continue;
							currMatch.argVal_b09= currArgVal_afd;
							if( !isValidBound(boundObjs_b04, currArg2_af4, false))
								continue;
							currMatch.arg2_b0a= currArg2_af4;
							bool Gz_guard= isGuardTrue( currMatch.arg1_b07, currMatch.arg2_b0a, currMatch.argVal_b09, currMatch.method1_b05, currMatch.method2_b06, currMatch.methodCall2_b08);
							if( true== Gz_guard)
								_matches.push_back( currMatch);
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void TransferMethodCallArgs_adb::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.argVal_b09.arg()+= currMatch.arg1_b07;
	}
}

void TransferMethodCallTarget_b14::operator()( const Packets_t& method1s_b15, const Packets_t& method2s_b17)
{
#ifdef PRINT_INFO
	printLog("TransferMethodCallTarget_b14" );
#endif
	RTTGenerator::Instance()->generateRule(513, "TransferMethodCallTarget");
	processInputPackets( method1s_b15, method2s_b17);
}

bool TransferMethodCallTarget_b14::isInputUnique( const Udm::Object& method1_b1d, const Udm::Object& method2_b26)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itMethod1_b1f= _method1_b19.begin(), itMethod2_b28= _method2_b22.begin(); itMethod1_b1f!= _method1_b19.end(), itMethod2_b28!= _method2_b22.end(); ++itMethod1_b1f, ++itMethod2_b28)
	{
		if( ( *itMethod1_b1f== method1_b1d)&& ( *itMethod2_b28== method2_b26))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_method1_b19.push_back( method1_b1d);
		_method2_b22.push_back( method2_b26);
	}
	return isUnique;
}

bool TransferMethodCallTarget_b14::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void TransferMethodCallTarget_b14::processInputPackets( const Packets_t& method1s_b15, const Packets_t& method2s_b17)
{
	for( Packets_t::const_iterator itMethod1_b1a= method1s_b15.begin(), itMethod2_b23= method2s_b17.begin(); itMethod1_b1a!= method1s_b15.end(), itMethod2_b23!= method2s_b17.end(); ++itMethod1_b1a, ++itMethod2_b23)
	{
		bool isUnique= isInputUnique( *itMethod1_b1a, *itMethod2_b23);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itMethod1_b1a, *itMethod2_b23);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TransferMethodCallTarget_b14::patternMatcher( const Udm::Object& method1_b1b, const Udm::Object& method2_b24)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( method1_b1b.type(), SFC::Function::meta))
			continue;
		SFC::Function method1_b20= SFC::Function::Cast( method1_b1b);
		if( false== Uml::IsDerivedFrom( method2_b24.type(), SFC::Function::meta))
			continue;
		SFC::Function method2_b29= SFC::Function::Cast( method2_b24);
		set< SFC::FunctionCall> methodCall2s_b2b= method2_b29.caller();
		for( set< SFC::FunctionCall>::const_iterator itMethodCall2s_b2c= methodCall2s_b2b.begin(); itMethodCall2s_b2c!= methodCall2s_b2b.end(); ++itMethodCall2s_b2c)
		{
			SFC::FunctionCall currMethodCall2_b2d= *itMethodCall2s_b2c;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_b31;
			if( !isValidBound(boundObjs_b31, method1_b20, true))
				continue;
			currMatch.method1_b32= method1_b20;
			if( !isValidBound(boundObjs_b31, method2_b29, true))
				continue;
			currMatch.method2_b33= method2_b29;
			if( !isValidBound(boundObjs_b31, currMethodCall2_b2d, false))
				continue;
			currMatch.methodCall2_b34= currMethodCall2_b2d;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void TransferMethodCallTarget_b14::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.methodCall2_b34.callee()= currMatch.method1_b32;
	}
}

void GetMethods_b3b::operator()( const Packets_t& class1s_b3d, const Packets_t& class2s_b40, Packets_t& method1s_b3c, Packets_t& method2s_b3f)
{
#ifdef PRINT_INFO
	printLog("GetMethods_b3b" );
#endif
	RTTGenerator::Instance()->generateRule(519, "GetMethods");
	_method1_b42= &method1s_b3c;
	_method2_b43= &method2s_b3f;
	processInputPackets( class1s_b3d, class2s_b40);
}

bool GetMethods_b3b::isInputUnique( const Udm::Object& class1_b48, const Udm::Object& class2_b51)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_b4a= _class1_b44.begin(), itClass2_b53= _class2_b4d.begin(); itClass1_b4a!= _class1_b44.end(), itClass2_b53!= _class2_b4d.end(); ++itClass1_b4a, ++itClass2_b53)
	{
		if( ( *itClass1_b4a== class1_b48)&& ( *itClass2_b53== class2_b51))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_b44.push_back( class1_b48);
		_class2_b4d.push_back( class2_b51);
	}
	return isUnique;
}

bool GetMethods_b3b::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool GetMethods_b3b::isGuardTrue( SFC::Class& Class1, SFC::Class& Class2, SFC::Function& Method1, SFC::Function& Method2)
{
	bool Gz_guard= false;
	Gz_guard = Method1.statementIndex() == Method2.statementIndex();;
	return Gz_guard;
}

void GetMethods_b3b::processInputPackets( const Packets_t& class1s_b3d, const Packets_t& class2s_b40)
{
	for( Packets_t::const_iterator itClass1_b45= class1s_b3d.begin(), itClass2_b4e= class2s_b40.begin(); itClass1_b45!= class1s_b3d.end(), itClass2_b4e!= class2s_b40.end(); ++itClass1_b45, ++itClass2_b4e)
	{
		bool isUnique= isInputUnique( *itClass1_b45, *itClass2_b4e);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_b45, *itClass2_b4e);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetMethods_b3b::patternMatcher( const Udm::Object& class1_b46, const Udm::Object& class2_b4f)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_b46.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_b4b= SFC::Class::Cast( class1_b46);
		if( false== Uml::IsDerivedFrom( class2_b4f.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_b54= SFC::Class::Cast( class2_b4f);
		set< SFC::Function> method1s_b56= class1_b4b.Function_kind_children();
		for( set< SFC::Function>::const_iterator itMethod1_b57= method1s_b56.begin(); itMethod1_b57!= method1s_b56.end(); ++itMethod1_b57)
		{
			SFC::Function currMethod1_b58= *itMethod1_b57;
			set< SFC::Function> method2s_b59= class2_b54.Function_kind_children();
			for( set< SFC::Function>::const_iterator itMethod2_b5a= method2s_b59.begin(); itMethod2_b5a!= method2s_b59.end(); ++itMethod2_b5a)
			{
				SFC::Function currMethod2_b5b= *itMethod2_b5a;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_b5f;
				if( !isValidBound(boundObjs_b5f, class1_b4b, true))
					continue;
				currMatch.class1_b60= class1_b4b;
				if( !isValidBound(boundObjs_b5f, class2_b54, true))
					continue;
				currMatch.class2_b61= class2_b54;
				if( !isValidBound(boundObjs_b5f, currMethod1_b58, false))
					continue;
				currMatch.method1_b62= currMethod1_b58;
				if( !isValidBound(boundObjs_b5f, currMethod2_b5b, false))
					continue;
				currMatch.method2_b63= currMethod2_b5b;
				bool Gz_guard= isGuardTrue( currMatch.class1_b60, currMatch.class2_b61, currMatch.method1_b62, currMatch.method2_b63);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetMethods_b3b::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.method1_b62, currMatch.method2_b63);
	}
}

void GetMethods_b3b::outputAppender( const SFC::Function& method1_b68, const SFC::Function& method2_b6a)
{
	_method1_b42->push_back( method1_b68);
	_method2_b43->push_back( method2_b6a);
}

void TransferStruct_b72::operator()( const Packets_t& class1s_b73, const Packets_t& class2s_b75, Packets_t& deleteclasss_b77)
{
#ifdef PRINT_INFO
	printLog("TransferStruct_b72" );
#endif
	_deleteclass_b78= &deleteclasss_b77;
	_deleteclass_b78->insert( _deleteclass_b78->end(), class2s_b75.begin(), class2s_b75.end());
	if( ( !class1s_b73.empty())&& ( !class2s_b75.empty()))
		callTransferStructMembers_cd7( class1s_b73, class2s_b75);
}

void TransferStruct_b72::callTransferStructMembers_cd7( const Packets_t& class1s_b7a, const Packets_t& class2s_b7c)
{
	Packets_t class1s_b7e;
	Packets_t class2s_b7f;
	TransferStructMembers_b79 transferStructMembers_b79;
	transferStructMembers_b79( class1s_b7a, class2s_b7c, class1s_b7e, class2s_b7f);
	if( ( !class1s_b7e.empty())&& ( !class2s_b7f.empty()))
		callTransferStruct_cda( class1s_b7e, class2s_b7f);
}

void TransferStruct_b72::callTransferStruct_cda( const Packets_t& class1s_caf, const Packets_t& class2s_cb1)
{
	TransferStruct_cae transferStruct_cae;
	transferStruct_cae( class1s_caf, class2s_cb1);
}

void TransferStructMembers_b79::operator()( const Packets_t& class1s_b7a, const Packets_t& class2s_b7c, Packets_t& class1s_b7e, Packets_t& class2s_b7f)
{
#ifdef PRINT_INFO
	printLog("TransferStructMembers_b79" );
#endif
	_class1_b80= &class1s_b7e;
	_class2_b81= &class2s_b7f;
	if( ( !class1s_b7a.empty())&& ( !class2s_b7c.empty()))
		callTransferParameterMembers_ca5( class1s_b7a, class2s_b7c);
	_class1_b80->insert( _class1_b80->end(), class1s_b7a.begin(), class1s_b7a.end());
	_class2_b81->insert( _class2_b81->end(), class2s_b7c.begin(), class2s_b7c.end());
}

void TransferStructMembers_b79::callTransferParameterMembers_ca5( const Packets_t& class1s_b83, const Packets_t& class2s_b85)
{
	Packets_t class1s_b87;
	Packets_t class2s_b88;
	TransferParameterMembers_b82 transferParameterMembers_b82;
	transferParameterMembers_b82( class1s_b83, class2s_b85, class1s_b87, class2s_b88);
	if( ( !class1s_b87.empty())&& ( !class2s_b88.empty()))
		callTransferTriggerMembers_ca8( class1s_b87, class2s_b88);
}

void TransferStructMembers_b79::callTransferTriggerMembers_ca8( const Packets_t& class1s_c52, const Packets_t& class2s_c54)
{
	Packets_t class1s_c56;
	Packets_t class2s_c57;
	TransferTriggerMembers_c51 transferTriggerMembers_c51;
	transferTriggerMembers_c51( class1s_c52, class2s_c54, class1s_c56, class2s_c57);
	if( ( !class1s_c56.empty())&& ( !class2s_c57.empty()))
		callTransferStructMembers_cab( class1s_c56, class2s_c57);
}

void TransferStructMembers_b79::callTransferStructMembers_cab( const Packets_t& class1s_bf8, const Packets_t& class2s_bfa)
{
	Packets_t class1s_bfc;
	Packets_t class2s_bfd;
	TransferStructMembers_bf7 transferStructMembers_bf7;
	transferStructMembers_bf7( class1s_bf8, class2s_bfa, class1s_bfc, class2s_bfd);
}

void TransferParameterMembers_b82::operator()( const Packets_t& class1s_b83, const Packets_t& class2s_b85, Packets_t& class1s_b87, Packets_t& class2s_b88)
{
#ifdef PRINT_INFO
	printLog("TransferParameterMembers_b82" );
#endif
	_class1_b89= &class1s_b87;
	_class2_b8a= &class2s_b88;
	if( ( !class1s_b83.empty())&& ( !class2s_b85.empty()))
		callTransferParameterMember_bf1( class1s_b83, class2s_b85);
	_class1_b89->insert( _class1_b89->end(), class1s_b83.begin(), class1s_b83.end());
	_class2_b8a->insert( _class2_b8a->end(), class2s_b85.begin(), class2s_b85.end());
}

void TransferParameterMembers_b82::callTransferParameterMember_bf1( const Packets_t& class1s_bad, const Packets_t& class2s_bb0)
{
	Packets_t localVar1s_baf;
	Packets_t localVar2s_bb2;
	TransferParameterMember_bac transferParameterMember_bac;
	transferParameterMember_bac( class1s_bad, class2s_bb0, localVar1s_baf, localVar2s_bb2);
	if( ( !localVar1s_baf.empty())&& ( !localVar2s_bb2.empty()))
		callTransferArgDeclRef_bf4( localVar1s_baf, localVar2s_bb2);
}

void TransferParameterMembers_b82::callTransferArgDeclRef_bf4( const Packets_t& localVar1s_b8c, const Packets_t& localVar2s_b8e)
{
	TransferArgDeclRef_b8b transferArgDeclRef_b8b;
	transferArgDeclRef_b8b( localVar1s_b8c, localVar2s_b8e);
}

void TransferArgDeclRef_b8b::operator()( const Packets_t& localVar1s_b8c, const Packets_t& localVar2s_b8e)
{
#ifdef PRINT_INFO
	printLog("TransferArgDeclRef_b8b" );
#endif
	RTTGenerator::Instance()->generateRule(540, "TransferArgDeclRef");
	processInputPackets( localVar1s_b8c, localVar2s_b8e);
}

bool TransferArgDeclRef_b8b::isInputUnique( const Udm::Object& localVar1_b94, const Udm::Object& localVar2_b9d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itLocalVar1_b96= _localVar1_b90.begin(), itLocalVar2_b9f= _localVar2_b99.begin(); itLocalVar1_b96!= _localVar1_b90.end(), itLocalVar2_b9f!= _localVar2_b99.end(); ++itLocalVar1_b96, ++itLocalVar2_b9f)
	{
		if( ( *itLocalVar1_b96== localVar1_b94)&& ( *itLocalVar2_b9f== localVar2_b9d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_localVar1_b90.push_back( localVar1_b94);
		_localVar2_b99.push_back( localVar2_b9d);
	}
	return isUnique;
}

bool TransferArgDeclRef_b8b::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void TransferArgDeclRef_b8b::processInputPackets( const Packets_t& localVar1s_b8c, const Packets_t& localVar2s_b8e)
{
	for( Packets_t::const_iterator itLocalVar1_b91= localVar1s_b8c.begin(), itLocalVar2_b9a= localVar2s_b8e.begin(); itLocalVar1_b91!= localVar1s_b8c.end(), itLocalVar2_b9a!= localVar2s_b8e.end(); ++itLocalVar1_b91, ++itLocalVar2_b9a)
	{
		bool isUnique= isInputUnique( *itLocalVar1_b91, *itLocalVar2_b9a);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itLocalVar1_b91, *itLocalVar2_b9a);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TransferArgDeclRef_b8b::patternMatcher( const Udm::Object& localVar1_b92, const Udm::Object& localVar2_b9b)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( localVar1_b92.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar1_b97= SFC::LocalVar::Cast( localVar1_b92);
		if( false== Uml::IsDerivedFrom( localVar2_b9b.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar2_ba0= SFC::LocalVar::Cast( localVar2_b9b);
		set< SFC::ArgDeclRef> argDeclRefs_ba2= localVar2_ba0.ref();
		for( set< SFC::ArgDeclRef>::const_iterator itArgDeclRefs_ba3= argDeclRefs_ba2.begin(); itArgDeclRefs_ba3!= argDeclRefs_ba2.end(); ++itArgDeclRefs_ba3)
		{
			SFC::ArgDeclRef currArgDeclRef_ba4= *itArgDeclRefs_ba3;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_ba8;
			if( !isValidBound(boundObjs_ba8, localVar1_b97, true))
				continue;
			currMatch.localVar1_ba9= localVar1_b97;
			if( !isValidBound(boundObjs_ba8, localVar2_ba0, true))
				continue;
			currMatch.localVar2_baa= localVar2_ba0;
			if( !isValidBound(boundObjs_ba8, currArgDeclRef_ba4, false))
				continue;
			currMatch.argDeclRef_bab= currArgDeclRef_ba4;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void TransferArgDeclRef_b8b::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.argDeclRef_bab.argdecl()= currMatch.localVar1_ba9;
	}
}

void TransferParameterMember_bac::operator()( const Packets_t& class1s_bad, const Packets_t& class2s_bb0, Packets_t& localVar1s_baf, Packets_t& localVar2s_bb2)
{
#ifdef PRINT_INFO
	printLog("TransferParameterMember_bac" );
#endif
	RTTGenerator::Instance()->generateRule(546, "TransferParameterMember");
	_localVar1_bb3= &localVar1s_baf;
	_localVar2_bb4= &localVar2s_bb2;
	processInputPackets( class1s_bad, class2s_bb0);
}

bool TransferParameterMember_bac::isInputUnique( const Udm::Object& class1_bb9, const Udm::Object& class2_bc2)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_bbb= _class1_bb5.begin(), itClass2_bc4= _class2_bbe.begin(); itClass1_bbb!= _class1_bb5.end(), itClass2_bc4!= _class2_bbe.end(); ++itClass1_bbb, ++itClass2_bc4)
	{
		if( ( *itClass1_bbb== class1_bb9)&& ( *itClass2_bc4== class2_bc2))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_bb5.push_back( class1_bb9);
		_class2_bbe.push_back( class2_bc2);
	}
	return isUnique;
}

bool TransferParameterMember_bac::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool TransferParameterMember_bac::isGuardTrue( SFC::Class& Class1, SFC::Class& Class2, SFC::LocalVar& LocalVar1, SFC::LocalVar& LocalVar2, CyPhyML::SignalFlow::SF_Parameter& Parameter1, CyPhyML::SignalFlow::SF_Parameter& Parameter2, SFC::Struct& Struct1, SFC::Struct& Struct2)
{
	bool Gz_guard= false;
	Gz_guard = SFUtils::InstanceEquivalent( Parameter1, Parameter2 );;
	return Gz_guard;
}

void TransferParameterMember_bac::processInputPackets( const Packets_t& class1s_bad, const Packets_t& class2s_bb0)
{
	for( Packets_t::const_iterator itClass1_bb6= class1s_bad.begin(), itClass2_bbf= class2s_bb0.begin(); itClass1_bb6!= class1s_bad.end(), itClass2_bbf!= class2s_bb0.end(); ++itClass1_bb6, ++itClass2_bbf)
	{
		bool isUnique= isInputUnique( *itClass1_bb6, *itClass2_bbf);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_bb6, *itClass2_bbf);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TransferParameterMember_bac::patternMatcher( const Udm::Object& class1_bb7, const Udm::Object& class2_bc0)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_bb7.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_bbc= SFC::Class::Cast( class1_bb7);
		if( false== Uml::IsDerivedFrom( class2_bc0.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_bc5= SFC::Class::Cast( class2_bc0);
		set< SFC::Struct> struct1s_bc7= class1_bbc.Struct_kind_children();
		for( set< SFC::Struct>::const_iterator itStruct1_bc8= struct1s_bc7.begin(); itStruct1_bc8!= struct1s_bc7.end(); ++itStruct1_bc8)
		{
			SFC::Struct currStruct1_bc9= *itStruct1_bc8;
			set< SFC::Struct> struct2s_bca= class2_bc5.Struct_kind_children();
			for( set< SFC::Struct>::const_iterator itStruct2_bcb= struct2s_bca.begin(); itStruct2_bcb!= struct2s_bca.end(); ++itStruct2_bcb)
			{
				SFC::Struct currStruct2_bcc= *itStruct2_bcb;
				set< SFC::LocalVar> localVar1s_bcd= currStruct1_bc9.LocalVar_kind_children();
				for( set< SFC::LocalVar>::const_iterator itLocalVar1_bce= localVar1s_bcd.begin(); itLocalVar1_bce!= localVar1s_bcd.end(); ++itLocalVar1_bce)
				{
					SFC::LocalVar currLocalVar1_bcf= *itLocalVar1_bce;
					set< SFC::LocalVar> localVar2s_bd0= currStruct2_bcc.LocalVar_kind_children();
					for( set< SFC::LocalVar>::const_iterator itLocalVar2_bd1= localVar2s_bd0.begin(); itLocalVar2_bd1!= localVar2s_bd0.end(); ++itLocalVar2_bd1)
					{
						SFC::LocalVar currLocalVar2_bd2= *itLocalVar2_bd1;
						set< CyPhyML::SignalFlow::SF_Parameter> parameter1s_bd3= currLocalVar1_bcf.param();
						for( set< CyPhyML::SignalFlow::SF_Parameter>::const_iterator itParameter1s_bd4= parameter1s_bd3.begin(); itParameter1s_bd4!= parameter1s_bd3.end(); ++itParameter1s_bd4)
						{
							CyPhyML::SignalFlow::SF_Parameter currParameter1_bd5= *itParameter1s_bd4;
							set< CyPhyML::SignalFlow::SF_Parameter> parameter2s_bd6= currLocalVar2_bd2.param();
							for( set< CyPhyML::SignalFlow::SF_Parameter>::const_iterator itParameter2s_bd7= parameter2s_bd6.begin(); itParameter2s_bd7!= parameter2s_bd6.end(); ++itParameter2s_bd7)
							{
								CyPhyML::SignalFlow::SF_Parameter currParameter2_bd8= *itParameter2s_bd7;
								Match currMatch;
								set< pair<int, Udm::Object> > boundObjs_bdc;
								if( !isValidBound(boundObjs_bdc, class1_bbc, true))
									continue;
								currMatch.class1_bdd= class1_bbc;
								if( !isValidBound(boundObjs_bdc, class2_bc5, true))
									continue;
								currMatch.class2_bde= class2_bc5;
								if( !isValidBound(boundObjs_bdc, currStruct1_bc9, false))
									continue;
								currMatch.struct1_bdf= currStruct1_bc9;
								if( !isValidBound(boundObjs_bdc, currLocalVar1_bcf, false))
									continue;
								currMatch.localVar1_be0= currLocalVar1_bcf;
								if( !isValidBound(boundObjs_bdc, currParameter1_bd5, false))
									continue;
								currMatch.parameter1_be1= currParameter1_bd5;
								if( !isValidBound(boundObjs_bdc, currParameter2_bd8, false))
									continue;
								currMatch.parameter2_be2= currParameter2_bd8;
								if( !isValidBound(boundObjs_bdc, currStruct2_bcc, false))
									continue;
								currMatch.struct2_be3= currStruct2_bcc;
								if( !isValidBound(boundObjs_bdc, currLocalVar2_bd2, false))
									continue;
								currMatch.localVar2_be4= currLocalVar2_bd2;
								bool Gz_guard= isGuardTrue( currMatch.class1_bdd, currMatch.class2_bde, currMatch.localVar1_be0, currMatch.localVar2_be4, currMatch.parameter1_be1, currMatch.parameter2_be2, currMatch.struct1_bdf, currMatch.struct2_be3);
								if( true== Gz_guard)
									_matches.push_back( currMatch);
							}
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void TransferParameterMember_bac::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Class& Class1= currMatch.class1_bdd;
		SFC::Class& Class2= currMatch.class2_bde;
		SFC::LocalVar& LocalVar1= currMatch.localVar1_be0;
		SFC::LocalVar& LocalVar2= currMatch.localVar2_be4;
		CyPhyML::SignalFlow::SF_Parameter& Parameter1= currMatch.parameter1_be1;
		CyPhyML::SignalFlow::SF_Parameter& Parameter2= currMatch.parameter2_be2;
		SFC::Struct& Struct1= currMatch.struct1_bdf;
		SFC::Struct& Struct2= currMatch.struct2_be3;
		{
Parameter2.memb() = LocalVar1;
};
		currMatch.localVar1_be0.param()+= currMatch.parameter2_be2;
		outputAppender( currMatch.localVar1_be0, currMatch.localVar2_be4);
	}
}

void TransferParameterMember_bac::outputAppender( const SFC::LocalVar& localVar1_bed, const SFC::LocalVar& localVar2_bef)
{
	_localVar1_bb3->push_back( localVar1_bed);
	_localVar2_bb4->push_back( localVar2_bef);
}

void TransferStructMembers_bf7::operator()( const Packets_t& class1s_bf8, const Packets_t& class2s_bfa, Packets_t& class1s_bfc, Packets_t& class2s_bfd)
{
#ifdef PRINT_INFO
	printLog("TransferStructMembers_bf7" );
#endif
	_class1_bfe= &class1s_bfc;
	_class2_bff= &class2s_bfd;
	if( ( !class1s_bf8.empty())&& ( !class2s_bfa.empty()))
		callTransferStructMember_c4b( class1s_bf8, class2s_bfa);
	_class1_bfe->insert( _class1_bfe->end(), class1s_bf8.begin(), class1s_bf8.end());
	_class2_bff->insert( _class2_bff->end(), class2s_bfa.begin(), class2s_bfa.end());
}

void TransferStructMembers_bf7::callTransferStructMember_c4b( const Packets_t& class1s_c01, const Packets_t& class2s_c04)
{
	Packets_t localVar1s_c03;
	Packets_t localVar2s_c06;
	TransferStructMember_c00 transferStructMember_c00;
	transferStructMember_c00( class1s_c01, class2s_c04, localVar1s_c03, localVar2s_c06);
	if( ( !localVar1s_c03.empty())&& ( !localVar2s_c06.empty()))
		callTransferArgDeclRef_c4e( localVar1s_c03, localVar2s_c06);
}

void TransferStructMembers_bf7::callTransferArgDeclRef_c4e( const Packets_t& localVar1s_b8c, const Packets_t& localVar2s_b8e)
{
	TransferArgDeclRef_b8b transferArgDeclRef_b8b;
	transferArgDeclRef_b8b( localVar1s_b8c, localVar2s_b8e);
}

void TransferStructMember_c00::operator()( const Packets_t& class1s_c01, const Packets_t& class2s_c04, Packets_t& localVar1s_c03, Packets_t& localVar2s_c06)
{
#ifdef PRINT_INFO
	printLog("TransferStructMember_c00" );
#endif
	RTTGenerator::Instance()->generateRule(568, "TransferStructMember");
	_localVar1_c07= &localVar1s_c03;
	_localVar2_c08= &localVar2s_c06;
	processInputPackets( class1s_c01, class2s_c04);
}

bool TransferStructMember_c00::isInputUnique( const Udm::Object& class1_c0d, const Udm::Object& class2_c16)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_c0f= _class1_c09.begin(), itClass2_c18= _class2_c12.begin(); itClass1_c0f!= _class1_c09.end(), itClass2_c18!= _class2_c12.end(); ++itClass1_c0f, ++itClass2_c18)
	{
		if( ( *itClass1_c0f== class1_c0d)&& ( *itClass2_c18== class2_c16))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_c09.push_back( class1_c0d);
		_class2_c12.push_back( class2_c16);
	}
	return isUnique;
}

bool TransferStructMember_c00::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool TransferStructMember_c00::isGuardTrue( SFC::Class& Class, SFC::Class& Class1, SFC::Class& Class2, SFC::LocalVar& LocalVar1, SFC::LocalVar& LocalVar2, SFC::Struct& Struct1, SFC::Struct& Struct2, CyPhyML::SignalFlow::Subsystem& SubSubsystem1, CyPhyML::SignalFlow::Subsystem& SubSubsystem2)
{
	bool Gz_guard= false;
	return SFUtils::InstanceCorrespond( SubSubsystem1, SubSubsystem2 );;
	return Gz_guard;
}

void TransferStructMember_c00::processInputPackets( const Packets_t& class1s_c01, const Packets_t& class2s_c04)
{
	for( Packets_t::const_iterator itClass1_c0a= class1s_c01.begin(), itClass2_c13= class2s_c04.begin(); itClass1_c0a!= class1s_c01.end(), itClass2_c13!= class2s_c04.end(); ++itClass1_c0a, ++itClass2_c13)
	{
		bool isUnique= isInputUnique( *itClass1_c0a, *itClass2_c13);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_c0a, *itClass2_c13);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TransferStructMember_c00::patternMatcher( const Udm::Object& class1_c0b, const Udm::Object& class2_c14)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_c0b.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_c10= SFC::Class::Cast( class1_c0b);
		if( false== Uml::IsDerivedFrom( class2_c14.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_c19= SFC::Class::Cast( class2_c14);
		set< SFC::Struct> struct2s_c1b= class2_c19.Struct_kind_children();
		for( set< SFC::Struct>::const_iterator itStruct2_c1c= struct2s_c1b.begin(); itStruct2_c1c!= struct2s_c1b.end(); ++itStruct2_c1c)
		{
			SFC::Struct currStruct2_c1d= *itStruct2_c1c;
			set< SFC::Struct> struct1s_c1e= class1_c10.Struct_kind_children();
			for( set< SFC::Struct>::const_iterator itStruct1_c1f= struct1s_c1e.begin(); itStruct1_c1f!= struct1s_c1e.end(); ++itStruct1_c1f)
			{
				SFC::Struct currStruct1_c20= *itStruct1_c1f;
				set< SFC::LocalVar> localVar2s_c21= currStruct2_c1d.LocalVar_kind_children();
				for( set< SFC::LocalVar>::const_iterator itLocalVar2_c22= localVar2s_c21.begin(); itLocalVar2_c22!= localVar2s_c21.end(); ++itLocalVar2_c22)
				{
					SFC::LocalVar currLocalVar2_c23= *itLocalVar2_c22;
					set< SFC::LocalVar> localVar1s_c24= currStruct1_c20.LocalVar_kind_children();
					for( set< SFC::LocalVar>::const_iterator itLocalVar1_c25= localVar1s_c24.begin(); itLocalVar1_c25!= localVar1s_c24.end(); ++itLocalVar1_c25)
					{
						SFC::LocalVar currLocalVar1_c26= *itLocalVar1_c25;
						set< CyPhyML::SignalFlow::Subsystem> subSubsystem2s_c27= currLocalVar2_c23.sys();
						for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itSubSubsystem2s_c28= subSubsystem2s_c27.begin(); itSubSubsystem2s_c28!= subSubsystem2s_c27.end(); ++itSubSubsystem2s_c28)
						{
							CyPhyML::SignalFlow::Subsystem currSubSubsystem2_c29= *itSubSubsystem2s_c28;
							SFC::Class class_c2a= currSubSubsystem2_c29.cls();
							if( !class_c2a)
								continue;
							set< CyPhyML::SignalFlow::Subsystem> subSubsystem1s_c2b= class_c2a.obj();
							for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itSubSubsystem1s_c2c= subSubsystem1s_c2b.begin(); itSubSubsystem1s_c2c!= subSubsystem1s_c2b.end(); ++itSubSubsystem1s_c2c)
							{
								CyPhyML::SignalFlow::Subsystem currSubSubsystem1_c2d= *itSubSubsystem1s_c2c;
								set< CyPhyML::SignalFlow::Subsystem> subSubsystem1s_c2e= currLocalVar1_c26.sys();
								for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itSubSubsystem1s_c2f= subSubsystem1s_c2e.begin(); itSubSubsystem1s_c2f!= subSubsystem1s_c2e.end(); ++itSubSubsystem1s_c2f)
								{
									CyPhyML::SignalFlow::Subsystem currSubSubsystem1_c30= *itSubSubsystem1s_c2f;
									if( currSubSubsystem1_c2d!= currSubSubsystem1_c30)
										continue;
									Match currMatch;
									set< pair<int, Udm::Object> > boundObjs_c34;
									if( !isValidBound(boundObjs_c34, class1_c10, true))
										continue;
									currMatch.class1_c35= class1_c10;
									if( !isValidBound(boundObjs_c34, class2_c19, true))
										continue;
									currMatch.class2_c36= class2_c19;
									if( !isValidBound(boundObjs_c34, currStruct1_c20, false))
										continue;
									currMatch.struct1_c37= currStruct1_c20;
									if( !isValidBound(boundObjs_c34, currLocalVar1_c26, false))
										continue;
									currMatch.localVar1_c38= currLocalVar1_c26;
									if( !isValidBound(boundObjs_c34, currSubSubsystem1_c2d, false))
										continue;
									currMatch.subSubsystem1_c39= currSubSubsystem1_c2d;
									if( !isValidBound(boundObjs_c34, class_c2a, false))
										continue;
									currMatch.class_c3a= class_c2a;
									if( !isValidBound(boundObjs_c34, currSubSubsystem2_c29, false))
										continue;
									currMatch.subSubsystem2_c3b= currSubSubsystem2_c29;
									if( !isValidBound(boundObjs_c34, currStruct2_c1d, false))
										continue;
									currMatch.struct2_c3c= currStruct2_c1d;
									if( !isValidBound(boundObjs_c34, currLocalVar2_c23, false))
										continue;
									currMatch.localVar2_c3d= currLocalVar2_c23;
									bool Gz_guard= isGuardTrue( currMatch.class_c3a, currMatch.class1_c35, currMatch.class2_c36, currMatch.localVar1_c38, currMatch.localVar2_c3d, currMatch.struct1_c37, currMatch.struct2_c3c, currMatch.subSubsystem1_c39, currMatch.subSubsystem2_c3b);
									if( true== Gz_guard)
										_matches.push_back( currMatch);
								}
							}
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void TransferStructMember_c00::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Class& Class= currMatch.class_c3a;
		SFC::Class& Class1= currMatch.class1_c35;
		SFC::Class& Class2= currMatch.class2_c36;
		SFC::LocalVar& LocalVar1= currMatch.localVar1_c38;
		SFC::LocalVar& LocalVar2= currMatch.localVar2_c3d;
		SFC::Struct& Struct1= currMatch.struct1_c37;
		SFC::Struct& Struct2= currMatch.struct2_c3c;
		CyPhyML::SignalFlow::Subsystem& SubSubsystem1= currMatch.subSubsystem1_c39;
		CyPhyML::SignalFlow::Subsystem& SubSubsystem2= currMatch.subSubsystem2_c3b;
		{
SubSubsystem2.memb() = LocalVar1;
};
		currMatch.localVar1_c38.sys()+= currMatch.subSubsystem2_c3b;
		outputAppender( currMatch.localVar1_c38, currMatch.localVar2_c3d);
	}
}

void TransferStructMember_c00::outputAppender( const SFC::LocalVar& localVar1_c47, const SFC::LocalVar& localVar2_c49)
{
	_localVar1_c07->push_back( localVar1_c47);
	_localVar2_c08->push_back( localVar2_c49);
}

void TransferTriggerMembers_c51::operator()( const Packets_t& class1s_c52, const Packets_t& class2s_c54, Packets_t& class1s_c56, Packets_t& class2s_c57)
{
#ifdef PRINT_INFO
	printLog("TransferTriggerMembers_c51" );
#endif
	_class1_c58= &class1s_c56;
	_class2_c59= &class2s_c57;
	_class1_c58->insert( _class1_c58->end(), class1s_c52.begin(), class1s_c52.end());
	_class2_c59->insert( _class2_c59->end(), class2s_c54.begin(), class2s_c54.end());
	if( ( !class1s_c52.empty())&& ( !class2s_c54.empty()))
		callTransferTriggerMember_c9f( class1s_c52, class2s_c54);
}

void TransferTriggerMembers_c51::callTransferTriggerMember_c9f( const Packets_t& class1s_c5b, const Packets_t& class2s_c5e)
{
	Packets_t localVar1s_c5d;
	Packets_t localVar2s_c60;
	TransferTriggerMember_c5a transferTriggerMember_c5a;
	transferTriggerMember_c5a( class1s_c5b, class2s_c5e, localVar1s_c5d, localVar2s_c60);
	if( ( !localVar1s_c5d.empty())&& ( !localVar2s_c60.empty()))
		callTransferArgDeclRef_ca2( localVar1s_c5d, localVar2s_c60);
}

void TransferTriggerMembers_c51::callTransferArgDeclRef_ca2( const Packets_t& localVar1s_b8c, const Packets_t& localVar2s_b8e)
{
	TransferArgDeclRef_b8b transferArgDeclRef_b8b;
	transferArgDeclRef_b8b( localVar1s_b8c, localVar2s_b8e);
}

void TransferTriggerMember_c5a::operator()( const Packets_t& class1s_c5b, const Packets_t& class2s_c5e, Packets_t& localVar1s_c5d, Packets_t& localVar2s_c60)
{
#ifdef PRINT_INFO
	printLog("TransferTriggerMember_c5a" );
#endif
	RTTGenerator::Instance()->generateRule(593, "TransferTriggerMember");
	_localVar1_c61= &localVar1s_c5d;
	_localVar2_c62= &localVar2s_c60;
	processInputPackets( class1s_c5b, class2s_c5e);
}

bool TransferTriggerMember_c5a::isInputUnique( const Udm::Object& class1_c67, const Udm::Object& class2_c70)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_c69= _class1_c63.begin(), itClass2_c72= _class2_c6c.begin(); itClass1_c69!= _class1_c63.end(), itClass2_c72!= _class2_c6c.end(); ++itClass1_c69, ++itClass2_c72)
	{
		if( ( *itClass1_c69== class1_c67)&& ( *itClass2_c72== class2_c70))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_c63.push_back( class1_c67);
		_class2_c6c.push_back( class2_c70);
	}
	return isUnique;
}

bool TransferTriggerMember_c5a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool TransferTriggerMember_c5a::isGuardTrue( SFC::Class& Class1, SFC::Class& Class2, SFC::LocalVar& LocalVar1, SFC::LocalVar& LocalVar2, SFC::Struct& Struct1, SFC::Struct& Struct2, CyPhyML::SignalFlow::TriggerPort& TriggerPort1, CyPhyML::SignalFlow::TriggerPort& TriggerPort2)
{
	bool Gz_guard= false;
	Gz_guard = SFUtils::InstanceEquivalent( TriggerPort1, TriggerPort2 );;
	return Gz_guard;
}

void TransferTriggerMember_c5a::processInputPackets( const Packets_t& class1s_c5b, const Packets_t& class2s_c5e)
{
	for( Packets_t::const_iterator itClass1_c64= class1s_c5b.begin(), itClass2_c6d= class2s_c5e.begin(); itClass1_c64!= class1s_c5b.end(), itClass2_c6d!= class2s_c5e.end(); ++itClass1_c64, ++itClass2_c6d)
	{
		bool isUnique= isInputUnique( *itClass1_c64, *itClass2_c6d);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_c64, *itClass2_c6d);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TransferTriggerMember_c5a::patternMatcher( const Udm::Object& class1_c65, const Udm::Object& class2_c6e)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_c65.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_c6a= SFC::Class::Cast( class1_c65);
		if( false== Uml::IsDerivedFrom( class2_c6e.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_c73= SFC::Class::Cast( class2_c6e);
		set< SFC::Struct> struct2s_c75= class2_c73.Struct_kind_children();
		for( set< SFC::Struct>::const_iterator itStruct2_c76= struct2s_c75.begin(); itStruct2_c76!= struct2s_c75.end(); ++itStruct2_c76)
		{
			SFC::Struct currStruct2_c77= *itStruct2_c76;
			set< SFC::LocalVar> localVar2s_c78= currStruct2_c77.LocalVar_kind_children();
			for( set< SFC::LocalVar>::const_iterator itLocalVar2_c79= localVar2s_c78.begin(); itLocalVar2_c79!= localVar2s_c78.end(); ++itLocalVar2_c79)
			{
				SFC::LocalVar currLocalVar2_c7a= *itLocalVar2_c79;
				set< SFC::Struct> struct1s_c7b= class1_c6a.Struct_kind_children();
				for( set< SFC::Struct>::const_iterator itStruct1_c7c= struct1s_c7b.begin(); itStruct1_c7c!= struct1s_c7b.end(); ++itStruct1_c7c)
				{
					SFC::Struct currStruct1_c7d= *itStruct1_c7c;
					set< SFC::LocalVar> localVar1s_c7e= currStruct1_c7d.LocalVar_kind_children();
					for( set< SFC::LocalVar>::const_iterator itLocalVar1_c7f= localVar1s_c7e.begin(); itLocalVar1_c7f!= localVar1s_c7e.end(); ++itLocalVar1_c7f)
					{
						SFC::LocalVar currLocalVar1_c80= *itLocalVar1_c7f;
						set< CyPhyML::SignalFlow::TriggerPort> triggerPort1s_c81= currLocalVar2_c7a.trig();
						for( set< CyPhyML::SignalFlow::TriggerPort>::const_iterator itTriggerPort1s_c82= triggerPort1s_c81.begin(); itTriggerPort1s_c82!= triggerPort1s_c81.end(); ++itTriggerPort1s_c82)
						{
							CyPhyML::SignalFlow::TriggerPort currTriggerPort1_c83= *itTriggerPort1s_c82;
							set< CyPhyML::SignalFlow::TriggerPort> triggerPort2s_c84= currLocalVar1_c80.trig();
							for( set< CyPhyML::SignalFlow::TriggerPort>::const_iterator itTriggerPort2s_c85= triggerPort2s_c84.begin(); itTriggerPort2s_c85!= triggerPort2s_c84.end(); ++itTriggerPort2s_c85)
							{
								CyPhyML::SignalFlow::TriggerPort currTriggerPort2_c86= *itTriggerPort2s_c85;
								Match currMatch;
								set< pair<int, Udm::Object> > boundObjs_c8a;
								if( !isValidBound(boundObjs_c8a, class1_c6a, true))
									continue;
								currMatch.class1_c8b= class1_c6a;
								if( !isValidBound(boundObjs_c8a, class2_c73, true))
									continue;
								currMatch.class2_c8c= class2_c73;
								if( !isValidBound(boundObjs_c8a, currStruct1_c7d, false))
									continue;
								currMatch.struct1_c8d= currStruct1_c7d;
								if( !isValidBound(boundObjs_c8a, currLocalVar1_c80, false))
									continue;
								currMatch.localVar1_c8e= currLocalVar1_c80;
								if( !isValidBound(boundObjs_c8a, currTriggerPort2_c86, false))
									continue;
								currMatch.triggerPort2_c8f= currTriggerPort2_c86;
								if( !isValidBound(boundObjs_c8a, currTriggerPort1_c83, false))
									continue;
								currMatch.triggerPort1_c90= currTriggerPort1_c83;
								if( !isValidBound(boundObjs_c8a, currStruct2_c77, false))
									continue;
								currMatch.struct2_c91= currStruct2_c77;
								if( !isValidBound(boundObjs_c8a, currLocalVar2_c7a, false))
									continue;
								currMatch.localVar2_c92= currLocalVar2_c7a;
								bool Gz_guard= isGuardTrue( currMatch.class1_c8b, currMatch.class2_c8c, currMatch.localVar1_c8e, currMatch.localVar2_c92, currMatch.struct1_c8d, currMatch.struct2_c91, currMatch.triggerPort1_c90, currMatch.triggerPort2_c8f);
								if( true== Gz_guard)
									_matches.push_back( currMatch);
							}
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void TransferTriggerMember_c5a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Class& Class1= currMatch.class1_c8b;
		SFC::Class& Class2= currMatch.class2_c8c;
		SFC::LocalVar& LocalVar1= currMatch.localVar1_c8e;
		SFC::LocalVar& LocalVar2= currMatch.localVar2_c92;
		SFC::Struct& Struct1= currMatch.struct1_c8d;
		SFC::Struct& Struct2= currMatch.struct2_c91;
		CyPhyML::SignalFlow::TriggerPort& TriggerPort1= currMatch.triggerPort1_c90;
		CyPhyML::SignalFlow::TriggerPort& TriggerPort2= currMatch.triggerPort2_c8f;
		{
TriggerPort1.memb() = LocalVar1;
};
		currMatch.localVar1_c8e.trig()+= currMatch.triggerPort1_c90;
		outputAppender( currMatch.localVar1_c8e, currMatch.localVar2_c92);
	}
}

void TransferTriggerMember_c5a::outputAppender( const SFC::LocalVar& localVar1_c9b, const SFC::LocalVar& localVar2_c9d)
{
	_localVar1_c61->push_back( localVar1_c9b);
	_localVar2_c62->push_back( localVar2_c9d);
}

void TransferStruct_cae::operator()( const Packets_t& class1s_caf, const Packets_t& class2s_cb1)
{
#ifdef PRINT_INFO
	printLog("TransferStruct_cae" );
#endif
	RTTGenerator::Instance()->generateRule(610, "TransferStruct");
	processInputPackets( class1s_caf, class2s_cb1);
}

bool TransferStruct_cae::isInputUnique( const Udm::Object& class1_cb7, const Udm::Object& class2_cc0)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_cb9= _class1_cb3.begin(), itClass2_cc2= _class2_cbc.begin(); itClass1_cb9!= _class1_cb3.end(), itClass2_cc2!= _class2_cbc.end(); ++itClass1_cb9, ++itClass2_cc2)
	{
		if( ( *itClass1_cb9== class1_cb7)&& ( *itClass2_cc2== class2_cc0))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_cb3.push_back( class1_cb7);
		_class2_cbc.push_back( class2_cc0);
	}
	return isUnique;
}

bool TransferStruct_cae::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void TransferStruct_cae::processInputPackets( const Packets_t& class1s_caf, const Packets_t& class2s_cb1)
{
	for( Packets_t::const_iterator itClass1_cb4= class1s_caf.begin(), itClass2_cbd= class2s_cb1.begin(); itClass1_cb4!= class1s_caf.end(), itClass2_cbd!= class2s_cb1.end(); ++itClass1_cb4, ++itClass2_cbd)
	{
		bool isUnique= isInputUnique( *itClass1_cb4, *itClass2_cbd);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_cb4, *itClass2_cbd);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TransferStruct_cae::patternMatcher( const Udm::Object& class1_cb5, const Udm::Object& class2_cbe)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_cb5.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_cba= SFC::Class::Cast( class1_cb5);
		if( false== Uml::IsDerivedFrom( class2_cbe.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_cc3= SFC::Class::Cast( class2_cbe);
		set< SFC::Struct> struct2s_cc5= class2_cc3.Struct_kind_children();
		for( set< SFC::Struct>::const_iterator itStruct2_cc6= struct2s_cc5.begin(); itStruct2_cc6!= struct2s_cc5.end(); ++itStruct2_cc6)
		{
			SFC::Struct currStruct2_cc7= *itStruct2_cc6;
			set< SFC::Struct> struct1s_cc8= class1_cba.Struct_kind_children();
			for( set< SFC::Struct>::const_iterator itStruct1_cc9= struct1s_cc8.begin(); itStruct1_cc9!= struct1s_cc8.end(); ++itStruct1_cc9)
			{
				SFC::Struct currStruct1_cca= *itStruct1_cc9;
				set< SFC::TypedEntity> argDeclBases_ccb= currStruct2_cc7.te();
				for( set< SFC::TypedEntity>::const_iterator itArgDeclBases_ccc= argDeclBases_ccb.begin(); itArgDeclBases_ccc!= argDeclBases_ccb.end(); ++itArgDeclBases_ccc)
				{
					if( false== Uml::IsDerivedFrom( (*itArgDeclBases_ccc).type(), SFC::ArgDeclBase::meta))
						continue;
					SFC::ArgDeclBase currArgDeclBase_ccd= SFC::ArgDeclBase::Cast( *itArgDeclBases_ccc);
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_cd1;
					if( !isValidBound(boundObjs_cd1, class1_cba, true))
						continue;
					currMatch.class1_cd2= class1_cba;
					if( !isValidBound(boundObjs_cd1, class2_cc3, true))
						continue;
					currMatch.class2_cd3= class2_cc3;
					if( !isValidBound(boundObjs_cd1, currStruct1_cca, false))
						continue;
					currMatch.struct1_cd4= currStruct1_cca;
					if( !isValidBound(boundObjs_cd1, currArgDeclBase_ccd, false))
						continue;
					currMatch.argDeclBase_cd5= currArgDeclBase_ccd;
					if( !isValidBound(boundObjs_cd1, currStruct2_cc7, false))
						continue;
					currMatch.struct2_cd6= currStruct2_cc7;
					_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void TransferStruct_cae::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.argDeclBase_cd5.dt()= currMatch.struct1_cd4;
	}
}

void TransferSubsystems_cdd::operator()( const Packets_t& class1s_cde, const Packets_t& class2s_ce0, Packets_t& class1s_ce2, Packets_t& class2s_ce3)
{
#ifdef PRINT_INFO
	printLog("TransferSubsystems_cdd" );
#endif
	_class1_ce4= &class1s_ce2;
	_class2_ce5= &class2s_ce3;
	if( ( !class1s_cde.empty())&& ( !class2s_ce0.empty()))
		callTransferSubsystem_d07( class1s_cde, class2s_ce0);
	_class1_ce4->insert( _class1_ce4->end(), class1s_cde.begin(), class1s_cde.end());
	_class2_ce5->insert( _class2_ce5->end(), class2s_ce0.begin(), class2s_ce0.end());
}

void TransferSubsystems_cdd::callTransferSubsystem_d07( const Packets_t& class1s_ce7, const Packets_t& class2s_ce9)
{
	TransferSubsystem_ce6 transferSubsystem_ce6;
	transferSubsystem_ce6( class1s_ce7, class2s_ce9);
}

void TransferSubsystem_ce6::operator()( const Packets_t& class1s_ce7, const Packets_t& class2s_ce9)
{
#ifdef PRINT_INFO
	printLog("TransferSubsystem_ce6" );
#endif
	RTTGenerator::Instance()->generateRule(625, "TransferSubsystem");
	processInputPackets( class1s_ce7, class2s_ce9);
}

bool TransferSubsystem_ce6::isInputUnique( const Udm::Object& class1_cef, const Udm::Object& class2_cf8)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_cf1= _class1_ceb.begin(), itClass2_cfa= _class2_cf4.begin(); itClass1_cf1!= _class1_ceb.end(), itClass2_cfa!= _class2_cf4.end(); ++itClass1_cf1, ++itClass2_cfa)
	{
		if( ( *itClass1_cf1== class1_cef)&& ( *itClass2_cfa== class2_cf8))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_class1_ceb.push_back( class1_cef);
		_class2_cf4.push_back( class2_cf8);
	}
	return isUnique;
}

bool TransferSubsystem_ce6::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void TransferSubsystem_ce6::processInputPackets( const Packets_t& class1s_ce7, const Packets_t& class2s_ce9)
{
	for( Packets_t::const_iterator itClass1_cec= class1s_ce7.begin(), itClass2_cf5= class2s_ce9.begin(); itClass1_cec!= class1s_ce7.end(), itClass2_cf5!= class2s_ce9.end(); ++itClass1_cec, ++itClass2_cf5)
	{
		bool isUnique= isInputUnique( *itClass1_cec, *itClass2_cf5);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_cec, *itClass2_cf5);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TransferSubsystem_ce6::patternMatcher( const Udm::Object& class1_ced, const Udm::Object& class2_cf6)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_ced.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_cf2= SFC::Class::Cast( class1_ced);
		if( false== Uml::IsDerivedFrom( class2_cf6.type(), SFC::Class::meta))
			continue;
		SFC::Class class2_cfb= SFC::Class::Cast( class2_cf6);
		set< CyPhyML::SignalFlow::Subsystem> subsystems_cfd= class2_cfb.obj();
		for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itSubsystems_cfe= subsystems_cfd.begin(); itSubsystems_cfe!= subsystems_cfd.end(); ++itSubsystems_cfe)
		{
			CyPhyML::SignalFlow::Subsystem currSubsystem_cff= *itSubsystems_cfe;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_d03;
			if( !isValidBound(boundObjs_d03, class1_cf2, true))
				continue;
			currMatch.class1_d04= class1_cf2;
			if( !isValidBound(boundObjs_d03, class2_cfb, true))
				continue;
			currMatch.class2_d05= class2_cfb;
			if( !isValidBound(boundObjs_d03, currSubsystem_cff, false))
				continue;
			currMatch.subsystem_d06= currSubsystem_cff;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void TransferSubsystem_ce6::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.subsystem_d06.cls()= currMatch.class1_d04;
	}
}

void GetEquivalence_d0a::operator()( const Packets_t& class1s_d0b, Packets_t& class1s_d0d, Packets_t& class2s_d0e)
{
#ifdef PRINT_INFO
	printLog("GetEquivalence_d0a" );
#endif
	RTTGenerator::Instance()->generateRule(631, "GetEquivalence");
	_class1_d0f= &class1s_d0d;
	_class2_d10= &class2s_d0e;
	processInputPackets( class1s_d0b);
}

bool GetEquivalence_d0a::isInputUnique( const Udm::Object& class1_d15)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itClass1_d17= _class1_d11.begin(); itClass1_d17!= _class1_d11.end(); ++itClass1_d17)
	{
		if( ( *itClass1_d17== class1_d15))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_class1_d11.push_back( class1_d15);
	return isUnique;
}

bool GetEquivalence_d0a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetEquivalence_d0a::processInputPackets( const Packets_t& class1s_d0b)
{
	for( Packets_t::const_iterator itClass1_d12= class1s_d0b.begin(); itClass1_d12!= class1s_d0b.end(); ++itClass1_d12)
	{
		bool isUnique= isInputUnique( *itClass1_d12);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itClass1_d12);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetEquivalence_d0a::patternMatcher( const Udm::Object& class1_d13)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( class1_d13.type(), SFC::Class::meta))
			continue;
		SFC::Class class1_d18= SFC::Class::Cast( class1_d13);
		set< SFC::Class> class2s_d1a= class1_d18.equivdst();
		for( set< SFC::Class>::const_iterator itClass2s_d1b= class2s_d1a.begin(); itClass2s_d1b!= class2s_d1a.end(); ++itClass2s_d1b)
		{
			SFC::Class currClass2_d1c= *itClass2s_d1b;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_d20;
			if( !isValidBound(boundObjs_d20, class1_d18, true))
				continue;
			currMatch.class1_d21= class1_d18;
			if( !isValidBound(boundObjs_d20, currClass2_d1c, false))
				continue;
			currMatch.class2_d22= currClass2_d1c;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetEquivalence_d0a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class1_d21, currMatch.class2_d22);
	}
}

void GetEquivalence_d0a::outputAppender( const SFC::Class& class1_d23, const SFC::Class& class2_d25)
{
	_class1_d0f->push_back( class1_d23);
	_class2_d10->push_back( class2_d25);
}

void GetClasses_d40::operator()( const Packets_t& projects_d42, Packets_t& classs_d41)
{
#ifdef PRINT_INFO
	printLog("GetClasses_d40" );
#endif
	RTTGenerator::Instance()->generateRule(635, "GetClasses");
	_class_d44= &classs_d41;
	processInputPackets( projects_d42);
}

bool GetClasses_d40::isInputUnique( const Udm::Object& project_d49)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itProject_d4b= _project_d45.begin(); itProject_d4b!= _project_d45.end(); ++itProject_d4b)
	{
		if( ( *itProject_d4b== project_d49))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_project_d45.push_back( project_d49);
	return isUnique;
}

bool GetClasses_d40::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetClasses_d40::processInputPackets( const Packets_t& projects_d42)
{
	for( Packets_t::const_iterator itProject_d46= projects_d42.begin(); itProject_d46!= projects_d42.end(); ++itProject_d46)
	{
		bool isUnique= isInputUnique( *itProject_d46);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itProject_d46);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetClasses_d40::patternMatcher( const Udm::Object& project_d47)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( project_d47.type(), SFC::Project::meta))
			continue;
		SFC::Project project_d4c= SFC::Project::Cast( project_d47);
		set< SFC::Program> programs_d4e= project_d4c.Program_kind_children();
		for( set< SFC::Program>::const_iterator itProgram_d4f= programs_d4e.begin(); itProgram_d4f!= programs_d4e.end(); ++itProgram_d4f)
		{
			SFC::Program currProgram_d50= *itProgram_d4f;
			set< SFC::Class> classs_d51= currProgram_d50.Class_kind_children();
			for( set< SFC::Class>::const_iterator itClass_d52= classs_d51.begin(); itClass_d52!= classs_d51.end(); ++itClass_d52)
			{
				SFC::Class currClass_d53= *itClass_d52;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_d57;
				if( !isValidBound(boundObjs_d57, project_d4c, true))
					continue;
				currMatch.project_d58= project_d4c;
				if( !isValidBound(boundObjs_d57, currProgram_d50, false))
					continue;
				currMatch.program_d59= currProgram_d50;
				if( !isValidBound(boundObjs_d57, currClass_d53, false))
					continue;
				currMatch.class_d5a= currClass_d53;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetClasses_d40::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.class_d5a);
	}
}

void GetClasses_d40::outputAppender( const SFC::Class& class_d5b)
{
	_class_d44->push_back( class_d5b);
}

void MakeEquivalence_d5d::operator()( const Packets_t& projects_d5e, Packets_t& projects_d60)
{
#ifdef PRINT_INFO
	printLog("MakeEquivalence_d5d" );
#endif
	RTTGenerator::Instance()->generateRule(641, "MakeEquivalence");
	_project_d61= &projects_d60;
	processInputPackets( projects_d5e);
	forwardInputs( );
}

bool MakeEquivalence_d5d::isInputUnique( const Udm::Object& project_d66)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itProject_d68= _project_d62.begin(); itProject_d68!= _project_d62.end(); ++itProject_d68)
	{
		if( ( *itProject_d68== project_d66))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_project_d62.push_back( project_d66);
	return isUnique;
}

bool MakeEquivalence_d5d::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool MakeEquivalence_d5d::isGuardTrue( SFC::Class& Class1, SFC::Class& Class2, SFC::Program& Program, SFC::Project& Project, CyPhyML::SignalFlow::Subsystem& Subsystem1, CyPhyML::SignalFlow::Subsystem& Subsystem2)
{
	bool Gz_guard= false;
	Gz_guard =
 Class1.uniqueId() > Class2.uniqueId() &&
 SFUtils::InstanceEquivalent( Subsystem1, Subsystem2 );;
	return Gz_guard;
}

void MakeEquivalence_d5d::processInputPackets( const Packets_t& projects_d5e)
{
	for( Packets_t::const_iterator itProject_d63= projects_d5e.begin(); itProject_d63!= projects_d5e.end(); ++itProject_d63)
	{
		bool isUnique= isInputUnique( *itProject_d63);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itProject_d63);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool MakeEquivalence_d5d::patternMatcher( const Udm::Object& project_d64)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( project_d64.type(), SFC::Project::meta))
			continue;
		SFC::Project project_d69= SFC::Project::Cast( project_d64);
		set< SFC::Program> programs_d6b= project_d69.Program_kind_children();
		for( set< SFC::Program>::const_iterator itProgram_d6c= programs_d6b.begin(); itProgram_d6c!= programs_d6b.end(); ++itProgram_d6c)
		{
			SFC::Program currProgram_d6d= *itProgram_d6c;
			set< SFC::Class> class1s_d6e= currProgram_d6d.Class_kind_children();
			for( set< SFC::Class>::const_iterator itClass1_d6f= class1s_d6e.begin(); itClass1_d6f!= class1s_d6e.end(); ++itClass1_d6f)
			{
				SFC::Class currClass1_d70= *itClass1_d6f;
				set< SFC::Class> class2s_d71= currProgram_d6d.Class_kind_children();
				for( set< SFC::Class>::const_iterator itClass2_d72= class2s_d71.begin(); itClass2_d72!= class2s_d71.end(); ++itClass2_d72)
				{
					SFC::Class currClass2_d73= *itClass2_d72;
					set< CyPhyML::SignalFlow::Subsystem> subsystem2s_d74= currClass2_d73.obj();
					for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itSubsystem2s_d75= subsystem2s_d74.begin(); itSubsystem2s_d75!= subsystem2s_d74.end(); ++itSubsystem2s_d75)
					{
						CyPhyML::SignalFlow::Subsystem currSubsystem2_d76= *itSubsystem2s_d75;
						set< CyPhyML::SignalFlow::Subsystem> subsystem1s_d77= currClass1_d70.obj();
						for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itSubsystem1s_d78= subsystem1s_d77.begin(); itSubsystem1s_d78!= subsystem1s_d77.end(); ++itSubsystem1s_d78)
						{
							CyPhyML::SignalFlow::Subsystem currSubsystem1_d79= *itSubsystem1s_d78;
							Match currMatch;
							set< pair<int, Udm::Object> > boundObjs_d7d;
							if( !isValidBound(boundObjs_d7d, project_d69, true))
								continue;
							currMatch.project_d7e= project_d69;
							if( !isValidBound(boundObjs_d7d, currProgram_d6d, false))
								continue;
							currMatch.program_d7f= currProgram_d6d;
							if( !isValidBound(boundObjs_d7d, currClass1_d70, false))
								continue;
							currMatch.class1_d80= currClass1_d70;
							if( !isValidBound(boundObjs_d7d, currClass2_d73, false))
								continue;
							currMatch.class2_d81= currClass2_d73;
							if( !isValidBound(boundObjs_d7d, currSubsystem1_d79, false))
								continue;
							currMatch.subsystem1_d82= currSubsystem1_d79;
							if( !isValidBound(boundObjs_d7d, currSubsystem2_d76, false))
								continue;
							currMatch.subsystem2_d83= currSubsystem2_d76;
							bool Gz_guard= isGuardTrue( currMatch.class1_d80, currMatch.class2_d81, currMatch.program_d7f, currMatch.project_d7e, currMatch.subsystem1_d82, currMatch.subsystem2_d83);
							if( true== Gz_guard)
								_matches.push_back( currMatch);
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void MakeEquivalence_d5d::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.class1_d80.equivdst()+= currMatch.class2_d81;
	}
}

void MakeEquivalence_d5d::forwardInputs()
{
	*_project_d61= _project_d62;
}

void Constructors_d94::operator()( const Packets_t& dataflows_d95, const Packets_t& projects_d97, Packets_t& dataflows_d99, Packets_t& projects_d9a)
{
#ifdef PRINT_INFO
	printLog("Constructors_d94" );
#endif
	_dataflow_d9b= &dataflows_d99;
	_project_d9c= &projects_d9a;
	if( ( !dataflows_d95.empty()))
		callGetSubsystems_1219( dataflows_d95);
	_dataflow_d9b->insert( _dataflow_d9b->end(), dataflows_d95.begin(), dataflows_d95.end());
	_project_d9c->insert( _project_d9c->end(), projects_d97.begin(), projects_d97.end());
}

void Constructors_d94::callGetSubsystems_1219( const Packets_t& comptypes_11fa)
{
	Packets_t subsystems_11fc;
	GetSubsystems_11f9 getSubsystems_11f9;
	getSubsystems_11f9( comptypes_11fa, subsystems_11fc);
	if( ( !subsystems_11fc.empty()))
		callMakeAllConstructors_121b( subsystems_11fc);
}

void Constructors_d94::callMakeAllConstructors_121b( const Packets_t& subsystems_d9e)
{
	MakeAllConstructors_d9d makeAllConstructors_d9d;
	makeAllConstructors_d9d( subsystems_d9e);
}

void MakeAllConstructors_d9d::operator()( const Packets_t& subsystems_d9e)
{
#ifdef PRINT_INFO
	printLog("MakeAllConstructors_d9d" );
#endif
	if( ( !subsystems_d9e.empty()))
		callSubsystemFilter_11ef( subsystems_d9e);
}

void MakeAllConstructors_d9d::callSubsystemFilter_11ef( const Packets_t& systems_1152)
{
	Packets_t chartsystems_1154;
	Packets_t sFchartsystems_1155;
	Packets_t systems_1156;
	SubsystemFilter_1151 subsystemFilter_1151;
	subsystemFilter_1151( systems_1152, chartsystems_1154, sFchartsystems_1155, systems_1156);
	if( ( !sFchartsystems_1155.empty()))
		callMakeSFChartConstructor_11f1( sFchartsystems_1155);
	if( ( !systems_1156.empty()))
		callMakeConstructors_11f3( systems_1156);
	if( ( !chartsystems_1154.empty()))
		callMakeChartConstructor_11f5( chartsystems_1154);
}

void MakeAllConstructors_d9d::callMakeSFChartConstructor_11f1( const Packets_t& systems_da1)
{
	MakeSFChartConstructor_da0 makeSFChartConstructor_da0;
	makeSFChartConstructor_da0( systems_da1);
}

void MakeAllConstructors_d9d::callMakeConstructors_11f3( const Packets_t& systems_dfb)
{
	Packets_t systems_dfd;
	MakeConstructors_dfa makeConstructors_dfa;
	makeConstructors_dfa( systems_dfb, systems_dfd);
	if( ( !systems_dfd.empty()))
		callGetSubSubsystems_11f7( systems_dfd);
}

void MakeAllConstructors_d9d::callMakeChartConstructor_11f5( const Packets_t& systems_1129)
{
	MakeChartConstructor_1128 makeChartConstructor_1128;
	makeChartConstructor_1128( systems_1129);
}

void MakeAllConstructors_d9d::callGetSubSubsystems_11f7( const Packets_t& systems_11d0)
{
	Packets_t subsystems_11d2;
	GetSubSubsystems_11cf getSubSubsystems_11cf;
	getSubSubsystems_11cf( systems_11d0, subsystems_11d2);
	if( ( !subsystems_11d2.empty()))
		callSubsystemFilter_11ef( subsystems_11d2);
}

void MakeSFChartConstructor_da0::operator()( const Packets_t& systems_da1)
{
#ifdef PRINT_INFO
	printLog("MakeSFChartConstructor_da0" );
#endif
	if( ( !systems_da1.empty()))
		callCreateInitFunction_df5( systems_da1);
}

void MakeSFChartConstructor_da0::callCreateInitFunction_df5( const Packets_t& subsystems_da4)
{
	Packets_t subsystems_da6;
	Packets_t initFunctions_da7;
	CreateInitFunction_da3 createInitFunction_da3;
	createInitFunction_da3( subsystems_da4, subsystems_da6, initFunctions_da7);
	if( ( !subsystems_da6.empty())&& ( !initFunctions_da7.empty()))
		callinitSubSubsystem_df7( subsystems_da6, initFunctions_da7);
}

void MakeSFChartConstructor_da0::callinitSubSubsystem_df7( const Packets_t& subsystems_dc5, const Packets_t& initFunctions_dc7)
{
	InitSubSubsystem_dc4 initSubSubsystem_dc4;
	initSubSubsystem_dc4( subsystems_dc5, initFunctions_dc7);
}

void CreateInitFunction_da3::operator()( const Packets_t& subsystems_da4, Packets_t& subsystems_da6, Packets_t& initFunctions_da7)
{
#ifdef PRINT_INFO
	printLog("CreateInitFunction_da3" );
#endif
	RTTGenerator::Instance()->generateRule(663, "CreateInitFunction");
	_subsystem_da8= &subsystems_da6;
	_initFunction_da9= &initFunctions_da7;
	processInputPackets( subsystems_da4);
}

bool CreateInitFunction_da3::isInputUnique( const Udm::Object& subsystem_dae)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_db0= _subsystem_daa.begin(); itSubsystem_db0!= _subsystem_daa.end(); ++itSubsystem_db0)
	{
		if( ( *itSubsystem_db0== subsystem_dae))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_subsystem_daa.push_back( subsystem_dae);
	return isUnique;
}

bool CreateInitFunction_da3::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateInitFunction_da3::processInputPackets( const Packets_t& subsystems_da4)
{
	for( Packets_t::const_iterator itSubsystem_dab= subsystems_da4.begin(); itSubsystem_dab!= subsystems_da4.end(); ++itSubsystem_dab)
	{
		bool isUnique= isInputUnique( *itSubsystem_dab);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_dab);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateInitFunction_da3::patternMatcher( const Udm::Object& subsystem_dac)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_dac.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_db1= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_dac);
		SFC::Class class_db3= subsystem_db1.cls();
		if( !class_db3)
			continue;
		set< SFC::Struct> structs_db4= class_db3.Struct_kind_children();
		for( set< SFC::Struct>::const_iterator itStruct_db5= structs_db4.begin(); itStruct_db5!= structs_db4.end(); ++itStruct_db5)
		{
			SFC::Struct currStruct_db6= *itStruct_db5;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_dba;
			if( !isValidBound(boundObjs_dba, subsystem_db1, true))
				continue;
			currMatch.subsystem_dbb= subsystem_db1;
			if( !isValidBound(boundObjs_dba, class_db3, false))
				continue;
			currMatch.class_dbc= class_db3;
			if( !isValidBound(boundObjs_dba, currStruct_db6, false))
				continue;
			currMatch.struct_dbd= currStruct_db6;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateInitFunction_da3::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function newInitFunction_dbe= SFC::Function::Create( currMatch.class_dbc, SFC::Class::meta_stmnt);
		SFC::Arg newArg_dbf= SFC::Arg::Create( newInitFunction_dbe);
		SFC::Arg& Arg= newArg_dbf;
		SFC::Class& Class= currMatch.class_dbc;
		SFC::Function& InitFunction= newInitFunction_dbe;
		SFC::Struct& Struct= currMatch.struct_dbd;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_dbb;
		{
__int64 statementCount = Class.statementCount();
InitFunction.statementIndex() = statementCount++;
Class.statementCount() = statementCount;

InitFunction.name() = static_cast< std::string >( Subsystem.name() ) +  "_init";
InitFunction.argCount() = 1;
InitFunction.statementCount() = -1;
};
		{
Arg.name() = "context";
Arg.ptr() = true;
Arg.argIndex() = 0;
};
		newInitFunction_dbe.sysinit()= currMatch.subsystem_dbb;
		newArg_dbf.dt()= currMatch.struct_dbd;
		outputAppender( currMatch.subsystem_dbb, newInitFunction_dbe);
	}
}

void CreateInitFunction_da3::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_dc0, const SFC::Function& initFunction_dc2)
{
	_subsystem_da8->push_back( subsystem_dc0);
	_initFunction_da9->push_back( initFunction_dc2);
}

void InitSubSubsystem_dc4::operator()( const Packets_t& subsystems_dc5, const Packets_t& initFunctions_dc7)
{
#ifdef PRINT_INFO
	printLog("InitSubSubsystem_dc4" );
#endif
	RTTGenerator::Instance()->generateRule(886, "initSubSubsystem");
	processInputPackets( subsystems_dc5, initFunctions_dc7);
}

bool InitSubSubsystem_dc4::isInputUnique( const Udm::Object& subsystem_dcd, const Udm::Object& initFunction_dd6)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_dcf= _subsystem_dc9.begin(), itInitFunction_dd8= _initFunction_dd2.begin(); itSubsystem_dcf!= _subsystem_dc9.end(), itInitFunction_dd8!= _initFunction_dd2.end(); ++itSubsystem_dcf, ++itInitFunction_dd8)
	{
		if( ( *itSubsystem_dcf== subsystem_dcd)&& ( *itInitFunction_dd8== initFunction_dd6))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_dc9.push_back( subsystem_dcd);
		_initFunction_dd2.push_back( initFunction_dd6);
	}
	return isUnique;
}

bool InitSubSubsystem_dc4::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void InitSubSubsystem_dc4::processInputPackets( const Packets_t& subsystems_dc5, const Packets_t& initFunctions_dc7)
{
	for( Packets_t::const_iterator itSubsystem_dca= subsystems_dc5.begin(), itInitFunction_dd3= initFunctions_dc7.begin(); itSubsystem_dca!= subsystems_dc5.end(), itInitFunction_dd3!= initFunctions_dc7.end(); ++itSubsystem_dca, ++itInitFunction_dd3)
	{
		bool isUnique= isInputUnique( *itSubsystem_dca, *itInitFunction_dd3);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_dca, *itInitFunction_dd3);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitSubSubsystem_dc4::patternMatcher( const Udm::Object& subsystem_dcb, const Udm::Object& initFunction_dd4)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_dcb.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_dd0= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_dcb);
		if( false== Uml::IsDerivedFrom( initFunction_dd4.type(), SFC::Function::meta))
			continue;
		SFC::Function initFunction_dd9= SFC::Function::Cast( initFunction_dd4);
		Udm::Object subsystemParent_ddb= subsystem_dd0.container();
		if( false== Uml::IsDerivedFrom( subsystemParent_ddb.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem superSubsystemSubsystem_ddc= CyPhyML::SignalFlow::Subsystem::Cast( subsystemParent_ddb);
		set< SFC::Arg> args_ddd= initFunction_dd9.Arg_kind_children();
		for( set< SFC::Arg>::const_iterator itArg_dde= args_ddd.begin(); itArg_dde!= args_ddd.end(); ++itArg_dde)
		{
			SFC::Arg currArg_ddf= *itArg_dde;
			SFC::Function superInitFunction_de0= superSubsystemSubsystem_ddc.init();
			if( !superInitFunction_de0)
				continue;
			set< SFC::Arg> superArgs_de1= superInitFunction_de0.Arg_kind_children();
			for( set< SFC::Arg>::const_iterator itSuperArg_de2= superArgs_de1.begin(); itSuperArg_de2!= superArgs_de1.end(); ++itSuperArg_de2)
			{
				SFC::Arg currSuperArg_de3= *itSuperArg_de2;
				SFC::LocalVar localVar_de4= subsystem_dd0.memb();
				if( !localVar_de4)
					continue;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_de8;
				if( !isValidBound(boundObjs_de8, subsystem_dd0, true))
					continue;
				currMatch.subsystem_de9= subsystem_dd0;
				if( !isValidBound(boundObjs_de8, initFunction_dd9, true))
					continue;
				currMatch.initFunction_dea= initFunction_dd9;
				if( !isValidBound(boundObjs_de8, localVar_de4, false))
					continue;
				currMatch.localVar_deb= localVar_de4;
				if( !isValidBound(boundObjs_de8, currSuperArg_de3, false))
					continue;
				currMatch.superArg_dec= currSuperArg_de3;
				if( !isValidBound(boundObjs_de8, superInitFunction_de0, false))
					continue;
				currMatch.superInitFunction_ded= superInitFunction_de0;
				if( !isValidBound(boundObjs_de8, superSubsystemSubsystem_ddc, false))
					continue;
				currMatch.superSubsystem_dee= superSubsystemSubsystem_ddc;
				if( !isValidBound(boundObjs_de8, currArg_ddf, false))
					continue;
				currMatch.arg_def= currArg_ddf;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void InitSubSubsystem_dc4::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::FunctionCall newFunctionCall_df0= SFC::FunctionCall::Create( currMatch.superInitFunction_ded, SFC::Function::meta_stmnt);
		SFC::ArgVal newArgVal_df1= SFC::ArgVal::Create( newFunctionCall_df0);
		SFC::BinaryExprs newBinaryExprs_df2= SFC::BinaryExprs::Create( newArgVal_df1, SFC::ArgVal::meta_argexpr);
		SFC::ArgDeclRef newDeclRef_df3= SFC::ArgDeclRef::Create( newBinaryExprs_df2, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef_df4= SFC::ArgDeclRef::Create( newBinaryExprs_df2, SFC::BinaryExprs::meta_leftexpr);
		SFC::Arg& Arg= currMatch.arg_def;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_df4;
		SFC::ArgVal& ArgVal= newArgVal_df1;
		SFC::BinaryExprs& BinaryExprs= newBinaryExprs_df2;
		SFC::ArgDeclRef& DeclRef= newDeclRef_df3;
		SFC::FunctionCall& FunctionCall= newFunctionCall_df0;
		SFC::Function& InitFunction= currMatch.initFunction_dea;
		SFC::LocalVar& LocalVar= currMatch.localVar_deb;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_de9;
		SFC::Arg& SuperArg= currMatch.superArg_dec;
		SFC::Function& SuperInitFunction= currMatch.superInitFunction_ded;
		CyPhyML::SignalFlow::Subsystem& SuperSubsystem= currMatch.superSubsystem_dee;
		{
ArgVal.argIndex() = Arg.argIndex();
};
		{
BinaryExprs.op() = ".";
};
		{
__int64 statementCount = SuperInitFunction.statementCount();
FunctionCall.statementIndex() = statementCount++;
SuperInitFunction.statementCount() = statementCount;

FunctionCall.argCount() = 1;
};
		newFunctionCall_df0.callee()= currMatch.initFunction_dea;
		newDeclRef_df3.argdecl()= currMatch.localVar_deb;
		newArgVal_df1.arg()+= currMatch.arg_def;
		newArgDeclRef_df4.argdecl()= currMatch.superArg_dec;
	}
}

void MakeConstructors_dfa::operator()( const Packets_t& systems_dfb, Packets_t& systems_dfd)
{
#ifdef PRINT_INFO
	printLog("MakeConstructors_dfa" );
#endif
	_system_dfe= &systems_dfd;
	_system_dfe->insert( _system_dfe->end(), systems_dfb.begin(), systems_dfb.end());
	if( ( !systems_dfb.empty()))
		callCreateInitFunction_111f( systems_dfb);
}

void MakeConstructors_dfa::callCreateInitFunction_111f( const Packets_t& subsystems_e00)
{
	Packets_t subsystems_e02;
	Packets_t initFunctions_e03;
	Packets_t structs_e04;
	CreateInitFunction_dff createInitFunction_dff;
	createInitFunction_dff( subsystems_e00, subsystems_e02, initFunctions_e03, structs_e04);
	if( ( !subsystems_e02.empty())&& ( !initFunctions_e03.empty())&& ( !structs_e04.empty()))
		callinitParameters_1121( subsystems_e02, initFunctions_e03, structs_e04);
}

void MakeConstructors_dfa::callinitParameters_1121( const Packets_t& systems_e25, const Packets_t& initFunctions_e27, const Packets_t& classStructs_e29)
{
	Packets_t systems_e2b;
	Packets_t initFunctions_e2c;
	InitParameters_e24 initParameters_e24;
	initParameters_e24( systems_e25, initFunctions_e27, classStructs_e29, systems_e2b, initFunctions_e2c);
	if( ( !systems_e2b.empty())&& ( !initFunctions_e2c.empty()))
		callinitSubSubsystem_1125( systems_e2b, initFunctions_e2c);
}

void MakeConstructors_dfa::callinitSubSubsystem_1125( const Packets_t& subsystems_dc5, const Packets_t& initFunctions_dc7)
{
	InitSubSubsystem_dc4 initSubSubsystem_dc4;
	initSubSubsystem_dc4( subsystems_dc5, initFunctions_dc7);
}

void CreateInitFunction_dff::operator()( const Packets_t& subsystems_e00, Packets_t& subsystems_e02, Packets_t& initFunctions_e03, Packets_t& structs_e04)
{
#ifdef PRINT_INFO
	printLog("CreateInitFunction_dff" );
#endif
	RTTGenerator::Instance()->generateRule(680, "CreateInitFunction");
	_subsystem_e05= &subsystems_e02;
	_initFunction_e06= &initFunctions_e03;
	_struct_e07= &structs_e04;
	processInputPackets( subsystems_e00);
}

bool CreateInitFunction_dff::isInputUnique( const Udm::Object& subsystem_e0c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_e0e= _subsystem_e08.begin(); itSubsystem_e0e!= _subsystem_e08.end(); ++itSubsystem_e0e)
	{
		if( ( *itSubsystem_e0e== subsystem_e0c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_subsystem_e08.push_back( subsystem_e0c);
	return isUnique;
}

bool CreateInitFunction_dff::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateInitFunction_dff::processInputPackets( const Packets_t& subsystems_e00)
{
	for( Packets_t::const_iterator itSubsystem_e09= subsystems_e00.begin(); itSubsystem_e09!= subsystems_e00.end(); ++itSubsystem_e09)
	{
		bool isUnique= isInputUnique( *itSubsystem_e09);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_e09);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateInitFunction_dff::patternMatcher( const Udm::Object& subsystem_e0a)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_e0a.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_e0f= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_e0a);
		SFC::Class class_e11= subsystem_e0f.cls();
		if( !class_e11)
			continue;
		set< SFC::Struct> structs_e12= class_e11.Struct_kind_children();
		for( set< SFC::Struct>::const_iterator itStruct_e13= structs_e12.begin(); itStruct_e13!= structs_e12.end(); ++itStruct_e13)
		{
			SFC::Struct currStruct_e14= *itStruct_e13;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_e18;
			if( !isValidBound(boundObjs_e18, subsystem_e0f, true))
				continue;
			currMatch.subsystem_e19= subsystem_e0f;
			if( !isValidBound(boundObjs_e18, class_e11, false))
				continue;
			currMatch.class_e1a= class_e11;
			if( !isValidBound(boundObjs_e18, currStruct_e14, false))
				continue;
			currMatch.struct_e1b= currStruct_e14;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateInitFunction_dff::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function newInitFunction_e1c= SFC::Function::Create( currMatch.class_e1a, SFC::Class::meta_stmnt);
		SFC::Arg newArg_e1d= SFC::Arg::Create( newInitFunction_e1c);
		SFC::Arg& Arg= newArg_e1d;
		SFC::Class& Class= currMatch.class_e1a;
		SFC::Function& InitFunction= newInitFunction_e1c;
		SFC::Struct& Struct= currMatch.struct_e1b;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_e19;
		{
__int64 statementCount = Class.statementCount();
InitFunction.statementIndex() = statementCount++;
Class.statementCount() = statementCount;

InitFunction.name() = static_cast< std::string >( Subsystem.name() ) + "_" + boost::lexical_cast< std::string >( Subsystem.uniqueId() )+  "_init";
InitFunction.argCount() = 1;
};
		{
Arg.name() = "context";
Arg.ptr() = true;
Arg.argIndex() = 0;
};
		newArg_e1d.dt()= currMatch.struct_e1b;
		newInitFunction_e1c.sysinit()= currMatch.subsystem_e19;
		outputAppender( currMatch.subsystem_e19, newInitFunction_e1c, currMatch.struct_e1b);
	}
}

void CreateInitFunction_dff::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_e1e, const SFC::Function& initFunction_e20, const SFC::Struct& struct_e22)
{
	_subsystem_e05->push_back( subsystem_e1e);
	_initFunction_e06->push_back( initFunction_e20);
	_struct_e07->push_back( struct_e22);
}

void InitParameters_e24::operator()( const Packets_t& systems_e25, const Packets_t& initFunctions_e27, const Packets_t& classStructs_e29, Packets_t& systems_e2b, Packets_t& initFunctions_e2c)
{
#ifdef PRINT_INFO
	printLog("InitParameters_e24" );
#endif
	_system_e2d= &systems_e2b;
	_initFunction_e2e= &initFunctions_e2c;
	_system_e2d->insert( _system_e2d->end(), systems_e25.begin(), systems_e25.end());
	_initFunction_e2e->insert( _initFunction_e2e->end(), initFunctions_e27.begin(), initFunctions_e27.end());
	if( ( !systems_e25.empty())&& ( !initFunctions_e27.empty())&& ( !classStructs_e29.empty()))
		callinitDirectParameters_110f( systems_e25, initFunctions_e27, classStructs_e29);
}

void InitParameters_e24::callinitDirectParameters_110f( const Packets_t& systems_e30, const Packets_t& initFunctions_e32, const Packets_t& classStructs_e34)
{
	Packets_t systems_e36;
	Packets_t initFunctions_e37;
	Packets_t classStructs_e38;
	InitDirectParameters_e2f initDirectParameters_e2f;
	initDirectParameters_e2f( systems_e30, initFunctions_e32, classStructs_e34, systems_e36, initFunctions_e37, classStructs_e38);
	if( ( !systems_e36.empty())&& ( !initFunctions_e37.empty())&& ( !classStructs_e38.empty()))
		callinitPrimitiveParameters_1113( systems_e36, initFunctions_e37, classStructs_e38);
}

void InitParameters_e24::callinitPrimitiveParameters_1113( const Packets_t& systems_f32, const Packets_t& initFunctions_f34, const Packets_t& classStructs_f36)
{
	Packets_t systems_f38;
	Packets_t initFunctions_f39;
	Packets_t classStructs_f3a;
	InitPrimitiveParameters_f31 initPrimitiveParameters_f31;
	initPrimitiveParameters_f31( systems_f32, initFunctions_f34, classStructs_f36, systems_f38, initFunctions_f39, classStructs_f3a);
	if( ( !systems_f38.empty())&& ( !initFunctions_f39.empty())&& ( !classStructs_f3a.empty()))
		callinitPrimPseudoParams_1117( systems_f38, initFunctions_f39, classStructs_f3a);
}

void InitParameters_e24::callinitPrimPseudoParams_1117( const Packets_t& systems_10c4, const Packets_t& initFunctions_10c6, const Packets_t& classStructs_10c8)
{
	Packets_t systems_10ca;
	Packets_t initFunctions_10cb;
	Packets_t classStructs_10cc;
	InitPrimPseudoParams_10c3 initPrimPseudoParams_10c3;
	initPrimPseudoParams_10c3( systems_10c4, initFunctions_10c6, classStructs_10c8, systems_10ca, initFunctions_10cb, classStructs_10cc);
	if( ( !systems_10ca.empty())&& ( !initFunctions_10cb.empty())&& ( !classStructs_10cc.empty()))
		callInitTriggerVars_111b( systems_10ca, initFunctions_10cb, classStructs_10cc);
}

void InitParameters_e24::callInitTriggerVars_111b( const Packets_t& systems_e75, const Packets_t& initFunctions_e77, const Packets_t& classStructs_e79)
{
	InitTriggerVars_e74 initTriggerVars_e74;
	initTriggerVars_e74( systems_e75, initFunctions_e77, classStructs_e79);
}

void InitDirectParameters_e2f::operator()( const Packets_t& systems_e30, const Packets_t& initFunctions_e32, const Packets_t& classStructs_e34, Packets_t& systems_e36, Packets_t& initFunctions_e37, Packets_t& classStructs_e38)
{
#ifdef PRINT_INFO
	printLog("InitDirectParameters_e2f" );
#endif
	_system_e39= &systems_e36;
	_initFunction_e3a= &initFunctions_e37;
	_classStruct_e3b= &classStructs_e38;
	_system_e39->insert( _system_e39->end(), systems_e30.begin(), systems_e30.end());
	_initFunction_e3a->insert( _initFunction_e3a->end(), initFunctions_e32.begin(), initFunctions_e32.end());
	_classStruct_e3b->insert( _classStruct_e3b->end(), classStructs_e34.begin(), classStructs_e34.end());
	if( ( !systems_e30.empty())&& ( !initFunctions_e32.empty())&& ( !classStructs_e34.empty()))
		callinitDirectParameter_e70( systems_e30, initFunctions_e32, classStructs_e34);
}

void InitDirectParameters_e2f::callinitDirectParameter_e70( const Packets_t& subsystems_e3d, const Packets_t& initFunctions_e3f, const Packets_t& classStructs_e41)
{
	InitDirectParameter_e3c initDirectParameter_e3c;
	initDirectParameter_e3c( subsystems_e3d, initFunctions_e3f, classStructs_e41);
}

void InitDirectParameter_e3c::operator()( const Packets_t& subsystems_e3d, const Packets_t& initFunctions_e3f, const Packets_t& classStructs_e41)
{
#ifdef PRINT_INFO
	printLog("InitDirectParameter_e3c" );
#endif
	RTTGenerator::Instance()->generateRule(707, "initDirectParameter");
	processInputPackets( subsystems_e3d, initFunctions_e3f, classStructs_e41);
}

bool InitDirectParameter_e3c::isInputUnique( const Udm::Object& subsystem_e47, const Udm::Object& initFunction_e50, const Udm::Object& classStruct_e59)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_e49= _subsystem_e43.begin(), itInitFunction_e52= _initFunction_e4c.begin(), itClassStruct_e5b= _classStruct_e55.begin(); itSubsystem_e49!= _subsystem_e43.end(), itInitFunction_e52!= _initFunction_e4c.end(), itClassStruct_e5b!= _classStruct_e55.end(); ++itSubsystem_e49, ++itInitFunction_e52, ++itClassStruct_e5b)
	{
		if( ( *itSubsystem_e49== subsystem_e47)&& ( *itInitFunction_e52== initFunction_e50)&& ( *itClassStruct_e5b== classStruct_e59))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_e43.push_back( subsystem_e47);
		_initFunction_e4c.push_back( initFunction_e50);
		_classStruct_e55.push_back( classStruct_e59);
	}
	return isUnique;
}

bool InitDirectParameter_e3c::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void InitDirectParameter_e3c::processInputPackets( const Packets_t& subsystems_e3d, const Packets_t& initFunctions_e3f, const Packets_t& classStructs_e41)
{
	for( Packets_t::const_iterator itSubsystem_e44= subsystems_e3d.begin(), itInitFunction_e4d= initFunctions_e3f.begin(), itClassStruct_e56= classStructs_e41.begin(); itSubsystem_e44!= subsystems_e3d.end(), itInitFunction_e4d!= initFunctions_e3f.end(), itClassStruct_e56!= classStructs_e41.end(); ++itSubsystem_e44, ++itInitFunction_e4d, ++itClassStruct_e56)
	{
		bool isUnique= isInputUnique( *itSubsystem_e44, *itInitFunction_e4d, *itClassStruct_e56);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_e44, *itInitFunction_e4d, *itClassStruct_e56);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitDirectParameter_e3c::patternMatcher( const Udm::Object& subsystem_e45, const Udm::Object& initFunction_e4e, const Udm::Object& classStruct_e57)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_e45.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_e4a= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_e45);
		if( false== Uml::IsDerivedFrom( initFunction_e4e.type(), SFC::Function::meta))
			continue;
		SFC::Function initFunction_e53= SFC::Function::Cast( initFunction_e4e);
		if( false== Uml::IsDerivedFrom( classStruct_e57.type(), SFC::Struct::meta))
			continue;
		SFC::Struct classStruct_e5c= SFC::Struct::Cast( classStruct_e57);
		set< SFC::LocalVar> localVars_e5e= classStruct_e5c.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itLocalVar_e5f= localVars_e5e.begin(); itLocalVar_e5f!= localVars_e5e.end(); ++itLocalVar_e5f)
		{
			SFC::LocalVar currLocalVar_e60= *itLocalVar_e5f;
			set< CyPhyML::SignalFlow::SF_Parameter> parameters_e61= subsystem_e4a.SF_Parameter_kind_children();
			for( set< CyPhyML::SignalFlow::SF_Parameter>::const_iterator itParameter_e62= parameters_e61.begin(); itParameter_e62!= parameters_e61.end(); ++itParameter_e62)
			{
				CyPhyML::SignalFlow::SF_Parameter currParameter_e63= *itParameter_e62;
				set< CyPhyML::SignalFlow::SF_Parameter> parameters_e64= currLocalVar_e60.param();
				for( set< CyPhyML::SignalFlow::SF_Parameter>::const_iterator itParameters_e65= parameters_e64.begin(); itParameters_e65!= parameters_e64.end(); ++itParameters_e65)
				{
					CyPhyML::SignalFlow::SF_Parameter currParameter_e66= *itParameters_e65;
					if( currParameter_e63!= currParameter_e66)
						continue;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_e6a;
					if( !isValidBound(boundObjs_e6a, subsystem_e4a, true))
						continue;
					currMatch.subsystem_e6b= subsystem_e4a;
					if( !isValidBound(boundObjs_e6a, initFunction_e53, true))
						continue;
					currMatch.initFunction_e6c= initFunction_e53;
					if( !isValidBound(boundObjs_e6a, classStruct_e5c, true))
						continue;
					currMatch.classStruct_e6d= classStruct_e5c;
					if( !isValidBound(boundObjs_e6a, currParameter_e63, false))
						continue;
					currMatch.parameter_e6e= currParameter_e63;
					if( !isValidBound(boundObjs_e6a, currLocalVar_e60, false))
						continue;
					currMatch.localVar_e6f= currLocalVar_e60;
					_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void InitDirectParameter_e3c::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Struct& ClassStruct= currMatch.classStruct_e6d;
		SFC::Function& InitFunction= currMatch.initFunction_e6c;
		SFC::LocalVar& LocalVar= currMatch.localVar_e6f;
		CyPhyML::SignalFlow::SF_Parameter& Parameter= currMatch.parameter_e6e;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_e6b;
		{
SFUtils::InitParameter( InitFunction, Parameter, LocalVar );
};
	}
}

void InitTriggerVars_e74::operator()( const Packets_t& systems_e75, const Packets_t& initFunctions_e77, const Packets_t& classStructs_e79)
{
#ifdef PRINT_INFO
	printLog("InitTriggerVars_e74" );
#endif
	if( ( !systems_e75.empty())&& ( !initFunctions_e77.empty())&& ( !classStructs_e79.empty()))
		callInitMatrixTrigger_f29( systems_e75, initFunctions_e77, classStructs_e79);
}

void InitTriggerVars_e74::callInitMatrixTrigger_f29( const Packets_t& systems_e7c, const Packets_t& initFunctions_e7e, const Packets_t& classStructs_e80)
{
	Packets_t outs_e82;
	Packets_t initFunctions_e83;
	Packets_t classStructs_e84;
	InitMatrixTrigger_e7b initMatrixTrigger_e7b;
	initMatrixTrigger_e7b( systems_e7c, initFunctions_e7e, classStructs_e80, outs_e82, initFunctions_e83, classStructs_e84);
	if( ( !outs_e82.empty())&& ( !initFunctions_e83.empty())&& ( !classStructs_e84.empty()))
		callInitStructTrigger_f2d( outs_e82, initFunctions_e83, classStructs_e84);
}

void InitTriggerVars_e74::callInitStructTrigger_f2d( const Packets_t& systems_ed6, const Packets_t& initFunctions_ed8, const Packets_t& classStructs_eda)
{
	InitStructTrigger_ed5 initStructTrigger_ed5;
	initStructTrigger_ed5( systems_ed6, initFunctions_ed8, classStructs_eda);
}

void InitMatrixTrigger_e7b::operator()( const Packets_t& systems_e7c, const Packets_t& initFunctions_e7e, const Packets_t& classStructs_e80, Packets_t& outs_e82, Packets_t& initFunctions_e83, Packets_t& classStructs_e84)
{
#ifdef PRINT_INFO
	printLog("InitMatrixTrigger_e7b" );
#endif
	_out_e85= &outs_e82;
	_initFunction_e86= &initFunctions_e83;
	_classStruct_e87= &classStructs_e84;
	_out_e85->insert( _out_e85->end(), systems_e7c.begin(), systems_e7c.end());
	_initFunction_e86->insert( _initFunction_e86->end(), initFunctions_e7e.begin(), initFunctions_e7e.end());
	_classStruct_e87->insert( _classStruct_e87->end(), classStructs_e80.begin(), classStructs_e80.end());
	if( ( !systems_e7c.empty())&& ( !initFunctions_e7e.empty())&& ( !classStructs_e80.empty()))
		callInitMatrixTrigger_ed1( systems_e7c, initFunctions_e7e, classStructs_e80);
}

void InitMatrixTrigger_e7b::callInitMatrixTrigger_ed1( const Packets_t& subsystems_e89, const Packets_t& initFunctions_e8b, const Packets_t& classStructs_e8d)
{
	InitMatrixTrigger_e88 initMatrixTrigger_e88;
	initMatrixTrigger_e88( subsystems_e89, initFunctions_e8b, classStructs_e8d);
}

void InitMatrixTrigger_e88::operator()( const Packets_t& subsystems_e89, const Packets_t& initFunctions_e8b, const Packets_t& classStructs_e8d)
{
#ifdef PRINT_INFO
	printLog("InitMatrixTrigger_e88" );
#endif
	RTTGenerator::Instance()->generateRule(728, "InitMatrixTrigger");
	processInputPackets( subsystems_e89, initFunctions_e8b, classStructs_e8d);
}

bool InitMatrixTrigger_e88::isInputUnique( const Udm::Object& subsystem_e93, const Udm::Object& initFunction_e9c, const Udm::Object& classStruct_ea5)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_e95= _subsystem_e8f.begin(), itInitFunction_e9e= _initFunction_e98.begin(), itClassStruct_ea7= _classStruct_ea1.begin(); itSubsystem_e95!= _subsystem_e8f.end(), itInitFunction_e9e!= _initFunction_e98.end(), itClassStruct_ea7!= _classStruct_ea1.end(); ++itSubsystem_e95, ++itInitFunction_e9e, ++itClassStruct_ea7)
	{
		if( ( *itSubsystem_e95== subsystem_e93)&& ( *itInitFunction_e9e== initFunction_e9c)&& ( *itClassStruct_ea7== classStruct_ea5))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_e8f.push_back( subsystem_e93);
		_initFunction_e98.push_back( initFunction_e9c);
		_classStruct_ea1.push_back( classStruct_ea5);
	}
	return isUnique;
}

bool InitMatrixTrigger_e88::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool InitMatrixTrigger_e88::isGuardTrue( SFC::Arg& Arg, SFC::Struct& ClassStruct, SFC::DT& DT, SFC::Function& InitFunction, SFC::LocalVar& LocalVar, CyPhyML::SignalFlow::Subsystem& Subsystem, CyPhyML::SignalFlow::TriggerPort& TriggerPort)
{
	bool Gz_guard= false;
	Gz_guard = DT.type() != SFC::Struct::meta;;
	return Gz_guard;
}

void InitMatrixTrigger_e88::processInputPackets( const Packets_t& subsystems_e89, const Packets_t& initFunctions_e8b, const Packets_t& classStructs_e8d)
{
	for( Packets_t::const_iterator itSubsystem_e90= subsystems_e89.begin(), itInitFunction_e99= initFunctions_e8b.begin(), itClassStruct_ea2= classStructs_e8d.begin(); itSubsystem_e90!= subsystems_e89.end(), itInitFunction_e99!= initFunctions_e8b.end(), itClassStruct_ea2!= classStructs_e8d.end(); ++itSubsystem_e90, ++itInitFunction_e99, ++itClassStruct_ea2)
	{
		bool isUnique= isInputUnique( *itSubsystem_e90, *itInitFunction_e99, *itClassStruct_ea2);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_e90, *itInitFunction_e99, *itClassStruct_ea2);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitMatrixTrigger_e88::patternMatcher( const Udm::Object& subsystem_e91, const Udm::Object& initFunction_e9a, const Udm::Object& classStruct_ea3)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_e91.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_e96= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_e91);
		if( false== Uml::IsDerivedFrom( initFunction_e9a.type(), SFC::Function::meta))
			continue;
		SFC::Function initFunction_e9f= SFC::Function::Cast( initFunction_e9a);
		if( false== Uml::IsDerivedFrom( classStruct_ea3.type(), SFC::Struct::meta))
			continue;
		SFC::Struct classStruct_ea8= SFC::Struct::Cast( classStruct_ea3);
		set< SFC::LocalVar> localVars_eaa= classStruct_ea8.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itLocalVar_eab= localVars_eaa.begin(); itLocalVar_eab!= localVars_eaa.end(); ++itLocalVar_eab)
		{
			SFC::LocalVar currLocalVar_eac= *itLocalVar_eab;
			set< CyPhyML::SignalFlow::TriggerPort> triggerPorts_ead= subsystem_e96.TriggerPort_kind_children();
			for( set< CyPhyML::SignalFlow::TriggerPort>::const_iterator itTriggerPort_eae= triggerPorts_ead.begin(); itTriggerPort_eae!= triggerPorts_ead.end(); ++itTriggerPort_eae)
			{
				CyPhyML::SignalFlow::TriggerPort currTriggerPort_eaf= *itTriggerPort_eae;
				set< CyPhyML::SignalFlow::TriggerPort> triggerPorts_eb0= currLocalVar_eac.trig();
				for( set< CyPhyML::SignalFlow::TriggerPort>::const_iterator itTriggerPorts_eb1= triggerPorts_eb0.begin(); itTriggerPorts_eb1!= triggerPorts_eb0.end(); ++itTriggerPorts_eb1)
				{
					CyPhyML::SignalFlow::TriggerPort currTriggerPort_eb2= *itTriggerPorts_eb1;
					if( currTriggerPort_eaf!= currTriggerPort_eb2)
						continue;
					set< SFC::Arg> args_eb3= initFunction_e9f.Arg_kind_children();
					for( set< SFC::Arg>::const_iterator itArg_eb4= args_eb3.begin(); itArg_eb4!= args_eb3.end(); ++itArg_eb4)
					{
						SFC::Arg currArg_eb5= *itArg_eb4;
						SFC::DT classStruct_eb6= currArg_eb5.dt();
						if(!classStruct_eb6 || false== Uml::IsDerivedFrom( classStruct_eb6.type(), SFC::Struct::meta))
							continue;
						SFC::Struct classStruct_eb7= SFC::Struct::Cast( classStruct_eb6);
						if( !classStruct_eb7)
							continue;
						if( classStruct_ea8!= classStruct_eb7)
							continue;
						SFC::DT dT_eb8= currLocalVar_eac.dt();
						if( !dT_eb8)
							continue;
						Match currMatch;
						set< pair<int, Udm::Object> > boundObjs_ebc;
						if( !isValidBound(boundObjs_ebc, subsystem_e96, true))
							continue;
						currMatch.subsystem_ebd= subsystem_e96;
						if( !isValidBound(boundObjs_ebc, initFunction_e9f, true))
							continue;
						currMatch.initFunction_ebe= initFunction_e9f;
						if( !isValidBound(boundObjs_ebc, classStruct_ea8, true))
							continue;
						currMatch.classStruct_ebf= classStruct_ea8;
						if( !isValidBound(boundObjs_ebc, currTriggerPort_eaf, false))
							continue;
						currMatch.triggerPort_ec0= currTriggerPort_eaf;
						if( !isValidBound(boundObjs_ebc, currArg_eb5, false))
							continue;
						currMatch.arg_ec1= currArg_eb5;
						if( !isValidBound(boundObjs_ebc, currLocalVar_eac, false))
							continue;
						currMatch.localVar_ec2= currLocalVar_eac;
						if( !isValidBound(boundObjs_ebc, dT_eb8, false))
							continue;
						currMatch.dT_ec3= dT_eb8;
						bool Gz_guard= isGuardTrue( currMatch.arg_ec1, currMatch.classStruct_ebf, currMatch.dT_ec3, currMatch.initFunction_ebe, currMatch.localVar_ec2, currMatch.subsystem_ebd, currMatch.triggerPort_ec0);
						if( true== Gz_guard)
							_matches.push_back( currMatch);
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void InitMatrixTrigger_e88::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::UserCode newUserCode_ecb= SFC::UserCode::Create( currMatch.initFunction_ebe, SFC::Function::meta_stmnt);
		SFC::BinaryExprs newAssign_ecc= SFC::BinaryExprs::Create( newUserCode_ecb, SFC::UserCode::meta_codeexpr);
		SFC::BinaryExprs newDot_ecd= SFC::BinaryExprs::Create( newAssign_ecc, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef_ece= SFC::ArgDeclRef::Create( newDot_ecd, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef2_ecf= SFC::ArgDeclRef::Create( newDot_ecd, SFC::BinaryExprs::meta_rightexpr);
		SFC::Int newZero_ed0= SFC::Int::Create( newAssign_ecc, SFC::BinaryExprs::meta_rightexpr);
		SFC::Arg& Arg= currMatch.arg_ec1;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_ece;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_ecf;
		SFC::BinaryExprs& Assign= newAssign_ecc;
		SFC::Struct& ClassStruct= currMatch.classStruct_ebf;
		SFC::DT& DT= currMatch.dT_ec3;
		SFC::BinaryExprs& Dot= newDot_ecd;
		SFC::Function& InitFunction= currMatch.initFunction_ebe;
		SFC::LocalVar& LocalVar= currMatch.localVar_ec2;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_ebd;
		CyPhyML::SignalFlow::TriggerPort& TriggerPort= currMatch.triggerPort_ec0;
		SFC::UserCode& UserCode= newUserCode_ecb;
		SFC::Int& Zero= newZero_ed0;
		{
Dot.op() = ".";
};
		{
Assign.op() = "=";
};
		{
Zero.val() = 0;
};
		{
__int64 statementCount = InitFunction.statementCount();
UserCode.statementIndex() = statementCount++;
InitFunction.statementCount() = statementCount;
};
		newArgDeclRef_ece.argdecl()= currMatch.arg_ec1;
		newArgDeclRef2_ecf.argdecl()= currMatch.localVar_ec2;
	}
}

void InitStructTrigger_ed5::operator()( const Packets_t& systems_ed6, const Packets_t& initFunctions_ed8, const Packets_t& classStructs_eda)
{
#ifdef PRINT_INFO
	printLog("InitStructTrigger_ed5" );
#endif
	if( ( !systems_ed6.empty())&& ( !initFunctions_ed8.empty())&& ( !classStructs_eda.empty()))
		callInitStructTrigger_f25( systems_ed6, initFunctions_ed8, classStructs_eda);
}

void InitStructTrigger_ed5::callInitStructTrigger_f25( const Packets_t& subsystems_edd, const Packets_t& initFunctions_edf, const Packets_t& classStructs_ee1)
{
	InitStructTrigger_edc initStructTrigger_edc;
	initStructTrigger_edc( subsystems_edd, initFunctions_edf, classStructs_ee1);
}

void InitStructTrigger_edc::operator()( const Packets_t& subsystems_edd, const Packets_t& initFunctions_edf, const Packets_t& classStructs_ee1)
{
#ifdef PRINT_INFO
	printLog("InitStructTrigger_edc" );
#endif
	RTTGenerator::Instance()->generateRule(764, "InitStructTrigger");
	processInputPackets( subsystems_edd, initFunctions_edf, classStructs_ee1);
}

bool InitStructTrigger_edc::isInputUnique( const Udm::Object& subsystem_ee7, const Udm::Object& initFunction_ef0, const Udm::Object& classStruct_ef9)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_ee9= _subsystem_ee3.begin(), itInitFunction_ef2= _initFunction_eec.begin(), itClassStruct_efb= _classStruct_ef5.begin(); itSubsystem_ee9!= _subsystem_ee3.end(), itInitFunction_ef2!= _initFunction_eec.end(), itClassStruct_efb!= _classStruct_ef5.end(); ++itSubsystem_ee9, ++itInitFunction_ef2, ++itClassStruct_efb)
	{
		if( ( *itSubsystem_ee9== subsystem_ee7)&& ( *itInitFunction_ef2== initFunction_ef0)&& ( *itClassStruct_efb== classStruct_ef9))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_ee3.push_back( subsystem_ee7);
		_initFunction_eec.push_back( initFunction_ef0);
		_classStruct_ef5.push_back( classStruct_ef9);
	}
	return isUnique;
}

bool InitStructTrigger_edc::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void InitStructTrigger_edc::processInputPackets( const Packets_t& subsystems_edd, const Packets_t& initFunctions_edf, const Packets_t& classStructs_ee1)
{
	for( Packets_t::const_iterator itSubsystem_ee4= subsystems_edd.begin(), itInitFunction_eed= initFunctions_edf.begin(), itClassStruct_ef6= classStructs_ee1.begin(); itSubsystem_ee4!= subsystems_edd.end(), itInitFunction_eed!= initFunctions_edf.end(), itClassStruct_ef6!= classStructs_ee1.end(); ++itSubsystem_ee4, ++itInitFunction_eed, ++itClassStruct_ef6)
	{
		bool isUnique= isInputUnique( *itSubsystem_ee4, *itInitFunction_eed, *itClassStruct_ef6);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_ee4, *itInitFunction_eed, *itClassStruct_ef6);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitStructTrigger_edc::patternMatcher( const Udm::Object& subsystem_ee5, const Udm::Object& initFunction_eee, const Udm::Object& classStruct_ef7)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_ee5.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_eea= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_ee5);
		if( false== Uml::IsDerivedFrom( initFunction_eee.type(), SFC::Function::meta))
			continue;
		SFC::Function initFunction_ef3= SFC::Function::Cast( initFunction_eee);
		if( false== Uml::IsDerivedFrom( classStruct_ef7.type(), SFC::Struct::meta))
			continue;
		SFC::Struct classStruct_efc= SFC::Struct::Cast( classStruct_ef7);
		set< SFC::Arg> args_efe= initFunction_ef3.Arg_kind_children();
		for( set< SFC::Arg>::const_iterator itArg_eff= args_efe.begin(); itArg_eff!= args_efe.end(); ++itArg_eff)
		{
			SFC::Arg currArg_f00= *itArg_eff;
			SFC::DT classStruct_f01= currArg_f00.dt();
			if(!classStruct_f01 || false== Uml::IsDerivedFrom( classStruct_f01.type(), SFC::Struct::meta))
				continue;
			SFC::Struct classStruct_f02= SFC::Struct::Cast( classStruct_f01);
			if( !classStruct_f02)
				continue;
			if( classStruct_efc!= classStruct_f02)
				continue;
			set< CyPhyML::SignalFlow::TriggerPort> triggerPorts_f03= subsystem_eea.TriggerPort_kind_children();
			for( set< CyPhyML::SignalFlow::TriggerPort>::const_iterator itTriggerPort_f04= triggerPorts_f03.begin(); itTriggerPort_f04!= triggerPorts_f03.end(); ++itTriggerPort_f04)
			{
				CyPhyML::SignalFlow::TriggerPort currTriggerPort_f05= *itTriggerPort_f04;
				set< SFC::LocalVar> localVars_f06= classStruct_efc.LocalVar_kind_children();
				for( set< SFC::LocalVar>::const_iterator itLocalVar_f07= localVars_f06.begin(); itLocalVar_f07!= localVars_f06.end(); ++itLocalVar_f07)
				{
					SFC::LocalVar currLocalVar_f08= *itLocalVar_f07;
					set< CyPhyML::SignalFlow::TriggerPort> triggerPorts_f09= currLocalVar_f08.trig();
					for( set< CyPhyML::SignalFlow::TriggerPort>::const_iterator itTriggerPorts_f0a= triggerPorts_f09.begin(); itTriggerPorts_f0a!= triggerPorts_f09.end(); ++itTriggerPorts_f0a)
					{
						CyPhyML::SignalFlow::TriggerPort currTriggerPort_f0b= *itTriggerPorts_f0a;
						if( currTriggerPort_f05!= currTriggerPort_f0b)
							continue;
						SFC::DT struct_f0c= currLocalVar_f08.dt();
						if(!struct_f0c || false== Uml::IsDerivedFrom( struct_f0c.type(), SFC::Struct::meta))
							continue;
						SFC::Struct struct_f0d= SFC::Struct::Cast( struct_f0c);
						if( !struct_f0d)
							continue;
						set< SFC::LocalVar> members_f0e= struct_f0d.LocalVar_kind_children();
						for( set< SFC::LocalVar>::const_iterator itMember_f0f= members_f0e.begin(); itMember_f0f!= members_f0e.end(); ++itMember_f0f)
						{
							SFC::LocalVar currMember_f10= *itMember_f0f;
							Match currMatch;
							set< pair<int, Udm::Object> > boundObjs_f14;
							if( !isValidBound(boundObjs_f14, subsystem_eea, true))
								continue;
							currMatch.subsystem_f15= subsystem_eea;
							if( !isValidBound(boundObjs_f14, initFunction_ef3, true))
								continue;
							currMatch.initFunction_f16= initFunction_ef3;
							if( !isValidBound(boundObjs_f14, classStruct_efc, true))
								continue;
							currMatch.classStruct_f17= classStruct_efc;
							if( !isValidBound(boundObjs_f14, currTriggerPort_f05, false))
								continue;
							currMatch.triggerPort_f18= currTriggerPort_f05;
							if( !isValidBound(boundObjs_f14, currArg_f00, false))
								continue;
							currMatch.arg_f19= currArg_f00;
							if( !isValidBound(boundObjs_f14, currMember_f10, false))
								continue;
							currMatch.member_f1a= currMember_f10;
							if( !isValidBound(boundObjs_f14, currLocalVar_f08, false))
								continue;
							currMatch.localVar_f1b= currLocalVar_f08;
							if( !isValidBound(boundObjs_f14, struct_f0d, false))
								continue;
							currMatch.struct_f1c= struct_f0d;
							_matches.push_back( currMatch);
						}
					}
				}
			}
		}
	}
	return !_matches.empty();
}

void InitStructTrigger_edc::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::UserCode newUserCode_f1d= SFC::UserCode::Create( currMatch.initFunction_f16, SFC::Function::meta_stmnt);
		SFC::BinaryExprs newAssign_f1e= SFC::BinaryExprs::Create( newUserCode_f1d, SFC::UserCode::meta_codeexpr);
		SFC::Int newZero_f1f= SFC::Int::Create( newAssign_f1e, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs newDot2_f20= SFC::BinaryExprs::Create( newAssign_f1e, SFC::BinaryExprs::meta_leftexpr);
		SFC::BinaryExprs newDot_f21= SFC::BinaryExprs::Create( newDot2_f20, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef2_f22= SFC::ArgDeclRef::Create( newDot_f21, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef_f23= SFC::ArgDeclRef::Create( newDot_f21, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef3_f24= SFC::ArgDeclRef::Create( newDot2_f20, SFC::BinaryExprs::meta_rightexpr);
		SFC::Arg& Arg= currMatch.arg_f19;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_f23;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_f22;
		SFC::ArgDeclRef& ArgDeclRef3= newArgDeclRef3_f24;
		SFC::BinaryExprs& Assign= newAssign_f1e;
		SFC::Struct& ClassStruct= currMatch.classStruct_f17;
		SFC::BinaryExprs& Dot= newDot_f21;
		SFC::BinaryExprs& Dot2= newDot2_f20;
		SFC::Function& InitFunction= currMatch.initFunction_f16;
		SFC::LocalVar& LocalVar= currMatch.localVar_f1b;
		SFC::LocalVar& Member= currMatch.member_f1a;
		SFC::Struct& Struct= currMatch.struct_f1c;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_f15;
		CyPhyML::SignalFlow::TriggerPort& TriggerPort= currMatch.triggerPort_f18;
		SFC::UserCode& UserCode= newUserCode_f1d;
		SFC::Int& Zero= newZero_f1f;
		{
Zero.val() = 0;
};
		{
Assign.op() = "=";
};
		{
Dot.op() = ".";
};
		{
Dot2.op() = ".";
};
		{
__int64 statementCount = InitFunction.statementCount();
UserCode.statementIndex() = statementCount++;
InitFunction.statementCount() = statementCount;
};
		newArgDeclRef2_f22.argdecl()= currMatch.localVar_f1b;
		newArgDeclRef_f23.argdecl()= currMatch.arg_f19;
		newArgDeclRef3_f24.argdecl()= currMatch.member_f1a;
	}
}

void InitPrimitiveParameters_f31::operator()( const Packets_t& systems_f32, const Packets_t& initFunctions_f34, const Packets_t& classStructs_f36, Packets_t& systems_f38, Packets_t& initFunctions_f39, Packets_t& classStructs_f3a)
{
#ifdef PRINT_INFO
	printLog("InitPrimitiveParameters_f31" );
#endif
	_system_f3b= &systems_f38;
	_initFunction_f3c= &initFunctions_f39;
	_classStruct_f3d= &classStructs_f3a;
	_system_f3b->insert( _system_f3b->end(), systems_f32.begin(), systems_f32.end());
	_initFunction_f3c->insert( _initFunction_f3c->end(), initFunctions_f34.begin(), initFunctions_f34.end());
	_classStruct_f3d->insert( _classStruct_f3d->end(), classStructs_f36.begin(), classStructs_f36.end());
	if( ( !systems_f32.empty())&& ( !initFunctions_f34.empty())&& ( !classStructs_f36.empty()))
		callGetStructMembers_10b3( systems_f32, initFunctions_f34, classStructs_f36);
}

void InitPrimitiveParameters_f31::callGetStructMembers_10b3( const Packets_t& subsystems_1052, const Packets_t& initFunctions_1055, const Packets_t& classStructs_1058)
{
	Packets_t subsystems_1054;
	Packets_t initFunctions_1057;
	Packets_t localVars_105a;
	GetStructMembers_1051 getStructMembers_1051;
	getStructMembers_1051( subsystems_1052, initFunctions_1055, classStructs_1058, subsystems_1054, initFunctions_1057, localVars_105a);
	if( ( !subsystems_1054.empty())&& ( !initFunctions_1057.empty())&& ( !localVars_105a.empty()))
		callTest_10b7( subsystems_1054, initFunctions_1057, localVars_105a);
}

void InitPrimitiveParameters_f31::callTest_10b7( const Packets_t& systems_f75, const Packets_t& initFunctions_f77, const Packets_t& members_f79)
{
	Packets_t systems_f7b;
	Packets_t initFunctions_f7c;
	Packets_t classStructs_f7d;
	Packets_t systems_f7e;
	Packets_t initFunctions_f7f;
	Packets_t classStructs_f80;
	Packets_t systems_f81;
	Packets_t initFunctions_f82;
	Packets_t classStructs_f83;
	Test_f74 test_f74;
	test_f74( systems_f75, initFunctions_f77, members_f79, systems_f7b, initFunctions_f7c, classStructs_f7d, systems_f7e, initFunctions_f7f, classStructs_f80, systems_f81, initFunctions_f82, classStructs_f83);
	if( ( !systems_f7b.empty())&& ( !initFunctions_f7c.empty())&& ( !classStructs_f7d.empty()))
		callinitPrimitiveParameter_10bb( systems_f7b, initFunctions_f7c, classStructs_f7d);
	if( ( !systems_f81.empty())&& ( !initFunctions_f82.empty())&& ( !classStructs_f83.empty()))
		callzeroPrimitiveParameter_10bf( systems_f81, initFunctions_f82, classStructs_f83);
}

void InitPrimitiveParameters_f31::callinitPrimitiveParameter_10bb( const Packets_t& subsystem1s_f3f, const Packets_t& initFunctions_f41, const Packets_t& localVars_f43)
{
	InitPrimitiveParameter_f3e initPrimitiveParameter_f3e;
	initPrimitiveParameter_f3e( subsystem1s_f3f, initFunctions_f41, localVars_f43);
}

void InitPrimitiveParameters_f31::callzeroPrimitiveParameter_10bf( const Packets_t& subsystems_108b, const Packets_t& initFunctions_108d, const Packets_t& localVars_108f)
{
	ZeroPrimitiveParameter_108a zeroPrimitiveParameter_108a;
	zeroPrimitiveParameter_108a( subsystems_108b, initFunctions_108d, localVars_108f);
}

void InitPrimitiveParameter_f3e::operator()( const Packets_t& subsystem1s_f3f, const Packets_t& initFunctions_f41, const Packets_t& localVars_f43)
{
#ifdef PRINT_INFO
	printLog("InitPrimitiveParameter_f3e" );
#endif
	RTTGenerator::Instance()->generateRule(811, "initPrimitiveParameter");
	processInputPackets( subsystem1s_f3f, initFunctions_f41, localVars_f43);
}

bool InitPrimitiveParameter_f3e::isInputUnique( const Udm::Object& subsystem1_f49, const Udm::Object& initFunction_f52, const Udm::Object& localVar_f5b)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem1_f4b= _subsystem1_f45.begin(), itInitFunction_f54= _initFunction_f4e.begin(), itLocalVar_f5d= _localVar_f57.begin(); itSubsystem1_f4b!= _subsystem1_f45.end(), itInitFunction_f54!= _initFunction_f4e.end(), itLocalVar_f5d!= _localVar_f57.end(); ++itSubsystem1_f4b, ++itInitFunction_f54, ++itLocalVar_f5d)
	{
		if( ( *itSubsystem1_f4b== subsystem1_f49)&& ( *itInitFunction_f54== initFunction_f52)&& ( *itLocalVar_f5d== localVar_f5b))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem1_f45.push_back( subsystem1_f49);
		_initFunction_f4e.push_back( initFunction_f52);
		_localVar_f57.push_back( localVar_f5b);
	}
	return isUnique;
}

bool InitPrimitiveParameter_f3e::isGuardTrue( SFC::Function& InitFunction, SFC::LocalVar& LocalVar, CyPhyML::SignalFlow::SF_Parameter& Parameter, CyPhyML::SignalFlow::Primitive& Primitive, CyPhyML::SignalFlow::Subsystem& Subsystem1, CyPhyML::SignalFlow::Subsystem& Subsystem2)
{
	bool Gz_guard= false;
	return (Subsystem1 == Subsystem2);;
	return Gz_guard;
}

void InitPrimitiveParameter_f3e::processInputPackets( const Packets_t& subsystem1s_f3f, const Packets_t& initFunctions_f41, const Packets_t& localVars_f43)
{
	for( Packets_t::const_iterator itSubsystem1_f46= subsystem1s_f3f.begin(), itInitFunction_f4f= initFunctions_f41.begin(), itLocalVar_f58= localVars_f43.begin(); itSubsystem1_f46!= subsystem1s_f3f.end(), itInitFunction_f4f!= initFunctions_f41.end(), itLocalVar_f58!= localVars_f43.end(); ++itSubsystem1_f46, ++itInitFunction_f4f, ++itLocalVar_f58)
	{
		bool isUnique= isInputUnique( *itSubsystem1_f46, *itInitFunction_f4f, *itLocalVar_f58);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem1_f46, *itInitFunction_f4f, *itLocalVar_f58);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitPrimitiveParameter_f3e::patternMatcher( const Udm::Object& subsystem1_f47, const Udm::Object& initFunction_f50, const Udm::Object& localVar_f59)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem1_f47.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem1_f4c= CyPhyML::SignalFlow::Subsystem::Cast( subsystem1_f47);
		if( false== Uml::IsDerivedFrom( initFunction_f50.type(), SFC::Function::meta))
			continue;
		SFC::Function initFunction_f55= SFC::Function::Cast( initFunction_f50);
		if( false== Uml::IsDerivedFrom( localVar_f59.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_f5e= SFC::LocalVar::Cast( localVar_f59);
		set< CyPhyML::SignalFlow::SF_Parameter> parameters_f60= localVar_f5e.param();
		for( set< CyPhyML::SignalFlow::SF_Parameter>::const_iterator itParameters_f61= parameters_f60.begin(); itParameters_f61!= parameters_f60.end(); ++itParameters_f61)
		{
			CyPhyML::SignalFlow::SF_Parameter currParameter_f62= *itParameters_f61;
			Udm::Object parameterParent_f63= currParameter_f62.container();
			if( false== Uml::IsDerivedFrom( parameterParent_f63.type(), CyPhyML::SignalFlow::Primitive::meta))
				continue;
			CyPhyML::SignalFlow::Primitive primitiveParameter_f64= CyPhyML::SignalFlow::Primitive::Cast( parameterParent_f63);
			Udm::Object primitiveParent_f65= primitiveParameter_f64.container();
			if( false== Uml::IsDerivedFrom( primitiveParent_f65.type(), CyPhyML::SignalFlow::Subsystem::meta))
				continue;
			CyPhyML::SignalFlow::Subsystem subsystem2Primitive_f66= CyPhyML::SignalFlow::Subsystem::Cast( primitiveParent_f65);
			Match currMatch;
			currMatch.subsystem1_f68= subsystem1_f4c;
			currMatch.initFunction_f69= initFunction_f55;
			currMatch.localVar_f6a= localVar_f5e;
			currMatch.subsystem2_f6b= subsystem2Primitive_f66;
			currMatch.primitive_f6c= primitiveParameter_f64;
			currMatch.parameter_f6d= currParameter_f62;
			bool Gz_guard= isGuardTrue( currMatch.initFunction_f69, currMatch.localVar_f6a, currMatch.parameter_f6d, currMatch.primitive_f6c, currMatch.subsystem1_f68, currMatch.subsystem2_f6b);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void InitPrimitiveParameter_f3e::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function& InitFunction= currMatch.initFunction_f69;
		SFC::LocalVar& LocalVar= currMatch.localVar_f6a;
		CyPhyML::SignalFlow::SF_Parameter& Parameter= currMatch.parameter_f6d;
		CyPhyML::SignalFlow::Primitive& Primitive= currMatch.primitive_f6c;
		CyPhyML::SignalFlow::Subsystem& Subsystem1= currMatch.subsystem1_f68;
		CyPhyML::SignalFlow::Subsystem& Subsystem2= currMatch.subsystem2_f6b;
		{
SFUtils::InitParameter( InitFunction, Parameter, LocalVar );
};
	}
}

void Test_f74::operator()( const Packets_t& systems_f75, const Packets_t& initFunctions_f77, const Packets_t& members_f79, Packets_t& systems_f7b, Packets_t& initFunctions_f7c, Packets_t& classStructs_f7d, Packets_t& systems_f7e, Packets_t& initFunctions_f7f, Packets_t& classStructs_f80, Packets_t& systems_f81, Packets_t& initFunctions_f82, Packets_t& classStructs_f83)
{
#ifdef PRINT_INFO
	printLog("Test_f74" );
#endif
	_system_f84= &systems_f7b;
	_initFunction_f85= &initFunctions_f7c;
	_classStruct_f86= &classStructs_f7d;
	_system_f87= &systems_f7e;
	_initFunction_f88= &initFunctions_f7f;
	_classStruct_f89= &classStructs_f80;
	_system_f8a= &systems_f81;
	_initFunction_f8b= &initFunctions_f82;
	_classStruct_f8c= &classStructs_f83;
	for( Packets_t::const_iterator itsystem_f8e= systems_f75.begin(), itinitFunction_f95= initFunctions_f77.begin(), itmember_f9c= members_f79.begin(); itsystem_f8e!= systems_f75.end(), itinitFunction_f95!= initFunctions_f77.end(), itmember_f9c!= members_f79.end(); ++itsystem_f8e, ++itinitFunction_f95, ++itmember_f9c)
	{
		bool isUnique= isInputUnique( *itsystem_f8e, *itinitFunction_f95, *itmember_f9c);
		if( !isUnique)
			continue;
		Packets_t onesystem_f92( 1, *itsystem_f8e);
		Packets_t oneinitFunction_f99( 1, *itinitFunction_f95);
		Packets_t onemember_fa0( 1, *itmember_f9c);
		executeOne( onesystem_f92, oneinitFunction_f99, onemember_fa0);
	}
}

void Test_f74::executeOne( const Packets_t& systems_f75, const Packets_t& initFunctions_f77, const Packets_t& members_f79)
{
	Packets_t subsystem1s_fa5;
	Packets_t initFunctions_fa8;
	Packets_t localVars_fab;
	MemberHasParameter_fa2 memberHasParameter_fa2;
	bool isMatchMemberHasParameter_fa2= memberHasParameter_fa2( systems_f75, initFunctions_f77, members_f79, subsystem1s_fa5, initFunctions_fa8, localVars_fab);
	_system_f84->insert( _system_f84->end(), subsystem1s_fa5.begin(), subsystem1s_fa5.end());
	_initFunction_f85->insert( _initFunction_f85->end(), initFunctions_fa8.begin(), initFunctions_fa8.end());
	_classStruct_f86->insert( _classStruct_f86->end(), localVars_fab.begin(), localVars_fab.end());
	if( isMatchMemberHasParameter_fa2)
		return;
	Packets_t subsystems_fe7;
	Packets_t initFunctions_fea;
	Packets_t localVars_fed;
	StructMember_fe4 structMember_fe4;
	bool isMatchStructMember_fe4= structMember_fe4( systems_f75, initFunctions_f77, members_f79, subsystems_fe7, initFunctions_fea, localVars_fed);
	_system_f87->insert( _system_f87->end(), subsystems_fe7.begin(), subsystems_fe7.end());
	_initFunction_f88->insert( _initFunction_f88->end(), initFunctions_fea.begin(), initFunctions_fea.end());
	_classStruct_f89->insert( _classStruct_f89->end(), localVars_fed.begin(), localVars_fed.end());
	if( isMatchStructMember_fe4)
		return;
	Packets_t subsystems_101f;
	Packets_t initFunctions_1022;
	Packets_t localVars_1025;
	MemberNoParameter_101c memberNoParameter_101c;
	bool isMatchMemberNoParameter_101c= memberNoParameter_101c( systems_f75, initFunctions_f77, members_f79, subsystems_101f, initFunctions_1022, localVars_1025);
	_system_f8a->insert( _system_f8a->end(), subsystems_101f.begin(), subsystems_101f.end());
	_initFunction_f8b->insert( _initFunction_f8b->end(), initFunctions_1022.begin(), initFunctions_1022.end());
	_classStruct_f8c->insert( _classStruct_f8c->end(), localVars_1025.begin(), localVars_1025.end());
	if( isMatchMemberNoParameter_101c)
		return;
}

bool Test_f74::isInputUnique( const Udm::Object& system_f8f, const Udm::Object& initFunction_f96, const Udm::Object& member_f9d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itsystem_f91= _system_f8d.begin(), itinitFunction_f98= _initFunction_f94.begin(), itmember_f9f= _member_f9b.begin(); itsystem_f91!= _system_f8d.end(), itinitFunction_f98!= _initFunction_f94.end(), itmember_f9f!= _member_f9b.end(); ++itsystem_f91, ++itinitFunction_f98, ++itmember_f9f)
	{
		if( ( *itsystem_f91== system_f8f)&& ( *itinitFunction_f98== initFunction_f96)&& ( *itmember_f9f== member_f9d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_system_f8d.push_back( system_f8f);
		_initFunction_f94.push_back( initFunction_f96);
		_member_f9b.push_back( member_f9d);
	}
	return isUnique;
}

bool MemberHasParameter_fa2::operator()( const Packets_t& subsystem1s_fa3, const Packets_t& initFunctions_fa6, const Packets_t& localVars_fa9, Packets_t& subsystem1s_fa5, Packets_t& initFunctions_fa8, Packets_t& localVars_fab)
{
#ifdef PRINT_INFO
	printLog("MemberHasParameter_fa2" );
#endif
	_subsystem1_fac= &subsystem1s_fa5;
	_initFunction_fad= &initFunctions_fa8;
	_localVar_fae= &localVars_fab;
	processInputPackets( subsystem1s_fa3, initFunctions_fa6, localVars_fa9);
	if( false== _matches.empty())
		return true;
	return false;
}

bool MemberHasParameter_fa2::isInputUnique( const Udm::Object& subsystem1_fb3, const Udm::Object& initFunction_fbc, const Udm::Object& localVar_fc5)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem1_fb5= _subsystem1_faf.begin(), itInitFunction_fbe= _initFunction_fb8.begin(), itLocalVar_fc7= _localVar_fc1.begin(); itSubsystem1_fb5!= _subsystem1_faf.end(), itInitFunction_fbe!= _initFunction_fb8.end(), itLocalVar_fc7!= _localVar_fc1.end(); ++itSubsystem1_fb5, ++itInitFunction_fbe, ++itLocalVar_fc7)
	{
		if( ( *itSubsystem1_fb5== subsystem1_fb3)&& ( *itInitFunction_fbe== initFunction_fbc)&& ( *itLocalVar_fc7== localVar_fc5))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem1_faf.push_back( subsystem1_fb3);
		_initFunction_fb8.push_back( initFunction_fbc);
		_localVar_fc1.push_back( localVar_fc5);
	}
	return isUnique;
}

bool MemberHasParameter_fa2::isGuardTrue( SFC::Function& InitFunction, SFC::LocalVar& LocalVar, CyPhyML::SignalFlow::SF_Parameter& Parameter, CyPhyML::SignalFlow::Primitive& Primitive, CyPhyML::SignalFlow::Subsystem& Subsystem1, CyPhyML::SignalFlow::Subsystem& Subsystem2)
{
	bool Gz_guard= false;
	return (Subsystem1 == Subsystem2);;
	return Gz_guard;
}

void MemberHasParameter_fa2::processInputPackets( const Packets_t& subsystem1s_fa3, const Packets_t& initFunctions_fa6, const Packets_t& localVars_fa9)
{
	for( Packets_t::const_iterator itSubsystem1_fb0= subsystem1s_fa3.begin(), itInitFunction_fb9= initFunctions_fa6.begin(), itLocalVar_fc2= localVars_fa9.begin(); itSubsystem1_fb0!= subsystem1s_fa3.end(), itInitFunction_fb9!= initFunctions_fa6.end(), itLocalVar_fc2!= localVars_fa9.end(); ++itSubsystem1_fb0, ++itInitFunction_fb9, ++itLocalVar_fc2)
	{
		bool isUnique= isInputUnique( *itSubsystem1_fb0, *itInitFunction_fb9, *itLocalVar_fc2);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem1_fb0, *itInitFunction_fb9, *itLocalVar_fc2);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem1_fd2, currMatch.initFunction_fd3, currMatch.localVar_fd4);
	}
}

bool MemberHasParameter_fa2::patternMatcher( const Udm::Object& subsystem1_fb1, const Udm::Object& initFunction_fba, const Udm::Object& localVar_fc3)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem1_fb1.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem1_fb6= CyPhyML::SignalFlow::Subsystem::Cast( subsystem1_fb1);
		if( false== Uml::IsDerivedFrom( initFunction_fba.type(), SFC::Function::meta))
			continue;
		SFC::Function initFunction_fbf= SFC::Function::Cast( initFunction_fba);
		if( false== Uml::IsDerivedFrom( localVar_fc3.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_fc8= SFC::LocalVar::Cast( localVar_fc3);
		set< CyPhyML::SignalFlow::SF_Parameter> parameters_fca= localVar_fc8.param();
		for( set< CyPhyML::SignalFlow::SF_Parameter>::const_iterator itParameters_fcb= parameters_fca.begin(); itParameters_fcb!= parameters_fca.end(); ++itParameters_fcb)
		{
			CyPhyML::SignalFlow::SF_Parameter currParameter_fcc= *itParameters_fcb;
			Udm::Object parameterParent_fcd= currParameter_fcc.container();
			if( false== Uml::IsDerivedFrom( parameterParent_fcd.type(), CyPhyML::SignalFlow::Primitive::meta))
				continue;
			CyPhyML::SignalFlow::Primitive primitiveParameter_fce= CyPhyML::SignalFlow::Primitive::Cast( parameterParent_fcd);
			Udm::Object primitiveParent_fcf= primitiveParameter_fce.container();
			if( false== Uml::IsDerivedFrom( primitiveParent_fcf.type(), CyPhyML::SignalFlow::Subsystem::meta))
				continue;
			CyPhyML::SignalFlow::Subsystem subsystem2Primitive_fd0= CyPhyML::SignalFlow::Subsystem::Cast( primitiveParent_fcf);
			Match currMatch;
			currMatch.subsystem1_fd2= subsystem1_fb6;
			currMatch.initFunction_fd3= initFunction_fbf;
			currMatch.localVar_fd4= localVar_fc8;
			currMatch.subsystem2_fd5= subsystem2Primitive_fd0;
			currMatch.primitive_fd6= primitiveParameter_fce;
			currMatch.parameter_fd7= currParameter_fcc;
			bool Gz_guard= isGuardTrue( currMatch.initFunction_fd3, currMatch.localVar_fd4, currMatch.parameter_fd7, currMatch.primitive_fd6, currMatch.subsystem1_fd2, currMatch.subsystem2_fd5);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void MemberHasParameter_fa2::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem1_fde, const SFC::Function& initFunction_fe0, const SFC::LocalVar& localVar_fe2)
{
	_subsystem1_fac->push_back( subsystem1_fde);
	_initFunction_fad->push_back( initFunction_fe0);
	_localVar_fae->push_back( localVar_fe2);
}

bool StructMember_fe4::operator()( const Packets_t& subsystems_fe5, const Packets_t& initFunctions_fe8, const Packets_t& localVars_feb, Packets_t& subsystems_fe7, Packets_t& initFunctions_fea, Packets_t& localVars_fed)
{
#ifdef PRINT_INFO
	printLog("StructMember_fe4" );
#endif
	_subsystem_fee= &subsystems_fe7;
	_initFunction_fef= &initFunctions_fea;
	_localVar_ff0= &localVars_fed;
	processInputPackets( subsystems_fe5, initFunctions_fe8, localVars_feb);
	if( false== _matches.empty())
		return true;
	return false;
}

bool StructMember_fe4::isInputUnique( const Udm::Object& subsystem_ff5, const Udm::Object& initFunction_ffe, const Udm::Object& localVar_1007)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_ff7= _subsystem_ff1.begin(), itInitFunction_1000= _initFunction_ffa.begin(), itLocalVar_1009= _localVar_1003.begin(); itSubsystem_ff7!= _subsystem_ff1.end(), itInitFunction_1000!= _initFunction_ffa.end(), itLocalVar_1009!= _localVar_1003.end(); ++itSubsystem_ff7, ++itInitFunction_1000, ++itLocalVar_1009)
	{
		if( ( *itSubsystem_ff7== subsystem_ff5)&& ( *itInitFunction_1000== initFunction_ffe)&& ( *itLocalVar_1009== localVar_1007))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_ff1.push_back( subsystem_ff5);
		_initFunction_ffa.push_back( initFunction_ffe);
		_localVar_1003.push_back( localVar_1007);
	}
	return isUnique;
}

bool StructMember_fe4::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void StructMember_fe4::processInputPackets( const Packets_t& subsystems_fe5, const Packets_t& initFunctions_fe8, const Packets_t& localVars_feb)
{
	for( Packets_t::const_iterator itSubsystem_ff2= subsystems_fe5.begin(), itInitFunction_ffb= initFunctions_fe8.begin(), itLocalVar_1004= localVars_feb.begin(); itSubsystem_ff2!= subsystems_fe5.end(), itInitFunction_ffb!= initFunctions_fe8.end(), itLocalVar_1004!= localVars_feb.end(); ++itSubsystem_ff2, ++itInitFunction_ffb, ++itLocalVar_1004)
	{
		bool isUnique= isInputUnique( *itSubsystem_ff2, *itInitFunction_ffb, *itLocalVar_1004);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_ff2, *itInitFunction_ffb, *itLocalVar_1004);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_1012, currMatch.initFunction_1013, currMatch.localVar_1014);
	}
}

bool StructMember_fe4::patternMatcher( const Udm::Object& subsystem_ff3, const Udm::Object& initFunction_ffc, const Udm::Object& localVar_1005)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_ff3.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_ff8= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_ff3);
		if( false== Uml::IsDerivedFrom( initFunction_ffc.type(), SFC::Function::meta))
			continue;
		SFC::Function initFunction_1001= SFC::Function::Cast( initFunction_ffc);
		if( false== Uml::IsDerivedFrom( localVar_1005.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_100a= SFC::LocalVar::Cast( localVar_1005);
		SFC::DT struct_100c= localVar_100a.dt();
		if(!struct_100c || false== Uml::IsDerivedFrom( struct_100c.type(), SFC::Struct::meta))
			continue;
		SFC::Struct struct_100d= SFC::Struct::Cast( struct_100c);
		if( !struct_100d)
			continue;
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1011;
		if( !isValidBound(boundObjs_1011, subsystem_ff8, true))
			continue;
		currMatch.subsystem_1012= subsystem_ff8;
		if( !isValidBound(boundObjs_1011, initFunction_1001, true))
			continue;
		currMatch.initFunction_1013= initFunction_1001;
		if( !isValidBound(boundObjs_1011, localVar_100a, true))
			continue;
		currMatch.localVar_1014= localVar_100a;
		if( !isValidBound(boundObjs_1011, struct_100d, false))
			continue;
		currMatch.struct_1015= struct_100d;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void StructMember_fe4::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1016, const SFC::Function& initFunction_1018, const SFC::LocalVar& localVar_101a)
{
	_subsystem_fee->push_back( subsystem_1016);
	_initFunction_fef->push_back( initFunction_1018);
	_localVar_ff0->push_back( localVar_101a);
}

bool MemberNoParameter_101c::operator()( const Packets_t& subsystems_101d, const Packets_t& initFunctions_1020, const Packets_t& localVars_1023, Packets_t& subsystems_101f, Packets_t& initFunctions_1022, Packets_t& localVars_1025)
{
#ifdef PRINT_INFO
	printLog("MemberNoParameter_101c" );
#endif
	_subsystem_1026= &subsystems_101f;
	_initFunction_1027= &initFunctions_1022;
	_localVar_1028= &localVars_1025;
	processInputPackets( subsystems_101d, initFunctions_1020, localVars_1023);
	if( false== _matches.empty())
		return true;
	return false;
}

bool MemberNoParameter_101c::isInputUnique( const Udm::Object& subsystem_102d, const Udm::Object& initFunction_1036, const Udm::Object& localVar_103f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_102f= _subsystem_1029.begin(), itInitFunction_1038= _initFunction_1032.begin(), itLocalVar_1041= _localVar_103b.begin(); itSubsystem_102f!= _subsystem_1029.end(), itInitFunction_1038!= _initFunction_1032.end(), itLocalVar_1041!= _localVar_103b.end(); ++itSubsystem_102f, ++itInitFunction_1038, ++itLocalVar_1041)
	{
		if( ( *itSubsystem_102f== subsystem_102d)&& ( *itInitFunction_1038== initFunction_1036)&& ( *itLocalVar_1041== localVar_103f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1029.push_back( subsystem_102d);
		_initFunction_1032.push_back( initFunction_1036);
		_localVar_103b.push_back( localVar_103f);
	}
	return isUnique;
}

bool MemberNoParameter_101c::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void MemberNoParameter_101c::processInputPackets( const Packets_t& subsystems_101d, const Packets_t& initFunctions_1020, const Packets_t& localVars_1023)
{
	for( Packets_t::const_iterator itSubsystem_102a= subsystems_101d.begin(), itInitFunction_1033= initFunctions_1020.begin(), itLocalVar_103c= localVars_1023.begin(); itSubsystem_102a!= subsystems_101d.end(), itInitFunction_1033!= initFunctions_1020.end(), itLocalVar_103c!= localVars_1023.end(); ++itSubsystem_102a, ++itInitFunction_1033, ++itLocalVar_103c)
	{
		bool isUnique= isInputUnique( *itSubsystem_102a, *itInitFunction_1033, *itLocalVar_103c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_102a, *itInitFunction_1033, *itLocalVar_103c);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_1048, currMatch.initFunction_1049, currMatch.localVar_104a);
	}
}

bool MemberNoParameter_101c::patternMatcher( const Udm::Object& subsystem_102b, const Udm::Object& initFunction_1034, const Udm::Object& localVar_103d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_102b.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1030= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_102b);
		if( false== Uml::IsDerivedFrom( initFunction_1034.type(), SFC::Function::meta))
			continue;
		SFC::Function initFunction_1039= SFC::Function::Cast( initFunction_1034);
		if( false== Uml::IsDerivedFrom( localVar_103d.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_1042= SFC::LocalVar::Cast( localVar_103d);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1047;
		if( !isValidBound(boundObjs_1047, subsystem_1030, true))
			continue;
		currMatch.subsystem_1048= subsystem_1030;
		if( !isValidBound(boundObjs_1047, initFunction_1039, true))
			continue;
		currMatch.initFunction_1049= initFunction_1039;
		if( !isValidBound(boundObjs_1047, localVar_1042, true))
			continue;
		currMatch.localVar_104a= localVar_1042;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void MemberNoParameter_101c::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_104b, const SFC::Function& initFunction_104d, const SFC::LocalVar& localVar_104f)
{
	_subsystem_1026->push_back( subsystem_104b);
	_initFunction_1027->push_back( initFunction_104d);
	_localVar_1028->push_back( localVar_104f);
}

void GetStructMembers_1051::operator()( const Packets_t& subsystems_1052, const Packets_t& initFunctions_1055, const Packets_t& classStructs_1058, Packets_t& subsystems_1054, Packets_t& initFunctions_1057, Packets_t& localVars_105a)
{
#ifdef PRINT_INFO
	printLog("GetStructMembers_1051" );
#endif
	RTTGenerator::Instance()->generateRule(855, "GetStructMembers");
	_subsystem_105b= &subsystems_1054;
	_initFunction_105c= &initFunctions_1057;
	_localVar_105d= &localVars_105a;
	processInputPackets( subsystems_1052, initFunctions_1055, classStructs_1058);
}

bool GetStructMembers_1051::isInputUnique( const Udm::Object& subsystem_1062, const Udm::Object& initFunction_106b, const Udm::Object& classStruct_1074)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1064= _subsystem_105e.begin(), itInitFunction_106d= _initFunction_1067.begin(), itClassStruct_1076= _classStruct_1070.begin(); itSubsystem_1064!= _subsystem_105e.end(), itInitFunction_106d!= _initFunction_1067.end(), itClassStruct_1076!= _classStruct_1070.end(); ++itSubsystem_1064, ++itInitFunction_106d, ++itClassStruct_1076)
	{
		if( ( *itSubsystem_1064== subsystem_1062)&& ( *itInitFunction_106d== initFunction_106b)&& ( *itClassStruct_1076== classStruct_1074))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_105e.push_back( subsystem_1062);
		_initFunction_1067.push_back( initFunction_106b);
		_classStruct_1070.push_back( classStruct_1074);
	}
	return isUnique;
}

bool GetStructMembers_1051::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetStructMembers_1051::processInputPackets( const Packets_t& subsystems_1052, const Packets_t& initFunctions_1055, const Packets_t& classStructs_1058)
{
	for( Packets_t::const_iterator itSubsystem_105f= subsystems_1052.begin(), itInitFunction_1068= initFunctions_1055.begin(), itClassStruct_1071= classStructs_1058.begin(); itSubsystem_105f!= subsystems_1052.end(), itInitFunction_1068!= initFunctions_1055.end(), itClassStruct_1071!= classStructs_1058.end(); ++itSubsystem_105f, ++itInitFunction_1068, ++itClassStruct_1071)
	{
		bool isUnique= isInputUnique( *itSubsystem_105f, *itInitFunction_1068, *itClassStruct_1071);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_105f, *itInitFunction_1068, *itClassStruct_1071);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetStructMembers_1051::patternMatcher( const Udm::Object& subsystem_1060, const Udm::Object& initFunction_1069, const Udm::Object& classStruct_1072)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1060.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1065= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1060);
		if( false== Uml::IsDerivedFrom( initFunction_1069.type(), SFC::Function::meta))
			continue;
		SFC::Function initFunction_106e= SFC::Function::Cast( initFunction_1069);
		if( false== Uml::IsDerivedFrom( classStruct_1072.type(), SFC::Struct::meta))
			continue;
		SFC::Struct classStruct_1077= SFC::Struct::Cast( classStruct_1072);
		set< SFC::LocalVar> localVars_1079= classStruct_1077.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itLocalVar_107a= localVars_1079.begin(); itLocalVar_107a!= localVars_1079.end(); ++itLocalVar_107a)
		{
			SFC::LocalVar currLocalVar_107b= *itLocalVar_107a;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_107f;
			if( !isValidBound(boundObjs_107f, subsystem_1065, true))
				continue;
			currMatch.subsystem_1080= subsystem_1065;
			if( !isValidBound(boundObjs_107f, initFunction_106e, true))
				continue;
			currMatch.initFunction_1081= initFunction_106e;
			if( !isValidBound(boundObjs_107f, classStruct_1077, true))
				continue;
			currMatch.classStruct_1082= classStruct_1077;
			if( !isValidBound(boundObjs_107f, currLocalVar_107b, false))
				continue;
			currMatch.localVar_1083= currLocalVar_107b;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetStructMembers_1051::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_1080, currMatch.initFunction_1081, currMatch.localVar_1083);
	}
}

void GetStructMembers_1051::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1084, const SFC::Function& initFunction_1086, const SFC::LocalVar& localVar_1088)
{
	_subsystem_105b->push_back( subsystem_1084);
	_initFunction_105c->push_back( initFunction_1086);
	_localVar_105d->push_back( localVar_1088);
}

void ZeroPrimitiveParameter_108a::operator()( const Packets_t& subsystems_108b, const Packets_t& initFunctions_108d, const Packets_t& localVars_108f)
{
#ifdef PRINT_INFO
	printLog("ZeroPrimitiveParameter_108a" );
#endif
	RTTGenerator::Instance()->generateRule(861, "zeroPrimitiveParameter");
	processInputPackets( subsystems_108b, initFunctions_108d, localVars_108f);
}

bool ZeroPrimitiveParameter_108a::isInputUnique( const Udm::Object& subsystem_1095, const Udm::Object& initFunction_109e, const Udm::Object& localVar_10a7)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1097= _subsystem_1091.begin(), itInitFunction_10a0= _initFunction_109a.begin(), itLocalVar_10a9= _localVar_10a3.begin(); itSubsystem_1097!= _subsystem_1091.end(), itInitFunction_10a0!= _initFunction_109a.end(), itLocalVar_10a9!= _localVar_10a3.end(); ++itSubsystem_1097, ++itInitFunction_10a0, ++itLocalVar_10a9)
	{
		if( ( *itSubsystem_1097== subsystem_1095)&& ( *itInitFunction_10a0== initFunction_109e)&& ( *itLocalVar_10a9== localVar_10a7))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1091.push_back( subsystem_1095);
		_initFunction_109a.push_back( initFunction_109e);
		_localVar_10a3.push_back( localVar_10a7);
	}
	return isUnique;
}

bool ZeroPrimitiveParameter_108a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void ZeroPrimitiveParameter_108a::processInputPackets( const Packets_t& subsystems_108b, const Packets_t& initFunctions_108d, const Packets_t& localVars_108f)
{
	for( Packets_t::const_iterator itSubsystem_1092= subsystems_108b.begin(), itInitFunction_109b= initFunctions_108d.begin(), itLocalVar_10a4= localVars_108f.begin(); itSubsystem_1092!= subsystems_108b.end(), itInitFunction_109b!= initFunctions_108d.end(), itLocalVar_10a4!= localVars_108f.end(); ++itSubsystem_1092, ++itInitFunction_109b, ++itLocalVar_10a4)
	{
		bool isUnique= isInputUnique( *itSubsystem_1092, *itInitFunction_109b, *itLocalVar_10a4);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1092, *itInitFunction_109b, *itLocalVar_10a4);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ZeroPrimitiveParameter_108a::patternMatcher( const Udm::Object& subsystem_1093, const Udm::Object& initFunction_109c, const Udm::Object& localVar_10a5)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1093.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1098= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1093);
		if( false== Uml::IsDerivedFrom( initFunction_109c.type(), SFC::Function::meta))
			continue;
		SFC::Function initFunction_10a1= SFC::Function::Cast( initFunction_109c);
		if( false== Uml::IsDerivedFrom( localVar_10a5.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_10aa= SFC::LocalVar::Cast( localVar_10a5);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_10af;
		if( !isValidBound(boundObjs_10af, subsystem_1098, true))
			continue;
		currMatch.subsystem_10b0= subsystem_1098;
		if( !isValidBound(boundObjs_10af, initFunction_10a1, true))
			continue;
		currMatch.initFunction_10b1= initFunction_10a1;
		if( !isValidBound(boundObjs_10af, localVar_10aa, true))
			continue;
		currMatch.localVar_10b2= localVar_10aa;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void ZeroPrimitiveParameter_108a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function& InitFunction= currMatch.initFunction_10b1;
		SFC::LocalVar& LocalVar= currMatch.localVar_10b2;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_10b0;
		{
SFUtils::InitParameter( InitFunction, LocalVar );
};
	}
}

void InitPrimPseudoParams_10c3::operator()( const Packets_t& systems_10c4, const Packets_t& initFunctions_10c6, const Packets_t& classStructs_10c8, Packets_t& systems_10ca, Packets_t& initFunctions_10cb, Packets_t& classStructs_10cc)
{
#ifdef PRINT_INFO
	printLog("InitPrimPseudoParams_10c3" );
#endif
	_system_10cd= &systems_10ca;
	_initFunction_10ce= &initFunctions_10cb;
	_classStruct_10cf= &classStructs_10cc;
	if( ( !systems_10c4.empty())&& ( !initFunctions_10c6.empty())&& ( !classStructs_10c8.empty()))
		callinitPrimPseudoParam_110b( systems_10c4, initFunctions_10c6, classStructs_10c8);
	_system_10cd->insert( _system_10cd->end(), systems_10c4.begin(), systems_10c4.end());
	_initFunction_10ce->insert( _initFunction_10ce->end(), initFunctions_10c6.begin(), initFunctions_10c6.end());
	_classStruct_10cf->insert( _classStruct_10cf->end(), classStructs_10c8.begin(), classStructs_10c8.end());
}

void InitPrimPseudoParams_10c3::callinitPrimPseudoParam_110b( const Packets_t& subsystem1s_10d1, const Packets_t& initFunctions_10d3, const Packets_t& classStructs_10d5)
{
	InitPrimPseudoParam_10d0 initPrimPseudoParam_10d0;
	initPrimPseudoParam_10d0( subsystem1s_10d1, initFunctions_10d3, classStructs_10d5);
}

void InitPrimPseudoParam_10d0::operator()( const Packets_t& subsystem1s_10d1, const Packets_t& initFunctions_10d3, const Packets_t& classStructs_10d5)
{
#ifdef PRINT_INFO
	printLog("InitPrimPseudoParam_10d0" );
#endif
	RTTGenerator::Instance()->generateRule(873, "initPrimPseudoParam");
	processInputPackets( subsystem1s_10d1, initFunctions_10d3, classStructs_10d5);
}

bool InitPrimPseudoParam_10d0::isInputUnique( const Udm::Object& subsystem1_10db, const Udm::Object& initFunction_10e4, const Udm::Object& classStruct_10ed)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem1_10dd= _subsystem1_10d7.begin(), itInitFunction_10e6= _initFunction_10e0.begin(), itClassStruct_10ef= _classStruct_10e9.begin(); itSubsystem1_10dd!= _subsystem1_10d7.end(), itInitFunction_10e6!= _initFunction_10e0.end(), itClassStruct_10ef!= _classStruct_10e9.end(); ++itSubsystem1_10dd, ++itInitFunction_10e6, ++itClassStruct_10ef)
	{
		if( ( *itSubsystem1_10dd== subsystem1_10db)&& ( *itInitFunction_10e6== initFunction_10e4)&& ( *itClassStruct_10ef== classStruct_10ed))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem1_10d7.push_back( subsystem1_10db);
		_initFunction_10e0.push_back( initFunction_10e4);
		_classStruct_10e9.push_back( classStruct_10ed);
	}
	return isUnique;
}

bool InitPrimPseudoParam_10d0::isGuardTrue( SFC::Struct& ClassStruct, SFC::Function& InitFunction, SFC::LocalVar& LocalVar, CyPhyML::SignalFlow::SF_Parameter& Parameter, CyPhyML::SignalFlow::Primitive& Primitive, CyPhyML::SignalFlow::Subsystem& Subsystem1, CyPhyML::SignalFlow::Subsystem& Subsystem2)
{
	bool Gz_guard= false;
	return Subsystem1 == Subsystem2;;
	return Gz_guard;
}

void InitPrimPseudoParam_10d0::processInputPackets( const Packets_t& subsystem1s_10d1, const Packets_t& initFunctions_10d3, const Packets_t& classStructs_10d5)
{
	for( Packets_t::const_iterator itSubsystem1_10d8= subsystem1s_10d1.begin(), itInitFunction_10e1= initFunctions_10d3.begin(), itClassStruct_10ea= classStructs_10d5.begin(); itSubsystem1_10d8!= subsystem1s_10d1.end(), itInitFunction_10e1!= initFunctions_10d3.end(), itClassStruct_10ea!= classStructs_10d5.end(); ++itSubsystem1_10d8, ++itInitFunction_10e1, ++itClassStruct_10ea)
	{
		bool isUnique= isInputUnique( *itSubsystem1_10d8, *itInitFunction_10e1, *itClassStruct_10ea);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem1_10d8, *itInitFunction_10e1, *itClassStruct_10ea);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool InitPrimPseudoParam_10d0::patternMatcher( const Udm::Object& subsystem1_10d9, const Udm::Object& initFunction_10e2, const Udm::Object& classStruct_10eb)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem1_10d9.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem1_10de= CyPhyML::SignalFlow::Subsystem::Cast( subsystem1_10d9);
		if( false== Uml::IsDerivedFrom( initFunction_10e2.type(), SFC::Function::meta))
			continue;
		SFC::Function initFunction_10e7= SFC::Function::Cast( initFunction_10e2);
		if( false== Uml::IsDerivedFrom( classStruct_10eb.type(), SFC::Struct::meta))
			continue;
		SFC::Struct classStruct_10f0= SFC::Struct::Cast( classStruct_10eb);
		set< SFC::LocalVar> localVars_10f2= classStruct_10f0.pmemb();
		for( set< SFC::LocalVar>::const_iterator itLocalVars_10f3= localVars_10f2.begin(); itLocalVars_10f3!= localVars_10f2.end(); ++itLocalVars_10f3)
		{
			SFC::LocalVar currLocalVar_10f4= *itLocalVars_10f3;
			set< CyPhyML::SignalFlow::SF_Parameter> parameters_10f5= currLocalVar_10f4.param();
			for( set< CyPhyML::SignalFlow::SF_Parameter>::const_iterator itParameters_10f6= parameters_10f5.begin(); itParameters_10f6!= parameters_10f5.end(); ++itParameters_10f6)
			{
				CyPhyML::SignalFlow::SF_Parameter currParameter_10f7= *itParameters_10f6;
				Udm::Object parameterParent_10f8= currParameter_10f7.container();
				if( false== Uml::IsDerivedFrom( parameterParent_10f8.type(), CyPhyML::SignalFlow::Primitive::meta))
					continue;
				CyPhyML::SignalFlow::Primitive primitiveParameter_10f9= CyPhyML::SignalFlow::Primitive::Cast( parameterParent_10f8);
				Udm::Object primitiveParent_10fa= primitiveParameter_10f9.container();
				if( false== Uml::IsDerivedFrom( primitiveParent_10fa.type(), CyPhyML::SignalFlow::Subsystem::meta))
					continue;
				CyPhyML::SignalFlow::Subsystem subsystem2Primitive_10fb= CyPhyML::SignalFlow::Subsystem::Cast( primitiveParent_10fa);
				Match currMatch;
				currMatch.subsystem1_10fd= subsystem1_10de;
				currMatch.initFunction_10fe= initFunction_10e7;
				currMatch.classStruct_10ff= classStruct_10f0;
				currMatch.subsystem2_1100= subsystem2Primitive_10fb;
				currMatch.primitive_1101= primitiveParameter_10f9;
				currMatch.parameter_1102= currParameter_10f7;
				currMatch.localVar_1103= currLocalVar_10f4;
				bool Gz_guard= isGuardTrue( currMatch.classStruct_10ff, currMatch.initFunction_10fe, currMatch.localVar_1103, currMatch.parameter_1102, currMatch.primitive_1101, currMatch.subsystem1_10fd, currMatch.subsystem2_1100);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void InitPrimPseudoParam_10d0::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Struct& ClassStruct= currMatch.classStruct_10ff;
		SFC::Function& InitFunction= currMatch.initFunction_10fe;
		SFC::LocalVar& LocalVar= currMatch.localVar_1103;
		CyPhyML::SignalFlow::SF_Parameter& Parameter= currMatch.parameter_1102;
		CyPhyML::SignalFlow::Primitive& Primitive= currMatch.primitive_1101;
		CyPhyML::SignalFlow::Subsystem& Subsystem1= currMatch.subsystem1_10fd;
		CyPhyML::SignalFlow::Subsystem& Subsystem2= currMatch.subsystem2_1100;
		{
SFUtils::InitParameter( InitFunction, Parameter, LocalVar );
};
	}
}

void MakeChartConstructor_1128::operator()( const Packets_t& systems_1129)
{
#ifdef PRINT_INFO
	printLog("MakeChartConstructor_1128" );
#endif
	if( ( !systems_1129.empty()))
		callCreateInitFunction_114c( systems_1129);
}

void MakeChartConstructor_1128::callCreateInitFunction_114c( const Packets_t& subsystems_112c)
{
	Packets_t subsystems_112e;
	Packets_t initFunctions_112f;
	CreateInitFunction_112b createInitFunction_112b;
	createInitFunction_112b( subsystems_112c, subsystems_112e, initFunctions_112f);
	if( ( !subsystems_112e.empty())&& ( !initFunctions_112f.empty()))
		callinitSubSubsystem_114e( subsystems_112e, initFunctions_112f);
}

void MakeChartConstructor_1128::callinitSubSubsystem_114e( const Packets_t& subsystems_dc5, const Packets_t& initFunctions_dc7)
{
	InitSubSubsystem_dc4 initSubSubsystem_dc4;
	initSubSubsystem_dc4( subsystems_dc5, initFunctions_dc7);
}

void CreateInitFunction_112b::operator()( const Packets_t& subsystems_112c, Packets_t& subsystems_112e, Packets_t& initFunctions_112f)
{
#ifdef PRINT_INFO
	printLog("CreateInitFunction_112b" );
#endif
	RTTGenerator::Instance()->generateRule(918, "CreateInitFunction");
	_subsystem_1130= &subsystems_112e;
	_initFunction_1131= &initFunctions_112f;
	processInputPackets( subsystems_112c);
}

bool CreateInitFunction_112b::isInputUnique( const Udm::Object& subsystem_1136)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1138= _subsystem_1132.begin(); itSubsystem_1138!= _subsystem_1132.end(); ++itSubsystem_1138)
	{
		if( ( *itSubsystem_1138== subsystem_1136))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_subsystem_1132.push_back( subsystem_1136);
	return isUnique;
}

bool CreateInitFunction_112b::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateInitFunction_112b::processInputPackets( const Packets_t& subsystems_112c)
{
	for( Packets_t::const_iterator itSubsystem_1133= subsystems_112c.begin(); itSubsystem_1133!= subsystems_112c.end(); ++itSubsystem_1133)
	{
		bool isUnique= isInputUnique( *itSubsystem_1133);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1133);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateInitFunction_112b::patternMatcher( const Udm::Object& subsystem_1134)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1134.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1139= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1134);
		SFC::Class class_113b= subsystem_1139.cls();
		if( !class_113b)
			continue;
		set< SFC::Struct> structs_113c= class_113b.Struct_kind_children();
		for( set< SFC::Struct>::const_iterator itStruct_113d= structs_113c.begin(); itStruct_113d!= structs_113c.end(); ++itStruct_113d)
		{
			SFC::Struct currStruct_113e= *itStruct_113d;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1142;
			if( !isValidBound(boundObjs_1142, subsystem_1139, true))
				continue;
			currMatch.subsystem_1143= subsystem_1139;
			if( !isValidBound(boundObjs_1142, class_113b, false))
				continue;
			currMatch.class_1144= class_113b;
			if( !isValidBound(boundObjs_1142, currStruct_113e, false))
				continue;
			currMatch.struct_1145= currStruct_113e;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateInitFunction_112b::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function newInitFunction_1146= SFC::Function::Create( currMatch.class_1144, SFC::Class::meta_stmnt);
		SFC::Arg newArg_1147= SFC::Arg::Create( newInitFunction_1146);
		SFC::Arg& Arg= newArg_1147;
		SFC::Class& Class= currMatch.class_1144;
		SFC::Function& InitFunction= newInitFunction_1146;
		SFC::Struct& Struct= currMatch.struct_1145;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_1143;
		{
Arg.name() = "context";
Arg.ptr() = true;
Arg.argIndex() = 0;
};
		{
__int64 statementCount = Class.statementCount();
InitFunction.statementIndex() = statementCount++;
Class.statementCount() = statementCount;

InitFunction.name() = static_cast< std::string >( Subsystem.name() ) +  "_init";
InitFunction.argCount() = 1;
InitFunction.statementCount() = -1;
};
		newInitFunction_1146.sysinit()= currMatch.subsystem_1143;
		newArg_1147.dt()= currMatch.struct_1145;
		outputAppender( currMatch.subsystem_1143, newInitFunction_1146);
	}
}

void CreateInitFunction_112b::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1148, const SFC::Function& initFunction_114a)
{
	_subsystem_1130->push_back( subsystem_1148);
	_initFunction_1131->push_back( initFunction_114a);
}

void SubsystemFilter_1151::operator()( const Packets_t& systems_1152, Packets_t& chartsystems_1154, Packets_t& sFchartsystems_1155, Packets_t& systems_1156)
{
#ifdef PRINT_INFO
	printLog("SubsystemFilter_1151" );
#endif
	_chartsystem_1157= &chartsystems_1154;
	_sFchartsystem_1158= &sFchartsystems_1155;
	_system_1159= &systems_1156;
	if( ( !systems_1152.empty()))
		callSubsystemFilter_11cd( systems_1152);
}

void SubsystemFilter_1151::callSubsystemFilter_11cd( const Packets_t& systems_115b)
{
	Packets_t systems_115d;
	Packets_t systems_115e;
	Packets_t systems_115f;
	Packets_t systems_1160;
	SubsystemFilter_115a subsystemFilter_115a;
	subsystemFilter_115a( systems_115b, systems_115d, systems_115e, systems_115f, systems_1160);
	_chartsystem_1157->insert( _chartsystem_1157->end(), systems_115d.begin(), systems_115d.end());
	_sFchartsystem_1158->insert( _sFchartsystem_1158->end(), systems_115e.begin(), systems_115e.end());
	_system_1159->insert( _system_1159->end(), systems_115f.begin(), systems_115f.end());
	_system_1159->insert( _system_1159->end(), systems_1160.begin(), systems_1160.end());
}

void SubsystemFilter_115a::operator()( const Packets_t& systems_115b, Packets_t& systems_115d, Packets_t& systems_115e, Packets_t& systems_115f, Packets_t& systems_1160)
{
#ifdef PRINT_INFO
	printLog("SubsystemFilter_115a" );
#endif
	_system_1161= &systems_115d;
	_system_1162= &systems_115e;
	_system_1163= &systems_115f;
	_system_1164= &systems_1160;
	for( Packets_t::const_iterator itsystem_1166= systems_115b.begin(); itsystem_1166!= systems_115b.end(); ++itsystem_1166)
	{
		bool isUnique= isInputUnique( *itsystem_1166);
		if( !isUnique)
			continue;
		Packets_t onesystem_116a( 1, *itsystem_1166);
		executeOne( onesystem_116a);
	}
}

void SubsystemFilter_115a::executeOne( const Packets_t& systems_115b)
{
	Packets_t subsystems_116f;
	IsStateChart_116c isStateChart_116c;
	bool isMatchIsStateChart_116c= isStateChart_116c( systems_115b, subsystems_116f);
	_system_1161->insert( _system_1161->end(), subsystems_116f.begin(), subsystems_116f.end());
	if( isMatchIsStateChart_116c)
		return;
	Packets_t subsystems_118c;
	IsSFStateChart_1189 isSFStateChart_1189;
	bool isMatchIsSFStateChart_1189= isSFStateChart_1189( systems_115b, subsystems_118c);
	_system_1162->insert( _system_1162->end(), subsystems_118c.begin(), subsystems_118c.end());
	if( isMatchIsSFStateChart_1189)
		return;
	Packets_t subsystems_11a5;
	IsInstance_11a2 isInstance_11a2;
	bool isMatchIsInstance_11a2= isInstance_11a2( systems_115b, subsystems_11a5);
	_system_1163->insert( _system_1163->end(), subsystems_11a5.begin(), subsystems_11a5.end());
	if( isMatchIsInstance_11a2)
		return;
	Packets_t subsystems_11bb;
	Otherwise_11b8 otherwise_11b8;
	bool isMatchOtherwise_11b8= otherwise_11b8( systems_115b, subsystems_11bb);
	_system_1164->insert( _system_1164->end(), subsystems_11bb.begin(), subsystems_11bb.end());
	if( isMatchOtherwise_11b8)
		return;
}

bool SubsystemFilter_115a::isInputUnique( const Udm::Object& system_1167)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itsystem_1169= _system_1165.begin(); itsystem_1169!= _system_1165.end(); ++itsystem_1169)
	{
		if( ( *itsystem_1169== system_1167))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_system_1165.push_back( system_1167);
	return isUnique;
}

bool IsStateChart_116c::operator()( const Packets_t& subsystems_116d, Packets_t& subsystems_116f)
{
#ifdef PRINT_INFO
	printLog("IsStateChart_116c" );
#endif
	_subsystem_1170= &subsystems_116f;
	processInputPackets( subsystems_116d);
	if( false== _matches.empty())
		return true;
	return false;
}

bool IsStateChart_116c::isInputUnique( const Udm::Object& subsystem_1175)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1177= _subsystem_1171.begin(); itSubsystem_1177!= _subsystem_1171.end(); ++itSubsystem_1177)
	{
		if( ( *itSubsystem_1177== subsystem_1175))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_subsystem_1171.push_back( subsystem_1175);
	return isUnique;
}

bool IsStateChart_116c::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void IsStateChart_116c::processInputPackets( const Packets_t& subsystems_116d)
{
	for( Packets_t::const_iterator itSubsystem_1172= subsystems_116d.begin(); itSubsystem_1172!= subsystems_116d.end(); ++itSubsystem_1172)
	{
		bool isUnique= isInputUnique( *itSubsystem_1172);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1172);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_1184);
	}
}

bool IsStateChart_116c::patternMatcher( const Udm::Object& subsystem_1173)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1173.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1178= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1173);
		set< CyPhyML::SignalFlow::Primitive> primitives_117a= subsystem_1178.Primitive_kind_children();
		for( set< CyPhyML::SignalFlow::Primitive>::const_iterator itPrimitive_117b= primitives_117a.begin(); itPrimitive_117b!= primitives_117a.end(); ++itPrimitive_117b)
		{
			CyPhyML::SignalFlow::Primitive currPrimitive_117c= *itPrimitive_117b;
			set< CyPhyML::SignalFlow::State> states_117d= currPrimitive_117c.State_kind_children();
			for( set< CyPhyML::SignalFlow::State>::const_iterator itState_117e= states_117d.begin(); itState_117e!= states_117d.end(); ++itState_117e)
			{
				CyPhyML::SignalFlow::State currState_117f= *itState_117e;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_1183;
				if( !isValidBound(boundObjs_1183, subsystem_1178, true))
					continue;
				currMatch.subsystem_1184= subsystem_1178;
				if( !isValidBound(boundObjs_1183, currPrimitive_117c, false))
					continue;
				currMatch.primitive_1185= currPrimitive_117c;
				if( !isValidBound(boundObjs_1183, currState_117f, false))
					continue;
				currMatch.state_1186= currState_117f;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void IsStateChart_116c::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1187)
{
	_subsystem_1170->push_back( subsystem_1187);
}

bool IsSFStateChart_1189::operator()( const Packets_t& subsystems_118a, Packets_t& subsystems_118c)
{
#ifdef PRINT_INFO
	printLog("IsSFStateChart_1189" );
#endif
	_subsystem_118d= &subsystems_118c;
	processInputPackets( subsystems_118a);
	if( false== _matches.empty())
		return true;
	return false;
}

bool IsSFStateChart_1189::isInputUnique( const Udm::Object& subsystem_1192)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1194= _subsystem_118e.begin(); itSubsystem_1194!= _subsystem_118e.end(); ++itSubsystem_1194)
	{
		if( ( *itSubsystem_1194== subsystem_1192))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_subsystem_118e.push_back( subsystem_1192);
	return isUnique;
}

bool IsSFStateChart_1189::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void IsSFStateChart_1189::processInputPackets( const Packets_t& subsystems_118a)
{
	for( Packets_t::const_iterator itSubsystem_118f= subsystems_118a.begin(); itSubsystem_118f!= subsystems_118a.end(); ++itSubsystem_118f)
	{
		bool isUnique= isInputUnique( *itSubsystem_118f);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_118f);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_119e);
	}
}

bool IsSFStateChart_1189::patternMatcher( const Udm::Object& subsystem_1190)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1190.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1195= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1190);
		set< CyPhyML::SignalFlow::SFState> sFStates_1197= subsystem_1195.SFState_kind_children();
		for( set< CyPhyML::SignalFlow::SFState>::const_iterator itSFState_1198= sFStates_1197.begin(); itSFState_1198!= sFStates_1197.end(); ++itSFState_1198)
		{
			CyPhyML::SignalFlow::SFState currSFState_1199= *itSFState_1198;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_119d;
			if( !isValidBound(boundObjs_119d, subsystem_1195, true))
				continue;
			currMatch.subsystem_119e= subsystem_1195;
			if( !isValidBound(boundObjs_119d, currSFState_1199, false))
				continue;
			currMatch.sFState_119f= currSFState_1199;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void IsSFStateChart_1189::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_11a0)
{
	_subsystem_118d->push_back( subsystem_11a0);
}

bool IsInstance_11a2::operator()( const Packets_t& subsystems_11a3, Packets_t& subsystems_11a5)
{
#ifdef PRINT_INFO
	printLog("IsInstance_11a2" );
#endif
	_subsystem_11a6= &subsystems_11a5;
	processInputPackets( subsystems_11a3);
	if( false== _matches.empty())
		return true;
	return false;
}

bool IsInstance_11a2::isInputUnique( const Udm::Object& subsystem_11ab)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_11ad= _subsystem_11a7.begin(); itSubsystem_11ad!= _subsystem_11a7.end(); ++itSubsystem_11ad)
	{
		if( ( *itSubsystem_11ad== subsystem_11ab))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_subsystem_11a7.push_back( subsystem_11ab);
	return isUnique;
}

bool IsInstance_11a2::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool IsInstance_11a2::isGuardTrue( CyPhyML::SignalFlow::Subsystem& Subsystem)
{
	bool Gz_guard= false;
	Gz_guard = Subsystem.isInstance();;
	return Gz_guard;
}

void IsInstance_11a2::processInputPackets( const Packets_t& subsystems_11a3)
{
	for( Packets_t::const_iterator itSubsystem_11a8= subsystems_11a3.begin(); itSubsystem_11a8!= subsystems_11a3.end(); ++itSubsystem_11a8)
	{
		bool isUnique= isInputUnique( *itSubsystem_11a8);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_11a8);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_11b4);
	}
}

bool IsInstance_11a2::patternMatcher( const Udm::Object& subsystem_11a9)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_11a9.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_11ae= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_11a9);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_11b3;
		if( !isValidBound(boundObjs_11b3, subsystem_11ae, true))
			continue;
		currMatch.subsystem_11b4= subsystem_11ae;
		bool Gz_guard= isGuardTrue( currMatch.subsystem_11b4);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void IsInstance_11a2::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_11b6)
{
	_subsystem_11a6->push_back( subsystem_11b6);
}

bool Otherwise_11b8::operator()( const Packets_t& subsystems_11b9, Packets_t& subsystems_11bb)
{
#ifdef PRINT_INFO
	printLog("Otherwise_11b8" );
#endif
	_subsystem_11bc= &subsystems_11bb;
	processInputPackets( subsystems_11b9);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_11b8::isInputUnique( const Udm::Object& subsystem_11c1)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_11c3= _subsystem_11bd.begin(); itSubsystem_11c3!= _subsystem_11bd.end(); ++itSubsystem_11c3)
	{
		if( ( *itSubsystem_11c3== subsystem_11c1))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_subsystem_11bd.push_back( subsystem_11c1);
	return isUnique;
}

bool Otherwise_11b8::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_11b8::processInputPackets( const Packets_t& subsystems_11b9)
{
	for( Packets_t::const_iterator itSubsystem_11be= subsystems_11b9.begin(); itSubsystem_11be!= subsystems_11b9.end(); ++itSubsystem_11be)
	{
		bool isUnique= isInputUnique( *itSubsystem_11be);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_11be);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_11ca);
	}
}

bool Otherwise_11b8::patternMatcher( const Udm::Object& subsystem_11bf)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_11bf.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_11c4= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_11bf);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_11c9;
		if( !isValidBound(boundObjs_11c9, subsystem_11c4, true))
			continue;
		currMatch.subsystem_11ca= subsystem_11c4;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_11b8::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_11cb)
{
	_subsystem_11bc->push_back( subsystem_11cb);
}

void GetSubSubsystems_11cf::operator()( const Packets_t& systems_11d0, Packets_t& subsystems_11d2)
{
#ifdef PRINT_INFO
	printLog("GetSubSubsystems_11cf" );
#endif
	_subsystem_11d3= &subsystems_11d2;
	if( ( !systems_11d0.empty()))
		callGetSubSubsystems_11ed( systems_11d0);
}

void GetSubSubsystems_11cf::callGetSubSubsystems_11ed( const Packets_t& subsystems_11d5)
{
	Packets_t subSubsystems_11d7;
	GetSubSubsystems_11d4 getSubSubsystems_11d4;
	getSubSubsystems_11d4( subsystems_11d5, subSubsystems_11d7);
	_subsystem_11d3->insert( _subsystem_11d3->end(), subSubsystems_11d7.begin(), subSubsystems_11d7.end());
}

void GetSubSubsystems_11d4::operator()( const Packets_t& subsystems_11d5, Packets_t& subSubsystems_11d7)
{
#ifdef PRINT_INFO
	printLog("GetSubSubsystems_11d4" );
#endif
	RTTGenerator::Instance()->generateRule(1958, "GetSubSubsystems");
	_subSubsystem_11d8= &subSubsystems_11d7;
	processInputPackets( subsystems_11d5);
}

bool GetSubSubsystems_11d4::isInputUnique( const Udm::Object& subsystem_11dd)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_11df= _subsystem_11d9.begin(); itSubsystem_11df!= _subsystem_11d9.end(); ++itSubsystem_11df)
	{
		if( ( *itSubsystem_11df== subsystem_11dd))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_subsystem_11d9.push_back( subsystem_11dd);
	return isUnique;
}

bool GetSubSubsystems_11d4::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetSubSubsystems_11d4::processInputPackets( const Packets_t& subsystems_11d5)
{
	for( Packets_t::const_iterator itSubsystem_11da= subsystems_11d5.begin(); itSubsystem_11da!= subsystems_11d5.end(); ++itSubsystem_11da)
	{
		bool isUnique= isInputUnique( *itSubsystem_11da);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_11da);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetSubSubsystems_11d4::patternMatcher( const Udm::Object& subsystem_11db)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_11db.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_11e0= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_11db);
		set< CyPhyML::SignalFlow::Subsystem> subSubsystems_11e2= subsystem_11e0.Subsystem_kind_children();
		for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itSubSubsystem_11e3= subSubsystems_11e2.begin(); itSubSubsystem_11e3!= subSubsystems_11e2.end(); ++itSubSubsystem_11e3)
		{
			CyPhyML::SignalFlow::Subsystem currSubSubsystem_11e4= *itSubSubsystem_11e3;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_11e8;
			if( !isValidBound(boundObjs_11e8, subsystem_11e0, true))
				continue;
			currMatch.subsystem_11e9= subsystem_11e0;
			if( !isValidBound(boundObjs_11e8, currSubSubsystem_11e4, false))
				continue;
			currMatch.subSubsystem_11ea= currSubSubsystem_11e4;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetSubSubsystems_11d4::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subSubsystem_11ea);
	}
}

void GetSubSubsystems_11d4::outputAppender( const CyPhyML::SignalFlow::Subsystem& subSubsystem_11eb)
{
	_subSubsystem_11d8->push_back( subSubsystem_11eb);
}

void GetSubsystems_11f9::operator()( const Packets_t& comptypes_11fa, Packets_t& subsystems_11fc)
{
#ifdef PRINT_INFO
	printLog("GetSubsystems_11f9" );
#endif
	_subsystem_11fd= &subsystems_11fc;
	if( ( !comptypes_11fa.empty()))
		callGetSubSystems_1217( comptypes_11fa);
}

void GetSubsystems_11f9::callGetSubSystems_1217( const Packets_t& dataflows_11ff)
{
	Packets_t subsystems_1201;
	GetSubSystems_11fe getSubSystems_11fe;
	getSubSystems_11fe( dataflows_11ff, subsystems_1201);
	_subsystem_11fd->insert( _subsystem_11fd->end(), subsystems_1201.begin(), subsystems_1201.end());
}

void GetSubSystems_11fe::operator()( const Packets_t& dataflows_11ff, Packets_t& subsystems_1201)
{
#ifdef PRINT_INFO
	printLog("GetSubSystems_11fe" );
#endif
	RTTGenerator::Instance()->generateRule(5007, "GetSubSystems");
	_subsystem_1202= &subsystems_1201;
	processInputPackets( dataflows_11ff);
}

bool GetSubSystems_11fe::isInputUnique( const Udm::Object& dataflow_1207)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itDataflow_1209= _dataflow_1203.begin(); itDataflow_1209!= _dataflow_1203.end(); ++itDataflow_1209)
	{
		if( ( *itDataflow_1209== dataflow_1207))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_dataflow_1203.push_back( dataflow_1207);
	return isUnique;
}

bool GetSubSystems_11fe::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetSubSystems_11fe::processInputPackets( const Packets_t& dataflows_11ff)
{
	for( Packets_t::const_iterator itDataflow_1204= dataflows_11ff.begin(); itDataflow_1204!= dataflows_11ff.end(); ++itDataflow_1204)
	{
		bool isUnique= isInputUnique( *itDataflow_1204);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itDataflow_1204);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetSubSystems_11fe::patternMatcher( const Udm::Object& dataflow_1205)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( dataflow_1205.type(), CyPhyML::SignalFlowModel::meta))
			continue;
		CyPhyML::SignalFlowModel dataflow_120a= CyPhyML::SignalFlowModel::Cast( dataflow_1205);
		set< CyPhyML::SignalFlow::Subsystem> subsystems_120c= dataflow_120a.SignalFlow_Subsystem_kind_children();
		for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itSubsystem_120d= subsystems_120c.begin(); itSubsystem_120d!= subsystems_120c.end(); ++itSubsystem_120d)
		{
			CyPhyML::SignalFlow::Subsystem currSubsystem_120e= *itSubsystem_120d;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1212;
			if( !isValidBound(boundObjs_1212, dataflow_120a, true))
				continue;
			currMatch.dataflow_1213= dataflow_120a;
			if( !isValidBound(boundObjs_1212, currSubsystem_120e, false))
				continue;
			currMatch.subsystem_1214= currSubsystem_120e;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetSubSystems_11fe::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_1214);
	}
}

void GetSubSystems_11fe::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1215)
{
	_subsystem_1202->push_back( subsystem_1215);
}

void MakeClasses_121d::operator()( const Packets_t& dataflows_121e, const Packets_t& projects_1220, Packets_t& dataflows_1222, Packets_t& projects_1223)
{
#ifdef PRINT_INFO
	printLog("MakeClasses_121d" );
#endif
	_dataflow_1224= &dataflows_1222;
	_project_1225= &projects_1223;
	if( ( !dataflows_121e.empty())&& ( !projects_1220.empty()))
		callGetBlocks_53c6( dataflows_121e, projects_1220);
	_dataflow_1224->insert( _dataflow_1224->end(), dataflows_121e.begin(), dataflows_121e.end());
	_project_1225->insert( _project_1225->end(), projects_1220.begin(), projects_1220.end());
}

void MakeClasses_121d::callGetBlocks_53c6( const Packets_t& comptypes_1227, const Packets_t& projects_1229)
{
	Packets_t subsystems_122b;
	Packets_t projects_122c;
	GetBlocks_1226 getBlocks_1226;
	getBlocks_1226( comptypes_1227, projects_1229, subsystems_122b, projects_122c);
	if( ( !subsystems_122b.empty())&& ( !projects_122c.empty()))
		callCreateAllPrograms_53c9( subsystems_122b, projects_122c);
}

void MakeClasses_121d::callCreateAllPrograms_53c9( const Packets_t& subsystems_125c, const Packets_t& projects_125e)
{
	CreateAllPrograms_125b createAllPrograms_125b;
	createAllPrograms_125b( subsystems_125c, projects_125e);
}

void GetBlocks_1226::operator()( const Packets_t& comptypes_1227, const Packets_t& projects_1229, Packets_t& subsystems_122b, Packets_t& projects_122c)
{
#ifdef PRINT_INFO
	printLog("GetBlocks_1226" );
#endif
	_subsystem_122d= &subsystems_122b;
	_project_122e= &projects_122c;
	if( ( !comptypes_1227.empty())&& ( !projects_1229.empty()))
		callGetSubSystems_1258( comptypes_1227, projects_1229);
}

void GetBlocks_1226::callGetSubSystems_1258( const Packets_t& dataflows_1230, const Packets_t& projects_1233)
{
	Packets_t subsystems_1232;
	Packets_t projects_1235;
	GetSubSystems_122f getSubSystems_122f;
	getSubSystems_122f( dataflows_1230, projects_1233, subsystems_1232, projects_1235);
	_subsystem_122d->insert( _subsystem_122d->end(), subsystems_1232.begin(), subsystems_1232.end());
	_project_122e->insert( _project_122e->end(), projects_1235.begin(), projects_1235.end());
}

void GetSubSystems_122f::operator()( const Packets_t& dataflows_1230, const Packets_t& projects_1233, Packets_t& subsystems_1232, Packets_t& projects_1235)
{
#ifdef PRINT_INFO
	printLog("GetSubSystems_122f" );
#endif
	RTTGenerator::Instance()->generateRule(942, "GetSubSystems");
	_subsystem_1236= &subsystems_1232;
	_project_1237= &projects_1235;
	processInputPackets( dataflows_1230, projects_1233);
}

bool GetSubSystems_122f::isInputUnique( const Udm::Object& dataflow_123c, const Udm::Object& project_1245)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itDataflow_123e= _dataflow_1238.begin(), itProject_1247= _project_1241.begin(); itDataflow_123e!= _dataflow_1238.end(), itProject_1247!= _project_1241.end(); ++itDataflow_123e, ++itProject_1247)
	{
		if( ( *itDataflow_123e== dataflow_123c)&& ( *itProject_1247== project_1245))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_dataflow_1238.push_back( dataflow_123c);
		_project_1241.push_back( project_1245);
	}
	return isUnique;
}

bool GetSubSystems_122f::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetSubSystems_122f::processInputPackets( const Packets_t& dataflows_1230, const Packets_t& projects_1233)
{
	for( Packets_t::const_iterator itDataflow_1239= dataflows_1230.begin(), itProject_1242= projects_1233.begin(); itDataflow_1239!= dataflows_1230.end(), itProject_1242!= projects_1233.end(); ++itDataflow_1239, ++itProject_1242)
	{
		bool isUnique= isInputUnique( *itDataflow_1239, *itProject_1242);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itDataflow_1239, *itProject_1242);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetSubSystems_122f::patternMatcher( const Udm::Object& dataflow_123a, const Udm::Object& project_1243)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( dataflow_123a.type(), CyPhyML::SignalFlowModel::meta))
			continue;
		CyPhyML::SignalFlowModel dataflow_123f= CyPhyML::SignalFlowModel::Cast( dataflow_123a);
		if( false== Uml::IsDerivedFrom( project_1243.type(), SFC::Project::meta))
			continue;
		SFC::Project project_1248= SFC::Project::Cast( project_1243);
		set< CyPhyML::SignalFlow::Subsystem> subsystems_124a= dataflow_123f.SignalFlow_Subsystem_kind_children();
		for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itSubsystem_124b= subsystems_124a.begin(); itSubsystem_124b!= subsystems_124a.end(); ++itSubsystem_124b)
		{
			CyPhyML::SignalFlow::Subsystem currSubsystem_124c= *itSubsystem_124b;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1250;
			if( !isValidBound(boundObjs_1250, dataflow_123f, true))
				continue;
			currMatch.dataflow_1251= dataflow_123f;
			if( !isValidBound(boundObjs_1250, project_1248, true))
				continue;
			currMatch.project_1252= project_1248;
			if( !isValidBound(boundObjs_1250, currSubsystem_124c, false))
				continue;
			currMatch.subsystem_1253= currSubsystem_124c;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetSubSystems_122f::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_1253, currMatch.project_1252);
	}
}

void GetSubSystems_122f::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1254, const SFC::Project& project_1256)
{
	_subsystem_1236->push_back( subsystem_1254);
	_project_1237->push_back( project_1256);
}

void CreateAllPrograms_125b::operator()( const Packets_t& subsystems_125c, const Packets_t& projects_125e)
{
#ifdef PRINT_INFO
	printLog("CreateAllPrograms_125b" );
#endif
	if( ( !subsystems_125c.empty())&& ( !projects_125e.empty()))
		callCreateProgramsTopLevel_53ba( subsystems_125c, projects_125e);
}

void CreateAllPrograms_125b::callCreateProgramsTopLevel_53ba( const Packets_t& systems_1d18, const Packets_t& projects_1d1a)
{
	Packets_t systems_1d1c;
	Packets_t programs_1d1d;
	CreateProgramsTopLevel_1d17 createProgramsTopLevel_1d17;
	createProgramsTopLevel_1d17( systems_1d18, projects_1d1a, systems_1d1c, programs_1d1d);
	if( ( !systems_1d1c.empty())&& ( !programs_1d1d.empty()))
		callCreateClasses_53bd( systems_1d1c, programs_1d1d);
}

void CreateAllPrograms_125b::callCreateClasses_53bd( const Packets_t& systems_180e, const Packets_t& programs_1810)
{
	Packets_t systems_1812;
	CreateClasses_180d createClasses_180d;
	createClasses_180d( systems_180e, programs_1810, systems_1812);
	if( ( !systems_1812.empty()))
		callCreateFunctionsAndArgs_53c0( systems_1812);
}

void CreateAllPrograms_125b::callCreateFunctionsAndArgs_53c0( const Packets_t& systems_1261)
{
	Packets_t systems_1263;
	CreateFunctionsAndArgs_1260 createFunctionsAndArgs_1260;
	createFunctionsAndArgs_1260( systems_1261, systems_1263);
	if( ( !systems_1263.empty()))
		callCreateFunctionLocalVars_53c2( systems_1263);
}

void CreateAllPrograms_125b::callCreateFunctionLocalVars_53c2( const Packets_t& systems_19c1)
{
	Packets_t systems_19c3;
	CreateFunctionLocalVars_19c0 createFunctionLocalVars_19c0;
	createFunctionLocalVars_19c0( systems_19c1, systems_19c3);
	if( ( !systems_19c3.empty()))
		callCreateSigFlowsR_53c4( systems_19c3);
}

void CreateAllPrograms_125b::callCreateSigFlowsR_53c4( const Packets_t& systems_1dc4)
{
	CreateSigFlowsR_1dc3 createSigFlowsR_1dc3;
	createSigFlowsR_1dc3( systems_1dc4);
}

void CreateFunctionsAndArgs_1260::operator()( const Packets_t& systems_1261, Packets_t& systems_1263)
{
#ifdef PRINT_INFO
	printLog("CreateFunctionsAndArgs_1260" );
#endif
	_system_1264= &systems_1263;
	_system_1264->insert( _system_1264->end(), systems_1261.begin(), systems_1261.end());
	if( ( !systems_1261.empty()))
		callSubsystemFilter_17fa( systems_1261);
}

void CreateFunctionsAndArgs_1260::callSubsystemFilter_17fa( const Packets_t& systems_1152)
{
	Packets_t chartsystems_1154;
	Packets_t sFchartsystems_1155;
	Packets_t systems_1156;
	SubsystemFilter_1151 subsystemFilter_1151;
	subsystemFilter_1151( systems_1152, chartsystems_1154, sFchartsystems_1155, systems_1156);
	if( ( !sFchartsystems_1155.empty()))
		callCreateSFChartFunction_17fc( sFchartsystems_1155);
	if( ( !chartsystems_1154.empty()))
		callCreateChartFunction_17fe( chartsystems_1154);
	if( ( !systems_1156.empty()))
		callCreateFunctions_1800( systems_1156);
}

void CreateFunctionsAndArgs_1260::callCreateSFChartFunction_17fc( const Packets_t& subsystems_17d7)
{
	Packets_t states_17d6;
	Packets_t mains_17d9;
	CreateSFChartFunction_17d5 createSFChartFunction_17d5;
	createSFChartFunction_17d5( subsystems_17d7, states_17d6, mains_17d9);
	if( ( !states_17d6.empty())&& ( !mains_17d9.empty()))
		callMakeSFChartArguments_1802( states_17d6, mains_17d9);
}

void CreateFunctionsAndArgs_1260::callCreateChartFunction_17fe( const Packets_t& subsystems_1664)
{
	Packets_t states_1663;
	Packets_t mains_1666;
	CreateChartFunction_1662 createChartFunction_1662;
	createChartFunction_1662( subsystems_1664, states_1663, mains_1666);
	if( ( !states_1663.empty())&& ( !mains_1666.empty()))
		callMakeChartArguments_1805( states_1663, mains_1666);
}

void CreateFunctionsAndArgs_1260::callCreateFunctions_1800( const Packets_t& subsystems_14f8)
{
	Packets_t subsystems_14fa;
	Packets_t mains_14fb;
	CreateFunctions_14f7 createFunctions_14f7;
	createFunctions_14f7( subsystems_14f8, subsystems_14fa, mains_14fb);
	if( ( !subsystems_14fa.empty())&& ( !mains_14fb.empty()))
		callMakeArguments_1808( subsystems_14fa, mains_14fb);
}

void CreateFunctionsAndArgs_1260::callMakeSFChartArguments_1802( const Packets_t& states_1519, const Packets_t& functions_151b)
{
	MakeSFChartArguments_1518 makeSFChartArguments_1518;
	makeSFChartArguments_1518( states_1519, functions_151b);
}

void CreateFunctionsAndArgs_1260::callMakeChartArguments_1805( const Packets_t& states_168c, const Packets_t& functions_168e)
{
	MakeChartArguments_168b makeChartArguments_168b;
	makeChartArguments_168b( states_168c, functions_168e);
}

void CreateFunctionsAndArgs_1260::callMakeArguments_1808( const Packets_t& systems_1266, const Packets_t& functions_1268)
{
	Packets_t systems_126a;
	MakeArguments_1265 makeArguments_1265;
	makeArguments_1265( systems_1266, functions_1268, systems_126a);
	if( ( !systems_126a.empty()))
		callGetSubSubsystems_180b( systems_126a);
}

void CreateFunctionsAndArgs_1260::callGetSubSubsystems_180b( const Packets_t& systems_11d0)
{
	Packets_t subsystems_11d2;
	GetSubSubsystems_11cf getSubSubsystems_11cf;
	getSubSubsystems_11cf( systems_11d0, subsystems_11d2);
	if( ( !subsystems_11d2.empty()))
		callSubsystemFilter_17fa( subsystems_11d2);
}

void MakeArguments_1265::operator()( const Packets_t& systems_1266, const Packets_t& functions_1268, Packets_t& systems_126a)
{
#ifdef PRINT_INFO
	printLog("MakeArguments_1265" );
#endif
	_system_126b= &systems_126a;
	if( ( !systems_1266.empty())&& ( !functions_1268.empty()))
		callTrigs_14e8( systems_1266, functions_1268);
}

void MakeArguments_1265::callTrigs_14e8( const Packets_t& systems_1382, const Packets_t& functions_1384)
{
	Packets_t systems_1386;
	Packets_t functions_1387;
	Trigs_1381 trigs_1381;
	trigs_1381( systems_1382, functions_1384, systems_1386, functions_1387);
	if( ( !systems_1386.empty())&& ( !functions_1387.empty()))
		callActions_14eb( systems_1386, functions_1387);
}

void MakeArguments_1265::callActions_14eb( const Packets_t& systems_14b0, const Packets_t& functions_14b2)
{
	Packets_t systems_14b4;
	Packets_t functions_14b5;
	Actions_14af actions_14af;
	actions_14af( systems_14b0, functions_14b2, systems_14b4, functions_14b5);
	if( ( !systems_14b4.empty())&& ( !functions_14b5.empty()))
		callInputs_14ee( systems_14b4, functions_14b5);
}

void MakeArguments_1265::callInputs_14ee( const Packets_t& systems_130e, const Packets_t& functions_1310)
{
	Packets_t systems_1312;
	Packets_t functions_1313;
	Inputs_130d inputs_130d;
	inputs_130d( systems_130e, functions_1310, systems_1312, functions_1313);
	if( ( !systems_1312.empty())&& ( !functions_1313.empty()))
		callOutputs_14f1( systems_1312, functions_1313);
}

void MakeArguments_1265::callOutputs_14f1( const Packets_t& systems_126d, const Packets_t& functions_126f)
{
	Packets_t systems_1271;
	Packets_t functions_1272;
	Outputs_126c outputs_126c;
	outputs_126c( systems_126d, functions_126f, systems_1271, functions_1272);
	if( ( !systems_1271.empty())&& ( !functions_1272.empty()))
		callZeroUnconOutputs_14f4( systems_1271, functions_1272);
}

void MakeArguments_1265::callZeroUnconOutputs_14f4( const Packets_t& systems_13bb, const Packets_t& functions_13bd)
{
	Packets_t systems_13bf;
	ZeroUnconOutputs_13ba zeroUnconOutputs_13ba;
	zeroUnconOutputs_13ba( systems_13bb, functions_13bd, systems_13bf);
	_system_126b->insert( _system_126b->end(), systems_13bf.begin(), systems_13bf.end());
}

void Outputs_126c::operator()( const Packets_t& systems_126d, const Packets_t& functions_126f, Packets_t& systems_1271, Packets_t& functions_1272)
{
#ifdef PRINT_INFO
	printLog("Outputs_126c" );
#endif
	_system_1273= &systems_1271;
	_function_1274= &functions_1272;
	_system_1273->insert( _system_1273->end(), systems_126d.begin(), systems_126d.end());
	_function_1274->insert( _function_1274->end(), functions_126f.begin(), functions_126f.end());
	if( ( !systems_126d.empty())&& ( !functions_126f.empty()))
		callCreateOutputPortArgs_1303( systems_126d, functions_126f);
}

void Outputs_126c::callCreateOutputPortArgs_1303( const Packets_t& subsystems_12aa, const Packets_t& mains_12ad)
{
	Packets_t outputPorts_12a9;
	Packets_t args_12ac;
	Packets_t mains_12af;
	CreateOutputPortArgs_12a8 createOutputPortArgs_12a8;
	createOutputPortArgs_12a8( subsystems_12aa, mains_12ad, outputPorts_12a9, args_12ac, mains_12af);
	if( ( !outputPorts_12a9.empty())&& ( !args_12ac.empty())&& ( !mains_12af.empty()))
		callMainArgCount_1306( outputPorts_12a9, args_12ac, mains_12af);
}

void Outputs_126c::callMainArgCount_1306( const Packets_t& outputPorts_1276, const Packets_t& args_1279, const Packets_t& mains_127c)
{
	Packets_t outputPorts_1278;
	Packets_t args_127b;
	MainArgCount_1275 mainArgCount_1275;
	mainArgCount_1275( outputPorts_1276, args_1279, mains_127c, outputPorts_1278, args_127b);
	if( ( !outputPorts_1278.empty())&& ( !args_127b.empty()))
		callAssignType_130a( outputPorts_1278, args_127b);
}

void Outputs_126c::callAssignType_130a( const Packets_t& ports_12d7, const Packets_t& argvars_12d9)
{
	AssignType_12d6 assignType_12d6;
	assignType_12d6( ports_12d7, argvars_12d9);
}

void MainArgCount_1275::operator()( const Packets_t& outputPorts_1276, const Packets_t& args_1279, const Packets_t& mains_127c, Packets_t& outputPorts_1278, Packets_t& args_127b)
{
#ifdef PRINT_INFO
	printLog("MainArgCount_1275" );
#endif
	RTTGenerator::Instance()->generateRule(962, "MainArgCount");
	_outputPort_127e= &outputPorts_1278;
	_arg_127f= &args_127b;
	processInputPackets( outputPorts_1276, args_1279, mains_127c);
	forwardInputs( );
}

bool MainArgCount_1275::isInputUnique( const Udm::Object& outputPort_1284, const Udm::Object& arg_128d, const Udm::Object& main_1296)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itOutputPort_1286= _outputPort_1280.begin(), itArg_128f= _arg_1289.begin(), itMain_1298= _main_1292.begin(); itOutputPort_1286!= _outputPort_1280.end(), itArg_128f!= _arg_1289.end(), itMain_1298!= _main_1292.end(); ++itOutputPort_1286, ++itArg_128f, ++itMain_1298)
	{
		if( ( *itOutputPort_1286== outputPort_1284)&& ( *itArg_128f== arg_128d)&& ( *itMain_1298== main_1296))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_outputPort_1280.push_back( outputPort_1284);
		_arg_1289.push_back( arg_128d);
		_main_1292.push_back( main_1296);
	}
	return isUnique;
}

bool MainArgCount_1275::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void MainArgCount_1275::processInputPackets( const Packets_t& outputPorts_1276, const Packets_t& args_1279, const Packets_t& mains_127c)
{
	for( Packets_t::const_iterator itOutputPort_1281= outputPorts_1276.begin(), itArg_128a= args_1279.begin(), itMain_1293= mains_127c.begin(); itOutputPort_1281!= outputPorts_1276.end(), itArg_128a!= args_1279.end(), itMain_1293!= mains_127c.end(); ++itOutputPort_1281, ++itArg_128a, ++itMain_1293)
	{
		bool isUnique= isInputUnique( *itOutputPort_1281, *itArg_128a, *itMain_1293);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itOutputPort_1281, *itArg_128a, *itMain_1293);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool MainArgCount_1275::patternMatcher( const Udm::Object& outputPort_1282, const Udm::Object& arg_128b, const Udm::Object& main_1294)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( outputPort_1282.type(), CyPhyML::SignalFlow::OutputPort::meta))
			continue;
		CyPhyML::SignalFlow::OutputPort outputPort_1287= CyPhyML::SignalFlow::OutputPort::Cast( outputPort_1282);
		if( false== Uml::IsDerivedFrom( arg_128b.type(), SFC::Arg::meta))
			continue;
		SFC::Arg arg_1290= SFC::Arg::Cast( arg_128b);
		if( false== Uml::IsDerivedFrom( main_1294.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1299= SFC::Function::Cast( main_1294);
		set< SFC::Arg> args_129b= main_1299.Arg_kind_children();
		for( set< SFC::Arg>::const_iterator itArg_129c= args_129b.begin(); itArg_129c!= args_129b.end(); ++itArg_129c)
		{
			SFC::Arg currArg_129d= *itArg_129c;
			if( arg_1290!= currArg_129d)
				continue;
			set< CyPhyML::SignalFlow::SF_Port> outputPorts_129e= arg_1290.port();
			for( set< CyPhyML::SignalFlow::SF_Port>::const_iterator itOutputPorts_129f= outputPorts_129e.begin(); itOutputPorts_129f!= outputPorts_129e.end(); ++itOutputPorts_129f)
			{
				if( false== Uml::IsDerivedFrom( (*itOutputPorts_129f).type(), CyPhyML::SignalFlow::OutputPort::meta))
					continue;
				CyPhyML::SignalFlow::OutputPort currOutputPort_12a0= CyPhyML::SignalFlow::OutputPort::Cast( *itOutputPorts_129f);
				if( outputPort_1287!= currOutputPort_12a0)
					continue;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_12a4;
				if( !isValidBound(boundObjs_12a4, outputPort_1287, true))
					continue;
				currMatch.outputPort_12a5= outputPort_1287;
				if( !isValidBound(boundObjs_12a4, arg_1290, true))
					continue;
				currMatch.arg_12a6= arg_1290;
				if( !isValidBound(boundObjs_12a4, main_1299, true))
					continue;
				currMatch.main_12a7= main_1299;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void MainArgCount_1275::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg& Arg= currMatch.arg_12a6;
		SFC::Function& Main= currMatch.main_12a7;
		CyPhyML::SignalFlow::OutputPort& OutputPort= currMatch.outputPort_12a5;
		{
Main.argCount() = static_cast< __int64 >( Main.argCount() ) + 1;
};
	}
}

void MainArgCount_1275::forwardInputs()
{
	*_outputPort_127e= _outputPort_1280;
	*_arg_127f= _arg_1289;
}

void CreateOutputPortArgs_12a8::operator()( const Packets_t& subsystems_12aa, const Packets_t& mains_12ad, Packets_t& outputPorts_12a9, Packets_t& args_12ac, Packets_t& mains_12af)
{
#ifdef PRINT_INFO
	printLog("CreateOutputPortArgs_12a8" );
#endif
	RTTGenerator::Instance()->generateRule(969, "CreateOutputPortArgs");
	_outputPort_12b0= &outputPorts_12a9;
	_arg_12b1= &args_12ac;
	_main_12b2= &mains_12af;
	processInputPackets( subsystems_12aa, mains_12ad);
}

bool CreateOutputPortArgs_12a8::isInputUnique( const Udm::Object& subsystem_12b7, const Udm::Object& main_12c0)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_12b9= _subsystem_12b3.begin(), itMain_12c2= _main_12bc.begin(); itSubsystem_12b9!= _subsystem_12b3.end(), itMain_12c2!= _main_12bc.end(); ++itSubsystem_12b9, ++itMain_12c2)
	{
		if( ( *itSubsystem_12b9== subsystem_12b7)&& ( *itMain_12c2== main_12c0))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_12b3.push_back( subsystem_12b7);
		_main_12bc.push_back( main_12c0);
	}
	return isUnique;
}

bool CreateOutputPortArgs_12a8::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateOutputPortArgs_12a8::processInputPackets( const Packets_t& subsystems_12aa, const Packets_t& mains_12ad)
{
	for( Packets_t::const_iterator itSubsystem_12b4= subsystems_12aa.begin(), itMain_12bd= mains_12ad.begin(); itSubsystem_12b4!= subsystems_12aa.end(), itMain_12bd!= mains_12ad.end(); ++itSubsystem_12b4, ++itMain_12bd)
	{
		bool isUnique= isInputUnique( *itSubsystem_12b4, *itMain_12bd);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_12b4, *itMain_12bd);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateOutputPortArgs_12a8::patternMatcher( const Udm::Object& subsystem_12b5, const Udm::Object& main_12be)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_12b5.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_12ba= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_12b5);
		if( false== Uml::IsDerivedFrom( main_12be.type(), SFC::Function::meta))
			continue;
		SFC::Function main_12c3= SFC::Function::Cast( main_12be);
		set< CyPhyML::SignalFlow::OutputPort> outputPorts_12c5= subsystem_12ba.OutputPort_kind_children();
		for( set< CyPhyML::SignalFlow::OutputPort>::const_iterator itOutputPort_12c6= outputPorts_12c5.begin(); itOutputPort_12c6!= outputPorts_12c5.end(); ++itOutputPort_12c6)
		{
			CyPhyML::SignalFlow::OutputPort currOutputPort_12c7= *itOutputPort_12c6;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_12cb;
			if( !isValidBound(boundObjs_12cb, subsystem_12ba, true))
				continue;
			currMatch.subsystem_12cc= subsystem_12ba;
			if( !isValidBound(boundObjs_12cb, main_12c3, true))
				continue;
			currMatch.main_12cd= main_12c3;
			if( !isValidBound(boundObjs_12cb, currOutputPort_12c7, false))
				continue;
			currMatch.outputPort_12ce= currOutputPort_12c7;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateOutputPortArgs_12a8::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_12cf= SFC::Arg::Create( currMatch.main_12cd);
		SFC::Arg& Arg= newArg_12cf;
		SFC::Function& Main= currMatch.main_12cd;
		CyPhyML::SignalFlow::OutputPort& OutputPort= currMatch.outputPort_12ce;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_12cc;
		{
__int64 argIndex = static_cast< __int64 >( Main.argCount() ) + static_cast< __int64 >( OutputPort.Number() );
Arg.argIndex() = argIndex;

Arg.name() = static_cast< std::string >( OutputPort.name() ) + "_" + boost::lexical_cast< std::string >( argIndex );
Arg.type() = "double";
Arg.ptr() = true;
};
		newArg_12cf.port()+= currMatch.outputPort_12ce;
		outputAppender( currMatch.outputPort_12ce, newArg_12cf, currMatch.main_12cd);
	}
}

void CreateOutputPortArgs_12a8::outputAppender( const CyPhyML::SignalFlow::OutputPort& outputPort_12d0, const SFC::Arg& arg_12d2, const SFC::Function& main_12d4)
{
	_outputPort_12b0->push_back( outputPort_12d0);
	_arg_12b1->push_back( arg_12d2);
	_main_12b2->push_back( main_12d4);
}

void AssignType_12d6::operator()( const Packets_t& ports_12d7, const Packets_t& argvars_12d9)
{
#ifdef PRINT_INFO
	printLog("AssignType_12d6" );
#endif
	if( ( !ports_12d7.empty())&& ( !argvars_12d9.empty()))
		callAssignType_1300( ports_12d7, argvars_12d9);
}

void AssignType_12d6::callAssignType_1300( const Packets_t& ports_12dc, const Packets_t& argvars_12de)
{
	AssignType_12db assignType_12db;
	assignType_12db( ports_12dc, argvars_12de);
}

void AssignType_12db::operator()( const Packets_t& ports_12dc, const Packets_t& argvars_12de)
{
#ifdef PRINT_INFO
	printLog("AssignType_12db" );
#endif
	RTTGenerator::Instance()->generateRule(1990, "AssignType");
	processInputPackets( ports_12dc, argvars_12de);
}

bool AssignType_12db::isInputUnique( const Udm::Object& port_12e4, const Udm::Object& argvar_12ed)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itPort_12e6= _port_12e0.begin(), itargvar_12ef= _argvar_12e9.begin(); itPort_12e6!= _port_12e0.end(), itargvar_12ef!= _argvar_12e9.end(); ++itPort_12e6, ++itargvar_12ef)
	{
		if( ( *itPort_12e6== port_12e4)&& ( *itargvar_12ef== argvar_12ed))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_port_12e0.push_back( port_12e4);
		_argvar_12e9.push_back( argvar_12ed);
	}
	return isUnique;
}

bool AssignType_12db::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void AssignType_12db::processInputPackets( const Packets_t& ports_12dc, const Packets_t& argvars_12de)
{
	for( Packets_t::const_iterator itPort_12e1= ports_12dc.begin(), itargvar_12ea= argvars_12de.begin(); itPort_12e1!= ports_12dc.end(), itargvar_12ea!= argvars_12de.end(); ++itPort_12e1, ++itargvar_12ea)
	{
		bool isUnique= isInputUnique( *itPort_12e1, *itargvar_12ea);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itPort_12e1, *itargvar_12ea);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool AssignType_12db::patternMatcher( const Udm::Object& port_12e2, const Udm::Object& argvar_12eb)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( port_12e2.type(), CyPhyML::SignalFlow::SF_Port::meta))
			continue;
		CyPhyML::SignalFlow::SF_Port port_12e7= CyPhyML::SignalFlow::SF_Port::Cast( port_12e2);
		if( false== Uml::IsDerivedFrom( argvar_12eb.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argvar_12f0= SFC::ArgDeclBase::Cast( argvar_12eb);
		set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_12f2= port_12e7.TypeBaseRef_kind_children();
		for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_12f3= typeBaseRefs_12f2.begin(); itTypeBaseRef_12f3!= typeBaseRefs_12f2.end(); ++itTypeBaseRef_12f3)
		{
			CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_12f4= *itTypeBaseRef_12f3;
			CyPhyML::SignalFlow::SF_TypeBase typeBase_12f5= currTypeBaseRef_12f4.ref();
			if( !typeBase_12f5)
				continue;
			SFC::DT dT_12f6= typeBase_12f5.dt();
			if( !dT_12f6)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_12fa;
			if( !isValidBound(boundObjs_12fa, port_12e7, true))
				continue;
			currMatch.port_12fb= port_12e7;
			if( !isValidBound(boundObjs_12fa, argvar_12f0, true))
				continue;
			currMatch.argvar_12fc= argvar_12f0;
			if( !isValidBound(boundObjs_12fa, currTypeBaseRef_12f4, false))
				continue;
			currMatch.typeBaseRef_12fd= currTypeBaseRef_12f4;
			if( !isValidBound(boundObjs_12fa, typeBase_12f5, false))
				continue;
			currMatch.typeBase_12fe= typeBase_12f5;
			if( !isValidBound(boundObjs_12fa, dT_12f6, false))
				continue;
			currMatch.dT_12ff= dT_12f6;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void AssignType_12db::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.argvar_12fc.dt()= currMatch.dT_12ff;
	}
}

void Inputs_130d::operator()( const Packets_t& systems_130e, const Packets_t& functions_1310, Packets_t& systems_1312, Packets_t& functions_1313)
{
#ifdef PRINT_INFO
	printLog("Inputs_130d" );
#endif
	_system_1314= &systems_1312;
	_function_1315= &functions_1313;
	if( ( !systems_130e.empty())&& ( !functions_1310.empty()))
		callCreateInputPortArgs_1377( systems_130e, functions_1310);
	_system_1314->insert( _system_1314->end(), systems_130e.begin(), systems_130e.end());
	_function_1315->insert( _function_1315->end(), functions_1310.begin(), functions_1310.end());
}

void Inputs_130d::callCreateInputPortArgs_1377( const Packets_t& subsystems_134b, const Packets_t& mains_134e)
{
	Packets_t inputPorts_134a;
	Packets_t args_134d;
	Packets_t mains_1350;
	CreateInputPortArgs_1349 createInputPortArgs_1349;
	createInputPortArgs_1349( subsystems_134b, mains_134e, inputPorts_134a, args_134d, mains_1350);
	if( ( !inputPorts_134a.empty())&& ( !args_134d.empty())&& ( !mains_1350.empty()))
		callUpdateArgCount_137a( inputPorts_134a, args_134d, mains_1350);
}

void Inputs_130d::callUpdateArgCount_137a( const Packets_t& inputPorts_1317, const Packets_t& args_131a, const Packets_t& mains_131d)
{
	Packets_t inputPorts_1319;
	Packets_t args_131c;
	UpdateArgCount_1316 updateArgCount_1316;
	updateArgCount_1316( inputPorts_1317, args_131a, mains_131d, inputPorts_1319, args_131c);
	if( ( !inputPorts_1319.empty())&& ( !args_131c.empty()))
		callAssignType_137e( inputPorts_1319, args_131c);
}

void Inputs_130d::callAssignType_137e( const Packets_t& ports_12d7, const Packets_t& argvars_12d9)
{
	AssignType_12d6 assignType_12d6;
	assignType_12d6( ports_12d7, argvars_12d9);
}

void UpdateArgCount_1316::operator()( const Packets_t& inputPorts_1317, const Packets_t& args_131a, const Packets_t& mains_131d, Packets_t& inputPorts_1319, Packets_t& args_131c)
{
#ifdef PRINT_INFO
	printLog("UpdateArgCount_1316" );
#endif
	RTTGenerator::Instance()->generateRule(983, "UpdateArgCount");
	_inputPort_131f= &inputPorts_1319;
	_arg_1320= &args_131c;
	processInputPackets( inputPorts_1317, args_131a, mains_131d);
	forwardInputs( );
}

bool UpdateArgCount_1316::isInputUnique( const Udm::Object& inputPort_1325, const Udm::Object& arg_132e, const Udm::Object& main_1337)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itInputPort_1327= _inputPort_1321.begin(), itArg_1330= _arg_132a.begin(), itMain_1339= _main_1333.begin(); itInputPort_1327!= _inputPort_1321.end(), itArg_1330!= _arg_132a.end(), itMain_1339!= _main_1333.end(); ++itInputPort_1327, ++itArg_1330, ++itMain_1339)
	{
		if( ( *itInputPort_1327== inputPort_1325)&& ( *itArg_1330== arg_132e)&& ( *itMain_1339== main_1337))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_inputPort_1321.push_back( inputPort_1325);
		_arg_132a.push_back( arg_132e);
		_main_1333.push_back( main_1337);
	}
	return isUnique;
}

bool UpdateArgCount_1316::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void UpdateArgCount_1316::processInputPackets( const Packets_t& inputPorts_1317, const Packets_t& args_131a, const Packets_t& mains_131d)
{
	for( Packets_t::const_iterator itInputPort_1322= inputPorts_1317.begin(), itArg_132b= args_131a.begin(), itMain_1334= mains_131d.begin(); itInputPort_1322!= inputPorts_1317.end(), itArg_132b!= args_131a.end(), itMain_1334!= mains_131d.end(); ++itInputPort_1322, ++itArg_132b, ++itMain_1334)
	{
		bool isUnique= isInputUnique( *itInputPort_1322, *itArg_132b, *itMain_1334);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itInputPort_1322, *itArg_132b, *itMain_1334);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool UpdateArgCount_1316::patternMatcher( const Udm::Object& inputPort_1323, const Udm::Object& arg_132c, const Udm::Object& main_1335)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( inputPort_1323.type(), CyPhyML::SignalFlow::InputPort::meta))
			continue;
		CyPhyML::SignalFlow::InputPort inputPort_1328= CyPhyML::SignalFlow::InputPort::Cast( inputPort_1323);
		if( false== Uml::IsDerivedFrom( arg_132c.type(), SFC::Arg::meta))
			continue;
		SFC::Arg arg_1331= SFC::Arg::Cast( arg_132c);
		if( false== Uml::IsDerivedFrom( main_1335.type(), SFC::Function::meta))
			continue;
		SFC::Function main_133a= SFC::Function::Cast( main_1335);
		set< SFC::Arg> args_133c= main_133a.Arg_kind_children();
		for( set< SFC::Arg>::const_iterator itArg_133d= args_133c.begin(); itArg_133d!= args_133c.end(); ++itArg_133d)
		{
			SFC::Arg currArg_133e= *itArg_133d;
			if( arg_1331!= currArg_133e)
				continue;
			set< CyPhyML::SignalFlow::SF_Port> inputPorts_133f= arg_1331.port();
			for( set< CyPhyML::SignalFlow::SF_Port>::const_iterator itInputPorts_1340= inputPorts_133f.begin(); itInputPorts_1340!= inputPorts_133f.end(); ++itInputPorts_1340)
			{
				if( false== Uml::IsDerivedFrom( (*itInputPorts_1340).type(), CyPhyML::SignalFlow::InputPort::meta))
					continue;
				CyPhyML::SignalFlow::InputPort currInputPort_1341= CyPhyML::SignalFlow::InputPort::Cast( *itInputPorts_1340);
				if( inputPort_1328!= currInputPort_1341)
					continue;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_1345;
				if( !isValidBound(boundObjs_1345, inputPort_1328, true))
					continue;
				currMatch.inputPort_1346= inputPort_1328;
				if( !isValidBound(boundObjs_1345, arg_1331, true))
					continue;
				currMatch.arg_1347= arg_1331;
				if( !isValidBound(boundObjs_1345, main_133a, true))
					continue;
				currMatch.main_1348= main_133a;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void UpdateArgCount_1316::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg& Arg= currMatch.arg_1347;
		CyPhyML::SignalFlow::InputPort& InputPort= currMatch.inputPort_1346;
		SFC::Function& Main= currMatch.main_1348;
		{
Main.argCount() = static_cast< __int64 >( Main.argCount() ) + 1;
};
	}
}

void UpdateArgCount_1316::forwardInputs()
{
	*_inputPort_131f= _inputPort_1321;
	*_arg_1320= _arg_132a;
}

void CreateInputPortArgs_1349::operator()( const Packets_t& subsystems_134b, const Packets_t& mains_134e, Packets_t& inputPorts_134a, Packets_t& args_134d, Packets_t& mains_1350)
{
#ifdef PRINT_INFO
	printLog("CreateInputPortArgs_1349" );
#endif
	RTTGenerator::Instance()->generateRule(990, "CreateInputPortArgs");
	_inputPort_1351= &inputPorts_134a;
	_arg_1352= &args_134d;
	_main_1353= &mains_1350;
	processInputPackets( subsystems_134b, mains_134e);
}

bool CreateInputPortArgs_1349::isInputUnique( const Udm::Object& subsystem_1358, const Udm::Object& main_1361)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_135a= _subsystem_1354.begin(), itMain_1363= _main_135d.begin(); itSubsystem_135a!= _subsystem_1354.end(), itMain_1363!= _main_135d.end(); ++itSubsystem_135a, ++itMain_1363)
	{
		if( ( *itSubsystem_135a== subsystem_1358)&& ( *itMain_1363== main_1361))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1354.push_back( subsystem_1358);
		_main_135d.push_back( main_1361);
	}
	return isUnique;
}

bool CreateInputPortArgs_1349::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateInputPortArgs_1349::processInputPackets( const Packets_t& subsystems_134b, const Packets_t& mains_134e)
{
	for( Packets_t::const_iterator itSubsystem_1355= subsystems_134b.begin(), itMain_135e= mains_134e.begin(); itSubsystem_1355!= subsystems_134b.end(), itMain_135e!= mains_134e.end(); ++itSubsystem_1355, ++itMain_135e)
	{
		bool isUnique= isInputUnique( *itSubsystem_1355, *itMain_135e);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1355, *itMain_135e);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateInputPortArgs_1349::patternMatcher( const Udm::Object& subsystem_1356, const Udm::Object& main_135f)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1356.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_135b= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1356);
		if( false== Uml::IsDerivedFrom( main_135f.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1364= SFC::Function::Cast( main_135f);
		set< CyPhyML::SignalFlow::InputPort> inputPorts_1366= subsystem_135b.InputPort_kind_children();
		for( set< CyPhyML::SignalFlow::InputPort>::const_iterator itInputPort_1367= inputPorts_1366.begin(); itInputPort_1367!= inputPorts_1366.end(); ++itInputPort_1367)
		{
			CyPhyML::SignalFlow::InputPort currInputPort_1368= *itInputPort_1367;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_136c;
			if( !isValidBound(boundObjs_136c, subsystem_135b, true))
				continue;
			currMatch.subsystem_136d= subsystem_135b;
			if( !isValidBound(boundObjs_136c, main_1364, true))
				continue;
			currMatch.main_136e= main_1364;
			if( !isValidBound(boundObjs_136c, currInputPort_1368, false))
				continue;
			currMatch.inputPort_136f= currInputPort_1368;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateInputPortArgs_1349::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_1370= SFC::Arg::Create( currMatch.main_136e);
		SFC::Arg& Arg= newArg_1370;
		CyPhyML::SignalFlow::InputPort& InputPort= currMatch.inputPort_136f;
		SFC::Function& Main= currMatch.main_136e;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_136d;
		{
__int64 argIndex = static_cast< __int64 >( Main.argCount() ) + static_cast< __int64 >( InputPort.Number() );
Arg.argIndex() = argIndex;

Arg.name() = static_cast< std::string >( InputPort.name() ) + "_" + boost::lexical_cast< std::string >( argIndex );
Arg.type() = "double";
};
		newArg_1370.port()+= currMatch.inputPort_136f;
		outputAppender( currMatch.inputPort_136f, newArg_1370, currMatch.main_136e);
	}
}

void CreateInputPortArgs_1349::outputAppender( const CyPhyML::SignalFlow::InputPort& inputPort_1371, const SFC::Arg& arg_1373, const SFC::Function& main_1375)
{
	_inputPort_1351->push_back( inputPort_1371);
	_arg_1352->push_back( arg_1373);
	_main_1353->push_back( main_1375);
}

void Trigs_1381::operator()( const Packets_t& systems_1382, const Packets_t& functions_1384, Packets_t& systems_1386, Packets_t& functions_1387)
{
#ifdef PRINT_INFO
	printLog("Trigs_1381" );
#endif
	_system_1388= &systems_1386;
	_function_1389= &functions_1387;
	_system_1388->insert( _system_1388->end(), systems_1382.begin(), systems_1382.end());
	_function_1389->insert( _function_1389->end(), functions_1384.begin(), functions_1384.end());
	if( ( !systems_1382.empty())&& ( !functions_1384.empty()))
		callCreateTriggerPortArgs_13b4( systems_1382, functions_1384);
}

void Trigs_1381::callCreateTriggerPortArgs_13b4( const Packets_t& subsystems_138b, const Packets_t& mains_138f)
{
	Packets_t triggerPorts_138d;
	Packets_t args_138e;
	CreateTriggerPortArgs_138a createTriggerPortArgs_138a;
	createTriggerPortArgs_138a( subsystems_138b, mains_138f, triggerPorts_138d, args_138e);
	if( ( !triggerPorts_138d.empty())&& ( !args_138e.empty()))
		callAssignType_13b7( triggerPorts_138d, args_138e);
}

void Trigs_1381::callAssignType_13b7( const Packets_t& ports_12d7, const Packets_t& argvars_12d9)
{
	AssignType_12d6 assignType_12d6;
	assignType_12d6( ports_12d7, argvars_12d9);
}

void CreateTriggerPortArgs_138a::operator()( const Packets_t& subsystems_138b, const Packets_t& mains_138f, Packets_t& triggerPorts_138d, Packets_t& args_138e)
{
#ifdef PRINT_INFO
	printLog("CreateTriggerPortArgs_138a" );
#endif
	RTTGenerator::Instance()->generateRule(1004, "CreateTriggerPortArgs");
	_triggerPort_1391= &triggerPorts_138d;
	_arg_1392= &args_138e;
	processInputPackets( subsystems_138b, mains_138f);
}

bool CreateTriggerPortArgs_138a::isInputUnique( const Udm::Object& subsystem_1397, const Udm::Object& main_13a0)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1399= _subsystem_1393.begin(), itMain_13a2= _main_139c.begin(); itSubsystem_1399!= _subsystem_1393.end(), itMain_13a2!= _main_139c.end(); ++itSubsystem_1399, ++itMain_13a2)
	{
		if( ( *itSubsystem_1399== subsystem_1397)&& ( *itMain_13a2== main_13a0))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1393.push_back( subsystem_1397);
		_main_139c.push_back( main_13a0);
	}
	return isUnique;
}

bool CreateTriggerPortArgs_138a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateTriggerPortArgs_138a::processInputPackets( const Packets_t& subsystems_138b, const Packets_t& mains_138f)
{
	for( Packets_t::const_iterator itSubsystem_1394= subsystems_138b.begin(), itMain_139d= mains_138f.begin(); itSubsystem_1394!= subsystems_138b.end(), itMain_139d!= mains_138f.end(); ++itSubsystem_1394, ++itMain_139d)
	{
		bool isUnique= isInputUnique( *itSubsystem_1394, *itMain_139d);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1394, *itMain_139d);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateTriggerPortArgs_138a::patternMatcher( const Udm::Object& subsystem_1395, const Udm::Object& main_139e)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1395.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_139a= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1395);
		if( false== Uml::IsDerivedFrom( main_139e.type(), SFC::Function::meta))
			continue;
		SFC::Function main_13a3= SFC::Function::Cast( main_139e);
		set< CyPhyML::SignalFlow::TriggerPort> triggerPorts_13a5= subsystem_139a.TriggerPort_kind_children();
		for( set< CyPhyML::SignalFlow::TriggerPort>::const_iterator itTriggerPort_13a6= triggerPorts_13a5.begin(); itTriggerPort_13a6!= triggerPorts_13a5.end(); ++itTriggerPort_13a6)
		{
			CyPhyML::SignalFlow::TriggerPort currTriggerPort_13a7= *itTriggerPort_13a6;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_13ab;
			if( !isValidBound(boundObjs_13ab, subsystem_139a, true))
				continue;
			currMatch.subsystem_13ac= subsystem_139a;
			if( !isValidBound(boundObjs_13ab, main_13a3, true))
				continue;
			currMatch.main_13ad= main_13a3;
			if( !isValidBound(boundObjs_13ab, currTriggerPort_13a7, false))
				continue;
			currMatch.triggerPort_13ae= currTriggerPort_13a7;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateTriggerPortArgs_138a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_13af= SFC::Arg::Create( currMatch.main_13ad);
		SFC::Arg& Arg= newArg_13af;
		SFC::Function& Main= currMatch.main_13ad;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_13ac;
		CyPhyML::SignalFlow::TriggerPort& TriggerPort= currMatch.triggerPort_13ae;
		{
__int64 argCount = Main.argCount();
Arg.argIndex() = argCount++;
Main.argCount() = argCount;

Arg.name() = static_cast< std::string >( TriggerPort.name() ) + "_" + boost::lexical_cast< std::string >( argCount - 1 );
Arg.type() = "double";
};
		newArg_13af.port()+= currMatch.triggerPort_13ae;
		outputAppender( currMatch.triggerPort_13ae, newArg_13af);
	}
}

void CreateTriggerPortArgs_138a::outputAppender( const CyPhyML::SignalFlow::TriggerPort& triggerPort_13b0, const SFC::Arg& arg_13b2)
{
	_triggerPort_1391->push_back( triggerPort_13b0);
	_arg_1392->push_back( arg_13b2);
}

void ZeroUnconOutputs_13ba::operator()( const Packets_t& systems_13bb, const Packets_t& functions_13bd, Packets_t& systems_13bf)
{
#ifdef PRINT_INFO
	printLog("ZeroUnconOutputs_13ba" );
#endif
	_system_13c0= &systems_13bf;
	_system_13c0->insert( _system_13c0->end(), systems_13bb.begin(), systems_13bb.end());
	if( ( !systems_13bb.empty())&& ( !functions_13bd.empty()))
		callGetOutputPorts_14a6( systems_13bb, functions_13bd);
}

void ZeroUnconOutputs_13ba::callGetOutputPorts_14a6( const Packets_t& subsystems_145d, const Packets_t& mains_1460)
{
	Packets_t outPorts_145f;
	Packets_t mains_1462;
	GetOutputPorts_145c getOutputPorts_145c;
	getOutputPorts_145c( subsystems_145d, mains_1460, outPorts_145f, mains_1462);
	if( ( !outPorts_145f.empty())&& ( !mains_1462.empty()))
		callOutPortConnected_14a9( outPorts_145f, mains_1462);
}

void ZeroUnconOutputs_13ba::callOutPortConnected_14a9( const Packets_t& outps_13c2, const Packets_t& functions_13c4)
{
	Packets_t outps_13c6;
	Packets_t functions_13c7;
	Packets_t outps_13c8;
	Packets_t functions_13c9;
	Packets_t outps_13ca;
	Packets_t functions_13cb;
	OutPortConnected_13c1 outPortConnected_13c1;
	outPortConnected_13c1( outps_13c2, functions_13c4, outps_13c6, functions_13c7, outps_13c8, functions_13c9, outps_13ca, functions_13cb);
	if( ( !outps_13ca.empty())&& ( !functions_13cb.empty()))
		callZeroOutPort_14ac( outps_13ca, functions_13cb);
}

void ZeroUnconOutputs_13ba::callZeroOutPort_14ac( const Packets_t& outPorts_1486, const Packets_t& mains_1488)
{
	ZeroOutPort_1485 zeroOutPort_1485;
	zeroOutPort_1485( outPorts_1486, mains_1488);
}

void OutPortConnected_13c1::operator()( const Packets_t& outps_13c2, const Packets_t& functions_13c4, Packets_t& outps_13c6, Packets_t& functions_13c7, Packets_t& outps_13c8, Packets_t& functions_13c9, Packets_t& outps_13ca, Packets_t& functions_13cb)
{
#ifdef PRINT_INFO
	printLog("OutPortConnected_13c1" );
#endif
	_outp_13cc= &outps_13c6;
	_function_13cd= &functions_13c7;
	_outp_13ce= &outps_13c8;
	_function_13cf= &functions_13c9;
	_outp_13d0= &outps_13ca;
	_function_13d1= &functions_13cb;
	for( Packets_t::const_iterator itoutp_13d3= outps_13c2.begin(), itfunction_13da= functions_13c4.begin(); itoutp_13d3!= outps_13c2.end(), itfunction_13da!= functions_13c4.end(); ++itoutp_13d3, ++itfunction_13da)
	{
		bool isUnique= isInputUnique( *itoutp_13d3, *itfunction_13da);
		if( !isUnique)
			continue;
		Packets_t oneoutp_13d7( 1, *itoutp_13d3);
		Packets_t onefunction_13de( 1, *itfunction_13da);
		executeOne( oneoutp_13d7, onefunction_13de);
	}
}

void OutPortConnected_13c1::executeOne( const Packets_t& outps_13c2, const Packets_t& functions_13c4)
{
	Packets_t outPorts_13e3;
	Packets_t mains_13e6;
	Connected_line_13e0 connected_line_13e0;
	bool isMatchConnected_line_13e0= connected_line_13e0( outps_13c2, functions_13c4, outPorts_13e3, mains_13e6);
	_outp_13cc->insert( _outp_13cc->end(), outPorts_13e3.begin(), outPorts_13e3.end());
	_function_13cd->insert( _function_13cd->end(), mains_13e6.begin(), mains_13e6.end());
	if( isMatchConnected_line_13e0)
		return;
	Packets_t outPorts_140e;
	Packets_t mains_1411;
	Connected_ConnToSFStates_140b connected_ConnToSFStates_140b;
	bool isMatchConnected_ConnToSFStates_140b= connected_ConnToSFStates_140b( outps_13c2, functions_13c4, outPorts_140e, mains_1411);
	_outp_13ce->insert( _outp_13ce->end(), outPorts_140e.begin(), outPorts_140e.end());
	_function_13cf->insert( _function_13cf->end(), mains_1411.begin(), mains_1411.end());
	if( isMatchConnected_ConnToSFStates_140b)
		return;
	Packets_t outPorts_143a;
	Packets_t mains_143d;
	Otherwise_1437 otherwise_1437;
	bool isMatchOtherwise_1437= otherwise_1437( outps_13c2, functions_13c4, outPorts_143a, mains_143d);
	_outp_13d0->insert( _outp_13d0->end(), outPorts_143a.begin(), outPorts_143a.end());
	_function_13d1->insert( _function_13d1->end(), mains_143d.begin(), mains_143d.end());
	if( isMatchOtherwise_1437)
		return;
}

bool OutPortConnected_13c1::isInputUnique( const Udm::Object& outp_13d4, const Udm::Object& function_13db)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itoutp_13d6= _outp_13d2.begin(), itfunction_13dd= _function_13d9.begin(); itoutp_13d6!= _outp_13d2.end(), itfunction_13dd!= _function_13d9.end(); ++itoutp_13d6, ++itfunction_13dd)
	{
		if( ( *itoutp_13d6== outp_13d4)&& ( *itfunction_13dd== function_13db))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_outp_13d2.push_back( outp_13d4);
		_function_13d9.push_back( function_13db);
	}
	return isUnique;
}

bool Connected_line_13e0::operator()( const Packets_t& outPorts_13e1, const Packets_t& mains_13e4, Packets_t& outPorts_13e3, Packets_t& mains_13e6)
{
#ifdef PRINT_INFO
	printLog("Connected_line_13e0" );
#endif
	_outPort_13e7= &outPorts_13e3;
	_main_13e8= &mains_13e6;
	processInputPackets( outPorts_13e1, mains_13e4);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Connected_line_13e0::isInputUnique( const Udm::Object& outPort_13ed, const Udm::Object& main_13f6)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itOutPort_13ef= _outPort_13e9.begin(), itMain_13f8= _main_13f2.begin(); itOutPort_13ef!= _outPort_13e9.end(), itMain_13f8!= _main_13f2.end(); ++itOutPort_13ef, ++itMain_13f8)
	{
		if( ( *itOutPort_13ef== outPort_13ed)&& ( *itMain_13f8== main_13f6))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_outPort_13e9.push_back( outPort_13ed);
		_main_13f2.push_back( main_13f6);
	}
	return isUnique;
}

bool Connected_line_13e0::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Connected_line_13e0::processInputPackets( const Packets_t& outPorts_13e1, const Packets_t& mains_13e4)
{
	for( Packets_t::const_iterator itOutPort_13ea= outPorts_13e1.begin(), itMain_13f3= mains_13e4.begin(); itOutPort_13ea!= outPorts_13e1.end(), itMain_13f3!= mains_13e4.end(); ++itOutPort_13ea, ++itMain_13f3)
	{
		bool isUnique= isInputUnique( *itOutPort_13ea, *itMain_13f3);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itOutPort_13ea, *itMain_13f3);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.outPort_1403, currMatch.main_1404);
	}
}

bool Connected_line_13e0::patternMatcher( const Udm::Object& outPort_13eb, const Udm::Object& main_13f4)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( outPort_13eb.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort outPort_13f0= CyPhyML::SignalFlow::OutPort::Cast( outPort_13eb);
		if( false== Uml::IsDerivedFrom( main_13f4.type(), SFC::Function::meta))
			continue;
		SFC::Function main_13f9= SFC::Function::Cast( main_13f4);
		set< CyPhyML::SignalFlow::Line> lines_13fb= outPort_13f0.srcLine();
		for( set< CyPhyML::SignalFlow::Line>::const_iterator itLines_13fc= lines_13fb.begin(); itLines_13fc!= lines_13fb.end(); ++itLines_13fc)
		{
			CyPhyML::SignalFlow::Line currLine_13fd= *itLines_13fc;
			CyPhyML::SignalFlow::SF_Port port_13fe= currLine_13fd.srcLine_end();
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1402;
			if( !isValidBound(boundObjs_1402, outPort_13f0, true))
				continue;
			currMatch.outPort_1403= outPort_13f0;
			if( !isValidBound(boundObjs_1402, main_13f9, true))
				continue;
			currMatch.main_1404= main_13f9;
			if( !isValidBound(boundObjs_1402, currLine_13fd, false))
				continue;
			currMatch.line_1405= currLine_13fd;
			if( !isValidBound(boundObjs_1402, port_13fe, false))
				continue;
			currMatch.port_1406= port_13fe;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void Connected_line_13e0::outputAppender( const CyPhyML::SignalFlow::OutPort& outPort_1407, const SFC::Function& main_1409)
{
	_outPort_13e7->push_back( outPort_1407);
	_main_13e8->push_back( main_1409);
}

bool Connected_ConnToSFStates_140b::operator()( const Packets_t& outPorts_140c, const Packets_t& mains_140f, Packets_t& outPorts_140e, Packets_t& mains_1411)
{
#ifdef PRINT_INFO
	printLog("Connected_ConnToSFStates_140b" );
#endif
	_outPort_1412= &outPorts_140e;
	_main_1413= &mains_1411;
	processInputPackets( outPorts_140c, mains_140f);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Connected_ConnToSFStates_140b::isInputUnique( const Udm::Object& outPort_1418, const Udm::Object& main_1421)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itOutPort_141a= _outPort_1414.begin(), itMain_1423= _main_141d.begin(); itOutPort_141a!= _outPort_1414.end(), itMain_1423!= _main_141d.end(); ++itOutPort_141a, ++itMain_1423)
	{
		if( ( *itOutPort_141a== outPort_1418)&& ( *itMain_1423== main_1421))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_outPort_1414.push_back( outPort_1418);
		_main_141d.push_back( main_1421);
	}
	return isUnique;
}

bool Connected_ConnToSFStates_140b::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Connected_ConnToSFStates_140b::processInputPackets( const Packets_t& outPorts_140c, const Packets_t& mains_140f)
{
	for( Packets_t::const_iterator itOutPort_1415= outPorts_140c.begin(), itMain_141e= mains_140f.begin(); itOutPort_1415!= outPorts_140c.end(), itMain_141e!= mains_140f.end(); ++itOutPort_1415, ++itMain_141e)
	{
		bool isUnique= isInputUnique( *itOutPort_1415, *itMain_141e);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itOutPort_1415, *itMain_141e);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.outPort_142f, currMatch.main_1430);
	}
}

bool Connected_ConnToSFStates_140b::patternMatcher( const Udm::Object& outPort_1416, const Udm::Object& main_141f)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( outPort_1416.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort outPort_141b= CyPhyML::SignalFlow::OutPort::Cast( outPort_1416);
		if( false== Uml::IsDerivedFrom( main_141f.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1424= SFC::Function::Cast( main_141f);
		set< CyPhyML::SignalFlow::ConnToSFStates> connToSFStatess_1426= outPort_141b.srcConnToSFStates();
		for( set< CyPhyML::SignalFlow::ConnToSFStates>::const_iterator itConnToSFStatess_1427= connToSFStatess_1426.begin(); itConnToSFStatess_1427!= connToSFStatess_1426.end(); ++itConnToSFStatess_1427)
		{
			CyPhyML::SignalFlow::ConnToSFStates currConnToSFStates_1428= *itConnToSFStatess_1427;
			CyPhyML::ConnToSFStates_Members_Base sFStateDE_1429= currConnToSFStates_1428.srcConnToSFStates_end();
			if( false== Uml::IsDerivedFrom( sFStateDE_1429.type(), CyPhyML::SignalFlow::SFStateDE::meta))
				continue;
			CyPhyML::SignalFlow::SFStateDE currSFStateDE_142a= CyPhyML::SignalFlow::SFStateDE::Cast( sFStateDE_1429);
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_142e;
			if( !isValidBound(boundObjs_142e, outPort_141b, true))
				continue;
			currMatch.outPort_142f= outPort_141b;
			if( !isValidBound(boundObjs_142e, main_1424, true))
				continue;
			currMatch.main_1430= main_1424;
			if( !isValidBound(boundObjs_142e, currConnToSFStates_1428, false))
				continue;
			currMatch.connToSFStates_1431= currConnToSFStates_1428;
			if( !isValidBound(boundObjs_142e, currSFStateDE_142a, false))
				continue;
			currMatch.sFStateDE_1432= currSFStateDE_142a;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void Connected_ConnToSFStates_140b::outputAppender( const CyPhyML::SignalFlow::OutPort& outPort_1433, const SFC::Function& main_1435)
{
	_outPort_1412->push_back( outPort_1433);
	_main_1413->push_back( main_1435);
}

bool Otherwise_1437::operator()( const Packets_t& outPorts_1438, const Packets_t& mains_143b, Packets_t& outPorts_143a, Packets_t& mains_143d)
{
#ifdef PRINT_INFO
	printLog("Otherwise_1437" );
#endif
	_outPort_143e= &outPorts_143a;
	_main_143f= &mains_143d;
	processInputPackets( outPorts_1438, mains_143b);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_1437::isInputUnique( const Udm::Object& outPort_1444, const Udm::Object& main_144d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itOutPort_1446= _outPort_1440.begin(), itMain_144f= _main_1449.begin(); itOutPort_1446!= _outPort_1440.end(), itMain_144f!= _main_1449.end(); ++itOutPort_1446, ++itMain_144f)
	{
		if( ( *itOutPort_1446== outPort_1444)&& ( *itMain_144f== main_144d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_outPort_1440.push_back( outPort_1444);
		_main_1449.push_back( main_144d);
	}
	return isUnique;
}

bool Otherwise_1437::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_1437::processInputPackets( const Packets_t& outPorts_1438, const Packets_t& mains_143b)
{
	for( Packets_t::const_iterator itOutPort_1441= outPorts_1438.begin(), itMain_144a= mains_143b.begin(); itOutPort_1441!= outPorts_1438.end(), itMain_144a!= mains_143b.end(); ++itOutPort_1441, ++itMain_144a)
	{
		bool isUnique= isInputUnique( *itOutPort_1441, *itMain_144a);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itOutPort_1441, *itMain_144a);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.outPort_1456, currMatch.main_1457);
	}
}

bool Otherwise_1437::patternMatcher( const Udm::Object& outPort_1442, const Udm::Object& main_144b)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( outPort_1442.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort outPort_1447= CyPhyML::SignalFlow::OutPort::Cast( outPort_1442);
		if( false== Uml::IsDerivedFrom( main_144b.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1450= SFC::Function::Cast( main_144b);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1455;
		if( !isValidBound(boundObjs_1455, outPort_1447, true))
			continue;
		currMatch.outPort_1456= outPort_1447;
		if( !isValidBound(boundObjs_1455, main_1450, true))
			continue;
		currMatch.main_1457= main_1450;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_1437::outputAppender( const CyPhyML::SignalFlow::OutPort& outPort_1458, const SFC::Function& main_145a)
{
	_outPort_143e->push_back( outPort_1458);
	_main_143f->push_back( main_145a);
}

void GetOutputPorts_145c::operator()( const Packets_t& subsystems_145d, const Packets_t& mains_1460, Packets_t& outPorts_145f, Packets_t& mains_1462)
{
#ifdef PRINT_INFO
	printLog("GetOutputPorts_145c" );
#endif
	RTTGenerator::Instance()->generateRule(1043, "GetOutputPorts");
	_outPort_1463= &outPorts_145f;
	_main_1464= &mains_1462;
	processInputPackets( subsystems_145d, mains_1460);
}

bool GetOutputPorts_145c::isInputUnique( const Udm::Object& subsystem_1469, const Udm::Object& main_1472)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_146b= _subsystem_1465.begin(), itMain_1474= _main_146e.begin(); itSubsystem_146b!= _subsystem_1465.end(), itMain_1474!= _main_146e.end(); ++itSubsystem_146b, ++itMain_1474)
	{
		if( ( *itSubsystem_146b== subsystem_1469)&& ( *itMain_1474== main_1472))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1465.push_back( subsystem_1469);
		_main_146e.push_back( main_1472);
	}
	return isUnique;
}

bool GetOutputPorts_145c::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetOutputPorts_145c::processInputPackets( const Packets_t& subsystems_145d, const Packets_t& mains_1460)
{
	for( Packets_t::const_iterator itSubsystem_1466= subsystems_145d.begin(), itMain_146f= mains_1460.begin(); itSubsystem_1466!= subsystems_145d.end(), itMain_146f!= mains_1460.end(); ++itSubsystem_1466, ++itMain_146f)
	{
		bool isUnique= isInputUnique( *itSubsystem_1466, *itMain_146f);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1466, *itMain_146f);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetOutputPorts_145c::patternMatcher( const Udm::Object& subsystem_1467, const Udm::Object& main_1470)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1467.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_146c= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1467);
		if( false== Uml::IsDerivedFrom( main_1470.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1475= SFC::Function::Cast( main_1470);
		set< CyPhyML::SignalFlow::OutPort> outPorts_1477= subsystem_146c.OutPort_kind_children();
		for( set< CyPhyML::SignalFlow::OutPort>::const_iterator itOutPort_1478= outPorts_1477.begin(); itOutPort_1478!= outPorts_1477.end(); ++itOutPort_1478)
		{
			CyPhyML::SignalFlow::OutPort currOutPort_1479= *itOutPort_1478;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_147d;
			if( !isValidBound(boundObjs_147d, subsystem_146c, true))
				continue;
			currMatch.subsystem_147e= subsystem_146c;
			if( !isValidBound(boundObjs_147d, main_1475, true))
				continue;
			currMatch.main_147f= main_1475;
			if( !isValidBound(boundObjs_147d, currOutPort_1479, false))
				continue;
			currMatch.outPort_1480= currOutPort_1479;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetOutputPorts_145c::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.outPort_1480, currMatch.main_147f);
	}
}

void GetOutputPorts_145c::outputAppender( const CyPhyML::SignalFlow::OutPort& outPort_1481, const SFC::Function& main_1483)
{
	_outPort_1463->push_back( outPort_1481);
	_main_1464->push_back( main_1483);
}

void ZeroOutPort_1485::operator()( const Packets_t& outPorts_1486, const Packets_t& mains_1488)
{
#ifdef PRINT_INFO
	printLog("ZeroOutPort_1485" );
#endif
	RTTGenerator::Instance()->generateRule(1048, "ZeroOutPort");
	processInputPackets( outPorts_1486, mains_1488);
}

bool ZeroOutPort_1485::isInputUnique( const Udm::Object& outPort_148e, const Udm::Object& main_1497)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itOutPort_1490= _outPort_148a.begin(), itMain_1499= _main_1493.begin(); itOutPort_1490!= _outPort_148a.end(), itMain_1499!= _main_1493.end(); ++itOutPort_1490, ++itMain_1499)
	{
		if( ( *itOutPort_1490== outPort_148e)&& ( *itMain_1499== main_1497))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_outPort_148a.push_back( outPort_148e);
		_main_1493.push_back( main_1497);
	}
	return isUnique;
}

bool ZeroOutPort_1485::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void ZeroOutPort_1485::processInputPackets( const Packets_t& outPorts_1486, const Packets_t& mains_1488)
{
	for( Packets_t::const_iterator itOutPort_148b= outPorts_1486.begin(), itMain_1494= mains_1488.begin(); itOutPort_148b!= outPorts_1486.end(), itMain_1494!= mains_1488.end(); ++itOutPort_148b, ++itMain_1494)
	{
		bool isUnique= isInputUnique( *itOutPort_148b, *itMain_1494);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itOutPort_148b, *itMain_1494);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ZeroOutPort_1485::patternMatcher( const Udm::Object& outPort_148c, const Udm::Object& main_1495)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( outPort_148c.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort outPort_1491= CyPhyML::SignalFlow::OutPort::Cast( outPort_148c);
		if( false== Uml::IsDerivedFrom( main_1495.type(), SFC::Function::meta))
			continue;
		SFC::Function main_149a= SFC::Function::Cast( main_1495);
		set< SFC::Arg> args_149c= outPort_1491.arg();
		for( set< SFC::Arg>::const_iterator itArgs_149d= args_149c.begin(); itArgs_149d!= args_149c.end(); ++itArgs_149d)
		{
			SFC::Arg currArg_149e= *itArgs_149d;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_14a2;
			if( !isValidBound(boundObjs_14a2, outPort_1491, true))
				continue;
			currMatch.outPort_14a3= outPort_1491;
			if( !isValidBound(boundObjs_14a2, main_149a, true))
				continue;
			currMatch.main_14a4= main_149a;
			if( !isValidBound(boundObjs_14a2, currArg_149e, false))
				continue;
			currMatch.arg_14a5= currArg_149e;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void ZeroOutPort_1485::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg& Arg= currMatch.arg_14a5;
		SFC::Function& Main= currMatch.main_14a4;
		CyPhyML::SignalFlow::OutPort& OutPort= currMatch.outPort_14a3;
		{
SFUtils::ZeroInit( Main, Arg );
};
	}
}

void Actions_14af::operator()( const Packets_t& systems_14b0, const Packets_t& functions_14b2, Packets_t& systems_14b4, Packets_t& functions_14b5)
{
#ifdef PRINT_INFO
	printLog("Actions_14af" );
#endif
	_system_14b6= &systems_14b4;
	_function_14b7= &functions_14b5;
	if( ( !systems_14b0.empty())&& ( !functions_14b2.empty()))
		callCreateTriggerPortArgs_14e2( systems_14b0, functions_14b2);
	_system_14b6->insert( _system_14b6->end(), systems_14b0.begin(), systems_14b0.end());
	_function_14b7->insert( _function_14b7->end(), functions_14b2.begin(), functions_14b2.end());
}

void Actions_14af::callCreateTriggerPortArgs_14e2( const Packets_t& subsystems_14b9, const Packets_t& mains_14bd)
{
	Packets_t actionPorts_14bb;
	Packets_t args_14bc;
	CreateTriggerPortArgs_14b8 createTriggerPortArgs_14b8;
	createTriggerPortArgs_14b8( subsystems_14b9, mains_14bd, actionPorts_14bb, args_14bc);
	if( ( !actionPorts_14bb.empty())&& ( !args_14bc.empty()))
		callAssignType_14e5( actionPorts_14bb, args_14bc);
}

void Actions_14af::callAssignType_14e5( const Packets_t& ports_12d7, const Packets_t& argvars_12d9)
{
	AssignType_12d6 assignType_12d6;
	assignType_12d6( ports_12d7, argvars_12d9);
}

void CreateTriggerPortArgs_14b8::operator()( const Packets_t& subsystems_14b9, const Packets_t& mains_14bd, Packets_t& actionPorts_14bb, Packets_t& args_14bc)
{
#ifdef PRINT_INFO
	printLog("CreateTriggerPortArgs_14b8" );
#endif
	RTTGenerator::Instance()->generateRule(1059, "CreateTriggerPortArgs");
	_actionPort_14bf= &actionPorts_14bb;
	_arg_14c0= &args_14bc;
	processInputPackets( subsystems_14b9, mains_14bd);
}

bool CreateTriggerPortArgs_14b8::isInputUnique( const Udm::Object& subsystem_14c5, const Udm::Object& main_14ce)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_14c7= _subsystem_14c1.begin(), itMain_14d0= _main_14ca.begin(); itSubsystem_14c7!= _subsystem_14c1.end(), itMain_14d0!= _main_14ca.end(); ++itSubsystem_14c7, ++itMain_14d0)
	{
		if( ( *itSubsystem_14c7== subsystem_14c5)&& ( *itMain_14d0== main_14ce))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_14c1.push_back( subsystem_14c5);
		_main_14ca.push_back( main_14ce);
	}
	return isUnique;
}

bool CreateTriggerPortArgs_14b8::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateTriggerPortArgs_14b8::processInputPackets( const Packets_t& subsystems_14b9, const Packets_t& mains_14bd)
{
	for( Packets_t::const_iterator itSubsystem_14c2= subsystems_14b9.begin(), itMain_14cb= mains_14bd.begin(); itSubsystem_14c2!= subsystems_14b9.end(), itMain_14cb!= mains_14bd.end(); ++itSubsystem_14c2, ++itMain_14cb)
	{
		bool isUnique= isInputUnique( *itSubsystem_14c2, *itMain_14cb);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_14c2, *itMain_14cb);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateTriggerPortArgs_14b8::patternMatcher( const Udm::Object& subsystem_14c3, const Udm::Object& main_14cc)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_14c3.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_14c8= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_14c3);
		if( false== Uml::IsDerivedFrom( main_14cc.type(), SFC::Function::meta))
			continue;
		SFC::Function main_14d1= SFC::Function::Cast( main_14cc);
		set< CyPhyML::SignalFlow::EnablePort> actionPorts_14d3= subsystem_14c8.EnablePort_kind_children();
		for( set< CyPhyML::SignalFlow::EnablePort>::const_iterator itActionPort_14d4= actionPorts_14d3.begin(); itActionPort_14d4!= actionPorts_14d3.end(); ++itActionPort_14d4)
		{
			CyPhyML::SignalFlow::EnablePort currActionPort_14d5= *itActionPort_14d4;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_14d9;
			if( !isValidBound(boundObjs_14d9, subsystem_14c8, true))
				continue;
			currMatch.subsystem_14da= subsystem_14c8;
			if( !isValidBound(boundObjs_14d9, main_14d1, true))
				continue;
			currMatch.main_14db= main_14d1;
			if( !isValidBound(boundObjs_14d9, currActionPort_14d5, false))
				continue;
			currMatch.actionPort_14dc= currActionPort_14d5;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateTriggerPortArgs_14b8::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_14dd= SFC::Arg::Create( currMatch.main_14db);
		CyPhyML::SignalFlow::EnablePort& ActionPort= currMatch.actionPort_14dc;
		SFC::Arg& Arg= newArg_14dd;
		SFC::Function& Main= currMatch.main_14db;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_14da;
		{
__int64 argCount = Main.argCount();
Arg.argIndex() = argCount++;
Main.argCount() = argCount;

Arg.name() = "action_" + boost::lexical_cast< std::string >( argCount - 1 );
Arg.type() = "int";
};
		newArg_14dd.port()+= currMatch.actionPort_14dc;
		outputAppender( currMatch.actionPort_14dc, newArg_14dd);
	}
}

void CreateTriggerPortArgs_14b8::outputAppender( const CyPhyML::SignalFlow::EnablePort& actionPort_14de, const SFC::Arg& arg_14e0)
{
	_actionPort_14bf->push_back( actionPort_14de);
	_arg_14c0->push_back( arg_14e0);
}

void CreateFunctions_14f7::operator()( const Packets_t& subsystems_14f8, Packets_t& subsystems_14fa, Packets_t& mains_14fb)
{
#ifdef PRINT_INFO
	printLog("CreateFunctions_14f7" );
#endif
	RTTGenerator::Instance()->generateRule(1068, "CreateFunctions");
	_subsystem_14fc= &subsystems_14fa;
	_main_14fd= &mains_14fb;
	processInputPackets( subsystems_14f8);
}

bool CreateFunctions_14f7::isInputUnique( const Udm::Object& subsystem_1502)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1504= _subsystem_14fe.begin(); itSubsystem_1504!= _subsystem_14fe.end(); ++itSubsystem_1504)
	{
		if( ( *itSubsystem_1504== subsystem_1502))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_subsystem_14fe.push_back( subsystem_1502);
	return isUnique;
}

bool CreateFunctions_14f7::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateFunctions_14f7::processInputPackets( const Packets_t& subsystems_14f8)
{
	for( Packets_t::const_iterator itSubsystem_14ff= subsystems_14f8.begin(); itSubsystem_14ff!= subsystems_14f8.end(); ++itSubsystem_14ff)
	{
		bool isUnique= isInputUnique( *itSubsystem_14ff);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_14ff);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateFunctions_14f7::patternMatcher( const Udm::Object& subsystem_1500)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1500.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1505= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1500);
		SFC::Class class_1507= subsystem_1505.cls();
		if( !class_1507)
			continue;
		set< SFC::Struct> structs_1508= class_1507.Struct_kind_children();
		for( set< SFC::Struct>::const_iterator itStruct_1509= structs_1508.begin(); itStruct_1509!= structs_1508.end(); ++itStruct_1509)
		{
			SFC::Struct currStruct_150a= *itStruct_1509;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_150e;
			if( !isValidBound(boundObjs_150e, subsystem_1505, true))
				continue;
			currMatch.subsystem_150f= subsystem_1505;
			if( !isValidBound(boundObjs_150e, class_1507, false))
				continue;
			currMatch.class_1510= class_1507;
			if( !isValidBound(boundObjs_150e, currStruct_150a, false))
				continue;
			currMatch.struct_1511= currStruct_150a;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateFunctions_14f7::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function newMain_1512= SFC::Function::Create( currMatch.class_1510, SFC::Class::meta_stmnt);
		SFC::Arg newArg_1513= SFC::Arg::Create( newMain_1512);
		SFC::Arg& Arg= newArg_1513;
		SFC::Class& Class= currMatch.class_1510;
		SFC::Function& Main= newMain_1512;
		SFC::Struct& Struct= currMatch.struct_1511;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_150f;
		{
__int64 argCount = Main.argCount();
Arg.argIndex() = argCount++;
Main.argCount() = argCount;

Arg.name() = "context";
Arg.ptr() = true;
};
		{
__int64 statementCount = Class.statementCount();
Main.statementIndex() = statementCount++;
Class.statementCount() = statementCount;
};
		{
Main.name() = static_cast< std::string >( Subsystem.name() ) + "_" + boost::lexical_cast< std::string >( Subsystem.uniqueId() ) + "_main";
};
		newArg_1513.dt()= currMatch.struct_1511;
		newMain_1512.sysmain()+= currMatch.subsystem_150f;
		outputAppender( currMatch.subsystem_150f, newMain_1512);
	}
}

void CreateFunctions_14f7::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1514, const SFC::Function& main_1516)
{
	_subsystem_14fc->push_back( subsystem_1514);
	_main_14fd->push_back( main_1516);
}

void MakeSFChartArguments_1518::operator()( const Packets_t& states_1519, const Packets_t& functions_151b)
{
#ifdef PRINT_INFO
	printLog("MakeSFChartArguments_1518" );
#endif
	if( ( !states_1519.empty())&& ( !functions_151b.empty()))
		callDataInput_1656( states_1519, functions_151b);
}

void MakeSFChartArguments_1518::callDataInput_1656( const Packets_t& states_15c9, const Packets_t& functions_15cb)
{
	Packets_t states_15cd;
	Packets_t functions_15ce;
	DataInput_15c8 dataInput_15c8;
	dataInput_15c8( states_15c9, functions_15cb, states_15cd, functions_15ce);
	if( ( !states_15cd.empty())&& ( !functions_15ce.empty()))
		callEventInput_1659( states_15cd, functions_15ce);
}

void MakeSFChartArguments_1518::callEventInput_1659( const Packets_t& states_151e, const Packets_t& functions_1520)
{
	Packets_t states_1522;
	Packets_t functions_1523;
	EventInput_151d eventInput_151d;
	eventInput_151d( states_151e, functions_1520, states_1522, functions_1523);
	if( ( !states_1522.empty())&& ( !functions_1523.empty()))
		callDataOutput_165c( states_1522, functions_1523);
}

void MakeSFChartArguments_1518::callDataOutput_165c( const Packets_t& states_1610, const Packets_t& functions_1612)
{
	Packets_t states_1614;
	Packets_t functions_1615;
	DataOutput_160f dataOutput_160f;
	dataOutput_160f( states_1610, functions_1612, states_1614, functions_1615);
	if( ( !states_1614.empty())&& ( !functions_1615.empty()))
		callEventOutput_165f( states_1614, functions_1615);
}

void MakeSFChartArguments_1518::callEventOutput_165f( const Packets_t& states_1585, const Packets_t& functions_1587)
{
	EventOutput_1584 eventOutput_1584;
	eventOutput_1584( states_1585, functions_1587);
}

void EventInput_151d::operator()( const Packets_t& states_151e, const Packets_t& functions_1520, Packets_t& states_1522, Packets_t& functions_1523)
{
#ifdef PRINT_INFO
	printLog("EventInput_151d" );
#endif
	_state_1524= &states_1522;
	_function_1525= &functions_1523;
	_state_1524->insert( _state_1524->end(), states_151e.begin(), states_151e.end());
	_function_1525->insert( _function_1525->end(), functions_1520.begin(), functions_1520.end());
	if( ( !states_151e.empty())&& ( !functions_1520.empty()))
		callEventInput_157e( states_151e, functions_1520);
}

void EventInput_151d::callEventInput_157e( const Packets_t& states_1527, const Packets_t& mains_152a)
{
	Packets_t args_1529;
	Packets_t mains_152c;
	EventInput_1526 eventInput_1526;
	eventInput_1526( states_1527, mains_152a, args_1529, mains_152c);
	if( ( !args_1529.empty())&& ( !mains_152c.empty()))
		callUpdateArgCount_1581( args_1529, mains_152c);
}

void EventInput_151d::callUpdateArgCount_1581( const Packets_t& args_155f, const Packets_t& mains_1561)
{
	UpdateArgCount_155e updateArgCount_155e;
	updateArgCount_155e( args_155f, mains_1561);
}

void EventInput_1526::operator()( const Packets_t& states_1527, const Packets_t& mains_152a, Packets_t& args_1529, Packets_t& mains_152c)
{
#ifdef PRINT_INFO
	printLog("EventInput_1526" );
#endif
	RTTGenerator::Instance()->generateRule(1091, "EventInput");
	_arg_152d= &args_1529;
	_main_152e= &mains_152c;
	processInputPackets( states_1527, mains_152a);
}

bool EventInput_1526::isInputUnique( const Udm::Object& state_1533, const Udm::Object& main_153c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1535= _state_152f.begin(), itMain_153e= _main_1538.begin(); itState_1535!= _state_152f.end(), itMain_153e!= _main_1538.end(); ++itState_1535, ++itMain_153e)
	{
		if( ( *itState_1535== state_1533)&& ( *itMain_153e== main_153c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_152f.push_back( state_1533);
		_main_1538.push_back( main_153c);
	}
	return isUnique;
}

bool EventInput_1526::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool EventInput_1526::isGuardTrue( SFC::DT& DT, CyPhyML::SignalFlow::SFEvent& Event, SFC::Function& Main, CyPhyML::SignalFlow::SFState& State, CyPhyML::SignalFlow::SF_TypeBase& TypeBase, CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Event.Scope() ) == "INPUT_EVENT";;
	return Gz_guard;
}

void EventInput_1526::processInputPackets( const Packets_t& states_1527, const Packets_t& mains_152a)
{
	for( Packets_t::const_iterator itState_1530= states_1527.begin(), itMain_1539= mains_152a.begin(); itState_1530!= states_1527.end(), itMain_1539!= mains_152a.end(); ++itState_1530, ++itMain_1539)
	{
		bool isUnique= isInputUnique( *itState_1530, *itMain_1539);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1530, *itMain_1539);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool EventInput_1526::patternMatcher( const Udm::Object& state_1531, const Udm::Object& main_153a)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1531.type(), CyPhyML::SignalFlow::SFState::meta))
			continue;
		CyPhyML::SignalFlow::SFState state_1536= CyPhyML::SignalFlow::SFState::Cast( state_1531);
		if( false== Uml::IsDerivedFrom( main_153a.type(), SFC::Function::meta))
			continue;
		SFC::Function main_153f= SFC::Function::Cast( main_153a);
		set< CyPhyML::SignalFlow::SFEvent> events_1541= state_1536.SFEvent_kind_children();
		for( set< CyPhyML::SignalFlow::SFEvent>::const_iterator itEvent_1542= events_1541.begin(); itEvent_1542!= events_1541.end(); ++itEvent_1542)
		{
			CyPhyML::SignalFlow::SFEvent currEvent_1543= *itEvent_1542;
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_1544= currEvent_1543.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_1545= typeBaseRefs_1544.begin(); itTypeBaseRef_1545!= typeBaseRefs_1544.end(); ++itTypeBaseRef_1545)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_1546= *itTypeBaseRef_1545;
				CyPhyML::SignalFlow::SF_TypeBase typeBase_1547= currTypeBaseRef_1546.ref();
				if( !typeBase_1547)
					continue;
				SFC::DT dT_1548= typeBase_1547.dt();
				if( !dT_1548)
					continue;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_154c;
				if( !isValidBound(boundObjs_154c, state_1536, true))
					continue;
				currMatch.state_154d= state_1536;
				if( !isValidBound(boundObjs_154c, main_153f, true))
					continue;
				currMatch.main_154e= main_153f;
				if( !isValidBound(boundObjs_154c, typeBase_1547, false))
					continue;
				currMatch.typeBase_154f= typeBase_1547;
				if( !isValidBound(boundObjs_154c, dT_1548, false))
					continue;
				currMatch.dT_1550= dT_1548;
				if( !isValidBound(boundObjs_154c, currEvent_1543, false))
					continue;
				currMatch.event_1551= currEvent_1543;
				if( !isValidBound(boundObjs_154c, currTypeBaseRef_1546, false))
					continue;
				currMatch.typeBaseRef_1552= currTypeBaseRef_1546;
				bool Gz_guard= isGuardTrue( currMatch.dT_1550, currMatch.event_1551, currMatch.main_154e, currMatch.state_154d, currMatch.typeBase_154f, currMatch.typeBaseRef_1552);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void EventInput_1526::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_1559= SFC::Arg::Create( currMatch.main_154e);
		SFC::Arg& Arg= newArg_1559;
		SFC::DT& DT= currMatch.dT_1550;
		CyPhyML::SignalFlow::SFEvent& Event= currMatch.event_1551;
		SFC::Function& Main= currMatch.main_154e;
		CyPhyML::SignalFlow::SFState& State= currMatch.state_154d;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_154f;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_1552;
		{
__int64 argIndex = static_cast< __int64 >( Main.argCount() ) + static_cast< __int64 >( Event.Port() ) - 1;
Arg.argIndex() = argIndex;

Arg.name() = static_cast< std::string >( Event.Name() ) + "_" + boost::lexical_cast< std::string >( argIndex );
};
		newArg_1559.dt()= currMatch.dT_1550;
		outputAppender( newArg_1559, currMatch.main_154e);
	}
}

void EventInput_1526::outputAppender( const SFC::Arg& arg_155a, const SFC::Function& main_155c)
{
	_arg_152d->push_back( arg_155a);
	_main_152e->push_back( main_155c);
}

void UpdateArgCount_155e::operator()( const Packets_t& args_155f, const Packets_t& mains_1561)
{
#ifdef PRINT_INFO
	printLog("UpdateArgCount_155e" );
#endif
	RTTGenerator::Instance()->generateRule(1129, "UpdateArgCount");
	processInputPackets( args_155f, mains_1561);
}

bool UpdateArgCount_155e::isInputUnique( const Udm::Object& arg_1567, const Udm::Object& main_1570)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itArg_1569= _arg_1563.begin(), itMain_1572= _main_156c.begin(); itArg_1569!= _arg_1563.end(), itMain_1572!= _main_156c.end(); ++itArg_1569, ++itMain_1572)
	{
		if( ( *itArg_1569== arg_1567)&& ( *itMain_1572== main_1570))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_arg_1563.push_back( arg_1567);
		_main_156c.push_back( main_1570);
	}
	return isUnique;
}

bool UpdateArgCount_155e::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void UpdateArgCount_155e::processInputPackets( const Packets_t& args_155f, const Packets_t& mains_1561)
{
	for( Packets_t::const_iterator itArg_1564= args_155f.begin(), itMain_156d= mains_1561.begin(); itArg_1564!= args_155f.end(), itMain_156d!= mains_1561.end(); ++itArg_1564, ++itMain_156d)
	{
		bool isUnique= isInputUnique( *itArg_1564, *itMain_156d);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itArg_1564, *itMain_156d);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool UpdateArgCount_155e::patternMatcher( const Udm::Object& arg_1565, const Udm::Object& main_156e)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( arg_1565.type(), SFC::Arg::meta))
			continue;
		SFC::Arg arg_156a= SFC::Arg::Cast( arg_1565);
		if( false== Uml::IsDerivedFrom( main_156e.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1573= SFC::Function::Cast( main_156e);
		set< SFC::Arg> args_1575= main_1573.Arg_kind_children();
		for( set< SFC::Arg>::const_iterator itArg_1576= args_1575.begin(); itArg_1576!= args_1575.end(); ++itArg_1576)
		{
			SFC::Arg currArg_1577= *itArg_1576;
			if( arg_156a!= currArg_1577)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_157b;
			if( !isValidBound(boundObjs_157b, arg_156a, true))
				continue;
			currMatch.arg_157c= arg_156a;
			if( !isValidBound(boundObjs_157b, main_1573, true))
				continue;
			currMatch.main_157d= main_1573;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void UpdateArgCount_155e::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg& Arg= currMatch.arg_157c;
		SFC::Function& Main= currMatch.main_157d;
		{
Main.argCount() = static_cast< __int64 >( Main.argCount() ) + 1;
};
	}
}

void EventOutput_1584::operator()( const Packets_t& states_1585, const Packets_t& functions_1587)
{
#ifdef PRINT_INFO
	printLog("EventOutput_1584" );
#endif
	if( ( !states_1585.empty())&& ( !functions_1587.empty()))
		callEventOutput_15c2( states_1585, functions_1587);
}

void EventOutput_1584::callEventOutput_15c2( const Packets_t& states_158a, const Packets_t& mains_158d)
{
	Packets_t args_158c;
	Packets_t mains_158f;
	EventOutput_1589 eventOutput_1589;
	eventOutput_1589( states_158a, mains_158d, args_158c, mains_158f);
	if( ( !args_158c.empty())&& ( !mains_158f.empty()))
		callUpdateArgCount_15c5( args_158c, mains_158f);
}

void EventOutput_1584::callUpdateArgCount_15c5( const Packets_t& args_155f, const Packets_t& mains_1561)
{
	UpdateArgCount_155e updateArgCount_155e;
	updateArgCount_155e( args_155f, mains_1561);
}

void EventOutput_1589::operator()( const Packets_t& states_158a, const Packets_t& mains_158d, Packets_t& args_158c, Packets_t& mains_158f)
{
#ifdef PRINT_INFO
	printLog("EventOutput_1589" );
#endif
	RTTGenerator::Instance()->generateRule(1109, "EventOutput");
	_arg_1590= &args_158c;
	_main_1591= &mains_158f;
	processInputPackets( states_158a, mains_158d);
}

bool EventOutput_1589::isInputUnique( const Udm::Object& state_1596, const Udm::Object& main_159f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1598= _state_1592.begin(), itMain_15a1= _main_159b.begin(); itState_1598!= _state_1592.end(), itMain_15a1!= _main_159b.end(); ++itState_1598, ++itMain_15a1)
	{
		if( ( *itState_1598== state_1596)&& ( *itMain_15a1== main_159f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1592.push_back( state_1596);
		_main_159b.push_back( main_159f);
	}
	return isUnique;
}

bool EventOutput_1589::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool EventOutput_1589::isGuardTrue( SFC::DT& DT, CyPhyML::SignalFlow::SFEvent& Event, SFC::Function& Main, CyPhyML::SignalFlow::SFState& State, CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef, CyPhyML::SignalFlow::TypeStruct& TypeStruct)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Event.Scope() ) == "OUTPUT_EVENT";;
	return Gz_guard;
}

void EventOutput_1589::processInputPackets( const Packets_t& states_158a, const Packets_t& mains_158d)
{
	for( Packets_t::const_iterator itState_1593= states_158a.begin(), itMain_159c= mains_158d.begin(); itState_1593!= states_158a.end(), itMain_159c!= mains_158d.end(); ++itState_1593, ++itMain_159c)
	{
		bool isUnique= isInputUnique( *itState_1593, *itMain_159c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1593, *itMain_159c);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool EventOutput_1589::patternMatcher( const Udm::Object& state_1594, const Udm::Object& main_159d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1594.type(), CyPhyML::SignalFlow::SFState::meta))
			continue;
		CyPhyML::SignalFlow::SFState state_1599= CyPhyML::SignalFlow::SFState::Cast( state_1594);
		if( false== Uml::IsDerivedFrom( main_159d.type(), SFC::Function::meta))
			continue;
		SFC::Function main_15a2= SFC::Function::Cast( main_159d);
		set< CyPhyML::SignalFlow::SFEvent> events_15a4= state_1599.SFEvent_kind_children();
		for( set< CyPhyML::SignalFlow::SFEvent>::const_iterator itEvent_15a5= events_15a4.begin(); itEvent_15a5!= events_15a4.end(); ++itEvent_15a5)
		{
			CyPhyML::SignalFlow::SFEvent currEvent_15a6= *itEvent_15a5;
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_15a7= currEvent_15a6.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_15a8= typeBaseRefs_15a7.begin(); itTypeBaseRef_15a8!= typeBaseRefs_15a7.end(); ++itTypeBaseRef_15a8)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_15a9= *itTypeBaseRef_15a8;
				CyPhyML::SignalFlow::SF_TypeBase typeStruct_15aa= currTypeBaseRef_15a9.ref();
				if( false== Uml::IsDerivedFrom( typeStruct_15aa.type(), CyPhyML::SignalFlow::TypeStruct::meta))
					continue;
				CyPhyML::SignalFlow::TypeStruct typeStruct_15ab= CyPhyML::SignalFlow::TypeStruct::Cast( typeStruct_15aa);
				if( !typeStruct_15ab)
					continue;
				SFC::DT dT_15ac= typeStruct_15ab.dt();
				if( !dT_15ac)
					continue;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_15b0;
				if( !isValidBound(boundObjs_15b0, state_1599, true))
					continue;
				currMatch.state_15b1= state_1599;
				if( !isValidBound(boundObjs_15b0, main_15a2, true))
					continue;
				currMatch.main_15b2= main_15a2;
				if( !isValidBound(boundObjs_15b0, typeStruct_15ab, false))
					continue;
				currMatch.typeStruct_15b3= typeStruct_15ab;
				if( !isValidBound(boundObjs_15b0, dT_15ac, false))
					continue;
				currMatch.dT_15b4= dT_15ac;
				if( !isValidBound(boundObjs_15b0, currEvent_15a6, false))
					continue;
				currMatch.event_15b5= currEvent_15a6;
				if( !isValidBound(boundObjs_15b0, currTypeBaseRef_15a9, false))
					continue;
				currMatch.typeBaseRef_15b6= currTypeBaseRef_15a9;
				bool Gz_guard= isGuardTrue( currMatch.dT_15b4, currMatch.event_15b5, currMatch.main_15b2, currMatch.state_15b1, currMatch.typeBaseRef_15b6, currMatch.typeStruct_15b3);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void EventOutput_1589::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_15bd= SFC::Arg::Create( currMatch.main_15b2);
		SFC::Arg& Arg= newArg_15bd;
		SFC::DT& DT= currMatch.dT_15b4;
		CyPhyML::SignalFlow::SFEvent& Event= currMatch.event_15b5;
		SFC::Function& Main= currMatch.main_15b2;
		CyPhyML::SignalFlow::SFState& State= currMatch.state_15b1;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_15b6;
		CyPhyML::SignalFlow::TypeStruct& TypeStruct= currMatch.typeStruct_15b3;
		{
__int64 argIndex = static_cast< __int64 >( Main.argCount() ) + static_cast< __int64 >( Event.Port() ) - 1;
Arg.argIndex() = argIndex;
Arg.ptr() = true;

Arg.name() = static_cast< std::string >( Event.name() ) + "_" + boost::lexical_cast< std::string >( argIndex );
};
		newArg_15bd.dt()= currMatch.dT_15b4;
		outputAppender( newArg_15bd, currMatch.main_15b2);
	}
}

void EventOutput_1589::outputAppender( const SFC::Arg& arg_15be, const SFC::Function& main_15c0)
{
	_arg_1590->push_back( arg_15be);
	_main_1591->push_back( main_15c0);
}

void DataInput_15c8::operator()( const Packets_t& states_15c9, const Packets_t& functions_15cb, Packets_t& states_15cd, Packets_t& functions_15ce)
{
#ifdef PRINT_INFO
	printLog("DataInput_15c8" );
#endif
	_state_15cf= &states_15cd;
	_function_15d0= &functions_15ce;
	_state_15cf->insert( _state_15cf->end(), states_15c9.begin(), states_15c9.end());
	_function_15d0->insert( _function_15d0->end(), functions_15cb.begin(), functions_15cb.end());
	if( ( !states_15c9.empty())&& ( !functions_15cb.empty()))
		callDataInput_1609( states_15c9, functions_15cb);
}

void DataInput_15c8::callDataInput_1609( const Packets_t& states_15d2, const Packets_t& mains_15d5)
{
	Packets_t args_15d4;
	Packets_t mains_15d7;
	DataInput_15d1 dataInput_15d1;
	dataInput_15d1( states_15d2, mains_15d5, args_15d4, mains_15d7);
	if( ( !args_15d4.empty())&& ( !mains_15d7.empty()))
		callUpdateArgCount_160c( args_15d4, mains_15d7);
}

void DataInput_15c8::callUpdateArgCount_160c( const Packets_t& args_155f, const Packets_t& mains_1561)
{
	UpdateArgCount_155e updateArgCount_155e;
	updateArgCount_155e( args_155f, mains_1561);
}

void DataInput_15d1::operator()( const Packets_t& states_15d2, const Packets_t& mains_15d5, Packets_t& args_15d4, Packets_t& mains_15d7)
{
#ifdef PRINT_INFO
	printLog("DataInput_15d1" );
#endif
	RTTGenerator::Instance()->generateRule(1134, "DataInput");
	_arg_15d8= &args_15d4;
	_main_15d9= &mains_15d7;
	processInputPackets( states_15d2, mains_15d5);
}

bool DataInput_15d1::isInputUnique( const Udm::Object& state_15de, const Udm::Object& main_15e7)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_15e0= _state_15da.begin(), itMain_15e9= _main_15e3.begin(); itState_15e0!= _state_15da.end(), itMain_15e9!= _main_15e3.end(); ++itState_15e0, ++itMain_15e9)
	{
		if( ( *itState_15e0== state_15de)&& ( *itMain_15e9== main_15e7))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_15da.push_back( state_15de);
		_main_15e3.push_back( main_15e7);
	}
	return isUnique;
}

bool DataInput_15d1::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool DataInput_15d1::isGuardTrue( SFC::DT& DT, CyPhyML::SignalFlow::SFData& Data, SFC::Function& Main, CyPhyML::SignalFlow::SFState& State, CyPhyML::SignalFlow::SF_TypeBase& TypeBase, CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Data.Scope() ) == "INPUT_DATA";;
	return Gz_guard;
}

void DataInput_15d1::processInputPackets( const Packets_t& states_15d2, const Packets_t& mains_15d5)
{
	for( Packets_t::const_iterator itState_15db= states_15d2.begin(), itMain_15e4= mains_15d5.begin(); itState_15db!= states_15d2.end(), itMain_15e4!= mains_15d5.end(); ++itState_15db, ++itMain_15e4)
	{
		bool isUnique= isInputUnique( *itState_15db, *itMain_15e4);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_15db, *itMain_15e4);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool DataInput_15d1::patternMatcher( const Udm::Object& state_15dc, const Udm::Object& main_15e5)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_15dc.type(), CyPhyML::SignalFlow::SFState::meta))
			continue;
		CyPhyML::SignalFlow::SFState state_15e1= CyPhyML::SignalFlow::SFState::Cast( state_15dc);
		if( false== Uml::IsDerivedFrom( main_15e5.type(), SFC::Function::meta))
			continue;
		SFC::Function main_15ea= SFC::Function::Cast( main_15e5);
		set< CyPhyML::SignalFlow::SFData> datas_15ec= state_15e1.SFData_kind_children();
		for( set< CyPhyML::SignalFlow::SFData>::const_iterator itData_15ed= datas_15ec.begin(); itData_15ed!= datas_15ec.end(); ++itData_15ed)
		{
			CyPhyML::SignalFlow::SFData currData_15ee= *itData_15ed;
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_15ef= currData_15ee.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_15f0= typeBaseRefs_15ef.begin(); itTypeBaseRef_15f0!= typeBaseRefs_15ef.end(); ++itTypeBaseRef_15f0)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_15f1= *itTypeBaseRef_15f0;
				CyPhyML::SignalFlow::SF_TypeBase typeBase_15f2= currTypeBaseRef_15f1.ref();
				if( !typeBase_15f2)
					continue;
				SFC::DT dT_15f3= typeBase_15f2.dt();
				if( !dT_15f3)
					continue;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_15f7;
				if( !isValidBound(boundObjs_15f7, state_15e1, true))
					continue;
				currMatch.state_15f8= state_15e1;
				if( !isValidBound(boundObjs_15f7, main_15ea, true))
					continue;
				currMatch.main_15f9= main_15ea;
				if( !isValidBound(boundObjs_15f7, typeBase_15f2, false))
					continue;
				currMatch.typeBase_15fa= typeBase_15f2;
				if( !isValidBound(boundObjs_15f7, dT_15f3, false))
					continue;
				currMatch.dT_15fb= dT_15f3;
				if( !isValidBound(boundObjs_15f7, currData_15ee, false))
					continue;
				currMatch.data_15fc= currData_15ee;
				if( !isValidBound(boundObjs_15f7, currTypeBaseRef_15f1, false))
					continue;
				currMatch.typeBaseRef_15fd= currTypeBaseRef_15f1;
				bool Gz_guard= isGuardTrue( currMatch.dT_15fb, currMatch.data_15fc, currMatch.main_15f9, currMatch.state_15f8, currMatch.typeBase_15fa, currMatch.typeBaseRef_15fd);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void DataInput_15d1::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_1604= SFC::Arg::Create( currMatch.main_15f9);
		SFC::Arg& Arg= newArg_1604;
		SFC::DT& DT= currMatch.dT_15fb;
		CyPhyML::SignalFlow::SFData& Data= currMatch.data_15fc;
		SFC::Function& Main= currMatch.main_15f9;
		CyPhyML::SignalFlow::SFState& State= currMatch.state_15f8;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_15fa;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_15fd;
		{
__int64 argIndex = static_cast< __int64 >( Main.argCount() ) + static_cast< __int64 >( Data.Port() ) - 1;
Arg.argIndex() = argIndex;
Arg.name() = static_cast< std::string >( Data.Name() ) + "_" + boost::lexical_cast< std::string >( argIndex );
};
		newArg_1604.dt()= currMatch.dT_15fb;
		outputAppender( newArg_1604, currMatch.main_15f9);
	}
}

void DataInput_15d1::outputAppender( const SFC::Arg& arg_1605, const SFC::Function& main_1607)
{
	_arg_15d8->push_back( arg_1605);
	_main_15d9->push_back( main_1607);
}

void DataOutput_160f::operator()( const Packets_t& states_1610, const Packets_t& functions_1612, Packets_t& states_1614, Packets_t& functions_1615)
{
#ifdef PRINT_INFO
	printLog("DataOutput_160f" );
#endif
	_state_1616= &states_1614;
	_function_1617= &functions_1615;
	_state_1616->insert( _state_1616->end(), states_1610.begin(), states_1610.end());
	_function_1617->insert( _function_1617->end(), functions_1612.begin(), functions_1612.end());
	if( ( !states_1610.empty())&& ( !functions_1612.empty()))
		callDataOutput_1650( states_1610, functions_1612);
}

void DataOutput_160f::callDataOutput_1650( const Packets_t& states_1619, const Packets_t& mains_161c)
{
	Packets_t args_161b;
	Packets_t mains_161e;
	DataOutput_1618 dataOutput_1618;
	dataOutput_1618( states_1619, mains_161c, args_161b, mains_161e);
	if( ( !args_161b.empty())&& ( !mains_161e.empty()))
		callUpdateArgCount_1653( args_161b, mains_161e);
}

void DataOutput_160f::callUpdateArgCount_1653( const Packets_t& args_155f, const Packets_t& mains_1561)
{
	UpdateArgCount_155e updateArgCount_155e;
	updateArgCount_155e( args_155f, mains_1561);
}

void DataOutput_1618::operator()( const Packets_t& states_1619, const Packets_t& mains_161c, Packets_t& args_161b, Packets_t& mains_161e)
{
#ifdef PRINT_INFO
	printLog("DataOutput_1618" );
#endif
	RTTGenerator::Instance()->generateRule(1154, "DataOutput");
	_arg_161f= &args_161b;
	_main_1620= &mains_161e;
	processInputPackets( states_1619, mains_161c);
}

bool DataOutput_1618::isInputUnique( const Udm::Object& state_1625, const Udm::Object& main_162e)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1627= _state_1621.begin(), itMain_1630= _main_162a.begin(); itState_1627!= _state_1621.end(), itMain_1630!= _main_162a.end(); ++itState_1627, ++itMain_1630)
	{
		if( ( *itState_1627== state_1625)&& ( *itMain_1630== main_162e))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1621.push_back( state_1625);
		_main_162a.push_back( main_162e);
	}
	return isUnique;
}

bool DataOutput_1618::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool DataOutput_1618::isGuardTrue( SFC::DT& DT, CyPhyML::SignalFlow::SFData& Data, SFC::Function& Main, CyPhyML::SignalFlow::SFState& State, CyPhyML::SignalFlow::SF_TypeBase& TypeBase, CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Data.Scope() ) == "OUTPUT_DATA";;
	return Gz_guard;
}

void DataOutput_1618::processInputPackets( const Packets_t& states_1619, const Packets_t& mains_161c)
{
	for( Packets_t::const_iterator itState_1622= states_1619.begin(), itMain_162b= mains_161c.begin(); itState_1622!= states_1619.end(), itMain_162b!= mains_161c.end(); ++itState_1622, ++itMain_162b)
	{
		bool isUnique= isInputUnique( *itState_1622, *itMain_162b);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1622, *itMain_162b);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool DataOutput_1618::patternMatcher( const Udm::Object& state_1623, const Udm::Object& main_162c)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1623.type(), CyPhyML::SignalFlow::SFState::meta))
			continue;
		CyPhyML::SignalFlow::SFState state_1628= CyPhyML::SignalFlow::SFState::Cast( state_1623);
		if( false== Uml::IsDerivedFrom( main_162c.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1631= SFC::Function::Cast( main_162c);
		set< CyPhyML::SignalFlow::SFData> datas_1633= state_1628.SFData_kind_children();
		for( set< CyPhyML::SignalFlow::SFData>::const_iterator itData_1634= datas_1633.begin(); itData_1634!= datas_1633.end(); ++itData_1634)
		{
			CyPhyML::SignalFlow::SFData currData_1635= *itData_1634;
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_1636= currData_1635.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_1637= typeBaseRefs_1636.begin(); itTypeBaseRef_1637!= typeBaseRefs_1636.end(); ++itTypeBaseRef_1637)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_1638= *itTypeBaseRef_1637;
				CyPhyML::SignalFlow::SF_TypeBase typeBase_1639= currTypeBaseRef_1638.ref();
				if( !typeBase_1639)
					continue;
				SFC::DT dT_163a= typeBase_1639.dt();
				if( !dT_163a)
					continue;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_163e;
				if( !isValidBound(boundObjs_163e, state_1628, true))
					continue;
				currMatch.state_163f= state_1628;
				if( !isValidBound(boundObjs_163e, main_1631, true))
					continue;
				currMatch.main_1640= main_1631;
				if( !isValidBound(boundObjs_163e, typeBase_1639, false))
					continue;
				currMatch.typeBase_1641= typeBase_1639;
				if( !isValidBound(boundObjs_163e, dT_163a, false))
					continue;
				currMatch.dT_1642= dT_163a;
				if( !isValidBound(boundObjs_163e, currData_1635, false))
					continue;
				currMatch.data_1643= currData_1635;
				if( !isValidBound(boundObjs_163e, currTypeBaseRef_1638, false))
					continue;
				currMatch.typeBaseRef_1644= currTypeBaseRef_1638;
				bool Gz_guard= isGuardTrue( currMatch.dT_1642, currMatch.data_1643, currMatch.main_1640, currMatch.state_163f, currMatch.typeBase_1641, currMatch.typeBaseRef_1644);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void DataOutput_1618::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_164b= SFC::Arg::Create( currMatch.main_1640);
		SFC::Arg& Arg= newArg_164b;
		SFC::DT& DT= currMatch.dT_1642;
		CyPhyML::SignalFlow::SFData& Data= currMatch.data_1643;
		SFC::Function& Main= currMatch.main_1640;
		CyPhyML::SignalFlow::SFState& State= currMatch.state_163f;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_1641;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_1644;
		{
			std::string fname = Main.name();
__int64 argIndex = static_cast< __int64 >( Main.argCount() ) + static_cast< __int64 >( Data.Port() ) - 1;
Arg.argIndex() = argIndex;
Arg.ptr() = true;

Arg.name() = static_cast< std::string >( Data.Name() ) + "_" + boost::lexical_cast< std::string >( argIndex );
};
		newArg_164b.dt()= currMatch.dT_1642;
		outputAppender( newArg_164b, currMatch.main_1640);
	}
}

void DataOutput_1618::outputAppender( const SFC::Arg& arg_164c, const SFC::Function& main_164e)
{
	_arg_161f->push_back( arg_164c);
	_main_1620->push_back( main_164e);
}

void CreateChartFunction_1662::operator()( const Packets_t& subsystems_1664, Packets_t& states_1663, Packets_t& mains_1666)
{
#ifdef PRINT_INFO
	printLog("CreateChartFunction_1662" );
#endif
	RTTGenerator::Instance()->generateRule(1169, "CreateChartFunction");
	_state_1667= &states_1663;
	_main_1668= &mains_1666;
	processInputPackets( subsystems_1664);
}

bool CreateChartFunction_1662::isInputUnique( const Udm::Object& subsystem_166d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_166f= _subsystem_1669.begin(); itSubsystem_166f!= _subsystem_1669.end(); ++itSubsystem_166f)
	{
		if( ( *itSubsystem_166f== subsystem_166d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_subsystem_1669.push_back( subsystem_166d);
	return isUnique;
}

bool CreateChartFunction_1662::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateChartFunction_1662::processInputPackets( const Packets_t& subsystems_1664)
{
	for( Packets_t::const_iterator itSubsystem_166a= subsystems_1664.begin(); itSubsystem_166a!= subsystems_1664.end(); ++itSubsystem_166a)
	{
		bool isUnique= isInputUnique( *itSubsystem_166a);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_166a);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateChartFunction_1662::patternMatcher( const Udm::Object& subsystem_166b)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_166b.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1670= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_166b);
		set< CyPhyML::SignalFlow::Primitive> primitives_1672= subsystem_1670.Primitive_kind_children();
		for( set< CyPhyML::SignalFlow::Primitive>::const_iterator itPrimitive_1673= primitives_1672.begin(); itPrimitive_1673!= primitives_1672.end(); ++itPrimitive_1673)
		{
			CyPhyML::SignalFlow::Primitive currPrimitive_1674= *itPrimitive_1673;
			set< CyPhyML::SignalFlow::State> states_1675= currPrimitive_1674.State_kind_children();
			for( set< CyPhyML::SignalFlow::State>::const_iterator itState_1676= states_1675.begin(); itState_1676!= states_1675.end(); ++itState_1676)
			{
				CyPhyML::SignalFlow::State currState_1677= *itState_1676;
				SFC::Class class_1678= subsystem_1670.cls();
				if( !class_1678)
					continue;
				set< SFC::Struct> structs_1679= class_1678.Struct_kind_children();
				for( set< SFC::Struct>::const_iterator itStruct_167a= structs_1679.begin(); itStruct_167a!= structs_1679.end(); ++itStruct_167a)
				{
					SFC::Struct currStruct_167b= *itStruct_167a;
					Match currMatch;
					set< pair<int, Udm::Object> > boundObjs_167f;
					if( !isValidBound(boundObjs_167f, subsystem_1670, true))
						continue;
					currMatch.subsystem_1680= subsystem_1670;
					if( !isValidBound(boundObjs_167f, currPrimitive_1674, false))
						continue;
					currMatch.primitive_1681= currPrimitive_1674;
					if( !isValidBound(boundObjs_167f, currState_1677, false))
						continue;
					currMatch.state_1682= currState_1677;
					if( !isValidBound(boundObjs_167f, class_1678, false))
						continue;
					currMatch.class_1683= class_1678;
					if( !isValidBound(boundObjs_167f, currStruct_167b, false))
						continue;
					currMatch.struct_1684= currStruct_167b;
					_matches.push_back( currMatch);
				}
			}
		}
	}
	return !_matches.empty();
}

void CreateChartFunction_1662::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function newMain_1685= SFC::Function::Create( currMatch.class_1683, SFC::Class::meta_stmnt);
		SFC::Arg newArg_1686= SFC::Arg::Create( newMain_1685);
		SFC::Arg& Arg= newArg_1686;
		SFC::Class& Class= currMatch.class_1683;
		SFC::Function& Main= newMain_1685;
		CyPhyML::SignalFlow::Primitive& Primitive= currMatch.primitive_1681;
		CyPhyML::SignalFlow::State& State= currMatch.state_1682;
		SFC::Struct& Struct= currMatch.struct_1684;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_1680;
		{
Main.name() = static_cast< std::string >( Subsystem.name() ) + "_main";
};
		{
__int64 statementCount = Class.statementCount();
Main.statementIndex() = statementCount++;
Class.statementCount() = statementCount;
};
		{
__int64 argCount = Main.argCount();
Arg.argIndex() = argCount++;
Main.argCount() = argCount;

Arg.name() = "context";
Arg.ptr() = true;
};
		{
Main.statementCount() = -1;
};
		newMain_1685.sysmain()+= currMatch.subsystem_1680;
		newArg_1686.dt()= currMatch.struct_1684;
		outputAppender( currMatch.state_1682, newMain_1685);
	}
}

void CreateChartFunction_1662::outputAppender( const CyPhyML::SignalFlow::State& state_1687, const SFC::Function& main_1689)
{
	_state_1667->push_back( state_1687);
	_main_1668->push_back( main_1689);
}

void MakeChartArguments_168b::operator()( const Packets_t& states_168c, const Packets_t& functions_168e)
{
#ifdef PRINT_INFO
	printLog("MakeChartArguments_168b" );
#endif
	if( ( !states_168c.empty())&& ( !functions_168e.empty()))
		callDataInput_17c9( states_168c, functions_168e);
}

void MakeChartArguments_168b::callDataInput_17c9( const Packets_t& states_1691, const Packets_t& functions_1693)
{
	Packets_t states_1695;
	Packets_t functions_1696;
	DataInput_1690 dataInput_1690;
	dataInput_1690( states_1691, functions_1693, states_1695, functions_1696);
	if( ( !states_1695.empty())&& ( !functions_1696.empty()))
		callEventInput_17cc( states_1695, functions_1696);
}

void MakeChartArguments_168b::callEventInput_17cc( const Packets_t& states_16f8, const Packets_t& functions_16fa)
{
	Packets_t states_16fc;
	Packets_t functions_16fd;
	EventInput_16f7 eventInput_16f7;
	eventInput_16f7( states_16f8, functions_16fa, states_16fc, functions_16fd);
	if( ( !states_16fc.empty())&& ( !functions_16fd.empty()))
		callDataOutput_17cf( states_16fc, functions_16fd);
}

void MakeChartArguments_168b::callDataOutput_17cf( const Packets_t& states_173f, const Packets_t& functions_1741)
{
	Packets_t states_1743;
	Packets_t functions_1744;
	DataOutput_173e dataOutput_173e;
	dataOutput_173e( states_173f, functions_1741, states_1743, functions_1744);
	if( ( !states_1743.empty())&& ( !functions_1744.empty()))
		callEventOutput_17d2( states_1743, functions_1744);
}

void MakeChartArguments_168b::callEventOutput_17d2( const Packets_t& states_1786, const Packets_t& functions_1788)
{
	EventOutput_1785 eventOutput_1785;
	eventOutput_1785( states_1786, functions_1788);
}

void DataInput_1690::operator()( const Packets_t& states_1691, const Packets_t& functions_1693, Packets_t& states_1695, Packets_t& functions_1696)
{
#ifdef PRINT_INFO
	printLog("DataInput_1690" );
#endif
	_state_1697= &states_1695;
	_function_1698= &functions_1696;
	if( ( !states_1691.empty())&& ( !functions_1693.empty()))
		callDataInput_16f1( states_1691, functions_1693);
	_state_1697->insert( _state_1697->end(), states_1691.begin(), states_1691.end());
	_function_1698->insert( _function_1698->end(), functions_1693.begin(), functions_1693.end());
}

void DataInput_1690::callDataInput_16f1( const Packets_t& states_16ba, const Packets_t& mains_16bd)
{
	Packets_t args_16bc;
	Packets_t mains_16bf;
	DataInput_16b9 dataInput_16b9;
	dataInput_16b9( states_16ba, mains_16bd, args_16bc, mains_16bf);
	if( ( !args_16bc.empty())&& ( !mains_16bf.empty()))
		callUpdateArgCount_16f4( args_16bc, mains_16bf);
}

void DataInput_1690::callUpdateArgCount_16f4( const Packets_t& args_169a, const Packets_t& mains_169c)
{
	UpdateArgCount_1699 updateArgCount_1699;
	updateArgCount_1699( args_169a, mains_169c);
}

void UpdateArgCount_1699::operator()( const Packets_t& args_169a, const Packets_t& mains_169c)
{
#ifdef PRINT_INFO
	printLog("UpdateArgCount_1699" );
#endif
	RTTGenerator::Instance()->generateRule(1197, "UpdateArgCount");
	processInputPackets( args_169a, mains_169c);
}

bool UpdateArgCount_1699::isInputUnique( const Udm::Object& arg_16a2, const Udm::Object& main_16ab)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itArg_16a4= _arg_169e.begin(), itMain_16ad= _main_16a7.begin(); itArg_16a4!= _arg_169e.end(), itMain_16ad!= _main_16a7.end(); ++itArg_16a4, ++itMain_16ad)
	{
		if( ( *itArg_16a4== arg_16a2)&& ( *itMain_16ad== main_16ab))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_arg_169e.push_back( arg_16a2);
		_main_16a7.push_back( main_16ab);
	}
	return isUnique;
}

bool UpdateArgCount_1699::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void UpdateArgCount_1699::processInputPackets( const Packets_t& args_169a, const Packets_t& mains_169c)
{
	for( Packets_t::const_iterator itArg_169f= args_169a.begin(), itMain_16a8= mains_169c.begin(); itArg_169f!= args_169a.end(), itMain_16a8!= mains_169c.end(); ++itArg_169f, ++itMain_16a8)
	{
		bool isUnique= isInputUnique( *itArg_169f, *itMain_16a8);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itArg_169f, *itMain_16a8);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool UpdateArgCount_1699::patternMatcher( const Udm::Object& arg_16a0, const Udm::Object& main_16a9)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( arg_16a0.type(), SFC::Arg::meta))
			continue;
		SFC::Arg arg_16a5= SFC::Arg::Cast( arg_16a0);
		if( false== Uml::IsDerivedFrom( main_16a9.type(), SFC::Function::meta))
			continue;
		SFC::Function main_16ae= SFC::Function::Cast( main_16a9);
		set< SFC::Arg> args_16b0= main_16ae.Arg_kind_children();
		for( set< SFC::Arg>::const_iterator itArg_16b1= args_16b0.begin(); itArg_16b1!= args_16b0.end(); ++itArg_16b1)
		{
			SFC::Arg currArg_16b2= *itArg_16b1;
			if( arg_16a5!= currArg_16b2)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_16b6;
			if( !isValidBound(boundObjs_16b6, arg_16a5, true))
				continue;
			currMatch.arg_16b7= arg_16a5;
			if( !isValidBound(boundObjs_16b6, main_16ae, true))
				continue;
			currMatch.main_16b8= main_16ae;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void UpdateArgCount_1699::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg& Arg= currMatch.arg_16b7;
		SFC::Function& Main= currMatch.main_16b8;
		{
Main.argCount() = static_cast< __int64 >( Main.argCount() ) + 1;
};
	}
}

void DataInput_16b9::operator()( const Packets_t& states_16ba, const Packets_t& mains_16bd, Packets_t& args_16bc, Packets_t& mains_16bf)
{
#ifdef PRINT_INFO
	printLog("DataInput_16b9" );
#endif
	RTTGenerator::Instance()->generateRule(1202, "DataInput");
	_arg_16c0= &args_16bc;
	_main_16c1= &mains_16bf;
	processInputPackets( states_16ba, mains_16bd);
}

bool DataInput_16b9::isInputUnique( const Udm::Object& state_16c6, const Udm::Object& main_16cf)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_16c8= _state_16c2.begin(), itMain_16d1= _main_16cb.begin(); itState_16c8!= _state_16c2.end(), itMain_16d1!= _main_16cb.end(); ++itState_16c8, ++itMain_16d1)
	{
		if( ( *itState_16c8== state_16c6)&& ( *itMain_16d1== main_16cf))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_16c2.push_back( state_16c6);
		_main_16cb.push_back( main_16cf);
	}
	return isUnique;
}

bool DataInput_16b9::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool DataInput_16b9::isGuardTrue( SFC::DT& DT, CyPhyML::SignalFlow::Data& Data, SFC::Function& Main, CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::SF_TypeBase& TypeBase, CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Data.Scope() ) == "INPUT_DATA";;
	return Gz_guard;
}

void DataInput_16b9::processInputPackets( const Packets_t& states_16ba, const Packets_t& mains_16bd)
{
	for( Packets_t::const_iterator itState_16c3= states_16ba.begin(), itMain_16cc= mains_16bd.begin(); itState_16c3!= states_16ba.end(), itMain_16cc!= mains_16bd.end(); ++itState_16c3, ++itMain_16cc)
	{
		bool isUnique= isInputUnique( *itState_16c3, *itMain_16cc);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_16c3, *itMain_16cc);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool DataInput_16b9::patternMatcher( const Udm::Object& state_16c4, const Udm::Object& main_16cd)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_16c4.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_16c9= CyPhyML::SignalFlow::State::Cast( state_16c4);
		if( false== Uml::IsDerivedFrom( main_16cd.type(), SFC::Function::meta))
			continue;
		SFC::Function main_16d2= SFC::Function::Cast( main_16cd);
		set< CyPhyML::SignalFlow::Data> datas_16d4= state_16c9.Data_kind_children();
		for( set< CyPhyML::SignalFlow::Data>::const_iterator itData_16d5= datas_16d4.begin(); itData_16d5!= datas_16d4.end(); ++itData_16d5)
		{
			CyPhyML::SignalFlow::Data currData_16d6= *itData_16d5;
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_16d7= currData_16d6.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_16d8= typeBaseRefs_16d7.begin(); itTypeBaseRef_16d8!= typeBaseRefs_16d7.end(); ++itTypeBaseRef_16d8)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_16d9= *itTypeBaseRef_16d8;
				CyPhyML::SignalFlow::SF_TypeBase typeBase_16da= currTypeBaseRef_16d9.ref();
				if( !typeBase_16da)
					continue;
				SFC::DT dT_16db= typeBase_16da.dt();
				if( !dT_16db)
					continue;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_16df;
				if( !isValidBound(boundObjs_16df, state_16c9, true))
					continue;
				currMatch.state_16e0= state_16c9;
				if( !isValidBound(boundObjs_16df, main_16d2, true))
					continue;
				currMatch.main_16e1= main_16d2;
				if( !isValidBound(boundObjs_16df, typeBase_16da, false))
					continue;
				currMatch.typeBase_16e2= typeBase_16da;
				if( !isValidBound(boundObjs_16df, dT_16db, false))
					continue;
				currMatch.dT_16e3= dT_16db;
				if( !isValidBound(boundObjs_16df, currData_16d6, false))
					continue;
				currMatch.data_16e4= currData_16d6;
				if( !isValidBound(boundObjs_16df, currTypeBaseRef_16d9, false))
					continue;
				currMatch.typeBaseRef_16e5= currTypeBaseRef_16d9;
				bool Gz_guard= isGuardTrue( currMatch.dT_16e3, currMatch.data_16e4, currMatch.main_16e1, currMatch.state_16e0, currMatch.typeBase_16e2, currMatch.typeBaseRef_16e5);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void DataInput_16b9::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_16ec= SFC::Arg::Create( currMatch.main_16e1);
		SFC::Arg& Arg= newArg_16ec;
		SFC::DT& DT= currMatch.dT_16e3;
		CyPhyML::SignalFlow::Data& Data= currMatch.data_16e4;
		SFC::Function& Main= currMatch.main_16e1;
		CyPhyML::SignalFlow::State& State= currMatch.state_16e0;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_16e2;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_16e5;
		{
			std::string fname = Main.name();
__int64 argIndex = static_cast< __int64 >( Main.argCount() ) + static_cast< __int64 >( Data.Port() ) - 1;
Arg.argIndex() = argIndex;

Arg.name() = static_cast< std::string >( Data.Name() ) + "_" + boost::lexical_cast< std::string >( argIndex );
};
		newArg_16ec.dt()= currMatch.dT_16e3;
		outputAppender( newArg_16ec, currMatch.main_16e1);
	}
}

void DataInput_16b9::outputAppender( const SFC::Arg& arg_16ed, const SFC::Function& main_16ef)
{
	_arg_16c0->push_back( arg_16ed);
	_main_16c1->push_back( main_16ef);
}

void EventInput_16f7::operator()( const Packets_t& states_16f8, const Packets_t& functions_16fa, Packets_t& states_16fc, Packets_t& functions_16fd)
{
#ifdef PRINT_INFO
	printLog("EventInput_16f7" );
#endif
	_state_16fe= &states_16fc;
	_function_16ff= &functions_16fd;
	if( ( !states_16f8.empty())&& ( !functions_16fa.empty()))
		callEventInput_1738( states_16f8, functions_16fa);
	_state_16fe->insert( _state_16fe->end(), states_16f8.begin(), states_16f8.end());
	_function_16ff->insert( _function_16ff->end(), functions_16fa.begin(), functions_16fa.end());
}

void EventInput_16f7::callEventInput_1738( const Packets_t& states_1701, const Packets_t& mains_1704)
{
	Packets_t args_1703;
	Packets_t mains_1706;
	EventInput_1700 eventInput_1700;
	eventInput_1700( states_1701, mains_1704, args_1703, mains_1706);
	if( ( !args_1703.empty())&& ( !mains_1706.empty()))
		callUpdateArgCount_173b( args_1703, mains_1706);
}

void EventInput_16f7::callUpdateArgCount_173b( const Packets_t& args_169a, const Packets_t& mains_169c)
{
	UpdateArgCount_1699 updateArgCount_1699;
	updateArgCount_1699( args_169a, mains_169c);
}

void EventInput_1700::operator()( const Packets_t& states_1701, const Packets_t& mains_1704, Packets_t& args_1703, Packets_t& mains_1706)
{
#ifdef PRINT_INFO
	printLog("EventInput_1700" );
#endif
	RTTGenerator::Instance()->generateRule(1222, "EventInput");
	_arg_1707= &args_1703;
	_main_1708= &mains_1706;
	processInputPackets( states_1701, mains_1704);
}

bool EventInput_1700::isInputUnique( const Udm::Object& state_170d, const Udm::Object& main_1716)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_170f= _state_1709.begin(), itMain_1718= _main_1712.begin(); itState_170f!= _state_1709.end(), itMain_1718!= _main_1712.end(); ++itState_170f, ++itMain_1718)
	{
		if( ( *itState_170f== state_170d)&& ( *itMain_1718== main_1716))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1709.push_back( state_170d);
		_main_1712.push_back( main_1716);
	}
	return isUnique;
}

bool EventInput_1700::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool EventInput_1700::isGuardTrue( SFC::DT& DT, CyPhyML::SignalFlow::Event& Event, SFC::Function& Main, CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::SF_TypeBase& TypeBase, CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Event.Scope() ) == "INPUT_EVENT";;
	return Gz_guard;
}

void EventInput_1700::processInputPackets( const Packets_t& states_1701, const Packets_t& mains_1704)
{
	for( Packets_t::const_iterator itState_170a= states_1701.begin(), itMain_1713= mains_1704.begin(); itState_170a!= states_1701.end(), itMain_1713!= mains_1704.end(); ++itState_170a, ++itMain_1713)
	{
		bool isUnique= isInputUnique( *itState_170a, *itMain_1713);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_170a, *itMain_1713);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool EventInput_1700::patternMatcher( const Udm::Object& state_170b, const Udm::Object& main_1714)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_170b.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1710= CyPhyML::SignalFlow::State::Cast( state_170b);
		if( false== Uml::IsDerivedFrom( main_1714.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1719= SFC::Function::Cast( main_1714);
		set< CyPhyML::SignalFlow::Event> events_171b= state_1710.Event_kind_children();
		for( set< CyPhyML::SignalFlow::Event>::const_iterator itEvent_171c= events_171b.begin(); itEvent_171c!= events_171b.end(); ++itEvent_171c)
		{
			CyPhyML::SignalFlow::Event currEvent_171d= *itEvent_171c;
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_171e= currEvent_171d.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_171f= typeBaseRefs_171e.begin(); itTypeBaseRef_171f!= typeBaseRefs_171e.end(); ++itTypeBaseRef_171f)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_1720= *itTypeBaseRef_171f;
				CyPhyML::SignalFlow::SF_TypeBase typeBase_1721= currTypeBaseRef_1720.ref();
				if( !typeBase_1721)
					continue;
				SFC::DT dT_1722= typeBase_1721.dt();
				if( !dT_1722)
					continue;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_1726;
				if( !isValidBound(boundObjs_1726, state_1710, true))
					continue;
				currMatch.state_1727= state_1710;
				if( !isValidBound(boundObjs_1726, main_1719, true))
					continue;
				currMatch.main_1728= main_1719;
				if( !isValidBound(boundObjs_1726, typeBase_1721, false))
					continue;
				currMatch.typeBase_1729= typeBase_1721;
				if( !isValidBound(boundObjs_1726, dT_1722, false))
					continue;
				currMatch.dT_172a= dT_1722;
				if( !isValidBound(boundObjs_1726, currEvent_171d, false))
					continue;
				currMatch.event_172b= currEvent_171d;
				if( !isValidBound(boundObjs_1726, currTypeBaseRef_1720, false))
					continue;
				currMatch.typeBaseRef_172c= currTypeBaseRef_1720;
				bool Gz_guard= isGuardTrue( currMatch.dT_172a, currMatch.event_172b, currMatch.main_1728, currMatch.state_1727, currMatch.typeBase_1729, currMatch.typeBaseRef_172c);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void EventInput_1700::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_1733= SFC::Arg::Create( currMatch.main_1728);
		SFC::Arg& Arg= newArg_1733;
		SFC::DT& DT= currMatch.dT_172a;
		CyPhyML::SignalFlow::Event& Event= currMatch.event_172b;
		SFC::Function& Main= currMatch.main_1728;
		CyPhyML::SignalFlow::State& State= currMatch.state_1727;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_1729;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_172c;
		{
__int64 argIndex = static_cast< __int64 >( Main.argCount() ) + static_cast< __int64 >( Event.Port() ) - 1;
Arg.argIndex() = argIndex;

Arg.name() = static_cast< std::string >( Event.Name() ) + "_" + boost::lexical_cast< std::string >( argIndex );
};
		newArg_1733.dt()= currMatch.dT_172a;
		outputAppender( newArg_1733, currMatch.main_1728);
	}
}

void EventInput_1700::outputAppender( const SFC::Arg& arg_1734, const SFC::Function& main_1736)
{
	_arg_1707->push_back( arg_1734);
	_main_1708->push_back( main_1736);
}

void DataOutput_173e::operator()( const Packets_t& states_173f, const Packets_t& functions_1741, Packets_t& states_1743, Packets_t& functions_1744)
{
#ifdef PRINT_INFO
	printLog("DataOutput_173e" );
#endif
	_state_1745= &states_1743;
	_function_1746= &functions_1744;
	if( ( !states_173f.empty())&& ( !functions_1741.empty()))
		callDataOutput_177f( states_173f, functions_1741);
	_state_1745->insert( _state_1745->end(), states_173f.begin(), states_173f.end());
	_function_1746->insert( _function_1746->end(), functions_1741.begin(), functions_1741.end());
}

void DataOutput_173e::callDataOutput_177f( const Packets_t& states_1748, const Packets_t& mains_174b)
{
	Packets_t args_174a;
	Packets_t mains_174d;
	DataOutput_1747 dataOutput_1747;
	dataOutput_1747( states_1748, mains_174b, args_174a, mains_174d);
	if( ( !args_174a.empty())&& ( !mains_174d.empty()))
		callUpdateArgCount_1782( args_174a, mains_174d);
}

void DataOutput_173e::callUpdateArgCount_1782( const Packets_t& args_169a, const Packets_t& mains_169c)
{
	UpdateArgCount_1699 updateArgCount_1699;
	updateArgCount_1699( args_169a, mains_169c);
}

void DataOutput_1747::operator()( const Packets_t& states_1748, const Packets_t& mains_174b, Packets_t& args_174a, Packets_t& mains_174d)
{
#ifdef PRINT_INFO
	printLog("DataOutput_1747" );
#endif
	RTTGenerator::Instance()->generateRule(1242, "DataOutput");
	_arg_174e= &args_174a;
	_main_174f= &mains_174d;
	processInputPackets( states_1748, mains_174b);
}

bool DataOutput_1747::isInputUnique( const Udm::Object& state_1754, const Udm::Object& main_175d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1756= _state_1750.begin(), itMain_175f= _main_1759.begin(); itState_1756!= _state_1750.end(), itMain_175f!= _main_1759.end(); ++itState_1756, ++itMain_175f)
	{
		if( ( *itState_1756== state_1754)&& ( *itMain_175f== main_175d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1750.push_back( state_1754);
		_main_1759.push_back( main_175d);
	}
	return isUnique;
}

bool DataOutput_1747::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool DataOutput_1747::isGuardTrue( SFC::DT& DT, CyPhyML::SignalFlow::Data& Data, SFC::Function& Main, CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::SF_TypeBase& TypeBase, CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Data.Scope() ) == "OUTPUT_DATA";;
	return Gz_guard;
}

void DataOutput_1747::processInputPackets( const Packets_t& states_1748, const Packets_t& mains_174b)
{
	for( Packets_t::const_iterator itState_1751= states_1748.begin(), itMain_175a= mains_174b.begin(); itState_1751!= states_1748.end(), itMain_175a!= mains_174b.end(); ++itState_1751, ++itMain_175a)
	{
		bool isUnique= isInputUnique( *itState_1751, *itMain_175a);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1751, *itMain_175a);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool DataOutput_1747::patternMatcher( const Udm::Object& state_1752, const Udm::Object& main_175b)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1752.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_1757= CyPhyML::SignalFlow::State::Cast( state_1752);
		if( false== Uml::IsDerivedFrom( main_175b.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1760= SFC::Function::Cast( main_175b);
		set< CyPhyML::SignalFlow::Data> datas_1762= state_1757.Data_kind_children();
		for( set< CyPhyML::SignalFlow::Data>::const_iterator itData_1763= datas_1762.begin(); itData_1763!= datas_1762.end(); ++itData_1763)
		{
			CyPhyML::SignalFlow::Data currData_1764= *itData_1763;
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_1765= currData_1764.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_1766= typeBaseRefs_1765.begin(); itTypeBaseRef_1766!= typeBaseRefs_1765.end(); ++itTypeBaseRef_1766)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_1767= *itTypeBaseRef_1766;
				CyPhyML::SignalFlow::SF_TypeBase typeBase_1768= currTypeBaseRef_1767.ref();
				if( !typeBase_1768)
					continue;
				SFC::DT dT_1769= typeBase_1768.dt();
				if( !dT_1769)
					continue;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_176d;
				if( !isValidBound(boundObjs_176d, state_1757, true))
					continue;
				currMatch.state_176e= state_1757;
				if( !isValidBound(boundObjs_176d, main_1760, true))
					continue;
				currMatch.main_176f= main_1760;
				if( !isValidBound(boundObjs_176d, typeBase_1768, false))
					continue;
				currMatch.typeBase_1770= typeBase_1768;
				if( !isValidBound(boundObjs_176d, dT_1769, false))
					continue;
				currMatch.dT_1771= dT_1769;
				if( !isValidBound(boundObjs_176d, currData_1764, false))
					continue;
				currMatch.data_1772= currData_1764;
				if( !isValidBound(boundObjs_176d, currTypeBaseRef_1767, false))
					continue;
				currMatch.typeBaseRef_1773= currTypeBaseRef_1767;
				bool Gz_guard= isGuardTrue( currMatch.dT_1771, currMatch.data_1772, currMatch.main_176f, currMatch.state_176e, currMatch.typeBase_1770, currMatch.typeBaseRef_1773);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void DataOutput_1747::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_177a= SFC::Arg::Create( currMatch.main_176f);
		SFC::Arg& Arg= newArg_177a;
		SFC::DT& DT= currMatch.dT_1771;
		CyPhyML::SignalFlow::Data& Data= currMatch.data_1772;
		SFC::Function& Main= currMatch.main_176f;
		CyPhyML::SignalFlow::State& State= currMatch.state_176e;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_1770;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_1773;
		{
			std::string fname = Main.name();
__int64 argIndex = static_cast< __int64 >( Main.argCount() ) + static_cast< __int64 >( Data.Port() ) - 1;
Arg.argIndex() = argIndex;
Arg.ptr() = true;

Arg.name() = static_cast< std::string >( Data.Name() ) + "_" + boost::lexical_cast< std::string >( argIndex );
};
		newArg_177a.dt()= currMatch.dT_1771;
		outputAppender( newArg_177a, currMatch.main_176f);
	}
}

void DataOutput_1747::outputAppender( const SFC::Arg& arg_177b, const SFC::Function& main_177d)
{
	_arg_174e->push_back( arg_177b);
	_main_174f->push_back( main_177d);
}

void EventOutput_1785::operator()( const Packets_t& states_1786, const Packets_t& functions_1788)
{
#ifdef PRINT_INFO
	printLog("EventOutput_1785" );
#endif
	if( ( !states_1786.empty())&& ( !functions_1788.empty()))
		callEventOutput_17c3( states_1786, functions_1788);
}

void EventOutput_1785::callEventOutput_17c3( const Packets_t& states_178b, const Packets_t& mains_178e)
{
	Packets_t args_178d;
	Packets_t mains_1790;
	EventOutput_178a eventOutput_178a;
	eventOutput_178a( states_178b, mains_178e, args_178d, mains_1790);
	if( ( !args_178d.empty())&& ( !mains_1790.empty()))
		callUpdateArgCount_17c6( args_178d, mains_1790);
}

void EventOutput_1785::callUpdateArgCount_17c6( const Packets_t& args_169a, const Packets_t& mains_169c)
{
	UpdateArgCount_1699 updateArgCount_1699;
	updateArgCount_1699( args_169a, mains_169c);
}

void EventOutput_178a::operator()( const Packets_t& states_178b, const Packets_t& mains_178e, Packets_t& args_178d, Packets_t& mains_1790)
{
#ifdef PRINT_INFO
	printLog("EventOutput_178a" );
#endif
	RTTGenerator::Instance()->generateRule(1260, "EventOutput");
	_arg_1791= &args_178d;
	_main_1792= &mains_1790;
	processInputPackets( states_178b, mains_178e);
}

bool EventOutput_178a::isInputUnique( const Udm::Object& state_1797, const Udm::Object& main_17a0)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itState_1799= _state_1793.begin(), itMain_17a2= _main_179c.begin(); itState_1799!= _state_1793.end(), itMain_17a2!= _main_179c.end(); ++itState_1799, ++itMain_17a2)
	{
		if( ( *itState_1799== state_1797)&& ( *itMain_17a2== main_17a0))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_state_1793.push_back( state_1797);
		_main_179c.push_back( main_17a0);
	}
	return isUnique;
}

bool EventOutput_178a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool EventOutput_178a::isGuardTrue( SFC::DT& DT, CyPhyML::SignalFlow::Event& Event, SFC::Function& Main, CyPhyML::SignalFlow::State& State, CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef, CyPhyML::SignalFlow::TypeStruct& TypeStruct)
{
	bool Gz_guard= false;
	Gz_guard = static_cast< std::string >( Event.Scope() ) == "OUTPUT_EVENT";;
	return Gz_guard;
}

void EventOutput_178a::processInputPackets( const Packets_t& states_178b, const Packets_t& mains_178e)
{
	for( Packets_t::const_iterator itState_1794= states_178b.begin(), itMain_179d= mains_178e.begin(); itState_1794!= states_178b.end(), itMain_179d!= mains_178e.end(); ++itState_1794, ++itMain_179d)
	{
		bool isUnique= isInputUnique( *itState_1794, *itMain_179d);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itState_1794, *itMain_179d);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool EventOutput_178a::patternMatcher( const Udm::Object& state_1795, const Udm::Object& main_179e)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( state_1795.type(), CyPhyML::SignalFlow::State::meta))
			continue;
		CyPhyML::SignalFlow::State state_179a= CyPhyML::SignalFlow::State::Cast( state_1795);
		if( false== Uml::IsDerivedFrom( main_179e.type(), SFC::Function::meta))
			continue;
		SFC::Function main_17a3= SFC::Function::Cast( main_179e);
		set< CyPhyML::SignalFlow::Event> events_17a5= state_179a.Event_kind_children();
		for( set< CyPhyML::SignalFlow::Event>::const_iterator itEvent_17a6= events_17a5.begin(); itEvent_17a6!= events_17a5.end(); ++itEvent_17a6)
		{
			CyPhyML::SignalFlow::Event currEvent_17a7= *itEvent_17a6;
			set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_17a8= currEvent_17a7.TypeBaseRef_kind_children();
			for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_17a9= typeBaseRefs_17a8.begin(); itTypeBaseRef_17a9!= typeBaseRefs_17a8.end(); ++itTypeBaseRef_17a9)
			{
				CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_17aa= *itTypeBaseRef_17a9;
				CyPhyML::SignalFlow::SF_TypeBase typeStruct_17ab= currTypeBaseRef_17aa.ref();
				if( false== Uml::IsDerivedFrom( typeStruct_17ab.type(), CyPhyML::SignalFlow::TypeStruct::meta))
					continue;
				CyPhyML::SignalFlow::TypeStruct typeStruct_17ac= CyPhyML::SignalFlow::TypeStruct::Cast( typeStruct_17ab);
				if( !typeStruct_17ac)
					continue;
				SFC::DT dT_17ad= typeStruct_17ac.dt();
				if( !dT_17ad)
					continue;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_17b1;
				if( !isValidBound(boundObjs_17b1, state_179a, true))
					continue;
				currMatch.state_17b2= state_179a;
				if( !isValidBound(boundObjs_17b1, main_17a3, true))
					continue;
				currMatch.main_17b3= main_17a3;
				if( !isValidBound(boundObjs_17b1, typeStruct_17ac, false))
					continue;
				currMatch.typeStruct_17b4= typeStruct_17ac;
				if( !isValidBound(boundObjs_17b1, dT_17ad, false))
					continue;
				currMatch.dT_17b5= dT_17ad;
				if( !isValidBound(boundObjs_17b1, currEvent_17a7, false))
					continue;
				currMatch.event_17b6= currEvent_17a7;
				if( !isValidBound(boundObjs_17b1, currTypeBaseRef_17aa, false))
					continue;
				currMatch.typeBaseRef_17b7= currTypeBaseRef_17aa;
				bool Gz_guard= isGuardTrue( currMatch.dT_17b5, currMatch.event_17b6, currMatch.main_17b3, currMatch.state_17b2, currMatch.typeBaseRef_17b7, currMatch.typeStruct_17b4);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void EventOutput_178a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Arg newArg_17be= SFC::Arg::Create( currMatch.main_17b3);
		SFC::Arg& Arg= newArg_17be;
		SFC::DT& DT= currMatch.dT_17b5;
		CyPhyML::SignalFlow::Event& Event= currMatch.event_17b6;
		SFC::Function& Main= currMatch.main_17b3;
		CyPhyML::SignalFlow::State& State= currMatch.state_17b2;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_17b7;
		CyPhyML::SignalFlow::TypeStruct& TypeStruct= currMatch.typeStruct_17b4;
		{
__int64 argIndex = static_cast< __int64 >( Main.argCount() ) + static_cast< __int64 >( Event.Port() ) - 1;
Arg.argIndex() = argIndex;
Arg.ptr() = true;

Arg.name() = static_cast< std::string >( Event.name() ) + "_" + boost::lexical_cast< std::string >( argIndex );
};
		newArg_17be.dt()= currMatch.dT_17b5;
		outputAppender( newArg_17be, currMatch.main_17b3);
	}
}

void EventOutput_178a::outputAppender( const SFC::Arg& arg_17bf, const SFC::Function& main_17c1)
{
	_arg_1791->push_back( arg_17bf);
	_main_1792->push_back( main_17c1);
}

void CreateSFChartFunction_17d5::operator()( const Packets_t& subsystems_17d7, Packets_t& states_17d6, Packets_t& mains_17d9)
{
#ifdef PRINT_INFO
	printLog("CreateSFChartFunction_17d5" );
#endif
	RTTGenerator::Instance()->generateRule(1275, "CreateSFChartFunction");
	_state_17da= &states_17d6;
	_main_17db= &mains_17d9;
	processInputPackets( subsystems_17d7);
}

bool CreateSFChartFunction_17d5::isInputUnique( const Udm::Object& subsystem_17e0)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_17e2= _subsystem_17dc.begin(); itSubsystem_17e2!= _subsystem_17dc.end(); ++itSubsystem_17e2)
	{
		if( ( *itSubsystem_17e2== subsystem_17e0))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_subsystem_17dc.push_back( subsystem_17e0);
	return isUnique;
}

bool CreateSFChartFunction_17d5::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateSFChartFunction_17d5::processInputPackets( const Packets_t& subsystems_17d7)
{
	for( Packets_t::const_iterator itSubsystem_17dd= subsystems_17d7.begin(); itSubsystem_17dd!= subsystems_17d7.end(); ++itSubsystem_17dd)
	{
		bool isUnique= isInputUnique( *itSubsystem_17dd);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_17dd);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateSFChartFunction_17d5::patternMatcher( const Udm::Object& subsystem_17de)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_17de.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_17e3= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_17de);
		set< CyPhyML::SignalFlow::SFState> states_17e5= subsystem_17e3.SFState_kind_children();
		for( set< CyPhyML::SignalFlow::SFState>::const_iterator itState_17e6= states_17e5.begin(); itState_17e6!= states_17e5.end(); ++itState_17e6)
		{
			CyPhyML::SignalFlow::SFState currState_17e7= *itState_17e6;
			SFC::Class class_17e8= subsystem_17e3.cls();
			if( !class_17e8)
				continue;
			set< SFC::Struct> structs_17e9= class_17e8.Struct_kind_children();
			for( set< SFC::Struct>::const_iterator itStruct_17ea= structs_17e9.begin(); itStruct_17ea!= structs_17e9.end(); ++itStruct_17ea)
			{
				SFC::Struct currStruct_17eb= *itStruct_17ea;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_17ef;
				if( !isValidBound(boundObjs_17ef, subsystem_17e3, true))
					continue;
				currMatch.subsystem_17f0= subsystem_17e3;
				if( !isValidBound(boundObjs_17ef, currState_17e7, false))
					continue;
				currMatch.state_17f1= currState_17e7;
				if( !isValidBound(boundObjs_17ef, class_17e8, false))
					continue;
				currMatch.class_17f2= class_17e8;
				if( !isValidBound(boundObjs_17ef, currStruct_17eb, false))
					continue;
				currMatch.struct_17f3= currStruct_17eb;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void CreateSFChartFunction_17d5::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Function newMain_17f4= SFC::Function::Create( currMatch.class_17f2, SFC::Class::meta_stmnt);
		SFC::Arg newArg_17f5= SFC::Arg::Create( newMain_17f4);
		SFC::Arg& Arg= newArg_17f5;
		SFC::Class& Class= currMatch.class_17f2;
		SFC::Function& Main= newMain_17f4;
		CyPhyML::SignalFlow::SFState& State= currMatch.state_17f1;
		SFC::Struct& Struct= currMatch.struct_17f3;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_17f0;
		{
Main.statementCount() = -1;
};
		{
__int64 statementCount = Class.statementCount();
Main.statementIndex() = statementCount++;
Class.statementCount() = statementCount;
};
		{
__int64 argCount = Main.argCount();
Arg.argIndex() = argCount++;
Main.argCount() = argCount;
Arg.name() = "context";
Arg.ptr() = true;
};
		{
Main.name() = static_cast< std::string >( State.name() ) + "_main";
};
		newMain_17f4.sysmain()+= currMatch.subsystem_17f0;
		newArg_17f5.dt()= currMatch.struct_17f3;
		outputAppender( currMatch.state_17f1, newMain_17f4);
	}
}

void CreateSFChartFunction_17d5::outputAppender( const CyPhyML::SignalFlow::SFState& state_17f6, const SFC::Function& main_17f8)
{
	_state_17da->push_back( state_17f6);
	_main_17db->push_back( main_17f8);
}

void CreateClasses_180d::operator()( const Packets_t& systems_180e, const Packets_t& programs_1810, Packets_t& systems_1812)
{
#ifdef PRINT_INFO
	printLog("CreateClasses_180d" );
#endif
	_system_1813= &systems_1812;
	_system_1813->insert( _system_1813->end(), systems_180e.begin(), systems_180e.end());
	if( ( !systems_180e.empty())&& ( !programs_1810.empty()))
		callCopyClass_19ad( systems_180e, programs_1810);
}

void CreateClasses_180d::callCopyClass_19ad( const Packets_t& systems_1815, const Packets_t& programs_1817)
{
	Packets_t systems_1819;
	Packets_t programs_181a;
	CopyClass_1814 copyClass_1814;
	copyClass_1814( systems_1815, programs_1817, systems_1819, programs_181a);
	if( ( !systems_1819.empty())&& ( !programs_181a.empty()))
		callGetSubSubsystems_19b0( systems_1819, programs_181a);
}

void CreateClasses_180d::callGetSubSubsystems_19b0( const Packets_t& subsystems_195a, const Packets_t& programs_195d)
{
	Packets_t subSubsystems_195c;
	Packets_t programs_195f;
	GetSubSubsystems_1959 getSubSubsystems_1959;
	getSubSubsystems_1959( subsystems_195a, programs_195d, subSubsystems_195c, programs_195f);
	if( ( !subSubsystems_195c.empty())&& ( !programs_195f.empty()))
		callSubsystemFilter_19b3( subSubsystems_195c, programs_195f);
}

void CreateClasses_180d::callSubsystemFilter_19b3( const Packets_t& systems_184d, const Packets_t& programs_184f)
{
	Packets_t systems_1851;
	Packets_t programs_1852;
	Packets_t systems_1853;
	Packets_t programs_1854;
	Packets_t systems_1855;
	Packets_t sFStates_1856;
	Packets_t programs_1857;
	Packets_t systems_1858;
	Packets_t programs_1859;
	SubsystemFilter_184c subsystemFilter_184c;
	subsystemFilter_184c( systems_184d, programs_184f, systems_1851, programs_1852, systems_1853, programs_1854, systems_1855, sFStates_1856, programs_1857, systems_1858, programs_1859);
	if( ( !systems_1853.empty())&& ( !programs_1854.empty()))
		callCreateChartClass_19b6( systems_1853, programs_1854);
	if( ( !systems_1858.empty())&& ( !programs_1859.empty()))
		callCreateClass_19b9( systems_1858, programs_1859);
	if( ( !systems_1851.empty())&& ( !programs_1852.empty()))
		callGetSubSubsystems_19b0( systems_1851, programs_1852);
	if( ( !systems_1855.empty())&& ( !sFStates_1856.empty())&& ( !programs_1857.empty()))
		callCreateSFChartClass_19bc( systems_1855, sFStates_1856, programs_1857);
}

void CreateClasses_180d::callCreateChartClass_19b6( const Packets_t& subsystems_193b, const Packets_t& programs_193d)
{
	CreateChartClass_193a createChartClass_193a;
	createChartClass_193a( subsystems_193b, programs_193d);
}

void CreateClasses_180d::callCreateClass_19b9( const Packets_t& subsystems_1918, const Packets_t& programs_191b)
{
	Packets_t subsystems_191a;
	Packets_t programs_191d;
	CreateClass_1917 createClass_1917;
	createClass_1917( subsystems_1918, programs_191b, subsystems_191a, programs_191d);
	if( ( !subsystems_191a.empty())&& ( !programs_191d.empty()))
		callCopyClass_19ad( subsystems_191a, programs_191d);
}

void CreateClasses_180d::callCreateSFChartClass_19bc( const Packets_t& subsystems_1983, const Packets_t& sFStates_1985, const Packets_t& programs_1987)
{
	CreateSFChartClass_1982 createSFChartClass_1982;
	createSFChartClass_1982( subsystems_1983, sFStates_1985, programs_1987);
}

void CopyClass_1814::operator()( const Packets_t& systems_1815, const Packets_t& programs_1817, Packets_t& systems_1819, Packets_t& programs_181a)
{
#ifdef PRINT_INFO
	printLog("CopyClass_1814" );
#endif
	_system_181b= &systems_1819;
	_program_181c= &programs_181a;
	_system_181b->insert( _system_181b->end(), systems_1815.begin(), systems_1815.end());
	_program_181c->insert( _program_181c->end(), programs_1817.begin(), programs_1817.end());
	if( ( !systems_1815.empty())&& ( !programs_1817.empty()))
		callCopyClass_1849( systems_1815, programs_1817);
}

void CopyClass_1814::callCopyClass_1849( const Packets_t& subsystems_181e, const Packets_t& programs_1820)
{
	CopyClass_181d copyClass_181d;
	copyClass_181d( subsystems_181e, programs_1820);
}

void CopyClass_181d::operator()( const Packets_t& subsystems_181e, const Packets_t& programs_1820)
{
#ifdef PRINT_INFO
	printLog("CopyClass_181d" );
#endif
	RTTGenerator::Instance()->generateRule(1302, "CopyClass");
	processInputPackets( subsystems_181e, programs_1820);
}

bool CopyClass_181d::isInputUnique( const Udm::Object& subsystem_1826, const Udm::Object& program_182f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1828= _subsystem_1822.begin(), itProgram_1831= _program_182b.begin(); itSubsystem_1828!= _subsystem_1822.end(), itProgram_1831!= _program_182b.end(); ++itSubsystem_1828, ++itProgram_1831)
	{
		if( ( *itSubsystem_1828== subsystem_1826)&& ( *itProgram_1831== program_182f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1822.push_back( subsystem_1826);
		_program_182b.push_back( program_182f);
	}
	return isUnique;
}

bool CopyClass_181d::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool CopyClass_181d::isGuardTrue( SFC::Class& Class, CyPhyML::SignalFlow::Subsystem& InstanceSubsystem, SFC::Program& Program, CyPhyML::SignalFlow::Subsystem& Subsystem)
{
	bool Gz_guard= false;
	Gz_guard = Subsystem.uniqueId() != InstanceSubsystem.uniqueId();;
	return Gz_guard;
}

void CopyClass_181d::processInputPackets( const Packets_t& subsystems_181e, const Packets_t& programs_1820)
{
	for( Packets_t::const_iterator itSubsystem_1823= subsystems_181e.begin(), itProgram_182c= programs_1820.begin(); itSubsystem_1823!= subsystems_181e.end(), itProgram_182c!= programs_1820.end(); ++itSubsystem_1823, ++itProgram_182c)
	{
		bool isUnique= isInputUnique( *itSubsystem_1823, *itProgram_182c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1823, *itProgram_182c);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CopyClass_181d::patternMatcher( const Udm::Object& subsystem_1824, const Udm::Object& program_182d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1824.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1829= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1824);
		if( false== Uml::IsDerivedFrom( program_182d.type(), SFC::Program::meta))
			continue;
		SFC::Program program_1832= SFC::Program::Cast( program_182d);
		set< SFC::Class> classs_1834= program_1832.Class_kind_children();
		for( set< SFC::Class>::const_iterator itClass_1835= classs_1834.begin(); itClass_1835!= classs_1834.end(); ++itClass_1835)
		{
			SFC::Class currClass_1836= *itClass_1835;
			SFC::Class class_1837= subsystem_1829.cls();
			if( !class_1837)
				continue;
			if( currClass_1836!= class_1837)
				continue;
			set< CyPhyML::SignalFlow::Subsystem> instanceSubsystems_1838= currClass_1836.obj();
			for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itInstanceSubsystems_1839= instanceSubsystems_1838.begin(); itInstanceSubsystems_1839!= instanceSubsystems_1838.end(); ++itInstanceSubsystems_1839)
			{
				CyPhyML::SignalFlow::Subsystem currInstanceSubsystem_183a= *itInstanceSubsystems_1839;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_183e;
				if( !isValidBound(boundObjs_183e, subsystem_1829, true))
					continue;
				currMatch.subsystem_183f= subsystem_1829;
				if( !isValidBound(boundObjs_183e, program_1832, true))
					continue;
				currMatch.program_1840= program_1832;
				if( !isValidBound(boundObjs_183e, currClass_1836, false))
					continue;
				currMatch.class_1841= currClass_1836;
				if( !isValidBound(boundObjs_183e, currInstanceSubsystem_183a, false))
					continue;
				currMatch.instanceSubsystem_1842= currInstanceSubsystem_183a;
				bool Gz_guard= isGuardTrue( currMatch.class_1841, currMatch.instanceSubsystem_1842, currMatch.program_1840, currMatch.subsystem_183f);
				if( true== Gz_guard)
					_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void CopyClass_181d::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Class newInstanceClass_1847= SFC::Class::Create( currMatch.program_1840, SFC::Program::meta_stmnt);
		SFC::Struct newInstanceStruct_1848= SFC::Struct::Create( newInstanceClass_1847, SFC::Class::meta_stmnt);
		SFC::Class& Class= currMatch.class_1841;
		SFC::Class& InstanceClass= newInstanceClass_1847;
		SFC::Struct& InstanceStruct= newInstanceStruct_1848;
		CyPhyML::SignalFlow::Subsystem& InstanceSubsystem= currMatch.instanceSubsystem_1842;
		SFC::Program& Program= currMatch.program_1840;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_183f;
		{
__int64 statementCount = InstanceClass.statementCount();
InstanceStruct.statementIndex() = statementCount++;
InstanceClass.statementCount() = statementCount;
};
		{
std::string name = static_cast< std::string >( InstanceSubsystem.name() ) + "_" + boost::lexical_cast< std::string >( InstanceClass.uniqueId() );
InstanceClass.name() = name+ "_class";
InstanceClass.annotation() = InstanceSubsystem.Description();
InstanceStruct.name() = name + "_context";
};
		{
__int64 statementCount = Program.statementCount();
InstanceClass.statementIndex() = statementCount++;
Program.statementCount() = statementCount;
};
		currMatch.instanceSubsystem_1842.cls()= newInstanceClass_1847;
	}
}

void SubsystemFilter_184c::operator()( const Packets_t& systems_184d, const Packets_t& programs_184f, Packets_t& systems_1851, Packets_t& programs_1852, Packets_t& systems_1853, Packets_t& programs_1854, Packets_t& systems_1855, Packets_t& sFStates_1856, Packets_t& programs_1857, Packets_t& systems_1858, Packets_t& programs_1859)
{
#ifdef PRINT_INFO
	printLog("SubsystemFilter_184c" );
#endif
	_system_185a= &systems_1851;
	_program_185b= &programs_1852;
	_system_185c= &systems_1853;
	_program_185d= &programs_1854;
	_system_185e= &systems_1855;
	_sFState_185f= &sFStates_1856;
	_program_1860= &programs_1857;
	_system_1861= &systems_1858;
	_program_1862= &programs_1859;
	for( Packets_t::const_iterator itsystem_1864= systems_184d.begin(), itprogram_186b= programs_184f.begin(); itsystem_1864!= systems_184d.end(), itprogram_186b!= programs_184f.end(); ++itsystem_1864, ++itprogram_186b)
	{
		bool isUnique= isInputUnique( *itsystem_1864, *itprogram_186b);
		if( !isUnique)
			continue;
		Packets_t onesystem_1868( 1, *itsystem_1864);
		Packets_t oneprogram_186f( 1, *itprogram_186b);
		executeOne( onesystem_1868, oneprogram_186f);
	}
}

void SubsystemFilter_184c::executeOne( const Packets_t& systems_184d, const Packets_t& programs_184f)
{
	Packets_t subsystems_1874;
	Packets_t programs_1877;
	HasClass_1871 hasClass_1871;
	bool isMatchHasClass_1871= hasClass_1871( systems_184d, programs_184f, subsystems_1874, programs_1877);
	_system_185a->insert( _system_185a->end(), subsystems_1874.begin(), subsystems_1874.end());
	_program_185b->insert( _program_185b->end(), programs_1877.begin(), programs_1877.end());
	if( isMatchHasClass_1871)
		return;
	Packets_t subsystems_189b;
	Packets_t programs_189e;
	IsStateChart_1898 isStateChart_1898;
	bool isMatchIsStateChart_1898= isStateChart_1898( systems_184d, programs_184f, subsystems_189b, programs_189e);
	_system_185c->insert( _system_185c->end(), subsystems_189b.begin(), subsystems_189b.end());
	_program_185d->insert( _program_185d->end(), programs_189e.begin(), programs_189e.end());
	if( isMatchIsStateChart_1898)
		return;
	Packets_t subsystems_18c8;
	Packets_t sFStates_18c9;
	Packets_t programs_18cc;
	IsSFStateChart_18c5 isSFStateChart_18c5;
	bool isMatchIsSFStateChart_18c5= isSFStateChart_18c5( systems_184d, programs_184f, subsystems_18c8, sFStates_18c9, programs_18cc);
	_system_185e->insert( _system_185e->end(), subsystems_18c8.begin(), subsystems_18c8.end());
	_sFState_185f->insert( _sFState_185f->end(), sFStates_18c9.begin(), sFStates_18c9.end());
	_program_1860->insert( _program_1860->end(), programs_18cc.begin(), programs_18cc.end());
	if( isMatchIsSFStateChart_18c5)
		return;
	Packets_t subsystems_18f5;
	Packets_t programs_18f8;
	Otherwise_18f2 otherwise_18f2;
	bool isMatchOtherwise_18f2= otherwise_18f2( systems_184d, programs_184f, subsystems_18f5, programs_18f8);
	_system_1861->insert( _system_1861->end(), subsystems_18f5.begin(), subsystems_18f5.end());
	_program_1862->insert( _program_1862->end(), programs_18f8.begin(), programs_18f8.end());
	if( isMatchOtherwise_18f2)
		return;
}

bool SubsystemFilter_184c::isInputUnique( const Udm::Object& system_1865, const Udm::Object& program_186c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itsystem_1867= _system_1863.begin(), itprogram_186e= _program_186a.begin(); itsystem_1867!= _system_1863.end(), itprogram_186e!= _program_186a.end(); ++itsystem_1867, ++itprogram_186e)
	{
		if( ( *itsystem_1867== system_1865)&& ( *itprogram_186e== program_186c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_system_1863.push_back( system_1865);
		_program_186a.push_back( program_186c);
	}
	return isUnique;
}

bool HasClass_1871::operator()( const Packets_t& subsystems_1872, const Packets_t& programs_1875, Packets_t& subsystems_1874, Packets_t& programs_1877)
{
#ifdef PRINT_INFO
	printLog("HasClass_1871" );
#endif
	_subsystem_1878= &subsystems_1874;
	_program_1879= &programs_1877;
	processInputPackets( subsystems_1872, programs_1875);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasClass_1871::isInputUnique( const Udm::Object& subsystem_187e, const Udm::Object& program_1887)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1880= _subsystem_187a.begin(), itProgram_1889= _program_1883.begin(); itSubsystem_1880!= _subsystem_187a.end(), itProgram_1889!= _program_1883.end(); ++itSubsystem_1880, ++itProgram_1889)
	{
		if( ( *itSubsystem_1880== subsystem_187e)&& ( *itProgram_1889== program_1887))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_187a.push_back( subsystem_187e);
		_program_1883.push_back( program_1887);
	}
	return isUnique;
}

bool HasClass_1871::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void HasClass_1871::processInputPackets( const Packets_t& subsystems_1872, const Packets_t& programs_1875)
{
	for( Packets_t::const_iterator itSubsystem_187b= subsystems_1872.begin(), itProgram_1884= programs_1875.begin(); itSubsystem_187b!= subsystems_1872.end(), itProgram_1884!= programs_1875.end(); ++itSubsystem_187b, ++itProgram_1884)
	{
		bool isUnique= isInputUnique( *itSubsystem_187b, *itProgram_1884);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_187b, *itProgram_1884);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_1891, currMatch.program_1892);
	}
}

bool HasClass_1871::patternMatcher( const Udm::Object& subsystem_187c, const Udm::Object& program_1885)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_187c.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1881= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_187c);
		if( false== Uml::IsDerivedFrom( program_1885.type(), SFC::Program::meta))
			continue;
		SFC::Program program_188a= SFC::Program::Cast( program_1885);
		SFC::Class class_188c= subsystem_1881.cls();
		if( !class_188c)
			continue;
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1890;
		if( !isValidBound(boundObjs_1890, subsystem_1881, true))
			continue;
		currMatch.subsystem_1891= subsystem_1881;
		if( !isValidBound(boundObjs_1890, program_188a, true))
			continue;
		currMatch.program_1892= program_188a;
		if( !isValidBound(boundObjs_1890, class_188c, false))
			continue;
		currMatch.class_1893= class_188c;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void HasClass_1871::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1894, const SFC::Program& program_1896)
{
	_subsystem_1878->push_back( subsystem_1894);
	_program_1879->push_back( program_1896);
}

bool IsStateChart_1898::operator()( const Packets_t& subsystems_1899, const Packets_t& programs_189c, Packets_t& subsystems_189b, Packets_t& programs_189e)
{
#ifdef PRINT_INFO
	printLog("IsStateChart_1898" );
#endif
	_subsystem_189f= &subsystems_189b;
	_program_18a0= &programs_189e;
	processInputPackets( subsystems_1899, programs_189c);
	if( false== _matches.empty())
		return true;
	return false;
}

bool IsStateChart_1898::isInputUnique( const Udm::Object& subsystem_18a5, const Udm::Object& program_18ae)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_18a7= _subsystem_18a1.begin(), itProgram_18b0= _program_18aa.begin(); itSubsystem_18a7!= _subsystem_18a1.end(), itProgram_18b0!= _program_18aa.end(); ++itSubsystem_18a7, ++itProgram_18b0)
	{
		if( ( *itSubsystem_18a7== subsystem_18a5)&& ( *itProgram_18b0== program_18ae))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_18a1.push_back( subsystem_18a5);
		_program_18aa.push_back( program_18ae);
	}
	return isUnique;
}

bool IsStateChart_1898::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void IsStateChart_1898::processInputPackets( const Packets_t& subsystems_1899, const Packets_t& programs_189c)
{
	for( Packets_t::const_iterator itSubsystem_18a2= subsystems_1899.begin(), itProgram_18ab= programs_189c.begin(); itSubsystem_18a2!= subsystems_1899.end(), itProgram_18ab!= programs_189c.end(); ++itSubsystem_18a2, ++itProgram_18ab)
	{
		bool isUnique= isInputUnique( *itSubsystem_18a2, *itProgram_18ab);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_18a2, *itProgram_18ab);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_18bd, currMatch.program_18be);
	}
}

bool IsStateChart_1898::patternMatcher( const Udm::Object& subsystem_18a3, const Udm::Object& program_18ac)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_18a3.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_18a8= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_18a3);
		if( false== Uml::IsDerivedFrom( program_18ac.type(), SFC::Program::meta))
			continue;
		SFC::Program program_18b1= SFC::Program::Cast( program_18ac);
		set< CyPhyML::SignalFlow::Primitive> primitives_18b3= subsystem_18a8.Primitive_kind_children();
		for( set< CyPhyML::SignalFlow::Primitive>::const_iterator itPrimitive_18b4= primitives_18b3.begin(); itPrimitive_18b4!= primitives_18b3.end(); ++itPrimitive_18b4)
		{
			CyPhyML::SignalFlow::Primitive currPrimitive_18b5= *itPrimitive_18b4;
			set< CyPhyML::SignalFlow::State> states_18b6= currPrimitive_18b5.State_kind_children();
			for( set< CyPhyML::SignalFlow::State>::const_iterator itState_18b7= states_18b6.begin(); itState_18b7!= states_18b6.end(); ++itState_18b7)
			{
				CyPhyML::SignalFlow::State currState_18b8= *itState_18b7;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_18bc;
				if( !isValidBound(boundObjs_18bc, subsystem_18a8, true))
					continue;
				currMatch.subsystem_18bd= subsystem_18a8;
				if( !isValidBound(boundObjs_18bc, program_18b1, true))
					continue;
				currMatch.program_18be= program_18b1;
				if( !isValidBound(boundObjs_18bc, currPrimitive_18b5, false))
					continue;
				currMatch.primitive_18bf= currPrimitive_18b5;
				if( !isValidBound(boundObjs_18bc, currState_18b8, false))
					continue;
				currMatch.state_18c0= currState_18b8;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void IsStateChart_1898::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_18c1, const SFC::Program& program_18c3)
{
	_subsystem_189f->push_back( subsystem_18c1);
	_program_18a0->push_back( program_18c3);
}

bool IsSFStateChart_18c5::operator()( const Packets_t& subsystems_18c6, const Packets_t& programs_18ca, Packets_t& subsystems_18c8, Packets_t& sFStates_18c9, Packets_t& programs_18cc)
{
#ifdef PRINT_INFO
	printLog("IsSFStateChart_18c5" );
#endif
	_subsystem_18cd= &subsystems_18c8;
	_sFState_18ce= &sFStates_18c9;
	_program_18cf= &programs_18cc;
	processInputPackets( subsystems_18c6, programs_18ca);
	if( false== _matches.empty())
		return true;
	return false;
}

bool IsSFStateChart_18c5::isInputUnique( const Udm::Object& subsystem_18d4, const Udm::Object& program_18dd)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_18d6= _subsystem_18d0.begin(), itProgram_18df= _program_18d9.begin(); itSubsystem_18d6!= _subsystem_18d0.end(), itProgram_18df!= _program_18d9.end(); ++itSubsystem_18d6, ++itProgram_18df)
	{
		if( ( *itSubsystem_18d6== subsystem_18d4)&& ( *itProgram_18df== program_18dd))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_18d0.push_back( subsystem_18d4);
		_program_18d9.push_back( program_18dd);
	}
	return isUnique;
}

bool IsSFStateChart_18c5::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void IsSFStateChart_18c5::processInputPackets( const Packets_t& subsystems_18c6, const Packets_t& programs_18ca)
{
	for( Packets_t::const_iterator itSubsystem_18d1= subsystems_18c6.begin(), itProgram_18da= programs_18ca.begin(); itSubsystem_18d1!= subsystems_18c6.end(), itProgram_18da!= programs_18ca.end(); ++itSubsystem_18d1, ++itProgram_18da)
	{
		bool isUnique= isInputUnique( *itSubsystem_18d1, *itProgram_18da);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_18d1, *itProgram_18da);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_18e9, currMatch.sFState_18eb, currMatch.program_18ea);
	}
}

bool IsSFStateChart_18c5::patternMatcher( const Udm::Object& subsystem_18d2, const Udm::Object& program_18db)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_18d2.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_18d7= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_18d2);
		if( false== Uml::IsDerivedFrom( program_18db.type(), SFC::Program::meta))
			continue;
		SFC::Program program_18e0= SFC::Program::Cast( program_18db);
		set< CyPhyML::SignalFlow::SFState> sFStates_18e2= subsystem_18d7.SFState_kind_children();
		for( set< CyPhyML::SignalFlow::SFState>::const_iterator itSFState_18e3= sFStates_18e2.begin(); itSFState_18e3!= sFStates_18e2.end(); ++itSFState_18e3)
		{
			CyPhyML::SignalFlow::SFState currSFState_18e4= *itSFState_18e3;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_18e8;
			if( !isValidBound(boundObjs_18e8, subsystem_18d7, true))
				continue;
			currMatch.subsystem_18e9= subsystem_18d7;
			if( !isValidBound(boundObjs_18e8, program_18e0, true))
				continue;
			currMatch.program_18ea= program_18e0;
			if( !isValidBound(boundObjs_18e8, currSFState_18e4, false))
				continue;
			currMatch.sFState_18eb= currSFState_18e4;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void IsSFStateChart_18c5::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_18ec, const CyPhyML::SignalFlow::SFState& sFState_18ee, const SFC::Program& program_18f0)
{
	_subsystem_18cd->push_back( subsystem_18ec);
	_sFState_18ce->push_back( sFState_18ee);
	_program_18cf->push_back( program_18f0);
}

bool Otherwise_18f2::operator()( const Packets_t& subsystems_18f3, const Packets_t& programs_18f6, Packets_t& subsystems_18f5, Packets_t& programs_18f8)
{
#ifdef PRINT_INFO
	printLog("Otherwise_18f2" );
#endif
	_subsystem_18f9= &subsystems_18f5;
	_program_18fa= &programs_18f8;
	processInputPackets( subsystems_18f3, programs_18f6);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_18f2::isInputUnique( const Udm::Object& subsystem_18ff, const Udm::Object& program_1908)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1901= _subsystem_18fb.begin(), itProgram_190a= _program_1904.begin(); itSubsystem_1901!= _subsystem_18fb.end(), itProgram_190a!= _program_1904.end(); ++itSubsystem_1901, ++itProgram_190a)
	{
		if( ( *itSubsystem_1901== subsystem_18ff)&& ( *itProgram_190a== program_1908))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_18fb.push_back( subsystem_18ff);
		_program_1904.push_back( program_1908);
	}
	return isUnique;
}

bool Otherwise_18f2::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_18f2::processInputPackets( const Packets_t& subsystems_18f3, const Packets_t& programs_18f6)
{
	for( Packets_t::const_iterator itSubsystem_18fc= subsystems_18f3.begin(), itProgram_1905= programs_18f6.begin(); itSubsystem_18fc!= subsystems_18f3.end(), itProgram_1905!= programs_18f6.end(); ++itSubsystem_18fc, ++itProgram_1905)
	{
		bool isUnique= isInputUnique( *itSubsystem_18fc, *itProgram_1905);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_18fc, *itProgram_1905);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_1911, currMatch.program_1912);
	}
}

bool Otherwise_18f2::patternMatcher( const Udm::Object& subsystem_18fd, const Udm::Object& program_1906)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_18fd.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1902= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_18fd);
		if( false== Uml::IsDerivedFrom( program_1906.type(), SFC::Program::meta))
			continue;
		SFC::Program program_190b= SFC::Program::Cast( program_1906);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1910;
		if( !isValidBound(boundObjs_1910, subsystem_1902, true))
			continue;
		currMatch.subsystem_1911= subsystem_1902;
		if( !isValidBound(boundObjs_1910, program_190b, true))
			continue;
		currMatch.program_1912= program_190b;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_18f2::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1913, const SFC::Program& program_1915)
{
	_subsystem_18f9->push_back( subsystem_1913);
	_program_18fa->push_back( program_1915);
}

void CreateClass_1917::operator()( const Packets_t& subsystems_1918, const Packets_t& programs_191b, Packets_t& subsystems_191a, Packets_t& programs_191d)
{
#ifdef PRINT_INFO
	printLog("CreateClass_1917" );
#endif
	RTTGenerator::Instance()->generateRule(1350, "CreateClass");
	_subsystem_191e= &subsystems_191a;
	_program_191f= &programs_191d;
	processInputPackets( subsystems_1918, programs_191b);
	forwardInputs( );
}

bool CreateClass_1917::isInputUnique( const Udm::Object& subsystem_1924, const Udm::Object& program_192d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1926= _subsystem_1920.begin(), itProgram_192f= _program_1929.begin(); itSubsystem_1926!= _subsystem_1920.end(), itProgram_192f!= _program_1929.end(); ++itSubsystem_1926, ++itProgram_192f)
	{
		if( ( *itSubsystem_1926== subsystem_1924)&& ( *itProgram_192f== program_192d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1920.push_back( subsystem_1924);
		_program_1929.push_back( program_192d);
	}
	return isUnique;
}

bool CreateClass_1917::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateClass_1917::processInputPackets( const Packets_t& subsystems_1918, const Packets_t& programs_191b)
{
	for( Packets_t::const_iterator itSubsystem_1921= subsystems_1918.begin(), itProgram_192a= programs_191b.begin(); itSubsystem_1921!= subsystems_1918.end(), itProgram_192a!= programs_191b.end(); ++itSubsystem_1921, ++itProgram_192a)
	{
		bool isUnique= isInputUnique( *itSubsystem_1921, *itProgram_192a);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1921, *itProgram_192a);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateClass_1917::patternMatcher( const Udm::Object& subsystem_1922, const Udm::Object& program_192b)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1922.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1927= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1922);
		if( false== Uml::IsDerivedFrom( program_192b.type(), SFC::Program::meta))
			continue;
		SFC::Program program_1930= SFC::Program::Cast( program_192b);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1935;
		if( !isValidBound(boundObjs_1935, subsystem_1927, true))
			continue;
		currMatch.subsystem_1936= subsystem_1927;
		if( !isValidBound(boundObjs_1935, program_1930, true))
			continue;
		currMatch.program_1937= program_1930;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateClass_1917::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Class newClass_1938= SFC::Class::Create( currMatch.program_1937, SFC::Program::meta_stmnt);
		SFC::Struct newStruct_1939= SFC::Struct::Create( newClass_1938, SFC::Class::meta_stmnt);
		SFC::Class& Class= newClass_1938;
		SFC::Program& Program= currMatch.program_1937;
		SFC::Struct& Struct= newStruct_1939;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_1936;
		{
__int64 statementCount = Program.statementCount();
Class.statementIndex() = statementCount++;
Program.statementCount() = statementCount;
};
		{
typedef std::set< Udm::Object > ObjectSet;

ObjectSet objectSet = SFUtils::getAllInstanceEquivalent( Subsystem );
objectSet.erase( Subsystem );

for( ObjectSet::iterator obsItr = objectSet.begin() ; obsItr != objectSet.end() ; (void)++obsItr ) {
  CyPhyML::SignalFlow::Subsystem::Cast( *obsItr ).cls() = Class;
}
};
		{
std::string name = static_cast< std::string >( Subsystem.name() ) + "_" + boost::lexical_cast< std::string >( Subsystem.uniqueId() );
Class.name() = name + "_class";
Class.annotation() = Subsystem.Description();
Struct.name() = name + "_context";
};
		{
__int64 statementCount = Class.statementCount();
Struct.statementIndex() = statementCount++;
Class.statementCount() = statementCount;
};
		currMatch.subsystem_1936.cls()= newClass_1938;
	}
}

void CreateClass_1917::forwardInputs()
{
	*_subsystem_191e= _subsystem_1920;
	*_program_191f= _program_1929;
}

void CreateChartClass_193a::operator()( const Packets_t& subsystems_193b, const Packets_t& programs_193d)
{
#ifdef PRINT_INFO
	printLog("CreateChartClass_193a" );
#endif
	RTTGenerator::Instance()->generateRule(1362, "CreateChartClass");
	processInputPackets( subsystems_193b, programs_193d);
}

bool CreateChartClass_193a::isInputUnique( const Udm::Object& subsystem_1943, const Udm::Object& program_194c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1945= _subsystem_193f.begin(), itProgram_194e= _program_1948.begin(); itSubsystem_1945!= _subsystem_193f.end(), itProgram_194e!= _program_1948.end(); ++itSubsystem_1945, ++itProgram_194e)
	{
		if( ( *itSubsystem_1945== subsystem_1943)&& ( *itProgram_194e== program_194c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_193f.push_back( subsystem_1943);
		_program_1948.push_back( program_194c);
	}
	return isUnique;
}

bool CreateChartClass_193a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateChartClass_193a::processInputPackets( const Packets_t& subsystems_193b, const Packets_t& programs_193d)
{
	for( Packets_t::const_iterator itSubsystem_1940= subsystems_193b.begin(), itProgram_1949= programs_193d.begin(); itSubsystem_1940!= subsystems_193b.end(), itProgram_1949!= programs_193d.end(); ++itSubsystem_1940, ++itProgram_1949)
	{
		bool isUnique= isInputUnique( *itSubsystem_1940, *itProgram_1949);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1940, *itProgram_1949);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateChartClass_193a::patternMatcher( const Udm::Object& subsystem_1941, const Udm::Object& program_194a)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1941.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1946= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1941);
		if( false== Uml::IsDerivedFrom( program_194a.type(), SFC::Program::meta))
			continue;
		SFC::Program program_194f= SFC::Program::Cast( program_194a);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1954;
		if( !isValidBound(boundObjs_1954, subsystem_1946, true))
			continue;
		currMatch.subsystem_1955= subsystem_1946;
		if( !isValidBound(boundObjs_1954, program_194f, true))
			continue;
		currMatch.program_1956= program_194f;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateChartClass_193a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Class newClass_1957= SFC::Class::Create( currMatch.program_1956, SFC::Program::meta_stmnt);
		SFC::Struct newStruct_1958= SFC::Struct::Create( newClass_1957, SFC::Class::meta_stmnt);
		SFC::Class& Class= newClass_1957;
		SFC::Program& Program= currMatch.program_1956;
		SFC::Struct& Struct= newStruct_1958;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_1955;
		{
__int64 statementCount = Class.statementCount();
Struct.statementIndex() = statementCount++;
Class.statementCount() = statementCount;
};
		{
std::string name = Subsystem.name();

Class.name() = name;
Struct.name() = name + "_context";
};
		{
typedef std::set< Udm::Object > ObjectSet;

ObjectSet objectSet = SFUtils::getAllInstanceEquivalent( Subsystem );
objectSet.erase( Subsystem );

for( ObjectSet::iterator obsItr = objectSet.begin() ; obsItr != objectSet.end() ; (void)++obsItr ) {
  CyPhyML::SignalFlow::Subsystem::Cast( *obsItr ).cls() = Class;
}
};
		{
__int64 statementCount = Program.statementCount();
Class.statementIndex() = statementCount++;
Program.statementCount() = statementCount;
};
		{
Struct.memberCount() = -1;
};
		currMatch.subsystem_1955.cls()= newClass_1957;
	}
}

void GetSubSubsystems_1959::operator()( const Packets_t& subsystems_195a, const Packets_t& programs_195d, Packets_t& subSubsystems_195c, Packets_t& programs_195f)
{
#ifdef PRINT_INFO
	printLog("GetSubSubsystems_1959" );
#endif
	RTTGenerator::Instance()->generateRule(1375, "GetSubSubsystems");
	_subSubsystem_1960= &subSubsystems_195c;
	_program_1961= &programs_195f;
	processInputPackets( subsystems_195a, programs_195d);
}

bool GetSubSubsystems_1959::isInputUnique( const Udm::Object& subsystem_1966, const Udm::Object& program_196f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1968= _subsystem_1962.begin(), itProgram_1971= _program_196b.begin(); itSubsystem_1968!= _subsystem_1962.end(), itProgram_1971!= _program_196b.end(); ++itSubsystem_1968, ++itProgram_1971)
	{
		if( ( *itSubsystem_1968== subsystem_1966)&& ( *itProgram_1971== program_196f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1962.push_back( subsystem_1966);
		_program_196b.push_back( program_196f);
	}
	return isUnique;
}

bool GetSubSubsystems_1959::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetSubSubsystems_1959::processInputPackets( const Packets_t& subsystems_195a, const Packets_t& programs_195d)
{
	for( Packets_t::const_iterator itSubsystem_1963= subsystems_195a.begin(), itProgram_196c= programs_195d.begin(); itSubsystem_1963!= subsystems_195a.end(), itProgram_196c!= programs_195d.end(); ++itSubsystem_1963, ++itProgram_196c)
	{
		bool isUnique= isInputUnique( *itSubsystem_1963, *itProgram_196c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1963, *itProgram_196c);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetSubSubsystems_1959::patternMatcher( const Udm::Object& subsystem_1964, const Udm::Object& program_196d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1964.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1969= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1964);
		if( false== Uml::IsDerivedFrom( program_196d.type(), SFC::Program::meta))
			continue;
		SFC::Program program_1972= SFC::Program::Cast( program_196d);
		set< CyPhyML::SignalFlow::Subsystem> subSubsystems_1974= subsystem_1969.Subsystem_kind_children();
		for( set< CyPhyML::SignalFlow::Subsystem>::const_iterator itSubSubsystem_1975= subSubsystems_1974.begin(); itSubSubsystem_1975!= subSubsystems_1974.end(); ++itSubSubsystem_1975)
		{
			CyPhyML::SignalFlow::Subsystem currSubSubsystem_1976= *itSubSubsystem_1975;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_197a;
			if( !isValidBound(boundObjs_197a, subsystem_1969, true))
				continue;
			currMatch.subsystem_197b= subsystem_1969;
			if( !isValidBound(boundObjs_197a, program_1972, true))
				continue;
			currMatch.program_197c= program_1972;
			if( !isValidBound(boundObjs_197a, currSubSubsystem_1976, false))
				continue;
			currMatch.subSubsystem_197d= currSubSubsystem_1976;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetSubSubsystems_1959::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subSubsystem_197d, currMatch.program_197c);
	}
}

void GetSubSubsystems_1959::outputAppender( const CyPhyML::SignalFlow::Subsystem& subSubsystem_197e, const SFC::Program& program_1980)
{
	_subSubsystem_1960->push_back( subSubsystem_197e);
	_program_1961->push_back( program_1980);
}

void CreateSFChartClass_1982::operator()( const Packets_t& subsystems_1983, const Packets_t& sFStates_1985, const Packets_t& programs_1987)
{
#ifdef PRINT_INFO
	printLog("CreateSFChartClass_1982" );
#endif
	RTTGenerator::Instance()->generateRule(1380, "CreateSFChartClass");
	processInputPackets( subsystems_1983, sFStates_1985, programs_1987);
}

bool CreateSFChartClass_1982::isInputUnique( const Udm::Object& subsystem_198d, const Udm::Object& sFState_1996, const Udm::Object& program_199f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_198f= _subsystem_1989.begin(), itSFState_1998= _sFState_1992.begin(), itProgram_19a1= _program_199b.begin(); itSubsystem_198f!= _subsystem_1989.end(), itSFState_1998!= _sFState_1992.end(), itProgram_19a1!= _program_199b.end(); ++itSubsystem_198f, ++itSFState_1998, ++itProgram_19a1)
	{
		if( ( *itSubsystem_198f== subsystem_198d)&& ( *itSFState_1998== sFState_1996)&& ( *itProgram_19a1== program_199f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1989.push_back( subsystem_198d);
		_sFState_1992.push_back( sFState_1996);
		_program_199b.push_back( program_199f);
	}
	return isUnique;
}

bool CreateSFChartClass_1982::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateSFChartClass_1982::processInputPackets( const Packets_t& subsystems_1983, const Packets_t& sFStates_1985, const Packets_t& programs_1987)
{
	for( Packets_t::const_iterator itSubsystem_198a= subsystems_1983.begin(), itSFState_1993= sFStates_1985.begin(), itProgram_199c= programs_1987.begin(); itSubsystem_198a!= subsystems_1983.end(), itSFState_1993!= sFStates_1985.end(), itProgram_199c!= programs_1987.end(); ++itSubsystem_198a, ++itSFState_1993, ++itProgram_199c)
	{
		bool isUnique= isInputUnique( *itSubsystem_198a, *itSFState_1993, *itProgram_199c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_198a, *itSFState_1993, *itProgram_199c);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateSFChartClass_1982::patternMatcher( const Udm::Object& subsystem_198b, const Udm::Object& sFState_1994, const Udm::Object& program_199d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_198b.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1990= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_198b);
		if( false== Uml::IsDerivedFrom( sFState_1994.type(), CyPhyML::SignalFlow::SFState::meta))
			continue;
		CyPhyML::SignalFlow::SFState sFState_1999= CyPhyML::SignalFlow::SFState::Cast( sFState_1994);
		if( false== Uml::IsDerivedFrom( program_199d.type(), SFC::Program::meta))
			continue;
		SFC::Program program_19a2= SFC::Program::Cast( program_199d);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_19a7;
		if( !isValidBound(boundObjs_19a7, subsystem_1990, true))
			continue;
		currMatch.subsystem_19a8= subsystem_1990;
		if( !isValidBound(boundObjs_19a7, sFState_1999, true))
			continue;
		currMatch.sFState_19a9= sFState_1999;
		if( !isValidBound(boundObjs_19a7, program_19a2, true))
			continue;
		currMatch.program_19aa= program_19a2;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateSFChartClass_1982::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Class newClass_19ab= SFC::Class::Create( currMatch.program_19aa, SFC::Program::meta_stmnt);
		SFC::Struct newStruct_19ac= SFC::Struct::Create( newClass_19ab, SFC::Class::meta_stmnt);
		SFC::Class& Class= newClass_19ab;
		SFC::Program& Program= currMatch.program_19aa;
		CyPhyML::SignalFlow::SFState& SFState= currMatch.sFState_19a9;
		SFC::Struct& Struct= newStruct_19ac;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_19a8;
		{
typedef std::set< Udm::Object > ObjectSet;

ObjectSet objectSet = SFUtils::getAllInstanceEquivalent( Subsystem );
objectSet.erase( Subsystem );

for( ObjectSet::iterator obsItr = objectSet.begin() ; obsItr != objectSet.end() ; (void)++obsItr ) {
  CyPhyML::SignalFlow::Subsystem::Cast( *obsItr ).cls() = Class;
}
};
		{
std::string name = SFState.name();

Class.name() = name;
Struct.name() = name + "_context";
};
		{
Struct.memberCount() = -1;
};
		{
__int64 statementCount = Program.statementCount();
Class.statementIndex() = statementCount++;
Program.statementCount() = statementCount;
};
		{
__int64 statementCount = Class.statementCount();
Struct.statementIndex() = statementCount++;
Class.statementCount() = statementCount;
};
		currMatch.subsystem_19a8.cls()= newClass_19ab;
	}
}

void CreateFunctionLocalVars_19c0::operator()( const Packets_t& systems_19c1, Packets_t& systems_19c3)
{
#ifdef PRINT_INFO
	printLog("CreateFunctionLocalVars_19c0" );
#endif
	_system_19c4= &systems_19c3;
	if( ( !systems_19c1.empty()))
		callSubsystemFilter_1d0b( systems_19c1);
	_system_19c4->insert( _system_19c4->end(), systems_19c1.begin(), systems_19c1.end());
}

void CreateFunctionLocalVars_19c0::callSubsystemFilter_1d0b( const Packets_t& systems_1152)
{
	Packets_t chartsystems_1154;
	Packets_t sFchartsystems_1155;
	Packets_t systems_1156;
	SubsystemFilter_1151 subsystemFilter_1151;
	subsystemFilter_1151( systems_1152, chartsystems_1154, sFchartsystems_1155, systems_1156);
	if( ( !systems_1156.empty()))
		callGetFunctions_1d0d( systems_1156);
}

void CreateFunctionLocalVars_19c0::callGetFunctions_1d0d( const Packets_t& systems_1ce8)
{
	Packets_t systems_1cea;
	Packets_t systemFunctions_1ceb;
	GetFunctions_1ce7 getFunctions_1ce7;
	getFunctions_1ce7( systems_1ce8, systems_1cea, systemFunctions_1ceb);
	if( ( !systems_1cea.empty())&& ( !systemFunctions_1ceb.empty()))
		callCreateOutPortLVs_1d0f( systems_1cea, systemFunctions_1ceb);
}

void CreateFunctionLocalVars_19c0::callCreateOutPortLVs_1d0f( const Packets_t& systems_19c6, const Packets_t& systemFunctions_19c8)
{
	Packets_t systems_19ca;
	Packets_t systemFunctions_19cb;
	CreateOutPortLVs_19c5 createOutPortLVs_19c5;
	createOutPortLVs_19c5( systems_19c6, systemFunctions_19c8, systems_19ca, systemFunctions_19cb);
	if( ( !systems_19ca.empty())&& ( !systemFunctions_19cb.empty()))
		callCreateInPortLVs_1d12( systems_19ca, systemFunctions_19cb);
}

void CreateFunctionLocalVars_19c0::callCreateInPortLVs_1d12( const Packets_t& systems_1b73, const Packets_t& systemFunctions_1b75)
{
	Packets_t systems_1b77;
	CreateInPortLVs_1b72 createInPortLVs_1b72;
	createInPortLVs_1b72( systems_1b73, systemFunctions_1b75, systems_1b77);
	if( ( !systems_1b77.empty()))
		callGetSubSubsystems_1d15( systems_1b77);
}

void CreateFunctionLocalVars_19c0::callGetSubSubsystems_1d15( const Packets_t& systems_11d0)
{
	Packets_t subsystems_11d2;
	GetSubSubsystems_11cf getSubSubsystems_11cf;
	getSubSubsystems_11cf( systems_11d0, subsystems_11d2);
	if( ( !subsystems_11d2.empty()))
		callSubsystemFilter_1d0b( subsystems_11d2);
}

void CreateOutPortLVs_19c5::operator()( const Packets_t& systems_19c6, const Packets_t& systemFunctions_19c8, Packets_t& systems_19ca, Packets_t& systemFunctions_19cb)
{
#ifdef PRINT_INFO
	printLog("CreateOutPortLVs_19c5" );
#endif
	_system_19cc= &systems_19ca;
	_systemFunction_19cd= &systemFunctions_19cb;
	if( ( !systems_19c6.empty())&& ( !systemFunctions_19c8.empty()))
		callGetChildOutPorts_1b64( systems_19c6, systemFunctions_19c8);
	_system_19cc->insert( _system_19cc->end(), systems_19c6.begin(), systems_19c6.end());
	_systemFunction_19cd->insert( _systemFunction_19cd->end(), systemFunctions_19c8.begin(), systemFunctions_19c8.end());
}

void CreateOutPortLVs_19c5::callGetChildOutPorts_1b64( const Packets_t& subsystems_1a4b, const Packets_t& mains_1a4e)
{
	Packets_t outPorts_1a4d;
	Packets_t mains_1a50;
	GetChildOutPorts_1a4a getChildOutPorts_1a4a;
	getChildOutPorts_1a4a( subsystems_1a4b, mains_1a4e, outPorts_1a4d, mains_1a50);
	if( ( !outPorts_1a4d.empty())&& ( !mains_1a50.empty()))
		callOutPortFilter_1b67( outPorts_1a4d, mains_1a50);
}

void CreateOutPortLVs_19c5::callOutPortFilter_1b67( const Packets_t& outPorts_19cf, const Packets_t& systemFunctions_19d1)
{
	Packets_t outPorts_19d3;
	Packets_t systemFunctions_19d4;
	Packets_t outPorts_19d5;
	Packets_t systemFunctions_19d6;
	OutPortFilter_19ce outPortFilter_19ce;
	outPortFilter_19ce( outPorts_19cf, systemFunctions_19d1, outPorts_19d3, systemFunctions_19d4, outPorts_19d5, systemFunctions_19d6);
	if( ( !outPorts_19d5.empty())&& ( !systemFunctions_19d6.empty()))
		callCreateLocalVars_1b6a( outPorts_19d5, systemFunctions_19d6);
	if( ( !outPorts_19d3.empty()))
		callGetOutArgs_1b6d( outPorts_19d3);
}

void CreateOutPortLVs_19c5::callCreateLocalVars_1b6a( const Packets_t& outPorts_1a78, const Packets_t& mains_1a7a)
{
	CreateLocalVars_1a77 createLocalVars_1a77;
	createLocalVars_1a77( outPorts_1a78, mains_1a7a);
}

void CreateOutPortLVs_19c5::callGetOutArgs_1b6d( const Packets_t& outPorts_1b46)
{
	Packets_t subsystemOutPorts_1b45;
	Packets_t outPorts_1b48;
	GetOutArgs_1b44 getOutArgs_1b44;
	getOutArgs_1b44( outPorts_1b46, subsystemOutPorts_1b45, outPorts_1b48);
	if( ( !subsystemOutPorts_1b45.empty())&& ( !outPorts_1b48.empty()))
		callBindToArg_1b6f( subsystemOutPorts_1b45, outPorts_1b48);
}

void CreateOutPortLVs_19c5::callBindToArg_1b6f( const Packets_t& systemOutPorts_1a9e, const Packets_t& outPorts_1aa0)
{
	BindToArg_1a9d bindToArg_1a9d;
	bindToArg_1a9d( systemOutPorts_1a9e, outPorts_1aa0);
}

void OutPortFilter_19ce::operator()( const Packets_t& outPorts_19cf, const Packets_t& systemFunctions_19d1, Packets_t& outPorts_19d3, Packets_t& systemFunctions_19d4, Packets_t& outPorts_19d5, Packets_t& systemFunctions_19d6)
{
#ifdef PRINT_INFO
	printLog("OutPortFilter_19ce" );
#endif
	_outPort_19d7= &outPorts_19d3;
	_systemFunction_19d8= &systemFunctions_19d4;
	_outPort_19d9= &outPorts_19d5;
	_systemFunction_19da= &systemFunctions_19d6;
	if( ( !outPorts_19cf.empty())&& ( !systemFunctions_19d1.empty()))
		callOutPortTest_1a47( outPorts_19cf, systemFunctions_19d1);
}

void OutPortFilter_19ce::callOutPortTest_1a47( const Packets_t& outPorts_19dc, const Packets_t& systemFunctions_19de)
{
	Packets_t outPorts_19e0;
	Packets_t systemFunctions_19e1;
	Packets_t outPorts_19e2;
	Packets_t systemFunctions_19e3;
	OutPortTest_19db outPortTest_19db;
	outPortTest_19db( outPorts_19dc, systemFunctions_19de, outPorts_19e0, systemFunctions_19e1, outPorts_19e2, systemFunctions_19e3);
	_outPort_19d7->insert( _outPort_19d7->end(), outPorts_19e0.begin(), outPorts_19e0.end());
	_systemFunction_19d8->insert( _systemFunction_19d8->end(), systemFunctions_19e1.begin(), systemFunctions_19e1.end());
	_outPort_19d9->insert( _outPort_19d9->end(), outPorts_19e2.begin(), outPorts_19e2.end());
	_systemFunction_19da->insert( _systemFunction_19da->end(), systemFunctions_19e3.begin(), systemFunctions_19e3.end());
}

void OutPortTest_19db::operator()( const Packets_t& outPorts_19dc, const Packets_t& systemFunctions_19de, Packets_t& outPorts_19e0, Packets_t& systemFunctions_19e1, Packets_t& outPorts_19e2, Packets_t& systemFunctions_19e3)
{
#ifdef PRINT_INFO
	printLog("OutPortTest_19db" );
#endif
	_outPort_19e4= &outPorts_19e0;
	_systemFunction_19e5= &systemFunctions_19e1;
	_outPort_19e6= &outPorts_19e2;
	_systemFunction_19e7= &systemFunctions_19e3;
	for( Packets_t::const_iterator itoutPort_19e9= outPorts_19dc.begin(), itsystemFunction_19f0= systemFunctions_19de.begin(); itoutPort_19e9!= outPorts_19dc.end(), itsystemFunction_19f0!= systemFunctions_19de.end(); ++itoutPort_19e9, ++itsystemFunction_19f0)
	{
		bool isUnique= isInputUnique( *itoutPort_19e9, *itsystemFunction_19f0);
		if( !isUnique)
			continue;
		Packets_t oneoutPort_19ed( 1, *itoutPort_19e9);
		Packets_t onesystemFunction_19f4( 1, *itsystemFunction_19f0);
		executeOne( oneoutPort_19ed, onesystemFunction_19f4);
	}
}

void OutPortTest_19db::executeOne( const Packets_t& outPorts_19dc, const Packets_t& systemFunctions_19de)
{
	Packets_t outPorts_19f9;
	Packets_t mains_19fc;
	OutPort2OutPort_19f6 outPort2OutPort_19f6;
	bool isMatchOutPort2OutPort_19f6= outPort2OutPort_19f6( outPorts_19dc, systemFunctions_19de, outPorts_19f9, mains_19fc);
	_outPort_19e4->insert( _outPort_19e4->end(), outPorts_19f9.begin(), outPorts_19f9.end());
	_systemFunction_19e5->insert( _systemFunction_19e5->end(), mains_19fc.begin(), mains_19fc.end());
	if( isMatchOutPort2OutPort_19f6)
		return;
	Packets_t outPorts_1a25;
	Packets_t mains_1a28;
	Otherwise_1a22 otherwise_1a22;
	bool isMatchOtherwise_1a22= otherwise_1a22( outPorts_19dc, systemFunctions_19de, outPorts_1a25, mains_1a28);
	_outPort_19e6->insert( _outPort_19e6->end(), outPorts_1a25.begin(), outPorts_1a25.end());
	_systemFunction_19e7->insert( _systemFunction_19e7->end(), mains_1a28.begin(), mains_1a28.end());
	if( isMatchOtherwise_1a22)
		return;
}

bool OutPortTest_19db::isInputUnique( const Udm::Object& outPort_19ea, const Udm::Object& systemFunction_19f1)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itoutPort_19ec= _outPort_19e8.begin(), itsystemFunction_19f3= _systemFunction_19ef.begin(); itoutPort_19ec!= _outPort_19e8.end(), itsystemFunction_19f3!= _systemFunction_19ef.end(); ++itoutPort_19ec, ++itsystemFunction_19f3)
	{
		if( ( *itoutPort_19ec== outPort_19ea)&& ( *itsystemFunction_19f3== systemFunction_19f1))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_outPort_19e8.push_back( outPort_19ea);
		_systemFunction_19ef.push_back( systemFunction_19f1);
	}
	return isUnique;
}

bool OutPort2OutPort_19f6::operator()( const Packets_t& outPorts_19f7, const Packets_t& mains_19fa, Packets_t& outPorts_19f9, Packets_t& mains_19fc)
{
#ifdef PRINT_INFO
	printLog("OutPort2OutPort_19f6" );
#endif
	_outPort_19fd= &outPorts_19f9;
	_main_19fe= &mains_19fc;
	processInputPackets( outPorts_19f7, mains_19fa);
	if( false== _matches.empty())
		return true;
	return false;
}

bool OutPort2OutPort_19f6::isInputUnique( const Udm::Object& outPort_1a03, const Udm::Object& main_1a0c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itOutPort_1a05= _outPort_19ff.begin(), itMain_1a0e= _main_1a08.begin(); itOutPort_1a05!= _outPort_19ff.end(), itMain_1a0e!= _main_1a08.end(); ++itOutPort_1a05, ++itMain_1a0e)
	{
		if( ( *itOutPort_1a05== outPort_1a03)&& ( *itMain_1a0e== main_1a0c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_outPort_19ff.push_back( outPort_1a03);
		_main_1a08.push_back( main_1a0c);
	}
	return isUnique;
}

bool OutPort2OutPort_19f6::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void OutPort2OutPort_19f6::processInputPackets( const Packets_t& outPorts_19f7, const Packets_t& mains_19fa)
{
	for( Packets_t::const_iterator itOutPort_1a00= outPorts_19f7.begin(), itMain_1a09= mains_19fa.begin(); itOutPort_1a00!= outPorts_19f7.end(), itMain_1a09!= mains_19fa.end(); ++itOutPort_1a00, ++itMain_1a09)
	{
		bool isUnique= isInputUnique( *itOutPort_1a00, *itMain_1a09);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itOutPort_1a00, *itMain_1a09);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.outPort_1a1a, currMatch.main_1a1b);
	}
}

bool OutPort2OutPort_19f6::patternMatcher( const Udm::Object& outPort_1a01, const Udm::Object& main_1a0a)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( outPort_1a01.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort outPort_1a06= CyPhyML::SignalFlow::OutPort::Cast( outPort_1a01);
		if( false== Uml::IsDerivedFrom( main_1a0a.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1a0f= SFC::Function::Cast( main_1a0a);
		set< CyPhyML::SignalFlow::Line> lines_1a11= outPort_1a06.dstLine();
		for( set< CyPhyML::SignalFlow::Line>::const_iterator itLines_1a12= lines_1a11.begin(); itLines_1a12!= lines_1a11.end(); ++itLines_1a12)
		{
			CyPhyML::SignalFlow::Line currLine_1a13= *itLines_1a12;
			CyPhyML::SignalFlow::SF_Port subsystemOutPort_1a14= currLine_1a13.dstLine_end();
			if( false== Uml::IsDerivedFrom( subsystemOutPort_1a14.type(), CyPhyML::SignalFlow::OutPort::meta))
				continue;
			CyPhyML::SignalFlow::OutPort currSubsystemOutPort_1a15= CyPhyML::SignalFlow::OutPort::Cast( subsystemOutPort_1a14);
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1a19;
			if( !isValidBound(boundObjs_1a19, outPort_1a06, true))
				continue;
			currMatch.outPort_1a1a= outPort_1a06;
			if( !isValidBound(boundObjs_1a19, main_1a0f, true))
				continue;
			currMatch.main_1a1b= main_1a0f;
			if( !isValidBound(boundObjs_1a19, currSubsystemOutPort_1a15, false))
				continue;
			currMatch.subsystemOutPort_1a1c= currSubsystemOutPort_1a15;
			if( !isValidBound(boundObjs_1a19, currLine_1a13, false))
				continue;
			currMatch.line_1a1d= currLine_1a13;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void OutPort2OutPort_19f6::outputAppender( const CyPhyML::SignalFlow::OutPort& outPort_1a1e, const SFC::Function& main_1a20)
{
	_outPort_19fd->push_back( outPort_1a1e);
	_main_19fe->push_back( main_1a20);
}

bool Otherwise_1a22::operator()( const Packets_t& outPorts_1a23, const Packets_t& mains_1a26, Packets_t& outPorts_1a25, Packets_t& mains_1a28)
{
#ifdef PRINT_INFO
	printLog("Otherwise_1a22" );
#endif
	_outPort_1a29= &outPorts_1a25;
	_main_1a2a= &mains_1a28;
	processInputPackets( outPorts_1a23, mains_1a26);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_1a22::isInputUnique( const Udm::Object& outPort_1a2f, const Udm::Object& main_1a38)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itOutPort_1a31= _outPort_1a2b.begin(), itMain_1a3a= _main_1a34.begin(); itOutPort_1a31!= _outPort_1a2b.end(), itMain_1a3a!= _main_1a34.end(); ++itOutPort_1a31, ++itMain_1a3a)
	{
		if( ( *itOutPort_1a31== outPort_1a2f)&& ( *itMain_1a3a== main_1a38))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_outPort_1a2b.push_back( outPort_1a2f);
		_main_1a34.push_back( main_1a38);
	}
	return isUnique;
}

bool Otherwise_1a22::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_1a22::processInputPackets( const Packets_t& outPorts_1a23, const Packets_t& mains_1a26)
{
	for( Packets_t::const_iterator itOutPort_1a2c= outPorts_1a23.begin(), itMain_1a35= mains_1a26.begin(); itOutPort_1a2c!= outPorts_1a23.end(), itMain_1a35!= mains_1a26.end(); ++itOutPort_1a2c, ++itMain_1a35)
	{
		bool isUnique= isInputUnique( *itOutPort_1a2c, *itMain_1a35);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itOutPort_1a2c, *itMain_1a35);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.outPort_1a41, currMatch.main_1a42);
	}
}

bool Otherwise_1a22::patternMatcher( const Udm::Object& outPort_1a2d, const Udm::Object& main_1a36)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( outPort_1a2d.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort outPort_1a32= CyPhyML::SignalFlow::OutPort::Cast( outPort_1a2d);
		if( false== Uml::IsDerivedFrom( main_1a36.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1a3b= SFC::Function::Cast( main_1a36);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1a40;
		if( !isValidBound(boundObjs_1a40, outPort_1a32, true))
			continue;
		currMatch.outPort_1a41= outPort_1a32;
		if( !isValidBound(boundObjs_1a40, main_1a3b, true))
			continue;
		currMatch.main_1a42= main_1a3b;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_1a22::outputAppender( const CyPhyML::SignalFlow::OutPort& outPort_1a43, const SFC::Function& main_1a45)
{
	_outPort_1a29->push_back( outPort_1a43);
	_main_1a2a->push_back( main_1a45);
}

void GetChildOutPorts_1a4a::operator()( const Packets_t& subsystems_1a4b, const Packets_t& mains_1a4e, Packets_t& outPorts_1a4d, Packets_t& mains_1a50)
{
#ifdef PRINT_INFO
	printLog("GetChildOutPorts_1a4a" );
#endif
	RTTGenerator::Instance()->generateRule(1426, "GetChildOutPorts");
	_outPort_1a51= &outPorts_1a4d;
	_main_1a52= &mains_1a50;
	processInputPackets( subsystems_1a4b, mains_1a4e);
}

bool GetChildOutPorts_1a4a::isInputUnique( const Udm::Object& subsystem_1a57, const Udm::Object& main_1a60)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1a59= _subsystem_1a53.begin(), itMain_1a62= _main_1a5c.begin(); itSubsystem_1a59!= _subsystem_1a53.end(), itMain_1a62!= _main_1a5c.end(); ++itSubsystem_1a59, ++itMain_1a62)
	{
		if( ( *itSubsystem_1a59== subsystem_1a57)&& ( *itMain_1a62== main_1a60))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1a53.push_back( subsystem_1a57);
		_main_1a5c.push_back( main_1a60);
	}
	return isUnique;
}

bool GetChildOutPorts_1a4a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetChildOutPorts_1a4a::processInputPackets( const Packets_t& subsystems_1a4b, const Packets_t& mains_1a4e)
{
	for( Packets_t::const_iterator itSubsystem_1a54= subsystems_1a4b.begin(), itMain_1a5d= mains_1a4e.begin(); itSubsystem_1a54!= subsystems_1a4b.end(), itMain_1a5d!= mains_1a4e.end(); ++itSubsystem_1a54, ++itMain_1a5d)
	{
		bool isUnique= isInputUnique( *itSubsystem_1a54, *itMain_1a5d);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1a54, *itMain_1a5d);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetChildOutPorts_1a4a::patternMatcher( const Udm::Object& subsystem_1a55, const Udm::Object& main_1a5e)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1a55.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1a5a= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1a55);
		if( false== Uml::IsDerivedFrom( main_1a5e.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1a63= SFC::Function::Cast( main_1a5e);
		set< CyPhyML::SignalFlow::Block> blocks_1a65= subsystem_1a5a.Block_kind_children();
		for( set< CyPhyML::SignalFlow::Block>::const_iterator itBlock_1a66= blocks_1a65.begin(); itBlock_1a66!= blocks_1a65.end(); ++itBlock_1a66)
		{
			CyPhyML::SignalFlow::Block currBlock_1a67= *itBlock_1a66;
			set< CyPhyML::SignalFlow::OutPort> outPorts_1a68= currBlock_1a67.OutPort_kind_children();
			for( set< CyPhyML::SignalFlow::OutPort>::const_iterator itOutPort_1a69= outPorts_1a68.begin(); itOutPort_1a69!= outPorts_1a68.end(); ++itOutPort_1a69)
			{
				CyPhyML::SignalFlow::OutPort currOutPort_1a6a= *itOutPort_1a69;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_1a6e;
				if( !isValidBound(boundObjs_1a6e, subsystem_1a5a, true))
					continue;
				currMatch.subsystem_1a6f= subsystem_1a5a;
				if( !isValidBound(boundObjs_1a6e, main_1a63, true))
					continue;
				currMatch.main_1a70= main_1a63;
				if( !isValidBound(boundObjs_1a6e, currBlock_1a67, false))
					continue;
				currMatch.block_1a71= currBlock_1a67;
				if( !isValidBound(boundObjs_1a6e, currOutPort_1a6a, false))
					continue;
				currMatch.outPort_1a72= currOutPort_1a6a;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetChildOutPorts_1a4a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.outPort_1a72, currMatch.main_1a70);
	}
}

void GetChildOutPorts_1a4a::outputAppender( const CyPhyML::SignalFlow::OutPort& outPort_1a73, const SFC::Function& main_1a75)
{
	_outPort_1a51->push_back( outPort_1a73);
	_main_1a52->push_back( main_1a75);
}

void CreateLocalVars_1a77::operator()( const Packets_t& outPorts_1a78, const Packets_t& mains_1a7a)
{
#ifdef PRINT_INFO
	printLog("CreateLocalVars_1a77" );
#endif
	RTTGenerator::Instance()->generateRule(1433, "CreateLocalVars");
	processInputPackets( outPorts_1a78, mains_1a7a);
}

bool CreateLocalVars_1a77::isInputUnique( const Udm::Object& outPort_1a80, const Udm::Object& main_1a89)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itOutPort_1a82= _outPort_1a7c.begin(), itMain_1a8b= _main_1a85.begin(); itOutPort_1a82!= _outPort_1a7c.end(), itMain_1a8b!= _main_1a85.end(); ++itOutPort_1a82, ++itMain_1a8b)
	{
		if( ( *itOutPort_1a82== outPort_1a80)&& ( *itMain_1a8b== main_1a89))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_outPort_1a7c.push_back( outPort_1a80);
		_main_1a85.push_back( main_1a89);
	}
	return isUnique;
}

bool CreateLocalVars_1a77::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateLocalVars_1a77::processInputPackets( const Packets_t& outPorts_1a78, const Packets_t& mains_1a7a)
{
	for( Packets_t::const_iterator itOutPort_1a7d= outPorts_1a78.begin(), itMain_1a86= mains_1a7a.begin(); itOutPort_1a7d!= outPorts_1a78.end(), itMain_1a86!= mains_1a7a.end(); ++itOutPort_1a7d, ++itMain_1a86)
	{
		bool isUnique= isInputUnique( *itOutPort_1a7d, *itMain_1a86);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itOutPort_1a7d, *itMain_1a86);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateLocalVars_1a77::patternMatcher( const Udm::Object& outPort_1a7e, const Udm::Object& main_1a87)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( outPort_1a7e.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort outPort_1a83= CyPhyML::SignalFlow::OutPort::Cast( outPort_1a7e);
		if( false== Uml::IsDerivedFrom( main_1a87.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1a8c= SFC::Function::Cast( main_1a87);
		set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_1a8e= outPort_1a83.TypeBaseRef_kind_children();
		for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_1a8f= typeBaseRefs_1a8e.begin(); itTypeBaseRef_1a8f!= typeBaseRefs_1a8e.end(); ++itTypeBaseRef_1a8f)
		{
			CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_1a90= *itTypeBaseRef_1a8f;
			CyPhyML::SignalFlow::SF_TypeBase typeBase_1a91= currTypeBaseRef_1a90.ref();
			if( !typeBase_1a91)
				continue;
			SFC::DT dT_1a92= typeBase_1a91.dt();
			if( !dT_1a92)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1a96;
			if( !isValidBound(boundObjs_1a96, outPort_1a83, true))
				continue;
			currMatch.outPort_1a97= outPort_1a83;
			if( !isValidBound(boundObjs_1a96, main_1a8c, true))
				continue;
			currMatch.main_1a98= main_1a8c;
			if( !isValidBound(boundObjs_1a96, currTypeBaseRef_1a90, false))
				continue;
			currMatch.typeBaseRef_1a99= currTypeBaseRef_1a90;
			if( !isValidBound(boundObjs_1a96, typeBase_1a91, false))
				continue;
			currMatch.typeBase_1a9a= typeBase_1a91;
			if( !isValidBound(boundObjs_1a96, dT_1a92, false))
				continue;
			currMatch.dT_1a9b= dT_1a92;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateLocalVars_1a77::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar newLocalVar_1a9c= SFC::LocalVar::Create( currMatch.main_1a98);
		SFC::DT& DT= currMatch.dT_1a9b;
		SFC::LocalVar& LocalVar= newLocalVar_1a9c;
		SFC::Function& Main= currMatch.main_1a98;
		CyPhyML::SignalFlow::OutPort& OutPort= currMatch.outPort_1a97;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_1a9a;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_1a99;
		{
__int64 statementCount = Main.statementCount();

LocalVar.name() = (  boost::format( "sig_%1%" ) % statementCount  ).str();
LocalVar.type() = "double";
LocalVar.statementIndex() = statementCount++;

Main.statementCount() = statementCount;
};
		currMatch.outPort_1a97.argdecl()= newLocalVar_1a9c;
		newLocalVar_1a9c.dt()= currMatch.dT_1a9b;
	}
}

void BindToArg_1a9d::operator()( const Packets_t& systemOutPorts_1a9e, const Packets_t& outPorts_1aa0)
{
#ifdef PRINT_INFO
	printLog("BindToArg_1a9d" );
#endif
	for( Packets_t::const_iterator itsystemOutPort_1aa3= systemOutPorts_1a9e.begin(), itoutPort_1aaa= outPorts_1aa0.begin(); itsystemOutPort_1aa3!= systemOutPorts_1a9e.end(), itoutPort_1aaa!= outPorts_1aa0.end(); ++itsystemOutPort_1aa3, ++itoutPort_1aaa)
	{
		bool isUnique= isInputUnique( *itsystemOutPort_1aa3, *itoutPort_1aaa);
		if( !isUnique)
			continue;
		Packets_t onesystemOutPort_1aa7( 1, *itsystemOutPort_1aa3);
		Packets_t oneoutPort_1aae( 1, *itoutPort_1aaa);
		executeOne( onesystemOutPort_1aa7, oneoutPort_1aae);
	}
}

void BindToArg_1a9d::executeOne( const Packets_t& systemOutPorts_1a9e, const Packets_t& outPorts_1aa0)
{
	if( ( !systemOutPorts_1a9e.empty())&& ( !outPorts_1aa0.empty()))
		callOutputArgTest_1b3e( systemOutPorts_1a9e, outPorts_1aa0);
}

bool BindToArg_1a9d::isInputUnique( const Udm::Object& systemOutPort_1aa4, const Udm::Object& outPort_1aab)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itsystemOutPort_1aa6= _systemOutPort_1aa2.begin(), itoutPort_1aad= _outPort_1aa9.begin(); itsystemOutPort_1aa6!= _systemOutPort_1aa2.end(), itoutPort_1aad!= _outPort_1aa9.end(); ++itsystemOutPort_1aa6, ++itoutPort_1aad)
	{
		if( ( *itsystemOutPort_1aa6== systemOutPort_1aa4)&& ( *itoutPort_1aad== outPort_1aab))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_systemOutPort_1aa2.push_back( systemOutPort_1aa4);
		_outPort_1aa9.push_back( outPort_1aab);
	}
	return isUnique;
}

void BindToArg_1a9d::callOutputArgTest_1b3e( const Packets_t& systemOutPorts_1ab1, const Packets_t& outPorts_1ab3)
{
	Packets_t systemOutPorts_1ab5;
	Packets_t outPorts_1ab6;
	Packets_t systemOutPorts_1ab7;
	Packets_t outPorts_1ab8;
	OutputArgTest_1ab0 outputArgTest_1ab0;
	outputArgTest_1ab0( systemOutPorts_1ab1, outPorts_1ab3, systemOutPorts_1ab5, outPorts_1ab6, systemOutPorts_1ab7, outPorts_1ab8);
	if( ( !systemOutPorts_1ab7.empty())&& ( !outPorts_1ab8.empty()))
		callBindToArg_1b41( systemOutPorts_1ab7, outPorts_1ab8);
}

void BindToArg_1a9d::callBindToArg_1b41( const Packets_t& subsystemOutPorts_1b18, const Packets_t& outPorts_1b1a)
{
	BindToArg_1b17 bindToArg_1b17;
	bindToArg_1b17( subsystemOutPorts_1b18, outPorts_1b1a);
}

void OutputArgTest_1ab0::operator()( const Packets_t& systemOutPorts_1ab1, const Packets_t& outPorts_1ab3, Packets_t& systemOutPorts_1ab5, Packets_t& outPorts_1ab6, Packets_t& systemOutPorts_1ab7, Packets_t& outPorts_1ab8)
{
#ifdef PRINT_INFO
	printLog("OutputArgTest_1ab0" );
#endif
	_systemOutPort_1ab9= &systemOutPorts_1ab5;
	_outPort_1aba= &outPorts_1ab6;
	_systemOutPort_1abb= &systemOutPorts_1ab7;
	_outPort_1abc= &outPorts_1ab8;
	for( Packets_t::const_iterator itsystemOutPort_1abe= systemOutPorts_1ab1.begin(), itoutPort_1ac5= outPorts_1ab3.begin(); itsystemOutPort_1abe!= systemOutPorts_1ab1.end(), itoutPort_1ac5!= outPorts_1ab3.end(); ++itsystemOutPort_1abe, ++itoutPort_1ac5)
	{
		bool isUnique= isInputUnique( *itsystemOutPort_1abe, *itoutPort_1ac5);
		if( !isUnique)
			continue;
		Packets_t onesystemOutPort_1ac2( 1, *itsystemOutPort_1abe);
		Packets_t oneoutPort_1ac9( 1, *itoutPort_1ac5);
		executeOne( onesystemOutPort_1ac2, oneoutPort_1ac9);
	}
}

void OutputArgTest_1ab0::executeOne( const Packets_t& systemOutPorts_1ab1, const Packets_t& outPorts_1ab3)
{
	Packets_t subsystemOutPorts_1ace;
	Packets_t outPorts_1ad1;
	OutPortArg_1acb outPortArg_1acb;
	bool isMatchOutPortArg_1acb= outPortArg_1acb( systemOutPorts_1ab1, outPorts_1ab3, subsystemOutPorts_1ace, outPorts_1ad1);
	_systemOutPort_1ab9->insert( _systemOutPort_1ab9->end(), subsystemOutPorts_1ace.begin(), subsystemOutPorts_1ace.end());
	_outPort_1aba->insert( _outPort_1aba->end(), outPorts_1ad1.begin(), outPorts_1ad1.end());
	if( isMatchOutPortArg_1acb)
		return;
	Packets_t subsystemOutPorts_1af5;
	Packets_t outPorts_1af8;
	Otherwise_1af2 otherwise_1af2;
	bool isMatchOtherwise_1af2= otherwise_1af2( systemOutPorts_1ab1, outPorts_1ab3, subsystemOutPorts_1af5, outPorts_1af8);
	_systemOutPort_1abb->insert( _systemOutPort_1abb->end(), subsystemOutPorts_1af5.begin(), subsystemOutPorts_1af5.end());
	_outPort_1abc->insert( _outPort_1abc->end(), outPorts_1af8.begin(), outPorts_1af8.end());
	if( isMatchOtherwise_1af2)
		return;
}

bool OutputArgTest_1ab0::isInputUnique( const Udm::Object& systemOutPort_1abf, const Udm::Object& outPort_1ac6)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itsystemOutPort_1ac1= _systemOutPort_1abd.begin(), itoutPort_1ac8= _outPort_1ac4.begin(); itsystemOutPort_1ac1!= _systemOutPort_1abd.end(), itoutPort_1ac8!= _outPort_1ac4.end(); ++itsystemOutPort_1ac1, ++itoutPort_1ac8)
	{
		if( ( *itsystemOutPort_1ac1== systemOutPort_1abf)&& ( *itoutPort_1ac8== outPort_1ac6))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_systemOutPort_1abd.push_back( systemOutPort_1abf);
		_outPort_1ac4.push_back( outPort_1ac6);
	}
	return isUnique;
}

bool OutPortArg_1acb::operator()( const Packets_t& subsystemOutPorts_1acc, const Packets_t& outPorts_1acf, Packets_t& subsystemOutPorts_1ace, Packets_t& outPorts_1ad1)
{
#ifdef PRINT_INFO
	printLog("OutPortArg_1acb" );
#endif
	_subsystemOutPort_1ad2= &subsystemOutPorts_1ace;
	_outPort_1ad3= &outPorts_1ad1;
	processInputPackets( subsystemOutPorts_1acc, outPorts_1acf);
	if( false== _matches.empty())
		return true;
	return false;
}

bool OutPortArg_1acb::isInputUnique( const Udm::Object& subsystemOutPort_1ad8, const Udm::Object& outPort_1ae1)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystemOutPort_1ada= _subsystemOutPort_1ad4.begin(), itOutPort_1ae3= _outPort_1add.begin(); itSubsystemOutPort_1ada!= _subsystemOutPort_1ad4.end(), itOutPort_1ae3!= _outPort_1add.end(); ++itSubsystemOutPort_1ada, ++itOutPort_1ae3)
	{
		if( ( *itSubsystemOutPort_1ada== subsystemOutPort_1ad8)&& ( *itOutPort_1ae3== outPort_1ae1))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystemOutPort_1ad4.push_back( subsystemOutPort_1ad8);
		_outPort_1add.push_back( outPort_1ae1);
	}
	return isUnique;
}

bool OutPortArg_1acb::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void OutPortArg_1acb::processInputPackets( const Packets_t& subsystemOutPorts_1acc, const Packets_t& outPorts_1acf)
{
	for( Packets_t::const_iterator itSubsystemOutPort_1ad5= subsystemOutPorts_1acc.begin(), itOutPort_1ade= outPorts_1acf.begin(); itSubsystemOutPort_1ad5!= subsystemOutPorts_1acc.end(), itOutPort_1ade!= outPorts_1acf.end(); ++itSubsystemOutPort_1ad5, ++itOutPort_1ade)
	{
		bool isUnique= isInputUnique( *itSubsystemOutPort_1ad5, *itOutPort_1ade);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystemOutPort_1ad5, *itOutPort_1ade);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystemOutPort_1aeb, currMatch.outPort_1aec);
	}
}

bool OutPortArg_1acb::patternMatcher( const Udm::Object& subsystemOutPort_1ad6, const Udm::Object& outPort_1adf)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystemOutPort_1ad6.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort subsystemOutPort_1adb= CyPhyML::SignalFlow::OutPort::Cast( subsystemOutPort_1ad6);
		if( false== Uml::IsDerivedFrom( outPort_1adf.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort outPort_1ae4= CyPhyML::SignalFlow::OutPort::Cast( outPort_1adf);
		SFC::ArgDeclBase argDeclBase_1ae6= outPort_1ae4.argdecl();
		if( !argDeclBase_1ae6)
			continue;
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1aea;
		if( !isValidBound(boundObjs_1aea, subsystemOutPort_1adb, true))
			continue;
		currMatch.subsystemOutPort_1aeb= subsystemOutPort_1adb;
		if( !isValidBound(boundObjs_1aea, outPort_1ae4, true))
			continue;
		currMatch.outPort_1aec= outPort_1ae4;
		if( !isValidBound(boundObjs_1aea, argDeclBase_1ae6, false))
			continue;
		currMatch.argDeclBase_1aed= argDeclBase_1ae6;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void OutPortArg_1acb::outputAppender( const CyPhyML::SignalFlow::OutPort& subsystemOutPort_1aee, const CyPhyML::SignalFlow::OutPort& outPort_1af0)
{
	_subsystemOutPort_1ad2->push_back( subsystemOutPort_1aee);
	_outPort_1ad3->push_back( outPort_1af0);
}

bool Otherwise_1af2::operator()( const Packets_t& subsystemOutPorts_1af3, const Packets_t& outPorts_1af6, Packets_t& subsystemOutPorts_1af5, Packets_t& outPorts_1af8)
{
#ifdef PRINT_INFO
	printLog("Otherwise_1af2" );
#endif
	_subsystemOutPort_1af9= &subsystemOutPorts_1af5;
	_outPort_1afa= &outPorts_1af8;
	processInputPackets( subsystemOutPorts_1af3, outPorts_1af6);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_1af2::isInputUnique( const Udm::Object& subsystemOutPort_1aff, const Udm::Object& outPort_1b08)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystemOutPort_1b01= _subsystemOutPort_1afb.begin(), itOutPort_1b0a= _outPort_1b04.begin(); itSubsystemOutPort_1b01!= _subsystemOutPort_1afb.end(), itOutPort_1b0a!= _outPort_1b04.end(); ++itSubsystemOutPort_1b01, ++itOutPort_1b0a)
	{
		if( ( *itSubsystemOutPort_1b01== subsystemOutPort_1aff)&& ( *itOutPort_1b0a== outPort_1b08))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystemOutPort_1afb.push_back( subsystemOutPort_1aff);
		_outPort_1b04.push_back( outPort_1b08);
	}
	return isUnique;
}

bool Otherwise_1af2::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_1af2::processInputPackets( const Packets_t& subsystemOutPorts_1af3, const Packets_t& outPorts_1af6)
{
	for( Packets_t::const_iterator itSubsystemOutPort_1afc= subsystemOutPorts_1af3.begin(), itOutPort_1b05= outPorts_1af6.begin(); itSubsystemOutPort_1afc!= subsystemOutPorts_1af3.end(), itOutPort_1b05!= outPorts_1af6.end(); ++itSubsystemOutPort_1afc, ++itOutPort_1b05)
	{
		bool isUnique= isInputUnique( *itSubsystemOutPort_1afc, *itOutPort_1b05);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystemOutPort_1afc, *itOutPort_1b05);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystemOutPort_1b11, currMatch.outPort_1b12);
	}
}

bool Otherwise_1af2::patternMatcher( const Udm::Object& subsystemOutPort_1afd, const Udm::Object& outPort_1b06)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystemOutPort_1afd.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort subsystemOutPort_1b02= CyPhyML::SignalFlow::OutPort::Cast( subsystemOutPort_1afd);
		if( false== Uml::IsDerivedFrom( outPort_1b06.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort outPort_1b0b= CyPhyML::SignalFlow::OutPort::Cast( outPort_1b06);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1b10;
		if( !isValidBound(boundObjs_1b10, subsystemOutPort_1b02, true))
			continue;
		currMatch.subsystemOutPort_1b11= subsystemOutPort_1b02;
		if( !isValidBound(boundObjs_1b10, outPort_1b0b, true))
			continue;
		currMatch.outPort_1b12= outPort_1b0b;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_1af2::outputAppender( const CyPhyML::SignalFlow::OutPort& subsystemOutPort_1b13, const CyPhyML::SignalFlow::OutPort& outPort_1b15)
{
	_subsystemOutPort_1af9->push_back( subsystemOutPort_1b13);
	_outPort_1afa->push_back( outPort_1b15);
}

void BindToArg_1b17::operator()( const Packets_t& subsystemOutPorts_1b18, const Packets_t& outPorts_1b1a)
{
#ifdef PRINT_INFO
	printLog("BindToArg_1b17" );
#endif
	RTTGenerator::Instance()->generateRule(1465, "BindToArg");
	processInputPackets( subsystemOutPorts_1b18, outPorts_1b1a);
}

bool BindToArg_1b17::isInputUnique( const Udm::Object& subsystemOutPort_1b20, const Udm::Object& outPort_1b29)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystemOutPort_1b22= _subsystemOutPort_1b1c.begin(), itOutPort_1b2b= _outPort_1b25.begin(); itSubsystemOutPort_1b22!= _subsystemOutPort_1b1c.end(), itOutPort_1b2b!= _outPort_1b25.end(); ++itSubsystemOutPort_1b22, ++itOutPort_1b2b)
	{
		if( ( *itSubsystemOutPort_1b22== subsystemOutPort_1b20)&& ( *itOutPort_1b2b== outPort_1b29))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystemOutPort_1b1c.push_back( subsystemOutPort_1b20);
		_outPort_1b25.push_back( outPort_1b29);
	}
	return isUnique;
}

bool BindToArg_1b17::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void BindToArg_1b17::processInputPackets( const Packets_t& subsystemOutPorts_1b18, const Packets_t& outPorts_1b1a)
{
	for( Packets_t::const_iterator itSubsystemOutPort_1b1d= subsystemOutPorts_1b18.begin(), itOutPort_1b26= outPorts_1b1a.begin(); itSubsystemOutPort_1b1d!= subsystemOutPorts_1b18.end(), itOutPort_1b26!= outPorts_1b1a.end(); ++itSubsystemOutPort_1b1d, ++itOutPort_1b26)
	{
		bool isUnique= isInputUnique( *itSubsystemOutPort_1b1d, *itOutPort_1b26);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystemOutPort_1b1d, *itOutPort_1b26);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool BindToArg_1b17::patternMatcher( const Udm::Object& subsystemOutPort_1b1e, const Udm::Object& outPort_1b27)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystemOutPort_1b1e.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort subsystemOutPort_1b23= CyPhyML::SignalFlow::OutPort::Cast( subsystemOutPort_1b1e);
		if( false== Uml::IsDerivedFrom( outPort_1b27.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort outPort_1b2c= CyPhyML::SignalFlow::OutPort::Cast( outPort_1b27);
		set< SFC::Arg> args_1b2e= subsystemOutPort_1b23.arg();
		for( set< SFC::Arg>::const_iterator itArgs_1b2f= args_1b2e.begin(); itArgs_1b2f!= args_1b2e.end(); ++itArgs_1b2f)
		{
			SFC::Arg currArg_1b30= *itArgs_1b2f;
			set< CyPhyML::SignalFlow::Line> lines_1b31= outPort_1b2c.dstLine();
			for( set< CyPhyML::SignalFlow::Line>::const_iterator itLines_1b32= lines_1b31.begin(); itLines_1b32!= lines_1b31.end(); ++itLines_1b32)
			{
				CyPhyML::SignalFlow::Line currLine_1b33= *itLines_1b32;
				CyPhyML::SignalFlow::SF_Port subsystemOutPort_1b34= currLine_1b33.dstLine_end();
				if( false== Uml::IsDerivedFrom( subsystemOutPort_1b34.type(), CyPhyML::SignalFlow::OutPort::meta))
					continue;
				CyPhyML::SignalFlow::OutPort currSubsystemOutPort_1b35= CyPhyML::SignalFlow::OutPort::Cast( subsystemOutPort_1b34);
				if( subsystemOutPort_1b23!= currSubsystemOutPort_1b35)
					continue;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_1b39;
				if( !isValidBound(boundObjs_1b39, subsystemOutPort_1b23, true))
					continue;
				currMatch.subsystemOutPort_1b3a= subsystemOutPort_1b23;
				if( !isValidBound(boundObjs_1b39, outPort_1b2c, true))
					continue;
				currMatch.outPort_1b3b= outPort_1b2c;
				if( !isValidBound(boundObjs_1b39, currArg_1b30, false))
					continue;
				currMatch.arg_1b3c= currArg_1b30;
				if( !isValidBound(boundObjs_1b39, currLine_1b33, false))
					continue;
				currMatch.line_1b3d= currLine_1b33;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void BindToArg_1b17::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.outPort_1b3b.argdecl()= currMatch.arg_1b3c;
	}
}

void GetOutArgs_1b44::operator()( const Packets_t& outPorts_1b46, Packets_t& subsystemOutPorts_1b45, Packets_t& outPorts_1b48)
{
#ifdef PRINT_INFO
	printLog("GetOutArgs_1b44" );
#endif
	RTTGenerator::Instance()->generateRule(1474, "GetOutArgs");
	_subsystemOutPort_1b49= &subsystemOutPorts_1b45;
	_outPort_1b4a= &outPorts_1b48;
	processInputPackets( outPorts_1b46);
	sortOutputs( );
}

bool GetOutArgs_1b44::isInputUnique( const Udm::Object& outPort_1b4f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itOutPort_1b51= _outPort_1b4b.begin(); itOutPort_1b51!= _outPort_1b4b.end(); ++itOutPort_1b51)
	{
		if( ( *itOutPort_1b51== outPort_1b4f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_outPort_1b4b.push_back( outPort_1b4f);
	return isUnique;
}

bool GetOutArgs_1b44::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetOutArgs_1b44::processInputPackets( const Packets_t& outPorts_1b46)
{
	for( Packets_t::const_iterator itOutPort_1b4c= outPorts_1b46.begin(); itOutPort_1b4c!= outPorts_1b46.end(); ++itOutPort_1b4c)
	{
		bool isUnique= isInputUnique( *itOutPort_1b4c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itOutPort_1b4c);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetOutArgs_1b44::patternMatcher( const Udm::Object& outPort_1b4d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( outPort_1b4d.type(), CyPhyML::SignalFlow::OutPort::meta))
			continue;
		CyPhyML::SignalFlow::OutPort outPort_1b52= CyPhyML::SignalFlow::OutPort::Cast( outPort_1b4d);
		set< CyPhyML::SignalFlow::Line> lines_1b54= outPort_1b52.dstLine();
		for( set< CyPhyML::SignalFlow::Line>::const_iterator itLines_1b55= lines_1b54.begin(); itLines_1b55!= lines_1b54.end(); ++itLines_1b55)
		{
			CyPhyML::SignalFlow::Line currLine_1b56= *itLines_1b55;
			CyPhyML::SignalFlow::SF_Port subsystemOutPort_1b57= currLine_1b56.dstLine_end();
			if( false== Uml::IsDerivedFrom( subsystemOutPort_1b57.type(), CyPhyML::SignalFlow::OutPort::meta))
				continue;
			CyPhyML::SignalFlow::OutPort currSubsystemOutPort_1b58= CyPhyML::SignalFlow::OutPort::Cast( subsystemOutPort_1b57);
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1b5c;
			if( !isValidBound(boundObjs_1b5c, outPort_1b52, true))
				continue;
			currMatch.outPort_1b5d= outPort_1b52;
			if( !isValidBound(boundObjs_1b5c, currSubsystemOutPort_1b58, false))
				continue;
			currMatch.subsystemOutPort_1b5e= currSubsystemOutPort_1b58;
			if( !isValidBound(boundObjs_1b5c, currLine_1b56, false))
				continue;
			currMatch.line_1b5f= currLine_1b56;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetOutArgs_1b44::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystemOutPort_1b5e, currMatch.outPort_1b5d);
	}
}

void GetOutArgs_1b44::outputAppender( const CyPhyML::SignalFlow::OutPort& subsystemOutPort_1b60, const CyPhyML::SignalFlow::OutPort& outPort_1b62)
{
	_subsystemOutPort_1b49->push_back( subsystemOutPort_1b60);
	_outPort_1b4a->push_back( outPort_1b62);
}

void GetOutArgs_1b44::sortOutputs()
{
	typedef std::multiset< CyPhyML::SignalFlow::OutPort, std::pointer_to_binary_function< const CyPhyML::SignalFlow::OutPort&, const CyPhyML::SignalFlow::OutPort&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const CyPhyML::SignalFlow::OutPort&, const CyPhyML::SignalFlow::OutPort&, bool> ptr_UniqueIdSort( UniqueIdSort< CyPhyML::SignalFlow::OutPort>);
	SortedSet_t sortedSet( ptr_UniqueIdSort);
	std::vector< int> permutationVector( _subsystemOutPort_1b49->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _subsystemOutPort_1b49->begin(); it!= _subsystemOutPort_1b49->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( CyPhyML::SignalFlow::OutPort::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _subsystemOutPort_1b49->begin());
	// order rest of the containers
	permutate( permutationVector, *_outPort_1b4a);
}

void CreateInPortLVs_1b72::operator()( const Packets_t& systems_1b73, const Packets_t& systemFunctions_1b75, Packets_t& systems_1b77)
{
#ifdef PRINT_INFO
	printLog("CreateInPortLVs_1b72" );
#endif
	_system_1b78= &systems_1b77;
	_system_1b78->insert( _system_1b78->end(), systems_1b73.begin(), systems_1b73.end());
	if( ( !systems_1b73.empty())&& ( !systemFunctions_1b75.empty()))
		callGetChildInPorts_1cd7( systems_1b73, systemFunctions_1b75);
}

void CreateInPortLVs_1b72::callGetChildInPorts_1cd7( const Packets_t& subsystems_1b7a, const Packets_t& mains_1b7d)
{
	Packets_t inPorts_1b7c;
	Packets_t mains_1b7f;
	GetChildInPorts_1b79 getChildInPorts_1b79;
	getChildInPorts_1b79( subsystems_1b7a, mains_1b7d, inPorts_1b7c, mains_1b7f);
	if( ( !inPorts_1b7c.empty())&& ( !mains_1b7f.empty()))
		callInPortFilter_1cda( inPorts_1b7c, mains_1b7f);
}

void CreateInPortLVs_1b72::callInPortFilter_1cda( const Packets_t& inPorts_1ba7, const Packets_t& systemFunctions_1ba9)
{
	Packets_t inPorts_1bab;
	Packets_t systemFunctions_1bac;
	Packets_t inPorts_1bad;
	Packets_t systemFunctions_1bae;
	Packets_t inPorts_1baf;
	Packets_t systemFunctions_1bb0;
	InPortFilter_1ba6 inPortFilter_1ba6;
	inPortFilter_1ba6( inPorts_1ba7, systemFunctions_1ba9, inPorts_1bab, systemFunctions_1bac, inPorts_1bad, systemFunctions_1bae, inPorts_1baf, systemFunctions_1bb0);
	if( ( !inPorts_1baf.empty())&& ( !systemFunctions_1bb0.empty()))
		callCreateLocalVars_1cdd( inPorts_1baf, systemFunctions_1bb0);
	if( ( !inPorts_1bab.empty()))
		callGetInArgs_1ce0( inPorts_1bab);
	if( ( !inPorts_1bad.empty()))
		callGetLocalVars_1ce2( inPorts_1bad);
}

void CreateInPortLVs_1b72::callCreateLocalVars_1cdd( const Packets_t& inPorts_1c58, const Packets_t& mains_1c5a)
{
	Packets_t localVars_1c57;
	Packets_t mains_1c5c;
	CreateLocalVars_1c56 createLocalVars_1c56;
	createLocalVars_1c56( inPorts_1c58, mains_1c5a, localVars_1c57, mains_1c5c);
	if( ( !localVars_1c57.empty())&& ( !mains_1c5c.empty()))
		callZeroInitLocalVars_1ce4( localVars_1c57, mains_1c5c);
}

void CreateInPortLVs_1b72::callGetInArgs_1ce0( const Packets_t& inPorts_1c85)
{
	GetInArgs_1c84 getInArgs_1c84;
	getInArgs_1c84( inPorts_1c85);
}

void CreateInPortLVs_1b72::callGetLocalVars_1ce2( const Packets_t& inPorts_1ca1)
{
	GetLocalVars_1ca0 getLocalVars_1ca0;
	getLocalVars_1ca0( inPorts_1ca1);
}

void CreateInPortLVs_1b72::callZeroInitLocalVars_1ce4( const Packets_t& localVars_1cbb, const Packets_t& mains_1cbd)
{
	ZeroInitLocalVars_1cba zeroInitLocalVars_1cba;
	zeroInitLocalVars_1cba( localVars_1cbb, mains_1cbd);
}

void GetChildInPorts_1b79::operator()( const Packets_t& subsystems_1b7a, const Packets_t& mains_1b7d, Packets_t& inPorts_1b7c, Packets_t& mains_1b7f)
{
#ifdef PRINT_INFO
	printLog("GetChildInPorts_1b79" );
#endif
	RTTGenerator::Instance()->generateRule(1484, "GetChildInPorts");
	_inPort_1b80= &inPorts_1b7c;
	_main_1b81= &mains_1b7f;
	processInputPackets( subsystems_1b7a, mains_1b7d);
}

bool GetChildInPorts_1b79::isInputUnique( const Udm::Object& subsystem_1b86, const Udm::Object& main_1b8f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1b88= _subsystem_1b82.begin(), itMain_1b91= _main_1b8b.begin(); itSubsystem_1b88!= _subsystem_1b82.end(), itMain_1b91!= _main_1b8b.end(); ++itSubsystem_1b88, ++itMain_1b91)
	{
		if( ( *itSubsystem_1b88== subsystem_1b86)&& ( *itMain_1b91== main_1b8f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1b82.push_back( subsystem_1b86);
		_main_1b8b.push_back( main_1b8f);
	}
	return isUnique;
}

bool GetChildInPorts_1b79::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetChildInPorts_1b79::processInputPackets( const Packets_t& subsystems_1b7a, const Packets_t& mains_1b7d)
{
	for( Packets_t::const_iterator itSubsystem_1b83= subsystems_1b7a.begin(), itMain_1b8c= mains_1b7d.begin(); itSubsystem_1b83!= subsystems_1b7a.end(), itMain_1b8c!= mains_1b7d.end(); ++itSubsystem_1b83, ++itMain_1b8c)
	{
		bool isUnique= isInputUnique( *itSubsystem_1b83, *itMain_1b8c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1b83, *itMain_1b8c);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetChildInPorts_1b79::patternMatcher( const Udm::Object& subsystem_1b84, const Udm::Object& main_1b8d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1b84.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1b89= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1b84);
		if( false== Uml::IsDerivedFrom( main_1b8d.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1b92= SFC::Function::Cast( main_1b8d);
		set< CyPhyML::SignalFlow::Block> blocks_1b94= subsystem_1b89.Block_kind_children();
		for( set< CyPhyML::SignalFlow::Block>::const_iterator itBlock_1b95= blocks_1b94.begin(); itBlock_1b95!= blocks_1b94.end(); ++itBlock_1b95)
		{
			CyPhyML::SignalFlow::Block currBlock_1b96= *itBlock_1b95;
			set< CyPhyML::SignalFlow::InPort> inPorts_1b97= currBlock_1b96.InPort_kind_children();
			for( set< CyPhyML::SignalFlow::InPort>::const_iterator itInPort_1b98= inPorts_1b97.begin(); itInPort_1b98!= inPorts_1b97.end(); ++itInPort_1b98)
			{
				CyPhyML::SignalFlow::InPort currInPort_1b99= *itInPort_1b98;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_1b9d;
				if( !isValidBound(boundObjs_1b9d, subsystem_1b89, true))
					continue;
				currMatch.subsystem_1b9e= subsystem_1b89;
				if( !isValidBound(boundObjs_1b9d, main_1b92, true))
					continue;
				currMatch.main_1b9f= main_1b92;
				if( !isValidBound(boundObjs_1b9d, currBlock_1b96, false))
					continue;
				currMatch.block_1ba0= currBlock_1b96;
				if( !isValidBound(boundObjs_1b9d, currInPort_1b99, false))
					continue;
				currMatch.inPort_1ba1= currInPort_1b99;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetChildInPorts_1b79::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.inPort_1ba1, currMatch.main_1b9f);
	}
}

void GetChildInPorts_1b79::outputAppender( const CyPhyML::SignalFlow::InPort& inPort_1ba2, const SFC::Function& main_1ba4)
{
	_inPort_1b80->push_back( inPort_1ba2);
	_main_1b81->push_back( main_1ba4);
}

void InPortFilter_1ba6::operator()( const Packets_t& inPorts_1ba7, const Packets_t& systemFunctions_1ba9, Packets_t& inPorts_1bab, Packets_t& systemFunctions_1bac, Packets_t& inPorts_1bad, Packets_t& systemFunctions_1bae, Packets_t& inPorts_1baf, Packets_t& systemFunctions_1bb0)
{
#ifdef PRINT_INFO
	printLog("InPortFilter_1ba6" );
#endif
	_inPort_1bb1= &inPorts_1bab;
	_systemFunction_1bb2= &systemFunctions_1bac;
	_inPort_1bb3= &inPorts_1bad;
	_systemFunction_1bb4= &systemFunctions_1bae;
	_inPort_1bb5= &inPorts_1baf;
	_systemFunction_1bb6= &systemFunctions_1bb0;
	if( ( !inPorts_1ba7.empty())&& ( !systemFunctions_1ba9.empty()))
		callInPortTest_1c53( inPorts_1ba7, systemFunctions_1ba9);
}

void InPortFilter_1ba6::callInPortTest_1c53( const Packets_t& inPorts_1bb8, const Packets_t& systemFunctions_1bba)
{
	Packets_t inPorts_1bbc;
	Packets_t systemFunctions_1bbd;
	Packets_t inPorts_1bbe;
	Packets_t systemFunctions_1bbf;
	Packets_t inPorts_1bc0;
	Packets_t systemFunctions_1bc1;
	InPortTest_1bb7 inPortTest_1bb7;
	inPortTest_1bb7( inPorts_1bb8, systemFunctions_1bba, inPorts_1bbc, systemFunctions_1bbd, inPorts_1bbe, systemFunctions_1bbf, inPorts_1bc0, systemFunctions_1bc1);
	_inPort_1bb1->insert( _inPort_1bb1->end(), inPorts_1bbc.begin(), inPorts_1bbc.end());
	_systemFunction_1bb2->insert( _systemFunction_1bb2->end(), systemFunctions_1bbd.begin(), systemFunctions_1bbd.end());
	_inPort_1bb3->insert( _inPort_1bb3->end(), inPorts_1bbe.begin(), inPorts_1bbe.end());
	_systemFunction_1bb4->insert( _systemFunction_1bb4->end(), systemFunctions_1bbf.begin(), systemFunctions_1bbf.end());
	_inPort_1bb5->insert( _inPort_1bb5->end(), inPorts_1bc0.begin(), inPorts_1bc0.end());
	_systemFunction_1bb6->insert( _systemFunction_1bb6->end(), systemFunctions_1bc1.begin(), systemFunctions_1bc1.end());
}

void InPortTest_1bb7::operator()( const Packets_t& inPorts_1bb8, const Packets_t& systemFunctions_1bba, Packets_t& inPorts_1bbc, Packets_t& systemFunctions_1bbd, Packets_t& inPorts_1bbe, Packets_t& systemFunctions_1bbf, Packets_t& inPorts_1bc0, Packets_t& systemFunctions_1bc1)
{
#ifdef PRINT_INFO
	printLog("InPortTest_1bb7" );
#endif
	_inPort_1bc2= &inPorts_1bbc;
	_systemFunction_1bc3= &systemFunctions_1bbd;
	_inPort_1bc4= &inPorts_1bbe;
	_systemFunction_1bc5= &systemFunctions_1bbf;
	_inPort_1bc6= &inPorts_1bc0;
	_systemFunction_1bc7= &systemFunctions_1bc1;
	for( Packets_t::const_iterator itinPort_1bc9= inPorts_1bb8.begin(), itsystemFunction_1bd0= systemFunctions_1bba.begin(); itinPort_1bc9!= inPorts_1bb8.end(), itsystemFunction_1bd0!= systemFunctions_1bba.end(); ++itinPort_1bc9, ++itsystemFunction_1bd0)
	{
		bool isUnique= isInputUnique( *itinPort_1bc9, *itsystemFunction_1bd0);
		if( !isUnique)
			continue;
		Packets_t oneinPort_1bcd( 1, *itinPort_1bc9);
		Packets_t onesystemFunction_1bd4( 1, *itsystemFunction_1bd0);
		executeOne( oneinPort_1bcd, onesystemFunction_1bd4);
	}
}

void InPortTest_1bb7::executeOne( const Packets_t& inPorts_1bb8, const Packets_t& systemFunctions_1bba)
{
	Packets_t inPorts_1bd9;
	Packets_t mains_1bdc;
	InPort2InPort_1bd6 inPort2InPort_1bd6;
	bool isMatchInPort2InPort_1bd6= inPort2InPort_1bd6( inPorts_1bb8, systemFunctions_1bba, inPorts_1bd9, mains_1bdc);
	_inPort_1bc2->insert( _inPort_1bc2->end(), inPorts_1bd9.begin(), inPorts_1bd9.end());
	_systemFunction_1bc3->insert( _systemFunction_1bc3->end(), mains_1bdc.begin(), mains_1bdc.end());
	if( isMatchInPort2InPort_1bd6)
		return;
	Packets_t inPorts_1c05;
	Packets_t mains_1c08;
	OutPort2InPort_1c02 outPort2InPort_1c02;
	bool isMatchOutPort2InPort_1c02= outPort2InPort_1c02( inPorts_1bb8, systemFunctions_1bba, inPorts_1c05, mains_1c08);
	_inPort_1bc4->insert( _inPort_1bc4->end(), inPorts_1c05.begin(), inPorts_1c05.end());
	_systemFunction_1bc5->insert( _systemFunction_1bc5->end(), mains_1c08.begin(), mains_1c08.end());
	if( isMatchOutPort2InPort_1c02)
		return;
	Packets_t inPorts_1c31;
	Packets_t mains_1c34;
	Otherwise_1c2e otherwise_1c2e;
	bool isMatchOtherwise_1c2e= otherwise_1c2e( inPorts_1bb8, systemFunctions_1bba, inPorts_1c31, mains_1c34);
	_inPort_1bc6->insert( _inPort_1bc6->end(), inPorts_1c31.begin(), inPorts_1c31.end());
	_systemFunction_1bc7->insert( _systemFunction_1bc7->end(), mains_1c34.begin(), mains_1c34.end());
	if( isMatchOtherwise_1c2e)
		return;
}

bool InPortTest_1bb7::isInputUnique( const Udm::Object& inPort_1bca, const Udm::Object& systemFunction_1bd1)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itinPort_1bcc= _inPort_1bc8.begin(), itsystemFunction_1bd3= _systemFunction_1bcf.begin(); itinPort_1bcc!= _inPort_1bc8.end(), itsystemFunction_1bd3!= _systemFunction_1bcf.end(); ++itinPort_1bcc, ++itsystemFunction_1bd3)
	{
		if( ( *itinPort_1bcc== inPort_1bca)&& ( *itsystemFunction_1bd3== systemFunction_1bd1))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_inPort_1bc8.push_back( inPort_1bca);
		_systemFunction_1bcf.push_back( systemFunction_1bd1);
	}
	return isUnique;
}

bool InPort2InPort_1bd6::operator()( const Packets_t& inPorts_1bd7, const Packets_t& mains_1bda, Packets_t& inPorts_1bd9, Packets_t& mains_1bdc)
{
#ifdef PRINT_INFO
	printLog("InPort2InPort_1bd6" );
#endif
	_inPort_1bdd= &inPorts_1bd9;
	_main_1bde= &mains_1bdc;
	processInputPackets( inPorts_1bd7, mains_1bda);
	if( false== _matches.empty())
		return true;
	return false;
}

bool InPort2InPort_1bd6::isInputUnique( const Udm::Object& inPort_1be3, const Udm::Object& main_1bec)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itInPort_1be5= _inPort_1bdf.begin(), itMain_1bee= _main_1be8.begin(); itInPort_1be5!= _inPort_1bdf.end(), itMain_1bee!= _main_1be8.end(); ++itInPort_1be5, ++itMain_1bee)
	{
		if( ( *itInPort_1be5== inPort_1be3)&& ( *itMain_1bee== main_1bec))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_inPort_1bdf.push_back( inPort_1be3);
		_main_1be8.push_back( main_1bec);
	}
	return isUnique;
}

bool InPort2InPort_1bd6::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void InPort2InPort_1bd6::processInputPackets( const Packets_t& inPorts_1bd7, const Packets_t& mains_1bda)
{
	for( Packets_t::const_iterator itInPort_1be0= inPorts_1bd7.begin(), itMain_1be9= mains_1bda.begin(); itInPort_1be0!= inPorts_1bd7.end(), itMain_1be9!= mains_1bda.end(); ++itInPort_1be0, ++itMain_1be9)
	{
		bool isUnique= isInputUnique( *itInPort_1be0, *itMain_1be9);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itInPort_1be0, *itMain_1be9);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.inPort_1bfa, currMatch.main_1bfb);
	}
}

bool InPort2InPort_1bd6::patternMatcher( const Udm::Object& inPort_1be1, const Udm::Object& main_1bea)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( inPort_1be1.type(), CyPhyML::SignalFlow::InPort::meta))
			continue;
		CyPhyML::SignalFlow::InPort inPort_1be6= CyPhyML::SignalFlow::InPort::Cast( inPort_1be1);
		if( false== Uml::IsDerivedFrom( main_1bea.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1bef= SFC::Function::Cast( main_1bea);
		set< CyPhyML::SignalFlow::Line> lines_1bf1= inPort_1be6.srcLine();
		for( set< CyPhyML::SignalFlow::Line>::const_iterator itLines_1bf2= lines_1bf1.begin(); itLines_1bf2!= lines_1bf1.end(); ++itLines_1bf2)
		{
			CyPhyML::SignalFlow::Line currLine_1bf3= *itLines_1bf2;
			CyPhyML::SignalFlow::SF_Port subsystemInPort_1bf4= currLine_1bf3.srcLine_end();
			if( false== Uml::IsDerivedFrom( subsystemInPort_1bf4.type(), CyPhyML::SignalFlow::InPort::meta))
				continue;
			CyPhyML::SignalFlow::InPort currSubsystemInPort_1bf5= CyPhyML::SignalFlow::InPort::Cast( subsystemInPort_1bf4);
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1bf9;
			if( !isValidBound(boundObjs_1bf9, inPort_1be6, true))
				continue;
			currMatch.inPort_1bfa= inPort_1be6;
			if( !isValidBound(boundObjs_1bf9, main_1bef, true))
				continue;
			currMatch.main_1bfb= main_1bef;
			if( !isValidBound(boundObjs_1bf9, currSubsystemInPort_1bf5, false))
				continue;
			currMatch.subsystemInPort_1bfc= currSubsystemInPort_1bf5;
			if( !isValidBound(boundObjs_1bf9, currLine_1bf3, false))
				continue;
			currMatch.line_1bfd= currLine_1bf3;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void InPort2InPort_1bd6::outputAppender( const CyPhyML::SignalFlow::InPort& inPort_1bfe, const SFC::Function& main_1c00)
{
	_inPort_1bdd->push_back( inPort_1bfe);
	_main_1bde->push_back( main_1c00);
}

bool OutPort2InPort_1c02::operator()( const Packets_t& inPorts_1c03, const Packets_t& mains_1c06, Packets_t& inPorts_1c05, Packets_t& mains_1c08)
{
#ifdef PRINT_INFO
	printLog("OutPort2InPort_1c02" );
#endif
	_inPort_1c09= &inPorts_1c05;
	_main_1c0a= &mains_1c08;
	processInputPackets( inPorts_1c03, mains_1c06);
	if( false== _matches.empty())
		return true;
	return false;
}

bool OutPort2InPort_1c02::isInputUnique( const Udm::Object& inPort_1c0f, const Udm::Object& main_1c18)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itInPort_1c11= _inPort_1c0b.begin(), itMain_1c1a= _main_1c14.begin(); itInPort_1c11!= _inPort_1c0b.end(), itMain_1c1a!= _main_1c14.end(); ++itInPort_1c11, ++itMain_1c1a)
	{
		if( ( *itInPort_1c11== inPort_1c0f)&& ( *itMain_1c1a== main_1c18))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_inPort_1c0b.push_back( inPort_1c0f);
		_main_1c14.push_back( main_1c18);
	}
	return isUnique;
}

bool OutPort2InPort_1c02::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void OutPort2InPort_1c02::processInputPackets( const Packets_t& inPorts_1c03, const Packets_t& mains_1c06)
{
	for( Packets_t::const_iterator itInPort_1c0c= inPorts_1c03.begin(), itMain_1c15= mains_1c06.begin(); itInPort_1c0c!= inPorts_1c03.end(), itMain_1c15!= mains_1c06.end(); ++itInPort_1c0c, ++itMain_1c15)
	{
		bool isUnique= isInputUnique( *itInPort_1c0c, *itMain_1c15);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itInPort_1c0c, *itMain_1c15);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.inPort_1c26, currMatch.main_1c27);
	}
}

bool OutPort2InPort_1c02::patternMatcher( const Udm::Object& inPort_1c0d, const Udm::Object& main_1c16)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( inPort_1c0d.type(), CyPhyML::SignalFlow::InPort::meta))
			continue;
		CyPhyML::SignalFlow::InPort inPort_1c12= CyPhyML::SignalFlow::InPort::Cast( inPort_1c0d);
		if( false== Uml::IsDerivedFrom( main_1c16.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1c1b= SFC::Function::Cast( main_1c16);
		set< CyPhyML::SignalFlow::Line> lines_1c1d= inPort_1c12.srcLine();
		for( set< CyPhyML::SignalFlow::Line>::const_iterator itLines_1c1e= lines_1c1d.begin(); itLines_1c1e!= lines_1c1d.end(); ++itLines_1c1e)
		{
			CyPhyML::SignalFlow::Line currLine_1c1f= *itLines_1c1e;
			CyPhyML::SignalFlow::SF_Port outPort_1c20= currLine_1c1f.srcLine_end();
			if( false== Uml::IsDerivedFrom( outPort_1c20.type(), CyPhyML::SignalFlow::OutPort::meta))
				continue;
			CyPhyML::SignalFlow::OutPort currOutPort_1c21= CyPhyML::SignalFlow::OutPort::Cast( outPort_1c20);
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1c25;
			if( !isValidBound(boundObjs_1c25, inPort_1c12, true))
				continue;
			currMatch.inPort_1c26= inPort_1c12;
			if( !isValidBound(boundObjs_1c25, main_1c1b, true))
				continue;
			currMatch.main_1c27= main_1c1b;
			if( !isValidBound(boundObjs_1c25, currOutPort_1c21, false))
				continue;
			currMatch.outPort_1c28= currOutPort_1c21;
			if( !isValidBound(boundObjs_1c25, currLine_1c1f, false))
				continue;
			currMatch.line_1c29= currLine_1c1f;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void OutPort2InPort_1c02::outputAppender( const CyPhyML::SignalFlow::InPort& inPort_1c2a, const SFC::Function& main_1c2c)
{
	_inPort_1c09->push_back( inPort_1c2a);
	_main_1c0a->push_back( main_1c2c);
}

bool Otherwise_1c2e::operator()( const Packets_t& inPorts_1c2f, const Packets_t& mains_1c32, Packets_t& inPorts_1c31, Packets_t& mains_1c34)
{
#ifdef PRINT_INFO
	printLog("Otherwise_1c2e" );
#endif
	_inPort_1c35= &inPorts_1c31;
	_main_1c36= &mains_1c34;
	processInputPackets( inPorts_1c2f, mains_1c32);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_1c2e::isInputUnique( const Udm::Object& inPort_1c3b, const Udm::Object& main_1c44)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itInPort_1c3d= _inPort_1c37.begin(), itMain_1c46= _main_1c40.begin(); itInPort_1c3d!= _inPort_1c37.end(), itMain_1c46!= _main_1c40.end(); ++itInPort_1c3d, ++itMain_1c46)
	{
		if( ( *itInPort_1c3d== inPort_1c3b)&& ( *itMain_1c46== main_1c44))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_inPort_1c37.push_back( inPort_1c3b);
		_main_1c40.push_back( main_1c44);
	}
	return isUnique;
}

bool Otherwise_1c2e::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_1c2e::processInputPackets( const Packets_t& inPorts_1c2f, const Packets_t& mains_1c32)
{
	for( Packets_t::const_iterator itInPort_1c38= inPorts_1c2f.begin(), itMain_1c41= mains_1c32.begin(); itInPort_1c38!= inPorts_1c2f.end(), itMain_1c41!= mains_1c32.end(); ++itInPort_1c38, ++itMain_1c41)
	{
		bool isUnique= isInputUnique( *itInPort_1c38, *itMain_1c41);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itInPort_1c38, *itMain_1c41);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.inPort_1c4d, currMatch.main_1c4e);
	}
}

bool Otherwise_1c2e::patternMatcher( const Udm::Object& inPort_1c39, const Udm::Object& main_1c42)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( inPort_1c39.type(), CyPhyML::SignalFlow::InPort::meta))
			continue;
		CyPhyML::SignalFlow::InPort inPort_1c3e= CyPhyML::SignalFlow::InPort::Cast( inPort_1c39);
		if( false== Uml::IsDerivedFrom( main_1c42.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1c47= SFC::Function::Cast( main_1c42);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1c4c;
		if( !isValidBound(boundObjs_1c4c, inPort_1c3e, true))
			continue;
		currMatch.inPort_1c4d= inPort_1c3e;
		if( !isValidBound(boundObjs_1c4c, main_1c47, true))
			continue;
		currMatch.main_1c4e= main_1c47;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_1c2e::outputAppender( const CyPhyML::SignalFlow::InPort& inPort_1c4f, const SFC::Function& main_1c51)
{
	_inPort_1c35->push_back( inPort_1c4f);
	_main_1c36->push_back( main_1c51);
}

void CreateLocalVars_1c56::operator()( const Packets_t& inPorts_1c58, const Packets_t& mains_1c5a, Packets_t& localVars_1c57, Packets_t& mains_1c5c)
{
#ifdef PRINT_INFO
	printLog("CreateLocalVars_1c56" );
#endif
	RTTGenerator::Instance()->generateRule(1526, "CreateLocalVars");
	_localVar_1c5d= &localVars_1c57;
	_main_1c5e= &mains_1c5c;
	processInputPackets( inPorts_1c58, mains_1c5a);
}

bool CreateLocalVars_1c56::isInputUnique( const Udm::Object& inPort_1c63, const Udm::Object& main_1c6c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itInPort_1c65= _inPort_1c5f.begin(), itMain_1c6e= _main_1c68.begin(); itInPort_1c65!= _inPort_1c5f.end(), itMain_1c6e!= _main_1c68.end(); ++itInPort_1c65, ++itMain_1c6e)
	{
		if( ( *itInPort_1c65== inPort_1c63)&& ( *itMain_1c6e== main_1c6c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_inPort_1c5f.push_back( inPort_1c63);
		_main_1c68.push_back( main_1c6c);
	}
	return isUnique;
}

bool CreateLocalVars_1c56::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateLocalVars_1c56::processInputPackets( const Packets_t& inPorts_1c58, const Packets_t& mains_1c5a)
{
	for( Packets_t::const_iterator itInPort_1c60= inPorts_1c58.begin(), itMain_1c69= mains_1c5a.begin(); itInPort_1c60!= inPorts_1c58.end(), itMain_1c69!= mains_1c5a.end(); ++itInPort_1c60, ++itMain_1c69)
	{
		bool isUnique= isInputUnique( *itInPort_1c60, *itMain_1c69);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itInPort_1c60, *itMain_1c69);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateLocalVars_1c56::patternMatcher( const Udm::Object& inPort_1c61, const Udm::Object& main_1c6a)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( inPort_1c61.type(), CyPhyML::SignalFlow::InPort::meta))
			continue;
		CyPhyML::SignalFlow::InPort inPort_1c66= CyPhyML::SignalFlow::InPort::Cast( inPort_1c61);
		if( false== Uml::IsDerivedFrom( main_1c6a.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1c6f= SFC::Function::Cast( main_1c6a);
		set< CyPhyML::SignalFlow::TypeBaseRef> typeBaseRefs_1c71= inPort_1c66.TypeBaseRef_kind_children();
		for( set< CyPhyML::SignalFlow::TypeBaseRef>::const_iterator itTypeBaseRef_1c72= typeBaseRefs_1c71.begin(); itTypeBaseRef_1c72!= typeBaseRefs_1c71.end(); ++itTypeBaseRef_1c72)
		{
			CyPhyML::SignalFlow::TypeBaseRef currTypeBaseRef_1c73= *itTypeBaseRef_1c72;
			CyPhyML::SignalFlow::SF_TypeBase typeBase_1c74= currTypeBaseRef_1c73.ref();
			if( !typeBase_1c74)
				continue;
			SFC::DT dT_1c75= typeBase_1c74.dt();
			if( !dT_1c75)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1c79;
			if( !isValidBound(boundObjs_1c79, inPort_1c66, true))
				continue;
			currMatch.inPort_1c7a= inPort_1c66;
			if( !isValidBound(boundObjs_1c79, main_1c6f, true))
				continue;
			currMatch.main_1c7b= main_1c6f;
			if( !isValidBound(boundObjs_1c79, currTypeBaseRef_1c73, false))
				continue;
			currMatch.typeBaseRef_1c7c= currTypeBaseRef_1c73;
			if( !isValidBound(boundObjs_1c79, dT_1c75, false))
				continue;
			currMatch.dT_1c7d= dT_1c75;
			if( !isValidBound(boundObjs_1c79, typeBase_1c74, false))
				continue;
			currMatch.typeBase_1c7e= typeBase_1c74;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateLocalVars_1c56::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar newLocalVar_1c7f= SFC::LocalVar::Create( currMatch.main_1c7b);
		SFC::DT& DT= currMatch.dT_1c7d;
		CyPhyML::SignalFlow::InPort& InPort= currMatch.inPort_1c7a;
		SFC::LocalVar& LocalVar= newLocalVar_1c7f;
		SFC::Function& Main= currMatch.main_1c7b;
		CyPhyML::SignalFlow::SF_TypeBase& TypeBase= currMatch.typeBase_1c7e;
		CyPhyML::SignalFlow::TypeBaseRef& TypeBaseRef= currMatch.typeBaseRef_1c7c;
		{
__int64 statementCount = Main.statementCount();

LocalVar.name() = (  boost::format( "sig_%1%" ) % statementCount  ).str();
LocalVar.type() = "double";
LocalVar.statementIndex() = statementCount++;

Main.statementCount() = statementCount;
};
		newLocalVar_1c7f.dt()= currMatch.dT_1c7d;
		currMatch.inPort_1c7a.argdecl()= newLocalVar_1c7f;
		outputAppender( newLocalVar_1c7f, currMatch.main_1c7b);
	}
}

void CreateLocalVars_1c56::outputAppender( const SFC::LocalVar& localVar_1c80, const SFC::Function& main_1c82)
{
	_localVar_1c5d->push_back( localVar_1c80);
	_main_1c5e->push_back( main_1c82);
}

void GetInArgs_1c84::operator()( const Packets_t& inPorts_1c85)
{
#ifdef PRINT_INFO
	printLog("GetInArgs_1c84" );
#endif
	RTTGenerator::Instance()->generateRule(1540, "GetInArgs");
	processInputPackets( inPorts_1c85);
}

bool GetInArgs_1c84::isInputUnique( const Udm::Object& inPort_1c8b)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itInPort_1c8d= _inPort_1c87.begin(); itInPort_1c8d!= _inPort_1c87.end(); ++itInPort_1c8d)
	{
		if( ( *itInPort_1c8d== inPort_1c8b))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_inPort_1c87.push_back( inPort_1c8b);
	return isUnique;
}

bool GetInArgs_1c84::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetInArgs_1c84::processInputPackets( const Packets_t& inPorts_1c85)
{
	for( Packets_t::const_iterator itInPort_1c88= inPorts_1c85.begin(); itInPort_1c88!= inPorts_1c85.end(); ++itInPort_1c88)
	{
		bool isUnique= isInputUnique( *itInPort_1c88);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itInPort_1c88);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetInArgs_1c84::patternMatcher( const Udm::Object& inPort_1c89)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( inPort_1c89.type(), CyPhyML::SignalFlow::InPort::meta))
			continue;
		CyPhyML::SignalFlow::InPort inPort_1c8e= CyPhyML::SignalFlow::InPort::Cast( inPort_1c89);
		set< CyPhyML::SignalFlow::Line> lines_1c90= inPort_1c8e.srcLine();
		for( set< CyPhyML::SignalFlow::Line>::const_iterator itLines_1c91= lines_1c90.begin(); itLines_1c91!= lines_1c90.end(); ++itLines_1c91)
		{
			CyPhyML::SignalFlow::Line currLine_1c92= *itLines_1c91;
			CyPhyML::SignalFlow::SF_Port subsystemInPort_1c93= currLine_1c92.srcLine_end();
			if( false== Uml::IsDerivedFrom( subsystemInPort_1c93.type(), CyPhyML::SignalFlow::InPort::meta))
				continue;
			CyPhyML::SignalFlow::InPort currSubsystemInPort_1c94= CyPhyML::SignalFlow::InPort::Cast( subsystemInPort_1c93);
			set< SFC::Arg> args_1c95= currSubsystemInPort_1c94.arg();
			for( set< SFC::Arg>::const_iterator itArgs_1c96= args_1c95.begin(); itArgs_1c96!= args_1c95.end(); ++itArgs_1c96)
			{
				SFC::Arg currArg_1c97= *itArgs_1c96;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_1c9b;
				if( !isValidBound(boundObjs_1c9b, inPort_1c8e, true))
					continue;
				currMatch.inPort_1c9c= inPort_1c8e;
				if( !isValidBound(boundObjs_1c9b, currArg_1c97, false))
					continue;
				currMatch.arg_1c9d= currArg_1c97;
				if( !isValidBound(boundObjs_1c9b, currSubsystemInPort_1c94, false))
					continue;
				currMatch.subsystemInPort_1c9e= currSubsystemInPort_1c94;
				if( !isValidBound(boundObjs_1c9b, currLine_1c92, false))
					continue;
				currMatch.line_1c9f= currLine_1c92;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void GetInArgs_1c84::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.inPort_1c9c.argdecl()= currMatch.arg_1c9d;
	}
}

void GetLocalVars_1ca0::operator()( const Packets_t& inPorts_1ca1)
{
#ifdef PRINT_INFO
	printLog("GetLocalVars_1ca0" );
#endif
	RTTGenerator::Instance()->generateRule(1549, "GetLocalVars");
	processInputPackets( inPorts_1ca1);
}

bool GetLocalVars_1ca0::isInputUnique( const Udm::Object& inPort_1ca7)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itInPort_1ca9= _inPort_1ca3.begin(); itInPort_1ca9!= _inPort_1ca3.end(); ++itInPort_1ca9)
	{
		if( ( *itInPort_1ca9== inPort_1ca7))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_inPort_1ca3.push_back( inPort_1ca7);
	return isUnique;
}

bool GetLocalVars_1ca0::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetLocalVars_1ca0::processInputPackets( const Packets_t& inPorts_1ca1)
{
	for( Packets_t::const_iterator itInPort_1ca4= inPorts_1ca1.begin(); itInPort_1ca4!= inPorts_1ca1.end(); ++itInPort_1ca4)
	{
		bool isUnique= isInputUnique( *itInPort_1ca4);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itInPort_1ca4);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetLocalVars_1ca0::patternMatcher( const Udm::Object& inPort_1ca5)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( inPort_1ca5.type(), CyPhyML::SignalFlow::InPort::meta))
			continue;
		CyPhyML::SignalFlow::InPort inPort_1caa= CyPhyML::SignalFlow::InPort::Cast( inPort_1ca5);
		set< CyPhyML::SignalFlow::Line> lines_1cac= inPort_1caa.srcLine();
		for( set< CyPhyML::SignalFlow::Line>::const_iterator itLines_1cad= lines_1cac.begin(); itLines_1cad!= lines_1cac.end(); ++itLines_1cad)
		{
			CyPhyML::SignalFlow::Line currLine_1cae= *itLines_1cad;
			CyPhyML::SignalFlow::SF_Port outPort_1caf= currLine_1cae.srcLine_end();
			if( false== Uml::IsDerivedFrom( outPort_1caf.type(), CyPhyML::SignalFlow::OutPort::meta))
				continue;
			CyPhyML::SignalFlow::OutPort currOutPort_1cb0= CyPhyML::SignalFlow::OutPort::Cast( outPort_1caf);
			SFC::ArgDeclBase argDeclBase_1cb1= currOutPort_1cb0.argdecl();
			if( !argDeclBase_1cb1)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1cb5;
			if( !isValidBound(boundObjs_1cb5, inPort_1caa, true))
				continue;
			currMatch.inPort_1cb6= inPort_1caa;
			if( !isValidBound(boundObjs_1cb5, argDeclBase_1cb1, false))
				continue;
			currMatch.argDeclBase_1cb7= argDeclBase_1cb1;
			if( !isValidBound(boundObjs_1cb5, currOutPort_1cb0, false))
				continue;
			currMatch.outPort_1cb8= currOutPort_1cb0;
			if( !isValidBound(boundObjs_1cb5, currLine_1cae, false))
				continue;
			currMatch.line_1cb9= currLine_1cae;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetLocalVars_1ca0::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		currMatch.inPort_1cb6.argdecl()= currMatch.argDeclBase_1cb7;
	}
}

void ZeroInitLocalVars_1cba::operator()( const Packets_t& localVars_1cbb, const Packets_t& mains_1cbd)
{
#ifdef PRINT_INFO
	printLog("ZeroInitLocalVars_1cba" );
#endif
	RTTGenerator::Instance()->generateRule(1558, "ZeroInitLocalVars");
	processInputPackets( localVars_1cbb, mains_1cbd);
}

bool ZeroInitLocalVars_1cba::isInputUnique( const Udm::Object& localVar_1cc3, const Udm::Object& main_1ccc)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itLocalVar_1cc5= _localVar_1cbf.begin(), itMain_1cce= _main_1cc8.begin(); itLocalVar_1cc5!= _localVar_1cbf.end(), itMain_1cce!= _main_1cc8.end(); ++itLocalVar_1cc5, ++itMain_1cce)
	{
		if( ( *itLocalVar_1cc5== localVar_1cc3)&& ( *itMain_1cce== main_1ccc))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_localVar_1cbf.push_back( localVar_1cc3);
		_main_1cc8.push_back( main_1ccc);
	}
	return isUnique;
}

bool ZeroInitLocalVars_1cba::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void ZeroInitLocalVars_1cba::processInputPackets( const Packets_t& localVars_1cbb, const Packets_t& mains_1cbd)
{
	for( Packets_t::const_iterator itLocalVar_1cc0= localVars_1cbb.begin(), itMain_1cc9= mains_1cbd.begin(); itLocalVar_1cc0!= localVars_1cbb.end(), itMain_1cc9!= mains_1cbd.end(); ++itLocalVar_1cc0, ++itMain_1cc9)
	{
		bool isUnique= isInputUnique( *itLocalVar_1cc0, *itMain_1cc9);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itLocalVar_1cc0, *itMain_1cc9);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ZeroInitLocalVars_1cba::patternMatcher( const Udm::Object& localVar_1cc1, const Udm::Object& main_1cca)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( localVar_1cc1.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_1cc6= SFC::LocalVar::Cast( localVar_1cc1);
		if( false== Uml::IsDerivedFrom( main_1cca.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1ccf= SFC::Function::Cast( main_1cca);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1cd4;
		if( !isValidBound(boundObjs_1cd4, localVar_1cc6, true))
			continue;
		currMatch.localVar_1cd5= localVar_1cc6;
		if( !isValidBound(boundObjs_1cd4, main_1ccf, true))
			continue;
		currMatch.main_1cd6= main_1ccf;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void ZeroInitLocalVars_1cba::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar& LocalVar= currMatch.localVar_1cd5;
		SFC::Function& Main= currMatch.main_1cd6;
		{
SFUtils::ZeroInit( Main, LocalVar );
};
	}
}

void GetFunctions_1ce7::operator()( const Packets_t& systems_1ce8, Packets_t& systems_1cea, Packets_t& systemFunctions_1ceb)
{
#ifdef PRINT_INFO
	printLog("GetFunctions_1ce7" );
#endif
	_system_1cec= &systems_1cea;
	_systemFunction_1ced= &systemFunctions_1ceb;
	if( ( !systems_1ce8.empty()))
		callGetFunctions_1d09( systems_1ce8);
}

void GetFunctions_1ce7::callGetFunctions_1d09( const Packets_t& subsystems_1cef)
{
	Packets_t subsystems_1cf1;
	Packets_t mains_1cf2;
	GetFunctions_1cee getFunctions_1cee;
	getFunctions_1cee( subsystems_1cef, subsystems_1cf1, mains_1cf2);
	_system_1cec->insert( _system_1cec->end(), subsystems_1cf1.begin(), subsystems_1cf1.end());
	_systemFunction_1ced->insert( _systemFunction_1ced->end(), mains_1cf2.begin(), mains_1cf2.end());
}

void GetFunctions_1cee::operator()( const Packets_t& subsystems_1cef, Packets_t& subsystems_1cf1, Packets_t& mains_1cf2)
{
#ifdef PRINT_INFO
	printLog("GetFunctions_1cee" );
#endif
	RTTGenerator::Instance()->generateRule(4701, "GetFunctions");
	_subsystem_1cf3= &subsystems_1cf1;
	_main_1cf4= &mains_1cf2;
	processInputPackets( subsystems_1cef);
}

bool GetFunctions_1cee::isInputUnique( const Udm::Object& subsystem_1cf9)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1cfb= _subsystem_1cf5.begin(); itSubsystem_1cfb!= _subsystem_1cf5.end(); ++itSubsystem_1cfb)
	{
		if( ( *itSubsystem_1cfb== subsystem_1cf9))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
		_subsystem_1cf5.push_back( subsystem_1cf9);
	return isUnique;
}

bool GetFunctions_1cee::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetFunctions_1cee::processInputPackets( const Packets_t& subsystems_1cef)
{
	for( Packets_t::const_iterator itSubsystem_1cf6= subsystems_1cef.begin(); itSubsystem_1cf6!= subsystems_1cef.end(); ++itSubsystem_1cf6)
	{
		bool isUnique= isInputUnique( *itSubsystem_1cf6);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1cf6);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetFunctions_1cee::patternMatcher( const Udm::Object& subsystem_1cf7)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1cf7.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1cfc= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1cf7);
		SFC::Function main_1cfe= subsystem_1cfc.main();
		if( !main_1cfe)
			continue;
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1d02;
		if( !isValidBound(boundObjs_1d02, subsystem_1cfc, true))
			continue;
		currMatch.subsystem_1d03= subsystem_1cfc;
		if( !isValidBound(boundObjs_1d02, main_1cfe, false))
			continue;
		currMatch.main_1d04= main_1cfe;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void GetFunctions_1cee::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_1d03, currMatch.main_1d04);
	}
}

void GetFunctions_1cee::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1d05, const SFC::Function& main_1d07)
{
	_subsystem_1cf3->push_back( subsystem_1d05);
	_main_1cf4->push_back( main_1d07);
}

void CreateProgramsTopLevel_1d17::operator()( const Packets_t& systems_1d18, const Packets_t& projects_1d1a, Packets_t& systems_1d1c, Packets_t& programs_1d1d)
{
#ifdef PRINT_INFO
	printLog("CreateProgramsTopLevel_1d17" );
#endif
	_system_1d1e= &systems_1d1c;
	_program_1d1f= &programs_1d1d;
	for( Packets_t::const_iterator itsystem_1d21= systems_1d18.begin(), itproject_1d28= projects_1d1a.begin(); itsystem_1d21!= systems_1d18.end(), itproject_1d28!= projects_1d1a.end(); ++itsystem_1d21, ++itproject_1d28)
	{
		bool isUnique= isInputUnique( *itsystem_1d21, *itproject_1d28);
		if( !isUnique)
			continue;
		Packets_t onesystem_1d25( 1, *itsystem_1d21);
		Packets_t oneproject_1d2c( 1, *itproject_1d28);
		executeOne( onesystem_1d25, oneproject_1d2c);
	}
}

void CreateProgramsTopLevel_1d17::executeOne( const Packets_t& systems_1d18, const Packets_t& projects_1d1a)
{
	if( ( !systems_1d18.empty())&& ( !projects_1d1a.empty()))
		callHasClassFilter_1dbd( systems_1d18, projects_1d1a);
}

bool CreateProgramsTopLevel_1d17::isInputUnique( const Udm::Object& system_1d22, const Udm::Object& project_1d29)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itsystem_1d24= _system_1d20.begin(), itproject_1d2b= _project_1d27.begin(); itsystem_1d24!= _system_1d20.end(), itproject_1d2b!= _project_1d27.end(); ++itsystem_1d24, ++itproject_1d2b)
	{
		if( ( *itsystem_1d24== system_1d22)&& ( *itproject_1d2b== project_1d29))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_system_1d20.push_back( system_1d22);
		_project_1d27.push_back( project_1d29);
	}
	return isUnique;
}

void CreateProgramsTopLevel_1d17::callHasClassFilter_1dbd( const Packets_t& systems_1d57, const Packets_t& projects_1d59)
{
	Packets_t systems_1d5b;
	Packets_t projects_1d5c;
	Packets_t systems_1d5d;
	Packets_t projects_1d5e;
	HasClassFilter_1d56 hasClassFilter_1d56;
	hasClassFilter_1d56( systems_1d57, projects_1d59, systems_1d5b, projects_1d5c, systems_1d5d, projects_1d5e);
	if( ( !systems_1d5d.empty())&& ( !projects_1d5e.empty()))
		callCreateProgramClass_1dc0( systems_1d5d, projects_1d5e);
}

void CreateProgramsTopLevel_1d17::callCreateProgramClass_1dc0( const Packets_t& subsystems_1d2f, const Packets_t& projects_1d33)
{
	Packets_t subsystems_1d31;
	Packets_t programs_1d32;
	CreateProgramClass_1d2e createProgramClass_1d2e;
	createProgramClass_1d2e( subsystems_1d2f, projects_1d33, subsystems_1d31, programs_1d32);
	_system_1d1e->insert( _system_1d1e->end(), subsystems_1d31.begin(), subsystems_1d31.end());
	_program_1d1f->insert( _program_1d1f->end(), programs_1d32.begin(), programs_1d32.end());
}

void CreateProgramClass_1d2e::operator()( const Packets_t& subsystems_1d2f, const Packets_t& projects_1d33, Packets_t& subsystems_1d31, Packets_t& programs_1d32)
{
#ifdef PRINT_INFO
	printLog("CreateProgramClass_1d2e" );
#endif
	RTTGenerator::Instance()->generateRule(1567, "CreateProgramClass");
	_subsystem_1d35= &subsystems_1d31;
	_program_1d36= &programs_1d32;
	processInputPackets( subsystems_1d2f, projects_1d33);
}

bool CreateProgramClass_1d2e::isInputUnique( const Udm::Object& subsystem_1d3b, const Udm::Object& project_1d44)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1d3d= _subsystem_1d37.begin(), itProject_1d46= _project_1d40.begin(); itSubsystem_1d3d!= _subsystem_1d37.end(), itProject_1d46!= _project_1d40.end(); ++itSubsystem_1d3d, ++itProject_1d46)
	{
		if( ( *itSubsystem_1d3d== subsystem_1d3b)&& ( *itProject_1d46== project_1d44))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1d37.push_back( subsystem_1d3b);
		_project_1d40.push_back( project_1d44);
	}
	return isUnique;
}

bool CreateProgramClass_1d2e::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateProgramClass_1d2e::processInputPackets( const Packets_t& subsystems_1d2f, const Packets_t& projects_1d33)
{
	for( Packets_t::const_iterator itSubsystem_1d38= subsystems_1d2f.begin(), itProject_1d41= projects_1d33.begin(); itSubsystem_1d38!= subsystems_1d2f.end(), itProject_1d41!= projects_1d33.end(); ++itSubsystem_1d38, ++itProject_1d41)
	{
		bool isUnique= isInputUnique( *itSubsystem_1d38, *itProject_1d41);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1d38, *itProject_1d41);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateProgramClass_1d2e::patternMatcher( const Udm::Object& subsystem_1d39, const Udm::Object& project_1d42)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1d39.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1d3e= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1d39);
		if( false== Uml::IsDerivedFrom( project_1d42.type(), SFC::Project::meta))
			continue;
		SFC::Project project_1d47= SFC::Project::Cast( project_1d42);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1d4c;
		if( !isValidBound(boundObjs_1d4c, subsystem_1d3e, true))
			continue;
		currMatch.subsystem_1d4d= subsystem_1d3e;
		if( !isValidBound(boundObjs_1d4c, project_1d47, true))
			continue;
		currMatch.project_1d4e= project_1d47;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateProgramClass_1d2e::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::Program newProgram_1d4f= SFC::Program::Create( currMatch.project_1d4e, SFC::Project::meta_stmnt);
		SFC::Class newClass_1d50= SFC::Class::Create( newProgram_1d4f, SFC::Program::meta_stmnt);
		SFC::Struct newStruct_1d51= SFC::Struct::Create( newClass_1d50, SFC::Class::meta_stmnt);
		SFC::Class& Class= newClass_1d50;
		SFC::Program& Program= newProgram_1d4f;
		SFC::Project& Project= currMatch.project_1d4e;
		SFC::Struct& Struct= newStruct_1d51;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_1d4d;
		{
__int64 statementCount = Project.statementCount();
Program.statementIndex() = statementCount++;
Project.statementCount() = statementCount;
};
		{
typedef std::set< Udm::Object > ObjectSet;

ObjectSet objectSet = SFUtils::getAllInstanceEquivalent( Subsystem );
objectSet.erase( Subsystem );

for( ObjectSet::iterator obsItr = objectSet.begin() ; obsItr != objectSet.end() ; (void)++obsItr ) {
    CyPhyML::SignalFlow::Subsystem::Cast( *obsItr ).cls() = Class;
}
};
		{
__int64 statementCount = Program.statementCount();
Class.statementIndex() = statementCount++;
Program.statementCount() = statementCount;
};
		{
__int64 statementCount = Class.statementCount();
Struct.statementIndex() = statementCount++;
Class.statementCount() = statementCount;
};
		{
std::string subsystemName = Subsystem.name();
Program.filename() = subsystemName + "_sl";

std::string name = subsystemName + "_" + boost::lexical_cast< std::string >( Subsystem.uniqueId() );
Class.name() = name + "_class";
Struct.name() = name + "_context";
};
		currMatch.subsystem_1d4d.cls()= newClass_1d50;
		outputAppender( currMatch.subsystem_1d4d, newProgram_1d4f);
	}
}

void CreateProgramClass_1d2e::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1d52, const SFC::Program& program_1d54)
{
	_subsystem_1d35->push_back( subsystem_1d52);
	_program_1d36->push_back( program_1d54);
}

void HasClassFilter_1d56::operator()( const Packets_t& systems_1d57, const Packets_t& projects_1d59, Packets_t& systems_1d5b, Packets_t& projects_1d5c, Packets_t& systems_1d5d, Packets_t& projects_1d5e)
{
#ifdef PRINT_INFO
	printLog("HasClassFilter_1d56" );
#endif
	_system_1d5f= &systems_1d5b;
	_project_1d60= &projects_1d5c;
	_system_1d61= &systems_1d5d;
	_project_1d62= &projects_1d5e;
	for( Packets_t::const_iterator itsystem_1d64= systems_1d57.begin(), itproject_1d6b= projects_1d59.begin(); itsystem_1d64!= systems_1d57.end(), itproject_1d6b!= projects_1d59.end(); ++itsystem_1d64, ++itproject_1d6b)
	{
		bool isUnique= isInputUnique( *itsystem_1d64, *itproject_1d6b);
		if( !isUnique)
			continue;
		Packets_t onesystem_1d68( 1, *itsystem_1d64);
		Packets_t oneproject_1d6f( 1, *itproject_1d6b);
		executeOne( onesystem_1d68, oneproject_1d6f);
	}
}

void HasClassFilter_1d56::executeOne( const Packets_t& systems_1d57, const Packets_t& projects_1d59)
{
	Packets_t subsystems_1d74;
	Packets_t projects_1d77;
	SubsystemHasClass_1d71 subsystemHasClass_1d71;
	bool isMatchSubsystemHasClass_1d71= subsystemHasClass_1d71( systems_1d57, projects_1d59, subsystems_1d74, projects_1d77);
	_system_1d5f->insert( _system_1d5f->end(), subsystems_1d74.begin(), subsystems_1d74.end());
	_project_1d60->insert( _project_1d60->end(), projects_1d77.begin(), projects_1d77.end());
	if( isMatchSubsystemHasClass_1d71)
		return;
	Packets_t subsystems_1d9b;
	Packets_t projects_1d9e;
	NoClass_1d98 noClass_1d98;
	bool isMatchNoClass_1d98= noClass_1d98( systems_1d57, projects_1d59, subsystems_1d9b, projects_1d9e);
	_system_1d61->insert( _system_1d61->end(), subsystems_1d9b.begin(), subsystems_1d9b.end());
	_project_1d62->insert( _project_1d62->end(), projects_1d9e.begin(), projects_1d9e.end());
	if( isMatchNoClass_1d98)
		return;
}

bool HasClassFilter_1d56::isInputUnique( const Udm::Object& system_1d65, const Udm::Object& project_1d6c)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itsystem_1d67= _system_1d63.begin(), itproject_1d6e= _project_1d6a.begin(); itsystem_1d67!= _system_1d63.end(), itproject_1d6e!= _project_1d6a.end(); ++itsystem_1d67, ++itproject_1d6e)
	{
		if( ( *itsystem_1d67== system_1d65)&& ( *itproject_1d6e== project_1d6c))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_system_1d63.push_back( system_1d65);
		_project_1d6a.push_back( project_1d6c);
	}
	return isUnique;
}

bool SubsystemHasClass_1d71::operator()( const Packets_t& subsystems_1d72, const Packets_t& projects_1d75, Packets_t& subsystems_1d74, Packets_t& projects_1d77)
{
#ifdef PRINT_INFO
	printLog("SubsystemHasClass_1d71" );
#endif
	_subsystem_1d78= &subsystems_1d74;
	_project_1d79= &projects_1d77;
	processInputPackets( subsystems_1d72, projects_1d75);
	if( false== _matches.empty())
		return true;
	return false;
}

bool SubsystemHasClass_1d71::isInputUnique( const Udm::Object& subsystem_1d7e, const Udm::Object& project_1d87)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1d80= _subsystem_1d7a.begin(), itProject_1d89= _project_1d83.begin(); itSubsystem_1d80!= _subsystem_1d7a.end(), itProject_1d89!= _project_1d83.end(); ++itSubsystem_1d80, ++itProject_1d89)
	{
		if( ( *itSubsystem_1d80== subsystem_1d7e)&& ( *itProject_1d89== project_1d87))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1d7a.push_back( subsystem_1d7e);
		_project_1d83.push_back( project_1d87);
	}
	return isUnique;
}

bool SubsystemHasClass_1d71::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void SubsystemHasClass_1d71::processInputPackets( const Packets_t& subsystems_1d72, const Packets_t& projects_1d75)
{
	for( Packets_t::const_iterator itSubsystem_1d7b= subsystems_1d72.begin(), itProject_1d84= projects_1d75.begin(); itSubsystem_1d7b!= subsystems_1d72.end(), itProject_1d84!= projects_1d75.end(); ++itSubsystem_1d7b, ++itProject_1d84)
	{
		bool isUnique= isInputUnique( *itSubsystem_1d7b, *itProject_1d84);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1d7b, *itProject_1d84);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_1d91, currMatch.project_1d92);
	}
}

bool SubsystemHasClass_1d71::patternMatcher( const Udm::Object& subsystem_1d7c, const Udm::Object& project_1d85)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1d7c.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1d81= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1d7c);
		if( false== Uml::IsDerivedFrom( project_1d85.type(), SFC::Project::meta))
			continue;
		SFC::Project project_1d8a= SFC::Project::Cast( project_1d85);
		SFC::Class class_1d8c= subsystem_1d81.cls();
		if( !class_1d8c)
			continue;
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1d90;
		if( !isValidBound(boundObjs_1d90, subsystem_1d81, true))
			continue;
		currMatch.subsystem_1d91= subsystem_1d81;
		if( !isValidBound(boundObjs_1d90, project_1d8a, true))
			continue;
		currMatch.project_1d92= project_1d8a;
		if( !isValidBound(boundObjs_1d90, class_1d8c, false))
			continue;
		currMatch.class_1d93= class_1d8c;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void SubsystemHasClass_1d71::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1d94, const SFC::Project& project_1d96)
{
	_subsystem_1d78->push_back( subsystem_1d94);
	_project_1d79->push_back( project_1d96);
}

bool NoClass_1d98::operator()( const Packets_t& subsystems_1d99, const Packets_t& projects_1d9c, Packets_t& subsystems_1d9b, Packets_t& projects_1d9e)
{
#ifdef PRINT_INFO
	printLog("NoClass_1d98" );
#endif
	_subsystem_1d9f= &subsystems_1d9b;
	_project_1da0= &projects_1d9e;
	processInputPackets( subsystems_1d99, projects_1d9c);
	if( false== _matches.empty())
		return true;
	return false;
}

bool NoClass_1d98::isInputUnique( const Udm::Object& subsystem_1da5, const Udm::Object& project_1dae)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1da7= _subsystem_1da1.begin(), itProject_1db0= _project_1daa.begin(); itSubsystem_1da7!= _subsystem_1da1.end(), itProject_1db0!= _project_1daa.end(); ++itSubsystem_1da7, ++itProject_1db0)
	{
		if( ( *itSubsystem_1da7== subsystem_1da5)&& ( *itProject_1db0== project_1dae))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1da1.push_back( subsystem_1da5);
		_project_1daa.push_back( project_1dae);
	}
	return isUnique;
}

bool NoClass_1d98::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void NoClass_1d98::processInputPackets( const Packets_t& subsystems_1d99, const Packets_t& projects_1d9c)
{
	for( Packets_t::const_iterator itSubsystem_1da2= subsystems_1d99.begin(), itProject_1dab= projects_1d9c.begin(); itSubsystem_1da2!= subsystems_1d99.end(), itProject_1dab!= projects_1d9c.end(); ++itSubsystem_1da2, ++itProject_1dab)
	{
		bool isUnique= isInputUnique( *itSubsystem_1da2, *itProject_1dab);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1da2, *itProject_1dab);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_1db7, currMatch.project_1db8);
	}
}

bool NoClass_1d98::patternMatcher( const Udm::Object& subsystem_1da3, const Udm::Object& project_1dac)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1da3.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1da8= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1da3);
		if( false== Uml::IsDerivedFrom( project_1dac.type(), SFC::Project::meta))
			continue;
		SFC::Project project_1db1= SFC::Project::Cast( project_1dac);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1db6;
		if( !isValidBound(boundObjs_1db6, subsystem_1da8, true))
			continue;
		currMatch.subsystem_1db7= subsystem_1da8;
		if( !isValidBound(boundObjs_1db6, project_1db1, true))
			continue;
		currMatch.project_1db8= project_1db1;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void NoClass_1d98::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1db9, const SFC::Project& project_1dbb)
{
	_subsystem_1d9f->push_back( subsystem_1db9);
	_project_1da0->push_back( project_1dbb);
}

void CreateSigFlowsR_1dc3::operator()( const Packets_t& systems_1dc4)
{
#ifdef PRINT_INFO
	printLog("CreateSigFlowsR_1dc3" );
#endif
	if( ( !systems_1dc4.empty()))
		callSubsystemFilter_53b1( systems_1dc4);
}

void CreateSigFlowsR_1dc3::callSubsystemFilter_53b1( const Packets_t& systems_1152)
{
	Packets_t chartsystems_1154;
	Packets_t sFchartsystems_1155;
	Packets_t systems_1156;
	SubsystemFilter_1151 subsystemFilter_1151;
	subsystemFilter_1151( systems_1152, chartsystems_1154, sFchartsystems_1155, systems_1156);
	if( ( !systems_1156.empty()))
		callGetFunctions_53b3( systems_1156);
}

void CreateSigFlowsR_1dc3::callGetFunctions_53b3( const Packets_t& systems_1ce8)
{
	Packets_t systems_1cea;
	Packets_t systemFunctions_1ceb;
	GetFunctions_1ce7 getFunctions_1ce7;
	getFunctions_1ce7( systems_1ce8, systems_1cea, systemFunctions_1ceb);
	if( ( !systems_1cea.empty())&& ( !systemFunctions_1ceb.empty()))
		callCreateTSB_53b5( systems_1cea, systemFunctions_1ceb);
}

void CreateSigFlowsR_1dc3::callCreateTSB_53b5( const Packets_t& systems_1dc7, const Packets_t& systemFunctions_1dc9)
{
	Packets_t systems_1dcb;
	CreateTSB_1dc6 createTSB_1dc6;
	createTSB_1dc6( systems_1dc7, systemFunctions_1dc9, systems_1dcb);
	if( ( !systems_1dcb.empty()))
		callGetSubSubsystems_53b8( systems_1dcb);
}

void CreateSigFlowsR_1dc3::callGetSubSubsystems_53b8( const Packets_t& systems_11d0)
{
	Packets_t subsystems_11d2;
	GetSubSubsystems_11cf getSubSubsystems_11cf;
	getSubSubsystems_11cf( systems_11d0, subsystems_11d2);
	if( ( !subsystems_11d2.empty()))
		callSubsystemFilter_53b1( subsystems_11d2);
}

void CreateTSB_1dc6::operator()( const Packets_t& systems_1dc7, const Packets_t& systemFunctions_1dc9, Packets_t& systems_1dcb)
{
#ifdef PRINT_INFO
	printLog("CreateTSB_1dc6" );
#endif
	_system_1dcc= &systems_1dcb;
	_system_1dcc->insert( _system_1dcc->end(), systems_1dc7.begin(), systems_1dc7.end());
	if( ( !systems_1dc7.empty())&& ( !systemFunctions_1dc9.empty()))
		callPassThroughs_53a1( systems_1dc7, systemFunctions_1dc9);
}

void CreateTSB_1dc6::callPassThroughs_53a1( const Packets_t& systems_5363, const Packets_t& systemFunctions_5365)
{
	Packets_t systems_5367;
	Packets_t systemFunctions_5368;
	PassThroughs_5362 passThroughs_5362;
	passThroughs_5362( systems_5363, systemFunctions_5365, systems_5367, systemFunctions_5368);
	if( ( !systems_5367.empty())&& ( !systemFunctions_5368.empty()))
		callDoTopologicalSort_53a4( systems_5367, systemFunctions_5368);
}

void CreateTSB_1dc6::callDoTopologicalSort_53a4( const Packets_t& subsystems_5342, const Packets_t& mains_5345)
{
	Packets_t subsystems_5344;
	Packets_t mains_5347;
	DoTopologicalSort_5341 doTopologicalSort_5341;
	doTopologicalSort_5341( subsystems_5342, mains_5345, subsystems_5344, mains_5347);
	if( ( !subsystems_5344.empty())&& ( !mains_5347.empty()))
		callCreatePreDelayExec_53a7( subsystems_5344, mains_5347);
}

void CreateTSB_1dc6::callCreatePreDelayExec_53a7( const Packets_t& systems_1dfb, const Packets_t& systemFunctions_1dfd)
{
	Packets_t systems_1dff;
	Packets_t systemFunctions_1e00;
	CreatePreDelayExec_1dfa createPreDelayExec_1dfa;
	createPreDelayExec_1dfa( systems_1dfb, systemFunctions_1dfd, systems_1dff, systemFunctions_1e00);
	if( ( !systems_1dff.empty())&& ( !systemFunctions_1e00.empty()))
		callGetSortedBlocks_53aa( systems_1dff, systemFunctions_1e00);
}

void CreateTSB_1dc6::callGetSortedBlocks_53aa( const Packets_t& subsystems_1dce, const Packets_t& mains_1dd2)
{
	Packets_t subsystems_1dd0;
	Packets_t childBlockss_1dd1;
	Packets_t mains_1dd4;
	GetSortedBlocks_1dcd getSortedBlocks_1dcd;
	getSortedBlocks_1dcd( subsystems_1dce, mains_1dd2, subsystems_1dd0, childBlockss_1dd1, mains_1dd4);
	if( ( !subsystems_1dd0.empty())&& ( !childBlockss_1dd1.empty())&& ( !mains_1dd4.empty()))
		callCreateBlockExecution_53ad( subsystems_1dd0, childBlockss_1dd1, mains_1dd4);
}

void CreateTSB_1dc6::callCreateBlockExecution_53ad( const Packets_t& systems_1e58, const Packets_t& childBlockss_1e5a, const Packets_t& systemFunctions_1e5c)
{
	Packets_t systems_1e5e;
	Packets_t systemFunctions_1e5f;
	CreateBlockExecution_1e57 createBlockExecution_1e57;
	createBlockExecution_1e57( systems_1e58, childBlockss_1e5a, systemFunctions_1e5c, systems_1e5e, systemFunctions_1e5f);
}

void GetSortedBlocks_1dcd::operator()( const Packets_t& subsystems_1dce, const Packets_t& mains_1dd2, Packets_t& subsystems_1dd0, Packets_t& childBlockss_1dd1, Packets_t& mains_1dd4)
{
#ifdef PRINT_INFO
	printLog("GetSortedBlocks_1dcd" );
#endif
	RTTGenerator::Instance()->generateRule(1603, "GetSortedBlocks");
	_subsystem_1dd5= &subsystems_1dd0;
	_childBlocks_1dd6= &childBlockss_1dd1;
	_main_1dd7= &mains_1dd4;
	processInputPackets( subsystems_1dce, mains_1dd2);
	sortOutputs( );
}

bool GetSortedBlocks_1dcd::isInputUnique( const Udm::Object& subsystem_1ddc, const Udm::Object& main_1de5)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1dde= _subsystem_1dd8.begin(), itMain_1de7= _main_1de1.begin(); itSubsystem_1dde!= _subsystem_1dd8.end(), itMain_1de7!= _main_1de1.end(); ++itSubsystem_1dde, ++itMain_1de7)
	{
		if( ( *itSubsystem_1dde== subsystem_1ddc)&& ( *itMain_1de7== main_1de5))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1dd8.push_back( subsystem_1ddc);
		_main_1de1.push_back( main_1de5);
	}
	return isUnique;
}

bool GetSortedBlocks_1dcd::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetSortedBlocks_1dcd::processInputPackets( const Packets_t& subsystems_1dce, const Packets_t& mains_1dd2)
{
	for( Packets_t::const_iterator itSubsystem_1dd9= subsystems_1dce.begin(), itMain_1de2= mains_1dd2.begin(); itSubsystem_1dd9!= subsystems_1dce.end(), itMain_1de2!= mains_1dd2.end(); ++itSubsystem_1dd9, ++itMain_1de2)
	{
		bool isUnique= isInputUnique( *itSubsystem_1dd9, *itMain_1de2);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1dd9, *itMain_1de2);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetSortedBlocks_1dcd::patternMatcher( const Udm::Object& subsystem_1dda, const Udm::Object& main_1de3)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1dda.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1ddf= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1dda);
		if( false== Uml::IsDerivedFrom( main_1de3.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1de8= SFC::Function::Cast( main_1de3);
		set< CyPhyML::SignalFlow::Block> childBlockss_1dea= subsystem_1ddf.Block_kind_children();
		for( set< CyPhyML::SignalFlow::Block>::const_iterator itChildBlocks_1deb= childBlockss_1dea.begin(); itChildBlocks_1deb!= childBlockss_1dea.end(); ++itChildBlocks_1deb)
		{
			CyPhyML::SignalFlow::Block currChildBlocks_1dec= *itChildBlocks_1deb;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1df0;
			if( !isValidBound(boundObjs_1df0, subsystem_1ddf, true))
				continue;
			currMatch.subsystem_1df1= subsystem_1ddf;
			if( !isValidBound(boundObjs_1df0, main_1de8, true))
				continue;
			currMatch.main_1df2= main_1de8;
			if( !isValidBound(boundObjs_1df0, currChildBlocks_1dec, false))
				continue;
			currMatch.childBlocks_1df3= currChildBlocks_1dec;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetSortedBlocks_1dcd::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.subsystem_1df1, currMatch.childBlocks_1df3, currMatch.main_1df2);
	}
}

void GetSortedBlocks_1dcd::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1df4, const CyPhyML::SignalFlow::Block& childBlocks_1df6, const SFC::Function& main_1df8)
{
	_subsystem_1dd5->push_back( subsystem_1df4);
	_childBlocks_1dd6->push_back( childBlocks_1df6);
	_main_1dd7->push_back( main_1df8);
}

void GetSortedBlocks_1dcd::sortOutputs()
{
	typedef std::multiset< CyPhyML::SignalFlow::Block, std::pointer_to_binary_function< const CyPhyML::SignalFlow::Block&, const CyPhyML::SignalFlow::Block&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const CyPhyML::SignalFlow::Block&, const CyPhyML::SignalFlow::Block&, bool> ptr_TopologicalSort( TopologicalSort< CyPhyML::SignalFlow::Block>);
	SortedSet_t sortedSet( ptr_TopologicalSort);
	std::vector< int> permutationVector( _childBlocks_1dd6->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _childBlocks_1dd6->begin(); it!= _childBlocks_1dd6->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( CyPhyML::SignalFlow::Block::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _childBlocks_1dd6->begin());
	// order rest of the containers
	permutate( permutationVector, *_subsystem_1dd5);
	permutate( permutationVector, *_main_1dd7);
}

void CreatePreDelayExec_1dfa::operator()( const Packets_t& systems_1dfb, const Packets_t& systemFunctions_1dfd, Packets_t& systems_1dff, Packets_t& systemFunctions_1e00)
{
#ifdef PRINT_INFO
	printLog("CreatePreDelayExec_1dfa" );
#endif
	_system_1e01= &systems_1dff;
	_systemFunction_1e02= &systemFunctions_1e00;
	if( ( !systems_1dfb.empty())&& ( !systemFunctions_1dfd.empty()))
		callGetDelayBlocks_5337( systems_1dfb, systemFunctions_1dfd);
	_system_1e01->insert( _system_1e01->end(), systems_1dfb.begin(), systems_1dfb.end());
	_systemFunction_1e02->insert( _systemFunction_1e02->end(), systemFunctions_1dfd.begin(), systemFunctions_1dfd.end());
}

void CreatePreDelayExec_1dfa::callGetDelayBlocks_5337( const Packets_t& subsystems_1e28, const Packets_t& mains_1e2c)
{
	Packets_t subsystems_1e2a;
	Packets_t childBlockss_1e2b;
	Packets_t mains_1e2e;
	GetDelayBlocks_1e27 getDelayBlocks_1e27;
	getDelayBlocks_1e27( subsystems_1e28, mains_1e2c, subsystems_1e2a, childBlockss_1e2b, mains_1e2e);
	if( ( !subsystems_1e2a.empty())&& ( !childBlockss_1e2b.empty())&& ( !mains_1e2e.empty()))
		callCreateBlockExecution_533a( subsystems_1e2a, childBlockss_1e2b, mains_1e2e);
}

void CreatePreDelayExec_1dfa::callCreateBlockExecution_533a( const Packets_t& systems_1e58, const Packets_t& childBlockss_1e5a, const Packets_t& systemFunctions_1e5c)
{
	Packets_t systems_1e5e;
	Packets_t systemFunctions_1e5f;
	CreateBlockExecution_1e57 createBlockExecution_1e57;
	createBlockExecution_1e57( systems_1e58, childBlockss_1e5a, systemFunctions_1e5c, systems_1e5e, systemFunctions_1e5f);
	if( ( !systems_1e5e.empty())&& ( !systemFunctions_1e5f.empty()))
		callResetDelayBlockType_533e( systems_1e5e, systemFunctions_1e5f);
}

void CreatePreDelayExec_1dfa::callResetDelayBlockType_533e( const Packets_t& subsystems_1e04, const Packets_t& mains_1e06)
{
	ResetDelayBlockType_1e03 resetDelayBlockType_1e03;
	resetDelayBlockType_1e03( subsystems_1e04, mains_1e06);
}

void ResetDelayBlockType_1e03::operator()( const Packets_t& subsystems_1e04, const Packets_t& mains_1e06)
{
#ifdef PRINT_INFO
	printLog("ResetDelayBlockType_1e03" );
#endif
	RTTGenerator::Instance()->generateRule(1613, "ResetDelayBlockType");
	processInputPackets( subsystems_1e04, mains_1e06);
}

bool ResetDelayBlockType_1e03::isInputUnique( const Udm::Object& subsystem_1e0c, const Udm::Object& main_1e15)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1e0e= _subsystem_1e08.begin(), itMain_1e17= _main_1e11.begin(); itSubsystem_1e0e!= _subsystem_1e08.end(), itMain_1e17!= _main_1e11.end(); ++itSubsystem_1e0e, ++itMain_1e17)
	{
		if( ( *itSubsystem_1e0e== subsystem_1e0c)&& ( *itMain_1e17== main_1e15))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1e08.push_back( subsystem_1e0c);
		_main_1e11.push_back( main_1e15);
	}
	return isUnique;
}

bool ResetDelayBlockType_1e03::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool ResetDelayBlockType_1e03::isGuardTrue( CyPhyML::SignalFlow::Primitive& ChildBlocks, SFC::Function& Main, CyPhyML::SignalFlow::Subsystem& Subsystem)
{
	bool Gz_guard= false;
	Gz_guard = false;
std::string bt = ChildBlocks.BlockType();
if (bt.compare("UnitDelayPre") == 0)
   Gz_guard = true;;
	return Gz_guard;
}

void ResetDelayBlockType_1e03::processInputPackets( const Packets_t& subsystems_1e04, const Packets_t& mains_1e06)
{
	for( Packets_t::const_iterator itSubsystem_1e09= subsystems_1e04.begin(), itMain_1e12= mains_1e06.begin(); itSubsystem_1e09!= subsystems_1e04.end(), itMain_1e12!= mains_1e06.end(); ++itSubsystem_1e09, ++itMain_1e12)
	{
		bool isUnique= isInputUnique( *itSubsystem_1e09, *itMain_1e12);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1e09, *itMain_1e12);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool ResetDelayBlockType_1e03::patternMatcher( const Udm::Object& subsystem_1e0a, const Udm::Object& main_1e13)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1e0a.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1e0f= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1e0a);
		if( false== Uml::IsDerivedFrom( main_1e13.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1e18= SFC::Function::Cast( main_1e13);
		set< CyPhyML::SignalFlow::Primitive> childBlockss_1e1a= subsystem_1e0f.Primitive_kind_children();
		for( set< CyPhyML::SignalFlow::Primitive>::const_iterator itChildBlocks_1e1b= childBlockss_1e1a.begin(); itChildBlocks_1e1b!= childBlockss_1e1a.end(); ++itChildBlocks_1e1b)
		{
			CyPhyML::SignalFlow::Primitive currChildBlocks_1e1c= *itChildBlocks_1e1b;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1e20;
			if( !isValidBound(boundObjs_1e20, subsystem_1e0f, true))
				continue;
			currMatch.subsystem_1e21= subsystem_1e0f;
			if( !isValidBound(boundObjs_1e20, main_1e18, true))
				continue;
			currMatch.main_1e22= main_1e18;
			if( !isValidBound(boundObjs_1e20, currChildBlocks_1e1c, false))
				continue;
			currMatch.childBlocks_1e23= currChildBlocks_1e1c;
			bool Gz_guard= isGuardTrue( currMatch.childBlocks_1e23, currMatch.main_1e22, currMatch.subsystem_1e21);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void ResetDelayBlockType_1e03::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		CyPhyML::SignalFlow::Primitive& ChildBlocks= currMatch.childBlocks_1e23;
		SFC::Function& Main= currMatch.main_1e22;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_1e21;
		{
std::string bt = ChildBlocks.BlockType();
/* erase "Pre" */
bt.erase( bt.find("Pre"), std::string::npos );
printLog(bt );
ChildBlocks.BlockType() = bt;

};
	}
}

void GetDelayBlocks_1e27::operator()( const Packets_t& subsystems_1e28, const Packets_t& mains_1e2c, Packets_t& subsystems_1e2a, Packets_t& childBlockss_1e2b, Packets_t& mains_1e2e)
{
#ifdef PRINT_INFO
	printLog("GetDelayBlocks_1e27" );
#endif
	RTTGenerator::Instance()->generateRule(1619, "GetDelayBlocks");
	_subsystem_1e2f= &subsystems_1e2a;
	_childBlocks_1e30= &childBlockss_1e2b;
	_main_1e31= &mains_1e2e;
	processInputPackets( subsystems_1e28, mains_1e2c);
}

bool GetDelayBlocks_1e27::isInputUnique( const Udm::Object& subsystem_1e36, const Udm::Object& main_1e3f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1e38= _subsystem_1e32.begin(), itMain_1e41= _main_1e3b.begin(); itSubsystem_1e38!= _subsystem_1e32.end(), itMain_1e41!= _main_1e3b.end(); ++itSubsystem_1e38, ++itMain_1e41)
	{
		if( ( *itSubsystem_1e38== subsystem_1e36)&& ( *itMain_1e41== main_1e3f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1e32.push_back( subsystem_1e36);
		_main_1e3b.push_back( main_1e3f);
	}
	return isUnique;
}

bool GetDelayBlocks_1e27::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool GetDelayBlocks_1e27::isGuardTrue( CyPhyML::SignalFlow::Primitive& ChildBlocks, SFC::Function& Main, CyPhyML::SignalFlow::Subsystem& Subsystem)
{
	bool Gz_guard= false;
	Gz_guard = false;
std::string bt = ChildBlocks.BlockType();
if (bt.compare("UnitDelay") == 0)
   Gz_guard = true;;
	return Gz_guard;
}

void GetDelayBlocks_1e27::processInputPackets( const Packets_t& subsystems_1e28, const Packets_t& mains_1e2c)
{
	for( Packets_t::const_iterator itSubsystem_1e33= subsystems_1e28.begin(), itMain_1e3c= mains_1e2c.begin(); itSubsystem_1e33!= subsystems_1e28.end(), itMain_1e3c!= mains_1e2c.end(); ++itSubsystem_1e33, ++itMain_1e3c)
	{
		bool isUnique= isInputUnique( *itSubsystem_1e33, *itMain_1e3c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1e33, *itMain_1e3c);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetDelayBlocks_1e27::patternMatcher( const Udm::Object& subsystem_1e34, const Udm::Object& main_1e3d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1e34.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1e39= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1e34);
		if( false== Uml::IsDerivedFrom( main_1e3d.type(), SFC::Function::meta))
			continue;
		SFC::Function main_1e42= SFC::Function::Cast( main_1e3d);
		set< CyPhyML::SignalFlow::Primitive> childBlockss_1e44= subsystem_1e39.Primitive_kind_children();
		for( set< CyPhyML::SignalFlow::Primitive>::const_iterator itChildBlocks_1e45= childBlockss_1e44.begin(); itChildBlocks_1e45!= childBlockss_1e44.end(); ++itChildBlocks_1e45)
		{
			CyPhyML::SignalFlow::Primitive currChildBlocks_1e46= *itChildBlocks_1e45;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1e4a;
			if( !isValidBound(boundObjs_1e4a, subsystem_1e39, true))
				continue;
			currMatch.subsystem_1e4b= subsystem_1e39;
			if( !isValidBound(boundObjs_1e4a, main_1e42, true))
				continue;
			currMatch.main_1e4c= main_1e42;
			if( !isValidBound(boundObjs_1e4a, currChildBlocks_1e46, false))
				continue;
			currMatch.childBlocks_1e4d= currChildBlocks_1e46;
			bool Gz_guard= isGuardTrue( currMatch.childBlocks_1e4d, currMatch.main_1e4c, currMatch.subsystem_1e4b);
			if( true== Gz_guard)
				_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetDelayBlocks_1e27::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		CyPhyML::SignalFlow::Primitive& ChildBlocks= currMatch.childBlocks_1e4d;
		SFC::Function& Main= currMatch.main_1e4c;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_1e4b;
		{
std::string bt = ChildBlocks.BlockType();
ChildBlocks.BlockType() = bt + "Pre";
};
		outputAppender( currMatch.subsystem_1e4b, currMatch.childBlocks_1e4d, currMatch.main_1e4c);
	}
}

void GetDelayBlocks_1e27::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1e51, const CyPhyML::SignalFlow::Primitive& childBlocks_1e53, const SFC::Function& main_1e55)
{
	_subsystem_1e2f->push_back( subsystem_1e51);
	_childBlocks_1e30->push_back( childBlocks_1e53);
	_main_1e31->push_back( main_1e55);
}

void CreateBlockExecution_1e57::operator()( const Packets_t& systems_1e58, const Packets_t& childBlockss_1e5a, const Packets_t& systemFunctions_1e5c, Packets_t& systems_1e5e, Packets_t& systemFunctions_1e5f)
{
#ifdef PRINT_INFO
	printLog("CreateBlockExecution_1e57" );
#endif
	_system_1e60= &systems_1e5e;
	_systemFunction_1e61= &systemFunctions_1e5f;
	for( Packets_t::const_iterator itsystem_1e63= systems_1e58.begin(), itchildBlocks_1e6a= childBlockss_1e5a.begin(), itsystemFunction_1e71= systemFunctions_1e5c.begin(); itsystem_1e63!= systems_1e58.end(), itchildBlocks_1e6a!= childBlockss_1e5a.end(), itsystemFunction_1e71!= systemFunctions_1e5c.end(); ++itsystem_1e63, ++itchildBlocks_1e6a, ++itsystemFunction_1e71)
	{
		bool isUnique= isInputUnique( *itsystem_1e63, *itchildBlocks_1e6a, *itsystemFunction_1e71);
		if( !isUnique)
			continue;
		Packets_t onesystem_1e67( 1, *itsystem_1e63);
		Packets_t onechildBlocks_1e6e( 1, *itchildBlocks_1e6a);
		Packets_t onesystemFunction_1e75( 1, *itsystemFunction_1e71);
		executeOne( onesystem_1e67, onechildBlocks_1e6e, onesystemFunction_1e75);
	}
}

void CreateBlockExecution_1e57::executeOne( const Packets_t& systems_1e58, const Packets_t& childBlockss_1e5a, const Packets_t& systemFunctions_1e5c)
{
	_system_1e60->insert( _system_1e60->end(), systems_1e58.begin(), systems_1e58.end());
	_systemFunction_1e61->insert( _systemFunction_1e61->end(), systemFunctions_1e5c.begin(), systemFunctions_1e5c.end());
	if( ( !systems_1e58.empty())&& ( !childBlockss_1e5a.empty())&& ( !systemFunctions_1e5c.empty()))
		callTestChildBlock_5324( systems_1e58, childBlockss_1e5a, systemFunctions_1e5c);
}

bool CreateBlockExecution_1e57::isInputUnique( const Udm::Object& system_1e64, const Udm::Object& childBlocks_1e6b, const Udm::Object& systemFunction_1e72)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itsystem_1e66= _system_1e62.begin(), itchildBlocks_1e6d= _childBlocks_1e69.begin(), itsystemFunction_1e74= _systemFunction_1e70.begin(); itsystem_1e66!= _system_1e62.end(), itchildBlocks_1e6d!= _childBlocks_1e69.end(), itsystemFunction_1e74!= _systemFunction_1e70.end(); ++itsystem_1e66, ++itchildBlocks_1e6d, ++itsystemFunction_1e74)
	{
		if( ( *itsystem_1e66== system_1e64)&& ( *itchildBlocks_1e6d== childBlocks_1e6b)&& ( *itsystemFunction_1e74== systemFunction_1e72))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_system_1e62.push_back( system_1e64);
		_childBlocks_1e69.push_back( childBlocks_1e6b);
		_systemFunction_1e70.push_back( systemFunction_1e72);
	}
	return isUnique;
}

void CreateBlockExecution_1e57::callTestChildBlock_5324( const Packets_t& systems_3e8d, const Packets_t& childBlocks_3e8f, const Packets_t& systemFunctions_3e91)
{
	Packets_t systems_3e93;
	Packets_t childCharts_3e94;
	Packets_t systemFunctions_3e95;
	Packets_t systems_3e96;
	Packets_t childCharts_3e97;
	Packets_t systemFunctions_3e98;
	Packets_t systems_3e99;
	Packets_t childSubsystems_3e9a;
	Packets_t systemFunctions_3e9b;
	Packets_t systems_3e9c;
	Packets_t childBlocks_3e9d;
	Packets_t systemFunctions_3e9e;
	TestChildBlock_3e8c testChildBlock_3e8c;
	testChildBlock_3e8c( systems_3e8d, childBlocks_3e8f, systemFunctions_3e91, systems_3e93, childCharts_3e94, systemFunctions_3e95, systems_3e96, childCharts_3e97, systemFunctions_3e98, systems_3e99, childSubsystems_3e9a, systemFunctions_3e9b, systems_3e9c, childBlocks_3e9d, systemFunctions_3e9e);
	if( ( !childBlocks_3e9d.empty())&& ( !systemFunctions_3e9e.empty()))
		callPrimitiveChildBlock_5328( childBlocks_3e9d, systemFunctions_3e9e);
	if( ( !systems_3e99.empty())&& ( !childSubsystems_3e9a.empty())&& ( !systemFunctions_3e9b.empty()))
		callSubsystemChildBlock_532b( systems_3e99, childSubsystems_3e9a, systemFunctions_3e9b);
	if( ( !systems_3e96.empty())&& ( !childCharts_3e97.empty())&& ( !systemFunctions_3e98.empty()))
		callSFChartChildBlock_532f( systems_3e96, childCharts_3e97, systemFunctions_3e98);
	if( ( !systems_3e93.empty())&& ( !childCharts_3e94.empty())&& ( !systemFunctions_3e95.empty()))
		callChartChildBlock_5333( systems_3e93, childCharts_3e94, systemFunctions_3e95);
}

void CreateBlockExecution_1e57::callPrimitiveChildBlock_5328( const Packets_t& childPrimitives_50cb, const Packets_t& systemFunctions_50cd)
{
	PrimitiveChildBlock_50ca primitiveChildBlock_50ca;
	primitiveChildBlock_50ca( childPrimitives_50cb, systemFunctions_50cd);
}

void CreateBlockExecution_1e57::callSubsystemChildBlock_532b( const Packets_t& systems_1e78, const Packets_t& childSubsystems_1e7a, const Packets_t& systemFunctions_1e7c)
{
	SubsystemChildBlock_1e77 subsystemChildBlock_1e77;
	subsystemChildBlock_1e77( systems_1e78, childSubsystems_1e7a, systemFunctions_1e7c);
}

void CreateBlockExecution_1e57::callSFChartChildBlock_532f( const Packets_t& systems_2d67, const Packets_t& childCharts_2d69, const Packets_t& systemFunctions_2d6b)
{
	SFChartChildBlock_2d66 sFChartChildBlock_2d66;
	sFChartChildBlock_2d66( systems_2d67, childCharts_2d69, systemFunctions_2d6b);
}

void CreateBlockExecution_1e57::callChartChildBlock_5333( const Packets_t& systems_3fa1, const Packets_t& childCharts_3fa3, const Packets_t& systemFunctions_3fa5)
{
	ChartChildBlock_3fa0 chartChildBlock_3fa0;
	chartChildBlock_3fa0( systems_3fa1, childCharts_3fa3, systemFunctions_3fa5);
}

void SubsystemChildBlock_1e77::operator()( const Packets_t& systems_1e78, const Packets_t& childSubsystems_1e7a, const Packets_t& systemFunctions_1e7c)
{
#ifdef PRINT_INFO
	printLog("SubsystemChildBlock_1e77" );
#endif
	if( ( !systems_1e78.empty())&& ( !childSubsystems_1e7a.empty())&& ( !systemFunctions_1e7c.empty()))
		callMakeTrigger_2d56( systems_1e78, childSubsystems_1e7a, systemFunctions_1e7c);
}

void SubsystemChildBlock_1e77::callMakeTrigger_2d56( const Packets_t& systems_1e7f, const Packets_t& childSubsystems_1e81, const Packets_t& systemFunctions_1e83)
{
	Packets_t systems_1e85;
	Packets_t childSubsystems_1e86;
	Packets_t compoundStatements_1e87;
	MakeTrigger_1e7e makeTrigger_1e7e;
	makeTrigger_1e7e( systems_1e7f, childSubsystems_1e81, systemFunctions_1e83, systems_1e85, childSubsystems_1e86, compoundStatements_1e87);
	if( ( !systems_1e85.empty())&& ( !childSubsystems_1e86.empty())&& ( !compoundStatements_1e87.empty()))
		callCreateMethodCall_2d5a( systems_1e85, childSubsystems_1e86, compoundStatements_1e87);
}

void SubsystemChildBlock_1e77::callCreateMethodCall_2d5a( const Packets_t& subsystems_2c13, const Packets_t& blocks_2c17, const Packets_t& mains_2c1a)
{
	Packets_t subsystems_2c15;
	Packets_t functions_2c16;
	Packets_t methodCalls_2c19;
	CreateMethodCall_2c12 createMethodCall_2c12;
	createMethodCall_2c12( subsystems_2c13, blocks_2c17, mains_2c1a, subsystems_2c15, functions_2c16, methodCalls_2c19);
	if( ( !subsystems_2c15.empty())&& ( !functions_2c16.empty())&& ( !methodCalls_2c19.empty()))
		callCreateFunctionCallArgs_2d5e( subsystems_2c15, functions_2c16, methodCalls_2c19);
}

void SubsystemChildBlock_1e77::callCreateFunctionCallArgs_2d5e( const Packets_t& subsystems_2bd5, const Packets_t& functions_2bd8, const Packets_t& methodCalls_2bdb)
{
	Packets_t subsystems_2bd7;
	Packets_t ports_2bda;
	Packets_t argVals_2bdd;
	CreateFunctionCallArgs_2bd4 createFunctionCallArgs_2bd4;
	createFunctionCallArgs_2bd4( subsystems_2bd5, functions_2bd8, methodCalls_2bdb, subsystems_2bd7, ports_2bda, argVals_2bdd);
	if( ( !subsystems_2bd7.empty())&& ( !ports_2bda.empty())&& ( !argVals_2bdd.empty()))
		callMakeArgDeclRef_2d62( subsystems_2bd7, ports_2bda, argVals_2bdd);
}

void SubsystemChildBlock_1e77::callMakeArgDeclRef_2d62( const Packets_t& systems_2c5a, const Packets_t& argPorts_2c5c, const Packets_t& argVals_2c5e)
{
	MakeArgDeclRef_2c59 makeArgDeclRef_2c59;
	makeArgDeclRef_2c59( systems_2c5a, argPorts_2c5c, argVals_2c5e);
}

void MakeTrigger_1e7e::operator()( const Packets_t& systems_1e7f, const Packets_t& childSubsystems_1e81, const Packets_t& systemFunctions_1e83, Packets_t& systems_1e85, Packets_t& childSubsystems_1e86, Packets_t& compoundStatements_1e87)
{
#ifdef PRINT_INFO
	printLog("MakeTrigger_1e7e" );
#endif
	_system_1e88= &systems_1e85;
	_childSubsystem_1e89= &childSubsystems_1e86;
	_compoundStatement_1e8a= &compoundStatements_1e87;
	if( ( !systems_1e7f.empty())&& ( !childSubsystems_1e81.empty())&& ( !systemFunctions_1e83.empty()))
		callIsTriggered_2bc8( systems_1e7f, childSubsystems_1e81, systemFunctions_1e83);
}

void MakeTrigger_1e7e::callIsTriggered_2bc8( const Packets_t& systems_2af4, const Packets_t& childSubsystems_2af6, const Packets_t& systemFunctions_2af8)
{
	Packets_t systems_2afa;
	Packets_t childSubsystems_2afb;
	Packets_t systemFunctions_2afc;
	Packets_t systems_2afd;
	Packets_t childSubsystems_2afe;
	Packets_t systemFunctions_2aff;
	Packets_t systems_2b00;
	Packets_t childSubsystems_2b01;
	Packets_t systemFunctions_2b02;
	IsTriggered_2af3 isTriggered_2af3;
	isTriggered_2af3( systems_2af4, childSubsystems_2af6, systemFunctions_2af8, systems_2afa, childSubsystems_2afb, systemFunctions_2afc, systems_2afd, childSubsystems_2afe, systemFunctions_2aff, systems_2b00, childSubsystems_2b01, systemFunctions_2b02);
	if( ( !systems_2afd.empty())&& ( !childSubsystems_2afe.empty())&& ( !systemFunctions_2aff.empty()))
		callCreateAction_2bcc( systems_2afd, childSubsystems_2afe, systemFunctions_2aff);
	_system_1e88->insert( _system_1e88->end(), systems_2b00.begin(), systems_2b00.end());
	_childSubsystem_1e89->insert( _childSubsystem_1e89->end(), childSubsystems_2b01.begin(), childSubsystems_2b01.end());
	_compoundStatement_1e8a->insert( _compoundStatement_1e8a->end(), systemFunctions_2b02.begin(), systemFunctions_2b02.end());
	if( ( !systems_2afa.empty())&& ( !childSubsystems_2afb.empty())&& ( !systemFunctions_2afc.empty()))
		callCreateTriggering_2bd0( systems_2afa, childSubsystems_2afb, systemFunctions_2afc);
}

void MakeTrigger_1e7e::callCreateAction_2bcc( const Packets_t& subsystems_1e8c, const Packets_t& blocks_1e8f, const Packets_t& functions_1e92)
{
	Packets_t subsystems_1e8e;
	Packets_t blocks_1e91;
	Packets_t conditionalBlocks_1e94;
	CreateAction_1e8b createAction_1e8b;
	createAction_1e8b( subsystems_1e8c, blocks_1e8f, functions_1e92, subsystems_1e8e, blocks_1e91, conditionalBlocks_1e94);
	_system_1e88->insert( _system_1e88->end(), subsystems_1e8e.begin(), subsystems_1e8e.end());
	_childSubsystem_1e89->insert( _childSubsystem_1e89->end(), blocks_1e91.begin(), blocks_1e91.end());
	_compoundStatement_1e8a->insert( _compoundStatement_1e8a->end(), conditionalBlocks_1e94.begin(), conditionalBlocks_1e94.end());
}

void MakeTrigger_1e7e::callCreateTriggering_2bd0( const Packets_t& systems_1ecc, const Packets_t& childSubsystems_1ece, const Packets_t& systemFunctions_1ed0)
{
	Packets_t systems_1ed2;
	Packets_t childSubsystems_1ed3;
	Packets_t conditionalBlocks_1ed4;
	CreateTriggering_1ecb createTriggering_1ecb;
	createTriggering_1ecb( systems_1ecc, childSubsystems_1ece, systemFunctions_1ed0, systems_1ed2, childSubsystems_1ed3, conditionalBlocks_1ed4);
	_system_1e88->insert( _system_1e88->end(), systems_1ed2.begin(), systems_1ed2.end());
	_childSubsystem_1e89->insert( _childSubsystem_1e89->end(), childSubsystems_1ed3.begin(), childSubsystems_1ed3.end());
	_compoundStatement_1e8a->insert( _compoundStatement_1e8a->end(), conditionalBlocks_1ed4.begin(), conditionalBlocks_1ed4.end());
}

void CreateAction_1e8b::operator()( const Packets_t& subsystems_1e8c, const Packets_t& blocks_1e8f, const Packets_t& functions_1e92, Packets_t& subsystems_1e8e, Packets_t& blocks_1e91, Packets_t& conditionalBlocks_1e94)
{
#ifdef PRINT_INFO
	printLog("CreateAction_1e8b" );
#endif
	RTTGenerator::Instance()->generateRule(2017, "CreateAction");
	_subsystem_1e95= &subsystems_1e8e;
	_block_1e96= &blocks_1e91;
	_conditionalBlock_1e97= &conditionalBlocks_1e94;
	processInputPackets( subsystems_1e8c, blocks_1e8f, functions_1e92);
}

bool CreateAction_1e8b::isInputUnique( const Udm::Object& subsystem_1e9c, const Udm::Object& block_1ea5, const Udm::Object& function_1eae)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1e9e= _subsystem_1e98.begin(), itBlock_1ea7= _block_1ea1.begin(), itFunction_1eb0= _function_1eaa.begin(); itSubsystem_1e9e!= _subsystem_1e98.end(), itBlock_1ea7!= _block_1ea1.end(), itFunction_1eb0!= _function_1eaa.end(); ++itSubsystem_1e9e, ++itBlock_1ea7, ++itFunction_1eb0)
	{
		if( ( *itSubsystem_1e9e== subsystem_1e9c)&& ( *itBlock_1ea7== block_1ea5)&& ( *itFunction_1eb0== function_1eae))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1e98.push_back( subsystem_1e9c);
		_block_1ea1.push_back( block_1ea5);
		_function_1eaa.push_back( function_1eae);
	}
	return isUnique;
}

bool CreateAction_1e8b::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateAction_1e8b::processInputPackets( const Packets_t& subsystems_1e8c, const Packets_t& blocks_1e8f, const Packets_t& functions_1e92)
{
	for( Packets_t::const_iterator itSubsystem_1e99= subsystems_1e8c.begin(), itBlock_1ea2= blocks_1e8f.begin(), itFunction_1eab= functions_1e92.begin(); itSubsystem_1e99!= subsystems_1e8c.end(), itBlock_1ea2!= blocks_1e8f.end(), itFunction_1eab!= functions_1e92.end(); ++itSubsystem_1e99, ++itBlock_1ea2, ++itFunction_1eab)
	{
		bool isUnique= isInputUnique( *itSubsystem_1e99, *itBlock_1ea2, *itFunction_1eab);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1e99, *itBlock_1ea2, *itFunction_1eab);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateAction_1e8b::patternMatcher( const Udm::Object& subsystem_1e9a, const Udm::Object& block_1ea3, const Udm::Object& function_1eac)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1e9a.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1e9f= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1e9a);
		if( false== Uml::IsDerivedFrom( block_1ea3.type(), CyPhyML::SignalFlow::Block::meta))
			continue;
		CyPhyML::SignalFlow::Block block_1ea8= CyPhyML::SignalFlow::Block::Cast( block_1ea3);
		if( false== Uml::IsDerivedFrom( function_1eac.type(), SFC::Function::meta))
			continue;
		SFC::Function function_1eb1= SFC::Function::Cast( function_1eac);
		set< CyPhyML::SignalFlow::EnablePort> actionPorts_1eb3= block_1ea8.EnablePort_kind_children();
		for( set< CyPhyML::SignalFlow::EnablePort>::const_iterator itActionPort_1eb4= actionPorts_1eb3.begin(); itActionPort_1eb4!= actionPorts_1eb3.end(); ++itActionPort_1eb4)
		{
			CyPhyML::SignalFlow::EnablePort currActionPort_1eb5= *itActionPort_1eb4;
			SFC::ArgDeclBase argDeclBase_1eb6= currActionPort_1eb5.argdecl();
			if( !argDeclBase_1eb6)
				continue;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1eba;
			if( !isValidBound(boundObjs_1eba, subsystem_1e9f, true))
				continue;
			currMatch.subsystem_1ebb= subsystem_1e9f;
			if( !isValidBound(boundObjs_1eba, block_1ea8, true))
				continue;
			currMatch.block_1ebc= block_1ea8;
			if( !isValidBound(boundObjs_1eba, function_1eb1, true))
				continue;
			currMatch.function_1ebd= function_1eb1;
			if( !isValidBound(boundObjs_1eba, currActionPort_1eb5, false))
				continue;
			currMatch.actionPort_1ebe= currActionPort_1eb5;
			if( !isValidBound(boundObjs_1eba, argDeclBase_1eb6, false))
				continue;
			currMatch.argDeclBase_1ebf= argDeclBase_1eb6;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void CreateAction_1e8b::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_1ec0= SFC::ConditionalBlock::Create( currMatch.function_1ebd);
		SFC::UserCode newUserCode_1ec1= SFC::UserCode::Create( newConditionalBlock_1ec0, SFC::ConditionalBlock::meta_cond);
		SFC::BinaryExprs newBinaryExprs_1ec2= SFC::BinaryExprs::Create( newUserCode_1ec1, SFC::UserCode::meta_codeexpr);
		SFC::Int newZero_1ec3= SFC::Int::Create( newBinaryExprs_1ec2, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef_1ec4= SFC::ArgDeclRef::Create( newBinaryExprs_1ec2, SFC::BinaryExprs::meta_leftexpr);
		CyPhyML::SignalFlow::EnablePort& ActionPort= currMatch.actionPort_1ebe;
		SFC::ArgDeclBase& ArgDeclBase= currMatch.argDeclBase_1ebf;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_1ec4;
		SFC::BinaryExprs& BinaryExprs= newBinaryExprs_1ec2;
		CyPhyML::SignalFlow::Block& Block= currMatch.block_1ebc;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_1ec0;
		SFC::Function& Function= currMatch.function_1ebd;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_1ebb;
		SFC::UserCode& UserCode= newUserCode_1ec1;
		SFC::Int& Zero= newZero_1ec3;
		{
__int64 statementCount = Function.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
Function.statementCount() = statementCount;
};
		{
BinaryExprs.op() = ">";
};
		{
Zero.val() = 0;
};
		newArgDeclRef_1ec4.argdecl()= currMatch.argDeclBase_1ebf;
		outputAppender( currMatch.subsystem_1ebb, currMatch.block_1ebc, newConditionalBlock_1ec0);
	}
}

void CreateAction_1e8b::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1ec5, const CyPhyML::SignalFlow::Block& block_1ec7, const SFC::ConditionalBlock& conditionalBlock_1ec9)
{
	_subsystem_1e95->push_back( subsystem_1ec5);
	_block_1e96->push_back( block_1ec7);
	_conditionalBlock_1e97->push_back( conditionalBlock_1ec9);
}

void CreateTriggering_1ecb::operator()( const Packets_t& systems_1ecc, const Packets_t& childSubsystems_1ece, const Packets_t& systemFunctions_1ed0, Packets_t& systems_1ed2, Packets_t& childSubsystems_1ed3, Packets_t& conditionalBlocks_1ed4)
{
#ifdef PRINT_INFO
	printLog("CreateTriggering_1ecb" );
#endif
	_system_1ed5= &systems_1ed2;
	_childSubsystem_1ed6= &childSubsystems_1ed3;
	_conditionalBlock_1ed7= &conditionalBlocks_1ed4;
	if( ( !systems_1ecc.empty())&& ( !childSubsystems_1ece.empty())&& ( !systemFunctions_1ed0.empty()))
		callGetTriggerPort_2ae5( systems_1ecc, childSubsystems_1ece, systemFunctions_1ed0);
}

void CreateTriggering_1ecb::callGetTriggerPort_2ae5( const Packets_t& subsystems_2a6c, const Packets_t& blocks_2a6f, const Packets_t& mains_2a72)
{
	Packets_t subsystems_2a6e;
	Packets_t triggerPorts_2a71;
	Packets_t mains_2a74;
	GetTriggerPort_2a6b getTriggerPort_2a6b;
	getTriggerPort_2a6b( subsystems_2a6c, blocks_2a6f, mains_2a72, subsystems_2a6e, triggerPorts_2a71, mains_2a74);
	if( ( !subsystems_2a6e.empty())&& ( !triggerPorts_2a71.empty())&& ( !mains_2a74.empty()))
		callAssignCondVal_2ae9( subsystems_2a6e, triggerPorts_2a71, mains_2a74);
}

void CreateTriggering_1ecb::callAssignCondVal_2ae9( const Packets_t& subsystems_2aa5, const Packets_t& triggerPorts_2aa8, const Packets_t& functions_2aad)
{
	Packets_t subsystems_2aa7;
	Packets_t triggerPorts_2aaa;
	Packets_t argDeclBases_2aab;
	Packets_t dTs_2aac;
	Packets_t functions_2aaf;
	AssignCondVal_2aa4 assignCondVal_2aa4;
	assignCondVal_2aa4( subsystems_2aa5, triggerPorts_2aa8, functions_2aad, subsystems_2aa7, triggerPorts_2aaa, argDeclBases_2aab, dTs_2aac, functions_2aaf);
	if( ( !subsystems_2aa7.empty())&& ( !triggerPorts_2aaa.empty())&& ( !argDeclBases_2aab.empty())&& ( !dTs_2aac.empty())&& ( !functions_2aaf.empty()))
		callMakeTrigger_2aed( subsystems_2aa7, triggerPorts_2aaa, argDeclBases_2aab, dTs_2aac, functions_2aaf);
}

void CreateTriggering_1ecb::callMakeTrigger_2aed( const Packets_t& systems_1ed9, const Packets_t& childSubsystemTriggers_1edb, const Packets_t& argdecls_1edd, const Packets_t& dts_1edf, const Packets_t& functions_1ee1)
{
	Packets_t systems_1ee3;
	Packets_t childSubsystems_1ee4;
	Packets_t conditionals_1ee5;
	MakeTrigger_1ed8 makeTrigger_1ed8;
	makeTrigger_1ed8( systems_1ed9, childSubsystemTriggers_1edb, argdecls_1edd, dts_1edf, functions_1ee1, systems_1ee3, childSubsystems_1ee4, conditionals_1ee5);
	_system_1ed5->insert( _system_1ed5->end(), systems_1ee3.begin(), systems_1ee3.end());
	_childSubsystem_1ed6->insert( _childSubsystem_1ed6->end(), childSubsystems_1ee4.begin(), childSubsystems_1ee4.end());
	_conditionalBlock_1ed7->insert( _conditionalBlock_1ed7->end(), conditionals_1ee5.begin(), conditionals_1ee5.end());
}

void MakeTrigger_1ed8::operator()( const Packets_t& systems_1ed9, const Packets_t& childSubsystemTriggers_1edb, const Packets_t& argdecls_1edd, const Packets_t& dts_1edf, const Packets_t& functions_1ee1, Packets_t& systems_1ee3, Packets_t& childSubsystems_1ee4, Packets_t& conditionals_1ee5)
{
#ifdef PRINT_INFO
	printLog("MakeTrigger_1ed8" );
#endif
	_system_1ee6= &systems_1ee3;
	_childSubsystem_1ee7= &childSubsystems_1ee4;
	_conditional_1ee8= &conditionals_1ee5;
	if( ( !systems_1ed9.empty())&& ( !childSubsystemTriggers_1edb.empty())&& ( !argdecls_1edd.empty())&& ( !dts_1edf.empty())&& ( !functions_1ee1.empty()))
		callAddStateVar_2a4f( systems_1ed9, childSubsystemTriggers_1edb, argdecls_1edd, dts_1edf, functions_1ee1);
}

void MakeTrigger_1ed8::callAddStateVar_2a4f( const Packets_t& subsystems_21ff, const Packets_t& triggerPorts_2202, const Packets_t& argDeclBases_2205, const Packets_t& dTs_2209, const Packets_t& functions_220d)
{
	Packets_t subsystems_2201;
	Packets_t triggerPorts_2204;
	Packets_t argDeclBases_2207;
	Packets_t localVars_2208;
	Packets_t dTs_220b;
	Packets_t args_220c;
	Packets_t functions_220f;
	AddStateVar_21fe addStateVar_21fe;
	addStateVar_21fe( subsystems_21ff, triggerPorts_2202, argDeclBases_2205, dTs_2209, functions_220d, subsystems_2201, triggerPorts_2204, argDeclBases_2207, localVars_2208, dTs_220b, args_220c, functions_220f);
	if( ( !subsystems_2201.empty())&& ( !triggerPorts_2204.empty())&& ( !argDeclBases_2207.empty())&& ( !dTs_220b.empty())&& ( !localVars_2208.empty())&& ( !args_220c.empty())&& ( !functions_220f.empty()))
		callAddTriggerVars_2a55( subsystems_2201, triggerPorts_2204, argDeclBases_2207, dTs_220b, localVars_2208, args_220c, functions_220f);
}

void MakeTrigger_1ed8::callAddTriggerVars_2a55( const Packets_t& systems_2356, const Packets_t& triggers_2358, const Packets_t& argdecls_235a, const Packets_t& dts_235c, const Packets_t& oldvals_235e, const Packets_t& contexts_2360, const Packets_t& functions_2362)
{
	Packets_t systems_2364;
	Packets_t triggers_2365;
	Packets_t argdecls_2366;
	Packets_t dts_2367;
	Packets_t oldvals_2368;
	Packets_t contexts_2369;
	Packets_t functions_236a;
	AddTriggerVars_2355 addTriggerVars_2355;
	addTriggerVars_2355( systems_2356, triggers_2358, argdecls_235a, dts_235c, oldvals_235e, contexts_2360, functions_2362, systems_2364, triggers_2365, argdecls_2366, dts_2367, oldvals_2368, contexts_2369, functions_236a);
	if( ( !systems_2364.empty())&& ( !triggers_2365.empty())&& ( !argdecls_2366.empty())&& ( !dts_2367.empty())&& ( !oldvals_2368.empty())&& ( !contexts_2369.empty())&& ( !functions_236a.empty()))
		callSaveState_2a5d( systems_2364, triggers_2365, argdecls_2366, dts_2367, oldvals_2368, contexts_2369, functions_236a);
}

void MakeTrigger_1ed8::callSaveState_2a5d( const Packets_t& systems_226a, const Packets_t& triggers_226c, const Packets_t& argdecls_226e, const Packets_t& dts_2270, const Packets_t& oldvals_2272, const Packets_t& contexts_2274, const Packets_t& functions_2276)
{
	Packets_t systems_2278;
	Packets_t triggers_2279;
	Packets_t dts_227a;
	Packets_t oldvals_227b;
	Packets_t functions_227c;
	SaveState_2269 saveState_2269;
	saveState_2269( systems_226a, triggers_226c, argdecls_226e, dts_2270, oldvals_2272, contexts_2274, functions_2276, systems_2278, triggers_2279, dts_227a, oldvals_227b, functions_227c);
	if( ( !systems_2278.empty())&& ( !triggers_2279.empty())&& ( !dts_227a.empty())&& ( !oldvals_227b.empty())&& ( !functions_227c.empty()))
		callMakeCondition_2a65( systems_2278, triggers_2279, dts_227a, oldvals_227b, functions_227c);
}

void MakeTrigger_1ed8::callMakeCondition_2a65( const Packets_t& systems_1eea, const Packets_t& triggers_1eec, const Packets_t& dts_1eee, const Packets_t& oldvals_1ef0, const Packets_t& functions_1ef2)
{
	Packets_t systems_1ef4;
	Packets_t childSubsystems_1ef5;
	Packets_t conditionals_1ef6;
	MakeCondition_1ee9 makeCondition_1ee9;
	makeCondition_1ee9( systems_1eea, triggers_1eec, dts_1eee, oldvals_1ef0, functions_1ef2, systems_1ef4, childSubsystems_1ef5, conditionals_1ef6);
	_system_1ee6->insert( _system_1ee6->end(), systems_1ef4.begin(), systems_1ef4.end());
	_childSubsystem_1ee7->insert( _childSubsystem_1ee7->end(), childSubsystems_1ef5.begin(), childSubsystems_1ef5.end());
	_conditional_1ee8->insert( _conditional_1ee8->end(), conditionals_1ef6.begin(), conditionals_1ef6.end());
}

void MakeCondition_1ee9::operator()( const Packets_t& systems_1eea, const Packets_t& triggers_1eec, const Packets_t& dts_1eee, const Packets_t& oldvals_1ef0, const Packets_t& functions_1ef2, Packets_t& systems_1ef4, Packets_t& childSubsystems_1ef5, Packets_t& conditionals_1ef6)
{
#ifdef PRINT_INFO
	printLog("MakeCondition_1ee9" );
#endif
	_system_1ef7= &systems_1ef4;
	_childSubsystem_1ef8= &childSubsystems_1ef5;
	_conditional_1ef9= &conditionals_1ef6;
	if( ( !systems_1eea.empty())&& ( !triggers_1eec.empty())&& ( !dts_1eee.empty())&& ( !oldvals_1ef0.empty())&& ( !functions_1ef2.empty()))
		callCreateConditional_21f0( systems_1eea, triggers_1eec, dts_1eee, oldvals_1ef0, functions_1ef2);
}

void MakeCondition_1ee9::callCreateConditional_21f0( const Packets_t& subsystems_1efb, const Packets_t& triggerPorts_1efe, const Packets_t& dTs_1f01, const Packets_t& localVars_1f04, const Packets_t& functions_1f08)
{
	Packets_t subsystems_1efd;
	Packets_t charts_1f00;
	Packets_t dTs_1f03;
	Packets_t triggerVars_1f06;
	Packets_t userCodes_1f07;
	Packets_t conditionalBlocks_1f0a;
	CreateConditional_1efa createConditional_1efa;
	createConditional_1efa( subsystems_1efb, triggerPorts_1efe, dTs_1f01, localVars_1f04, functions_1f08, subsystems_1efd, charts_1f00, dTs_1f03, triggerVars_1f06, userCodes_1f07, conditionalBlocks_1f0a);
	_system_1ef7->insert( _system_1ef7->end(), subsystems_1efd.begin(), subsystems_1efd.end());
	_childSubsystem_1ef8->insert( _childSubsystem_1ef8->end(), charts_1f00.begin(), charts_1f00.end());
	_conditional_1ef9->insert( _conditional_1ef9->end(), conditionalBlocks_1f0a.begin(), conditionalBlocks_1f0a.end());
	if( ( !dTs_1f03.empty())&& ( !triggerVars_1f06.empty())&& ( !userCodes_1f07.empty()))
		callSetMatrixCondition_21f6( dTs_1f03, triggerVars_1f06, userCodes_1f07);
}

void MakeCondition_1ee9::callSetMatrixCondition_21f6( const Packets_t& dts_1f5b, const Packets_t& triggervars_1f5d, const Packets_t& conditions_1f5f)
{
	Packets_t dts_1f61;
	Packets_t triggervars_1f62;
	Packets_t conditions_1f63;
	SetMatrixCondition_1f5a setMatrixCondition_1f5a;
	setMatrixCondition_1f5a( dts_1f5b, triggervars_1f5d, conditions_1f5f, dts_1f61, triggervars_1f62, conditions_1f63);
	if( ( !dts_1f61.empty())&& ( !triggervars_1f62.empty())&& ( !conditions_1f63.empty()))
		callSetStructCondition_21fa( dts_1f61, triggervars_1f62, conditions_1f63);
}

void MakeCondition_1ee9::callSetStructCondition_21fa( const Packets_t& dts_1f99, const Packets_t& oldvals_1f9b, const Packets_t& conditions_1f9d)
{
	SetStructCondition_1f98 setStructCondition_1f98;
	setStructCondition_1f98( dts_1f99, oldvals_1f9b, conditions_1f9d);
}

void CreateConditional_1efa::operator()( const Packets_t& subsystems_1efb, const Packets_t& triggerPorts_1efe, const Packets_t& dTs_1f01, const Packets_t& localVars_1f04, const Packets_t& functions_1f08, Packets_t& subsystems_1efd, Packets_t& charts_1f00, Packets_t& dTs_1f03, Packets_t& triggerVars_1f06, Packets_t& userCodes_1f07, Packets_t& conditionalBlocks_1f0a)
{
#ifdef PRINT_INFO
	printLog("CreateConditional_1efa" );
#endif
	RTTGenerator::Instance()->generateRule(2064, "CreateConditional");
	_subsystem_1f0b= &subsystems_1efd;
	_chart_1f0c= &charts_1f00;
	_dT_1f0d= &dTs_1f03;
	_triggerVar_1f0e= &triggerVars_1f06;
	_userCode_1f0f= &userCodes_1f07;
	_conditionalBlock_1f10= &conditionalBlocks_1f0a;
	processInputPackets( subsystems_1efb, triggerPorts_1efe, dTs_1f01, localVars_1f04, functions_1f08);
}

bool CreateConditional_1efa::isInputUnique( const Udm::Object& subsystem_1f15, const Udm::Object& triggerPort_1f1e, const Udm::Object& dT_1f27, const Udm::Object& localVar_1f30, const Udm::Object& function_1f39)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_1f17= _subsystem_1f11.begin(), itTriggerPort_1f20= _triggerPort_1f1a.begin(), itDT_1f29= _dT_1f23.begin(), itLocalVar_1f32= _localVar_1f2c.begin(), itFunction_1f3b= _function_1f35.begin(); itSubsystem_1f17!= _subsystem_1f11.end(), itTriggerPort_1f20!= _triggerPort_1f1a.end(), itDT_1f29!= _dT_1f23.end(), itLocalVar_1f32!= _localVar_1f2c.end(), itFunction_1f3b!= _function_1f35.end(); ++itSubsystem_1f17, ++itTriggerPort_1f20, ++itDT_1f29, ++itLocalVar_1f32, ++itFunction_1f3b)
	{
		if( ( *itSubsystem_1f17== subsystem_1f15)&& ( *itTriggerPort_1f20== triggerPort_1f1e)&& ( *itDT_1f29== dT_1f27)&& ( *itLocalVar_1f32== localVar_1f30)&& ( *itFunction_1f3b== function_1f39))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_1f11.push_back( subsystem_1f15);
		_triggerPort_1f1a.push_back( triggerPort_1f1e);
		_dT_1f23.push_back( dT_1f27);
		_localVar_1f2c.push_back( localVar_1f30);
		_function_1f35.push_back( function_1f39);
	}
	return isUnique;
}

bool CreateConditional_1efa::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void CreateConditional_1efa::processInputPackets( const Packets_t& subsystems_1efb, const Packets_t& triggerPorts_1efe, const Packets_t& dTs_1f01, const Packets_t& localVars_1f04, const Packets_t& functions_1f08)
{
	for( Packets_t::const_iterator itSubsystem_1f12= subsystems_1efb.begin(), itTriggerPort_1f1b= triggerPorts_1efe.begin(), itDT_1f24= dTs_1f01.begin(), itLocalVar_1f2d= localVars_1f04.begin(), itFunction_1f36= functions_1f08.begin(); itSubsystem_1f12!= subsystems_1efb.end(), itTriggerPort_1f1b!= triggerPorts_1efe.end(), itDT_1f24!= dTs_1f01.end(), itLocalVar_1f2d!= localVars_1f04.end(), itFunction_1f36!= functions_1f08.end(); ++itSubsystem_1f12, ++itTriggerPort_1f1b, ++itDT_1f24, ++itLocalVar_1f2d, ++itFunction_1f36)
	{
		bool isUnique= isInputUnique( *itSubsystem_1f12, *itTriggerPort_1f1b, *itDT_1f24, *itLocalVar_1f2d, *itFunction_1f36);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_1f12, *itTriggerPort_1f1b, *itDT_1f24, *itLocalVar_1f2d, *itFunction_1f36);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool CreateConditional_1efa::patternMatcher( const Udm::Object& subsystem_1f13, const Udm::Object& triggerPort_1f1c, const Udm::Object& dT_1f25, const Udm::Object& localVar_1f2e, const Udm::Object& function_1f37)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_1f13.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_1f18= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_1f13);
		if( false== Uml::IsDerivedFrom( triggerPort_1f1c.type(), CyPhyML::SignalFlow::TriggerPort::meta))
			continue;
		CyPhyML::SignalFlow::TriggerPort triggerPort_1f21= CyPhyML::SignalFlow::TriggerPort::Cast( triggerPort_1f1c);
		if( false== Uml::IsDerivedFrom( dT_1f25.type(), SFC::DT::meta))
			continue;
		SFC::DT dT_1f2a= SFC::DT::Cast( dT_1f25);
		if( false== Uml::IsDerivedFrom( localVar_1f2e.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_1f33= SFC::LocalVar::Cast( localVar_1f2e);
		if( false== Uml::IsDerivedFrom( function_1f37.type(), SFC::Function::meta))
			continue;
		SFC::Function function_1f3c= SFC::Function::Cast( function_1f37);
		Udm::Object triggerPortParent_1f3e= triggerPort_1f21.container();
		if( false== Uml::IsDerivedFrom( triggerPortParent_1f3e.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem chartTriggerPort_1f3f= CyPhyML::SignalFlow::Subsystem::Cast( triggerPortParent_1f3e);
		SFC::LocalVar triggerVar_1f40= localVar_1f33.trigvar();
		if( !triggerVar_1f40)
			continue;
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1f44;
		if( !isValidBound(boundObjs_1f44, subsystem_1f18, true))
			continue;
		currMatch.subsystem_1f45= subsystem_1f18;
		if( !isValidBound(boundObjs_1f44, triggerPort_1f21, true))
			continue;
		currMatch.triggerPort_1f46= triggerPort_1f21;
		if( !isValidBound(boundObjs_1f44, dT_1f2a, true))
			continue;
		currMatch.dT_1f47= dT_1f2a;
		if( !isValidBound(boundObjs_1f44, localVar_1f33, true))
			continue;
		currMatch.localVar_1f48= localVar_1f33;
		if( !isValidBound(boundObjs_1f44, function_1f3c, true))
			continue;
		currMatch.function_1f49= function_1f3c;
		if( !isValidBound(boundObjs_1f44, chartTriggerPort_1f3f, false))
			continue;
		currMatch.chart_1f4a= chartTriggerPort_1f3f;
		if( !isValidBound(boundObjs_1f44, triggerVar_1f40, false))
			continue;
		currMatch.triggerVar_1f4b= triggerVar_1f40;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void CreateConditional_1efa::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ConditionalBlock newConditionalBlock_1f4c= SFC::ConditionalBlock::Create( currMatch.function_1f49, SFC::Function::meta_stmnt);
		SFC::UserCode newUserCode_1f4d= SFC::UserCode::Create( newConditionalBlock_1f4c, SFC::ConditionalBlock::meta_cond);
		CyPhyML::SignalFlow::Subsystem& Chart= currMatch.chart_1f4a;
		SFC::ConditionalBlock& ConditionalBlock= newConditionalBlock_1f4c;
		SFC::DT& DT= currMatch.dT_1f47;
		SFC::Function& Function= currMatch.function_1f49;
		SFC::LocalVar& LocalVar= currMatch.localVar_1f48;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_1f45;
		CyPhyML::SignalFlow::TriggerPort& TriggerPort= currMatch.triggerPort_1f46;
		SFC::LocalVar& TriggerVar= currMatch.triggerVar_1f4b;
		SFC::UserCode& UserCode= newUserCode_1f4d;
		{
__int64 statementCount = Function.statementCount();
ConditionalBlock.statementIndex() = statementCount++;
Function.statementCount() = statementCount;
};
		outputAppender( currMatch.subsystem_1f45, currMatch.chart_1f4a, currMatch.dT_1f47, currMatch.triggerVar_1f4b, newUserCode_1f4d, newConditionalBlock_1f4c);
	}
}

void CreateConditional_1efa::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_1f4e, const CyPhyML::SignalFlow::Subsystem& chart_1f50, const SFC::DT& dT_1f52, const SFC::LocalVar& triggerVar_1f54, const SFC::UserCode& userCode_1f56, const SFC::ConditionalBlock& conditionalBlock_1f58)
{
	_subsystem_1f0b->push_back( subsystem_1f4e);
	_chart_1f0c->push_back( chart_1f50);
	_dT_1f0d->push_back( dT_1f52);
	_triggerVar_1f0e->push_back( triggerVar_1f54);
	_userCode_1f0f->push_back( userCode_1f56);
	_conditionalBlock_1f10->push_back( conditionalBlock_1f58);
}

void SetMatrixCondition_1f5a::operator()( const Packets_t& dts_1f5b, const Packets_t& triggervars_1f5d, const Packets_t& conditions_1f5f, Packets_t& dts_1f61, Packets_t& triggervars_1f62, Packets_t& conditions_1f63)
{
#ifdef PRINT_INFO
	printLog("SetMatrixCondition_1f5a" );
#endif
	_dt_1f64= &dts_1f61;
	_triggervar_1f65= &triggervars_1f62;
	_condition_1f66= &conditions_1f63;
	_dt_1f64->insert( _dt_1f64->end(), dts_1f5b.begin(), dts_1f5b.end());
	_triggervar_1f65->insert( _triggervar_1f65->end(), triggervars_1f5d.begin(), triggervars_1f5d.end());
	_condition_1f66->insert( _condition_1f66->end(), conditions_1f5f.begin(), conditions_1f5f.end());
	if( ( !dts_1f5b.empty())&& ( !triggervars_1f5d.empty())&& ( !conditions_1f5f.empty()))
		callMatrixCondition_1f94( dts_1f5b, triggervars_1f5d, conditions_1f5f);
}

void SetMatrixCondition_1f5a::callMatrixCondition_1f94( const Packets_t& dTs_1f68, const Packets_t& triggerVars_1f6a, const Packets_t& conditions_1f6c)
{
	MatrixCondition_1f67 matrixCondition_1f67;
	matrixCondition_1f67( dTs_1f68, triggerVars_1f6a, conditions_1f6c);
}

void MatrixCondition_1f67::operator()( const Packets_t& dTs_1f68, const Packets_t& triggerVars_1f6a, const Packets_t& conditions_1f6c)
{
#ifdef PRINT_INFO
	printLog("MatrixCondition_1f67" );
#endif
	RTTGenerator::Instance()->generateRule(2086, "MatrixCondition");
	processInputPackets( dTs_1f68, triggerVars_1f6a, conditions_1f6c);
}

bool MatrixCondition_1f67::isInputUnique( const Udm::Object& dT_1f72, const Udm::Object& triggerVar_1f7b, const Udm::Object& condition_1f84)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itDT_1f74= _dT_1f6e.begin(), itTriggerVar_1f7d= _triggerVar_1f77.begin(), itCondition_1f86= _condition_1f80.begin(); itDT_1f74!= _dT_1f6e.end(), itTriggerVar_1f7d!= _triggerVar_1f77.end(), itCondition_1f86!= _condition_1f80.end(); ++itDT_1f74, ++itTriggerVar_1f7d, ++itCondition_1f86)
	{
		if( ( *itDT_1f74== dT_1f72)&& ( *itTriggerVar_1f7d== triggerVar_1f7b)&& ( *itCondition_1f86== condition_1f84))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_dT_1f6e.push_back( dT_1f72);
		_triggerVar_1f77.push_back( triggerVar_1f7b);
		_condition_1f80.push_back( condition_1f84);
	}
	return isUnique;
}

bool MatrixCondition_1f67::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool MatrixCondition_1f67::isGuardTrue( SFC::UserCode& Condition, SFC::DT& DT, SFC::LocalVar& TriggerVar)
{
	bool Gz_guard= false;
	Gz_guard = DT.type() != SFC::Struct::meta;;
	return Gz_guard;
}

void MatrixCondition_1f67::processInputPackets( const Packets_t& dTs_1f68, const Packets_t& triggerVars_1f6a, const Packets_t& conditions_1f6c)
{
	for( Packets_t::const_iterator itDT_1f6f= dTs_1f68.begin(), itTriggerVar_1f78= triggerVars_1f6a.begin(), itCondition_1f81= conditions_1f6c.begin(); itDT_1f6f!= dTs_1f68.end(), itTriggerVar_1f78!= triggerVars_1f6a.end(), itCondition_1f81!= conditions_1f6c.end(); ++itDT_1f6f, ++itTriggerVar_1f78, ++itCondition_1f81)
	{
		bool isUnique= isInputUnique( *itDT_1f6f, *itTriggerVar_1f78, *itCondition_1f81);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itDT_1f6f, *itTriggerVar_1f78, *itCondition_1f81);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool MatrixCondition_1f67::patternMatcher( const Udm::Object& dT_1f70, const Udm::Object& triggerVar_1f79, const Udm::Object& condition_1f82)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( dT_1f70.type(), SFC::DT::meta))
			continue;
		SFC::DT dT_1f75= SFC::DT::Cast( dT_1f70);
		if( false== Uml::IsDerivedFrom( triggerVar_1f79.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar triggerVar_1f7e= SFC::LocalVar::Cast( triggerVar_1f79);
		if( false== Uml::IsDerivedFrom( condition_1f82.type(), SFC::UserCode::meta))
			continue;
		SFC::UserCode condition_1f87= SFC::UserCode::Cast( condition_1f82);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_1f8c;
		if( !isValidBound(boundObjs_1f8c, dT_1f75, true))
			continue;
		currMatch.dT_1f8d= dT_1f75;
		if( !isValidBound(boundObjs_1f8c, triggerVar_1f7e, true))
			continue;
		currMatch.triggerVar_1f8e= triggerVar_1f7e;
		if( !isValidBound(boundObjs_1f8c, condition_1f87, true))
			continue;
		currMatch.condition_1f8f= condition_1f87;
		bool Gz_guard= isGuardTrue( currMatch.condition_1f8f, currMatch.dT_1f8d, currMatch.triggerVar_1f8e);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void MatrixCondition_1f67::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::ArgDeclRef newArgDeclRef_1f93= SFC::ArgDeclRef::Create( currMatch.condition_1f8f, SFC::UserCode::meta_codeexpr);
		newArgDeclRef_1f93.argdecl()= currMatch.triggerVar_1f8e;
	}
}

void SetStructCondition_1f98::operator()( const Packets_t& dts_1f99, const Packets_t& oldvals_1f9b, const Packets_t& conditions_1f9d)
{
#ifdef PRINT_INFO
	printLog("SetStructCondition_1f98" );
#endif
	if( ( !dts_1f99.empty())&& ( !oldvals_1f9b.empty())&& ( !conditions_1f9d.empty()))
		callStartCondition_21e3( dts_1f99, oldvals_1f9b, conditions_1f9d);
}

void SetStructCondition_1f98::callStartCondition_21e3( const Packets_t& structs_21ae, const Packets_t& triggerVars_21b1, const Packets_t& userCodes_21b4)
{
	Packets_t structs_21b0;
	Packets_t triggerVars_21b3;
	Packets_t unaryExprss_21b6;
	StartCondition_21ad startCondition_21ad;
	startCondition_21ad( structs_21ae, triggerVars_21b1, userCodes_21b4, structs_21b0, triggerVars_21b3, unaryExprss_21b6);
	if( ( !structs_21b0.empty())&& ( !triggerVars_21b3.empty())&& ( !unaryExprss_21b6.empty()))
		callgetStructMembers_21e7( structs_21b0, triggerVars_21b3, unaryExprss_21b6);
}

void SetStructCondition_1f98::callgetStructMembers_21e7( const Packets_t& structs_1fa0, const Packets_t& triggerVars_1fa4, const Packets_t& unaryExprss_1fa7)
{
	Packets_t structs_1fa2;
	Packets_t members_1fa3;
	Packets_t triggerVars_1fa6;
	Packets_t unaryExprss_1fa9;
	GetStructMembers_1f9f getStructMembers_1f9f;
	getStructMembers_1f9f( structs_1fa0, triggerVars_1fa4, unaryExprss_1fa7, structs_1fa2, members_1fa3, triggerVars_1fa6, unaryExprss_1fa9);
	if( ( !structs_1fa2.empty())&& ( !members_1fa3.empty())&& ( !triggerVars_1fa6.empty())&& ( !unaryExprss_1fa9.empty()))
		callPlaceMember_21eb( structs_1fa2, members_1fa3, triggerVars_1fa6, unaryExprss_1fa9);
}

void SetStructCondition_1f98::callPlaceMember_21eb( const Packets_t& structs_1fdd, const Packets_t& members_1fdf, const Packets_t& trigvars_1fe1, const Packets_t& condexprs_1fe3)
{
	PlaceMember_1fdc placeMember_1fdc;
	placeMember_1fdc( structs_1fdd, members_1fdf, trigvars_1fe1, condexprs_1fe3);
}

void GetStructMembers_1f9f::operator()( const Packets_t& structs_1fa0, const Packets_t& triggerVars_1fa4, const Packets_t& unaryExprss_1fa7, Packets_t& structs_1fa2, Packets_t& members_1fa3, Packets_t& triggerVars_1fa6, Packets_t& unaryExprss_1fa9)
{
#ifdef PRINT_INFO
	printLog("GetStructMembers_1f9f" );
#endif
	RTTGenerator::Instance()->generateRule(2097, "getStructMembers");
	_struct_1faa= &structs_1fa2;
	_member_1fab= &members_1fa3;
	_triggerVar_1fac= &triggerVars_1fa6;
	_unaryExprs_1fad= &unaryExprss_1fa9;
	processInputPackets( structs_1fa0, triggerVars_1fa4, unaryExprss_1fa7);
	sortOutputs( );
}

bool GetStructMembers_1f9f::isInputUnique( const Udm::Object& struct_1fb2, const Udm::Object& triggerVar_1fbb, const Udm::Object& unaryExprs_1fc4)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itStruct_1fb4= _struct_1fae.begin(), itTriggerVar_1fbd= _triggerVar_1fb7.begin(), itUnaryExprs_1fc6= _unaryExprs_1fc0.begin(); itStruct_1fb4!= _struct_1fae.end(), itTriggerVar_1fbd!= _triggerVar_1fb7.end(), itUnaryExprs_1fc6!= _unaryExprs_1fc0.end(); ++itStruct_1fb4, ++itTriggerVar_1fbd, ++itUnaryExprs_1fc6)
	{
		if( ( *itStruct_1fb4== struct_1fb2)&& ( *itTriggerVar_1fbd== triggerVar_1fbb)&& ( *itUnaryExprs_1fc6== unaryExprs_1fc4))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_struct_1fae.push_back( struct_1fb2);
		_triggerVar_1fb7.push_back( triggerVar_1fbb);
		_unaryExprs_1fc0.push_back( unaryExprs_1fc4);
	}
	return isUnique;
}

bool GetStructMembers_1f9f::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void GetStructMembers_1f9f::processInputPackets( const Packets_t& structs_1fa0, const Packets_t& triggerVars_1fa4, const Packets_t& unaryExprss_1fa7)
{
	for( Packets_t::const_iterator itStruct_1faf= structs_1fa0.begin(), itTriggerVar_1fb8= triggerVars_1fa4.begin(), itUnaryExprs_1fc1= unaryExprss_1fa7.begin(); itStruct_1faf!= structs_1fa0.end(), itTriggerVar_1fb8!= triggerVars_1fa4.end(), itUnaryExprs_1fc1!= unaryExprss_1fa7.end(); ++itStruct_1faf, ++itTriggerVar_1fb8, ++itUnaryExprs_1fc1)
	{
		bool isUnique= isInputUnique( *itStruct_1faf, *itTriggerVar_1fb8, *itUnaryExprs_1fc1);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itStruct_1faf, *itTriggerVar_1fb8, *itUnaryExprs_1fc1);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool GetStructMembers_1f9f::patternMatcher( const Udm::Object& struct_1fb0, const Udm::Object& triggerVar_1fb9, const Udm::Object& unaryExprs_1fc2)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( struct_1fb0.type(), SFC::Struct::meta))
			continue;
		SFC::Struct struct_1fb5= SFC::Struct::Cast( struct_1fb0);
		if( false== Uml::IsDerivedFrom( triggerVar_1fb9.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar triggerVar_1fbe= SFC::LocalVar::Cast( triggerVar_1fb9);
		if( false== Uml::IsDerivedFrom( unaryExprs_1fc2.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_1fc7= SFC::UnaryExprs::Cast( unaryExprs_1fc2);
		set< SFC::LocalVar> members_1fc9= struct_1fb5.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itMember_1fca= members_1fc9.begin(); itMember_1fca!= members_1fc9.end(); ++itMember_1fca)
		{
			SFC::LocalVar currMember_1fcb= *itMember_1fca;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_1fcf;
			if( !isValidBound(boundObjs_1fcf, struct_1fb5, true))
				continue;
			currMatch.struct_1fd0= struct_1fb5;
			if( !isValidBound(boundObjs_1fcf, triggerVar_1fbe, true))
				continue;
			currMatch.triggerVar_1fd1= triggerVar_1fbe;
			if( !isValidBound(boundObjs_1fcf, unaryExprs_1fc7, true))
				continue;
			currMatch.unaryExprs_1fd2= unaryExprs_1fc7;
			if( !isValidBound(boundObjs_1fcf, currMember_1fcb, false))
				continue;
			currMatch.member_1fd3= currMember_1fcb;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void GetStructMembers_1f9f::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.struct_1fd0, currMatch.member_1fd3, currMatch.triggerVar_1fd1, currMatch.unaryExprs_1fd2);
	}
}

void GetStructMembers_1f9f::outputAppender( const SFC::Struct& struct_1fd4, const SFC::LocalVar& member_1fd6, const SFC::LocalVar& triggerVar_1fd8, const SFC::UnaryExprs& unaryExprs_1fda)
{
	_struct_1faa->push_back( struct_1fd4);
	_member_1fab->push_back( member_1fd6);
	_triggerVar_1fac->push_back( triggerVar_1fd8);
	_unaryExprs_1fad->push_back( unaryExprs_1fda);
}

void GetStructMembers_1f9f::sortOutputs()
{
	typedef std::multiset< SFC::LocalVar, std::pointer_to_binary_function< const SFC::LocalVar&, const SFC::LocalVar&, bool> > SortedSet_t;
	std::pointer_to_binary_function< const SFC::LocalVar&, const SFC::LocalVar&, bool> ptr_StatementOrder( StatementOrder< SFC::LocalVar>);
	SortedSet_t sortedSet( ptr_StatementOrder);
	std::vector< int> permutationVector( _member_1fab->size());
	int currStep= 0;
	for( Packets_t::const_iterator it= _member_1fab->begin(); it!= _member_1fab->end(); ++it, ++currStep)
	{
		SortedSet_t::const_iterator inserted= sortedSet.insert( SFC::LocalVar::Cast(*it));
		SortedSet_t::difference_type pos= std::distance( SortedSet_t::const_iterator( sortedSet.begin()), inserted);
		permutationVector[ currStep]=  pos;
		for( int i= 0; i< currStep; ++i)
		{
			if( permutationVector[ i] >= pos)
				++permutationVector[ i];
		}
	}
	// order the primary container
	std::copy( sortedSet.begin(), sortedSet.end(), _member_1fab->begin());
	// order rest of the containers
	permutate( permutationVector, *_struct_1faa);
	permutate( permutationVector, *_triggerVar_1fac);
	permutate( permutationVector, *_unaryExprs_1fad);
}

void PlaceMember_1fdc::operator()( const Packets_t& structs_1fdd, const Packets_t& members_1fdf, const Packets_t& trigvars_1fe1, const Packets_t& condexprs_1fe3)
{
#ifdef PRINT_INFO
	printLog("PlaceMember_1fdc" );
#endif
	for( Packets_t::const_iterator itstruct_1fe6= structs_1fdd.begin(), itmember_1fed= members_1fdf.begin(), ittrigvar_1ff4= trigvars_1fe1.begin(), itcondexpr_1ffb= condexprs_1fe3.begin(); itstruct_1fe6!= structs_1fdd.end(), itmember_1fed!= members_1fdf.end(), ittrigvar_1ff4!= trigvars_1fe1.end(), itcondexpr_1ffb!= condexprs_1fe3.end(); ++itstruct_1fe6, ++itmember_1fed, ++ittrigvar_1ff4, ++itcondexpr_1ffb)
	{
		bool isUnique= isInputUnique( *itstruct_1fe6, *itmember_1fed, *ittrigvar_1ff4, *itcondexpr_1ffb);
		if( !isUnique)
			continue;
		Packets_t onestruct_1fea( 1, *itstruct_1fe6);
		Packets_t onemember_1ff1( 1, *itmember_1fed);
		Packets_t onetrigvar_1ff8( 1, *ittrigvar_1ff4);
		Packets_t onecondexpr_1fff( 1, *itcondexpr_1ffb);
		executeOne( onestruct_1fea, onemember_1ff1, onetrigvar_1ff8, onecondexpr_1fff);
	}
}

void PlaceMember_1fdc::executeOne( const Packets_t& structs_1fdd, const Packets_t& members_1fdf, const Packets_t& trigvars_1fe1, const Packets_t& condexprs_1fe3)
{
	if( ( !structs_1fdd.empty())&& ( !members_1fdf.empty())&& ( !trigvars_1fe1.empty())&& ( !condexprs_1fe3.empty()))
		callTriggerTest_219e( structs_1fdd, members_1fdf, trigvars_1fe1, condexprs_1fe3);
}

bool PlaceMember_1fdc::isInputUnique( const Udm::Object& struct_1fe7, const Udm::Object& member_1fee, const Udm::Object& trigvar_1ff5, const Udm::Object& condexpr_1ffc)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstruct_1fe9= _struct_1fe5.begin(), itmember_1ff0= _member_1fec.begin(), ittrigvar_1ff7= _trigvar_1ff3.begin(), itcondexpr_1ffe= _condexpr_1ffa.begin(); itstruct_1fe9!= _struct_1fe5.end(), itmember_1ff0!= _member_1fec.end(), ittrigvar_1ff7!= _trigvar_1ff3.end(), itcondexpr_1ffe!= _condexpr_1ffa.end(); ++itstruct_1fe9, ++itmember_1ff0, ++ittrigvar_1ff7, ++itcondexpr_1ffe)
	{
		if( ( *itstruct_1fe9== struct_1fe7)&& ( *itmember_1ff0== member_1fee)&& ( *ittrigvar_1ff7== trigvar_1ff5)&& ( *itcondexpr_1ffe== condexpr_1ffc))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_struct_1fe5.push_back( struct_1fe7);
		_member_1fec.push_back( member_1fee);
		_trigvar_1ff3.push_back( trigvar_1ff5);
		_condexpr_1ffa.push_back( condexpr_1ffc);
	}
	return isUnique;
}

void PlaceMember_1fdc::callTriggerTest_219e( const Packets_t& structs_204f, const Packets_t& members_2051, const Packets_t& trigvars_2053, const Packets_t& condexprs_2055)
{
	Packets_t structs_2057;
	Packets_t members_2058;
	Packets_t trigvars_2059;
	Packets_t condexprs_205a;
	Packets_t structs_205b;
	Packets_t members_205c;
	Packets_t trigvars_205d;
	Packets_t condexprs_205e;
	TriggerTest_204e triggerTest_204e;
	triggerTest_204e( structs_204f, members_2051, trigvars_2053, condexprs_2055, structs_2057, members_2058, trigvars_2059, condexprs_205a, structs_205b, members_205c, trigvars_205d, condexprs_205e);
	if( ( !structs_2057.empty())&& ( !members_2058.empty())&& ( !trigvars_2059.empty())&& ( !condexprs_205a.empty()))
		callTraverseBinary_21a3( structs_2057, members_2058, trigvars_2059, condexprs_205a);
	if( ( !structs_205b.empty())&& ( !members_205c.empty())&& ( !trigvars_205d.empty())&& ( !condexprs_205e.empty()))
		callAddTrigger_21a8( structs_205b, members_205c, trigvars_205d, condexprs_205e);
}

void PlaceMember_1fdc::callTraverseBinary_21a3( const Packets_t& structs_2002, const Packets_t& members_2005, const Packets_t& triggerVars_2008, const Packets_t& unaryExprss_200b)
{
	Packets_t structs_2004;
	Packets_t members_2007;
	Packets_t triggerVars_200a;
	Packets_t unaryExprss_200d;
	TraverseBinary_2001 traverseBinary_2001;
	traverseBinary_2001( structs_2002, members_2005, triggerVars_2008, unaryExprss_200b, structs_2004, members_2007, triggerVars_200a, unaryExprss_200d);
	if( ( !structs_2004.empty())&& ( !members_2007.empty())&& ( !triggerVars_200a.empty())&& ( !unaryExprss_200d.empty()))
		callTriggerTest_219e( structs_2004, members_2007, triggerVars_200a, unaryExprss_200d);
}

void PlaceMember_1fdc::callAddTrigger_21a8( const Packets_t& structs_2112, const Packets_t& members_2114, const Packets_t& trigvars_2116, const Packets_t& condexprs_2118)
{
	AddTrigger_2111 addTrigger_2111;
	addTrigger_2111( structs_2112, members_2114, trigvars_2116, condexprs_2118);
}

void TraverseBinary_2001::operator()( const Packets_t& structs_2002, const Packets_t& members_2005, const Packets_t& triggerVars_2008, const Packets_t& unaryExprss_200b, Packets_t& structs_2004, Packets_t& members_2007, Packets_t& triggerVars_200a, Packets_t& unaryExprss_200d)
{
#ifdef PRINT_INFO
	printLog("TraverseBinary_2001" );
#endif
	RTTGenerator::Instance()->generateRule(2108, "TraverseBinary");
	_struct_200e= &structs_2004;
	_member_200f= &members_2007;
	_triggerVar_2010= &triggerVars_200a;
	_unaryExprs_2011= &unaryExprss_200d;
	processInputPackets( structs_2002, members_2005, triggerVars_2008, unaryExprss_200b);
}

bool TraverseBinary_2001::isInputUnique( const Udm::Object& struct_2016, const Udm::Object& member_201f, const Udm::Object& triggerVar_2028, const Udm::Object& unaryExprs_2031)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itStruct_2018= _struct_2012.begin(), itMember_2021= _member_201b.begin(), itTriggerVar_202a= _triggerVar_2024.begin(), itUnaryExprs_2033= _unaryExprs_202d.begin(); itStruct_2018!= _struct_2012.end(), itMember_2021!= _member_201b.end(), itTriggerVar_202a!= _triggerVar_2024.end(), itUnaryExprs_2033!= _unaryExprs_202d.end(); ++itStruct_2018, ++itMember_2021, ++itTriggerVar_202a, ++itUnaryExprs_2033)
	{
		if( ( *itStruct_2018== struct_2016)&& ( *itMember_2021== member_201f)&& ( *itTriggerVar_202a== triggerVar_2028)&& ( *itUnaryExprs_2033== unaryExprs_2031))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_struct_2012.push_back( struct_2016);
		_member_201b.push_back( member_201f);
		_triggerVar_2024.push_back( triggerVar_2028);
		_unaryExprs_202d.push_back( unaryExprs_2031);
	}
	return isUnique;
}

bool TraverseBinary_2001::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void TraverseBinary_2001::processInputPackets( const Packets_t& structs_2002, const Packets_t& members_2005, const Packets_t& triggerVars_2008, const Packets_t& unaryExprss_200b)
{
	for( Packets_t::const_iterator itStruct_2013= structs_2002.begin(), itMember_201c= members_2005.begin(), itTriggerVar_2025= triggerVars_2008.begin(), itUnaryExprs_202e= unaryExprss_200b.begin(); itStruct_2013!= structs_2002.end(), itMember_201c!= members_2005.end(), itTriggerVar_2025!= triggerVars_2008.end(), itUnaryExprs_202e!= unaryExprss_200b.end(); ++itStruct_2013, ++itMember_201c, ++itTriggerVar_2025, ++itUnaryExprs_202e)
	{
		bool isUnique= isInputUnique( *itStruct_2013, *itMember_201c, *itTriggerVar_2025, *itUnaryExprs_202e);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itStruct_2013, *itMember_201c, *itTriggerVar_2025, *itUnaryExprs_202e);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool TraverseBinary_2001::patternMatcher( const Udm::Object& struct_2014, const Udm::Object& member_201d, const Udm::Object& triggerVar_2026, const Udm::Object& unaryExprs_202f)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( struct_2014.type(), SFC::Struct::meta))
			continue;
		SFC::Struct struct_2019= SFC::Struct::Cast( struct_2014);
		if( false== Uml::IsDerivedFrom( member_201d.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar member_2022= SFC::LocalVar::Cast( member_201d);
		if( false== Uml::IsDerivedFrom( triggerVar_2026.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar triggerVar_202b= SFC::LocalVar::Cast( triggerVar_2026);
		if( false== Uml::IsDerivedFrom( unaryExprs_202f.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_2034= SFC::UnaryExprs::Cast( unaryExprs_202f);
		set< SFC::BinaryExprs> binaryExprss_2036= unaryExprs_2034.BinaryExprs_kind_children();
		for( set< SFC::BinaryExprs>::const_iterator itBinaryExprs_2037= binaryExprss_2036.begin(); itBinaryExprs_2037!= binaryExprss_2036.end(); ++itBinaryExprs_2037)
		{
			SFC::BinaryExprs currBinaryExprs_2038= *itBinaryExprs_2037;
			set< SFC::UnaryExprs> unaryExprss_2039= currBinaryExprs_2038.UnaryExprs_kind_children();
			for( set< SFC::UnaryExprs>::const_iterator itUnaryExprs_203a= unaryExprss_2039.begin(); itUnaryExprs_203a!= unaryExprss_2039.end(); ++itUnaryExprs_203a)
			{
				SFC::UnaryExprs currUnaryExprs_203b= *itUnaryExprs_203a;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_203f;
				if( !isValidBound(boundObjs_203f, struct_2019, true))
					continue;
				currMatch.struct_2040= struct_2019;
				if( !isValidBound(boundObjs_203f, member_2022, true))
					continue;
				currMatch.member_2041= member_2022;
				if( !isValidBound(boundObjs_203f, triggerVar_202b, true))
					continue;
				currMatch.triggerVar_2042= triggerVar_202b;
				if( !isValidBound(boundObjs_203f, unaryExprs_2034, true))
					continue;
				currMatch.unaryExprs_2043= unaryExprs_2034;
				if( !isValidBound(boundObjs_203f, currBinaryExprs_2038, false))
					continue;
				currMatch.binaryExprs_2044= currBinaryExprs_2038;
				if( !isValidBound(boundObjs_203f, currUnaryExprs_203b, false))
					continue;
				currMatch.unaryExprs_2045= currUnaryExprs_203b;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void TraverseBinary_2001::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.struct_2040, currMatch.member_2041, currMatch.triggerVar_2042, currMatch.unaryExprs_2045);
	}
}

void TraverseBinary_2001::outputAppender( const SFC::Struct& struct_2046, const SFC::LocalVar& member_2048, const SFC::LocalVar& triggerVar_204a, const SFC::UnaryExprs& unaryExprs_204c)
{
	_struct_200e->push_back( struct_2046);
	_member_200f->push_back( member_2048);
	_triggerVar_2010->push_back( triggerVar_204a);
	_unaryExprs_2011->push_back( unaryExprs_204c);
}

void TriggerTest_204e::operator()( const Packets_t& structs_204f, const Packets_t& members_2051, const Packets_t& trigvars_2053, const Packets_t& condexprs_2055, Packets_t& structs_2057, Packets_t& members_2058, Packets_t& trigvars_2059, Packets_t& condexprs_205a, Packets_t& structs_205b, Packets_t& members_205c, Packets_t& trigvars_205d, Packets_t& condexprs_205e)
{
#ifdef PRINT_INFO
	printLog("TriggerTest_204e" );
#endif
	_struct_205f= &structs_2057;
	_member_2060= &members_2058;
	_trigvar_2061= &trigvars_2059;
	_condexpr_2062= &condexprs_205a;
	_struct_2063= &structs_205b;
	_member_2064= &members_205c;
	_trigvar_2065= &trigvars_205d;
	_condexpr_2066= &condexprs_205e;
	for( Packets_t::const_iterator itstruct_2068= structs_204f.begin(), itmember_206f= members_2051.begin(), ittrigvar_2076= trigvars_2053.begin(), itcondexpr_207d= condexprs_2055.begin(); itstruct_2068!= structs_204f.end(), itmember_206f!= members_2051.end(), ittrigvar_2076!= trigvars_2053.end(), itcondexpr_207d!= condexprs_2055.end(); ++itstruct_2068, ++itmember_206f, ++ittrigvar_2076, ++itcondexpr_207d)
	{
		bool isUnique= isInputUnique( *itstruct_2068, *itmember_206f, *ittrigvar_2076, *itcondexpr_207d);
		if( !isUnique)
			continue;
		Packets_t onestruct_206c( 1, *itstruct_2068);
		Packets_t onemember_2073( 1, *itmember_206f);
		Packets_t onetrigvar_207a( 1, *ittrigvar_2076);
		Packets_t onecondexpr_2081( 1, *itcondexpr_207d);
		executeOne( onestruct_206c, onemember_2073, onetrigvar_207a, onecondexpr_2081);
	}
}

void TriggerTest_204e::executeOne( const Packets_t& structs_204f, const Packets_t& members_2051, const Packets_t& trigvars_2053, const Packets_t& condexprs_2055)
{
	Packets_t structs_2086;
	Packets_t members_2089;
	Packets_t triggerVars_208c;
	Packets_t unaryExprss_208f;
	HasBinaryExprs_2083 hasBinaryExprs_2083;
	bool isMatchHasBinaryExprs_2083= hasBinaryExprs_2083( structs_204f, members_2051, trigvars_2053, condexprs_2055, structs_2086, members_2089, triggerVars_208c, unaryExprss_208f);
	_struct_205f->insert( _struct_205f->end(), structs_2086.begin(), structs_2086.end());
	_member_2060->insert( _member_2060->end(), members_2089.begin(), members_2089.end());
	_trigvar_2061->insert( _trigvar_2061->end(), triggerVars_208c.begin(), triggerVars_208c.end());
	_condexpr_2062->insert( _condexpr_2062->end(), unaryExprss_208f.begin(), unaryExprss_208f.end());
	if( isMatchHasBinaryExprs_2083)
		return;
	Packets_t structs_20cf;
	Packets_t members_20d2;
	Packets_t triggerVars_20d5;
	Packets_t unaryExprss_20d8;
	Otherwise_20cc otherwise_20cc;
	bool isMatchOtherwise_20cc= otherwise_20cc( structs_204f, members_2051, trigvars_2053, condexprs_2055, structs_20cf, members_20d2, triggerVars_20d5, unaryExprss_20d8);
	_struct_2063->insert( _struct_2063->end(), structs_20cf.begin(), structs_20cf.end());
	_member_2064->insert( _member_2064->end(), members_20d2.begin(), members_20d2.end());
	_trigvar_2065->insert( _trigvar_2065->end(), triggerVars_20d5.begin(), triggerVars_20d5.end());
	_condexpr_2066->insert( _condexpr_2066->end(), unaryExprss_20d8.begin(), unaryExprss_20d8.end());
	if( isMatchOtherwise_20cc)
		return;
}

bool TriggerTest_204e::isInputUnique( const Udm::Object& struct_2069, const Udm::Object& member_2070, const Udm::Object& trigvar_2077, const Udm::Object& condexpr_207e)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itstruct_206b= _struct_2067.begin(), itmember_2072= _member_206e.begin(), ittrigvar_2079= _trigvar_2075.begin(), itcondexpr_2080= _condexpr_207c.begin(); itstruct_206b!= _struct_2067.end(), itmember_2072!= _member_206e.end(), ittrigvar_2079!= _trigvar_2075.end(), itcondexpr_2080!= _condexpr_207c.end(); ++itstruct_206b, ++itmember_2072, ++ittrigvar_2079, ++itcondexpr_2080)
	{
		if( ( *itstruct_206b== struct_2069)&& ( *itmember_2072== member_2070)&& ( *ittrigvar_2079== trigvar_2077)&& ( *itcondexpr_2080== condexpr_207e))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_struct_2067.push_back( struct_2069);
		_member_206e.push_back( member_2070);
		_trigvar_2075.push_back( trigvar_2077);
		_condexpr_207c.push_back( condexpr_207e);
	}
	return isUnique;
}

bool HasBinaryExprs_2083::operator()( const Packets_t& structs_2084, const Packets_t& members_2087, const Packets_t& triggerVars_208a, const Packets_t& unaryExprss_208d, Packets_t& structs_2086, Packets_t& members_2089, Packets_t& triggerVars_208c, Packets_t& unaryExprss_208f)
{
#ifdef PRINT_INFO
	printLog("HasBinaryExprs_2083" );
#endif
	_struct_2090= &structs_2086;
	_member_2091= &members_2089;
	_triggerVar_2092= &triggerVars_208c;
	_unaryExprs_2093= &unaryExprss_208f;
	processInputPackets( structs_2084, members_2087, triggerVars_208a, unaryExprss_208d);
	if( false== _matches.empty())
		return true;
	return false;
}

bool HasBinaryExprs_2083::isInputUnique( const Udm::Object& struct_2098, const Udm::Object& member_20a1, const Udm::Object& triggerVar_20aa, const Udm::Object& unaryExprs_20b3)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itStruct_209a= _struct_2094.begin(), itMember_20a3= _member_209d.begin(), itTriggerVar_20ac= _triggerVar_20a6.begin(), itUnaryExprs_20b5= _unaryExprs_20af.begin(); itStruct_209a!= _struct_2094.end(), itMember_20a3!= _member_209d.end(), itTriggerVar_20ac!= _triggerVar_20a6.end(), itUnaryExprs_20b5!= _unaryExprs_20af.end(); ++itStruct_209a, ++itMember_20a3, ++itTriggerVar_20ac, ++itUnaryExprs_20b5)
	{
		if( ( *itStruct_209a== struct_2098)&& ( *itMember_20a3== member_20a1)&& ( *itTriggerVar_20ac== triggerVar_20aa)&& ( *itUnaryExprs_20b5== unaryExprs_20b3))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_struct_2094.push_back( struct_2098);
		_member_209d.push_back( member_20a1);
		_triggerVar_20a6.push_back( triggerVar_20aa);
		_unaryExprs_20af.push_back( unaryExprs_20b3);
	}
	return isUnique;
}

bool HasBinaryExprs_2083::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void HasBinaryExprs_2083::processInputPackets( const Packets_t& structs_2084, const Packets_t& members_2087, const Packets_t& triggerVars_208a, const Packets_t& unaryExprss_208d)
{
	for( Packets_t::const_iterator itStruct_2095= structs_2084.begin(), itMember_209e= members_2087.begin(), itTriggerVar_20a7= triggerVars_208a.begin(), itUnaryExprs_20b0= unaryExprss_208d.begin(); itStruct_2095!= structs_2084.end(), itMember_209e!= members_2087.end(), itTriggerVar_20a7!= triggerVars_208a.end(), itUnaryExprs_20b0!= unaryExprss_208d.end(); ++itStruct_2095, ++itMember_209e, ++itTriggerVar_20a7, ++itUnaryExprs_20b0)
	{
		bool isUnique= isInputUnique( *itStruct_2095, *itMember_209e, *itTriggerVar_20a7, *itUnaryExprs_20b0);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itStruct_2095, *itMember_209e, *itTriggerVar_20a7, *itUnaryExprs_20b0);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.struct_20bf, currMatch.member_20c0, currMatch.triggerVar_20c1, currMatch.unaryExprs_20c2);
	}
}

bool HasBinaryExprs_2083::patternMatcher( const Udm::Object& struct_2096, const Udm::Object& member_209f, const Udm::Object& triggerVar_20a8, const Udm::Object& unaryExprs_20b1)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( struct_2096.type(), SFC::Struct::meta))
			continue;
		SFC::Struct struct_209b= SFC::Struct::Cast( struct_2096);
		if( false== Uml::IsDerivedFrom( member_209f.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar member_20a4= SFC::LocalVar::Cast( member_209f);
		if( false== Uml::IsDerivedFrom( triggerVar_20a8.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar triggerVar_20ad= SFC::LocalVar::Cast( triggerVar_20a8);
		if( false== Uml::IsDerivedFrom( unaryExprs_20b1.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_20b6= SFC::UnaryExprs::Cast( unaryExprs_20b1);
		set< SFC::BinaryExprs> binaryExprss_20b8= unaryExprs_20b6.BinaryExprs_kind_children();
		for( set< SFC::BinaryExprs>::const_iterator itBinaryExprs_20b9= binaryExprss_20b8.begin(); itBinaryExprs_20b9!= binaryExprss_20b8.end(); ++itBinaryExprs_20b9)
		{
			SFC::BinaryExprs currBinaryExprs_20ba= *itBinaryExprs_20b9;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_20be;
			if( !isValidBound(boundObjs_20be, struct_209b, true))
				continue;
			currMatch.struct_20bf= struct_209b;
			if( !isValidBound(boundObjs_20be, member_20a4, true))
				continue;
			currMatch.member_20c0= member_20a4;
			if( !isValidBound(boundObjs_20be, triggerVar_20ad, true))
				continue;
			currMatch.triggerVar_20c1= triggerVar_20ad;
			if( !isValidBound(boundObjs_20be, unaryExprs_20b6, true))
				continue;
			currMatch.unaryExprs_20c2= unaryExprs_20b6;
			if( !isValidBound(boundObjs_20be, currBinaryExprs_20ba, false))
				continue;
			currMatch.binaryExprs_20c3= currBinaryExprs_20ba;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void HasBinaryExprs_2083::outputAppender( const SFC::Struct& struct_20c4, const SFC::LocalVar& member_20c6, const SFC::LocalVar& triggerVar_20c8, const SFC::UnaryExprs& unaryExprs_20ca)
{
	_struct_2090->push_back( struct_20c4);
	_member_2091->push_back( member_20c6);
	_triggerVar_2092->push_back( triggerVar_20c8);
	_unaryExprs_2093->push_back( unaryExprs_20ca);
}

bool Otherwise_20cc::operator()( const Packets_t& structs_20cd, const Packets_t& members_20d0, const Packets_t& triggerVars_20d3, const Packets_t& unaryExprss_20d6, Packets_t& structs_20cf, Packets_t& members_20d2, Packets_t& triggerVars_20d5, Packets_t& unaryExprss_20d8)
{
#ifdef PRINT_INFO
	printLog("Otherwise_20cc" );
#endif
	_struct_20d9= &structs_20cf;
	_member_20da= &members_20d2;
	_triggerVar_20db= &triggerVars_20d5;
	_unaryExprs_20dc= &unaryExprss_20d8;
	processInputPackets( structs_20cd, members_20d0, triggerVars_20d3, unaryExprss_20d6);
	if( false== _matches.empty())
		return true;
	return false;
}

bool Otherwise_20cc::isInputUnique( const Udm::Object& struct_20e1, const Udm::Object& member_20ea, const Udm::Object& triggerVar_20f3, const Udm::Object& unaryExprs_20fc)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itStruct_20e3= _struct_20dd.begin(), itMember_20ec= _member_20e6.begin(), itTriggerVar_20f5= _triggerVar_20ef.begin(), itUnaryExprs_20fe= _unaryExprs_20f8.begin(); itStruct_20e3!= _struct_20dd.end(), itMember_20ec!= _member_20e6.end(), itTriggerVar_20f5!= _triggerVar_20ef.end(), itUnaryExprs_20fe!= _unaryExprs_20f8.end(); ++itStruct_20e3, ++itMember_20ec, ++itTriggerVar_20f5, ++itUnaryExprs_20fe)
	{
		if( ( *itStruct_20e3== struct_20e1)&& ( *itMember_20ec== member_20ea)&& ( *itTriggerVar_20f5== triggerVar_20f3)&& ( *itUnaryExprs_20fe== unaryExprs_20fc))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_struct_20dd.push_back( struct_20e1);
		_member_20e6.push_back( member_20ea);
		_triggerVar_20ef.push_back( triggerVar_20f3);
		_unaryExprs_20f8.push_back( unaryExprs_20fc);
	}
	return isUnique;
}

bool Otherwise_20cc::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void Otherwise_20cc::processInputPackets( const Packets_t& structs_20cd, const Packets_t& members_20d0, const Packets_t& triggerVars_20d3, const Packets_t& unaryExprss_20d6)
{
	for( Packets_t::const_iterator itStruct_20de= structs_20cd.begin(), itMember_20e7= members_20d0.begin(), itTriggerVar_20f0= triggerVars_20d3.begin(), itUnaryExprs_20f9= unaryExprss_20d6.begin(); itStruct_20de!= structs_20cd.end(), itMember_20e7!= members_20d0.end(), itTriggerVar_20f0!= triggerVars_20d3.end(), itUnaryExprs_20f9!= unaryExprss_20d6.end(); ++itStruct_20de, ++itMember_20e7, ++itTriggerVar_20f0, ++itUnaryExprs_20f9)
	{
		bool isUnique= isInputUnique( *itStruct_20de, *itMember_20e7, *itTriggerVar_20f0, *itUnaryExprs_20f9);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itStruct_20de, *itMember_20e7, *itTriggerVar_20f0, *itUnaryExprs_20f9);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.struct_2105, currMatch.member_2106, currMatch.triggerVar_2107, currMatch.unaryExprs_2108);
	}
}

bool Otherwise_20cc::patternMatcher( const Udm::Object& struct_20df, const Udm::Object& member_20e8, const Udm::Object& triggerVar_20f1, const Udm::Object& unaryExprs_20fa)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( struct_20df.type(), SFC::Struct::meta))
			continue;
		SFC::Struct struct_20e4= SFC::Struct::Cast( struct_20df);
		if( false== Uml::IsDerivedFrom( member_20e8.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar member_20ed= SFC::LocalVar::Cast( member_20e8);
		if( false== Uml::IsDerivedFrom( triggerVar_20f1.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar triggerVar_20f6= SFC::LocalVar::Cast( triggerVar_20f1);
		if( false== Uml::IsDerivedFrom( unaryExprs_20fa.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_20ff= SFC::UnaryExprs::Cast( unaryExprs_20fa);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2104;
		if( !isValidBound(boundObjs_2104, struct_20e4, true))
			continue;
		currMatch.struct_2105= struct_20e4;
		if( !isValidBound(boundObjs_2104, member_20ed, true))
			continue;
		currMatch.member_2106= member_20ed;
		if( !isValidBound(boundObjs_2104, triggerVar_20f6, true))
			continue;
		currMatch.triggerVar_2107= triggerVar_20f6;
		if( !isValidBound(boundObjs_2104, unaryExprs_20ff, true))
			continue;
		currMatch.unaryExprs_2108= unaryExprs_20ff;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void Otherwise_20cc::outputAppender( const SFC::Struct& struct_2109, const SFC::LocalVar& member_210b, const SFC::LocalVar& triggerVar_210d, const SFC::UnaryExprs& unaryExprs_210f)
{
	_struct_20d9->push_back( struct_2109);
	_member_20da->push_back( member_210b);
	_triggerVar_20db->push_back( triggerVar_210d);
	_unaryExprs_20dc->push_back( unaryExprs_210f);
}

void AddTrigger_2111::operator()( const Packets_t& structs_2112, const Packets_t& members_2114, const Packets_t& trigvars_2116, const Packets_t& condexprs_2118)
{
#ifdef PRINT_INFO
	printLog("AddTrigger_2111" );
#endif
	if( ( !structs_2112.empty())&& ( !members_2114.empty())&& ( !trigvars_2116.empty())&& ( !condexprs_2118.empty()))
		callAddNextTrigger_2194( structs_2112, members_2114, trigvars_2116, condexprs_2118);
	if( ( !structs_2112.empty())&& ( !members_2114.empty())&& ( !trigvars_2116.empty())&& ( !condexprs_2118.empty()))
		callAddLastTrigger_2199( structs_2112, members_2114, trigvars_2116, condexprs_2118);
}

void AddTrigger_2111::callAddNextTrigger_2194( const Packets_t& structs_211b, const Packets_t& members_211d, const Packets_t& triggerVars_211f, const Packets_t& unaryExprss_2121)
{
	AddNextTrigger_211a addNextTrigger_211a;
	addNextTrigger_211a( structs_211b, members_211d, triggerVars_211f, unaryExprss_2121);
}

void AddTrigger_2111::callAddLastTrigger_2199( const Packets_t& structs_2159, const Packets_t& members_215b, const Packets_t& triggerVars_215d, const Packets_t& unaryExprss_215f)
{
	AddLastTrigger_2158 addLastTrigger_2158;
	addLastTrigger_2158( structs_2159, members_215b, triggerVars_215d, unaryExprss_215f);
}

void AddNextTrigger_211a::operator()( const Packets_t& structs_211b, const Packets_t& members_211d, const Packets_t& triggerVars_211f, const Packets_t& unaryExprss_2121)
{
#ifdef PRINT_INFO
	printLog("AddNextTrigger_211a" );
#endif
	RTTGenerator::Instance()->generateRule(2147, "AddNextTrigger");
	processInputPackets( structs_211b, members_211d, triggerVars_211f, unaryExprss_2121);
}

bool AddNextTrigger_211a::isInputUnique( const Udm::Object& struct_2127, const Udm::Object& member_2130, const Udm::Object& triggerVar_2139, const Udm::Object& unaryExprs_2142)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itStruct_2129= _struct_2123.begin(), itMember_2132= _member_212c.begin(), itTriggerVar_213b= _triggerVar_2135.begin(), itUnaryExprs_2144= _unaryExprs_213e.begin(); itStruct_2129!= _struct_2123.end(), itMember_2132!= _member_212c.end(), itTriggerVar_213b!= _triggerVar_2135.end(), itUnaryExprs_2144!= _unaryExprs_213e.end(); ++itStruct_2129, ++itMember_2132, ++itTriggerVar_213b, ++itUnaryExprs_2144)
	{
		if( ( *itStruct_2129== struct_2127)&& ( *itMember_2132== member_2130)&& ( *itTriggerVar_213b== triggerVar_2139)&& ( *itUnaryExprs_2144== unaryExprs_2142))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_struct_2123.push_back( struct_2127);
		_member_212c.push_back( member_2130);
		_triggerVar_2135.push_back( triggerVar_2139);
		_unaryExprs_213e.push_back( unaryExprs_2142);
	}
	return isUnique;
}

bool AddNextTrigger_211a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool AddNextTrigger_211a::isGuardTrue( SFC::LocalVar& Member, SFC::Struct& Struct, SFC::LocalVar& TriggerVar, SFC::UnaryExprs& UnaryExprs)
{
	bool Gz_guard= false;
	Gz_guard = Member.statementIndex() + 1 != Struct.memberCount();;
	return Gz_guard;
}

void AddNextTrigger_211a::processInputPackets( const Packets_t& structs_211b, const Packets_t& members_211d, const Packets_t& triggerVars_211f, const Packets_t& unaryExprss_2121)
{
	for( Packets_t::const_iterator itStruct_2124= structs_211b.begin(), itMember_212d= members_211d.begin(), itTriggerVar_2136= triggerVars_211f.begin(), itUnaryExprs_213f= unaryExprss_2121.begin(); itStruct_2124!= structs_211b.end(), itMember_212d!= members_211d.end(), itTriggerVar_2136!= triggerVars_211f.end(), itUnaryExprs_213f!= unaryExprss_2121.end(); ++itStruct_2124, ++itMember_212d, ++itTriggerVar_2136, ++itUnaryExprs_213f)
	{
		bool isUnique= isInputUnique( *itStruct_2124, *itMember_212d, *itTriggerVar_2136, *itUnaryExprs_213f);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itStruct_2124, *itMember_212d, *itTriggerVar_2136, *itUnaryExprs_213f);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool AddNextTrigger_211a::patternMatcher( const Udm::Object& struct_2125, const Udm::Object& member_212e, const Udm::Object& triggerVar_2137, const Udm::Object& unaryExprs_2140)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( struct_2125.type(), SFC::Struct::meta))
			continue;
		SFC::Struct struct_212a= SFC::Struct::Cast( struct_2125);
		if( false== Uml::IsDerivedFrom( member_212e.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar member_2133= SFC::LocalVar::Cast( member_212e);
		if( false== Uml::IsDerivedFrom( triggerVar_2137.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar triggerVar_213c= SFC::LocalVar::Cast( triggerVar_2137);
		if( false== Uml::IsDerivedFrom( unaryExprs_2140.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_2145= SFC::UnaryExprs::Cast( unaryExprs_2140);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_214a;
		if( !isValidBound(boundObjs_214a, struct_212a, true))
			continue;
		currMatch.struct_214b= struct_212a;
		if( !isValidBound(boundObjs_214a, member_2133, true))
			continue;
		currMatch.member_214c= member_2133;
		if( !isValidBound(boundObjs_214a, triggerVar_213c, true))
			continue;
		currMatch.triggerVar_214d= triggerVar_213c;
		if( !isValidBound(boundObjs_214a, unaryExprs_2145, true))
			continue;
		currMatch.unaryExprs_214e= unaryExprs_2145;
		bool Gz_guard= isGuardTrue( currMatch.member_214c, currMatch.struct_214b, currMatch.triggerVar_214d, currMatch.unaryExprs_214e);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void AddNextTrigger_211a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::BinaryExprs newOr_2153= SFC::BinaryExprs::Create( currMatch.unaryExprs_214e, SFC::UnaryExprs::meta_subexpr);
		SFC::UnaryExprs newDummy_2154= SFC::UnaryExprs::Create( newOr_2153, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs newDot_2155= SFC::BinaryExprs::Create( newOr_2153, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef1_2156= SFC::ArgDeclRef::Create( newDot_2155, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef2_2157= SFC::ArgDeclRef::Create( newDot_2155, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef& ArgDeclRef1= newArgDeclRef1_2156;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_2157;
		SFC::BinaryExprs& Dot= newDot_2155;
		SFC::UnaryExprs& Dummy= newDummy_2154;
		SFC::LocalVar& Member= currMatch.member_214c;
		SFC::BinaryExprs& Or= newOr_2153;
		SFC::Struct& Struct= currMatch.struct_214b;
		SFC::LocalVar& TriggerVar= currMatch.triggerVar_214d;
		SFC::UnaryExprs& UnaryExprs= currMatch.unaryExprs_214e;
		{
Dummy.op() = "";
};
		{
Dot.op() = ".";
};
		{
Or.op() = "||";
};
		newArgDeclRef2_2157.argdecl()= currMatch.triggerVar_214d;
		newArgDeclRef1_2156.argdecl()= currMatch.member_214c;
	}
}

void AddLastTrigger_2158::operator()( const Packets_t& structs_2159, const Packets_t& members_215b, const Packets_t& triggerVars_215d, const Packets_t& unaryExprss_215f)
{
#ifdef PRINT_INFO
	printLog("AddLastTrigger_2158" );
#endif
	RTTGenerator::Instance()->generateRule(2167, "AddLastTrigger");
	processInputPackets( structs_2159, members_215b, triggerVars_215d, unaryExprss_215f);
}

bool AddLastTrigger_2158::isInputUnique( const Udm::Object& struct_2165, const Udm::Object& member_216e, const Udm::Object& triggerVar_2177, const Udm::Object& unaryExprs_2180)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itStruct_2167= _struct_2161.begin(), itMember_2170= _member_216a.begin(), itTriggerVar_2179= _triggerVar_2173.begin(), itUnaryExprs_2182= _unaryExprs_217c.begin(); itStruct_2167!= _struct_2161.end(), itMember_2170!= _member_216a.end(), itTriggerVar_2179!= _triggerVar_2173.end(), itUnaryExprs_2182!= _unaryExprs_217c.end(); ++itStruct_2167, ++itMember_2170, ++itTriggerVar_2179, ++itUnaryExprs_2182)
	{
		if( ( *itStruct_2167== struct_2165)&& ( *itMember_2170== member_216e)&& ( *itTriggerVar_2179== triggerVar_2177)&& ( *itUnaryExprs_2182== unaryExprs_2180))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_struct_2161.push_back( struct_2165);
		_member_216a.push_back( member_216e);
		_triggerVar_2173.push_back( triggerVar_2177);
		_unaryExprs_217c.push_back( unaryExprs_2180);
	}
	return isUnique;
}

bool AddLastTrigger_2158::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool AddLastTrigger_2158::isGuardTrue( SFC::LocalVar& Member, SFC::Struct& Struct, SFC::LocalVar& TriggerVar, SFC::UnaryExprs& UnaryExprs)
{
	bool Gz_guard= false;
	Gz_guard = Member.statementIndex() + 1 == Struct.memberCount();;
	return Gz_guard;
}

void AddLastTrigger_2158::processInputPackets( const Packets_t& structs_2159, const Packets_t& members_215b, const Packets_t& triggerVars_215d, const Packets_t& unaryExprss_215f)
{
	for( Packets_t::const_iterator itStruct_2162= structs_2159.begin(), itMember_216b= members_215b.begin(), itTriggerVar_2174= triggerVars_215d.begin(), itUnaryExprs_217d= unaryExprss_215f.begin(); itStruct_2162!= structs_2159.end(), itMember_216b!= members_215b.end(), itTriggerVar_2174!= triggerVars_215d.end(), itUnaryExprs_217d!= unaryExprss_215f.end(); ++itStruct_2162, ++itMember_216b, ++itTriggerVar_2174, ++itUnaryExprs_217d)
	{
		bool isUnique= isInputUnique( *itStruct_2162, *itMember_216b, *itTriggerVar_2174, *itUnaryExprs_217d);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itStruct_2162, *itMember_216b, *itTriggerVar_2174, *itUnaryExprs_217d);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool AddLastTrigger_2158::patternMatcher( const Udm::Object& struct_2163, const Udm::Object& member_216c, const Udm::Object& triggerVar_2175, const Udm::Object& unaryExprs_217e)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( struct_2163.type(), SFC::Struct::meta))
			continue;
		SFC::Struct struct_2168= SFC::Struct::Cast( struct_2163);
		if( false== Uml::IsDerivedFrom( member_216c.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar member_2171= SFC::LocalVar::Cast( member_216c);
		if( false== Uml::IsDerivedFrom( triggerVar_2175.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar triggerVar_217a= SFC::LocalVar::Cast( triggerVar_2175);
		if( false== Uml::IsDerivedFrom( unaryExprs_217e.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_2183= SFC::UnaryExprs::Cast( unaryExprs_217e);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2188;
		if( !isValidBound(boundObjs_2188, struct_2168, true))
			continue;
		currMatch.struct_2189= struct_2168;
		if( !isValidBound(boundObjs_2188, member_2171, true))
			continue;
		currMatch.member_218a= member_2171;
		if( !isValidBound(boundObjs_2188, triggerVar_217a, true))
			continue;
		currMatch.triggerVar_218b= triggerVar_217a;
		if( !isValidBound(boundObjs_2188, unaryExprs_2183, true))
			continue;
		currMatch.unaryExprs_218c= unaryExprs_2183;
		bool Gz_guard= isGuardTrue( currMatch.member_218a, currMatch.struct_2189, currMatch.triggerVar_218b, currMatch.unaryExprs_218c);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void AddLastTrigger_2158::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::BinaryExprs newDot_2191= SFC::BinaryExprs::Create( currMatch.unaryExprs_218c, SFC::UnaryExprs::meta_subexpr);
		SFC::ArgDeclRef newArgDeclRef2_2192= SFC::ArgDeclRef::Create( newDot_2191, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef1_2193= SFC::ArgDeclRef::Create( newDot_2191, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef& ArgDeclRef1= newArgDeclRef1_2193;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_2192;
		SFC::BinaryExprs& Dot= newDot_2191;
		SFC::LocalVar& Member= currMatch.member_218a;
		SFC::Struct& Struct= currMatch.struct_2189;
		SFC::LocalVar& TriggerVar= currMatch.triggerVar_218b;
		SFC::UnaryExprs& UnaryExprs= currMatch.unaryExprs_218c;
		{
Dot.op() = ".";
};
		newArgDeclRef1_2193.argdecl()= currMatch.member_218a;
		newArgDeclRef2_2192.argdecl()= currMatch.triggerVar_218b;
	}
}

void StartCondition_21ad::operator()( const Packets_t& structs_21ae, const Packets_t& triggerVars_21b1, const Packets_t& userCodes_21b4, Packets_t& structs_21b0, Packets_t& triggerVars_21b3, Packets_t& unaryExprss_21b6)
{
#ifdef PRINT_INFO
	printLog("StartCondition_21ad" );
#endif
	RTTGenerator::Instance()->generateRule(2181, "StartCondition");
	_struct_21b7= &structs_21b0;
	_triggerVar_21b8= &triggerVars_21b3;
	_unaryExprs_21b9= &unaryExprss_21b6;
	processInputPackets( structs_21ae, triggerVars_21b1, userCodes_21b4);
}

bool StartCondition_21ad::isInputUnique( const Udm::Object& struct_21be, const Udm::Object& triggerVar_21c7, const Udm::Object& userCode_21d0)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itStruct_21c0= _struct_21ba.begin(), itTriggerVar_21c9= _triggerVar_21c3.begin(), itUserCode_21d2= _userCode_21cc.begin(); itStruct_21c0!= _struct_21ba.end(), itTriggerVar_21c9!= _triggerVar_21c3.end(), itUserCode_21d2!= _userCode_21cc.end(); ++itStruct_21c0, ++itTriggerVar_21c9, ++itUserCode_21d2)
	{
		if( ( *itStruct_21c0== struct_21be)&& ( *itTriggerVar_21c9== triggerVar_21c7)&& ( *itUserCode_21d2== userCode_21d0))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_struct_21ba.push_back( struct_21be);
		_triggerVar_21c3.push_back( triggerVar_21c7);
		_userCode_21cc.push_back( userCode_21d0);
	}
	return isUnique;
}

bool StartCondition_21ad::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void StartCondition_21ad::processInputPackets( const Packets_t& structs_21ae, const Packets_t& triggerVars_21b1, const Packets_t& userCodes_21b4)
{
	for( Packets_t::const_iterator itStruct_21bb= structs_21ae.begin(), itTriggerVar_21c4= triggerVars_21b1.begin(), itUserCode_21cd= userCodes_21b4.begin(); itStruct_21bb!= structs_21ae.end(), itTriggerVar_21c4!= triggerVars_21b1.end(), itUserCode_21cd!= userCodes_21b4.end(); ++itStruct_21bb, ++itTriggerVar_21c4, ++itUserCode_21cd)
	{
		bool isUnique= isInputUnique( *itStruct_21bb, *itTriggerVar_21c4, *itUserCode_21cd);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itStruct_21bb, *itTriggerVar_21c4, *itUserCode_21cd);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool StartCondition_21ad::patternMatcher( const Udm::Object& struct_21bc, const Udm::Object& triggerVar_21c5, const Udm::Object& userCode_21ce)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( struct_21bc.type(), SFC::Struct::meta))
			continue;
		SFC::Struct struct_21c1= SFC::Struct::Cast( struct_21bc);
		if( false== Uml::IsDerivedFrom( triggerVar_21c5.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar triggerVar_21ca= SFC::LocalVar::Cast( triggerVar_21c5);
		if( false== Uml::IsDerivedFrom( userCode_21ce.type(), SFC::UserCode::meta))
			continue;
		SFC::UserCode userCode_21d3= SFC::UserCode::Cast( userCode_21ce);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_21d8;
		if( !isValidBound(boundObjs_21d8, struct_21c1, true))
			continue;
		currMatch.struct_21d9= struct_21c1;
		if( !isValidBound(boundObjs_21d8, triggerVar_21ca, true))
			continue;
		currMatch.triggerVar_21da= triggerVar_21ca;
		if( !isValidBound(boundObjs_21d8, userCode_21d3, true))
			continue;
		currMatch.userCode_21db= userCode_21d3;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void StartCondition_21ad::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::UnaryExprs newUnaryExprs_21dc= SFC::UnaryExprs::Create( currMatch.userCode_21db, SFC::UserCode::meta_codeexpr);
		SFC::Struct& Struct= currMatch.struct_21d9;
		SFC::LocalVar& TriggerVar= currMatch.triggerVar_21da;
		SFC::UnaryExprs& UnaryExprs= newUnaryExprs_21dc;
		SFC::UserCode& UserCode= currMatch.userCode_21db;
		{
UnaryExprs.op() = "";
};
		outputAppender( currMatch.struct_21d9, currMatch.triggerVar_21da, newUnaryExprs_21dc);
	}
}

void StartCondition_21ad::outputAppender( const SFC::Struct& struct_21dd, const SFC::LocalVar& triggerVar_21df, const SFC::UnaryExprs& unaryExprs_21e1)
{
	_struct_21b7->push_back( struct_21dd);
	_triggerVar_21b8->push_back( triggerVar_21df);
	_unaryExprs_21b9->push_back( unaryExprs_21e1);
}

void AddStateVar_21fe::operator()( const Packets_t& subsystems_21ff, const Packets_t& triggerPorts_2202, const Packets_t& argDeclBases_2205, const Packets_t& dTs_2209, const Packets_t& functions_220d, Packets_t& subsystems_2201, Packets_t& triggerPorts_2204, Packets_t& argDeclBases_2207, Packets_t& localVars_2208, Packets_t& dTs_220b, Packets_t& args_220c, Packets_t& functions_220f)
{
#ifdef PRINT_INFO
	printLog("AddStateVar_21fe" );
#endif
	RTTGenerator::Instance()->generateRule(2188, "AddStateVar");
	_subsystem_2210= &subsystems_2201;
	_triggerPort_2211= &triggerPorts_2204;
	_argDeclBase_2212= &argDeclBases_2207;
	_localVar_2213= &localVars_2208;
	_dT_2214= &dTs_220b;
	_arg_2215= &args_220c;
	_function_2216= &functions_220f;
	processInputPackets( subsystems_21ff, triggerPorts_2202, argDeclBases_2205, dTs_2209, functions_220d);
}

bool AddStateVar_21fe::isInputUnique( const Udm::Object& subsystem_221b, const Udm::Object& triggerPort_2224, const Udm::Object& argDeclBase_222d, const Udm::Object& dT_2236, const Udm::Object& function_223f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itSubsystem_221d= _subsystem_2217.begin(), itTriggerPort_2226= _triggerPort_2220.begin(), itArgDeclBase_222f= _argDeclBase_2229.begin(), itDT_2238= _dT_2232.begin(), itFunction_2241= _function_223b.begin(); itSubsystem_221d!= _subsystem_2217.end(), itTriggerPort_2226!= _triggerPort_2220.end(), itArgDeclBase_222f!= _argDeclBase_2229.end(), itDT_2238!= _dT_2232.end(), itFunction_2241!= _function_223b.end(); ++itSubsystem_221d, ++itTriggerPort_2226, ++itArgDeclBase_222f, ++itDT_2238, ++itFunction_2241)
	{
		if( ( *itSubsystem_221d== subsystem_221b)&& ( *itTriggerPort_2226== triggerPort_2224)&& ( *itArgDeclBase_222f== argDeclBase_222d)&& ( *itDT_2238== dT_2236)&& ( *itFunction_2241== function_223f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_subsystem_2217.push_back( subsystem_221b);
		_triggerPort_2220.push_back( triggerPort_2224);
		_argDeclBase_2229.push_back( argDeclBase_222d);
		_dT_2232.push_back( dT_2236);
		_function_223b.push_back( function_223f);
	}
	return isUnique;
}

bool AddStateVar_21fe::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void AddStateVar_21fe::processInputPackets( const Packets_t& subsystems_21ff, const Packets_t& triggerPorts_2202, const Packets_t& argDeclBases_2205, const Packets_t& dTs_2209, const Packets_t& functions_220d)
{
	for( Packets_t::const_iterator itSubsystem_2218= subsystems_21ff.begin(), itTriggerPort_2221= triggerPorts_2202.begin(), itArgDeclBase_222a= argDeclBases_2205.begin(), itDT_2233= dTs_2209.begin(), itFunction_223c= functions_220d.begin(); itSubsystem_2218!= subsystems_21ff.end(), itTriggerPort_2221!= triggerPorts_2202.end(), itArgDeclBase_222a!= argDeclBases_2205.end(), itDT_2233!= dTs_2209.end(), itFunction_223c!= functions_220d.end(); ++itSubsystem_2218, ++itTriggerPort_2221, ++itArgDeclBase_222a, ++itDT_2233, ++itFunction_223c)
	{
		bool isUnique= isInputUnique( *itSubsystem_2218, *itTriggerPort_2221, *itArgDeclBase_222a, *itDT_2233, *itFunction_223c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itSubsystem_2218, *itTriggerPort_2221, *itArgDeclBase_222a, *itDT_2233, *itFunction_223c);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool AddStateVar_21fe::patternMatcher( const Udm::Object& subsystem_2219, const Udm::Object& triggerPort_2222, const Udm::Object& argDeclBase_222b, const Udm::Object& dT_2234, const Udm::Object& function_223d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( subsystem_2219.type(), CyPhyML::SignalFlow::Subsystem::meta))
			continue;
		CyPhyML::SignalFlow::Subsystem subsystem_221e= CyPhyML::SignalFlow::Subsystem::Cast( subsystem_2219);
		if( false== Uml::IsDerivedFrom( triggerPort_2222.type(), CyPhyML::SignalFlow::TriggerPort::meta))
			continue;
		CyPhyML::SignalFlow::TriggerPort triggerPort_2227= CyPhyML::SignalFlow::TriggerPort::Cast( triggerPort_2222);
		if( false== Uml::IsDerivedFrom( argDeclBase_222b.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_2230= SFC::ArgDeclBase::Cast( argDeclBase_222b);
		if( false== Uml::IsDerivedFrom( dT_2234.type(), SFC::DT::meta))
			continue;
		SFC::DT dT_2239= SFC::DT::Cast( dT_2234);
		if( false== Uml::IsDerivedFrom( function_223d.type(), SFC::Function::meta))
			continue;
		SFC::Function function_2242= SFC::Function::Cast( function_223d);
		set< SFC::Arg> args_2244= function_2242.Arg_kind_children();
		for( set< SFC::Arg>::const_iterator itArg_2245= args_2244.begin(); itArg_2245!= args_2244.end(); ++itArg_2245)
		{
			SFC::Arg currArg_2246= *itArg_2245;
			Udm::Object functionParent_2247= function_2242.container();
			if( false== Uml::IsDerivedFrom( functionParent_2247.type(), SFC::Class::meta))
				continue;
			SFC::Class classFunction_2248= SFC::Class::Cast( functionParent_2247);
			set< SFC::Struct> structs_2249= classFunction_2248.Struct_kind_children();
			for( set< SFC::Struct>::const_iterator itStruct_224a= structs_2249.begin(); itStruct_224a!= structs_2249.end(); ++itStruct_224a)
			{
				SFC::Struct currStruct_224b= *itStruct_224a;
				SFC::DT struct_224c= currArg_2246.dt();
				if(!struct_224c || false== Uml::IsDerivedFrom( struct_224c.type(), SFC::Struct::meta))
					continue;
				SFC::Struct struct_224d= SFC::Struct::Cast( struct_224c);
				if( !struct_224d)
					continue;
				if( currStruct_224b!= struct_224d)
					continue;
				Match currMatch;
				set< pair<int, Udm::Object> > boundObjs_2251;
				if( !isValidBound(boundObjs_2251, subsystem_221e, true))
					continue;
				currMatch.subsystem_2252= subsystem_221e;
				if( !isValidBound(boundObjs_2251, triggerPort_2227, true))
					continue;
				currMatch.triggerPort_2253= triggerPort_2227;
				if( !isValidBound(boundObjs_2251, argDeclBase_2230, true))
					continue;
				currMatch.argDeclBase_2254= argDeclBase_2230;
				if( !isValidBound(boundObjs_2251, dT_2239, true))
					continue;
				currMatch.dT_2255= dT_2239;
				if( !isValidBound(boundObjs_2251, function_2242, true))
					continue;
				currMatch.function_2256= function_2242;
				if( !isValidBound(boundObjs_2251, currArg_2246, false))
					continue;
				currMatch.arg_2257= currArg_2246;
				if( !isValidBound(boundObjs_2251, currStruct_224b, false))
					continue;
				currMatch.struct_2258= currStruct_224b;
				if( !isValidBound(boundObjs_2251, classFunction_2248, false))
					continue;
				currMatch.class_2259= classFunction_2248;
				_matches.push_back( currMatch);
			}
		}
	}
	return !_matches.empty();
}

void AddStateVar_21fe::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar newLocalVar_225a= SFC::LocalVar::Create( currMatch.struct_2258, SFC::Struct::meta_memb);
		SFC::Arg& Arg= currMatch.arg_2257;
		SFC::ArgDeclBase& ArgDeclBase= currMatch.argDeclBase_2254;
		SFC::Class& Class= currMatch.class_2259;
		SFC::DT& DT= currMatch.dT_2255;
		SFC::Function& Function= currMatch.function_2256;
		SFC::LocalVar& LocalVar= newLocalVar_225a;
		SFC::Struct& Struct= currMatch.struct_2258;
		CyPhyML::SignalFlow::Subsystem& Subsystem= currMatch.subsystem_2252;
		CyPhyML::SignalFlow::TriggerPort& TriggerPort= currMatch.triggerPort_2253;
		{
__int64 memberCount = Struct.memberCount();
LocalVar.statementIndex() = memberCount++;
Struct.memberCount() = memberCount;

LocalVar.name() = "triggerData" + boost::lexical_cast< std::string >( LocalVar.uniqueId() );
};
		newLocalVar_225a.trig()+= currMatch.triggerPort_2253;
		newLocalVar_225a.dt()= currMatch.dT_2255;
		outputAppender( currMatch.subsystem_2252, currMatch.triggerPort_2253, currMatch.argDeclBase_2254, newLocalVar_225a, currMatch.dT_2255, currMatch.arg_2257, currMatch.function_2256);
	}
}

void AddStateVar_21fe::outputAppender( const CyPhyML::SignalFlow::Subsystem& subsystem_225b, const CyPhyML::SignalFlow::TriggerPort& triggerPort_225d, const SFC::ArgDeclBase& argDeclBase_225f, const SFC::LocalVar& localVar_2261, const SFC::DT& dT_2263, const SFC::Arg& arg_2265, const SFC::Function& function_2267)
{
	_subsystem_2210->push_back( subsystem_225b);
	_triggerPort_2211->push_back( triggerPort_225d);
	_argDeclBase_2212->push_back( argDeclBase_225f);
	_localVar_2213->push_back( localVar_2261);
	_dT_2214->push_back( dT_2263);
	_arg_2215->push_back( arg_2265);
	_function_2216->push_back( function_2267);
}

void SaveState_2269::operator()( const Packets_t& systems_226a, const Packets_t& triggers_226c, const Packets_t& argdecls_226e, const Packets_t& dts_2270, const Packets_t& oldvals_2272, const Packets_t& contexts_2274, const Packets_t& functions_2276, Packets_t& systems_2278, Packets_t& triggers_2279, Packets_t& dts_227a, Packets_t& oldvals_227b, Packets_t& functions_227c)
{
#ifdef PRINT_INFO
	printLog("SaveState_2269" );
#endif
	_system_227d= &systems_2278;
	_trigger_227e= &triggers_2279;
	_dt_227f= &dts_227a;
	_oldval_2280= &oldvals_227b;
	_function_2281= &functions_227c;
	if( ( !argdecls_226e.empty())&& ( !dts_2270.empty())&& ( !oldvals_2272.empty())&& ( !contexts_2274.empty())&& ( !functions_2276.empty()))
		callSaveMatrixState_2349( argdecls_226e, dts_2270, oldvals_2272, contexts_2274, functions_2276);
	_system_227d->insert( _system_227d->end(), systems_226a.begin(), systems_226a.end());
	_trigger_227e->insert( _trigger_227e->end(), triggers_226c.begin(), triggers_226c.end());
	_dt_227f->insert( _dt_227f->end(), dts_2270.begin(), dts_2270.end());
	_oldval_2280->insert( _oldval_2280->end(), oldvals_2272.begin(), oldvals_2272.end());
	_function_2281->insert( _function_2281->end(), functions_2276.begin(), functions_2276.end());
}

void SaveState_2269::callSaveMatrixState_2349( const Packets_t& argdecls_2283, const Packets_t& dts_2285, const Packets_t& oldvals_2287, const Packets_t& contexts_2289, const Packets_t& functions_228b)
{
	Packets_t argdecls_228d;
	Packets_t dts_228e;
	Packets_t oldvals_228f;
	Packets_t contexts_2290;
	Packets_t functions_2291;
	SaveMatrixState_2282 saveMatrixState_2282;
	saveMatrixState_2282( argdecls_2283, dts_2285, oldvals_2287, contexts_2289, functions_228b, argdecls_228d, dts_228e, oldvals_228f, contexts_2290, functions_2291);
	if( ( !argdecls_228d.empty())&& ( !dts_228e.empty())&& ( !oldvals_228f.empty())&& ( !contexts_2290.empty())&& ( !functions_2291.empty()))
		callSaveStructState_234f( argdecls_228d, dts_228e, oldvals_228f, contexts_2290, functions_2291);
}

void SaveState_2269::callSaveStructState_234f( const Packets_t& argdecls_22ea, const Packets_t& dts_22ec, const Packets_t& oldvals_22ee, const Packets_t& contexts_22f0, const Packets_t& functions_22f2)
{
	SaveStructState_22e9 saveStructState_22e9;
	saveStructState_22e9( argdecls_22ea, dts_22ec, oldvals_22ee, contexts_22f0, functions_22f2);
}

void SaveMatrixState_2282::operator()( const Packets_t& argdecls_2283, const Packets_t& dts_2285, const Packets_t& oldvals_2287, const Packets_t& contexts_2289, const Packets_t& functions_228b, Packets_t& argdecls_228d, Packets_t& dts_228e, Packets_t& oldvals_228f, Packets_t& contexts_2290, Packets_t& functions_2291)
{
#ifdef PRINT_INFO
	printLog("SaveMatrixState_2282" );
#endif
	_argdecl_2292= &argdecls_228d;
	_dt_2293= &dts_228e;
	_oldval_2294= &oldvals_228f;
	_context_2295= &contexts_2290;
	_function_2296= &functions_2291;
	if( ( !argdecls_2283.empty())&& ( !dts_2285.empty())&& ( !oldvals_2287.empty())&& ( !contexts_2289.empty())&& ( !functions_228b.empty()))
		callSaveMatrixState_22e3( argdecls_2283, dts_2285, oldvals_2287, contexts_2289, functions_228b);
	_argdecl_2292->insert( _argdecl_2292->end(), argdecls_2283.begin(), argdecls_2283.end());
	_dt_2293->insert( _dt_2293->end(), dts_2285.begin(), dts_2285.end());
	_oldval_2294->insert( _oldval_2294->end(), oldvals_2287.begin(), oldvals_2287.end());
	_context_2295->insert( _context_2295->end(), contexts_2289.begin(), contexts_2289.end());
	_function_2296->insert( _function_2296->end(), functions_228b.begin(), functions_228b.end());
}

void SaveMatrixState_2282::callSaveMatrixState_22e3( const Packets_t& argDeclBases_2298, const Packets_t& dTs_229a, const Packets_t& localVars_229c, const Packets_t& args_229e, const Packets_t& functions_22a0)
{
	SaveMatrixState_2297 saveMatrixState_2297;
	saveMatrixState_2297( argDeclBases_2298, dTs_229a, localVars_229c, args_229e, functions_22a0);
}

void SaveMatrixState_2297::operator()( const Packets_t& argDeclBases_2298, const Packets_t& dTs_229a, const Packets_t& localVars_229c, const Packets_t& args_229e, const Packets_t& functions_22a0)
{
#ifdef PRINT_INFO
	printLog("SaveMatrixState_2297" );
#endif
	RTTGenerator::Instance()->generateRule(2230, "SaveMatrixState");
	processInputPackets( argDeclBases_2298, dTs_229a, localVars_229c, args_229e, functions_22a0);
}

bool SaveMatrixState_2297::isInputUnique( const Udm::Object& argDeclBase_22a6, const Udm::Object& dT_22af, const Udm::Object& localVar_22b8, const Udm::Object& arg_22c1, const Udm::Object& function_22ca)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itArgDeclBase_22a8= _argDeclBase_22a2.begin(), itDT_22b1= _dT_22ab.begin(), itLocalVar_22ba= _localVar_22b4.begin(), itArg_22c3= _arg_22bd.begin(), itFunction_22cc= _function_22c6.begin(); itArgDeclBase_22a8!= _argDeclBase_22a2.end(), itDT_22b1!= _dT_22ab.end(), itLocalVar_22ba!= _localVar_22b4.end(), itArg_22c3!= _arg_22bd.end(), itFunction_22cc!= _function_22c6.end(); ++itArgDeclBase_22a8, ++itDT_22b1, ++itLocalVar_22ba, ++itArg_22c3, ++itFunction_22cc)
	{
		if( ( *itArgDeclBase_22a8== argDeclBase_22a6)&& ( *itDT_22b1== dT_22af)&& ( *itLocalVar_22ba== localVar_22b8)&& ( *itArg_22c3== arg_22c1)&& ( *itFunction_22cc== function_22ca))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_argDeclBase_22a2.push_back( argDeclBase_22a6);
		_dT_22ab.push_back( dT_22af);
		_localVar_22b4.push_back( localVar_22b8);
		_arg_22bd.push_back( arg_22c1);
		_function_22c6.push_back( function_22ca);
	}
	return isUnique;
}

bool SaveMatrixState_2297::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool SaveMatrixState_2297::isGuardTrue( SFC::Arg& Arg, SFC::ArgDeclBase& ArgDeclBase, SFC::DT& DT, SFC::Function& Function, SFC::LocalVar& LocalVar)
{
	bool Gz_guard= false;
	Gz_guard = DT.type() != SFC::Struct::meta;;
	return Gz_guard;
}

void SaveMatrixState_2297::processInputPackets( const Packets_t& argDeclBases_2298, const Packets_t& dTs_229a, const Packets_t& localVars_229c, const Packets_t& args_229e, const Packets_t& functions_22a0)
{
	for( Packets_t::const_iterator itArgDeclBase_22a3= argDeclBases_2298.begin(), itDT_22ac= dTs_229a.begin(), itLocalVar_22b5= localVars_229c.begin(), itArg_22be= args_229e.begin(), itFunction_22c7= functions_22a0.begin(); itArgDeclBase_22a3!= argDeclBases_2298.end(), itDT_22ac!= dTs_229a.end(), itLocalVar_22b5!= localVars_229c.end(), itArg_22be!= args_229e.end(), itFunction_22c7!= functions_22a0.end(); ++itArgDeclBase_22a3, ++itDT_22ac, ++itLocalVar_22b5, ++itArg_22be, ++itFunction_22c7)
	{
		bool isUnique= isInputUnique( *itArgDeclBase_22a3, *itDT_22ac, *itLocalVar_22b5, *itArg_22be, *itFunction_22c7);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itArgDeclBase_22a3, *itDT_22ac, *itLocalVar_22b5, *itArg_22be, *itFunction_22c7);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool SaveMatrixState_2297::patternMatcher( const Udm::Object& argDeclBase_22a4, const Udm::Object& dT_22ad, const Udm::Object& localVar_22b6, const Udm::Object& arg_22bf, const Udm::Object& function_22c8)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( argDeclBase_22a4.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_22a9= SFC::ArgDeclBase::Cast( argDeclBase_22a4);
		if( false== Uml::IsDerivedFrom( dT_22ad.type(), SFC::DT::meta))
			continue;
		SFC::DT dT_22b2= SFC::DT::Cast( dT_22ad);
		if( false== Uml::IsDerivedFrom( localVar_22b6.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_22bb= SFC::LocalVar::Cast( localVar_22b6);
		if( false== Uml::IsDerivedFrom( arg_22bf.type(), SFC::Arg::meta))
			continue;
		SFC::Arg arg_22c4= SFC::Arg::Cast( arg_22bf);
		if( false== Uml::IsDerivedFrom( function_22c8.type(), SFC::Function::meta))
			continue;
		SFC::Function function_22cd= SFC::Function::Cast( function_22c8);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_22d2;
		if( !isValidBound(boundObjs_22d2, argDeclBase_22a9, true))
			continue;
		currMatch.argDeclBase_22d3= argDeclBase_22a9;
		if( !isValidBound(boundObjs_22d2, dT_22b2, true))
			continue;
		currMatch.dT_22d4= dT_22b2;
		if( !isValidBound(boundObjs_22d2, localVar_22bb, true))
			continue;
		currMatch.localVar_22d5= localVar_22bb;
		if( !isValidBound(boundObjs_22d2, arg_22c4, true))
			continue;
		currMatch.arg_22d6= arg_22c4;
		if( !isValidBound(boundObjs_22d2, function_22cd, true))
			continue;
		currMatch.function_22d7= function_22cd;
		bool Gz_guard= isGuardTrue( currMatch.arg_22d6, currMatch.argDeclBase_22d3, currMatch.dT_22d4, currMatch.function_22d7, currMatch.localVar_22d5);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void SaveMatrixState_2297::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::UserCode newUserCode_22dd= SFC::UserCode::Create( currMatch.function_22d7, SFC::Function::meta_stmnt);
		SFC::BinaryExprs newAssign_22de= SFC::BinaryExprs::Create( newUserCode_22dd, SFC::UserCode::meta_codeexpr);
		SFC::BinaryExprs newDot_22df= SFC::BinaryExprs::Create( newAssign_22de, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef3_22e0= SFC::ArgDeclRef::Create( newDot_22df, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef4_22e1= SFC::ArgDeclRef::Create( newDot_22df, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef2_22e2= SFC::ArgDeclRef::Create( newAssign_22de, SFC::BinaryExprs::meta_rightexpr);
		SFC::Arg& Arg= currMatch.arg_22d6;
		SFC::ArgDeclBase& ArgDeclBase= currMatch.argDeclBase_22d3;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_22e2;
		SFC::ArgDeclRef& ArgDeclRef3= newArgDeclRef3_22e0;
		SFC::ArgDeclRef& ArgDeclRef4= newArgDeclRef4_22e1;
		SFC::BinaryExprs& Assign= newAssign_22de;
		SFC::DT& DT= currMatch.dT_22d4;
		SFC::BinaryExprs& Dot= newDot_22df;
		SFC::Function& Function= currMatch.function_22d7;
		SFC::LocalVar& LocalVar= currMatch.localVar_22d5;
		SFC::UserCode& UserCode= newUserCode_22dd;
		{
__int64 statementCount = Function.statementCount();
UserCode.statementIndex() = statementCount++;
Function.statementCount() = statementCount;
};
		{
Assign.op() = "=";
};
		{
Dot.op() = ".";
};
		newArgDeclRef3_22e0.argdecl()= currMatch.localVar_22d5;
		newArgDeclRef4_22e1.argdecl()= currMatch.arg_22d6;
		newArgDeclRef2_22e2.argdecl()= currMatch.argDeclBase_22d3;
	}
}

void SaveStructState_22e9::operator()( const Packets_t& argdecls_22ea, const Packets_t& dts_22ec, const Packets_t& oldvals_22ee, const Packets_t& contexts_22f0, const Packets_t& functions_22f2)
{
#ifdef PRINT_INFO
	printLog("SaveStructState_22e9" );
#endif
	if( ( !argdecls_22ea.empty())&& ( !dts_22ec.empty())&& ( !oldvals_22ee.empty())&& ( !contexts_22f0.empty())&& ( !functions_22f2.empty()))
		callSaveStructState_2343( argdecls_22ea, dts_22ec, oldvals_22ee, contexts_22f0, functions_22f2);
}

void SaveStructState_22e9::callSaveStructState_2343( const Packets_t& argDeclBases_22f5, const Packets_t& structs_22f7, const Packets_t& localVars_22f9, const Packets_t& contexts_22fb, const Packets_t& functions_22fd)
{
	SaveStructState_22f4 saveStructState_22f4;
	saveStructState_22f4( argDeclBases_22f5, structs_22f7, localVars_22f9, contexts_22fb, functions_22fd);
}

void SaveStructState_22f4::operator()( const Packets_t& argDeclBases_22f5, const Packets_t& structs_22f7, const Packets_t& localVars_22f9, const Packets_t& contexts_22fb, const Packets_t& functions_22fd)
{
#ifdef PRINT_INFO
	printLog("SaveStructState_22f4" );
#endif
	RTTGenerator::Instance()->generateRule(2260, "SaveStructState");
	processInputPackets( argDeclBases_22f5, structs_22f7, localVars_22f9, contexts_22fb, functions_22fd);
}

bool SaveStructState_22f4::isInputUnique( const Udm::Object& argDeclBase_2303, const Udm::Object& struct_230c, const Udm::Object& localVar_2315, const Udm::Object& context_231e, const Udm::Object& function_2327)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itArgDeclBase_2305= _argDeclBase_22ff.begin(), itStruct_230e= _struct_2308.begin(), itLocalVar_2317= _localVar_2311.begin(), itContext_2320= _context_231a.begin(), itFunction_2329= _function_2323.begin(); itArgDeclBase_2305!= _argDeclBase_22ff.end(), itStruct_230e!= _struct_2308.end(), itLocalVar_2317!= _localVar_2311.end(), itContext_2320!= _context_231a.end(), itFunction_2329!= _function_2323.end(); ++itArgDeclBase_2305, ++itStruct_230e, ++itLocalVar_2317, ++itContext_2320, ++itFunction_2329)
	{
		if( ( *itArgDeclBase_2305== argDeclBase_2303)&& ( *itStruct_230e== struct_230c)&& ( *itLocalVar_2317== localVar_2315)&& ( *itContext_2320== context_231e)&& ( *itFunction_2329== function_2327))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_argDeclBase_22ff.push_back( argDeclBase_2303);
		_struct_2308.push_back( struct_230c);
		_localVar_2311.push_back( localVar_2315);
		_context_231a.push_back( context_231e);
		_function_2323.push_back( function_2327);
	}
	return isUnique;
}

bool SaveStructState_22f4::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void SaveStructState_22f4::processInputPackets( const Packets_t& argDeclBases_22f5, const Packets_t& structs_22f7, const Packets_t& localVars_22f9, const Packets_t& contexts_22fb, const Packets_t& functions_22fd)
{
	for( Packets_t::const_iterator itArgDeclBase_2300= argDeclBases_22f5.begin(), itStruct_2309= structs_22f7.begin(), itLocalVar_2312= localVars_22f9.begin(), itContext_231b= contexts_22fb.begin(), itFunction_2324= functions_22fd.begin(); itArgDeclBase_2300!= argDeclBases_22f5.end(), itStruct_2309!= structs_22f7.end(), itLocalVar_2312!= localVars_22f9.end(), itContext_231b!= contexts_22fb.end(), itFunction_2324!= functions_22fd.end(); ++itArgDeclBase_2300, ++itStruct_2309, ++itLocalVar_2312, ++itContext_231b, ++itFunction_2324)
	{
		bool isUnique= isInputUnique( *itArgDeclBase_2300, *itStruct_2309, *itLocalVar_2312, *itContext_231b, *itFunction_2324);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itArgDeclBase_2300, *itStruct_2309, *itLocalVar_2312, *itContext_231b, *itFunction_2324);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool SaveStructState_22f4::patternMatcher( const Udm::Object& argDeclBase_2301, const Udm::Object& struct_230a, const Udm::Object& localVar_2313, const Udm::Object& context_231c, const Udm::Object& function_2325)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( argDeclBase_2301.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_2306= SFC::ArgDeclBase::Cast( argDeclBase_2301);
		if( false== Uml::IsDerivedFrom( struct_230a.type(), SFC::Struct::meta))
			continue;
		SFC::Struct struct_230f= SFC::Struct::Cast( struct_230a);
		if( false== Uml::IsDerivedFrom( localVar_2313.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_2318= SFC::LocalVar::Cast( localVar_2313);
		if( false== Uml::IsDerivedFrom( context_231c.type(), SFC::Arg::meta))
			continue;
		SFC::Arg context_2321= SFC::Arg::Cast( context_231c);
		if( false== Uml::IsDerivedFrom( function_2325.type(), SFC::Function::meta))
			continue;
		SFC::Function function_232a= SFC::Function::Cast( function_2325);
		set< SFC::LocalVar> members_232c= struct_230f.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itMember_232d= members_232c.begin(); itMember_232d!= members_232c.end(); ++itMember_232d)
		{
			SFC::LocalVar currMember_232e= *itMember_232d;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_2332;
			if( !isValidBound(boundObjs_2332, argDeclBase_2306, true))
				continue;
			currMatch.argDeclBase_2333= argDeclBase_2306;
			if( !isValidBound(boundObjs_2332, struct_230f, true))
				continue;
			currMatch.struct_2334= struct_230f;
			if( !isValidBound(boundObjs_2332, localVar_2318, true))
				continue;
			currMatch.localVar_2335= localVar_2318;
			if( !isValidBound(boundObjs_2332, context_2321, true))
				continue;
			currMatch.context_2336= context_2321;
			if( !isValidBound(boundObjs_2332, function_232a, true))
				continue;
			currMatch.function_2337= function_232a;
			if( !isValidBound(boundObjs_2332, currMember_232e, false))
				continue;
			currMatch.member_2338= currMember_232e;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void SaveStructState_22f4::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::UserCode newUserCode_2339= SFC::UserCode::Create( currMatch.function_2337);
		SFC::BinaryExprs newAssign_233a= SFC::BinaryExprs::Create( newUserCode_2339, SFC::UserCode::meta_codeexpr);
		SFC::BinaryExprs newMemberDot_233b= SFC::BinaryExprs::Create( newAssign_233a, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newMemberRef3_233c= SFC::ArgDeclRef::Create( newMemberDot_233b, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs newContextDot_233d= SFC::BinaryExprs::Create( newMemberDot_233b, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef3_233e= SFC::ArgDeclRef::Create( newContextDot_233d, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef4_233f= SFC::ArgDeclRef::Create( newContextDot_233d, SFC::BinaryExprs::meta_leftexpr);
		SFC::BinaryExprs newArgDeclDot2_2340= SFC::BinaryExprs::Create( newAssign_233a, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newMemberRef2_2341= SFC::ArgDeclRef::Create( newArgDeclDot2_2340, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef2_2342= SFC::ArgDeclRef::Create( newArgDeclDot2_2340, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclBase& ArgDeclBase= currMatch.argDeclBase_2333;
		SFC::BinaryExprs& ArgDeclDot2= newArgDeclDot2_2340;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_2342;
		SFC::ArgDeclRef& ArgDeclRef3= newArgDeclRef3_233e;
		SFC::ArgDeclRef& ArgDeclRef4= newArgDeclRef4_233f;
		SFC::BinaryExprs& Assign= newAssign_233a;
		SFC::Arg& Context= currMatch.context_2336;
		SFC::BinaryExprs& ContextDot= newContextDot_233d;
		SFC::Function& Function= currMatch.function_2337;
		SFC::LocalVar& LocalVar= currMatch.localVar_2335;
		SFC::LocalVar& Member= currMatch.member_2338;
		SFC::BinaryExprs& MemberDot= newMemberDot_233b;
		SFC::ArgDeclRef& MemberRef2= newMemberRef2_2341;
		SFC::ArgDeclRef& MemberRef3= newMemberRef3_233c;
		SFC::Struct& Struct= currMatch.struct_2334;
		SFC::UserCode& UserCode= newUserCode_2339;
		{
ContextDot.op() = ".";
};
		{
__int64 statementCount = Function.statementCount();
UserCode.statementIndex() = statementCount++;
Function.statementCount() = statementCount;
};
		{
Assign.op() = "=";
};
		{
MemberDot.op() = ".";
};
		{
ArgDeclDot2.op() = ".";
};
		newArgDeclRef4_233f.argdecl()= currMatch.context_2336;
		newArgDeclRef2_2342.argdecl()= currMatch.argDeclBase_2333;
		newArgDeclRef3_233e.argdecl()= currMatch.localVar_2335;
		newMemberRef3_233c.argdecl()= currMatch.member_2338;
		newMemberRef2_2341.argdecl()= currMatch.member_2338;
	}
}

void AddTriggerVars_2355::operator()( const Packets_t& systems_2356, const Packets_t& triggers_2358, const Packets_t& argdecls_235a, const Packets_t& dts_235c, const Packets_t& oldvals_235e, const Packets_t& contexts_2360, const Packets_t& functions_2362, Packets_t& systems_2364, Packets_t& triggers_2365, Packets_t& argdecls_2366, Packets_t& dts_2367, Packets_t& oldvals_2368, Packets_t& contexts_2369, Packets_t& functions_236a)
{
#ifdef PRINT_INFO
	printLog("AddTriggerVars_2355" );
#endif
	_system_236b= &systems_2364;
	_trigger_236c= &triggers_2365;
	_argdecl_236d= &argdecls_2366;
	_dt_236e= &dts_2367;
	_oldval_236f= &oldvals_2368;
	_context_2370= &contexts_2369;
	_function_2371= &functions_236a;
	_system_236b->insert( _system_236b->end(), systems_2356.begin(), systems_2356.end());
	_trigger_236c->insert( _trigger_236c->end(), triggers_2358.begin(), triggers_2358.end());
	_argdecl_236d->insert( _argdecl_236d->end(), argdecls_235a.begin(), argdecls_235a.end());
	_dt_236e->insert( _dt_236e->end(), dts_235c.begin(), dts_235c.end());
	_oldval_236f->insert( _oldval_236f->end(), oldvals_235e.begin(), oldvals_235e.end());
	_context_2370->insert( _context_2370->end(), contexts_2360.begin(), contexts_2360.end());
	_function_2371->insert( _function_2371->end(), functions_2362.begin(), functions_2362.end());
	if( ( !triggers_2358.empty())&& ( !argdecls_235a.empty())&& ( !dts_235c.empty())&& ( !oldvals_235e.empty())&& ( !contexts_2360.empty())&& ( !functions_2362.empty()))
		callAddMatrixTriggerVars_2a41( triggers_2358, argdecls_235a, dts_235c, oldvals_235e, contexts_2360, functions_2362);
}

void AddTriggerVars_2355::callAddMatrixTriggerVars_2a41( const Packets_t& triggers_271b, const Packets_t& argdecls_271d, const Packets_t& dts_271f, const Packets_t& oldvals_2721, const Packets_t& contexts_2723, const Packets_t& functions_2725)
{
	Packets_t triggers_2727;
	Packets_t argdecls_2728;
	Packets_t dts_2729;
	Packets_t oldvals_272a;
	Packets_t contexts_272b;
	Packets_t functions_272c;
	AddMatrixTriggerVars_271a addMatrixTriggerVars_271a;
	addMatrixTriggerVars_271a( triggers_271b, argdecls_271d, dts_271f, oldvals_2721, contexts_2723, functions_2725, triggers_2727, argdecls_2728, dts_2729, oldvals_272a, contexts_272b, functions_272c);
	if( ( !triggers_2727.empty())&& ( !argdecls_2728.empty())&& ( !dts_2729.empty())&& ( !oldvals_272a.empty())&& ( !contexts_272b.empty())&& ( !functions_272c.empty()))
		callAddStructTriggerVars_2a48( triggers_2727, argdecls_2728, dts_2729, oldvals_272a, contexts_272b, functions_272c);
}

void AddTriggerVars_2355::callAddStructTriggerVars_2a48( const Packets_t& triggers_2373, const Packets_t& argdecls_2375, const Packets_t& dts_2377, const Packets_t& oldvals_2379, const Packets_t& contexts_237b, const Packets_t& functions_237d)
{
	AddStructTriggerVars_2372 addStructTriggerVars_2372;
	addStructTriggerVars_2372( triggers_2373, argdecls_2375, dts_2377, oldvals_2379, contexts_237b, functions_237d);
}

void AddStructTriggerVars_2372::operator()( const Packets_t& triggers_2373, const Packets_t& argdecls_2375, const Packets_t& dts_2377, const Packets_t& oldvals_2379, const Packets_t& contexts_237b, const Packets_t& functions_237d)
{
#ifdef PRINT_INFO
	printLog("AddStructTriggerVars_2372" );
#endif
	if( ( !triggers_2373.empty())&& ( !argdecls_2375.empty())&& ( !dts_2377.empty())&& ( !oldvals_2379.empty())&& ( !contexts_237b.empty())&& ( !functions_237d.empty()))
		callAddTriggerVar_26e6( triggers_2373, argdecls_2375, dts_2377, oldvals_2379, contexts_237b, functions_237d);
}

void AddStructTriggerVars_2372::callAddTriggerVar_26e6( const Packets_t& triggerPorts_23fb, const Packets_t& argDeclBases_23fe, const Packets_t& structs_2401, const Packets_t& localVars_2404, const Packets_t& contexts_2407, const Packets_t& functions_240b)
{
	Packets_t triggerPorts_23fd;
	Packets_t argDeclBases_2400;
	Packets_t structs_2403;
	Packets_t localVars_2406;
	Packets_t contexts_2409;
	Packets_t triggerVars_240a;
	Packets_t functions_240d;
	AddTriggerVar_23fa addTriggerVar_23fa;
	addTriggerVar_23fa( triggerPorts_23fb, argDeclBases_23fe, structs_2401, localVars_2404, contexts_2407, functions_240b, triggerPorts_23fd, argDeclBases_2400, structs_2403, localVars_2406, contexts_2409, triggerVars_240a, functions_240d);
	if( ( !triggerPorts_23fd.empty())&& ( !argDeclBases_2400.empty())&& ( !structs_2403.empty())&& ( !localVars_2406.empty())&& ( !contexts_2409.empty())&& ( !triggerVars_240a.empty())&& ( !functions_240d.empty()))
		callStartAssignment_26ed( triggerPorts_23fd, argDeclBases_2400, structs_2403, localVars_2406, contexts_2409, triggerVars_240a, functions_240d);
}

void AddStructTriggerVars_2372::callStartAssignment_26ed( const Packets_t& triggerPorts_2380, const Packets_t& argDeclBases_2383, const Packets_t& structs_2387, const Packets_t& oldvals_2389, const Packets_t& contexts_238c, const Packets_t& triggerVars_238f, const Packets_t& functions_2391)
{
	Packets_t triggerPorts_2382;
	Packets_t argDeclBases_2385;
	Packets_t localVars_2386;
	Packets_t oldvals_238b;
	Packets_t contexts_238e;
	Packets_t unaryExprss_2393;
	StartAssignment_237f startAssignment_237f;
	startAssignment_237f( triggerPorts_2380, argDeclBases_2383, structs_2387, oldvals_2389, contexts_238c, triggerVars_238f, functions_2391, triggerPorts_2382, argDeclBases_2385, localVars_2386, oldvals_238b, contexts_238e, unaryExprss_2393);
	if( ( !triggerPorts_2382.empty())&& ( !argDeclBases_2385.empty())&& ( !localVars_2386.empty())&& ( !oldvals_238b.empty())&& ( !contexts_238e.empty())&& ( !unaryExprss_2393.empty()))
		callEdgeTest_26f5( triggerPorts_2382, argDeclBases_2385, localVars_2386, oldvals_238b, contexts_238e, unaryExprss_2393);
}

void AddStructTriggerVars_2372::callEdgeTest_26f5( const Packets_t& triggers_2465, const Packets_t& argdecls_2467, const Packets_t& members_2469, const Packets_t& oldvals_246b, const Packets_t& contexts_246d, const Packets_t& initexprs_246f)
{
	Packets_t argdecls_2471;
	Packets_t members_2472;
	Packets_t oldvals_2473;
	Packets_t contexts_2474;
	Packets_t initexprs_2475;
	Packets_t argdecls_2476;
	Packets_t members_2477;
	Packets_t oldvals_2478;
	Packets_t contexts_2479;
	Packets_t initexprs_247a;
	Packets_t argdecls_247b;
	Packets_t members_247c;
	Packets_t oldvals_247d;
	Packets_t contexts_247e;
	Packets_t initexprs_247f;
	EdgeTest_2464 edgeTest_2464;
	edgeTest_2464( triggers_2465, argdecls_2467, members_2469, oldvals_246b, contexts_246d, initexprs_246f, argdecls_2471, members_2472, oldvals_2473, contexts_2474, initexprs_2475, argdecls_2476, members_2477, oldvals_2478, contexts_2479, initexprs_247a, argdecls_247b, members_247c, oldvals_247d, contexts_247e, initexprs_247f);
	if( ( !argdecls_2471.empty())&& ( !members_2472.empty())&& ( !oldvals_2473.empty())&& ( !contexts_2474.empty())&& ( !initexprs_2475.empty()))
		callRisingEdge_26fc( argdecls_2471, members_2472, oldvals_2473, contexts_2474, initexprs_2475);
	if( ( !argdecls_2476.empty())&& ( !members_2477.empty())&& ( !oldvals_2478.empty())&& ( !contexts_2479.empty())&& ( !initexprs_247a.empty()))
		callFallingEdge_2702( argdecls_2476, members_2477, oldvals_2478, contexts_2479, initexprs_247a);
	if( ( !argdecls_247b.empty())&& ( !members_247c.empty())&& ( !oldvals_247d.empty())&& ( !contexts_247e.empty())&& ( !initexprs_247f.empty()))
		callEitherEdge_2708( argdecls_247b, members_247c, oldvals_247d, contexts_247e, initexprs_247f);
}

void AddStructTriggerVars_2372::callRisingEdge_26fc( const Packets_t& argDeclBases_25ef, const Packets_t& members_25f1, const Packets_t& localVars_25f3, const Packets_t& contexts_25f5, const Packets_t& unaryExprss_25f7)
{
	RisingEdge_25ee risingEdge_25ee;
	risingEdge_25ee( argDeclBases_25ef, members_25f1, localVars_25f3, contexts_25f5, unaryExprss_25f7);
}

void AddStructTriggerVars_2372::callFallingEdge_2702( const Packets_t& argDeclBases_263d, const Packets_t& members_263f, const Packets_t& localVars_2641, const Packets_t& contexts_2643, const Packets_t& unaryExprss_2645)
{
	FallingEdge_263c fallingEdge_263c;
	fallingEdge_263c( argDeclBases_263d, members_263f, localVars_2641, contexts_2643, unaryExprss_2645);
}

void AddStructTriggerVars_2372::callEitherEdge_2708( const Packets_t& argDeclBases_268b, const Packets_t& members_268e, const Packets_t& localVars_2691, const Packets_t& contexts_2694, const Packets_t& unaryExprss_2697)
{
	Packets_t argDeclBases_268d;
	Packets_t members_2690;
	Packets_t localVars_2693;
	Packets_t contexts_2696;
	Packets_t leftUnaryExprss_2699;
	Packets_t rightUnaryExprss_269a;
	EitherEdge_268a eitherEdge_268a;
	eitherEdge_268a( argDeclBases_268b, members_268e, localVars_2691, contexts_2694, unaryExprss_2697, argDeclBases_268d, members_2690, localVars_2693, contexts_2696, leftUnaryExprss_2699, rightUnaryExprss_269a);
	if( ( !argDeclBases_268d.empty())&& ( !members_2690.empty())&& ( !localVars_2693.empty())&& ( !contexts_2696.empty())&& ( !leftUnaryExprss_2699.empty()))
		callRisingEdge_270e( argDeclBases_268d, members_2690, localVars_2693, contexts_2696, leftUnaryExprss_2699);
	if( ( !argDeclBases_268d.empty())&& ( !members_2690.empty())&& ( !localVars_2693.empty())&& ( !contexts_2696.empty())&& ( !rightUnaryExprss_269a.empty()))
		callFallingEdge_2714( argDeclBases_268d, members_2690, localVars_2693, contexts_2696, rightUnaryExprss_269a);
}

void AddStructTriggerVars_2372::callRisingEdge_270e( const Packets_t& argDeclBases_25ef, const Packets_t& members_25f1, const Packets_t& localVars_25f3, const Packets_t& contexts_25f5, const Packets_t& unaryExprss_25f7)
{
	RisingEdge_25ee risingEdge_25ee;
	risingEdge_25ee( argDeclBases_25ef, members_25f1, localVars_25f3, contexts_25f5, unaryExprss_25f7);
}

void AddStructTriggerVars_2372::callFallingEdge_2714( const Packets_t& argDeclBases_263d, const Packets_t& members_263f, const Packets_t& localVars_2641, const Packets_t& contexts_2643, const Packets_t& unaryExprss_2645)
{
	FallingEdge_263c fallingEdge_263c;
	fallingEdge_263c( argDeclBases_263d, members_263f, localVars_2641, contexts_2643, unaryExprss_2645);
}

void StartAssignment_237f::operator()( const Packets_t& triggerPorts_2380, const Packets_t& argDeclBases_2383, const Packets_t& structs_2387, const Packets_t& oldvals_2389, const Packets_t& contexts_238c, const Packets_t& triggerVars_238f, const Packets_t& functions_2391, Packets_t& triggerPorts_2382, Packets_t& argDeclBases_2385, Packets_t& localVars_2386, Packets_t& oldvals_238b, Packets_t& contexts_238e, Packets_t& unaryExprss_2393)
{
#ifdef PRINT_INFO
	printLog("StartAssignment_237f" );
#endif
	RTTGenerator::Instance()->generateRule(2320, "StartAssignment");
	_triggerPort_2394= &triggerPorts_2382;
	_argDeclBase_2395= &argDeclBases_2385;
	_localVar_2396= &localVars_2386;
	_oldval_2397= &oldvals_238b;
	_context_2398= &contexts_238e;
	_unaryExprs_2399= &unaryExprss_2393;
	processInputPackets( triggerPorts_2380, argDeclBases_2383, structs_2387, oldvals_2389, contexts_238c, triggerVars_238f, functions_2391);
}

bool StartAssignment_237f::isInputUnique( const Udm::Object& triggerPort_239e, const Udm::Object& argDeclBase_23a7, const Udm::Object& struct_23b0, const Udm::Object& oldval_23b9, const Udm::Object& context_23c2, const Udm::Object& triggerVar_23cb, const Udm::Object& function_23d4)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itTriggerPort_23a0= _triggerPort_239a.begin(), itArgDeclBase_23a9= _argDeclBase_23a3.begin(), itStruct_23b2= _struct_23ac.begin(), itoldval_23bb= _oldval_23b5.begin(), itContext_23c4= _context_23be.begin(), itTriggerVar_23cd= _triggerVar_23c7.begin(), itFunction_23d6= _function_23d0.begin(); itTriggerPort_23a0!= _triggerPort_239a.end(), itArgDeclBase_23a9!= _argDeclBase_23a3.end(), itStruct_23b2!= _struct_23ac.end(), itoldval_23bb!= _oldval_23b5.end(), itContext_23c4!= _context_23be.end(), itTriggerVar_23cd!= _triggerVar_23c7.end(), itFunction_23d6!= _function_23d0.end(); ++itTriggerPort_23a0, ++itArgDeclBase_23a9, ++itStruct_23b2, ++itoldval_23bb, ++itContext_23c4, ++itTriggerVar_23cd, ++itFunction_23d6)
	{
		if( ( *itTriggerPort_23a0== triggerPort_239e)&& ( *itArgDeclBase_23a9== argDeclBase_23a7)&& ( *itStruct_23b2== struct_23b0)&& ( *itoldval_23bb== oldval_23b9)&& ( *itContext_23c4== context_23c2)&& ( *itTriggerVar_23cd== triggerVar_23cb)&& ( *itFunction_23d6== function_23d4))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_triggerPort_239a.push_back( triggerPort_239e);
		_argDeclBase_23a3.push_back( argDeclBase_23a7);
		_struct_23ac.push_back( struct_23b0);
		_oldval_23b5.push_back( oldval_23b9);
		_context_23be.push_back( context_23c2);
		_triggerVar_23c7.push_back( triggerVar_23cb);
		_function_23d0.push_back( function_23d4);
	}
	return isUnique;
}

bool StartAssignment_237f::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void StartAssignment_237f::processInputPackets( const Packets_t& triggerPorts_2380, const Packets_t& argDeclBases_2383, const Packets_t& structs_2387, const Packets_t& oldvals_2389, const Packets_t& contexts_238c, const Packets_t& triggerVars_238f, const Packets_t& functions_2391)
{
	for( Packets_t::const_iterator itTriggerPort_239b= triggerPorts_2380.begin(), itArgDeclBase_23a4= argDeclBases_2383.begin(), itStruct_23ad= structs_2387.begin(), itoldval_23b6= oldvals_2389.begin(), itContext_23bf= contexts_238c.begin(), itTriggerVar_23c8= triggerVars_238f.begin(), itFunction_23d1= functions_2391.begin(); itTriggerPort_239b!= triggerPorts_2380.end(), itArgDeclBase_23a4!= argDeclBases_2383.end(), itStruct_23ad!= structs_2387.end(), itoldval_23b6!= oldvals_2389.end(), itContext_23bf!= contexts_238c.end(), itTriggerVar_23c8!= triggerVars_238f.end(), itFunction_23d1!= functions_2391.end(); ++itTriggerPort_239b, ++itArgDeclBase_23a4, ++itStruct_23ad, ++itoldval_23b6, ++itContext_23bf, ++itTriggerVar_23c8, ++itFunction_23d1)
	{
		bool isUnique= isInputUnique( *itTriggerPort_239b, *itArgDeclBase_23a4, *itStruct_23ad, *itoldval_23b6, *itContext_23bf, *itTriggerVar_23c8, *itFunction_23d1);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itTriggerPort_239b, *itArgDeclBase_23a4, *itStruct_23ad, *itoldval_23b6, *itContext_23bf, *itTriggerVar_23c8, *itFunction_23d1);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool StartAssignment_237f::patternMatcher( const Udm::Object& triggerPort_239c, const Udm::Object& argDeclBase_23a5, const Udm::Object& struct_23ae, const Udm::Object& oldval_23b7, const Udm::Object& context_23c0, const Udm::Object& triggerVar_23c9, const Udm::Object& function_23d2)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( triggerPort_239c.type(), CyPhyML::SignalFlow::TriggerPort::meta))
			continue;
		CyPhyML::SignalFlow::TriggerPort triggerPort_23a1= CyPhyML::SignalFlow::TriggerPort::Cast( triggerPort_239c);
		if( false== Uml::IsDerivedFrom( argDeclBase_23a5.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_23aa= SFC::ArgDeclBase::Cast( argDeclBase_23a5);
		if( false== Uml::IsDerivedFrom( struct_23ae.type(), SFC::Struct::meta))
			continue;
		SFC::Struct struct_23b3= SFC::Struct::Cast( struct_23ae);
		if( false== Uml::IsDerivedFrom( oldval_23b7.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar oldval_23bc= SFC::LocalVar::Cast( oldval_23b7);
		if( false== Uml::IsDerivedFrom( context_23c0.type(), SFC::Arg::meta))
			continue;
		SFC::Arg context_23c5= SFC::Arg::Cast( context_23c0);
		if( false== Uml::IsDerivedFrom( triggerVar_23c9.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar triggerVar_23ce= SFC::LocalVar::Cast( triggerVar_23c9);
		if( false== Uml::IsDerivedFrom( function_23d2.type(), SFC::Function::meta))
			continue;
		SFC::Function function_23d7= SFC::Function::Cast( function_23d2);
		set< SFC::LocalVar> localVars_23d9= struct_23b3.LocalVar_kind_children();
		for( set< SFC::LocalVar>::const_iterator itLocalVar_23da= localVars_23d9.begin(); itLocalVar_23da!= localVars_23d9.end(); ++itLocalVar_23da)
		{
			SFC::LocalVar currLocalVar_23db= *itLocalVar_23da;
			Match currMatch;
			set< pair<int, Udm::Object> > boundObjs_23df;
			if( !isValidBound(boundObjs_23df, triggerPort_23a1, true))
				continue;
			currMatch.triggerPort_23e0= triggerPort_23a1;
			if( !isValidBound(boundObjs_23df, argDeclBase_23aa, true))
				continue;
			currMatch.argDeclBase_23e1= argDeclBase_23aa;
			if( !isValidBound(boundObjs_23df, struct_23b3, true))
				continue;
			currMatch.struct_23e2= struct_23b3;
			if( !isValidBound(boundObjs_23df, oldval_23bc, true))
				continue;
			currMatch.oldval_23e3= oldval_23bc;
			if( !isValidBound(boundObjs_23df, context_23c5, true))
				continue;
			currMatch.context_23e4= context_23c5;
			if( !isValidBound(boundObjs_23df, triggerVar_23ce, true))
				continue;
			currMatch.triggerVar_23e5= triggerVar_23ce;
			if( !isValidBound(boundObjs_23df, function_23d7, true))
				continue;
			currMatch.function_23e6= function_23d7;
			if( !isValidBound(boundObjs_23df, currLocalVar_23db, false))
				continue;
			currMatch.localVar_23e7= currLocalVar_23db;
			_matches.push_back( currMatch);
		}
	}
	return !_matches.empty();
}

void StartAssignment_237f::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::UserCode newAssignment_23e8= SFC::UserCode::Create( currMatch.function_23e6, SFC::Function::meta_stmnt);
		SFC::BinaryExprs newAssign_23e9= SFC::BinaryExprs::Create( newAssignment_23e8, SFC::UserCode::meta_codeexpr);
		SFC::UnaryExprs newUnaryExprs_23ea= SFC::UnaryExprs::Create( newAssign_23e9, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs newDot_23eb= SFC::BinaryExprs::Create( newAssign_23e9, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef_23ec= SFC::ArgDeclRef::Create( newDot_23eb, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef2_23ed= SFC::ArgDeclRef::Create( newDot_23eb, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclBase& ArgDeclBase= currMatch.argDeclBase_23e1;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_23ec;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_23ed;
		SFC::BinaryExprs& Assign= newAssign_23e9;
		SFC::UserCode& Assignment= newAssignment_23e8;
		SFC::Arg& Context= currMatch.context_23e4;
		SFC::BinaryExprs& Dot= newDot_23eb;
		SFC::Function& Function= currMatch.function_23e6;
		SFC::LocalVar& LocalVar= currMatch.localVar_23e7;
		SFC::Struct& Struct= currMatch.struct_23e2;
		CyPhyML::SignalFlow::TriggerPort& TriggerPort= currMatch.triggerPort_23e0;
		SFC::LocalVar& TriggerVar= currMatch.triggerVar_23e5;
		SFC::UnaryExprs& UnaryExprs= newUnaryExprs_23ea;
		SFC::LocalVar& oldval= currMatch.oldval_23e3;
		{
__int64 statementCount = Function.statementCount();
Assignment.statementIndex() = statementCount++;
Function.statementCount() = statementCount;
};
		{
UnaryExprs.op() = "";
};
		{
Dot.op() = ".";
};
		{
Assign.op() = "=";
};
		newArgDeclRef_23ec.argdecl()= currMatch.triggerVar_23e5;
		newArgDeclRef2_23ed.argdecl()= currMatch.localVar_23e7;
		outputAppender( currMatch.triggerPort_23e0, currMatch.argDeclBase_23e1, currMatch.localVar_23e7, currMatch.oldval_23e3, currMatch.context_23e4, newUnaryExprs_23ea);
	}
}

void StartAssignment_237f::outputAppender( const CyPhyML::SignalFlow::TriggerPort& triggerPort_23ee, const SFC::ArgDeclBase& argDeclBase_23f0, const SFC::LocalVar& localVar_23f2, const SFC::LocalVar& oldval_23f4, const SFC::Arg& context_23f6, const SFC::UnaryExprs& unaryExprs_23f8)
{
	_triggerPort_2394->push_back( triggerPort_23ee);
	_argDeclBase_2395->push_back( argDeclBase_23f0);
	_localVar_2396->push_back( localVar_23f2);
	_oldval_2397->push_back( oldval_23f4);
	_context_2398->push_back( context_23f6);
	_unaryExprs_2399->push_back( unaryExprs_23f8);
}

void AddTriggerVar_23fa::operator()( const Packets_t& triggerPorts_23fb, const Packets_t& argDeclBases_23fe, const Packets_t& structs_2401, const Packets_t& localVars_2404, const Packets_t& contexts_2407, const Packets_t& functions_240b, Packets_t& triggerPorts_23fd, Packets_t& argDeclBases_2400, Packets_t& structs_2403, Packets_t& localVars_2406, Packets_t& contexts_2409, Packets_t& triggerVars_240a, Packets_t& functions_240d)
{
#ifdef PRINT_INFO
	printLog("AddTriggerVar_23fa" );
#endif
	RTTGenerator::Instance()->generateRule(2348, "AddTriggerVar");
	_triggerPort_240e= &triggerPorts_23fd;
	_argDeclBase_240f= &argDeclBases_2400;
	_struct_2410= &structs_2403;
	_localVar_2411= &localVars_2406;
	_context_2412= &contexts_2409;
	_triggerVar_2413= &triggerVars_240a;
	_function_2414= &functions_240d;
	processInputPackets( triggerPorts_23fb, argDeclBases_23fe, structs_2401, localVars_2404, contexts_2407, functions_240b);
}

bool AddTriggerVar_23fa::isInputUnique( const Udm::Object& triggerPort_2419, const Udm::Object& argDeclBase_2422, const Udm::Object& struct_242b, const Udm::Object& localVar_2434, const Udm::Object& context_243d, const Udm::Object& function_2446)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itTriggerPort_241b= _triggerPort_2415.begin(), itArgDeclBase_2424= _argDeclBase_241e.begin(), itStruct_242d= _struct_2427.begin(), itLocalVar_2436= _localVar_2430.begin(), itContext_243f= _context_2439.begin(), itFunction_2448= _function_2442.begin(); itTriggerPort_241b!= _triggerPort_2415.end(), itArgDeclBase_2424!= _argDeclBase_241e.end(), itStruct_242d!= _struct_2427.end(), itLocalVar_2436!= _localVar_2430.end(), itContext_243f!= _context_2439.end(), itFunction_2448!= _function_2442.end(); ++itTriggerPort_241b, ++itArgDeclBase_2424, ++itStruct_242d, ++itLocalVar_2436, ++itContext_243f, ++itFunction_2448)
	{
		if( ( *itTriggerPort_241b== triggerPort_2419)&& ( *itArgDeclBase_2424== argDeclBase_2422)&& ( *itStruct_242d== struct_242b)&& ( *itLocalVar_2436== localVar_2434)&& ( *itContext_243f== context_243d)&& ( *itFunction_2448== function_2446))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_triggerPort_2415.push_back( triggerPort_2419);
		_argDeclBase_241e.push_back( argDeclBase_2422);
		_struct_2427.push_back( struct_242b);
		_localVar_2430.push_back( localVar_2434);
		_context_2439.push_back( context_243d);
		_function_2442.push_back( function_2446);
	}
	return isUnique;
}

bool AddTriggerVar_23fa::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void AddTriggerVar_23fa::processInputPackets( const Packets_t& triggerPorts_23fb, const Packets_t& argDeclBases_23fe, const Packets_t& structs_2401, const Packets_t& localVars_2404, const Packets_t& contexts_2407, const Packets_t& functions_240b)
{
	for( Packets_t::const_iterator itTriggerPort_2416= triggerPorts_23fb.begin(), itArgDeclBase_241f= argDeclBases_23fe.begin(), itStruct_2428= structs_2401.begin(), itLocalVar_2431= localVars_2404.begin(), itContext_243a= contexts_2407.begin(), itFunction_2443= functions_240b.begin(); itTriggerPort_2416!= triggerPorts_23fb.end(), itArgDeclBase_241f!= argDeclBases_23fe.end(), itStruct_2428!= structs_2401.end(), itLocalVar_2431!= localVars_2404.end(), itContext_243a!= contexts_2407.end(), itFunction_2443!= functions_240b.end(); ++itTriggerPort_2416, ++itArgDeclBase_241f, ++itStruct_2428, ++itLocalVar_2431, ++itContext_243a, ++itFunction_2443)
	{
		bool isUnique= isInputUnique( *itTriggerPort_2416, *itArgDeclBase_241f, *itStruct_2428, *itLocalVar_2431, *itContext_243a, *itFunction_2443);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itTriggerPort_2416, *itArgDeclBase_241f, *itStruct_2428, *itLocalVar_2431, *itContext_243a, *itFunction_2443);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool AddTriggerVar_23fa::patternMatcher( const Udm::Object& triggerPort_2417, const Udm::Object& argDeclBase_2420, const Udm::Object& struct_2429, const Udm::Object& localVar_2432, const Udm::Object& context_243b, const Udm::Object& function_2444)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( triggerPort_2417.type(), CyPhyML::SignalFlow::TriggerPort::meta))
			continue;
		CyPhyML::SignalFlow::TriggerPort triggerPort_241c= CyPhyML::SignalFlow::TriggerPort::Cast( triggerPort_2417);
		if( false== Uml::IsDerivedFrom( argDeclBase_2420.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_2425= SFC::ArgDeclBase::Cast( argDeclBase_2420);
		if( false== Uml::IsDerivedFrom( struct_2429.type(), SFC::Struct::meta))
			continue;
		SFC::Struct struct_242e= SFC::Struct::Cast( struct_2429);
		if( false== Uml::IsDerivedFrom( localVar_2432.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_2437= SFC::LocalVar::Cast( localVar_2432);
		if( false== Uml::IsDerivedFrom( context_243b.type(), SFC::Arg::meta))
			continue;
		SFC::Arg context_2440= SFC::Arg::Cast( context_243b);
		if( false== Uml::IsDerivedFrom( function_2444.type(), SFC::Function::meta))
			continue;
		SFC::Function function_2449= SFC::Function::Cast( function_2444);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_244e;
		if( !isValidBound(boundObjs_244e, triggerPort_241c, true))
			continue;
		currMatch.triggerPort_244f= triggerPort_241c;
		if( !isValidBound(boundObjs_244e, argDeclBase_2425, true))
			continue;
		currMatch.argDeclBase_2450= argDeclBase_2425;
		if( !isValidBound(boundObjs_244e, struct_242e, true))
			continue;
		currMatch.struct_2451= struct_242e;
		if( !isValidBound(boundObjs_244e, localVar_2437, true))
			continue;
		currMatch.localVar_2452= localVar_2437;
		if( !isValidBound(boundObjs_244e, context_2440, true))
			continue;
		currMatch.context_2453= context_2440;
		if( !isValidBound(boundObjs_244e, function_2449, true))
			continue;
		currMatch.function_2454= function_2449;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void AddTriggerVar_23fa::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar newTriggerVar_2455= SFC::LocalVar::Create( currMatch.function_2454, SFC::Function::meta_stmnt);
		SFC::ArgDeclBase& ArgDeclBase= currMatch.argDeclBase_2450;
		SFC::Arg& Context= currMatch.context_2453;
		SFC::Function& Function= currMatch.function_2454;
		SFC::LocalVar& LocalVar= currMatch.localVar_2452;
		SFC::Struct& Struct= currMatch.struct_2451;
		CyPhyML::SignalFlow::TriggerPort& TriggerPort= currMatch.triggerPort_244f;
		SFC::LocalVar& TriggerVar= newTriggerVar_2455;
		{
__int64 statementCount = Function.statementCount();
TriggerVar.statementIndex() = statementCount++;
Function.statementCount() = statementCount;
};
		{
TriggerVar.type() = "int";
TriggerVar.name() = std::string( "event" ) + boost::lexical_cast< std::string >( TriggerVar.uniqueId() );
};
		currMatch.localVar_2452.trigvar()= newTriggerVar_2455;
		newTriggerVar_2455.dt()= currMatch.struct_2451;
		outputAppender( currMatch.triggerPort_244f, currMatch.argDeclBase_2450, currMatch.struct_2451, currMatch.localVar_2452, currMatch.context_2453, newTriggerVar_2455, currMatch.function_2454);
	}
}

void AddTriggerVar_23fa::outputAppender( const CyPhyML::SignalFlow::TriggerPort& triggerPort_2456, const SFC::ArgDeclBase& argDeclBase_2458, const SFC::Struct& struct_245a, const SFC::LocalVar& localVar_245c, const SFC::Arg& context_245e, const SFC::LocalVar& triggerVar_2460, const SFC::Function& function_2462)
{
	_triggerPort_240e->push_back( triggerPort_2456);
	_argDeclBase_240f->push_back( argDeclBase_2458);
	_struct_2410->push_back( struct_245a);
	_localVar_2411->push_back( localVar_245c);
	_context_2412->push_back( context_245e);
	_triggerVar_2413->push_back( triggerVar_2460);
	_function_2414->push_back( function_2462);
}

void EdgeTest_2464::operator()( const Packets_t& triggers_2465, const Packets_t& argdecls_2467, const Packets_t& members_2469, const Packets_t& oldvals_246b, const Packets_t& contexts_246d, const Packets_t& initexprs_246f, Packets_t& argdecls_2471, Packets_t& members_2472, Packets_t& oldvals_2473, Packets_t& contexts_2474, Packets_t& initexprs_2475, Packets_t& argdecls_2476, Packets_t& members_2477, Packets_t& oldvals_2478, Packets_t& contexts_2479, Packets_t& initexprs_247a, Packets_t& argdecls_247b, Packets_t& members_247c, Packets_t& oldvals_247d, Packets_t& contexts_247e, Packets_t& initexprs_247f)
{
#ifdef PRINT_INFO
	printLog("EdgeTest_2464" );
#endif
	_argdecl_2480= &argdecls_2471;
	_member_2481= &members_2472;
	_oldval_2482= &oldvals_2473;
	_context_2483= &contexts_2474;
	_initexpr_2484= &initexprs_2475;
	_argdecl_2485= &argdecls_2476;
	_member_2486= &members_2477;
	_oldval_2487= &oldvals_2478;
	_context_2488= &contexts_2479;
	_initexpr_2489= &initexprs_247a;
	_argdecl_248a= &argdecls_247b;
	_member_248b= &members_247c;
	_oldval_248c= &oldvals_247d;
	_context_248d= &contexts_247e;
	_initexpr_248e= &initexprs_247f;
	for( Packets_t::const_iterator ittrigger_2490= triggers_2465.begin(), itargdecl_2497= argdecls_2467.begin(), itmember_249e= members_2469.begin(), itoldval_24a5= oldvals_246b.begin(), itcontext_24ac= contexts_246d.begin(), itinitexpr_24b3= initexprs_246f.begin(); ittrigger_2490!= triggers_2465.end(), itargdecl_2497!= argdecls_2467.end(), itmember_249e!= members_2469.end(), itoldval_24a5!= oldvals_246b.end(), itcontext_24ac!= contexts_246d.end(), itinitexpr_24b3!= initexprs_246f.end(); ++ittrigger_2490, ++itargdecl_2497, ++itmember_249e, ++itoldval_24a5, ++itcontext_24ac, ++itinitexpr_24b3)
	{
		bool isUnique= isInputUnique( *ittrigger_2490, *itargdecl_2497, *itmember_249e, *itoldval_24a5, *itcontext_24ac, *itinitexpr_24b3);
		if( !isUnique)
			continue;
		Packets_t onetrigger_2494( 1, *ittrigger_2490);
		Packets_t oneargdecl_249b( 1, *itargdecl_2497);
		Packets_t onemember_24a2( 1, *itmember_249e);
		Packets_t oneoldval_24a9( 1, *itoldval_24a5);
		Packets_t onecontext_24b0( 1, *itcontext_24ac);
		Packets_t oneinitexpr_24b7( 1, *itinitexpr_24b3);
		executeOne( onetrigger_2494, oneargdecl_249b, onemember_24a2, oneoldval_24a9, onecontext_24b0, oneinitexpr_24b7);
	}
}

void EdgeTest_2464::executeOne( const Packets_t& triggers_2465, const Packets_t& argdecls_2467, const Packets_t& members_2469, const Packets_t& oldvals_246b, const Packets_t& contexts_246d, const Packets_t& initexprs_246f)
{
	Packets_t argDeclBases_24be;
	Packets_t members_24c1;
	Packets_t localVars_24c4;
	Packets_t contexts_24c7;
	Packets_t unaryExprss_24ca;
	RisingEdge_24b9 risingEdge_24b9;
	bool isMatchRisingEdge_24b9= risingEdge_24b9( triggers_2465, argdecls_2467, members_2469, oldvals_246b, contexts_246d, initexprs_246f, argDeclBases_24be, members_24c1, localVars_24c4, contexts_24c7, unaryExprss_24ca);
	_argdecl_2480->insert( _argdecl_2480->end(), argDeclBases_24be.begin(), argDeclBases_24be.end());
	_member_2481->insert( _member_2481->end(), members_24c1.begin(), members_24c1.end());
	_oldval_2482->insert( _oldval_2482->end(), localVars_24c4.begin(), localVars_24c4.end());
	_context_2483->insert( _context_2483->end(), contexts_24c7.begin(), contexts_24c7.end());
	_initexpr_2484->insert( _initexpr_2484->end(), unaryExprss_24ca.begin(), unaryExprss_24ca.end());
	if( isMatchRisingEdge_24b9)
		return;
	Packets_t argDeclBases_2525;
	Packets_t members_2528;
	Packets_t localVars_252b;
	Packets_t contexts_252e;
	Packets_t unaryExprss_2531;
	FallingEdge_2520 fallingEdge_2520;
	bool isMatchFallingEdge_2520= fallingEdge_2520( triggers_2465, argdecls_2467, members_2469, oldvals_246b, contexts_246d, initexprs_246f, argDeclBases_2525, members_2528, localVars_252b, contexts_252e, unaryExprss_2531);
	_argdecl_2485->insert( _argdecl_2485->end(), argDeclBases_2525.begin(), argDeclBases_2525.end());
	_member_2486->insert( _member_2486->end(), members_2528.begin(), members_2528.end());
	_oldval_2487->insert( _oldval_2487->end(), localVars_252b.begin(), localVars_252b.end());
	_context_2488->insert( _context_2488->end(), contexts_252e.begin(), contexts_252e.end());
	_initexpr_2489->insert( _initexpr_2489->end(), unaryExprss_2531.begin(), unaryExprss_2531.end());
	Packets_t argDeclBases_258c;
	Packets_t members_258f;
	Packets_t localVars_2592;
	Packets_t contexts_2595;
	Packets_t unaryExprss_2598;
	EitherEdge_2587 eitherEdge_2587;
	bool isMatchEitherEdge_2587= eitherEdge_2587( triggers_2465, argdecls_2467, members_2469, oldvals_246b, contexts_246d, initexprs_246f, argDeclBases_258c, members_258f, localVars_2592, contexts_2595, unaryExprss_2598);
	_argdecl_248a->insert( _argdecl_248a->end(), argDeclBases_258c.begin(), argDeclBases_258c.end());
	_member_248b->insert( _member_248b->end(), members_258f.begin(), members_258f.end());
	_oldval_248c->insert( _oldval_248c->end(), localVars_2592.begin(), localVars_2592.end());
	_context_248d->insert( _context_248d->end(), contexts_2595.begin(), contexts_2595.end());
	_initexpr_248e->insert( _initexpr_248e->end(), unaryExprss_2598.begin(), unaryExprss_2598.end());
}

bool EdgeTest_2464::isInputUnique( const Udm::Object& trigger_2491, const Udm::Object& argdecl_2498, const Udm::Object& member_249f, const Udm::Object& oldval_24a6, const Udm::Object& context_24ad, const Udm::Object& initexpr_24b4)
{
	bool isUnique= true;
	for( Packets_t::const_iterator ittrigger_2493= _trigger_248f.begin(), itargdecl_249a= _argdecl_2496.begin(), itmember_24a1= _member_249d.begin(), itoldval_24a8= _oldval_24a4.begin(), itcontext_24af= _context_24ab.begin(), itinitexpr_24b6= _initexpr_24b2.begin(); ittrigger_2493!= _trigger_248f.end(), itargdecl_249a!= _argdecl_2496.end(), itmember_24a1!= _member_249d.end(), itoldval_24a8!= _oldval_24a4.end(), itcontext_24af!= _context_24ab.end(), itinitexpr_24b6!= _initexpr_24b2.end(); ++ittrigger_2493, ++itargdecl_249a, ++itmember_24a1, ++itoldval_24a8, ++itcontext_24af, ++itinitexpr_24b6)
	{
		if( ( *ittrigger_2493== trigger_2491)&& ( *itargdecl_249a== argdecl_2498)&& ( *itmember_24a1== member_249f)&& ( *itoldval_24a8== oldval_24a6)&& ( *itcontext_24af== context_24ad)&& ( *itinitexpr_24b6== initexpr_24b4))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_trigger_248f.push_back( trigger_2491);
		_argdecl_2496.push_back( argdecl_2498);
		_member_249d.push_back( member_249f);
		_oldval_24a4.push_back( oldval_24a6);
		_context_24ab.push_back( context_24ad);
		_initexpr_24b2.push_back( initexpr_24b4);
	}
	return isUnique;
}

bool RisingEdge_24b9::operator()( const Packets_t& triggerPorts_24ba, const Packets_t& argDeclBases_24bc, const Packets_t& members_24bf, const Packets_t& localVars_24c2, const Packets_t& contexts_24c5, const Packets_t& unaryExprss_24c8, Packets_t& argDeclBases_24be, Packets_t& members_24c1, Packets_t& localVars_24c4, Packets_t& contexts_24c7, Packets_t& unaryExprss_24ca)
{
#ifdef PRINT_INFO
	printLog("RisingEdge_24b9" );
#endif
	_argDeclBase_24cb= &argDeclBases_24be;
	_member_24cc= &members_24c1;
	_localVar_24cd= &localVars_24c4;
	_context_24ce= &contexts_24c7;
	_unaryExprs_24cf= &unaryExprss_24ca;
	processInputPackets( triggerPorts_24ba, argDeclBases_24bc, members_24bf, localVars_24c2, contexts_24c5, unaryExprss_24c8);
	if( false== _matches.empty())
		return true;
	return false;
}

bool RisingEdge_24b9::isInputUnique( const Udm::Object& triggerPort_24d4, const Udm::Object& argDeclBase_24dd, const Udm::Object& member_24e6, const Udm::Object& localVar_24ef, const Udm::Object& context_24f8, const Udm::Object& unaryExprs_2501)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itTriggerPort_24d6= _triggerPort_24d0.begin(), itArgDeclBase_24df= _argDeclBase_24d9.begin(), itMember_24e8= _member_24e2.begin(), itLocalVar_24f1= _localVar_24eb.begin(), itContext_24fa= _context_24f4.begin(), itUnaryExprs_2503= _unaryExprs_24fd.begin(); itTriggerPort_24d6!= _triggerPort_24d0.end(), itArgDeclBase_24df!= _argDeclBase_24d9.end(), itMember_24e8!= _member_24e2.end(), itLocalVar_24f1!= _localVar_24eb.end(), itContext_24fa!= _context_24f4.end(), itUnaryExprs_2503!= _unaryExprs_24fd.end(); ++itTriggerPort_24d6, ++itArgDeclBase_24df, ++itMember_24e8, ++itLocalVar_24f1, ++itContext_24fa, ++itUnaryExprs_2503)
	{
		if( ( *itTriggerPort_24d6== triggerPort_24d4)&& ( *itArgDeclBase_24df== argDeclBase_24dd)&& ( *itMember_24e8== member_24e6)&& ( *itLocalVar_24f1== localVar_24ef)&& ( *itContext_24fa== context_24f8)&& ( *itUnaryExprs_2503== unaryExprs_2501))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_triggerPort_24d0.push_back( triggerPort_24d4);
		_argDeclBase_24d9.push_back( argDeclBase_24dd);
		_member_24e2.push_back( member_24e6);
		_localVar_24eb.push_back( localVar_24ef);
		_context_24f4.push_back( context_24f8);
		_unaryExprs_24fd.push_back( unaryExprs_2501);
	}
	return isUnique;
}

bool RisingEdge_24b9::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool RisingEdge_24b9::isGuardTrue( SFC::ArgDeclBase& ArgDeclBase, SFC::Arg& Context, SFC::LocalVar& LocalVar, SFC::LocalVar& Member, CyPhyML::SignalFlow::TriggerPort& TriggerPort, SFC::UnaryExprs& UnaryExprs)
{
	bool Gz_guard= false;
	std::string trigger = TriggerPort.TriggerType();
Gz_guard = trigger == "rising";;
	return Gz_guard;
}

void RisingEdge_24b9::processInputPackets( const Packets_t& triggerPorts_24ba, const Packets_t& argDeclBases_24bc, const Packets_t& members_24bf, const Packets_t& localVars_24c2, const Packets_t& contexts_24c5, const Packets_t& unaryExprss_24c8)
{
	for( Packets_t::const_iterator itTriggerPort_24d1= triggerPorts_24ba.begin(), itArgDeclBase_24da= argDeclBases_24bc.begin(), itMember_24e3= members_24bf.begin(), itLocalVar_24ec= localVars_24c2.begin(), itContext_24f5= contexts_24c5.begin(), itUnaryExprs_24fe= unaryExprss_24c8.begin(); itTriggerPort_24d1!= triggerPorts_24ba.end(), itArgDeclBase_24da!= argDeclBases_24bc.end(), itMember_24e3!= members_24bf.end(), itLocalVar_24ec!= localVars_24c2.end(), itContext_24f5!= contexts_24c5.end(), itUnaryExprs_24fe!= unaryExprss_24c8.end(); ++itTriggerPort_24d1, ++itArgDeclBase_24da, ++itMember_24e3, ++itLocalVar_24ec, ++itContext_24f5, ++itUnaryExprs_24fe)
	{
		bool isUnique= isInputUnique( *itTriggerPort_24d1, *itArgDeclBase_24da, *itMember_24e3, *itLocalVar_24ec, *itContext_24f5, *itUnaryExprs_24fe);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itTriggerPort_24d1, *itArgDeclBase_24da, *itMember_24e3, *itLocalVar_24ec, *itContext_24f5, *itUnaryExprs_24fe);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.argDeclBase_250b, currMatch.member_250c, currMatch.localVar_250d, currMatch.context_250e, currMatch.unaryExprs_250f);
	}
}

bool RisingEdge_24b9::patternMatcher( const Udm::Object& triggerPort_24d2, const Udm::Object& argDeclBase_24db, const Udm::Object& member_24e4, const Udm::Object& localVar_24ed, const Udm::Object& context_24f6, const Udm::Object& unaryExprs_24ff)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( triggerPort_24d2.type(), CyPhyML::SignalFlow::TriggerPort::meta))
			continue;
		CyPhyML::SignalFlow::TriggerPort triggerPort_24d7= CyPhyML::SignalFlow::TriggerPort::Cast( triggerPort_24d2);
		if( false== Uml::IsDerivedFrom( argDeclBase_24db.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_24e0= SFC::ArgDeclBase::Cast( argDeclBase_24db);
		if( false== Uml::IsDerivedFrom( member_24e4.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar member_24e9= SFC::LocalVar::Cast( member_24e4);
		if( false== Uml::IsDerivedFrom( localVar_24ed.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_24f2= SFC::LocalVar::Cast( localVar_24ed);
		if( false== Uml::IsDerivedFrom( context_24f6.type(), SFC::Arg::meta))
			continue;
		SFC::Arg context_24fb= SFC::Arg::Cast( context_24f6);
		if( false== Uml::IsDerivedFrom( unaryExprs_24ff.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_2504= SFC::UnaryExprs::Cast( unaryExprs_24ff);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2509;
		if( !isValidBound(boundObjs_2509, triggerPort_24d7, true))
			continue;
		currMatch.triggerPort_250a= triggerPort_24d7;
		if( !isValidBound(boundObjs_2509, argDeclBase_24e0, true))
			continue;
		currMatch.argDeclBase_250b= argDeclBase_24e0;
		if( !isValidBound(boundObjs_2509, member_24e9, true))
			continue;
		currMatch.member_250c= member_24e9;
		if( !isValidBound(boundObjs_2509, localVar_24f2, true))
			continue;
		currMatch.localVar_250d= localVar_24f2;
		if( !isValidBound(boundObjs_2509, context_24fb, true))
			continue;
		currMatch.context_250e= context_24fb;
		if( !isValidBound(boundObjs_2509, unaryExprs_2504, true))
			continue;
		currMatch.unaryExprs_250f= unaryExprs_2504;
		bool Gz_guard= isGuardTrue( currMatch.argDeclBase_250b, currMatch.context_250e, currMatch.localVar_250d, currMatch.member_250c, currMatch.triggerPort_250a, currMatch.unaryExprs_250f);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void RisingEdge_24b9::outputAppender( const SFC::ArgDeclBase& argDeclBase_2516, const SFC::LocalVar& member_2518, const SFC::LocalVar& localVar_251a, const SFC::Arg& context_251c, const SFC::UnaryExprs& unaryExprs_251e)
{
	_argDeclBase_24cb->push_back( argDeclBase_2516);
	_member_24cc->push_back( member_2518);
	_localVar_24cd->push_back( localVar_251a);
	_context_24ce->push_back( context_251c);
	_unaryExprs_24cf->push_back( unaryExprs_251e);
}

bool FallingEdge_2520::operator()( const Packets_t& triggerPorts_2521, const Packets_t& argDeclBases_2523, const Packets_t& members_2526, const Packets_t& localVars_2529, const Packets_t& contexts_252c, const Packets_t& unaryExprss_252f, Packets_t& argDeclBases_2525, Packets_t& members_2528, Packets_t& localVars_252b, Packets_t& contexts_252e, Packets_t& unaryExprss_2531)
{
#ifdef PRINT_INFO
	printLog("FallingEdge_2520" );
#endif
	_argDeclBase_2532= &argDeclBases_2525;
	_member_2533= &members_2528;
	_localVar_2534= &localVars_252b;
	_context_2535= &contexts_252e;
	_unaryExprs_2536= &unaryExprss_2531;
	processInputPackets( triggerPorts_2521, argDeclBases_2523, members_2526, localVars_2529, contexts_252c, unaryExprss_252f);
	if( false== _matches.empty())
		return true;
	return false;
}

bool FallingEdge_2520::isInputUnique( const Udm::Object& triggerPort_253b, const Udm::Object& argDeclBase_2544, const Udm::Object& member_254d, const Udm::Object& localVar_2556, const Udm::Object& context_255f, const Udm::Object& unaryExprs_2568)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itTriggerPort_253d= _triggerPort_2537.begin(), itArgDeclBase_2546= _argDeclBase_2540.begin(), itMember_254f= _member_2549.begin(), itLocalVar_2558= _localVar_2552.begin(), itContext_2561= _context_255b.begin(), itUnaryExprs_256a= _unaryExprs_2564.begin(); itTriggerPort_253d!= _triggerPort_2537.end(), itArgDeclBase_2546!= _argDeclBase_2540.end(), itMember_254f!= _member_2549.end(), itLocalVar_2558!= _localVar_2552.end(), itContext_2561!= _context_255b.end(), itUnaryExprs_256a!= _unaryExprs_2564.end(); ++itTriggerPort_253d, ++itArgDeclBase_2546, ++itMember_254f, ++itLocalVar_2558, ++itContext_2561, ++itUnaryExprs_256a)
	{
		if( ( *itTriggerPort_253d== triggerPort_253b)&& ( *itArgDeclBase_2546== argDeclBase_2544)&& ( *itMember_254f== member_254d)&& ( *itLocalVar_2558== localVar_2556)&& ( *itContext_2561== context_255f)&& ( *itUnaryExprs_256a== unaryExprs_2568))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_triggerPort_2537.push_back( triggerPort_253b);
		_argDeclBase_2540.push_back( argDeclBase_2544);
		_member_2549.push_back( member_254d);
		_localVar_2552.push_back( localVar_2556);
		_context_255b.push_back( context_255f);
		_unaryExprs_2564.push_back( unaryExprs_2568);
	}
	return isUnique;
}

bool FallingEdge_2520::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool FallingEdge_2520::isGuardTrue( SFC::ArgDeclBase& ArgDeclBase, SFC::Arg& Context, SFC::LocalVar& LocalVar, SFC::LocalVar& Member, CyPhyML::SignalFlow::TriggerPort& TriggerPort, SFC::UnaryExprs& UnaryExprs)
{
	bool Gz_guard= false;
	std::string trigger = TriggerPort.TriggerType();
Gz_guard = trigger == "falling";;
	return Gz_guard;
}

void FallingEdge_2520::processInputPackets( const Packets_t& triggerPorts_2521, const Packets_t& argDeclBases_2523, const Packets_t& members_2526, const Packets_t& localVars_2529, const Packets_t& contexts_252c, const Packets_t& unaryExprss_252f)
{
	for( Packets_t::const_iterator itTriggerPort_2538= triggerPorts_2521.begin(), itArgDeclBase_2541= argDeclBases_2523.begin(), itMember_254a= members_2526.begin(), itLocalVar_2553= localVars_2529.begin(), itContext_255c= contexts_252c.begin(), itUnaryExprs_2565= unaryExprss_252f.begin(); itTriggerPort_2538!= triggerPorts_2521.end(), itArgDeclBase_2541!= argDeclBases_2523.end(), itMember_254a!= members_2526.end(), itLocalVar_2553!= localVars_2529.end(), itContext_255c!= contexts_252c.end(), itUnaryExprs_2565!= unaryExprss_252f.end(); ++itTriggerPort_2538, ++itArgDeclBase_2541, ++itMember_254a, ++itLocalVar_2553, ++itContext_255c, ++itUnaryExprs_2565)
	{
		bool isUnique= isInputUnique( *itTriggerPort_2538, *itArgDeclBase_2541, *itMember_254a, *itLocalVar_2553, *itContext_255c, *itUnaryExprs_2565);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itTriggerPort_2538, *itArgDeclBase_2541, *itMember_254a, *itLocalVar_2553, *itContext_255c, *itUnaryExprs_2565);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.argDeclBase_2572, currMatch.member_2573, currMatch.localVar_2574, currMatch.context_2575, currMatch.unaryExprs_2576);
	}
}

bool FallingEdge_2520::patternMatcher( const Udm::Object& triggerPort_2539, const Udm::Object& argDeclBase_2542, const Udm::Object& member_254b, const Udm::Object& localVar_2554, const Udm::Object& context_255d, const Udm::Object& unaryExprs_2566)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( triggerPort_2539.type(), CyPhyML::SignalFlow::TriggerPort::meta))
			continue;
		CyPhyML::SignalFlow::TriggerPort triggerPort_253e= CyPhyML::SignalFlow::TriggerPort::Cast( triggerPort_2539);
		if( false== Uml::IsDerivedFrom( argDeclBase_2542.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_2547= SFC::ArgDeclBase::Cast( argDeclBase_2542);
		if( false== Uml::IsDerivedFrom( member_254b.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar member_2550= SFC::LocalVar::Cast( member_254b);
		if( false== Uml::IsDerivedFrom( localVar_2554.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_2559= SFC::LocalVar::Cast( localVar_2554);
		if( false== Uml::IsDerivedFrom( context_255d.type(), SFC::Arg::meta))
			continue;
		SFC::Arg context_2562= SFC::Arg::Cast( context_255d);
		if( false== Uml::IsDerivedFrom( unaryExprs_2566.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_256b= SFC::UnaryExprs::Cast( unaryExprs_2566);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2570;
		if( !isValidBound(boundObjs_2570, triggerPort_253e, true))
			continue;
		currMatch.triggerPort_2571= triggerPort_253e;
		if( !isValidBound(boundObjs_2570, argDeclBase_2547, true))
			continue;
		currMatch.argDeclBase_2572= argDeclBase_2547;
		if( !isValidBound(boundObjs_2570, member_2550, true))
			continue;
		currMatch.member_2573= member_2550;
		if( !isValidBound(boundObjs_2570, localVar_2559, true))
			continue;
		currMatch.localVar_2574= localVar_2559;
		if( !isValidBound(boundObjs_2570, context_2562, true))
			continue;
		currMatch.context_2575= context_2562;
		if( !isValidBound(boundObjs_2570, unaryExprs_256b, true))
			continue;
		currMatch.unaryExprs_2576= unaryExprs_256b;
		bool Gz_guard= isGuardTrue( currMatch.argDeclBase_2572, currMatch.context_2575, currMatch.localVar_2574, currMatch.member_2573, currMatch.triggerPort_2571, currMatch.unaryExprs_2576);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void FallingEdge_2520::outputAppender( const SFC::ArgDeclBase& argDeclBase_257d, const SFC::LocalVar& member_257f, const SFC::LocalVar& localVar_2581, const SFC::Arg& context_2583, const SFC::UnaryExprs& unaryExprs_2585)
{
	_argDeclBase_2532->push_back( argDeclBase_257d);
	_member_2533->push_back( member_257f);
	_localVar_2534->push_back( localVar_2581);
	_context_2535->push_back( context_2583);
	_unaryExprs_2536->push_back( unaryExprs_2585);
}

bool EitherEdge_2587::operator()( const Packets_t& triggerPorts_2588, const Packets_t& argDeclBases_258a, const Packets_t& members_258d, const Packets_t& localVars_2590, const Packets_t& contexts_2593, const Packets_t& unaryExprss_2596, Packets_t& argDeclBases_258c, Packets_t& members_258f, Packets_t& localVars_2592, Packets_t& contexts_2595, Packets_t& unaryExprss_2598)
{
#ifdef PRINT_INFO
	printLog("EitherEdge_2587" );
#endif
	_argDeclBase_2599= &argDeclBases_258c;
	_member_259a= &members_258f;
	_localVar_259b= &localVars_2592;
	_context_259c= &contexts_2595;
	_unaryExprs_259d= &unaryExprss_2598;
	processInputPackets( triggerPorts_2588, argDeclBases_258a, members_258d, localVars_2590, contexts_2593, unaryExprss_2596);
	if( false== _matches.empty())
		return true;
	return false;
}

bool EitherEdge_2587::isInputUnique( const Udm::Object& triggerPort_25a2, const Udm::Object& argDeclBase_25ab, const Udm::Object& member_25b4, const Udm::Object& localVar_25bd, const Udm::Object& context_25c6, const Udm::Object& unaryExprs_25cf)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itTriggerPort_25a4= _triggerPort_259e.begin(), itArgDeclBase_25ad= _argDeclBase_25a7.begin(), itMember_25b6= _member_25b0.begin(), itLocalVar_25bf= _localVar_25b9.begin(), itContext_25c8= _context_25c2.begin(), itUnaryExprs_25d1= _unaryExprs_25cb.begin(); itTriggerPort_25a4!= _triggerPort_259e.end(), itArgDeclBase_25ad!= _argDeclBase_25a7.end(), itMember_25b6!= _member_25b0.end(), itLocalVar_25bf!= _localVar_25b9.end(), itContext_25c8!= _context_25c2.end(), itUnaryExprs_25d1!= _unaryExprs_25cb.end(); ++itTriggerPort_25a4, ++itArgDeclBase_25ad, ++itMember_25b6, ++itLocalVar_25bf, ++itContext_25c8, ++itUnaryExprs_25d1)
	{
		if( ( *itTriggerPort_25a4== triggerPort_25a2)&& ( *itArgDeclBase_25ad== argDeclBase_25ab)&& ( *itMember_25b6== member_25b4)&& ( *itLocalVar_25bf== localVar_25bd)&& ( *itContext_25c8== context_25c6)&& ( *itUnaryExprs_25d1== unaryExprs_25cf))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_triggerPort_259e.push_back( triggerPort_25a2);
		_argDeclBase_25a7.push_back( argDeclBase_25ab);
		_member_25b0.push_back( member_25b4);
		_localVar_25b9.push_back( localVar_25bd);
		_context_25c2.push_back( context_25c6);
		_unaryExprs_25cb.push_back( unaryExprs_25cf);
	}
	return isUnique;
}

bool EitherEdge_2587::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool EitherEdge_2587::isGuardTrue( SFC::ArgDeclBase& ArgDeclBase, SFC::Arg& Context, SFC::LocalVar& LocalVar, SFC::LocalVar& Member, CyPhyML::SignalFlow::TriggerPort& TriggerPort, SFC::UnaryExprs& UnaryExprs)
{
	bool Gz_guard= false;
	std::string trigger = TriggerPort.TriggerType();
Gz_guard = trigger == "either";;
	return Gz_guard;
}

void EitherEdge_2587::processInputPackets( const Packets_t& triggerPorts_2588, const Packets_t& argDeclBases_258a, const Packets_t& members_258d, const Packets_t& localVars_2590, const Packets_t& contexts_2593, const Packets_t& unaryExprss_2596)
{
	for( Packets_t::const_iterator itTriggerPort_259f= triggerPorts_2588.begin(), itArgDeclBase_25a8= argDeclBases_258a.begin(), itMember_25b1= members_258d.begin(), itLocalVar_25ba= localVars_2590.begin(), itContext_25c3= contexts_2593.begin(), itUnaryExprs_25cc= unaryExprss_2596.begin(); itTriggerPort_259f!= triggerPorts_2588.end(), itArgDeclBase_25a8!= argDeclBases_258a.end(), itMember_25b1!= members_258d.end(), itLocalVar_25ba!= localVars_2590.end(), itContext_25c3!= contexts_2593.end(), itUnaryExprs_25cc!= unaryExprss_2596.end(); ++itTriggerPort_259f, ++itArgDeclBase_25a8, ++itMember_25b1, ++itLocalVar_25ba, ++itContext_25c3, ++itUnaryExprs_25cc)
	{
		bool isUnique= isInputUnique( *itTriggerPort_259f, *itArgDeclBase_25a8, *itMember_25b1, *itLocalVar_25ba, *itContext_25c3, *itUnaryExprs_25cc);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itTriggerPort_259f, *itArgDeclBase_25a8, *itMember_25b1, *itLocalVar_25ba, *itContext_25c3, *itUnaryExprs_25cc);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.argDeclBase_25d9, currMatch.member_25da, currMatch.localVar_25db, currMatch.context_25dc, currMatch.unaryExprs_25dd);
	}
}

bool EitherEdge_2587::patternMatcher( const Udm::Object& triggerPort_25a0, const Udm::Object& argDeclBase_25a9, const Udm::Object& member_25b2, const Udm::Object& localVar_25bb, const Udm::Object& context_25c4, const Udm::Object& unaryExprs_25cd)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( triggerPort_25a0.type(), CyPhyML::SignalFlow::TriggerPort::meta))
			continue;
		CyPhyML::SignalFlow::TriggerPort triggerPort_25a5= CyPhyML::SignalFlow::TriggerPort::Cast( triggerPort_25a0);
		if( false== Uml::IsDerivedFrom( argDeclBase_25a9.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_25ae= SFC::ArgDeclBase::Cast( argDeclBase_25a9);
		if( false== Uml::IsDerivedFrom( member_25b2.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar member_25b7= SFC::LocalVar::Cast( member_25b2);
		if( false== Uml::IsDerivedFrom( localVar_25bb.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_25c0= SFC::LocalVar::Cast( localVar_25bb);
		if( false== Uml::IsDerivedFrom( context_25c4.type(), SFC::Arg::meta))
			continue;
		SFC::Arg context_25c9= SFC::Arg::Cast( context_25c4);
		if( false== Uml::IsDerivedFrom( unaryExprs_25cd.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_25d2= SFC::UnaryExprs::Cast( unaryExprs_25cd);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_25d7;
		if( !isValidBound(boundObjs_25d7, triggerPort_25a5, true))
			continue;
		currMatch.triggerPort_25d8= triggerPort_25a5;
		if( !isValidBound(boundObjs_25d7, argDeclBase_25ae, true))
			continue;
		currMatch.argDeclBase_25d9= argDeclBase_25ae;
		if( !isValidBound(boundObjs_25d7, member_25b7, true))
			continue;
		currMatch.member_25da= member_25b7;
		if( !isValidBound(boundObjs_25d7, localVar_25c0, true))
			continue;
		currMatch.localVar_25db= localVar_25c0;
		if( !isValidBound(boundObjs_25d7, context_25c9, true))
			continue;
		currMatch.context_25dc= context_25c9;
		if( !isValidBound(boundObjs_25d7, unaryExprs_25d2, true))
			continue;
		currMatch.unaryExprs_25dd= unaryExprs_25d2;
		bool Gz_guard= isGuardTrue( currMatch.argDeclBase_25d9, currMatch.context_25dc, currMatch.localVar_25db, currMatch.member_25da, currMatch.triggerPort_25d8, currMatch.unaryExprs_25dd);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void EitherEdge_2587::outputAppender( const SFC::ArgDeclBase& argDeclBase_25e4, const SFC::LocalVar& member_25e6, const SFC::LocalVar& localVar_25e8, const SFC::Arg& context_25ea, const SFC::UnaryExprs& unaryExprs_25ec)
{
	_argDeclBase_2599->push_back( argDeclBase_25e4);
	_member_259a->push_back( member_25e6);
	_localVar_259b->push_back( localVar_25e8);
	_context_259c->push_back( context_25ea);
	_unaryExprs_259d->push_back( unaryExprs_25ec);
}

void RisingEdge_25ee::operator()( const Packets_t& argDeclBases_25ef, const Packets_t& members_25f1, const Packets_t& localVars_25f3, const Packets_t& contexts_25f5, const Packets_t& unaryExprss_25f7)
{
#ifdef PRINT_INFO
	printLog("RisingEdge_25ee" );
#endif
	RTTGenerator::Instance()->generateRule(2404, "RisingEdge");
	processInputPackets( argDeclBases_25ef, members_25f1, localVars_25f3, contexts_25f5, unaryExprss_25f7);
}

bool RisingEdge_25ee::isInputUnique( const Udm::Object& argDeclBase_25fd, const Udm::Object& member_2606, const Udm::Object& localVar_260f, const Udm::Object& context_2618, const Udm::Object& unaryExprs_2621)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itArgDeclBase_25ff= _argDeclBase_25f9.begin(), itMember_2608= _member_2602.begin(), itLocalVar_2611= _localVar_260b.begin(), itContext_261a= _context_2614.begin(), itUnaryExprs_2623= _unaryExprs_261d.begin(); itArgDeclBase_25ff!= _argDeclBase_25f9.end(), itMember_2608!= _member_2602.end(), itLocalVar_2611!= _localVar_260b.end(), itContext_261a!= _context_2614.end(), itUnaryExprs_2623!= _unaryExprs_261d.end(); ++itArgDeclBase_25ff, ++itMember_2608, ++itLocalVar_2611, ++itContext_261a, ++itUnaryExprs_2623)
	{
		if( ( *itArgDeclBase_25ff== argDeclBase_25fd)&& ( *itMember_2608== member_2606)&& ( *itLocalVar_2611== localVar_260f)&& ( *itContext_261a== context_2618)&& ( *itUnaryExprs_2623== unaryExprs_2621))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_argDeclBase_25f9.push_back( argDeclBase_25fd);
		_member_2602.push_back( member_2606);
		_localVar_260b.push_back( localVar_260f);
		_context_2614.push_back( context_2618);
		_unaryExprs_261d.push_back( unaryExprs_2621);
	}
	return isUnique;
}

bool RisingEdge_25ee::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void RisingEdge_25ee::processInputPackets( const Packets_t& argDeclBases_25ef, const Packets_t& members_25f1, const Packets_t& localVars_25f3, const Packets_t& contexts_25f5, const Packets_t& unaryExprss_25f7)
{
	for( Packets_t::const_iterator itArgDeclBase_25fa= argDeclBases_25ef.begin(), itMember_2603= members_25f1.begin(), itLocalVar_260c= localVars_25f3.begin(), itContext_2615= contexts_25f5.begin(), itUnaryExprs_261e= unaryExprss_25f7.begin(); itArgDeclBase_25fa!= argDeclBases_25ef.end(), itMember_2603!= members_25f1.end(), itLocalVar_260c!= localVars_25f3.end(), itContext_2615!= contexts_25f5.end(), itUnaryExprs_261e!= unaryExprss_25f7.end(); ++itArgDeclBase_25fa, ++itMember_2603, ++itLocalVar_260c, ++itContext_2615, ++itUnaryExprs_261e)
	{
		bool isUnique= isInputUnique( *itArgDeclBase_25fa, *itMember_2603, *itLocalVar_260c, *itContext_2615, *itUnaryExprs_261e);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itArgDeclBase_25fa, *itMember_2603, *itLocalVar_260c, *itContext_2615, *itUnaryExprs_261e);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool RisingEdge_25ee::patternMatcher( const Udm::Object& argDeclBase_25fb, const Udm::Object& member_2604, const Udm::Object& localVar_260d, const Udm::Object& context_2616, const Udm::Object& unaryExprs_261f)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( argDeclBase_25fb.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_2600= SFC::ArgDeclBase::Cast( argDeclBase_25fb);
		if( false== Uml::IsDerivedFrom( member_2604.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar member_2609= SFC::LocalVar::Cast( member_2604);
		if( false== Uml::IsDerivedFrom( localVar_260d.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_2612= SFC::LocalVar::Cast( localVar_260d);
		if( false== Uml::IsDerivedFrom( context_2616.type(), SFC::Arg::meta))
			continue;
		SFC::Arg context_261b= SFC::Arg::Cast( context_2616);
		if( false== Uml::IsDerivedFrom( unaryExprs_261f.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_2624= SFC::UnaryExprs::Cast( unaryExprs_261f);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2629;
		if( !isValidBound(boundObjs_2629, argDeclBase_2600, true))
			continue;
		currMatch.argDeclBase_262a= argDeclBase_2600;
		if( !isValidBound(boundObjs_2629, member_2609, true))
			continue;
		currMatch.member_262b= member_2609;
		if( !isValidBound(boundObjs_2629, localVar_2612, true))
			continue;
		currMatch.localVar_262c= localVar_2612;
		if( !isValidBound(boundObjs_2629, context_261b, true))
			continue;
		currMatch.context_262d= context_261b;
		if( !isValidBound(boundObjs_2629, unaryExprs_2624, true))
			continue;
		currMatch.unaryExprs_262e= unaryExprs_2624;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void RisingEdge_25ee::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::BinaryExprs newAnd_262f= SFC::BinaryExprs::Create( currMatch.unaryExprs_262e, SFC::UnaryExprs::meta_subexpr);
		SFC::BinaryExprs newGreaterThan_2630= SFC::BinaryExprs::Create( newAnd_262f, SFC::BinaryExprs::meta_rightexpr);
		SFC::Int newZero2_2631= SFC::Int::Create( newGreaterThan_2630, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs newLessThan_2632= SFC::BinaryExprs::Create( newAnd_262f, SFC::BinaryExprs::meta_leftexpr);
		SFC::Int newZero_2633= SFC::Int::Create( newLessThan_2632, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs newArgDeclDot_2634= SFC::BinaryExprs::Create( newGreaterThan_2630, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef_2635= SFC::ArgDeclRef::Create( newArgDeclDot_2634, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newMemberRef_2636= SFC::ArgDeclRef::Create( newArgDeclDot_2634, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs newMemberDot_2637= SFC::BinaryExprs::Create( newLessThan_2632, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newMemberRef2_2638= SFC::ArgDeclRef::Create( newMemberDot_2637, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs newDot_2639= SFC::BinaryExprs::Create( newMemberDot_2637, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef3_263a= SFC::ArgDeclRef::Create( newDot_2639, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef2_263b= SFC::ArgDeclRef::Create( newDot_2639, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs& And= newAnd_262f;
		SFC::ArgDeclBase& ArgDeclBase= currMatch.argDeclBase_262a;
		SFC::BinaryExprs& ArgDeclDot= newArgDeclDot_2634;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_2635;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_263b;
		SFC::ArgDeclRef& ArgDeclRef3= newArgDeclRef3_263a;
		SFC::Arg& Context= currMatch.context_262d;
		SFC::BinaryExprs& Dot= newDot_2639;
		SFC::BinaryExprs& GreaterThan= newGreaterThan_2630;
		SFC::BinaryExprs& LessThan= newLessThan_2632;
		SFC::LocalVar& LocalVar= currMatch.localVar_262c;
		SFC::LocalVar& Member= currMatch.member_262b;
		SFC::BinaryExprs& MemberDot= newMemberDot_2637;
		SFC::ArgDeclRef& MemberRef= newMemberRef_2636;
		SFC::ArgDeclRef& MemberRef2= newMemberRef2_2638;
		SFC::UnaryExprs& UnaryExprs= currMatch.unaryExprs_262e;
		SFC::Int& Zero= newZero_2633;
		SFC::Int& Zero2= newZero2_2631;
		{
LessThan.op() = "<=";
};
		{
And.op() = "&&";
};
		{
GreaterThan.op() = ">";
};
		{
Dot.op() = ".";
};
		{
Zero.val() = 0;
};
		{
Zero2.val() = 0;
};
		{
MemberDot.op() = ".";
};
		{
ArgDeclDot.op() = ".";
};
		newArgDeclRef2_263b.argdecl()= currMatch.localVar_262c;
		newArgDeclRef_2635.argdecl()= currMatch.argDeclBase_262a;
		newArgDeclRef3_263a.argdecl()= currMatch.context_262d;
		newMemberRef_2636.argdecl()= currMatch.member_262b;
		newMemberRef2_2638.argdecl()= currMatch.member_262b;
	}
}

void FallingEdge_263c::operator()( const Packets_t& argDeclBases_263d, const Packets_t& members_263f, const Packets_t& localVars_2641, const Packets_t& contexts_2643, const Packets_t& unaryExprss_2645)
{
#ifdef PRINT_INFO
	printLog("FallingEdge_263c" );
#endif
	RTTGenerator::Instance()->generateRule(2449, "FallingEdge");
	processInputPackets( argDeclBases_263d, members_263f, localVars_2641, contexts_2643, unaryExprss_2645);
}

bool FallingEdge_263c::isInputUnique( const Udm::Object& argDeclBase_264b, const Udm::Object& member_2654, const Udm::Object& localVar_265d, const Udm::Object& context_2666, const Udm::Object& unaryExprs_266f)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itArgDeclBase_264d= _argDeclBase_2647.begin(), itMember_2656= _member_2650.begin(), itLocalVar_265f= _localVar_2659.begin(), itContext_2668= _context_2662.begin(), itUnaryExprs_2671= _unaryExprs_266b.begin(); itArgDeclBase_264d!= _argDeclBase_2647.end(), itMember_2656!= _member_2650.end(), itLocalVar_265f!= _localVar_2659.end(), itContext_2668!= _context_2662.end(), itUnaryExprs_2671!= _unaryExprs_266b.end(); ++itArgDeclBase_264d, ++itMember_2656, ++itLocalVar_265f, ++itContext_2668, ++itUnaryExprs_2671)
	{
		if( ( *itArgDeclBase_264d== argDeclBase_264b)&& ( *itMember_2656== member_2654)&& ( *itLocalVar_265f== localVar_265d)&& ( *itContext_2668== context_2666)&& ( *itUnaryExprs_2671== unaryExprs_266f))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_argDeclBase_2647.push_back( argDeclBase_264b);
		_member_2650.push_back( member_2654);
		_localVar_2659.push_back( localVar_265d);
		_context_2662.push_back( context_2666);
		_unaryExprs_266b.push_back( unaryExprs_266f);
	}
	return isUnique;
}

bool FallingEdge_263c::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void FallingEdge_263c::processInputPackets( const Packets_t& argDeclBases_263d, const Packets_t& members_263f, const Packets_t& localVars_2641, const Packets_t& contexts_2643, const Packets_t& unaryExprss_2645)
{
	for( Packets_t::const_iterator itArgDeclBase_2648= argDeclBases_263d.begin(), itMember_2651= members_263f.begin(), itLocalVar_265a= localVars_2641.begin(), itContext_2663= contexts_2643.begin(), itUnaryExprs_266c= unaryExprss_2645.begin(); itArgDeclBase_2648!= argDeclBases_263d.end(), itMember_2651!= members_263f.end(), itLocalVar_265a!= localVars_2641.end(), itContext_2663!= contexts_2643.end(), itUnaryExprs_266c!= unaryExprss_2645.end(); ++itArgDeclBase_2648, ++itMember_2651, ++itLocalVar_265a, ++itContext_2663, ++itUnaryExprs_266c)
	{
		bool isUnique= isInputUnique( *itArgDeclBase_2648, *itMember_2651, *itLocalVar_265a, *itContext_2663, *itUnaryExprs_266c);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itArgDeclBase_2648, *itMember_2651, *itLocalVar_265a, *itContext_2663, *itUnaryExprs_266c);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool FallingEdge_263c::patternMatcher( const Udm::Object& argDeclBase_2649, const Udm::Object& member_2652, const Udm::Object& localVar_265b, const Udm::Object& context_2664, const Udm::Object& unaryExprs_266d)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( argDeclBase_2649.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_264e= SFC::ArgDeclBase::Cast( argDeclBase_2649);
		if( false== Uml::IsDerivedFrom( member_2652.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar member_2657= SFC::LocalVar::Cast( member_2652);
		if( false== Uml::IsDerivedFrom( localVar_265b.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_2660= SFC::LocalVar::Cast( localVar_265b);
		if( false== Uml::IsDerivedFrom( context_2664.type(), SFC::Arg::meta))
			continue;
		SFC::Arg context_2669= SFC::Arg::Cast( context_2664);
		if( false== Uml::IsDerivedFrom( unaryExprs_266d.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_2672= SFC::UnaryExprs::Cast( unaryExprs_266d);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2677;
		if( !isValidBound(boundObjs_2677, argDeclBase_264e, true))
			continue;
		currMatch.argDeclBase_2678= argDeclBase_264e;
		if( !isValidBound(boundObjs_2677, member_2657, true))
			continue;
		currMatch.member_2679= member_2657;
		if( !isValidBound(boundObjs_2677, localVar_2660, true))
			continue;
		currMatch.localVar_267a= localVar_2660;
		if( !isValidBound(boundObjs_2677, context_2669, true))
			continue;
		currMatch.context_267b= context_2669;
		if( !isValidBound(boundObjs_2677, unaryExprs_2672, true))
			continue;
		currMatch.unaryExprs_267c= unaryExprs_2672;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void FallingEdge_263c::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::BinaryExprs newAnd_267d= SFC::BinaryExprs::Create( currMatch.unaryExprs_267c, SFC::UnaryExprs::meta_subexpr);
		SFC::BinaryExprs newLessThan_267e= SFC::BinaryExprs::Create( newAnd_267d, SFC::BinaryExprs::meta_rightexpr);
		SFC::Int newZero2_267f= SFC::Int::Create( newLessThan_267e, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs newGreaterThan_2680= SFC::BinaryExprs::Create( newAnd_267d, SFC::BinaryExprs::meta_leftexpr);
		SFC::Int newZero_2681= SFC::Int::Create( newGreaterThan_2680, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs newMemberDot_2682= SFC::BinaryExprs::Create( newGreaterThan_2680, SFC::BinaryExprs::meta_leftexpr);
		SFC::BinaryExprs newDot_2683= SFC::BinaryExprs::Create( newMemberDot_2682, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef3_2684= SFC::ArgDeclRef::Create( newDot_2683, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newArgDeclRef2_2685= SFC::ArgDeclRef::Create( newDot_2683, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newMemberRef2_2686= SFC::ArgDeclRef::Create( newMemberDot_2682, SFC::BinaryExprs::meta_rightexpr);
		SFC::BinaryExprs newArgDeclDot_2687= SFC::BinaryExprs::Create( newLessThan_267e, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclRef newMemberRef_2688= SFC::ArgDeclRef::Create( newArgDeclDot_2687, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef_2689= SFC::ArgDeclRef::Create( newArgDeclDot_2687, SFC::BinaryExprs::meta_leftexpr);
		SFC::BinaryExprs& And= newAnd_267d;
		SFC::ArgDeclBase& ArgDeclBase= currMatch.argDeclBase_2678;
		SFC::BinaryExprs& ArgDeclDot= newArgDeclDot_2687;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_2689;
		SFC::ArgDeclRef& ArgDeclRef2= newArgDeclRef2_2685;
		SFC::ArgDeclRef& ArgDeclRef3= newArgDeclRef3_2684;
		SFC::Arg& Context= currMatch.context_267b;
		SFC::BinaryExprs& Dot= newDot_2683;
		SFC::BinaryExprs& GreaterThan= newGreaterThan_2680;
		SFC::BinaryExprs& LessThan= newLessThan_267e;
		SFC::LocalVar& LocalVar= currMatch.localVar_267a;
		SFC::LocalVar& Member= currMatch.member_2679;
		SFC::BinaryExprs& MemberDot= newMemberDot_2682;
		SFC::ArgDeclRef& MemberRef= newMemberRef_2688;
		SFC::ArgDeclRef& MemberRef2= newMemberRef2_2686;
		SFC::UnaryExprs& UnaryExprs= currMatch.unaryExprs_267c;
		SFC::Int& Zero= newZero_2681;
		SFC::Int& Zero2= newZero2_267f;
		{
LessThan.op() = "<";
};
		{
And.op() = "&&";
};
		{
GreaterThan.op() = ">=";
};
		{
Dot.op() = ".";
};
		{
Zero.val() = 0;
};
		{
Zero2.val() = 0;
};
		{
ArgDeclDot.op() = ".";
};
		{
MemberDot.op() = ".";
};
		newArgDeclRef2_2685.argdecl()= currMatch.localVar_267a;
		newArgDeclRef_2689.argdecl()= currMatch.argDeclBase_2678;
		newArgDeclRef3_2684.argdecl()= currMatch.context_267b;
		newMemberRef2_2686.argdecl()= currMatch.member_2679;
		newMemberRef_2688.argdecl()= currMatch.member_2679;
	}
}

void EitherEdge_268a::operator()( const Packets_t& argDeclBases_268b, const Packets_t& members_268e, const Packets_t& localVars_2691, const Packets_t& contexts_2694, const Packets_t& unaryExprss_2697, Packets_t& argDeclBases_268d, Packets_t& members_2690, Packets_t& localVars_2693, Packets_t& contexts_2696, Packets_t& leftUnaryExprss_2699, Packets_t& rightUnaryExprss_269a)
{
#ifdef PRINT_INFO
	printLog("EitherEdge_268a" );
#endif
	RTTGenerator::Instance()->generateRule(2494, "EitherEdge");
	_argDeclBase_269b= &argDeclBases_268d;
	_member_269c= &members_2690;
	_localVar_269d= &localVars_2693;
	_context_269e= &contexts_2696;
	_leftUnaryExprs_269f= &leftUnaryExprss_2699;
	_rightUnaryExprs_26a0= &rightUnaryExprss_269a;
	processInputPackets( argDeclBases_268b, members_268e, localVars_2691, contexts_2694, unaryExprss_2697);
}

bool EitherEdge_268a::isInputUnique( const Udm::Object& argDeclBase_26a5, const Udm::Object& member_26ae, const Udm::Object& localVar_26b7, const Udm::Object& context_26c0, const Udm::Object& unaryExprs_26c9)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itArgDeclBase_26a7= _argDeclBase_26a1.begin(), itMember_26b0= _member_26aa.begin(), itLocalVar_26b9= _localVar_26b3.begin(), itContext_26c2= _context_26bc.begin(), itUnaryExprs_26cb= _unaryExprs_26c5.begin(); itArgDeclBase_26a7!= _argDeclBase_26a1.end(), itMember_26b0!= _member_26aa.end(), itLocalVar_26b9!= _localVar_26b3.end(), itContext_26c2!= _context_26bc.end(), itUnaryExprs_26cb!= _unaryExprs_26c5.end(); ++itArgDeclBase_26a7, ++itMember_26b0, ++itLocalVar_26b9, ++itContext_26c2, ++itUnaryExprs_26cb)
	{
		if( ( *itArgDeclBase_26a7== argDeclBase_26a5)&& ( *itMember_26b0== member_26ae)&& ( *itLocalVar_26b9== localVar_26b7)&& ( *itContext_26c2== context_26c0)&& ( *itUnaryExprs_26cb== unaryExprs_26c9))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_argDeclBase_26a1.push_back( argDeclBase_26a5);
		_member_26aa.push_back( member_26ae);
		_localVar_26b3.push_back( localVar_26b7);
		_context_26bc.push_back( context_26c0);
		_unaryExprs_26c5.push_back( unaryExprs_26c9);
	}
	return isUnique;
}

bool EitherEdge_268a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void EitherEdge_268a::processInputPackets( const Packets_t& argDeclBases_268b, const Packets_t& members_268e, const Packets_t& localVars_2691, const Packets_t& contexts_2694, const Packets_t& unaryExprss_2697)
{
	for( Packets_t::const_iterator itArgDeclBase_26a2= argDeclBases_268b.begin(), itMember_26ab= members_268e.begin(), itLocalVar_26b4= localVars_2691.begin(), itContext_26bd= contexts_2694.begin(), itUnaryExprs_26c6= unaryExprss_2697.begin(); itArgDeclBase_26a2!= argDeclBases_268b.end(), itMember_26ab!= members_268e.end(), itLocalVar_26b4!= localVars_2691.end(), itContext_26bd!= contexts_2694.end(), itUnaryExprs_26c6!= unaryExprss_2697.end(); ++itArgDeclBase_26a2, ++itMember_26ab, ++itLocalVar_26b4, ++itContext_26bd, ++itUnaryExprs_26c6)
	{
		bool isUnique= isInputUnique( *itArgDeclBase_26a2, *itMember_26ab, *itLocalVar_26b4, *itContext_26bd, *itUnaryExprs_26c6);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itArgDeclBase_26a2, *itMember_26ab, *itLocalVar_26b4, *itContext_26bd, *itUnaryExprs_26c6);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool EitherEdge_268a::patternMatcher( const Udm::Object& argDeclBase_26a3, const Udm::Object& member_26ac, const Udm::Object& localVar_26b5, const Udm::Object& context_26be, const Udm::Object& unaryExprs_26c7)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( argDeclBase_26a3.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_26a8= SFC::ArgDeclBase::Cast( argDeclBase_26a3);
		if( false== Uml::IsDerivedFrom( member_26ac.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar member_26b1= SFC::LocalVar::Cast( member_26ac);
		if( false== Uml::IsDerivedFrom( localVar_26b5.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_26ba= SFC::LocalVar::Cast( localVar_26b5);
		if( false== Uml::IsDerivedFrom( context_26be.type(), SFC::Arg::meta))
			continue;
		SFC::Arg context_26c3= SFC::Arg::Cast( context_26be);
		if( false== Uml::IsDerivedFrom( unaryExprs_26c7.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_26cc= SFC::UnaryExprs::Cast( unaryExprs_26c7);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_26d1;
		if( !isValidBound(boundObjs_26d1, argDeclBase_26a8, true))
			continue;
		currMatch.argDeclBase_26d2= argDeclBase_26a8;
		if( !isValidBound(boundObjs_26d1, member_26b1, true))
			continue;
		currMatch.member_26d3= member_26b1;
		if( !isValidBound(boundObjs_26d1, localVar_26ba, true))
			continue;
		currMatch.localVar_26d4= localVar_26ba;
		if( !isValidBound(boundObjs_26d1, context_26c3, true))
			continue;
		currMatch.context_26d5= context_26c3;
		if( !isValidBound(boundObjs_26d1, unaryExprs_26cc, true))
			continue;
		currMatch.unaryExprs_26d6= unaryExprs_26cc;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void EitherEdge_268a::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::BinaryExprs newOr_26d7= SFC::BinaryExprs::Create( currMatch.unaryExprs_26d6, SFC::UnaryExprs::meta_subexpr);
		SFC::UnaryExprs newLeftUnaryExprs_26d8= SFC::UnaryExprs::Create( newOr_26d7, SFC::BinaryExprs::meta_leftexpr);
		SFC::UnaryExprs newRightUnaryExprs_26d9= SFC::UnaryExprs::Create( newOr_26d7, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclBase& ArgDeclBase= currMatch.argDeclBase_26d2;
		SFC::Arg& Context= currMatch.context_26d5;
		SFC::UnaryExprs& LeftUnaryExprs= newLeftUnaryExprs_26d8;
		SFC::LocalVar& LocalVar= currMatch.localVar_26d4;
		SFC::LocalVar& Member= currMatch.member_26d3;
		SFC::BinaryExprs& Or= newOr_26d7;
		SFC::UnaryExprs& RightUnaryExprs= newRightUnaryExprs_26d9;
		SFC::UnaryExprs& UnaryExprs= currMatch.unaryExprs_26d6;
		{
LeftUnaryExprs.op() = "";
};
		{
RightUnaryExprs.op() = "";
};
		{
Or.op() = "||";
};
		outputAppender( currMatch.argDeclBase_26d2, currMatch.member_26d3, currMatch.localVar_26d4, currMatch.context_26d5, newLeftUnaryExprs_26d8, newRightUnaryExprs_26d9);
	}
}

void EitherEdge_268a::outputAppender( const SFC::ArgDeclBase& argDeclBase_26da, const SFC::LocalVar& member_26dc, const SFC::LocalVar& localVar_26de, const SFC::Arg& context_26e0, const SFC::UnaryExprs& leftUnaryExprs_26e2, const SFC::UnaryExprs& rightUnaryExprs_26e4)
{
	_argDeclBase_269b->push_back( argDeclBase_26da);
	_member_269c->push_back( member_26dc);
	_localVar_269d->push_back( localVar_26de);
	_context_269e->push_back( context_26e0);
	_leftUnaryExprs_269f->push_back( leftUnaryExprs_26e2);
	_rightUnaryExprs_26a0->push_back( rightUnaryExprs_26e4);
}

void AddMatrixTriggerVars_271a::operator()( const Packets_t& triggers_271b, const Packets_t& argdecls_271d, const Packets_t& dts_271f, const Packets_t& oldvals_2721, const Packets_t& contexts_2723, const Packets_t& functions_2725, Packets_t& triggers_2727, Packets_t& argdecls_2728, Packets_t& dts_2729, Packets_t& oldvals_272a, Packets_t& contexts_272b, Packets_t& functions_272c)
{
#ifdef PRINT_INFO
	printLog("AddMatrixTriggerVars_271a" );
#endif
	_trigger_272d= &triggers_2727;
	_argdecl_272e= &argdecls_2728;
	_dt_272f= &dts_2729;
	_oldval_2730= &oldvals_272a;
	_context_2731= &contexts_272b;
	_function_2732= &functions_272c;
	_trigger_272d->insert( _trigger_272d->end(), triggers_271b.begin(), triggers_271b.end());
	_argdecl_272e->insert( _argdecl_272e->end(), argdecls_271d.begin(), argdecls_271d.end());
	_dt_272f->insert( _dt_272f->end(), dts_271f.begin(), dts_271f.end());
	_oldval_2730->insert( _oldval_2730->end(), oldvals_2721.begin(), oldvals_2721.end());
	_context_2731->insert( _context_2731->end(), contexts_2723.begin(), contexts_2723.end());
	_function_2732->insert( _function_2732->end(), functions_2725.begin(), functions_2725.end());
	if( ( !triggers_271b.empty())&& ( !argdecls_271d.empty())&& ( !dts_271f.empty())&& ( !oldvals_2721.empty())&& ( !contexts_2723.empty())&& ( !functions_2725.empty()))
		callAddTriggerVar_2a14( triggers_271b, argdecls_271d, dts_271f, oldvals_2721, contexts_2723, functions_2725);
}

void AddMatrixTriggerVars_271a::callAddTriggerVar_2a14( const Packets_t& triggerPorts_2734, const Packets_t& argDeclBases_2737, const Packets_t& dTs_273a, const Packets_t& localVars_273c, const Packets_t& contexts_273f, const Packets_t& functions_2743)
{
	Packets_t triggerPorts_2736;
	Packets_t argDeclBases_2739;
	Packets_t localVars_273e;
	Packets_t contexts_2741;
	Packets_t triggerVars_2742;
	Packets_t functions_2745;
	AddTriggerVar_2733 addTriggerVar_2733;
	addTriggerVar_2733( triggerPorts_2734, argDeclBases_2737, dTs_273a, localVars_273c, contexts_273f, functions_2743, triggerPorts_2736, argDeclBases_2739, localVars_273e, contexts_2741, triggerVars_2742, functions_2745);
	if( ( !triggerPorts_2736.empty())&& ( !argDeclBases_2739.empty())&& ( !localVars_273e.empty())&& ( !contexts_2741.empty())&& ( !triggerVars_2742.empty())&& ( !functions_2745.empty()))
		callStartAssignment_2a1b( triggerPorts_2736, argDeclBases_2739, localVars_273e, contexts_2741, triggerVars_2742, functions_2745);
}

void AddMatrixTriggerVars_271a::callStartAssignment_2a1b( const Packets_t& triggerPorts_27a0, const Packets_t& argDeclBases_27a3, const Packets_t& oldvals_27a6, const Packets_t& contexts_27a9, const Packets_t& triggerVars_27ac, const Packets_t& functions_27ae)
{
	Packets_t triggerPorts_27a2;
	Packets_t argDeclBases_27a5;
	Packets_t oldvals_27a8;
	Packets_t contexts_27ab;
	Packets_t unaryExprss_27b0;
	StartAssignment_279f startAssignment_279f;
	startAssignment_279f( triggerPorts_27a0, argDeclBases_27a3, oldvals_27a6, contexts_27a9, triggerVars_27ac, functions_27ae, triggerPorts_27a2, argDeclBases_27a5, oldvals_27a8, contexts_27ab, unaryExprss_27b0);
	if( ( !triggerPorts_27a2.empty())&& ( !argDeclBases_27a5.empty())&& ( !oldvals_27a8.empty())&& ( !contexts_27ab.empty())&& ( !unaryExprss_27b0.empty()))
		callEdgeTest_2a22( triggerPorts_27a2, argDeclBases_27a5, oldvals_27a8, contexts_27ab, unaryExprss_27b0);
}

void AddMatrixTriggerVars_271a::callEdgeTest_2a22( const Packets_t& triggers_2805, const Packets_t& argdecls_2807, const Packets_t& oldvals_2809, const Packets_t& contexts_280b, const Packets_t& initexprs_280d)
{
	Packets_t argdecls_280f;
	Packets_t oldvals_2810;
	Packets_t contexts_2811;
	Packets_t initexprs_2812;
	Packets_t argdecls_2813;
	Packets_t oldvals_2814;
	Packets_t contexts_2815;
	Packets_t initexprs_2816;
	Packets_t argdecls_2817;
	Packets_t oldvals_2818;
	Packets_t contexts_2819;
	Packets_t initexprs_281a;
	EdgeTest_2804 edgeTest_2804;
	edgeTest_2804( triggers_2805, argdecls_2807, oldvals_2809, contexts_280b, initexprs_280d, argdecls_280f, oldvals_2810, contexts_2811, initexprs_2812, argdecls_2813, oldvals_2814, contexts_2815, initexprs_2816, argdecls_2817, oldvals_2818, contexts_2819, initexprs_281a);
	if( ( !argdecls_280f.empty())&& ( !oldvals_2810.empty())&& ( !contexts_2811.empty())&& ( !initexprs_2812.empty()))
		callRisingEdge_2a28( argdecls_280f, oldvals_2810, contexts_2811, initexprs_2812);
	if( ( !argdecls_2813.empty())&& ( !oldvals_2814.empty())&& ( !contexts_2815.empty())&& ( !initexprs_2816.empty()))
		callFallingEdge_2a2d( argdecls_2813, oldvals_2814, contexts_2815, initexprs_2816);
	if( ( !argdecls_2817.empty())&& ( !oldvals_2818.empty())&& ( !contexts_2819.empty())&& ( !initexprs_281a.empty()))
		callEitherEdge_2a32( argdecls_2817, oldvals_2818, contexts_2819, initexprs_281a);
}

void AddMatrixTriggerVars_271a::callRisingEdge_2a28( const Packets_t& argDeclBases_294d, const Packets_t& localVars_294f, const Packets_t& contexts_2951, const Packets_t& unaryExprss_2953)
{
	RisingEdge_294c risingEdge_294c;
	risingEdge_294c( argDeclBases_294d, localVars_294f, contexts_2951, unaryExprss_2953);
}

void AddMatrixTriggerVars_271a::callFallingEdge_2a2d( const Packets_t& argDeclBases_298b, const Packets_t& localVars_298d, const Packets_t& contexts_298f, const Packets_t& unaryExprss_2991)
{
	FallingEdge_298a fallingEdge_298a;
	fallingEdge_298a( argDeclBases_298b, localVars_298d, contexts_298f, unaryExprss_2991);
}

void AddMatrixTriggerVars_271a::callEitherEdge_2a32( const Packets_t& argDeclBases_29c9, const Packets_t& localVars_29cc, const Packets_t& contexts_29cf, const Packets_t& unaryExprss_29d2)
{
	Packets_t argDeclBases_29cb;
	Packets_t localVars_29ce;
	Packets_t contexts_29d1;
	Packets_t leftUnaryExprss_29d4;
	Packets_t rightUnaryExprss_29d5;
	EitherEdge_29c8 eitherEdge_29c8;
	eitherEdge_29c8( argDeclBases_29c9, localVars_29cc, contexts_29cf, unaryExprss_29d2, argDeclBases_29cb, localVars_29ce, contexts_29d1, leftUnaryExprss_29d4, rightUnaryExprss_29d5);
	if( ( !argDeclBases_29cb.empty())&& ( !localVars_29ce.empty())&& ( !contexts_29d1.empty())&& ( !leftUnaryExprss_29d4.empty()))
		callRisingEdge_2a37( argDeclBases_29cb, localVars_29ce, contexts_29d1, leftUnaryExprss_29d4);
	if( ( !argDeclBases_29cb.empty())&& ( !localVars_29ce.empty())&& ( !contexts_29d1.empty())&& ( !rightUnaryExprss_29d5.empty()))
		callFallingEdge_2a3c( argDeclBases_29cb, localVars_29ce, contexts_29d1, rightUnaryExprss_29d5);
}

void AddMatrixTriggerVars_271a::callRisingEdge_2a37( const Packets_t& argDeclBases_294d, const Packets_t& localVars_294f, const Packets_t& contexts_2951, const Packets_t& unaryExprss_2953)
{
	RisingEdge_294c risingEdge_294c;
	risingEdge_294c( argDeclBases_294d, localVars_294f, contexts_2951, unaryExprss_2953);
}

void AddMatrixTriggerVars_271a::callFallingEdge_2a3c( const Packets_t& argDeclBases_298b, const Packets_t& localVars_298d, const Packets_t& contexts_298f, const Packets_t& unaryExprss_2991)
{
	FallingEdge_298a fallingEdge_298a;
	fallingEdge_298a( argDeclBases_298b, localVars_298d, contexts_298f, unaryExprss_2991);
}

void AddTriggerVar_2733::operator()( const Packets_t& triggerPorts_2734, const Packets_t& argDeclBases_2737, const Packets_t& dTs_273a, const Packets_t& localVars_273c, const Packets_t& contexts_273f, const Packets_t& functions_2743, Packets_t& triggerPorts_2736, Packets_t& argDeclBases_2739, Packets_t& localVars_273e, Packets_t& contexts_2741, Packets_t& triggerVars_2742, Packets_t& functions_2745)
{
#ifdef PRINT_INFO
	printLog("AddTriggerVar_2733" );
#endif
	RTTGenerator::Instance()->generateRule(2522, "AddTriggerVar");
	_triggerPort_2746= &triggerPorts_2736;
	_argDeclBase_2747= &argDeclBases_2739;
	_localVar_2748= &localVars_273e;
	_context_2749= &contexts_2741;
	_triggerVar_274a= &triggerVars_2742;
	_function_274b= &functions_2745;
	processInputPackets( triggerPorts_2734, argDeclBases_2737, dTs_273a, localVars_273c, contexts_273f, functions_2743);
}

bool AddTriggerVar_2733::isInputUnique( const Udm::Object& triggerPort_2750, const Udm::Object& argDeclBase_2759, const Udm::Object& dT_2762, const Udm::Object& localVar_276b, const Udm::Object& context_2774, const Udm::Object& function_277d)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itTriggerPort_2752= _triggerPort_274c.begin(), itArgDeclBase_275b= _argDeclBase_2755.begin(), itDT_2764= _dT_275e.begin(), itLocalVar_276d= _localVar_2767.begin(), itContext_2776= _context_2770.begin(), itFunction_277f= _function_2779.begin(); itTriggerPort_2752!= _triggerPort_274c.end(), itArgDeclBase_275b!= _argDeclBase_2755.end(), itDT_2764!= _dT_275e.end(), itLocalVar_276d!= _localVar_2767.end(), itContext_2776!= _context_2770.end(), itFunction_277f!= _function_2779.end(); ++itTriggerPort_2752, ++itArgDeclBase_275b, ++itDT_2764, ++itLocalVar_276d, ++itContext_2776, ++itFunction_277f)
	{
		if( ( *itTriggerPort_2752== triggerPort_2750)&& ( *itArgDeclBase_275b== argDeclBase_2759)&& ( *itDT_2764== dT_2762)&& ( *itLocalVar_276d== localVar_276b)&& ( *itContext_2776== context_2774)&& ( *itFunction_277f== function_277d))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_triggerPort_274c.push_back( triggerPort_2750);
		_argDeclBase_2755.push_back( argDeclBase_2759);
		_dT_275e.push_back( dT_2762);
		_localVar_2767.push_back( localVar_276b);
		_context_2770.push_back( context_2774);
		_function_2779.push_back( function_277d);
	}
	return isUnique;
}

bool AddTriggerVar_2733::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool AddTriggerVar_2733::isGuardTrue( SFC::ArgDeclBase& ArgDeclBase, SFC::Arg& Context, SFC::DT& DT, SFC::Function& Function, SFC::LocalVar& LocalVar, CyPhyML::SignalFlow::TriggerPort& TriggerPort)
{
	bool Gz_guard= false;
	Gz_guard = DT.type() != SFC::Struct::meta;;
	return Gz_guard;
}

void AddTriggerVar_2733::processInputPackets( const Packets_t& triggerPorts_2734, const Packets_t& argDeclBases_2737, const Packets_t& dTs_273a, const Packets_t& localVars_273c, const Packets_t& contexts_273f, const Packets_t& functions_2743)
{
	for( Packets_t::const_iterator itTriggerPort_274d= triggerPorts_2734.begin(), itArgDeclBase_2756= argDeclBases_2737.begin(), itDT_275f= dTs_273a.begin(), itLocalVar_2768= localVars_273c.begin(), itContext_2771= contexts_273f.begin(), itFunction_277a= functions_2743.begin(); itTriggerPort_274d!= triggerPorts_2734.end(), itArgDeclBase_2756!= argDeclBases_2737.end(), itDT_275f!= dTs_273a.end(), itLocalVar_2768!= localVars_273c.end(), itContext_2771!= contexts_273f.end(), itFunction_277a!= functions_2743.end(); ++itTriggerPort_274d, ++itArgDeclBase_2756, ++itDT_275f, ++itLocalVar_2768, ++itContext_2771, ++itFunction_277a)
	{
		bool isUnique= isInputUnique( *itTriggerPort_274d, *itArgDeclBase_2756, *itDT_275f, *itLocalVar_2768, *itContext_2771, *itFunction_277a);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itTriggerPort_274d, *itArgDeclBase_2756, *itDT_275f, *itLocalVar_2768, *itContext_2771, *itFunction_277a);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool AddTriggerVar_2733::patternMatcher( const Udm::Object& triggerPort_274e, const Udm::Object& argDeclBase_2757, const Udm::Object& dT_2760, const Udm::Object& localVar_2769, const Udm::Object& context_2772, const Udm::Object& function_277b)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( triggerPort_274e.type(), CyPhyML::SignalFlow::TriggerPort::meta))
			continue;
		CyPhyML::SignalFlow::TriggerPort triggerPort_2753= CyPhyML::SignalFlow::TriggerPort::Cast( triggerPort_274e);
		if( false== Uml::IsDerivedFrom( argDeclBase_2757.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_275c= SFC::ArgDeclBase::Cast( argDeclBase_2757);
		if( false== Uml::IsDerivedFrom( dT_2760.type(), SFC::DT::meta))
			continue;
		SFC::DT dT_2765= SFC::DT::Cast( dT_2760);
		if( false== Uml::IsDerivedFrom( localVar_2769.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_276e= SFC::LocalVar::Cast( localVar_2769);
		if( false== Uml::IsDerivedFrom( context_2772.type(), SFC::Arg::meta))
			continue;
		SFC::Arg context_2777= SFC::Arg::Cast( context_2772);
		if( false== Uml::IsDerivedFrom( function_277b.type(), SFC::Function::meta))
			continue;
		SFC::Function function_2780= SFC::Function::Cast( function_277b);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_2785;
		if( !isValidBound(boundObjs_2785, triggerPort_2753, true))
			continue;
		currMatch.triggerPort_2786= triggerPort_2753;
		if( !isValidBound(boundObjs_2785, argDeclBase_275c, true))
			continue;
		currMatch.argDeclBase_2787= argDeclBase_275c;
		if( !isValidBound(boundObjs_2785, dT_2765, true))
			continue;
		currMatch.dT_2788= dT_2765;
		if( !isValidBound(boundObjs_2785, localVar_276e, true))
			continue;
		currMatch.localVar_2789= localVar_276e;
		if( !isValidBound(boundObjs_2785, context_2777, true))
			continue;
		currMatch.context_278a= context_2777;
		if( !isValidBound(boundObjs_2785, function_2780, true))
			continue;
		currMatch.function_278b= function_2780;
		bool Gz_guard= isGuardTrue( currMatch.argDeclBase_2787, currMatch.context_278a, currMatch.dT_2788, currMatch.function_278b, currMatch.localVar_2789, currMatch.triggerPort_2786);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void AddTriggerVar_2733::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::LocalVar newTriggerVar_2792= SFC::LocalVar::Create( currMatch.function_278b, SFC::Function::meta_stmnt);
		SFC::ArgDeclBase& ArgDeclBase= currMatch.argDeclBase_2787;
		SFC::Arg& Context= currMatch.context_278a;
		SFC::DT& DT= currMatch.dT_2788;
		SFC::Function& Function= currMatch.function_278b;
		SFC::LocalVar& LocalVar= currMatch.localVar_2789;
		CyPhyML::SignalFlow::TriggerPort& TriggerPort= currMatch.triggerPort_2786;
		SFC::LocalVar& TriggerVar= newTriggerVar_2792;
		{
__int64 statementCount = Function.statementCount();
TriggerVar.statementIndex() = statementCount++;
Function.statementCount() = statementCount;
};
		{
TriggerVar.type() = "int";
TriggerVar.name() = std::string( "event" ) + boost::lexical_cast< std::string >( TriggerVar.uniqueId() );
};
		newTriggerVar_2792.dt()= currMatch.dT_2788;
		currMatch.localVar_2789.trigvar()= newTriggerVar_2792;
		outputAppender( currMatch.triggerPort_2786, currMatch.argDeclBase_2787, currMatch.localVar_2789, currMatch.context_278a, newTriggerVar_2792, currMatch.function_278b);
	}
}

void AddTriggerVar_2733::outputAppender( const CyPhyML::SignalFlow::TriggerPort& triggerPort_2793, const SFC::ArgDeclBase& argDeclBase_2795, const SFC::LocalVar& localVar_2797, const SFC::Arg& context_2799, const SFC::LocalVar& triggerVar_279b, const SFC::Function& function_279d)
{
	_triggerPort_2746->push_back( triggerPort_2793);
	_argDeclBase_2747->push_back( argDeclBase_2795);
	_localVar_2748->push_back( localVar_2797);
	_context_2749->push_back( context_2799);
	_triggerVar_274a->push_back( triggerVar_279b);
	_function_274b->push_back( function_279d);
}

void StartAssignment_279f::operator()( const Packets_t& triggerPorts_27a0, const Packets_t& argDeclBases_27a3, const Packets_t& oldvals_27a6, const Packets_t& contexts_27a9, const Packets_t& triggerVars_27ac, const Packets_t& functions_27ae, Packets_t& triggerPorts_27a2, Packets_t& argDeclBases_27a5, Packets_t& oldvals_27a8, Packets_t& contexts_27ab, Packets_t& unaryExprss_27b0)
{
#ifdef PRINT_INFO
	printLog("StartAssignment_279f" );
#endif
	RTTGenerator::Instance()->generateRule(2535, "StartAssignment");
	_triggerPort_27b1= &triggerPorts_27a2;
	_argDeclBase_27b2= &argDeclBases_27a5;
	_oldval_27b3= &oldvals_27a8;
	_context_27b4= &contexts_27ab;
	_unaryExprs_27b5= &unaryExprss_27b0;
	processInputPackets( triggerPorts_27a0, argDeclBases_27a3, oldvals_27a6, contexts_27a9, triggerVars_27ac, functions_27ae);
}

bool StartAssignment_279f::isInputUnique( const Udm::Object& triggerPort_27ba, const Udm::Object& argDeclBase_27c3, const Udm::Object& oldval_27cc, const Udm::Object& context_27d5, const Udm::Object& triggerVar_27de, const Udm::Object& function_27e7)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itTriggerPort_27bc= _triggerPort_27b6.begin(), itArgDeclBase_27c5= _argDeclBase_27bf.begin(), itoldval_27ce= _oldval_27c8.begin(), itContext_27d7= _context_27d1.begin(), itTriggerVar_27e0= _triggerVar_27da.begin(), itFunction_27e9= _function_27e3.begin(); itTriggerPort_27bc!= _triggerPort_27b6.end(), itArgDeclBase_27c5!= _argDeclBase_27bf.end(), itoldval_27ce!= _oldval_27c8.end(), itContext_27d7!= _context_27d1.end(), itTriggerVar_27e0!= _triggerVar_27da.end(), itFunction_27e9!= _function_27e3.end(); ++itTriggerPort_27bc, ++itArgDeclBase_27c5, ++itoldval_27ce, ++itContext_27d7, ++itTriggerVar_27e0, ++itFunction_27e9)
	{
		if( ( *itTriggerPort_27bc== triggerPort_27ba)&& ( *itArgDeclBase_27c5== argDeclBase_27c3)&& ( *itoldval_27ce== oldval_27cc)&& ( *itContext_27d7== context_27d5)&& ( *itTriggerVar_27e0== triggerVar_27de)&& ( *itFunction_27e9== function_27e7))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_triggerPort_27b6.push_back( triggerPort_27ba);
		_argDeclBase_27bf.push_back( argDeclBase_27c3);
		_oldval_27c8.push_back( oldval_27cc);
		_context_27d1.push_back( context_27d5);
		_triggerVar_27da.push_back( triggerVar_27de);
		_function_27e3.push_back( function_27e7);
	}
	return isUnique;
}

bool StartAssignment_279f::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

void StartAssignment_279f::processInputPackets( const Packets_t& triggerPorts_27a0, const Packets_t& argDeclBases_27a3, const Packets_t& oldvals_27a6, const Packets_t& contexts_27a9, const Packets_t& triggerVars_27ac, const Packets_t& functions_27ae)
{
	for( Packets_t::const_iterator itTriggerPort_27b7= triggerPorts_27a0.begin(), itArgDeclBase_27c0= argDeclBases_27a3.begin(), itoldval_27c9= oldvals_27a6.begin(), itContext_27d2= contexts_27a9.begin(), itTriggerVar_27db= triggerVars_27ac.begin(), itFunction_27e4= functions_27ae.begin(); itTriggerPort_27b7!= triggerPorts_27a0.end(), itArgDeclBase_27c0!= argDeclBases_27a3.end(), itoldval_27c9!= oldvals_27a6.end(), itContext_27d2!= contexts_27a9.end(), itTriggerVar_27db!= triggerVars_27ac.end(), itFunction_27e4!= functions_27ae.end(); ++itTriggerPort_27b7, ++itArgDeclBase_27c0, ++itoldval_27c9, ++itContext_27d2, ++itTriggerVar_27db, ++itFunction_27e4)
	{
		bool isUnique= isInputUnique( *itTriggerPort_27b7, *itArgDeclBase_27c0, *itoldval_27c9, *itContext_27d2, *itTriggerVar_27db, *itFunction_27e4);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itTriggerPort_27b7, *itArgDeclBase_27c0, *itoldval_27c9, *itContext_27d2, *itTriggerVar_27db, *itFunction_27e4);
		if( isMatch)
			effector( );
		_matches.clear();
	}
}

bool StartAssignment_279f::patternMatcher( const Udm::Object& triggerPort_27b8, const Udm::Object& argDeclBase_27c1, const Udm::Object& oldval_27ca, const Udm::Object& context_27d3, const Udm::Object& triggerVar_27dc, const Udm::Object& function_27e5)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( triggerPort_27b8.type(), CyPhyML::SignalFlow::TriggerPort::meta))
			continue;
		CyPhyML::SignalFlow::TriggerPort triggerPort_27bd= CyPhyML::SignalFlow::TriggerPort::Cast( triggerPort_27b8);
		if( false== Uml::IsDerivedFrom( argDeclBase_27c1.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_27c6= SFC::ArgDeclBase::Cast( argDeclBase_27c1);
		if( false== Uml::IsDerivedFrom( oldval_27ca.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar oldval_27cf= SFC::LocalVar::Cast( oldval_27ca);
		if( false== Uml::IsDerivedFrom( context_27d3.type(), SFC::Arg::meta))
			continue;
		SFC::Arg context_27d8= SFC::Arg::Cast( context_27d3);
		if( false== Uml::IsDerivedFrom( triggerVar_27dc.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar triggerVar_27e1= SFC::LocalVar::Cast( triggerVar_27dc);
		if( false== Uml::IsDerivedFrom( function_27e5.type(), SFC::Function::meta))
			continue;
		SFC::Function function_27ea= SFC::Function::Cast( function_27e5);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_27ef;
		if( !isValidBound(boundObjs_27ef, triggerPort_27bd, true))
			continue;
		currMatch.triggerPort_27f0= triggerPort_27bd;
		if( !isValidBound(boundObjs_27ef, argDeclBase_27c6, true))
			continue;
		currMatch.argDeclBase_27f1= argDeclBase_27c6;
		if( !isValidBound(boundObjs_27ef, oldval_27cf, true))
			continue;
		currMatch.oldval_27f2= oldval_27cf;
		if( !isValidBound(boundObjs_27ef, context_27d8, true))
			continue;
		currMatch.context_27f3= context_27d8;
		if( !isValidBound(boundObjs_27ef, triggerVar_27e1, true))
			continue;
		currMatch.triggerVar_27f4= triggerVar_27e1;
		if( !isValidBound(boundObjs_27ef, function_27ea, true))
			continue;
		currMatch.function_27f5= function_27ea;
		_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void StartAssignment_279f::effector()
{
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		SFC::UserCode newAssignment_27f6= SFC::UserCode::Create( currMatch.function_27f5, SFC::Function::meta_stmnt);
		SFC::BinaryExprs newAssign_27f7= SFC::BinaryExprs::Create( newAssignment_27f6, SFC::UserCode::meta_codeexpr);
		SFC::UnaryExprs newUnaryExprs_27f8= SFC::UnaryExprs::Create( newAssign_27f7, SFC::BinaryExprs::meta_rightexpr);
		SFC::ArgDeclRef newArgDeclRef_27f9= SFC::ArgDeclRef::Create( newAssign_27f7, SFC::BinaryExprs::meta_leftexpr);
		SFC::ArgDeclBase& ArgDeclBase= currMatch.argDeclBase_27f1;
		SFC::ArgDeclRef& ArgDeclRef= newArgDeclRef_27f9;
		SFC::BinaryExprs& Assign= newAssign_27f7;
		SFC::UserCode& Assignment= newAssignment_27f6;
		SFC::Arg& Context= currMatch.context_27f3;
		SFC::Function& Function= currMatch.function_27f5;
		CyPhyML::SignalFlow::TriggerPort& TriggerPort= currMatch.triggerPort_27f0;
		SFC::LocalVar& TriggerVar= currMatch.triggerVar_27f4;
		SFC::UnaryExprs& UnaryExprs= newUnaryExprs_27f8;
		SFC::LocalVar& oldval= currMatch.oldval_27f2;
		{
UnaryExprs.op() = "";
};
		{
__int64 statementCount = Function.statementCount();
Assignment.statementIndex() = statementCount++;
Function.statementCount() = statementCount;
};
		{
Assign.op() = "=";
};
		newArgDeclRef_27f9.argdecl()= currMatch.triggerVar_27f4;
		outputAppender( currMatch.triggerPort_27f0, currMatch.argDeclBase_27f1, currMatch.oldval_27f2, currMatch.context_27f3, newUnaryExprs_27f8);
	}
}

void StartAssignment_279f::outputAppender( const CyPhyML::SignalFlow::TriggerPort& triggerPort_27fa, const SFC::ArgDeclBase& argDeclBase_27fc, const SFC::LocalVar& oldval_27fe, const SFC::Arg& context_2800, const SFC::UnaryExprs& unaryExprs_2802)
{
	_triggerPort_27b1->push_back( triggerPort_27fa);
	_argDeclBase_27b2->push_back( argDeclBase_27fc);
	_oldval_27b3->push_back( oldval_27fe);
	_context_27b4->push_back( context_2800);
	_unaryExprs_27b5->push_back( unaryExprs_2802);
}

void EdgeTest_2804::operator()( const Packets_t& triggers_2805, const Packets_t& argdecls_2807, const Packets_t& oldvals_2809, const Packets_t& contexts_280b, const Packets_t& initexprs_280d, Packets_t& argdecls_280f, Packets_t& oldvals_2810, Packets_t& contexts_2811, Packets_t& initexprs_2812, Packets_t& argdecls_2813, Packets_t& oldvals_2814, Packets_t& contexts_2815, Packets_t& initexprs_2816, Packets_t& argdecls_2817, Packets_t& oldvals_2818, Packets_t& contexts_2819, Packets_t& initexprs_281a)
{
#ifdef PRINT_INFO
	printLog("EdgeTest_2804" );
#endif
	_argdecl_281b= &argdecls_280f;
	_oldval_281c= &oldvals_2810;
	_context_281d= &contexts_2811;
	_initexpr_281e= &initexprs_2812;
	_argdecl_281f= &argdecls_2813;
	_oldval_2820= &oldvals_2814;
	_context_2821= &contexts_2815;
	_initexpr_2822= &initexprs_2816;
	_argdecl_2823= &argdecls_2817;
	_oldval_2824= &oldvals_2818;
	_context_2825= &contexts_2819;
	_initexpr_2826= &initexprs_281a;
	for( Packets_t::const_iterator ittrigger_2828= triggers_2805.begin(), itargdecl_282f= argdecls_2807.begin(), itoldval_2836= oldvals_2809.begin(), itcontext_283d= contexts_280b.begin(), itinitexpr_2844= initexprs_280d.begin(); ittrigger_2828!= triggers_2805.end(), itargdecl_282f!= argdecls_2807.end(), itoldval_2836!= oldvals_2809.end(), itcontext_283d!= contexts_280b.end(), itinitexpr_2844!= initexprs_280d.end(); ++ittrigger_2828, ++itargdecl_282f, ++itoldval_2836, ++itcontext_283d, ++itinitexpr_2844)
	{
		bool isUnique= isInputUnique( *ittrigger_2828, *itargdecl_282f, *itoldval_2836, *itcontext_283d, *itinitexpr_2844);
		if( !isUnique)
			continue;
		Packets_t onetrigger_282c( 1, *ittrigger_2828);
		Packets_t oneargdecl_2833( 1, *itargdecl_282f);
		Packets_t oneoldval_283a( 1, *itoldval_2836);
		Packets_t onecontext_2841( 1, *itcontext_283d);
		Packets_t oneinitexpr_2848( 1, *itinitexpr_2844);
		executeOne( onetrigger_282c, oneargdecl_2833, oneoldval_283a, onecontext_2841, oneinitexpr_2848);
	}
}

void EdgeTest_2804::executeOne( const Packets_t& triggers_2805, const Packets_t& argdecls_2807, const Packets_t& oldvals_2809, const Packets_t& contexts_280b, const Packets_t& initexprs_280d)
{
	Packets_t argDeclBases_284f;
	Packets_t localVars_2852;
	Packets_t contexts_2855;
	Packets_t unaryExprss_2858;
	RisingEdge_284a risingEdge_284a;
	bool isMatchRisingEdge_284a= risingEdge_284a( triggers_2805, argdecls_2807, oldvals_2809, contexts_280b, initexprs_280d, argDeclBases_284f, localVars_2852, contexts_2855, unaryExprss_2858);
	_argdecl_281b->insert( _argdecl_281b->end(), argDeclBases_284f.begin(), argDeclBases_284f.end());
	_oldval_281c->insert( _oldval_281c->end(), localVars_2852.begin(), localVars_2852.end());
	_context_281d->insert( _context_281d->end(), contexts_2855.begin(), contexts_2855.end());
	_initexpr_281e->insert( _initexpr_281e->end(), unaryExprss_2858.begin(), unaryExprss_2858.end());
	if( isMatchRisingEdge_284a)
		return;
	Packets_t argDeclBases_28a5;
	Packets_t localVars_28a8;
	Packets_t contexts_28ab;
	Packets_t unaryExprss_28ae;
	FallingEdge_28a0 fallingEdge_28a0;
	bool isMatchFallingEdge_28a0= fallingEdge_28a0( triggers_2805, argdecls_2807, oldvals_2809, contexts_280b, initexprs_280d, argDeclBases_28a5, localVars_28a8, contexts_28ab, unaryExprss_28ae);
	_argdecl_281f->insert( _argdecl_281f->end(), argDeclBases_28a5.begin(), argDeclBases_28a5.end());
	_oldval_2820->insert( _oldval_2820->end(), localVars_28a8.begin(), localVars_28a8.end());
	_context_2821->insert( _context_2821->end(), contexts_28ab.begin(), contexts_28ab.end());
	_initexpr_2822->insert( _initexpr_2822->end(), unaryExprss_28ae.begin(), unaryExprss_28ae.end());
	Packets_t argDeclBases_28fb;
	Packets_t localVars_28fe;
	Packets_t contexts_2901;
	Packets_t unaryExprss_2904;
	EitherEdge_28f6 eitherEdge_28f6;
	bool isMatchEitherEdge_28f6= eitherEdge_28f6( triggers_2805, argdecls_2807, oldvals_2809, contexts_280b, initexprs_280d, argDeclBases_28fb, localVars_28fe, contexts_2901, unaryExprss_2904);
	_argdecl_2823->insert( _argdecl_2823->end(), argDeclBases_28fb.begin(), argDeclBases_28fb.end());
	_oldval_2824->insert( _oldval_2824->end(), localVars_28fe.begin(), localVars_28fe.end());
	_context_2825->insert( _context_2825->end(), contexts_2901.begin(), contexts_2901.end());
	_initexpr_2826->insert( _initexpr_2826->end(), unaryExprss_2904.begin(), unaryExprss_2904.end());
}

bool EdgeTest_2804::isInputUnique( const Udm::Object& trigger_2829, const Udm::Object& argdecl_2830, const Udm::Object& oldval_2837, const Udm::Object& context_283e, const Udm::Object& initexpr_2845)
{
	bool isUnique= true;
	for( Packets_t::const_iterator ittrigger_282b= _trigger_2827.begin(), itargdecl_2832= _argdecl_282e.begin(), itoldval_2839= _oldval_2835.begin(), itcontext_2840= _context_283c.begin(), itinitexpr_2847= _initexpr_2843.begin(); ittrigger_282b!= _trigger_2827.end(), itargdecl_2832!= _argdecl_282e.end(), itoldval_2839!= _oldval_2835.end(), itcontext_2840!= _context_283c.end(), itinitexpr_2847!= _initexpr_2843.end(); ++ittrigger_282b, ++itargdecl_2832, ++itoldval_2839, ++itcontext_2840, ++itinitexpr_2847)
	{
		if( ( *ittrigger_282b== trigger_2829)&& ( *itargdecl_2832== argdecl_2830)&& ( *itoldval_2839== oldval_2837)&& ( *itcontext_2840== context_283e)&& ( *itinitexpr_2847== initexpr_2845))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_trigger_2827.push_back( trigger_2829);
		_argdecl_282e.push_back( argdecl_2830);
		_oldval_2835.push_back( oldval_2837);
		_context_283c.push_back( context_283e);
		_initexpr_2843.push_back( initexpr_2845);
	}
	return isUnique;
}

bool RisingEdge_284a::operator()( const Packets_t& triggerPorts_284b, const Packets_t& argDeclBases_284d, const Packets_t& localVars_2850, const Packets_t& contexts_2853, const Packets_t& unaryExprss_2856, Packets_t& argDeclBases_284f, Packets_t& localVars_2852, Packets_t& contexts_2855, Packets_t& unaryExprss_2858)
{
#ifdef PRINT_INFO
	printLog("RisingEdge_284a" );
#endif
	_argDeclBase_2859= &argDeclBases_284f;
	_localVar_285a= &localVars_2852;
	_context_285b= &contexts_2855;
	_unaryExprs_285c= &unaryExprss_2858;
	processInputPackets( triggerPorts_284b, argDeclBases_284d, localVars_2850, contexts_2853, unaryExprss_2856);
	if( false== _matches.empty())
		return true;
	return false;
}

bool RisingEdge_284a::isInputUnique( const Udm::Object& triggerPort_2861, const Udm::Object& argDeclBase_286a, const Udm::Object& localVar_2873, const Udm::Object& context_287c, const Udm::Object& unaryExprs_2885)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itTriggerPort_2863= _triggerPort_285d.begin(), itArgDeclBase_286c= _argDeclBase_2866.begin(), itLocalVar_2875= _localVar_286f.begin(), itContext_287e= _context_2878.begin(), itUnaryExprs_2887= _unaryExprs_2881.begin(); itTriggerPort_2863!= _triggerPort_285d.end(), itArgDeclBase_286c!= _argDeclBase_2866.end(), itLocalVar_2875!= _localVar_286f.end(), itContext_287e!= _context_2878.end(), itUnaryExprs_2887!= _unaryExprs_2881.end(); ++itTriggerPort_2863, ++itArgDeclBase_286c, ++itLocalVar_2875, ++itContext_287e, ++itUnaryExprs_2887)
	{
		if( ( *itTriggerPort_2863== triggerPort_2861)&& ( *itArgDeclBase_286c== argDeclBase_286a)&& ( *itLocalVar_2875== localVar_2873)&& ( *itContext_287e== context_287c)&& ( *itUnaryExprs_2887== unaryExprs_2885))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_triggerPort_285d.push_back( triggerPort_2861);
		_argDeclBase_2866.push_back( argDeclBase_286a);
		_localVar_286f.push_back( localVar_2873);
		_context_2878.push_back( context_287c);
		_unaryExprs_2881.push_back( unaryExprs_2885);
	}
	return isUnique;
}

bool RisingEdge_284a::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool RisingEdge_284a::isGuardTrue( SFC::ArgDeclBase& ArgDeclBase, SFC::Arg& Context, SFC::LocalVar& LocalVar, CyPhyML::SignalFlow::TriggerPort& TriggerPort, SFC::UnaryExprs& UnaryExprs)
{
	bool Gz_guard= false;
	std::string trigger = TriggerPort.TriggerType();
Gz_guard = trigger == "rising";;
	return Gz_guard;
}

void RisingEdge_284a::processInputPackets( const Packets_t& triggerPorts_284b, const Packets_t& argDeclBases_284d, const Packets_t& localVars_2850, const Packets_t& contexts_2853, const Packets_t& unaryExprss_2856)
{
	for( Packets_t::const_iterator itTriggerPort_285e= triggerPorts_284b.begin(), itArgDeclBase_2867= argDeclBases_284d.begin(), itLocalVar_2870= localVars_2850.begin(), itContext_2879= contexts_2853.begin(), itUnaryExprs_2882= unaryExprss_2856.begin(); itTriggerPort_285e!= triggerPorts_284b.end(), itArgDeclBase_2867!= argDeclBases_284d.end(), itLocalVar_2870!= localVars_2850.end(), itContext_2879!= contexts_2853.end(), itUnaryExprs_2882!= unaryExprss_2856.end(); ++itTriggerPort_285e, ++itArgDeclBase_2867, ++itLocalVar_2870, ++itContext_2879, ++itUnaryExprs_2882)
	{
		bool isUnique= isInputUnique( *itTriggerPort_285e, *itArgDeclBase_2867, *itLocalVar_2870, *itContext_2879, *itUnaryExprs_2882);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itTriggerPort_285e, *itArgDeclBase_2867, *itLocalVar_2870, *itContext_2879, *itUnaryExprs_2882);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.argDeclBase_288f, currMatch.localVar_2890, currMatch.context_2891, currMatch.unaryExprs_2892);
	}
}

bool RisingEdge_284a::patternMatcher( const Udm::Object& triggerPort_285f, const Udm::Object& argDeclBase_2868, const Udm::Object& localVar_2871, const Udm::Object& context_287a, const Udm::Object& unaryExprs_2883)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( triggerPort_285f.type(), CyPhyML::SignalFlow::TriggerPort::meta))
			continue;
		CyPhyML::SignalFlow::TriggerPort triggerPort_2864= CyPhyML::SignalFlow::TriggerPort::Cast( triggerPort_285f);
		if( false== Uml::IsDerivedFrom( argDeclBase_2868.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_286d= SFC::ArgDeclBase::Cast( argDeclBase_2868);
		if( false== Uml::IsDerivedFrom( localVar_2871.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_2876= SFC::LocalVar::Cast( localVar_2871);
		if( false== Uml::IsDerivedFrom( context_287a.type(), SFC::Arg::meta))
			continue;
		SFC::Arg context_287f= SFC::Arg::Cast( context_287a);
		if( false== Uml::IsDerivedFrom( unaryExprs_2883.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_2888= SFC::UnaryExprs::Cast( unaryExprs_2883);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_288d;
		if( !isValidBound(boundObjs_288d, triggerPort_2864, true))
			continue;
		currMatch.triggerPort_288e= triggerPort_2864;
		if( !isValidBound(boundObjs_288d, argDeclBase_286d, true))
			continue;
		currMatch.argDeclBase_288f= argDeclBase_286d;
		if( !isValidBound(boundObjs_288d, localVar_2876, true))
			continue;
		currMatch.localVar_2890= localVar_2876;
		if( !isValidBound(boundObjs_288d, context_287f, true))
			continue;
		currMatch.context_2891= context_287f;
		if( !isValidBound(boundObjs_288d, unaryExprs_2888, true))
			continue;
		currMatch.unaryExprs_2892= unaryExprs_2888;
		bool Gz_guard= isGuardTrue( currMatch.argDeclBase_288f, currMatch.context_2891, currMatch.localVar_2890, currMatch.triggerPort_288e, currMatch.unaryExprs_2892);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void RisingEdge_284a::outputAppender( const SFC::ArgDeclBase& argDeclBase_2898, const SFC::LocalVar& localVar_289a, const SFC::Arg& context_289c, const SFC::UnaryExprs& unaryExprs_289e)
{
	_argDeclBase_2859->push_back( argDeclBase_2898);
	_localVar_285a->push_back( localVar_289a);
	_context_285b->push_back( context_289c);
	_unaryExprs_285c->push_back( unaryExprs_289e);
}

bool FallingEdge_28a0::operator()( const Packets_t& triggerPorts_28a1, const Packets_t& argDeclBases_28a3, const Packets_t& localVars_28a6, const Packets_t& contexts_28a9, const Packets_t& unaryExprss_28ac, Packets_t& argDeclBases_28a5, Packets_t& localVars_28a8, Packets_t& contexts_28ab, Packets_t& unaryExprss_28ae)
{
#ifdef PRINT_INFO
	printLog("FallingEdge_28a0" );
#endif
	_argDeclBase_28af= &argDeclBases_28a5;
	_localVar_28b0= &localVars_28a8;
	_context_28b1= &contexts_28ab;
	_unaryExprs_28b2= &unaryExprss_28ae;
	processInputPackets( triggerPorts_28a1, argDeclBases_28a3, localVars_28a6, contexts_28a9, unaryExprss_28ac);
	if( false== _matches.empty())
		return true;
	return false;
}

bool FallingEdge_28a0::isInputUnique( const Udm::Object& triggerPort_28b7, const Udm::Object& argDeclBase_28c0, const Udm::Object& localVar_28c9, const Udm::Object& context_28d2, const Udm::Object& unaryExprs_28db)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itTriggerPort_28b9= _triggerPort_28b3.begin(), itArgDeclBase_28c2= _argDeclBase_28bc.begin(), itLocalVar_28cb= _localVar_28c5.begin(), itContext_28d4= _context_28ce.begin(), itUnaryExprs_28dd= _unaryExprs_28d7.begin(); itTriggerPort_28b9!= _triggerPort_28b3.end(), itArgDeclBase_28c2!= _argDeclBase_28bc.end(), itLocalVar_28cb!= _localVar_28c5.end(), itContext_28d4!= _context_28ce.end(), itUnaryExprs_28dd!= _unaryExprs_28d7.end(); ++itTriggerPort_28b9, ++itArgDeclBase_28c2, ++itLocalVar_28cb, ++itContext_28d4, ++itUnaryExprs_28dd)
	{
		if( ( *itTriggerPort_28b9== triggerPort_28b7)&& ( *itArgDeclBase_28c2== argDeclBase_28c0)&& ( *itLocalVar_28cb== localVar_28c9)&& ( *itContext_28d4== context_28d2)&& ( *itUnaryExprs_28dd== unaryExprs_28db))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_triggerPort_28b3.push_back( triggerPort_28b7);
		_argDeclBase_28bc.push_back( argDeclBase_28c0);
		_localVar_28c5.push_back( localVar_28c9);
		_context_28ce.push_back( context_28d2);
		_unaryExprs_28d7.push_back( unaryExprs_28db);
	}
	return isUnique;
}

bool FallingEdge_28a0::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool FallingEdge_28a0::isGuardTrue( SFC::ArgDeclBase& ArgDeclBase, SFC::Arg& Context, SFC::LocalVar& LocalVar, CyPhyML::SignalFlow::TriggerPort& TriggerPort, SFC::UnaryExprs& UnaryExprs)
{
	bool Gz_guard= false;
	std::string trigger = TriggerPort.TriggerType();
Gz_guard = trigger == "falling";;
	return Gz_guard;
}

void FallingEdge_28a0::processInputPackets( const Packets_t& triggerPorts_28a1, const Packets_t& argDeclBases_28a3, const Packets_t& localVars_28a6, const Packets_t& contexts_28a9, const Packets_t& unaryExprss_28ac)
{
	for( Packets_t::const_iterator itTriggerPort_28b4= triggerPorts_28a1.begin(), itArgDeclBase_28bd= argDeclBases_28a3.begin(), itLocalVar_28c6= localVars_28a6.begin(), itContext_28cf= contexts_28a9.begin(), itUnaryExprs_28d8= unaryExprss_28ac.begin(); itTriggerPort_28b4!= triggerPorts_28a1.end(), itArgDeclBase_28bd!= argDeclBases_28a3.end(), itLocalVar_28c6!= localVars_28a6.end(), itContext_28cf!= contexts_28a9.end(), itUnaryExprs_28d8!= unaryExprss_28ac.end(); ++itTriggerPort_28b4, ++itArgDeclBase_28bd, ++itLocalVar_28c6, ++itContext_28cf, ++itUnaryExprs_28d8)
	{
		bool isUnique= isInputUnique( *itTriggerPort_28b4, *itArgDeclBase_28bd, *itLocalVar_28c6, *itContext_28cf, *itUnaryExprs_28d8);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itTriggerPort_28b4, *itArgDeclBase_28bd, *itLocalVar_28c6, *itContext_28cf, *itUnaryExprs_28d8);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.argDeclBase_28e5, currMatch.localVar_28e6, currMatch.context_28e7, currMatch.unaryExprs_28e8);
	}
}

bool FallingEdge_28a0::patternMatcher( const Udm::Object& triggerPort_28b5, const Udm::Object& argDeclBase_28be, const Udm::Object& localVar_28c7, const Udm::Object& context_28d0, const Udm::Object& unaryExprs_28d9)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( triggerPort_28b5.type(), CyPhyML::SignalFlow::TriggerPort::meta))
			continue;
		CyPhyML::SignalFlow::TriggerPort triggerPort_28ba= CyPhyML::SignalFlow::TriggerPort::Cast( triggerPort_28b5);
		if( false== Uml::IsDerivedFrom( argDeclBase_28be.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_28c3= SFC::ArgDeclBase::Cast( argDeclBase_28be);
		if( false== Uml::IsDerivedFrom( localVar_28c7.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_28cc= SFC::LocalVar::Cast( localVar_28c7);
		if( false== Uml::IsDerivedFrom( context_28d0.type(), SFC::Arg::meta))
			continue;
		SFC::Arg context_28d5= SFC::Arg::Cast( context_28d0);
		if( false== Uml::IsDerivedFrom( unaryExprs_28d9.type(), SFC::UnaryExprs::meta))
			continue;
		SFC::UnaryExprs unaryExprs_28de= SFC::UnaryExprs::Cast( unaryExprs_28d9);
		Match currMatch;
		set< pair<int, Udm::Object> > boundObjs_28e3;
		if( !isValidBound(boundObjs_28e3, triggerPort_28ba, true))
			continue;
		currMatch.triggerPort_28e4= triggerPort_28ba;
		if( !isValidBound(boundObjs_28e3, argDeclBase_28c3, true))
			continue;
		currMatch.argDeclBase_28e5= argDeclBase_28c3;
		if( !isValidBound(boundObjs_28e3, localVar_28cc, true))
			continue;
		currMatch.localVar_28e6= localVar_28cc;
		if( !isValidBound(boundObjs_28e3, context_28d5, true))
			continue;
		currMatch.context_28e7= context_28d5;
		if( !isValidBound(boundObjs_28e3, unaryExprs_28de, true))
			continue;
		currMatch.unaryExprs_28e8= unaryExprs_28de;
		bool Gz_guard= isGuardTrue( currMatch.argDeclBase_28e5, currMatch.context_28e7, currMatch.localVar_28e6, currMatch.triggerPort_28e4, currMatch.unaryExprs_28e8);
		if( true== Gz_guard)
			_matches.push_back( currMatch);
	}
	return !_matches.empty();
}

void FallingEdge_28a0::outputAppender( const SFC::ArgDeclBase& argDeclBase_28ee, const SFC::LocalVar& localVar_28f0, const SFC::Arg& context_28f2, const SFC::UnaryExprs& unaryExprs_28f4)
{
	_argDeclBase_28af->push_back( argDeclBase_28ee);
	_localVar_28b0->push_back( localVar_28f0);
	_context_28b1->push_back( context_28f2);
	_unaryExprs_28b2->push_back( unaryExprs_28f4);
}

bool EitherEdge_28f6::operator()( const Packets_t& triggerPorts_28f7, const Packets_t& argDeclBases_28f9, const Packets_t& localVars_28fc, const Packets_t& contexts_28ff, const Packets_t& unaryExprss_2902, Packets_t& argDeclBases_28fb, Packets_t& localVars_28fe, Packets_t& contexts_2901, Packets_t& unaryExprss_2904)
{
#ifdef PRINT_INFO
	printLog("EitherEdge_28f6" );
#endif
	_argDeclBase_2905= &argDeclBases_28fb;
	_localVar_2906= &localVars_28fe;
	_context_2907= &contexts_2901;
	_unaryExprs_2908= &unaryExprss_2904;
	processInputPackets( triggerPorts_28f7, argDeclBases_28f9, localVars_28fc, contexts_28ff, unaryExprss_2902);
	if( false== _matches.empty())
		return true;
	return false;
}

bool EitherEdge_28f6::isInputUnique( const Udm::Object& triggerPort_290d, const Udm::Object& argDeclBase_2916, const Udm::Object& localVar_291f, const Udm::Object& context_2928, const Udm::Object& unaryExprs_2931)
{
	bool isUnique= true;
	for( Packets_t::const_iterator itTriggerPort_290f= _triggerPort_2909.begin(), itArgDeclBase_2918= _argDeclBase_2912.begin(), itLocalVar_2921= _localVar_291b.begin(), itContext_292a= _context_2924.begin(), itUnaryExprs_2933= _unaryExprs_292d.begin(); itTriggerPort_290f!= _triggerPort_2909.end(), itArgDeclBase_2918!= _argDeclBase_2912.end(), itLocalVar_2921!= _localVar_291b.end(), itContext_292a!= _context_2924.end(), itUnaryExprs_2933!= _unaryExprs_292d.end(); ++itTriggerPort_290f, ++itArgDeclBase_2918, ++itLocalVar_2921, ++itContext_292a, ++itUnaryExprs_2933)
	{
		if( ( *itTriggerPort_290f== triggerPort_290d)&& ( *itArgDeclBase_2918== argDeclBase_2916)&& ( *itLocalVar_2921== localVar_291f)&& ( *itContext_292a== context_2928)&& ( *itUnaryExprs_2933== unaryExprs_2931))
		{
			isUnique= false;
			break;
		}
	}
	if( isUnique)
	{
		_triggerPort_2909.push_back( triggerPort_290d);
		_argDeclBase_2912.push_back( argDeclBase_2916);
		_localVar_291b.push_back( localVar_291f);
		_context_2924.push_back( context_2928);
		_unaryExprs_292d.push_back( unaryExprs_2931);
	}
	return isUnique;
}

bool EitherEdge_28f6::isValidBound( set< pair<int, Udm::Object> >& boundObjs, Udm::Object& currObj, bool isInputObj)
{
	if( boundObjs.find(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj)) != boundObjs.end())
		if( !isInputObj)
			return false;
		else
			return true;
	else
		boundObjs.insert(make_pair(currObj.__impl()->__getdn()->uniqueId(), currObj));
	return true;
}

bool EitherEdge_28f6::isGuardTrue( SFC::ArgDeclBase& ArgDeclBase, SFC::Arg& Context, SFC::LocalVar& LocalVar, CyPhyML::SignalFlow::TriggerPort& TriggerPort, SFC::UnaryExprs& UnaryExprs)
{
	bool Gz_guard= false;
	std::string trigger = TriggerPort.TriggerType();
Gz_guard = trigger == "either";;
	return Gz_guard;
}

void EitherEdge_28f6::processInputPackets( const Packets_t& triggerPorts_28f7, const Packets_t& argDeclBases_28f9, const Packets_t& localVars_28fc, const Packets_t& contexts_28ff, const Packets_t& unaryExprss_2902)
{
	for( Packets_t::const_iterator itTriggerPort_290a= triggerPorts_28f7.begin(), itArgDeclBase_2913= argDeclBases_28f9.begin(), itLocalVar_291c= localVars_28fc.begin(), itContext_2925= contexts_28ff.begin(), itUnaryExprs_292e= unaryExprss_2902.begin(); itTriggerPort_290a!= triggerPorts_28f7.end(), itArgDeclBase_2913!= argDeclBases_28f9.end(), itLocalVar_291c!= localVars_28fc.end(), itContext_2925!= contexts_28ff.end(), itUnaryExprs_292e!= unaryExprss_2902.end(); ++itTriggerPort_290a, ++itArgDeclBase_2913, ++itLocalVar_291c, ++itContext_2925, ++itUnaryExprs_292e)
	{
		bool isUnique= isInputUnique( *itTriggerPort_290a, *itArgDeclBase_2913, *itLocalVar_291c, *itContext_2925, *itUnaryExprs_292e);
		if( !isUnique)
			continue;
		bool isMatch= patternMatcher( *itTriggerPort_290a, *itArgDeclBase_2913, *itLocalVar_291c, *itContext_2925, *itUnaryExprs_292e);
	}
	for( std::list< Match>::const_iterator itMatch= _matches.begin(); itMatch!= _matches.end(); ++itMatch)
	{
		Match currMatch= *itMatch;
		outputAppender( currMatch.argDeclBase_293b, currMatch.localVar_293c, currMatch.context_293d, currMatch.unaryExprs_293e);
	}
}

bool EitherEdge_28f6::patternMatcher( const Udm::Object& triggerPort_290b, const Udm::Object& argDeclBase_2914, const Udm::Object& localVar_291d, const Udm::Object& context_2926, const Udm::Object& unaryExprs_292f)
{
	for( int i= 0; i< 1; ++i)
	{
		if( false== Uml::IsDerivedFrom( triggerPort_290b.type(), CyPhyML::SignalFlow::TriggerPort::meta))
			continue;
		CyPhyML::SignalFlow::TriggerPort triggerPort_2910= CyPhyML::SignalFlow::TriggerPort::Cast( triggerPort_290b);
		if( false== Uml::IsDerivedFrom( argDeclBase_2914.type(), SFC::ArgDeclBase::meta))
			continue;
		SFC::ArgDeclBase argDeclBase_2919= SFC::ArgDeclBase::Cast( argDeclBase_2914);
		if( false== Uml::IsDerivedFrom( localVar_291d.type(), SFC::LocalVar::meta))
			continue;
		SFC::LocalVar localVar_2922= SFC::LocalVar::Cast( localVar_291d);
		if( false== Uml::IsDerivedFrom( context_292