/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef __MOCODEGEN_H__
#define __MOCODEGEN_H__

#include "CyPhyML.h"

class MoCodeGen
{
public:
	MoCodeGen(CyPhyML::Component &cyphyComponent, const std::string &outputDirectory, const std::string logFile);
//	MoCodeGen(CyPhyML::TestBench &testbench, const std::string &outputDirectory);
	void gen();
	void setPackageName(const std::string &pkg);
private:
	void genWrapper_source();
	void genWrapper_proj();
	void genModelica();
//	void genModelica_busPort();
	void genPackageMo();
	std::string generateGUID();
	std::string convertMoType(const std::string &slType);
	std::string getDataVarFullPath(const CyPhyML::SF_DataParameterBase &obj);
	std::string getParaVarFullPath(const CyPhyML::SignalFlow::SF_Parameter &param);
	CyPhyML::BusPort getBusPort(const CyPhyML::SignalFlowBusPortInterface &busportInterface);

	CyPhyML::Component _com;
	std::string _comName;
	std::string _directory;
	std::string _wrapperName;
	std::string _topSubSystemName;
	std::string _contextName;
	std::string _pkgName;
	std::string _logFileName;
	
	list<CyPhyML::SignalFlow::Subsystem> _topSubSystems;

	list<CyPhyML::SignalFlow::InputPort> _inputs;
	list<CyPhyML::SignalFlow::OutputPort> _outputs;
	map<CyPhyML::SignalFlow::InputPort, CyPhyML::SignalFlow::TypeBaseRef> _inputMap;
	map<CyPhyML::SignalFlow::OutputPort, CyPhyML::SignalFlow::TypeBaseRef>  _outputMap;
	map<CyPhyML::SignalFlowBusPortInterface, CyPhyML::BusPort> _busportMap;
	map<CyPhyML::SF_ParameterRef, std::string > _parameterRefMap;
	map<CyPhyML::SF_DataRef, std::string> _sfdataRefMap;

	set<std::string> _hfiles;
	set<std::string> _cfiles;
	std::string _mainArgs;

	struct InputPortSorter {
		bool operator()( const CyPhyML::SignalFlow::InputPort &port1, const CyPhyML::SignalFlow::InputPort &port2 ) const {
				return static_cast< int >(port1.Number() ) < static_cast< int >( port2.Number() );
			}
		};

	struct OutputPortSorter {
		bool operator()( const CyPhyML::SignalFlow::OutputPort &port1, const CyPhyML::SignalFlow::OutputPort &port2 ) const {
				return static_cast< int >(port1.Number() ) < static_cast< int >( port2.Number() );
			}
		};
};

#endif