/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// UdmApp.h: interface for the CUdmApp class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_UDMAPP_H__296A93EB_6DB6_4179_AA0B_A3D799FB3A1C__INCLUDED_)
#define AFX_UDMAPP_H__296A93EB_6DB6_4179_AA0B_A3D799FB3A1C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// Udm includes
#include "UdmBase.h"
#include "Uml.h"
#include "UmlExt.h"

#include "CyPhyML.h"

#ifdef _USE_DOM
	#include "UdmDOM.h"
#endif

#include "UdmGme.h"
#include "UdmStatic.h"

#include "CGProgressDialog.h"

class CUdmApp  
{

public:
	int Initialize()
	{
		mgaPath = "";
		currPath = "";
		logFile = "";
		outputDir = "";
		master = false;
		badNameObjs.clear();
		checkedSFs.clear();
		return 0;
	}
	void UdmMain(Udm::DataNetwork* p_backend, Udm::Object currentObject, std::set<Udm::Object> selectedObjects, long param);
	CString mgaPath;
	std::string outputDir;
	bool master;

private:
	std::string currPath;
	std::string logFile;

	list<Udm::Object> badNameObjs;
	set<CyPhyML::SignalFlowModel> checkedSFs;
	set<CyPhyML::SignalFlow::SFState> checkedSFStates;

	void processComponent(CyPhyML::Component &com,  bool genmo, std::string comname="");
	std::string createWrapperFolder(const std::string &foldername);
	void removeWrapperFolder(const std::string &foldername);
	void processComponentAssembly(const CyPhyML::ComponentAssembly &ca, bool genmo, std::string ca_prefix="");
	void processTestBench(const CyPhyML::TestBench &tb);
	void checkBadNames(const CyPhyML::SignalFlow::Block &block);
	void checkSFState(CyPhyML::SignalFlow::SFState &sfstate);
	void updateInputPort(CyPhyML::SignalFlow::SFData &sfdata);
	void updateOutputPort(CyPhyML::SignalFlow::SFData &sfdata);
	void checkComponent(CyPhyML::Component &com);
	//void checkPortNumber(const CyPhyML::SignalFlow::Subsystem &subsys);
	void checkPortNumber(const CyPhyML::SignalFlow::Block &block);
};

#endif // !defined(AFX_UDMAPP_H__296A93EB_6DB6_4179_AA0B_A3D799FB3A1C__INCLUDED_)
