/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#pragma once

#include <string>
#include <afxwin.h>
#include "UdmBase.h"

namespace GMEConsole
{
	const COLORREF CLOUDBLUE = RGB(128, 184, 223);
	const COLORREF WHITE = RGB(255, 255, 255);
	const COLORREF BLACK = RGB(1, 1, 1);
	const COLORREF DARKGRAY = RGB(128, 128, 128);
	const COLORREF LIGHTGRAY = RGB(210, 210, 210);
	const COLORREF GREEN = RGB(185, 245, 148);
	const COLORREF RED = RGB(186, 12, 72);


	class Formatter
	{
	public:
		static std::string MakeBold(const std::string & text){return std::string("<b>") + text +"</b>";}
		static std::string MakeItalic(const std::string & text){return std::string("<i>") + text +"</i>";}
		static std::string MakeUnderline(const std::string & text){return std::string("<u>") + text +"</u>";}
		static std::string MakeHyperlink(const std::string & text, const std::string& url){return std::string("<a href=\"") + url + "\">" + text +"</a>";}
		static std::string MakeObjectHyperlink(const std::string & text, const Udm::Object& object);
		static std::string MakeColored(const std::string & text, COLORREF color);

	};
}
/*
"<A HREF=\"mga:" + id +"\">" + nm + "</A>";
*/
