/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef RUNSL_CODEGEN
#define RUNSL_CODEGEN

#include "CyPhyML.h"

void __declspec(dllimport) runCyPhySF_CodeGen_dllimported(const CyPhyML::SignalFlowModel &sfmodel, std::string cyphy_file, Uml::Diagram &cyphy_meta_diagram, std::string logFlile, std::string directory="");
bool __declspec(dllexport) runCyPhySL_CodeGen_dllimported(const CyPhyML::SignalFlowModel &sfmodel, std::string cyphy_file, Uml::Diagram cyphy_meta_diagram, std::string directory="");
bool runCyPhySL_CodeGen(const CyPhyML::SignalFlowModel &sfmodel, std::string cyphy_file, Udm::DataNetwork* sdn_cyphy, std::string directory="");
//void runCyPhySL_CodeGen(const CyPhyML::SignalFlowModel &sfmodel, Udm::DataNetwork* sdn_cyphy, std::string directory="");
void logGeneratedFiles(std::string workDir);

class ComponentCodeGen
{
public:
	ComponentCodeGen(CyPhyML::Component &cyphyComponent, const std::string &outputDirectory, const std::string &comname);
	void runCodeGen(const std::string &logFile);
	set<std::string> getGenerated_H_Files();
	set<std::string> getGenerated_C_Files();
private:
	CyPhyML::Component _com;
	std::string _comname;
	std::string _directory;
	set<std::string> _cfiles;
	set<std::string> _hfiles;
//	set<std::string> _topSubSystems;
	bool errorReported;

public:
	bool getError( void ) {
		return errorReported;
	}
	void setError( void ) {
		errorReported = true;
	}
};

#endif