#
# This is an example of a 'driver file' for the PARC_QRM_Toolkit
#

import sys, os, traceback
import PARC_QRM_Toolkit

# tell the module where to find the executables.  Note that omc will only
# operate properly if it can find OPENMODELICAHOME.

os.environ['OPENMODELICAHOME'] = "C:/OpenModelica/1.8.1"
PARC_QRM_Toolkit.OMC = "C:/OpenModelica/1.8.1/bin/omc"
PARC_QRM_Toolkit.QRM = "C:/QRM/bin/QRM.exe"

try:
    model_directory = os.path.join(os.getcwd(), "MassSpringDamperTest")
    xml_file = PARC_QRM_Toolkit.generate_xml(
        "MassSpringDamperTest.MassSpringDamperTest",
        [os.path.join(model_directory, "package.mo")],
        "3.2")
except:
    sys.stderr.write("Can't generate XML:\n%s\n" % traceback.format_exc())
    # more complicated error handling can be added here, if desired
else:
    try:
        json_file = PARC_QRM_Toolkit.do_envisionment(xml_file)
    except:
        sys.stderr.write("Can't generate envisionment!  Error is:\n%s\n" % traceback.format_exc())
        # more complicated error handling can be added here, if desired
    else:
        os.unlink(xml_file)

        # what to do with the json file?  Right now, generate a report, and
        # write that report to stdout
        sys.stdout.write(PARC_QRM_Toolkit.analyze_envisionment(json_file))
        os.unlink(json_file)
